package com.ibm.ie.reeng.rt.client;


import com.ibm.ie.reeng.rt.common.TemporalFunctions;

/**
 * This class provides a set of convenience functions that are called
 * by the C functions that support the JNI interface to user components.
 * <P>
 * These functions enable the C functions to convert to and from the
 * Java representations of the temporal types DATE, TIME and TIMESTAMP
 * and that required by the user components.
 */
public class TemporalHandler
{
    public static int getComponentDate(java.sql.Date jDate)
    {
        return TemporalFunctions.newToOldDate(jDate);
    }


    public static java.sql.Date getJavaDate(int cDate)
    {
        return TemporalFunctions.oldToNewDate(cDate);
    }


    public static int getComponentTime(java.sql.Time jTime)
    {
        return TemporalFunctions.newToOldTime(jTime);
    }


    public static java.sql.Time getJavaTime(int cTime)
    {
        return TemporalFunctions.oldToNewTime(cTime);
    }


    public static int[] getComponentTimestamp(java.sql.Timestamp jTimestamp)
    {
        int[] cTimestamp = new int[3];

        cTimestamp[0] = TemporalFunctions.newToOldDate(
            TemporalFunctions.date(jTimestamp));
        cTimestamp[1] = TemporalFunctions.newToOldTime(
            TemporalFunctions.time(jTimestamp));
        cTimestamp[2] = TemporalFunctions.fraction(jTimestamp);

        return cTimestamp;
    }


    public static java.sql.Timestamp getJavaTimestamp(
        int cDate, int cTime, int cFraction)
    {
        return TemporalFunctions.timestamp(
            TemporalFunctions.oldToNewDate(cDate),
            TemporalFunctions.oldToNewTime(cTime), cFraction);
    }
}
