package com.ibm.ie.reeng.rt.client;


/**
 * This class is used by {@link TransmuteTable} instances to get and
 * retrieve "linked" data. For a general discussion of this topic see
 * {@link ClientData} and {@link DataHandler}.
 */
public class TableDataHandler extends DataHandler
{
    private TransmuteTable tableComponent;


    public TableDataHandler(TransmuteTable tableComponent)
    {
        super(tableComponent);

        this.tableComponent = tableComponent;
    }

    public void displayData()
    {
        TransmuteTableModel model =
            (TransmuteTableModel)tableComponent.getModel();

        model.fireTableDataChanged();
    }


    public int storeData()
    {
        TransmuteTableModel model =
            (TransmuteTableModel)tableComponent.getModel();

        return model.storeData();
    }
}
