package com.ibm.ie.reeng.rt.client;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

/**
 * This class is used by {@link TransmuteRadioButton} instances to get and
 * retrieve "linked" data. For a general discussion of this topic see
 * {@link ClientData} and {@link DataHandler}.
 */
public class RadioButtonDataHandler extends DataHandler implements ItemListener
{
    private TransmuteRadioButton radioButton;
    private boolean internalStateChange = false;


    public RadioButtonDataHandler(TransmuteRadioButton radioButton)
    {
        super(radioButton);

        this.radioButton = radioButton;

        radioButton.addItemListener(this);
    }


    /**
     * Only the radio button that is selected needs to worry about its
     * state changing, the radio button that becomes unselected can just
     * ignore its state change.
     */
    public void itemStateChanged(ItemEvent event)
    {
        if (internalStateChange) return;

        if (event.getStateChange() == ItemEvent.SELECTED) stateChanged();
    }


    /**
     * If the datalink is empty then the first radio button
     * with that datalink sets it to its identifier.
     */
    public void displayData()
    {
        if (clientData == null) return;

        String data = clientData.get().toString();

        if (data.trim().equals(""))
        {
            clientData.set(radioButton.getIdentifier());

            getDialog().updateSharedDatalinks(this);
        }
        else
        {
            boolean selected
                = data.equalsIgnoreCase(radioButton.getIdentifier());

            internalStateChange = true;
            radioButton.setSelected(selected);
            internalStateChange = false;
        }
    }


    public int storeData()
    {
        if (clientData != null)
        {
            if (radioButton.isSelected())
                clientData.set(radioButton.getIdentifier());
        }

        return VALID;
    }
}
