package com.ibm.ie.reeng.rt.client;

import java.awt.GridLayout;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Toolkit;

import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.DefaultListModel;
import javax.swing.ListSelectionModel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;

import javax.swing.event.ListSelectionListener;
import javax.swing.event.ListSelectionEvent;

import java.io.*;
import java.util.*;
import java.util.jar.*;

import com.ibm.ie.reeng.rt.common.Config;
import com.ibm.ie.reeng.rt.common.PropertyConfigSource;


public class PanelDemo extends JFrame implements ListSelectionListener
{
    private String packageName = "window";

    private TransmuteDialog dialog;
    private JList list;

    private static boolean exitToSystem=false;

    private String sep=null;

    private ArrayList fullNameList=new ArrayList();

    private class AppThread extends Thread
    {
        public String name=null;
        
        public void run()
        {
/*            
            if (dialog != null)
            {
                dialog.actionPerformed(new ActionEvent(
                    new TransmuteButton(""),
                    ActionEvent.ACTION_PERFORMED, ""));
                dialog.dispose();
            }
*/            
            dialog = createDialog(name);
            try
            {
                dialog.converse();
            }
            catch (Exception e)
            {
System.out.println("Caught exception "+e);        
            }
            dialog.dispose();
            dialog=null;
        }
    }

    private AppThread appThread=null;

    public void valueChanged(ListSelectionEvent event)
    {
        if (event.getValueIsAdjusting() != false) return;
        if (list.getSelectedIndex() == -1) return;


//        final String name = packageName + "."
//            + list.getSelectedValue().toString();

//        final String name=list.getSelectedValue().toString();
        final String name=(String)fullNameList.get(list.getSelectedIndex());

        // The following is still not safe, but it'll do for a demo
//        if (dialog !=null && appThread!=null && appThread.isAlive())
        if (appThread!=null && appThread.isAlive())
        {
            appThread.interrupt();
//            dialog.dispatchImmediateReturnEvent("Blah");
            /*
            dialog.actionPerformed(new ActionEvent(
                        new TransmuteButton(""), 
                        ActionEvent.ACTION_PERFORMED, ""));
            */
            
            try
            {
                appThread.join();
            }
            catch (InterruptedException e)
            {
                e.printStackTrace();
            }

            appThread=null;
        }

//        if (appThread==null)
            appThread=new AppThread();

        appThread.name=name;

        appThread.start();
/*        
        new Thread()
        {
            public void run()
            {
                if (dialog != null)
                {
                    dialog.actionPerformed(new ActionEvent(
                        new TransmuteButton(""),
                        ActionEvent.ACTION_PERFORMED, ""));
                    dialog.dispose();
                }
                dialog = createDialog(name);
                dialog.converse();
                dialog.dispose();
            }
        }.start();
*/
    }

    private static TransmuteDialog createDialog(String name)
    {
        try
        {
            return (TransmuteDialog)Class.forName(name).newInstance();
        }
        catch (Exception e)
        {
            fatalException(e);
            return null;    // keep the compiler happy.
        }
    }

    private static void fatalException(Exception e)
    {
        System.out.println("EXCEPTION: " + e);
        System.exit(-1);
    }

    private static void fatalError(String s)
    {
        System.out.println("ERROR: " + s);
        System.exit(-1);
    }

    private static void information(String s)
    {
        System.out.println(s);
    }

    private static boolean isTransmuteDialogInstance(String name)
    {
        try
        {
            Object o = Class.forName(name).newInstance();
            
            if (o instanceof TransmuteDialog) return true;

            information(name + " is not an instance of TransmuteDialog");
        }
        catch (ExceptionInInitializerError e)
        {
            information("Error initializing class "
                + name + ": " + e.getException());
        }
        catch (LinkageError e)
        {
            information("Linkage error loading " + name);
        }
        catch (ClassNotFoundException e)
        {
            information("Cannot load class " + name);
        }
        catch (Exception e)
        {
            information("Unexpected error loading class " + name);
            e.printStackTrace();
        }
        return false;
    }

    private void addDialogClasses(DefaultListModel model, ArrayList classNames)
    {
        for (int i = 0; i < classNames.size(); i++)
        {
            String name = (String)classNames.get(i);

            if (name.endsWith(".class") && name.indexOf('$') < 0)
            {
                name = name.substring(0, name.lastIndexOf('.'));
                name=name.replace(File.separatorChar, '.');
                name=name.replace('/', '.');

//                String fullName = packageName.replace('/', File.separatorChar) + "." + name;
               
//                if (isTransmuteDialogInstance(fullName))
                if (isTransmuteDialogInstance(name))
                {
                    information("found dialog " + name);
                    fullNameList.add(name);
                    
                    int lastDotIndex=name.lastIndexOf('.');
                    if (lastDotIndex!=-1)
                        name=name.substring(lastDotIndex+1);


                    model.addElement(name);
                }
            }
        }
    }

    public PanelDemo(String packageName)
        throws IOException
    {
        this(packageName, null);
    }

    public PanelDemo(String windowClassNames[], String fullNames[])
    {
        initMainWindow();
        
        DefaultListModel model = new DefaultListModel();

        for (int i=0; i<windowClassNames.length; i++)
        {
            fullNameList.add(fullNames[i]);
            
            model.addElement(windowClassNames[i]);
        }   

        run(model);
    }

    public PanelDemo(String packageName, String path)
        throws IOException
    {

	    this.packageName = packageName;

        initMainWindow();

        DefaultListModel model = new DefaultListModel();

        if (path==null)
            path=System.getProperty("java.class.path");

        StringTokenizer toks = new StringTokenizer(
                path,
                System.getProperty("path.separator"));

        ArrayList classNames=new ArrayList();
        
        while (toks.hasMoreTokens())
        {
            String token=toks.nextToken();
            if (isJar(token))
            {
                JarFile jarFile=new JarFile(new File(token));
                Enumeration enum=jarFile.entries();
                while (enum.hasMoreElements())
                {
                    JarEntry entry=(JarEntry)enum.nextElement();
                    if (!entry.isDirectory() && isClassInPackage(packageName, entry.getName()))
                        classNames.add(entry.getName());
                }
            }
            else
            {
                File dir = new File(token);

                if (dir.isDirectory())
                {
                    ArrayList list=getRecursiveFileList(dir);
                    for (int i=0; i<list.size(); i++)
                    {
                        String temp=((String)list.get(i)).substring(dir.getPath().length());
                        if (temp.length()>0 && temp.charAt(0)==File.separatorChar)
                            temp=temp.substring(1);
                        if (isClassInPackage(packageName, temp))
                            classNames.add(temp);
                    }
                //    addDialogClasses(model, dir);
                }
            }
        }

        addDialogClasses(model, classNames);

        run(model);
    }

    private void initMainWindow()
    {
        getContentPane().setLayout(new GridLayout(0, 1));

        addWindowListener(new WindowAdapter()
        {
            public void windowClosing(WindowEvent e) 
                { 
                    if (dialog!=null)
                        dialog.dispose();
                    if (exitToSystem)
                        System.exit(0); 
                }
        });
    }

    private void run(DefaultListModel model)
    {
        if (model.size() == 0)
        {
            information("No TransmuteDialog subclasses"
                + " found in package \"" + packageName + "\".");
            fatalError("Please ensure the windows are compiled.");
        }

        list = new JList(model);
        list.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        list.addListSelectionListener(this);

        JScrollPane scrollPane = new JScrollPane(list);

        getContentPane().add(scrollPane);

        // Now work out what height the scroll pane really should be...

        Dimension d = scrollPane.getPreferredSize();
        Insets insets = scrollPane.getBorder().getBorderInsets(scrollPane);

        int width = d.width;
        int height = list.getPreferredSize().height +
            insets.top + insets.bottom;

        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int maxHeight = (screen.height * 8) / 10;

        if (height > maxHeight) height = maxHeight;

        scrollPane.setPreferredSize(new Dimension(width, height));

        pack();

        //1.2KL int x = (screen.width - getWidth()) / 2;
        int x = (screen.width - getSize().width) / 2;
        //1.2KL int y = (screen.height - getHeight()) / 2;
        int y = (screen.height - getSize().height) / 2;

        setLocation(x, y);
        setVisible(true);
    }

    public void stop()
    {
        setVisible(false);
    }
    
    private static void usage()
    {
        System.out.println("Usage: java transmute.runtime.PanelDemo"
            + " [<package name>]");
        System.out.println("  the package name is \"window\""
            + " if unspecified");
        System.exit(0);
    }

	
    public static void main(String[] args)
    {
        String packageName = "window";
		
		Config.setSource(new PropertyConfigSource());
	
		if (args.length > 1 || 
				(args.length == 1 && args[0].startsWith("-h")))
        {
            usage();
        }
        else if (args.length == 1) packageName = args[0];

        exitToSystem=true;

        try
        {
            /*
            String lookAndFeel=Config.instance().getString("lookAndFeel");

            if (lookAndFeel!=null)
            {
                System.out.println("Attempting to override default look and feel..");
                UIManager.setLookAndFeel(lookAndFeel);
            }
            else
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());


            System.out.println("Using look and feel "+UIManager.getLookAndFeel());
            */
            new PanelDemo(packageName);
        }
        catch (Exception e)
        {
            fatalException(e);
        }
    }

    ArrayList getRecursiveFileList(File directory)
        throws IOException
    {
        ArrayList list=new ArrayList();
        
        return getRecursiveFileList(directory, list);
    }

    ArrayList getRecursiveFileList(File directory, ArrayList arrayList)
        throws IOException
    {
        File files[]=directory.listFiles();

        for (int i=0; i<files.length; i++)
        {
            if (files[i].isDirectory())
                getRecursiveFileList(files[i], arrayList);
            else
                arrayList.add(files[i].getPath());
        }

        return arrayList;
    }

    boolean isJar(String jarFileName)
    {
        return jarFileName.toLowerCase().endsWith(".jar");
    }

    boolean isClassInPackage(String packageName, String className)
    {
        String normalPackageName=packageName.replace('/', '.');
        normalPackageName=normalPackageName.replace(File.separatorChar, '.');

        String normalClassName=className.replace('/', '.');
        normalClassName=normalClassName.replace(File.separatorChar, '.');

        return normalClassName.startsWith(normalPackageName);
    }
}
