package com.ibm.ie.reeng.rt.client;

import com.ibm.ie.reeng.rt.common.Log;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.text.Keymap;


/**
 * This class allows the user to interactively supply a user name and
 * password. It is used by {@link transmute.runtime.Database} and by
 * various middleware classes to authenticate the user.
 * <P>
 * It is synchronous (the calling thread is blocked until the user
 * responds) so it shouldn't be used from the AWT event dispatch thread.
 */
public class LogonDialog extends JFrame implements ActionListener
{
    private String userName;
    private String password;
    private boolean okIsPressed;
    
    private JTextField userNameField;
    private JPasswordField passwordField;
    private JButton accept;

    /**
     * Window constructor.
     */
    public LogonDialog(String title, String userName, String password)
    {
        userName = userName == null ? "" : userName;
        password = password == null ? "" : password;

        this.userName = userName;
        this.password = password;    
   
        // set up the window.
        setTitle(title);
//        setResizable(false);
        Dimension wndSize = getToolkit().getScreenSize();    
        setLocation(wndSize.width / 2 - 110, wndSize.height / 2 - 70);
        setSize(220, 160);
        addWindowListener(new WindowAdapter()
        {
            public void windowClosing(WindowEvent e) { releaseWait(); }
            public void windowActivated(WindowEvent e)
            {
                // A hack to workaround the fact that requestFocus() is
                // broken in Swing and awt.
                javax.swing.SwingUtilities.invokeLater(new Runnable()
                {
                    public void run()
                    {
                        if (userNameField.getText().equals(""))
                            userNameField.requestFocus();
                        else if (passwordField.getPassword().equals(""))
                            passwordField.requestFocus();
                    }
                });
            } 
        });


        // username field
        userNameField = new JTextField(15);
        userNameField.getKeymap().removeKeyStrokeBinding(
            KeyStroke.getKeyStroke(KeyEvent.VK_ENTER, 0));
        userNameField.setText(userName);

        // password field
        passwordField = new JPasswordField(15);
        userNameField.setFont(passwordField.getFont());
        passwordField.getKeymap().removeKeyStrokeBinding(
            KeyStroke.getKeyStroke(KeyEvent.VK_ENTER, 0));
        passwordField.setText(password);

        // Button set-up
        accept = new JButton("OK");
        getRootPane().setDefaultButton(accept);
        accept.addActionListener(this);
        accept.setMnemonic('O');
        JPanel flow = new JPanel();
        flow.add(accept);
        getContentPane().add(flow, BorderLayout.SOUTH);

        // Entry panel set-up
        JPanel namePanel = new JPanel();
        namePanel.setLayout(new FlowLayout(FlowLayout.RIGHT));
        namePanel.add(new JLabel("User Name: ", JLabel.LEFT));
        namePanel.add(userNameField);

        JPanel passwordPanel = new JPanel();
        passwordPanel.setLayout(new FlowLayout(FlowLayout.RIGHT));
        passwordPanel.add(new JLabel("Password:  ", JLabel.LEFT));
        passwordPanel.add(passwordField);

        JPanel upperPanel = new JPanel();
        upperPanel.setLayout(new FlowLayout(FlowLayout.CENTER));
        upperPanel.setBorder(new EmptyBorder(5, 5, 5, 15));
        upperPanel.add(namePanel);
        upperPanel.add(passwordPanel);
        getContentPane().add(upperPanel, BorderLayout.CENTER);

        show();
        waitForOk();
    }

    void waitForOk()
    {
        okIsPressed = false;
        while(okIsPressed != true)
        {
            try { synchronized (this) { wait(); } }        
            catch(InterruptedException e)
            {
                Log.fatalException(e);
            }
            catch(IllegalMonitorStateException e)
            {
                Log.fatalException(e);
            }
        }
    }
 
    void releaseWait()
    {
        okIsPressed = true;
        synchronized (this)
        {
            notifyAll();
        }
        dispose();
    }



    // Passes the information to the outside world
 
    public String getUserName() { return userName; }

    public String getPassword() { return password; }

    /**
     * Actions performed as a result of clicking on a button.
     */
    public void actionPerformed(ActionEvent ae)
    {
        if (!userNameField.getText().equals(""))
        {
            userName = userNameField.getText(); 
            password = new String(passwordField.getPassword());

            releaseWait();
        }
        else
        {
            JOptionPane.showMessageDialog(accept,
                "A user name must be entered with a password",
                "Warning Message", JOptionPane.WARNING_MESSAGE);
        }
    }

    static
    {
        try
        {
            UIManager.setLookAndFeel(
                UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e)
        {
        }
    }
}
