package com.ibm.ie.reeng.rt.client;


import com.ibm.ie.reeng.rt.common.TemporalFunctions;

/**
 * Note: -1 is used by HPS to represent an invalid date, if a text field
 * is linked to a date data item it should turn itself red if the date
 * data item contains -1. This behavior is not currently supported.
 */
public class DateData extends ClientData
{
    public String objectToString(Object object)
    {
        java.sql.Date date = (java.sql.Date)object;
        if (TemporalFunctions.newToOldDate(date) == 0) return "";
        else return TemporalFunctions.toString(date);
    }

    public Object stringToObject(String string)
    {
        java.sql.Date date;

        string = string.trim();
        // Hps allows you to enter "-" into a date field to represent
        // the current date.
        if (string.equals("-"))
            date = TemporalFunctions.date();
        else
            date = TemporalFunctions.date(string);

        if (TemporalFunctions.isInvalidDate(date)) return null;
        else return date;
    }
}
