package com.ibm.ie.reeng.rt.client;

import com.ibm.ie.reeng.rt.common.Log;

import com.ibm.ie.reeng.rt.common.set.WindowObjectAttributes;
import com.ibm.ie.reeng.rt.common.set.WindowObjectColors;

import java.awt.Color;
import java.util.HashMap;


/**
 * This class is used by the
 * {@link transmute.runtime.system.component.SetControlColorById} and 
 * {@link transmute.runtime.system.component.SetFieldColor} system
 * components.
 * <p>
 * It provides a mapping from  Hps colors into
 * {@link java.awt.Color java.awt.Color}s (see {@link #getColor}).
 * <p>
 * Note that there are limitations in the mapping to Hps color control
 * (see {@link #setColor setColor}).
 */
public class ColorManager
{
    private ColorManager() { }

    /**
     * Notes: Swing has a border concept but there is no generic way to
     * set the color of a border, so HPS BORDER is treated as
     * background. Similarly HPS TEXT is treated foreground.
     *
     * @param action    an element of {@link WindowObjectAttributes}
     */
    public static void setColor(TransmuteDialog dialog,
        java.awt.Component component, int action, Color color)
    {
        switch (action)
        {
        case WindowObjectAttributes.TEXT:
            component.setForeground(color);
            break;

        case WindowObjectAttributes.RESETTEXT:
            dialog.resetForeground(component);
            break;

        case WindowObjectAttributes.BORDER:
            Log.warning("ColorManager", "treating BORDER as BACKGROUND");
        case WindowObjectAttributes.BACKGROUND:
            component.setBackground(color);
            break;

        case WindowObjectAttributes.RESETBORDER:
            Log.warning("ColorManager", "treating BORDER as BACKGROUND");
        case WindowObjectAttributes.RESETBACKGROUND:
            dialog.resetBackground(component);
            break;

        default:
            Log.error("ColorManager", "unknown action " + action);
        }
    }


    // ------------------------------------------------------------------------


    /**
     * Gets the {@link java.awt.Color java.awt.Color} corresponding to
     * elements of {@link WindowObjectColors}.
     */
    public static Color getColor(int i)
    {
        return (Color)colorMap.get(new Integer(i));
    }

    private static HashMap colorMap;


    private static void put(int i, Color color)
    {
        colorMap.put(new Integer(i), color);
    }



    static
    {
        // Those colors not explicitly enumerated in Color have been
        // created using values derived from X11 rgb.txt

        colorMap = new HashMap();
        put(WindowObjectColors.WHITE,  Color.white);
        put(WindowObjectColors.YELLOW, Color.yellow);
        put(WindowObjectColors.BLUE,   Color.blue);
        put(WindowObjectColors.RED,    Color.red);
        put(WindowObjectColors.PURPLE, new Color(160, 32, 240));
        put(WindowObjectColors.ORANGE, Color.orange);
        put(WindowObjectColors.GREEN,  Color.green);
        put(WindowObjectColors.MAROON, new Color(176, 48, 96));
        put(WindowObjectColors.BLACK,  Color.black);
        put(WindowObjectColors.AQUA,   new Color(127, 255, 212));
    }
}
