       IDENTIFICATION DIVISION.
       PROGRAM-ID. "isqlexample".
       ENVIRONMENT DIVISION.
       DATA DIVISION.

       WORKING-STORAGE SECTION.

       COPY "lisqlall.cpy".

       01 connect-info.
          05 ds-name     pic x(50).
          05 username    pic x(50).
          05 password    pic x(50).
          05 table-name  pic x(50).

       01 three-columns.
          05  col-one      pic x(30).
          05  col-two      pic x(30).
          05  col-three    pic x(30).
                                                                   
       PROCEDURE DIVISION.
       A.

           initialize connect-info.
           initialize three-columns.

           display "Enter Name of Datasource: " erase.
           accept ds-name line 0 col 0.
           display "Enter Datasource username: ".
           accept username line 0 col 0.
           display "Enter Datasource password: ". 
           accept password line 0 col 0.
           display "Enter a table name from Datasource: ".
           accept table-name line 0 col 0.

           if username = spaces
              move "BLANK" to username.
           

           SQL CONNECT DATASOURCE 
               sql-ConnectionHandle
               ds-name
               username
               password.
           
           IF NOT sql-OK
              display "UNSUCCESFUL CONNECT!!!"
              PERFORM WITH TEST AFTER UNTIL sql-EndOfData
                SQL DESCRIBE ERROR
                    sql-Error-Description
                IF NOT sql-EndOfData
                  PERFORM DISPLAY-ERROR-INFO
                END-IF
              END-PERFORM
              GO TO Z
           END-IF

           SQL CONSTRUCT QUERY
           sql-QrySQL,
           sql-DirSetDS  sql-ConnectionHandle,
           "select * from",
           sql-DirQtID, table-name.

           IF NOT sql-OK
              display "UNSUCCESFUL CONSTRUCT!!!"
              PERFORM WITH TEST AFTER UNTIL sql-EndOfData
                SQL DESCRIBE ERROR
                    sql-Error-Description
                IF NOT sql-EndOfData
                  PERFORM DISPLAY-ERROR-INFO
                END-IF
              END-PERFORM
              GO TO Z
           END-IF

           SQL PREPARE QUERY sql-QueryHandle,
               sql-ConnectionHandle,
               sql-QrySQL.

           IF NOT sql-OK
              display "UNSUCCESFUL PREPARE!!!"
              PERFORM WITH TEST AFTER UNTIL sql-EndOfData
                SQL DESCRIBE ERROR
                    sql-Error-Description
                IF NOT sql-EndOfData
                  PERFORM DISPLAY-ERROR-INFO
                END-IF
              END-PERFORM
              GO TO Z
           END-IF

           SQL START QUERY sql-QueryHandle.
           IF NOT sql-OK
              display "UNSUCCESFUL START!!!"
              PERFORM WITH TEST AFTER UNTIL sql-EndOfData
                SQL DESCRIBE ERROR
                    sql-Error-Description
                IF NOT sql-EndOfData
                  PERFORM DISPLAY-ERROR-INFO
                END-IF
              END-PERFORM
              GO TO Z
           END-IF

           SQL BIND COLUMN sql-QueryHandle,
               1, col-one, OMITTED,
               2, col-two, OMITTED,
               3, col-three, OMITTED.

           IF NOT sql-OK
              display "UNSUCCESFUL BIND!!!"
              PERFORM WITH TEST AFTER UNTIL sql-EndOfData
                SQL DESCRIBE ERROR
                    sql-Error-Description
                IF NOT sql-EndOfData
                  PERFORM DISPLAY-ERROR-INFO
                END-IF
              END-PERFORM
              GO TO Z
           END-IF

           PERFORM WITH TEST AFTER UNTIL NOT sql-OK
              SQL FETCH ROW sql-QueryHandle
              IF sql-OK
                 display col-one col-two col-three 
              ELSE
                 DISPLAY "<End of data.>"
                 GO TO Z
              END-IF             
          END-PERFORM.
      *END Query

       Z.
           SQL END QUERY sql-QueryHandle.

      *DISCONNECT from data source.
           SQL DISCONNECT DATASOURCE 
                      sql-ConnectionHandle.
      *TERMINATE InstantSQL.
           SQL SHUTDOWN.

           STOP SPACES.

           STOP RUN.

       DISPLAY-ERROR-INFO.
           DISPLAY "Err Msg " sql-ErrMsg
           DISPLAY "Err Typ"  sql-ErrType
           DISPLAY  "Err statement " sql-ErrStatement
           DISPLAY  "ErrsqlSate " sql-ErrSqlState
           DISPLAY "err no "  sql-ErrNo.

       END PROGRAM "isqlexample".
       

