       IDENTIFICATION DIVISION.
       PROGRAM-ID. TPSIOREC.
      ******************************************************************
      *!!!!!!!! REPLACE THIS PROGRAM WITH 'TPSIOREC' AFTER !!!!!!!!!!! *
      *!!!!!!!! SPLITTING THE RECEIVE FILE.                !!!!!!!!!!! *
      *     THIS PROGRAM PERFORMS I/O TO THE LATEST RECEIVE FILE       *
      ******************************************************************
      * 02/25/19 CHANGE OLD DATE TO 20190101. THE OLD FILE(RECVOLD4)   *
      *          CONTAINS RECORDS  20160101 - 20181231               AC*
      * 05/24/16 FIX READ PREVIOUS WHEN IT HAS TO GO TO OLD FILE.    JM*
      * 05/17/16 CHANGE OLD DATE TO 20160101. THE OLD FILE NOW         *
      *    JM    CONTAINS RECORDS TO 20151231.                         *
      * 02/12/12 CHANGE OLD DATE TO 20110101. THE OLD FILE NOW         *
      *    JM    CONTAINS RECORDS TO 20101231.                         *
      * 09/21/10 CHANGE OLD DATE TO 20070101. THE OLD FILE NOW         *
      *    JM    CONTAINS RECORDS TO 20061231.                         *
      * 11/06/06 CHANGE OLD DATE TO 20040101. THE OLD FILE NOW         *
      *    JM    CONTAINS RECORDS TO 20031231.                         *
      * 08/28/06 USE FILE-NAME FIELD WHEN CALLING TPSIORCV (OLD FILE)  *
      *    JM    'END' MEANS NEAR END OF OLD FILE, 'NEW' MEANS CHANGE  *
      *          THE DATE AND READ THE NEW FILE.                       *
      * 03/27/03 start high was checking receive date for '99999' (5   *        
      *    ts    nines), should have been receive NUMBER..........     *
      * 03/17/03 i think that jim made this change at read to ignore   *        
      *    ts    lock on record/file............     i think......     *
      * 07/23/01 CHANGE PROGRAM TO DO I/O TO ALL RECORDS CREATED AFTER *
      *    JM    12/31/1999. EARLIER RECORDS WILL USE TPSIORCV.        *
      * 11/24/99 AT START-HIGH IF RECEIVE NUMBER = 99999, USE KEY FROM *
      *    TS    CALLING PROGRAM INSTEAD OF HIGH-VALUES............    *
      * 11/17/95 MOVE 'Y' TO OPEN FLAG IN OPEN I-O                  JM *
      * 11/17/95 Restore "ignore lock" statement from 10/25/95      JC *
      * 11/10/95 ADD START-LOW (GET RECORD < KEY).                  JM *
      * 10/25/95 "Ignore Lock" when doing a READ NEXT.              JC *
      ******************************************************************
       ENVIRONMENT DIVISION.
       CONFIGURATION SECTION.
       SOURCE-COMPUTER. IBM-PC.
       OBJECT-COMPUTER. IBM-PC.
       SPECIAL-NAMES.
       INPUT-OUTPUT SECTION.
       FILE-CONTROL.
           SELECT RECEIVE-FILE ASSIGN TO DYNAMIC  FILESPEC
               ORGANIZATION IS INDEXED
               LOCK MODE IS AUTOMATIC
               ACCESS MODE IS DYNAMIC
               RECORD KEY IS MAIL-KEY OF FS
               FILE STATUS IS FILE-STATUS-LOCAL.
       DATA DIVISION.
       FILE SECTION.
       FD  RECEIVE-FILE
               LABEL RECORDS STANDARD.
       01  FS.
           COPY "TPSMAIL.CPY".

       WORKING-STORAGE SECTION.

       01  FILESPEC                    PIC X(27) VALUE 
           '\tps\prod\files\receive.dat'.
       01  TPSIOERR                    PIC X(08) VALUE 'TPSIOERR'.
       01  TPSIORCV                    PIC X(08) VALUE 'TPSIORCV'.
       01  TPSIORC2                    PIC X(08) VALUE 'TPSIORC2'.
       01  TPSIORC3                    PIC X(08) VALUE 'TPSIORC3'.
       01  TPSIORC4                    PIC X(08) VALUE 'TPSIORC4'.
       01  FILE-STATUS-LOCAL           PIC XX VALUE ZERO.
       01  OPENED-FLAG                 PIC X.
       01  OLD-DATE                    PIC 9(08) VALUE 20190101.
       01  END-DATE                    PIC 9(08) VALUE 20181220.
       01  END-KEY.
           05 END-ACCT-NO              PIC 9(10).
           05 END-SUB-ACCT             PIC 9(02).

       01  GENERIC-KEY.
           05 GENERIC-KEY-BYTE OCCURS 50 INDEXED BY BKDEX                       
                                              
                               PIC X.

       01  GENERIC-TEST.
           05 GENERIC-TEST-BYTE OCCURS 50 INDEXED BY GTDEX                      
                                              
                               PIC X.

      *
      *%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
       LINKAGE SECTION.
      *
               COPY TPSFILES.CPY.
       01 LS.
               COPY "TPSMAIL.CPY".
      *%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
       PROCEDURE DIVISION USING FILE-REQUEST LS.
      *%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
      *
       0001-STARTUP.
      *                         :---------------------------------------
      * ------------------------: Load the keys, initialize variables.
      *                         :---------------------------------------
      *
      ******READ THE VALUE OF ENVIRONMENT NAME "TPSRECEIVEFILE"
           IF FILESPEC = SPACES
            DISPLAY "TPSRECEIVEFILE" UPON ENVIRONMENT-NAME
            ACCEPT FILESPEC FROM ENVIRONMENT-VALUE.
           MOVE '00' TO FILE-STATUS-LOCAL FILE-STATUS.
      *
      *                         :---------------------------------------
      * ------------------------: Perform the requested operation.
      *                         :---------------------------------------
      *
           IF FR-START-LOW
              GO TO 0016-FR-START-LOW.
      *
           GO TO
               0003-FR-OPEN-INPUT
               0004-FR-OPEN-I-O
               0005-FR-CLOSE
               0006-FR-WRITE
               0007-FR-REWRITE
               0008-FR-DELETE
               0009-FR-START
               0009-FR-START
               0010-FR-START-HIGH
               0010-FR-START-HIGH
               0011-FR-READ
               0012-FR-READ-NEXT
               0013-FR-READ-PREVIOUS
               DEPENDING
               ON FILE-ACTION.
      * -====-
       0002-FR-CREATE.
      *                         :---------------------------------------
      * ------------------------: Create the file by open output.
      *                         : the first attempt you get return '05'
      *                         :---------------------------------------
      *
           IF FR-CREATE
             OPEN OUTPUT RECEIVE-FILE.
      *
           GO TO 0017-RETURN.
      * -====-
       0003-FR-OPEN-INPUT.
      *                         :---------------------------------------
      * ------------------------: Open the file INPUT.
      *                         :---------------------------------------
      *
      *JM07/01 ***** OPEN INPUT OLD & NEW RECEIVE FILES *****
           IF OPENED-FLAG NOT = 'Y'
             OPEN INPUT RECEIVE-FILE
             IF FILE-STATUS-LOCAL NOT = '00' AND '05'
                GO TO 0017-RETURN
             ELSE
                CALL TPSIORC4 USING FILE-REQUEST LS
                CALL TPSIORC3 USING FILE-REQUEST LS
                CALL TPSIORC2 USING FILE-REQUEST LS
                CALL TPSIORCV USING FILE-REQUEST LS
                MOVE 'Y' TO OPENED-FLAG.
      *
           GO TO 0017-RETURN.
      * -====-
       0004-FR-OPEN-I-O.
      *                         :---------------------------------------
      * ------------------------: Open the file I/O and get highest key.
      *                         :---------------------------------------
      *
      *JM07/01 ***** OPEN I-O BOTH OLD & NEW RECEIVE FILE *****
           IF OPENED-FLAG NOT = 'Y'
             OPEN I-O RECEIVE-FILE
             IF FILE-STATUS-LOCAL NOT = '00' AND '05'
                GO TO 0017-RETURN
             ELSE
                CALL TPSIORC4 USING FILE-REQUEST LS
                CALL TPSIORC3 USING FILE-REQUEST LS
                CALL TPSIORC2 USING FILE-REQUEST LS
                CALL TPSIORCV USING FILE-REQUEST LS
                MOVE 'Y' TO OPENED-FLAG.
      *
           GO TO 0017-RETURN.
      * -====-
       0005-FR-CLOSE.
      *                         :---------------------------------------
      * ------------------------: Close the file.
      *                         :---------------------------------------
      *
      *JM07/01 ***** CLOSE BOTH OLD & NEW RECEIVE FILE *****
           IF OPENED-FLAG = 'Y'
             CLOSE RECEIVE-FILE
             CALL TPSIORC4 USING FILE-REQUEST LS
             CALL TPSIORC3 USING FILE-REQUEST LS
             CALL TPSIORC2 USING FILE-REQUEST LS
             CALL TPSIORCV USING FILE-REQUEST LS
             MOVE 'N' TO OPENED-FLAG.
      *
           GO TO 0017-RETURN.
      * -====-
       0006-FR-WRITE.
      *                         :---------------------------------------
      * ------------------------: Write a new record.
      *                         :---------------------------------------
      *
      *JM07/01 ***** IF OLD RECORD USE THE OLD RECEIVE FILE *****
           IF MAIL-RECEIVE-DATE OF LS < OLD-DATE
              CALL TPSIORC4 USING FILE-REQUEST LS
              GO TO 0018-RETURN.
      *
           WRITE FS FROM LS.
      *
           GO TO 0017-RETURN.
      * -====-
       0007-FR-REWRITE.
      *                         :---------------------------------------
      * ------------------------: Rewrite the record.
      *                         :---------------------------------------
      *
      *JM07/01 ***** IF OLD RECORD USE THE OLD RECEIVE FILE *****
           IF MAIL-RECEIVE-DATE OF LS < OLD-DATE
              CALL TPSIORC4 USING FILE-REQUEST LS
              GO TO 0018-RETURN.
      *
           REWRITE FS FROM LS.
      *
           GO TO 0017-RETURN.
      * -====-
       0008-FR-DELETE.
      *                         :---------------------------------------
      * ------------------------: Delete the record.
      *                         :---------------------------------------
      *
      *JM07/01 ***** IF OLD RECORD USE THE OLD RECEIVE FILE *****
           IF MAIL-RECEIVE-DATE OF LS < OLD-DATE
              CALL TPSIORC4 USING FILE-REQUEST LS
              GO TO 0018-RETURN.
      *
           DELETE RECEIVE-FILE RECORD.
      *
           GO TO 0017-RETURN.
      * -====-
       0009-FR-START.
      *                         :---------------------------------------
      * ------------------------: Start with record = or > key.
      *                         :---------------------------------------
      *
      *JM07/01 ***** IF OLD RECORD USE THE OLD RECEIVE FILE *****
           IF MAIL-RECEIVE-DATE OF LS < OLD-DATE
              CALL TPSIORC4 USING FILE-REQUEST LS
              GO TO 0018-RETURN.
      *
           MOVE MAIL-KEY OF LS TO MAIL-KEY OF FS.
           START RECEIVE-FILE KEY NOT LESS THAN MAIL-KEY OF FS.
      *
           GO TO 0017-RETURN.
      * -====-
       0010-FR-START-HIGH.
      *                         :---------------------------------------
      * ------------------------: Start with record = or > key.
      *                         : this is not correct but it has been
      *                         : this way since the beginning.
      *                         :---------------------------------------
      *
      *JM07/01 ***** IF OLD RECORD USE THE OLD RECEIVE FILE *****
           IF MAIL-RECEIVE-DATE OF LS < OLD-DATE
              CALL TPSIORC4 USING FILE-REQUEST LS
              GO TO 0018-RETURN.
      *
      *09/13 MOVE MAIL-KEY OF LS TO MAIL-KEY OF FS
      *09/13 START RECEIVE-FILE KEY IS NOT < MAIL-KEY OF FS
      *
      *03/27/03                                                                 
                                                
      *03/27  MAIL-RECEIVE-DATE OF LS = '99999'  
           if mail-receive-number of ls = '99999'                               
              MOVE MAIL-KEY OF LS TO MAIL-KEY OF FS                             
              MOVE MAIL-KEY OF FS TO GENERIC-KEY                                
              START RECEIVE-FILE KEY IS LESS THAN                               
                                     OR EQUAL TO MAIL-KEY OF FS                 
              INVALID KEY                                                       
                CONTINUE                                                        
           ELSE
              MOVE MAIL-KEY OF FS TO GENERIC-KEY                                
              MOVE HIGH-VALUE     TO MAIL-KEY OF FS                             
              START RECEIVE-FILE KEY EQUAL MAIL-KEY OF FS                       
              INVALID KEY                                                       
                CONTINUE                                                        
            END-IF.                                                             
                                              
                                              
           GO TO 0017-RETURN.
      * -====-
       0011-FR-READ.
      *                         :---------------------------------------
      * ------------------------: Read the record directly on prime key.
      *                         : The prime key never allows duplicates.
      *                         :---------------------------------------
      *
      *JM07/01 ***** IF OLD RECORD USE THE OLD RECEIVE FILE *****
           IF MAIL-RECEIVE-DATE OF LS < OLD-DATE
              CALL TPSIORC4 USING FILE-REQUEST LS
              GO TO 0018-RETURN.
      *
           MOVE MAIL-KEY OF LS TO MAIL-KEY OF FS.
           READ RECEIVE-FILE INTO LS
      *03/17/03                                                                 
                                                
           IGNORE LOCK.                                                         
                                                
      *
           GO TO 0017-RETURN.
      * -====-
       0012-FR-READ-NEXT.
      *                         :---------------------------------------
      * ------------------------: Browse (read sequential) the file.
      *                         :---------------------------------------
      *
      *JM07/01 ***** IF OLD RECORD USE THE OLD RECEIVE FILE *****
      *08/28/06***** SET UP RECORD TO JUMP FROM OLD TO NEW FILE******
           IF MAIL-RECEIVE-DATE OF LS < OLD-DATE
              IF MAIL-RECEIVE-DATE OF LS > END-DATE                             
                 MOVE 'END4'       TO FILE-NAME
              END-IF                                                            
             CALL TPSIORC4 USING FILE-REQUEST LS
              IF FILE-NAME = 'NEW5'
                 MOVE MAIL-KEY OF LS TO MAIL-KEY OF FS
                 START RECEIVE-FILE KEY NOT LESS THAN MAIL-KEY OF FS
                 MOVE SPACES TO FILE-NAME
                 NEXT SENTENCE
              END-IF                                                            
             GO TO 0018-RETURN.                                                 
      *
           READ RECEIVE-FILE
           NEXT RECORD INTO LS
           IGNORE LOCK.
      *
           GO TO 0017-RETURN.
      * -====-
       0013-FR-READ-PREVIOUS.
      *                         :---------------------------------------
      * ------------------------: Browse a file backwards.
      *                         :---------------------------------------
      *JM07/01 ***** IF OLD RECORD USE THE OLD RECEIVE FILE *****
           IF MAIL-RECEIVE-DATE OF LS < OLD-DATE
             IF FILE-NAME = 'NEW4'
                MOVE SPACES TO FILE-NAME
             END-IF
             CALL TPSIORC4 USING FILE-REQUEST LS
             GO TO 0017-RETURN.
      *
      *05/24/16 **** SAVE RECORD TO GO TO OLD RECEIVE FILE *****
              MOVE MAIL-ACCT-NO OF LS   TO END-ACCT-NO.
              MOVE MAIL-SUB-ACCT OF LS  TO END-SUB-ACCT.

           READ RECEIVE-FILE
               PREVIOUS RECORD INTO LS.

      *05/24/16 CONTINUE READ PREVIOUS ON OLD FILE
           IF MAIL-ACCT-NO OF LS NOT = END-ACCT-NO OR
              MAIL-SUB-ACCT OF LS NOT = END-SUB-ACCT
                  MOVE 'NEW4'           TO FILE-NAME
                  MOVE HIGH-VALUES      TO MAIL-KEY OF LS
                  MOVE END-ACCT-NO      TO MAIL-ACCT-NO OF LS
                  MOVE END-SUB-ACCT     TO MAIL-SUB-ACCT OF LS
               CALL TPSIORC4 USING FILE-REQUEST LS
           END-IF.


           GO TO 0017-RETURN.
      * -====-
       0016-FR-START-LOW.
      *
      *JM07/01 ***** IF OLD RECORD USE THE OLD RECEIVE FILE *****
           IF MAIL-RECEIVE-DATE OF LS < OLD-DATE
              CALL TPSIORC4 USING FILE-REQUEST LS
              GO TO 0018-RETURN.
      *
           IF FR-PRIME
             MOVE MAIL-KEY OF LS TO MAIL-KEY OF FS
             START RECEIVE-FILE KEY LESS THAN MAIL-KEY OF FS
      *          INVALID KEY
      *        CONTINUE.
      *
           GO TO 0017-RETURN.
      * -====-
      *
       0017-RETURN.
           MOVE FILE-STATUS-LOCAL TO FILE-STATUS.
           GOBACK.
      *
       0018-RETURN.
           GOBACK.
      *
