001000******************************************************************
001010*                                                                *
001000******************************************************************
       identification division.
       program-id. tpsiojnk.
       environment division.
       configuration section.
       source-computer. ibm-pc.
       object-computer. ibm-pc.
       special-names.
       input-output section.
       file-control.
           select jnkimg-file assign to dynamic filespec                                                                  
               organization is indexed
               lock mode is automatic                                                                                     
               access mode is dynamic
               record key is jnk-image-key of fs
               file status is file-status-local.
       data division.
       file section.
       FD  jnkimg-file
               LABEL RECORDS STANDARD.
       01  fs.
           copy "tpsjkimg.cpy".
       working-storage section.
       01  filespec                    pic x(28) value                                                                    
          '\tps\prod\files\jnkimage.dat'.                                                                                
       01  file-status-local           pic xx value zero.
      *
       01  next-key-record.
           05  filler                  pic x(52) value high-value.
           05  next-key-number         pic s9(9) comp-4 value 1.
           05  filler                  pic x(167) value low-value.
       01  opened-flag                 pic x.
       01  generic-flag                pic x.
       01  generic-key-length-lv       pic s9(4) comp-5.
       01  generic-key-length          pic s9(4) comp-5.
       01  generic-key.
           05  generic-key-byte occurs 50 indexed by gkdex
                                       pic x.
       01  generic-test.
           05  generic-test-byte occurs 50 indexed by gtdex
                                       pic x.
      *                                                                                                                   
       linkage section.
      *
               copy tpsfiles.cpy.
       01 ls.
               copy "tpsjkimg.cpy".
      *                                                                                                                   
       procedure division using file-request ls.
      *                                                                                                                   
      *
       0001-startup.
           if filespec = spaces
            display "tpsimagefile" upon environment-name
            accept filespec from environment-value.
           move '00' to file-status-local file-status.
      *
      *                         :---------------------------------------
      * ------------------------: perform the requested operation.
      *                         :---------------------------------------
      *
           go to
               0003-fr-open-input
               0004-fr-open-i-o
               0005-fr-close
               0006-fr-write
               0007-fr-rewrite
               0008-fr-delete
               0009-fr-start
               0009-fr-start
               0010-fr-start-high
               0010-fr-start-high
               0011-fr-read
               0012-fr-read-next
               0013-fr-read-previous
               depending
               on file-action.
      * -====-
       0002-fr-create.
           if fr-create
             open output jnkimg-file
             if file-status-local = '00'
                   or '41'
               write fs from
                   next-key-record
                   invalid key
                 continue
               end-write
               if file-status-local = '00'
                 close jnkimg-file
                 if file-status-local = '00'
                   open i-o jnkimg-file
                   if file-status-local = '00'
                     move 'Y' to opened-flag
                   end-if
                 end-if
               end-if
             end-if
           else
             move 'ZZ' to file-status-local.
           go to 0017-return.
                                                                                                                          
                                                                                                                          
       0003-fr-open-input.
           if opened-flag not = 'Y'
             open input jnkimg-file
             move 'Y' to opened-flag.
           go to 0017-return.
                                                                                                                          
                                                                                                                          
       0004-fr-open-i-o.
           if opened-flag not = 'Y'
             open i-o jnkimg-file.
           go to 0017-return.
                                                                                                                          
                                                                                                                          
       0005-fr-close.
           if opened-flag = 'Y'
             close jnkimg-file
             move 'N' to opened-flag.
           go to 0017-return.
                                                                                                                          
                                                                                                                          
       0006-fr-write.
           write fs from ls.
           go to 0017-return.
                                                                                                                          
                                                                                                                          
       0007-fr-rewrite.
           rewrite fs from ls.
           go to 0017-return.
                                                                                                                          
                                                                                                                          
       0008-fr-delete.
           delete jnkimg-file record.
           go to 0017-return.
                                                                                                                          
                                                                                                                          
       0009-fr-start.
           if fr-prime
             move jnk-image-key of ls to jnk-image-key of fs
             move jnk-image-key of fs to generic-key
             start jnkimg-file key not less than jnk-image-key of fs
                 invalid key
               continue.
               continue.
           if fr-generic-start
             perform 0014-save-generic-key.
           go to 0017-return.
                                                                                                                          
                                                                                                                          
       0010-fr-start-high.
           if fr-prime
             move jnk-image-key of fs to generic-key
             move high-value to jnk-image-key of fs
             start jnkimg-file key equal jnk-image-key of fs
                 invalid key
               continue.
               continue.
           if fr-generic-start
             perform 0014-save-generic-key.
                                                                                                                          
                                                                                                                          
       0011-fr-read.
           move jnk-image-key of ls to jnk-image-key of fs.
           read jnkimg-file into ls
               key is jnk-image-key of fs
               invalid key
             move low-values to ls.
           go to 0017-return.
                                                                                                                          
                                                                                                                          
       0012-fr-read-next.
           read jnkimg-file
           next record into ls
          ignore lock
           at end
             move 'N' to generic-flag.
           perform 0015-eof-test.
           go to 0017-return.
                                                                                                                          
                                                                                                                          
       0013-fr-read-previous.
           read jnkimg-file
               previous record into ls
           at end
             move 'N' to generic-flag.
           perform 0015-eof-test.
           go to 0017-return.
                                                                                                                          
                                                                                                                          
       0014-save-generic-key.
           move 0 to generic-key-length generic-key-length-lv.
           inspect generic-key
               tallying generic-key-length-lv
               for characters before initial low-value.
       
           inspect generic-key
               tallying generic-key-length
               for characters before initial space.
       
           if generic-key-length > generic-key-length-lv
             move generic-key-length-lv to generic-key-length.
       
           if generic-key-length > 0
             move 'Y' to generic-flag
           else
             move 'N' to generic-flag.
                                                                                                                          
       0015-eof-test.
           if jnk-image-key of fs = high-values
             move '10' to file-status-local.
           if file-status-local = '10' or '23'
             move 'N' to generic-flag.
           if generic-flag = 'Y'
             if fr-prime
               move jnk-image-key of fs to generic-test
             end-if
             perform with test after
                   varying gkdex from generic-key-length by -1
                   until gkdex = 1 or generic-flag = 'N'
               set gtdex to gkdex
               if generic-key-byte (gkdex)
                     not = generic-test-byte (gtdex)
                 move '10' to file-status-local
                 move 'N' to generic-flag
               end-perform.
                                                                                                                          
       0017-return.
           move file-status-local to file-status.
           goback.
                                                                                                                          
