000400 identification division.
000500 program-id. tpsio048.
000600*****************************************************************
000700* i/o to the credit card description/chart of accounts database *                                                   
000800*****************************************************************
000900 environment division.
001000
001100 configuration section.
001200 source-computer. ibm-pc.
001300 object-computer. ibm-pc.
001400 special-names.
001500     environment-value is env-value
001600     environment-name is env-name.
001700
001800 input-output section.
001900 file-control.
002000
002100    select card-file assign to dynamic filespec                                                                     
002200        organization is indexed
002300        lock mode is automatic
002400        access mode is dynamic
002500        record key is card-key                                                                                      
002600        file status is file-status-local.
002700
002800 data division.
002900
003000 file section.
003100
003200 fd  card-file                                                                                                      
003300        record contains 500 characters
003400        label records standard.
003500 01  card-rec.                                                                                                      
003600      05  card-key                 pic  x(262).
003700      05  filler                   pic  x(238).
003800
003900 working-storage section.
004400*
004500 01  filespec                    pic x(28) value                                                                    
          '/tps/prod/files/tpsccxrf.dat'.                                                                                 
004600*
004700 01  file-status-local           pic xx value zero.
004800*
004900 01  next-key-record.
005000    05  filler                   pic x(262) value high-value.
005100    05  next-key-number          pic s9(9) comp-4 value 1.
005200    05  filler                   pic x(167) value low-value.
005300*
005400 01  opened-flag                 pic x.
005500*
005600 01  generic-flag                pic x.
005700*
005800 01  generic-key-length-lv       pic s9(4) comp-5.
005900*
006000 01  generic-key-length          pic s9(4) comp-5.
006100*
006200 01  generic-key.
006300    05  generic-key-byte occurs 50 indexed by gkdex
006400                                 pic x.
006500 01  generic-test.
006600    05  generic-test-byte occurs 50 indexed by gtdex
006700                                 pic x.
006800*
006900                              77   link-sign-on      pic  x(10).
007000                              77   link-password     pic  x(10).
007100 linkage section.
007200      copy tpsfiles.cpy.
007300*
007400 01  cs.
007500      copy tpscards.cpy.
007600*
007700 procedure division using file-request cs.
007800*
007900 0001-startup.
008000     if filespec = spaces
008100      display 'downloadcreditcardfile' upon environment-name                                                        
008200      accept filespec from environment-value.
008300*
008400    move card-rec-key          to card-key.                                                                         
008500    move '00'                  to file-status-local file-status.
008600*
008700    go to
008800******  0000-fr-create
008900        0001-fr-open-input
009000        0002-fr-open-i-o
009100        0003-fr-close
009200        0004-fr-write
009300        0005-fr-rewrite
009400        0006-fr-delete
009500        0007-fr-start
009600        0008-fr-generic-start
009700        0009-fr-start-high
009800        0010-fr-generic-start-high
009900        0011-fr-read
010000        0012-fr-read-next
010100        0013-fr-read-previous
010200        0014-fr-read-with-lock
010300        0015-fr-open-with-lock
010400        0016-fr-unlock
010500        0017-fr-start-low
010600        depending
010700        on file-action.
010800*
010900 0000-fr-create.
011000    go to 0020-return.
011100*
011200 0001-fr-open-input.
011300      if opened-flag = 'y'
011400          go to 0020-return.
011500      open input card-file                                                                                          
011600        if file-status-local = '00' or '05'
011700           move 'y' to opened-flag.
011800        go to 0020-return.
011900*
012000 0002-fr-open-i-o.
012100      if opened-flag = 'y'
012200          go to 0020-return.
012300      open i-o card-file                                                                                            
012400        if file-status-local = '00' or '05'
012500           move 'y' to opened-flag.
012600        go to 0020-return.
012700*
012800 0003-fr-close.
012900    if opened-flag = 'y'
013000      close card-file                                                                                               
013100      move 'n' to opened-flag.
013200    go to 0020-return.
013300*
013400 0004-fr-write.
013500    write card-rec from cs.                                                                                         
013600    go to 0020-return.
013700*
013800 0005-fr-rewrite.
013900    rewrite card-rec from cs.                                                                                       
014000    go to 0020-return.
014100*
014200 0006-fr-delete.
014300    delete card-file record.                                                                                        
014400    go to 0020-return.
014500*
014600 0007-fr-start.
014700      start card-file key not less than card-key.                                                                   
014800    go to 0020-return.
014900*
015000 0008-fr-generic-start.
015100    go to 0020-return.
015200*
015300 0009-fr-start-high.
015400    go to 0020-return.
015500*
015600 0010-fr-generic-start-high.
015700    go to 0020-return.
015800*
015900 0011-fr-read.
016000    read card-file into cs.                                                                                         
016100    go to 0020-return.
016200*
016300 0012-fr-read-next.
016400      read card-file                                                                                                
016500      next record into cs
016600    ignore lock
016700      at end move 'n' to generic-flag.
016800
016900    go to 0020-return.
017000*
017100 0013-fr-read-previous.
017200
017300    read card-file                                                                                                  
017400    previous record into cs
017500    at end move 'n' to generic-flag.
017600
017700*   perform 0019-eof-test.
017800    go to 0020-return.
017900*
018000 0014-fr-read-with-lock.
018100    go to 0020-return.
018200*
018300 0015-fr-open-with-lock.
018400    go to 0020-return.
018500*
018600 0016-fr-unlock.
018700    go to 0020-return.
018800*
018900 0017-fr-start-low.
019000    start card-file key not less than card-key.                                                                     
019100    go to 0020-return.
019200*
019300 0019-eof-test.
019400    if card-key = high-values                                                                                       
019500      move '10' to file-status-local.
019600    if file-status-local = '10' or '23'
019700      move 'n' to generic-flag.
019800
019900    move card-key to generic-test                                                                                   
020000
020100      perform with test after
020200      varying gkdex from generic-key-length by -1
020300      until gkdex = 1 or generic-flag = 'n'
020400        set gtdex to gkdex
020500        if generic-key-byte (gkdex)
020600        not = generic-test-byte (gtdex)
020700    move '10' to file-status-local
020800    move 'n' to generic-flag
020900        end-perform.
021000
021100*
021200*
021300* -====-
021400*
021500 0020-return.
021600    move file-status-local to file-status.
021700    goback.
021800*
