000200 identification division.
000300 program-id. tpsio046.                                                                                              
000400************************************************04/06/07*********
000500*   program performs i/o to the wire data base                  *                                                   
000600*****************************************************************
000500*                     maintenance log                           *                                                   
000500*                                                               *                                                   
000600*****************************************************************
000900 environment division.
001100 configuration section.
001200 source-computer. ibm-pc.
001300 object-computer. ibm-pc.
001400 special-names.
001500     environment-value is env-value
001600     environment-name is env-name.
001700
001800 input-output section.
001900 file-control.
002000
002100    select wire-file assign to dynamic filespec
002200        organization is indexed
002200        lock mode is automatic
002300        access mode is dynamic
002400        record key is wire-rec-key                                                                                  
002500        file status is file-status-local.
002600
002700 data division.
002800
002900 file section.
003000
003100 fd  wire-file
003200        record contains 1500 characters                                                                             
003300        label records standard.
003400 01  wire-rec.
003500      05  wire-rec-key            pic  x(35).                                                                       
003600      05  filler                  pic  x(1465).                                                                     
003700
003800 working-storage section.
003900
005000 01  filespec                    pic x(27) value                                                                    
005200    '\tps\prod\files\tpswire.dat'.                                                                  
005200 
006000 01  file-status-local           pic xx value zero.
006600*
006700 01  opened-flag                 pic x.
008300                                                                          
008400 linkage section.
008600*
008500      copy tpsfiles.cpy.
008600*
008700 01  tps-wire-rec.
008800      copy tpswire.cpy.                                                                                             
008900*
009000 procedure division using file-request tps-wire-rec.
009100*
009200 0001-startup.
009300     if filespec = spaces
009410      display 'tpswirefile' upon environment-name                                                                   
009500      accept filespec from environment-value.
009600*
009700    move wireit-key           to wire-rec-key.                                                                      
009800    move '00'                 to file-status-local file-status.                                                     
009900*
010000    go to
010100*       0000-fr-create
010200        0001-fr-open-input
010300        0002-fr-open-i-o
010400        0003-fr-close
010500        0004-fr-write
010600        0005-fr-rewrite
010700        0006-fr-delete
010800        0007-fr-start
010900        0008-fr-generic-start
011000        0009-fr-start-high
011100        0010-fr-generic-start-high
011200        0011-fr-read
011300        0012-fr-read-next
011400        0013-fr-read-previous
011400        0014-fr-read-with-lock
011400        0015-fr-open-with-lock
011400        0016-fr-unlock
011400        0017-fr-start-low
011500        depending
011600        on file-action.
011700*
011800 0000-fr-create.
010600     IF FR-CREATE
010800       OPEN OUTPUT wire-FILE.
011900    go to 0020-return.
012000*
012100 0001-fr-open-input.
012200      if opened-flag = 'y'
012300          go to 0020-return.
012400      open input wire-file
012500        if file-status-local = '00' or '05'
012600           move 'y' to opened-flag.
012700        go to 0020-return.
012900*
013000 0002-fr-open-i-o.
013100      if opened-flag = 'y'
013200          go to 0020-return.
013300      open i-o wire-file
013400        if file-status-local = '00' or '05'
013500           move 'y' to opened-flag.
013600        go to 0020-return.
013700*
013800 0003-fr-close.
013900    if opened-flag = 'y'
014000      close wire-file
014100      move 'n' to opened-flag.
014200    go to 0020-return.
014300*
014400 0004-fr-write.
014500    write wire-rec from tps-wire-rec.
014600    go to 0020-return.
014700*
014800 0005-fr-rewrite.
014900    rewrite wire-rec from tps-wire-rec.
015000    go to 0020-return.
015100*
015200 0006-fr-delete.
015300    delete wire-file record.
015400    go to 0020-return.
015500*
015600 0007-fr-start.
015700      start wire-file key not less than wire-rec-key.                                                               
015800    go to 0020-return.
015900*
016000 0008-fr-generic-start.
016100    go to 0020-return.
016200*
016300 0009-fr-start-high.
015700      start wire-file key is greater than wire-rec-key.                                                             
016400    go to 0020-return.
016500*
016600 0010-fr-generic-start-high.
016700    go to 0020-return.
016800*
016900 0011-fr-read.
017000    read wire-file into tps-wire-rec.
017100    go to 0020-return.
017200*
017300 0012-fr-read-next.
017400    read wire-file
017500    next record into tps-wire-rec
017800    go to 0020-return.
017900*
018000 0013-fr-read-previous.
018110    read wire-file
018120    previous record into tps-wire-rec
018200    go to 0020-return.
018300*
018400 0014-fr-read-with-lock.
018200    go to 0020-return.
018500*
018400 0015-fr-open-with-lock.
018200    go to 0020-return.
018500*
018400 0016-fr-unlock.
018200    go to 0020-return.
018500*
018400 0017-fr-start-low.
015700    start wire-file key less than wire-rec-key.                                                                     
018200    go to 0020-return.
018700*
020800*
020900*
021000* -====-
021100*
021200 0020-return.
021300    move file-status-local to file-status.
021400    goback.
021500*
