000900 identification division.
001000 program-id. tpsio038.
001500*****************************************************************
001100*01/xx/04                                                       *
001200* program for i/o - client horse data base...............       *
001500*                                                               *
001500*****************************************************************
001500*                    maintenance log                            *
001500*                                                               *
001500*                                                               *
001500*                                                               *
001500*****************************************************************
001600 environment division.
001700*
001800 configuration section.
001900 source-computer. ibm-pc.
002000 object-computer. ibm-pc.
002100 special-names.
002200     environment-value is env-value
002300     environment-name is env-name.
002400*
002500 input-output section.
002600 file-control.
002700*
002800    select horse-file assign to dynamic filespec
002900        organization is indexed
003100        access mode is dynamic
003200        record key is horse-key-io
003300        file status is file-status-local.
003400*
003500 data division.
003600*
003700 file section.
003800*
003900 fd  horse-file
004000        record contains 500 characters
004100        label records standard.
004200 01  horse-rec-io.
004300      05  horse-key-io             pic  x(18).
004400      05  filler                   pic  x(482).
004500*
004600 working-storage section.
004700*
004800 01  horse-rec.
004900      copy tpshorse.cpy.
005000*
005800 01  filespec                    pic x(28) value
006000    '\tps\prod\files\tpshorse.dat'.
006000*
006100 01  tps-pathspec                pic x(80).
006200 01  tps-filename                pic x(08) value 'tpshorse'.
006300 01  tps-system-code             pic x(03) value 'tps'.
006400*
006500 01  env-str-name                pic x(121).
006600 01  env-str-value               pic x(121).
006700*
006800 01  file-status-local           pic xx value zero.
006900*
007000 01  next-key-record.
007100    05  filler                   pic x(52) value high-value.
007200    05  next-key-number          pic s9(9) comp-4 value 1.
007300    05  filler                   pic x(167) value low-value.
007400*
007500 01  opened-flag                 pic x.
007600*
007700 01  generic-flag                pic x.
007800*
007900 01  generic-key-length-lv       pic s9(4) comp-5.
008000*
008100 01  generic-key-length          pic s9(4) comp-5.
008200*
008300 01  generic-key.
008400    05  generic-key-byte occurs 50 indexed by gkdex
008500                                 pic x.
008600*
008700 01  generic-test.
008800    05  generic-test-byte occurs 50 indexed by gtdex
008900                                 pic x.
009000*
009100                              77   link-sign-on      pic  x(10).
009200                              77   link-password     pic  x(10).
009300*
009400 linkage section.
009500      copy tpsfiles.cpy.
009600 01  ls.
009700      copy tpshorse.cpy.
009800*
009900 procedure division using file-request ls.
010000*
010100 0001-startup.
010200      if filespec = spaces
010300         display 'tpshorsefile' upon environment-name
010400         accept filespec from environment-value.
010500*
010600    move horse-key of ls       to horse-key-io.
010700    move '00'                  to file-status-local file-status.
010800*

          if fr-open-with-lock
             go to 0014-open-with-lock
           end-if.

010800*
010900    go to
011000******  0000-fr-create
011100        0001-fr-open-input
011200        0002-fr-open-i-o
011300        0003-fr-close
011400        0004-fr-write
011500        0005-fr-rewrite
011600        0006-fr-delete
011700        0007-fr-start
011800        0008-fr-generic-start
011900        0009-fr-start-high
012000        0010-fr-generic-start-high
012100        0011-fr-read
012200        0012-fr-read-next
012300        0013-fr-read-previous
012400        depending
012500        on file-action.
012600*
012700 0000-fr-create.
012800*
012900    go to 0017-return.
013000*
013100 0001-fr-open-input.
013200      if opened-flag = 'Y'
013300          go to 0017-return.
013400*
013500      open input horse-file
013600        if file-status-local = '00' or '05'
013700           move 'Y' to opened-flag.
013800        go to 0017-return.
013900*
014000 0002-fr-open-i-o.
014100      if opened-flag = 'Y'
014200          go to 0017-return.
014300*
014400      open i-o horse-file
014500        if file-status-local = '00' or '05'
014600           move 'Y' to opened-flag.
014700        go to 0017-return.
014800*
014900 0003-fr-close.
015000    if opened-flag = 'Y'
015100      close horse-file
015200      move 'N' to opened-flag.
015300    go to 0017-return.
015400*
015500 0004-fr-write.
015600    write horse-rec-io from ls.
015700    go to 0017-return.
015800*
015900 0005-fr-rewrite.
016000    rewrite horse-rec-io from ls.
016100    go to 0017-return.
016200* -====-
016300 0006-fr-delete.
016400    delete horse-file record.
016500    go to 0017-return.
016600*
016700 0007-fr-start.
016800      start horse-file key not less than horse-key-io.
016900    go to 0017-return.
017000*
017100 0008-fr-generic-start.
017200*
017300    go to 0017-return.
017400*
017500 0009-fr-start-high.
016800      start horse-file key not greater than horse-key-io.
017700    go to 0017-return.
017800*
017900 0010-fr-generic-start-high.
018000*
018100    go to 0017-return.
018200*
018300 0011-fr-read.
018400    read horse-file into ls.
018500    go to 0017-return.
018600*
018700 0012-fr-read-next.
018800      read horse-file
018900      next record into ls
019000    ignore lock
019100      at end move high-values to horse-key of ls
019200           go to 0017-return.
019300
019400      go to 0017-return.
019500*
019600 0013-fr-read-previous.
018800      read horse-file
018900      previous record into ls
           at end
             move 'N' to generic-flag.
      *
      *12/16/99  perform 0015-eof-test.
      *
           go to 0017-return.
      * -====-
019900*
       0014-open-with-lock.
014100      if opened-flag = 'Y'
014200          go to 0017-return.
014300*
014400      open i-o horse-file with lock
014500        if file-status-local = '00' or '05'
014600           move 'Y' to opened-flag.
014700        go to 0017-return.
019900*
      *0014-fr-read-with-lock.
010600*    move pam-client-key of ls  to pamon-key.
      *    read pamon-file into ls with kept lock.
      *    go to 0017-return.
019900*
      *unlock-the-file.
      *    unlock pamon-file.
      *    go to 0017-return.
019900*
020000 0014-save-generic-key.
020100*
020200* -====-
020300*
020400 0015-eof-test.
019100    if horse-key of ls = high-values
020600      move '10' to file-status-local.
020700    if file-status-local = '10' or '23'
020800      move 'N' to generic-flag.
020900
019100      move horse-key of ls to generic-test.
021100
021200      perform with test after
021300      varying gkdex from generic-key-length by -1
021400      until gkdex = 1 or generic-flag = 'N'
021500        set gtdex to gkdex
021600        if generic-key-byte (gkdex)
021700        not = generic-test-byte (gtdex)
021800    move '10' to file-status-local
021900    move 'N' to generic-flag
022000        end-perform.
022100
022200* -====-
022300*
022400 0016-build-filespec.
022500*
022600*
022700* -====-
022800*
022900 0017-return.
023000*
023100    move file-status-local to file-status.
023200*
023300    goback.
023400*
