*******980608  1054  CHECKIN TPSACCID.CBL JJM 
       IDENTIFICATION DIVISION.
       PROGRAM-ID. TPSACCID.
       AUTHOR. JIM MONAGHAN.
      ***************************************************************
      *    FIND ACCOUNT NUMBER ID WHEN MORE THAN ONE CREDIT CARD    *
      *    OR TELEPHONE NUMBER EXITS FOR THE SAME VENDOR.           *
      ***************************************************************
      *                      MAINTENANCE LOG                        *                                                   
      * 03/30/00 CHANGED 'PERFORM' STATEMENT TO 'PERFORM WITH TEST  *                                                   
      *    TS    BEFORE', SUBSCRIPT ERROR ON BLANK RECUR A/C #..... *                                                   
      ***************************************************************
       FILE-CONTROL.
       DATA DIVISION.
       FILE SECTION.

       WORKING-STORAGE SECTION.

        01 AC-IND-NO                  PIC 9(01).
        01 AC-ACCT                    PIC X(20).
        01 AC-ACCT-NO REDEFINES AC-ACCT
                      OCCURS 20 TIMES PIC X(01).
        01 AC-IND1                    PIC 9(02) VALUE ZERO.
        01 AC-IND2                    PIC 9(02) VALUE ZERO.

        01 TPSIORCR                   PIC X(08) VALUE 'TPSIORCR'.
        01 TPSIOERR                   PIC X(08) VALUE 'TPSIOERR'.
        01 TPS-RECUR-REC.
           COPY "TPSRECUR.CPY".

           COPY "TPSFILES.CPY".

        01 TPSRECUR-FLAG              PIC 9(01) VALUE ZERO.
           88 TPSRECUR-OPEN           VALUE 1.

       LINKAGE SECTION.

       01 TPS-KEY.
          10 TPS-ACCT-NO              PIC 9(10).
          10 TPS-SUB-ACCT             PIC 9(02).
          10 TPS-ADDRESOR-NAME        PIC X(36).
          10 TPS-RECUR-ACCT-NO        PIC X(20).
       01 TPS-ACCT-ID                 PIC X(05).

       PROCEDURE DIVISION USING TPS-KEY TPS-ACCT-ID.

       010-MAIN-EVENT.

          INITIALIZE TPS-RECUR-REC.
          MOVE ZERO                   TO AC-IND-NO.
          MOVE TPS-ACCT-NO            TO RECUR-ACCT-NO.
          MOVE TPS-SUB-ACCT           TO RECUR-SUB-ACCT.
          MOVE TPS-ADDRESOR-NAME      TO RECUR-ADDRESOR-NAME.

          MOVE F-PRIME TO FILE-KEY.
          MOVE F-START TO FILE-ACTION.
          CALL TPSIORCR USING FILE-REQUEST TPS-RECUR-REC.

          IF NO-RECORD-WAS-FOUND
             GO TO 010-EXIT
          END-IF.

          IF NOT A-SUCCESSFUL-OPERATION
             MOVE ' RECUR' TO FILE-NAME
             MOVE 'TPSACCID-SBRC' TO FILE-TEXT
             CALL TPSIOERR USING FILE-REQUEST
             GO TO 010-EXIT
          END-IF.

       010-BROWSE.
          MOVE F-PRIME TO FILE-KEY.
          MOVE F-READ-NEXT TO FILE-ACTION.
          CALL TPSIORCR USING FILE-REQUEST TPS-RECUR-REC.

          IF END-OF-FILE-WAS-REACHED
             GO TO 010-EXIT
          END-IF.

          IF NOT A-SUCCESSFUL-OPERATION
             MOVE ' RECUR' TO FILE-NAME
             MOVE 'TPSACCID-BRRC' TO FILE-TEXT
             CALL TPSIOERR USING FILE-REQUEST
             GO TO 010-EXIT
          END-IF.

          IF TPS-ACCT-NO NOT = RECUR-ACCT-NO OR
             TPS-SUB-ACCT NOT = RECUR-SUB-ACCT OR
             TPS-ADDRESOR-NAME NOT = RECUR-ADDRESOR-NAME
             GO TO 010-EXIT
          END-IF.

          IF RECUR-CHART-ACCT-01  = '0200000000' AND
            (RECUR-CHART-ACCT-03  = '1900020000' OR
             RECUR-CHART-ACCT-04  = '1103060000')
             NEXT SENTENCE
          ELSE
             GO TO 010-BROWSE.

          ADD 1                  TO AC-IND-NO.
          IF AC-IND-NO > 1
             NEXT SENTENCE
          ELSE
             GO TO 010-BROWSE.

          MOVE TPS-RECUR-ACCT-NO   TO AC-ACCT.
          IF RECUR-CHART-ACCT-03 = '1900020000'
             PERFORM WITH TEST BEFORE                                                                                   
                     VARYING AC-IND1 FROM 20 BY -1 UNTIL
                     AC-ACCT-NO(AC-IND1) > SPACES OR                                                                    
                     AC-IND1 = 1                                                                                        
                     CONTINUE                                                                                           
                END-PERFORM                                                                                             
             MOVE AC-IND1            TO AC-IND2
             PERFORM WITH TEST BEFORE                                                                                   
                     VARYING AC-IND2 FROM AC-IND2 BY -1 UNTIL                                                           
                     AC-ACCT-NO(AC-IND2) = '-' OR                                                                       
                     AC-ACCT-NO(AC-IND2) = SPACE OR                                                                     
                     AC-IND2 = 1                                                                                        
                      CONTINUE                                                                                          
                END-PERFORM                                                                                             
             IF AC-IND1 > 1 AND AC-IND2 > 0
                COMPUTE AC-IND2 = AC-IND2 + 1
                MOVE AC-ACCT(AC-IND2:) TO TPS-ACCT-ID
             ELSE
                COMPUTE AC-IND2 = AC-IND1 - 3
                MOVE AC-ACCT(AC-IND2:) TO TPS-ACCT-ID
             END-IF
          ELSE
             IF RECUR-CHART-ACCT-04 = '1103060000'
                IF AC-ACCT(8:1) = '-' AND AC-ACCT(9:4) NUMERIC
                   MOVE AC-ACCT(9:4) TO TPS-ACCT-ID
                ELSE
                   PERFORM WITH TEST BEFORE                                                                             
                           VARYING AC-IND2 FROM 20 BY -1 UNTIL
                           AC-ACCT-NO(AC-IND2) > SPACE OR                                                               
                           AC-IND2 = ZERO                                                                               
                        CONTINUE
                      END-PERFORM                                                                                       
                   COMPUTE AC-IND2 = AC-IND2 - 3
                   MOVE AC-ACCT(AC-IND2:) TO TPS-ACCT-ID
                END-IF
             END-IF
          END-IF.

       010-EXIT.   EXIT.

          GOBACK.

