000700 IDENTIFICATION DIVISION.                                                            00001200
000800 PROGRAM-ID. TPS4020.                                                                00001300
000900                                                                                     00001400
001000****************************************************************                     00001500
001200* 01/02/95      CREATE HOLIDAY CALENDAR RECORDS                *                     00001700
001400****************************************************************                     00001900
001500*                MAINTENANCE LOG                               *                     00002000
000000* 05/08/17  CHANGED GUI                                      JM*
      * 02/12/14 ADDED CHECK FOR NO HOLIDAYS RECORDS TO DISPLAY   JA *
      *          IF ZERO THEN CALLS NEW YEAR ROUTINE TO ADD HOLIDAYS *
003720* 05/18/10 ADD COMMENT ON HOW TO ADD A HOLIDAY..........     JM*
003720* 10/25/06 FIX ALT-INDEX WAS NOT CLEARED OUT AFTER 1ST         *
003720*    TS    CALENDAR DISPLAY.....                               *
003720* 11/02/00 FIXED HIGH LIMIT CHECK FOR ALT-INDEX, WAS NOT > 16, *                                                  
003720*    TS    CHANGED TO < 16......                               *                                                  
003720* 08/04/99 AT 'START' FOR HOLIDAY SEARCH,ADDED NO-RECORD-FOUND *                                                  
003720*    TS    TO ALLOW NEW YEAR HOLIDAYS......                    *                                                  
003720* 01/14/99 ADDED 'IF NO-RECORD-WAS-FOUND' AT READ OF PROFILE,  *                                                  
003720*    TS    GAP IN ACCOUNTS CAUSED BY BUG IN NEW ACCOUNT SETUP  *                                                  
001601* 03/26/97  ADDED CODE WHEN DOING B'BAYS, ETC. TO BUILD CONTROL*                     00002600
001602*    TS     RECORDS FOR NEW YEAR, NEW MONTH & NEW DAY.. MISSING*                     00002700
001603*           CONTROLS WAS CAUSING DUP KEY PROBLEM. FILE WAS     *                     00002800
001604*           REPAIRED VIA FIXCALEN.CBL............              *                     00002900
001700* 12/26/96  ADDED OPTION VIA PANEL TPS4020C TO SEARCH CURRENT  *                     00003100
001800*    TS     YEAR FOR B'DAYS & ANNIVERSARIES & CREATE RECORD    *                     00003200
001900*           FOR NEXT YEAR. OPTION WILL ONLY BE ALLOWED WHEN    *                     00003300
002000*           FULL HOLIDAY OPTION IS DONE.                       *                     00003400
002100*                                                              *                     00003500
002200****************************************************************                     00003600
002300                                                                                     00003700
002400 ENVIRONMENT DIVISION.                                                               00003800
002500                                                                                     00003900
002600 CONFIGURATION SECTION.                                                              00004000
002700 SOURCE-COMPUTER. IBM-PC.                                                            00004100
002800 OBJECT-COMPUTER. IBM-PC.                                                            00004200
002900                                                                                     00004300
003000 FILE-CONTROL.                                                                       00004400
003100     SELECT PRT-FILE  ASSIGN TO FILE-ASSIGNMENT                                      00004500
003200         FILE STATUS IS TPS-FILE-STATUS                                              00004600
003300         ORGANIZATION IS LINE SEQUENTIAL.                                            00004700
003400****     FILE STATUS IS TPS-FILE-STATUS.                                             00004800
003500                                                                                     00004900
003600 DATA DIVISION.                                                                      00005000
003700 FILE SECTION.                                                                       00005100
003800 FD  PRT-FILE                                                                        00005200
003900     LABEL RECORDS ARE OMITTED                                                       00005300
004000     RECORD CONTAINS 150 CHARACTERS.                                                 00005400
004100 01  PRT-RECORD PIC X(150).                                                          00005500
004200                                                                                     00005600
004300                                                                                     00005700
004400 WORKING-STORAGE SECTION. 

***************** WINFORMS SCREEN DEFINITION **********

       01 TPS4020 type TPS000.TPS4020Form.
       01 TPS4020A type TPS000.TPS4020AForm.
       01 TPS4021 type TPS000.TPS4021Form.
       01 TPS4022 type TPS000.TPS4022Form.
       01 TPS4022A type TPS000.TPS4022AForm.
       01 TPS4022B type TPS000.TPS4022BForm.
       01 TPS4025 type TPS000.TPS4025Form.
       01 TPS4000 type TPS000.TPS4000Form.
       01 PROCESS-2 type TPS000.PROCESS_2Form.

       01 TPS4020-WHICH-YEAR PIC 9(04).
       01 TPS4020-MMDD PIC 9(04) OCCURS 16 TIMES.
       01 TPS4020-YY PIC X(03) OCCURS 16 TIMES.
       01 TPS4020-DAY-WEEK PIC X(09) OCCURS 16 TIMES.
       01 TPS4020-DESCRIPTION PIC X(30) OCCURS 16 TIMES.
       01 TPS4020-IDX PIC 9(02).
       01 TPS4020-DISPLAY-FLAG PIC 9(01) VALUE 0.

       01 TPS4021-DATE PIC 9(06).

       01 TPS4022-MMDDYY PIC x(08) OCCURS 16 TIMES.
       01 TPS4022-DAY-WEEK PIC X(09) OCCURS 16 TIMES.
       01 TPS4022-DESCRIPTION PIC X(30) OCCURS 16 TIMES.
       01 TPS4022-DELETE PIC X(10) OCCURS 16 TIMES.
       01 TPS4022-IDX PIC 9(02).
       01 TPS4022-DISPLAY-FLAG PIC 9(01) VALUE 0.

       01 TPS4022A-DATE PIC 9(06).
       01 TPS4022B-DATE PIC 9(06).

       01 TPS4025-YEAR-TO-PRINT PIC 9(04).

       01 TPS4000-DISPLAY-FLAG PIC 9(01) VALUE 0.
       01 PROCESS-2-DISPLAY-FLAG PIC 9(01) VALUE 0.



       01 THE-IDX-2 PIC 9(02).
       01 CLOSE-ALL-FORMS-FLAG PIC 9(01) VALUE 0.
       01 SCREEN-NAME PIC x(10).

       01 WS-CURRENT-X                            PIC 9(04).
       01 WS-CURRENT-Y                            PIC 9(04).
       01 WS-CURRENT-XY-PARM.
          05 WS-X-PARM                            PIC 9(04).
          05 WS-Y-PARM                            PIC 9(04).

       COPY "ds-cntrl.v1".

       COPY "TPS4020B.CPB".



**********************************************************

       01 THE-IDX                  PIC S9(4).                                              00005800
004500                                                                                     00005900
004600* ------------------------: Dynamically called programs:                             00006000
004700*        SCRNIO  is SCREENIO                                                         00006100
004800*        TPSIO018 IS 'CALEN' FILE HANDLER.                                           00006200
004900*                                                                                    00006300
023300  01  GUISCREEN               PIC X(08) VALUE 'GS     '.                             00025300
005000* 01  SCREENIO                PIC X(8) VALUE 'SCRNIO'.                               00006400
005100  01  TPSDATES                PIC X(8) VALUE 'TPSDATES'.                             00006500
005200  01  TPSIOERR                PIC X(8) VALUE 'TPSIOERR'.                             00006600
005300  01  TPSIO003                PIC X(8) VALUE 'TPSIO003'.                             00006700
005400  01  TPSIO004                PIC X(8) VALUE 'TPSIO004'.                             00006800
005500  01  TPSIO018                PIC X(8) VALUE 'TPSIO018'.                             00006900
005600  01  FLOATBIG                PIC X(8) VALUE 'FLOATBIG'.                             00007000
005700  01  FLOATIT                 PIC X(8) VALUE 'FLOATIT'.                              00007100
005800  01  MOD10                   PIC X(8) VALUE 'MOD10  '.                              00007200
005900                                                                                     00007300
006000  COPY KEYVALUE.CPY.                                                                 00007400
006100  COPY PCLVALUE.CPY.                                                                 00007500
006200  COPY PCL5VALU.CPY.                                                                 00007600
006300                                                                                     00007700
006400  COPY TPSBROWS.CPY.                                                                 00007800
006500                                                                                     00007900
006600 01  TPS-BRANCH-REC.                                                                 00008000
006700  COPY TPSBRNCH.CPY.                                                                 00008100
006800                                                                                     00008200
006900 01  TPS-CALENDAR-REC.                                                               00008300
007000  COPY TPSCALEN.CPY.                                                                 00008400
007100                                                                                     00008500
007200 01 TPS-PROFL-REC.                                                                   00008600
007300     COPY "TPSPROFL.CPY".                                                            00008700
007400                                                                                     00008800
007500                                                                                     00008900
007600 01  SAV-CALENDAR-REC       PIC  X(200).                                             00009000
007700                                                                                     00009100
007800 01  S-C-R-1                PIC  X(200).                                             00009200
007900 01  S-C-R-2                PIC  X(200).                                             00009300
008000 01  S-C-R-3                PIC  X(200).                                             00009400
008100                                                                                     00009500
008200 01  SAV-APPT-ADD-DATE      PIC  X(08).                                              00009600
008300                                                                                     00009700
008400 01  TPS-FILES-STATUS           PIC XX.                                              00009800
008500     88  TPS-CARRIER-FILE-OK        VALUE '00', '02'.                                00009900
008600                                                                                     00010000
008700                                                                                     00010100
008800*01  WS.                                                                             00010200
008900* COPY TPSLOGON.CPY.                                                                 00010300
009000                                                                                     00010400
009100  COPY TPSFILES.CPY.                                                                 00010500
009200                                                                                     00010600


009700  COPY TPS4020C.COB.                                                                 00011100




011200                                                                                     00012600

012600  COPY HOLIDAY.CPY.                                                                  00014000
012700                                                                                     00014100
012800 01 PANEL-SAVER.                                                                     00014200
012900        05 PANEL-SAVE     PIC  X(2300) VALUE HIGH-VALUES.                            00014300
013000        05 FILLER REDEFINES PANEL-SAVE.                                              00014400
013100            10 PANEL-DATA OCCURS 50 TIMES.                                           00014500
013200               15  PANEL-DAY-MMDD     PIC  X(04).                                    00014600
013300               15  PANEL-DAY-YY       PIC  X(03).                                    00014700
013400               15  PANEL-DAY-OF-WEEK  PIC  X(09).                                    00014800
013500               15  PANEL-DAY-DESCRIPT PIC  X(30).                                    00014900
013600                                                                                     00015000
013700                                                                                     00015100
013800                                                                                     00015200
013900 01 RECORD-SAVER.                                                                    00015300
014000        05 RECORD-SAVE     PIC  X(6500) VALUE HIGH-VALUES.                           00015400
014100        05 FILLER REDEFINES RECORD-SAVE.                                             00015500
014200            10 RECORD-DATA OCCURS 100 TIMES.                                         00015600
014300               15  RECORD-ACTION-CODE        PIC  X(01).                             00015700
014400                   88 RECORD-ACTION-NONE          VALUE '0'.                         00015800
014500                   88 RECORD-ACTION-MODIFY        VALUE '1'.                         00015900
014600                   88 RECORD-ACTION-DELETE        VALUE '2'.                         00016000
014700               15  RECORD-KEY                PIC  X(26).                             00016100
014800               15  FILLER REDEFINES RECORD-KEY.                                      00016200
014900                   20  RECORD-KEY-ACCT       PIC  X(10).                             00016300
015000                   20  RECORD-KEY-SUB-ACCT   PIC  X(02).                             00016400
015100                   20  RECORD-KEY-DATE       PIC  X(08).                             00016500
015200                   20  RECORD-KEY-RECORD     PIC  X(04).                             00016600
015300                   20  RECORD-KEY-SUB-REC    PIC  X(02).                             00016700
015400               15  RECORD-DAY-DESCRIPT       PIC  X(30).                             00016800
015500               15  RECORD-KEY-DATE-OLD       PIC  X(08).                             00016900
015600                                                                                     00017000
015700                                                                                     00017100
015800                                                                                     00017200
015900 01 PANEL-IDX-SAVER.                                                                 00017300
016000        05 PANEL-IDX-SAVE     PIC  X(40) VALUE HIGH-VALUES.                          00017400
016100        05 FILLER REDEFINES PANEL-IDX-SAVE.                                          00017500
016200            10 PANEL-DATA OCCURS 10 TIMES.                                           00017600
016300               15  PANEL-IDX-POINTER         PIC  X(04).                             00017700
016400                                                                                     00017800
016500                                                                                     00017900
016600 01  TPS-FILE-STATUS             PIC XX.                                             00018000
016700      88  TPS-CARRIER-FILE-OK        VALUE '00', '02'.                               00018100
016800                                                                                     00018200
016900 01  FILESPEC                    PIC X(80) VALUE SPACES.                             00018300
017000 01  FILE-ASSIGNMENT             PIC X(80) VALUE                                     00018400
017100               "C:\TPS\APP\HOLIDAYS.PCL        ".                                    00018500
017200*01  THE-INDEX                      PIC S9(4) COMP.                                  00018600
017300*01  BYTE-INDEX                     PIC S9(4) COMP.                                  00018700
017400*01  FORTY-INDEX                    PIC S9(4) COMP VALUE 40.                         00018800
017500                                                                                     00018900
017600 01  PRT-COMMAND-1              PIC  X(80)                                           00019000
017700      VALUE 'P C:\TPS\APP\HOLIDAYS.PCL                 '.                            00019100
017800 01  DEL-COMMAND-1              PIC  X(80)                                           00019200
017900      VALUE 'DEL C:\TPS\APP\HOLIDAYS.PCL               '.                            00019300
018000 01  RESULT                     PIC  99 COMP-X.                                      00019400
018100 01  FUNCTION-35                PIC  99 COMP-X VALUE 35.                             00019500
018200 01  NULL-PARAMETER.                                                                 00019600
018300      05  FILLER                PIC  99 COMP-X VALUE 0.                              00019700
018400      05  FILLER                PIC  X.                                              00019800
018500                                                                                     00019900
018600                                                                                     00020000
018700 01 REMEMBER-DATA-SEARCH              PIC  X(43).                                    00020100
018800 01 FILLER REDEFINES REMEMBER-DATA-SEARCH.                                           00020200
018900    05 REMEMBER-DATA-BYTES            PIC  X(01) OCCURS 43 TIMES.                    00020300
019000                                                                             0000401000020400
019100                                                                             0000402000020500
019200                                                                                     00020600
019300 01 PAGE-LINE-COUNT             PIC  9(02) VALUE ZEROS.                              00020700
019400 01 PAGE-NUMBER                 PIC  9(03) VALUE ZEROS.                              00020800
019500                                                                                     00020900
019600                                                                                     00021000
019700 01  HEAD-01.                                                                        00021100
019800     10  FILLER        PIC X(05)  VALUE SPACES.                                      00021200
019900     10  FILLER        PIC X(20)  VALUE ' TPS List of Holiday'.                      00021300
020000     10  FILLER        PIC X(20)  VALUE 's for Calendar Year '.                      00021400
020100     10  HEAD-01-WHATYEAR  PIC X(04).                                                00021500
020200     10  FILLER        PIC X(10)  VALUE spaces.                                      00021600
020300     10  FILLER        PIC X(09)  VALUE 'Prepared '.                                 00021700
020400     10  HEAD-01-DATE  PIC X(08)  VALUE 'xx/xx/xx'.                                  00021800
020500     10  FILLER        PIC X(08)  VALUE '   Page '.                                  00021900
020600     10  HEAD-01-PAGE  PIC ZZ9.                                                      00022000
020700     10  FILLER        PIC X(05)  VALUE SPACES.                                      00022100
020800                                                                                     00022200
020900 01  SUB-HEAD-01.                                                                    00022300
021000*** 05  FILLER              PIC  X(10) VALUE SPACES.                                 00022400
021100    05  FILLER              PIC  X(01) VALUE SPACES.                                 00022500
021200    05  FILLER              PIC  X(08) VALUE '  DATE  '.                             00022600
021300    05  FILLER              PIC  X(05) VALUE SPACES.                                 00022700
021400    05  FILLER              PIC  X(09) VALUE '  DAY    '.                            00022800
021500    05  FILLER              PIC  X(05) VALUE SPACES.                                 00022900
021600    05  FILLER              PIC  X(30) VALUE                                         00023000
021700                  '  HOLIDAY DESCRIPTION         '.                                  00023100
021800    05  FILLER                      PIC  X(40) VALUE SPACES.                         00023200
021900                                                                                     00023300
022000 01  HOLIDAY-PRINT.                                                                  00023400
022100*** 05  FILLER                      PIC  X(10) VALUE SPACES.                         00023500
022200    05  P-HOLIDAY-DATE-NG           PIC  X(01) VALUE SPACES.                         00023600
022300    05  P-HOLIDAY-DATE              PIC  X(08) VALUE SPACES.                         00023700
022400    05  FILLER                      PIC  X(05) VALUE SPACES.                         00023800
022500    05  P-HOLIDAY-DAY-OF-WEEK       PIC  X(09) VALUE SPACES.                         00023900
022600    05  FILLER                      PIC  X(05) VALUE SPACES.                         00024000
022700    05  P-HOLIDAY-NAME              PIC  X(30) VALUE SPACES.                         00024100
022800    05  FILLER                      PIC  X(40) VALUE SPACES.                         00024200
022900                                                                                     00024300
023000 01 JCL-PCL.                                                                         00024400
023100      05 PCL                    PIC  X(20).                                          00024500
023200      05 FILLER REDEFINES PCL.                                                       00024600
023300         10 PCL-BYTES           PIC  X(01) OCCURS 20 TIMES.                          00024700
023400      05 FULL-LINE-PRINT        PIC  X(150) VALUE SPACES.                            00024800
023500                                                                                     00024900
023600 01  WS-CALN-MEMO.                                                                   00025000
023700      05  WS-TODAYS-DATE-YMD         PIC  9(06).                                     00025100
023800      05  FILLER REDEFINES WS-TODAYS-DATE-YMD.                                       00025200
023900          10  WS-TODAYS-DATE-YMD-YY  PIC  9(02).                                     00025300
024000          10  WS-TODAYS-DATE-YMD-MM  PIC  9(02).                                     00025400
024100          10  WS-TODAYS-DATE-YMD-DD  PIC  9(02).                                     00025500
024200                                                                                     00025600
024300      05  WS-MEMO-DATE-CYMD          PIC  9(08).                                     00025700
024400      05  FILLER REDEFINES WS-MEMO-DATE-CYMD.                                        00025800
024500          10  WS-MEMO-DATE-CYMD-CC   PIC  9(02).                                     00025900
024600          10  WS-MEMO-DATE-CYMD-YY   PIC  9(02).                                     00026000
024700          10  WS-MEMO-DATE-CYMD-MM   PIC  9(02).                                     00026100
024800          10  WS-MEMO-DATE-CYMD-DD   PIC  9(02).                                     00026200
024900                                                                                     00026300
025000      05  WS-TODAYS-DATE-CYMD        PIC  9(08).                                     00026400
025100      05  FILLER REDEFINES WS-TODAYS-DATE-CYMD.                                      00026500
025200          10  WS-TODAYS-DATE-CYMD-CC PIC  9(02).                                     00026600
025300          10  WS-TODAYS-DATE-CYMD-YY PIC  9(02).                                     00026700
025400          10  WS-TODAYS-DATE-CYMD-MM PIC  9(02).                                     00026800
025500          10  WS-TODAYS-DATE-CYMD-DD PIC  9(02).                                     00026900
025600                                                                                     00027000
025700 01  WS-FROM-TO-DATE.                                                                00027100
025800      05  WS-FROM-DATE               PIC  9(08).                                     00027200
025900      05  FILLER REDEFINES WS-FROM-DATE.                                             00027300
026000          10  WS-FROM-DATE-CC        PIC  9(02).                                     00027400
026100          10  WS-FROM-DATE-YY        PIC  9(02).                                     00027500
026200          10  WS-FROM-DATE-MM        PIC  9(02).                                     00027600
026300          10  WS-FROM-DATE-DD        PIC  9(02).                                     00027700
026400      05  WS-TO-DATE                 PIC  9(08).                                     00027800
026500      05  FILLER REDEFINES WS-TO-DATE.                                               00027900
026600          10  WS-TO-DATE-CC          PIC  9(02).                                     00028000
026700          10  WS-TO-DATE-YY          PIC  9(02).                                     00028100
026800          10  WS-TO-DATE-MM          PIC  9(02).                                     00028200
026900          10  WS-TO-DATE-DD          PIC  9(02).                                     00028300
027000                                                                                     00028400
027100  01  WS-FLOAT-DATA.                                                                 00028500
027200      05  WS-FLOAT-PARMS              PIC  X(101).                                   00028600
027300      05  FILLER REDEFINES WS-FLOAT-PARMS.                                           00028700
027400          10  WS-FLOAT-COUNT          PIC  X(01).                                    00028800
027500          10  WS-FLOAT-1              PIC  X(25).                                    00028900
027600          10  WS-FLOAT-2              PIC  X(25).                                    00029000
027700          10  WS-FLOAT-3              PIC  X(25).                                    00029100
027800          10  FILLER REDEFINES WS-FLOAT-3.                                           00029200
027900              15  WS-FLOAT-3-A        PIC  X(22).                                    00029300
028000              15  WS-FLOAT-3-B        PIC  X(03).                                    00029400
028100          10  WS-FLOAT-4              PIC  X(25).                                    00029500
028200                                                                                     00029600
028300  01  BG-FLOAT-DATA.                                                                 00029700
028400      05  BG-FLOAT-PARMS              PIC  X(161).                                   00029800
028500      05  FILLER REDEFINES BG-FLOAT-PARMS.                                           00029900
028600          10  BG-FLOAT-COUNT          PIC  X(01).                                    00030000
028700          10  BG-FLOAT-1              PIC  X(40).                                    00030100
028800          10  BG-FLOAT-2              PIC  X(40).                                    00030200
028900          10  BG-FLOAT-2-R REDEFINES BG-FLOAT-2.                                     00030300
029000              15  BG-FLOAT-2-I        PIC  X(01) OCCURS 40 TIMES.                    00030400
029100          10  BG-FLOAT-3              PIC  X(40).                                    00030500
029200          10  FILLER REDEFINES BG-FLOAT-3.                                           00030600
029300              15  BG-FLOAT-3-A        PIC  X(37).                                    00030700
029400              15  BG-FLOAT-3-B        PIC  X(03).                                    00030800
029500          10  BG-FLOAT-3-R REDEFINES BG-FLOAT-3.                                     00030900
029600              15  BG-FLOAT-3-I        PIC  X(01) OCCURS 40 TIMES.                    00031000
029700          10  BG-FLOAT-4              PIC  X(40).                                    00031100
029800                                                                                     00031200
029900                                                                                     00031300
030000                                                                                     00031400
030100  01  WS-DATE-REQUEST.                                                               00031500
030200      05  WS-DATE-PARAM          PIC  9(02).                                         00031600
030400      05  WS-DATE-TENBYTES       PIC  X(20) VALUE SPACES.                            00031800
030500      05  FILLER REDEFINES WS-DATE-TENBYTES.                                         00031900
030600          10  WS-DATE-REFORM         PIC  X(06).                                     00032000
030700          10  WS-DATE-EXTEND         PIC  X(04).                                     00032100
030800          10  FILLER                 PIC  X(10).                                     00032200
030900      05  FILLER REDEFINES WS-DATE-TENBYTES.                                         00032300
031000          10  WS-DATE-REFORM-LEN06   PIC  X(06).                                     00032400
031100          10  FILLER                 PIC  X(14).                                     00032500
031200      05  FILLER REDEFINES WS-DATE-TENBYTES.                                         00032600
031300          10  WS-DATE-REFORM-LEN08   PIC  X(08).                                     00032700
031400          10  FILLER                 PIC  X(12).                                     00032800
031500      05  FILLER REDEFINES WS-DATE-TENBYTES.                                         00032900
031600          10  WS-DATE-REFORM-LEN10   PIC  X(10).                                     00033000
031700          10  FILLER                 PIC  X(10).                                     00033100
031800      05  FILLER REDEFINES WS-DATE-TENBYTES.                                         00033200
031900          10  WS-TIME-PARM1          PIC  X(06).                                     00033300
032000          10  WS-TIME-PARM2          PIC  X(06).                                     00033400
032100          10  WS-TIME-EXTEND         PIC  X(08).                                     00033500
032200      05  FILLER REDEFINES WS-DATE-TENBYTES.                                         00033600
032300          10  WS-TIME-PARM1BY8       PIC  X(08).                                     00033700
032400          10  WS-TIME-PARM2BY8       PIC  X(08).                                     00033800
032500          10  WS-TIME-EXTNDBY8       PIC  X(04).                                     00033900
032600                                                                                     00034000
032700      05  WS-FIX-DATE-YMD            PIC  9(06).                                     00034100
032800      05  FILLER REDEFINES WS-FIX-DATE-YMD.                                          00034200
032900          10  WS-FIX-DATE-YY-YMD     PIC  9(02).                                     00034300
033000          10  WS-FIX-DATE-MM-YMD     PIC  9(02).                                     00034400
033100          10  WS-FIX-DATE-DD-YMD     PIC  9(02).                                     00034500
033200                                                                                     00034600
033300      05  WS-FIX-DATE-MDY            PIC  9(06).                                     00034700
033400      05  FILLER REDEFINES WS-FIX-DATE-MDY.                                          00034800
033500          10  WS-FIX-DATE-MM-MDY     PIC  9(02).                                     00034900
033600          10  WS-FIX-DATE-DD-MDY     PIC  9(02).                                     00035000
033700          10  WS-FIX-DATE-YY-MDY     PIC  9(02).                                     00035100
033800                                                                                     00035200
033900      05  WS-TIME-OF-DAY        PIC  9(08) VALUE ZERO.                               00035300
034000      05  FILLER REDEFINES WS-TIME-OF-DAY.                                           00035400
034100          10  WS-TIME-HH        PIC  9(02).                                          00035500
034200          10  WS-TIME-MM        PIC  9(02).                                          00035600
034300          10  WS-TIME-SS        PIC  9(04).                                          00035700
034400          10  FILLER REDEFINES WS-TIME-SS.                                           00035800
034500              15  WS-TIME-SS1   PIC  9(02).                                          00035900
034600              15  WS-TIME-SS1   PIC  9(02).                                          00036000
034700              15  WS-TIME-SS2   PIC  9(02).                                          00036100
034800                                                                                     00036200
034900      05  WS-ADMIN-ONLY-ONCE        PIC  9(01) VALUE 0.                              00036300
035000               88  ADMIN-MISSED-ONCE      VALUE 1.                                   00036400
035100                                                                                     00036500
035200      05  WS-WORK-DATE-CYMD             PIC  9(08) VALUE ZEROS.                      00036600
035300      05  FILLER REDEFINES WS-WORK-DATE-CYMD.                                        00036700
035400          10  WS-WORK-DATE-CC           PIC  9(02).                                  00036800
035500          10  WS-WORK-DATE-YY           PIC  9(02).                                  00036900
035600          10  WS-WORK-DATE-MM           PIC  9(02).                                  00037000
035700          10  WS-WORK-DATE-DD           PIC  9(02).                                  00037100
035800      05  WS-BDAY-ANNIV-DATE-END        PIC  9(08) VALUE ZEROS.                      00037200
035900      05  WS-HOLD-RECORD-NUMBER         PIC  9(04) VALUE ZEROS.                      00037300
036000      05  WS-HOLD-SUB-RECORD-NUMBER     PIC  9(02) VALUE ZEROS.                      00037400
036100                                                                                     00037500
036200      05  WS-PREV-DAY-MMDD              PIC  9(04) VALUE ZEROS.                      00037600
036300      05  SAVE-PREV-DAY-MMDD            PIC  9(04) VALUE ZEROS.                      00037700
036400                                                                                     00037800
036500      05  WS-COMMON-MEMO                PIC  X(50).                                  00037900
036600                                                                                     00038000
036700      05  WS-NEXT-AVAIL-REC-NUM         PIC  9(04).                                  00038100
036800                                                                                     00038200
036900      05  WS-MONTH-WORK         PIC  X(09).                                          00038300
037000      05  FILLER REDEFINES WS-MONTH-WORK.                                            00038400
037100          10  WS-MONTH-WORK2    PIC  X(01) OCCURS 9 TIMES.                           00038500
037200      05  MONTH-INDEX           PIC S9(04) COMP.                                     00038600
037300      05  COMA-IDX              PIC S9(04) COMP.                                     00038700
037400      05  THE-INDEX             PIC S9(04) COMP.                                     00038800
037500      05  TMP-INDEX             PIC S9(04) COMP.                                     00038900
037600      05  WK-INDEX              PIC S9(04) COMP.                                     00039000
037700      05  ALT-INDEX             PIC S9(04) COMP.                                     00039100
037800      05  START-ALT-INDEX       PIC S9(04) COMP.                                     00039200
037900      05  PANEL-IDX             PIC S9(04) COMP VALUE 0.                             00039300
038000      05  RECORD-IDX            PIC S9(04) COMP VALUE 0.                             00039400
038100      05  START-RECORD-IDX      PIC S9(04) COMP VALUE 0.                             00039500
038200      05  POINTER-IDX           PIC S9(04) COMP VALUE 0.                             00039600
038300                                                                                     00039700
038400      05  SPACE-HIT             PIC  9(01) VALUE 0.                                  00039800
038500                                                                                     00039900
038600      05  YEAR-OF-HOLIDAYS      PIC  9(08).                                          00040000
038700      05  FILLER REDEFINES YEAR-OF-HOLIDAYS.                                         00040100
038800          10  YEAR-OF-HOLIDAYS-CCYY PIC  9(04).                                      00040200
038900          10  YEAR-OF-HOLIDAYS-MMDD PIC  9(04).                                      00040300
039000                                                                                     00040400
039100 01  CURSOR-WORK                PIC  9(04).                                          00040500
039200 01  CURSOR-WORK1               PIC  9(04).                                          00040600
039300 01  CURSOR-WORK2               PIC  9(04).                                          00040700
039400 01  WS-TWO                     PIC  9(01) VALUE 2.                                  00040800
039500                                                                                     00040900
039600 01  BEFORE-EDIT-DATE           PIC  9(06).                                          00041000
039700 01  SAV-CAL-KEY-DATE           PIC  9(08) VALUE 0.                                  00041100
039800                                                                                     00041200
039900 01  THE-DAY                    PIC  X(09).                                          00041300
040000                                                                                     00041400
040100 01  DOW                        PIC  9(01).                                          00041500
040200                                                                                     00041600
040300 01  DAYS-OF-THE-WEEK.                                                               00041700
040400      05  FILLER    PIC  9(01) VALUE 0.                                              00041800
040500      05  FILLER    PIC  X(09) VALUE 'Sunday   '.                                    00041900
040600      05  FILLER    PIC  9(01) VALUE 1.                                              00042000
040700      05  FILLER    PIC  X(09) VALUE 'Monday   '.                                    00042100
040800      05  FILLER    PIC  9(01) VALUE 2.                                              00042200
040900      05  FILLER    PIC  X(09) VALUE 'Tuesday  '.                                    00042300
041000      05  FILLER    PIC  9(01) VALUE 3.                                              00042400
041100      05  FILLER    PIC  X(09) VALUE 'Wednesday'.                                    00042500
041200      05  FILLER    PIC  9(01) VALUE 4.                                              00042600
041300      05  FILLER    PIC  X(09) VALUE 'Thursday '.                                    00042700
041400      05  FILLER    PIC  9(01) VALUE 5.                                              00042800
041500      05  FILLER    PIC  X(09) VALUE 'Friday   '.                                    00042900
041600      05  FILLER    PIC  9(01) VALUE 6.                                              00043000
041700      05  FILLER    PIC  X(09) VALUE 'Saturday '.                                    00043100
041800 01  DAYS-OF-THE-WEEK-R REDEFINES DAYS-OF-THE-WEEK.                                  00043200
041900     05  DAYS-OF-THE-WEEK-R OCCURS 7 TIMES INDEXED BY DAYS-INDEX.                    00043300
042000         10  DAY-VALUE          PIC  9(01).                                          00043400
042100         10  DAY-NAME           PIC  X(09).                                          00043500
042200                                                                                     00043600
042300                                                                                     00043700
042400      05  WS-CLNT-ACCT-NO       PIC  9(10).                                          00043800
042500      05  WS-CLNT-SUB-ACCT      PIC  9(02).                                          00043900
042600                                                                                     00044000
042700      05  PARMS                       PIC  X(250).                                   00044100
042800      05  FILLER REDEFINES PARMS.                                                    00044200
042900          10  PARM01                  PIC  9(12).                                    00044300
043000          10  FILLER REDEFINES PARM01.                                               00044400
043100              15  PARM01-ACCOUNT-NO   PIC  9(10).                                    00044500
043200              15  PARM01-SUB-ACCT     PIC  9(02).                                    00044600
043300          10  PARM02                  PIC  9(01).                                    00044700
043400              88  PARM02-NEW-ACCT                VALUE 1.                            00044800
043500          10  PARM03                  PIC  9(01).                                    00044900
043600              88  PARM03-MAINT-ACCT              VALUE 1.                            00045000
043700          10  PARM04                  PIC  9(01).                                    00045100
043800          10  PARM05                  PIC  9(01).                                    00045200
043900          10  PARM06                  PIC  9(01).                                    00045300
044000          10  PARM07                  PIC  9(01).                                    00045400
044100          10  PARM08                  PIC  9(01).                                    00045500
044200          10  PARM09                  PIC  9(01).                                    00045600
044300          10  PARM10                  PIC  9(06).                                    00045700
044400          10  FILLER                  PIC  X(229).                                   00045800
044500                                                                                     00045900
044600  01  DISPLAY-FILE-ACTION        PIC 99.                                             00046000
044700  01  FUNCTION-15                PIC S9(4) COMP-5 VALUE 15.                          00046100
044800                                                                                     00046200
044900  01  WS-PASSWORD-STATUS        PIC  9(01) VALUE 0.                                  00046300
045000           88  WS-PASSWORD-NG              VALUE 1.                                  00046400
045100                                                                                     00046500
045200  01  WS-PASSWORD-ACTIVE        PIC  9(01) VALUE 0.                                  00046600
045300           88  WS-PASSWORD-INACTIVE        VALUE 1.                                  00046700
045400                                                                                     00046800
045500  01  END-OF-HOLIDAYS-FLAG      PIC  9(01) VALUE 0.                                  00046900
045600           88  END-OF-HOLIDAYS             VALUE 1.                                  00047000
045700                                                                                     00047100
045800  01  ALLOW-BDAY-OPTION-FLAG    PIC  9(01) VALUE 0.                                  00047200
045900           88  ALLOW-BDAY-OPTION           VALUE 1.                                  00047300
046000                                                                                     00047400
046100  01  HOLIDAY-READ-PRINT-FLAG   PIC  9(01) VALUE 0.                                  00047500
046200           88  FIRST-READ-FOR-PRINT        VALUE 0.                                  00047600
046300                                                                                     00047700
046400  01  HAVE-EDIT-DELETE-FLAG     PIC  9(01) VALUE 0.                                  00047800
046500           88  HAVE-EDIT-DELETE            VALUE 1.                                  00047900
046600                                                                                     00048000
046700  01  FUNCTION-FLAG             PIC S9(4) COMP-5 VALUE 12.                           00048100
046800                                                                                     00048200
046900  01  CURRENT-CURSOR            PIC  9(4) COMP-5 VALUE 2.                            00048300
047000                                                                                     00048400
047100  01  SPEC-HOLIDAY-PROCESS-FLAG PIC  9(01) VALUE 0.                                  00048500
047200           88  SPEC-HOLIDAY-PROCESS        VALUE 1.                                  00048600
047300                                                                                     00048700
047400  01  SPEC-HOLIDAY-CURSOR-FLAG  PIC  9(01) VALUE 0.                                  00048800
047500           88  SPEC-HOLIDAY-DATE-DONE      VALUE 1.                                  00048900
047600           88  SPEC-HOLIDAY-DAY-DONE       VALUE 2.                                  00049000
047700  01 CHECK-HOLI-DISPLAY-CNT     PIC 9(3) VALUE 0.                                    00049100
047800                                                                                     00049200
047900 01  DOESNT-EXIST.                                                                   00049300
048000      05  FILLER  PIC  X(20) VALUE 'REQUESTED YEAR DOES '.                           00049400
048100      05  FILLER  PIC  X(20) VALUE 'NOT EXIST ON DATA BA'.                           00049500
048200      05  FILLER  PIC  X(20) VALUE 'SE, END KEY - PREVIO'.                           00049600
048300      05  FILLER  PIC  X(20) VALUE 'US MENU.            '.                           00049700
048400                                                                                     00049800
048500 LINKAGE SECTION.                                                                    00049900
048600 01  LS-LOGON.                                                                       00050000
048700      COPY TPSLOGON.CPY.                                                             00050100
048800                                                                                     00050200
048900 01  LS-PROFL.                                                                       00050300
049000      COPY TPSPROFL.CPY.                                                             00050400
049100                                                                                     00050500
049200 01  LS-MENU-SELECT             PIC  9(02).                                          00050600
049300         88 LS-MENU-SELECT-MAINT     VALUE 05.                                       00050700
049400         88 LS-MENU-SELECT-PRINT     VALUE 06.                                       00050800
049500                                                                                     00050900
049600 01 CURRENT-XY-PARAMETERS PIC 9(08).

049700 PROCEDURE DIVISION USING LS-LOGON
                                LS-PROFL
                                LS-MENU-SELECT
                                CURRENT-XY-PARAMETERS.
049800                                                                                
049900 0001-BEGIN.

      *********** INITIALIZE WINFORMS SCREENS **********

       set TPS4020 to new TPS000.TPS4020Form().
       set TPS4020A to new TPS000.TPS4020AForm().
       set TPS4021 to new TPS000.TPS4021Form().
       set TPS4022 to new TPS000.TPS4022Form().
       set TPS4022A to new TPS000.TPS4022AForm().
       set TPS4022B to new TPS000.TPS4022BForm().
       set TPS4025 to new TPS000.TPS4025Form().
       set TPS4000 to new TPS000.TPS4000Form().
       set PROCESS-2 to new TPS000.PROCESS_2Form().

      **************************************************

           MOVE CURRENT-XY-PARAMETERS(1:4) TO WS-CURRENT-X
                                              WS-X-PARM.
           MOVE CURRENT-XY-PARAMETERS(5:4) TO WS-CURRENT-Y
                                              WS-Y-PARM.

      ** 2/12/14 ADDED SET HOLIDAY-INDEX TO ZERO. JA
      ** 2/12/14 ADDED MOVE ZERO TO CHECK-HOLI-DISPLAY-CNT JA
            MOVE ZERO TO CHECK-HOLI-DISPLAY-CNT.                                           00125200
      **********************************************************
050000      ACCEPT WS-TODAYS-DATE-YMD FROM DATE.                                           00051400
050100      MOVE 01                   TO WS-DATE-PARAM.                                    00051500
050200      MOVE WS-TODAYS-DATE-YMD   TO WS-DATE-REFORM.                                   00051600
050300      MOVE SPACES               TO WS-DATE-EXTEND.                                   00051700
050400         CALL TPSDATES USING WS-DATE-REQUEST.                                        00051800
050500      MOVE WS-DATE-REFORM-LEN08 TO WS-TODAYS-DATE-CYMD.                              00051900
050600                                                                                     00052000
050700    PERFORM OPEN-THE-FILES                                                           00052100
050800       THRU OPEN-THE-FILES-EXIT.                                                     00052200
050900                                                                                     00052300
051000*     MOVE CLNT-PROFILE-ACCT-NO OF LS-PROFL                                          00052400
051100*                                 TO WS-CLNT-ACCT-NO.                                00052500
051200*     MOVE CLNT-PROFILE-SUB-ACCT OF LS-PROFL                                         00052600
051300*                                 TO WS-CLNT-SUB-ACCT.                               00052700
051400                                                                                     00052800
051500      IF LS-MENU-SELECT-PRINT                                                        00052900
051600         GO TO PRINT-HOLIDAYS.                                                       00053000
051700      IF NOT LS-MENU-SELECT-MAINT                                                    00053100
051800         MOVE '99'        TO LS-MENU-SELECT                                          00053200
051900         GO TO EXIT-THE-MODULE.                                                      00053300
052000                                                                                     00053400
052100      MOVE ZEROS                TO TPS4020-WHICH-YEAR.                               00053500
052200                                                                                     00053600
052300      PERFORM VARYING THE-INDEX FROM 1 BY 1                                          00053700
052400              UNTIL THE-INDEX > 16                                                   00053800
052500         MOVE ZEROS             TO TPS4020-MMDD(THE-INDEX)                          00053900
052600         MOVE SPACES            TO TPS4020-YY(THE-INDEX)                            00054000
052700         MOVE SPACES            TO TPS4020-DAY-WEEK(THE-INDEX)                       00054100
052800         MOVE SPACES            TO TPS4020-DESCRIPTION(THE-INDEX)                      00054200
052900      END-PERFORM.                                                                   00054300
053000                                                                                     00054400
053100*JUST-PAINT-TPS4020.                                                                 00054500
053200*          MOVE '6'             TO TPS4020-INDICATORS.                               00054600
053300*          MOVE 'O'             TO TPS4020-REPAINT-SCREEN.                           00054700
053400*     CALL SCREENIO USING TPS4020-PANEL                                              00054800
053500*                         TPS4020-PASS-TO-EXIT                                       00054900
053600*                         TPS4020-WORK-S                                             00055000
053700*                         TPS4020-WORK-D.                                            00055100
053800                                                                                     00055200
053900                                                                                     00055300
054000*DISPLAY-PANEL-TPS4020A.                                                             00055400
054100*     MOVE SPACES          TO HOLIDAY-SPECIAL-QUESTION.                              00055500
054200*     MOVE '6'             TO TPS4020A-INDICATORS.                                   00055600
054300*     CALL SCREENIO USING TPS4020A-PANEL                                             00055700
054400*                         TPS4020A-PASS-TO-EXIT                                      00055800
054500*                         TPS4020A-WORK-S                                            00055900
054600*                         TPS4020A-WORK-D.                                           00056000
054700                                                                                     00056100
054800*     IF HOLIDAY-SPECIAL-QUESTION = 'N'                                              00056200
054900*         GO TO DISPLAY-PANEL-TPS4020.                                               00056300
055000                                                                                     00056400
055100*     IF HOLIDAY-SPECIAL-QUESTION = 'Y'                                              00056500
055200*         GO TO SETUP-PANEL-TPS4021.                                                 00056600
055300                                                                                     00056700
055400*     IF THEY-HIT-END                                                                00056800
055500*         GO TO EXIT-THE-MODULE.                                                     00056900
055600                                                                                     00057000
055700*     MOVE 1                    TO TPS4020A-DISPLAY-OPTION                           00057100
055800*     MOVE 'VALID RESPONSES ARE Y or N   ' TO                                        00057200
055900*                                  TPS4020A-MENU-MSG                                 00057300
056000*     GO TO DISPLAY-PANEL-TPS4020A.                                                  00057400
056100                                                                                     00057500
056200                                                                                     00057600
056300 DISPLAY-PANEL-TPS4020.                                                              00057700

           MOVE TPS4020-WHICH-YEAR TO TPS4020::WHICH-YEAR.
           MOVE 0 TO TPS4020-IDX.
           PERFORM VARYING THE-IDX-2 FROM 1 BY 1
             UNTIL THE-IDX-2 > 16
               MOVE TPS4020-MMDD(THE-IDX-2) TO
                 TPS4020::MMDD(TPS4020-IDX)
               MOVE TPS4020-YY(THE-IDX-2) TO
                 TPS4020::YY(TPS4020-IDX)
               MOVE TPS4020-DAY-WEEK(THE-IDX-2) TO
                 TPS4020::DAY-WEEK(TPS4020-IDX)
               MOVE TPS4020-DESCRIPTION(THE-IDX-2) TO
                 TPS4020::DESCRIPTION(TPS4020-IDX)
               COMPUTE TPS4020-IDX = TPS4020-IDX + 1
           END-PERFORM.

           SET TPS4020::X-POINT TO WS-X-PARM.
           SET TPS4020::Y-POINT TO WS-Y-PARM.
           INVOKE TPS4020::ShowDialog.
           MOVE TPS4020::Location::X TO WS-X-PARM
             WS-CURRENT-X.
           MOVE TPS4020::Location::Y TO WS-Y-PARM
             WS-CURRENT-Y.
           MOVE TPS4020::SCREEN-NAME TO SCREEN-NAME.

           MOVE TPS4020::WHICH-YEAR TO TPS4020-WHICH-YEAR.
 

057100                                                                                     00058500
057200      IF TPS4020::KEY-PRESSED = "End Key"                         
057300          GO TO JUST-PAINT-TPS4020.                                                  00058700
057400*12/25/96 GO TO EXIT-THE-MODULE.                                                     00058800
057500                                                                                     00058900
057600*     IF THEY-HIT-ENTER                                                              00059000
057700*        MOVE 1                    TO TPS4020-DISPLAY-OPTION                         00059100
057800*        MOVE 'HIT ALT-ENTER TO PROCESS DATA' TO                                     00059200
057900*                                  TPS4020::MENU-LINE                             00059300
058000*        GO TO DISPLAY-PANEL-TPS4020.                                                00059400
058100                                                                                     00059500
058200      EVALUATE TPS4020::HOT-FIELD                                                     00059600
058300          WHEN 1001
                     GO TO HOT-FIELD-1001                                     00059700
058400      END-EVALUATE.                                                                  00059800
058500                                                                                     00059900
058600      GO TO DISPLAY-PANEL-TPS4020.                                                   00060000
058700                                                                                     00060100
058800 HOT-FIELD-1001.                                                                     00060200
058900      MOVE  TPS4020-WHICH-YEAR  TO YEAR-OF-HOLIDAYS-CCYY                             00060300
059000                                   TPS4022::WHICH-YEAR.                               00060400
059100      MOVE 2 TO TPS4020::ACTIVE-FIELD.                                                                             
059200*HERE                                                                                00060600
059300                                                                                     00060700
059400      MOVE '9999999999'         TO CAL-KEY-ACCT-NO.                                  00060800
059500      MOVE '00'                 TO CAL-KEY-SUB-ACCT.                                 00060900
059600      MOVE ZEROS                TO CAL-KEY-DATE                                      00061000
059700                                   CAL-KEY-RECORD-NUMBER                             00061100
059800                                   CAL-KEY-SUB-RECORD-NUMBER.                        00061200
059900      MOVE YEAR-OF-HOLIDAYS-CCYY TO CAL-KEY-DATE(1:4).                               00061300
060000                                                                                     00061400
060100      MOVE F-PRIME      TO FILE-KEY.                                                 00061500
060200      MOVE F-START      TO FILE-ACTION.                                              00061600
060300      CALL TPSIO018 USING FILE-REQUEST TPS-CALENDAR-REC.                             00061700
165700      IF NO-RECORD-WAS-FOUND                                                         00061800
062100         MOVE '1'               TO ALLOW-BDAY-OPTION-FLAG                            00061900
063400         GO TO NEW-YEAR-OF-HOLIDAYS                                                  00062000
             END-IF.                                                                       00062100
060400      IF FILE-STATUS NOT = '00' AND '05'                                             00062200
060500         MOVE 'TPS4020 ' TO FILE-NAME                                                00062300
060600         MOVE 'START   ' TO FILE-TEXT                                                00062400
060700         PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                     00062500
060800         GO TO EXIT-THE-MODULE.                                                      00062600
060900                                                                                     00062700
061000 SEARCH-FOR-HOLIDAY.                                                                 00062800
061100      MOVE F-PRIME      TO FILE-KEY.                                                 00062900
061200      MOVE F-READ-NEXT  TO FILE-ACTION.                                              00063000
061300      CALL TPSIO018 USING FILE-REQUEST TPS-CALENDAR-REC.                             00063100
061400      IF FILE-STATUS NOT = '00' AND '05' AND '10'                                    00063200
061500         MOVE 'TPS4020 ' TO FILE-NAME                                                00063300
061600         MOVE 'READ-NEXT' TO FILE-TEXT                                               00063400
061700         PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                     00063500
061800         GO TO EXIT-THE-MODULE.                                                      00063600
061900                                                                                     00063700
062000      IF CAL-KEY = HIGH-VALUES                                                       00063800
062100         MOVE '1'               TO ALLOW-BDAY-OPTION-FLAG                            00063900
062200         GO TO NEW-YEAR-OF-HOLIDAYS.                                                 00064000
062300                                                                                     00064100
062400      IF CAL-KEY-DATE(1:4) NOT = YEAR-OF-HOLIDAYS-CCYY                               00064200
062500         MOVE '1'               TO ALLOW-BDAY-OPTION-FLAG                            00064300
062600         GO TO NEW-YEAR-OF-HOLIDAYS.                                                 00064400
062700                                                                                     00064500
062800      IF NOT CAL-HOLIDAY-REC                                                         00064600
062900         GO TO SEARCH-FOR-HOLIDAY.                                                   00064700
063000                                                                                     00064800
063100      GO TO RETRIEVE-THE-HOLIDAYS.                                                   00064900
063200                                                                                     00065000
063300                                                                                     00065100
063400 NEW-YEAR-OF-HOLIDAYS.    

           INITIALIZE  TPS4020B-CL-WINDOW-FLAG
                       TPS4020B-END-FLAG                  
                       TPS4020B-CR-FLAG.                 

           MOVE TPS4020B-DATA-BLOCK-VERSION-NO 
                                 TO DS-DATA-BLOCK-VERSION-NO.
           MOVE TPS4020B-VERSION-NO TO DS-VERSION-NO.
           MOVE WS-CURRENT-X TO TPS4020B-DSMOVSZ-X.
           MOVE WS-CURRENT-Y TO TPS4020B-DSMOVSZ-Y.
           MOVE DS-PUSH-SET TO DS-CONTROL.
           MOVE "TPS4020B"  TO DS-SET-NAME.
           CALL "DSGRUN" USING DS-CONTROL-BLOCK
                               TPS4020B-DATA-BLOCK.

          MOVE TPS4020B-DSMOVSZ-X TO WS-CURRENT-X.
          MOVE TPS4020B-DSMOVSZ-Y TO WS-CURRENT-Y.
          MOVE WS-CURRENT-X TO WS-X-PARM.
          MOVE WS-CURRENT-Y TO WS-Y-PARM.

      *********** CLOSE POPUP TPS4020B ***********************

           MOVE TPS4020B-DATA-BLOCK-VERSION-NO 
                                 TO DS-DATA-BLOCK-VERSION-NO.
           MOVE TPS4020B-VERSION-NO TO DS-VERSION-NO.
           MOVE WS-CURRENT-X TO TPS4020B-DSMOVSZ-X.
           MOVE WS-CURRENT-Y TO TPS4020B-DSMOVSZ-Y.
           MOVE DS-QUIT-SET TO DS-CONTROL.
           MOVE "TPS4020B"  TO DS-SET-NAME.
           CALL "DSGRUN" USING DS-CONTROL-BLOCK
                               TPS4020B-DATA-BLOCK.
      ********************************************************

064000                                                                                     00065800
064100      MOVE 0                    TO ALT-INDEX.                                        00065900
064200      SET HOLIDAY-INDEX         TO ALT-INDEX.                                        00066000
064300      MOVE ZEROS                TO WS-PREV-DAY-MMDD.                                 00066100
064400                                                                                     00066200
064500 NEXT-PANEL-OF-HOLIDAYS.                                                             00066300
064600      PERFORM VARYING THE-INDEX FROM 1 BY 1                                          00066400
064700              UNTIL THE-INDEX > 16                                                   00066500
064800         SET HOLIDAY-INDEX UP BY 1                                                   00066600
064900         ADD 1                  TO ALT-INDEX                                         00066700
065000         IF HOLIDAY-DATE(HOLIDAY-INDEX)  = '9999'                                    00066800
065100              MOVE SAVE-PREV-DAY-MMDD TO WS-PREV-DAY-MMDD                            00066900

065200              GO TO REDISPLAY-PANEL-TPS4020                                          00067000
065300         END-IF                                                                      00067100
065400         IF HOLIDAY-DATE(HOLIDAY-INDEX) NOT = ZEROS                                  00067200
065500              MOVE HOLIDAY-DATE(HOLIDAY-INDEX)                                       00067300
065600                                TO TPS4020-MMDD(ALT-INDEX)                          00067400
065700              MOVE '/'          TO TPS4020-YY(ALT-INDEX)(1:1)                       00067500
065800              MOVE YEAR-OF-HOLIDAYS-CCYY(3:2)                                        00067600
065900                                TO TPS4020-YY(ALT-INDEX)(2:2)                       00067700
066000              MOVE HOLIDAY-DATE(HOLIDAY-INDEX)                                       00067800
066100                                TO YEAR-OF-HOLIDAYS-MMDD                             00067900
066200                 PERFORM FIGURE-THE-DAY                                              00068000
066300                    THRU FIGURE-THE-DAY-EXIT                                         00068100
066400              MOVE THE-DAY      TO TPS4020-DAY-WEEK(ALT-INDEX)                       00068200
066500         END-IF                                                                      00068300
066600              MOVE HOLIDAY-NAME(HOLIDAY-INDEX)                                       00068400
066700                                TO TPS4020-DESCRIPTION(ALT-INDEX)                      00068500
066800         END-PERFORM.                                                                00068600
066900      MOVE SAVE-PREV-DAY-MMDD   TO WS-PREV-DAY-MMDD.                                 00068700
067000                                                                                     00068800
067100 REDISPLAY-PANEL-TPS4020.                                                            00068900

           MOVE TPS4020-WHICH-YEAR TO TPS4020::WHICH-YEAR.
           MOVE 0 TO TPS4020-IDX.
           PERFORM VARYING THE-IDX-2 FROM 1 BY 1
             UNTIL THE-IDX-2 > 16
               MOVE TPS4020-MMDD(THE-IDX-2) TO
                 TPS4020::MMDD(TPS4020-IDX)
               MOVE TPS4020-YY(THE-IDX-2) TO
                 TPS4020::YY(TPS4020-IDX)
               MOVE TPS4020-DAY-WEEK(THE-IDX-2) TO
                 TPS4020::DAY-WEEK(TPS4020-IDX)
               MOVE TPS4020-DESCRIPTION(THE-IDX-2) TO
                 TPS4020::DESCRIPTION(TPS4020-IDX)
               COMPUTE TPS4020-IDX = TPS4020-IDX + 1
           END-PERFORM.

           SET TPS4020::X-POINT TO WS-X-PARM.
           SET TPS4020::Y-POINT TO WS-Y-PARM.
           INVOKE TPS4020::ShowDialog.
           MOVE TPS4020::Location::X TO WS-X-PARM
             WS-CURRENT-X.
           MOVE TPS4020::Location::Y TO WS-Y-PARM
             WS-CURRENT-Y.
           MOVE TPS4020::SCREEN-NAME TO SCREEN-NAME.

           MOVE TPS4020::WHICH-YEAR TO TPS4020-WHICH-YEAR.


067800                                                                                     
067900      IF TPS4020::KEY-PRESSED = "End Key"
068000          GO TO EXIT-THE-MODULE.                                                     00069800
068100                                                                                     00069900
068200      IF TPS4020::KEY-PRESSED = "F1 Key"                                                  00070000
068300          GO TO TAB-BACKWARDS.                                                       00070100
068400                                                                                     00070200
068500*     IF THEY-HIT-ENTER                                                              00070300
068600*     MOVE 1                    TO TPS4020-DISPLAY-OPTION                            00070400
068700*     MOVE 'HIT ALT-ENTER TO PROCESS DATA' TO                                        00070500
068800*                                  TPS4020::MENU-LINE                             00070600
068900*     GO TO REDISPLAY-PANEL-TPS4020.                                                 00070700
069000                                                                                     00070800
069100*07/06IF THEY-HIT-ALT-ENTER     GO TO END-OF-HOT-FIELDS.                             00070900
069200      IF TPS4020::KEY-PRESSED = "Enter Key"                                            00071000
069300        IF NOT END-OF-HOLIDAYS                                                       00071100
069500         MOVE 'PLEASE ENTER AND TAB THRU ALL HOLIDAYS' TO                            00071300
069600                                      TPS4020::MENU-LINE                          00071400
069700         GO TO REDISPLAY-PANEL-TPS4020                                               00071500
069800        ELSE                                                                         00071600
069900         GO TO END-OF-HOT-FIELDS                                                     00071700
070000        END-IF                                                                       00071800
070100      END-IF.                                                                        00071900
070200                                                                                     00072000
070300      EVALUATE TPS4020::HOT-FIELD                                                     00072100
070400          WHEN 1002
                     GO TO HOT-FIELD-1002                                     00072200
070500          WHEN 1006
                     GO TO HOT-FIELD-1006                                     00072300
070600          WHEN 1010
                     GO TO HOT-FIELD-1010                                     00072400
070700          WHEN 1014
                     GO TO HOT-FIELD-1014                                     00072500
070800          WHEN 1018
                     GO TO HOT-FIELD-1018                                     00072600
070900          WHEN 1022
                     GO TO HOT-FIELD-1022                                     00072700
071000          WHEN 1026
                     GO TO HOT-FIELD-1026                                     00072800
071100          WHEN 1030
                     GO TO HOT-FIELD-1030                                     00072900
071200          WHEN 1034
                     GO TO HOT-FIELD-1034                                     00073000
071300          WHEN 1038
                     GO TO HOT-FIELD-1038                                     00073100
071400          WHEN 1042
                     GO TO HOT-FIELD-1042                                     00073200
071500          WHEN 1046
                     GO TO HOT-FIELD-1046                                     00073300
071600          WHEN 1050
                     GO TO HOT-FIELD-1050                                     00073400
071700          WHEN 1054
                     GO TO HOT-FIELD-1054                                     00073500
071800          WHEN 1058
                     GO TO HOT-FIELD-1058                                     00073600
071900          WHEN 1062
                     GO TO HOT-FIELD-1062                                     00073700
072000      END-EVALUATE.                                                                  00073800
072100                                                                                     00073900
072300      MOVE 'PLEASE ENTER AND TAB THRU ALL HOLIDAYS' TO                               00074100
072400                                   TPS4020::MENU-LINE                             00074200
072500      GO TO REDISPLAY-PANEL-TPS4020.                                                 00074300
072600*07/06GO TO END-OF-HOT-FIELDS.                                                       00074400
072700                                                                                     00074500
072800 TAB-BACKWARDS.                                                                      00074600
072900      IF CURRENT-CURSOR > 2                                                          00074700
073000         SUBTRACT 4             FROM CURRENT-CURSOR.                                 00074800
073100      MOVE CURRENT-CURSOR       TO TPS4020::ACTIVE-FIELD.                         00074900
073300      GO TO REDISPLAY-PANEL-TPS4020.                                                 00075100
073400                                                                                     00075200

073600 HOT-FIELD-1002.                                                                     00075400
073700      MOVE 6                    TO TPS4020::ACTIVE-FIELD.                         00075500
073800      MOVE TPS4020::ACTIVE-FIELD TO CURRENT-CURSOR.                               00075600
074000      MOVE '/'                   TO TPS4020-YY(1)(1:1).                         00075800
074100      MOVE YEAR-OF-HOLIDAYS-CCYY(3:2) TO TPS4020-YY(1)(2:2).                    00075900
074200                                                                                     00076000
074300      IF TPS4020-MMDD(1)(3:2) = ZEROS                                           00076100
074400         MOVE SPACES               TO TPS4020-DAY-WEEK(1)                         00076200
074500      ELSE                                                                           00076300
074600         MOVE TPS4020-MMDD(1) TO YEAR-OF-HOLIDAYS-MMDD                          00076400
074700           PERFORM FIGURE-THE-DAY                                                    00076500
074800              THRU FIGURE-THE-DAY-EXIT                                               00076600
074900         MOVE THE-DAY              TO TPS4020-DAY-WEEK(1)                         00076700
075000      END-IF.                                                                        00076800
075100                                                                                     00076900
075200      IF TPS4020-DESCRIPTION(2) NOT = SPACES                                     00077000
075300         GO TO REDISPLAY-PANEL-TPS4020.                                              00077100
075400      MOVE 2                 TO TPS4020::ACTIVE-FIELD.                            00077200
075500      MOVE TPS4020::ACTIVE-FIELD TO CURRENT-CURSOR.                               00077300
075600      MOVE 1                 TO END-OF-HOLIDAYS-FLAG.                                00077400
075700      GO TO REDISPLAY-PANEL-TPS4020.                                                 00077500
075800                                                                                     00077600
075900 HOT-FIELD-1006.                                                                     00077700
076000      MOVE 10                   TO TPS4020::ACTIVE-FIELD.                         00077800
076100      MOVE TPS4020::ACTIVE-FIELD TO CURRENT-CURSOR.                               00077900
076300      MOVE '/'                   TO TPS4020-YY(2)(1:1).                         00078100
076400      MOVE YEAR-OF-HOLIDAYS-CCYY(3:2) TO TPS4020-YY(2)(2:2).                    00078200
076500                                                                                     00078300
076600      IF TPS4020-MMDD(2)(3:2) = ZEROS                                           00078400
076700         MOVE SPACES               TO TPS4020-DAY-WEEK(2)                         00078500
076800      ELSE                                                                           00078600
076900         MOVE TPS4020-MMDD(2) TO YEAR-OF-HOLIDAYS-MMDD                          00078700
077000           PERFORM FIGURE-THE-DAY                                                    00078800
077100              THRU FIGURE-THE-DAY-EXIT                                               00078900
077200         MOVE THE-DAY              TO TPS4020-DAY-WEEK(2)                         00079000
077300      END-IF.                                                                        00079100
077400                                                                                     00079200
077500      IF TPS4020-DESCRIPTION(3) NOT = SPACES                                     00079300
077600         GO TO REDISPLAY-PANEL-TPS4020.                                              00079400
077700      MOVE 2                 TO TPS4020::ACTIVE-FIELD.                            00079500
077800      MOVE TPS4020::ACTIVE-FIELD TO CURRENT-CURSOR.                               00079600
077900      MOVE 1                 TO END-OF-HOLIDAYS-FLAG.                                00079700
078000      GO TO REDISPLAY-PANEL-TPS4020.                                                 00079800
078100                                                                                     00079900
078200 HOT-FIELD-1010.                                                                     00080000
078300      MOVE 14                   TO TPS4020::ACTIVE-FIELD.                         00080100
078400      MOVE TPS4020::ACTIVE-FIELD TO CURRENT-CURSOR.                               00080200
078600      MOVE '/'                   TO TPS4020-YY(3)(1:1).                         00080400
078700      MOVE YEAR-OF-HOLIDAYS-CCYY(3:2) TO TPS4020-YY(3)(2:2).                    00080500
078800                                                                                     00080600
078900      IF TPS4020-MMDD(3)(3:2) = ZEROS                                           00080700
079000         MOVE SPACES               TO TPS4020-DAY-WEEK(3)                         00080800
079100      ELSE                                                                           00080900
079200         MOVE TPS4020-MMDD(3) TO YEAR-OF-HOLIDAYS-MMDD                          00081000
079300           PERFORM FIGURE-THE-DAY                                                    00081100
079400              THRU FIGURE-THE-DAY-EXIT                                               00081200
079500         MOVE THE-DAY              TO TPS4020-DAY-WEEK(3)                         00081300
079600      END-IF.                                                                        00081400
079700                                                                                     00081500
079800      IF TPS4020-DESCRIPTION(4) NOT = SPACES                                     00081600
079900         GO TO REDISPLAY-PANEL-TPS4020.                                              00081700
080000      MOVE 2                 TO TPS4020::ACTIVE-FIELD.                            00081800
080100      MOVE TPS4020::ACTIVE-FIELD TO CURRENT-CURSOR.                               00081900
080200      MOVE 1                 TO END-OF-HOLIDAYS-FLAG.                                00082000
080300      GO TO REDISPLAY-PANEL-TPS4020.                                                 00082100
080400                                                                                     00082200
080500 HOT-FIELD-1014.                                                                     00082300
080600      MOVE 18                   TO TPS4020::ACTIVE-FIELD.                         00082400
080700      MOVE TPS4020::ACTIVE-FIELD TO CURRENT-CURSOR.                               00082500
080900      MOVE '/'                   TO TPS4020-YY(4)(1:1).                         00082700
081000      MOVE YEAR-OF-HOLIDAYS-CCYY(3:2) TO TPS4020-YY(4)(2:2).                    00082800
081100                                                                                     00082900
081200      IF TPS4020-MMDD(4)(3:2) = ZEROS                                           00083000
081300         MOVE SPACES               TO TPS4020-DAY-WEEK(4)                         00083100
081400      ELSE                                                                           00083200
081500         MOVE TPS4020-MMDD(4) TO YEAR-OF-HOLIDAYS-MMDD                          00083300
081600           PERFORM FIGURE-THE-DAY                                                    00083400
081700              THRU FIGURE-THE-DAY-EXIT                                               00083500
081800         MOVE THE-DAY              TO TPS4020-DAY-WEEK(4)                         00083600
081900      END-IF.                                                                        00083700
082000                                                                                     00083800
082100      IF TPS4020-DESCRIPTION(5) NOT = SPACES                                     00083900
082200         GO TO REDISPLAY-PANEL-TPS4020.                                              00084000
082300      MOVE 2                 TO TPS4020::ACTIVE-FIELD.                            00084100
082400      MOVE TPS4020::ACTIVE-FIELD TO CURRENT-CURSOR.                               00084200
082500      MOVE 1                 TO END-OF-HOLIDAYS-FLAG.                                00084300
082600      GO TO REDISPLAY-PANEL-TPS4020.                                                 00084400
082700                                                                                     00084500
082800 HOT-FIELD-1018.                                                                     00084600
082900      MOVE 22                   TO TPS4020::ACTIVE-FIELD.                         00084700
083000      MOVE TPS4020::ACTIVE-FIELD TO CURRENT-CURSOR.                               00084800
083200      MOVE '/'                   TO TPS4020-YY(5)(1:1).                         00085000
083300      MOVE YEAR-OF-HOLIDAYS-CCYY(3:2) TO TPS4020-YY(5)(2:2).                    00085100
083400                                                                                     00085200
083500      IF TPS4020-MMDD(5)(3:2) = ZEROS                                           00085300
083600         MOVE SPACES               TO TPS4020-DAY-WEEK(5)                         00085400
083700      ELSE                                                                           00085500
083800         MOVE TPS4020-MMDD(5) TO YEAR-OF-HOLIDAYS-MMDD                          00085600
083900           PERFORM FIGURE-THE-DAY                                                    00085700
084000              THRU FIGURE-THE-DAY-EXIT                                               00085800
084100         MOVE THE-DAY              TO TPS4020-DAY-WEEK(5)                         00085900
084200      END-IF.                                                                        00086000
084300                                                                                     00086100
084400      IF TPS4020-DESCRIPTION(6) NOT = SPACES                                     00086200
084500         GO TO REDISPLAY-PANEL-TPS4020.                                              00086300
084600      MOVE 2                 TO TPS4020::ACTIVE-FIELD.                            00086400
084700      MOVE TPS4020::ACTIVE-FIELD TO CURRENT-CURSOR.                               00086500
084800      MOVE 1                 TO END-OF-HOLIDAYS-FLAG.                                00086600
084900      GO TO REDISPLAY-PANEL-TPS4020.                                                 00086700
085000                                                                                     00086800
085100 HOT-FIELD-1022.                                                                     00086900
085200      MOVE 26                   TO TPS4020::ACTIVE-FIELD.                         00087000
085300      MOVE TPS4020::ACTIVE-FIELD TO CURRENT-CURSOR.                               00087100
085500      MOVE '/'                   TO TPS4020-YY(6)(1:1).                         00087300
085600      MOVE YEAR-OF-HOLIDAYS-CCYY(3:2) TO TPS4020-YY(6)(2:2).                    00087400
085700                                                                                     00087500
085800      IF TPS4020-MMDD(6)(3:2) = ZEROS                                           00087600
085900         MOVE SPACES               TO TPS4020-DAY-WEEK(6)                         00087700
086000      ELSE                                                                           00087800
086100         MOVE TPS4020-MMDD(6) TO YEAR-OF-HOLIDAYS-MMDD                          00087900
086200           PERFORM FIGURE-THE-DAY                                                    00088000
086300              THRU FIGURE-THE-DAY-EXIT                                               00088100
086400         MOVE THE-DAY              TO TPS4020-DAY-WEEK(6)                         00088200
086500      END-IF.                                                                        00088300
086600                                                                                     00088400
086700      IF TPS4020-DESCRIPTION(7) NOT = SPACES                                     00088500
086800         GO TO REDISPLAY-PANEL-TPS4020.                                              00088600
086900      MOVE 2                 TO TPS4020::ACTIVE-FIELD.                            00088700
087000      MOVE TPS4020::ACTIVE-FIELD TO CURRENT-CURSOR.                               00088800
087100      MOVE 1                 TO END-OF-HOLIDAYS-FLAG.                                00088900
087200      GO TO REDISPLAY-PANEL-TPS4020.                                                 00089000
087300                                                                                     00089100
087400 HOT-FIELD-1026.                                                                     00089200
087500      MOVE 30                   TO TPS4020::ACTIVE-FIELD.                         00089300
087600      MOVE TPS4020::ACTIVE-FIELD TO CURRENT-CURSOR.                               00089400
087800      MOVE '/'                   TO TPS4020-YY(7)(1:1).                         00089600
087900      MOVE YEAR-OF-HOLIDAYS-CCYY(3:2) TO TPS4020-YY(7)(2:2).                    00089700
088000                                                                                     00089800
088100      IF TPS4020-MMDD(7)(3:2) = ZEROS                                           00089900
088200         MOVE SPACES               TO TPS4020-DAY-WEEK(7)                         00090000
088300      ELSE                                                                           00090100
088400         MOVE TPS4020-MMDD(7) TO YEAR-OF-HOLIDAYS-MMDD                          00090200
088500           PERFORM FIGURE-THE-DAY                                                    00090300
088600              THRU FIGURE-THE-DAY-EXIT                                               00090400
088700         MOVE THE-DAY              TO TPS4020-DAY-WEEK(7)                         00090500
088800      END-IF.                                                                        00090600
088900                                                                                     00090700
089000      IF TPS4020-DESCRIPTION(8) NOT = SPACES                                     00090800
089100         GO TO REDISPLAY-PANEL-TPS4020.                                              00090900
089200      MOVE 2                 TO TPS4020::ACTIVE-FIELD.                            00091000
089300      MOVE TPS4020::ACTIVE-FIELD TO CURRENT-CURSOR.                               00091100
089400      MOVE 1                 TO END-OF-HOLIDAYS-FLAG.                                00091200
089500      GO TO REDISPLAY-PANEL-TPS4020.                                                 00091300
089600                                                                                     00091400
089700 HOT-FIELD-1030.                                                                     00091500
089800      MOVE 34                   TO TPS4020::ACTIVE-FIELD.                         00091600
089900      MOVE TPS4020::ACTIVE-FIELD TO CURRENT-CURSOR.                               00091700
090100      MOVE '/'                   TO TPS4020-YY(8)(1:1).                         00091900
090200      MOVE YEAR-OF-HOLIDAYS-CCYY(3:2) TO TPS4020-YY(8)(2:2).                    00092000
090300                                                                                     00092100
090400      IF TPS4020-MMDD(8)(3:2) = ZEROS                                           00092200
090500         MOVE SPACES               TO TPS4020-DAY-WEEK(8)                         00092300
090600      ELSE                                                                           00092400
090700         MOVE TPS4020-MMDD(8) TO YEAR-OF-HOLIDAYS-MMDD                          00092500
090800           PERFORM FIGURE-THE-DAY                                                    00092600
090900              THRU FIGURE-THE-DAY-EXIT                                               00092700
091000         MOVE THE-DAY              TO TPS4020-DAY-WEEK(8)                         00092800
091100      END-IF.                                                                        00092900
091200                                                                                     00093000
091300      IF TPS4020-DESCRIPTION(9) NOT = SPACES                                     00093100
091400         GO TO REDISPLAY-PANEL-TPS4020.                                              00093200
091500      MOVE 2                 TO TPS4020::ACTIVE-FIELD.                            00093300
091600      MOVE TPS4020::ACTIVE-FIELD TO CURRENT-CURSOR.                               00093400
091700      MOVE 1                 TO END-OF-HOLIDAYS-FLAG.                                00093500
091800      GO TO REDISPLAY-PANEL-TPS4020.                                                 00093600
091900                                                                                     00093700
092000 HOT-FIELD-1034.                                                                     00093800
092100      MOVE 38                   TO TPS4020::ACTIVE-FIELD.                         00093900
092200      MOVE TPS4020::ACTIVE-FIELD TO CURRENT-CURSOR.                               00094000
092400      MOVE '/'                   TO TPS4020-YY(9)(1:1).                         00094200
092500      MOVE YEAR-OF-HOLIDAYS-CCYY(3:2) TO TPS4020-YY(9)(2:2).                    00094300
092600                                                                                     00094400
092700      IF TPS4020-MMDD(9)(3:2) = ZEROS                                           00094500
092800         MOVE SPACES               TO TPS4020-DAY-WEEK(9)                         00094600
092900      ELSE                                                                           00094700
093000         MOVE TPS4020-MMDD(9) TO YEAR-OF-HOLIDAYS-MMDD                          00094800
093100           PERFORM FIGURE-THE-DAY                                                    00094900
093200              THRU FIGURE-THE-DAY-EXIT                                               00095000
093300         MOVE THE-DAY              TO TPS4020-DAY-WEEK(9)                         00095100
093400      END-IF.                                                                        00095200
093500                                                                                     00095300
093600      IF TPS4020-DESCRIPTION(10) NOT = SPACES                                     00095400
093700         GO TO REDISPLAY-PANEL-TPS4020.                                              00095500
093800      MOVE 2                 TO TPS4020::ACTIVE-FIELD.                            00095600
093900      MOVE TPS4020::ACTIVE-FIELD TO CURRENT-CURSOR.                               00095700
094000      MOVE 1                 TO END-OF-HOLIDAYS-FLAG.                                00095800
094100      GO TO REDISPLAY-PANEL-TPS4020.                                                 00095900
094200                                                                                     00096000
094300 HOT-FIELD-1038.                                                                     00096100
094400      MOVE 42                   TO TPS4020::ACTIVE-FIELD.                         00096200
094500      MOVE TPS4020::ACTIVE-FIELD TO CURRENT-CURSOR.                               00096300
094700      MOVE '/'                   TO TPS4020-YY(10)(1:1).                         00096500
094800      MOVE YEAR-OF-HOLIDAYS-CCYY(3:2) TO TPS4020-YY(10)(2:2).                    00096600
094900                                                                                     00096700
095000      IF TPS4020-MMDD(10)(3:2) = ZEROS                                           00096800
095100         MOVE SPACES               TO TPS4020-DAY-WEEK(10)                         00096900
095200      ELSE                                                                           00097000
095300         MOVE TPS4020-MMDD(10) TO YEAR-OF-HOLIDAYS-MMDD                          00097100
095400           PERFORM FIGURE-THE-DAY                                                    00097200
095500              THRU FIGURE-THE-DAY-EXIT                                               00097300
095600         MOVE THE-DAY              TO TPS4020-DAY-WEEK(10)                         00097400
095700      END-IF.                                                                        00097500
095800                                                                                     00097600
095900      IF TPS4020-DESCRIPTION(11) NOT = SPACES                                     00097700
096000         GO TO REDISPLAY-PANEL-TPS4020.                                              00097800
096100      MOVE 2                 TO TPS4020::ACTIVE-FIELD.                            00097900
096200      MOVE TPS4020::ACTIVE-FIELD TO CURRENT-CURSOR.                               00098000
096300      MOVE 1                 TO END-OF-HOLIDAYS-FLAG.                                00098100
096400      GO TO REDISPLAY-PANEL-TPS4020.                                                 00098200
096500                                                                                     00098300
096600 HOT-FIELD-1042.                                                                     00098400
096700      MOVE 46                   TO TPS4020::ACTIVE-FIELD.                         00098500
096800      MOVE TPS4020::ACTIVE-FIELD TO CURRENT-CURSOR.                               00098600
097000      MOVE '/'                   TO TPS4020-YY(11)(1:1).                         00098800
097100      MOVE YEAR-OF-HOLIDAYS-CCYY(3:2) TO TPS4020-YY(11)(2:2).                    00098900
097200                                                                                     00099000
097300      IF TPS4020-MMDD(11)(3:2) = ZEROS                                           00099100
097400         MOVE SPACES               TO TPS4020-DAY-WEEK(11)                         00099200
097500      ELSE                                                                           00099300
097600         MOVE TPS4020-MMDD(11) TO YEAR-OF-HOLIDAYS-MMDD                          00099400
097700           PERFORM FIGURE-THE-DAY                                                    00099500
097800              THRU FIGURE-THE-DAY-EXIT                                               00099600
097900         MOVE THE-DAY              TO TPS4020-DAY-WEEK(11)                         00099700
098000      END-IF.                                                                        00099800
098100                                                                                     00099900
098200      IF TPS4020-DESCRIPTION(12) NOT = SPACES                                     00100000
098300         GO TO REDISPLAY-PANEL-TPS4020.                                              00100100
098400      MOVE 2                 TO TPS4020::ACTIVE-FIELD.                            00100200
098500      MOVE TPS4020::ACTIVE-FIELD TO CURRENT-CURSOR.                               00100300
098600      MOVE 1                 TO END-OF-HOLIDAYS-FLAG.                                00100400
098700      GO TO REDISPLAY-PANEL-TPS4020.                                                 00100500
098800                                                                                     00100600
098900 HOT-FIELD-1046.                                                                     00100700
099000      MOVE 50                   TO TPS4020::ACTIVE-FIELD.                         00100800
099100      MOVE TPS4020::ACTIVE-FIELD TO CURRENT-CURSOR.                               00100900
099300      MOVE '/'                   TO TPS4020-YY(12)(1:1).                         00101100
099400      MOVE YEAR-OF-HOLIDAYS-CCYY(3:2) TO TPS4020-YY(12)(2:2).                    00101200
099500                                                                                     00101300
099600      IF TPS4020-MMDD(12)(3:2) = ZEROS                                           00101400
099700         MOVE SPACES               TO TPS4020-DAY-WEEK(12)                         00101500
099800      ELSE                                                                           00101600
099900         MOVE TPS4020-MMDD(12) TO YEAR-OF-HOLIDAYS-MMDD                          00101700
100000           PERFORM FIGURE-THE-DAY                                                    00101800
100100              THRU FIGURE-THE-DAY-EXIT                                               00101900
100200         MOVE THE-DAY              TO TPS4020-DAY-WEEK(12)                         00102000
100300      END-IF.                                                                        00102100
100400                                                                                     00102200
100500      IF TPS4020-DESCRIPTION(13) NOT = SPACES                                     00102300
100600         GO TO REDISPLAY-PANEL-TPS4020.                                              00102400
100700      MOVE 2                 TO TPS4020::ACTIVE-FIELD.                            00102500
100800      MOVE TPS4020::ACTIVE-FIELD TO CURRENT-CURSOR.                               00102600
100900      MOVE 1                 TO END-OF-HOLIDAYS-FLAG.                                00102700
101000      GO TO REDISPLAY-PANEL-TPS4020.                                                 00102800
101100                                                                                     00102900
101200 HOT-FIELD-1050.                                                                     00103000
101300      MOVE 54                   TO TPS4020::ACTIVE-FIELD.                         00103100
101400      MOVE TPS4020::ACTIVE-FIELD TO CURRENT-CURSOR.                               00103200
101600      MOVE '/'                   TO TPS4020-YY(13)(1:1).                         00103400
101700      MOVE YEAR-OF-HOLIDAYS-CCYY(3:2) TO TPS4020-YY(13)(2:2).                    00103500
101800                                                                                     00103600
101900      IF TPS4020-MMDD(13)(3:2) = ZEROS                                           00103700
102000         MOVE SPACES               TO TPS4020-DAY-WEEK(13)                         00103800
102100      ELSE                                                                           00103900
102200         MOVE TPS4020-MMDD(13) TO YEAR-OF-HOLIDAYS-MMDD                          00104000
102300           PERFORM FIGURE-THE-DAY                                                    00104100
102400              THRU FIGURE-THE-DAY-EXIT                                               00104200
102500         MOVE THE-DAY              TO TPS4020-DAY-WEEK(13)                         00104300
102600      END-IF.                                                                        00104400
102700                                                                                     00104500
102800      IF TPS4020-DESCRIPTION(14) NOT = SPACES                                     00104600
102900         GO TO REDISPLAY-PANEL-TPS4020.                                              00104700
103000      MOVE 2                 TO TPS4020::ACTIVE-FIELD.                            00104800
103100      MOVE TPS4020::ACTIVE-FIELD TO CURRENT-CURSOR.                               00104900
103200      MOVE 1                 TO END-OF-HOLIDAYS-FLAG.                                00105000
103300      GO TO REDISPLAY-PANEL-TPS4020.                                                 00105100
103400                                                                                     00105200
103500 HOT-FIELD-1054.                                                                     00105300
103600      MOVE 58                   TO TPS4020::ACTIVE-FIELD.                         00105400
103700      MOVE TPS4020::ACTIVE-FIELD TO CURRENT-CURSOR.                               00105500
103900      MOVE '/'                   TO TPS4020-YY(14)(1:1).                         00105700
104000      MOVE YEAR-OF-HOLIDAYS-CCYY(3:2) TO TPS4020-YY(14)(2:2).                    00105800
104100                                                                                     00105900
104200      IF TPS4020-MMDD(14)(3:2) = ZEROS                                           00106000
104300         MOVE SPACES               TO TPS4020-DAY-WEEK(14)                         00106100
104400      ELSE                                                                           00106200
104500         MOVE TPS4020-MMDD(14) TO YEAR-OF-HOLIDAYS-MMDD                          00106300
104600           PERFORM FIGURE-THE-DAY                                                    00106400
104700              THRU FIGURE-THE-DAY-EXIT                                               00106500
104800         MOVE THE-DAY              TO TPS4020-DAY-WEEK(14)                         00106600
104900      END-IF.                                                                        00106700
105000                                                                                     00106800
105100      IF TPS4020-DESCRIPTION(15) NOT = SPACES                                     00106900
105200         GO TO REDISPLAY-PANEL-TPS4020.                                              00107000
105300      MOVE 2                 TO TPS4020::ACTIVE-FIELD.                            00107100
105400      MOVE TPS4020::ACTIVE-FIELD TO CURRENT-CURSOR.                               00107200
105500      MOVE 1                 TO END-OF-HOLIDAYS-FLAG.                                00107300
105600      GO TO REDISPLAY-PANEL-TPS4020.                                                 00107400
105700                                                                                     00107500
105800 HOT-FIELD-1058.                                                                     00107600
105900      MOVE 62                   TO TPS4020::ACTIVE-FIELD.                         00107700
106000      MOVE TPS4020::ACTIVE-FIELD TO CURRENT-CURSOR.                               00107800
106200      MOVE '/'                   TO TPS4020-YY(15)(1:1).                         00108000
106300      MOVE YEAR-OF-HOLIDAYS-CCYY(3:2) TO TPS4020-YY(15)(2:2).                    00108100
106400                                                                                     00108200
106500      IF TPS4020-MMDD(15)(3:2) = ZEROS                                           00108300
106600         MOVE SPACES               TO TPS4020-DAY-WEEK(15)                         00108400
106700      ELSE                                                                           00108500
106800         MOVE TPS4020-MMDD(15) TO YEAR-OF-HOLIDAYS-MMDD                          00108600
106900           PERFORM FIGURE-THE-DAY                                                    00108700
107000              THRU FIGURE-THE-DAY-EXIT                                               00108800
107100         MOVE THE-DAY              TO TPS4020-DAY-WEEK(15)                         00108900
107200      END-IF.                                                                        00109000
107300                                                                                     00109100
107400      IF TPS4020-DESCRIPTION(16) NOT = SPACES                                     00109200
107500         GO TO REDISPLAY-PANEL-TPS4020.                                              00109300
107600      MOVE 2                 TO TPS4020::ACTIVE-FIELD.                            00109400
107700      MOVE TPS4020::ACTIVE-FIELD TO CURRENT-CURSOR.                               00109500
107800      MOVE 1                 TO END-OF-HOLIDAYS-FLAG.                                00109600
107900      GO TO REDISPLAY-PANEL-TPS4020.                                                 00109700
108000                                                                                     00109800
108100 HOT-FIELD-1062.                                                                     00109900
108200      MOVE 2                    TO TPS4020::ACTIVE-FIELD.                         00110000
108300      MOVE TPS4020::ACTIVE-FIELD TO CURRENT-CURSOR.                               00110100
108500      MOVE '/'                   TO TPS4020-YY(16)(1:1).                         00110300
108600      MOVE YEAR-OF-HOLIDAYS-CCYY(3:2) TO TPS4020-YY(16)(2:2).                    00110400
108700                                                                                     00110500
108800      IF TPS4020-MMDD(16)(3:2) = ZEROS                                           00110600
108900         MOVE SPACES               TO TPS4020-DAY-WEEK(16)                         00110700
109000      ELSE                                                                           00110800
109100         MOVE TPS4020-MMDD(16) TO YEAR-OF-HOLIDAYS-MMDD                          00110900
109200           PERFORM FIGURE-THE-DAY                                                    00111000
109300              THRU FIGURE-THE-DAY-EXIT                                               00111100
109400         MOVE THE-DAY              TO TPS4020-DAY-WEEK(16)                         00111200
109500      END-IF.                                                                        00111300
109600                                                                                     00111400
109700      MOVE 1                    TO END-OF-HOLIDAYS-FLAG.                             00111500
109800      GO TO REDISPLAY-PANEL-TPS4020.                                                 00111600
109900                                                                                     00111700
110000 END-OF-HOT-FIELDS.                                                                  00111800
110100         MOVE 0                 TO END-OF-HOLIDAYS-FLAG.                             00111900
110200         PERFORM VARYING THE-INDEX FROM 1 BY 1                                       00112000
110300                  UNTIL THE-INDEX > 16                                               00112100
110400         IF TPS4020-MMDD(THE-INDEX) = '0000'                                        00112200
110500           IF HOLIDAY-DATE(HOLIDAY-INDEX)  = '9999'                                  00112300
110600              GO TO WRITE-THE-HOLIDAYS                                               00112400
110700           END-IF                                                                    00112500
110800              ADD 1            TO PANEL-IDX                                          00112600
110900              MOVE HIGH-VALUES TO PANEL-DAY-MMDD(PANEL-IDX)(1:46)                    00112700
064100*10/25/06 ADD MOVE 0           TO ALT-INDEX                                          00065900
064100              MOVE 0           TO ALT-INDEX                                          00065900
111000              GO TO NEXT-PANEL-OF-HOLIDAYS                                           00112800
111100         END-IF                                                                      00112900
111200         ADD 1                  TO PANEL-IDX                                         00113000
111300         MOVE TPS4020-MMDD(THE-INDEX)(1:46) TO                                      00113100
111400                        PANEL-DAY-MMDD(PANEL-IDX)(1:46)                              00113200
111500         MOVE TPS4020-MMDD(THE-INDEX)(1:4) TO                                       00113300
111600                        SAVE-PREV-DAY-MMDD                                           00113400
111700         MOVE ZEROS             TO TPS4020-MMDD(THE-INDEX)                          00113500
111800         MOVE SPACES            TO TPS4020-YY(THE-INDEX)                            00113600
111900         MOVE SPACES            TO TPS4020-DAY-WEEK(THE-INDEX)                       00113700
112000         MOVE SPACES            TO TPS4020-DESCRIPTION(THE-INDEX)                      00113800
112100      END-PERFORM.                                                                   00113900
112200                                                                                     00114000
112300      MOVE ZEROS                TO WS-PREV-DAY-MMDD.                                 00114100
112400      MOVE 0                    TO ALT-INDEX.                                        00114200
112500     IF HOLIDAY-DATE(HOLIDAY-INDEX)  = '9999'                                        00114300
112600              GO TO WRITE-THE-HOLIDAYS.                                              00114400
112700      GO TO NEXT-PANEL-OF-HOLIDAYS.                                                  00114500
112800                                                                                     00114600
112900 WRITE-THE-HOLIDAYS.                                                                 00114700
113000         PERFORM VARYING PANEL-IDX FROM 1 BY 1                                       00114800
113100                  UNTIL PANEL-DAY-MMDD(PANEL-IDX) = HIGH-VALUES                      00114900
113200                                                                                     00115000
113300      MOVE '9999999999'           TO CAL-KEY-ACCT-NO                                 00115100
113400      MOVE '00'                   TO CAL-KEY-SUB-ACCT                                00115200
113500      MOVE 11                   TO WS-DATE-PARAM                                     00115300
113600      MOVE PANEL-DAY-MMDD(PANEL-IDX)(1:2)                                            00115400
113700                                TO WS-DATE-REFORM(1:2)                               00115500
113800      MOVE PANEL-DAY-MMDD(PANEL-IDX)(3:2)                                            00115600
113900                                TO WS-DATE-REFORM(3:2)                               00115700
114000      MOVE PANEL-DAY-MMDD(PANEL-IDX)(6:2)                                            00115800
114100                                TO WS-DATE-REFORM(5:2)                               00115900
114200      MOVE SPACES               TO WS-DATE-EXTEND                                    00116000
114300         CALL TPSDATES USING WS-DATE-REQUEST                                         00116100
114400      MOVE WS-DATE-REFORM-LEN08 TO CAL-KEY-DATE                                      00116200
114500                                                                                     00116300
114600      IF CAL-KEY-DATE NOT = SAV-CAL-KEY-DATE                                         00116400
114700         MOVE CAL-KEY-DATE     TO  SAV-CAL-KEY-DATE                                  00116500
114800         MOVE '0001'           TO CAL-KEY-RECORD-NUMBER                              00116600
114900      ELSE                                                                           00116700
115000         ADD 1                 TO CAL-KEY-RECORD-NUMBER                              00116800
115100      END-IF                                                                         00116900
115200      MOVE '01'                   TO CAL-KEY-SUB-RECORD-NUMBER                       00117000
115300                                                                                     00117100
115400      MOVE '08'                   TO CAL-RECORD-TYPE                                 00117200
115500      MOVE SPACES                 TO CAL-VARIABLE                                    00117300
115600      MOVE 'Event: '         TO CAL-APPT-APPOINT-DATA(1:07)                          00117400
115700      MOVE PANEL-DAY-DESCRIPT(PANEL-IDX)(1:30) TO                                    00117500
115800                                CAL-APPT-APPOINT-DATA(8:30)                          00117600
115900      MOVE LOGREC-SIGN-ON     TO CAL-APPT-ADD-PASSWORD                               00117700
116000      MOVE WS-TODAYS-DATE-CYMD TO                                                    00117800
116100                          CAL-APPT-ADD-DATE                                          00117900
116200      MOVE LOGREC-SIGN-ON    TO CAL-APPT-CHANGE-PASSWORD                             00118000
116300      MOVE WS-TODAYS-DATE-CYMD TO                                                    00118100
116400                          CAL-APPT-CHANGE-DATE                                       00118200
116500      PERFORM WRITE-THE-CALENDAR THRU                                                00118300
116600              WRITE-THE-CALENDAR-EXIT                                                00118400
116700      END-PERFORM.                                                                   00118500
116800      GO TO JUST-PAINT-TPS4020.                                                      00118600
116900***** GO TO EXIT-THE-MODULE.                                                         00118700
117000                                                                                     00118800
117100                                                                                     00118900
117200 RETRIEVE-THE-HOLIDAYS.                                                              00119000
117300      MOVE HIGH-VALUES          TO RECORD-SAVE.                                      00119100
117400                                                                                     00119200
117500      MOVE '9999999999'         TO CAL-KEY-ACCT-NO.                                  00119300
117600      MOVE '00'                 TO CAL-KEY-SUB-ACCT.                                 00119400
117700      MOVE ZEROS                TO CAL-KEY-DATE                                      00119500
117800                                   CAL-KEY-RECORD-NUMBER                             00119600
117900                                   CAL-KEY-SUB-RECORD-NUMBER.                        00119700
118000      MOVE YEAR-OF-HOLIDAYS-CCYY TO CAL-KEY-DATE(1:4).                               00119800
118100                                                                                     00119900
118200      MOVE F-PRIME      TO FILE-KEY.                                                 00120000
118300      MOVE F-START      TO FILE-ACTION.                                              00120100
118400      CALL TPSIO018 USING FILE-REQUEST TPS-CALENDAR-REC.                             00120200
118500      IF FILE-STATUS NOT = '00' AND '05'                                             00120300
118600         MOVE 'TPS4020 ' TO FILE-NAME                                                00120400
118700         MOVE 'START   ' TO FILE-TEXT                                                00120500
118800         PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                     00120600
118900         GO TO EXIT-THE-MODULE.                                                      00120700
119000                                                                                     00120800
119100*HERE                                                                                00120900
119200                                                                                     00121000
119300      MOVE 0                    TO RECORD-IDX.                                       00121100
119400      MOVE 0                    TO ALT-INDEX.                                        00121200
119500***   SET HOLIDAY-INDEX         TO ALT-INDEX.                                        00121300
119600      MOVE ZEROS                TO WS-PREV-DAY-MMDD.                                 00121400
119700      MOVE 1                    TO POINTER-IDX.                                      00121500
119800      MOVE ZEROS                TO WK-INDEX.                                         00121600
119900      MOVE '0001'               TO PANEL-IDX-POINTER(POINTER-IDX).                   00121700
120000                                                                                     00121800
120100                                                                                     00121900
120200 READ-ALL-HOLIDAYS.                                                                  00122000
120300      MOVE F-PRIME      TO FILE-KEY.                                                 00122100
120400      MOVE F-READ-NEXT  TO FILE-ACTION.                                              00122200
120500      CALL TPSIO018 USING FILE-REQUEST TPS-CALENDAR-REC.                             00122300
120600      IF FILE-STATUS NOT = '00' AND '05' AND '10'                                    00122400
120700         MOVE 'TPS4020 ' TO FILE-NAME                                                00122500
120800         MOVE 'READ-NEXT' TO FILE-TEXT                                               00122600
120900         PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                     00122700
121000         GO TO EXIT-THE-MODULE.                                                      00122800
121100***************************************************************
      ****** READS ALL HOLI REC  NEED CHCK CAL-APPT-ADD-DATE = '9'  *
      ****** 9=DELETE REC IF COUNTER IS ZERO THEN PERFORM NEW YEAR **
      ***************************************************************
121200      IF CAL-KEY = HIGH-VALUES                                                       00123000
121300***      IF RECORD-IDX NOT = PANEL-IDX-POINTER(POINTER-IDX)                          00123100
121400***         SET POINTER-IDX UP BY 1                                                  00123200
121500***         MOVE RECORD-IDX     TO PANEL-IDX-POINTER(POINTER-IDX)                    00123300
121600***      END-IF                                                                      00123400
121700         MOVE 1                 TO RECORD-IDX                                        00123500
121800         MOVE 0                 TO ALT-INDEX                                         00123600
121900         MOVE RECORD-IDX        TO START-RECORD-IDX                                  00123700
122000         MOVE ALT-INDEX         TO START-ALT-INDEX                                   00123800
122100         MOVE 1                 TO POINTER-IDX                                       00123900
122200         MOVE PANEL-IDX-POINTER(POINTER-IDX)                                         00124000
122300                                TO RECORD-IDX                                        00124100
122400         GO TO HAVE-ALL-HOLIDAYS.                                                    00124200
122500                                                                                     00124300
122600****  IF CAL-APPT-APPOINT-DATA(8:08) = 'Daylight'                                    00124400
122700****     move 'd'   TO CAL-APPT-APPOINT-DATA(8:01).                                  00124500
122800                                                                                     00124600
122900      IF NOT CAL-HOLIDAY-REC                                                         00124700
123000         GO TO READ-ALL-HOLIDAYS.

      **  ADD COUNTER OF HOLIDAYS TO DISPLAY JA 2/12/2014
            IF CAL-APPT-ADD-DATE(1:1) NOT = '9'                                            00125000
123400          ADD 1 TO CHECK-HOLI-DISPLAY-CNT.                                           00125200
123100                                                                                     00124900
123200      IF CAL-APPT-ADD-DATE(1:1) = '8' or '9'                                         00125000
123300         GO TO READ-ALL-HOLIDAYS.                                                    00125100
123500      IF CAL-KEY-DATE-DD = '99'                                                      00125300
123600         GO TO READ-ALL-HOLIDAYS.                                                    00125400
123700                                                                                     00125500
123800      IF YEAR-OF-HOLIDAYS-CCYY NOT = CAL-KEY-DATE(1:4)                               00125600
123900         GO TO READ-ALL-HOLIDAYS.                                                    00125700

124000                                                                                     00125800
124100      SET RECORD-IDX  UP BY 1.                                                       00125900
124200      SET WK-INDEX    UP BY 1.                                                       00126000
124300      IF WK-INDEX = 17                                                               00126100
124400         SET POINTER-IDX UP BY 1                                                     00126200
124500         MOVE RECORD-IDX       TO PANEL-IDX-POINTER(POINTER-IDX)                     00126300
124600         MOVE 1                TO WK-INDEX.                                          00126400
124700                                                                                     00126500
124800      MOVE '0'                 TO RECORD-ACTION-CODE(RECORD-IDX).                    00126600
124900      MOVE '00000000'          TO RECORD-KEY-DATE-OLD(RECORD-IDX).                   00126700
125000      MOVE CAL-KEY             TO RECORD-KEY(RECORD-IDX).                            00126800
125100      MOVE CAL-APPT-APPOINT-DATA(8:30)                                               00126900
125200                         TO RECORD-DAY-DESCRIPT(RECORD-IDX).                         00127000
125300      IF RECORD-IDX NOT > 100                                                        00127100
125400         GO TO READ-ALL-HOLIDAYS.                                                    00127200
125500                                                                                     00127300
125600      STOP RUN.                                                                      00127400
125700                                                                                     00127500
125800                                                                                     00127600
125900 HAVE-ALL-HOLIDAYS.
      **  ADD CHECK FOR NO HOLIDAYS RECORDS TO DISPLAY JA 2/12/2014
123400      IF CHECK-HOLI-DISPLAY-CNT = ZERO                                               00125200
               GO TO NEW-YEAR-OF-HOLIDAYS.                                                 00062000
126000      SET ALT-INDEX  UP BY 1.                                                        00127800
126100                                                                                     00127900
126200*LOAD-HOLIDAYS-IN-PANEL.                                                             00128000
126300      MOVE 05                      TO WS-DATE-PARAM.                                 00128100
126400      MOVE SPACES                  TO WS-DATE-EXTEND.                                00128200
126500      MOVE RECORD-KEY-DATE(RECORD-IDX)(3:6)                                          00128300
126600                                   TO WS-DATE-REFORM(1:6).                           00128400
126700          CALL TPSDATES USING WS-DATE-REQUEST.

126800      MOVE WS-DATE-REFORM-LEN08(1:2)    TO                                                00128600
126900                          TPS4022-MMDDYY(ALT-INDEX)(1:2).                             00128700
127000      MOVE '/'  TO TPS4022-MMDDYY(ALT-INDEX)(3:1)
126800      MOVE WS-DATE-REFORM-LEN08(3:2)    TO                                                00128600
126900                          TPS4022-MMDDYY(ALT-INDEX)(4:2). 
             MOVE '/'  TO TPS4022-MMDDYY(ALT-INDEX)(6:1)
126800      MOVE WS-DATE-REFORM-LEN08(5:2)    TO                                                00128600
126900                          TPS4022-MMDDYY(ALT-INDEX)(7:2). 
127100      IF RECORD-KEY-DATE(RECORD-IDX)(7:2) = ZEROS                                    00128900
127200         MOVE SPACES        TO TPS4022-DAY-WEEK(ALT-INDEX)                       00129000
127300      ELSE                                                                           00129100
127400         MOVE RECORD-KEY-DATE(RECORD-IDX)(5:4)                                       00129200
127500                            TO YEAR-OF-HOLIDAYS-MMDD                                 00129300
127600          PERFORM FIGURE-THE-DAY                                                     00129400
127700             THRU FIGURE-THE-DAY-EXIT                                                00129500
127800          MOVE THE-DAY      TO TPS4022-DAY-WEEK(ALT-INDEX)                       00129600
127900      END-IF.                                                                        00129700
128000                                                                                     00129800
128100      MOVE RECORD-DAY-DESCRIPT(RECORD-IDX)                                           00129900
128200                         TO TPS4022-DESCRIPTION(ALT-INDEX).                         00130000
128300      MOVE SPACES               TO TPS4022-DELETE(ALT-INDEX).                    00130100
128400***   MOVE SAVE-PREV-DAY-MMDD   TO WS-PREV-DAY-MMDD.                                 00130200
128500                                                                                     00130300
128600      IF RECORD-ACTION-NONE(RECORD-IDX)                                              00130400
128700         MOVE SPACES            TO TPS4022-DELETE(ALT-INDEX)                     00130500
128800      ELSE                                                                           00130600
128900      IF RECORD-ACTION-MODIFY(RECORD-IDX)                                            00130700
129000         MOVE 'MODIFIED  '      TO TPS4022-DELETE(ALT-INDEX)                     00130800
129100      ELSE                                                                           00130900
129200      IF RECORD-ACTION-DELETE(RECORD-IDX)                                            00131000
129300         MOVE 'DELETED   '      TO TPS4022-DELETE(ALT-INDEX)                     00131100
129400      ELSE                                                                           00131200
129500         MOVE SPACES            TO TPS4022-DELETE(ALT-INDEX)                     00131300
129600      END-IF.                                                                        00131400
129700                                                                                     00131500
129800*QQQQQQQQQQ                                                                          00131600
129900                                                                                     00131700
130000      SET RECORD-IDX UP BY 1.                                                        00131800
130100                                                                                     00131900
130200      IF RECORD-KEY(RECORD-IDX) = HIGH-VALUES 
               MOVE 2    TO TPS4022::ACTIVE-FIELD                                                                         00132000
130300        GO TO DISPLAY-PANEL-TPS4022.                                                 00132100
130400                                                                                     00132200
130500*11/02IF ALT-INDEX  NOT > 16                                                         00132300
130500      IF ALT-INDEX  < 16                                                                                          
130600         GO TO HAVE-ALL-HOLIDAYS.                                                    00132400
130700                                                                                     00132500
130800      MOVE 2               TO TPS4022::ACTIVE-FIELD.                         00132600

131000                                                                                     00132800
131100 DISPLAY-PANEL-TPS4022.                                                              00132900
131200                                                                                     00133000
072200*05/18/10    add comment on how to add holiday                                       00074000

072300      MOVE 'F1-EDIT, F2-DELETE, PAGE UP/DOWN, END TO ADD' TO                                            
072400                                   TPS4022::MENU-LINE.                            

           MOVE 0 TO TPS4022-IDX.
           PERFORM VARYING THE-IDX-2 FROM 1 BY 1
             UNTIL THE-IDX-2 > 16
               MOVE TPS4022-MMDDYY(THE-IDX-2) TO
                 TPS4022::MMDDYY(TPS4022-IDX)
               MOVE TPS4022-DAY-WEEK(THE-IDX-2) TO
                 TPS4022::DAY-WEEK(TPS4022-IDX)
               MOVE TPS4022-DESCRIPTION(THE-IDX-2) TO
                 TPS4022::DESCRIPTION(TPS4022-IDX)
               MOVE TPS4022-DELETE(THE-IDX-2) TO
                 TPS4022::DELETE-1(TPS4022-IDX)
               COMPUTE TPS4022-IDX = TPS4022-IDX + 1
           END-PERFORM.

           SET TPS4022::X-POINT TO WS-X-PARM.
           SET TPS4022::Y-POINT TO WS-Y-PARM.
           INVOKE TPS4022::ShowDialog.
           MOVE TPS4022::Location::X TO WS-X-PARM
             WS-CURRENT-X.
           MOVE TPS4022::Location::Y TO WS-Y-PARM
             WS-CURRENT-Y.
           MOVE TPS4022::SCREEN-NAME TO SCREEN-NAME.
 


132000      IF TPS4022::KEY-PRESSED = "End Key"                         
132100         IF HAVE-EDIT-DELETE                                                         00133900
132200            GO TO UPDATE-CALENDAR-DATA-BASE                                          00134000
132300         ELSE                                                                        00134100
132400            GO TO JUST-PAINT-TPS4020                                                 00134200
132500********    GO TO EXIT-THE-MODULE                                                    00134300
132600         END-IF                                                                      00134400
132700       END-IF.                                                                       00134500
132800      IF TPS4022::KEY-PRESSED = "F1 Key"                                                      00134600
132900          GO TO SETUP-REVIEW-FOR-EDIT.                                               00134700
133000      IF TPS4022::KEY-PRESSED = "F2 Key"                                                      00134800
133100          GO TO SETUP-REVIEW-FOR-DELETE.                                             00134900
133200      IF TPS4022::KEY-PRESSED = "Page Up Key"                                              00135000
133300          GO TO SETUP-REVIEW-FOR-PREV-PAGE.                                          00135100
133400      IF TPS4022::KEY-PRESSED = "Page Down Key"                                          00135200
133500          GO TO SETUP-REVIEW-FOR-NEXT-PAGE.                                          00135300
133600      GO TO DISPLAY-PANEL-TPS4022.                                                   00135400
133700                                                                                     00135500
133800                                                                                     00135600
133900*        MOVE 0                 TO RECORD-IDX                                        00135700
134000*        MOVE 0                 TO ALT-INDEX                                         00135800
134100*        MOVE RECORD-IDX        TO START-RECORD-IDX                                  00135900
134200*        MOVE ALT-INDEX         TO START-ALT-INDEX                                   00136000
134300*        GO TO HAVE-ALL-HOLIDAYS.                                                    00136100
134400                                                                                     00136200
134500                                                                                     00136300
134600 SETUP-REVIEW-FOR-EDIT.                                                              00136400
134700      MOVE TPS4022::ACTIVE-FIELD   TO CURSOR-WORK.                                00136500
134800      MOVE  ZEROS                 TO CURSOR-WORK1                                    00136600
134900                                     CURSOR-WORK2.                                   00136700
135000      DIVIDE CURSOR-WORK  BY WS-TWO   GIVING                                         00136800
135100                        CURSOR-WORK1  REMAINDER CURSOR-WORK2.                        00136900
135200      MOVE CURSOR-WORK1           TO WK-INDEX.                                       00137000
135300                                                                                     00137100
135400                                                                                     00137200
135500      MOVE PANEL-IDX-POINTER(POINTER-IDX) TO TMP-INDEX.                              00137300
135600      ADD TMP-INDEX               TO WK-INDEX.                                       00137400
135700      SUBTRACT 1                FROM WK-INDEX.                                       00137500
135800                                                                                     00137600
135900                                                                                     00137700
136000                                                                                     00137800
136100*???? ADD  START-RECORD-IDX       TO WK-INDEX.                                       00137900
136200                                                                                     00138000
136300      MOVE 05                      TO WS-DATE-PARAM.                                 00138100
136400      MOVE SPACES                  TO WS-DATE-EXTEND.                                00138200
136500      MOVE RECORD-KEY-DATE(WK-INDEX)(3:6)                                            00138300
136600                                   TO WS-DATE-REFORM(1:6).                           00138400
136700          CALL TPSDATES USING WS-DATE-REQUEST.                                       00138500
136800      MOVE WS-DATE-REFORM-LEN06    TO TPS4022A-DATE                                   00138600
136900                                      BEFORE-EDIT-DATE.                              00138700
137000                                                                                     00138800
137100      MOVE RECORD-KEY-DATE(WK-INDEX)(5:4)                                            00138900
137200                                TO YEAR-OF-HOLIDAYS-MMDD.                            00139000
137300        PERFORM FIGURE-THE-DAY                                                       00139100
137400           THRU FIGURE-THE-DAY-EXIT.                                                 00139200
137500      MOVE THE-DAY              TO TPS4022A::DAY-OF-WEEK-1.                      00139300
137600                                                                                     00139400
137700      MOVE RECORD-DAY-DESCRIPT(WK-INDEX)                                             00139500
137800                                TO TPS4022A::NAME-OF-HOLIDAY.    
                                      
137900                                                                                     00139700
138000*     MOVE SPACES               TO TPS4022-DELETE(ALT-INDEX).                    00139800
138100*                                                                                    00139900
138200*     IF RECORD-ACTION-NONE(RECORD-IDX)                                              00140000
138300*        MOVE SPACES            TO TPS4022-DELETE(ALT-INDEX)                     00140100
138400*     ELSE                                                                           00140200
138500*     IF RECORD-ACTION-MODIFY(RECORD-IDX)                                            00140300
138600*        MOVE 'MODIFIED  '      TO TPS4022-DELETE(ALT-INDEX)                     00140400
138700*     ELSE                                                                           00140500
138800*     IF RECORD-ACTION-DELETE(RECORD-IDX)                                            00140600
138900*        MOVE 'DELETED   '      TO TPS4022-DELETE(ALT-INDEX)                     00140700
139000*     ELSE                                                                           00140800
139100*        MOVE SPACES            TO TPS4022-DELETE(ALT-INDEX)                     00140900
139200*     END-IF.                                                                        00141000
139300                                                                                     00141100
139400 DISPLAY-PANEL-TPS4022A.

           MOVE TPS4022A-DATE TO TPS4022A::DATE-1.

           MOVE 1 TO TPS4022::SPLASH-SCREEN-FLAG.
           IF TPS4022-DISPLAY-FLAG = 0
               SET TPS4022::X-POINT TO WS-X-PARM
               SET TPS4022::Y-POINT TO WS-Y-PARM
               SET TPS4022::Width TO 1
               SET TPS4022::Height TO 1
               INVOKE TPS4022::Show
               SET TPS4022::Width TO 1205
               SET TPS4022::Height TO 793
               INVOKE TPS4022::Show
               MOVE 1 TO TPS4022-DISPLAY-FLAG
           END-IF.
           MOVE 0 TO TPS4022::SPLASH-SCREEN-FLAG.

           SET TPS4022A::X-POINT TO WS-X-PARM.
           SET TPS4022A::Y-POINT TO WS-Y-PARM.
           INVOKE TPS4022A::ShowDialog.
           MOVE TPS4022A::SCREEN-NAME TO SCREEN-NAME.
           MOVE TPS4022A::Location::X TO WS-X-PARM
             WS-CURRENT-X.
           MOVE TPS4022A::Location::Y TO WS-Y-PARM
             WS-CURRENT-Y.
           MOVE TPS4022A::DATE-1 TO TPS4022A-DATE.


140200      IF TPS4022A::KEY-PRESSED = "End Key"                                       
140300         MOVE 0                 TO TPS4022::ACTIVE-FIELD                          
               INVOKE TPS4022::Hide
               MOVE 0 TO TPS4022-DISPLAY-FLAG
140500         GO TO DISPLAY-PANEL-TPS4022.
                                                                                           00142300
140600      IF NOT TPS4022A::KEY-PRESSED = "Enter Key"                                        00142400
140800         MOVE 'ENTER - MODIFY, END - PREVIOUS MENU' TO                               00142600
140900                                      TPS4022A::MENU-LINE                         00142700
141000         GO TO DISPLAY-PANEL-TPS4022A.                                               00142800
141100                                                                                     00142900
141200      IF BEFORE-EDIT-DATE = TPS4022A-DATE                                             00143000
141400         MOVE 'NO MODIFICATION DETECTED           ' TO                               00143200
141500                                      TPS4022A::MENU-LINE                         00143300
141600         GO TO DISPLAY-PANEL-TPS4022A.
                                                                                           00143400
           INVOKE TPS4022::Hide.
           MOVE 0 TO TPS4022-DISPLAY-FLAG.

141700                                                                                     00143500
141800********       FLAG RECORD AS MODIFIED   ***********                                 00143600
141900      MOVE '1'              TO HAVE-EDIT-DELETE-FLAG.                                00143700
142000      MOVE '1'              TO RECORD-ACTION-CODE(WK-INDEX).                         00143800
142100                                                                                     00143900
142200      MOVE 11                      TO WS-DATE-PARAM.                                 00144000
142300      MOVE SPACES                  TO WS-DATE-EXTEND.                                00144100
142400      MOVE TPS4022A-DATE       TO WS-DATE-REFORM.                                     00144200
142500          CALL TPSDATES USING WS-DATE-REQUEST.                                       00144300
142600      MOVE RECORD-KEY-DATE(WK-INDEX) TO                                              00144400
142700                          RECORD-KEY-DATE-OLD(WK-INDEX).                             00144500
142800      MOVE WS-DATE-REFORM-LEN08    TO                                                00144600
142900                          RECORD-KEY-DATE(WK-INDEX).                                 00144700
143000                                                                                     00144800
143100***   MOVE START-RECORD-IDX TO RECORD-IDX.                                           00144900
143200      MOVE START-ALT-INDEX  TO ALT-INDEX.                                            00145000
143300      MOVE PANEL-IDX-POINTER(POINTER-IDX) TO RECORD-IDX.                             00145100
143400      GO TO HAVE-ALL-HOLIDAYS.                                                       00145200
143500                                                                                     00145300
143600                                                                                     00145400
143700 SETUP-REVIEW-FOR-DELETE.                                                            00145500
143800      MOVE TPS4022::ACTIVE-FIELD   TO CURSOR-WORK.                                00145600
143900      MOVE  ZEROS                 TO CURSOR-WORK1                                    00145700
144000                                     CURSOR-WORK2.                                   00145800
144100      DIVIDE CURSOR-WORK  BY WS-TWO   GIVING                                         00145900
144200                        CURSOR-WORK1  REMAINDER CURSOR-WORK2.                        00146000
144300      MOVE CURSOR-WORK1           TO WK-INDEX.                                       00146100
144400                                                                                     00146200
144500                                                                                     00146300
144600      MOVE PANEL-IDX-POINTER(POINTER-IDX) TO TMP-INDEX.                              00146400
144700      ADD TMP-INDEX               TO WK-INDEX.                                       00146500
144800      SUBTRACT 1                FROM WK-INDEX.                                       00146600
144900                                                                                     00146700
145000                                                                                     00146800
145100*???? ADD  START-RECORD-IDX       TO WK-INDEX.                                       00146900
145200                                                                                     00147000
145300      MOVE 05                      TO WS-DATE-PARAM.                                 00147100
145400      MOVE SPACES                  TO WS-DATE-EXTEND.                                00147200
145500      MOVE RECORD-KEY-DATE(WK-INDEX)(3:6)                                            00147300
145600                                   TO WS-DATE-REFORM(1:6).                           00147400
145700          CALL TPSDATES USING WS-DATE-REQUEST.                                       00147500
145800      MOVE WS-DATE-REFORM-LEN06    TO TPS4022B-DATE.                                  00147600
145900                                                                                     00147700
146000      MOVE RECORD-KEY-DATE(WK-INDEX)(5:4)                                            00147800
146100                                TO YEAR-OF-HOLIDAYS-MMDD.                            00147900
146200        PERFORM FIGURE-THE-DAY                                                       00148000
146300           THRU FIGURE-THE-DAY-EXIT.                                                 00148100
146400      MOVE THE-DAY              TO TPS4022B::DAY-OF-WEEK-1.                    00148200
146500                                                                                     00148300
146600      MOVE RECORD-DAY-DESCRIPT(WK-INDEX)                                             00148400
146700                                TO TPS4022B::NAME-OF-HOLIDAY.                          00148500
146800                                                                                     00148600
146900 DISPLAY-PANEL-TPS4022B.

           MOVE TPS4022B-DATE TO TPS4022B::DATE-1.                                         00148700

           MOVE 'ENTER to delete or END to return' TO
                                   TPS4022B::MENU-LINE.

           MOVE 1 TO TPS4022::SPLASH-SCREEN-FLAG.
           IF TPS4022-DISPLAY-FLAG = 0
               SET TPS4022::X-POINT TO WS-X-PARM
               SET TPS4022::Y-POINT TO WS-Y-PARM
               SET TPS4022::Width TO 1
               SET TPS4022::Height TO 1
               INVOKE TPS4022::Show
               SET TPS4022::Width TO 1205
               SET TPS4022::Height TO 793
               INVOKE TPS4022::Show
               MOVE 1 TO TPS4022-DISPLAY-FLAG
           END-IF.
           MOVE 0 TO TPS4022::SPLASH-SCREEN-FLAG.

           SET TPS4022B::X-POINT TO WS-X-PARM.
           SET TPS4022B::Y-POINT TO WS-Y-PARM.
           INVOKE TPS4022B::ShowDialog.
           MOVE TPS4022B::SCREEN-NAME TO SCREEN-NAME.
           MOVE TPS4022B::Location::X TO WS-X-PARM
             WS-CURRENT-X.
           MOVE TPS4022B::Location::Y TO WS-Y-PARM
             WS-CURRENT-Y.


147700      IF TPS4022B::KEY-PRESSED = "End Key"                                       
147800         MOVE 0                 TO TPS4022::ACTIVE-FIELD
               INVOKE TPS4022::Hide
               MOVE 0 TO TPS4022-DISPLAY-FLAG
148000         GO TO DISPLAY-PANEL-TPS4022.

148100      IF NOT TPS4022B::KEY-PRESSED = "Enter Key"                                       
148300         MOVE 'ENTER - DELETE, END - PREVIOUS MENU' TO                               00150100
148400                                      TPS4022B::MENU-LINE                         00150200
148500         GO TO DISPLAY-PANEL-TPS4022B.                                               00150300
148600                                                                                     00150400
           INVOKE TPS4022::Hide.
           MOVE 0 TO TPS4022-DISPLAY-FLAG.

148700********       FLAG RECORD AS DELETEDD   ***********                                 00150500
148800      MOVE '1'              TO HAVE-EDIT-DELETE-FLAG.                                00150600
148900      MOVE '2'             TO RECORD-ACTION-CODE(WK-INDEX).                          00150700
149000                                                                                     00150800
149100      MOVE 11                      TO WS-DATE-PARAM.                                 00150900
149200      MOVE SPACES                  TO WS-DATE-EXTEND.                                00151000
149300      MOVE TPS4022B-DATE    TO WS-DATE-REFORM.                                       00151100
149400          CALL TPSDATES USING WS-DATE-REQUEST.                                       00151200
149500      MOVE WS-DATE-REFORM-LEN08    TO                                                00151300
149600                          RECORD-KEY-DATE(WK-INDEX)                                  00151400
149700                                                                                     00151500
149800***   MOVE START-RECORD-IDX TO RECORD-IDX.                                           00151600
149900      MOVE START-ALT-INDEX  TO ALT-INDEX.                                            00151700
150000      MOVE PANEL-IDX-POINTER(POINTER-IDX) TO RECORD-IDX.                             00151800
150100      GO TO HAVE-ALL-HOLIDAYS.                                                       00151900
150200                                                                                     00152000
150300                                                                                     00152100
150400                                                                                     00152200
150500                                                                                     00152300
150600                                                                                     00152400
150700                                                                                     00152500
150800                                                                                     00152600
150900 SETUP-REVIEW-FOR-PREV-PAGE.                                                         00152700
151000      IF POINTER-IDX = '0001'                                                        00152800
151100         MOVE PANEL-IDX-POINTER(POINTER-IDX)                                         00152900
151200                                TO RECORD-IDX                                        00153000
151300         MOVE ZEROS             TO ALT-INDEX                                         00153100
151400      ELSE                                                                           00153200
151500         SET POINTER-IDX DOWN BY 1                                                   00153300
151600         MOVE PANEL-IDX-POINTER(POINTER-IDX)                                         00153400
151700                                TO RECORD-IDX                                        00153500
151800         MOVE ZEROS             TO ALT-INDEX                                         00153600
151900      END-IF.                                                                        00153700

            PERFORM VARYING TPS4022-IDX FROM 1 BY 1
                    UNTIL TPS4022-IDX > 16
                    MOVE SPACES TO TPS4022-MMDDYY(TPS4022-IDX)
                                   TPS4022-DAY-WEEK(TPS4022-IDX)
                                  TPS4022-DESCRIPTION(TPS4022-IDX)
                                   TPS4022-DELETE(TPS4022-IDX)
            END-PERFORM.

152100      GO TO HAVE-ALL-HOLIDAYS.                                                       00153900
152200                                                                                     00154000
152300                                                                                     00154100
152400 SETUP-REVIEW-FOR-NEXT-PAGE.                                                         00154200
152500      SET POINTER-IDX UP BY 1                                                        00154300
152600      IF PANEL-IDX-POINTER(POINTER-IDX) = HIGH-VALUES                                00154400
152700         SET POINTER-IDX DOWN BY 1                                                   00154500
152800         MOVE PANEL-IDX-POINTER(POINTER-IDX)                                         00154600
152900                                TO RECORD-IDX                                        00154700
153000         MOVE ZEROS             TO ALT-INDEX                                         00154800
153100      ELSE                                                                           00154900
153200         MOVE PANEL-IDX-POINTER(POINTER-IDX)                                         00155000
153300                                TO RECORD-IDX                                        00155100
153400         MOVE ZEROS             TO ALT-INDEX                                         00155200
153500      END-IF.                                                                        00155300

            PERFORM VARYING TPS4022-IDX FROM 1 BY 1
                    UNTIL TPS4022-IDX > 16
                    MOVE SPACES TO TPS4022-MMDDYY(TPS4022-IDX)
                                   TPS4022-DAY-WEEK(TPS4022-IDX)
                                  TPS4022-DESCRIPTION(TPS4022-IDX)
                                   TPS4022-DELETE(TPS4022-IDX)
            END-PERFORM.

153700      GO TO HAVE-ALL-HOLIDAYS.                                                       00155500
153800                                                                                     00155600
153900                                                                                     00155700
154000                                                                                     00155800
154100                                                                                     00155900
154200                                                                                     00156000
154300                                                                                     00156100
154400                                                                                     00156200
154500 UPDATE-CALENDAR-DATA-BASE.                                                          00156300
154600      PERFORM VARYING RECORD-IDX FROM 1 BY 1                                         00156400
154700              UNTIL RECORD-KEY(RECORD-IDX) = HIGH-VALUES                             00156500
154800                                                                                     00156600
154900        IF RECORD-ACTION-DELETE(RECORD-IDX)                                          00156700
155000           MOVE RECORD-KEY(RECORD-IDX)  TO CAL-KEY                                   00156800
155100           MOVE F-PRIME      TO FILE-KEY                                             00156900
155200           MOVE F-READ       TO FILE-ACTION                                          00157000
155300            CALL TPSIO018 USING FILE-REQUEST TPS-CALENDAR-REC                        00157100
155400           IF NOT A-SUCCESSFUL-OPERATION                                             00157200
155500              MOVE 'TPS4020 ' TO FILE-NAME                                           00157300
155600              MOVE 'READ-DEL' TO FILE-TEXT                                           00157400
155700              PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                00157500
155800              GO TO EXIT-THE-MODULE                                                  00157600
155900           END-IF                                                                    00157700
156000           IF CAL-APPT-ADD-DATE(1:1) = '1'                                           00157800
156100              MOVE '8'       TO CAL-APPT-ADD-DATE(1:1)                               00157900
156200           ELSE                                                                      00158000
156300              MOVE '9'       TO CAL-APPT-ADD-DATE(1:1)                               00158100
156400           END-IF                                                                    00158200
156500           MOVE LOGREC-SIGN-ON    TO CAL-APPT-CHANGE-PASSWORD                        00158300
156600           MOVE WS-TODAYS-DATE-CYMD TO                                               00158400
156700                          CAL-APPT-CHANGE-DATE                                       00158500
156800           MOVE F-PRIME      TO FILE-KEY                                             00158600
156900           MOVE F-REWRITE    TO FILE-ACTION                                          00158700
157000            CALL TPSIO018 USING FILE-REQUEST TPS-CALENDAR-REC                        00158800
157100           IF NOT A-SUCCESSFUL-OPERATION                                             00158900
157200              MOVE 'TPS4020 ' TO FILE-NAME                                           00159000
157300              MOVE 'WRIT-DEL' TO FILE-TEXT                                           00159100
157400              PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                00159200
157500              GO TO EXIT-THE-MODULE                                                  00159300
157600           END-IF                                                                    00159400
157700        ELSE                                                                         00159500
157800        IF RECORD-ACTION-MODIFY(RECORD-IDX)                                          00159600
157900           MOVE RECORD-KEY(RECORD-IDX)  TO CAL-KEY                                   00159700
158000           MOVE RECORD-KEY-DATE-OLD(RECORD-IDX)                                      00159800
158100                                        TO CAL-KEY-DATE                              00159900
158200           MOVE F-PRIME      TO FILE-KEY                                             00160000
158300           MOVE F-READ       TO FILE-ACTION                                          00160100
158400            CALL TPSIO018 USING FILE-REQUEST TPS-CALENDAR-REC                        00160200
158500           IF NOT A-SUCCESSFUL-OPERATION                                             00160300
158600              MOVE 'TPS4020 ' TO FILE-NAME                                           00160400
158700              MOVE 'READ-MOD ' TO FILE-TEXT                                          00160500
158800              PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                00160600
158900              GO TO EXIT-THE-MODULE                                                  00160700
159000           END-IF                                                                    00160800
159100           IF CAL-APPT-ADD-DATE(1:1) = '1'                                           00160900
159200              MOVE '8'       TO CAL-APPT-ADD-DATE(1:1)                               00161000
159300           ELSE                                                                      00161100
159400              MOVE '9'       TO CAL-APPT-ADD-DATE(1:1)                               00161200
159500           END-IF                                                                    00161300
159600           MOVE LOGREC-SIGN-ON    TO CAL-APPT-CHANGE-PASSWORD                        00161400
159700           MOVE WS-TODAYS-DATE-CYMD TO                                               00161500
159800                          CAL-APPT-CHANGE-DATE                                       00161600
159900****       MOVE RECORD-KEY(RECORD-IDX)  TO CAL-KEY                                   00161700
160000****       MOVE RECORD-KEY-DATE-OLD(RECORD-IDX)                                      00161800
160100****                                    TO CAL-KEY-DATE                              00161900
160200           MOVE F-PRIME      TO FILE-KEY                                             00162000
160300           MOVE F-REWRITE    TO FILE-ACTION                                          00162100
160400            CALL TPSIO018 USING FILE-REQUEST TPS-CALENDAR-REC                        00162200
160500********   IF FILE-STATUS NOT = '00' AND '05'                                        00162300
160600           IF NOT A-SUCCESSFUL-OPERATION                                             00162400
160700              MOVE 'TPS4020 ' TO FILE-NAME                                           00162500
160800              MOVE 'REWRI-MOD' TO FILE-TEXT                                          00162600
160900              PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                00162700
161000              GO TO EXIT-THE-MODULE                                                  00162800
161100           END-IF                                                                    00162900
161200           PERFORM DETERMINE-RECORD-NUMBER THRU                                      00163000
161300                   DETERMINE-RECORD-NUMBER-EXIT                                      00163100
161400                                                                                     00163200
161500           MOVE '08'              TO CAL-RECORD-TYPE                                 00163300
161600           MOVE SPACES            TO CAL-VARIABLE                                    00163400
161700           MOVE 'Event: '         TO CAL-APPT-APPOINT-DATA(1:07)                     00163500
161800           MOVE LOGREC-SIGN-ON    TO CAL-APPT-ADD-PASSWORD                           00163600
161900           MOVE WS-TODAYS-DATE-CYMD TO                                               00163700
162000                          CAL-APPT-ADD-DATE                                          00163800
162100           MOVE LOGREC-SIGN-ON    TO CAL-APPT-CHANGE-PASSWORD                        00163900
162200           MOVE WS-TODAYS-DATE-CYMD TO                                               00164000
162300                          CAL-APPT-CHANGE-DATE                                       00164100
162400           MOVE RECORD-DAY-DESCRIPT(RECORD-IDX)                                      00164200
162500                               TO CAL-APPT-APPOINT-DATA(8:30)                        00164300
162600           MOVE F-PRIME      TO FILE-KEY                                             00164400
162700           MOVE F-WRITE      TO FILE-ACTION                                          00164500
162800            CALL TPSIO018 USING FILE-REQUEST TPS-CALENDAR-REC                        00164600
162900           IF NOT A-SUCCESSFUL-OPERATION                                             00164700
163000              MOVE 'TPS4020 ' TO FILE-NAME                                           00164800
163100              MOVE 'WRITE-MOD' TO FILE-TEXT                                          00164900
163200              PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                00165000
163300              GO TO EXIT-THE-MODULE                                                  00165100
163400           END-IF                                                                    00165200
163500         END-IF                                                                      00165300
163600        END-IF                                                                       00165400
163700      END-PERFORM.                                                                   00165500
163800                                                                                     00165600
163900     GO TO JUST-PAINT-TPS4020.                                                       00165700
164000**** GO TO EXIT-THE-MODULE.                                                          00165800
164100                                                                                     00165900
164200                                                                                     00166000
164300 DETERMINE-RECORD-NUMBER.                                                            00166100
164400           MOVE RECORD-KEY(RECORD-IDX)  TO CAL-KEY                                   00166200
164500           MOVE '0001'         TO CAL-KEY-RECORD-NUMBER.                             00166300
164600           MOVE '01'           TO CAL-KEY-SUB-RECORD-NUMBER.                         00166400
164700                                                                                     00166500
164800 TO-DETERMINE-RECORD-NUMBER.                                                         00166600
164900           MOVE F-PRIME      TO FILE-KEY                                             00166700
165000           MOVE F-READ       TO FILE-ACTION                                          00166800
165100            CALL TPSIO018 USING FILE-REQUEST TPS-CALENDAR-REC                        00166900
165200****       IF IT-WAS-A-DUPLICATE-KEY                                                 00167000
165300           IF A-SUCCESSFUL-OPERATION                                                 00167100
165400              ADD 1           TO CAL-KEY-RECORD-NUMBER                               00167200
165500              GO TO TO-DETERMINE-RECORD-NUMBER                                       00167300
165600           ELSE                                                                      00167400
165700           IF NO-RECORD-WAS-FOUND                                                    00167500
165800              GO TO DETERMINE-RECORD-NUMBER-EXIT                                     00167600
165900           ELSE                                                                      00167700
166000           IF NOT A-SUCCESSFUL-OPERATION                                             00167800
166100              MOVE 'TPS4020 ' TO FILE-NAME                                           00167900
166200              MOVE 'READ-DETR' TO FILE-TEXT                                          00168000
166300              PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                00168100
166400              GO TO EXIT-THE-MODULE.                                                 00168200
166500 DETERMINE-RECORD-NUMBER-EXIT. EXIT.                                                 00168300
166600                                                                                     00168400
166700                                                                                     00168500
166800                                                                                     00168600
166900 JUST-PAINT-TPS4020. 

           set TPS4020 to new TPS000.TPS4020Form().
           MOVE 1 TO TPS4020::SPLASH-SCREEN-FLAG.
           IF TPS4020-DISPLAY-FLAG = 0
               SET TPS4020::X-POINT TO WS-X-PARM
               SET TPS4020::Y-POINT TO WS-Y-PARM
               SET TPS4020::Width TO 1
               SET TPS4020::Height TO 1
               INVOKE TPS4020::Show
               SET TPS4020::Width TO 1205
               SET TPS4020::Height TO 793
               INVOKE TPS4020::Show
               MOVE 1 TO TPS4020-DISPLAY-FLAG
           END-IF.
           MOVE 0 TO TPS4020::SPLASH-SCREEN-FLAG.

167800                                                                                     00169600
167900                                                                                     00169700
168000 DISPLAY-PANEL-TPS4020A.                                                             00169800

168100      MOVE SPACES          TO TPS4020A::QUESTION.

           SET TPS4020A::X-POINT TO WS-X-PARM.
           SET TPS4020A::Y-POINT TO WS-Y-PARM.
           INVOKE TPS4020A::ShowDialog.
           MOVE TPS4020A::SCREEN-NAME TO SCREEN-NAME.
           MOVE TPS4020A::Location::X TO WS-X-PARM
             WS-CURRENT-X.
           MOVE TPS4020A::Location::Y TO WS-Y-PARM
             WS-CURRENT-Y.



169700     IF TPS4020A::KEY-PRESSED = "End Key"
               INVOKE TPS4020::Hide
               MOVE 0 TO TPS4020-DISPLAY-FLAG
               GO TO EXIT-THE-MODULE
           END-IF.
169800           
                                                                                                                                
168800      IF TPS4020A::QUESTION = 'N'
               INVOKE TPS4020::Hide
               MOVE 0 TO TPS4020-DISPLAY-FLAG
               GO TO DISPLAY-PANEL-TPS4020C
            END-IF
168900                                                    

169300      IF TPS4020A::QUESTION = 'Y'                                                     00171100
169400         MOVE '1'        TO SPEC-HOLIDAY-PROCESS-FLAG                                00171200
169500          GO TO SETUP-PANEL-TPS4021.                                 
                                                                                           00171400

170100      MOVE 'VALID RESPONSES ARE Y or N   ' TO                                        00171900
170200                                   TPS4020A::MENU-LINE                            00172000
170300      GO TO DISPLAY-PANEL-TPS4020A.                                                  00172100
170400                                                                                     00172200
170500                                                                                     00172300
170600 SETUP-PANEL-TPS4021.                                                                00172400
170700     MOVE ZEROS             TO TPS4021-DATE.                                    00172500
170800     MOVE SPACES            TO TPS4021::DAY-OF-WEEK-1                              00172600
170900                               TPS4021::NAME-OF-HOLIDAY.                           00172700

171100     MOVE '   TAB THRU ALL FIELDS FIRST ' TO                                         00172900
171200                               TPS4021::MENU-LINE.                                00173000
171300     MOVE '0'               TO SPEC-HOLIDAY-CURSOR-FLAG.                             00173100
171400     MOVE '1'               TO TPS4021::ACTIVE-FIELD.                             00173200

171600                                                                                     00173400
171700                                                                                     00173500
171800 DISPLAY-PANEL-TPS4021.                                                              00173600

           MOVE TPS4021-DATE TO TPS4021::DATE-1.

           SET TPS4021::X-POINT TO WS-X-PARM.
           SET TPS4021::Y-POINT TO WS-Y-PARM.
           INVOKE TPS4021::ShowDialog.
           MOVE TPS4021::SCREEN-NAME TO SCREEN-NAME.
           MOVE TPS4021::Location::X TO WS-X-PARM
             WS-CURRENT-X.
           MOVE TPS4021::Location::Y TO WS-Y-PARM
             WS-CURRENT-Y.

171900     MOVE TPS4021::DATE-1 TO TPS4021-DATE.                                           00173700
172600                                                                                     00174400
172700      IF TPS4021::KEY-PRESSED = "Enter Key"                                            00174500
172800         IF SPEC-HOLIDAY-DAY-DONE                                                    00174600
                   INVOKE TPS4020::Hide
                   MOVE 0 TO TPS4020-DISPLAY-FLAG
172900            GO TO SPEC-HOLIDAY-UPDATE                                                00174700
173000         END-IF                                                                      00174800
173200         MOVE '   TAB THRU ALL FIELDS FIRST    ' TO                                  00175000
173300                                   TPS4021::MENU-LINE                             00175100
173400         GO TO DISPLAY-PANEL-TPS4021                                                 00175200
173500      END-IF.                                                                        00175300
173600                                                                                     00175400
173700     IF TPS4021::KEY-PRESSED = "End Key"
               INVOKE TPS4020::Hide
               MOVE 0 TO TPS4020-DISPLAY-FLAG
               GO TO DISPLAY-PANEL-TPS4020C
           END-IF.
173800                                                                                     00175600
173900*12/24/96 GO TO JUST-PAINT-TPS4020.                                                  00175700
174000                                                                                     00175800
174100      EVALUATE TPS4021::HOT-FIELD                                                     00175900
174200          WHEN 1001
                     GO TO SPEC-HOT-FIELD-1001                                00176000
174300          WHEN 1003
                     GO TO SPEC-HOT-FIELD-1003                                00176100
174400      END-EVALUATE.                                                                  00176200
174500                                                                                     00176300
174600      GO TO DISPLAY-PANEL-TPS4021.                                                   00176400
174700                                                                                     00176500
174800 SPEC-HOT-FIELD-1001.                                                                00176600
174900      MOVE '1'            TO SPEC-HOLIDAY-CURSOR-FLAG.                               00176700
175000      MOVE '3'            TO TPS4021::ACTIVE-FIELD.                               00176800
175300      MOVE '   TAB THRU ALL FIELDS    ' TO                                           00177100
175400                             TPS4021::MENU-LINE                                   00177200
175500      GO TO DISPLAY-PANEL-TPS4021.                                                   00177300
175600                                                                                     00177400
175700 SPEC-HOT-FIELD-1003.                                                                00177500
175800      MOVE '2'            TO SPEC-HOLIDAY-CURSOR-FLAG.                               00177600
175900      MOVE '1'            TO TPS4021::ACTIVE-FIELD.                               00177700
176100      MOVE 11                   TO WS-DATE-PARAM.                                    00177900
176200      MOVE TPS4021-DATE    TO WS-DATE-REFORM.                                   00178000
176300      MOVE SPACES               TO WS-DATE-EXTEND.                                   00178100
176400         CALL TPSDATES USING WS-DATE-REQUEST.                                        00178200
176500      MOVE WS-DATE-REFORM-LEN08 TO YEAR-OF-HOLIDAYS.                                 00178300
176600      PERFORM FIGURE-THE-DAY                                                         00178400
176700         THRU FIGURE-THE-DAY-EXIT.                                                   00178500
176800      MOVE THE-DAY              TO TPS4021::DAY-OF-WEEK-1.                         00178600
177000      MOVE ' ENTER - TO PROCESS, END - RETURN TO PREVIOUS MENU'                      00178800
177100                                TO TPS4021::MENU-LINE.                            00178900
177200      GO TO DISPLAY-PANEL-TPS4021.                                                   00179000
177300                                                                                     00179100
177400                                                                                     00179200
177500 SPEC-HOLIDAY-UPDATE.                                                                00179300
177600      MOVE '9999999999'           TO CAL-KEY-ACCT-NO.                                00179400
177700      MOVE '00'                   TO CAL-KEY-SUB-ACCT.                               00179500
177800      MOVE 11                   TO WS-DATE-PARAM.                                    00179600
177900      MOVE TPS4021-DATE    TO WS-DATE-REFORM.                                   00179700
178000      MOVE SPACES               TO WS-DATE-EXTEND.                                   00179800
178100         CALL TPSDATES USING WS-DATE-REQUEST.                                        00179900
178200      MOVE WS-DATE-REFORM-LEN08 TO CAL-KEY-DATE                                      00180000
178300      MOVE '0001'         TO CAL-KEY-RECORD-NUMBER.                                  00180100
178400      MOVE '01'           TO CAL-KEY-SUB-RECORD-NUMBER.                              00180200
178500           PERFORM TO-DETERMINE-RECORD-NUMBER THRU                                   00180300
178600                      DETERMINE-RECORD-NUMBER-EXIT.                                  00180400
178700                                                                                     00180500
178800      MOVE '08'                   TO CAL-RECORD-TYPE.                                00180600
178900      MOVE SPACES                 TO CAL-VARIABLE.                                   00180700
179000      MOVE 'Event: '         TO CAL-APPT-APPOINT-DATA(1:07).                         00180800
179100      MOVE TPS4021::NAME-OF-HOLIDAY TO                                             00180900
179200                                CAL-APPT-APPOINT-DATA(8:30).                         00181000
179300      MOVE LOGREC-SIGN-ON     TO CAL-APPT-ADD-PASSWORD.                              00181100
179400      MOVE WS-TODAYS-DATE-CYMD TO                                                    00181200
179500                          CAL-APPT-ADD-DATE.                                         00181300
179600      MOVE LOGREC-SIGN-ON    TO CAL-APPT-CHANGE-PASSWORD.                            00181400
179700      MOVE WS-TODAYS-DATE-CYMD TO                                                    00181500
179800                          CAL-APPT-CHANGE-DATE.                                      00181600
179900      MOVE F-PRIME      TO FILE-KEY.                                                 00181700
180000      MOVE F-WRITE      TO FILE-ACTION.                                              00181800
180100        CALL TPSIO018 USING FILE-REQUEST TPS-CALENDAR-REC.                           00181900
180200      IF NOT A-SUCCESSFUL-OPERATION                                                  00182000
180300         MOVE 'TPS4020 ' TO FILE-NAME                                                00182100
180400         MOVE 'WRITE-SPEC' TO FILE-TEXT                                              00182200
180500         PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                     00182300
180600         GO TO EXIT-THE-MODULE.                                                      00182400
180700      GO TO DISPLAY-PANEL-TPS4020C.                                                  00182500
180800*12/24/96  GO TO JUST-PAINT-TPS4020.                                                 00182600
180900                                                                                     00182700
181000                                                                                     00182800
181100 DISPLAY-PANEL-TPS4020C.                                                             00182900
181200      IF WS-TODAYS-DATE-CYMD = '19970324'                                            00183000
181300         MOVE '1'               TO ALLOW-BDAY-OPTION-FLAG                            00183100
181400         MOVE '1997'            TO YEAR-OF-HOLIDAYS-CCYY                             00183200
181500       END-IF.                                                                       00183300
181600                                                                                     00183400
181700      IF NOT ALLOW-BDAY-OPTION                                                       00183500
181800         GO TO EXIT-THE-MODULE.                                                      00183600
181900                                                                                     00183700
182000      MOVE YEAR-OF-HOLIDAYS-CCYY TO CAL-BDAY-ANNIV-YEAR.                             00183800
182100      MOVE SPACES                TO CAL-BDAY-ANNIV-ANSWER.                           00183900
182200      SET TPS4020C-DO-DISPLAY TO TRUE                                                00184000
182300      CALL GUISCREEN USING TPS4020C-1                                                00184100
182400                           TPS4020C-2                                                00184200
182500                           TPS4020C-3                                                00184300
182600                           TPS4020C-4.                                               00184400
182700                                                                                     00184500
182800      IF CAL-BDAY-ANNIV-ANSWER = 'N'                                                 00184600
182900          GO TO EXIT-THE-MODULE.                                                     00184700
183000******    GO TO DISPLAY-PANEL-TPS4020.                                               00184800
183100                                                                                     00184900
183200      IF CAL-BDAY-ANNIV-ANSWER NOT = 'Y'                     
               MOVE 'VALID RESPONSES ARE Y or N   ' TO                                     00185200
183500                                   TPS4020C-MESSAGE-TEXT                             00185300
183600         GO TO DISPLAY-PANEL-TPS4020C.                                               00185400
183700                                                                                     00185500
183800      SUBTRACT 1         FROM CAL-BDAY-ANNIV-YEAR.                                   00185600
183900                                                                                     00185700
184000      MOVE 'NY'              TO BRNCH-CONTROL-STATE.                                 00185800
184100      MOVE LOGREC-ADMIN-ACCT-BRANCH                                                  00185900
184200                             TO BRNCH-CONTROL-OFFICE.                                00186000
184300      MOVE LOGREC-ADMIN-ACCT-ADMIN                                                   00186100
184400                             TO BRNCH-CONTROL-GROUP.                                 00186200
184500                                                                                     00186300
184600      SET FR-OPEN-I-O TO TRUE.                                                       00186400
184700      CALL TPSIO003 USING FILE-REQUEST TPS-BRANCH-REC.                               00186500
184800                                                                                     00186600
184900      IF FILE-STATUS NOT = '00' AND '05'                                             00186700
185000           MOVE 'BRNCH' TO FILE-NAME                                                 00186800
185100           MOVE 'TPS4020-OPEN' TO FILE-TEXT                                          00186900
185200           PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
                 IF PROCESS-2-DISPLAY-FLAG = 1
                     INVOKE PROCESS-2::Hide
                     MOVE 0 TO PROCESS-2-DISPLAY-FLAG
                 END-IF
185300           GOBACK GIVING CURRENT-XY-PARAMETERS.                                                                 
185400                                                                                     00187200
185500      SET FR-READ TO TRUE.                                                           00187300
185600      CALL TPSIO003 USING FILE-REQUEST TPS-BRANCH-REC.                               00187400
185700                                                                                     00187500
185800      IF NOT A-SUCCESSFUL-OPERATION                                                  00187600
185900           MOVE 'BRNCH' TO FILE-NAME                                                 00187700
186000           MOVE 'TPS4020-READ' TO FILE-TEXT                                          00187800
186100           PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                   00187900
               IF PROCESS-2-DISPLAY-FLAG = 1
                   INVOKE PROCESS-2::Hide
                   MOVE 0 TO PROCESS-2-DISPLAY-FLAG
               END-IF
186200           GOBACK GIVING CURRENT-XY-PARAMETERS.                                                                   
186300                                                                                     00188100
186400      SET FR-CLOSE TO TRUE.                                                          00188200
186500      CALL TPSIO003 USING FILE-REQUEST TPS-BRANCH-REC.                               00188300
186600                                                                                     00188400
186700      IF NOT A-SUCCESSFUL-OPERATION                                                  00188500
186800           MOVE 'BRNCH' TO FILE-NAME                                                 00188600
186900           MOVE 'TPS4020-CLOSE' TO FILE-TEXT                                         00188700
187000           PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                   00188800
               IF PROCESS-2-DISPLAY-FLAG = 1
                   INVOKE PROCESS-2::Hide
                   MOVE 0 TO PROCESS-2-DISPLAY-FLAG
               END-IF
187100           GOBACK GIVING CURRENT-XY-PARAMETERS                                                                  
187200                                                                                     00189000
187300      CANCEL TPSIO003.                                                               00189100
187400                                                                                     00189200
187500      MOVE ADMIN-FIRST-ACCT-NUM-USED  TO CLNT-PROFILE-ACCT-NO                        00189300
187600                                         OF TPS-PROFL-REC.                           00189400
187700      MOVE '00'                       TO CLNT-PROFILE-SUB-ACCT                       00189500
187800                                         OF TPS-PROFL-REC.                           00189600
187900                                                                                     00189700
188000 CLIENT-READ.                                                                        00189800
188100      SET FR-READ TO TRUE.                                                           00189900
188200      CALL TPSIO004 USING FILE-REQUEST TPS-PROFL-REC.                                00190000
003710*01/14/99                                                                            00190100
003720      IF NO-RECORD-WAS-FOUND                                                         00190200
003740         GO TO NEXT-AVAILABLE-ACCT                                              0005400190300
003750       END-IF.                                                                   000500190400
003710*01/14/99                                                                            00190500
188400      IF NOT A-SUCCESSFUL-OPERATION                                                  00190600
188500         IF CLNT-PROFILE-ACCT-NO OF TPS-PROFL-REC < '0101000230'                     00190700
188600              GO TO NEXT-AVAILABLE-ACCT                                              00190800
188700          ELSE                                                                       00190900
188800           MOVE 'PROFL' TO FILE-NAME                                                 00191000
188900           MOVE 'TPS4020-READ' TO FILE-TEXT                                          00191100
189000           PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                   00191200
                   IF PROCESS-2-DISPLAY-FLAG = 1
                       INVOKE PROCESS-2::Hide
                       MOVE 0 TO PROCESS-2-DISPLAY-FLAG
                   END-IF
189100           GOBACK GIVING CURRENT-XY-PARAMETERS                                                                  
189200          END-IF                                                                     00191400
189300        END-IF.                                                                      00191500
189400                                                                                     00191600
189500      IF CLNT-PROFILE-ADD-DATE OF TPS-PROFL-REC(1:1) = '8' OR '9'                    00191700
189600         GO TO NEXT-AVAILABLE-ACCT.                                                  00191800
189700                                                                                     00191900
189701      MOVE CLNT-PROFILE-ACCT-NO OF TPS-PROFL-REC                                     00192000
189702                                  TO WS-CLNT-ACCT-NO.                                00192100
189703      MOVE CLNT-PROFILE-SUB-ACCT OF TPS-PROFL-REC                                    00192200
189704                                  TO WS-CLNT-SUB-ACCT.                               00192300
189710                                                                                     00192400
189800      PERFORM SEARCH-BDAY-ANNIV THRU                                                 00192500
189900              SEARCH-BDAY-ANNIV-EXIT.                                                00192600
190000                                                                                     00192700
190100 NEXT-AVAILABLE-ACCT.                                                                00192800
190200      ADD 10                    TO CLNT-PROFILE-ACCT-NO                              00192900
190300                                   OF TPS-PROFL-REC.                                 00193000
190400      CALL MOD10 USING CLNT-PROFILE-ACCT-NO OF TPS-PROFL-REC.                        00193100
190500      MOVE '00'                 TO CLNT-PROFILE-SUB-ACCT                             00193200
190600                                   OF TPS-PROFL-REC.                                 00193300
190700                                                                                     00193400
190800      IF CLNT-PROFILE-ACCT-NO OF TPS-PROFL-REC NOT >                                 00193500
190900                           ADMIN-LAST-ACCT-NUM-USED                                  00193600
191000         GO TO  CLIENT-READ                                                          00193700
191100       END-IF.                                                                       00193800
191200      GO TO EXIT-THE-MODULE.                                                         00193900
191300                                                                                     00194000
191400 SEARCH-BDAY-ANNIV.                                                                  00194100
191500      MOVE CLNT-PROFILE-ACCT-NO OF TPS-PROFL-REC                                     00194200
191600                                TO CAL-KEY-ACCT-NO.                                  00194300
191700      MOVE '00'                 TO CAL-KEY-SUB-ACCT                                  00194400
191800                                   CAL-KEY-RECORD-NUMBER                             00194500
191900                                   CAL-KEY-SUB-RECORD-NUMBER.                        00194600
192000      MOVE CAL-BDAY-ANNIV-YEAR   TO CAL-KEY-DATE(1:4).                               00194700
192100      MOVE '0101'                TO CAL-KEY-DATE(5:4).                               00194800
192200      MOVE CAL-KEY-DATE          TO WS-BDAY-ANNIV-DATE-END.                          00194900
192300      GO TO READ-BDAY-ANNIV-1.                                                       00195000
192400                                                                                     00195100
192500 SET-UP-NEXT-BDAY-ANNIV-DATE.                                                        00195200
192600      MOVE SPACES               TO WS-DATE-EXTEND.                                   00195300
192700      MOVE 21                   TO WS-DATE-PARAM.                                    00195400
192800      MOVE WS-BDAY-ANNIV-DATE-END                                                    00195500
192900                                TO WS-DATE-REFORM-LEN08.                             00195600
193000      MOVE '001'                TO WS-DATE-REFORM(9:3).                              00195700
193100         CALL TPSDATES USING WS-DATE-REQUEST.                                        00195800
193200      MOVE WS-DATE-REFORM-LEN08 TO CAL-KEY-DATE                                      00195900
193300                                   WS-BDAY-ANNIV-DATE-END.                           00196000
193400      IF CAL-BDAY-ANNIV-YEAR NOT = CAL-KEY-DATE(1:4)                                 00196100
193500         GO TO SEARCH-BDAY-ANNIV-EXIT                                                00196200
193600       END-IF.                                                                       00196300
193700                                                                                     00196400
193800      MOVE ZEROS                TO CAL-KEY-RECORD-NUMBER                             00196500
193900                                   CAL-KEY-SUB-RECORD-NUMBER.                        00196600
194000                                                                                     00196700
194100*--------------------------------------------------------                            00196800
194200 READ-BDAY-ANNIV-1.                                                                  00196900
194300      ADD 1                 TO CAL-KEY-RECORD-NUMBER.                                00197000
194400      MOVE '01'             TO CAL-KEY-SUB-RECORD-NUMBER.                            00197100
194500      MOVE F-PRIME          TO FILE-KEY.                                             00197200
194600      MOVE F-READ           TO FILE-ACTION.                                          00197300
194700      CALL TPSIO018 USING FILE-REQUEST TPS-CALENDAR-REC.                             00197400
194800                                                                                     00197500
194900      IF NO-RECORD-WAS-FOUND                                                         00197600
195000         GO TO SET-UP-NEXT-BDAY-ANNIV-DATE                                           00197700
195100        END-IF.                                                                      00197800
195200                                                                                     00197900
195300      IF NOT A-SUCCESSFUL-OPERATION                                                  00198000
195400         MOVE 'TPS4020 ' TO FILE-NAME                                                00198100
195500         MOVE 'READ-2  ' TO FILE-TEXT                                                00198200
195600         PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                     00198300
195700         GO TO EXIT-THE-MODULE.                                                      00198400
195800                                                                                     00198500
195900      IF CAL-KEY-DATE(1:1) NOT < '8'                                                 00198600
196000         GO TO READ-BDAY-ANNIV-1                                                     00198700
196100       END-IF.                                                                       00198800
196200                                                                                     00198900
196300      MOVE TPS-CALENDAR-REC      TO S-C-R-1.                                         00199000
196400                                                                                     00199100
196500*--------------------------------------------------------                            00199200
196600                                                                                     00199300
196700 READ-BDAY-ANNIV-2.                                                                  00199400
196800      ADD 1                 TO CAL-KEY-SUB-RECORD-NUMBER.                            00199500
196900      MOVE F-PRIME          TO FILE-KEY.                                             00199600
197000      MOVE F-READ           TO FILE-ACTION.                                          00199700
197100      CALL TPSIO018 USING FILE-REQUEST TPS-CALENDAR-REC.                             00199800
197200                                                                                     00199900
197300      IF NO-RECORD-WAS-FOUND                                                         00200000
197400         GO TO READ-BDAY-ANNIV-1                                                     00200100
197500        END-IF.                                                                      00200200
197600                                                                                     00200300
197700      IF NOT A-SUCCESSFUL-OPERATION                                                  00200400
197800         MOVE 'TPS4020 ' TO FILE-NAME                                                00200500
197900         MOVE 'READ-2  ' TO FILE-TEXT                                                00200600
198000         PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                     00200700
198100         GO TO EXIT-THE-MODULE.                                                      00200800
198200                                                                                     00200900
198300      MOVE TPS-CALENDAR-REC      TO S-C-R-2.                                         00201000
198400                                                                                     00201100
198500*--------------------------------------------------------                            00201200
198600                                                                                     00201300
198700 READ-BDAY-ANNIV-3.                                                                  00201400
198800      ADD 1                 TO CAL-KEY-SUB-RECORD-NUMBER.                            00201500
198900      MOVE F-PRIME          TO FILE-KEY.                                             00201600
199000      MOVE F-READ           TO FILE-ACTION.                                          00201700
199100      CALL TPSIO018 USING FILE-REQUEST TPS-CALENDAR-REC.                             00201800
199200                                                                                     00201900
199300      IF A-SUCCESSFUL-OPERATION                                                      00202000
199400         GO TO READ-BDAY-ANNIV-1                                                     00202100
199500        END-IF.                                                                      00202200
199600                                                                                     00202300
199700 START-THE-SEARCH.                                                                   00202400
199800      MOVE S-C-R-1               TO TPS-CALENDAR-REC.                                00202500
199900      MOVE CAL-APPT-APPOINT-DATA(8:43)                                               00202600
200000                                 TO REMEMBER-DATA-SEARCH.                            00202700
200100                                                                                     00202800
200200      PERFORM VARYING COMA-IDX FROM 1 BY 1                                           00202900
200300              UNTIL COMA-IDX > 40                                                    00203000
200400*12/25   IF REMEMBER-DATA-BYTES(COMA-IDX)(1:7) = "'s Bday"                           00203100
200500         IF REMEMBER-DATA-BYTES(COMA-IDX)(1:9) = "'s Bday  "                         00203200
200600            GO TO ITS-A-DAY-TO-REMEMBER                                              00203300
200700           ELSE                                                                      00203400
200800*12/25   IF REMEMBER-DATA-BYTES(COMA-IDX)(1:8) = "'s B'day"                          00203500
200900         IF REMEMBER-DATA-BYTES(COMA-IDX)(1:10) = "'s B'day  "                       00203600
201000            GO TO ITS-A-DAY-TO-REMEMBER                                              00203700
201100           ELSE                                                                      00203800
201200*12/25   IF REMEMBER-DATA-BYTES(COMA-IDX)(1:7) = "'s BDAY"                           00203900
201300         IF REMEMBER-DATA-BYTES(COMA-IDX)(1:9) = "'s BDAY  "                         00204000
201400            GO TO ITS-A-DAY-TO-REMEMBER                                              00204100
201500           ELSE                                                                      00204200
201600*12/25   IF REMEMBER-DATA-BYTES(COMA-IDX)(1:8) = "'s B'DAY"                          00204300
201700         IF REMEMBER-DATA-BYTES(COMA-IDX)(1:10) = "'s B'DAY  "                       00204400
201800            GO TO ITS-A-DAY-TO-REMEMBER                                              00204500
201900           ELSE                                                                      00204600
202000         IF REMEMBER-DATA-BYTES(COMA-IDX)(1:7) = "'s Anni"                           00204700
202100            GO TO ITS-A-DAY-TO-REMEMBER                                              00204800
202200           END-IF                                                                    00204900
202300          END-IF                                                                     00205000
202400         END-IF                                                                      00205100
202500        END-IF                                                                       00205200
202600       END-IF                                                                        00205300
202700      END-PERFORM.                                                                   00205400
202800                                                                                     00205500
202900      GO TO READ-BDAY-ANNIV-1.                                                       00205600
203000                                                                                     00205700
203100                                                                                     00205800
203200 ITS-A-DAY-TO-REMEMBER.                                                              00205900
203300    MOVE CAL-KEY-DATE         TO WS-WORK-DATE-CYMD.                                  00206000
203400    ADD  10000                TO WS-WORK-DATE-CYMD.                                  00206100
203500    MOVE WS-WORK-DATE-CYMD    TO CAL-KEY-DATE.                                       00206200
203600                                                                                     00206300
203700    MOVE TPS-CALENDAR-REC     TO S-C-R-1.                                            00206400
203800                                                                                     00206500
203900    PERFORM SETUP-CONTROL-RECORDS THRU                                               00206600
204000            SETUP-CONTROL-RECORDS-EXIT.                                              00206700
204100                                                                                     00206800
204200    MOVE '0001'               TO CAL-KEY-RECORD-NUMBER.                              00206900
204300    MOVE '01'                 TO CAL-KEY-SUB-RECORD-NUMBER.                          00207000
204400                                                                                     00207100
204500    MOVE WS-NEXT-AVAIL-REC-NUM TO WS-HOLD-RECORD-NUMBER.                             00207200
204600    MOVE '01'                  TO WS-HOLD-SUB-RECORD-NUMBER.                         00207300
204700                                                                                     00207400
204800 HAVE-NEXT-AVAILABLE-KEY.                                                            00207500
204900*   MOVE CAL-KEY-RECORD-NUMBER     TO WS-HOLD-RECORD-NUMBER.                         00207600
205000*   MOVE CAL-KEY-SUB-RECORD-NUMBER TO WS-HOLD-SUB-RECORD-NUMBER.                     00207700
205100    MOVE S-C-R-1                   TO TPS-CALENDAR-REC.                              00207800
205200    MOVE WS-HOLD-RECORD-NUMBER     TO CAL-KEY-RECORD-NUMBER.                         00207900
205300    MOVE WS-HOLD-SUB-RECORD-NUMBER TO CAL-KEY-SUB-RECORD-NUMBER.                     00208000
205400    MOVE '0000'                    TO CAL-APPT-START-TIME.                           00208100
205500    MOVE SPACES                    TO CAL-APPT-START-TIME-AM-PM.                     00208200
205600    MOVE '0000'                    TO CAL-APPT-STOP-TIME.                            00208300
205700    MOVE SPACES                    TO CAL-APPT-STOP-TIME-AM-PM.                      00208400
205800    MOVE '00000000'                TO CAL-APPT-RECEIVE-DATE.                         00208500
205900    MOVE ZEROS                     TO CAL-APPT-RECEIVE-NUMBER.                       00208600
206000    MOVE '2'                       TO CAL-APPT-WHERE-FROM.                           00208700
206100    MOVE ' '                       TO CAL-APPT-PRINT-OPTION                          00208800
206200                                      CAL-APPT-ATTEND-OPTION.                        00208900
206300    MOVE 'TPS4020 '                TO CAL-APPT-ADD-PASSWORD                          00209000
206400                                      CAL-APPT-CHANGE-PASSWORD.                      00209100
206500    MOVE WS-TODAYS-DATE-CYMD       TO CAL-APPT-ADD-DATE                              00209200
206600                                      CAL-APPT-CHANGE-DATE.                          00209300
206700                                                                                     00209400
206710 ALLOW-DUPS-HERE-ONLY.                                                               00209500
206800    MOVE F-PRIME TO FILE-KEY.                                                        00209600
206900    MOVE F-WRITE TO FILE-ACTION.                                                     00209700
207000    CALL TPSIO018 USING FILE-REQUEST TPS-CALENDAR-REC.                               00209800
207010    IF IT-WAS-A-DUPLICATE-KEY                                                        00209900
207030       ADD 1           TO CAL-KEY-RECORD-NUMBER                                      00210000
207040                          WS-HOLD-RECORD-NUMBER                                      00210100
207050       GO TO ALLOW-DUPS-HERE-ONLY.                                                   00210200
207100    IF NOT A-SUCCESSFUL-OPERATION                                                    00210300
207200       MOVE 'TPS4020 ' TO FILE-NAME                                                  00210400
207300       MOVE 'WRITE'    TO FILE-TEXT                                                  00210500
207400       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                       00210600
207500       GO TO EXIT-THE-MODULE.                                                        00210700
207600                                                                                     00210800
207700    MOVE S-C-R-2                   TO TPS-CALENDAR-REC.                              00210900
207800    MOVE CAL-KEY-DATE              TO WS-WORK-DATE-CYMD.                             00211000
207900    ADD  10000                     TO WS-WORK-DATE-CYMD.                             00211100
208000    MOVE WS-WORK-DATE-CYMD         TO CAL-KEY-DATE.                                  00211200
208100    MOVE WS-HOLD-RECORD-NUMBER     TO CAL-KEY-RECORD-NUMBER.                         00211300
208200    MOVE WS-HOLD-SUB-RECORD-NUMBER TO CAL-KEY-SUB-RECORD-NUMBER.                     00211400
208300    ADD 1                          TO CAL-KEY-SUB-RECORD-NUMBER.                     00211500
208400    MOVE '0000'                    TO CAL-APPT-START-TIME.                           00211600
208500    MOVE SPACES                    TO CAL-APPT-START-TIME-AM-PM.                     00211700
208600    MOVE '0000'                    TO CAL-APPT-STOP-TIME.                            00211800
208700    MOVE SPACES                    TO CAL-APPT-STOP-TIME-AM-PM.                      00211900
208800    MOVE '00000000'                TO CAL-APPT-RECEIVE-DATE.                         00212000
208900    MOVE ZEROS                     TO CAL-APPT-RECEIVE-NUMBER.                       00212100
209000    MOVE '2'                       TO CAL-APPT-WHERE-FROM.                           00212200
209100    MOVE ' '                       TO CAL-APPT-PRINT-OPTION                          00212300
209200                                      CAL-APPT-ATTEND-OPTION.                        00212400
209300    MOVE 'TPS4020 '                TO CAL-APPT-ADD-PASSWORD                          00212500
209400                                      CAL-APPT-CHANGE-PASSWORD.                      00212600
209500    MOVE WS-TODAYS-DATE-CYMD       TO CAL-APPT-ADD-DATE                              00212700
209600                                      CAL-APPT-CHANGE-DATE.                          00212800
209700    MOVE SPACES               TO WS-DATE-EXTEND.                                     00212900
209800    MOVE 03                   TO WS-DATE-PARAM.                                      00213000
209900    MOVE CAL-KEY-DATE(3:6)    TO WS-DATE-REFORM.                                     00213100
210000     CALL TPSDATES USING WS-DATE-REQUEST.                                            00213200
210100    MOVE WS-DATE-REFORM-LEN08 TO CAL-APPT-APPOINT-DATA(7:08).                        00213300
210200                                                                                     00213400
210300    MOVE F-PRIME TO FILE-KEY.                                                        00213500
210400    MOVE F-WRITE TO FILE-ACTION.                                                     00213600
210500    CALL TPSIO018 USING FILE-REQUEST TPS-CALENDAR-REC.                               00213700
210600    IF NOT A-SUCCESSFUL-OPERATION                                                    00213800
210700       MOVE 'TPS4020 ' TO FILE-NAME                                                  00213900
210800       MOVE 'WRITE'    TO FILE-TEXT                                                  00214000
210900       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                       00214100
211000       GO TO EXIT-THE-MODULE.                                                        00214200
211100                                                                             0009095000214300
211200     GO TO READ-BDAY-ANNIV-1.                                                        00214400
211300                                                                                     00214500
211400 SEARCH-BDAY-ANNIV-EXIT.                                                             00214600
211500                                                                                     00214700
211600*------------------------------------------------------------                        00214800
211700*------------------------------------------------------------                        00214900
211800*------------------------------------------------------------                        00215000
211900*------------------------------------------------------------                        00215100
212000 SETUP-CONTROL-RECORDS.                                                              00215200
212010      MOVE WS-CLNT-ACCT-NO        TO CAL-KEY-ACCT-NO.                                00215300
212020      MOVE WS-CLNT-SUB-ACCT       TO CAL-KEY-SUB-ACCT.                               00215400
212100      MOVE ZEROS                  TO CAL-KEY-DATE.                                   00215500
212200      MOVE WS-WORK-DATE-CC        TO CAL-KEY-DATE-CC.                                00215600
212300      MOVE WS-WORK-DATE-YY        TO CAL-KEY-DATE-YY.                                00215700
212400      MOVE ZEROS                  TO CAL-KEY-RECORD-NUMBER.                          00215800
212500      MOVE ZEROS                  TO CAL-KEY-SUB-RECORD-NUMBER.                      00215900
212600                                                                                     00216000
212700      PERFORM READ-CALENDAR-CONTROL THRU                                             00216100
212800              READ-CALENDAR-CONTROL-EXIT.                                            00216200
212900                                                                                     00216300
213000      IF WS-CLNT-ACCT-NO = CAL-KEY-ACCT-NO                                           00216400
213100         GO TO HAVE-YEAR-CHECK-MONTH.                                                00216500
213200                                                                                     00216600
213300*****  BUILD OF YEARLY CONTROL RECORD                                                00216700
213400                                                                                     00216800
213410      MOVE WS-CLNT-ACCT-NO        TO CAL-KEY-ACCT-NO.                                00216900
213420      MOVE WS-CLNT-SUB-ACCT       TO CAL-KEY-SUB-ACCT.                               00217000
213500      MOVE ZEROS                  TO CAL-KEY-DATE.                                   00217100
213600      MOVE WS-WORK-DATE-CC        TO CAL-KEY-DATE-CC.                                00217200
213700      MOVE WS-WORK-DATE-YY        TO CAL-KEY-DATE-YY.                                00217300
213800      MOVE ZEROS                  TO CAL-KEY-RECORD-NUMBER.                          00217400
213900      MOVE ZEROS                  TO CAL-KEY-SUB-RECORD-NUMBER.                      00217500
214000                                                                                     00217600
214100      MOVE ZEROS                  TO CAL-RECORD-TYPE.                                00217700
214200      MOVE SPACES                 TO CAL-VARIABLE.                                   00217800
214300                                                                                     00217900
214400      PERFORM VARYING THE-INDEX FROM 1 BY 1                                          00218000
214500                      UNTIL THE-INDEX > 12                                           00218100
214600         MOVE 0 TO CAL-YR-MONTH-OF-YEAR-APPT(THE-INDEX)                              00218200
214700         MOVE 0 TO CAL-YR-MONTH-OF-YEAR-EVENT(THE-INDEX)                             00218300
214800         MOVE 0 TO CAL-YR-MONTH-OF-YEAR-DELET(THE-INDEX)                             00218400
214900      END-PERFORM.                                                                   00218500
215000                                                                                     00218600
215100      PERFORM UPDATE-MONTH-OF-YEAR THRU                                              00218700
215200              UPDATE-MONTH-OF-YEAR-EXIT.                                             00218800
215300      PERFORM WRITE-CALENDAR-CONTROL THRU                                            00218900
215400              WRITE-CALENDAR-CONTROL-EXIT.                                           00219000
215500      GO TO READ-THE-MONTH-RECORD.                                                   00219100
215600                                                                                     00219200
215700 UPDATE-MONTH-OF-YEAR.                                                               00219300
215800      MOVE WS-WORK-DATE-MM       TO THE-INDEX.                                       00219400
215900      ADD 1       TO CAL-YR-MONTH-OF-YEAR-EVENT(THE-INDEX).                          00219500
216000 UPDATE-MONTH-OF-YEAR-EXIT. EXIT.                                                    00219600
216100                                                                                     00219700
216200 HAVE-YEAR-CHECK-MONTH.                                                              00219800
216300      PERFORM UPDATE-MONTH-OF-YEAR THRU                                              00219900
216400              UPDATE-MONTH-OF-YEAR-EXIT.                                             00220000
216500      PERFORM REWRITE-CALENDAR-CONTROL THRU                                          00220100
216600              REWRITE-CALENDAR-CONTROL-EXIT.                                         00220200
216700                                                                                     00220300
216800 READ-THE-MONTH-RECORD.                                                              00220400
216900      MOVE WS-WORK-DATE-MM        TO CAL-KEY-DATE-MM.                                00220500
217000                                                                                     00220600
217100      PERFORM READ-CALENDAR-CONTROL THRU                                             00220700
217200              READ-CALENDAR-CONTROL-EXIT.                                            00220800
217300                                                                                     00220900
217400      IF WS-CLNT-ACCT-NO = CAL-KEY-ACCT-NO                                           00221000
217500         GO TO HAVE-MONTH-CHECK-DAY.                                                 00221100
217600                                                                                     00221200
217700*****  BUILD OF MONTHLY CONTROL RECORD                                               00221300
217800                                                                                     00221400
217810      MOVE WS-CLNT-ACCT-NO        TO CAL-KEY-ACCT-NO.                                00221500
217820      MOVE WS-CLNT-SUB-ACCT       TO CAL-KEY-SUB-ACCT.                               00221600
217900      MOVE ZEROS                  TO CAL-KEY-DATE.                                   00221700
218000      MOVE WS-WORK-DATE-CC        TO CAL-KEY-DATE-CC.                                00221800
218100      MOVE WS-WORK-DATE-YY        TO CAL-KEY-DATE-YY.                                00221900
218200      MOVE WS-WORK-DATE-MM        TO CAL-KEY-DATE-MM.                                00222000
218300      MOVE ZEROS                  TO CAL-KEY-RECORD-NUMBER.                          00222100
218400      MOVE ZEROS                  TO CAL-KEY-SUB-RECORD-NUMBER.                      00222200
218500                                                                                     00222300
218600      MOVE ZEROS                  TO CAL-RECORD-TYPE.                                00222400
218700      MOVE SPACES                 TO CAL-VARIABLE.                                   00222500
218800                                                                                     00222600
218900      PERFORM VARYING THE-INDEX FROM 1 BY 1                                          00222700
219000                      UNTIL THE-INDEX > 31                                           00222800
219100         MOVE 0 TO CAL-MO-DAY-OF-MONTH-APPT(THE-INDEX)                               00222900
219200         MOVE 0 TO CAL-MO-DAY-OF-MONTH-EVENT(THE-INDEX)                              00223000
219300         MOVE 0 TO CAL-MO-DAY-OF-MONTH-DELET(THE-INDEX)                              00223100
219400      END-PERFORM.                                                                   00223200
219500                                                                                     00223300
219600      PERFORM UPDATE-DAY-OF-MONTH THRU                                               00223400
219700              UPDATE-DAY-OF-MONTH-EXIT.                                              00223500
219800      PERFORM WRITE-CALENDAR-CONTROL THRU                                            00223600
219900              WRITE-CALENDAR-CONTROL-EXIT.                                           00223700
220000      GO TO READ-THE-DAY-RECORD.                                                     00223800
220100                                                                                     00223900
220200 UPDATE-DAY-OF-MONTH.                                                                00224000
220300      MOVE WS-WORK-DATE-DD       TO THE-INDEX.                                       00224100
220400      ADD 1       TO CAL-MO-DAY-OF-MONTH-EVENT(THE-INDEX).                           00224200
220500 UPDATE-DAY-OF-MONTH-EXIT. EXIT.                                                     00224300
220600                                                                                     00224400
220700 HAVE-MONTH-CHECK-DAY.                                                               00224500
220800      PERFORM UPDATE-DAY-OF-MONTH THRU                                               00224600
220900              UPDATE-DAY-OF-MONTH-EXIT.                                              00224700
221000      PERFORM REWRITE-CALENDAR-CONTROL THRU                                          00224800
221100              REWRITE-CALENDAR-CONTROL-EXIT.                                         00224900
221200                                                                                     00225000
221300 READ-THE-DAY-RECORD.                                                                00225100
221400      MOVE WS-WORK-DATE-DD        TO CAL-KEY-DATE-DD.                                00225200
221500                                                                                     00225300
221600      PERFORM READ-CALENDAR-CONTROL THRU                                             00225400
221700              READ-CALENDAR-CONTROL-EXIT.                                            00225500
221800                                                                                     00225600
221900      IF WS-CLNT-ACCT-NO = CAL-KEY-ACCT-NO                                           00225700
222000         GO TO HAVE-DAY-GET-CONTROL-NUMBER.                                          00225800
222100                                                                                     00225900
222200*****  BUILD OF DAILY CONTROL RECORD                                                 00226000
222300                                                                                     00226100
222310      MOVE WS-CLNT-ACCT-NO        TO CAL-KEY-ACCT-NO.                                00226200
222320      MOVE WS-CLNT-SUB-ACCT       TO CAL-KEY-SUB-ACCT.                               00226300
222400      MOVE WS-WORK-DATE-CYMD      TO CAL-KEY-DATE.                                   00226400
222500      MOVE ZEROS                  TO CAL-KEY-RECORD-NUMBER.                          00226500
222600      MOVE ZEROS                  TO CAL-KEY-SUB-RECORD-NUMBER.                      00226600
222700                                                                                     00226700
222800      MOVE ZEROS                  TO CAL-RECORD-TYPE.                                00226800
222900      MOVE SPACES                 TO CAL-VARIABLE.                                   00226900
223000      MOVE '0001'                 TO CAL-DAY-NEXT-AVAIL-REC-NUM.                     00227000
223100      MOVE ZEROS                  TO CAL-DAY-OF-MONTH-APPT                           00227100
223200                                     CAL-DAY-OF-MONTH-EVENT                          00227200
223300                                     CAL-DAY-OF-MONTH-DELET.                         00227300
223400      PERFORM WRITE-CALENDAR-CONTROL THRU                                            00227400
223500              WRITE-CALENDAR-CONTROL-EXIT.                                           00227500
223600                                                                                     00227600
223700 HAVE-DAY-GET-CONTROL-NUMBER.                                                        00227700
223800      MOVE CAL-DAY-NEXT-AVAIL-REC-NUM TO WS-NEXT-AVAIL-REC-NUM.                      00227800
223900      ADD  1                     TO CAL-DAY-NEXT-AVAIL-REC-NUM.                      00227900
224000      ADD 1                      TO CAL-DAY-OF-MONTH-EVENT.                          00228000
224100                                                                                     00228100
224200      PERFORM REWRITE-CALENDAR-CONTROL THRU                                          00228200
224300              REWRITE-CALENDAR-CONTROL-EXIT.                                         00228300
224600 SETUP-CONTROL-RECORDS-EXIT. EXIT.                                                   00228400
224700                                                                                     00228500
224800 READ-CALENDAR-CONTROL.                                                              00228600
224900    MOVE F-PRIME TO FILE-KEY.                                                        00228700
225000    MOVE F-READ TO FILE-ACTION.                                                      00228800
225100    CALL TPSIO018 USING FILE-REQUEST TPS-CALENDAR-REC.                               00228900
225200    IF NOT A-SUCCESSFUL-OPERATION                                                    00229000
225300       MOVE ZEROS      TO CAL-KEY-ACCT-NO.                                           00229100
225400**     MOVE 'CALENDAR' TO FILE-NAME                                                  00229200
225500**     MOVE 'READ'     TO FILE-TEXT                                                  00229300
225600**     PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                       00229400
225700**     GO TO TPS4010-COMMON-EXIT.                                                    00229500
225800 READ-CALENDAR-CONTROL-EXIT. EXIT.                                                   00229600
225900                                                                                     00229700
226000                                                                                     00229800
226100 WRITE-CALENDAR-CONTROL.                                                             00229900
226200    MOVE F-PRIME TO FILE-KEY.                                                        00230000
226300    MOVE F-WRITE TO FILE-ACTION.                                                     00230100
226400    CALL TPSIO018 USING FILE-REQUEST TPS-CALENDAR-REC.                               00230200
226500    IF NOT A-SUCCESSFUL-OPERATION                                                    00230300
226600       MOVE 'CALENDAR' TO FILE-NAME                                                  00230400
226700       MOVE 'WRITE'    TO FILE-TEXT                                                  00230500
226800       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                       00230600
226900       GO TO EXIT-THE-MODULE.                                                        00230700
227000 WRITE-CALENDAR-CONTROL-EXIT. EXIT.                                                  00230800
227100                                                                                     00230900
227200 REWRITE-CALENDAR-CONTROL.                                                           00231000
227300    MOVE F-PRIME TO FILE-KEY.                                                        00231100
227400    MOVE F-REWRITE TO FILE-ACTION.                                                   00231200
227500    CALL TPSIO018 USING FILE-REQUEST TPS-CALENDAR-REC.                               00231300
227600*   IF CHANGE-RECORD = 'Y' AND  NO-RECORD-WAS-FOUND                                  00231400
227700*      PERFORM WRITE-THE-CALENDAR THRU                                               00231500
227800*              WRITE-THE-CALENDAR-EXIT                                               00231600
227900*   ELSE                                                                             00231700
228000    IF NOT A-SUCCESSFUL-OPERATION                                                    00231800
228100       MOVE 'CALENDAR' TO FILE-NAME                                                  00231900
228200       MOVE 'REWRITE'  TO FILE-TEXT                                                  00232000
228300       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                       00232100
228400       GO TO EXIT-THE-MODULE.                                                        00232200
228500 REWRITE-CALENDAR-CONTROL-EXIT. EXIT.                                                00232300
228600                                                                                     00232400
228700                                                                                     00232500
228800*------------------------------------------------------------                        00232600
228900*------------------------------------------------------------                        00232700
229000*------------------------------------------------------------                        00232800
229100*------------------------------------------------------------                        00232900
229200                                                                                     00233000
229300                                                                                     00233100
229400                                                                                     00233200
229500                                                                                     00233300
229600 FIGURE-THE-DAY.                                                                     00233400
229700      IF YEAR-OF-HOLIDAYS-MMDD(1:2) < '01' OR > '12'                                 00233500
229900         MOVE 'INVALID MONTH         ' TO                                            00233700
230000                                      TPS4020::MENU-LINE                          00233800
230100         IF SPEC-HOLIDAY-PROCESS                                                     00233900
230200            GO TO FIGURE-THE-DAY-EXIT                                                00234000
230300         ELSE                                                                        00234100
230400            GO TO REPOSITION-CURSOR                                                  00234200
230500         END-IF                                                                      00234300
230600       END-IF.                                                                       00234400
230700                                                                                     00234500
230800      MOVE 24                       TO WS-DATE-PARAM.                                00234600
230900      MOVE SPACES                   TO WS-DATE-EXTEND.                               00234700
231000      MOVE YEAR-OF-HOLIDAYS         TO WS-DATE-REFORM(1:8).                          00234800
231100          CALL TPSDATES USING WS-DATE-REQUEST.                                       00234900
231200      IF YEAR-OF-HOLIDAYS-MMDD(3:2) NOT >                                            00235000
231300                          WS-DATE-REFORM-LEN08(7:2)                                  00235100
231400         GO TO DAY-IS-OK.                                                            00235200
231500                                                                                     00235300
231600      IF SPEC-HOLIDAY-PROCESS                                                        00235400
231700         GO TO FIGURE-THE-DAY-EXIT.                                                  00235500
231900      MOVE 'INVALID DAY OF MONTH  ' TO                                               00235700
232000                                   TPS4020::MENU-LINE.                            00235800
232100                                                                                     00235900
232200 REPOSITION-CURSOR.                                                                  00236000
232300      IF CURRENT-CURSOR  = 2                                                         00236100
232400         MOVE 62                TO CURRENT-CURSOR                                    00236200
232500      ELSE                                                                           00236300
232600         SUBTRACT 4           FROM CURRENT-CURSOR.                                   00236400
232700      MOVE CURRENT-CURSOR       TO TPS4020::ACTIVE-FIELD.                         00236500
232900      GO TO REDISPLAY-PANEL-TPS4020.                                                 00236700
233000                                                                                     00236800
233100 DAY-IS-OK.                                                                          00236900
233200**    IF YEAR-OF-HOLIDAYS-MMDD(1:4) < WS-PREV-DAY-MMDD                               00237000
233300**       MOVE 1                 TO TPS4020-DISPLAY-OPTION                            00237100
233400**       MOVE 'DATE LESSER VALUE THAN PREVIOUS DATE' TO                              00237200
233500**                                    TPS4020::MENU-LINE                          00237300
233600**       GO TO REPOSITION-CURSOR.                                                    00237400
233700                                                                                     00237500
233800      MOVE YEAR-OF-HOLIDAYS-MMDD(1:4) TO WS-PREV-DAY-MMDD.                           00237600
233900      MOVE 23                       TO WS-DATE-PARAM.                                00237700
234000      MOVE SPACES                   TO WS-DATE-EXTEND.                               00237800
234100      MOVE YEAR-OF-HOLIDAYS         TO WS-DATE-REFORM(1:8).                          00237900
234200          CALL TPSDATES USING WS-DATE-REQUEST.                                       00238000
234300      MOVE WS-DATE-REFORM-LEN08(9:1) TO DOW.                                         00238100
234400                                                                                     00238200
234500      PERFORM VARYING DAYS-INDEX FROM 1 BY 1                                         00238300
234600              UNTIL DAYS-INDEX > 7                                                   00238400
234700         IF DAY-VALUE(DAYS-INDEX) = DOW                                              00238500
234800              MOVE DAY-NAME(DAYS-INDEX) TO THE-DAY                                   00238600
234900              GO TO FIGURE-THE-DAY-EXIT                                              00238700
235000         END-IF                                                                      00238800
235100      END-PERFORM.                                                                   00238900
235200 FIGURE-THE-DAY-EXIT. EXIT.                                                          00239000
235300                                                                                     00239100
235400                                                                                     00239200
235500                                                                                     00239300
235600 EXIT-THE-MODULE.                                                                    00239400
235700      PERFORM CLOSE-THE-FILES THRU                                                   00239500
235800              CLOSE-THE-FILES-EXIT.                                                  00239600
235900      CANCEL TPSDATES.                                                               00239700
236000      CANCEL TPSIOERR.                                                               00239800
236100      CANCEL TPSIO018.                                                               00239900
236200      CANCEL FLOATBIG.                                                               00240000
236300      CANCEL FLOATIT.                                                                00240100

           INITIALIZE CURRENT-XY-PARAMETERS.
           MOVE WS-CURRENT-X TO CURRENT-XY-PARAMETERS(1:4).
           MOVE WS-CURRENT-Y TO CURRENT-XY-PARAMETERS(5:4).

           IF PROCESS-2-DISPLAY-FLAG = 1
               INVOKE PROCESS-2::Hide
               MOVE 0 TO PROCESS-2-DISPLAY-FLAG
           END-IF.

           IF CLOSE-ALL-FORMS-FLAG = 0
               SET TPS4020::KEY-PRESSED TO "End Key"
               SET TPS4020A::KEY-PRESSED TO "End Key"
               SET TPS4021::KEY-PRESSED TO "End Key"
               SET TPS4022::KEY-PRESSED TO "End Key"
               SET TPS4022A::KEY-PRESSED TO "End Key"
               SET TPS4022B::KEY-PRESSED TO "End Key"
               SET TPS4025::KEY-PRESSED TO "End Key"
               SET TPS4000::KEY-PRESSED TO "End Key"
               INVOKE TPS4020::Close
               INVOKE TPS4020A::Close
               INVOKE TPS4021::Close
               INVOKE TPS4022::Close
               INVOKE TPS4022A::Close
               INVOKE TPS4022B::Close
               INVOKE TPS4025::Close
               INVOKE TPS4000::Close
               MOVE 1 TO CLOSE-ALL-FORMS-FLAG
           END-IF.

236400      GOBACK GIVING CURRENT-XY-PARAMETERS.                                                                       
236500                                                                                     00240300
236600                                                                                     00240400
236700 PRINT-HOLIDAYS.                                                                     00240500
236800      OPEN OUTPUT PRT-FILE.                                                          00240600
236900      MOVE 0                    TO TPS4022::ACTIVE-FIELD.                         00240700
237100      MOVE ZEROS                TO TPS4025-YEAR-TO-PRINT.                            00240900
237200                                                                                     00241000
237300 DISPLAY-PANEL-TPS4025.

           MOVE TPS4025-YEAR-TO-PRINT TO TPS4025::YEAR-TO-PRINT.                           00241100

           set TPS4000 to new TPS000.TPS4000Form().
           MOVE 1 TO TPS4000::SPLASH-SCREEN-FLAG.
           IF TPS4000-DISPLAY-FLAG = 0
               SET TPS4000::X-POINT TO WS-X-PARM
               SET TPS4000::Y-POINT TO WS-Y-PARM
               SET TPS4000::Width TO 1
               SET TPS4000::Height TO 1
               INVOKE TPS4000::Show
               SET TPS4000::Width TO 1205
               SET TPS4000::Height TO 793
               INVOKE TPS4000::Show
               MOVE 1 TO TPS4000-DISPLAY-FLAG
           END-IF.
           MOVE 0 TO TPS4000::SPLASH-SCREEN-FLAG.

           SET TPS4025::X-POINT TO WS-X-PARM.
           SET TPS4025::Y-POINT TO WS-Y-PARM.
           INVOKE TPS4025::ShowDialog.
           MOVE TPS4025::SCREEN-NAME TO SCREEN-NAME.
           MOVE TPS4025::Location::X TO WS-X-PARM
             WS-CURRENT-X.
           MOVE TPS4025::Location::Y TO WS-Y-PARM
             WS-CURRENT-Y.


238100     MOVE TPS4025::YEAR-TO-PRINT TO TPS4025-YEAR-TO-PRINT.

238200     IF TPS4025::KEY-PRESSED = "End Key"
               INVOKE TPS4000::Hide
               MOVE 0 TO TPS4000-DISPLAY-FLAG
               GO TO EXIT-THE-MODULE
           END-IF.
238300                                                                                     00242100
238400                                                                                     00242200
238500      IF NOT TPS4025::KEY-PRESSED = "Enter Key"                                        00242300
238700         MOVE 'ENTER - PROCESS, END - PREVIOUS MENU' TO                              00242500
238800                                      TPS4025::MENU-LINE                          00242600
238900         GO TO DISPLAY-PANEL-TPS4025.                                                00242700

           INVOKE TPS4000::Hide.
           MOVE 0 TO TPS4000-DISPLAY-FLAG.
=
239100      MOVE 03                   TO WS-DATE-PARAM.                                    00242900
239200      MOVE WS-TODAYS-DATE-YMD   TO WS-DATE-REFORM.                                   00243000
239300      MOVE SPACES               TO WS-DATE-EXTEND.                                   00243100
239400         CALL TPSDATES USING WS-DATE-REQUEST.                                        00243200
239500      MOVE WS-DATE-REFORM-LEN08 TO HEAD-01-DATE.                                     00243300
239600                                                                                     00243400
239700      MOVE HIGH-VALUES          TO RECORD-SAVE.                                      00243500
239800                                                                                     00243600
239900      MOVE '9999999999'         TO CAL-KEY-ACCT-NO.                                  00243700
240000      MOVE '00'                 TO CAL-KEY-SUB-ACCT.                                 00243800
240100      MOVE ZEROS                TO CAL-KEY-DATE                                      00243900
240200                                   CAL-KEY-RECORD-NUMBER                             00244000
240300                                   CAL-KEY-SUB-RECORD-NUMBER.                        00244100
240400      MOVE TPS4025-YEAR-TO-PRINT TO CAL-KEY-DATE(1:4)                                00244200
240500                                    HEAD-01-WHATYEAR.                                00244300
240600                                                                                     00244400
240700      MOVE F-PRIME      TO FILE-KEY.                                                 00244500
240800      MOVE F-START      TO FILE-ACTION.                                              00244600
240900      CALL TPSIO018 USING FILE-REQUEST TPS-CALENDAR-REC.                             00244700
241000      IF FILE-STATUS NOT = '00' AND '05'                                             00244800
241100         MOVE 'TPS4020 ' TO FILE-NAME                                                00244900
241200         MOVE 'P-START ' TO FILE-TEXT                                                00245000
241300         PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                     00245100
241400         GO TO EXIT-THE-MODULE.                                                      00245200
241500                                                                                     00245300
241600                                                                                     00245400
241700 PRINT-ALL-HOLIDAYS.                                                                 00245500
241800      MOVE F-PRIME      TO FILE-KEY.                                                 00245600
241900      MOVE F-READ-NEXT  TO FILE-ACTION.                                              00245700
242000      CALL TPSIO018 USING FILE-REQUEST TPS-CALENDAR-REC.                             00245800
242100      IF FILE-STATUS NOT = '00' AND '05' AND '10'                                    00245900
242200         MOVE 'TPS4020 ' TO FILE-NAME                                                00246000
242300         MOVE 'P-READ-NEXT' TO FILE-TEXT                                             00246100
242400         PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                     00246200
242500         GO TO EXIT-THE-MODULE.                                                      00246300
242600                                                                                     00246400
242700      IF CAL-KEY = HIGH-VALUES                                                       00246500
242800         IF FIRST-READ-FOR-PRINT                                                     00246600
243000            MOVE DOESNT-EXIST     TO TPS4025::MENU-LINE                           00246800
243100            GO TO DISPLAY-PANEL-TPS4025                                              00246900
243200         END-IF                                                                      00247000
243300         GO TO ISSUE-PRINT-COMMAND                                                   00247100
243400      END-IF.                                                                        00247200
243500                                                                                     00247300
243600      IF NOT CAL-HOLIDAY-REC                                                         00247400
243700         GO TO PRINT-ALL-HOLIDAYS.                                                   00247500
243800                                                                                     00247600
243900      IF CAL-APPT-ADD-DATE(1:1) = '8' or '9'                                         00247700
244000         GO TO PRINT-ALL-HOLIDAYS.                                                   00247800
244100                                                                                     00247900
244200      IF CAL-KEY-DATE-DD = '99'                                                      00248000
244300         GO TO PRINT-ALL-HOLIDAYS.                                                   00248100
244400                                                                                     00248200
244500      IF TPS4025-YEAR-TO-PRINT NOT = CAL-KEY-DATE(1:4)                               00248300
244600         GO TO PRINT-ALL-HOLIDAYS.                                                   00248400
244700                                                                                     00248500
244800     IF FIRST-READ-FOR-PRINT
               MOVE '1' TO HOLIDAY-READ-PRINT-FLAG
               IF PROCESS-2-DISPLAY-FLAG = 0
                   MOVE 1 TO PROCESS-2-DISPLAY-FLAG                                        00248600
                   set PROCESS-2 to new TPS000.PROCESS_2Form                               00248700
                   SET PROCESS-2::X-POINT TO WS-X-PARM
                   SET PROCESS-2::Y-POINT TO WS-Y-PARM
                   INVOKE PROCESS-2::Show
                   MOVE PROCESS-2::Location::X TO WS-X-PARM
                     WS-CURRENT-X
                   MOVE PROCESS-2::Location::Y TO WS-Y-PARM
                     WS-CURRENT-Y
                   MOVE PROCESS-2::SCREEN-NAME TO SCREEN-NAME
               END-IF
245600     END-IF.                                                                         00249400
245700                                                                                     00249500
245800      IF PAGE-LINE-COUNT < 1                                                         00249600
245900         PERFORM PAGE-BREAK THRU                                                     00249700
246000                 PAGE-BREAK-EXIT.                                                    00249800
246100                                                                                     00249900
246200      SUBTRACT 1                 FROM PAGE-LINE-COUNT.                               00250000
246300                                                                                     00250100
246400      MOVE 03                      TO WS-DATE-PARAM.                                 00250200
246500      MOVE SPACES                  TO WS-DATE-EXTEND.                                00250300
246600      MOVE CAL-KEY-DATE(3:6)       TO WS-DATE-REFORM(1:6).                           00250400
246700          CALL TPSDATES USING WS-DATE-REQUEST.                                       00250500
246800      MOVE WS-DATE-REFORM-LEN08    TO P-HOLIDAY-DATE.                                00250600
246900                                                                                     00250700
247000      IF CAL-KEY-DATE-DD = ZEROS                                                     00250800
247100         MOVE '*'                 TO P-HOLIDAY-DATE-NG                               00250900
247200      ELSE                                                                           00251000
247300         MOVE CAL-KEY-DATE        TO YEAR-OF-HOLIDAYS                                00251100
247400           PERFORM FIGURE-THE-DAY                                                    00251200
247500              THRU FIGURE-THE-DAY-EXIT                                               00251300
247600         MOVE THE-DAY             TO P-HOLIDAY-DAY-OF-WEEK                           00251400
247700      END-IF.                                                                        00251500
247800                                                                                     00251600
247900      MOVE CAL-APPT-APPOINT-DATA(8:30)                                               00251700
248000                                TO P-HOLIDAY-NAME.                                   00251800
248100                                                                                     00251900
248200      MOVE SPACES               TO FULL-LINE-PRINT.                                  00252000
248300      ADD  0050                 TO PCL5-VC-DOTS-VALUE.                               00252100
248400      MOVE PCL5-V-CURSOR-NUM-DOTS TO PCL.                                            00252200
248500      MOVE HOLIDAY-PRINT     TO FULL-LINE-PRINT.                                     00252300
248600      WRITE PRT-RECORD FROM JCL-PCL.                                                 00252400
248700      MOVE SPACES               TO HOLIDAY-PRINT.                                    00252500
248800      GO TO PRINT-ALL-HOLIDAYS.                                                      00252600
248900                                                                                     00252700
249000                                                                                     00252800
249100 ISSUE-PRINT-COMMAND.                                                                00252900
249200      CLOSE PRT-FILE.                                                                00253000
249300      DISPLAY PRT-COMMAND-1 UPON COMMAND-LINE.                                       00253100
249400      CALL X'91' USING RESULT FUNCTION-35 NULL-PARAMETER.                            00253200
249500      GO TO EXIT-THE-MODULE.                                                         00253300
249600                                                                                     00253400
249700                                                                                     00253500
249800 OPEN-THE-FILES.                                                                     00253600
249900    MOVE F-PRIME      TO FILE-KEY.                                                   00253700
250000    MOVE F-OPEN-I-O TO FILE-ACTION.                                                  00253800
250100    CALL TPSIO018 USING FILE-REQUEST TPS-CALENDAR-REC.                               00253900
250200    IF FILE-STATUS NOT = '00' AND '05'                                               00254000
250300       MOVE 'TPS4020 ' TO FILE-NAME                                                  00254100
250400       MOVE 'OPEN-I-O' TO FILE-TEXT                                                  00254200
250500       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                       00254300
250600       GO TO EXIT-THE-MODULE                                                         00254400
250700    END-IF.                                                                          00254500
250800 OPEN-THE-FILES-EXIT. EXIT.                                                          00254600
250900                                                                                     00254700
251000 CLOSE-THE-FILES.                                                                    00254800
251100    MOVE F-PRIME TO FILE-KEY.                                                        00254900
251200    MOVE F-CLOSE TO FILE-ACTION.                                                     00255000
251300    CALL TPSIO018 USING FILE-REQUEST TPS-CALENDAR-REC.                               00255100
251400    IF NOT A-SUCCESSFUL-OPERATION                                                    00255200
251500       MOVE 'TPS4020 ' TO FILE-NAME                                                  00255300
251600       MOVE 'CLOSE'    TO FILE-TEXT                                                  00255400
251700       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                       00255500
251800    END-IF.                                                                          00255600
251900 CLOSE-THE-FILES-EXIT. EXIT.                                                         00255700
252000                                                                                     00255800
252100 WRITE-THE-CALENDAR.                                                                 00255900
252200    MOVE TPS-CALENDAR-REC       TO SAV-CALENDAR-REC.                                 00256000
252300                                                                                     00256100
252400    MOVE F-PRIME TO FILE-KEY.                                                        00256200
252500    MOVE F-READ TO FILE-ACTION.                                                      00256300
252600    CALL TPSIO018 USING FILE-REQUEST TPS-CALENDAR-REC.                               00256400
252700    IF NOT A-SUCCESSFUL-OPERATION                                                    00256500
252800       GO TO WRITE-NEW-RECORD.                                                       00256600
252900                                                                                     00256700
253000    MOVE SAV-CALENDAR-REC       TO TPS-CALENDAR-REC.                                 00256800
253100                                                                                     00256900
253200    MOVE F-PRIME TO FILE-KEY.                                                        00257000
253300    MOVE F-REWRITE TO FILE-ACTION.                                                   00257100
253400    CALL TPSIO018 USING FILE-REQUEST TPS-CALENDAR-REC.                               00257200
253500    IF NOT A-SUCCESSFUL-OPERATION                                                    00257300
253600       MOVE 'TPS4020 ' TO FILE-NAME                                                  00257400
253700       MOVE 'REWRITE'     TO FILE-TEXT                                               00257500
253800       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                       00257600
253900       GO TO EXIT-THE-MODULE.                                                        00257700
254000    GO TO WRITE-THE-CALENDAR-EXIT.                                                   00257800
254100                                                                                     00257900
254200 WRITE-NEW-RECORD.                                                                   00258000
254300    MOVE F-PRIME TO FILE-KEY.                                                        00258100
254400    MOVE F-WRITE TO FILE-ACTION.                                                     00258200
254500    CALL TPSIO018 USING FILE-REQUEST TPS-CALENDAR-REC.                               00258300
254600*   IF FILE-REQUEST(3:2) = '22'                                                      00258400
254700*        ADD 1        TO CAL-KEY-RECORD-NUMBER                                       00258500
254800*        GO TO WRITE-THE-CALENDAR.                                                   00258600
254900    IF NOT A-SUCCESSFUL-OPERATION                                                    00258700
255000       MOVE 'TPS4020 ' TO FILE-NAME                                                  00258800
255100       MOVE 'WRITE'    TO FILE-TEXT                                                  00258900
255200       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                       00259000
255300       GO TO EXIT-THE-MODULE.                                                        00259100
255400 WRITE-THE-CALENDAR-EXIT. EXIT.                                                      00259200
255500                                                                                     00259300
255600                                                                                     00259400
255700 FILE-ERROR.                                                                         00259500
255800      CALL TPSIOERR USING FILE-REQUEST
                                WS-CURRENT-XY-PARM.
255900      CANCEL TPSIOERR.
           
            MOVE WS-CURRENT-XY-PARM(1:4) TO WS-CURRENT-X.
            MOVE WS-CURRENT-XY-PARM(5:4) TO WS-CURRENT-Y.

            INITIALIZE CURRENT-XY-PARAMETERS.
            MOVE WS-CURRENT-X TO CURRENT-XY-PARAMETERS(1:4).
            MOVE WS-CURRENT-Y TO CURRENT-XY-PARAMETERS(5:4).

           IF CLOSE-ALL-FORMS-FLAG = 0
               SET TPS4020::KEY-PRESSED TO "End Key"
               SET TPS4020A::KEY-PRESSED TO "End Key"
               SET TPS4021::KEY-PRESSED TO "End Key"
               SET TPS4022::KEY-PRESSED TO "End Key"
               SET TPS4022A::KEY-PRESSED TO "End Key"
               SET TPS4022B::KEY-PRESSED TO "End Key"
               SET TPS4025::KEY-PRESSED TO "End Key"
               SET TPS4000::KEY-PRESSED TO "End Key"
               INVOKE TPS4020::Close
               INVOKE TPS4020A::Close
               INVOKE TPS4021::Close
               INVOKE TPS4022::Close
               INVOKE TPS4022A::Close
               INVOKE TPS4022B::Close
               INVOKE TPS4025::Close
               INVOKE TPS4000::Close
               MOVE 1 TO CLOSE-ALL-FORMS-FLAG
           END-IF.

256000 FILE-ERROR-EXIT. EXIT.                                                              00259800
256100                                                                                     00259900
256200*QQQQQQQQQQQQQQQQQQQQQQQQQQQQQ                                                       00260000
256300                                                                                     00260100
256400 PAGE-BREAK.                                                                         00260200
256500      MOVE  SPACES               TO FULL-LINE-PRINT.                                 00260300
256600      MOVE 46                    TO PAGE-LINE-COUNT.                                 00260400
256700      WRITE PRT-RECORD FROM PCL-EJECT-PAGE AFTER ADVANCING 0 LINES.                  00260500
256800                                                                                     00260600
256900      WRITE PRT-RECORD FROM PCL5-PRM-SPACE-PROPO                                     00260700
257000                       AFTER ADVANCING 0 LINES.                                      00260800
257100      WRITE PRT-RECORD FROM PCL5-LINE-SPACE-08LPI                                    00260900
257200                       AFTER ADVANCING 0 LINES.                                      00261000
257300      MOVE 0010                 TO PCL5-CPI-VALUE.                                   00261100
257400      WRITE PRT-RECORD FROM PCL5-PRIMARY-PITCH-CPI                                   00261200
257500                       AFTER ADVANCING 0 LINES.                                      00261300
257600      MOVE 12                   TO PCL5-POINTS-VALUE.                                00261400
257700      WRITE PRT-RECORD FROM PCL5-PRIMARY-HEIGHT                                      00261500
257800                       AFTER ADVANCING 0 LINES.                                      00261600
257900      WRITE PRT-RECORD FROM PCL5-STYLE-ITALIC                                        00261700
258000                       AFTER ADVANCING 0 LINES.                                      00261800
258100      WRITE PRT-RECORD FROM PCL5-WT-BOLD                                             00261900
258200                       AFTER ADVANCING 0 LINES.                                      00262000
258300                                                                                     00262100
258400      ADD 1                     TO PAGE-NUMBER.                                      00262200
258500      MOVE PAGE-NUMBER          TO HEAD-01-PAGE.                                     00262300
258600      MOVE SPACES               TO FULL-LINE-PRINT.                                  00262400
258700      MOVE 0050                 TO PCL5-HC-DOTS-VALUE.                               00262500
258800      MOVE 0100                 TO PCL5-VC-DOTS-VALUE.                               00262600
258900      MOVE PCL5-V-CURSOR-NUM-DOTS TO PCL.                                            00262700
259000      MOVE HEAD-01           TO FULL-LINE-PRINT.                                     00262800
259100      WRITE PRT-RECORD FROM JCL-PCL.                                                 00262900
259200                                                                                     00263000
259300*     WRITE PRT-RECORD FROM PCL5-FONT-PC8                                            00263100
259400*                      AFTER ADVANCING 0 LINES.                                      00263200
259500      WRITE PRT-RECORD FROM PCL5-PRM-SPACE-FIXED                                     00263300
259600                       AFTER ADVANCING 0 LINES.                                      00263400
259700*     WRITE PRT-RECORD FROM PCL5-LINE-SPACE-08LPI                                    00263500
259800*                      AFTER ADVANCING 0 LINES.                                      00263600
259900*     MOVE 0010                 TO PCL5-CPI-VALUE.                                   00263700
260000*     WRITE PRT-RECORD FROM PCL5-PRIMARY-PITCH-CPI                                   00263800
260100*                      AFTER ADVANCING 0 LINES.                                      00263900
260200      MOVE 10                   TO PCL5-POINTS-VALUE.                                00264000
260300      WRITE PRT-RECORD FROM PCL5-PRIMARY-HEIGHT                                      00264100
260400                       AFTER ADVANCING 0 LINES.                                      00264200
260500****  WRITE PRT-RECORD FROM PCL5-STYLE-ITALIC                                        00264300
260600      WRITE PRT-RECORD FROM PCL5-STYLE-UPRIGHT                                       00264400
260700                       AFTER ADVANCING 0 LINES.                                      00264500
260800*     WRITE PRT-RECORD FROM PCL5-FAM-LTTR-GOTHIC                                     00264600
260900*                      AFTER ADVANCING 0 LINES.                                      00264700
261000****  WRITE PRT-RECORD FROM PCL5-WT-BOLD                                             00264800
261100      WRITE PRT-RECORD FROM PCL5-WT-MEDIUM                                           00264900
261200                       AFTER ADVANCING 0 LINES.                                      00265000
261300                                                                                     00265100
261400      MOVE SPACES               TO FULL-LINE-PRINT.                                  00265200
261500      ADD  0075                 TO PCL5-VC-DOTS-VALUE.                               00265300
261600      MOVE PCL5-V-CURSOR-NUM-DOTS TO PCL.                                            00265400
261700      MOVE SUB-HEAD-01       TO FULL-LINE-PRINT.                                     00265500
261800      WRITE PRT-RECORD FROM JCL-PCL.                                                 00265600
261900                                                                                     00265700
262000      ADD  0025                 TO PCL5-VC-DOTS-VALUE.                               00265800
262100                                                                                     00265900
262200 PAGE-BREAK-EXIT. EXIT.                                                              00266000
262300                                                                                     00266100
262400*----------------------------------------------------------------                    00266200
262500*----------------------------------------------------------------                    00266300
262600*----------------------------------------------------------------                    00266400
262700*----------------------------------------------------------------                    00266500
262800*----------------------------------------------------------------                    00266600
262900*----------------------------------------------------------------                    00266700
263000                                                                                     00266800
263100                                                                                     00266900
