000100 IDENTIFICATION DIVISION.
000200 PROGRAM-ID. TPS021T.
000300 AUTHOR. T S.
000400***************************************************************
000500*       DAILY LIST OF MAIL RECEIVED BY ADMINISTRATOR          *                                                   
000600***************************************************************
000601*  PROGRAM IS CALLED BY TPS006 every day and using the last   *
000602*  P.A. MONITOR BUSINESS DATE ACCUMULATES THE MAIL PROCESSED  *
000604*  FOR THAT DAY.............................................. *
000610***************************************************************
000700*                 MAINTENANCE LOG                             *
      * 07/13/17 CHANGED GUI                                     AC *   
121300* 10/06/05 -if mail-admin-xxxxxx = spaces & recur-admin-logon *                                                     
121300*    ts     not = spaces use that fields data......           *                                                   
121300* 04/01/04 -took out daily call to this program and added     *
121300*    JM    -screen to enter run date.                         *
121300* 06/21/01 -converted program to use pcl, page breaks, 10 col-*                                                   
121300*    ts     umns, time stamp, duplex printing.                *                                                   
121300*          -program executed via panel tps0036 or automatic   *                                                   
121300*           overnite via tps006...................            *                                                   
121300*                                                             *                                                   
000900***************************************************************
001000 ENVIRONMENT DIVISION.
001100 CONFIGURATION SECTION.
001200 SOURCE-COMPUTER. IBM-PS2.
001300 OBJECT-COMPUTER. IBM-PS2.
001400 FILE-CONTROL.
001710***  SELECT PRT-FILE ASSIGN TO "lpt1"                                                                             
001710     SELECT PRT-FILE ASSIGN TO REPORT-ASSIGNMENT                                                                  
001900         ORGANIZATION IS LINE SEQUENTIAL
002000         FILE STATUS IS TPS-FILE-STATUS.
003300
002600     SELECT BAT-FILE  ASSIGN TO BATCH-ASSIGNMENT
002700         FILE STATUS IS BAT-FILE-STATUS
002800         ORGANIZATION IS LINE SEQUENTIAL.
003300
002100 DATA DIVISION.
002200 FILE SECTION.
005500 FD  PRT-FILE 
005600     LABEL RECORDS ARE OMITTED
005700     RECORD CONTAINS 150 CHARACTERS.
005800 01  PRT-RECORD.                                                                                                  
005900     10 PRT-VARIABLE             PIC X(150).                                                                      
006000     10 FILLER REDEFINES PRT-VARIABLE.                                                                            
006200        15 PRT-CAT-DESCRIP        PIC X(40).                                                                      
006300        15 FILLER                 PIC X(02).
007200        15 PRT-CNT-MAIL-TODAY     PIC X(108).                                                                     
007300        15 FILLER REDEFINES PRT-CNT-MAIL-TODAY OCCURS 12 TIMES.                                                   
007400           20 FILLER              PIC X(04).
007500           20 PRT-CNT-TODAY       PIC ZZZZ9.
007800     10 FILLER REDEFINES PRT-VARIABLE.
007900        15 PRT-RECAP-NAME         PIC X(36).                                                                      
008300        15 FILLER                 PIC X(03).
008400        15 PRT-RECAP-COUNT        PIC ZZZZ9.                                                                      
008500        15 FILLER                 PIC X(03).
008600        15 PRT-RECAP-PCT          PIC X(06).                                                                      
008710        15 FILLER                 PIC X(10).
008800        15 PRT-RECAP-LOGON        PIC X(05).                                                                      
008900        15 FILLER                 PIC X(04).
008800        15 PRT-RECAP-LOGOFF       PIC X(05).                                                                      
009100        15 FILLER                 PIC X(22).
009100        15 FILLER                 PIC X(51).
003400                                                                                                                  
004000 FD  BAT-FILE
004100     LABEL RECORDS ARE OMITTED
004200     RECORD CONTAINS 080 CHARACTERS.
004300 01  BAT-RECORD PIC X(080).
004800
009300
009400
009500 WORKING-STORAGE SECTION.
009520 01  REPORT-ASSIGNMENT.                                                                                           
009520     05 FILLER                    PIC X(25) VALUE
009530       '\TPS\PROD\FILES\TPSREPRT\'.                                                                               
009520     05 FILLER                    PIC X(02) VALUE
009530       'pa'.                                                                                                      
009520     05 FILE-REPORT-NAME          PIC X(06) VALUE                                                                 
009600       'YYMMDD'.                                                                                                  
009520     05 FILLER                    PIC X(04) VALUE
009530       '.pcl'.                                                                                                    
009520                                                                                                                  
004900
005600 01  BATCH-ASSIGNMENT.
009520     05 FILLER                    PIC X(25) VALUE
009530       '\TPS\PROD\FILES\TPSREPRT\'.                                                                               
009520     05 FILLER                    PIC X(02) VALUE
009530       'pa'.                                                                                                      
009520     05 bat-assign-name           PIC X(06) VALUE                                                                 
009600       'YYMMDD'.                                                                                                  
009520     05 FILLER                    PIC X(04) VALUE
009530       '.bat'.                                                                                                    
006300
012800 01 BAT-FILE-STATUS         PIC 9(02) value zeros.
012900
009520 01  BAT-CREATION.                                                                                                
009520     05 FILLER                    PIC X(27) VALUE                                                                 
009530       'P \TPS\PROD\FILES\TPSREPRT\'.                                                                             
009520     05 FILLER                    PIC X(02) VALUE
009530       'pa'.                                                                                                      
009520     05 BAT-REPORT-NAME           PIC X(06) VALUE                                                                 
009600       'YYMMDD'.                                                                                                  
009520     05 FILLER                    PIC X(04) VALUE
009530       '.pcl'.                                                                                                    
009600
009600 01  bat-command.                                                                                                 
009520     05 FILLER                    PIC X(25) VALUE                                                                 
009530       '\TPS\PROD\FILES\TPSREPRT\'.                                                                               
009520     05 FILLER                    PIC X(02) VALUE
009530       'pa'.                                                                                                      
009520     05 BAT-command-NAME          PIC X(06) VALUE
009600       'YYMMDD'.                                                                                                  
009520     05 FILLER                    PIC X(04) VALUE
009530       '.bat'.                                                                                                    
009600
009600 01  result                       pic  99 comp-x.
009600 01  function-35                  pic  99 comp-x value 35.
009600 01  null-parameter.                                                                                              
009600     05  filler                   pic  99 comp-x value 0.                                                         
009600     05  filler                   pic  x.                                                                         
009600
009600
145000 01  FULL-LINE-PRINT            PIC  X(100) VALUE SPACES.                                                         
009600
009610
009700     COPY "TPSFILES.CPY".
009800     COPY "KEYVALUE.CPY".
009810     COPY "PCL5VALU.CPY".
065500     COPY "PCLVALUE.CPY".
009400
009900
010000 01  TPS-MAIL-REC.
010100     COPY "TPSMAIL.CPY".
010200
010300 01  TPS-LOGON-REC.
010400     COPY "TPSLOGON.CPY".
010500
010600 01  TPS-PROFL-REC.
010700     COPY "TPSPROFL.CPY".
010500
010600 01  TPS-PAMON-REC.                                                                                               
010700     COPY "TPSPAMON.CPY".                                                                                         
010500
010600 01  TPS-TRACK-REC.                                                                                               
010700     COPY "TPSTRACK.CPY".                                                                                         
010800
010900  COPY TPS021T.COB.
010900  COPY PROCESS.COB.
010901  COPY PRINTING.COB.
011000
011600
011702 01  PRT-HDR1pg1.                                                                                                 
011706        15 FILLER                 PIC X(02) VALUE SPACES.                                                         
011704        15 FILLER                 PIC X(40) VALUE
011705          'Daily Report of Administrators Activity'.                                                              
011706        15 FILLER                 PIC X(05) VALUE SPACES.
011707        15 PRT-HDR1pg1-DATE       PIC X(10).                                                                      
011706        15 FILLER                 PIC X(10) VALUE SPACES.                                                         
011710        15 FILLER                 PIC X(05) VALUE 'Page '.
011711        15 PRT-HDR1pg1-PAGE-NUM   PIC ZZ9.                                                                        
011712
011713 01  PAGE-COUNT                   PIC  9(03) VALUE ZEROS.
011713 01  two-per-page                 PIC  9(01) VALUE ZEROS.                                                         
011714
011715 01  PRT-HDR2pg1.                                                                                                 
011706        15 FILLER                 PIC X(10) VALUE SPACES.
011718        15 FILLER                 PIC X(17) VALUE
011719          'For Receive Date '.                                                                                    
011720        15 FOR-what-daypg1        PIC X(50) VALUE SPACES.                                                         
011724
011725
011726*******   '1234567890123456789012345678901234567890'.
011727 01  PRT-HDR3pg1.                                                                                                 
011728******* 15 FILLER                 PIC X(10) VALUE SPACES.
011730        15 FILLER                 PIC X(36) VALUE
011731          '     Administrator                  '.
011732        15 FILLER                 PIC X(03) VALUE SPACES.
011733        15 FILLER                 PIC X(05) VALUE '  DAY'.
011734        15 FILLER                 PIC X(03) VALUE SPACES.
011735        15 FILLER                 PIC X(06) VALUE ' % DAY'.
011736******* 15 FILLER                 PIC X(03) VALUE SPACES.
011737        15 FILLER                 PIC X(10) VALUE SPACES.                                                         
011738        15 FILLER                 PIC X(05) VALUE 'LOGON'.
011739        15 FILLER                 PIC X(03) VALUE SPACES.
011740        15 FILLER                 PIC X(06) VALUE 'LOGOFF'.
011743
011745
011000
011600
016400*          1234567890123456789012345678901234567890                                                               
011702 01  PRT-HDR1pg2.                                                                                                 
011706        15 FILLER                 PIC X(05) VALUE SPACES.                                                         
011704        15 FILLER                 PIC X(40) VALUE
011705          'Daily Report of Administrators Activity '.                                                             
011718        15 FILLER                 PIC X(17) VALUE
011719          'For Receive Date '.                                                                                    
011720        15 FOR-what-daypg2        PIC X(50) VALUE SPACES.                                                         
011718        15 FILLER                 PIC X(01) VALUE ':'.                                                            
011706        15 FILLER                 PIC X(15) VALUE SPACES.
011707        15 PRT-HDR1pg2-DATE       PIC X(10).                                                                      
011706        15 FILLER                 PIC X(10) VALUE SPACES.                                                         
011710        15 FILLER                 PIC X(05) VALUE 'Page '.
011711        15 PRT-HDR1pg2-PAGE-NUM   PIC ZZ9.                                                                        
011712
011714
011746 01  PRT-HDR4pg2.                                                                                                 
011747        15 FILLER                 PIC X(40) VALUE
011748          '       Communications Category          '.
011749        15 FILLER                 PIC X(02) VALUE SPACES.
007200        15 PRT-HDR4pg2-LOGONS     PIC X(90).                                                                      
007300        15 FILLER REDEFINES PRT-HDR4pg2-LOGONS OCCURS 10 TIMES.                                                   
007400           20 FILLER              PIC X(02).
007500           20 PRT-HDR4pg2-LOGON   PIC X(07).                                                                      
007600        15 FILLER                 PIC X(04).
011745
011745
011810 01 PREV-LOGON             PIC X(08) VALUE SPACES.
011900
011910 01 WHICH-HALF-FLAG        PIC 9(01) VALUE 0.
011920    88 FIRST-HALF                    VALUE 0.
011930    88 SECOND-HALF                   VALUE 1.
012000
012600
012700 01 CURRENT-ACCT         PIC 9(10) VALUE ZEROS.                                                                   
012800 01  GUISCREEN               PIC x(08) VALUE 'GS      '.
012900 01  PROGRAM-NAMES.
013000     10  TPSIOERR        PIC X(08) VALUE 'TPSIOERR'.                                                              
013100*    10  SCREENIO        PIC X(08) VALUE 'SCRNIO  '.                                                              
013200     10  TPSIOREC        PIC X(08) VALUE 'TPSIOREC'.                                                              
013300     10  TPSIO001        PIC X(08) VALUE 'TPSIO001'.                                                              
013400     10  TPSIO004        PIC X(08) VALUE 'TPSIO004'.                                                              
013400     10  TPSIO027        PIC X(08) VALUE 'TPSIO027'.                                                              
013400     10  TPSIO029        PIC X(08) VALUE 'TPSIO029'.                                                              
013500     10  FLOATBIG        PIC X(08) VALUE 'FLOATBIG'.                                                              
013600     10  TPSDATES        PIC X(08) VALUE 'TPSDATES'.                                                              
013700     10 FILLER           PIC X(08) VALUE HIGH-VALUES.                                                             
013800
013900 01  TPS-FILE-STATUS                       PIC XX.
014000     88  TPS-CARRIER-FILE-OK VALUE '00', '02'.
014100
014200 01  TOTAL-IDX                    PIC S9(04) COMP.
014200 01  THE-INDEX                    PIC S9(04) COMP.
014300 01  ALT-INDEX                    PIC S9(04) COMP.
014400 01  LOGON-IDX                    PIC S9(04) COMP.                                                                
014500 01  YTD-INDEX                    PIC S9(04) COMP.
014600
014200 01  IDX-COUNT                    PIC  9(02) VALUE 0.                                                             
014200 01  IDX-1                        PIC S9(04) COMP VALUE 1.                                                        
014200 01  IDX-2                        PIC S9(04) COMP VALUE 2.                                                        
014200 01  IDX-3                        PIC S9(04) COMP VALUE 3.                                                        
014200 01  IDX-4                        PIC S9(04) COMP VALUE 4.                                                        
014200 01  IDX-5                        PIC S9(04) COMP VALUE 5.                                                        
014200 01  IDX-6                        PIC S9(04) COMP VALUE 6.                                                        
014200 01  IDX-7                        PIC S9(04) COMP VALUE 7.                                                        
014200 01  IDX-8                        PIC S9(04) COMP VALUE 8.                                                        
014200 01  IDX-9                        PIC S9(04) COMP VALUE 9.                                                        
014200 01  IDX-10                       PIC S9(04) COMP VALUE 10.                                                       
014200 01  TBL-IDX-1                    PIC S9(04) COMP VALUE 1.                                                        
014200 01  TBL-IDX-2                    PIC S9(04) COMP VALUE 2.                                                        
014200 01  TBL-IDX-3                    PIC S9(04) COMP VALUE 3.                                                        
014200 01  TBL-IDX-4                    PIC S9(04) COMP VALUE 4.                                                        
014200 01  TBL-IDX-5                    PIC S9(04) COMP VALUE 5.                                                        
014200 01  TBL-IDX-6                    PIC S9(04) COMP VALUE 6.                                                        
014200 01  TBL-IDX-7                    PIC S9(04) COMP VALUE 7.                                                        
014200 01  TBL-IDX-8                    PIC S9(04) COMP VALUE 8.                                                        
014200 01  TBL-IDX-9                    PIC S9(04) COMP VALUE 9.                                                        
014200 01  TBL-IDX-10                   PIC S9(04) COMP VALUE 10.                                                       
014600
120700 01  debug-count                  pic  9(05) value 0.                                                             
014600
014200 01  COL-1-COUNT                  PIC  9(05) VALUE 0.                                                             
014200 01  COL-2-COUNT                  PIC  9(05) VALUE 0.                                                             
014200 01  COL-3-COUNT                  PIC  9(05) VALUE 0.                                                             
014200 01  COL-4-COUNT                  PIC  9(05) VALUE 0.                                                             
014200 01  COL-5-COUNT                  PIC  9(05) VALUE 0.                                                             
014200 01  COL-6-COUNT                  PIC  9(05) VALUE 0.                                                             
014200 01  COL-7-COUNT                  PIC  9(05) VALUE 0.                                                             
014200 01  COL-8-COUNT                  PIC  9(05) VALUE 0.                                                             
014200 01  COL-9-COUNT                  PIC  9(05) VALUE 0.                                                             
014200 01  COL-10-COUNT                 PIC  9(05) VALUE 0.                                                             
014600
014600
014800 01  ADMIN-TABLE                  PIC  X(56800).                                                                  
014900 01  FILLER REDEFINES ADMIN-TABLE OCCURS 50 TIMES.
015000     05 ADMIN-SLOT.
015100        10 ADMIN-LOGON             PIC  X(08).
015200        10 ADMIN-SLOTS             PIC  X(1128).                                                                  
015300        10 FILLER REDEFINES ADMIN-SLOTS OCCURS 24 TIMES.                                                          
015400           15 ADMIN-CATEGORY       PIC  X(02).
015500           15 ADMIN-DESCRIP        PIC  X(40).
015600           15 ADMIN-COUNT          PIC  9(05).
016200
016300
016400*567890123456789012345678901234567890
016500 01 TABLE-FILLER.
016600       05 FILLER PIC  X(08) VALUE SPACES.
016700*  # 01
016800       05 FILLER PIC  X(02) VALUE '21'.
016900       05 FILLER PIC  X(40) VALUE
017000          "Client's Memo                           ".
017100       05 FILLER PIC  9(05) VALUE ZEROS.
019700*  # 02
019800       05 FILLER PIC  X(02) VALUE '19'.
019900       05 FILLER PIC  X(40) VALUE
020000          "Administrator's Memo                    ".
020100       05 FILLER PIC  9(05) VALUE ZEROS.
022700*  # 03
022800       05 FILLER PIC  X(02) VALUE '90'.
022900       05 FILLER PIC  X(40) VALUE
023000          "Reports Issued by TPS                   ".
023100       05 FILLER PIC  9(05) VALUE ZEROS.
025700*  # 04
025800       05 FILLER PIC  X(02) VALUE '01'.
025900       05 FILLER PIC  X(40) VALUE
026000          "Personal Notes/Invitations              ".
026100       05 FILLER PIC  9(05) VALUE ZEROS.
028700*  # 05
028800       05 FILLER PIC  X(02) VALUE '02'.
028900       05 FILLER PIC  X(40) VALUE
029000          "Bills Received/Cash Disbursements       ".
029100       05 FILLER PIC  9(05) VALUE ZEROS.
031700*  # 06
031800       05 FILLER PIC  X(02) VALUE '09'.
031900       05 FILLER PIC  X(40) VALUE
032000          "Refunds / Reimbursements                ".
032100       05 FILLER PIC  9(05) VALUE ZEROS.
034700*  # 07
034800       05 FILLER PIC  X(02) VALUE '03'.
034900       05 FILLER PIC  X(40) VALUE
035000          "Financial Statements                    ".
035100       05 FILLER PIC  9(05) VALUE ZEROS.
037700*  # 08
037800       05 FILLER PIC  X(02) VALUE '12'.
037900       05 FILLER PIC  X(40) VALUE
038000          "Checking Statement <Non TPS>            ".
038100       05 FILLER PIC  9(05) VALUE ZEROS.
040700*  # 09
040800       05 FILLER PIC  X(02) VALUE '22'.
040900       05 FILLER PIC  X(40) VALUE
041000          "Investments: Manager Communications     ".
041100       05 FILLER PIC  9(05) VALUE ZEROS.
043700*  # 10
043800       05 FILLER PIC  X(02) VALUE '10'.
043900       05 FILLER PIC  X(40) VALUE
044000          "Investments: Corporate Communications   ".
044100       05 FILLER PIC  9(05) VALUE ZEROS.
046700*  # 11
046800       05 FILLER PIC  X(02) VALUE '15'.
046900       05 FILLER PIC  X(40) VALUE
047000          "Banking/Financial Correspondence        ".
047100       05 FILLER PIC  9(05) VALUE ZEROS.
043700*  # 12
043800       05 FILLER PIC  X(02) VALUE '04'.
043900       05 FILLER PIC  X(40) VALUE
044000          "General                                 ".
044100       05 FILLER PIC  9(05) VALUE ZEROS.
049700*  # 13
049800       05 FILLER PIC  X(02) VALUE '16'.
049900       05 FILLER PIC  X(40) VALUE
050000          "Third Party Correspondence              ".
050100       05 FILLER PIC  9(05) VALUE ZEROS.
052700*  # 14
052800       05 FILLER PIC  X(02) VALUE '25'.
052900       05 FILLER PIC  X(40) VALUE
053000          "Newspapers <Solicited>                  ".
053100       05 FILLER PIC  9(05) VALUE ZEROS.
055700*  # 15
055800       05 FILLER PIC  X(02) VALUE '23'.
055900       05 FILLER PIC  X(40) VALUE
056000          "Magazines & Newsletters <Solicited>     ".
056100       05 FILLER PIC  9(05) VALUE ZEROS.
058700*  # 16
058800       05 FILLER PIC  X(02) VALUE '08'.
058900       05 FILLER PIC  X(40) VALUE
059000          "Catalogs <Solicited>                    ".
059100       05 FILLER PIC  9(05) VALUE ZEROS.
061700*  # 17
061800       05 FILLER PIC  X(02) VALUE '24'.
061900       05 FILLER PIC  X(40) VALUE
062000          "Magazines & Newsletters <Unsolicited>   ".
062100       05 FILLER PIC  9(05) VALUE ZEROS.
064700*  # 18
064800       05 FILLER PIC  X(02) VALUE '20'.
064900       05 FILLER PIC  X(40) VALUE
065000          "Catalogs <Unsolicited>                  ".
065100       05 FILLER PIC  9(05) VALUE ZEROS.
067700*  # 19
067800       05 FILLER PIC  X(02) VALUE '26'.
067900       05 FILLER PIC  X(40) VALUE
068000          "Newspapers <Unsolicited>                ".
068100       05 FILLER PIC  9(05) VALUE ZEROS.
070700*  # 20
070800       05 FILLER PIC  X(02) VALUE '99'.
070900       05 FILLER PIC  X(40) VALUE
071000          "Other                                   ".
071100       05 FILLER PIC  9(05) VALUE ZEROS.
073700*  # 21
073800       05 FILLER PIC  X(02) VALUE '06'.
073900       05 FILLER PIC  X(40) VALUE
074000          "Newspapers                              ".
074100       05 FILLER PIC  9(05) VALUE ZEROS.
076700*  # 22
076800       05 FILLER PIC  X(02) VALUE '17'.
076900       05 FILLER PIC  X(40) VALUE
077000          "Administrator/Client Notes              ".
077100       05 FILLER PIC  9(05) VALUE ZEROS.
076700*  # 23
076800       05 FILLER PIC  X(02) VALUE '27'.
076900       05 FILLER PIC  X(40) VALUE
077000          "Junk Mail                               ".
077100       05 FILLER PIC  9(05) VALUE ZEROS.
079700*  # 24
079800       05 FILLER PIC  X(02) VALUE HIGH-VALUES.
079900       05 FILLER PIC  X(40) VALUE HIGH-VALUES.
080000       05 FILLER PIC  9(05) VALUE ZEROS.
082600*
014600
014800 01  TOTAL-TABLE.                                                                                                 
015100     05 TOTAL-LOGON               PIC  X(08).                                                                     
015200     05 TOTAL-SLOTS               PIC  X(1128).                                                                   
015300     05 FILLER REDEFINES TOTAL-SLOTS OCCURS 24 TIMES.                                                             
015400        10 TOTAL-CATEGORY         PIC  X(02).                                                                     
015500        10 TOTAL-DESCRIP          PIC  X(40).                                                                     
015600        10 TOTAL-COUNT            PIC  9(05).                                                                     
016200
016200
082700***************************************************************
082700***************************************************************
082700***************************************************************
082700
082700
082700
082800 01  NAME-TABLE                       PIC  X(2600).                                                               
082900 01  FILLER REDEFINES NAME-TABLE OCCURS 50 TIMES.
083000     05 LOGON-AND-NAME                PIC  X(52).                                                                 
083100     05 FILLER REDEFINES LOGON-AND-NAME.
083200        10 LOGON-OF-ADMIN             PIC  X(08).                                                                 
083300        10 NAME-OF-ADMIN              PIC  X(36).                                                                 
002500        10 FIRST-SIGN-ON-TIME         PIC  9(04).                                                                 
002500        10 LAST-SIGN-OFF-TIME         PIC  9(04).                                                                 
083400
083600
083700 01 LOGON-COUNT                   PIC  9(05) VALUE ZEROS.
083900 01 MAIL-COUNT                    PIC  9(07) VALUE ZEROS.
084100 01 WK-LOGON-COUNT                PIC  9(12) VALUE ZEROS.
084200 01 WK-MAIL-COUNT                 PIC  9(07) VALUE ZEROS.
084300
084400 01 WS-QUOT-PCT                   PIC  9(05) VALUE ZEROS.
084500 01 WS-QUOT-REMAINDER             PIC  9(07) VALUE ZEROS.
084600*
084700 01 PCT-MASK                      PIC  X(04) VALUE '.00%'.                                                        
084800*
084900 01 FACTOR-100000                 PIC  9(06) VALUE 100000.
085000
085100                                                                                     00012940
085200 01  BG-FLOAT-DATA.                                                                 00012950
085300     05  BG-FLOAT-PARMS              PIC  X(161).                                   00012960
085400     05  FILLER REDEFINES BG-FLOAT-PARMS.                                           00012970
085500         10  BG-FLOAT-COUNT          PIC  X(01).                                    00012980
085600         10  BG-FLOAT-1              PIC  X(40).                                    00012990
085700         10  BG-FLOAT-2              PIC  X(40).                                    00013020
085800         10  BG-FLOAT-3              PIC  X(40).                                    00013050
085900         10  BG-FLOAT-4              PIC  X(40).                                    00013110
086000
011720  01  edit-time.                                                                                                  
011720      05  filler                     pic  x(03) value 'at '.
011720      05  edit-time-hh               pic  9(02).                                                                  
011720      05  filler                     pic  x(01) value ':'.
011720      05  edit-time-mm               pic  9(02).                                                                  
086100
089510  01  WS-todays-time             pic  9(08).                                                                      
089510  01  filler redefines ws-todays-time.                                                                            
089510      05  WS-todays-time-hh      pic  9(02).                                                                      
089510      05  WS-todays-time-mm      pic  9(02).                                                                      
089510      05  WS-todays-time-ssss    pic  9(04).                                                                      
086100
086200  01  WS-TODAYS-DATE-YMD.
086300      10 WS-TODAYS-DATE-YY       PIC 9(02).
086300      10 WS-TODAYS-DATE-MM       PIC 9(02).
086300      10 WS-TODAYS-DATE-DD       PIC 9(02).
086400
086500  01  WS-DATE-REQUEST.
086600      05  WS-DATE-PARAM          PIC  9(02).
086700      05  WS-DATE-TENBYTES       PIC  X(20) VALUE SPACES.
086800      05  FILLER REDEFINES WS-DATE-TENBYTES.
086900          10  WS-DATE-REFORM         PIC  X(06).
087000          10  WS-DATE-EXTEND         PIC  X(04).
087100          10  FILLER                 PIC  X(10).
087200      05  FILLER REDEFINES WS-DATE-TENBYTES.
087300          10  WS-DATE-REFORM-LEN06   PIC  X(06).
087400          10  FILLER                 PIC  X(14).
087500      05  FILLER REDEFINES WS-DATE-TENBYTES.
087600          10  WS-DATE-REFORM-LEN08   PIC  X(08).
087700          10  FILLER                 PIC  X(12).
087800      05  FILLER REDEFINES WS-DATE-TENBYTES.
087900          10  WS-DATE-REFORM-LEN10   PIC  X(10).
088000          10  FILLER                 PIC  X(10).
088100
086200 01  SEARCH-COUNT               PIC  9(02) VALUE ZEROS.                                                           
086200 01  SEARCH-DATE-CYMD           PIC  9(08) VALUE ZEROS.                                                           
086200 01  search-date-mdy            pic  9(06) value zeros.                                                           
088110                                                                                     00006800
088120 01  BAT-COMMAND-1              PIC  X(80)                                           00006900
088140      VALUE 'P C:\TPS\APP\TPS021T.TXT                  '.
089000
088200   01 WS-MONDAYS-DATE-CYMD           PIC X(08).                                                                   
089110*LINKAGE SECTION.
088200   01 WS-TODAYS-DATE-CYMD            PIC X(08).
089000
089110*PROCEDURE DIVISION USING WS-TODAYS-DATE-CYMD.
122903 PROCEDURE DIVISION.
089200
089300
089400 TPS021T-BEGIN.                                                                                                   

            ACCEPT WS-TODAYS-DATE-YMD FROM DATE.
      *04/01/04 ******* ACCEPT DATE FROM DISPLAY PANEL *****
101701
101702      SET TPS021T-DO-DISPLAY TO TRUE.
            CALL GUISCREEN USING TPS021T-1
101703                           TPS021T-2
101704                           TPS021T-3
101705                           TPS021T-4.
086100
089510      MOVE ADMIN-RUN-DATE(1:2)   TO WS-TODAYS-DATE-MM.
089510      MOVE ADMIN-RUN-DATE(3:2)   TO WS-TODAYS-DATE-DD.
089510      MOVE ADMIN-RUN-DATE(5:2)   TO WS-TODAYS-DATE-YY.
086100
089510      ACCEPT ws-todays-time FROM time.
011720      move ws-todays-time-hh     to edit-time-hh.                                                                 
011720      move ws-todays-time-mm     to edit-time-mm.                                                                 
089510                                                                                                                  
089600      MOVE 01                   TO WS-DATE-PARAM.
089700      MOVE SPACES               TO WS-DATE-EXTEND.
089800      MOVE WS-TODAYS-DATE-YMD   TO WS-DATE-REFORM.
089900      CALL TPSDATES USING WS-DATE-REQUEST.
090000      MOVE WS-DATE-REFORM-LEN08 TO WS-TODAYS-DATE-CYMD                                                            
090000                                   SEARCH-DATE-CYMD.                                                              
089510*     123456   123456                                                                                             
089510*     yymmdd   mmddyy                                                                                             
089800      move ws-todays-date-ymd(1:2)  to search-date-mdy(5:2).                                                        
089800      move ws-todays-date-ymd(3:2)  to search-date-mdy(1:2).                                                        
089800      move ws-todays-date-ymd(5:2)  to search-date-mdy(3:2).                                                        
090110*---------------------------------------------------------------
122841      MOVE SEARCH-DATE-CYMD         TO PAM-CNTRL-DATE.                                                            
122844      MOVE ZEROS                    TO PAM-RECORD-TYPE                                                            
122845                                       PAM-ACCT-NO                                                                
122846                                       PAM-SUB-ACCT-NO                                                            
122850                                       PAM-ZERO-1                                                                 
122851                                       PAM-ZERO-2                                                                 
122852                                       PAM-ZERO-3                                                                 
122853                                       PAM-ZERO-4.                                                                
086200      MOVE ZEROS                    TO SEARCH-COUNT.                                                              
122854                                                                                                                  
122856      SET FR-OPEN-INPUT TO TRUE.                                                                                  
122858      CALL TPSIO027 USING FILE-REQUEST TPS-PAMON-REC.                                                             
122862      IF FILE-STATUS NOT = '00' AND '05'                                                                          
122863         MOVE 'PAMON'        TO FILE-NAME                                                                         
122864         MOVE 'TPS021T-OPEN' TO FILE-TEXT                                                                         
122865         PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                                                  
105200         GO TO TPS021-COMMON-EXIT                                                                                 
122868       END-IF.                                                                                                    
089510                                                                                                                  
089510      IF WS-TODAYS-DATE-YMD = '010613'                                                                            
105200         GO TO CLOSE-PAMON-FILE                                                                                   
122868       END-IF.                                                                                                    
089510                                                                                                                  
122841 READ-AGAIN.                                                                                                      
122869      SET FR-READ TO TRUE.                                                                                        
122870      CALL TPSIO027 USING FILE-REQUEST TPS-PAMON-REC.                                                             
122871      IF NO-RECORD-WAS-FOUND                                                                                      
086200         ADD 1                  TO SEARCH-COUNT                                                                   
086200         IF SEARCH-COUNT > 10                                                                                     
105200            GO TO TPS021-COMMON-EXIT                                                                              
                END-IF
089600         MOVE 22                    TO WS-DATE-PARAM                                                              
089700         MOVE SPACES                TO WS-DATE-EXTEND                                                             
089800         MOVE SEARCH-DATE-CYMD      TO WS-DATE-REFORM-LEN08                                                       
089800         MOVE '001'                 TO WS-DATE-REFORM-LEN08(9:3)                                                  
089900         CALL TPSDATES USING WS-DATE-REQUEST                                                                      
090000         MOVE WS-DATE-REFORM-LEN08  TO SEARCH-DATE-CYMD                                                           
122841         MOVE SEARCH-DATE-CYMD      TO PAM-CNTRL-DATE                                                             
122841         GO TO READ-AGAIN                                                                                         
122873       END-IF.                                                                                                    
122874      IF NOT A-SUCCESSFUL-OPERATION                                                                               
122875         MOVE 'PAMON' TO FILE-NAME                                                                                
122864         MOVE 'TPS021T-OPEN' TO FILE-TEXT                                                                         
122877         PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                                                  
105200         GO TO TPS021-COMMON-EXIT                                                                                 
122881       END-IF.                                                                                                    
122880
105200 CLOSE-PAMON-FILE.                                                                                                
122882      SET FR-CLOSE TO TRUE.                                                                                       
122883      CALL TPSIO027 USING FILE-REQUEST TPS-PAMON-REC.                                                             
122884      IF NOT A-SUCCESSFUL-OPERATION                                                                               
122885         MOVE 'PAMON' TO FILE-NAME                                                                                
122864         MOVE 'TPS021T-OPEN' TO FILE-TEXT                                                                         
122887         PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                                                  
105200         GO TO TPS021-COMMON-EXIT                                                                                 
122890       END-IF.                                                                                                    
122883      CANCEL TPSIO027.                                                                                            
101300*
122841     MOVE SEARCH-DATE-mdy       TO FILE-REPORT-NAME
009520                                   BAT-REPORT-NAME                                                                
009520                                   bat-assign-name
090000                                   bat-command-name.
101500*--------------------------------------------------------------
101600
101700 START-THE-PROCESS.
101701*     MOVE 'O'         TO PROCESS-REPAINT-SCREEN.
101702*     CALL SCREENIO USING PROCESS-PANEL
101703*                         PROCESS-PASS-TO-EXIT
101704*                         PROCESS-WORK-S
101705*                         PROCESS-WORK-D.
101707*---------------------------------------------------------------
101713                                                                                                                  
101708      MOVE 04                   TO WS-DATE-PARAM.
101709      MOVE SPACES               TO WS-DATE-EXTEND.
101710      MOVE WS-TODAYS-DATE-CYMD(3:6)   TO WS-DATE-REFORM.
101711      CALL TPSDATES USING WS-DATE-REQUEST.
087900      MOVE WS-DATE-REFORM-LEN10 TO PRT-HDR1pg1-DATE                                                               
087900                                   PRT-HDR1pg2-DATE.                                                              
101713                                                                                                                  
101713                                                                                                                  
101713                                                                                                                  
101707*---------------------------------------------------------------
101707*---------------------------------------------------------------
108300      MOVE SPACES               TO BG-FLOAT-PARMS.                                                                
087900                                                                                                                  
101708      MOVE 23                   TO WS-DATE-PARAM.                                                                 
101709      MOVE SPACES               TO WS-DATE-EXTEND.
087600
122841      MOVE SEARCH-DATE-CYMD     TO WS-date-reform-len08.                                                          
101711      CALL TPSDATES USING WS-DATE-REQUEST.
122841      if WS-date-reform-len08(9:1) = '0'                                                                          
087900         move 'Sunday'          to bg-float-1                                                                     
087900        else                                                                                                      
122841      if WS-date-reform-len08(9:1) = '1'                                                                          
087900         move 'Monday'          to bg-float-1                                                                     
087900        else                                                                                                      
122841      if WS-date-reform-len08(9:1) = '2'                                                                          
087900         move 'Tuesday'         to bg-float-1                                                                     
087900        else                                                                                                      
122841      if WS-date-reform-len08(9:1) = '3'                                                                          
087900         move 'Wednesday'       to bg-float-1                                                                     
087900        else                                                                                                      
122841      if WS-date-reform-len08(9:1) = '4'                                                                          
087900         move 'Thursday'        to bg-float-1                                                                     
087900        else                                                                                                      
122841      if WS-date-reform-len08(9:1) = '5'                                                                          
087900         move 'Friday'          to bg-float-1                                                                     
087900        else                                                                                                      
087900         move 'Saturday'        to bg-float-1                                                                     
087900             end-if                                                                                               
087900            end-if                                                                                                
087900           end-if                                                                                                 
087900          end-if                                                                                                  
087900         end-if                                                                                                   
087900        end-if.                                                                                                   
087900                                                                                                                  
087900      move ', '                 to bg-float-2.                                                                    
101708      MOVE 06                   TO WS-DATE-PARAM.
101709      MOVE SPACES               TO WS-DATE-EXTEND.
122841      MOVE SEARCH-DATE-CYMD(3:6) TO WS-date-reform.                                                               
101711      CALL TPSDATES USING WS-DATE-REQUEST.
101712      MOVE WS-DATE-TENBYTES     TO bg-float-2(3:20).     
087900                                                                                                                  
011720      move edit-time            to bg-float-3.                                                                    
087900                                                                                                                  
108700      MOVE '3'                  TO BG-FLOAT-COUNT                                                                 
109400      CALL FLOATBIG USING BG-FLOAT-DATA.                                                                          
109500      MOVE BG-FLOAT-1(1:50)     TO for-what-daypg1                                                                
101712                                   for-what-daypg2.      
115300
101713*---------------------------------------------------------------
101707*---------------------------------------------------------------
101750
101750
101750
101800    PERFORM OPEN-THE-FILES
101900       THRU OPEN-THE-FILES-EXIT.
102000
102100    PERFORM VARYING THE-INDEX FROM 1 BY 1
102200              UNTIL THE-INDEX > 50
102300         MOVE TABLE-FILLER    TO ADMIN-SLOT(THE-INDEX)
102400         MOVE SPACES          TO LOGON-OF-ADMIN(THE-INDEX)
102500                                 NAME-OF-ADMIN(THE-INDEX)
002500         MOVE ZEROS           TO FIRST-SIGN-ON-TIME(THE-INDEX)                                                    
002500                                 LAST-SIGN-OFF-TIME(THE-INDEX)                                                    
102600      END-PERFORM.
102700
014800     MOVE TABLE-FILLER           TO TOTAL-TABLE.
015100     MOVE ' TOTALS '             TO TOTAL-LOGON.                                                                  
102710
102710***************************************************************                                                   
102710***************************************************************                                                   
102710
102800    INITIALIZE TPS-LOGON-REC.
106300    MOVE 'NYMIQAU 02' TO LOGREC-SIGN-ON.                                                                          
104200    MOVE F-PRIME TO FILE-KEY.
104300    MOVE F-READ  TO FILE-ACTION.                                                                                  
104400    CALL TPSIO001 USING FILE-REQUEST TPS-LOGON-REC.
122871    IF NO-RECORD-WAS-FOUND                                                                                        
             CONTINUE                                                                                                   
105300      ELSE                                                                                                        
104800    IF NOT A-SUCCESSFUL-OPERATION
104900       MOVE ' LOGON  ' TO FILE-NAME
105000       MOVE 'TPS021-BRN' TO FILE-TEXT
105100       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
105200       GO TO TPS021-COMMON-EXIT
105300      ELSE                                                                                                        
104200       MOVE F-PRIME   TO FILE-KEY                                                                                 
104300       MOVE F-DELET  TO FILE-ACTION
104400       CALL TPSIO001 USING FILE-REQUEST TPS-LOGON-REC                                                             
104800       IF NOT A-SUCCESSFUL-OPERATION                                                                              
104900          MOVE ' LOGON  ' TO FILE-NAME                                                                            
105000          MOVE 'TPS021-DEL' TO FILE-TEXT                                                                          
105100          PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                                                 
105200          GO TO TPS021-COMMON-EXIT                                                                                
105300        END-IF                                                                                                    
105300     END-IF.
105400       
102710***************************************************************                                                   
102710***************************************************************                                                   
102710
107900    MOVE ZEROS        TO THE-INDEX.                                                                               
102800    INITIALIZE TPS-LOGON-REC.
102900    MOVE LOW-VALUES   TO LOGREC-KEY.
103000    MOVE F-PRIME TO FILE-KEY.
103100    MOVE F-START TO FILE-ACTION.
103200    CALL TPSIO001 USING FILE-REQUEST TPS-LOGON-REC.
103300    IF NOT A-SUCCESSFUL-OPERATION
103400       MOVE ' LOGON  ' TO FILE-NAME
103500       MOVE 'TPS021-SBR' TO FILE-TEXT
103600       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
103700       GO TO TPS021-COMMON-EXIT.
103800
104000
104100 READ-ALL-LOGON-RECORDS.
104200    MOVE F-PRIME TO FILE-KEY.
104300    MOVE F-READ-NEXT TO FILE-ACTION.
104400    CALL TPSIO001 USING FILE-REQUEST TPS-LOGON-REC.
104500    IF END-OF-FILE-WAS-REACHED
104600       GO TO READ-THE-LOGON-EXIT
104700     END-IF.
104800    IF NOT A-SUCCESSFUL-OPERATION
104900       MOVE ' LOGON  ' TO FILE-NAME
105000       MOVE 'TPS021-BRN' TO FILE-TEXT
105100       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
105200       GO TO TPS021-COMMON-EXIT
105300     END-IF.
105400       
105500*09/28/00                                                                                                         
105500    IF LOGREC-STATUS-INACTIVE
105600       GO TO READ-ALL-LOGON-RECORDS                                                                               
105700     END-IF.
105800
105900    IF LOGREC-SIGN-ON-SHORT = PREV-LOGON
106000       GO TO READ-ALL-LOGON-RECORDS
106100     END-IF.
106200
106300    IF LOGREC-SIGN-ON-SHORT = 'DAMFWIC '
106400       GO TO READ-ALL-LOGON-RECORDS
106500     END-IF.
106600
120700
121000* 06/14/01                                                                                                        
121000* FOLLOWING IS TEMP UNTIL RECEIVE IS FIXED, ADMIN MEMO                                                            
121000* RECORDS ARE BLANK.....................................                                                          
106700*   IF LOGREC-SIGN-ON-SHORT = 'NYTHSCA '                                                                          
106800*      GO TO READ-ALL-LOGON-RECORDS                                                                               
106900*    END-IF.                                                                                                      
107000
107100*   IF LOGREC-SIGN-ON-SHORT = 'NYJAMON '
107200*      GO TO READ-ALL-LOGON-RECORDS
107300*    END-IF.
106600
106700    IF LOGREC-SIGN-ON-SHORT = 'NYKEAKE '
106800       GO TO READ-ALL-LOGON-RECORDS
106900     END-IF.
106600
106700    IF LOGREC-SIGN-ON-SHORT = 'NYNAAKE '
106800       GO TO READ-ALL-LOGON-RECORDS
106900     END-IF.
107400
107500    IF LOGREC-SIGN-ON-SHORT(1:4) = 'NYCK'
107600       GO TO READ-ALL-LOGON-RECORDS
107700     END-IF.
107400
107500    IF LOGREC-ACCESS-LEVEL > '04'                  
107600       GO TO READ-ALL-LOGON-RECORDS
107700     END-IF.
107800
107900    SET THE-INDEX UP BY 1.
108000    MOVE LOGREC-SIGN-ON-SHORT    TO PREV-LOGON
108100                                    ADMIN-LOGON(THE-INDEX)
108200                                    LOGON-OF-ADMIN(THE-INDEX).
108300    MOVE SPACES                     TO BG-FLOAT-PARMS.                                                            
108000    MOVE '(XXXXXXX)'             TO BG-FLOAT-1.                   
108000    MOVE LOGREC-SIGN-ON-SHORT    TO BG-FLOAT-1(2:7)
108400    MOVE LOGREC-ADMIN-LAST-NAME  TO BG-FLOAT-2.
108500    MOVE LOGREC-ADMIN-FIRST-NAME TO BG-FLOAT-3.
108600    IF LOGREC-ADMIN-MID-INIT = SPACES
108700       MOVE '3'                  TO BG-FLOAT-COUNT
108800      ELSE
108900       MOVE '4'                  TO BG-FLOAT-COUNT
109000       MOVE ', '                 TO BG-FLOAT-4
109100       MOVE LOGREC-ADMIN-MID-INIT TO BG-FLOAT-4(3:1)
109200       MOVE '.'                  TO BG-FLOAT-4(4:1)
109300     END-IF.
109400    CALL FLOATBIG USING BG-FLOAT-DATA.
109500    MOVE BG-FLOAT-1(1:36)        TO NAME-OF-ADMIN(THE-INDEX).
115300
108000    MOVE LOGREC-SIGN-ON-SHORT    TO TRACK-SIGN-ON-SHORT.
108000    MOVE SEARCH-DATE-CYMD        TO TRACK-SIGN-ON-DATE.
122869                                                                                                                  
122869    SET FR-READ TO TRUE.                                                                                          
122870    CALL TPSIO029 USING FILE-REQUEST TPS-TRACK-REC.                                                               
122871    IF NO-RECORD-WAS-FOUND                                                                                        
002500       MOVE ZEROS         TO FIRST-SIGN-ON-TIME(THE-INDEX)                                                        
002500                             LAST-SIGN-OFF-TIME(THE-INDEX)                                                        
109600       GO TO READ-ALL-LOGON-RECORDS                                                                               
122873      ELSE                                                                                                        
122874    IF NOT A-SUCCESSFUL-OPERATION                                                                                 
122875       MOVE 'TRACK' TO FILE-NAME                                                                                  
122864       MOVE 'TPS021T-READ' TO FILE-TEXT                                                                           
122877       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                                                    
105200       GO TO TPS021-COMMON-EXIT                                                                                   
122880      END-IF                                                                                                      
122881     END-IF.                                                                                                      
115300
002500    MOVE TRACK-FIRST-SIGN-ON-TIME                                                                                 
002500                          TO FIRST-SIGN-ON-TIME(THE-INDEX).                                                       
002500    MOVE TRACK-LAST-SIGN-OFF-TIME                                                                                 
002500                          TO LAST-SIGN-OFF-TIME(THE-INDEX).                                                       
109600    GO TO READ-ALL-LOGON-RECORDS.
109700
109800
109900 READ-THE-LOGON-EXIT.
110000    PERFORM READ-THE-MAIL
110100       THRU READ-THE-MAIL-EXIT.
109800
110300    PERFORM CLOSE-THE-FILES
110400       THRU CLOSE-THE-FILES-EXIT.
110466                                                                                                                  
109800    display bat-command upon command-line.
109800    call x'91' using result function-35 null-parameter.
109800
110500    EXIT PROGRAM.
110501    GOBACK.
109800
109800
109800
110200 TPS021-COMMON-EXIT.
110300    PERFORM CLOSE-THE-FILES
110400       THRU CLOSE-THE-FILES-EXIT.
110466                                                                                                                  
110500    EXIT PROGRAM.
110501    GOBACK.
110510    STOP RUN.
110600
110700
110800 READ-THE-MAIL.
110900    MOVE F-PRIME TO FILE-KEY.
111000    MOVE F-START TO FILE-ACTION.
111100    MOVE LOW-VALUES TO TPS-PROFL-REC.
111200    MOVE ZEROES TO CLNT-PROFILE-KEY.
111300    CALL TPSIO004 USING FILE-REQUEST TPS-PROFL-REC.
111400    IF NO-RECORD-WAS-FOUND
111500       GO TO READ-THE-MAIL-EXIT
111600     END-IF.
111700    IF NOT A-SUCCESSFUL-OPERATION
111800       MOVE ' PROFILE' TO FILE-NAME
111900       MOVE 'TPS021-STRT ' TO FILE-TEXT
112000       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
112100       GO TO READ-THE-MAIL-EXIT
112200     END-IF.
112300
112400
112500 READ-NEXT-CLIENT.
112600    MOVE F-PRIME TO FILE-KEY.
112700    MOVE F-READ-NEXT TO FILE-ACTION.
112800    CALL TPSIO004 USING FILE-REQUEST TPS-PROFL-REC.
112900    IF END-OF-FILE-WAS-REACHED
113000       GO TO PRINT-THE-TABLE
113100     END-IF.
113200    IF NOT A-SUCCESSFUL-OPERATION
113300       MOVE ' PROFILE' TO FILE-NAME
113400       MOVE 'TPS021-RNXT' TO FILE-TEXT
113500       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
113600       GO TO TPS021-COMMON-EXIT
113700     END-IF.
113800
113900    IF CLNT-PROFILE-SUB-ACCT NOT = '00'
114000       GO TO READ-NEXT-CLIENT
114100     END-IF.
114200
114300    IF CLNT-PROFILE-ADD-DATE(1:1) = 8 OR 9
114400       GO TO READ-NEXT-CLIENT                                                                                     
114500     END-IF.
114600
115200    MOVE CLNT-PROFILE-ACCT-NO  TO CURRENT-ACCT.
115300
115500 RESTART-RECEIVE.
115600    MOVE LOW-VALUES TO MAIL-KEY OF TPS-MAIL-REC.
089800    MOVE SEARCH-DATE-CYMD                                                                                         
115800                      TO MAIL-RECEIVE-DATE.
115900    MOVE CURRENT-ACCT TO MAIL-ACCT-NO.
116000    MOVE ZEROS        TO MAIL-SUB-ACCT
116100                         MAIL-RECEIVE-NUMBER.
116200
116300    MOVE F-PRIME TO FILE-KEY.
116400    MOVE F-START TO FILE-ACTION.
116500    CALL TPSIOREC USING FILE-REQUEST TPS-MAIL-REC.
116600    IF NO-RECORD-WAS-FOUND
116700       GO TO READ-NEXT-CLIENT
116800     END-IF.
116900    IF NOT A-SUCCESSFUL-OPERATION
117000       MOVE ' RECEIVE' TO FILE-NAME
117100       MOVE 'TPS021-SBR' TO FILE-TEXT
117200       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
117300       GO TO TPS021-COMMON-EXIT.
117400
117500 READ-ALL-RECEIVE-NUMBERS.
117600    MOVE F-PRIME TO FILE-KEY.
117700    MOVE F-READ-NEXT TO FILE-ACTION.
117800    CALL TPSIOREC USING FILE-REQUEST TPS-MAIL-REC.
117900    IF END-OF-FILE-WAS-REACHED
118000       GO TO READ-NEXT-CLIENT
118100     END-IF.
118200    IF NOT A-SUCCESSFUL-OPERATION
118300       MOVE ' RECEIVE' TO FILE-NAME
118400       MOVE 'TPS021-BRN' TO FILE-TEXT
118500       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
118600       GO TO TPS021-COMMON-EXIT.
118700
118800    IF MAIL-ACCT-NO NOT = CURRENT-ACCT
118900       GO TO READ-NEXT-CLIENT
119000     END-IF.
119100
119200    IF MAIL-RECEIVE-DATE IS NOT NUMERIC
119300       MOVE ZEROS        TO MAIL-RECEIVE-DATE
119400     END-IF.
119500
119600    IF MAIL-RECEIVE-DATE < SEARCH-DATE-CYMD                                                                       
119700       GO TO READ-ALL-RECEIVE-NUMBERS
119800     END-IF.
119900
119600    IF MAIL-RECEIVE-DATE > SEARCH-DATE-CYMD                                                                       
120100       GO TO READ-NEXT-CLIENT
120200     END-IF.
120300*06/14/01    bypass void
121300    IF MAIL-disposition = '88'                                                                                    
120500       GO TO READ-ALL-RECEIVE-NUMBERS
120600     END-IF.
120300
120300*06/14/01    bypass tps issued reports
121300    IF MAIL-disposition = '90'                                                                                    
120500       GO TO READ-ALL-RECEIVE-NUMBERS
120600     END-IF.
120300
120400    IF MAIL-ADMIN-XXXXXX(1:3) = 'TPS'
120500       GO TO READ-ALL-RECEIVE-NUMBERS
120600     END-IF.
120700*10/06/05                                                                                                           
121000    if mail-admin-xxxxxx = spaces                                                                                 
120700       if recur-admin-logon not = spaces                                                                            
121000          move recur-admin-logon(1:8)                                                                               
121000                        to mail-admin-xxxxxx(1:8)                                                                   
120600        end-if                                                                                                      
120600     end-if.
120700
121000* 06/14/01                                                                                                        
121000* FOLLOWING IS TEMP UNTIL RECEIVE IS FIXED, ADMIN MEMO                                                            
121000* RECORDS ARE BLANK.....................................                                                          
121000    IF MAIL-ADMIN-XXXXXX = spaces                                                                                 
121000       move 'NYTHSCA '        TO MAIL-ADMIN-XXXXXX(1:8)                                                           
120600     END-IF.
121000    IF MAIL-ADMIN-XXXXXX(1:7) = 'XXXXXXX'                                                                         
121000       move 'NYJAMON '        TO MAIL-ADMIN-XXXXXX(1:8)                                                           
120600     END-IF.
121000    IF MAIL-ADMIN-XXXXXX(1:7) = 'NYXXXXX'                                                                         
121000       move 'NYJAMON '        TO MAIL-ADMIN-XXXXXX(1:8)                                                           
120600     END-IF.
120700
121300    IF MAIL-CATEGORY-CODE = '11' OR '31' OR '33'                                                                  
121300       MOVE '02'             TO MAIL-CATEGORY-CODE                                                                
120600     END-IF.
121300    IF MAIL-CATEGORY-CODE = '30' OR '32'                                                                          
121300       MOVE '09'             TO MAIL-CATEGORY-CODE                                                                
120600     END-IF.
120700
120700    add 1                    to debug-count.
120700
120800    PERFORM VARYING THE-INDEX FROM 1 BY 1
120900              UNTIL THE-INDEX > 50
121000      IF MAIL-ADMIN-XXXXXX(1:7) = ADMIN-LOGON(THE-INDEX)                                                          
121300         IF MAIL-disposition = '27'                                                                               
121300            move mail-disposition   to MAIL-CATEGORY-CODE                                                         
                end-if                                                                                                  
121100         PERFORM VARYING ALT-INDEX FROM 1 BY 1
121200                   UNTIL ALT-INDEX > 24                                                                           
121300           IF MAIL-CATEGORY-CODE =
121400                  ADMIN-CATEGORY(THE-INDEX,ALT-INDEX)
121500              ADD 1  TO  ADMIN-COUNT(THE-INDEX,ALT-INDEX)
121600                         MAIL-COUNT
121500              ADD 1  TO  TOTAL-COUNT(ALT-INDEX)                                                                   
125700              GO TO READ-ALL-RECEIVE-NUMBERS                                                                      
                  end-if                                                                                                
123400           END-PERFORM                                                                                            
125700         GO TO READ-ALL-RECEIVE-NUMBERS                                                                           
123300       END-IF                                                                                                     
123400      END-PERFORM.
123500
125700    GO TO READ-ALL-RECEIVE-NUMBERS.                                                                               
125800
125900
126000 PRINT-THE-TABLE.
042600    OPEN OUTPUT BAT-FILE.                                                                                         
046000    WRITE BAT-RECORD FROM bat-creation.                                                                           
046100    CLOSE BAT-FILE.                                                                                               
047100
126030    WRITE PRT-RECORD FROM PCL5-duplex-on                                                                          
138300                    AFTER ADVANCING 0 LINES.                                                                      
126030    WRITE PRT-RECORD FROM PCL5-FONT-PC8                                                                           
138300                    AFTER ADVANCING 0 LINES.                                                                      
126030    WRITE PRT-RECORD FROM PCL5-PRM-SPACE-FIXED                                                                    
138300                    AFTER ADVANCING 0 LINES.                                                                      
126030*** WRITE PRT-RECORD FROM PCL5-LINE-SPACE-08LPI                                                                   
126030    WRITE PRT-RECORD FROM PCL5-LINE-SPACE-06LPI                                                                   
138300                    AFTER ADVANCING 0 LINES.                                                                      
138800*** MOVE 0016          TO pcl5-CPI-value.                                                                         
138800    MOVE 0012          TO pcl5-CPI-value.                                                                         
126030    WRITE PRT-RECORD FROM pcl5-primary-PITCH-CPI
138300                    AFTER ADVANCING 0 LINES.                                                                      
138800    MOVE 0010          TO pcl5-points-value.                                                                      
126030    WRITE PRT-RECORD FROM pcl5-primary-height                                                                     
138300                    AFTER ADVANCING 0 LINES.                                                                      
126030    WRITE PRT-RECORD FROM pcl5-STYLE-UPRIGHT                                                                      
138300                    AFTER ADVANCING 0 LINES.                                                                      
126030    WRITE PRT-RECORD FROM pcl5-WT-BOLD                                                                            
138300                    AFTER ADVANCING 0 LINES.                                                                      
126030    WRITE PRT-RECORD FROM pcl5-fam-courier                                                                        
138300                    AFTER ADVANCING 0 LINES.                                                                      
125900
126050    MOVE SPACES        TO PRT-RECORD.                                                                             
126060    WRITE PRT-RECORD.                                                                                             
126060    WRITE PRT-RECORD.                                                                                             
126010    ADD 1              TO PAGE-COUNT.                                                                             
126020    MOVE PAGE-COUNT    TO PRT-HDR1pg1-PAGE-NUM.                                                                   
126030    WRITE PRT-RECORD FROM PRT-HDR1pg1.                                                                            
126031    MOVE SPACES        TO PRT-RECORD.                                                                             
126040    WRITE PRT-RECORD FROM PRT-HDR2pg1.                                                                            
126050    MOVE SPACES        TO PRT-RECORD.                                                                             
126060    WRITE PRT-RECORD.                                                                                             
126070    WRITE PRT-RECORD FROM PRT-HDR3pg1.                                                                            
126071    MOVE SPACES        TO PRT-RECORD.                                                                             
126080    WRITE PRT-RECORD.
126700
126800    PERFORM VARYING THE-INDEX FROM 1 BY 1
126900              UNTIL THE-INDEX > 50
127000      IF ADMIN-LOGON(THE-INDEX) NOT = SPACES
127100         MOVE ZEROS       TO LOGON-COUNT
127300         PERFORM VARYING ALT-INDEX FROM 1 BY 1
127400                   UNTIL ALT-INDEX > 24                                                                           
127500             ADD  ADMIN-COUNT(THE-INDEX,ALT-INDEX)
127600                          TO LOGON-COUNT
127900           END-PERFORM
128000         MOVE SPACES      TO PRT-RECORD                                                                           
128300         IF ADMIN-LOGON(THE-INDEX) =
128400                             LOGON-OF-ADMIN(THE-INDEX)
128500            MOVE NAME-OF-ADMIN(THE-INDEX)
128600                          TO PRT-RECAP-NAME                                                                       
002500            IF FIRST-SIGN-ON-TIME(THE-INDEX) = ZEROS                                                              
008800               MOVE ' N/A '       TO PRT-RECAP-LOGON                                                              
                    ELSE
008800               MOVE 'XX:XX'       TO PRT-RECAP-LOGON                                                              
002500               MOVE FIRST-SIGN-ON-TIME(THE-INDEX)(1:2)                                                            
008800                                  TO PRT-RECAP-LOGON(1:2)                                                         
002500               MOVE FIRST-SIGN-ON-TIME(THE-INDEX)(3:2)                                                            
008800                                  TO PRT-RECAP-LOGON(4:2)                                                         
                   END-IF                                                                                               
002500            IF LAST-SIGN-OFF-TIME(THE-INDEX) = ZEROS                                                              
008800               MOVE ' N/A '       TO PRT-RECAP-LOGOFF                                                             
                    ELSE
008800               MOVE 'XX:XX'       TO PRT-RECAP-LOGOFF                                                             
002500               MOVE LAST-SIGN-OFF-TIME(THE-INDEX)(1:2)
008800                                  TO PRT-RECAP-LOGOFF(1:2)                                                        
002500               MOVE LAST-SIGN-OFF-TIME(THE-INDEX)(3:2)
008800                                  TO PRT-RECAP-LOGOFF(4:2)                                                        
                   END-IF                                                                                               
128700          END-IF
128800         MOVE LOGON-COUNT        TO PRT-RECAP-COUNT                                                               
128900         MOVE LOGON-COUNT        TO WK-LOGON-COUNT                                                                
129000         MOVE MAIL-COUNT         TO WK-MAIL-COUNT                                                                 
129100         MULTIPLY FACTOR-100000  BY WK-LOGON-COUNT
129200         DIVIDE WK-LOGON-COUNT   BY WK-MAIL-COUNT                                                                 
129300         GIVING WS-QUOT-PCT  REMAINDER WS-QUOT-REMAINDER
129400         ADD 500                 TO WS-QUOT-PCT                                                                   
129500         MOVE WS-QUOT-PCT(1:2)   TO PCT-MASK(2:2)                                                                 
129600         MOVE PCT-MASK           TO PRT-RECAP-PCT                                                                 
130800         WRITE PRT-RECORD                                                                                         
130900         MOVE SPACES      TO PRT-RECORD                                                                           
131100        END-IF
131200      END-PERFORM.
131300
131400    MOVE ' *TOTAL*'       TO PRT-RECAP-NAME(1:8).                                                                 
131500    MOVE MAIL-COUNT       TO PRT-RECAP-COUNT.                                                                     
131700    WRITE PRT-RECORD.                                                                                             
131800    MOVE SPACES           TO PRT-RECORD.                                                                          
131910
131910*page break here...................................
126030    WRITE PRT-RECORD FROM PCL5-FORM-FEED                                                                          
138300                    AFTER ADVANCING 0 LINES.                                                                      
089510*                                                                                                                 
132100    PERFORM VARYING THE-INDEX FROM 1 BY 1                                                                         
132300              UNTIL ADMIN-LOGON(THE-INDEX) = SPACES
133540      END-PERFORM.                                                                                                
015000     MOVE TOTAL-TABLE        TO ADMIN-SLOT(THE-INDEX).
132050
089510                                                                                                                  
089510                                                                                                                  
089510                                                                                                                  
089510                                                                                                                  
089510                                                                                                                  
089510*   IF WS-TODAYS-DATE-YMD = '010613'                                                                              
142400*      GO TO READ-THE-MAIL-EXIT                                                                                   
      *    END-IF.                                                                                                      
138600
126030    WRITE PRT-RECORD FROM PCL5-LANDSCAPE                                                                          
138300                    AFTER ADVANCING 0 LINES.                                                                      
126030    WRITE PRT-RECORD FROM PCL5-FONT-PC8                                                                           
138300                    AFTER ADVANCING 0 LINES.                                                                      
126030    WRITE PRT-RECORD FROM PCL5-PRM-SPACE-FIXED                                                                    
138300                    AFTER ADVANCING 0 LINES.                                                                      
126030    WRITE PRT-RECORD FROM PCL5-LINE-SPACE-08LPI                                                                   
138300                    AFTER ADVANCING 0 LINES.                                                                      
138800    MOVE 0013          TO pcl5-CPI-value.                                                                         
126030    WRITE PRT-RECORD FROM pcl5-primary-PITCH-CPI
138300                    AFTER ADVANCING 0 LINES.                                                                      
138800    MOVE 0010          TO pcl5-points-value.                                                                      
126030    WRITE PRT-RECORD FROM pcl5-primary-height                                                                     
138300                    AFTER ADVANCING 0 LINES.                                                                      
126030    WRITE PRT-RECORD FROM pcl5-STYLE-UPRIGHT                                                                      
138300                    AFTER ADVANCING 0 LINES.                                                                      
126030    WRITE PRT-RECORD FROM pcl5-WT-BOLD                                                                            
138300                    AFTER ADVANCING 0 LINES.                                                                      
126030    WRITE PRT-RECORD FROM pcl5-fam-courier                                                                        
138300                    AFTER ADVANCING 0 LINES.                                                                      
014200    MOVE ZEROS                  TO LOGON-IDX.                                                                     
014200    MOVE ZEROS                  TO IDX-COUNT.                                                                     
014200    MOVE ZEROS                  TO COL-1-COUNT                                                                    
014200                                   COL-2-COUNT                                                                    
014200                                   COL-3-COUNT                                                                    
014200                                   COL-4-COUNT                                                                    
014200                                   COL-5-COUNT                                                                    
014200                                   COL-6-COUNT                                                                    
014200                                   COL-7-COUNT                                                                    
014200                                   COL-8-COUNT                                                                    
014200                                   COL-9-COUNT                                                                    
014200                                   COL-10-COUNT.                                                                  
125900
138200 break-page-two.                                                                                                  
126050    MOVE SPACES        TO PRT-RECORD.                                                                             
126060    WRITE PRT-RECORD.                                                                                             
126060    WRITE PRT-RECORD.                                                                                             
131910
132032    ADD 1               TO PAGE-COUNT.
132033    MOVE PAGE-COUNT     TO PRT-HDR1pg2-PAGE-NUM.                                                                  
132034    WRITE PRT-RECORD  FROM PRT-HDR1pg2.                                                                           
132036    MOVE SPACES         TO PRT-RECORD.
132037    WRITE PRT-RECORD.
138200    move zeros          to two-per-page.                                                                          
132050
132050
138200 NEXT-10-LOGONS.                                                                                                  
132100    PERFORM VARYING THE-INDEX FROM 1 BY 1                                                                         
132200              UNTIL THE-INDEX > 10                                                                                
014200      SET LOGON-IDX UP BY 1                                                                                       
132300      IF ADMIN-LOGON(LOGON-IDX) NOT = SPACES                                                                      
014200         ADD 1                  TO IDX-COUNT                                                                      
132300         MOVE ADMIN-LOGON(LOGON-IDX)                                                                              
007500                 TO PRT-HDR4pg2-LOGON(THE-INDEX)                                                                  
133540        END-IF                                                                                                    
133540      END-PERFORM.                                                                                                
132050
132038    WRITE PRT-RECORD  FROM PRT-HDR4pg2.                                                                           
132039    MOVE SPACES         TO PRT-RECORD.
132040    WRITE PRT-RECORD.
132050
133600    PERFORM VARYING ALT-INDEX FROM 1 BY 1                                                                         
133700              UNTIL ALT-INDEX > 23                                                                                
134700        MOVE ADMIN-DESCRIP(TBL-IDX-1,ALT-INDEX)                                                                   
134800                              TO PRT-CAT-DESCRIP                                                                  
134900        MOVE ADMIN-COUNT(TBL-IDX-1,ALT-INDEX)                                                                     
135000                              TO PRT-CNT-TODAY(IDX-1)
134900        ADD ADMIN-COUNT(TBL-IDX-1,ALT-INDEX)                                                                      
014200                              TO COL-1-COUNT                                                                      
014200        IF IDX-COUNT > 1                                                                                          
134900           MOVE ADMIN-COUNT(TBL-IDX-2,ALT-INDEX)                                                                  
135000                              TO PRT-CNT-TODAY(IDX-2)
134900           ADD ADMIN-COUNT(TBL-IDX-2,ALT-INDEX)                                                                   
014200                              TO COL-2-COUNT                                                                      
133540         END-IF                                                                                                   
014200        IF IDX-COUNT > 2                                                                                          
134900           MOVE ADMIN-COUNT(TBL-IDX-3,ALT-INDEX)                                                                  
135000                              TO PRT-CNT-TODAY(IDX-3)
134900           ADD ADMIN-COUNT(TBL-IDX-3,ALT-INDEX)                                                                   
014200                              TO COL-3-COUNT                                                                      
133540         END-IF                                                                                                   
014200        IF IDX-COUNT > 3                                                                                          
134900           MOVE ADMIN-COUNT(TBL-IDX-4,ALT-INDEX)                                                                  
135000                              TO PRT-CNT-TODAY(IDX-4)
134900           ADD ADMIN-COUNT(TBL-IDX-4,ALT-INDEX)                                                                   
014200                              TO COL-4-COUNT                                                                      
133540         END-IF                                                                                                   
014200        IF IDX-COUNT > 4                                                                                          
134900           MOVE ADMIN-COUNT(TBL-IDX-5,ALT-INDEX)                                                                  
135000                              TO PRT-CNT-TODAY(IDX-5)
134900           ADD ADMIN-COUNT(TBL-IDX-5,ALT-INDEX)                                                                   
014200                              TO COL-5-COUNT                                                                      
133540         END-IF                                                                                                   
014200        IF IDX-COUNT > 5                                                                                          
134900           MOVE ADMIN-COUNT(TBL-IDX-6,ALT-INDEX)                                                                  
135000                              TO PRT-CNT-TODAY(IDX-6)
134900           ADD ADMIN-COUNT(TBL-IDX-6,ALT-INDEX)                                                                   
014200                              TO COL-6-COUNT                                                                      
133540         END-IF                                                                                                   
014200        IF IDX-COUNT > 6                                                                                          
134900           MOVE ADMIN-COUNT(TBL-IDX-7,ALT-INDEX)                                                                  
135000                              TO PRT-CNT-TODAY(IDX-7)
134900           ADD ADMIN-COUNT(TBL-IDX-7,ALT-INDEX)                                                                   
014200                              TO COL-7-COUNT                                                                      
133540         END-IF                                                                                                   
014200        IF IDX-COUNT > 7                                                                                          
134900           MOVE ADMIN-COUNT(TBL-IDX-8,ALT-INDEX)                                                                  
135000                              TO PRT-CNT-TODAY(IDX-8)
134900           ADD ADMIN-COUNT(TBL-IDX-8,ALT-INDEX)                                                                   
014200                              TO COL-8-COUNT                                                                      
133540         END-IF                                                                                                   
014200        IF IDX-COUNT > 8                                                                                          
134900           MOVE ADMIN-COUNT(TBL-IDX-9,ALT-INDEX)                                                                  
135000                              TO PRT-CNT-TODAY(IDX-9)
134900           ADD ADMIN-COUNT(TBL-IDX-9,ALT-INDEX)                                                                   
014200                              TO COL-9-COUNT                                                                      
133540         END-IF                                                                                                   
014200        IF IDX-COUNT > 9                                                                                          
134900           MOVE ADMIN-COUNT(TBL-IDX-10,ALT-INDEX)                                                                 
135000                              TO PRT-CNT-TODAY(IDX-10)                                                            
134900           ADD ADMIN-COUNT(TBL-IDX-10,ALT-INDEX)                                                                  
014200                              TO COL-10-COUNT                                                                     
133540         END-IF                                                                                                   
138200        WRITE PRT-RECORD                                                                                          
138300        MOVE SPACES      TO PRT-RECORD                                                                            
138400      END-PERFORM.                                                                                                
138400                                                                                                                  
138300     MOVE SPACES         TO PRT-RECORD.                                                                           
138200     WRITE PRT-RECORD.                                                                                            
138400                                                                                                                  
134800     MOVE '       TOTAL'      TO PRT-CAT-DESCRIP.                                                                 
134900     MOVE COL-1-COUNT         TO PRT-CNT-TODAY(IDX-1).                                                            
014200     IF IDX-COUNT > 1                                                                                             
134900        MOVE COL-2-COUNT      TO PRT-CNT-TODAY(IDX-2)                                                             
133540      END-IF.                                                                                                     
014200     IF IDX-COUNT > 2                                                                                             
134900        MOVE COL-3-COUNT      TO PRT-CNT-TODAY(IDX-3)                                                             
133540      END-IF.                                                                                                     
014200     IF IDX-COUNT > 3                                                                                             
134900        MOVE COL-4-COUNT      TO PRT-CNT-TODAY(IDX-4)                                                             
133540      END-IF.                                                                                                     
014200     IF IDX-COUNT > 4                                                                                             
134900        MOVE COL-5-COUNT      TO PRT-CNT-TODAY(IDX-5)                                                             
133540      END-IF.                                                                                                     
014200     IF IDX-COUNT > 5                                                                                             
134900        MOVE COL-6-COUNT      TO PRT-CNT-TODAY(IDX-6)                                                             
133540      END-IF.                                                                                                     
014200     IF IDX-COUNT > 6                                                                                             
134900        MOVE COL-7-COUNT      TO PRT-CNT-TODAY(IDX-7)                                                             
133540      END-IF.                                                                                                     
014200     IF IDX-COUNT > 7                                                                                             
134900        MOVE COL-8-COUNT      TO PRT-CNT-TODAY(IDX-8)                                                             
133540      END-IF.                                                                                                     
014200     IF IDX-COUNT > 8                                                                                             
134900        MOVE COL-9-COUNT      TO PRT-CNT-TODAY(IDX-9)                                                             
133540      END-IF.                                                                                                     
014200     IF IDX-COUNT > 9                                                                                             
134900        MOVE COL-10-COUNT     TO PRT-CNT-TODAY(IDX-10)                                                            
133540      END-IF.                                                                                                     
138200     WRITE PRT-RECORD.                                                                                            
138300     MOVE SPACES      TO PRT-RECORD.                                                                              
138400                                                                                                                  
014200     SET LOGON-IDX UP BY 1.                                                                                       
132300     IF ADMIN-LOGON(LOGON-IDX) NOT = SPACES                                                                       
014200        SET LOGON-IDX DOWN BY 1                                                                                   
014200        MOVE ZEROS              TO IDX-COUNT                                                                      
014200        MOVE ZEROS              TO COL-1-COUNT                                                                    
014200                                   COL-2-COUNT                                                                    
014200                                   COL-3-COUNT                                                                    
014200                                   COL-4-COUNT                                                                    
014200                                   COL-5-COUNT                                                                    
014200                                   COL-6-COUNT                                                                    
014200                                   COL-7-COUNT                                                                    
014200                                   COL-8-COUNT                                                                    
014200                                   COL-9-COUNT                                                                    
014200                                   COL-10-COUNT                                                                   
134900        SET TBL-IDX-1 UP BY 10                                                                                    
134900        SET TBL-IDX-2 UP BY 10                                                                                    
134900        SET TBL-IDX-3 UP BY 10                                                                                    
134900        SET TBL-IDX-4 UP BY 10                                                                                    
134900        SET TBL-IDX-5 UP BY 10                                                                                    
134900        SET TBL-IDX-6 UP BY 10                                                                                    
134900        SET TBL-IDX-7 UP BY 10                                                                                    
134900        SET TBL-IDX-8 UP BY 10                                                                                    
134900        SET TBL-IDX-9 UP BY 10                                                                                    
134900        SET TBL-IDX-10 UP BY 10                                                                                   
007200        MOVE SPACES             TO PRT-HDR4pg2-LOGONS                                                             
138300        MOVE SPACES             TO PRT-RECORD                                                                     
138200        WRITE PRT-RECORD                                                                                          
138200        WRITE PRT-RECORD                                                                                          
138200        add 1              to two-per-page                                                                        
138200        if two-per-page = 2                                                                                       
126030           WRITE PRT-RECORD FROM PCL5-FORM-FEED                                                                   
138300                           AFTER ADVANCING 0 LINES                                                                
138200           go to break-page-two                                                                                   
133540         END-IF                                                                                                   
138200        GO TO NEXT-10-LOGONS                                                                                      
133540      END-IF.                                                                                                     
138400                                                                                                                  
142400 READ-THE-MAIL-EXIT. EXIT.
142500
142600
142700
142800 FILE-ERROR.
142900     CALL TPSIOERR USING FILE-REQUEST.
143000     CANCEL TPSIOERR.
143100 FILE-ERROR-EXIT. EXIT.
143200
143300
143400 OPEN-THE-FILES.
143500    OPEN OUTPUT PRT-FILE.                                                                                         
146200    MOVE F-PRIME    TO FILE-KEY.
146300    MOVE F-OPEN-INPUT TO FILE-ACTION.
146400    CALL TPSIOREC USING FILE-REQUEST TPS-MAIL-REC.
146500    IF FILE-STATUS NOT = '00' AND '05'
146600       MOVE 'RECEIVE ' TO FILE-NAME
146700       MOVE 'TPS021-ORC' TO FILE-TEXT
146800       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
146900       GO TO TPS021-COMMON-EXIT.
147000    MOVE F-PRIME    TO FILE-KEY.
147100    MOVE F-OPEN-I-O TO FILE-ACTION.
147200    CALL TPSIO001 USING FILE-REQUEST TPS-LOGON-REC.
147300    IF FILE-STATUS NOT = '00' AND '05'
147400       MOVE 'LOGON   ' TO FILE-NAME
147500       MOVE 'TPS021-ORC' TO FILE-TEXT
147600       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
147700       GO TO TPS021-COMMON-EXIT.
147800
147900    MOVE F-PRIME    TO FILE-KEY.
148000    MOVE F-OPEN-I-O TO FILE-ACTION.
148100    CALL TPSIO004 USING FILE-REQUEST TPS-PROFL-REC.
148200    IF FILE-STATUS NOT = '00' AND '05'
148300       MOVE 'LOGON   ' TO FILE-NAME
148400       MOVE 'TPS021-ORC' TO FILE-TEXT
148500       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
148600       GO TO TPS021-COMMON-EXIT.
147800
147900    MOVE F-PRIME    TO FILE-KEY.
146300    MOVE F-OPEN-INPUT TO FILE-ACTION.
148100    CALL TPSIO029 USING FILE-REQUEST TPS-TRACK-REC.
148200    IF FILE-STATUS NOT = '00' AND '05'
148300       MOVE 'TRACK   ' TO FILE-NAME
148400       MOVE 'TPS021-ORC' TO FILE-TEXT
148500       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
148600       GO TO TPS021-COMMON-EXIT.
148700
148800 OPEN-THE-FILES-EXIT. EXIT.
148900
149000
149100 CLOSE-THE-FILES.
149200      CLOSE PRT-FILE.                                                                                             
149400      MOVE F-PRIME TO FILE-KEY.
149500      MOVE F-CLOSE TO FILE-ACTION.
149700      CALL TPSIOREC USING FILE-REQUEST TPS-MAIL-REC.
149800      IF NOT A-SUCCESSFUL-OPERATION
149900         MOVE 'RECEIVE ' TO FILE-NAME
150000         MOVE 'TPS021-CCK' TO FILE-TEXT
150100         PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
150200       END-IF.
148100      CALL TPSIO029 USING FILE-REQUEST TPS-TRACK-REC.                                                             
149800      IF NOT A-SUCCESSFUL-OPERATION
148300         MOVE 'TRACK   ' TO FILE-NAME                                                                             
148400         MOVE 'TPS021-CCK' TO FILE-TEXT                                                                           
148500         PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                                                  
151600       END-IF.                                                                                                    
151800 CLOSE-THE-FILES-EXIT. EXIT.
151900
151900
