000400 IDENTIFICATION DIVISION.
000500 PROGRAM-ID. TPS010.
000600***************************************************************
000700*                                                             *
000800*   FOR PRIVATE LABEL PROCESSING, EXECUTE .BAT FILE FOR EACH  *
000900*   ACCOUNT NUMBER............................                *
001000*                                                             *
001100***************************************************************
001200*    THIS MODULE WILL SELECT ALL CLIENTS WHO REQUIRE THEIR    *
001300*    CALENDARS BE PRINTED AND PASS THE ACCOUNT NUMBER TO      *
001400*    TPS4500 (ONE ACCOUNT PER EXECUTION) UNTIL ALL ACCOUNTS   *
001500*    FOR ACTIVE ADMINISTRATOR HAVE BEEN PROCESSED........     *
001600*                                                             *
001700***************************************************************
001800***************************************************************
001900*                   MAINTENANCE LOG                           *
003720* 05/17/01 ELIMINATE PRINTING OF CALENDAR CONTROL SHEET       *
003720*    TS    ELIMINATE DISPLAYS(AND NEED TO RESPOND)...         *
003720* 10/25/00 REPLACE TPSSIGN WITH PASIGN FOR PA SIGNATURE    JM *
003720* 04/03/00 TAKE OUT MISSING MAIL (TPS1010M).               JM *
003720* 01/14/99 ADDED 'IF NO-RECORD-WAS-FOUND' AT READ OF PROFILE, *
003720*    TS    GAP IN ACCOUNTS CAUSED BY BUG IN NEW ACCOUNT SETUP *
073000* 05/07/98 COMMENTED OUT CHECK FOR LOGON 'NYTHSCA   ' WHICH   *
073000*    TS    IS USED TO SKIP CALL TO TPS1010M WHEN TESTING      *
001910* 03/03/98 ADDED '88' LEVEL TO LINK-PARMS TO INDICATE IF ;    *
001920*    TS    1 - BROADCAST MONTHLY                              *
001920*          2 - PRINT MONTHLY                                  *
001920*          3 - PRINT WEEKLY.......                            *
001910* 02/19/98 ADDED OPTION TO BROADCAST CALENDAR UODATE REMINDER *
001920*    TS    TO ALL CLIENTS THAT SUBSCRIBE TO CALENDAR PRINT... *
002000* 10/27/97 MOVE FIRST ACCT TO LINK-PARM TO PASS TO TPS1010M   *
002100* 10/24/96 CHANGED CONTROL LOG TO BE MORE USER FRIENDLY AND   *
002200*    TS    ELIMINATED OBSOLETE DATES.                         *
002300* 02/22/96 ADD MISSING MAIL REPORT AFTER CALENDAR IS PRINTED  *
002400* 02/07/96 SKIP CLIENTS THAT DO NOT WANT CALENDAR PRINTED  JM *
002500* 01/31/96 ADDED LOGO CALLS AND CALL OF .BAT FILE TO PRINT    *
002600*    TS    CALENDARS, ADDED 'PROCESSING' AND 'PRINTING' PANELS*
002700* 01/25/96 CORRECTED ONE BAD CHECK OF DELETED ACCOUNTS.   TS  *
002800* 01/19/96 SKIP CLIENTS THAT HAVE BEEN DELETED.           JM  *
002900***************************************************************
003000 ENVIRONMENT DIVISION.
003100 CONFIGURATION SECTION.
003200 SOURCE-COMPUTER. IBM-PS2.
003300 OBJECT-COMPUTER. IBM-PS2.
003400
003500 FILE-CONTROL.
003600
003700     SELECT PRT-FILE  ASSIGN TO "C:\TPS\APP\CALCNTRL.TXT"
003800***  SELECT PRT-FILE  ASSIGN TO "LPT1"
003900         ORGANIZATION IS LINE SEQUENTIAL.
004000
004200 DATA DIVISION.
004300 FILE SECTION.
004400 FD  PRT-FILE
004500     LABEL RECORDS ARE OMITTED
004600     RECORD CONTAINS 150 CHARACTERS.
004700 01  PRT-RECORD PIC X(150).
004800
005100 WORKING-STORAGE SECTION.

************WINFORMS DEFINITIONS*********************


*****************************************************

******DIALOG SCREEN DEFINITION*****

       01 WS-CURRENT-X                            PIC 9(04).
       01 WS-CURRENT-Y                            PIC 9(04).
       01 WS-CURRENT-XY-PARM.
          05 WS-X-PARM                            PIC 9(04).
          05 WS-Y-PARM                            PIC 9(04).

       COPY "ds-cntrl.v1".
**********************************************************
005200 01  FILESPEC                    PIC X(80) VALUE SPACES.
005300 01  THE-INDEX                      PIC S9(4) COMP.
005400
005500 01 RPRT-PARM.
005600    05 RPRT-PROG-ID         PIC  X(08) VALUE 'TPS4500 '.
005700    05 RPRT-DISPOSITION     PIC  X(02) VALUE '03'.
005800    05 RPRT-CATEGORY        PIC  X(02) VALUE '19'.
005900    05 RPRT-FROM-NAME       PIC  X(36) VALUE
006000                    'Personal Calendar Update Reminder   '.
006100    05 RPRT-TO-NAME         PIC  X(36) VALUE
006200                    '                                    '.
006300
006400
006500 01  WS-DATE-REQUEST.
006600     05  WS-DATE-PARAM          PIC  9(02).
006700
006800     05  WS-DATE-TENBYTES       PIC  X(20) VALUE SPACES.
006900     05  FILLER REDEFINES WS-DATE-TENBYTES.
007000         10  WS-DATE-REFORM         PIC  X(06).
007100         10  WS-DATE-EXTEND         PIC  X(04).
007200         10  FILLER                 PIC  X(10).
007300     05  FILLER REDEFINES WS-DATE-TENBYTES.
007400         10  WS-DATE-REFORM-LEN06   PIC  X(06).
007500         10  FILLER                 PIC  X(14).
007600     05  FILLER REDEFINES WS-DATE-TENBYTES.
007700         10  WS-DATE-REFORM-LEN08   PIC  X(08).
007800         10  FILLER                 PIC  X(12).
007900     05  FILLER REDEFINES WS-DATE-TENBYTES.
008000         10  WS-DATE-REFORM-LEN10   PIC  X(10).
008100         10  FILLER                 PIC  X(10).
008200     05  FILLER REDEFINES WS-DATE-TENBYTES.
008300         10  WS-TIME-PARM1          PIC  X(06).
008400         10  WS-TIME-PARM2          PIC  X(06).
008500         10  WS-TIME-EXTEND         PIC  X(08).
008600     05  FILLER REDEFINES WS-DATE-TENBYTES.
008700         10  WS-TIME-PARM1BY8       PIC  X(08).
008800         10  WS-TIME-PARM2BY8       PIC  X(08).
008900         10  WS-TIME-EXTNDBY8       PIC  X(04).
009000
009100     05  WORK-DATE-CYMD             PIC  9(08).
009200     05  SUNDAY-CYMD                PIC  9(08).
009300
009400 01 TODAYS-DATE-YMD                  PIC  9(06).
009500 01 TODAYS-DATE-CYMD                 PIC  9(08).
009600
009700
009800 01 JCL-PCL.
009900     05  PCL                         PIC  X(20).
010000     05  FULL-LINE-PRINT             PIC  X(240) VALUE SPACES.
010100
010200*************************************************************
010300
010400 01  DL0.
010500      05  FILLER               PIC  X(35) VALUE SPACES.
010600      05  FILLER               PIC  X(08) VALUE ' THIS WK'.
010700      05  FILLER               PIC  X(04) VALUE SPACES.
010800      05  FILLER               PIC  X(08) VALUE ' NEXT WK'.
010900
011000 01  DL1.
011100      05  FILLER               PIC  X(15) VALUE SPACES.
011200      05  FILLER        PIC  X(20) VALUE 'PRINT CALENDARS ON  '.
011300      05  OLD-PRINT-MNTH-DATE      PIC  X(08).
011400      05  FILLER                   PIC  X(04) VALUE SPACES.
011500      05  NEW-PRINT-MNTH-DATE      PIC  X(08).
011600
011700 01  DL2.
011800      05  FILLER               PIC  X(15) VALUE SPACES.
011900      05  FILLER        PIC  X(20) VALUE 'PRINT WEEKLY FROM   '.
012000      05  OLD-APPNT-WKLY-FROM      PIC  X(08).
012100      05  FILLER                   PIC  X(04) VALUE SPACES.
012200      05  NEW-APPNT-WKLY-FROM      PIC  X(08).
012300
012400 01  DL3.
012500      05  FILLER               PIC  X(15) VALUE SPACES.
012600      05  FILLER        PIC  X(20) VALUE 'PRINT WEEKLY TO     '.
012700      05  OLD-APPNT-WKLY-TO        PIC  X(08).
012800      05  FILLER                   PIC  X(04) VALUE SPACES.
012900      05  NEW-APPNT-WKLY-TO        PIC  X(08).
013000
013100 01  DL4.
013200      05  FILLER               PIC  X(15) VALUE SPACES.
013300      05  FILLER        PIC  X(20) VALUE 'PRINT MONTHLY FROM  '.
013400      05  OLD-PRINT-MNTH-FROM      PIC  X(08).
013500      05  FILLER                   PIC  X(04) VALUE SPACES.
013600      05  NEW-PRINT-MNTH-FROM      PIC  X(08).
013700
013800 01  DL5.
013900      05  FILLER               PIC  X(15) VALUE SPACES.
014000      05  FILLER        PIC  X(20) VALUE 'PRINT MONTHLY TO    '.
014100      05  OLD-PRINT-MNTH-TO        PIC  X(08).
014200      05  FILLER                   PIC  X(04) VALUE SPACES.
014300      05  NEW-PRINT-MNTH-TO        PIC  X(08).
014400
014500 01  DL6.
014600      05  FILLER               PIC  X(15) VALUE SPACES.
014700      05  FILLER        PIC  X(20) VALUE 'PRINT YEARLY FROM   '.
014800      05  OLD-PRINT-YRLY-FROM      PIC  X(08).
014900      05  FILLER                   PIC  X(04) VALUE SPACES.
015000      05  NEW-PRINT-YRLY-FROM      PIC  X(08).
015100
015200 01  DL7.
015300      05  FILLER               PIC  X(15) VALUE SPACES.
015400      05  FILLER        PIC  X(20) VALUE 'PRINT YEARLY TO     '.
015500      05  OLD-PRINT-YRLY-TO        PIC  X(08).
015600      05  FILLER                   PIC  X(04) VALUE SPACES.
015700      05  NEW-PRINT-YRLY-TO        PIC  X(08).
015800
015900*************************************************************
016000
016100 01  CR1.
016200      05  FILLER        PIC  X(20) VALUE '  Copyright 1994,   '.
016300      05  FILLER        PIC  X(20) VALUE 'Total Personal Servi'.
016400      05  FILLER        PIC  X(20) VALUE 'ces Administrative G'.
016500      05  FILLER        PIC  X(20) VALUE 'roup LLC,           '.
016600
016700 01  CR2.
016800      05  FILLER        PIC  X(20) VALUE SPACES.
016900      05  FILLER        PIC  X(20) VALUE 'Garden City, New Yor'.
017000      05  FILLER        PIC  X(20) VALUE 'k 11530.  All Rights'.
017100      05  FILLER        PIC  X(20) VALUE ' Reserved.          '.
017200
017300
017400
017500 01  WL0.
017600      05  FILLER        PIC  X(10) VALUE SPACES.
017700      05  WL0-DATE      PIC  X(08).
017800      05  FILLER        PIC  X(05) VALUE SPACES.
017900      05  WL0-TIME      PIC  X(08).
018000      05  FILLER        PIC  X(20) VALUE SPACES.
018100      05  FILLER        PIC  X(20) VALUE '             TPS010.'.
018200
018300 01  WL1.
018400      05  FILLER        PIC  X(10) VALUE SPACES.
018500      05  FILLER        PIC  X(20) VALUE '                    '.
018600      05  FILLER        PIC  X(20) VALUE 'PLEASE NOTE:        '.
018700      05  FILLER        PIC  X(20) VALUE '                    '.
018800
018900 01  WL2.
019000      05  FILLER        PIC  X(10) VALUE SPACES.
019100      05  FILLER        PIC  X(20) VALUE 'The following dates '.
019200      05  FILLER        PIC  X(20) VALUE 'MUST be verified bef'.
019300      05  FILLER        PIC  X(20) VALUE 'ore another cycle of'.
019400
019500 01  WL3.
019600      05  FILLER        PIC  X(10) VALUE SPACES.
019700      05  FILLER        PIC  X(20) VALUE 'Calendars are printe'.
019800      05  FILLER        PIC  X(20) VALUE 'd.                  '.
019900
020000 01  WL4.
020100      05  FILLER        PIC  X(10) VALUE SPACES.
020200      05  FILLER        PIC  X(20) VALUE 'After verification, '.
020300      05  FILLER        PIC  X(20) VALUE 'please initial this '.
020400      05  FILLER        PIC  X(20) VALUE 'report and add it to'.
020500
020600 01  WL5.
020700      05  FILLER        PIC  X(10) VALUE SPACES.
020800      05  FILLER        PIC  X(20) VALUE 'the Calendar Control'.
020900      05  FILLER        PIC  X(20) VALUE ' Logbook..          '.
021000
021100 01  WL9.
021200      05  FILLER        PIC  X(05) VALUE SPACES.
021300      05  FILLER        PIC  X(20) VALUE SPACES.
021400      05  FILLER        PIC  X(20) VALUE '       Initial _____'.
021500      05  FILLER        PIC  X(20) VALUE '_______   Date    / '.
021600      05  FILLER        PIC  X(20) VALUE '    /     ...       '.
021700
021800*************************************************************
021900
022000
022100
022200 01  BAT-COMMAND-1              PIC  X(80)
022300      VALUE 'C:\TPS\APP\CALENDAR.BAT                   '.
022400 01  DEL-COMMAND-1              PIC  X(80)
022500      VALUE 'DEL C:\TPS\APP\CALENDAR.BAT               '.
022600 01  PRT-COMMAND-1              PIC  X(80)
022700      VALUE 'P C:\TPS\APP\CALENDAR.PCL                 '.
022800 01  PRT-COMMAND-2      PIC  X(80)
022900      VALUE 'P C:\TPS\APP\CALCNTRL.TXT                 '.
023000 01  RESULT                     PIC 99 COMP-X.
023100 01  FUNCTION-35                PIC 99 COMP-X VALUE 35.
023200 01  NULL-PARAMETER.
023300      05  FILLER                PIC 99 COMP-X VALUE 0.
023400      05  FILLER                PIC X.
023500
023600
023700 01  FILE-ASSIGNMENT            PIC  X(80) VALUE
023800           'C:\TPS\APP\CALENDAR.PCL                 '.
023900
024000
024100  01  TIME-DAY.
024200      05  TIME-OF-DAY            PIC  9(08).
024300      05  FILLER REDEFINES TIME-OF-DAY.
024400          10  TIME-OF-DAY-HH     PIC  9(02).
024500          10  TIME-OF-DAY-MM     PIC  9(02).
024600          10  TIME-OF-DAY-SS     PIC  9(04).
024700          10  FILLER REDEFINES TIME-OF-DAY-SS.
024800              15  TIME-IN-SS1    PIC  9(02).
024900              15  TIME-IN-SS2    PIC  9(02).
025000
025100 01 WS-FLOAT-DATA.
025200    05  WS-FLOAT-PARMS            PIC  X(101).
025300    05  FILLER REDEFINES WS-FLOAT-PARMS.
025400        10 WS-FLOAT-COUNT         PIC  X(01).
025500        10 WS-FLOAT-1             PIC  X(25).
025600        10 WS-FLOAT-2             PIC  X(25).
025700        10 WS-FLOAT-3             PIC  X(25).
025800        10 WS-FLOAT-4             PIC  X(25).
025900
026000 01  LINK-PARMS.
026100      05  PARMS                       PIC  X(250).
026200      05  FILLER REDEFINES PARMS.
026300          10  PARM01                  PIC  9(12).
026400          10  FILLER REDEFINES PARM01.
026500              15 PARM01-ACCOUNT-NUMBER  PIC  9(10).
026600              15 PARM01-SUB-ACCT        PIC  9(02).
026700          10  PARM02                  PIC  9(01).
026800              88  PARM02-NEW-ACCT                VALUE 1.
026900          10  PARM03                  PIC  9(01).
027000              88  PARM03-MAINT-ACCT              VALUE 1.
027100          10  PARM04                  PIC  9(01).
027200              88  PARM04-DELETE-ACCT             VALUE 1.
027300          10  PARM05                  PIC  9(01).
027400              88  PARM03-UNDELETE-ACCT           VALUE 1.
027500          10  PARM06                  PIC  9(01).
027600          10  PARM07                  PIC  9(01).
027700          10  PARM08                  PIC  9(01).
027800          10  PARM09                  PIC  9(01).
027900          10  PARM10                  PIC  9(01).
028000          10  FILLER                  PIC  X(231).
028100
028200     COPY PROCESS.COB.
028300     COPY PRINTING.COB.
028300     COPY NOTHING.COB.
028400
028500     COPY "TPSFILES.CPY".
028600     COPY "KEYVALUE.CPY".
028600     COPY "PCLVALUE.CPY".
028700
028800 01  TPS-MAIL-REC.
028900     COPY "TPSMAIL.CPY".
029000
029100 01  TPS-MEMO-REC.
029200     COPY "TPSMEMO.CPY".
029300
029400 01  TPS-CAL-REC.
029500     COPY TPSCALEN.CPY.
029600
029700 01  TPS-BRANCH-REC.
029800     COPY TPSBRNCH.CPY.
029900
030000 01 TPS-PROFL-REC.
030100     COPY "TPSPROFL.CPY".
030200
030300 01  PROGRAM-NAMES.
030400     10 SCREENIO    PIC X(08) VALUE 'SCRNIO'.
030500     10 FLOATIT     PIC X(08) VALUE 'FLOATIT '.
030600     10 TPSIOERR    PIC X(08) VALUE 'TPSIOERR'.
030700     10 TPSDATES    PIC X(08) VALUE 'TPSDATES'.
030800     10 TPSIO003    PIC X(08) VALUE 'TPSIO003'.
030900     10 TPSIO004    PIC X(08) VALUE 'TPSIO004'.
031000     10 TPSIO018    PIC X(08) VALUE 'TPSIO018'.
031100     10 TPSIOREC    PIC X(08) VALUE 'TPSIOREC'.
031200     10 TPS1010G    PIC X(08) VALUE 'TPS1010G'.
031300     10 TPS1010M    PIC X(08) VALUE 'TPS1010M'.
031400     10 TPS4500     PIC X(08) VALUE 'TPS4500'.
031500     10 MOD10       PIC X(08) VALUE 'MOD10'.
031600     10 TPSLOGOS    PIC X(08) VALUE 'TPSLOGOS'.
031700*JM10/00  10 TPSSIGN     PIC X(08) VALUE 'TPSSIGN '.
031700     10 PASIGN      PIC X(08) VALUE 'PASIGN  '.
031800     10 FILLER      PIC X(08) VALUE HIGH-VALUES.
031900
032000 01  PROGRAM-NAMES-R REDEFINES PROGRAM-NAMES.
032100     10 PROGRAM-NAME PIC X(08) OCCURS 15 TIMES.
032200
032300 01  TPS-FILE-STATUS                       PIC XX.
032400     88  TPS-CARRIER-FILE-OK VALUE '00', '02'.
032500
032600 01  LS-PARMS.
032700     05  LS-WHAT-KIND-OF-OPTION     PIC  X(02) VALUE '00'.
032800         88  LS-DOWNLOAD-TPS                   VALUE '01'.
032900         88  LS-DOWNLOAD-YES                   VALUE '02'.
033000         88  LS-PRINT-LOGO-TPS                 VALUE '11'.
033100         88  LS-PRINT-LOGO-YES                 VALUE '12'.
033200         88  LS-UNLOAD-TPS                     VALUE '21'.
033300         88  LS-UNLOAD-YES                     VALUE '22'.
033400         88  LS-WRITE-PRINT-COMMAND            VALUE '31'.
033500         88  LS-WRITE-PRINT-COPY-COMMAND       VALUE '32'.
033600         88  LS-SEEIF-PRIVATE-LABEL            VALUE '99'.
033700     05  LS-DOWNLOAD-PCL-ID         PIC  X(12) VALUE
033800                    'LOGO000.PCL '.
033900     05  LS-MACRO-ID       PIC  X(02) VALUE '01'.
034000     05  LS-HORIZONTAL-CURSOR       PIC  9(04).
034100     05  LS-VERTICAL-CURSOR         PIC  9(04).
034200     05  LS-RESOLUTION-VALUE        PIC  9(03).
034300     05  LS-FILE-ASSIGNMENT         PIC  X(88) VALUE SPACES.
034400     05  LS-ACCOUNT-NUMBER          PIC  9(10) VALUE ZEROS.
034500
034600 01 MISC-STORAGE.
034700     05  PRIVATE-LABELS-PRESENT-FLAG PIC 9(01) VALUE 0.
034800         88  PRIVATE-LABELS-PRESENT            VALUE 1.
034900
035000     05  WERE-BROADCASTING-FLAG      PIC 9(01) VALUE 0.
035100         88  WERE-BROADCASTING                 VALUE 1.
035200
053400     05  WE-DID-CALENDARS-FLAG       PIC 9(01) VALUE 0.
053400         88 WE-DID-CALENDARS                   VALUE 1.
035200
035300***************************      '1234567890123456789012345'.
035400 01 MEMO-LINES.
035500    05 MEMO-LINE-01.
035600       10 FILLER PIC X(25) VALUE 'Just a reminder, your mon'.
035700       10 FILLER PIC X(25) VALUE 'thly personal calendar is'.
035800    05 MEMO-LINE-02.
035900       10 FILLER PIC X(25) VALUE 'scheduled to be printed o'.
036000       10 FILLER PIC X(02) VALUE 'n '.
036100       10 MEMO-LINE-02-DATE  PIC X(08).
036200       10 FILLER PIC X(15) VALUE '. Please send  '.
036200****** 10 FILLER PIC X(15) VALUE '. Please submit'.
036300    05 MEMO-LINE-03.
036400       10 FILLER PIC X(25) VALUE 'any additions/changes to '.
036500       10 FILLER PIC X(16) VALUE 'me on or before '.
036600       10 MEMO-LINE-03-DATE  PIC X(08).
036700       10 FILLER PIC X(01) VALUE ' '.
036800    05 MEMO-LINE-04.
036900       10 FILLER PIC X(25) VALUE 'to ensure that they will '.
037000       10 FILLER PIC X(25) VALUE 'appear on the calendar.  '.
037100    05 MEMO-LINE-05.
037200       10 FILLER PIC X(25) VALUE '                         '.
037300       10 FILLER PIC X(25) VALUE '                         '.
037400    05 MEMO-LINE-06.
037500       10 FILLER PIC X(25) VALUE '                         '.
037600       10 FILLER PIC X(25) VALUE '                         '.
037700    05 MEMO-LINE-07.
037800       10 FILLER PIC X(25) VALUE '                         '.
037900       10 FILLER PIC X(25) VALUE '                         '.
038000    05 MEMO-LINE-08.
038100       10 FILLER PIC X(25) VALUE '                         '.
038200       10 FILLER PIC X(25) VALUE '                         '.
038300    05 MEMO-LINE-09.
038400       10 FILLER PIC X(25) VALUE '                         '.
038500       10 FILLER PIC X(25) VALUE '                         '.
038600    05 MEMO-LINE-10.
038700       10 FILLER PIC X(25) VALUE '                         '.
038800       10 FILLER PIC X(25) VALUE '                         '.
038900
039000
039100 01  LS-LOGON-PARMS.
039200     05  LS-ACCESS-LEVEL          PIC  X(02).
039300     05  LS-ACCESS-LEVEL-NAME     PIC  X(36).
039400     05  LS-ACCESS-LEVEL-TITLE    PIC  X(36).
039500     05  LS-ACCESS-LEVEL-INITIALS PIC  X(07).
039600
039700
039800
039900 LINKAGE SECTION.
040000 01 TPS-LOGON-REC.
040100     COPY "TPSLOGON.CPY".
040200
040300 01 LINK-PARM.
040400    05 LINK-PARM-FROM-PROG        PIC  X(08).
040400    05 FILLER REDEFINES LINK-PARM-FROM-PROG.
040400       10 FILLER                  PIC  X(07).
040400       10 LINK-PARM-WHICH-PRINT   PIC  X(01).
040400          88 LINK-PARM-BROADCAST-MONTHLY    VALUE '1'.
040400          88 LINK-PARM-PRINT-MONTHLY        VALUE '2'.
040400          88 LINK-PARM-PRINT-WEEKLY         VALUE '3'.
040500    05 LINK-PARM-TO-PROG          PIC  X(08).
040600    05 LINK-PARM-HOW2OPEN         PIC  X(01).
040700       88 LINK-OPEN-OUTPUT             VALUE '1'.
040800       88 LINK-OPEN-EXTEND             VALUE '2'.
040900    05 FILLER                     PIC  X(103).
041000 
       01 CURRENT-XY-PARAMETERS PIC 9(08).
       01 SCREEN-NAME           PIC x(10).

041100**  05 LINK-PARM-FROM-PROG        PIC  X(08).
041200**  05 LINK-PARM-FROM-DATE-MO     PIC  X(08).
041300**  05 LINK-PARM-TO-DATE-MO       PIC  X(08).
041400**  05 LINK-PARM-FROM-DATE-YR     PIC  X(08).
041500**  05 LINK-PARM-TO-DATE-YR       PIC  X(08).
041600
041700*PROCEDURE DIVISION.
041800 PROCEDURE DIVISION USING TPS-LOGON-REC
                                LINK-PARM
041900                          CURRENT-XY-PARAMETERS.

042000 TPS010-BEGIN.

           INITIALIZE DS-CONTROL-BLOCK.
           INITIALIZE DS-INPUT-FIELDS.
           MOVE CURRENT-XY-PARAMETERS(1:4) TO WS-CURRENT-X
                                              WS-X-PARM.
           MOVE CURRENT-XY-PARAMETERS(5:4) TO WS-CURRENT-Y
                                              WS-Y-PARM.

042100      ACCEPT TODAYS-DATE-YMD FROM DATE.
042200      MOVE 01                   TO WS-DATE-PARAM.
042300      MOVE SPACES               TO WS-DATE-EXTEND.
042400      MOVE TODAYS-DATE-YMD      TO WS-DATE-REFORM.
042500       CALL TPSDATES USING WS-DATE-REQUEST.
042600      MOVE WS-DATE-REFORM-LEN08 TO TODAYS-DATE-CYMD.
042700      PERFORM WHAT-ARE-WE-DOING THRU
042800              WHAT-ARE-WE-DOING-EXIT.
042900
043000      MOVE 03                   TO WS-DATE-PARAM.
043100      MOVE SPACES               TO WS-DATE-EXTEND.
043200      ACCEPT WS-DATE-REFORM FROM DATE.
043300        CALL TPSDATES USING WS-DATE-REQUEST.
043400      MOVE WS-DATE-REFORM-LEN08 TO WL0-DATE.
043500
043600      ACCEPT TIME-OF-DAY   FROM TIME.
043700
043800        MOVE TIME-OF-DAY-HH      TO WL0-TIME(1:2).
043900        MOVE ':'                 TO WL0-TIME(3:1).
044000        MOVE TIME-OF-DAY-MM      TO WL0-TIME(4:2).
044100        MOVE ':'                 TO WL0-TIME(6:1).
044200        MOVE TIME-OF-DAY-SS(1:2) TO WL0-TIME(7:2).
044300
044400      MOVE 'NY'              TO BRNCH-CONTROL-STATE.
044500      MOVE LOGREC-ADMIN-ACCT-BRANCH TO
044600                             BRNCH-CONTROL-OFFICE.
044700      MOVE LOGREC-ADMIN-ACCT-ADMIN  TO
044800                             BRNCH-CONTROL-GROUP.
044900
045000      SET FR-OPEN-I-O TO TRUE.
045100      CALL TPSIO003 USING FILE-REQUEST TPS-BRANCH-REC.
045200
045300      IF FILE-STATUS NOT = '00' AND '05'
045400         MOVE 'BRNCH' TO FILE-NAME
045500         MOVE 'TPS010-OPEN' TO FILE-TEXT
045600         PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
045700         GOBACK GIVING CURRENT-XY-PARAMETERS
045800       END-IF.
045900
046000      SET FR-READ TO TRUE.
046100      CALL TPSIO003 USING FILE-REQUEST TPS-BRANCH-REC.
046200
046300      IF NOT A-SUCCESSFUL-OPERATION
046400         MOVE 'BRNCH' TO FILE-NAME
046500         MOVE 'TPS010-READ' TO FILE-TEXT
046600         PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
046700         GOBACK GIVING CURRENT-XY-PARAMETERS
046800       END-IF.
046900
047000      SET FR-CLOSE TO TRUE.
047100      CALL TPSIO003 USING FILE-REQUEST TPS-BRANCH-REC.
047200
047300      IF NOT A-SUCCESSFUL-OPERATION
047400           MOVE 'BRNCH' TO FILE-NAME
047500           MOVE 'TPS010-CLOSE' TO FILE-TEXT
047600           PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
047700           GOBACK GIVING CURRENT-XY-PARAMETERS
047800       END-IF.
047900
048000      CANCEL TPSIO003.
048100
048200      MOVE ZEROS                TO CLNT-PROFILE-ACCT-NO
048300                                   CLNT-PROFILE-SUB-ACCT.
048400
048500      SET FR-OPEN-I-O TO TRUE.
048600      CALL TPSIO004 USING FILE-REQUEST TPS-PROFL-REC.
048700
048800      IF FILE-STATUS NOT = '00' AND '05'
048900           MOVE 'PROFL' TO FILE-NAME
049000           MOVE 'TPS010-OPEN' TO FILE-TEXT
049100           PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
049200           GOBACK GIVING CURRENT-XY-PARAMETERS
049300       END-IF.
049400
049500*05/17/01                                                                                                         
049500*     IF NOT WERE-BROADCASTING
049600*        MOVE 'O'         TO PROCESS-REPAINT-SCREEN
049700*        CALL SCREENIO USING PROCESS-PANEL
049800*                            PROCESS-PASS-TO-EXIT
049900*                            PROCESS-WORK-S
050000*                            PROCESS-WORK-D
050100*      END-IF.
050200
050300      MOVE ADMIN-FIRST-ACCT-NUM-USED  TO CLNT-PROFILE-ACCT-NO.
050400      MOVE '00'                       TO CLNT-PROFILE-SUB-ACCT.
050500      MOVE '1'                        TO LINK-PARM-HOW2OPEN.
050600*JM10/97 ***** SET UP LINK PARMS FOR CALLING PROGRAMS *****
050700      MOVE ADMIN-FIRST-ACCT-NUM-USED  TO PARM01-ACCOUNT-NUMBER.
050800      MOVE '00'                       TO PARM01-SUB-ACCT.
050900
051000 CLIENT-READ.
051100      SET FR-READ TO TRUE.
051200      CALL TPSIO004 USING FILE-REQUEST TPS-PROFL-REC.
051300*01/14/99
003720      IF NO-RECORD-WAS-FOUND
003740         GO TO NEXT-AVAILABLE-ACCT                                              
003750       END-IF.                                                                   
051300*01/14/99
051400      IF NOT A-SUCCESSFUL-OPERATION
051500         IF CLNT-PROFILE-ACCT-NO < '0101000230'
051600              GO TO NEXT-AVAILABLE-ACCT
051700           ELSE
051800           MOVE 'PROFL' TO FILE-NAME
051900           MOVE 'TPS010-READ' TO FILE-TEXT
052000           PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
052100           GOBACK GIVING CURRENT-XY-PARAMETERS
052200          END-IF
052300        END-IF.
052400
052500      IF CLNT-PROFILE-ADD-DATE(1:1) = '8' OR '9'
052700         GO TO NEXT-AVAILABLE-ACCT
052800       END-IF.
052400
052600      IF CLNT-CALENDAR-RPT = 'N'
052700         GO TO NEXT-AVAILABLE-ACCT
052800       END-IF.
052400
052600      IF CLNT-CALENDAR-RPT-NO
052700         GO TO NEXT-AVAILABLE-ACCT
052800       END-IF.
052900
040400      IF LINK-PARM-BROADCAST-MONTHLY
052600         IF CLNT-CALENDAR-RPT-MONTHLY
053000            GO TO DEPENDENT-LOOP
052800          END-IF
052800       END-IF.
052900
040400      IF LINK-PARM-PRINT-MONTHLY
052600         IF CLNT-CALENDAR-RPT-MONTHLY
053000            GO TO DEPENDENT-LOOP
052800          END-IF
052800       END-IF.
052900
040400      IF LINK-PARM-PRINT-WEEKLY
052600         IF CLNT-CALENDAR-RPT-WEEKLY
053000            GO TO DEPENDENT-LOOP
052800          END-IF
052800       END-IF.
052900
052700      GO TO NEXT-AVAILABLE-ACCT.
052900
052900
053000 DEPENDENT-LOOP.
053100      IF WERE-BROADCASTING
053200         GO TO BROADCAST-TO-DIARY
053300       END-IF.
053400
053400      MOVE '1'                    TO WE-DID-CALENDARS-FLAG.
053400
053500      CALL LINK-PARM-TO-PROG USING TPS-LOGON-REC
053600                                   TPS-PROFL-REC
053700                                   LINK-PARM.
053800      CANCEL LINK-PARM-TO-PROG.
053900
054000
054100      IF NOT PRIVATE-LABELS-PRESENT
054200         GO TO CHECK-FOR-PRIVATE-LABELS
054300        END-IF.
054400
054500       DISPLAY DEL-COMMAND-1 UPON COMMAND-LINE.
054600       CALL X'91' USING RESULT FUNCTION-35 NULL-PARAMETER.
054700
054800*****     following is call for TPS sundial macro download
054900       MOVE '02'                TO LS-WHAT-KIND-OF-OPTION.
055000       MOVE 'LOGO005.PCL '      TO LS-DOWNLOAD-PCL-ID.
055100       MOVE '05'                TO LS-MACRO-ID.
055200       MOVE  FILE-ASSIGNMENT    TO LS-FILE-ASSIGNMENT.
055300       CALL TPSLOGOS USING LS-PARMS.
055400
055500*****     following is call for TPS sundial macro download
055600       MOVE '02'                TO LS-WHAT-KIND-OF-OPTION.
055700       MOVE 'LOGO006.PCL '      TO LS-DOWNLOAD-PCL-ID.
055800       MOVE '06'                TO LS-MACRO-ID.
055900       MOVE  FILE-ASSIGNMENT    TO LS-FILE-ASSIGNMENT.
056000       CALL TPSLOGOS USING LS-PARMS.
056100
056200*****     following is call for creating a .BAT file
056300       MOVE '31'                TO LS-WHAT-KIND-OF-OPTION.
056400       MOVE  FILE-ASSIGNMENT    TO LS-FILE-ASSIGNMENT.
056500       CALL TPSLOGOS USING LS-PARMS.
056600
056700*****     following is call for TPS sundial macro unload
056800       MOVE '22'                TO LS-WHAT-KIND-OF-OPTION.
056900       MOVE '05'                TO LS-MACRO-ID.
057000       MOVE  FILE-ASSIGNMENT    TO LS-FILE-ASSIGNMENT.
057100       CALL TPSLOGOS USING LS-PARMS.
057200
057300*****     following is call for TPS sundial macro unload
057400       MOVE '22'                TO LS-WHAT-KIND-OF-OPTION.
057500       MOVE '06'                TO LS-MACRO-ID.
057600       MOVE  FILE-ASSIGNMENT    TO LS-FILE-ASSIGNMENT.
057700       CALL TPSLOGOS USING LS-PARMS.
057800
057900*****     following is to run .BAT file created above and
058000*****     will download macros, print report and unload macros..
058100       DISPLAY BAT-COMMAND-1 UPON COMMAND-LINE.
058200       CALL X'91' USING RESULT FUNCTION-35 NULL-PARAMETER.
058300       GO TO DOALL-AS-PRIVATE-LABELS.
058400
058500
058600 CHECK-FOR-PRIVATE-LABELS.
058700      MOVE CLNT-PROFILE-ACCT-NO   TO LS-ACCOUNT-NUMBER.
058800      MOVE '99'                   TO LS-WHAT-KIND-OF-OPTION.
058900       CALL TPSLOGOS USING LS-PARMS.
059000      IF LS-ACCOUNT-NUMBER = ZEROS
059100         MOVE '2'                 TO LINK-PARM-HOW2OPEN
059200         GO TO SEE-WHERE-WE-ARE
059300        END-IF.
059400
059500 DOALL-AS-PRIVATE-LABELS.
059600       MOVE '1'                 TO PRIVATE-LABELS-PRESENT-FLAG.
059700       MOVE '1'                 TO LINK-PARM-HOW2OPEN.
059800
059900       DISPLAY DEL-COMMAND-1 UPON COMMAND-LINE.
060000       CALL X'91' USING RESULT FUNCTION-35 NULL-PARAMETER.
060100
060200*****     following is call for TPS sundial macro download
060300       MOVE '02'                TO LS-WHAT-KIND-OF-OPTION.
060400       MOVE 'LOGO005.PCL '      TO LS-DOWNLOAD-PCL-ID.
060500       MOVE '05'                TO LS-MACRO-ID.
060600       MOVE  FILE-ASSIGNMENT    TO LS-FILE-ASSIGNMENT.
060700       CALL TPSLOGOS USING LS-PARMS.
060800
060900*****     following is call for TPS sundial macro download
061000       MOVE '02'                TO LS-WHAT-KIND-OF-OPTION.
061100       MOVE 'LOGO006.PCL '      TO LS-DOWNLOAD-PCL-ID.
061200       MOVE '06'                TO LS-MACRO-ID.
061300       MOVE  FILE-ASSIGNMENT    TO LS-FILE-ASSIGNMENT.
061400       CALL TPSLOGOS USING LS-PARMS.
061500
061600*****     following is call for creating a .BAT file
061700       MOVE '31'                TO LS-WHAT-KIND-OF-OPTION.
061800       MOVE  FILE-ASSIGNMENT    TO LS-FILE-ASSIGNMENT.
061900       CALL TPSLOGOS USING LS-PARMS.
062000
062100*****     following is call for TPS sundial macro unload
062200       MOVE '22'                TO LS-WHAT-KIND-OF-OPTION.
062300       MOVE '05'                TO LS-MACRO-ID.
062400       MOVE  FILE-ASSIGNMENT    TO LS-FILE-ASSIGNMENT.
062500       CALL TPSLOGOS USING LS-PARMS.
062600
062700*****     following is call for TPS sundial macro unload
062800       MOVE '22'                TO LS-WHAT-KIND-OF-OPTION.
062900       MOVE '06'                TO LS-MACRO-ID.
063000       MOVE  FILE-ASSIGNMENT    TO LS-FILE-ASSIGNMENT.
063100       CALL TPSLOGOS USING LS-PARMS.
063200
063300*****     following is to run .BAT file created above and
063400*****     will download macros, print report and unload macros..
063500       DISPLAY BAT-COMMAND-1 UPON COMMAND-LINE.
063600       CALL X'91' USING RESULT FUNCTION-35 NULL-PARAMETER.
063700
063800
063900
064000 SEE-WHERE-WE-ARE.
064100*     ADD 1                           TO CLNT-PROFILE-SUB-ACCT.
064200*     SET FR-READ TO TRUE.
064300*     CALL TPSIO004 USING FILE-REQUEST TPS-PROFL-REC.
064400*
064500*     IF A-SUCCESSFUL-OPERATION
064600*        GO TO DEPENDENT-LOOP.
064700
064800      IF CLNT-PROFILE-ACCT-NO > ADMIN-LAST-ACCT-NUM-USED
064900         GO TO PRINT-ALL-REPORTS
065000       END-IF.
065100
065200 NEXT-AVAILABLE-ACCT.
065300      ADD 10                    TO CLNT-PROFILE-ACCT-NO.
065400      CALL MOD10 USING CLNT-PROFILE-ACCT-NO.
065500      MOVE '00'                 TO CLNT-PROFILE-SUB-ACCT.
065600
065700*ts   IF CLNT-PROFILE-ACCT-NO = '0101000040'
065800*ts      GO TO NEXT-AVAILABLE-ACCT.
065900
066000      IF CLNT-PROFILE-ACCT-NO NOT >
066100                           ADMIN-LAST-ACCT-NUM-USED
066200         GO TO  CLIENT-READ
066300       END-IF.
066400
066500
066600 PRINT-ALL-REPORTS.
066700      IF WERE-BROADCASTING
066800         GO TO PRIVATE-LABELS-DONE
066900       END-IF.
067000
067100*01/31/96 DISPLAY PRT-COMMAND-1 UPON COMMAND-LINE.
067200*01/31/96 CALL X'91' USING RESULT FUNCTION-35 NULL-PARAMETER.
067300
067300
067400      IF PRIVATE-LABELS-PRESENT
067500         GO TO PRIVATE-LABELS-DONE
067600        END-IF.
067700
067700*05/17/01
053400      IF NOT WE-DID-CALENDARS
067900*        MOVE 1           TO NOTHING-DISPLAY-OPTION
067900*        MOVE '  NO CALENDARS PRINTED TODAY, ENTER TO CONTINUE'
067900*                         TO NOTHING-MENU-MSG
067900*        CALL SCREENIO USING NOTHING-PANEL
068000*                            NOTHING-PASS-TO-EXIT
068100*                            NOTHING-WORK-S
068200*                            NOTHING-WORK-D
067500         GO TO PRIVATE-LABELS-DONE
067600        END-IF.
067700
067700
067800*     MOVE 'O'              TO PRINTING-REPAINT-SCREEN.
067900*     CALL SCREENIO USING PRINTING-PANEL
068000*                         PRINTING-PASS-TO-EXIT
068100*                         PRINTING-WORK-S
068200*                         PRINTING-WORK-D.
068300
068400
068500       DISPLAY DEL-COMMAND-1 UPON COMMAND-LINE.
068600       CALL X'91' USING RESULT FUNCTION-35 NULL-PARAMETER.
068700
068800*****     following is call for TPS sundial macro download
068900       MOVE '02'                TO LS-WHAT-KIND-OF-OPTION.
069000       MOVE 'LOGO005.PCL '      TO LS-DOWNLOAD-PCL-ID.
069100       MOVE '05'                TO LS-MACRO-ID.
069200       MOVE  FILE-ASSIGNMENT    TO LS-FILE-ASSIGNMENT.
069300       CALL TPSLOGOS USING LS-PARMS.
069400
069500*****     following is call for TPS sundial macro download
069600       MOVE '02'                TO LS-WHAT-KIND-OF-OPTION.
069700       MOVE 'LOGO006.PCL '      TO LS-DOWNLOAD-PCL-ID.
069800       MOVE '06'                TO LS-MACRO-ID.
069900       MOVE  FILE-ASSIGNMENT    TO LS-FILE-ASSIGNMENT.
070000       CALL TPSLOGOS USING LS-PARMS.
070100
070200*****     following is call for creating a .BAT file
070300       MOVE '31'                TO LS-WHAT-KIND-OF-OPTION.
070400       MOVE  FILE-ASSIGNMENT    TO LS-FILE-ASSIGNMENT.
070500       CALL TPSLOGOS USING LS-PARMS.
070600
070700*****     following is call for TPS sundial macro unload
070800       MOVE '22'                TO LS-WHAT-KIND-OF-OPTION.
070900       MOVE '05'                TO LS-MACRO-ID.
071000       MOVE  FILE-ASSIGNMENT    TO LS-FILE-ASSIGNMENT.
071100       CALL TPSLOGOS USING LS-PARMS.
071200
071300*****     following is call for TPS sundial macro unload
071400       MOVE '22'                TO LS-WHAT-KIND-OF-OPTION.
071500       MOVE '06'                TO LS-MACRO-ID.
071600       MOVE  FILE-ASSIGNMENT    TO LS-FILE-ASSIGNMENT.
071700       CALL TPSLOGOS USING LS-PARMS.
071800
071900
072000*****     following is to run .BAT file created above and
072100*****     will download macros, print report and unload macros..
072200       DISPLAY BAT-COMMAND-1 UPON COMMAND-LINE.
072300       CALL X'91' USING RESULT FUNCTION-35 NULL-PARAMETER.
072400
072500
072600 PRIVATE-LABELS-DONE.
072700      PERFORM UPDATE-CONTROL-RECORD THRU
072800              UPDATE-CONTROL-RECORD-EXIT.
072900
073000      IF WERE-BROADCASTING
073100         GO TO SKIP-MISSING-MAIL-CALL
073200       END-IF.
072900
040400      IF LINK-PARM-PRINT-MONTHLY
073100         GO TO SKIP-MISSING-MAIL-CALL
073200       END-IF.
072900
072900*03/10/98 FOR TESTING CALENDAR, SKIP CALL TO TPS1010M..........
073000*     IF LOGREC-SIGN-ON = 'NYTHSCA   '
073100*        GO TO SKIP-MISSING-MAIL-CALL
073200*      END-IF.
072900*03/10/98
073300
073400*05/17/01 DISPLAY PRT-COMMAND-2 UPON COMMAND-LINE.                                                                
073500*05/17/01 CALL X'91' USING RESULT FUNCTION-35 NULL-PARAMETER.                                                     
073600
073700
073800
073900*   MOVE F-PRIME TO FILE-KEY.
074000*   MOVE F-CLOSE TO FILE-ACTION.
074100*   CALL TPSIOREC USING FILE-REQUEST TPS-MAIL-REC.
074200**  IF NOT A-SUCCESSFUL-OPERATION
074300*      MOVE ' RECEIVE ' TO FILE-NAME
074400*      MOVE 'TPS010.CLOS' TO FILE-TEXT
074500*      PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
074600****************************************************************
074700* PRINT RECURRING FILE CONTROL LOG (MISSING MAIL)              *
074800****************************************************************
074900*   MOVE 1                     TO PARM10.
075000*   CALL TPS1010M USING TPS-LOGON-REC TPS-PROFL-REC LINK-PARMS.
075100*   CANCEL TPS1010M.
075200
075300 SKIP-MISSING-MAIL-CALL.
075400    CANCEL TPSIOREC.
075500
075600
075700 EXIT-THE-MODULE.
075800****  PERFORM CLOSE-THE-FILES THRU
075900****          CLOSE-THE-FILES-EXIT.

           INITIALIZE CURRENT-XY-PARAMETERS.
           MOVE WS-CURRENT-X TO CURRENT-XY-PARAMETERS(1:4).
           MOVE WS-CURRENT-Y TO CURRENT-XY-PARAMETERS(5:4).

076000      GOBACK GIVING CURRENT-XY-PARAMETERS.
076100
076200
076300 FILE-ERROR.
076400     CALL TPSIOERR USING FILE-REQUEST
                               WS-CURRENT-XY-PARM.
076500     CANCEL TPSIOERR.

            MOVE WS-CURRENT-XY-PARM(1:4) TO WS-CURRENT-X.
            MOVE WS-CURRENT-XY-PARM(5:4) TO WS-CURRENT-Y.

           INITIALIZE CURRENT-XY-PARAMETERS.
           MOVE WS-CURRENT-X TO CURRENT-XY-PARAMETERS(1:4).
           MOVE WS-CURRENT-Y TO CURRENT-XY-PARAMETERS(5:4).
076600 FILE-ERROR-EXIT. EXIT.
076700
076800*OPEN-THE-FILES.
076900*   OPEN OUTPUT PRT-FILE.
077000*   OPEN OUTPUT PRT-SORT.
077100*   MOVE F-PRIME      TO FILE-KEY.
077200*   MOVE F-OPEN-I-O   TO FILE-ACTION.
077300*   CALL TPSIO018 USING FILE-REQUEST TPS-CAL-REC.
077400*   IF FILE-STATUS NOT = '00'
077500*      MOVE ' CALENDAR' TO FILE-NAME
077600*      MOVE 'TPS4500-001' TO FILE-TEXT
077700*      PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
077800*      GO TO EXIT-THE-MODULE.
077900*OPEN-THE-FILES-EXIT. EXIT.
078000
078100*CLOSE-THE-FILES.
078200*   CLOSE PRT-FILE.
078300*   CLOSE PRT-SORT.
078400*   MOVE F-PRIME TO FILE-KEY.
078500*   MOVE F-CLOSE TO FILE-ACTION.
078600*   CALL TPSIO018 USING FILE-REQUEST TPS-CAL-REC.
078700*   IF NOT A-SUCCESSFUL-OPERATION
078800*      MOVE ' CALENDAR' TO FILE-NAME
078900*      MOVE 'TPS4500-002' TO FILE-TEXT
079000*      PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
079100*   END-IF.
079200*   PERFORM VARYING THE-INDEX FROM 2 BY 1
079300*           UNTIL  PROGRAM-NAME (THE-INDEX) = HIGH-VALUES
079400*           CANCEL PROGRAM-NAME (THE-INDEX)
079500*   END-PERFORM.
079600*CLOSE-THE-FILES-EXIT. EXIT.
079700
079800
079900
080000
080100 UPDATE-CONTROL-RECORD.
080200      MOVE ZEROS                    TO CAL-KEY-ACCT-NO
080300                                       CAL-KEY-SUB-ACCT
080400                                       CAL-KEY-DATE
080500                                       CAL-KEY-RECORD-NUMBER
080600                                       CAL-KEY-SUB-RECORD-NUMBER.
080700      MOVE LOGREC-ADMIN-ACCT-BRANCH TO CAL-KEY-ACCT-NO(1:2).
080800      MOVE LOGREC-ADMIN-ACCT-ADMIN  TO CAL-KEY-ACCT-NO(3:2).
080900
081000    MOVE F-PRIME TO FILE-KEY.
081100    MOVE F-OPEN-I-O TO FILE-ACTION.
081200    CALL TPSIO018 USING FILE-REQUEST TPS-CAL-REC.
081300    IF NOT A-SUCCESSFUL-OPERATION
081400       MOVE ' CALENDAR' TO FILE-NAME
081500       MOVE 'OPEN-I-O   ' TO FILE-TEXT
081600       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
081700       GO TO EXIT-THE-MODULE
081800     END-IF.
081900
082000      PERFORM CALENDAR-ACTUAL-READ THRU
082100              CALENDAR-ACTUAL-READ-EXIT.
082200
082300
082400*************************************************************
082500
082600      IF WERE-BROADCASTING
098800         GO TO CLOSE-THE-CALENDAR
082800       END-IF.
082900
040400      IF LINK-PARM-PRINT-MONTHLY
098800         GO TO CLOSE-THE-CALENDAR
082800       END-IF.
083000
083100      MOVE 03                       TO WS-DATE-PARAM.
083200      MOVE SPACES                   TO WS-DATE-EXTEND.
083300      MOVE CAL-ADM-PRINT-YRLY-FROM-CYMD(3:6)
083400                                    TO WS-DATE-REFORM(1:6).
083500         CALL TPSDATES USING WS-DATE-REQUEST.
083600      MOVE WS-DATE-REFORM-LEN08 TO
083700                                OLD-PRINT-YRLY-FROM.
083800
083900      MOVE 03                       TO WS-DATE-PARAM.
084000      MOVE SPACES                   TO WS-DATE-EXTEND.
084100      MOVE CAL-ADM-PRINT-YRLY-TO-CYMD(3:6)
084200                                    TO WS-DATE-REFORM(1:6).
084300         CALL TPSDATES USING WS-DATE-REQUEST.
084400      MOVE WS-DATE-REFORM-LEN08 TO
084500                                OLD-PRINT-YRLY-TO.
084600
084700      MOVE 03                       TO WS-DATE-PARAM.
084800      MOVE SPACES                   TO WS-DATE-EXTEND.
084900      MOVE CAL-ADM-PRINT-MNTH-DATE-CYMD(3:6)
085000                                    TO WS-DATE-REFORM(1:6).
085100         CALL TPSDATES USING WS-DATE-REQUEST.
085200      MOVE WS-DATE-REFORM-LEN08 TO
085300                                OLD-PRINT-MNTH-DATE.
085400
085500      MOVE 03                       TO WS-DATE-PARAM.
085600      MOVE SPACES                   TO WS-DATE-EXTEND.
085700      MOVE CAL-ADM-PRINT-MNTH-FROM-CYMD(3:6)
085800                                    TO WS-DATE-REFORM(1:6).
085900         CALL TPSDATES USING WS-DATE-REQUEST.
086000      MOVE WS-DATE-REFORM-LEN08 TO
086100                                OLD-PRINT-MNTH-FROM.
086200
086300      MOVE 03                       TO WS-DATE-PARAM.
086400      MOVE SPACES                   TO WS-DATE-EXTEND.
086500      MOVE CAL-ADM-PRINT-MNTH-TO-CYMD(3:6)
086600                                    TO WS-DATE-REFORM(1:6).
086700         CALL TPSDATES USING WS-DATE-REQUEST.
086800      MOVE WS-DATE-REFORM-LEN08 TO
086900                                OLD-PRINT-MNTH-TO.
087000
087100      MOVE 03                       TO WS-DATE-PARAM.
087200      MOVE SPACES                   TO WS-DATE-EXTEND.
087300      MOVE CAL-ADM-APPNT-WKLY-FROM-CYMD(3:6)
087400                                    TO WS-DATE-REFORM(1:6).
087500         CALL TPSDATES USING WS-DATE-REQUEST.
087600      MOVE WS-DATE-REFORM-LEN08 TO
087700                                OLD-APPNT-WKLY-FROM.
087800
087900      MOVE 03                       TO WS-DATE-PARAM.
088000      MOVE SPACES                   TO WS-DATE-EXTEND.
088100      MOVE CAL-ADM-APPNT-WKLY-TO-CYMD(3:6)
088200                                    TO WS-DATE-REFORM(1:6).
088300         CALL TPSDATES USING WS-DATE-REQUEST.
088400      MOVE WS-DATE-REFORM-LEN08 TO
088500                                OLD-APPNT-WKLY-TO.
088600
088700*************************************************************
088800
088900
089000      MOVE 21                       TO WS-DATE-PARAM.
089100      MOVE SPACES                   TO WS-DATE-EXTEND.
089200      MOVE CAL-ADM-PRINT-MNTH-DATE-CYMD
089300                                    TO WS-DATE-REFORM(1:8).
089400      MOVE '007'                    TO WS-DATE-REFORM(9:3).
089500         CALL TPSDATES USING WS-DATE-REQUEST.
089600      MOVE WS-DATE-REFORM-LEN08 TO CAL-ADM-PRINT-MNTH-DATE-CYMD.
089700
089800      MOVE 21                       TO WS-DATE-PARAM.
089900      MOVE SPACES                   TO WS-DATE-EXTEND.
090000      MOVE CAL-ADM-APPNT-WKLY-FROM-CYMD
090100                                    TO WS-DATE-REFORM(1:8).
090200      MOVE '007'                    TO WS-DATE-REFORM(9:3).
090300         CALL TPSDATES USING WS-DATE-REQUEST.
090400      MOVE WS-DATE-REFORM-LEN08 TO CAL-ADM-APPNT-WKLY-FROM-CYMD.
090500
090600      MOVE 21                       TO WS-DATE-PARAM.
090700      MOVE SPACES                   TO WS-DATE-EXTEND.
090800      MOVE CAL-ADM-APPNT-WKLY-TO-CYMD
090900                                    TO WS-DATE-REFORM(1:8).
091000      MOVE '007'                    TO WS-DATE-REFORM(9:3).
091100         CALL TPSDATES USING WS-DATE-REQUEST.
091200      MOVE WS-DATE-REFORM-LEN08 TO CAL-ADM-APPNT-WKLY-TO-CYMD.
091300
091400****  IF CAL-ADM-APPNT-WKLY-TO-CYMD NOT >
091500      IF CAL-ADM-APPNT-WKLY-FROM-CYMD NOT >
091600                               CAL-ADM-PRINT-MNTH-TO-CYMD
091700*****         GO TO SEEIF-YEARLY-OPTION-ACTIVE
091800         GO TO REWRITE-THE-CONTROL
091900       END-IF.
092000
092100      ADD 1                TO CAL-ADM-PRINT-MNTH-FROM-MM.
092200      IF  CAL-ADM-PRINT-MNTH-FROM-MM > 12
092300          ADD 1            TO CAL-ADM-PRINT-MNTH-FROM-CY
092400          SUBTRACT 12    FROM CAL-ADM-PRINT-MNTH-FROM-MM
092500       END-IF.
092600
092700      MOVE 24                       TO WS-DATE-PARAM.
092800      MOVE SPACES                   TO WS-DATE-EXTEND.
092900      MOVE CAL-ADM-PRINT-MNTH-FROM-CYMD
093000                                    TO WS-DATE-REFORM(1:8).
093100         CALL TPSDATES USING WS-DATE-REQUEST.
093200      MOVE WS-DATE-REFORM-LEN08 TO CAL-ADM-PRINT-MNTH-TO-CYMD.
093300
093400
093500 SEEIF-YEARLY-OPTION-ACTIVE.
093600***** IF NOT YEARLY-PRINT      GO TO REWRITE-THE-CONTROL.
093700
093800      ADD 1                TO CAL-ADM-PRINT-YRLY-FROM-MM.
093900      IF  CAL-ADM-PRINT-YRLY-FROM-MM > 12
094000          ADD 1            TO CAL-ADM-PRINT-YRLY-FROM-CY
094100          SUBTRACT 12    FROM CAL-ADM-PRINT-YRLY-FROM-MM
094200       END-IF.
094300
094400      ADD 1                TO CAL-ADM-PRINT-YRLY-TO-MM.
094500      IF  CAL-ADM-PRINT-YRLY-TO-MM > 12
094600          ADD 1            TO CAL-ADM-PRINT-YRLY-TO-CY
094700          SUBTRACT 12    FROM CAL-ADM-PRINT-YRLY-TO-MM
094800       END-IF.
094900
095000      MOVE 24                       TO WS-DATE-PARAM.
095100      MOVE SPACES                   TO WS-DATE-EXTEND.
095200      MOVE CAL-ADM-PRINT-YRLY-TO-CYMD TO WS-DATE-REFORM(1:8).
095300         CALL TPSDATES USING WS-DATE-REQUEST.
095400      MOVE WS-DATE-REFORM-LEN08 TO CAL-ADM-PRINT-YRLY-TO-CYMD.
095500
095600      MOVE 24                       TO WS-DATE-PARAM.
095700      MOVE SPACES                   TO WS-DATE-EXTEND.
095800      MOVE CAL-ADM-PRINT-YRLY-FROM-CYMD
095900                                    TO WS-DATE-REFORM(1:8).
096000      CALL TPSDATES USING WS-DATE-REQUEST.
096100      MOVE WS-DATE-REFORM-LEN08 TO WORK-DATE-CYMD.
096200
096300      PERFORM LOOK-FOR-A-SUNDAY-MINUS THRU
096400              LOOK-FOR-A-SUNDAY-MINUS-EXIT.
096500      MOVE SUNDAY-CYMD          TO CAL-ADM-PRINT-YRLY-DATE-CYMD.
096600      GO TO REWRITE-THE-CONTROL.
096700
096800
097400
097500
097600
097700 REWRITE-THE-CONTROL.
097800      SET FR-REWRITE TO TRUE
097900      CALL TPSIO018 USING FILE-REQUEST TPS-CAL-REC
098000      IF NOT A-SUCCESSFUL-OPERATION
098100         MOVE 'CALEN' TO FILE-NAME
098200         MOVE 'TPS000-WRITE' TO FILE-TEXT
098300         PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
098400         GO TO EXIT-THE-MODULE
098500       END-IF.
098600
099100*************************************************************
099200
099300      MOVE 03                       TO WS-DATE-PARAM.
099400      MOVE SPACES                   TO WS-DATE-EXTEND.
099500      MOVE CAL-ADM-PRINT-YRLY-FROM-CYMD(3:6)
099600                                    TO WS-DATE-REFORM(1:6).
099700         CALL TPSDATES USING WS-DATE-REQUEST.
099800      MOVE WS-DATE-REFORM-LEN08 TO
099900                                NEW-PRINT-YRLY-FROM.
100000
100100      MOVE 03                       TO WS-DATE-PARAM.
100200      MOVE SPACES                   TO WS-DATE-EXTEND.
100300      MOVE CAL-ADM-PRINT-YRLY-TO-CYMD(3:6)
100400                                    TO WS-DATE-REFORM(1:6).
100500         CALL TPSDATES USING WS-DATE-REQUEST.
100600      MOVE WS-DATE-REFORM-LEN08 TO
100700                                NEW-PRINT-YRLY-TO.
100800
100900      MOVE 03                       TO WS-DATE-PARAM.
101000      MOVE SPACES                   TO WS-DATE-EXTEND.
101100      MOVE CAL-ADM-PRINT-MNTH-DATE-CYMD(3:6)
101200                                    TO WS-DATE-REFORM(1:6).
101300         CALL TPSDATES USING WS-DATE-REQUEST.
101400      MOVE WS-DATE-REFORM-LEN08 TO
101500                                NEW-PRINT-MNTH-DATE.
101600
101700      MOVE 03                       TO WS-DATE-PARAM.
101800      MOVE SPACES                   TO WS-DATE-EXTEND.
101900      MOVE CAL-ADM-PRINT-MNTH-FROM-CYMD(3:6)
102000                                    TO WS-DATE-REFORM(1:6).
102100         CALL TPSDATES USING WS-DATE-REQUEST.
102200      MOVE WS-DATE-REFORM-LEN08 TO
102300                                NEW-PRINT-MNTH-FROM.
102400
102500      MOVE 03                       TO WS-DATE-PARAM.
102600      MOVE SPACES                   TO WS-DATE-EXTEND.
102700      MOVE CAL-ADM-PRINT-MNTH-TO-CYMD(3:6)
102800                                    TO WS-DATE-REFORM(1:6).
102900         CALL TPSDATES USING WS-DATE-REQUEST.
103000      MOVE WS-DATE-REFORM-LEN08 TO
103100                                NEW-PRINT-MNTH-TO.
103200
103300      MOVE 03                       TO WS-DATE-PARAM.
103400      MOVE SPACES                   TO WS-DATE-EXTEND.
103500      MOVE CAL-ADM-APPNT-WKLY-FROM-CYMD(3:6)
103600                                    TO WS-DATE-REFORM(1:6).
103700         CALL TPSDATES USING WS-DATE-REQUEST.
103800      MOVE WS-DATE-REFORM-LEN08 TO
103900                                NEW-APPNT-WKLY-FROM.
104000
104100      MOVE 03                       TO WS-DATE-PARAM.
104200      MOVE SPACES                   TO WS-DATE-EXTEND.
104300      MOVE CAL-ADM-APPNT-WKLY-TO-CYMD(3:6)
104400                                    TO WS-DATE-REFORM(1:6).
104500         CALL TPSDATES USING WS-DATE-REQUEST.
104600      MOVE WS-DATE-REFORM-LEN08 TO
104700                                NEW-APPNT-WKLY-TO.
104800
104900*************************************************************
105000
105100      OPEN OUTPUT PRT-FILE.
105200
105300      WRITE PRT-RECORD    FROM PCL-RESET
105400                               AFTER ADVANCING 0 LINES.
105500
105600      MOVE SPACES           TO FULL-LINE-PRINT.
105700      MOVE CR1              TO FULL-LINE-PRINT.
105800      WRITE PRT-RECORD    FROM FULL-LINE-PRINT
105900                               AFTER ADVANCING 1 LINES.
106000
106100      MOVE SPACES           TO FULL-LINE-PRINT.
106200      MOVE CR2              TO FULL-LINE-PRINT.
106300      WRITE PRT-RECORD    FROM FULL-LINE-PRINT
106400                               AFTER ADVANCING 1 LINES.
106500
106600      MOVE SPACES           TO FULL-LINE-PRINT.
106700      MOVE WL0              TO FULL-LINE-PRINT.
106800      WRITE PRT-RECORD    FROM FULL-LINE-PRINT
106900                               AFTER ADVANCING 4 LINES.
107000
107100      MOVE SPACES           TO FULL-LINE-PRINT.
107200      MOVE WL1              TO FULL-LINE-PRINT.
107300      WRITE PRT-RECORD    FROM FULL-LINE-PRINT
107400                               AFTER ADVANCING 4 LINES.
107500
107600      MOVE SPACES           TO FULL-LINE-PRINT.
107700      MOVE WL2              TO FULL-LINE-PRINT.
107800      WRITE PRT-RECORD    FROM FULL-LINE-PRINT
107900                               AFTER ADVANCING 4 LINES.
108000
108100      MOVE SPACES           TO FULL-LINE-PRINT.
108200      MOVE WL3              TO FULL-LINE-PRINT.
108300      WRITE PRT-RECORD    FROM FULL-LINE-PRINT
108400                               AFTER ADVANCING 2 LINES.
108500
108600      MOVE SPACES           TO FULL-LINE-PRINT.
108700      MOVE WL4              TO FULL-LINE-PRINT.
108800      WRITE PRT-RECORD    FROM FULL-LINE-PRINT
108900                               AFTER ADVANCING 2 LINES.
109000
109100      MOVE SPACES           TO FULL-LINE-PRINT.
109200      MOVE WL5              TO FULL-LINE-PRINT.
109300      WRITE PRT-RECORD    FROM FULL-LINE-PRINT
109400                               AFTER ADVANCING 2 LINES.
109500
109600      MOVE SPACES           TO FULL-LINE-PRINT.
109700      MOVE DL0              TO FULL-LINE-PRINT.
109800      WRITE PRT-RECORD    FROM FULL-LINE-PRINT
109900                               AFTER ADVANCING 4 LINES.
110000
110100      MOVE SPACES           TO FULL-LINE-PRINT.
110200      MOVE DL1              TO FULL-LINE-PRINT.
110300      WRITE PRT-RECORD    FROM FULL-LINE-PRINT
110400                               AFTER ADVANCING 2 LINES.
110500
110600      MOVE SPACES           TO FULL-LINE-PRINT.
110700      MOVE DL2              TO FULL-LINE-PRINT.
110800      WRITE PRT-RECORD    FROM FULL-LINE-PRINT
110900                               AFTER ADVANCING 4 LINES.
111000
111100      MOVE SPACES           TO FULL-LINE-PRINT.
111200      MOVE DL3              TO FULL-LINE-PRINT.
111300      WRITE PRT-RECORD    FROM FULL-LINE-PRINT
111400                               AFTER ADVANCING 2 LINES.
111500
111600      MOVE SPACES           TO FULL-LINE-PRINT.
111700      MOVE DL4              TO FULL-LINE-PRINT.
111800      WRITE PRT-RECORD    FROM FULL-LINE-PRINT
111900                               AFTER ADVANCING 4 LINES.
112000
112100      MOVE SPACES           TO FULL-LINE-PRINT.
112200      MOVE DL5              TO FULL-LINE-PRINT.
112300      WRITE PRT-RECORD    FROM FULL-LINE-PRINT
112400                               AFTER ADVANCING 2 LINES.
112500
112600      MOVE SPACES           TO FULL-LINE-PRINT.
112700      MOVE DL6              TO FULL-LINE-PRINT.
112800      WRITE PRT-RECORD    FROM FULL-LINE-PRINT
112900                               AFTER ADVANCING 4 LINES.
113000
113100      MOVE SPACES           TO FULL-LINE-PRINT.
113200      MOVE DL7              TO FULL-LINE-PRINT.
113300      WRITE PRT-RECORD    FROM FULL-LINE-PRINT
113400                               AFTER ADVANCING 2 LINES.
113500
113600      MOVE SPACES           TO FULL-LINE-PRINT.
113700      MOVE WL9              TO FULL-LINE-PRINT.
113800      WRITE PRT-RECORD    FROM FULL-LINE-PRINT
113900                               AFTER ADVANCING 4 LINES.
114000
114100      WRITE PRT-RECORD    FROM PCL-EJECT-PAGE
114200                               AFTER ADVANCING 0 LINES.
114300
114400      CLOSE PRT-FILE.
114500
114600 CLOSE-THE-CALENDAR.
114700    MOVE F-PRIME TO FILE-KEY.
114800    MOVE F-CLOSE TO FILE-ACTION.
114900    CALL TPSIO018 USING FILE-REQUEST TPS-CAL-REC.
115000    IF NOT A-SUCCESSFUL-OPERATION
115100       MOVE ' CALENDAR' TO FILE-NAME
115200       MOVE 'TPS010.CLOS' TO FILE-TEXT
115300       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
115400    END-IF.
115500
115600 UPDATE-CONTROL-RECORD-EXIT. EXIT.
115700
115800
115900
116000 WHAT-ARE-WE-DOING.
116100      MOVE ZEROS                    TO CAL-KEY-ACCT-NO
116200                                       CAL-KEY-SUB-ACCT
116300                                       CAL-KEY-DATE
116400                                       CAL-KEY-RECORD-NUMBER
116500                                       CAL-KEY-SUB-RECORD-NUMBER.
116600      MOVE LOGREC-ADMIN-ACCT-BRANCH TO CAL-KEY-ACCT-NO(1:2).
116700      MOVE LOGREC-ADMIN-ACCT-ADMIN  TO CAL-KEY-ACCT-NO(3:2).
116800
116900    MOVE F-PRIME      TO FILE-KEY.
117000    MOVE F-OPEN-I-O TO FILE-ACTION.
117100    CALL TPSIO018 USING FILE-REQUEST TPS-CAL-REC.
117200    IF NOT A-SUCCESSFUL-OPERATION
117300       MOVE ' CALENDAR' TO FILE-NAME
117400       MOVE 'OPEN-INPUT ' TO FILE-TEXT
117500       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
117600       GO TO EXIT-THE-MODULE
117700     END-IF.
117800
117900      PERFORM CALENDAR-ACTUAL-READ THRU
118000              CALENDAR-ACTUAL-READ-EXIT.
118100
040400      IF LINK-PARM-BROADCAST-MONTHLY
118300         MOVE '1'                TO WERE-BROADCASTING-FLAG
118400        ELSE
118500         MOVE '0'                TO WERE-BROADCASTING-FLAG
118600         GO TO WHAT-ARE-WE-DOING-EXIT
118700       END-IF.
118800
118800      INSPECT CAL-ADM-PRINT-CAL-MONTHLY-ON
118800              REPLACING ALL X'20' BY X'30'.
118800      INSPECT CAL-ADM-PRINT-CAL-MONTHLY-ON
118800              REPLACING ALL X'00' BY X'30'.
118800      IF CAL-ADM-PRINT-CAL-MONTHLY-ON = ZEROS
118800         MOVE '19980326'        TO CAL-ADM-PRINT-CAL-MONTHLY-ON
118800       END-IF.
118800
118800
118800
118900      MOVE 03                   TO WS-DATE-PARAM.
119000      MOVE SPACES               TO WS-DATE-EXTEND.
118800      MOVE CAL-ADM-PRINT-CAL-MONTHLY-ON(3:6)
119200                                TO WS-DATE-REFORM.
119300      CALL TPSDATES USING WS-DATE-REQUEST.
119400      MOVE WS-DATE-REFORM-LEN08 TO MEMO-LINE-02-DATE
119500
119600      MOVE 22                   TO WS-DATE-PARAM.
119700      MOVE SPACES               TO WS-DATE-EXTEND.
118800      MOVE CAL-ADM-PRINT-CAL-MONTHLY-ON
119900                                TO WS-DATE-REFORM-LEN08.
120000      MOVE '001'                TO WS-DATE-REFORM(9:3).
120100      CALL TPSDATES USING WS-DATE-REQUEST.
120200      MOVE WS-DATE-REFORM-LEN08 TO MEMO-LINE-03-DATE
120300
120400      MOVE 03                   TO WS-DATE-PARAM.
120500      MOVE SPACES               TO WS-DATE-EXTEND.
120600      MOVE MEMO-LINE-03-DATE(3:6)
120700                                TO WS-DATE-REFORM.
120800      CALL TPSDATES USING WS-DATE-REQUEST.
120900      MOVE WS-DATE-REFORM-LEN08 TO MEMO-LINE-03-DATE.
121000
121100      MOVE '04'                 TO LS-ACCESS-LEVEL.
121200      MOVE SPACES               TO LS-ACCESS-LEVEL-NAME
121300                                   LS-ACCESS-LEVEL-TITLE
121400                                   LS-ACCESS-LEVEL-INITIALS.
121500      CALL PASIGN USING TPS-PROFL-REC
                              LS-LOGON-PARMS
                              WS-CURRENT-XY-PARM.
121600      CANCEL PASIGN.

            MOVE WS-CURRENT-XY-PARM(1:4) TO WS-CURRENT-X.
            MOVE WS-CURRENT-XY-PARM(5:4) TO WS-CURRENT-Y.

121500*JM10/00 CALL TPSSIGN USING TPS-LOGON-REC LS-LOGON-PARMS.
121600****     CANCEL TPSSIGN.
121700
121800      MOVE LS-ACCESS-LEVEL-NAME TO MEMO-LINE-06.
121900      MOVE LS-ACCESS-LEVEL-TITLE TO MEMO-LINE-07.
122100 WHAT-ARE-WE-DOING-EXIT. EXIT.
122200
122300
122400
122500
122600 LOOK-FOR-A-SUNDAY-PLUS.
122700      MOVE 23                       TO WS-DATE-PARAM.
122800      MOVE SPACES                   TO WS-DATE-EXTEND.
122900      MOVE WORK-DATE-CYMD           TO WS-DATE-REFORM(1:8).
123000      CALL TPSDATES USING WS-DATE-REQUEST.
123100
123200      MOVE WS-DATE-REFORM-LEN08 TO SUNDAY-CYMD.
123300      IF WS-DATE-REFORM-LEN08(9:1) NOT = '0'
123400         MOVE 21                TO WS-DATE-PARAM
123500         MOVE '001'             TO WS-DATE-REFORM-LEN08(9:3)
123600         CALL TPSDATES USING WS-DATE-REQUEST
123700         MOVE WS-DATE-REFORM-LEN08 TO WORK-DATE-CYMD
123800         GO TO LOOK-FOR-A-SUNDAY-PLUS
123900      END-IF.
124000 LOOK-FOR-A-SUNDAY-PLUS-EXIT. EXIT.
124100
124200 LOOK-FOR-A-SUNDAY-MINUS.
124300      MOVE 23                       TO WS-DATE-PARAM.
124400      MOVE SPACES                   TO WS-DATE-EXTEND.
124500      MOVE WORK-DATE-CYMD           TO WS-DATE-REFORM(1:8).
124600      CALL TPSDATES USING WS-DATE-REQUEST.
124700
124800      MOVE WS-DATE-REFORM-LEN08 TO SUNDAY-CYMD.
124900      IF WS-DATE-REFORM-LEN08(9:1) NOT = '0'
125000         MOVE 22                TO WS-DATE-PARAM
125100         MOVE '001'             TO WS-DATE-REFORM-LEN08(9:3)
125200         CALL TPSDATES USING WS-DATE-REQUEST
125300         MOVE WS-DATE-REFORM-LEN08 TO WORK-DATE-CYMD
125400         GO TO LOOK-FOR-A-SUNDAY-MINUS
125500      END-IF.
125600 LOOK-FOR-A-SUNDAY-MINUS-EXIT. EXIT.
125700
125800
125900
126000
126100 CALENDAR-ACTUAL-READ.
126200    MOVE F-PRIME TO FILE-KEY.
126300    MOVE F-READ      TO FILE-ACTION.
126400    CALL TPSIO018 USING FILE-REQUEST TPS-CAL-REC.
126500    IF NOT A-SUCCESSFUL-OPERATION
126600       MOVE ZEROS      TO CAL-KEY-ACCT-NO
126700       GO TO CALENDAR-ACTUAL-READ-EXIT
126800     END-IF.
126900 CALENDAR-ACTUAL-READ-EXIT. EXIT.
127000
127100
127200 CALENDAR-ACTUAL-DELETE.
127300    MOVE F-PRIME TO FILE-KEY.
127400    MOVE F-DELET    TO FILE-ACTION.
127500    CALL TPSIO018 USING FILE-REQUEST TPS-CAL-REC.
127600    IF NOT A-SUCCESSFUL-OPERATION
127700       MOVE ' CALENDAR' TO FILE-NAME
127800       MOVE 'DELETE     ' TO FILE-TEXT
127900       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
128000    END-IF.
128100 CALENDAR-ACTUAL-DELETE-EXIT. EXIT.
128200
128300
128400*02/16/98------------------------------------------------------
128500 BROADCAST-TO-DIARY.
128600       MOVE SPACES         TO MAIL-PASS-WORD
128700                              MAIL-TYPE-ACCT
128800                              MAIL-CARRIER-CODE
128900                              MAIL-ADDRESOR-NAME
129000                              MAIL-ADDRESOR-ADDRL1
129100                              MAIL-ADDRESOR-ADDRL2
129200                              MAIL-ADDRESOR-CITYSTAT
129300                              MAIL-ADDRESEE-NAME
129400                              MAIL-ADDRESEE-ADDRL1
129500                              MAIL-ADDRESEE-ADDRL2
129600                              MAIL-ADDRESEE-CITYSTAT
129700                              MAIL-ADMIN-XXXXXX
129800                              MAIL-MEMO-ATTACHED
129900                              MAIL-DISPOSITION
130000                              MAIL-CATEGORY-CODE
130100                              MAIL-ROOM-TO-EXPAND
130200                              RECUR-ADDRESOR-NAME
130300                              RECUR-PASS-WORD
130400                              RECUR-TYPE-ACCT
130500                              RECUR-ADDRESOR-ADDRL1
130600                              RECUR-ADDRESOR-ADDRL2
130700                              RECUR-ADDRESOR-CITYSTAT
130800                              RECUR-ADDRESEE-NAME
130900                              RECUR-ADDRESEE-ADDRL1
131000                              RECUR-ADDRESEE-ADDRL2
131100                              RECUR-ADDRESEE-CITYSTAT
131200                              RECUR-PAYEE-NAME
131300                              RECUR-PAYEE-ADDRL1
131400                              RECUR-PAYEE-ADDRL2
131500                              RECUR-PAYEE-CITYSTAT
131600                              RECUR-PAYEE-ACCOUNT-NUMBER
131700                              RECUR-PAYEE-MEMO-FIELD
131800                              RECUR-INVOICE-CATEGORY
131900                              RECUR-CARRIER-CODE
132000                              RECUR-POSTAGE-CLASS
132100                              RECUR-CONTAINR-SIZE
132200                              RECUR-DISPOSITION
132300                              RECUR-CATEGORY-CODE
132400                              RECUR-SEND-BILL-STUB.
132500        MOVE ZEROS         TO MAIL-RECEIVE-DATE
132600                              MAIL-RECEIVE-NUMBER
132700                              MAIL-ADDRESOR-ZIPCODE
132800                              MAIL-ADDRESEE-ZIPCODE
132900                              MAIL-POSTMARK-DATE
133000                              MAIL-POSTAGE-CLASS
133100                              MAIL-POSTAGE-AMOUNT
133200                              MAIL-CONTAINR-SIZE
133300                              MAIL-ADMIN-PROCESS-DATE
133400                              MAIL-NUMBER-ENCLOSED
133500                              MAIL-ENCLOSED-DESCRIPT
133600                              MAIL-DOCUMENT-DISPOS-ITION
133700                              MAIL-NUMBER-ENCLOSURES
133800                              MAIL-IMAGE-NUMBER
133900                              MAIL-TOTAL-BALANCE
134000                              MAIL-DUE-DATE
134100                              MAIL-AMOUNT-BILLED
134200                              MAIL-CLOSING-DATE
134300                              MAIL-CHECK-TRANSACTION-NO
134400                              MAIL-XREF-DATE
134500                              MAIL-XREF-N
134600                              MAIL-DEPOSIT-AMOUNT
134700                              MAIL-OPENING-BALANCE-SHARES
134800                              MAIL-CLOSING-BALANCE-SHARES
134900                              MAIL-CALENDAR-XREF
135000                              RECUR-ACCT-NO
135100                              RECUR-SUB-ACCT
135200                              RECUR-ADDRESOR-ZIPCODE
135300                              RECUR-ADDRESEE-ZIPCODE
135400                              RECUR-PAYEE-ZIPCODE
135500                              RECUR-PAYEE-RESIDENT-CODE
135600                              RECUR-PAYEE-DISPOSITION
135700                              RECUR-INVOICE-CLASSIFY
135800                              RECUR-PRE-APPROVE-LOLIMIT
135900                              RECUR-PRE-APPROVE-HILIMIT
136000                              RECUR-CYCLE-AMOUNT
136100                              RECUR-CYCLE-DATE
136200                              RECUR-CYCLE-EVENT
136300                              RECUR-POSTAGE-AMOUNT
136400                              RECUR-NUMBER-ENCLOSURES
136500                              RECUR-CHART-ACCT-01
136600                              RECUR-CHART-ACCT-02
136700                              RECUR-CHART-ACCT-03
136800                              RECUR-CHART-ACCT-04
136900                              RECUR-CHART-ACCT-05
137000                              RECUR-CHART-ACCT-06
137100                              RECUR-CHART-ACCT-07
137200                              RECUR-CHART-ACCT-08.
137300
137400      MOVE CLNT-PROFILE-ACCT-NO  TO MAIL-ACCT-NO
137500                                    RECUR-ACCT-NO.
137600      MOVE CLNT-PROFILE-SUB-ACCT TO MAIL-SUB-ACCT
137700                                    RECUR-SUB-ACCT.
137800      MOVE 'TPS010  '         TO MAIL-ADMIN-XXXXXX.
137900      MOVE '99'               TO MAIL-DISPOSITION
138000                                 RECUR-DISPOSITION.
138100      MOVE '19'               TO MAIL-CATEGORY-CODE
138200                                 RECUR-CATEGORY-CODE
138300                                 RECUR-CHART-ACCT-01(1:2).
138400      MOVE '99'               TO MAIL-CONTAINR-SIZE                                
138500                                 MAIL-POSTAGE-CLASS                                
138600                                 MAIL-CARRIER-CODE.                                
138700      MOVE RPRT-FROM-NAME     TO MAIL-ADDRESOR-NAME
138800                                 RECUR-ADDRESOR-NAME.
138900      MOVE LS-ACCESS-LEVEL-TITLE TO MAIL-ADDRESOR-ADDRL1
139000                                    RECUR-ADDRESOR-ADDRL1.
139100
139200      MOVE SPACES                     TO WS-FLOAT-PARMS.
139300      MOVE CLNT-PROFILE-FIRST-NAME    TO WS-FLOAT-1.
139400      IF CLNT-PROFILE-MDDL-INIT = SPACES
139500         MOVE '2'                     TO WS-FLOAT-COUNT
139600         MOVE CLNT-PROFILE-LAST-NAME  TO WS-FLOAT-2
139700        ELSE
139800         MOVE '3'                     TO WS-FLOAT-COUNT
139900         MOVE CLNT-PROFILE-MDDL-INIT  TO WS-FLOAT-2(1:1)
140000         MOVE '.'                     TO WS-FLOAT-2 (2:1)
140100         MOVE CLNT-PROFILE-LAST-NAME  TO WS-FLOAT-3
140200       END-IF.
140300      CALL FLOATIT USING WS-FLOAT-DATA.
140400
140500      MOVE WS-FLOAT-1(1:36)  TO RPRT-TO-NAME.
140600
140700      MOVE RPRT-TO-NAME       TO MAIL-ADDRESEE-NAME
140800                                 RECUR-ADDRESEE-NAME.
140900      MOVE 'y'                TO MAIL-ALLOW-DUPLICATES.
141000
141100      MOVE MEMO-LINE-01       TO TPS-MEMO-LINE-01.
141200      MOVE MEMO-LINE-02       TO TPS-MEMO-LINE-02.
141300      MOVE MEMO-LINE-03       TO TPS-MEMO-LINE-03.
141400      MOVE MEMO-LINE-04       TO TPS-MEMO-LINE-04.
141500      MOVE MEMO-LINE-05       TO TPS-MEMO-LINE-05.
141600      MOVE MEMO-LINE-06       TO TPS-MEMO-LINE-06.
141700      MOVE MEMO-LINE-07       TO TPS-MEMO-LINE-07.
141800      MOVE MEMO-LINE-08       TO TPS-MEMO-LINE-08.
141900      MOVE MEMO-LINE-09       TO TPS-MEMO-LINE-09.
142000      MOVE MEMO-LINE-10       TO TPS-MEMO-LINE-10.
142100
142200      CALL TPS1010G USING TPS-LOGON-REC
142300                          TPS-PROFL-REC
142400                          TPS-MAIL-REC
142500                          TPS-MEMO-REC.
142600      CANCEL TPS1010G.
142700
142800      GO TO NEXT-AVAILABLE-ACCT.
142900
143000
143100
143200
