000100 IDENTIFICATION DIVISION.
000200 PROGRAM-ID. seehorse.
000300 AUTHOR. JOHN CURRAN.
000400***************************************************************
000500*    LIST OF PROFILE DATABASE                                *
000600***************************************************************
000700 ENVIRONMENT DIVISION.
000800 CONFIGURATION SECTION.
000900 SOURCE-COMPUTER. IBM-PS2.
001000 OBJECT-COMPUTER. IBM-PS2.
001100 FILE-CONTROL.
001200*    SELECT PRT-FILE  ASSIGN TO 'lpt1'                            00001000
           SELECT PRT-FILE  ASSIGN TO "C:\TPS\APP\seehorse.TXT"         00001000                                        
001400         ORGANIZATION IS LINE SEQUENTIAL                          00001100
001500         FILE STATUS IS TPS-FILE-STATUS.
001600 DATA DIVISION.
001700 FILE SECTION.
001800 FD  PRT-FILE                                                     00001600
001900     LABEL RECORDS ARE OMITTED                                    00001700
002000     RECORD CONTAINS 200 CHARACTERS.                              00001800
                             
       
002100 01  PRT-RECORD.
              05  PRT-acct-no                       PIC x(10).                                                            
002148        05  FILLER                            PIC X(02).                                                            
003400        05  prt-record-type                   pic x(02).                                                            
002148        05  FILLER                            PIC X(02).                                                            
003400        05  prt-extension                     pic x(02).                                                            
002148        05  FILLER                            PIC X(02).                                                            
003400        05  prt-record-number                 pic x(04).                                                            
002148        05  FILLER                            PIC X(02).                                                            
004900        05  prt-short-name                    pic x(30).                                                            
002148        05  FILLER                            PIC X(02).                                                            
004900        05  prt-dob                           pic x(08).                                                            
002148        05  FILLER                            PIC X(99).                                                            
002263
002264
002265
004500 WORKING-STORAGE SECTION.
004600     COPY "TPSFILES.CPY".
004700     COPY "KEYVALUE.CPY".
004700     COPY "pcl5valu.CPY".
004800 01  TPS-horse-REC.
004900     COPY "TPShorse.CPY".
005000 01  tpsio038                      PIC X(08) VALUE 'tpsio038'.
005100 01  PROGRAM-NAMES.
005200  10 TPSIOERR    PIC X(08) VALUE 'TPSIOERR'.
005200  10 FLOATBIG    PIC X(08) VALUE 'FLOATBIG'.
005300  10 FILLER      PIC X(08) VALUE HIGH-VALUES.
005400 01  TPS-FILE-STATUS                       PIC XX.
005500     88  TPS-CARRIER-FILE-OK VALUE '00', '02'.

005100 01  CLIENT-COUNT                   PIC  9(03) VALUE ZEROS.
005100 01  COUNT-MASK                     PIC  ZZ9.

029300                                                                                     00037100
030600 01  BG-FLOAT-DATA.                                                                  00037200
030700     05  BG-FLOAT-PARMS              PIC  X(161).                                    00037300
030800     05  FILLER REDEFINES BG-FLOAT-PARMS.                                            00037400
030900         10  BG-FLOAT-COUNT          PIC  X(01).                                     00037500
031000         10  BG-FLOAT-1              PIC  X(40).                                     00037600
031100         10  BG-FLOAT-2              PIC  X(40).                                     00037700
031200         10  BG-FLOAT-2-R REDEFINES BG-FLOAT-2.                                      00037800
031300             15  BG-FLOAT-2-I        PIC  X(01) OCCURS 40 TIMES.                     00037900
031400         10  BG-FLOAT-3              PIC  X(40).                                     00038000
031500         10  FILLER REDEFINES BG-FLOAT-3.                                            00038100
031600             15  BG-FLOAT-3-A        PIC  X(37).                                     00038200
031700             15  BG-FLOAT-3-B        PIC  X(03).                                     00038300
031800         10  BG-FLOAT-3-R REDEFINES BG-FLOAT-3.                                      00038400
031900             15  BG-FLOAT-3-I        PIC  X(01) OCCURS 40 TIMES.                     00038500
032000         10  BG-FLOAT-4              PIC  X(40).                                     00038600
032100                                                                                     00038700
       01  cur-horse-number                 pic  9(04) value 0.                                                           
       
       01  cur-account-number               pic  9(10) value 0.                                                         


      *************************************************************
      *   table of horse name was for bob spegiel including the   *
      *   names commented out                                     *
      *                                                           *
      *   the 3 names replacing the commented ou names are for    *
      *   start-up of the walker stable account                   *
      *                                                           *
      *************************************************************
       01 name-tbl.
000000***** "12345678901234567890123456789012345678901234567890"
          05 filler                pic  x(50) value
            "A Generic Horse                                   ".                                                         
          05 filler                pic  x(50) value
            "Air Race                                          ".                                                         
      ****  "High Yield ~ Global Starr                         ".                                                         
          05 filler                pic  x(50) value
            "Church Service                                    ".                                                         
      ****  "Forever Splendid ~ Malibu Wesley                  ".                                                         
          05 filler                pic  x(50) value
            "Hoot                                              ".
      ****  "Millions ~ Sugar Blues                            ".
          05 filler                pic  x(50) value
            "Sky Classic ~ Miss Garland                        ".
          05 filler                pic  x(50) value
            "Conquistador ~ Bolshoi Comedy                     ".
          05 filler                pic  x(50) value
            "Carson ~ Global Star                              ".
          05 filler                pic  x(50) value
            "Conquis ~ Private Light                           ".
          05 filler                pic  x(50) value
            "Radio ~ Forever Splendid                          ".
          05 filler                pic  x(50) value
            "Radio Start ~ Sybil                               ".
          05 filler                pic  x(50) value
            "Smoke ~ Miss Actress                              ".
          05 filler                pic  x(50) value
            "Smoke ~ Pine Forest                               ".
          05 filler                pic  x(50) value
            "Southern Halo ~ Miss Garland                      ".
          05 filler                pic  x(50) value
            "Wild Again ~ Rash                                 ".
          05 filler                pic  x(50) value
            "Ball Park                                         ".
          05 filler                pic  x(50) value
            "Boca Juniors                                      ".
          05 filler                pic  x(50) value
            "Bolshi Comedy                                     ".
          05 filler                pic  x(50) value
            "Cairne                                            ".
          05 filler                pic  x(50) value
            "Char                                              ".
          05 filler                pic  x(50) value
            "Forever Splendid                                  ".
          05 filler                pic  x(50) value
            "Global Star                                       ".
          05 filler                pic  x(50) value
            "Hard As Nails                                     ".
          05 filler                pic  x(50) value
            "Holly Rae                                         ".
          05 filler                pic  x(50) value
            "Judge TC                                          ".
          05 filler                pic  x(50) value
            "Last Puff                                         ".
          05 filler                pic  x(50) value
            "Midnight Polka                                    ".
          05 filler                pic  x(50) value
            "Millions                                          ".
          05 filler                pic  x(50) value
            "Miss Actress                                      ".
          05 filler                pic  x(50) value
            "Miss Garland                                      ".
          05 filler                pic  x(50) value
            "Personal Flag                                     ".
          05 filler                pic  x(50) value
            "Pine Forest                                       ".
          05 filler                pic  x(50) value
            "Private Light                                     ".
          05 filler                pic  x(50) value
            "Radio Star                                        ".
          05 filler                pic  x(50) value
            "Rash                                              ".
          05 filler                pic  x(50) value
            "Rhythmic Motion                                   ".
          05 filler                pic  x(50) value
            "Ruff                                              ".
          05 filler                pic  x(50) value
            "Saracandu                                         ".
          05 filler                pic  x(50) value
            "Skit                                              ".
          05 filler                pic  x(50) value
            "Smash Hit                                         ".
          05 filler                pic  x(50) value
            "Smashing Gail                                     ".
          05 filler                pic  x(50) value
            "Sybil S                                           ".
          05 filler                pic  x(50) value
            "Wessex (ARG)                                      ".
          05 filler                pic  x(50) value
            "Midnight Polka ~ Acceptable                       ".
          05 filler                pic  x(50) value
            "Smoke Glacken ~ Could't Be Sold                   ".                                                         
          05 filler                pic  x(50) value
            "Mr Greeley ~ Ruff                                 ".
          05 filler                pic  x(50) value
            "Asked                                             ".
          05 filler                pic  x(50) value
            "Counselita's Wish                                 ".
          05 filler                pic  x(50) value
            "Malibu Wesley                                     ".
          05 filler                pic  x(50) value
            "Smoke Glacken                                     ".
          05 filler                pic  x(50) value high-values.
       01 name-tbl-x redefines name-tbl.                                                                                  
          05 init-horse-names-x occurs 50 times
                             indexed by the-idx.
             10 init-horse-names      pic  x(50).                                                                         


       
      *01  what-to-list-flag               pic  9(01) value 0.                                                          
      *01  what-to-list-flag               pic  9(01) value 1.
       01  what-to-list-flag               pic  9(01) value 2.
      *01  what-to-list-flag               pic  9(01) value 3.                                                          
      *01  what-to-list-flag               pic  9(01) value 9.                                                          
           88  make-new-horse-account                 value 1.                                                            
           88  copy-all-horse-records                 value 2.
           88  make-some-horses                       value 9.                                                          



005600 LINKAGE SECTION.
005700 01 TPS-PARAMETER.
005800    05 TPS-PARAMETER-VALUE PIC XX.
005900
006000 PROCEDURE DIVISION USING
006100                          TPS-PARAMETER.
006200 seehorse-BEGIN.
006300    PERFORM OPEN-THE-FILES
006400       THRU OPEN-THE-FILES-EXIT.
006200                                                                                                                  
          if make-new-horse-account                                                                                       
006200       perform create-new-horse-owner thru                                                                          
006200               create-new-horse-owner-exit                                                                          
           end-if.                                                                                                      
006200                                                                                                                  
          if copy-all-horse-records                                                                                       
006200       perform copy-horse-records thru                                                                              
006200               copy-horse-records-exit                                                                              
           end-if.                                                                                                      
006200                                                                                                                  
          if make-some-horses                                                                                             
006200       perform create-horse-records thru                                                                            
006200               create-horse-records-exit                                                                            
006700****** go to seehorse-common-exit                                                                                   
           end-if.                                                                                                      
006200                                                                                                                  
006200                                                                                                                  
006200                                                                                                                  
006500    PERFORM READ-THE-horses
006600       THRU READ-THE-horses-EXIT.                                                                                   


006700 seehorse-COMMON-EXIT.
006800    PERFORM CLOSE-THE-FILES
006900       THRU CLOSE-THE-FILES-EXIT.
007000    goback.                                                                                                       
007100
007200 READ-THE-horses.                                                                                                   
007300    MOVE ZEROS      TO horse-KEY.                                                                                   
007400    MOVE F-PRIME TO FILE-KEY.
007500    MOVE F-START TO FILE-ACTION.
007600    CALL tpsio038 USING FILE-REQUEST tps-horse-rec.
007700    IF NO-RECORD-WAS-FOUND GO TO READ-THE-horses-EXIT.
007800    IF NOT A-SUCCESSFUL-OPERATION
007900       MOVE ' horse' TO FILE-NAME
008000       MOVE 'seehorse-SBR' TO FILE-TEXT
008100       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
008200       GO TO seehorse-COMMON-EXIT.
008210
008300 READ-ALL-horse-RECORDS.
008400    MOVE F-PRIME TO FILE-KEY.
008500    MOVE F-READ-NEXT TO FILE-ACTION.
008600    CALL tpsio038 USING FILE-REQUEST tps-horse-rec.
008700    IF END-OF-FILE-WAS-REACHED GO TO READ-THE-horses-EXIT.
008800    IF NOT A-SUCCESSFUL-OPERATION
008900       MOVE ' horse' TO FILE-NAME
009000       MOVE 'seehorse-BRN' TO FILE-TEXT
009100       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
009200       GO TO seehorse-COMMON-EXIT.
009228    
009247*   if horse-add-date(1:1) > '7'                                                                                    
009227*      go to read-all-horse-records.
009225
009225
009243
009229     MOVE SPACES                TO PRT-RECORD.                                                                      
009243
003400     move horse-acct-no                                                                                             
               to PRT-acct-no.                                                                                            
003400     move horse-record-type                                                                                         
003400         to prt-record-type.                                                                                        
003400     move horse-extension                                                                                           
003400         to prt-extension.                                                                                          
003400     move horse-record-number                                                                                       
003400         to prt-record-number.                                                                                      
004900     move horse-short-name                                                                                          
004900         to prt-short-name.                                                                                         
004900     move horse-dob                                                                                                 
004900         to prt-dob.                                                                                                
                                                                                                                          
011900       WRITE PRT-RECORD.
012000       GO TO READ-ALL-horse-RECORDS.
301900
009225                                                                                                                  
012100 READ-THE-horses-EXIT. EXIT.
012300
012400
012500 FILE-ERROR.
012600     CALL TPSIOERR USING FILE-REQUEST.
012700     CANCEL TPSIOERR.
012800 FILE-ERROR-EXIT. EXIT.
012900
013000
013100 OPEN-THE-FILES.
013200    OPEN OUTPUT PRT-FILE.
011900*    WRITE PRT-RECORD FROM PCL5-LINE-SPACE-08LPI                                                                  
      *                    AFTER ADVANCING 0 LINES.                                                                     
013300    MOVE F-PRIME    TO FILE-KEY.
013400    MOVE F-OPEN-I-O TO FILE-ACTION.
013500    CALL tpsio038 USING FILE-REQUEST tps-horse-rec.
013600    IF FILE-STATUS NOT = '00' AND '05'
013700       MOVE 'horse ' TO FILE-NAME
013800       MOVE 'seehorse-ORC' TO FILE-TEXT
013900       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
014000       GO TO seehorse-COMMON-EXIT.
014100 OPEN-THE-FILES-EXIT. EXIT.
014110
014200 CLOSE-THE-FILES.
014300    CLOSE PRT-FILE.
014400      MOVE F-PRIME TO FILE-KEY.
014500      MOVE F-CLOSE TO FILE-ACTION.
014700      CALL tpsio038 USING FILE-REQUEST tps-horse-rec.
014800      IF NOT A-SUCCESSFUL-OPERATION
014900         MOVE 'horse ' TO FILE-NAME
015000         MOVE 'seehorse-CCK' TO FILE-TEXT
015100         PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
015200      END-IF.
015300
015400 CLOSE-THE-FILES-EXIT. EXIT.
015500
015500
015500
029700
029710 DELETE-THE-RECORD.
029720    MOVE F-PRIME TO FILE-KEY.
029730    MOVE F-DELET TO FILE-ACTION.
014700    CALL tpsio038 USING FILE-REQUEST tps-horse-rec.
029760    IF NOT A-SUCCESSFUL-OPERATION
029770       MOVE ' horse' TO FILE-NAME
029780       MOVE 'SEEBILLS-DEL' TO FILE-TEXT
029790       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
014000       GO TO seehorse-COMMON-EXIT
109100     END-IF.                                                                         00221700
029792
012000    GO TO READ-ALL-horse-RECORDS.
029800
015500
015500
029710 REad-THE-RECORD.                                                                                                 
029720    MOVE F-PRIME TO FILE-KEY.
108300    MOVE F-REad  TO FILE-ACTION.                                                                                  
014700    CALL tpsio038 USING FILE-REQUEST tps-horse-rec.
108500    IF NOT A-SUCCESSFUL-OPERATION                                                    00221100
029770       MOVE ' horse' TO FILE-NAME
029780       MOVE 'SEEBILLS-Rd ' TO FILE-TEXT                                                                           
108800       PERFORM FILE-ERROR THRU                                                       00221400
108900               FILE-ERROR-EXIT                                                       00221500
014000       GO TO seehorse-COMMON-EXIT
109100     END-IF.                                                                         00221700
029710 REad-THE-RECORD-exit. exit.                                                                                      
015500
015500
015500
029710 REWRITE-THE-RECORD.
029720    MOVE F-PRIME TO FILE-KEY.
108300    MOVE F-REWRITE TO FILE-ACTION.                                                   00220900
014700    CALL tpsio038 USING FILE-REQUEST tps-horse-rec.
108500    IF NOT A-SUCCESSFUL-OPERATION                                                    00221100
029770       MOVE ' horse' TO FILE-NAME
029780       MOVE 'SEEBILLS-REW' TO FILE-TEXT
108800       PERFORM FILE-ERROR THRU                                                       00221400
108900               FILE-ERROR-EXIT                                                       00221500
014000       GO TO seehorse-COMMON-EXIT
109100     END-IF.                                                                         00221700
029710 REWRITE-THE-RECORD-exit. exit.                                                                                   
015500
000000
006200 copy-horse-records.                                                                                                
007300    move zeros      to horse-key.                                                                                   
003400    move '0101000990'                 to horse-acct-no.                                                             
007400    move f-prime to file-key.
007500    move f-start to file-action.
007600    call tpsio038 using file-request tps-horse-rec.
007700    if no-record-was-found                                                                                          
006200       go to copy-horse-records-exit                                                                                
           end-if.                                                                                                        
007800    if not a-successful-operation
007900       move ' horse' to file-name
008000       move 'seehorse-sbr' to file-text
008100       perform file-error thru file-error-exit
008200       go to seehorse-common-exit.
008210
008300 copy-horse-records-detail.
008400    move f-prime to file-key.
008500    move f-read-next to file-action.
008600    call tpsio038 using file-request tps-horse-rec.
008700    if end-of-file-was-reached                                                                                      
006200       go to copy-horse-records-exit                                                                                
           end-if.                                                                                                        
008800    if not a-successful-operation
008900       move ' horse' to file-name
009000       move 'seehorse-brn' to file-text
009100       perform file-error thru file-error-exit
009200       go to seehorse-common-exit.
009228    
003400    if horse-acct-no not = '0101000990'                                                                             
006200       go to copy-horse-records-exit                                                                                
           end-if.                                                                                                        
009225
003400    move '0101002111'                 to horse-acct-no.                                                             
029720    move f-prime to file-key.
108300    move f-write to file-action.                                                   00220900                         
014700    call tpsio038 using file-request tps-horse-rec.
108500    if not a-successful-operation                                                    00221100
029770       move ' horse' to file-name
029780       move 'seehorse-wr3' to file-text                                                                             
108800       perform file-error thru                                                       00221400
108900               file-error-exit                                                       00221500
014000       go to seehorse-common-exit
109100     end-if.                                                                         00221700
009225
003400    move '0101000990'                 to horse-acct-no.                                                             
007400    move f-prime to file-key.
007500    move f-start to file-action.
007600    call tpsio038 using file-request tps-horse-rec.
007700    if no-record-was-found                                                                                          
006200       go to copy-horse-records-exit                                                                                
           end-if.                                                                                                        
007800    if not a-successful-operation
007900       move ' horse' to file-name
008000       move 'seehorse-sbr' to file-text
008100       perform file-error thru file-error-exit
008200       go to seehorse-common-exit.
008210
008400    move f-prime to file-key.
008500    move f-read-next to file-action.
008600    call tpsio038 using file-request tps-horse-rec.
008700    if end-of-file-was-reached                                                                                      
006200       go to copy-horse-records-exit                                                                                
           end-if.                                                                                                        
008800    if not a-successful-operation
008900       move ' horse' to file-name
009000       move 'seehorse-brn' to file-text
009100       perform file-error thru file-error-exit
009200       go to seehorse-common-exit.
008300    go to copy-horse-records-detail.
009228    
006200 copy-horse-records-exit. exit.                                                                                     
015500
015500
006200 create-horse-records.                                                                                              
007600    initialize tps-horse-rec.                                                                                     
003400    move '0101000990'              to horse-acct-no.                                                                
003400    move '01'                      to horse-extension.                                                              
003400    move '01'                      to horse-record-type.                                                            
006301    move 'NYTHSCA   '              to horse-add-password.                                                           
006302    move '20040102'                to horse-add-date.                                                               
006301    move '          '              to horse-change-password.                                                        
006302    move '00000000'                to horse-change-date.                                                            
012610    move spaces                    to horse-room-to-expand.                                                         
004900    move '00000000'                to horse-dob.                                                                    
015500
015500
015500    perform varying the-idx from 1 by 1
                    until init-horse-names(the-idx)                                                                       
015500                  = high-values                                                                                     
             add 1                  to cur-horse-number                                                                   
003400       move cur-horse-number  to horse-record-number                                                                
             move init-horse-names(the-idx)                                                                               
004900                              to horse-short-name                                                                   
004900       move spaces            to horse-long-name                                                                    
             move init-horse-names(the-idx)                                                                               
004900                              to horse-long-name                                                                    
029720       move f-prime to file-key                                                                                     
108300       move f-write to file-action                                                    00220900                      
014700       call tpsio038 using file-request tps-horse-rec                                                               
108500       if not a-successful-operation                                                    00221100                    
029770          move ' horse' to file-name                                                                                
029780          move 'seehorse-wri' to file-text                                                                          
108800          perform file-error thru                                                       00221400                    
108900                  file-error-exit                                                       00221500                    
014000          go to seehorse-common-exit                                                                                
109100        end-if                                                                                                      
109100      end-perform.                                                                                                  
015500
015500
003400    move '00'                      to horse-record-type.                                                            
004900    move spaces                    to horse-short-name                                                              
004900                                      horse-long-name.                                                              
029720    move f-prime to file-key.
108300    move f-write to file-action.                                                   00220900                         
014700    call tpsio038 using file-request tps-horse-rec.
108500    if not a-successful-operation                                                    00221100
029770       move ' horse' to file-name
029780       move 'seehorse-wr2' to file-text
108800       perform file-error thru                                                       00221400
108900               file-error-exit                                                       00221500
014000       go to seehorse-common-exit
109100     end-if.                                                                         00221700
015500
015500
006200 create-horse-records-exit. exit.                                                                                   
015500
015500
006200 create-new-horse-owner.                                                                                            
007600    initialize tps-horse-rec.                                                                                     
003400*** move '0106000169'              to horse-acct-no.                                                                
003400    move '0106000318'              to horse-acct-no.                                                                
003400    move '01'                      to horse-extension.                                                              
003400    move '01'                      to horse-record-type.                                                            
006301    move 'NYTHSCA   '              to horse-add-password.                                                           
006302    move '20080114'                to horse-add-date.                                                               
006301    move '          '              to horse-change-password.                                                        
006302    move '00000000'                to horse-change-date.                                                            
012610    move spaces                    to horse-room-to-expand.                                                         
004900    move '00000000'                to horse-dob.                                                                    
015500
015500
015500    perform varying the-idx from 1 by 1
                    until the-idx > 1                                                                                     
      ****          until the-idx > 4                                                                                     
             add 1                  to cur-horse-number                                                                   
003400       move cur-horse-number  to horse-record-number                                                                
             move init-horse-names(the-idx)                                                                               
004900                              to horse-short-name                                                                   
004900       move spaces            to horse-long-name                                                                    
             move init-horse-names(the-idx)                                                                               
004900                              to horse-long-name                                                                    
029720       move f-prime to file-key                                                                                     
108300       move f-write to file-action                                                    00220900                      
014700       call tpsio038 using file-request tps-horse-rec                                                               
108500       if not a-successful-operation                                                    00221100                    
029770          move ' horse' to file-name                                                                                
029780          move 'seehorse-wri' to file-text                                                                          
108800          perform file-error thru                                                       00221400                    
108900                  file-error-exit                                                       00221500                    
014000          go to seehorse-common-exit                                                                                
109100        end-if                                                                                                      
109100      end-perform.                                                                                                  
015500
015500
003400    move '00'                      to horse-record-type.                                                            
004900    move spaces                    to horse-short-name                                                              
004900                                      horse-long-name.                                                              
029720    move f-prime to file-key.
108300    move f-write to file-action.                                                   00220900                         
014700    call tpsio038 using file-request tps-horse-rec.
108500    if not a-successful-operation                                                    00221100
029770       move ' horse' to file-name
029780       move 'seehorse-wr2' to file-text
108800       perform file-error thru                                                       00221400
108900               file-error-exit                                                       00221500
014000       go to seehorse-common-exit
109100     end-if.                                                                         00221700
015500
006200 create-new-horse-owner-exit. exit.                                                                                 
015500
