000100 IDENTIFICATION DIVISION.
000200 PROGRAM-ID. seedtrib.
000300 AUTHOR. T S.
000400***************************************************************
000500*    LIST OF dtrib records                                    *
000600***************************************************************
000700 ENVIRONMENT DIVISION.
000800 CONFIGURATION SECTION.
000900 SOURCE-COMPUTER. IBM-PS2.
001000 OBJECT-COMPUTER. IBM-PS2.
001100 FILE-CONTROL.
001200***  SELECT PRT-FILE  ASSIGN TO EXTERNAL LISTFILE                 00001000
001300     SELECT PRT-FILE  ASSIGN TO "C:\TPS\APP\seedtrib.TXT"         00001000
001400         ORGANIZATION IS LINE SEQUENTIAL                          00001100
001500         FILE STATUS IS TPS-FILE-STATUS.
001300***  SELECT xfl-FILE  ASSIGN TO "C:\TPS\APP\seedtrib.xfl"         00001000
001300     SELECT xfl-FILE                                                                                              
001300         assign to "\tps\prod\files\tpsdtrib.xfl"                                                                 
001400         ORGANIZATION IS LINE SEQUENTIAL                          00001100
001500         FILE STATUS IS TPS-FILE-STATUS.
001600 DATA DIVISION.
001700 FILE SECTION.
001800 FD  PRT-FILE                                                     00001600
001900     LABEL RECORDS ARE OMITTED                                    00001700
002000     RECORD CONTAINS 150 CHARACTERS.                              00001800
002100 01  PRT-RECORD.
002115*       05  prt-key                           PIC  X(18).
002111*       05  FILLER                            PIC  X(02).
002115        05  prt-acct-no                       PIC  X(10).
002111        05  FILLER                            PIC  X(02).
002115        05  prt-receive-date                  PIC  X(08).
002111        05  FILLER                            PIC  X(02).
002115        05  prt-bin-number                    PIC  X(06).                                                         
002111        05  FILLER                            PIC  X(02).
002115        05  prt-received-count                PIC  zzz,zz9.                                                       
002111        05  FILLER                            PIC  X(02).
002111        05  FILLER                            PIC  X(02).
002111        05  FILLER                            PIC  X(02).
002115        05  prt-mail-until-date               PIC  X(08).                                                         
002111        05  FILLER                            PIC  X(02).
002115        05  prt-status                        PIC  X(01).                                                         
002111        05  FILLER                            PIC  X(02).
002111        05  FILLER                            PIC  X(02).
002119        05  FILLER                            PIC  X(02).
003900        05  FILLER                            PIC  X(150).
001800                                                                                                                  
001800 FD  xfl-FILE                                                                                                     
001900     LABEL RECORDS ARE OMITTED                                                                                    
002000     RECORD CONTAINS 95 CHARACTERS.                                                                               
002100 01  xfl-RECORD.
002115        05  xfl-acct-no                       PIC  X(10).
002111        05  xfl-coma-1                        PIC  X(01).
002115        05  xfl-client-last-name              PIC  X(20).                                                         
002111        05  xfl-coma-2                        PIC  X(01).
002115        05  xfl-client-first-name             PIC  X(15).                                                         
002111        05  xfl-coma-3                        PIC  X(01).
002115        05  xfl-client-dup-name               PIC  X(01).                                                         
002111        05  xfl-coma-4                        PIC  X(01).
002111        05  xfl-bin-number                    PIC  X(03).                                                         
002111        05  xfl-coma-5                        PIC  X(01).                                                         
002111        05  xfl-mail-count                    PIC  X(04).                                                         
002111        05  xfl-coma-6                        PIC  X(01).                                                         
002115        05  xfl-master-last-name              PIC  X(20).                                                         
002111        05  xfl-coma-7                        PIC  X(01).
002115        05  xfl-master-first-name             PIC  X(15).                                                         
009500
009600
009700 WORKING-STORAGE SECTION.
009800     COPY "TPSFILES.CPY".
009900     COPY "KEYVALUE.CPY".
010110                                                                                                                  
010000 01  TPS-dtrib-REC.
010100     COPY "TPSdtrib.CPY".
010000 01  sav-dtrib-REC                 pic  x(150).                                                                     
010110                                                                                                                  
010000 01  TPS-profl-REC.
010100     COPY "TPSprofl.CPY".
010110                                                                                                                  
010210 01  TPSIO004                      PIC X(08) VALUE 'TPSIO004'.
010210 01  TPSIO035                      PIC X(08) VALUE 'TPSIO035'.
010220
010300 01  PROGRAM-NAMES.
010400  10 TPSIOERR    PIC X(08) VALUE 'TPSIOERR'.
010500  10 FILLER      PIC X(08) VALUE HIGH-VALUES.
010600 01  TPS-FILE-STATUS                       PIC XX.
010700     88  TPS-CARRIER-FILE-OK VALUE '00', '02'.
010800                                                                                                                  
010800                                                                                                                  
010800 01 THE-IDX                 PIC S9(04) COMP.                                                                      
010800 01 THE-TABLE                          OCCURS 100 TIMES.
010800    05 the-name.                                                                                                  
010800       10 the-last-name     pic  x(20).                                                                           
010800       10 the-first-name    pic  x(15).                                                                           
010800    05 the-account          pic  x(10).                                                                           
021200                                                                                                                  
010800***************************************************************                                                   
010230
010800 01 what-r-we-doing-flag    PIC  9(01) value 0.
010800*01 what-r-we-doing-flag    PIC  9(01) value 1.                                                                   
010800*01 what-r-we-doing-flag    PIC  9(01) value 2.                                                                   
010800*01 what-r-we-doing-flag    PIC  9(01) value 3.                                                                   
010800   88 build-new-data-base              value 1.                                                                   
010800   88 fix-some-fields                  value 2.                                                                   
010800   88 delete-the-19recs                value 3.                                                                   
010230
       01 the-mail-bin-number     pic  9(06) value 10.                                                                  
010800                                                                                                                  
010800 LINKAGE SECTION.
010900 01 TPS-PARAMETER.
011000    05 TPS-PARAMETER-VALUE PIC XX.
011100
011200 PROCEDURE DIVISION USING tps-parameter.
011300                                                                                                                  
011400 seedtrib-BEGIN.
011500    PERFORM OPEN-THE-FILES
011600       THRU OPEN-THE-FILES-EXIT.
011601
010800    if build-new-data-base                                                                                        
011601       go to create-the-data-base                                                                                 
           end-if.                                                                                                      
011601
010800    if fix-some-fields                                                                                              
011601       perform repair-recycle-records thru                                                                          
011601               repair-recycle-records-exit                                                                          
           end-if.                                                                                                      
011601
010800    if delete-the-19recs                                                                                            
011601       perform lose-the-19-recs thru                                                                                
011601               lose-the-19-recs-exit                                                                                
           end-if.                                                                                                      
011601
011700    PERFORM READ-THE-dtrib
011800       THRU READ-THE-dtrib-EXIT.
011630
011630
011900 seedtrib-COMMON-EXIT.
012000    PERFORM CLOSE-THE-FILES
012100       THRU CLOSE-THE-FILES-EXIT.
012200    GOBACK.                                                                                                       
012200    STOP RUN.
012300
012400 READ-THE-dtrib.
012500    INITIALIZE TPS-dtrib-REC.
012300
012511*   MOVE '0101000446'          TO dtrib-ACCT-NO.                                                                  
012513*   MOVE '00'                  TO dtrib-SUB-ACCT.                                                                 
012555
012600    MOVE F-PRIME TO FILE-KEY.
012700    MOVE F-START TO FILE-ACTION.
012800    CALL tpsio035 USING FILE-REQUEST TPS-dtrib-REC.
012900    IF NO-RECORD-WAS-FOUND GO TO READ-THE-dtrib-EXIT.
013000    IF NOT A-SUCCESSFUL-OPERATION
013100       MOVE 'dtrib ' TO FILE-NAME
013200       MOVE 'seedtrib-SBR' TO FILE-TEXT
013300       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
013400       GO TO seedtrib-COMMON-EXIT.
013500
013600 READ-ALL-dtrib-RECORDS.
013700    MOVE F-PRIME TO FILE-KEY.
013800    MOVE F-READ-NEXT TO FILE-ACTION.
013900    CALL tpsio035 USING FILE-REQUEST TPS-dtrib-REC.
014000    IF END-OF-FILE-WAS-REACHED GO TO READ-THE-dtrib-EXIT.
014100    IF NOT A-SUCCESSFUL-OPERATION
014200       MOVE 'dtrib ' TO FILE-NAME
014300       MOVE 'seedtrib-BRN' TO FILE-TEXT
014400       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
014500       GO TO seedtrib-COMMON-EXIT.
017500                                                                                                                  
010800    if delete-the-19recs                                                                                            
             if dtrib-receive-date not = zeros                                                                            
013600          go to read-all-dtrib-records                                                                              
014600        end-if                                                                                                      
014600     end-if.                                                                                                        
          if dtrib-acct-no(3:1) not = '9'
013600       go to read-all-dtrib-records.
          if dtrib-acct-no(3:1) = '9'
             if dtrib-receive-date = zero
013600          go to read-all-dtrib-records
           end-if.
014600
026101    MOVE SPACES                TO PRT-RECORD.                                                                     
      *   move dtrib-key                                                                                                
002115*       to  prt-key.                                                                                                
          move dtrib-acct-no                                                                                            
002115        to  prt-acct-no.
          move dtrib-receive-date
002115        to  prt-receive-date.                                                                                       
          move dtrib-mail-bin-number                                                                                    
002115        to  prt-bin-number.                                                                                       
          move dtrib-mail-received-count                                                                                  
002115        to  prt-received-count.                                                                                     
          move dtrib-mail-until-date                                                                                    
002115        to  prt-mail-until-date.                                                                                    
          move dtrib-client-status                                                                                      
002115        to  prt-status.                                                                                             
017550
026100    WRITE PRT-RECORD.                                                                                             
026101    MOVE SPACES                TO PRT-RECORD.                                                                     
026102
013600    GO TO READ-ALL-dtrib-RECORDS.                                                                                 
026302
026310 READ-THE-dtrib-EXIT. EXIT.
026400
026410
026560
026600 FILE-ERROR.
026700     CALL TPSIOERR USING FILE-REQUEST.
026800     CANCEL TPSIOERR.
026900 FILE-ERROR-EXIT. EXIT.
027000
027100
027200 OPEN-THE-FILES.
027300    OPEN OUTPUT PRT-FILE.
028110    MOVE F-PRIME    TO FILE-KEY.
028120    MOVE F-OPEN-I-O TO FILE-ACTION.
028130    CALL tpsio035 USING FILE-REQUEST TPS-dtrib-REC.
028140    IF FILE-STATUS NOT = '00' AND '05'
028150       MOVE 'dtrib ' TO FILE-NAME
028160       MOVE 'seedtrib-ORC' TO FILE-TEXT
028170       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
028180       GO TO seedtrib-COMMON-EXIT.
028200 OPEN-THE-FILES-EXIT. EXIT.
028300
028301
028350
028400 CLOSE-THE-FILES.
028500    CLOSE PRT-FILE.
029310      MOVE F-PRIME TO FILE-KEY.
029320      MOVE F-CLOSE TO FILE-ACTION.
029330      CALL tpsio035 USING FILE-REQUEST TPS-dtrib-REC.
029340      IF NOT A-SUCCESSFUL-OPERATION
029350         MOVE 'dtrib ' TO FILE-NAME
029360         MOVE 'seedtrib-CCK' TO FILE-TEXT                                                                         
029370         PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
029380      END-IF.
029400
029500 CLOSE-THE-FILES-EXIT. EXIT.
029600
029700
011601 create-the-data-base.                                                                                            
014600    perform varying the-idx from 1 by 1
014600              until the-idx > 100                                                                                 
010800         move high-values              to the-last-name(the-idx)                                                  
010800                                          the-first-name(the-idx)                                                 
010800                                          the-account(the-idx)                                                    
014600      end-perform.                                                                                                
014600
014600    move 0   to the-idx.                                                                                          
014600
028110    move f-prime    to file-key.
028120    move f-open-i-o to file-action.
028130    call tpsio004 using file-request tps-profl-rec.
028140    if file-status not = '00' and '05'
028150       move 'profl ' to file-name
028160       move 'seedtrib-orc' to file-text
028170       perform file-error thru file-error-exit
028180       go to seedtrib-common-exit.
029800
012600    move f-prime to file-key.
012700    move f-start to file-action.
012800    call tpsio004 using file-request tps-profl-rec.
012900    if no-record-was-found                                                                                        
013400       go to build-dtrib-control.                                                                                 
013000    if not a-successful-operation
013100       move 'profl ' to file-name
013200       move 'seedtrib-sbr' to file-text
013300       perform file-error thru file-error-exit
013400       go to seedtrib-common-exit.
013500
013600 read-all-profl-records.
013700    move f-prime to file-key.
013800    move f-read-next to file-action.
013900    call tpsio004 using file-request tps-profl-rec.
014000    if end-of-file-was-reached                                                                                    
013400       go to sort-the-table.                                                                                      
014100    if not a-successful-operation
014200       move 'profl ' to file-name
014300       move 'seedtrib-rnx' to file-text
014400       perform file-error thru file-error-exit
014500       go to seedtrib-common-exit.
017500                                                                                                                  
014600    if clnt-profile-sub-acct not = '00'                                                                           
013600       go to read-all-profl-records                                                                               
           end-if.                                                                                                      
014600
014600    if clnt-profile-add-date(1:1) > '7'                                                                           
013600       go to read-all-profl-records                                                                               
           end-if.                                                                                                      
014600
014600    set the-idx up by 1.                                                                                          
014600
014600
014600    move clnt-profile-acct-no    to the-account(the-idx).                                                         
014600    if clnt-profile-acct-no(1:4) = '0150'                                                                         
014600       move clnt-profile-last-name(1:15)                                                                          
014600                                to the-first-name(the-idx)                                                        
014600       move spaces              to the-last-name(the-idx)                                                         
014600       move clnt-profile-first-name(1:15)                                                                         
014600                                 to the-last-name(the-idx)(1:15)                                                  
014600      else                                                                                                        
014600       move clnt-profile-last-name  to the-last-name(the-idx)                                                     
014600       move clnt-profile-first-name to the-first-name(the-idx)                                                    
014600     end-if.                                                                                                      
014600
013600    go to read-all-profl-records.                                                                                 
014600
014600
014600
014600
014600
013400 sort-the-table.                                                                                                  
010800    sort the-table on ascending key the-name.                                                                     
014600
027300    open output xfl-file.                                                                                         
014600    move 0   to the-idx.                                                                                          
014600
014600 read-from-table.                                                                                                 
014600    set the-idx up by 1.
010800    if the-last-name(the-idx) = high-values                                                                       
013400       go to build-dtrib-control                                                                                  
014600     end-if.                                                                                                      
014600
010800    move the-account(the-idx)       to clnt-profile-acct-no.                                                      
010800    move '00'                       to clnt-profile-sub-acct.                                                     
014600
013700    move f-prime to file-key.
013800    move f-read  to file-action.                                                                                  
013900    call tpsio004 using file-request tps-profl-rec.
014100    if not a-successful-operation
014200       move 'profl ' to file-name
014300       move 'seedtrib-rd ' to file-text                                                                           
014400       perform file-error thru file-error-exit
014500       go to seedtrib-common-exit.
017500                                                                                                                  
014600
014600    initialize tps-dtrib-rec.                                                                                     
014600
014600    move clnt-profile-acct-no                                                                                     
                               to dtrib-acct-no.                                                                        
          move zeros           to dtrib-receive-date                                                                    
                                  dtrib-mail-until-date                                                                 
                                  dtrib-client-status                                                                   
                                  dtrib-mail-received-count.                                                            
          move spaces          to dtrib-room-to-expand.                                                                 
014600
          add 1                to the-mail-bin-number.                                                                  
          move the-mail-bin-number                                                                                      
                               to dtrib-mail-bin-number.                                                                
014600   
013700    move f-prime to file-key.
013800    move f-write to file-action.                                                                                  
013900    call tpsio035 using file-request tps-dtrib-rec.
014100    if not a-successful-operation
014200       move 'profl ' to file-name
014300       move 'seedtrib-wr1' to file-text
014400       perform file-error thru file-error-exit
014500       go to seedtrib-common-exit.
017500                                                                                                                  
017500************** build xfl file here *******************                                                            
002115    move ','                       to xfl-coma-1                                                                  
002115                                      xfl-coma-2                                                                  
002115                                      xfl-coma-3                                                                  
002115                                      xfl-coma-4                                                                  
002115                                      xfl-coma-5                                                                  
002115                                      xfl-coma-6                                                                  
002115                                      xfl-coma-7.                                                                 
002115    move clnt-profile-acct-no      to xfl-acct-no.                                                                
017500                                                                                                                  
017500                                                                                                                  
002115    inspect clnt-profile-last-name                                                                                
002115            replacing all ',' by ' '.                                                                             
002115    inspect clnt-profile-first-name                                                                               
002115            replacing all ',' by ' '.                                                                             
017500                                                                                                                  
017500                                                                                                                  
002115    move clnt-profile-last-name    to xfl-client-last-name.                                                       
002115    move clnt-profile-first-name   to xfl-client-first-name.                                                      
          move dtrib-mail-bin-number(4:3) to xfl-bin-number.                                                            
002111    move '0000'                    to xfl-mail-count.                                                             
017500                                                                                                                  
002115    move '0'                       to xfl-client-dup-name.                                                        
002115    move spaces                    to xfl-master-last-name                                                        
002115                                      xfl-master-first-name.                                                      
017500                                                                                                                  
002100    write xfl-RECORD.
002100    move spaces               to xfl-RECORD.                                                                      
017500                                                                                                                  
014600    go to read-from-table.                                                                                        
014600
013400 build-dtrib-control.                                                                                             
027300    close xfl-FILE.                                                                                               
014600    initialize tps-dtrib-rec.                                                                                     
014600    move '0100000000'    to dtrib-acct-no.
014600
          move zeros           to dtrib-receive-date                                                                    
                                  dtrib-client-status                                                                   
                                  dtrib-mail-received-count.                                                            
          move spaces          to dtrib-room-to-expand.                                                                 
014600
          move the-mail-bin-number                                                                                      
                               to dtrib-mail-bin-number.                                                                
014600   
013700    move f-prime to file-key.
013800    move f-write to file-action.                                                                                  
013900    call tpsio035 using file-request tps-dtrib-rec.
014100    if not a-successful-operation
014200       move 'profl ' to file-name
014300       move 'seedtrib-wr2' to file-text
014400       perform file-error thru file-error-exit
014500       go to seedtrib-common-exit.
017500                                                                                                                  
011700    PERFORM READ-THE-dtrib
011800       THRU READ-THE-dtrib-EXIT.
075300
013400    go to seedtrib-common-exit.                                                                                   
075300
075300
075300***************************************************************
011601 repair-recycle-records.                                                                                            
012500    initialize tps-dtrib-rec.
013600 repair-start-dtrib-records.                                                                                        
012600    move f-prime to file-key.
012700    move f-start to file-action.
012800    call tpsio035 using file-request tps-dtrib-rec.
013000    if not a-successful-operation
013100       move 'dtrib ' to file-name
013200       move 'seedtrib-sbr' to file-text
013300       perform file-error thru file-error-exit
013400       go to seedtrib-common-exit.
013500
013600 repair-next-dtrib-records.                                                                                         
013700    move f-prime to file-key.
013800    move f-read-next to file-action.
013900    call tpsio035 using file-request tps-dtrib-rec.
014000    if end-of-file-was-reached                                                                                      
011601       go to repair-recycle-records-exit                                                                            
           end-if.                                                                                                        
014100    if not a-successful-operation
014200       move 'dtrib ' to file-name
014300       move 'seedtrib-brn' to file-text
014400       perform file-error thru file-error-exit
014500       go to seedtrib-common-exit.
017500                                                                                                                  
          if dtrib-acct-no(3:1) not = '9'                                                                                 
             if dtrib-receive-date > zero
013600       go to repair-next-dtrib-records                                                                              
           end-if.                                                                                                        
002115                                                                                                                    
010000    move tps-dtrib-rec       to sav-dtrib-REC.                                                                      
013600    go to repair-next-dtrib-records.
002115                                                                                                                    
          move dtrib-acct-no(5:6)  to dtrib-mail-bin-number.                                                              
          move dtrib-receive-date  to dtrib-mail-until-date.                                                              
002115                                                                                                                    
013700    move f-prime   to file-key.                                                                                     
013800    move f-rewrite to file-action.                                                                                  
013900    call tpsio035 using file-request tps-dtrib-rec.
014100    if not a-successful-operation
014200       move 'dtrib ' to file-name
014300       move 'seedtrib-rew' to file-text                                                                             
014400       perform file-error thru file-error-exit
014500       go to seedtrib-common-exit.
017500                                                                                                                  
010000    move sav-dtrib-rec       to tps-dtrib-rec.                                                                      
013600                                                                                                                    
012600    move f-prime to file-key.
012700    move f-start to file-action.
012800    call tpsio035 using file-request tps-dtrib-rec.
013000    if not a-successful-operation
013100       move 'dtrib ' to file-name
013200       move 'seedtrib-sbr' to file-text
013300       perform file-error thru file-error-exit
013400       go to seedtrib-common-exit.
013500
013700    move f-prime to file-key.
013800    move f-read-next to file-action.
013900    call tpsio035 using file-request tps-dtrib-rec.
014000    if end-of-file-was-reached                                                                                      
011601       go to repair-recycle-records-exit                                                                            
           end-if.                                                                                                        
014100    if not a-successful-operation
014200       move 'dtrib ' to file-name
014300       move 'seedtrib-brn' to file-text
014400       perform file-error thru file-error-exit
014500       go to seedtrib-common-exit.
017500                                                                                                                  
013600    go to repair-next-dtrib-records.                                                                                
017500                                                                                                                  
011601 repair-recycle-records-exit. exit.                                                                                 
075300
075300
011601 lose-the-19-recs.                                                                                                  
012800    initialize tps-dtrib-rec.                                                                                       
          move '019'   to dtrib-acct-no(1:3)
012600    move f-prime to file-key.
012700    move f-start to file-action.
012800    call tpsio035 using file-request tps-dtrib-rec.
013000    if not a-successful-operation
013100       move 'dtrib ' to file-name
013200       move 'seedtrib-sbr' to file-text
013300       perform file-error thru file-error-exit
013400       go to seedtrib-common-exit.
013500
011601 lose-the-next-19-recs.                                                                                             
013700    move f-prime to file-key.
013800    move f-read-next to file-action.
013900    call tpsio035 using file-request tps-dtrib-rec.
014000    if end-of-file-was-reached                                                                                      
011601       go to lose-the-19-recs-exit                                                                                  
           end-if.                                                                                                        
014100    if not a-successful-operation
014200       move 'dtrib ' to file-name
014300       move 'seedtrib-brn' to file-text
014400       perform file-error thru file-error-exit
014500       go to seedtrib-common-exit.
017500                                                                                                                  
          if dtrib-acct-no(3:1) not = '9'                                                                                 
010000       move tps-dtrib-rec       to sav-dtrib-REC                                                                    
011601       go to lose-the-next-19-recs                                                                                  
           end-if.                                                                                                        
002115                                                                                                                    
002115                                                                                                                    
013700    move f-prime to file-key.
013800    move f-delet to file-action.                                                                                    
013900    call tpsio035 using file-request tps-dtrib-rec.
014100    if not a-successful-operation
014200       move 'dtrib ' to file-name
014300       move 'seedtrib-del' to file-text
014400       perform file-error thru file-error-exit
014500       go to seedtrib-common-exit                                                                                   
            else                                                                                                          
011601       go to lose-the-next-19-recs                                                                                  
           end-if.                                                                                                        
017500                                                                                                                  
010000    move sav-dtrib-rec       to tps-dtrib-rec.                                                                      
013600                                                                                                                    
012600    move f-prime to file-key.
012700    move f-start to file-action.
012800    call tpsio035 using file-request tps-dtrib-rec.
013000    if not a-successful-operation
013100       move 'dtrib ' to file-name
013200       move 'seedtrib-sbr' to file-text
013300       perform file-error thru file-error-exit
013400       go to seedtrib-common-exit.
013500
013700    move f-prime to file-key.
013800    move f-read-next to file-action.
013900    call tpsio035 using file-request tps-dtrib-rec.
014000    if end-of-file-was-reached                                                                                      
011601       go to lose-the-19-recs-exit                                                                                  
           end-if.                                                                                                        
014100    if not a-successful-operation
014200       move 'dtrib ' to file-name
014300       move 'seedtrib-brn' to file-text
014400       perform file-error thru file-error-exit
014500       go to seedtrib-common-exit.
017500                                                                                                                  
011601    go to lose-the-next-19-recs.                                                                                    
017500                                                                                                                  
017500                                                                                                                  
011601 lose-the-19-recs-exit. exit.                                                                                       
075300
075300
