000100 IDENTIFICATION DIVISION.
000200 PROGRAM-ID. DONLETTR.
000300 AUTHOR. JIM MONAGHAN.
000400***************************************************************
000500*    DISPLAY ALL CHECKS FOR CHARTITIES THAT DID NOT SEND      *
      *    THANK YOU LETTER EXPLAINING WHAT IS TAX DEDUCTIBLE       *
000600***************************************************************
000600* 06/13/18 CHANGES FOR GUISCREENS                          JM *
000600***************************************************************
000700 ENVIRONMENT DIVISION.
000800 CONFIGURATION SECTION.
000900 SOURCE-COMPUTER. IBM-PS2.
001000 OBJECT-COMPUTER. IBM-PS2.
001100 FILE-CONTROL.
000000                                                                                                                    
009400                                                                                                                    
001600 DATA DIVISION.
001700 FILE SECTION.
000000                                                    
004500                                                                                                                    
004500                                                                                                                    
004500 WORKING-STORAGE SECTION.
002100
004600     COPY "TPSFILES.CPY".
004700     COPY "KEYVALUE.CPY".
004710     COPY "PCL5VALU.CPY".
002100                                                                                                                    
004710                                                                                                                    
004800 01  FGN-CHECK-REC.
004900     COPY "TPSFGNCK.CPY".
004800 01  TPS-CHECK-REC.
004900     COPY "TPSCHECK.CPY".
004910 01  TPS-MAIL-HOLD.
004920     COPY "TPSMAIL.CPY".
004800 01  TPS-RECUR-REC.
004900     COPY "TPSRECUR.CPY".
008100 01  TPS-CKING-REC.                                                                  00011100
008200     COPY TPSCKING.CPY.                                                              00011200
008000                                                                                     00011000
005000 01  GUISCREEN                   PIC X(08) VALUE 'GS      '.
005000 01  TPSIOCHK                    PIC X(08) VALUE 'TPSIOCHK'.
005010 01  TPSIOREC                    PIC X(08) VALUE 'TPSIOREC'.
005010 01  TPSIO004                    PIC X(08) VALUE 'TPSIO004'.
005010 01  tpsio015                    pic x(08) value 'tpsio015'.
005010 01  tpsio026                    pic x(08) value 'tpsio026'.
005200 01  TPSIOERR                    PIC X(08) VALUE 'TPSIOERR'.
005200 01  TPSIO025                    PIC X(08) VALUE 'TPSIO025'.
055800 01  TPSDATES                    PIC X(08) VALUE 'TPSDATES'.
055800 01  TPSVEDIT                    PIC X(08) VALUE 'TPSVEDIT'.
005300
005400 COPY DONCHECK.COB.
005300
005400 COPY DONLETR1.COB.
047100 01 FILLER REDEFINES DONLETR1-4.
047200    10 DONCHECK-USER-FIELDS-R OCCURS 15 TIMES.
047300       20 DON-CHK-DATE              PIC  X(08).
047400       20 DON-CHK-NO                PIC  9(05).
047500       20 DON-CHK-AMT               PIC S9(06)V9(02).
047600       20 DON-CHK-RECV-DATE         PIC  X(08).
047600       20 DON-CHK-PAYEE             PIC  X(20).
047800       20 DON-CHK-MEMO              PIC  X(15).
047800
030600                                                                                                                    
041500 01  FLD-IND                    PIC 9(03) VALUE ZEROS.
041500 01  CLR-IND                    PIC 9(03) VALUE ZEROS.
041500 01  CUR-IND                    PIC 9(03) VALUE ZEROS.
041500 01  DISP-IND                   PIC 9(03) VALUE ZEROS.
041500 01  TBL-IND                    PIC 9(03) VALUE ZEROS.
041500 01  BK-IND                     PIC 9(03) VALUE ZEROS.
041500 01  PANEL-IND                  PIC 9(03) VALUE ZEROS.
050100
050200 01 CHECK-TABLE OCCURS 1 TO 500 TIMES DEPENDING ON TBL-IND.
026500    05 TBL-ACCT-NO                    PIC 9(10).
026500    05 TBL-SUB-ACCT                   PIC 9(02).
026500    05 TBL-CHK-TYPE                   PIC X(01).
026500    05 TBL-CHK-DATE                   PIC 9(08).
026500    05 TBL-CHK-NO                     PIC 9(05).
026500    05 TBL-CHK-AMT                    PIC S9(07)V9(02).
026500    05 TBL-RECV-DATE                  PIC 9(08).
026500    05 TBL-RECV-NO                    PIC 9(05).
026500    05 TBL-PAYEE-NAME                 PIC X(36).
026500    05 TBL-MEMO                       PIC X(40).
026500    05 TBL-FGN-CHK-AC-NO              PIC 9(02).
026500    05 TBL-FGN-CHK-TRANS-CODE         PIC X(01).
026500    05 TBL-FGN-TIE-BREAKER            PIC 9(02).
026500    05 TBL-CHK-TRANSACTION-NO         PIC 9(05).
026500    05 TBL-ADDRESSEE-NAME             PIC X(36).
000100                                                                                                                    
050100
050200 01 BANK-TABLE OCCURS 1 TO 50 TIMES DEPENDING ON BK-IND.
026500    05 TBL-BANK-NO                    PIC 9(02).
026500    05 TBL-BANK-NAME                  PIC X(50).
026500    05 TBL-BANK-ACCT-NAME             PIC X(50).
026500    05 TBL-BANK-ACCT-NO               PIC X(50).
050100
050200 01 WS-DATE.
026500    05 WS-DATE-YY                     PIC 9(02).
026500    05 WS-DATE-MM                     PIC 9(02).
026500    05 WS-DATE-DD                     PIC 9(02).
050100
050200 01 WORK-DATE.
026500    05 WORK-MM                        PIC 9(02).
026500    05 FILLER                         PIC X(01) VALUE '/'.
026500    05 WORK-DD                        PIC 9(02).
026500    05 FILLER                         PIC X(01) VALUE '/'.
026500    05 WORK-YY                        PIC 9(02).
000100                                                                                                                    
037800  01  WS-DATE-REQUEST.
037900      05  WS-DATE-PARAM          PIC  9(02).
038100      05  WS-DATE-TENBYTES       PIC  X(20) VALUE SPACES.
038200      05  FILLER REDEFINES WS-DATE-TENBYTES.
038300          10  WS-DATE-REFORM         PIC  X(06).
038400          10  WS-DATE-EXTEND         PIC  X(04).
038500          10  FILLER                 PIC  X(10).
038600      05  FILLER REDEFINES WS-DATE-TENBYTES.
038700          10  WS-DATE-REFORM-LEN06   PIC  X(06).
038800          10  FILLER                 PIC  X(14).
038900      05  FILLER REDEFINES WS-DATE-TENBYTES.
039000          10  WS-DATE-REFORM-LEN08   PIC  X(08).
039100          10  FILLER                 PIC  X(12).
039200      05  FILLER REDEFINES WS-DATE-TENBYTES.
039300          10  WS-DATE-REFORM-LEN10   PIC  X(10).
039400          10  FILLER                 PIC  X(10).
039500      05  FILLER REDEFINES WS-DATE-TENBYTES.
039600          10  WS-TIME-PARM1          PIC  X(06).
039700          10  WS-TIME-PARM2          PIC  X(06).
039800          10  WS-TIME-EXTEND         PIC  X(08).
039900      05  FILLER REDEFINES WS-DATE-TENBYTES.
040000          10  WS-TIME-PARM1BY8       PIC  X(08).
040100          10  WS-TIME-PARM2BY8       PIC  X(08).
040200          10  WS-TIME-EXTNDBY8       PIC  X(04).
000100                                                                                                                    
005540 01 OLD-DATE                         PIC 9(08).
005550                                                 
       01 FGN-ADDRESOR-NAME                 PIC X(36).
       01 FGN-PAYEE-NAME                    PIC X(36).
       01  CONVERT-TO-CAPITALS              PIC X(01) VALUE 'Y'.
       01  LENGTH-36                        PIC 999   VALUE 36.
005550
005550
005550
005600 LINKAGE SECTION.
005700 01 TPS-PARAMETER.
005800    05 TPS-PARAMETER-VALUE PIC X.
004910 01  TPS-MAIL-REC.
004920     COPY "TPSMAIL.CPY".
005900
006000 PROCEDURE DIVISION USING TPS-PARAMETER TPS-MAIL-REC.
006100
006200 SEECHECK-BEGIN.
005900
006300    PERFORM OPEN-THE-FILES
006400       THRU OPEN-THE-FILES-EXIT.
005900
005900    MOVE TPS-MAIL-REC    TO TPS-MAIL-HOLD.
005900
151000    IF MAIL-RECEIVE-DATE OF TPS-MAIL-REC = ZEROS
             ACCEPT WS-DATE FROM DATE
151100       IF WS-DATE-YY > 94
151100          MOVE 19    TO MAIL-RECEIVE-DATE OF TPS-MAIL-REC(1:2)
151100       ELSE
151100          MOVE 20    TO MAIL-RECEIVE-DATE OF TPS-MAIL-REC(1:2)
151300       END-IF
151400       MOVE WS-DATE  TO MAIL-RECEIVE-DATE OF TPS-MAIL-REC(3:6).
151400
005900
151000    MOVE 22                    TO WS-DATE-PARAM.
151100    MOVE MAIL-RECEIVE-DATE OF TPS-MAIL-REC
151100                               TO WS-DATE-REFORM-LEN08.
151100    MOVE '550'                 TO WS-DATE-TENBYTES(9:3).
151300    CALL TPSDATES USING WS-DATE-REQUEST.
151400    MOVE WS-DATE-REFORM-LEN08  TO OLD-DATE.
151400
006500
006600    MOVE ZEROS   TO BK-IND DISP-IND CLR-IND TBL-IND PANEL-IND.
005900
005900    PERFORM LOAD-BANK-DATA
005900       THRU LOAD-BANK-DATA-EXIT.
005900
017400    PERFORM READ-THE-MAIL
017500       THRU READ-THE-MAIL-EXIT.
005900
017400    PERFORM READ-FGN-CHECKS
017500       THRU READ-FGN-CHECKS-EXIT.
022700
006500    SORT CHECK-TABLE DESCENDING TBL-CHK-DATE
006600                     ASCENDING TBL-CHK-NO TBL-CHK-TYPE.
022700
006500    PERFORM DISPLAY-THE-RECORDS
006600       THRU DISPLAY-THE-RECORDS-EXIT.
022700
006800    PERFORM CLOSE-THE-FILES
006900       THRU CLOSE-THE-FILES-EXIT.
007000    GOBACK.                                                                                                       
018000
018100 READ-THE-MAIL.
018000
021300    MOVE OLD-DATE     TO MAIL-RECEIVE-DATE OF TPS-MAIL-REC.
018000
021300    MOVE F-PRIME TO FILE-KEY.
021400    MOVE F-START TO FILE-ACTION.
021500    CALL TPSIOREC USING FILE-REQUEST TPS-MAIL-REC.
021600    IF NO-RECORD-WAS-FOUND GO TO READ-THE-MAIL-EXIT.
021700    IF NOT A-SUCCESSFUL-OPERATION
021800       MOVE ' RECEIVE' TO FILE-NAME
021900       MOVE 'DONLTR-STR' TO FILE-TEXT
022000       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
022100       GO TO EXIT-PROGRAM.
026880
026880
022200 READ-NEXT-RECORD.
022300    MOVE F-PRIME TO FILE-KEY.
22400     MOVE F-READ-NEXT TO FILE-ACTION.
022500    CALL TPSIOREC USING FILE-REQUEST TPS-MAIL-REC.
022600    IF END-OF-FILE-WAS-REACHED
022700       GO TO READ-THE-MAIL-EXIT
022800     END-IF.
022900
023000    IF NOT A-SUCCESSFUL-OPERATION
023100       MOVE ' RECEIVE' TO FILE-NAME
023200       MOVE 'DONLTR-RNX' TO FILE-TEXT
023300       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
023400       GO TO EXIT-PROGRAM
023500     END-IF.
023610
026880    IF MAIL-ACCT-NO OF TPS-MAIL-REC NOT =
026880       MAIL-ACCT-NO OF TPS-MAIL-HOLD
026880          GO TO READ-THE-MAIL-EXIT.
023610
026880    IF MAIL-CATEGORY-CODE OF TPS-MAIL-REC NOT = '02'
026880       GO TO READ-NEXT-RECORD.
026880
287410    IF MAIL-DISPOSITION OF TPS-MAIL-REC = '88'
026880       GO TO READ-NEXT-RECORD.
026880
022300    IF MAIL-ADDRESOR-NAME OF TPS-MAIL-REC =
022400       MAIL-ADDRESOR-NAME OF TPS-MAIL-HOLD
022500        CONTINUE
023000    ELSE
023100       GO TO READ-NEXT-RECORD.
026880
023000    IF RECUR-CHART-ACCT-01 OF TPS-MAIL-REC(1:2) = 02 AND
023000       RECUR-CHART-ACCT-02 OF TPS-MAIL-REC(1:6) = 000002 AND
023000       MAIL-CHECK-TRANSACTION-NO OF TPS-MAIL-REC > ZEROS
023100        CONTINUE
023200    ELSE
023300       GO TO READ-NEXT-RECORD.
023500
      *
007100
007200 READ-THE-CHECKS.
                  
                  
026880    MOVE MAIL-ACCT-NO OF TPS-MAIL-REC TO CHECK-ACCT-NO.
026880    MOVE MAIL-SUB-ACCT OF TPS-MAIL-REC TO CHECK-SUB-ACCT.
026880    MOVE MAIL-CHECK-TRANSACTION-NO OF TPS-MAIL-REC TO
026880                                      CHECK-TRANSACTION-NO.
                  
007400    MOVE F-PRIME TO FILE-KEY.
007500    MOVE F-START TO FILE-ACTION.
007600    CALL TPSIOCHK USING FILE-REQUEST TPS-CHECK-REC.
007700    IF NO-RECORD-WAS-FOUND
009216       GO TO READ-NEXT-RECORD.
007800    IF NOT A-SUCCESSFUL-OPERATION
007900       MOVE ' CHECK' TO FILE-NAME
008000       MOVE 'DONLTR-SBR' TO FILE-TEXT
008100       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
008200       GO TO EXIT-PROGRAM.
008300 READ-ALL-CHECK-NUMBERS.
008400    MOVE F-PRIME TO FILE-KEY.
008500    MOVE F-READ-NEXT TO FILE-ACTION.
008600    CALL TPSIOCHK USING FILE-REQUEST TPS-CHECK-REC.
008700    IF END-OF-FILE-WAS-REACHED
008700       GO TO READ-NEXT-RECORD.
008800    IF NOT A-SUCCESSFUL-OPERATION
008900       MOVE ' CHECK' TO FILE-NAME
009000       MOVE 'DONLTR-BRN' TO FILE-TEXT
009100       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
009200       GO TO EXIT-PROGRAM.
244500
009215    IF CHECK-ACCT-NO NOT = MAIL-ACCT-NO OF TPS-MAIL-REC
009216       GO TO READ-NEXT-RECORD.
244500
244600    IF CHECK-NUMBER = ZEROS
023300       GO TO READ-NEXT-RECORD.
244500
244600    IF CHECK-DONATION-LETTER = 'Y'
023300       GO TO READ-NEXT-RECORD.
244500
009215    IF CHECK-ACCT-NO = MAIL-ACCT-NO OF TPS-MAIL-REC AND
009216       CHECK-SUB-ACCT = MAIL-SUB-ACCT OF TPS-MAIL-REC AND
009217       CHECK-RECEIVE-DATE = MAIL-RECEIVE-DATE OF TPS-MAIL-REC
009218       AND
009219       CHECK-RECEIVE-NUMBER =
009219                   MAIL-RECEIVE-NUMBER OF TPS-MAIL-REC
009219        CONTINUE
009219    ELSE
009219       GO TO READ-NEXT-RECORD.
009220
009220*ADD RECORD TO TABLE
009230   ADD 1                    TO TBL-IND.
009220
009230   MOVE CHECK-ACCT-NO       TO TBL-ACCT-NO(TBL-IND).
009228   MOVE CHECK-SUB-ACCT      TO TBL-SUB-ACCT(TBL-IND).
005540   MOVE 'C'                 TO TBL-CHK-TYPE(TBL-IND).
005540   MOVE CHECK-DATE          TO TBL-CHK-DATE(TBL-IND).
009288   MOVE CHECK-NUMBER        TO TBL-CHK-NO(TBL-IND).
009289   MOVE CHECK-AMOUNT        TO TBL-CHK-AMT(TBL-IND).
009290   MOVE CHECK-RECEIVE-DATE  TO TBL-RECV-DATE(TBL-IND).
009288   MOVE CHECK-RECEIVE-NUMBER TO TBL-RECV-NO(TBL-IND).
009289   MOVE RECUR-PAYEE-NAME OF TPS-MAIL-REC
009290                            TO TBL-PAYEE-NAME(TBL-IND).
009313   MOVE RECUR-PAYEE-MEMO-FIELD OF TPS-MAIL-REC
009289                            TO TBL-MEMO(TBL-IND).
009290   MOVE CHECK-TRANSACTION-NO
009274                            TO TBL-CHK-TRANSACTION-NO(TBL-IND).
009289   MOVE MAIL-ADDRESEE-NAME OF TPS-MAIL-REC
009290                            TO TBL-ADDRESSEE-NAME(TBL-IND).
009289   MOVE ZEROS               TO TBL-FGN-CHK-AC-NO(TBL-IND)
009290                               TBL-FGN-CHK-TRANS-CODE(TBL-IND)
009362                               TBL-FGN-TIE-BREAKER(TBL-IND).
009290
009219   GO TO READ-NEXT-RECORD.
009220
022700 READ-THE-MAIL-EXIT.
022700
007100
007200 READ-FGN-CHECKS.
005900
005900    MOVE TPS-MAIL-HOLD    TO TPS-MAIL-REC.
022300    MOVE MAIL-ADDRESOR-NAME OF TPS-MAIL-HOLD
022300                            TO FGN-ADDRESOR-NAME.
          CALL TPSVEDIT USING CONVERT-TO-CAPITALS                                          00304700
                              LENGTH-36                                                    00304800
                              FGN-ADDRESOR-NAME.                                           00304900
111400                                                                                     00118300

026880    INITIALIZE FGN-CHECK-REC.
026880    MOVE MAIL-ACCT-NO OF TPS-MAIL-REC TO FGN-CHECK-ACCT-NO.
026880    MOVE MAIL-SUB-ACCT OF TPS-MAIL-REC TO FGN-CHECK-SUB-ACCT.
026880    MOVE 2               TO FGN-CHECK-CHECKING-AC-NO.
021300    MOVE OLD-DATE        TO FGN-CHECK-RECEIVE-DATE.
105700                                                                                     00109900
105800    MOVE F-PRIME TO FILE-KEY.                                                        00110000
105900    MOVE F-START TO FILE-ACTION.                                                     00110100
256500    CALL TPSIO026 USING FILE-REQUEST FGN-CHECK-REC.                                  00285500
106200    IF NOT A-SUCCESSFUL-OPERATION                                                    00110600
260800       GO TO EXIT-PROGRAM                                                            00290800
          END-IF.                                                                          00111100
106700 READ-NEXT-FGNCK-REC.                                                                00111300
259700    MOVE F-PRIME     TO FILE-KEY.                                                    00289700
259800    MOVE F-READ-NEXT TO FILE-ACTION.                                                 00289800
256500    CALL TPSIO026 USING FILE-REQUEST FGN-CHECK-REC.                                  00285500
260400    IF NOT A-SUCCESSFUL-OPERATION                                                    00290400
260800       GO TO EXIT-PROGRAM                                                            00290800
260900      END-IF.                                                                        00290900
106700                                                                                     00111400
108700    IF FGN-CHECK-ACCT-NO NOT = MAIL-ACCT-NO OF TPS-MAIL-HOLD                         00146000
007200       GO TO READ-FGN-CHECKS-EXIT
107900     END-IF.                                                                         00146200
109000    IF FGN-CHECK-SUB-ACCT NOT = MAIL-SUB-ACCT OF TPS-MAIL-HOLD                       00146300
007200       GO TO READ-FGN-CHECKS-EXIT
107900     END-IF.                                                                         00146500
260900                                                                                     00290900
260900*******  IGNORE SPECAIL DEBIT ACCTS FOR SUMMARY                                      00290900
003600    IF FGN-CHECK-CHECKING-AC-NO = 99 AND
004200       FGN-CHECK-RECEIVE-NUMBER = 11111
023100       GO TO READ-NEXT-FGNCK-REC
260900    END-IF.                                                                          00290900
023500
111700    IF FGN-CHECK-DATE < OLD-DATE
108700       GO TO READ-NEXT-FGNCK-REC.
111400                                                                                     00118300
022300    IF FGN-CHECK-PAYEE-NAME(1:1) =
022300                     MAIL-ADDRESOR-NAME OF TPS-MAIL-HOLD(1:1)
             MOVE FGN-CHECK-PAYEE-NAME TO FGN-PAYEE-NAME                                   00304700
             CALL TPSVEDIT USING CONVERT-TO-CAPITALS                                       00304700
                                 LENGTH-36                                                 00304800
                                 FGN-PAYEE-NAME                                            00304900
023000    ELSE
023100       GO TO READ-NEXT-FGNCK-REC.
111400                                                                                     00118300
022300    IF FGN-PAYEE-NAME = FGN-ADDRESOR-NAME
022500        CONTINUE
023000    ELSE
023100       GO TO READ-NEXT-FGNCK-REC.
026880
023000    IF FGN-CHART-ACCT-01(1:2) = 02 AND
023000       FGN-CHART-ACCT-02(1:6) = 000002 AND
023000       FGN-CHECK-AMOUNT > ZERO
023100        CONTINUE
023200    ELSE
023300       GO TO READ-NEXT-FGNCK-REC.
023500
111700    IF FGN-CHECK-REGULAR AND FGN-CHECK-AMOUNT > ZERO
108700       CONTINUE
111700    ELSE
108700       GO TO READ-NEXT-FGNCK-REC.
023500
111700    IF FGN-DONATION-LETTER = 'Y'
108700       GO TO READ-NEXT-FGNCK-REC.
108800
009220*ADD RECORD TO TABLE
009230    ADD 1                    TO TBL-IND.
009220
106700    MOVE FGN-CHECK-ACCT-NO   TO TBL-ACCT-NO(TBL-IND).
106700    MOVE FGN-CHECK-SUB-ACCT  TO TBL-SUB-ACCT(TBL-IND).
005540    MOVE 'F'                 TO TBL-CHK-TYPE(TBL-IND).
106700    MOVE FGN-CHECK-DATE      TO TBL-CHK-DATE(TBL-IND).
106700    MOVE FGN-CHECK-NUMBER    TO TBL-CHK-NO(TBL-IND).
108700    MOVE FGN-CHECK-AMOUNT    TO TBL-CHK-AMT(TBL-IND).
108800    MOVE FGN-CHECK-RECEIVE-DATE TO TBL-RECV-DATE(TBL-IND).
107900    MOVE FGN-CHECK-RECEIVE-NUMBER  TO TBL-RECV-NO(TBL-IND).
111700    MOVE FGN-CHECK-PAYEE-NAME TO TBL-PAYEE-NAME(TBL-IND).
111700    MOVE FGN-CHECK-MEMO-FIELD TO TBL-MEMO(TBL-IND).
009290    MOVE ZEROS              TO TBL-CHK-TRANSACTION-NO(TBL-IND).
009289    MOVE FGN-CHECK-CHECKING-AC-NO TO TBL-FGN-CHK-AC-NO(TBL-IND).
009290    MOVE FGN-CHECK-TRANSACTION-CODE
009290                            TO TBL-FGN-CHK-TRANS-CODE(TBL-IND).
009362    MOVE FGN-CHECK-TIE-BREAKER
009362                            TO TBL-FGN-TIE-BREAKER(TBL-IND).

          GO TO READ-NEXT-FGNCK-REC.
108800
007200 READ-FGN-CHECKS-EXIT.   EXIT.
009229
006500 DISPLAY-THE-RECORDS.
506600
506600   PERFORM VARYING CLR-IND FROM 1 BY 1
506600                   UNTIL CLR-IND = 16
047400       MOVE ZEROS      TO DON-CHK-NO(CLR-IND)
047500                          DON-CHK-AMT(CLR-IND)
047300       MOVE SPACES     TO DON-CHK-DATE(CLR-IND)
047600                          DON-CHK-RECV-DATE(CLR-IND)
047600                          DON-CHK-PAYEE(CLR-IND)
047800                          DON-CHK-MEMO(CLR-IND)
535300   END-PERFORM.
006500
219400    PERFORM VARYING DISP-IND FROM 1 BY 1
219500              UNTIL DISP-IND > TBL-IND OR
219500                    DISP-IND = 16
219600      ADD 1      TO PANEL-IND
219600      MOVE TBL-CHK-DATE(PANEL-IND)(3:2) TO WORK-YY
219600      MOVE TBL-CHK-DATE(PANEL-IND)(5:2) TO WORK-MM
219600      MOVE TBL-CHK-DATE(PANEL-IND)(7:2) TO WORK-DD
219600      MOVE WORK-DATE               TO DON-CHK-DATE(DISP-IND)
219700      MOVE TBL-CHK-NO(PANEL-IND)   TO DON-CHK-NO(DISP-IND)
219700      MOVE TBL-CHK-AMT(PANEL-IND)  TO DON-CHK-AMT(DISP-IND)
219600      MOVE TBL-RECV-DATE(PANEL-IND)(3:2) TO WORK-YY
219600      MOVE TBL-RECV-DATE(PANEL-IND)(5:2) TO WORK-MM
219600      MOVE TBL-RECV-DATE(PANEL-IND)(7:2) TO WORK-DD
219600      MOVE WORK-DATE             TO DON-CHK-RECV-DATE(DISP-IND)
219800      MOVE TBL-PAYEE-NAME(PANEL-IND) TO DON-CHK-PAYEE(DISP-IND)
219800      MOVE TBL-MEMO(PANEL-IND)   TO DON-CHK-MEMO(DISP-IND)
219800      IF TBL-CHK-TYPE(PANEL-IND) = 'F'
156000         COMPUTE FLD-IND = 6 * DISP-IND - 1                                          00165300
156000         MOVE 079       TO DONLETR1-FIELD-COLOR(FLD-IND)                             00165300
219800      END-IF
219900    END-PERFORM.
219900
535300 DISPLAY-DONLETTERS.
535300
506100    CALL GUISCREEN USING DONLETR1-1
506200                      DONLETR1-2
506300                      DONLETR1-3
506400                      DONLETR1-4.
506600
506500    MOVE DONLETR1-EVENT-ID   TO EXIT-KEY-NAMES.
535300
535500    IF THEY-HIT-END
535600       GO TO EXIT-PROGRAM.
506600
535200    IF THEY-HIT-PAGE-DOWN
535300       GO TO DISPLAY-NEXT-PAGE.
535400
535200    IF THEY-HIT-PAGE-UP
535300       GO TO DISPLAY-PREVIOUS-PAGE.
535300
535500    IF THEY-HIT-ENTER AND DON-CHK-SELECTED = ZERO
535600       GO TO EXIT-PROGRAM.
535300
535700    IF THEY-HIT-ENTER
533600       GO TO DISPLAY-SELECTED-RECORD.
533600*
506700*   MOVE ZERO              TO TPS1010T-DISPLAY-OPTION.
506800*   MOVE SPACES            TO TPS1010T-MENU-MSG
506900*                             TPS1010T-MENU-LINE.
006600*   ADD 1              TO DISP-IND.
006500    GO TO DISPLAY-THE-RECORDS.
006600
006600 DISPLAY-THE-RECORDS-EXIT.  EXIT.
009229
006500 DISPLAY-NEXT-PAGE.
506600
535200    IF TBL-IND > PANEL-IND
506600       PERFORM VARYING CLR-IND FROM 1 BY 1
506600                       UNTIL CLR-IND = 16
047400       MOVE ZEROS      TO DON-CHK-NO(CLR-IND)
047500                          DON-CHK-AMT(CLR-IND)
047300       MOVE SPACES     TO DON-CHK-DATE(CLR-IND)
047600                          DON-CHK-RECV-DATE(CLR-IND)
047600                          DON-CHK-PAYEE(CLR-IND)
047800                          DON-CHK-MEMO(CLR-IND)
535300       END-PERFORM
506600       MOVE PANEL-IND   TO CUR-IND
535200    ELSE
535300       MOVE 'NO MORE RECORDS TO DISPLAY ' TO 
535300                                   DONLETR1-MESSAGE-TEXT
535300       GO TO DISPLAY-DONLETTERS.
006500
219500    MOVE ZERO    TO DISP-IND.
219500
219400 READ-NEXT-TABLE-REC.
219500
219500    ADD 1        TO DISP-IND
219500    IF DISP-IND = 16
219500       GO TO DISPLAY-NEXT-PAGE-EXIT.
219500
219500    ADD 1        TO PANEL-IND.
219500    IF PANEL-IND > TBL-IND
219500       GO TO DISPLAY-NEXT-PAGE-EXIT.
219500
219600    MOVE TBL-CHK-DATE(PANEL-IND)(3:2) TO WORK-YY.
219600    MOVE TBL-CHK-DATE(PANEL-IND)(5:2) TO WORK-MM.
219600    MOVE TBL-CHK-DATE(PANEL-IND)(7:2) TO WORK-DD.
219600    MOVE WORK-DATE               TO DON-CHK-DATE(DISP-IND).
219700    MOVE TBL-CHK-NO(PANEL-IND)   TO DON-CHK-NO(DISP-IND).
219700    MOVE TBL-CHK-AMT(PANEL-IND)  TO DON-CHK-AMT(DISP-IND).
219600    MOVE TBL-RECV-DATE(PANEL-IND)(3:2) TO WORK-YY.
219600    MOVE TBL-RECV-DATE(PANEL-IND)(5:2) TO WORK-MM.
219600    MOVE TBL-RECV-DATE(PANEL-IND)(7:2) TO WORK-DD.
219600    MOVE WORK-DATE               TO DON-CHK-RECV-DATE(DISP-IND).
219800    MOVE TBL-PAYEE-NAME(PANEL-IND) TO DON-CHK-PAYEE(DISP-IND).
219800    MOVE TBL-MEMO(PANEL-IND)   TO DON-CHK-MEMO(DISP-IND).
219500
219900
219400    GO TO READ-NEXT-TABLE-REC.
219900
006600
006600 DISPLAY-NEXT-PAGE-EXIT.
535300    GO TO DISPLAY-DONLETTERS.
006600 EXIT.
005900
009229
006500 DISPLAY-PREVIOUS-PAGE.
506600
506600    IF DISP-IND = 16
506600       SUBTRACT 15 FROM PANEL-IND
506600    ELSE
506600       SUBTRACT DISP-IND FROM PANEL-IND.
535200    IF PANEL-IND > 1
506600       PERFORM VARYING CLR-IND FROM 1 BY 1
506600                       UNTIL CLR-IND = 16
047400       MOVE ZEROS      TO DON-CHK-NO(CLR-IND)
047500                          DON-CHK-AMT(CLR-IND)
047300       MOVE SPACES     TO DON-CHK-DATE(CLR-IND)
047600                          DON-CHK-RECV-DATE(CLR-IND)
047600                          DON-CHK-PAYEE(CLR-IND)
047800                          DON-CHK-MEMO(CLR-IND)
535300       END-PERFORM
506600       SUBTRACT 15 FROM PANEL-IND
506600       MOVE PANEL-IND   TO CUR-IND
535200    ELSE
535300       MOVE 'NO MORE RECORDS TO DISPLAY ' TO
535300                                      DONLETR1-MESSAGE-TEXT
535300       GO TO DISPLAY-DONLETTERS.
006500
219500    MOVE ZERO    TO DISP-IND.
219500    IF PANEL-IND < 15
219500       MOVE ZERO TO PANEL-IND.
219500
219400 READ-PREVIOUS-TABLE-REC.
219500
219500    ADD 1        TO DISP-IND.
219500    IF DISP-IND > 15
219500       GO TO DISPLAY-PREVIOUS-PAGE-EXIT.
219500
219500    ADD 1        TO PANEL-IND.
219500    IF PANEL-IND > TBL-IND
219500       GO TO DISPLAY-NEXT-PAGE-EXIT.
219500
219600    MOVE TBL-CHK-DATE(PANEL-IND)(3:2) TO WORK-YY.
219600    MOVE TBL-CHK-DATE(PANEL-IND)(5:2) TO WORK-MM.
219600    MOVE TBL-CHK-DATE(PANEL-IND)(7:2) TO WORK-DD.
219600    MOVE WORK-DATE               TO DON-CHK-DATE(DISP-IND).
219700    MOVE TBL-CHK-NO(PANEL-IND)   TO DON-CHK-NO(DISP-IND).
219700    MOVE TBL-CHK-AMT(PANEL-IND)  TO DON-CHK-AMT(DISP-IND).
219600    MOVE TBL-RECV-DATE(PANEL-IND)(3:2) TO WORK-YY.
219600    MOVE TBL-RECV-DATE(PANEL-IND)(5:2) TO WORK-MM.
219600    MOVE TBL-RECV-DATE(PANEL-IND)(7:2) TO WORK-DD.
219600    MOVE WORK-DATE               TO DON-CHK-RECV-DATE(DISP-IND).
219800    MOVE TBL-PAYEE-NAME(PANEL-IND) TO DON-CHK-PAYEE(DISP-IND).
219800    MOVE TBL-MEMO(PANEL-IND)   TO DON-CHK-MEMO(DISP-IND).
219500
219500    GO TO READ-PREVIOUS-TABLE-REC.
219900
219900
006600
006600 DISPLAY-PREVIOUS-PAGE-EXIT.
535300    GO TO DISPLAY-DONLETTERS.
006600 EXIT.
005900
533600 DISPLAY-SELECTED-RECORD.
506600
506600   IF CUR-IND = ZERO
535200      MOVE DON-CHK-SELECTED  TO CUR-IND
535300   ELSE
506600      ADD DON-CHK-SELECTED   TO CUR-IND.
533600
005540   MOVE ZEROS                TO DON-CHK-SELECTED.
005540   MOVE SPACES               TO DONCK-DONLETR-ANSWER.
533600
219600   MOVE TBL-CHK-DATE(CUR-IND)(3:2) TO DONCK-DATE(5:2)
219600   MOVE TBL-CHK-DATE(CUR-IND)(5:2) TO DONCK-DATE(1:2)
219600   MOVE TBL-CHK-DATE(CUR-IND)(7:2) TO DONCK-DATE(3:2)
009288   MOVE TBL-CHK-NO(CUR-IND)         TO DONCK-NUMBER
009289   MOVE TBL-CHK-AMT(CUR-IND)        TO DONCK-AMOUNT
009290   MOVE TBL-PAYEE-NAME(CUR-IND)     TO DONCK-PAYEE-NAME
009289   MOVE TBL-MEMO(CUR-IND)           TO DONCK-MEMO.
009230   IF TBL-CHK-TYPE(CUR-IND) = 'C'
009313      MOVE TBL-ADDRESSEE-NAME(CUR-IND) TO DONCK-PAYOR-NAME
009230   ELSE
009313      MOVE TBL-FGN-CHK-AC-NO(CUR-IND) TO BK-IND
009230      MOVE 'FGN CHECK ACCT # '        TO DONCK-PAYOR-NAME(1:17)
247000      MOVE TBL-BANK-ACCT-NO(BK-IND)   TO DONCK-PAYOR-NAME(18:)
009313   END-IF.
535300
506100   CALL GUISCREEN USING DONCHECK-1
506200                        DONCHECK-2
506300                        DONCHECK-3
506400                        DONCHECK-4.
506600
506500    MOVE DONCHECK-EVENT-ID TO EXIT-KEY-NAMES.
535300
506600    IF DONCK-DONLETR-ANSWER = 'Y'
535300       GO TO UPDATE-RECORD.
506600
535300    GO TO DISPLAY-DONLETTERS.
535400
533600 DISPLAY-SELECTED-RECORD-EXIT.  EXIT.
533600
535400
533600 UPDATE-RECORD.
533600
026880    IF TBL-CHK-TYPE(CUR-IND) = 'F'
026880       GO TO UPDATE-FGNCK-REC.
533600
026880    MOVE TBL-ACCT-NO(CUR-IND)        TO CHECK-ACCT-NO.
026880    MOVE TBL-SUB-ACCT(CUR-IND)       TO CHECK-SUB-ACCT.
026880    MOVE TBL-CHK-TRANSACTION-NO(CUR-IND)
026880                                     TO CHECK-TRANSACTION-NO.

007400    MOVE F-PRIME TO FILE-KEY.
007500    MOVE F-START TO FILE-ACTION.
007600    CALL TPSIOCHK USING FILE-REQUEST TPS-CHECK-REC.
007800    IF NOT A-SUCCESSFUL-OPERATION
007900       MOVE ' CHECK' TO FILE-NAME
008000       MOVE 'DONLTR-STR' TO FILE-TEXT
008100       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
008200       GO TO EXIT-PROGRAM.
008300
008400    MOVE F-PRIME TO FILE-KEY.
008500    MOVE F-READ-NEXT TO FILE-ACTION.
008600    CALL TPSIOCHK USING FILE-REQUEST TPS-CHECK-REC.
008800    IF NOT A-SUCCESSFUL-OPERATION
008900       MOVE ' CHECK' TO FILE-NAME
009000       MOVE 'DONLTR-RNX  ' TO FILE-TEXT
009100       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
009200       GO TO EXIT-PROGRAM.
244500
009215    MOVE 'Y'             TO CHECK-DONATION-LETTER.
008300
008400    MOVE F-PRIME TO FILE-KEY.
008500    MOVE F-REWRITE   TO FILE-ACTION.
008600    CALL TPSIOCHK USING FILE-REQUEST TPS-CHECK-REC.
008800    IF NOT A-SUCCESSFUL-OPERATION
008900       MOVE ' CHECK' TO FILE-NAME
009000       MOVE 'DONLTR-RERITE' TO FILE-TEXT
009100       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
009200       GO TO EXIT-PROGRAM.
533600
533600    GO TO UPDATE-CURRENT-MAIL-RECORD.
244500
533600 UPDATE-FGNCK-REC.
026880
026880    MOVE TBL-ACCT-NO(CUR-IND)     TO FGN-CHECK-ACCT-NO.
026880    MOVE TBL-SUB-ACCT(CUR-IND)    TO FGN-CHECK-SUB-ACCT.
026880    MOVE TBL-FGN-CHK-AC-NO(CUR-IND)
026880                                  TO FGN-CHECK-CHECKING-AC-NO.
106700    MOVE TBL-RECV-DATE(CUR-IND)   TO FGN-CHECK-RECEIVE-DATE.
106700    MOVE TBL-RECV-NO(CUR-IND)     TO FGN-CHECK-RECEIVE-NUMBER.
005540    MOVE TBL-CHK-DATE(CUR-IND)    TO FGN-CHECK-DATE.
106700    MOVE TBL-CHK-NO(CUR-IND)      TO FGN-CHECK-NUMBER.
106700    MOVE TBL-CHK-AMT(CUR-IND)     TO FGN-CHECK-AMOUNT.
108700    MOVE TBL-FGN-CHK-TRANS-CODE(CUR-IND)
108800                                  TO FGN-CHECK-TRANSACTION-CODE.
107900    MOVE TBL-FGN-TIE-BREAKER(CUR-IND)
111700                                  TO FGN-CHECK-TIE-BREAKER.


007400    MOVE F-PRIME TO FILE-KEY.
007500    MOVE F-START TO FILE-ACTION.
256500    CALL TPSIO026 USING FILE-REQUEST FGN-CHECK-REC.
007800    IF NOT A-SUCCESSFUL-OPERATION
007900       MOVE 'FGNCK ' TO FILE-NAME
008000       MOVE 'DONLTR-STR' TO FILE-TEXT
008100       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
008200       GO TO EXIT-PROGRAM.
008300
008400    MOVE F-PRIME TO FILE-KEY.
008500    MOVE F-READ-NEXT TO FILE-ACTION.
256500    CALL TPSIO026 USING FILE-REQUEST FGN-CHECK-REC.
008800    IF NOT A-SUCCESSFUL-OPERATION
008900       MOVE 'FGNCK ' TO FILE-NAME
009000       MOVE 'DONLTR-RNX  ' TO FILE-TEXT
009100       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
009200       GO TO EXIT-PROGRAM.
244500
009215    MOVE 'Y'             TO FGN-DONATION-LETTER.
008300
008400    MOVE F-PRIME TO FILE-KEY.
008500    MOVE F-REWRITE   TO FILE-ACTION.
256500    CALL TPSIO026 USING FILE-REQUEST FGN-CHECK-REC.
008800    IF NOT A-SUCCESSFUL-OPERATION
008900       MOVE 'FGNCK ' TO FILE-NAME
009000       MOVE 'DONLTR-RERITE' TO FILE-TEXT
009100       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
009200       GO TO EXIT-PROGRAM.
244500
533600 UPDATE-CURRENT-MAIL-RECORD.
026880
026880    MOVE TPS-MAIL-HOLD      TO TPS-MAIL-REC.

007400    MOVE F-PRIME TO FILE-KEY.
007500    MOVE F-START TO FILE-ACTION.
007600    CALL TPSIOREC USING FILE-REQUEST TPS-MAIL-REC.
007800    IF NOT A-SUCCESSFUL-OPERATION
007900       MOVE 'RECV  ' TO FILE-NAME
008000       MOVE 'DONLTR-STR' TO FILE-TEXT
008100       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
008200       GO TO EXIT-PROGRAM.
008300
008400    MOVE F-PRIME TO FILE-KEY.
008500    MOVE F-READ-NEXT TO FILE-ACTION.
146800    CALL TPSIOREC USING FILE-REQUEST TPS-MAIL-REC.
008800    IF NOT A-SUCCESSFUL-OPERATION
008900       MOVE 'RECV  ' TO FILE-NAME
009000       MOVE 'DONLTR-RNX  ' TO FILE-TEXT
009100       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
009200       GO TO EXIT-PROGRAM.
244500
026880    MOVE TBL-CHK-TYPE(CUR-IND) TO
026880                     MAIL-DONATION-TYPE OF TPS-MAIL-REC.
009215    MOVE TBL-CHK-NO(CUR-IND) TO
026880                     MAIL-DONATION-CHECK-NO OF TPS-MAIL-REC.
009215    MOVE TBL-CHK-DATE(CUR-IND)(3:6) TO
026880                     MAIL-DONATION-CHECK-DATE OF TPS-MAIL-REC.
008300
008400    MOVE F-PRIME TO FILE-KEY.
008500    MOVE F-REWRITE   TO FILE-ACTION.
008600    CALL TPSIOREC USING FILE-REQUEST TPS-MAIL-REC.
008800    IF NOT A-SUCCESSFUL-OPERATION
008900       MOVE 'RECV  ' TO FILE-NAME
009000       MOVE 'DONLTR-RERITE' TO FILE-TEXT
009100       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
009200       GO TO EXIT-PROGRAM.
506600
535300    GO TO EXIT-PROGRAM.
244500
533600 UPDATE-RECORD-EXIT.   EXIT.
533600
242500                                                                                     00094500
242600 LOAD-BANK-DATA.                                                                     00094600
243200                                                                                     00095100
243300    MOVE MAIL-ACCT-NO OF TPS-MAIL-HOLD  TO CHECKING-ACCT-NO                        2300095200
243400    MOVE MAIL-SUB-ACCT OF TPS-MAIL-HOLD TO CHECKING-SUB-ACCT.                      2300095300
243500    MOVE '01'                      TO CHECKING-RECORD-NUMBER.                      2300095400
243200                                                                                     00095500
048100    MOVE F-PRIME TO FILE-KEY.                                                        00096700
048200    MOVE F-START  TO FILE-ACTION.                                                    00096800
047300    CALL TPSIO025 USING FILE-REQUEST TPS-CKING-REC.                                  00096900
048400    IF NOT A-SUCCESSFUL-OPERATION                                                    00097000
048500       MOVE ' CKING  ' TO FILE-NAME                                                  00097100
048600       MOVE 'DONLTR-STR' TO FILE-TEXT                                                00097200
048700       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                       00097300
009200       GO TO EXIT-PROGRAM
243900     END-IF.                                                                         00097500
243700                                                                                     00097600
047000    MOVE ZEROS           TO BK-IND.                                                  00097700
243700                                                                                     00097800
243800 READ-NEXT-BANK-REC.                                                                 00097900
048100    MOVE F-PRIME TO FILE-KEY.                                                        00098000
048200    MOVE F-READ-NEXT  TO FILE-ACTION.                                                00098200
047300    CALL TPSIO025 USING FILE-REQUEST TPS-CKING-REC.                                  00098300
049400    IF END-OF-FILE-WAS-REACHED                                                       00098700
009200       GO TO LOAD-BANK-DATA-EXIT
244400     END-IF.                                                                       2400098900
048400    IF NOT A-SUCCESSFUL-OPERATION                                                    00099000
048500       MOVE ' CKING  ' TO FILE-NAME                                                  00099100
048600       MOVE 'DONLTR-STR' TO FILE-TEXT                                                00099200
048700       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                       00099300
009200       GO TO LOAD-BANK-DATA-EXIT
243900     END-IF.                                                                         00099500
244100                                                                                     00099600
244200    IF MAIL-ACCT-NO OF TPS-MAIL-HOLD NOT = CHECKING-ACCT-NO                        2400099700
244300       GO TO LOAD-BANK-DATA-EXIT                                                   2400099800
244400    END-IF.                                                                        2400099900
244500                                                                                     00100000
244600    IF CHECKING-ADD-DATE(1:1) = '8' OR '9'                                           00100100
244800       GO TO READ-NEXT-BANK-REC                                                      00100300
244900    END-IF.                                                                          00100400
245000                                                                                     00100500
245500                                                                                     00101000
245600    ADD 1 TO BK-IND.                                                                 00101100
246300    MOVE CHECKING-RECORD-NUMBER      TO TBL-BANK-NO(BK-IND).                         00101200
246700    MOVE CHECKING-ACCOUNT-BANK-NAME  TO TBL-BANK-NAME(BK-IND).                       00101600
247000    MOVE CHECKING-ACCOUNT-ACCOUNT-NUMB                                               00101900
247000                                   TO TBL-BANK-ACCT-NO(BK-IND).                      00101900
247300    MOVE CHECKING-ACCOUNT-ACCOUNT-NAME                                               00102200
247000                                 TO TBL-BANK-ACCT-NAME(BK-IND).                      00101900
248800                                                                                     00103000
244800    GO TO READ-NEXT-BANK-REC.                                                        00100300
249000                                                                                     00103200
005900 LOAD-BANK-DATA-EXIT. EXIT.
009360
012300
012400
012500 FILE-ERROR.
012600     CALL TPSIOERR USING FILE-REQUEST.
012700     CANCEL TPSIOERR.
012800 FILE-ERROR-EXIT. EXIT.
012900
013000
013100 OPEN-THE-FILES.
013200
013300
          MOVE F-PRIME    TO FILE-KEY.
013400    MOVE F-OPEN-I-O TO FILE-ACTION.
013500    CALL TPSIOCHK USING FILE-REQUEST TPS-CHECK-REC.
013600    IF FILE-IS-ALREADY-OPEN
013700       CONTINUE
013700    ELSE
013600    IF FILE-STATUS NOT = '00'
013700       MOVE 'CHECK ' TO FILE-NAME
013800       MOVE 'DONLETTR-OPN' TO FILE-TEXT
013900       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
014000       GO TO EXIT-PROGRAM.
265500    CALL TPSIO026 USING FILE-REQUEST FGN-CHECK-REC.
458100    IF NOT A-SUCCESSFUL-OPERATION
265700       MOVE ' FGNCK  '   TO FILE-NAME
265800       MOVE 'DONLETTR-OPN' TO FILE-TEXT
265900       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
014080       GO TO EXIT-PROGRAM.
047300    CALL TPSIO025 USING FILE-REQUEST TPS-CKING-REC.                                  00095900
047400    IF FILE-STATUS NOT = '00'                                                        00096000
047500       MOVE ' CKING  ' TO FILE-NAME                                                  00096100
047600       MOVE 'DONLTR-OPN' TO FILE-TEXT                                                00096200
047700       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                       00096300
009200       GO TO EXIT-PROGRAM.
266100
014100 OPEN-THE-FILES-EXIT. EXIT.

       EXIT-PROGRAM.

014200 CLOSE-THE-FILES.
014300
014400      MOVE F-PRIME TO FILE-KEY.
014500      MOVE F-CLOSE TO FILE-ACTION.
014600
014700      CALL TPSIOCHK USING FILE-REQUEST TPS-CHECK-REC.
014800      IF NOT A-SUCCESSFUL-OPERATION
014900         MOVE 'CHECK ' TO FILE-NAME
015000         MOVE 'SEECHECK-CLO' TO FILE-TEXT
015100         PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
015200      END-IF.
015300
265500    CALL TPSIO026 USING FILE-REQUEST FGN-CHECK-REC.
458100    IF NOT A-SUCCESSFUL-OPERATION
265700       MOVE ' FGNCK  '   TO FILE-NAME
265800       MOVE 'DONLETTR-CLO' TO FILE-TEXT
265900       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
014080    END-IF.
266100
047300    CALL TPSIO025 USING FILE-REQUEST TPS-CKING-REC.                                  00095900
047400    IF FILE-STATUS NOT = '00'                                                        00096000
047500       MOVE ' CKING  ' TO FILE-NAME                                                  00096100
047600       MOVE 'DONLTR-CLO' TO FILE-TEXT                                                00096200
047700       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                       00096300
009200    END-IF.
                                                                                           00096500
015400 CLOSE-THE-FILES-EXIT. EXIT.
015500
015500    CANCEL TPSIOCHK.
015500    CANCEL TPSIO025.
015500    CANCEL TPSIO026.
015500
015500    GOBACK.
000100                                                                                                                    
000100                                                                                                                    
000100                                                                                                                    
000000                                                                                                                  
