      ******************************************************************
      *                        cvtmoney                                *
      *                                                                *
      *    converts a numeric money amount into one or more text       *
      *    lines for printing on wire transfer request letters.        *
      *       (up to $999,999,999,999,999.99 can be converted)         *                                                  
      *                                                                *
      ******************************************************************
       identification division.
       program-id.    cvtmoney.                                                                                           
       environment division.
       configuration section.
       data division.
       
       working-storage section.
       77  ws-amount                   pic s9(15)v9(02) comp value 0.
       
       01  money-work-area.
           03  mw-amount               pic  9(15)v9(02).
           03  mw-amount-r             redefines mw-amount.
               05  mw-amount-dollars       pic  9(15).
               05  mw-amount-dollars-r     redefines mw-amount-dollars.
                   07  mw-amount-trillions     pic  9(03).
                   07  mw-amount-billions      pic  9(03).
                   07  mw-amount-millions      pic  9(03).
                   07  mw-amount-thousands     pic  9(03).
                   07  mw-amount-ones          pic  9(03).
               05  mw-amount-cents         pic  9(02).
       
           03  mw-work                 pic  9(03).
           03  mw-work-r1              redefines mw-work.
               05  mw-work-hundreds        pic  9(01).
               05  mw-work-tens            pic  9(01).
               05  mw-work-ones            pic  9(01).
           03  mw-work-r2              redefines mw-work.
               05      filler              pic  9(01).
               05  mw-work-teens           pic  9(02).
       
      ***  78  mw-mclim                value 50.
           78  mw-mclim                value 70.
           03  mw-money.
               05  mw-money-char       pic  x(01)
                                           occurs mw-mclim times.
           03  mw-mcx                  pic  9(02)       comp value 0.
       
      ***  78  mw-mllim                value 6.
           78  mw-mllim                value 2.
           03  mw-money-lines.
               05  mw-money-line       pic  x(mw-mclim)
                                           occurs mw-mllim times.
           03  mw-mlx                  pic  9(02)       comp value 0.
       
           03  mw-word-text.
               05  mw-word-size        pic  9(01).
               05  mw-word.
                   07  mw-word-char    pic  x(01)
                                           occurs 9 times.
           03  mw-wcx                  pic  9(02)       comp value 0.
       
           03  mw-ix1                  pic  9(02)       comp value 0.
           03  mw-ix2                  pic  9(02)       comp value 0.
       
       
           03  mw-ones-values.
               05      filler  pic  x(10)      value "3One      ".
               05      filler  pic  x(10)      value "3Two      ".
               05      filler  pic  x(10)      value "5Three    ".
               05      filler  pic  x(10)      value "4Four     ".
               05      filler  pic  x(10)      value "4Five     ".
               05      filler  pic  x(10)      value "3Six      ".
               05      filler  pic  x(10)      value "5Seven    ".
               05      filler  pic  x(10)      value "5Eight    ".
               05      filler  pic  x(10)      value "4Nine     ".
               05      filler  pic  x(10)      value "3Ten      ".
               05      filler  pic  x(10)      value "6Eleven   ".
               05      filler  pic  x(10)      value "6Twelve   ".
               05      filler  pic  x(10)      value "8Thirteen ".
               05      filler  pic  x(10)      value "8Fourteen ".
               05      filler  pic  x(10)      value "7Fifteen  ".
               05      filler  pic  x(10)      value "7Sixteen  ".
               05      filler  pic  x(10)      value "9Seventeen".
               05      filler  pic  x(10)      value "8Eighteen ".
               05      filler  pic  x(10)      value "8Nineteen ".
       
           03  mw-ones-value           redefines mw-ones-values
                                           pic  x(10)
                                           occurs 19 times.
       
       
           03  mw-tens-values.
               05      filler  pic  x(08)      value "3Ten    ".
               05      filler  pic  x(08)      value "6Twenty ".
               05      filler  pic  x(08)      value "6Thirty ".
               05      filler  pic  x(08)      value "5Forty  ".
               05      filler  pic  x(08)      value "5Fifty  ".
               05      filler  pic  x(08)      value "5Sixty  ".
               05      filler  pic  x(08)      value "7Seventy".
               05      filler  pic  x(08)      value "6Eighty ".
               05      filler  pic  x(08)      value "6Ninety ".
       
           03  mw-tens-value           redefines mw-tens-values
                                           pic  x(08)
                                           occurs  9 times.
       linkage section.                                                                                                   
       01 link-amounts.                                                                                                   
          05 link-amount-numeric           pic s9(15)v9(02).                                                              
          05 link-amount-english           pic  x(140).                                                                   
       
       procedure division using link-amounts.
       
       cvtmoney-begin.
           if link-amount-numeric not > 0                                                                                 
              go to cvtmoney-common-exit                                                                                  
            end-if.                                                                                                       
                                                                                                                          
           move link-amount-numeric        to ws-amount                                                                   
                                              mw-amount.                                                                  
                                                                                                                          
       
           perform 001000-money thru
                   001000-exit.
           move mw-money-lines(1:140)                                                                                     
                               to link-amount-english.                                                                    
           go to cvtmoney-common-exit.                                                                                    
       
       
       
       
       001000-money.
           move spaces to mw-money.
           move 1      to mw-mcx.
           move spaces to mw-money-lines.                                                                                 
           move 1      to mw-mlx.
       
           if (mw-amount-trillions not zero)
               move mw-amount-trillions to mw-work
               perform 001100-three-digits
                  thru 001100-exit
               move "8Trillion" to mw-word-text
               perform 001400-move-word
                  thru 001400-exit.
       
           if (mw-amount-billions not zero)
               move mw-amount-billions to mw-work
               perform 001100-three-digits
                  thru 001100-exit
               move "7Billion"  to mw-word-text
               perform 001400-move-word
                  thru 001400-exit.
       
           if (mw-amount-millions not zero)
               move mw-amount-millions to mw-work
               perform 001100-three-digits
                  thru 001100-exit
               move "7Million"  to mw-word-text
               perform 001400-move-word
                  thru 001400-exit.
       
           if (mw-amount-thousands not zero)
               move mw-amount-thousands to mw-work
               perform 001100-three-digits
                  thru 001100-exit
               move "8Thousand" to mw-word-text
               perform 001400-move-word
                  thru 001400-exit.
       
           if (mw-amount-ones not zero)
               move mw-amount-ones  to mw-work
               perform 001100-three-digits
                  thru 001100-exit.
       
           if (mw-amount-dollars zero)
               move "2No"           to mw-word-text
               perform 001400-move-word
                  thru 001400-exit.
       
           if (mw-amount-dollars = 1)
               move "6Dollar"  to mw-word-text
           else
               move "7Dollars" to mw-word-text.
           perform 001400-move-word
              thru 001400-exit.
       
           move "3and"         to mw-word-text.
           perform 001400-move-word
              thru 001400-exit.
       
           if (mw-amount-cents = 0)
               move "2No"           to mw-word-text
               perform 001400-move-word
                  thru 001400-exit
           else
               move mw-amount-cents to mw-work
               perform 001200-two-digits
                  thru 001200-exit.
       
           if (mw-amount-cents = 1)
               move "6Cent**"  to mw-word-text
           else
               move "7Cents**" to mw-word-text.
           perform 001400-move-word
              thru 001400-exit.
       
      **** compute mw-ix1 = (mw-mclim - mw-mcx) / 2 + 1 .   xxxx
           compute mw-ix1 = 1 .                                                                                           
           string mw-money delimited by size
               into mw-money-line(mw-mlx)
                   with pointer mw-ix1.
       
       001000-exit. exit.
       
      *
      *             c o n v e r t   t h r e e   d i g i t s
      *
       001100-three-digits.
           if (mw-work-hundreds > 0)
               move mw-ones-value(mw-work-hundreds) to mw-word-text
               perform 001400-move-word
                  thru 001400-exit
               move "7Hundred" to mw-word-text
               perform 001400-move-word
                  thru 001400-exit.
       
           perform 001200-two-digits
              thru 001200-exit.
       
       001100-exit. exit.
       
      *
      *               c o n v e r t   t w o   d i g i t s
      *
       001200-two-digits.
           if (mw-work-teens > 0)
               if (mw-work-teens < 20)
                   move mw-ones-value(mw-work-teens) to mw-word-text
                   perform 001400-move-word
                      thru 001400-exit
               else
                   perform 001300-tens-ones
                      thru 001300-exit.
       001200-exit. exit.
       
      *
      *                c o n v e r t   t e n s / o n e s
      *
       001300-tens-ones.
           if (mw-work-tens > 0)
               move mw-tens-value(mw-work-tens) to mw-word-text
               perform 001400-move-word
                  thru 001400-exit.
       
           if (mw-work-ones > 0)
               move mw-ones-value(mw-work-ones) to mw-word-text
               perform 001400-move-word
                  thru 001400-exit.
       001300-exit. exit.
       
      *
      *                 m o v e   i n   n e w   w o r d
      *
       001400-move-word.
           compute mw-ix2 = mw-mcx + mw-word-size + 3 .
           if (mw-ix2 > mw-mclim)
               string "**" delimited by size
                   into mw-money
                       with pointer mw-mcx
               compute mw-ix1 = (mw-mclim - mw-mcx) / 2 + 1
               string mw-money delimited by size
                   into mw-money-line(mw-mlx)
                       with pointer mw-ix1
               add  1      to mw-mlx
               move spaces to mw-money
               move 1      to mw-mcx.
       
           if (mw-mcx = 1)
               string "**" delimited by size
                   into mw-money pointer mw-mcx
           else
               add  1      to mw-mcx.
       
           string mw-word delimited by space
               into mw-money
                   with pointer mw-mcx.
       
       001400-exit.                                                                                                       
              exit.                                                                                                       
                                                                                                                          
                                                                                                                          
       cvtmoney-common-exit.
           goback.                                                                                                        
                                                                                                                          
                                                                                                                          
                                                                                                                          
