       IDENTIFICATION DIVISION.
       PROGRAM-ID. TPSIORCD.
      ******************************************************************
      *   * THIS PROGRAM PERFORMS I/O TO THE new   RECEIVE FILE *      *
      *     EVERYTHING REMAINS THE SAME AS TPSIOREC PROGRAM EXCEPT     *
      *     THE ENVIRONMENT VARIABLE IS 'TPSRECVOLD2FILE' CALLING      *
      *     THE 'RECVOLD2.DAT' FILE.                                   *
      *   02/11/12                                                     *
      ******************************************************************
       ENVIRONMENT DIVISION.
       CONFIGURATION SECTION.
       SOURCE-COMPUTER. IBM-PC.
       OBJECT-COMPUTER. IBM-PC.
       SPECIAL-NAMES.
       INPUT-OUTPUT SECTION.
       FILE-CONTROL.
           SELECT RECEIVE-FILE ASSIGN TO DYNAMIC  FILESPEC
               ORGANIZATION IS INDEXED
               LOCK MODE IS AUTOMATIC
               ACCESS MODE IS DYNAMIC
               RECORD KEY IS MAIL-KEY OF FS
               FILE STATUS IS FILE-STATUS-LOCAL.
       DATA DIVISION.
       FILE SECTION.
       FD  RECEIVE-FILE
               LABEL RECORDS STANDARD.
       01  FS.
           COPY "TPSMAIL.CPY".

       WORKING-STORAGE SECTION.

       01  FILESPEC                    PIC X(28) VALUE 
           '\tps\prod\files\recvold2.dat'.
       01  TPSIOERR                    PIC X(08) VALUE 'TPSIOERR'.
       01  TPSIORCV                    PIC X(08) VALUE 'TPSIORCV'.
       01  FILE-STATUS-LOCAL           PIC XX VALUE ZERO.
       01  OPENED-FLAG                 PIC X.
       01  OLD-DATE                    PIC 9(08) VALUE 20000101.
      *
      *
      *%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
       LINKAGE SECTION.
      *
               COPY TPSFILES.CPY.
       01 LS.
               COPY "TPSMAIL.CPY".
      *%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
       PROCEDURE DIVISION USING FILE-REQUEST LS.
      *%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
      *
       0001-STARTUP.
      *                         :---------------------------------------
      * ------------------------: Load the keys, initialize variables.
      *                         :---------------------------------------
      *
      ******READ THE VALUE OF ENVIRONMENT NAME "TPSRECVOLDFILE"
           IF FILESPEC = SPACES
            DISPLAY "TPSRECVOLD2FILE" UPON ENVIRONMENT-NAME
            ACCEPT FILESPEC FROM ENVIRONMENT-VALUE.
           MOVE '\TPS\PROD\FILES\RECVNEW.DAT' TO FILESPEC.
           MOVE '00' TO FILE-STATUS-LOCAL FILE-STATUS.
      *
      *                         :---------------------------------------
      * ------------------------: Perform the requested operation.
      *                         :---------------------------------------
      *
           IF FR-START-LOW
              GO TO 0016-FR-START-LOW.
      *
           GO TO
               0003-FR-OPEN-INPUT
               0004-FR-OPEN-I-O
               0005-FR-CLOSE
               0006-FR-WRITE
               0007-FR-REWRITE
               0008-FR-DELETE
               0009-FR-START
               0009-FR-START
               0010-FR-START-HIGH
               0010-FR-START-HIGH
               0011-FR-READ
               0012-FR-READ-NEXT
               0013-FR-READ-PREVIOUS
               DEPENDING
               ON FILE-ACTION.
      * -====-
       0002-FR-CREATE.
      *                         :---------------------------------------
      * ------------------------: Create the file by open output.
      *                         : the first attempt you get return '05'
      *                         :---------------------------------------
      *
           IF FR-CREATE
             OPEN OUTPUT RECEIVE-FILE.
      *
           GO TO 0017-RETURN.
      * -====-
       0003-FR-OPEN-INPUT.
      *                         :---------------------------------------
      * ------------------------: Open the file INPUT.
      *                         :---------------------------------------
      *
           IF OPENED-FLAG NOT = 'Y'
             OPEN INPUT RECEIVE-FILE
             MOVE 'Y' TO OPENED-FLAG.
      *
           GO TO 0017-RETURN.
      * -====-
       0004-FR-OPEN-I-O.
      *                         :---------------------------------------
      * ------------------------: Open the file I/O and get highest key.
      *                         :---------------------------------------
      *
           IF OPENED-FLAG NOT = 'Y'
             OPEN I-O RECEIVE-FILE
             MOVE 'Y' TO OPENED-FLAG.
      *
           GO TO 0017-RETURN.
      * -====-
       0005-FR-CLOSE.
      *                         :---------------------------------------
      * ------------------------: Close the file.
      *                         :---------------------------------------
      *
           IF OPENED-FLAG = 'Y'
             CLOSE RECEIVE-FILE
             MOVE 'N' TO OPENED-FLAG.
      *
           GO TO 0017-RETURN.
      * -====-
       0006-FR-WRITE.
      *                         :---------------------------------------
      * ------------------------: Write a new record.
      *                         :---------------------------------------
      *
           WRITE FS FROM LS.
      *
           GO TO 0017-RETURN.
      * -====-
       0007-FR-REWRITE.
      *                         :---------------------------------------
      * ------------------------: Rewrite the record.
      *                         :---------------------------------------
      *
           REWRITE FS FROM LS.
      *
           GO TO 0017-RETURN.
      * -====-
       0008-FR-DELETE.
      *                         :---------------------------------------
      * ------------------------: Delete the record.
      *                         :---------------------------------------
      *
           DELETE RECEIVE-FILE RECORD.
      *
           GO TO 0017-RETURN.
      * -====-
       0009-FR-START.
      *                         :---------------------------------------
      * ------------------------: Start with record = or > key.
      *                         :---------------------------------------
      *
           MOVE MAIL-KEY OF LS TO MAIL-KEY OF FS.
           START RECEIVE-FILE KEY NOT LESS THAN MAIL-KEY OF FS.
      *
           GO TO 0017-RETURN.
      * -====-
       0010-FR-START-HIGH.
      *                         :---------------------------------------
      * ------------------------: Start with record = or > key.
      *                         : this is not correct but it has been
      *                         : this way since the beginning.
      *                         :---------------------------------------
      *
             MOVE MAIL-KEY OF LS TO MAIL-KEY OF FS
             START RECEIVE-FILE KEY IS NOT < MAIL-KEY OF FS
      *
           GO TO 0017-RETURN.
      * -====-
       0011-FR-READ.
      *                         :---------------------------------------
      * ------------------------: Read the record directly on prime key.
      *                         : The prime key never allows duplicates.
      *                         :---------------------------------------
      *
           MOVE MAIL-KEY OF LS TO MAIL-KEY OF FS.
           READ RECEIVE-FILE INTO LS.
      *
           GO TO 0017-RETURN.
      * -====-
       0012-FR-READ-NEXT.
      *                         :---------------------------------------
      * ------------------------: Browse (read sequential) the file.
      *                         :---------------------------------------
      *
           READ RECEIVE-FILE
           NEXT RECORD INTO LS
           IGNORE LOCK.
      *
           GO TO 0017-RETURN.
      * -====-
       0013-FR-READ-PREVIOUS.
      *                         :---------------------------------------
      * ------------------------: Browse a file backwards.
      *                         :---------------------------------------
      *
           READ RECEIVE-FILE
               PREVIOUS RECORD INTO LS.
      *
           GO TO 0017-RETURN.
      * -====-
       0016-FR-START-LOW.
      *
      *
           IF FR-PRIME
             MOVE MAIL-KEY OF LS TO MAIL-KEY OF FS
             START RECEIVE-FILE KEY LESS THAN MAIL-KEY OF FS.
      *
           GO TO 0017-RETURN.
      * -====-
      *
       0017-RETURN.
           MOVE FILE-STATUS-LOCAL TO FILE-STATUS.
           GOBACK.
      *
       0018-RETURN.
           GOBACK.
      *
