       IDENTIFICATION DIVISION.
       PROGRAM-ID. TPSIORC3.
      ******************************************************************
      *     THIS PROGRAM PERFORMS I/O TO THE 2ND RECEIVE FILE          *
      *     EVERYTHING REMAINS THE SAME AS TPSIOREC PROGRAM EXCEPT     *
      *     THE ENVIRONMENT VARIABLE IS 'TPSRECVOLD3FILE' CALLING      *
      *     THE 'RECVOLD3.DAT' FILE.                                   *
      *   02/12/12                                                     *
      ******************************************************************
      * 07/13/16 SKIP SEARCH WHEN CALLED FROM PROGRAM TPS3054        JM*
      * 05/24/16 DO START B4 READ PREVIOUS WHEN COMING FROM NEW FILE JM*
      * 05/23/16 FIX SEARCH FOR NEW CLIENTS STARTED AFTER 01/01/16.    *
      * 05/17/16 CHANGE OLD DATE TO 20110101. THE OLD FILE NOW         *
      *    JM    CONTAINS RECORDS TO 20101231.                         *
      * 05/17/16 ADD LOGIC IF SEARCHING FOR CLIENT NOT STARTED IN      *
      *   JM     2010 BUT IN 2011 JUMP TO NEXT RECEIVE FILE. SOME      *
      *          SEARCHES GO BACK 6 MONTHS AND CLIENT IS NOT ACTIVE.   *
      ******************************************************************
       ENVIRONMENT DIVISION.
       CONFIGURATION SECTION.
       SOURCE-COMPUTER. IBM-PC.
       OBJECT-COMPUTER. IBM-PC.
       SPECIAL-NAMES.
       INPUT-OUTPUT SECTION.
       FILE-CONTROL.
           SELECT RECEIVE-FILE ASSIGN TO DYNAMIC  FILESPEC
               ORGANIZATION IS INDEXED
               LOCK MODE IS AUTOMATIC
               ACCESS MODE IS DYNAMIC
               RECORD KEY IS MAIL-KEY OF FS
               FILE STATUS IS FILE-STATUS-LOCAL.
       DATA DIVISION.
       FILE SECTION.
       FD  RECEIVE-FILE
               LABEL RECORDS STANDARD.
       01  FS.
           COPY "TPSMAIL.CPY".

       WORKING-STORAGE SECTION.

       01  FILESPEC                    PIC X(28) VALUE 
           '\tps\prod\files\recvold3.dat'.
       01  TPSIOERR                    PIC X(08) VALUE 'TPSIOERR'.
       01  TPSIORC2                    PIC X(08) VALUE 'TPSIORC2'.
       01  FILE-STATUS-LOCAL           PIC XX VALUE ZERO.
       01  OPENED-FLAG-3               PIC X.
       01  OLD-DATE                    PIC 9(08) VALUE 20110101.
       01  END-DATE                    PIC 9(08) VALUE 20101220.
       01  END-KEY.
           05 END-ACCT-NO              PIC 9(10).
           05 END-SUB-ACCT             PIC 9(02).
      *
      *
      *%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
       LINKAGE SECTION.
      *
               COPY TPSFILES.CPY.
       01 LS.
               COPY "TPSMAIL.CPY".
      *%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
       PROCEDURE DIVISION USING FILE-REQUEST LS.
      *%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
      *
       0001-STARTUP.
      *                         :---------------------------------------
      * ------------------------: Load the keys, initialize variables.
      *                         :---------------------------------------
      *
      ******READ THE VALUE OF ENVIRONMENT NAME "TPSRECVOLDFILE"
           IF FILESPEC = SPACES
            DISPLAY "TPSRECVOLD3FILE" UPON ENVIRONMENT-NAME
            ACCEPT FILESPEC FROM ENVIRONMENT-VALUE.
      *    MOVE '\TPS\PROD\FILES\RECVNEW.DAT' TO FILESPEC.
      *    MOVE '00' TO FILE-STATUS-LOCAL FILE-STATUS.
      *
      *                         :---------------------------------------
      * ------------------------: Perform the requested operation.
      *                         :---------------------------------------
      *
           IF FR-START-LOW
              GO TO 0016-FR-START-LOW.
      *
           GO TO
               0003-FR-OPEN-INPUT
               0004-FR-OPEN-I-O
               0005-FR-CLOSE
               0006-FR-WRITE
               0007-FR-REWRITE
               0008-FR-DELETE
               0009-FR-START
               0009-FR-START
               0010-FR-START-HIGH
               0010-FR-START-HIGH
               0011-FR-READ
               0012-FR-READ-NEXT
               0013-FR-READ-PREVIOUS
               DEPENDING
               ON FILE-ACTION.
      * -====-
       0002-FR-CREATE.
      *                         :---------------------------------------
      * ------------------------: Create the file by open output.
      *                         : the first attempt you get return '05'
      *                         :---------------------------------------
      *
           IF FR-CREATE
             OPEN OUTPUT RECEIVE-FILE.
      *
           GO TO 0017-RETURN.
      * -====-
       0003-FR-OPEN-INPUT.
      *                         :---------------------------------------
      * ------------------------: Open the file INPUT.
      *                         :---------------------------------------
      *
           IF OPENED-FLAG-3 NOT = 'Y'
             OPEN INPUT RECEIVE-FILE
             MOVE 'Y' TO OPENED-FLAG-3.
      *
           GO TO 0017-RETURN.
      * -====-
       0004-FR-OPEN-I-O.
      *                         :---------------------------------------
      * ------------------------: Open the file I/O and get highest key.
      *                         :---------------------------------------
      *
           IF OPENED-FLAG-3 NOT = 'Y'
             OPEN I-O RECEIVE-FILE
             MOVE 'Y' TO OPENED-FLAG-3.
      *
           GO TO 0017-RETURN.
      * -====-
       0005-FR-CLOSE.
      *                         :---------------------------------------
      * ------------------------: Close the file.
      *                         :---------------------------------------
      *
           IF OPENED-FLAG-3 = 'Y'
             CLOSE RECEIVE-FILE
             MOVE 'N' TO OPENED-FLAG-3.
      *
           GO TO 0017-RETURN.
      * -====-
       0006-FR-WRITE.
      *                         :---------------------------------------
      * ------------------------: Write a new record.
      *                         :---------------------------------------
      *01/11/12 **** IF OLD RECORD USE THE OLD RECEIVE FILE *****
           IF MAIL-RECEIVE-DATE OF LS < OLD-DATE
              CALL TPSIORC2 USING FILE-REQUEST LS
              GO TO 0018-RETURN.
      *
           WRITE FS FROM LS.
      *
           GO TO 0017-RETURN.
      * -====-
       0007-FR-REWRITE.
      *                         :---------------------------------------
      * ------------------------: Rewrite the record.
      *                         :---------------------------------------
      *01/11/12 **** IF OLD RECORD USE THE OLD RECEIVE FILE *****
           IF MAIL-RECEIVE-DATE OF LS < OLD-DATE
              CALL TPSIORC2 USING FILE-REQUEST LS
              GO TO 0018-RETURN.
      *
           REWRITE FS FROM LS.
      *
           GO TO 0017-RETURN.
      * -====-
       0008-FR-DELETE.
      *                         :---------------------------------------
      * ------------------------: Delete the record.
      *                         :---------------------------------------
      *01/11/12 **** IF OLD RECORD USE THE OLD RECEIVE FILE *****
           IF MAIL-RECEIVE-DATE OF LS < OLD-DATE
              CALL TPSIORC2 USING FILE-REQUEST LS
              GO TO 0018-RETURN.
      *
           DELETE RECEIVE-FILE RECORD.
      *
           GO TO 0017-RETURN.
      * -====-
       0009-FR-START.
      *                         :---------------------------------------
      * ------------------------: Start with record = or > key.
      *                         :---------------------------------------
      *01/11/12 **** IF OLD RECORD USE THE OLD RECEIVE FILE *****
           IF MAIL-RECEIVE-DATE OF LS < OLD-DATE
              CALL TPSIORC2 USING FILE-REQUEST LS
              GO TO 0018-RETURN.
      *
           MOVE MAIL-KEY OF LS TO MAIL-KEY OF FS.
           START RECEIVE-FILE KEY NOT LESS THAN MAIL-KEY OF FS.
      *
           GO TO 0017-RETURN.
      * -====-
       0010-FR-START-HIGH.
      *                         :---------------------------------------
      * ------------------------: Start with record = or > key.
      *                         : this is not correct but it has been
      *                         : this way since the beginning.
      *                         :---------------------------------------
      *01/11/12 **** IF OLD RECORD USE THE OLD RECEIVE FILE *****
           IF MAIL-RECEIVE-DATE OF LS < OLD-DATE
              CALL TPSIORC2 USING FILE-REQUEST LS
              GO TO 0018-RETURN.
      *
             MOVE MAIL-KEY OF LS TO MAIL-KEY OF FS
             START RECEIVE-FILE KEY IS NOT < MAIL-KEY OF FS
      *
           GO TO 0017-RETURN.
      * -====-
       0011-FR-READ.
      *                         :---------------------------------------
      * ------------------------: Read the record directly on prime key.
      *                         : The prime key never allows duplicates.
      *                         :---------------------------------------
      *01/11/12 **** IF OLD RECORD USE THE OLD RECEIVE FILE *****
           IF MAIL-RECEIVE-DATE OF LS < OLD-DATE
              CALL TPSIORC2 USING FILE-REQUEST LS
              GO TO 0018-RETURN.
      *
           MOVE MAIL-KEY OF LS TO MAIL-KEY OF FS.
           READ RECEIVE-FILE INTO LS.
      *
           GO TO 0017-RETURN.
      * -====-
       0012-FR-READ-NEXT.
      *                         :---------------------------------------
      * ------------------------: Browse (read sequential) the file.
      *                         :---------------------------------------
      *
      *JM07/01 ***** IF OLD RECORD USE THE OLD RECEIVE FILE *****
      *08/28/06***** SET UP RECORD TO JUMP FROM OLD TO NEW FILE******
           IF MAIL-RECEIVE-DATE OF LS < OLD-DATE
              IF MAIL-RECEIVE-DATE OF LS > END-DATE
                 MOVE 'END2'       TO FILE-NAME
              END-IF
             CALL TPSIORC2 USING FILE-REQUEST LS
              IF FILE-NAME = 'NEW3'
                 MOVE MAIL-KEY OF LS TO MAIL-KEY OF FS
                 START RECEIVE-FILE KEY NOT LESS THAN MAIL-KEY OF FS
                 MOVE SPACES TO FILE-NAME
                 NEXT SENTENCE
              END-IF
             GO TO 0018-RETURN.

      *  ** SET UP RECORD TO JUMP FROM OLD3 FILE TO NEW FILE **
      *    IF FILE-NAME = 'END3'
              MOVE MAIL-ACCT-NO OF LS   TO END-ACCT-NO.
              MOVE MAIL-SUB-ACCT OF LS  TO END-SUB-ACCT.

           READ RECEIVE-FILE
           NEXT RECORD INTO LS
           IGNORE LOCK.

      *  ** SET UP RECORD TO JUMP FROM OLD2 FILE TO NEW FILE **
           IF FILE-NAME = 'END3'
             IF MAIL-ACCT-NO OF LS NOT = END-ACCT-NO OR
                MAIL-SUB-ACCT OF LS NOT = END-SUB-ACCT
                  MOVE 'NEW4'           TO FILE-NAME
                  MOVE END-ACCT-NO      TO MAIL-ACCT-NO OF LS
                  MOVE END-SUB-ACCT     TO MAIL-SUB-ACCT OF LS
                  MOVE '20160101'       TO MAIL-RECEIVE-DATE OF LS
                  MOVE ZEROS            TO MAIL-RECEIVE-NUMBER OF LS
             END-IF
           END-IF.

      *07/13/16 WHEN COMING FROM PROGRAM TPS3054 SKIP TO EXIT
           IF FILE-PROGRAM = 'TPS3054'
              GO TO 0017-RETURN.

      *05/23/16 IF SEARCH IS FOR CLIENT NOT STARTED IN 3RD FILE
      *  *****  BUT STARTED IN 4TH FILE. EX:SUMMARY STARTS 6 MONTHS
      *  *****  BACK OF START DATE
           IF MAIL-ACCT-NO OF LS NOT = END-ACCT-NO OR
              MAIL-SUB-ACCT OF LS NOT = END-SUB-ACCT
                  MOVE 'NEW4'           TO FILE-NAME
                  MOVE END-ACCT-NO      TO MAIL-ACCT-NO OF LS
                  MOVE END-SUB-ACCT     TO MAIL-SUB-ACCT OF LS
                  MOVE '20160101'       TO MAIL-RECEIVE-DATE OF LS
                  MOVE ZEROS            TO MAIL-RECEIVE-NUMBER OF LS
           END-IF.

           GO TO 0017-RETURN.
      * -====-
       0013-FR-READ-PREVIOUS.
      *                         :---------------------------------------
      * ------------------------: Browse a file backwards.
      *                         :---------------------------------------
      *01/11/12 **** IF OLD RECORD USE THE OLD RECEIVE FILE *****
           IF MAIL-RECEIVE-DATE OF LS < OLD-DATE
              CALL TPSIORC2 USING FILE-REQUEST LS
              GO TO 0018-RETURN.

      *05/24/16 DO START B4 READ PREVIOUS WHEN COMING FROM NEW FILE **
           IF FILE-NAME = 'NEW3'
              MOVE MAIL-KEY OF LS TO MAIL-KEY OF FS
              START RECEIVE-FILE KEY LESS THAN MAIL-KEY OF FS.
      *
           READ RECEIVE-FILE
               PREVIOUS RECORD INTO LS.
      *
           GO TO 0017-RETURN.
      * -====-
       0016-FR-START-LOW.
      *
      *01/11/12 **** IF OLD RECORD USE THE OLD RECEIVE FILE *****
           IF MAIL-RECEIVE-DATE OF LS < OLD-DATE
              CALL TPSIORC2 USING FILE-REQUEST LS
              GO TO 0018-RETURN.
      *
           IF FR-PRIME
             MOVE MAIL-KEY OF LS TO MAIL-KEY OF FS
             START RECEIVE-FILE KEY LESS THAN MAIL-KEY OF FS. 
      *
           GO TO 0017-RETURN.
      * -====-
      *
       0017-RETURN.
           MOVE FILE-STATUS-LOCAL TO FILE-STATUS.
           GOBACK.
      *
       0018-RETURN.
           GOBACK.
      *
