       IDENTIFICATION DIVISION.
       PROGRAM-ID. TPS630.
       AUTHOR. JIM MONAGHAN.
      *****************************************************************
      *  SHOW RECURRING INSTRUCTIONS WHEN CALLING RECORDS.            *         
      *  AA's CAN VIEW ONLY, PA's CAN UPDATE THE RECORDS.             *
      *****************************************************************
001001* 11/30/17 MODIFIED PROGRAM AND GUI SCREEN                   AC *
      * 07/11/01 add delete function by using ctrl-delete key.     JM *
      *****************************************************************
       ENVIRONMENT DIVISION.
       CONFIGURATION SECTION.
       SOURCE-COMPUTER. IBM-PS2.
       OBJECT-COMPUTER. IBM-PS2.

       DATA DIVISION.

       WORKING-STORAGE SECTION.

       01 PROGRAM-NAMES.
          10 SCREENIO    PIC X(08) VALUE 'SCRNIO'.
          10 TPSIOERR    PIC X(08) VALUE 'TPSIOERR'.
          10 TPSIO031    PIC X(08) VALUE 'TPSIO031'.
          10 TPSIORCR    PIC X(08) VALUE 'TPSIORCR'.
          10 TPSDATES    PIC X(08) VALUE 'TPSDATES'.
      ************** SCREENIO COPYBOOK ***************

      *Alex Castro*******************************************
        COPY "ds-cntrl.v1".
        COPY  "RECURINS.CPB".


       01 WS-CURRENT-X                            PIC 9(04).
       01 WS-CURRENT-Y                            PIC 9(04).
       
      ********************************************************
       01  GUISCREEN               pic x(08) value 'GS      '.

       01  RCRINSTR.
           COPY "RCRINSTR.CPY".

           COPY "TPSFILES.CPY".
           COPY "KEYVALUE.CPY".
           COPY "PCL5VALU.CPY".
           COPY "CALLDATE.CPY".


       01 RECORD-EXIST             PIC X(01) VALUE 'Y'.                         


       LINKAGE SECTION.

       01 TPSRECUR.                                                             
             COPY TPSRECUR.CPY.

       01 LOGREC-ACCESS-LEVEL      PIC X(02).

       01 CURRENT-XY-PARAMETERS PIC 9(08).

       PROCEDURE DIVISION USING TPSRECUR LOGREC-ACCESS-LEVEL
                                CURRENT-XY-PARAMETERS.

       0001-BEGIN.

           INITIALIZE DS-CONTROL-BLOCK.
           INITIALIZE DS-INPUT-FIELDS.
           MOVE CURRENT-XY-PARAMETERS(1:4) TO WS-CURRENT-X.
           MOVE CURRENT-XY-PARAMETERS(5:4) TO WS-CURRENT-Y.

          MOVE RECUR-ACCT-NO          TO RCRINSTR-ACCT-NO.                      
          MOVE RECUR-SUB-ACCT         TO RCRINSTR-SUB-ACCT.
          MOVE RECUR-ADDRESOR-NAME    TO RCRINSTR-ADDRESSOR-NAME.
          MOVE RECUR-ADDRESEE-NAME    TO RCRINSTR-ADDRESSEE-NAME.
          MOVE RECUR-CATEGORY-CODE    TO RCRINSTR-CATEGORY.
          MOVE RECUR-PAYEE-ACCOUNT-NUMBER TO RCRINSTR-PAYEE-ACCT.

      ******** OPEN AND READ FILE **********                                    
          MOVE F-PRIME         TO FILE-KEY.                                     
          MOVE F-OPEN-I-O      TO FILE-ACTION.                                  
          CALL TPSIO031 USING FILE-REQUEST RCRINSTR.                            
          IF FILE-STATUS NOT = '00' AND '05'                                    
             MOVE 'RCRINSTR'   TO FILE-NAME                                     
             MOVE 'TPS630-OPN' TO FILE-TEXT                                     
             PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                            
             GO TO EXIT-THE-MODULE.                                             

          MOVE F-PRIME         TO FILE-KEY.                                     
          MOVE F-READ          TO FILE-ACTION.                                  
          CALL TPSIO031 USING FILE-REQUEST RCRINSTR.
          IF NO-RECORD-WAS-FOUND                                                
             MOVE 'N'          TO RECORD-EXIST                                  
          ELSE                                                                  
             MOVE 'Y'          TO RECORD-EXIST
             IF NOT A-SUCCESSFUL-OPERATION
                MOVE 'RCRINSTR'   TO FILE-NAME
                MOVE 'TPS630-SBR' TO FILE-TEXT
                PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
                GO TO EXIT-THE-MODULE.

       0001-EXIT.   EXIT.                                                       

       0010-DISPLAY-REC.



          IF RECORD-EXIST = 'N'                                                 
             MOVE SPACES          TO RECURINS-DATA-BLOCK
          ELSE                                                                  
             MOVE RCRINSTR-LINES  TO RECURINS-DATA-BLOCK.
                                                                                
          MOVE 'ENTER TO SAVE INSTRUCTIONS / PRESS DELETE TO DELETE'
                                     TO RECURINS-MENU-LINE.
          IF RECURINS-ACTIVE-FIELD = SPACES
             MOVE 1 TO RECURINS-ACTIVE-FIELD
          END-IF.

           INITIALIZE  RECURINS-CL-WINDOW-FLAG
                       RECURINS-END-FLAG                  
                       RECURINS-CR-FLAG
                       RECURINS-DEL-FLAG.

           MOVE RECURINS-DATA-BLOCK-VERSION-NO 
                                 TO DS-DATA-BLOCK-VERSION-NO
           MOVE RECURINS-VERSION-NO TO DS-VERSION-NO
           MOVE WS-CURRENT-X TO RECURINS-DSMOVSZ-X.
           MOVE WS-CURRENT-Y TO RECURINS-DSMOVSZ-Y.
           MOVE DS-PUSH-SET TO DS-CONTROL
           MOVE "RECURINS"  TO DS-SET-NAME
           CALL "DSGRUN" USING DS-CONTROL-BLOCK
                               RECURINS-DATA-BLOCK.

          MOVE RECURINS-DSMOVSZ-X TO WS-CURRENT-X.
          MOVE RECURINS-DSMOVSZ-Y TO WS-CURRENT-Y.


      *****CLOSE SCREEN AS A POP-UP**********
           MOVE RECURINS-DATA-BLOCK-VERSION-NO 
                                 TO DS-DATA-BLOCK-VERSION-NO
           MOVE RECURINS-VERSION-NO TO DS-VERSION-NO
           MOVE DS-QUIT-SET TO DS-CONTROL
           MOVE "RECURINS"  TO DS-SET-NAME
           CALL "DSGRUN" USING DS-CONTROL-BLOCK
                               RECURINS-DATA-BLOCK.

      *****************************************                         
          IF RECURINS-END-FLAG-TRUE OR RECURINS-CL-WINDOW-FLAG-TRUE
             GO TO EXIT-THE-MODULE
          END-IF.

      ******* VIEW ONLY FOR AA's *******
          IF LOGREC-ACCESS-LEVEL < 04                                                      00722200
             GO TO EXIT-THE-MODULE.                                                        00722200

      ******* WHEN NOTHING ENTERED EXIT PROGRAM *******
          IF RECORD-EXIST = 'N' AND RECURINS-DATA-BLOCK = SPACES
             GO TO EXIT-THE-MODULE.
                                                                                
      **** DELETE OLD RECORD WHEN CTRL-DELETE KEY AND USER ****
      *JM   CONFIRMS DELETE
          IF RECURINS-DEL-FLAG-TRUE
             MOVE 'PRESS DELETE TO CONFIRM DELETE'
                                     TO RECURINS-MENU-LINE
             INITIALIZE  RECURINS-CL-WINDOW-FLAG
                         RECURINS-END-FLAG                  
                         RECURINS-CR-FLAG
                         RECURINS-DEL-FLAG

            MOVE RECURINS-DATA-BLOCK-VERSION-NO 
                                  TO DS-DATA-BLOCK-VERSION-NO
            MOVE RECURINS-VERSION-NO TO DS-VERSION-NO
            MOVE WS-CURRENT-X TO RECURINS-DSMOVSZ-X
            MOVE WS-CURRENT-Y TO RECURINS-DSMOVSZ-Y
            MOVE DS-PUSH-SET TO DS-CONTROL
            MOVE "RECURINS"  TO DS-SET-NAME
            CALL "DSGRUN" USING DS-CONTROL-BLOCK
                               RECURINS-DATA-BLOCK

            MOVE RECURINS-DSMOVSZ-X TO WS-CURRENT-X
            MOVE RECURINS-DSMOVSZ-Y TO WS-CURRENT-Y


             IF RECURINS-DEL-FLAG-TRUE
                NEXT SENTENCE
             ELSE
               MOVE RECURINS-DATA-BLOCK-VERSION-NO 
                                 TO DS-DATA-BLOCK-VERSION-NO
               MOVE RECURINS-VERSION-NO TO DS-VERSION-NO
               MOVE DS-QUIT-SET TO DS-CONTROL
               MOVE "RECURINS"  TO DS-SET-NAME
               CALL "DSGRUN" USING DS-CONTROL-BLOCK
                               RECURINS-DATA-BLOCK

                GO TO EXIT-THE-MODULE.
          IF THEY-HIT-CTRL-DELETE
             MOVE F-PRIME           TO FILE-KEY
             MOVE F-DELET           TO FILE-ACTION
             CALL TPSIO031 USING FILE-REQUEST RCRINSTR
             IF NOT A-SUCCESSFUL-OPERATION
                MOVE 'RCRINSTR'     TO FILE-NAME
                MOVE 'TPS630-DELETE' TO FILE-TEXT
                PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
                GO TO EXIT-THE-MODULE
             ELSE
             MOVE 'N'                 TO RECUR-CHART-ACCT-01(9:1)
             MOVE F-PRIME             TO FILE-KEY
             MOVE F-REWRITE           TO FILE-ACTION
             CALL TPSIORCR USING FILE-REQUEST RECUR-ROOT-SECTION
             IF NOT A-SUCCESSFUL-OPERATION
                MOVE 'RECUR'         TO FILE-NAME
                MOVE 'TPS630-REWRIT' TO FILE-TEXT
                PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
                GO TO EXIT-THE-MODULE
             ELSE
                GO TO EXIT-THE-MODULE.

      ******* WRITE OR REWRITE RECORD **********
          MOVE RECURINS-DATA-BLOCK   TO RCRINSTR-LINES.

          IF RECORD-EXIST = 'N'                                                 
             MOVE F-PRIME         TO FILE-KEY                                   
             MOVE F-WRITE         TO FILE-ACTION                                
          ELSE                                                                  
             MOVE F-PRIME         TO FILE-KEY                                   
             MOVE F-REWRITE       TO FILE-ACTION.                               
          CALL TPSIO031 USING FILE-REQUEST RCRINSTR.
          IF NOT A-SUCCESSFUL-OPERATION
             MOVE 'RCRINSTR'    TO FILE-NAME
             MOVE 'TPS630-WRITE' TO FILE-TEXT                                   
             PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
             GO TO EXIT-THE-MODULE.

      ******* UPDATE RECURRING RECORD ***********
             MOVE 'Y'                 TO RECUR-CHART-ACCT-01(9:1)
             MOVE F-PRIME             TO FILE-KEY
             MOVE F-REWRITE           TO FILE-ACTION
             CALL TPSIORCR USING FILE-REQUEST RECUR-ROOT-SECTION
             IF NOT A-SUCCESSFUL-OPERATION
                MOVE 'RECUR'         TO FILE-NAME
                MOVE 'TPS630-REWRIT' TO FILE-TEXT
                PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
                GO TO EXIT-THE-MODULE.

       0010-EXIT. EXIT.                                                         

       EXIT-THE-MODULE.

          MOVE F-PRIME         TO FILE-KEY
          MOVE F-CLOSE         TO FILE-ACTION
          CALL TPSIO031 USING FILE-REQUEST RCRINSTR
          IF NOT A-SUCCESSFUL-OPERATION
             MOVE 'RCRINSTR'   TO FILE-NAME
             MOVE 'TPS630-CLS' TO FILE-TEXT
             PERFORM FILE-ERROR THRU FILE-ERROR-EXIT.

          CANCEL TPSIO031.

          GOBACK.

       FILE-ERROR.
            CALL TPSIOERR USING FILE-REQUEST.
            CANCEL TPSIOERR.
       FILE-ERROR-EXIT. EXIT.

