       IDENTIFICATION DIVISION.
       PROGRAM-ID. TPS1013R.
       AUTHOR. JIM MONAGHAN.
      ***************************************************************
      *    LIST RECURRING BILLS IN CATEGORY SEQUENCE                *
      ***************************************************************
      *    !!!!!!!!!!!!!!!!!   NOTICE   !!!!!!!!!!!!!!!!!!!         *
      *MAKE CHANGES IN TPS1010R&11R(LIST RECURRING ITEMS) ALSO....  *
      *    !!!!!!!!!!!!!!!!!   NOTICE   !!!!!!!!!!!!!!!!!!!         *
      ***************************************************************
      *                         maintenance log                     *
000000* 03/27/16  CHANGED GUI                                     JM*
      * 11/11/02 ADD MAINTENANCE NAME & DATE TO REPORT....       JM *
      * 03/06/02 UPDATED BILL SEARCH TO INCLUDE 18........       ts *                                                   
      * 06/26/01 ADD DUPLEX PRINTING                             JM *
      * 05/10/01 UPDATED BILL SEARCH TO INCLUDE 02, 11, 31, 33 AND  *                                                   
      *    TS    02, 09, 11, 30, 31, 32 OR 33..................     *                                                   
      * 07/10/98 FIX PRINT OF BILL RECEIVED/CASH DISBURSEMENTS   JM *
      * 01/12/98 FIX CATEGORY '31' AND '33' TO PRINT 'ACCT PAYABLE' *
      * 09/22/97 ADD CATEGORY '31' AND '33' TO PROCESS FOR BUSINESS *
      *   JM     ACCOUNTS USING ACCOUNTS PAYABLE ACCOUNTS AS BILLS  *
      ***************************************************************
       ENVIRONMENT DIVISION.
       CONFIGURATION SECTION.
       SOURCE-COMPUTER. IBM-PS2.
       OBJECT-COMPUTER. IBM-PS2.
       FILE-CONTROL.
           SELECT PRT-FILE
           ASSIGN TO DYNAMIC FILESPEC
           ORGANIZATION IS LINE SEQUENTIAL.

           SELECT  TPS-PAYMENT-FREQUENCY
                   ASSIGN TO "\tps\prod\files\payfreq.men"
                   ORGANIZATION IS LINE SEQUENTIAL
                   FILE STATUS IS TPS-FILE-STATUS.


       DATA DIVISION.
       FILE SECTION.
       FD  PRT-FILE
           LABEL RECORDS ARE OMITTED
           RECORD CONTAINS 200 CHARACTERS.
       01  PRT-RECORD            PIC X(200).

       FD  TPS-PAYMENT-FREQUENCY
           DATA RECORD  IS TPS-PAYMENT-FREQUENCY-INPUT
           LABEL RECORDS STANDARD.
       01  TPS-PAYMENT-FREQUENCY-INPUT      PIC X(80).


       WORKING-STORAGE SECTION.

***************** WINFORMS SCREEN DEFINITION **********

       01 PROCESS-2 type TPS000.PROCESS_2Form.

       01 PROCESS-2-DISPLAY-FLAG PIC 9(01) VALUE 0.

       01 SCREEN-NAME PIC x(10).

       01 WS-CURRENT-X                            PIC 9(04).
       01 WS-CURRENT-Y                            PIC 9(04).
       01 WS-CURRENT-XY-PARM.
          05 WS-X-PARM                            PIC 9(04).
          05 WS-Y-PARM                            PIC 9(04).


*********************************************************

       01 MAIL-REC.
          COPY "TPSMAIL.CPY".
       01 RECUR-REC.
          COPY "TPSRECUR.CPY".

       01 FILESPEC               PIC X(80) VALUE SPACES.

          COPY "TPSFILES.CPY".
          COPY "KEYVALUE.CPY".
          COPY "PCLVALUE.CPY".
          COPY "PCL5VALU.CPY".


       01 PROGRAM-NAMES.
010400    10 GUISCREEN                pic x(08) value 'GS      '.
          05 SCREENIO                 PIC X(08) VALUE 'SCRNIO '.
          05 TPSIORCR                 PIC X(08) VALUE 'TPSIORCR'.
          05 TPSIOERR                 PIC X(08) VALUE 'TPSIOERR'.
          05 FLOATIT                  PIC X(08) VALUE 'FLOATIT'.
          05 FLOATBIG                 PIC X(08) VALUE 'FLOATBIG'.
          05 TPSCHART                 PIC X(08) VALUE 'TPSCHART'.
          05 TPSDATES                 PIC X(08) VALUE 'TPSDATES'.

       01  TPSRECUR-FLAG              PIC 9(01) VALUE 0.
           88 TPSRECUR-OPEN                     VALUE 1.
       01  TPSMAIL-FLAG               PIC 9(01) VALUE 0.
           88 TPSMAIL-OPEN                      VALUE 1.

       01  WS-ADDRESS-LINES           PIC 9(01) VALUE 0.
       01  WS-CATEGORY-LINES          PIC 9(01) VALUE 0.

       01  DIR-COMMAND.
           05 FILLER                  PIC  X(13) VALUE 'IF NOT EXIST '.
           05 DIR-COMMAND-1           PIC  X(15).
           05 DIR-COMMAND-2           PIC  X(09).
           05 FILLER                  PIC  X(04) VALUE '\*.*'.
           05 FILLER                  PIC  X(04) VALUE ' MD '.
           05 DIR-COMMAND-3           PIC  X(15).
           05 DIR-COMMAND-4           PIC  X(09).
       01  PRT-COMMAND-1.
           05 PRT-COMMAND-P           PIC  X(08) VALUE 'COPY /B '.
           05 PRT-COMMAND-PATH        PIC  X(50).
           05 FILLER                  PIC  X(12) VALUE '/A PRN > NUL'.
       01  RESULT                     PIC  99 COMP-X.
       01  FUNCTION-35                PIC  99 COMP-X VALUE 35.
       01  NULL-PARAMETER.
            05  FILLER                PIC  99 COMP-X VALUE 0.
            05  FILLER                PIC  X.

       01 CLIENT-DIRECTORY.
          10 FILLER                         PIC X(01) VALUE '\'.
          10 PRT-PATH.
             20 PRT-PATH-NAME               PIC X(08).
          10 FILLER                         PIC X(01) VALUE '\'.
          10 PRT-PATH-REPORT.
             20 PRT-PATH-RPT-TYPE           PIC X(08).
          10 FILLER                         PIC X(01) VALUE '.'.
          10 PRT-PATH-EXT.
             20 PRT-PATH-RPT-NO             PIC X(03).

       01 TPS-FILE-STATUS                   PIC 9(02).
021900 01 PAYMENT-FREQUENCY-DATA OCCURS 020 TIMES
                            INDEXED BY FREQUENCY-INDEX.
022000    10 PAYMENT-FREQUENCY-ROW.
022100       20 TPS-FREQUENCY-DATA.
022200          25 TPS-FREQUENCY-CODE    PIC X(01).
022300          25 FILLER                PIC X(01).
022200          25 TPS-FREQUENCY-NAME    PIC X(78).

       01 NEW-PAGE              PIC X VALUE X'0C'.
       01 BLANK-LINE.
          10 FILLER PIC X     VALUE X'1B'.
          10 FILLER PIC X(10) VALUE '*p+0010y0X'.
       01 BOLD-LINE.
****************DRAW A SOLID BLACK LINE FROM LEFT MARGIN TO RIGHT.
                10 FILLER PIC X     VALUE X'1B'.
                10 FILLER PIC X(14) VALUE '*c4000a0010b0P'.
****************MOVE DOWN AND OVER TO THE LEFT MARGIN
                10 FILLER PIC X     VALUE X'1B'.
                10 FILLER PIC X(10) VALUE '*p+0005y0X'.
       01 BOLD-LINE-2.
****************MOVE DOWN AND OVER TO THE LEFT MARGIN
                10 FILLER PIC X     VALUE X'1B'.
                10 FILLER PIC X(10) VALUE '*p+0005y0X'.
****************DRAW A SOLID BLACK LINE FROM LEFT MARGIN TO RIGHT.
                10 FILLER PIC X     VALUE X'1B'.
                10 FILLER PIC X(14) VALUE '*c4000a0010b0P'.
****************MOVE DOWN AND OVER TO THE LEFT MARGIN
                10 FILLER PIC X     VALUE X'1B'.
                10 FILLER PIC X(10) VALUE '*p+0005y0X'.
       01  THIN-LINE.
****************DRAW A THIN BLACK LINE FROM LEFT MARGIN TO RIGHT.
                10 FILLER PIC X     VALUE X'1B'.
                10 FILLER PIC X(14) VALUE '*c4000a0005b0P'.
****************MOVE DOWN AND OVER TO THE LEFT MARGIN
                10 FILLER PIC X     VALUE X'1B'.
                10 FILLER PIC X(10) VALUE '*p-0005y0X'.

       01  PRINT-SETUP                    PIC X(50).

       01 HEADING-1.
          10 FILLER PIC X(01) VALUE SPACE.
          10 FILLER PIC X(01) VALUE X'1B'.
          10 FILLER PIC X(02) VALUE  '*p'.
          10 Y-AXIS PIC X(04) VALUE  '0050'.
          10 FILLER PIC X(01) VALUE  'y'.
          10 X-AXIS PIC X(04) VALUE  '1200'.
          10 FILLER PIC X(01) VALUE  'X'.
          10 FILLER PIC X(50) VALUE
                 'CLIENT RECURRING BILLS'.
       01 HEADING-1-A.
          10 FILLER PIC X(01) VALUE SPACE.
          10 FILLER PIC X(01) VALUE X'1B'.
          10 FILLER PIC X(02) VALUE  '*p'.
          10 Y-AXIS PIC X(04) VALUE  '0050'.
          10 FILLER PIC X(01) VALUE  'y'.
          10 X-AXIS PIC X(04) VALUE  '2600'.
          10 FILLER PIC X(01) VALUE  'X'.
          10 PRT-RPT-DATE     PIC X(20).
       01 HEADING-2-A.
          10 FILLER PIC X(01) VALUE SPACE.
          10 FILLER PIC X(01) VALUE X'1B'.
          10 FILLER PIC X(02) VALUE  '*p'.
          10 Y-AXIS PIC X(04) VALUE  '0100'.
          10 FILLER PIC X(01) VALUE  'y'.
          10 X-AXIS PIC X(04) VALUE  '2600'.
          10 FILLER PIC X(01) VALUE  'X'.
          10 FILLER           PIC X(04) VALUE 'Page'.
          10 PRT-PAGE         PIC X(03).
          10 FILLER           PIC X(04) VALUE ' of '.
          10 PRT-TOTAL-PAGE   PIC X(03).
       01 HEADING-2.
          10 FILLER PIC X(01) VALUE SPACE.
          10 FILLER PIC X(01) VALUE X'1B'.
          10 FILLER PIC X(02) VALUE  '*p'.
          10 Y-AXIS PIC X(04) VALUE  '0100'.
          10 FILLER PIC X(01) VALUE  'y'.
          10 X-AXIS PIC X(04) VALUE  '1250'.
          10 FILLER PIC X(01) VALUE  'X'.
          10 FILLER PIC X(50) VALUE
                 'TPS Administrative Group LLC'.
       01 HEADING-3.
          10 FILLER PIC X(01) VALUE SPACE.
          10 FILLER PIC X(01) VALUE X'1B'.
          10 FILLER PIC X(02) VALUE  '*p'.
          10 Y-AXIS PIC X(04) VALUE  '0150'.
          10 FILLER PIC X(01) VALUE  'y'.
          10 X-AXIS PIC X(04) VALUE  '1070'.
          10 FILLER PIC X(01) VALUE  'X'.
          10 FILLER PIC X(51) VALUE
               '"Taking Care of Your Personal Business...Privately"'.

       01 WS-CLIENT                  PIC X(08) VALUE 'CLIENT: '.
       01 RPT-CLIENT.
          10 FILLER                  PIC X(01) VALUE X'1B'.
          10 FILLER                  PIC X(07) VALUE '*p0050X'.
          10 RPT-CLIENT-NAME         PIC X(150).

       01 RPT-SECTION-HDR1.
          10 FILLER                  PIC X(01) VALUE x'1B'.
          10 FILLER                  PIC X(07) VALUE '*p0100X'.
          10 FILLER                  PIC X(09) VALUE
                 'ADDRESSOR'.
          10 FILLER                  PIC X(01) VALUE x'1B'.
          10 FILLER                  PIC X(07) VALUE '*p1000X'.
          10 FILLER                  PIC X(09) VALUE
                 'ADDRESSEE'.
          10 FILLER                  PIC X(01) VALUE x'1B'.
          10 FILLER                  PIC X(07) VALUE '*p1800X'.
          10 FILLER                  PIC X(08) VALUE
                 'CATEGORY'.
          10 FILLER                  PIC X(01) VALUE x'1B'.
          10 FILLER                  PIC X(07) VALUE '*p2500X'.
          10 FILLER                  PIC X(20) VALUE
                 'PAYEE/ACCOUNT/AMOUNT'.

       01 PRT-DATA.
          10 FILLER                  PIC X(01) VALUE x'1B'.
          10 FILLER                  PIC X(07) VALUE '*p0000X'.
          10 PRT-ADDRESSOR           PIC X(36).
          10 FILLER                  PIC X(01) VALUE x'1B'.
          10 FILLER                  PIC X(07) VALUE '*p0900X'.
          10 PRT-ADDRESSEE           PIC X(36).
          10 FILLER                  PIC X(01) VALUE x'1B'.
          10 FILLER                  PIC X(07) VALUE '*p1700X'.
          10 PRT-CATEGORY            PIC X(40).
          10 FILLER                  PIC X(01) VALUE x'1B'.
          10 FILLER                  PIC X(07) VALUE '*p2500X'.
          10 PRT-PAYEE               PIC X(40).

       01 RPT-LAST-LINE.
          10 FILLER                  PIC X(90) VALUE SPACES.
          10 FILLER                  PIC X(15) VALUE
                'End of Report'.


       01 FIRST-PAGE         PIC  X  VALUE 'Y'.
       01 PAGES-PRINTED      PIC  9(02) VALUE 00.
       01 PAGES-PRINTED-MASK PIC  ZZZ.
       01 LINES-PRINTED      PIC  9(02) VALUE 0.

       01  WS-ADDRESS1-COUNT                PIC 9 VALUE 0.
       01  WS-ADDRESS2-COUNT                PIC 9 VALUE 0.

       01  WS-ADDRESSOR.
           05 WS-ADDRESSOR1                 PIC X(36).
           05 WS-ADDRESSOR2                 PIC X(36).
           05 WS-ADDRESSOR3                 PIC X(36).
           05 WS-ADDRESSOR4                 PIC X(36).

       01  WS-ADDRESSEE.
           05 WS-ADDRESSEE1                 PIC X(36).
           05 WS-ADDRESSEE2                 PIC X(36).
           05 WS-ADDRESSEE3                 PIC X(36).
           05 WS-ADDRESSEE4                 PIC X(36).

       01  WS-CNT                    PIC 9(02) VALUE ZERO.
       01  WS-WORK-LOAMOUNT          PIC $,$$$,$$$.99.
       01  WS-WORK-HIAMOUNT          PIC $,$$$,$$$.99.
       01  WS-HI-AMOUNT.
           05 FILLER               PIC X(12) VALUE 'High Amount '.
           05 WS-HIAMOUNT          PIC X(12).
           05 FILLER               PIC X(01) VALUE x'1B'.
           05 FILLER               PIC X(07) VALUE '*p3025X'.
           05 WS-MAINT-DATE        PIC X(08).
       01  WS-LOW-AMOUNT.
           05 FILLER               PIC X(12) VALUE 'Low  Amount '.
           05 WS-LOAMOUNT          PIC X(12).
           05 FILLER               PIC X(01) VALUE x'1B'.
           05 FILLER               PIC X(07) VALUE '*p3025X'.
           05 WS-MAINT-ACT         PIC X(03).
           05 FILLER               PIC X(01) VALUE SPACES.
           05 WS-MAINT-BY          PIC X(03).
057700                                                                                     00092800
057800 01  UNPACK-WORK-X                     PIC X(04).                                    00092900
057900 01  FILLER REDEFINES UNPACK-WORK-X.                                                 00093000
058000     10 FILLER                         PIC X(03).                                    00093100
058100     10 UNPACK-WORK-SIGN               PIC X(01).                                    00093200
058200 01  FILLER REDEFINES UNPACK-WORK-X.                                                 00093300
058300     10 UNPACK-WORK-PL7                PIC 9(07) COMP-3.                             00093400
058400                                                                                     00093500
058500 01  UNPACK-WORK                       PIC 9(07).                                    00093600
058600 01  FILLER REDEFINES UNPACK-WORK.                                                   00093700
058700     10 UNPACK-YY                      PIC 9(02).                                    00093800
058800     10 UNPACK-MM                      PIC 9(02).                                    00093900
058900     10 UNPACK-DD                      PIC 9(02).                                    00094000
059000     10 FILLER                         PIC 9(01).                                    00094100
059100                                                                                     00094200
058600 01  WS-MAINT-DATE-YMD.                                                              00093700
058700     10 WS-MAINT-MM                    PIC 9(02).                                    00093800
059000     10 FILLER                         PIC X(01) VALUE '/'.                          00094100
058800     10 WS-MAINT-DD                    PIC 9(02).                                    00093900
059000     10 FILLER                         PIC X(01) VALUE '/'.                          00094100
058900     10 WS-MAINT-YY                    PIC 9(02).                                    00094000
005201
005202 01 REC-IDX                            PIC 9(04) VALUE ZERO.
005202 01 TBL-IDX                            PIC 9(04) VALUE ZERO.
005202 01 TABLE-RECUR-RECS OCCURS 1 TO 5000 TIMES
005202                     DEPENDING ON TBL-IDX.
005202    05 TABLE-SORT-KEY.
005202       10 TABLE-SORT-CHART.
005202          15 TABLE-SORT-CHART-1       pic  x(10).
005202          15 TABLE-SORT-CHART-2       pic  x(10).
005202          15 TABLE-SORT-CHART-3       pic  x(10).
005202          15 TABLE-SORT-CHART-4       pic  x(10).
005202       10 TABLE-SORT-ADDRESSOR        pic  x(36).
005202       10 TABLE-SORT-ADDRESSEE        pic  x(36).
005202       10 TABLE-SORT-PAYEE-ACCOUNT    pic  x(10).
005202    05 TABLE-SAVE-RECUR-REC           pic  x(679).
005202

       01  WS-FLIP-PAY-DATE.
           05 WS-FLIP-YY                    PIC  9(02).
           05 WS-FLIP-MM                    PIC  9(02).
           05 WS-FLIP-DD                    PIC  9(02).

       01  WS-FLOAT-DATA.
           05  WS-FLOAT-PARMS               PIC  X(101).
           05  FILLER REDEFINES WS-FLOAT-PARMS.
               10  WS-FLOAT-COUNT           PIC  X(01).
               10  WS-FLOAT-1               PIC  X(25).
               10  WS-FLOAT-2               PIC  X(25).
               10  WS-FLOAT-3               PIC  X(25).
               10  FILLER REDEFINES WS-FLOAT-3.
                   15  WS-FLOAT-3-A         PIC  X(22).
                   15  WS-FLOAT-3-B         PIC  X(03).
               10  WS-FLOAT-4               PIC  X(25).

       01  BG-FLOAT-DATA.
           05  BG-FLOAT-PARMS               PIC  X(161).
           05  FILLER REDEFINES BG-FLOAT-PARMS.
               10  BG-FLOAT-COUNT           PIC  X(01).
               10  BG-FLOAT-1               PIC  X(40).
               10  BG-FLOAT-2               PIC  X(40).
               10  BG-FLOAT-2-R REDEFINES BG-FLOAT-2.
                   15  BG-FLOAT-2-I         PIC  X(01) OCCURS 40 TIMES.
               10  BG-FLOAT-3               PIC  X(40).
               10  FILLER REDEFINES BG-FLOAT-3.
                   15  BG-FLOAT-3-A         PIC  X(37).
                   15  BG-FLOAT-3-B         PIC  X(03).
               10  BG-FLOAT-3-R REDEFINES BG-FLOAT-3.
                   15  BG-FLOAT-3-I         PIC  X(01) OCCURS 40 TIMES.
               10  BG-FLOAT-4               PIC  X(40).

037200 01 TODAYS-DATE-YMD.
037200    05 WS-TODAYS-DATE-YY       PIC  9(02).
037200    05 WS-TODAYS-DATE-MM       PIC  9(02).
037200    05 WS-TODAYS-DATE-DD       PIC  9(02).
006000
037200 01 TODAYS-DATE-CYMD.
037200    05 TODAYS-DATE-CC          PIC  9(02).
037200    05 TODAYS-DATE-YY          PIC  9(02).
037200    05 TODAYS-DATE-MM          PIC  9(02).
037200    05 TODAYS-DATE-DD          PIC  9(02).
037300
037800  01  WS-DATE-REQUEST.
037900      05  WS-DATE-PARAM          PIC  9(02).
038000
038100      05  WS-DATE-TENBYTES       PIC  X(20) VALUE SPACES.
038200      05  FILLER REDEFINES WS-DATE-TENBYTES.
038300          10  WS-DATE-REFORM         PIC  X(06).
038400          10  WS-DATE-EXTEND         PIC  X(04).
038500          10  FILLER                 PIC  X(10).
038600      05  FILLER REDEFINES WS-DATE-TENBYTES.
038700          10  WS-DATE-REFORM-LEN06   PIC  X(06).
038800          10  FILLER                 PIC  X(14).
038900      05  FILLER REDEFINES WS-DATE-TENBYTES.
039000          10  WS-DATE-REFORM-LEN08   PIC  X(08).
039100          10  FILLER                 PIC  X(12).
039200      05  FILLER REDEFINES WS-DATE-TENBYTES.
039300          10  WS-DATE-REFORM-LEN10   PIC  X(10).
039400          10  FILLER                 PIC  X(10).
039500      05  FILLER REDEFINES WS-DATE-TENBYTES.
039600          10  WS-TIME-PARM1          PIC  X(06).
039700          10  WS-TIME-PARM2          PIC  X(06).
039800          10  WS-TIME-EXTEND         PIC  X(08).
039900      05  FILLER REDEFINES WS-DATE-TENBYTES.
040000          10  WS-TIME-PARM1BY8       PIC  X(08).
040100          10  WS-TIME-PARM2BY8       PIC  X(08).
040200          10  WS-TIME-EXTNDBY8       PIC  X(04).
040300
036500 01  WS-PARMS.
036600     05  WS-ACTION-PARM               PIC  9(01) VALUE 3.
036700         88  WS-ACTION-NEW                       VALUE 1.
036800         88  WS-ACTION-EXISTING                  VALUE 2.
036900         88  WS-ACTION-ENGLISH                   VALUE 3.
037000     05  WS-ENGLISH-CHART-01          PIC  X(60).
037100     05  WS-ENGLISH-CHART-02          PIC  X(60).
037200     05  WS-ENGLISH-CHART-03          PIC  X(60).
037300     05  WS-ENGLISH-CHART-04          PIC  X(60).
037400     05  WS-ENGLISH-CHART-05          PIC  X(60).
037500     05  WS-ENGLISH-CHART-06          PIC  X(60).
037600     05  WS-ENGLISH-CHART-07          PIC  X(60).
037700     05  WS-ENGLISH-CHART-08          PIC  X(60).
037800     05  WS-TYPEIN-TEXT OCCURS 018 TIMES.
037900         10  WS-LINE-OF-TYPEIN        PIC  X(60).
038000   02 BUY-SELL-INFO.
038100     05  WS-PANEL-CHART-01            PIC  X(80).
038200     05  WS-PANEL-CHART-02            PIC  X(80).
038300     05  WS-PANEL-CHART-03            PIC  X(80).
038400     05  WS-PANEL-CHART-04            PIC  X(80).
038500     05  WS-PANEL-CHART-05            PIC  X(80).
038600     05  WS-PANEL-CHART-06            PIC  X(80).
038700     05  WS-PANEL-CHART-07            PIC  X(80).
038800     05  WS-PANEL-CHART-08            PIC  X(80).
038900     05  WS-PANEL-CHART-09            PIC  X(80).
039000     05  WS-PANEL-CHART-10            PIC  X(80).
039100     05  WS-PANEL-CHART-11            PIC  X(80).
039200     05  WS-PANEL-CHART-12            PIC  X(80).
039300     05  WS-PANEL-CHART-13            PIC  X(80).
039400     05  WS-PANEL-CHART-14            PIC  X(80).
039500     05  WS-PANEL-CHART-15            PIC  X(80).
039600     05  WS-PANEL-CHART-16            PIC  X(80).
039700
       LINKAGE SECTION.
       01 TPS-PROFL.
          COPY "TPSPROFL.CPY".
       01 RECEIVE-SWITCH                    PIC X(01).

       01 CURRENT-XY-PARAMETERS PIC 9(08).

       PROCEDURE DIVISION USING TPS-PROFL
                                RECEIVE-SWITCH
                                CURRENT-XY-PARAMETERS.

       0001-BEGIN.

       
           MOVE CURRENT-XY-PARAMETERS(1:4) TO WS-CURRENT-X
                                              WS-X-PARM.
           MOVE CURRENT-XY-PARAMETERS(5:4) TO WS-CURRENT-Y
                                              WS-Y-PARM.

            ACCEPT TODAYS-DATE-YMD FROM DATE.
            MOVE 01                   TO WS-DATE-PARAM.
            MOVE TODAYS-DATE-YMD      TO WS-DATE-REFORM.
            MOVE SPACES               TO WS-DATE-EXTEND.
            CALL TPSDATES USING WS-DATE-REQUEST.
            MOVE WS-DATE-REFORM-LEN08 TO TODAYS-DATE-CYMD.

            MOVE 06                   TO WS-DATE-PARAM.
            MOVE TODAYS-DATE-YMD      TO WS-DATE-REFORM.
            MOVE SPACES               TO WS-DATE-EXTEND.
            CALL TPSDATES USING WS-DATE-REQUEST.
            MOVE WS-DATE-TENBYTES     TO PRT-RPT-DATE.

      ********* SET UP PRINT ARCHIVE DIRECTORY ***********
          MOVE 'TPSREPRT'                TO PRT-PATH-NAME.
          MOVE 'BILRECUR'                TO PRT-PATH-RPT-TYPE.
          MOVE 'RPT'                     TO PRT-PATH-RPT-NO.

**********
110500    OPEN  INPUT  TPS-PAYMENT-FREQUENCY.
110600    PERFORM VARYING FREQUENCY-INDEX FROM 1 BY 1
            UNTIL TPS-FILE-STATUS NOT = ZERO
110800      READ TPS-PAYMENT-FREQUENCY
                 INTO PAYMENT-FREQUENCY-ROW(FREQUENCY-INDEX)
                 AT END GO TO TPS-PAYMENT-FREQUENCY-EXIT
110900      END-READ
111100    END-PERFORM.
111200 TPS-PAYMENT-FREQUENCY-EXIT.
          MOVE HIGH-VALUES TO PAYMENT-FREQUENCY-ROW(FREQUENCY-INDEX).
111300    CLOSE TPS-PAYMENT-FREQUENCY.
**********

      ***** SETUP PCL5 PRINT COMMAND FOR PRINTING DATA LINES. *******
          MOVE PCL5-PRM-SPACE-PROPO       TO PRINT-SETUP(1:5).
          MOVE PCL5-STYLE-ITALIC          TO PRINT-SETUP(6:5).
          MOVE 10                         TO PCL5-POINTS-VALUE.
          MOVE PCL5-PRIMARY-HEIGHT        TO PRINT-SETUP(11:8).
          MOVE PCL5-WT-MEDIUM             TO PRINT-SETUP(19:5).
          MOVE PCL5-FAM-COURIER           TO PRINT-SETUP(24:8).

           SET PROCESS-2 TO NEW TPS000.PROCESS_2Form().
           IF PROCESS-2-DISPLAY-FLAG = 0
               SET PROCESS-2::X-POINT TO WS-X-PARM
               SET PROCESS-2::Y-POINT TO WS-Y-PARM
               INVOKE PROCESS-2::Show
               MOVE 1 TO PROCESS-2-DISPLAY-FLAG
           END-IF.



      ****** FIRST PASS TO GET TOTAL PAGE NUMBER ********
          INITIALIZE MAIL-REC.
          MOVE 'NUL'                TO FILESPEC
          OPEN OUTPUT PRT-FILE.
          PERFORM 0100-OPEN-THE-FILES
             THRU 0100-EXIT.
          PERFORM 0400-TOP-OF-PAGE
             THRU 0400-EXIT.
          PERFORM 0200-READ-RECUR-FILE
             THRU 0200-EXIT.
          PERFORM 0250-SORT-THE-TABLE
             THRU 0250-EXIT.
          MOVE PRT-PAGE             TO PRT-TOTAL-PAGE.
          MOVE 'Y'                  TO FIRST-PAGE.
          MOVE ZERO                 TO PAGES-PRINTED.
          CLOSE PRT-FILE.

      ****** SECOND PASS TO PRINT REPORT ********
          IF FILESPEC > SPACES
      *      DISPLAY "TPSFCAL" UPON ENVIRONMENT-NAME
      *      ACCEPT FILESPEC FROM ENVIRONMENT-VALUE
             MOVE '\tps\prod\files\financal.pcl' TO FILESPEC
      ********* MAKE A DIRECTORY ***********
             MOVE FILESPEC              TO DIR-COMMAND-1
                                           DIR-COMMAND-3
             MOVE CLIENT-DIRECTORY(1:9) TO DIR-COMMAND-2
                                           DIR-COMMAND-4
             DISPLAY DIR-COMMAND UPON COMMAND-LINE
             CALL X'91' USING RESULT FUNCTION-35 NULL-PARAMETER
      ********* OPEN NEW FILE IN DIRECTORY ********
             ACCEPT FILESPEC FROM ENVIRONMENT-VALUE
             MOVE CLIENT-DIRECTORY  TO FILESPEC(16:22)
             MOVE FILESPEC          TO PRT-COMMAND-PATH.
          OPEN OUTPUT PRT-FILE.


          PERFORM 0400-TOP-OF-PAGE
             THRU 0400-EXIT.
          PERFORM 0200-READ-RECUR-FILE
             THRU 0200-EXIT.
          PERFORM 0250-SORT-THE-TABLE
             THRU 0250-EXIT.

          WRITE PRT-RECORD FROM COURIER-56 AFTER ADVANCING 1 LINE.
          WRITE PRT-RECORD FROM RPT-LAST-LINE AFTER ADVANCING 0 LINE.
          WRITE PRT-RECORD FROM THIN-LINE AFTER ADVANCING 0 LINE.
          WRITE PRT-RECORD FROM PCL-RESET AFTER ADVANCING 1 LINE.
          CLOSE PRT-FILE.
      ******* PRINT REPORT ********
          DISPLAY PRT-COMMAND-1 UPON COMMAND-LINE.
          CALL X'91' USING RESULT FUNCTION-35 NULL-PARAMETER.

          GO TO EXIT-THE-MODULE.
          STOP RUN.

       0001-EXIT.    EXIT.

       0100-OPEN-THE-FILES.

          IF RECEIVE-SWITCH = 'Y'
             GO TO 0100-EXIT.

          MOVE 1            TO TPSRECUR-FLAG.
          MOVE F-PRIME      TO FILE-KEY.
          MOVE F-OPEN-INPUT TO FILE-ACTION.
          CALL TPSIORCR USING FILE-REQUEST RECUR-REC.
          IF FILE-STATUS NOT = '00' AND '05'
             MOVE 'RECUR ' TO FILE-NAME
             MOVE 'TPS1013R-ORC' TO FILE-TEXT
             PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
             GO TO EXIT-THE-MODULE.
       0100-EXIT.    EXIT.

       0200-READ-RECUR-FILE.

          MOVE LOW-VALUES TO RECUR-KEY OF RECUR-REC.
          MOVE CLNT-PROFILE-ACCT-NO TO RECUR-ACCT-NO OF RECUR-REC.
          MOVE CLNT-PROFILE-SUB-ACCT TO RECUR-SUB-ACCT OF RECUR-REC.
          MOVE F-PRIME TO FILE-KEY.
          MOVE F-START TO FILE-ACTION.
          CALL TPSIORCR USING FILE-REQUEST RECUR-REC.
      *   IF NO-RECORD-WAS-FOUND OR END-OF-FILE-WAS-REACHED
      *      MOVE 'NO RECORDS FOUND FOR CLIENT' TO PRT-ADDRESSOR
      *      WRITE PRT-RECORD FROM PRT-LINE AFTER ADVANCING 1 LINE
      *      GO TO READ-THE-MAIL-EXIT.
          IF NOT A-SUCCESSFUL-OPERATION
             MOVE ' RECUR' TO FILE-NAME
             MOVE 'TPS1013R-SBR' TO FILE-TEXT
             PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
             GO TO EXIT-THE-MODULE.

          SET TBL-IDX TO ZERO.

       READ-RECUR-RECORDS.
          MOVE F-PRIME TO FILE-KEY.
          MOVE F-READ-NEXT TO FILE-ACTION.
          CALL TPSIORCR USING FILE-REQUEST RECUR-REC.

          IF END-OF-FILE-WAS-REACHED
             GO TO 0200-EXIT.

          IF NOT A-SUCCESSFUL-OPERATION
             MOVE ' RECUR' TO FILE-NAME
             MOVE 'TPS1013R-RN' TO FILE-TEXT
             PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
             GO TO EXIT-THE-MODULE.

          IF RECUR-ACCT-NO OF RECUR-REC NOT = CLNT-PROFILE-ACCT-NO OR
             RECUR-SUB-ACCT OF RECUR-REC NOT = CLNT-PROFILE-SUB-ACCT
             GO TO 0200-EXIT.
      *JM******* PROCESS BILLS ONLY ***********
      *05/10/01                                                                                                         
          IF RECUR-CHART-ACCT-01 OF RECUR-REC(1:2) NOT =                                                                
                                                '02' AND '11' and
                                                '31' AND '33'
             GO TO READ-RECUR-RECORDS.
005200
005200 BUILD-THE-TABLE.
005202    SET TBL-IDX UP BY 1.
005202    MOVE RECUR-CHART-ACCT-01 OF RECUR-REC
005202                       to TABLE-SORT-CHART-1(TBL-IDX).
005202    MOVE RECUR-CHART-ACCT-02 OF RECUR-REC
005202                       to TABLE-SORT-CHART-2(TBL-IDX).
005202    MOVE RECUR-CHART-ACCT-03 OF RECUR-REC
005202                       to TABLE-SORT-CHART-3(TBL-IDX).
005202    MOVE RECUR-CHART-ACCT-04 OF RECUR-REC
005202                       to TABLE-SORT-CHART-4(TBL-IDX).
005202    MOVE RECUR-ADDRESOR-NAME OF RECUR-REC
005202                       to TABLE-SORT-ADDRESSOR(TBL-IDX).
005202    MOVE RECUR-ADDRESEE-NAME OF RECUR-REC
005202                       to TABLE-SORT-ADDRESSEE(TBL-IDX).
005202    MOVE RECUR-PAYEE-ACCOUNT-NUMBER OF RECUR-REC
005202                       to TABLE-SORT-PAYEE-ACCOUNT(TBL-IDX).
008610    MOVE RECUR-ROOT-SECTION OF RECUR-REC
005202                       to TABLE-SAVE-RECUR-REC(tbl-idx).
          GO TO READ-RECUR-RECORDS.

       0200-EXIT.     EXIT.

       0250-SORT-THE-TABLE.
          SORT TABLE-RECUR-RECS ON ASCENDING KEY TABLE-SORT-KEY.
          MOVE 0 TO REC-IDX.

       0250-READ-THE-TABLE.
          SET REC-IDX UP BY 1.
          IF REC-IDX > TBL-IDX
             GO TO 0250-EXIT.

          MOVE TABLE-SAVE-RECUR-REC(REC-IDX)  TO RECUR-REC.

          MOVE SPACES                  TO WS-ADDRESSOR.
          MOVE 3                       TO WS-ADDRESS1-COUNT
          MOVE RECUR-ADDRESOR-NAME OF RECUR-REC   TO WS-ADDRESSOR1.
          MOVE RECUR-ADDRESOR-ADDRL1 OF RECUR-REC TO WS-ADDRESSOR2.
          IF RECUR-ADDRESOR-ADDRL2 OF RECUR-REC > SPACES
             MOVE 4                       TO WS-ADDRESS1-COUNT
             MOVE RECUR-ADDRESOR-ADDRL2 OF RECUR-REC TO WS-ADDRESSOR3.
          MOVE SPACES                     TO BG-FLOAT-PARMS.
          MOVE '3'                        TO BG-FLOAT-COUNT.
          MOVE RECUR-ADDRESOR-CITY OF RECUR-REC       TO BG-FLOAT-1.
          MOVE RECUR-ADDRESOR-STATE OF RECUR-REC      TO BG-FLOAT-2.
          IF RECUR-ADDRESOR-ZIPCODE OF RECUR-REC(6:4) > ZEROS
             MOVE RECUR-ADDRESOR-ZIPCODE OF RECUR-REC(1:5)
                                              TO BG-FLOAT-3(1:5)
             MOVE '-'                         TO BG-FLOAT-3(6:1)
             MOVE RECUR-ADDRESOR-ZIPCODE OF RECUR-REC(6:4)
                                              TO BG-FLOAT-3(7:4)
          ELSE
             MOVE RECUR-ADDRESOR-ZIPCODE OF RECUR-REC(1:5)
                                              TO BG-FLOAT-3(1:5).
          CALL FLOATBIG USING BG-FLOAT-DATA.
          CANCEL FLOATBIG.
          IF WS-ADDRESS1-COUNT = 3
             MOVE BG-FLOAT-1(1:36)        TO WS-ADDRESSOR3
          ELSE
             MOVE BG-FLOAT-1(1:36)        TO WS-ADDRESSOR4.

          MOVE SPACES                  TO WS-ADDRESSEE.
          MOVE 3                       TO WS-ADDRESS2-COUNT
          MOVE RECUR-ADDRESEE-NAME OF RECUR-REC    TO WS-ADDRESSEE1.
          MOVE RECUR-ADDRESEE-ADDRL1 OF RECUR-REC  TO WS-ADDRESSEE2.
          IF RECUR-ADDRESEE-ADDRL2 OF RECUR-REC > SPACES
             MOVE 4                       TO WS-ADDRESS2-COUNT
             MOVE RECUR-ADDRESEE-ADDRL2 OF RECUR-REC  TO WS-ADDRESSEE3.
          MOVE SPACES                     TO BG-FLOAT-PARMS.
          MOVE '3'                        TO BG-FLOAT-COUNT.
          MOVE RECUR-ADDRESEE-CITY OF RECUR-REC       TO BG-FLOAT-1.
          MOVE RECUR-ADDRESEE-STATE OF RECUR-REC      TO BG-FLOAT-2.
          IF RECUR-ADDRESEE-ZIPCODE OF RECUR-REC(6:4) > ZEROS
             MOVE RECUR-ADDRESEE-ZIPCODE OF RECUR-REC(1:5)
                                              TO BG-FLOAT-3(1:5)
             MOVE '-'                         TO BG-FLOAT-3(6:1)
             MOVE RECUR-ADDRESEE-ZIPCODE OF RECUR-REC(6:4)
                                              TO BG-FLOAT-3(7:4)
          ELSE
             MOVE RECUR-ADDRESEE-ZIPCODE OF RECUR-REC(1:5)
                                              TO BG-FLOAT-3(1:5).
          CALL FLOATBIG USING BG-FLOAT-DATA.
          CANCEL FLOATBIG.
          IF WS-ADDRESS2-COUNT = 3
             MOVE BG-FLOAT-1(1:36)        TO WS-ADDRESSEE3
          ELSE
             MOVE BG-FLOAT-1(1:36)        TO WS-ADDRESSEE4.

          IF RECUR-PRE-APPROVE-LOLIMIT OF RECUR-REC NOT NUMERIC AND
             RECUR-PRE-APPROVE-HILIMIT OF RECUR-REC NOT NUMERIC
             MOVE SPACES                     TO WS-HIAMOUNT
                                                WS-LOAMOUNT
             GO TO 0250-CONTINUE
          ELSE
             MOVE ZERO                 TO WS-CNT.

          IF RECUR-PRE-APPROVE-LOLIMIT OF RECUR-REC > ZERO OR
             RECUR-PRE-APPROVE-HILIMIT OF RECUR-REC > ZERO
             MOVE 4                          TO WS-ADDRESS1-COUNT
             MOVE RECUR-PRE-APPROVE-LOLIMIT OF RECUR-REC
                                            TO WS-WORK-LOAMOUNT
             MOVE RECUR-PRE-APPROVE-HILIMIT OF RECUR-REC
                                            TO WS-WORK-HIAMOUNT
             INSPECT WS-WORK-LOAMOUNT
                TALLYING WS-CNT FOR LEADING SPACES
             MOVE WS-WORK-LOAMOUNT(WS-CNT:)  TO WS-LOAMOUNT
             MOVE ZERO                       TO WS-CNT
             INSPECT WS-WORK-HIAMOUNT
                TALLYING WS-CNT FOR LEADING SPACES
             MOVE WS-WORK-HIAMOUNT(WS-CNT:)  TO WS-HIAMOUNT
          ELSE
             MOVE SPACES                     TO WS-HIAMOUNT
                                                WS-LOAMOUNT.
      *JM11/02 ***** ADD MAINTENANCE NAME & DATE *****
          IF RECUR-MAINTENANCE-FLAG OF RECUR-REC = 'A'
             MOVE 'ADD'                   TO WS-MAINT-ACT
          ELSE
             MOVE 'UPD'                   TO WS-MAINT-ACT.
          MOVE RECUR-TYPE-ACCT OF RECUR-REC  TO WS-MAINT-BY.
          MOVE RECUR-MAINTENANCE-DATE OF RECUR-REC  TO UNPACK-WORK-X.
          MOVE X'0F'                   TO UNPACK-WORK-SIGN.
          MOVE UNPACK-WORK-PL7         TO UNPACK-WORK.
          MOVE UNPACK-YY               TO WS-MAINT-YY.
          MOVE UNPACK-MM               TO WS-MAINT-MM.
          MOVE UNPACK-DD               TO WS-MAINT-DD.
          MOVE WS-MAINT-DATE-YMD       TO WS-MAINT-DATE.

       0250-CONTINUE.

            MOVE RECUR-REC       TO RECUR-ROOT-SECTION OF MAIL-REC.
            INITIALIZE   WS-PARMS.
            MOVE 3               TO WS-ACTION-PARM.
            CALL TPSCHART USING WS-PARMS
                                TPS-PROFL
                                MAIL-REC
                                WS-CURRENT-XY-PARM.
            CANCEL TPSCHART.

            MOVE WS-CURRENT-XY-PARM(1:4) TO WS-CURRENT-X.
            MOVE WS-CURRENT-XY-PARM(5:4) TO WS-CURRENT-Y.
          PERFORM 0300-PRINT-DATA THRU 0300-EXIT.
          WRITE PRT-RECORD FROM THIN-LINE AFTER ADVANCING 0 LINE.
          GO TO 0250-READ-THE-TABLE.

       0250-EXIT.     EXIT.

       0300-PRINT-DATA.

          IF LINES-PRINTED > 40
             PERFORM 0400-TOP-OF-PAGE THRU 0400-EXIT.

          MOVE WS-ADDRESSOR1              TO PRT-ADDRESSOR.
          MOVE WS-ADDRESSEE1              TO PRT-ADDRESSEE.
      *JM9/97 ***** ADD ACCTS PAY & RECV FOR BUSINESS ACCTS *****
      *05/10/01                                                                                                         
          IF (RECUR-CHART-ACCT-01 OF RECUR-REC(1:2) =                                                                   
                                             '02' OR '09' OR '11' OR                                                    
                                             '30' OR '31' OR '18' or                                                    
                                             '32' OR '33')  AND                                                         
             RECUR-CYCLE-EVENT OF RECUR-REC(1:1) > 0
             PERFORM 0310-PRT-CATEGORY THRU 0310-EXIT
          ELSE
             IF RECUR-ACCT-NO OF RECUR-REC(1:4) = 0101
                MOVE WS-ENGLISH-CHART-01(1:14)  TO PRT-CATEGORY
             ELSE
                MOVE WS-ENGLISH-CHART-01(1:40)  TO PRT-CATEGORY.

      *05/10/01                                                                                                         
          IF RECUR-CHART-ACCT-01 OF RECUR-REC(1:2) =                                                                    
                                             '02' OR '09' OR '11' OR                                                    
                                             '30' OR '31' OR '18' or                                                    
                                             '32' OR '33'                                                               
             MOVE RECUR-PAYEE-NAME OF RECUR-REC TO PRT-PAYEE
          ELSE
             MOVE SPACES                        TO PRT-PAYEE.

          WRITE PRT-RECORD FROM PRT-DATA AFTER ADVANCING 1 LINE.
          ADD  1                          TO LINES-PRINTED.

          MOVE WS-ADDRESSOR2              TO PRT-ADDRESSOR.
          MOVE WS-ADDRESSEE2              TO PRT-ADDRESSEE.
          MOVE WS-ENGLISH-CHART-02(1:40)  TO PRT-CATEGORY.

      *05/10/01                                                                                                         
          IF RECUR-CHART-ACCT-01 OF RECUR-REC(1:2) =                                                                    
                                             '02' OR '09' OR '11' OR                                                    
                                             '30' OR '31' OR '18' or                                                    
                                             '32' OR '33'                                                               
             MOVE RECUR-PAYEE-ACCOUNT-NUMBER OF RECUR-REC TO PRT-PAYEE
          ELSE
             MOVE SPACES                                  TO PRT-PAYEE.
          WRITE PRT-RECORD FROM PRT-DATA AFTER ADVANCING 1 LINE.
          ADD  1                          TO LINES-PRINTED.

          MOVE WS-ADDRESSOR3              TO PRT-ADDRESSOR.
          MOVE WS-ADDRESSEE3              TO PRT-ADDRESSEE.
          MOVE WS-ENGLISH-CHART-03(1:40)  TO PRT-CATEGORY
      *05/10/01                                                                                                         
      *JM11/02   IF WS-LOAMOUNT > SPACES AND
      *      RECUR-CATEGORY-CODE OF RECUR-REC = '02' OR '11' OR
      *                                         '31' OR '33'
          MOVE WS-LOW-AMOUNT           TO PRT-PAYEE
      *   ELSE
      *      MOVE SPACES                  TO PRT-PAYEE.
          WRITE PRT-RECORD FROM PRT-DATA AFTER ADVANCING 1 LINE.
          ADD  1                          TO LINES-PRINTED.

          IF WS-ADDRESS1-COUNT < 4 AND
             WS-ADDRESS2-COUNT < 4 AND
             WS-ENGLISH-CHART-04 = SPACES
             MOVE SPACES                     TO PRT-ADDRESSOR
             MOVE SPACES                     TO PRT-ADDRESSEE
             MOVE SPACES                     TO PRT-CATEGORY
          ELSE
             MOVE WS-ADDRESSOR4              TO PRT-ADDRESSOR
             MOVE WS-ADDRESSEE4              TO PRT-ADDRESSEE
             MOVE WS-ENGLISH-CHART-04(1:40)  TO PRT-CATEGORY.
      *JM11/02    IF WS-HIAMOUNT > SPACES AND
      *         RECUR-CATEGORY-CODE OF RECUR-REC = '02' OR '11' OR
      *                                            '31' OR '33'
          MOVE WS-HI-AMOUNT            TO PRT-PAYEE
      *      ELSE
      *         MOVE SPACES                  TO PRT-PAYEE.
          WRITE PRT-RECORD FROM PRT-DATA AFTER ADVANCING 1 LINE
          ADD  1                          TO LINES-PRINTED.


       0300-EXIT.     EXIT.

       0310-PRT-CATEGORY.

          MOVE SPACES                     TO BG-FLOAT-DATA.
          MOVE 2                          TO BG-FLOAT-COUNT.
          IF RECUR-CATEGORY-CODE OF RECUR-REC = '02' OR '11'                                                            
             MOVE 'Bills Received'        to BG-FLOAT-1
          ELSE
          IF RECUR-CATEGORY-CODE OF RECUR-REC = '30' OR '32'
             MOVE 'Receivables'           to BG-FLOAT-1
          ELSE
          IF RECUR-CATEGORY-CODE OF RECUR-REC = '31' OR '33'
             MOVE 'Payables'              to BG-FLOAT-1.

          SET FREQUENCY-INDEX TO 1.
          SEARCH PAYMENT-FREQUENCY-DATA
                 WHEN RECUR-CYCLE-EVENT OF RECUR-REC (2:1)
                    = TPS-FREQUENCY-CODE(FREQUENCY-INDEX)
                      MOVE TPS-FREQUENCY-NAME(FREQUENCY-INDEX)
                        TO BG-FLOAT-2
          END-SEARCH.

          IF RECUR-CYCLE-EVENT OF RECUR-REC (1:1) = '2'
             MOVE 3             TO BG-FLOAT-COUNT
             MOVE 'Automatic'  TO BG-FLOAT-3.

          CALL FLOATBIG USING BG-FLOAT-DATA.
          CANCEL FLOATBIG.

          MOVE BG-FLOAT-1              TO PRT-CATEGORY.

       0310-EXIT.     EXIT.

       0400-TOP-OF-PAGE.

          IF FIRST-PAGE = 'Y'
            WRITE PRT-RECORD FROM PCL-LANDSCAPE AFTER 0 LINE
            WRITE PRT-RECORD FROM PCL5-DUPLEX-ON AFTER 0 LINE
          ELSE
            WRITE PRT-RECORD FROM NEW-PAGE AFTER 0 LINE.

          WRITE PRT-RECORD FROM COURIER-56 AFTER ADVANCING 0 LINES.
          WRITE PRT-RECORD FROM HEADING-1  AFTER ADVANCING 0 LINE.
          WRITE PRT-RECORD FROM HEADING-1-A AFTER ADVANCING 0 LINE.
          ADD 1                            TO PAGES-PRINTED.
          MOVE PAGES-PRINTED               TO PAGES-PRINTED-MASK.
          MOVE PAGES-PRINTED-MASK          TO PRT-PAGE.
          WRITE PRT-RECORD FROM HEADING-2-A AFTER ADVANCING 0 LINE.
          WRITE PRT-RECORD FROM COURIER-59 AFTER ADVANCING 1 LINES.
          WRITE PRT-RECORD FROM HEADING-2 AFTER ADVANCING 0 LINE.
          WRITE PRT-RECORD FROM HEADING-3 AFTER ADVANCING 1 LINE.
          WRITE PRT-RECORD FROM COURIER-56 AFTER ADVANCING 1 LINES.
          MOVE  5                          TO LINES-PRINTED.

          IF FIRST-PAGE = 'Y'
           MOVE 'N'                   TO FIRST-PAGE
           MOVE SPACES                TO WS-FLOAT-PARMS
           IF CLNT-PROFILE-ACCT-NO = 0101000230 OR 0101000248
             MOVE WS-CLIENT                  TO WS-FLOAT-1(1:9)
             MOVE CLNT-PROFILE-LAST-NAME     TO WS-FLOAT-1(10:20)
           ELSE
             MOVE '3'                        TO WS-FLOAT-COUNT
             MOVE WS-CLIENT                  TO WS-FLOAT-1
             MOVE CLNT-PROFILE-FIRST-NAME    TO WS-FLOAT-2
             IF CLNT-PROFILE-MDDL-INIT  > SPACES
                MOVE '4'                       TO WS-FLOAT-COUNT
                MOVE CLNT-PROFILE-MDDL-INIT    TO WS-FLOAT-3(1:1)
                MOVE '.'                       TO WS-FLOAT-3(2:1)
                MOVE CLNT-PROFILE-LAST-NAME    TO WS-FLOAT-4
             ELSE
                MOVE CLNT-PROFILE-LAST-NAME    TO WS-FLOAT-3
             END-IF
             CALL FLOATIT USING WS-FLOAT-DATA
             CANCEL FLOATIT
           END-IF.

          MOVE WS-FLOAT-1(1:100)            TO RPT-CLIENT-NAME.
          ADD  2                            TO LINES-PRINTED.
          WRITE PRT-RECORD FROM RPT-CLIENT  AFTER ADVANCING 2 LINES.
          WRITE PRT-RECORD FROM RPT-SECTION-HDR1
                                          AFTER ADVANCING 2 LINES.
          WRITE PRT-RECORD FROM BOLD-LINE AFTER ADVANCING 0 LINES.
          WRITE PRT-RECORD FROM PRINT-SETUP AFTER ADVANCING 0 LINES.

       0400-EXIT.     EXIT.

       EXIT-THE-MODULE.

          SEEIF-TPSRECUR-ISOPEN.
              IF NOT TPSRECUR-OPEN
                 GO TO END-OF-THE-LINE.

            SET FR-CLOSE         TO TRUE
            CALL TPSIORCR USING FILE-REQUEST RECUR-REC.
           IF NOT A-SUCCESSFUL-OPERATION
               MOVE 'RECUR' TO FILE-NAME
               MOVE 'TPS1013R-CLOSE' TO FILE-TEXT
               PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
               IF PROCESS-2-DISPLAY-FLAG = 1
                   invoke PROCESS-2::Hide
                   MOVE 0 TO PROCESS-2-DISPLAY-FLAG
               END-IF
               GOBACK GIVING CURRENT-XY-PARAMETERS.


       END-OF-THE-LINE.

            CANCEL TPSDATES.
            CANCEL TPSIOERR.
            CANCEL TPSCHART.

           IF PROCESS-2-DISPLAY-FLAG = 1
               invoke PROCESS-2::Hide
               MOVE 0 TO PROCESS-2-DISPLAY-FLAG
           END-IF


           INITIALIZE CURRENT-XY-PARAMETERS.
           MOVE WS-CURRENT-X TO CURRENT-XY-PARAMETERS(1:4).
           MOVE WS-CURRENT-Y TO CURRENT-XY-PARAMETERS(5:4).

           GOBACK GIVING CURRENT-XY-PARAMETERS.

       FILE-ERROR.
            CALL TPSIOERR USING FILE-REQUEST
                                WS-CURRENT-XY-PARM.
            CANCEL TPSIOERR.

            MOVE WS-CURRENT-XY-PARM(1:4) TO WS-CURRENT-X.
            MOVE WS-CURRENT-XY-PARM(5:4) TO WS-CURRENT-Y.

            INITIALIZE CURRENT-XY-PARAMETERS.
            MOVE WS-CURRENT-X TO CURRENT-XY-PARAMETERS(1:4).
            MOVE WS-CURRENT-Y TO CURRENT-XY-PARAMETERS(5:4).

       FILE-ERROR-EXIT. EXIT.

