       IDENTIFICATION DIVISION.
       PROGRAM-ID. TPS1010M.
       AUTHOR. JIM MONAGHAN.
      ***************************************************************
      *    RECURRING MAIL CONTROL LOG (MISSING MAIL REPORT)         *
      *    READ INPUT RECURRING FILE, IF CYCLE EVENT IS MONTHLY     *
      *    BI-MONTHLY OR QUARTERLY ETC. SEE IF MAIL WAS RECEIVED IN *
      *    THE TIME FRAME ALLOTTED. IF NOT PRINT INFO ON THE REPORT *
      ***************************************************************
      *                  MAINTENANCE LOG                            *
      *                                                             *
      * 07/14/17 CHANGED GUI                                        *
      * 09/19/01 ADD 10 MORE DAYS TO CALCULATION TO BE MORE ACCURATE*
      * 06/26/01 ADD DUPLEX PRINTING.                            JM *
      * 01/26/00 PRINT ALL GROUPS & CLIENTS TOGETHER.            JM *
      * 12/14/99 AT 700-CONTINUE, ENSURE THAT INDEX WS-TAB HAS A    *                                                   
      *    TS    VALUE OF 1, BETWEEN 2 SORTS RESET WS-HOLD-CYCLE '9'*
      *          AT END, COMMENT OUT CLOSE & CANCEL OF TPSIO004.....*
      * 01/22/99 FIX YEAR END CALCULATION.                       JM *
      * 12/30/98 ADD CHECK FOR EXPIRATION DATE.                  JM *
      * 10/06/97 CHANGE 'AA' LOOKUP USE CUURENT LOGON NAME TO MAKE  *
      *    JM    PROCESS RUN FASTER.                                *
      * 02/13/97 WHEN CHECKING THE MAIL DAYS, IT MUST BE < 7000     *
      *    JM    BECAUSE AT YR END THE # JUMPS > 8000.              *
      * 10/21/96 ADD CHECK FOR RECUR-CHART-ACCT-01 = 02         JM  *
      * 02/29/96 SORT BY PA & AA, ADD TEMPORARY CODE TO FILL        *
      *          RECUR-ADMIN-LOGON WITH 'NYLEZUT   ' AA NAME.       *
      ***************************************************************
       ENVIRONMENT DIVISION.
       CONFIGURATION SECTION.
       SOURCE-COMPUTER. IBM-PS2.
       OBJECT-COMPUTER. IBM-PS2.
       FILE-CONTROL.

       SELECT PRT-FILE
       ASSIGN TO DYNAMIC FILESPEC
       ORGANIZATION IS LINE SEQUENTIAL.

      *SELECT SORT-FILE ASSIGN TO '\SORTFILE.DAT'.
      *SELECT SORTWORK  ASSIGN TO '\SORTWORK.DAT'.

       SELECT SORT-FILE ASSIGN TO 'C:\TPS\APP\SORTFILE.DAT'.
       SELECT SORTWORK  ASSIGN TO 'C:\TPS\APP\SORTWORK.DAT'.

       DATA DIVISION.
       FILE SECTION.

       FD  PRT-FILE
           LABEL RECORDS ARE OMITTED
           RECORD CONTAINS 200 CHARACTERS.
       01  PRT-RECORD                     PIC X(200).

       FD  SORTWORK
           RECORD CONTAINS 150 CHARACTERS.
       01  SW-RECORD.
            05 SW-SORT-KEY                PIC X(65).
            05 SW-SORT-REC                PIC X(85).

       SD  SORT-FILE
           RECORD CONTAINS 150 CHARACTERS.
       01  SORT-RECORD.
            05 SORT-KEY                   PIC X(65).
            05 SORT-REC                   PIC X(85).

       WORKING-STORAGE SECTION.

       01  PROGRAM-NAMES.
094600  10 GUISCREEN   PIC X(08) VALUE 'GS    '.                                           00011370
        10 SCREENIO    PIC X(08) VALUE 'SCRNIO'.
        10 TPSIOREC    PIC X(08) VALUE 'TPSIOREC'.
        10 TPSIOERR    PIC X(08) VALUE 'TPSIOERR'.
        10 TPSIORCR    PIC X(08) VALUE 'TPSIORCR'.
        10 TPSIO001    PIC X(08) VALUE 'TPSIO001'.
        10 TPSIO004    PIC X(08) VALUE 'TPSIO004'.
        10 TPSDEDIT    PIC X(08) VALUE 'TPSDEDIT'.
        10 TPSVEDIT    PIC X(08) VALUE 'TPSVEDIT'.
        10 TPSDATES    PIC X(08) VALUE 'TPSDATES'.
        10 FLOATBIG    PIC X(08) VALUE 'FLOATBIG'.
        10 FLOATIT     PIC X(08) VALUE 'FLOATIT'.
        10 FILLER      PIC X(08) VALUE HIGH-VALUES.
       01  PROGRAM-NAMES-R REDEFINES PROGRAM-NAMES.
        10 PROGRAM-NAME PIC X(08) OCCURS 20 TIMES.

       01  FILESPEC                    PIC X(80) VALUE SPACES.
           COPY "TPSFILES.CPY".
           COPY "KEYVALUE.CPY".
           COPY "PCLVALUE.CPY".
           COPY "PCL5VALU.CPY".
           COPY "TPSKEYS.CPY".
           COPY "MAILPROS.COB".
           COPY "PRINTING.COB".

       01  TPSLOGON-FLAG              PIC 9(01) VALUE 0.
           88 TPSLOGON-OPEN                     VALUE 1.
       01  TPSRECUR-FLAG              PIC 9(01) VALUE 0.
           88 TPSRECUR-OPEN                     VALUE 1.
       01  TPSMAIL-FLAG               PIC 9(01) VALUE 0.
           88 TPSMAIL-OPEN                      VALUE 1.
       01  TPSPROFL-FLAG              PIC 9(01) VALUE 0.
           88 TPSPROFL-OPEN                     VALUE 1.

       01  DIR-COMMAND.
           05 FILLER                  PIC  X(13) VALUE 'IF NOT EXIST '.
           05 DIR-COMMAND-1           PIC  X(15).
           05 DIR-COMMAND-2           PIC  X(09).
           05 FILLER                  PIC  X(04) VALUE '\*.*'.
           05 FILLER                  PIC  X(04) VALUE ' MD '.
           05 DIR-COMMAND-3           PIC  X(15).
           05 DIR-COMMAND-4           PIC  X(09).
       01  PRT-COMMAND-1.
           05 PRT-COMMAND-P           PIC  X(08) VALUE 'COPY /B '.
           05 PRT-COMMAND-PATH        PIC  X(50).
           05 FILLER                  PIC  X(12) VALUE '/A PRN > NUL'.
       01  RESULT                     PIC  99 COMP-X.
       01  FUNCTION-35                PIC  99 COMP-X VALUE 35.
       01  NULL-PARAMETER.
            05  FILLER                PIC  99 COMP-X VALUE 0.
            05  FILLER                PIC  X.

       01 CLIENT-DIRECTORY.
          10 FILLER                         PIC X(01) VALUE '\'.
          10 PRT-PATH.
             20 PRT-PATH-NAME               PIC X(08).
          10 FILLER                         PIC X(01) VALUE '\'.
          10 PRT-PATH-REPORT.
             20 PRT-PATH-RPT-TYPE           PIC X(08).
          10 FILLER                         PIC X(01) VALUE '.'.
          10 PRT-PATH-EXT.
             20 PRT-PATH-RPT-NO             PIC X(03).


       01 NEW-PAGE              PIC X VALUE X'0C'.
       01 BLANK-LINE.
          10 FILLER PIC X     VALUE X'1B'.
          10 FILLER PIC X(10) VALUE '*p+0010y0X'.
       01 DRAW-VARIABLE-COLUMN.
      **********DRAW FIRST LINE DOWN THE PAGE.
                10 FILLER PIC X     VALUE X'1B'.
                10 FILLER PIC X(12) VALUE '*p0400y3050X'.
                10 FILLER PIC X     VALUE X'1B'.
                10 FILLER PIC X(07) VALUE '*c0005a'.
                10 PAGE-ENDING-1    PIC 9(04).
                10 FILLER PIC X(03) VALUE 'b0P'.
      **********DRAW SECOND LINE DOWN THE PAGE.
                10 FILLER PIC X     VALUE X'1B'.
                10 FILLER PIC X(12) VALUE '*p0400y3175X'.
                10 FILLER PIC X     VALUE X'1B'.
                10 FILLER PIC X(07) VALUE '*c0005a'.
                10 PAGE-ENDING-2    PIC 9(04).
                10 FILLER PIC X(03) VALUE 'b0P'.
       01 SHADE-CLIENT.
                10 FILLER PIC X     VALUE X'1B'.
                10 FILLER PIC X(17) VALUE '*c1000a0060b11g2P'.
       01  THIN-LINE.
      **********DRAW A THIN BLACK LINE FROM LEFT MARGIN TO RIGHT.
                10 FILLER PIC X     VALUE X'1B'.
                10 FILLER PIC X(14) VALUE '*c4000a0005b0P'.
      **********MOVE DOWN AND OVER TO THE LEFT MARGIN
                10 FILLER PIC X     VALUE X'1B'.
                10 FILLER PIC X(10) VALUE '*p-0005y0X'.
       01 DISP-LINE.
      **********DRAW A THIN BLACK LINE FROM LEFT MARGIN TO RIGHT.
                10 FILLER PIC X     VALUE X'1B'.
                10 FILLER PIC X(07) VALUE '*p0100X'.
                10 FILLER PIC X     VALUE X'1B'.
                10 FILLER PIC X(14) VALUE '*c4000a0005b0P'.
      **********MOVE DOWN AND OVER TO THE LEFT MARGIN
                10 FILLER PIC X     VALUE X'1B'.
                10 FILLER PIC X(10) VALUE '*p-0005y0X'.
       01  AMOUNT-PROPORTIONAL.
           30 FILLER PIC X(01) VALUE X'1B'.
           30 FILLER PIC X(04) VALUE  '(s1p'.
           30 FILLER PIC X(13) VALUE  '12v0s0b4101T'.
       01  AMOUNT-MONOSPACE.
           30 FILLER PIC X(01) VALUE X'1B'.
           30 FILLER PIC X(04) VALUE  '(s0p'.
           30 FILLER PIC X(13) VALUE  '10h0s1b4101T'.

       01 HEADING-1.
          10 FILLER PIC X(01) VALUE SPACE.
          10 FILLER PIC X(01) VALUE X'1B'.
          10 FILLER PIC X(02) VALUE  '*p'.
          10 Y-AXIS PIC X(04) VALUE  '0050'.
          10 FILLER PIC X(01) VALUE  'y'.
          10 X-AXIS PIC X(04) VALUE  '1050'.
          10 FILLER PIC X(01) VALUE  'X'.
          10 FILLER PIC X(50) VALUE
                 'RECURRING MAIL CONTROL LOG'.
       01 HEADING-1-A.
          10 FILLER PIC X(01) VALUE SPACE.
          10 FILLER PIC X(01) VALUE X'1B'.
          10 FILLER PIC X(02) VALUE  '*p'.
          10 Y-AXIS PIC X(04) VALUE  '0050'.
          10 FILLER PIC X(01) VALUE  'y'.
          10 X-AXIS PIC X(04) VALUE  '2600'.
          10 FILLER PIC X(01) VALUE  'X'.
          10 PRT-RPT-DATE     PIC X(20).
       01 HEADING-2-A.
          10 FILLER PIC X(01) VALUE SPACE.
          10 FILLER PIC X(01) VALUE X'1B'.
          10 FILLER PIC X(02) VALUE  '*p'.
          10 Y-AXIS PIC X(04) VALUE  '0100'.
          10 FILLER PIC X(01) VALUE  'y'.
          10 X-AXIS PIC X(04) VALUE  '2600'.
          10 FILLER PIC X(01) VALUE  'X'.
          10 FILLER           PIC X(04) VALUE 'Page'.
          10 PRT-PAGE         PIC X(03).
          10 FILLER           PIC X(04) VALUE ' of '.
          10 PRT-TOTAL-PAGE   PIC X(03).
       01 HEADING-2.
          10 FILLER PIC X(01) VALUE SPACE.
          10 FILLER PIC X(01) VALUE X'1B'.
          10 FILLER PIC X(02) VALUE  '*p'.
          10 Y-AXIS PIC X(04) VALUE  '0100'.
          10 FILLER PIC X(01) VALUE  'y'.
          10 X-AXIS PIC X(04) VALUE  '1150'.
          10 FILLER PIC X(01) VALUE  'X'.
          10 FILLER PIC X(50) VALUE
                 'TPS Administrative Group LLC'.
       01 HEADING-3.
          10 FILLER PIC X(01) VALUE SPACE.
          10 FILLER PIC X(01) VALUE X'1B'.
          10 FILLER PIC X(02) VALUE  '*p'.
          10 Y-AXIS PIC X(04) VALUE  '0150'.
          10 FILLER PIC X(01) VALUE  'y'.
          10 X-AXIS PIC X(04) VALUE  '1000'.
          10 FILLER PIC X(01) VALUE  'X'.
          10 FILLER PIC X(51) VALUE
               '"Taking Care of Your Personal Business...Privately"'.

       01 PA-NAME.
          10 FILLER                  PIC X(05) VALUE 'PA - '.
          10 RPT-PA-NAME             PIC X(100).

       01 AA-NAME.
          10 FILLER                  PIC X(05) VALUE 'AA - '.
          10 RPT-AA-NAME             PIC X(100).

       01 WS-CLIENT                  PIC X(08) VALUE 'CLIENT: '.
       01 RPT-CLIENT.
      *   10 FILLER                  PIC X(01) VALUE x'1B'.
      *   10 FILLER                  PIC X(07) VALUE '*p1000X'.
          10 RPT-CLIENT-NAME         PIC X(150).

       01 RPT-SECTION-HDR1.
          10 FILLER                  PIC X(01) VALUE x'1B'.
          10 FILLER                  PIC X(07) VALUE '*p0075X'.
          10 FILLER                  PIC X(09) VALUE
                 'DATE LAST'.
          10 FILLER                  PIC X(01) VALUE x'1B'.
          10 FILLER                  PIC X(07) VALUE '*p3060X'.
          10 FILLER                  PIC X(04) VALUE
                 'APP'.

       01 RPT-SECTION-HDR2.
          10 FILLER                  PIC X(01) VALUE x'1B'.
          10 FILLER                  PIC X(07) VALUE '*p0075X'.
          10 FILLER                  PIC X(08) VALUE
                 'RECEIVED'.
          10 FILLER                  PIC X(01) VALUE x'1B'.
          10 FILLER                  PIC X(07) VALUE '*p0500X'.
          10 FILLER                  PIC X(09) VALUE
                 'FOR      '.
          10 FILLER                  PIC X(01) VALUE x'1B'.
          10 FILLER                  PIC X(07) VALUE '*p1450X'.
          10 FILLER                  PIC X(09) VALUE
                 'FROM     '.
          10 FILLER                  PIC X(01) VALUE x'1B'.
          10 FILLER                  PIC X(07) VALUE '*p2500X'.
          10 FILLER                  PIC X(07) VALUE
                 'ACCOUNT'.
          10 FILLER                  PIC X(01) VALUE x'1B'.
          10 FILLER                  PIC X(07) VALUE '*p3060X'.
          10 FILLER                  PIC X(04) VALUE
                 'INIT'.

       01 RPT-SECTION-HDR3.
          10 RPT-SECTION-NME         PIC X(24).
          10 FILLER                  PIC X(01) VALUE SPACE.
          10 FILLER                  PIC X(23) VALUE
                 'Total recurring mail = '.
          10 RPT-SECTION-TOTAL       PIC X(04).
          10 FILLER                  PIC X(03) VALUE SPACE.
          10 FILLER                  PIC X(16) VALUE
                 'Reported mail = '.
          10 RPT-SECTION-RPTD        PIC X(04).

       01 PRINT-DATA.
          10 FILLER                  PIC X(01) VALUE x'1B'.
          10 FILLER                  PIC X(07) VALUE '*p0050X'.
          10 PRT-AUTO                PIC X(08).
          10 FILLER                  PIC X(01) VALUE x'1B'.
          10 FILLER                  PIC X(07) VALUE '*p0100X'.
          10 PRT-REC-DATE            PIC X(08).
          10 FILLER                  PIC X(01) VALUE x'1B'.
          10 FILLER                  PIC X(07) VALUE '*p0375X'.
          10 PRT-FROM-NAME           PIC X(36).
          10 FILLER                  PIC X(01) VALUE x'1B'.
          10 FILLER                  PIC X(07) VALUE '*p1300X'.
          10 PRT-FOR-NAME            PIC X(36).
          10 FILLER                  PIC X(01) VALUE x'1B'.
          10 FILLER                  PIC X(07) VALUE '*p2500X'.
          10 PRT-ACCOUNT-NO          PIC X(22).
      **  10 FILLER                  PIC X(01) VALUE x'1B'.
      **  10 FILLER                  PIC X(07) VALUE '*p3075X'.
      **  10 FILLER                  PIC X(04) VALUE '____'.

       01 PRINT-DISP.
          10 FILLER                  PIC X(01) VALUE x'1B'.
          10 FILLER                  PIC X(07) VALUE '*p0100X'.
          10 FILLER                  PIC X(12) VALUE 'Disposition:'.

       01 PAGE-END.
          10 FILLER                  PIC X(03) VALUE SPACES.
          10 FILLER                  PIC X(21) VALUE
                '* = automatic payment'.

       01 RPT-LAST-LINE.
          10 FILLER                  PIC X(03) VALUE SPACES.
          10 FILLER                  PIC X(21) VALUE
                '* = automatic payment'.
          10 FILLER                  PIC X(64) VALUE SPACES.
          10 FILLER                  PIC X(15) VALUE
                'End of Report'.


       01 LAST-LINE.
          10 FILLER                  PIC X(01) VALUE x'1B'.
          10 FILLER                  PIC X(04) VALUE '*p0x'.
          10 LAST-LINE-NO            PIC 9(04).
          10 FILLER                  PIC X(01) VALUE 'Y'.

       01 CONFIDENTIAL-LINE-1.
          10 FILLER                  PIC X(43) VALUE
             'Any and all information concerning clients '.
          10 FILLER                  PIC X(36) VALUE
             'is deemed by TPS to be confidential.'.
       01 CONFIDENTIAL-LINE-2.
          10 FILLER                  PIC X(41) VALUE
             'Employees are prohibited from copying or '.
          10 FILLER                  PIC X(36) VALUE
             'disclosing confidential information.'.

       01 PAGES-PRINTED      PIC  9(03) VALUE 00.
       01 PAGES-PRINTED-MASK PIC  ZZZ.
       01 LINES-PRINTED      PIC  9(03) VALUE 0.
       01 MAIL-MASK          PIC  ZZZZ.


       01  WS-SORT-RECORD.
           05 WS-SORT-KEY.
              10 WS-SORT-ACCT-BRANCH          PIC  X(02).
              10 WS-SORT-ACCT-ADMIN           PIC  X(02).
              10 WS-SORT-ACCESS-LEVEL         PIC  X(02).
              10 WS-SORT-ACCT-LOGON           PIC  X(10).
              10 WS-SORT-ACCT-NO              PIC  9(10).
              10 WS-SORT-SUB-ACCT             PIC  9(02).
              10 WS-SORT-CYCLE                PIC  9(01).
              10 WS-SORT-FOR-NAME             PIC  X(36).
           05 WS-SORT-RECV-DATE               PIC  9(08).
           05 WS-SORT-FROM-NAME               PIC  X(36).
           05 WS-SORT-BILL-ACCT               PIC  X(22).
           05 WS-SORT-NOT-FND                 PIC  X(01).
           05 FILLER                          PIC  X(18).

       01  WS-CLIENT-TABLE.
           05 CLIENT-TABLE-NAMES OCCURS 1 TO 1000 TIMES
                                 DEPENDING ON WS-SUB.
              10 TABLE-ACCT-NO              PIC  9(10).
              10 TABLE-SUB-ACCT             PIC  9(02).
              10 TABLE-LAST-NAME            PIC  X(20).
              10 TABLE-FIRST-NAME           PIC  X(15).
              10 TABLE-MDDL-INIT            PIC  X(01).
              10 TABLE-TOT-MTH-MAIL         PIC  9(04).
              10 TABLE-TOT-BMTH-MAIL        PIC  9(04).
              10 TABLE-TOT-QRTR-MAIL        PIC  9(04).
              10 TABLE-TOT-SANL-MAIL        PIC  9(04).
              10 TABLE-TOT-ANUL-MAIL        PIC  9(04).
      *01/XX/01                                                                                                         
              10 TABLE-TOT-BIAN-MAIL        PIC  9(04).
              10 TABLE-TOT-WEEK-MAIL        PIC  9(04).
              10 TABLE-TOT-BIWK-MAIL        PIC  9(04).
              10 TABLE-PRT-MTH-MAIL         PIC  9(04).
              10 TABLE-PRT-BMTH-MAIL        PIC  9(04).
              10 TABLE-PRT-QRTR-MAIL        PIC  9(04).
              10 TABLE-PRT-SANL-MAIL        PIC  9(04).
              10 TABLE-PRT-ANUL-MAIL        PIC  9(04).
      *01/XX/01                                                                                                         
              10 TABLE-PRT-BIAN-MAIL        PIC  9(04).
              10 TABLE-PRT-WEEK-MAIL        PIC  9(04).
              10 TABLE-PRT-BIWK-MAIL        PIC  9(04).

       01  WS-ACCT-DEL-TABLE.
           05 ACCT-DEL-TABLE OCCURS 1 TO 1000 TIMES
                                 DEPENDING ON DEL-SUB.
              10 DELETE-ACCT-NO             PIC  9(10).

       01  WS-FLIP-PAY-DATE.
           05 WS-FLIP-YY                    PIC  9(02).
           05 WS-FLIP-MM                    PIC  9(02).
           05 WS-FLIP-DD                    PIC  9(02).

       01  WS-FLOAT-DATA.
           05  WS-FLOAT-PARMS               PIC  X(101).
           05  FILLER REDEFINES WS-FLOAT-PARMS.
               10  WS-FLOAT-COUNT           PIC  X(01).
               10  WS-FLOAT-1               PIC  X(25).
               10  WS-FLOAT-2               PIC  X(25).
               10  WS-FLOAT-3               PIC  X(25).
               10  FILLER REDEFINES WS-FLOAT-3.
                   15  WS-FLOAT-3-A         PIC  X(22).
                   15  WS-FLOAT-3-B         PIC  X(03).
               10  WS-FLOAT-4               PIC  X(25).

       01  BG-FLOAT-DATA.
           05  BG-FLOAT-PARMS               PIC  X(161).
           05  FILLER REDEFINES BG-FLOAT-PARMS.
               10  BG-FLOAT-COUNT           PIC  X(01).
               10  BG-FLOAT-1               PIC  X(40).
               10  BG-FLOAT-2               PIC  X(40).
               10  BG-FLOAT-2-R REDEFINES BG-FLOAT-2.
                   15  BG-FLOAT-2-I         PIC  X(01) OCCURS 40 TIMES.
               10  BG-FLOAT-3               PIC  X(40).
               10  FILLER REDEFINES BG-FLOAT-3.
                   15  BG-FLOAT-3-A         PIC  X(37).
                   15  BG-FLOAT-3-B         PIC  X(03).
               10  BG-FLOAT-3-R REDEFINES BG-FLOAT-3.
                   15  BG-FLOAT-3-I         PIC  X(01) OCCURS 40 TIMES.
               10  BG-FLOAT-4               PIC  X(40).
016400*
000100 01 CONVERT-TO-CAPITALS         PIC X(01) VALUE 'Y'.
000100 01 WS-ADDRESOR-NAME            PIC X(36).
000100 01 WS-ADDRESEE-NAME            PIC X(36).
000100 01 LENGTH-36                   PIC 999   VALUE 36.
000100 01 CHECK-ACCT-NO               PIC X(10) VALUE 'N'.
000100 01 WS-HOLD-ACCT-NO             PIC 9(10) VALUE 0.
000100 01 WS-HOLD-CYCLE               PIC 9(01) VALUE 9.
000100 01 FIRST-SORT-REC              PIC X(01) VALUE 'Y'.
000100 01 WS-SUB                      PIC 9(04) VALUE 0.
000100 01 DEL-SUB                     PIC 9(04) VALUE 0.
000100 01 TAB-SUB                     PIC 9(03) VALUE 0.
000100 01 WS-TAB                      PIC 9(04) VALUE 0.
000100 01 NO-MAIL                     PIC X(01) VALUE 'N'.
000100 01 MAIL-DAYS                   PIC 9(05) VALUE 0.
000100 01 WS-ACCT-NO                  PIC 9(10) VALUE 0.
000100 01 ACCT-DELETED                PIC X(01) VALUE 'N'.
000100 01 LOGREC-RETURN-KEY           PIC X(10).
000100
000100 01 HOLD-ACCT-BRANCH            PIC 9(02) VALUE ZERO.
000100 01 HOLD-ACCT-ADMIN             PIC 9(02) VALUE ZERO.
000100 01 HOLD-ACCT-LOGON             PIC X(10) VALUE SPACES.
006000
037200 01 TODAYS-DATE-YMD.
037200    05 WS-TODAYS-DATE-YY       PIC  9(02).
037200    05 WS-TODAYS-DATE-MM       PIC  9(02).
037200    05 WS-TODAYS-DATE-DD       PIC  9(02).
006000
037200 01 TODAYS-DATE-CYMD.
037200    05 TODAYS-DATE-CC          PIC  9(02).
037200    05 TODAYS-DATE-YY          PIC  9(02).
037200    05 TODAYS-DATE-MM          PIC  9(02).
037200    05 TODAYS-DATE-DD          PIC  9(02).
006000
037200 01 WORK-DATE                  PIC  9(08).
037210*
037220  01  WS-TODAYS-DATE-ENGLISH     PIC  X(20).
037300*
037500  01  WS-REPORT-DATE             PIC  X(20).
037700
037800  01  WS-DATE-REQUEST.
037900      05  WS-DATE-PARAM          PIC  9(02).
038000
038100      05  WS-DATE-TENBYTES       PIC  X(20) VALUE SPACES.
038200      05  FILLER REDEFINES WS-DATE-TENBYTES.
038300          10  WS-DATE-REFORM         PIC  X(06).
038400          10  WS-DATE-EXTEND         PIC  X(04).
038500          10  FILLER                 PIC  X(10).
038600      05  FILLER REDEFINES WS-DATE-TENBYTES.
038700          10  WS-DATE-REFORM-LEN06   PIC  X(06).
038800          10  FILLER                 PIC  X(14).
038900      05  FILLER REDEFINES WS-DATE-TENBYTES.
039000          10  WS-DATE-REFORM-LEN08   PIC  X(08).
039100          10  FILLER                 PIC  X(12).
039200      05  FILLER REDEFINES WS-DATE-TENBYTES.
039300          10  WS-DATE-REFORM-LEN10   PIC  X(10).
039400          10  FILLER                 PIC  X(10).
039500      05  FILLER REDEFINES WS-DATE-TENBYTES.
039600          10  WS-TIME-PARM1          PIC  X(06).
039700          10  WS-TIME-PARM2          PIC  X(06).
039800          10  WS-TIME-EXTEND         PIC  X(08).
039900      05  FILLER REDEFINES WS-DATE-TENBYTES.
040000          10  WS-TIME-PARM1BY8       PIC  X(08).
040100          10  WS-TIME-PARM2BY8       PIC  X(08).
040200          10  WS-TIME-EXTNDBY8       PIC  X(04).
040300

       01 TPS-RECUR.
           COPY "TPSRECUR.CPY".
       01 TPS-MAIL.
           COPY "TPSMAIL.CPY".

       LINKAGE SECTION.
       01 TPS-LOGON.
           COPY "TPSLOGON.CPY".
       01 TPS-PROFL.
           COPY "TPSPROFL.CPY".
019900 01  LINK-PARMS.                                                      00073700
020000      05  PARMS                       PIC  X(250).                    00073800
020100      05  FILLER REDEFINES PARMS.                                     00073900
020200          10  PARM01                  PIC  9(12).                     00074000
020201          10  FILLER REDEFINES PARM01.                                00074100
020210              15 PARM01-ACCOUNT-NUMBER  PIC  9(10).                   00074200
020220              15 PARM01-SUB-ACCT        PIC  9(02).                   00074300
020300          10  PARM02                  PIC  9(01).                     00074400
020400              88  PARM02-NEW-ACCT                VALUE 1.             00074500
020500          10  PARM03                  PIC  9(01).                     00074600
020600              88  PARM03-MAINT-ACCT              VALUE 1.             00074700
020700          10  PARM04                  PIC  9(01).                     00074800
020600              88  PARM04-DELETE-ACCT             VALUE 1.             00074900
020800          10  PARM05                  PIC  9(01).                     00075000
020600              88  PARM03-UNDELETE-ACCT           VALUE 1.             00075100
020900          10  PARM06                  PIC  9(01).                     00075200
021000          10  PARM07                  PIC  9(01).                     00075300
021100          10  PARM08                  PIC  9(01).                     00075400
021200          10  PARM09                  PIC  9(01).                     00075500
021300          10  PARM10                  PIC  9(01).                     00075600
021400          10  FILLER                  PIC  X(231).                    00075700

       PROCEDURE DIVISION USING TPS-LOGON TPS-PROFL LINK-PARMS.

       001-MAIN-STREAM.

          PERFORM 100-OPEN-FILES THRU 100-EXIT.

          ACCEPT TODAYS-DATE-YMD FROM DATE.
          MOVE TODAYS-DATE-YMD      TO TODAYS-DATE-CYMD(3:6).
          IF WS-TODAYS-DATE-YY > 94
             MOVE 19                TO TODAYS-DATE-CC
          ELSE
             MOVE 20                TO TODAYS-DATE-CC.

          MOVE 06                   TO WS-DATE-PARAM.
          MOVE TODAYS-DATE-YMD      TO WS-DATE-REFORM.
          MOVE SPACES               TO WS-DATE-EXTEND.
          CALL TPSDATES USING WS-DATE-REQUEST.
          MOVE WS-DATE-TENBYTES     TO PRT-RPT-DATE.

          PERFORM 050-LOAD-TABLES THRU 050-EXIT.
      ******* HOLD KEY TO RESET LOGON RECORD *******
          MOVE LOGREC-KEY           TO LOGREC-RETURN-KEY.

      ******* SET UP SORT RECORD *********

          PERFORM 200-PROCESS-DATA THRU 500-EXIT.
          CLOSE SORTWORK.

          SORT SORT-FILE
               ON ASCENDING SORT-KEY
               USING SORTWORK
               OUTPUT PROCEDURE IS 600-PRINT-THE-DATA THRU 900-EXIT.

      ****** CLOSE PRT-FILE SET UP TOTAL PAGES & RESET FLAGS ******
          MOVE PAGES-PRINTED           TO PAGES-PRINTED-MASK.
          MOVE PAGES-PRINTED-MASK      TO PRT-TOTAL-PAGE.
          MOVE 0                       TO PAGES-PRINTED
                                          WS-TAB
                                          LINES-PRINTED
                                          HOLD-ACCT-BRANCH
                                          HOLD-ACCT-ADMIN.
000100*12/14/99                                                                                                         
000100    MOVE '9'                     TO WS-HOLD-CYCLE.                                                                
          MOVE SPACES                  TO HOLD-ACCT-LOGON.
          MOVE 'Y'                     TO FIRST-SORT-REC.
          SORT SORT-FILE
               ON ASCENDING SORT-KEY
               USING SORTWORK
               OUTPUT PROCEDURE IS 600-PRINT-THE-DATA THRU 900-EXIT.

      ******* PRINT REPORT *********

          DISPLAY PRT-COMMAND-1 UPON COMMAND-LINE
          CALL X'91' USING RESULT FUNCTION-35 NULL-PARAMETER.
      ******* RESET PROFILE RECORD WHEN SELECTED REPORT *********
          IF PARM10 = 1
             NEXT SENTENCE
          ELSE
             MOVE 1                         TO PARM06                        00077900
             MOVE PARM01-ACCOUNT-NUMBER     TO CLNT-PROFILE-ACCT-NO          00077900
             MOVE PARM01-SUB-ACCT           TO CLNT-PROFILE-SUB-ACCT         00078000
             SET FR-READ                    TO TRUE                                        00080500
             CALL TPSIO004 USING FILE-REQUEST TPS-PROFL.                     00080600

          DELETE FILE SORTWORK.
          GO TO EXIT-THE-MODULE.

       001-EXIT.

       050-LOAD-TABLES.

          MOVE ZEROS                TO CLNT-PROFILE-KEY.
          MOVE F-PRIME TO FILE-KEY
          MOVE F-START TO FILE-ACTION
          CALL TPSIO004 USING FILE-REQUEST TPS-PROFL
          IF NOT A-SUCCESSFUL-OPERATION
             MOVE 'PROFILE ' TO FILE-NAME
             MOVE 'TPS1010M-START' TO FILE-TEXT
             CALL TPSIOERR USING FILE-REQUEST
             GO TO EXIT-THE-MODULE.

       050-CONTINUE.

          MOVE F-PRIME TO FILE-KEY
          MOVE F-READ-NEXT  TO FILE-ACTION
          CALL TPSIO004 USING FILE-REQUEST TPS-PROFL

          IF END-OF-FILE-WAS-REACHED
             GO TO 050-EXIT.

          IF NOT A-SUCCESSFUL-OPERATION
             MOVE 'PROFILE' TO FILE-NAME
             MOVE 'TPS1010M-RN ' TO FILE-TEXT
             CALL TPSIOERR USING FILE-REQUEST
             GO TO EXIT-THE-MODULE.

          IF CLNT-PROFILE-SUB-ACCT NOT = ZERO
             GO TO 050-CONTINUE.

          IF CLNT-PROFILE-ADD-DATE(1:1) = 8 OR 9
             ADD 1                       TO DEL-SUB
             MOVE CLNT-PROFILE-ACCT-NO   TO DELETE-ACCT-NO(DEL-SUB)
             GO TO 050-CONTINUE.
      *JM01/00 ****** PRINT ALL GROUPS & CLIENTS ******
      *   IF PARM01-ACCOUNT-NUMBER(1:4) NOT =
      *                                  CLNT-PROFILE-ACCT-NO(1:4)
      *      ADD 1                       TO DEL-SUB
      *      MOVE CLNT-PROFILE-ACCT-NO   TO DELETE-ACCT-NO(DEL-SUB)
      *      GO TO 050-CONTINUE.

          ADD 1                         TO WS-SUB.
          MOVE CLNT-PROFILE-ACCT-NO     TO TABLE-ACCT-NO(WS-SUB).
          MOVE CLNT-PROFILE-SUB-ACCT    TO TABLE-SUB-ACCT(WS-SUB).
          MOVE CLNT-PROFILE-LAST-NAME   TO TABLE-LAST-NAME(WS-SUB).
          MOVE CLNT-PROFILE-FIRST-NAME  TO TABLE-FIRST-NAME(WS-SUB).
          MOVE CLNT-PROFILE-MDDL-INIT   TO TABLE-MDDL-INIT(WS-SUB).
          MOVE ZEROS                    TO TABLE-TOT-MTH-MAIL(WS-SUB)
                                           TABLE-TOT-BMTH-MAIL(WS-SUB)
                                           TABLE-TOT-QRTR-MAIL(WS-SUB)
                                           TABLE-TOT-SANL-MAIL(WS-SUB)
                                           TABLE-TOT-ANUL-MAIL(WS-SUB)
                                           TABLE-PRT-MTH-MAIL(WS-SUB)
                                           TABLE-PRT-BMTH-MAIL(WS-SUB)
                                           TABLE-PRT-QRTR-MAIL(WS-SUB)
                                           TABLE-PRT-SANL-MAIL(WS-SUB)
                                           TABLE-PRT-ANUL-MAIL(WS-SUB).

          GO TO 050-CONTINUE.

       050-EXIT.      EXIT.

       100-OPEN-FILES.

          OPEN OUTPUT SORTWORK.

          MOVE F-PRIME      TO FILE-KEY.
          MOVE F-OPEN-INPUT TO FILE-ACTION.

          IF NOT TPSLOGON-OPEN
             MOVE 1                TO TPSLOGON-FLAG
             CALL TPSIO001 USING FILE-REQUEST TPS-LOGON
             IF FILE-STATUS NOT = '00'
                MOVE 'TPSLOGON' TO FILE-NAME
                MOVE 'TPS1010M-OP' TO FILE-TEXT
                CALL TPSIOERR USING FILE-REQUEST.

          IF NOT TPSRECUR-OPEN
             MOVE 1                TO TPSRECUR-FLAG
             CALL TPSIORCR USING FILE-REQUEST TPS-RECUR
             IF FILE-STATUS NOT = '00'
                MOVE 'RECURRING' TO FILE-NAME
                MOVE 'TPS1010M'  TO FILE-TEXT
                CALL TPSIOERR USING FILE-REQUEST.

          IF NOT TPSMAIL-OPEN
             MOVE 1                TO TPSMAIL-FLAG
             CALL TPSIOREC USING FILE-REQUEST TPS-MAIL
             IF FILE-STATUS NOT = '00'
                MOVE 'RECEIVE ' TO FILE-NAME
                MOVE 'TPS1010M-OP' TO FILE-TEXT
                CALL TPSIOERR USING FILE-REQUEST.

          IF NOT TPSPROFL-OPEN
             MOVE 1                TO TPSPROFL-FLAG
             CALL TPSIO004 USING FILE-REQUEST TPS-PROFL
             IF FILE-STATUS NOT = '00'
                MOVE 'PROFILE  ' TO FILE-NAME
                MOVE 'TPS1010M-OP'  TO FILE-TEXT
                CALL TPSIOERR USING FILE-REQUEST.

       100-EXIT.

       200-PROCESS-DATA.

          MOVE LOW-VALUES              TO RECUR-KEY OF TPS-RECUR.
          ADD 1                        TO TAB-SUB.
          IF TAB-SUB > WS-SUB
             GO TO 500-EXIT.
          MOVE TABLE-ACCT-NO(TAB-SUB)  TO RECUR-ACCT-NO OF TPS-RECUR.
          MOVE TABLE-SUB-ACCT(TAB-SUB) TO RECUR-SUB-ACCT OF TPS-RECUR.
          MOVE F-PRIME TO FILE-KEY.
          MOVE F-START TO FILE-ACTION.
          CALL TPSIORCR USING FILE-REQUEST TPS-RECUR.

          IF NO-RECORD-WAS-FOUND
             GO TO 500-EXIT
          END-IF.
          IF NOT A-SUCCESSFUL-OPERATION
             MOVE ' RECUR' TO FILE-NAME
             MOVE 'TPS1010M-SBR' TO FILE-TEXT
             CALL TPSIOERR USING FILE-REQUEST
             GO TO EXIT-THE-MODULE
          END-IF.

       200-BROWSE-THE-RECUR-FILE.
          MOVE F-PRIME TO FILE-KEY.
          MOVE F-READ-NEXT TO FILE-ACTION.
          CALL TPSIORCR USING FILE-REQUEST TPS-RECUR.

          IF END-OF-FILE-WAS-REACHED
             GO TO 500-EXIT
          END-IF.
          IF NOT A-SUCCESSFUL-OPERATION
             MOVE ' RECUR' TO FILE-NAME
             MOVE 'TPS101OF-RN ' TO FILE-TEXT
             CALL TPSIOERR USING FILE-REQUEST
             GO TO EXIT-THE-MODULE
          END-IF.
      ****** CHECK ACCOUNT NUMBER ********
          IF RECUR-ACCT-NO OF TPS-RECUR NOT NUMERIC
             GO TO 200-BROWSE-THE-RECUR-FILE.
          IF RECUR-ACCT-NO OF TPS-RECUR NOT = TABLE-ACCT-NO(TAB-SUB)
             GO TO 200-PROCESS-DATA.
      *JM01/00 ******* USE TABLE TO LOOK AT RECUR FILE *******
      *   IF RECUR-ACCT-NO OF TPS-RECUR NOT = WS-ACCT-NO
      *      MOVE RECUR-ACCT-NO OF TPS-RECUR  TO WS-ACCT-NO
      *      MOVE 'N'                         TO ACCT-DELETED
      *      PERFORM 250-CHECK-DEL-TABLE VARYING TAB-SUB FROM 1 BY 1
      *                                  UNTIL TAB-SUB > DEL-SUB
      *      IF ACCT-DELETED = 'Y'
      *         GO TO 200-BROWSE-THE-RECUR-FILE
      *      END-IF
      *      PERFORM VARYING TAB-SUB FROM 1 BY 1 UNTIL
      *          RECUR-ACCT-NO OF TPS-RECUR = TABLE-ACCT-NO(TAB-SUB)
      *         CONTINUE
      *      END-PERFORM.
      *      IF ACCT-DELETED = 'Y'
      *         GO TO 200-BROWSE-THE-RECUR-FILE.
      ****JM 10/21/96 ****** CHECK FOR BILLS ********
          IF RECUR-CHART-ACCT-01 OF TPS-RECUR(1:2) = '02' OR
                                                     '31' OR '33'
             NEXT SENTENCE
          ELSE
             GO TO 200-BROWSE-THE-RECUR-FILE.
      ****** CHECK FOR SCHEDULED OR AUTOMATIC EVENTS ********
          IF RECUR-CYCLE-EVENT OF TPS-RECUR(1:1) = '1' OR '2'
             NEXT SENTENCE
          ELSE
             GO TO 200-BROWSE-THE-RECUR-FILE.
      ****** CHECK FOR MONTHLY BI-MONTHLY OR QUARTERLY EVENTS ******
      *01/xx/01                                                                                                         
      *   IF RECUR-CYCLE-EVENT OF TPS-RECUR(2:1) = '0' OR '1' OR '2' OR
      *                                            '3' OR '4'
          IF RECUR-CYCLE-EVENT OF TPS-RECUR(2:1) = '0' OR '1' OR '2' OR
                                                   '3' OR '4' OR '5' OR
                                                   '6' OR '7'                
             NEXT SENTENCE
          ELSE
             GO TO 200-BROWSE-THE-RECUR-FILE.
      ****** CHECK FOR EXPIRED ACCOUNTS ********
          IF RECUR-EXPIRE-DATE OF TPS-RECUR > ZEROS
             IF RECUR-EXPIRE-DATE OF TPS-RECUR <= TODAYS-DATE-CYMD
                GO TO 200-BROWSE-THE-RECUR-FILE.
      ****** DO NOT PROCESS PAYROLL RECORD *******
          IF RECUR-CYCLE-EVENT OF TPS-RECUR(1:1) = '1' AND
             RECUR-CYCLE-AMOUNT OF TPS-RECUR > ZERO
             GO TO 200-BROWSE-THE-RECUR-FILE.
      ****** ADD TOTAL PIECE COUNT TO CLIENT-TABLE ******
          IF RECUR-CYCLE-EVENT OF TPS-RECUR(2:1) = '0'
             ADD 1                 TO TABLE-TOT-MTH-MAIL(TAB-SUB)
          ELSE
          IF RECUR-CYCLE-EVENT OF TPS-RECUR(2:1) = '1'
             ADD 1                 TO TABLE-TOT-BMTH-MAIL(TAB-SUB)
          ELSE
          IF RECUR-CYCLE-EVENT OF TPS-RECUR(2:1) = '2'
             ADD 1                 TO TABLE-TOT-QRTR-MAIL(TAB-SUB)
          ELSE
          IF RECUR-CYCLE-EVENT OF TPS-RECUR(2:1) = '3'
             ADD 1                 TO TABLE-TOT-SANL-MAIL(TAB-SUB)
          ELSE
          IF RECUR-CYCLE-EVENT OF TPS-RECUR(2:1) = '4'
             ADD 1                 TO TABLE-TOT-ANUL-MAIL(TAB-SUB) 
      *01/XX/01
          ELSE
          IF RECUR-CYCLE-EVENT OF TPS-RECUR(2:1) = '5'
             ADD 1                 TO TABLE-TOT-BIAN-MAIL(TAB-SUB) 
          ELSE
          IF RECUR-CYCLE-EVENT OF TPS-RECUR(2:1) = '6'
             ADD 1                 TO TABLE-TOT-WEEK-MAIL(TAB-SUB) 
          ELSE
          IF RECUR-CYCLE-EVENT OF TPS-RECUR(2:1) = '7'
             ADD 1                 TO TABLE-TOT-BIWK-MAIL(TAB-SUB) 
           END-IF.
                                 
      ***** SET UP ACCT NO. & NAMES FOR COMPARISIONS ********
          IF RECUR-PAYEE-ACCOUNT-NUMBER OF TPS-RECUR > SPACES
             MOVE 'Y'              TO CHECK-ACCT-NO
           CALL TPSDEDIT USING RECUR-PAYEE-ACCOUNT-NUMBER OF TPS-RECUR
          ELSE
             MOVE 'N'              TO CHECK-ACCT-NO.

          MOVE RECUR-ADDRESOR-NAME OF TPS-RECUR   TO WS-ADDRESOR-NAME.
          CALL TPSVEDIT USING CONVERT-TO-CAPITALS
                              LENGTH-36
                              WS-ADDRESOR-NAME.
          MOVE RECUR-ADDRESEE-NAME OF TPS-RECUR   TO WS-ADDRESEE-NAME.
          CALL TPSVEDIT USING CONVERT-TO-CAPITALS
                              LENGTH-36
                              WS-ADDRESEE-NAME.

          PERFORM 300-FIND-LAST-PAYMENT THRU 300-EXIT

          GO TO 200-BROWSE-THE-RECUR-FILE.

       200-EXIT.  EXIT.

       250-CHECK-DEL-TABLE.

          IF RECUR-ACCT-NO OF TPS-RECUR = DELETE-ACCT-NO(TAB-SUB)
             MOVE 'Y'               TO ACCT-DELETED.

       250-EXIT.  EXIT.

       260-SETUP-MISSING-REC.

          MOVE RECUR-ACCT-NO OF TPS-RECUR  TO WS-SORT-ACCT-NO.
          MOVE RECUR-SUB-ACCT OF TPS-RECUR TO WS-SORT-SUB-ACCT.
          MOVE RECUR-CYCLE-EVENT OF TPS-RECUR(2:1) TO WS-SORT-CYCLE.
          IF RECUR-CYCLE-EVENT OF TPS-RECUR(2:1) = '0'
             ADD 1                 TO TABLE-TOT-MTH-MAIL(TAB-SUB)
             ADD 1                 TO TABLE-PRT-MTH-MAIL(TAB-SUB)
          ELSE
          IF RECUR-CYCLE-EVENT OF TPS-RECUR(2:1) = '1'
             ADD 1                 TO TABLE-TOT-BMTH-MAIL(TAB-SUB)
             ADD 1                 TO TABLE-PRT-BMTH-MAIL(TAB-SUB)
          ELSE
          IF RECUR-CYCLE-EVENT OF TPS-RECUR(2:1) = '2'
             ADD 1                 TO TABLE-TOT-QRTR-MAIL(TAB-SUB)
             ADD 1                 TO TABLE-PRT-QRTR-MAIL(TAB-SUB)
          ELSE
          IF RECUR-CYCLE-EVENT OF TPS-RECUR(2:1) = '3'
             ADD 1                 TO TABLE-TOT-SANL-MAIL(TAB-SUB)
             ADD 1                 TO TABLE-PRT-SANL-MAIL(TAB-SUB)
          ELSE
          IF RECUR-CYCLE-EVENT OF TPS-RECUR(2:1) = '4'
             ADD 1                 TO TABLE-TOT-ANUL-MAIL(TAB-SUB)
             ADD 1                 TO TABLE-PRT-ANUL-MAIL(TAB-SUB)                                                      
      *01/XX/01
          ELSE
          IF RECUR-CYCLE-EVENT OF TPS-RECUR(2:1) = '5'
             ADD 1                 TO TABLE-TOT-BIAN-MAIL(TAB-SUB)
             ADD 1                 TO TABLE-PRT-BIAN-MAIL(TAB-SUB) 
          ELSE
          IF RECUR-CYCLE-EVENT OF TPS-RECUR(2:1) = '6'
             ADD 1                 TO TABLE-TOT-WEEK-MAIL(TAB-SUB)
             ADD 1                 TO TABLE-PRT-WEEK-MAIL(TAB-SUB) 
          ELSE
          IF RECUR-CYCLE-EVENT OF TPS-RECUR(2:1) = '7'
             ADD 1                 TO TABLE-TOT-BIWK-MAIL(TAB-SUB)
             ADD 1                 TO TABLE-PRT-BIWK-MAIL(TAB-SUB) 
           END-IF.

          IF RECUR-CYCLE-DATE OF TPS-RECUR NUMERIC
             MOVE RECUR-CYCLE-DATE OF TPS-RECUR TO WORK-DATE
             IF WORK-DATE(3:2) > 94
                MOVE 19            TO WORK-DATE(1:2)
             ELSE
                MOVE 20            TO WORK-DATE(1:2)
             END-IF
             MOVE WORK-DATE        TO WS-SORT-RECV-DATE
          ELSE
             MOVE ZEROS            TO WS-SORT-RECV-DATE
          END-IF.
      *JM10/97   IF RECUR-ADMIN-LOGON OF TPS-RECUR = SPACES
      *      MOVE 'NYLEZUT   ' TO RECUR-ADMIN-LOGON OF TPS-RECUR
      *   END-IF.
      *   MOVE RECUR-ADMIN-LOGON OF TPS-RECUR  TO LOGREC-KEY.
      *   PERFORM 450-READ-LOGON-FILE THRU 450-EXIT.
          MOVE LOGREC-ADMIN-ACCT-BRANCH TO WS-SORT-ACCT-BRANCH.
          MOVE LOGREC-ADMIN-ACCT-ADMIN  TO WS-SORT-ACCT-ADMIN.
          MOVE LOGREC-ACCESS-LEVEL      TO WS-SORT-ACCESS-LEVEL.
          MOVE LOGREC-KEY               TO WS-SORT-ACCT-LOGON.
          MOVE RECUR-ADDRESEE-NAME OF TPS-RECUR
                                   TO WS-SORT-FROM-NAME.
          MOVE RECUR-ADDRESOR-NAME OF TPS-RECUR
                                   TO WS-SORT-FOR-NAME.
          MOVE RECUR-PAYEE-ACCOUNT-NUMBER OF TPS-RECUR
                                   TO WS-SORT-BILL-ACCT.
          MOVE 'Y'                 TO WS-SORT-NOT-FND.
          WRITE SW-RECORD FROM WS-SORT-RECORD.

       260-EXIT.  EXIT.

       300-FIND-LAST-PAYMENT.

          MOVE RECUR-ACCT-NO OF TPS-RECUR  TO MAIL-ACCT-NO.
          MOVE RECUR-SUB-ACCT OF TPS-RECUR TO MAIL-SUB-ACCT.
          MOVE TODAYS-DATE-CYMD            TO MAIL-RECEIVE-DATE.
          MOVE 90                          TO MAIL-RECEIVE-NUMBER.
          MOVE F-PRIME TO FILE-KEY.
          MOVE F-START-LOW TO FILE-ACTION.
          CALL TPSIOREC USING FILE-REQUEST TPS-MAIL.

          IF END-OF-FILE-WAS-REACHED
             MOVE ZERO                        TO FILE-STATUS
             PERFORM 260-SETUP-MISSING-REC THRU 260-EXIT
             GO TO 300-EXIT.

      *JM IF NOT A-SUCCESSFUL-OPERATION
      *      MOVE ' RECEIVE' TO FILE-NAME
      *      MOVE 'TPS1010M-SBR' TO FILE-TEXT
      *      CALL TPSIOERR USING FILE-REQUEST
      *      GO TO EXIT-THE-MODULE.

          MOVE F-PRIME TO FILE-KEY.
          MOVE F-READ-PREVIOUS TO FILE-ACTION.

       300-FIND-LAST-PAYMENT-LOOP.
          CALL TPSIOREC USING FILE-REQUEST TPS-MAIL.
          IF END-OF-FILE-WAS-REACHED OR
             MAIL-ACCT-NO NOT = RECUR-ACCT-NO OF TPS-RECUR OR
             MAIL-SUB-ACCT NOT = RECUR-SUB-ACCT OF TPS-RECUR
             MOVE ZERO                   TO FILE-STATUS
             PERFORM 260-SETUP-MISSING-REC THRU 260-EXIT
             GO TO 300-EXIT.

          IF NOT A-SUCCESSFUL-OPERATION
             MOVE ' RECEIVE' TO FILE-NAME
             MOVE 'TPS1010M-READP' TO FILE-TEXT
             CALL TPSIOERR USING FILE-REQUEST
             GO TO EXIT-THE-MODULE.

      ***** CHECK IF PAYEE NAME IS STARTS WITH SAME LETTER ******
          IF MAIL-ADDRESOR-NAME(1:1) NOT = WS-ADDRESOR-NAME(1:1)
             GO TO 300-FIND-LAST-PAYMENT-LOOP.
      ***** SET UP ACCT NO. FOR COMPARISION ********
          IF CHECK-ACCT-NO = 'Y'
             CALL TPSDEDIT USING
                      RECUR-PAYEE-ACCOUNT-NUMBER OF TPS-MAIL
             IF RECUR-PAYEE-ACCOUNT-NUMBER OF TPS-MAIL NOT =
                RECUR-PAYEE-ACCOUNT-NUMBER OF TPS-RECUR
                GO TO 300-FIND-LAST-PAYMENT-LOOP.

      ***** SET UP NAMES FOR COMPARISIONS ********
          CALL TPSVEDIT USING CONVERT-TO-CAPITALS
                              LENGTH-36
                              MAIL-ADDRESOR-NAME.
          CALL TPSVEDIT USING CONVERT-TO-CAPITALS
                              LENGTH-36
                              MAIL-ADDRESEE-NAME.

          IF MAIL-ADDRESOR-NAME = WS-ADDRESOR-NAME AND
             MAIL-ADDRESEE-NAME = WS-ADDRESEE-NAME
             PERFORM 400-SEE-IF-LATE THRU 400-EXIT
             GO TO 300-EXIT.

          GO TO 300-FIND-LAST-PAYMENT-LOOP.

       300-EXIT.
           EXIT.

       400-SEE-IF-LATE.

      ****** CALCULATE NUMBER OF DAYS SINCE LAST MAIL RECEIVED ******
          MOVE TODAYS-DATE-CYMD      TO WORK-DATE.
          SUBTRACT MAIL-RECEIVE-DATE OF TPS-MAIL FROM WORK-DATE
                   GIVING MAIL-DAYS.

      ****** CHECK FOR MONTHLY EVENTS ******
          IF RECUR-CYCLE-EVENT OF TPS-RECUR(2:1) = '0'
             IF (MAIL-DAYS > 110 AND < 7000) OR MAIL-DAYS > 8900
                MOVE 0                 TO WS-SORT-CYCLE
                ADD 1                  TO TABLE-PRT-MTH-MAIL(TAB-SUB)
                PERFORM 500-EXTRACT-DATA.
      ****** CHECK FOR BI-MONTHLY EVENTS ******
          IF RECUR-CYCLE-EVENT OF TPS-RECUR(2:1) = '1'
             IF (MAIL-DAYS > 210 AND < 7000) OR MAIL-DAYS > 9000
                MOVE 1                 TO WS-SORT-CYCLE
                ADD 1                  TO TABLE-PRT-BMTH-MAIL(TAB-SUB)
                PERFORM 500-EXTRACT-DATA.
      ****** CHECK FOR QUARTERLY EVENTS ******
          IF RECUR-CYCLE-EVENT OF TPS-RECUR(2:1) = '2'
             IF (MAIL-DAYS > 310 AND < 7000) OR MAIL-DAYS > 9100
                MOVE 2                 TO WS-SORT-CYCLE
                ADD 1                  TO TABLE-PRT-QRTR-MAIL(TAB-SUB)
                PERFORM 500-EXTRACT-DATA.
      ****** CHECK FOR SEMI-ANNUAL EVENTS ******
          IF RECUR-CYCLE-EVENT OF TPS-RECUR(2:1) = '3'
             IF (MAIL-DAYS > 610 AND < 7000) OR MAIL-DAYS > 9400
                MOVE 3                 TO WS-SORT-CYCLE
                ADD 1                  TO TABLE-PRT-SANL-MAIL(TAB-SUB)
                PERFORM 500-EXTRACT-DATA.
      ****** CHECK FOR ANNUAL EVENTS ******
          IF RECUR-CYCLE-EVENT OF TPS-RECUR(2:1) = '4' AND
             MAIL-DAYS > 10010
             MOVE 4                 TO WS-SORT-CYCLE
             ADD 1                  TO TABLE-PRT-ANUL-MAIL(TAB-SUB)
             PERFORM 500-EXTRACT-DATA.

       400-EXIT.    EXIT.

       450-READ-LOGON-FILE.

          MOVE F-PRIME TO FILE-KEY.
          MOVE F-START TO FILE-ACTION.
          CALL TPSIO001 USING FILE-REQUEST TPS-LOGON.
          IF NOT A-SUCCESSFUL-OPERATION
             MOVE 'LOGON' TO FILE-NAME
             MOVE 'TPS1010M-START' TO FILE-TEXT
             PERFORM FILE-ERROR THRU FILE-ERROR-EXIT.

       450-CONTINUE.

          MOVE F-PRIME      TO FILE-KEY.
          MOVE F-READ-NEXT  TO FILE-ACTION.
          CALL TPSIO001 USING FILE-REQUEST TPS-LOGON.
          IF NOT A-SUCCESSFUL-OPERATION
             MOVE 'LOGON' TO FILE-NAME
             MOVE 'TPS1010M-READ' TO FILE-TEXT
             PERFORM FILE-ERROR THRU FILE-ERROR-EXIT.

          IF WS-SORT-ACCT-BRANCH = LOGREC-ADMIN-ACCT-BRANCH AND
             WS-SORT-ACCT-ADMIN  = LOGREC-ADMIN-ACCT-ADMIN
             GO TO 450-EXIT
          ELSE
             GO TO 450-CONTINUE.

       450-EXIT.    EXIT.

       500-EXTRACT-DATA.

      ***** THIS CODE IS TEMPORARY UNTIL RECUR UPDATE IS DONE *****
      *JM10/97 SKIP THIS CODE TO SPEED UP PROCESSING *************
      *JM10/97 USE LOGON FROM CURRENT LOGON          *************
      *JM10/97   IF RECUR-ADMIN-LOGON OF TPS-RECUR = SPACES
      *   MOVE 'NYLEZUT   '      TO RECUR-ADMIN-LOGON OF TPS-RECUR.
      *   MOVE RECUR-ADMIN-LOGON OF TPS-RECUR  TO LOGREC-KEY.
      *   PERFORM 450-READ-LOGON-FILE THRU 450-EXIT.
          MOVE LOGREC-ADMIN-ACCT-BRANCH TO WS-SORT-ACCT-BRANCH.
          MOVE LOGREC-ADMIN-ACCT-ADMIN  TO WS-SORT-ACCT-ADMIN.
          MOVE LOGREC-ACCESS-LEVEL      TO WS-SORT-ACCESS-LEVEL.
          MOVE LOGREC-KEY               TO WS-SORT-ACCT-LOGON.
          MOVE MAIL-ACCT-NO             TO WS-SORT-ACCT-NO.
          MOVE MAIL-SUB-ACCT            TO WS-SORT-SUB-ACCT.
          MOVE MAIL-RECEIVE-DATE        TO WS-SORT-RECV-DATE.
          MOVE RECUR-ADDRESEE-NAME OF TPS-RECUR
                                        TO WS-SORT-FROM-NAME.
          MOVE RECUR-ADDRESOR-NAME OF TPS-RECUR
                                        TO WS-SORT-FOR-NAME.
          MOVE RECUR-PAYEE-ACCOUNT-NUMBER OF TPS-MAIL
                                        TO WS-SORT-BILL-ACCT.
      ***** WHEN AUTOMATIC PAYMENT MOVE 'A' **********
          IF RECUR-CYCLE-EVENT OF TPS-RECUR(1:1) = '2'
             MOVE 'A'                   TO WS-SORT-NOT-FND
          ELSE
             MOVE 'N'                   TO WS-SORT-NOT-FND.

          WRITE SW-RECORD FROM WS-SORT-RECORD.

       500-EXIT.      EXIT.

       600-PRINT-THE-DATA.

      ********* SET UP ARCHIVE DIRECTORY ***********
          MOVE 'TPSREPRT'                TO PRT-PATH-NAME.
          MOVE 'MISSMAIL'                TO PRT-PATH-RPT-TYPE.
          MOVE 'RPT'                     TO PRT-PATH-RPT-NO.

          IF FILESPEC NOT > SPACES
             MOVE 'NUL'                TO FILESPEC
          ELSE
      *      DISPLAY "TPSFCAL" UPON ENVIRONMENT-NAME
      *      ACCEPT FILESPEC FROM ENVIRONMENT-VALUE
             MOVE '\tps\prod\files\financal.pcl' TO FILESPEC
      ********* MAKE A DIRECTORY ***********
             MOVE FILESPEC              TO DIR-COMMAND-1
                                           DIR-COMMAND-3
             MOVE CLIENT-DIRECTORY(1:9) TO DIR-COMMAND-2
                                           DIR-COMMAND-4
             DISPLAY DIR-COMMAND UPON COMMAND-LINE
             CALL X'91' USING RESULT FUNCTION-35 NULL-PARAMETER
      ********* OPEN NEW FILE IN DIRECTORY ********
      *      ACCEPT FILESPEC FROM ENVIRONMENT-VALUE
             MOVE CLIENT-DIRECTORY  TO FILESPEC(16:22)
             MOVE FILESPEC          TO PRT-COMMAND-PATH.
          OPEN OUTPUT PRT-FILE.

       700-PRINT-DETAIL.

          RETURN SORT-FILE
             AT END
             GO TO 900-END-PRINT.

          INITIALIZE WS-SORT-RECORD.
          MOVE SORT-RECORD         TO WS-SORT-RECORD.

      ******* PRINT NEW PAGE ********
          IF LINES-PRINTED > 40
             PERFORM 800-HEADING THRU 800-EXIT.

          IF WS-SORT-ACCT-BRANCH NOT = HOLD-ACCT-BRANCH AND
             WS-SORT-ACCT-ADMIN  NOT = HOLD-ACCT-ADMIN
             MOVE WS-SORT-ACCT-BRANCH  TO HOLD-ACCT-BRANCH
             MOVE WS-SORT-ACCT-ADMIN   TO HOLD-ACCT-ADMIN
             PERFORM 750-READ-PA-REC   THRU 750-EXIT
             PERFORM 850-FLOAT-NAME    THRU 850-EXIT
             MOVE WS-FLOAT-1(1:100)    TO RPT-PA-NAME
             MOVE WS-SORT-ACCT-LOGON   TO LOGREC-KEY
                                          HOLD-ACCT-LOGON
             PERFORM 450-READ-LOGON-FILE THRU 450-EXIT
             PERFORM 850-FLOAT-NAME    THRU 850-EXIT
             MOVE WS-FLOAT-1(1:100)    TO RPT-AA-NAME
             PERFORM 800-HEADING THRU 800-EXIT.

          IF WS-SORT-ACCT-LOGON  NOT = HOLD-ACCT-LOGON
             MOVE WS-SORT-ACCT-LOGON   TO LOGREC-KEY
                                          HOLD-ACCT-LOGON
             PERFORM 450-READ-LOGON-FILE THRU 450-EXIT
             PERFORM 800-HEADING THRU 800-EXIT.

          IF WS-SORT-ACCT-NO = WS-HOLD-ACCT-NO
             GO TO 700-CONTINUE.
          MOVE 9                    TO WS-HOLD-CYCLE.
          MOVE WS-SORT-ACCT-NO      TO WS-HOLD-ACCT-NO.
          MOVE ZERO                 TO WS-TAB.

       710-TABLE-LOOKUP.

          ADD 1                             TO WS-TAB.
          IF WS-TAB > WS-SUB
             MOVE 'CLIENT NOT ON TABLE'     TO RPT-CLIENT-NAME
          ELSE
          IF TABLE-ACCT-NO(WS-TAB) = WS-SORT-ACCT-NO
             NEXT SENTENCE
          ELSE
             GO TO 710-TABLE-LOOKUP.

          MOVE SPACES                       TO WS-FLOAT-PARMS.
          IF TABLE-ACCT-NO(WS-TAB) = 0101000230 OR 0101000248
             MOVE 'CLIENT: '                TO WS-FLOAT-1(1:8)
             MOVE TABLE-LAST-NAME(WS-TAB)   TO WS-FLOAT-1(9:20)
          ELSE
             MOVE '3'                        TO WS-FLOAT-COUNT
             MOVE WS-CLIENT                  TO WS-FLOAT-1
             MOVE TABLE-FIRST-NAME(WS-TAB)   TO WS-FLOAT-2
             IF TABLE-MDDL-INIT(WS-TAB) > SPACES
                MOVE '4'                       TO WS-FLOAT-COUNT
                MOVE TABLE-MDDL-INIT(WS-TAB)   TO WS-FLOAT-3(1:1)
                MOVE '.'                       TO WS-FLOAT-3(2:1)
                MOVE TABLE-LAST-NAME(WS-TAB)   TO WS-FLOAT-4
             ELSE
                MOVE TABLE-LAST-NAME(WS-TAB)   TO WS-FLOAT-3
             END-IF
             CALL FLOATIT USING WS-FLOAT-DATA
             CANCEL FLOATIT.

          MOVE WS-FLOAT-1(1:100)            TO RPT-CLIENT-NAME.
          IF LINES-PRINTED > 35
             PERFORM 800-HEADING THRU 800-EXIT.
          IF NO-MAIL = 'Y'
             MOVE '***No Recurring Mail***'  TO RPT-CLIENT-NAME(50:23)
             WRITE PRT-RECORD FROM COURIER-56 AFTER ADVANCING 1 LINES
             WRITE PRT-RECORD FROM SHADE-CLIENT AFTER ADVANCING 0 LINES
             WRITE PRT-RECORD FROM RPT-CLIENT AFTER ADVANCING 1 LINES
             ADD 2                           TO LINES-PRINTED
             GO TO 710-TABLE-LOOKUP
          ELSE
             WRITE PRT-RECORD FROM COURIER-56 AFTER ADVANCING 1 LINES
             WRITE PRT-RECORD FROM SHADE-CLIENT AFTER ADVANCING 0 LINES
             WRITE PRT-RECORD FROM RPT-CLIENT AFTER ADVANCING 1 LINES
             ADD 2                           TO LINES-PRINTED.

       700-CONTINUE.

          IF WS-SORT-CYCLE = WS-HOLD-CYCLE
             NEXT SENTENCE
          ELSE
000100*12/14/99                                                                                                         
             IF WS-TAB = 0                                                                                              
                MOVE 1                   TO WS-TAB                                                                      
              END-IF                                                                                                    
             MOVE WS-SORT-CYCLE          TO WS-HOLD-CYCLE
             WRITE PRT-RECORD FROM COURIER-56 AFTER ADVANCING 1 LINES
             ADD 2                       TO LINES-PRINTED
             IF WS-SORT-CYCLE = 0
                MOVE 'Monthly Invoice Mail'      TO RPT-SECTION-NME
                MOVE TABLE-TOT-MTH-MAIL(WS-TAB)  TO MAIL-MASK
                MOVE MAIL-MASK                   TO RPT-SECTION-TOTAL
                MOVE TABLE-PRT-MTH-MAIL(WS-TAB)  TO MAIL-MASK
                MOVE MAIL-MASK                   TO RPT-SECTION-RPTD
                WRITE PRT-RECORD FROM RPT-SECTION-HDR3
                                   AFTER ADVANCING 1 LINE
             ELSE
             IF WS-SORT-CYCLE = 1
                MOVE 'Bi-Monthly Invoice Mail'   TO RPT-SECTION-NME
                MOVE TABLE-TOT-BMTH-MAIL(WS-TAB) TO MAIL-MASK
                MOVE MAIL-MASK                   TO RPT-SECTION-TOTAL
                MOVE TABLE-PRT-BMTH-MAIL(WS-TAB) TO MAIL-MASK
                MOVE MAIL-MASK                   TO RPT-SECTION-RPTD
                WRITE PRT-RECORD FROM RPT-SECTION-HDR3
                                   AFTER ADVANCING 1 LINE
             ELSE
             IF WS-SORT-CYCLE = 2
                MOVE 'Quarterly Invoice Mail'    TO RPT-SECTION-NME
                MOVE TABLE-TOT-QRTR-MAIL(WS-TAB) TO MAIL-MASK
                MOVE MAIL-MASK                   TO RPT-SECTION-TOTAL
                MOVE TABLE-PRT-QRTR-MAIL(WS-TAB) TO MAIL-MASK
                MOVE MAIL-MASK                   TO RPT-SECTION-RPTD
                WRITE PRT-RECORD FROM RPT-SECTION-HDR3
                                   AFTER ADVANCING 1 LINE
             ELSE
             IF WS-SORT-CYCLE = 3
                MOVE 'Semi-Annual Invoice Mail'  TO RPT-SECTION-NME
                MOVE TABLE-TOT-SANL-MAIL(WS-TAB) TO MAIL-MASK
                MOVE MAIL-MASK                   TO RPT-SECTION-TOTAL
                MOVE TABLE-PRT-SANL-MAIL(WS-TAB) TO MAIL-MASK
                MOVE MAIL-MASK                   TO RPT-SECTION-RPTD
                WRITE PRT-RECORD FROM RPT-SECTION-HDR3
                                   AFTER ADVANCING 1 LINE
             ELSE
             IF WS-SORT-CYCLE = 4
                MOVE 'Annual Invoice Mail'       TO RPT-SECTION-NME
                MOVE TABLE-TOT-ANUL-MAIL(WS-TAB) TO MAIL-MASK
                MOVE MAIL-MASK                   TO RPT-SECTION-TOTAL
                MOVE TABLE-PRT-ANUL-MAIL(WS-TAB) TO MAIL-MASK
                MOVE MAIL-MASK                   TO RPT-SECTION-RPTD
                WRITE PRT-RECORD FROM RPT-SECTION-HDR3
                                   AFTER ADVANCING 1 LINE.

          IF WS-SORT-NOT-FND = 'A'
             MOVE '*'                       TO PRT-AUTO
          ELSE
             MOVE SPACES                    TO PRT-AUTO.
          MOVE WS-SORT-RECV-DATE(3:6)    TO WS-DATE-REFORM.
          MOVE 03                        TO WS-DATE-PARAM.
          MOVE SPACES                    TO WS-DATE-EXTEND.
          CALL TPSDATES USING WS-DATE-REQUEST.
          MOVE WS-DATE-TENBYTES          TO PRT-REC-DATE.

          MOVE WS-SORT-FROM-NAME         TO PRT-FROM-NAME.
          MOVE WS-SORT-FOR-NAME          TO PRT-FOR-NAME.
          IF WS-SORT-NOT-FND = 'Y'
             MOVE 'No previous mail found'  TO PRT-ACCOUNT-NO
             MOVE SPACES                    TO PRT-REC-DATE
          ELSE
             MOVE WS-SORT-BILL-ACCT         TO PRT-ACCOUNT-NO.
          WRITE PRT-RECORD FROM PS12-U-N-CGT AFTER ADVANCING 1 LINE.
          WRITE PRT-RECORD FROM PRINT-DATA AFTER ADVANCING 0 LINE.
          WRITE PRT-RECORD FROM PRINT-DISP AFTER ADVANCING 1 LINES.
          WRITE PRT-RECORD FROM DISP-LINE AFTER ADVANCING 0 LINES.
          ADD 2                           TO LINES-PRINTED.

          GO TO 700-PRINT-DETAIL.

       700-EXIT.   EXIT.

       750-READ-PA-REC.

          MOVE LOW-VALUES   TO LOGREC-KEY.
          MOVE F-PRIME      TO FILE-KEY.
          MOVE F-START      TO FILE-ACTION.
          CALL TPSIO001 USING FILE-REQUEST TPS-LOGON.
          IF NOT A-SUCCESSFUL-OPERATION
             MOVE 'LOGON' TO FILE-NAME
             MOVE 'TPS1010M-READN' TO FILE-TEXT
             PERFORM FILE-ERROR THRU FILE-ERROR-EXIT.

       750-CONTINUE.

          MOVE F-PRIME      TO FILE-KEY.
          MOVE F-READ-NEXT  TO FILE-ACTION.
          CALL TPSIO001 USING FILE-REQUEST TPS-LOGON.
          IF END-OF-FILE-WAS-REACHED
             GO TO 750-EXIT.
          IF NOT A-SUCCESSFUL-OPERATION
             MOVE 'LOGON' TO FILE-NAME
             MOVE 'TPS1010M-READN' TO FILE-TEXT
             PERFORM FILE-ERROR THRU FILE-ERROR-EXIT.

          IF WS-SORT-ACCT-BRANCH = LOGREC-ADMIN-ACCT-BRANCH AND
             WS-SORT-ACCT-ADMIN  = LOGREC-ADMIN-ACCT-ADMIN  AND
             LOGREC-ACCESS-LEVEL = '04' AND
             LOGREC-COVER-LETTER-OPTION = 'Y'
             GO TO 750-EXIT
          ELSE
             GO TO 750-CONTINUE.

       750-EXIT.    EXIT.

       800-HEADING.

          IF PAGES-PRINTED = 0
             MOVE PCL-RESET        TO PRT-RECORD(1:20)
             MOVE PCL-LANDSCAPE    TO PRT-RECORD(1:)
             MOVE PCL5-DUPLEX-ON   TO PRT-RECORD(20:)
             WRITE PRT-RECORD      AFTER ADVANCING 0 LINES
          ELSE
             MOVE 0                       TO PAGE-ENDING-1
             MULTIPLY 40 BY LINES-PRINTED GIVING PAGE-ENDING-1
             ADD 50                       TO PAGE-ENDING-1
             MOVE PAGE-ENDING-1           TO PAGE-ENDING-2
                                             LAST-LINE-NO
             ADD 350                      TO LAST-LINE-NO
             WRITE PRT-RECORD FROM DRAW-VARIABLE-COLUMN
                                               AFTER ADVANCING 0 LINES
             WRITE PRT-RECORD FROM COURIER-56 AFTER ADVANCING 1 LINES
             WRITE PRT-RECORD FROM LAST-LINE AFTER ADVANCING 1 LINES
             WRITE PRT-RECORD FROM THIN-LINE AFTER ADVANCING 0 LINES
             WRITE PRT-RECORD FROM PAGE-END AFTER ADVANCING 1 LINES
             WRITE PRT-RECORD FROM THIN-LINE AFTER ADVANCING 0 LINES
          END-IF.

          IF PAGES-PRINTED > 0
             WRITE PRT-RECORD FROM NEW-PAGE AFTER ADVANCING 1 LINES.
          WRITE PRT-RECORD FROM COURIER-56  AFTER ADVANCING 0 LINES.
          WRITE PRT-RECORD FROM HEADING-1   AFTER ADVANCING 0 LINES.
          WRITE PRT-RECORD FROM HEADING-1-A AFTER ADVANCING 0 LINES.
          ADD 1                             TO PAGES-PRINTED
          MOVE PAGES-PRINTED                TO PAGES-PRINTED-MASK.
          MOVE PAGES-PRINTED-MASK           TO PRT-PAGE.
          WRITE PRT-RECORD FROM HEADING-2-A AFTER ADVANCING 0 LINES.
          WRITE PRT-RECORD FROM COURIER-59  AFTER ADVANCING 1 LINES.
          WRITE PRT-RECORD FROM HEADING-2   AFTER ADVANCING 0 LINES.
          WRITE PRT-RECORD FROM HEADING-3   AFTER ADVANCING 1 LINES.
          WRITE PRT-RECORD FROM COURIER-56  AFTER ADVANCING 2 LINES.
          WRITE PRT-RECORD FROM PA-NAME     AFTER ADVANCING 0 LINES.
          WRITE PRT-RECORD FROM AA-NAME     AFTER ADVANCING 1 LINES.
          WRITE PRT-RECORD FROM PS12-U-N-CGT AFTER ADVANCING 1 LINES.
          WRITE PRT-RECORD FROM CONFIDENTIAL-LINE-1
                                            AFTER ADVANCING 0 LINES.
          WRITE PRT-RECORD FROM CONFIDENTIAL-LINE-2
                                            AFTER ADVANCING 1 LINES.
          WRITE PRT-RECORD FROM THIN-LINE   AFTER ADVANCING 0 LINES.
          WRITE PRT-RECORD FROM COURIER-56  AFTER ADVANCING 1 LINES.
          WRITE PRT-RECORD FROM RPT-SECTION-HDR1
                                            AFTER ADVANCING 0 LINES.
          WRITE PRT-RECORD FROM RPT-SECTION-HDR2
                                            AFTER ADVANCING 1 LINES.
          WRITE PRT-RECORD FROM THIN-LINE   AFTER ADVANCING 0 LINES.
          MOVE 12                           TO LINES-PRINTED.

       800-EXIT.          EXIT.

       850-FLOAT-NAME.

          MOVE SPACES                       TO WS-FLOAT-PARMS.
          MOVE '2'                          TO WS-FLOAT-COUNT
          MOVE LOGREC-ADMIN-FIRST-NAME      TO WS-FLOAT-1
          MOVE LOGREC-ADMIN-LAST-NAME       TO WS-FLOAT-2
          CALL FLOATIT USING WS-FLOAT-DATA
          CANCEL FLOATIT.

       850-EXIT.       EXIT.

       900-END-PRINT.

          MOVE 0                       TO PAGE-ENDING-1.
          MULTIPLY 40 BY LINES-PRINTED GIVING PAGE-ENDING-1.
          ADD 50                       TO PAGE-ENDING-1.
          MOVE PAGE-ENDING-1           TO PAGE-ENDING-2
                                          LAST-LINE-NO.
          ADD 350                      TO LAST-LINE-NO.

          WRITE PRT-RECORD FROM COURIER-56 AFTER ADVANCING 2 LINES.
          WRITE PRT-RECORD FROM LAST-LINE  AFTER ADVANCING 1 LINES.
          WRITE PRT-RECORD FROM THIN-LINE AFTER ADVANCING 0 LINES.
          WRITE PRT-RECORD FROM RPT-LAST-LINE AFTER ADVANCING 1 LINES.
          WRITE PRT-RECORD FROM THIN-LINE AFTER ADVANCING 0 LINES.
          WRITE PRT-RECORD FROM DRAW-VARIABLE-COLUMN
                                            AFTER ADVANCING 0 LINES.
          WRITE PRT-RECORD FROM PCL-RESET   AFTER ADVANCING 0 LINES.

          CLOSE PRT-FILE.
                                                                            00076900
       900-EXIT.       EXIT.

       EXIT-THE-MODULE.

      ****** RESET LOGON RECORD *******
          MOVE LOGREC-RETURN-KEY  TO LOGREC-KEY.
          MOVE F-PRIME TO FILE-KEY.
          MOVE F-START TO FILE-ACTION.
          CALL TPSIO001 USING FILE-REQUEST TPS-LOGON.
          IF NOT A-SUCCESSFUL-OPERATION
             MOVE 'LOGON' TO FILE-NAME
             MOVE 'TPS1010M-STAR2' TO FILE-TEXT
             PERFORM FILE-ERROR THRU FILE-ERROR-EXIT.

       GET-ORGINAL-RECORD.

          MOVE F-PRIME      TO FILE-KEY.
          MOVE F-READ-NEXT  TO FILE-ACTION.
          CALL TPSIO001 USING FILE-REQUEST TPS-LOGON.
          IF NOT A-SUCCESSFUL-OPERATION
             MOVE 'LOGON' TO FILE-NAME
             MOVE 'TPS1010M-READ' TO FILE-TEXT
             PERFORM FILE-ERROR THRU FILE-ERROR-EXIT.

          IF WS-SORT-ACCT-BRANCH = LOGREC-ADMIN-ACCT-BRANCH AND
             WS-SORT-ACCT-ADMIN  = LOGREC-ADMIN-ACCT-ADMIN
             CONTINUE
          ELSE
             GO TO GET-ORGINAL-RECORD.

          MOVE F-PRIME TO FILE-KEY.
          MOVE F-READ  TO FILE-ACTION.
          CALL TPSIO001 USING FILE-REQUEST TPS-LOGON.
          IF NOT A-SUCCESSFUL-OPERATION
             MOVE 'LOGON' TO FILE-NAME
             MOVE 'TPS1010M-READ2' TO FILE-TEXT
             PERFORM FILE-ERROR THRU FILE-ERROR-EXIT.

          SEEIF-TPSRECUR-ISOPEN.
              IF NOT TPSRECUR-OPEN
                 GO TO SEEIF-TPSRECVE-ISOPEN.

            SET FR-CLOSE         TO TRUE
            CALL TPSIORCR USING FILE-REQUEST TPS-RECUR.
            IF NOT A-SUCCESSFUL-OPERATION
                 MOVE 'RECUR' TO FILE-NAME
                 MOVE 'TPS1010M-CLOSE' TO FILE-TEXT
                 PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
                 GOBACK.

          SEEIF-TPSRECVE-ISOPEN.
            IF NOT TPSMAIL-OPEN
                 GO TO SEEIF-TPSPROFL-ISOPEN.

            SET FR-CLOSE         TO TRUE
            CALL TPSIOREC USING FILE-REQUEST TPS-MAIL.
            IF NOT A-SUCCESSFUL-OPERATION
                 MOVE 'RECEIVE' TO FILE-NAME
                 MOVE 'TPS1010M-CLOSE' TO FILE-TEXT
                 PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
                 GOBACK.

          SEEIF-TPSPROFL-ISOPEN.
            IF NOT TPSPROFL-OPEN
                 GO TO END-OF-THE-LINE.

      *12/14SET FR-CLOSE         TO TRUE
      *     CALL TPSIO004 USING FILE-REQUEST TPS-PROFL.
      *     IF NOT A-SUCCESSFUL-OPERATION
      *          MOVE 'PROFILE' TO FILE-NAME
      *          MOVE 'TPS1010M-CLOSE' TO FILE-TEXT
      *          PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
      *          GOBACK.

       END-OF-THE-LINE.

            CANCEL TPSDATES.
            CANCEL TPSIOERR.
      *12/04CANCEL TPSIO004.
            CANCEL TPSIOREC.
            CANCEL TPSIORCR.

               GOBACK.

       FILE-ERROR.
            CALL TPSIOERR USING FILE-REQUEST.
            CANCEL TPSIOERR.
       FILE-ERROR-EXIT. EXIT.

