       IDENTIFICATION DIVISION.
       PROGRAM-ID. TPS0054.
       AUTHOR. JIM MONAGHAN.
      *****************************************************************
      *  CHANGE THE PA SIGNATURE THAT APPEARS ON THE REPORTS.         *
      *****************************************************************
      *  07/07/17  CHANGED GUI                                      AC*
      *  03/30/17  GUI SCREEN CONVERSION                           TAM*
      *  01/10/17  ADDED 'SECURE EMAIL CLIENT' TO SIGNATURE REPORT. JM*
      *  04/13/15  ADDED "ENTER" MESSAGE TO PA SIGNATURE SCREEN     JA*
      *  01/22/14  CHANGED SIGNATURE-KEY TO SIGNATURE-ACCT-NO SO THAT *
      *               MULTI CHANGES WOULD WORK                      JA*
      *  01/26/01 ADD PANEL TPS0054D FOR NEW CLIENT SETUP           JM*
      *  08/01/18 ADD START EMAIL FILE BEFORE READ NEXT WHEN PRINT  JM*
      *****************************************************************
       ENVIRONMENT DIVISION.
       CONFIGURATION SECTION.
       SOURCE-COMPUTER. IBM-PS2.
       OBJECT-COMPUTER. IBM-PS2.

       FILE-CONTROL.

           SELECT PRT-FILE
          ASSIGN TO  "LPT1"
      **    ASSIGN TO  "c:\tps\app\signatur.txt"
           ORGANIZATION IS LINE SEQUENTIAL.

       DATA DIVISION.
       FILE SECTION.
       FD  PRT-FILE
           LABEL RECORDS ARE OMITTED
           RECORD CONTAINS 200 CHARACTERS.
       01  PRT-RECORD                     PIC X(200).

       WORKING-STORAGE SECTION.

*******WINFORMS SCREEN DEFINITION**************************

       01 TPS0054 type TPS000.TPS0054Form.
       01 PROCESSFORM type TPS000.PROCESSForm.
       01 TPS0054A type TPS000.TPS0054AForm.
       01 TPS0054B type TPS000.TPS0054BForm.
       01 TPS0054C type TPS000.TPS0054CForm.

       01 PROCESSFORM-DISPLAY-FLAG PIC 9(01) VALUE 0.

       01 TPS0054A-CUR-SIGNATURE PIC X(10).
       01 TPS0054A-NEW-SIGNATURE PIC X(10).
       01 TPS0054A-FROM-DATE PIC 9(06).
       01 TPS0054A-TO-DATE PIC 9(06).

       01 TPS0054B-CUR-SIGNATURE PIC X(10).
       01 TPS0054B-NEW-SIGNATURE PIC X(10).
       01 TPS0054B-FROM-DATE PIC 9(06).
       01 TPS0054B-TO-DATE PIC 9(06).


       01 SCREEN-NAME PIC x(10).

       01 WS-CURRENT-X                            PIC 9(04).
       01 WS-CURRENT-Y                            PIC 9(04).
       01 WS-CURRENT-XY-PARM.
          05 WS-X-PARM                            PIC 9(04).
          05 WS-Y-PARM                            PIC 9(04).

       COPY "ds-cntrl.v1".

       COPY "TPS0054D.CPB".

**********************************************************

       01 PROGRAM-NAMES.
          10 GUISCREEN   PIC X(08) VALUE 'GS      '.
          10 SCREENIO    PIC X(08) VALUE 'SCRNIO'.
          10 TPSIOERR    PIC X(08) VALUE 'TPSIOERR'.
          10 TPSIO032    PIC X(08) VALUE 'TPSIO032'.
          10 TPSIO001    PIC X(08) VALUE 'TPSIO001'.
          10 TPSIO004    PIC X(08) VALUE 'TPSIO004'.
          10 TPSDATES    PIC X(08) VALUE 'TPSDATES'.
          10 FLOATBIG    PIC X(08) VALUE 'FLOATBIG'.
          10 TPSIO033    PIC X(08) VALUE 'TPSIO033'.

      ************** SCREENIO COPYBOOK ***************





      *    COPY  PRINTING.COB.

       01  SIGNATURE.
           COPY "SIGNATUR.CPY".

       01  TPSPROFL.
           COPY "TPSPROFL.CPY".

       01  TPS-EMAIL-REC.
           COPY TPSEMAIL.CPY.

       01  PROFL-OPEN              PIC X(01) VALUE 'N'.

           COPY "TPSFILES.CPY".
           COPY "KEYVALUE.CPY".
           COPY "PCL5VALU.CPY".
           COPY "PCLVALUE.CPY".
           COPY "CALLDATE.CPY".

       01 NUM-MASK           PIC  ZZ.
       01 PAGES-PRINTED      PIC  9(02) VALUE 00.
       01 PAGES-PRINTED-MASK PIC  ZZ.
       01 LINES-PRINTED      PIC  9(02) VALUE 00.
       01 LINES-PER-PAGE     PIC  9(02) VALUE 43.

      *01/10/17
       01 SERCURE-TABLE OCCURS 1 TO 900 TIMES DEPENDING ON TBL-IDX.
          05 SECURE-ACCT-NO                 PIC 9(10).

       01 TBL-IDX            PIC  9(03) VALUE ZERO.
       01 WS-IDX             PIC  9(03) VALUE ZERO.
      *************************************************
       01  NEW-PAGE PIC X VALUE X'0C'.                                                     00008600
       01 BOLD-LINE.                                                                       00009000
****************DRAW A SOLID BLACK LINE FROM LEFT MARGIN TO RIGHT.                         00009100
                10 FILLER PIC X     VALUE X'1B'.                                           00009200
                10 FILLER PIC X(14) VALUE '*c4000a0010b0P'.                                00009300
****************MOVE DOWN AND OVER TO THE LEFT MARGIN                                      00009400
                10 FILLER PIC X     VALUE X'1B'.                                           00009500
                10 FILLER PIC X(10) VALUE '*p+0005y0X'.                                    00009600
       01 BOLD-LINE-2.                                                                     00009700
****************MOVE DOWN AND OVER TO THE LEFT MARGIN                                      00009800
                10 FILLER PIC X     VALUE X'1B'.                                           00009900
                10 FILLER PIC X(10) VALUE '*p+0005y0X'.                                    00010000
****************DRAW A SOLID BLACK LINE FROM LEFT MARGIN TO RIGHT.                         00010100
                10 FILLER PIC X     VALUE X'1B'.                                           00010200
                10 FILLER PIC X(14) VALUE '*c4000a0010b0P'.                                00010300
****************MOVE DOWN AND OVER TO THE LEFT MARGIN                                      00010400
                10 FILLER PIC X     VALUE X'1B'.                                           00010500
                10 FILLER PIC X(10) VALUE '*p+0005y0X'.                                    00010600
       01  THIN-LINE.                                                                      00010700
****************DRAW A THIN BLACK LINE FROM LEFT MARGIN TO RIGHT.                          00010800
                10 FILLER PIC X     VALUE X'1B'.                                           00010900
                10 FILLER PIC X(14) VALUE '*c4000a0005b0P'.                                00011000
****************MOVE DOWN AND OVER TO THE LEFT MARGIN                                      00011100
                10 FILLER PIC X     VALUE X'1B'.                                           00011200
                10 FILLER PIC X(10) VALUE '*p-0005y0X'.                                    00011300
       01  MONOSPACE.                                                                      00011400
           30 FILLER PIC X(01) VALUE X'1B'.                                                00011500
           30 FILLER PIC X(04) VALUE  '(s0p'.                                              00011600
           30 FILLER PIC X(13) VALUE  '13h0s1b4101T'.                                      00011700
                                                                                           00011800
       01  HEADING-1.                                                                      00033700
           05 FILLER PIC X(01) VALUE X'1B'.                                                00036200
           05 FILLER PIC X(02) VALUE  '*p'.                                                00036300
           05 X-AXIS PIC X(04) VALUE  '1150'.                                              00036400
           05 FILLER PIC X(01) VALUE  'X'.                                                 00036500
           05 FILLER PIC X(17) VALUE                                                       00036600
               'PA Signature List'.                                                        00036700
           05 FILLER             PIC X VALUE X'1B'.                                        00036800
           05 FILLER             PIC X(07) VALUE '*p2800X'.                                00036900
           05 FILLER             PIC X(009) VALUE 'Page'.                                  00037000
           05 PAGE-NO            PIC X(002).                                               00037100
       01  HEADING-2.                                                                      00034600
           05 FILLER PIC X(01) VALUE X'1B'.                                                00036200
           05 FILLER PIC X(02) VALUE  '*p'.                                                00036300
           05 X-AXIS PIC X(04) VALUE  '0800'.                                              00036400
           05 FILLER PIC X(01) VALUE  'X'.                                                 00036500
           05 FILLER PIC X(50) VALUE                                                       00036600
               'Total Personal Services Administrative Group, LLC'.                        00036700
      *    05 FILLER             PIC X VALUE X'1B'.                                        00036800
      *    05 FILLER             PIC X(07) VALUE '*p2600X'.                                00036900
      *    05 FILLER             PIC X(009) VALUE 'Page'.                                  00037000
      *    05 PAGE-NO            PIC X(002).                                               00037100
       01  HEADING-3.                                                                      00037200
           05 FILLER PIC X(01) VALUE SPACE.                                                00037300
           05 FILLER PIC X(01) VALUE X'1B'.                                                00037400
           05 FILLER PIC X(02) VALUE  '*p'.                                                00037500
           05 X-AXIS PIC X(04) VALUE  '0800'.                                              00037600
           05 FILLER PIC X(01) VALUE  'X'.                                                 00037700
           05 FILLER PIC X(51) VALUE                                                       00037800
             '"Taking Care of Your Personal Business...Privately"'.                        00037900
       01  HEADING-4.                                                                      00038000
           05 FILLER               PIC X(14) VALUE SPACES.                                 00038100
           05 FILLER               PIC X(06) VALUE                                         00038200
                 'CLIENT'.                                                                 00038300
           05 FILLER               PIC X(70) VALUE SPACES.                                 00038400
           05 FILLER               PIC X(12) VALUE                                         00038500
                 'PA SIGNATURE'.                                                           00038600
       01  PRINT-REC.                                                                      00038000
           05 FILLER               PIC X(02) VALUE SPACES.                                 00038100
           05 PRT-ACCT-NO          PIC X(10).                                              00038200
           05 FILLER               PIC X(02) VALUE SPACES.                                 00038400
           05 PRT-ACCT-NAME        PIC X(36).                                              00038500
           05 FILLER               PIC X(04) VALUE SPACES.                                 00038700
           05 PRT-SIG-ID           PIC X(08).                                              00038800
           05 FILLER               PIC X(02) VALUE SPACES.                                 00039000
           05 PRT-SIG-NAME         PIC X(36).                                              00039100
           05 FILLER               PIC X(04) VALUE SPACES.                                 00039300
           05 PRT-TEMP-INFO        PIC X(95) VALUE SPACES.                                 00039400
                                                                                           00039500
       01 TEMP-INFO.                                                                       00039600
           05 FILLER               PIC X(21) VALUE                                         00039600
                 'Temporary signature '.                                                   00039800
           05 PRT-TEMP-ID          PIC X(08).                                              00039700
           05 FILLER               PIC X(06) VALUE                                         00039700
                 ' from '.                                                                 00039800
           05 PRT-FROM-MM          PIC X(02).                                              00039700
           05 FILLER               PIC X(01) VALUE '/'.                                    00039700
           05 PRT-FROM-DD          PIC X(02).                                              00039700
           05 FILLER               PIC X(01) VALUE '/'.                                    00039700
           05 PRT-FROM-YY          PIC X(02).                                              00039700
           05 FILLER               PIC X(04) VALUE                                         00039600
                 ' to '.                                                                   00039800
           05 PRT-TO-MM            PIC X(02).                                              00039700
           05 FILLER               PIC X(01) VALUE '/'.                                    00039700
           05 PRT-TO-DD            PIC X(02).                                              00039700
           05 FILLER               PIC X(01) VALUE '/'.                                    00039700
           05 PRT-TO-YY            PIC X(02).                                              00039700
                                                                                           00039900
       01  END-OF-PRINT.                                                                   00038000
           05 FILLER               PIC X(60) VALUE SPACES.                                 00038100
           05 FILLER               PIC X(12) VALUE                                         00038200
                 'END OF LIST'.                                                            00038300

005100
005200  01  BG-FLOAT-DATA.
005300      05  BG-FLOAT-PARMS              PIC  X(161).
005400      05  FILLER REDEFINES BG-FLOAT-PARMS.
005500          10  BG-FLOAT-COUNT          PIC  X(01).
005600          10  BG-FLOAT-1              PIC  X(40).
005700          10  BG-FLOAT-1-R REDEFINES BG-FLOAT-1.
005800              15  BG-FLOAT-1-I        PIC  X(01) OCCURS 40 TIMES.
005900          10  BG-FLOAT-2              PIC  X(40).
006000          10  BG-FLOAT-2-R REDEFINES BG-FLOAT-2.
006100              15  BG-FLOAT-2-I        PIC  X(01) OCCURS 40 TIMES.
006200          10  BG-FLOAT-3              PIC  X(40).
006300          10  FILLER REDEFINES BG-FLOAT-3.
006400              15  BG-FLOAT-3-A        PIC  X(37).
006500              15  BG-FLOAT-3-B        PIC  X(03).
006600          10  BG-FLOAT-3-R REDEFINES BG-FLOAT-3.
006700              15  BG-FLOAT-3-I        PIC  X(01) OCCURS 40 TIMES.
006800          10  BG-FLOAT-4              PIC  X(40).
006900
010000
011200 01  LS-PARMS.
011300     05  LS-ACCESS-LEVEL           PIC  X(02).
011400     05  LS-ACCESS-LEVEL-NAME      PIC  X(36).
011500     05  LS-ACCESS-LEVEL-TITLE     PIC  X(36) VALUE
011600           'Personal Administrator             '.
011600     05  LS-ACCESS-LEVEL-INITIALS  PIC  X(07).
011700

       01 TODAYS-DATE-CYMD            PIC  9(08).
       01 FILLER REDEFINES TODAYS-DATE-CYMD.
          05 TODAYS-DATE-C            PIC  9(02).
          05 TODAYS-DATE-YMD          PIC  9(06).

       01 SAVE-LOGREC-KEY             PIC  X(10).

      *Changes made by TAM                                                                                                
090800 01  TPS0054A-WS.
           05  EXITED-FIELD      PIC 9(4) VALUE ZEROS.
           05  EXITED-FIELD-R redefines EXITED-FIELD.
               10 FILLER         PIC 99.
               10 EX-FIELD-NO    PIC 99.
      *End of changes made by TAM                                                                          

       LINKAGE SECTION.

       01 TPSLOGON.
           COPY "TPSLOGON.CPY".

       01 NEW-CLIENT            PIC X(01).
       01 NEW-CLIENT-NO         PIC 9(10).

       01 CURRENT-XY-PARAMETERS PIC 9(08).

       PROCEDURE DIVISION USING TPSLOGON
                                NEW-CLIENT
                                NEW-CLIENT-NO
                                CURRENT-XY-PARAMETERS.

       0001-BEGIN.

      ********INITIALIZE WINFORMS SCREENS **************

       set TPS0054 to new TPS000.TPS0054Form().
       set PROCESSFORM to new TPS000.PROCESSForm().
       set TPS0054A to new TPS000.TPS0054AForm().
       set TPS0054B to new TPS000.TPS0054BForm().
       set TPS0054C to new TPS000.TPS0054CForm().

      **************************************************

           MOVE CURRENT-XY-PARAMETERS(1:4) TO WS-CURRENT-X
                                              WS-X-PARM.
           MOVE CURRENT-XY-PARAMETERS(5:4) TO WS-CURRENT-Y
                                              WS-Y-PARM.

          ACCEPT TODAYS-DATE-YMD FROM DATE.
          MOVE 19                   TO TODAYS-DATE-C.
          IF TODAYS-DATE-YMD < 940201
             MOVE 20                TO TODAYS-DATE-C
           END-IF.

      ******** SAVE ORIGINAL LOGON TO GO BACK TO **********
          MOVE LOGREC-KEY      TO SAVE-LOGREC-KEY.

      ******** OPEN FILE **********
          MOVE F-PRIME         TO FILE-KEY.
          MOVE F-OPEN-I-O      TO FILE-ACTION.
          CALL TPSIO032 USING FILE-REQUEST SIGNATURE.
          IF FILE-STATUS NOT = '00' AND '05'
             MOVE 'SIGNATUR'   TO FILE-NAME
             MOVE 'TPS0054-OPN' TO FILE-TEXT
             PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
             GO TO EXIT-THE-MODULE.
      ****** ADD PA SIGNATURE WHEN NEW CLIENT SETUP ******
          IF NEW-CLIENT = 'Y'
             PERFORM 0350-NEW-CLIENT THRU 0350-EXIT
             GO TO EXIT-THE-MODULE.

       0001-DISPLAY.


           SET TPS0054::X-POINT TO WS-X-PARM.
           SET TPS0054::Y-POINT TO WS-Y-PARM.
           INVOKE TPS0054::ShowDialog.
           MOVE TPS0054::Location::X TO WS-X-PARM
                                        WS-CURRENT-X.
           MOVE TPS0054::Location::Y TO WS-Y-PARM
                                        WS-CURRENT-Y.
           MOVE TPS0054::SCREEN-NAME TO SCREEN-NAME.


          IF NOT TPS0054::KEY-PRESSED = "Enter Key"
             GO TO EXIT-THE-MODULE.  

          IF TPS0054::SEL-MAINT = 1
             PERFORM 0100-CHANGE-SIGNATURE THRU 0100-EXIT.
          IF TPS0054::SEL-MAINT = 2
             PERFORM 0200-CHANGE-CLIENTS THRU 0200-EXIT.
          IF TPS0054::SEL-MAINT = 3
             PERFORM 0300-ADD-CLIENTS THRU 0300-EXIT.
          IF TPS0054::SEL-MAINT = 4
             PERFORM 0400-DELETE-CLIENT THRU 0400-EXIT.
          IF TPS0054::SEL-MAINT = 5
             PERFORM 0450-PRINT-CLIENTS THRU 0450-EXIT.

           IF PROCESSFORM-DISPLAY-FLAG = 1
               MOVE 0 TO PROCESSFORM-DISPLAY-FLAG
               INVOKE PROCESSFORM::Hide
           END-IF.

          GO TO EXIT-THE-MODULE.

       0001-EXIT.  EXIT.

       0100-CHANGE-SIGNATURE.

          MOVE ZEROS                 TO TPS0054A-FROM-DATE
                                        TPS0054A-TO-DATE.
          MOVE 'ENTER KEY TO PROCESS END KEY TO GO BACK'
                                     TO TPS0054A::MENU-LINE.
          MOVE 1 TO TPS0054A::ACTIVE-FIELD.


       0100-DISPLAY.

           MOVE TPS0054A-CUR-SIGNATURE TO TPS0054A::CUR-SIGNATURE.
           MOVE TPS0054A-NEW-SIGNATURE TO TPS0054A::NEW-SIGNATURE.
           MOVE TPS0054A-FROM-DATE TO TPS0054A::FROM-DATE.
           MOVE TPS0054A-TO-DATE TO TPS0054A::TO-DATE.

           SET TPS0054A::X-POINT TO WS-X-PARM.
           SET TPS0054A::Y-POINT TO WS-Y-PARM.
           INVOKE TPS0054A::ShowDialog.
           MOVE TPS0054A::Location::X TO WS-X-PARM
                                         WS-CURRENT-X.
           MOVE TPS0054A::Location::Y TO WS-Y-PARM
                                          WS-CURRENT-Y.
           MOVE TPS0054A::SCREEN-NAME TO SCREEN-NAME.

           MOVE TPS0054A::CUR-SIGNATURE TO TPS0054A-CUR-SIGNATURE.
           MOVE TPS0054A::NEW-SIGNATURE TO TPS0054A-NEW-SIGNATURE.
           MOVE TPS0054A::FROM-DATE TO TPS0054A-FROM-DATE.
           MOVE TPS0054A::TO-DATE TO TPS0054A-TO-DATE.

 
          
          IF NOT TPS0054A::KEY-PRESSED = "Enter Key"
             GO TO 0001-DISPLAY.

          IF TPS0054A-CUR-SIGNATURE = SPACES
             MOVE 'ENTER SIGNATURE'  TO TPS0054A::MENU-LINE
             MOVE 1                  TO TPS0054A::ACTIVE-FIELD
             GO TO 0100-DISPLAY.

          IF TPS0054A-NEW-SIGNATURE = SPACES
             MOVE 'ENTER SIGNATURE'  TO TPS0054A::MENU-LINE
             MOVE 2                  TO TPS0054A::ACTIVE-FIELD
             GO TO 0100-DISPLAY.

      ********** CHECK PA CURRENT SIGNATURE ***********
          MOVE TPS0054A-CUR-SIGNATURE   TO LOGREC-KEY.
          PERFORM 0600-START-LOGON THRU 0600-EXIT.
          MOVE F-PRIME         TO FILE-KEY.
          MOVE F-READ-NEXT     TO FILE-ACTION.
          CALL TPSIO001 USING FILE-REQUEST TPSLOGON.
          IF NOT A-SUCCESSFUL-OPERATION
             MOVE 'LOGON   '     TO FILE-NAME
             MOVE 'TPS0054-READ' TO FILE-TEXT
             PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
             GO TO EXIT-THE-MODULE.
          IF TPS0054A-CUR-SIGNATURE(1:8) NOT = LOGREC-SIGN-ON-SHORT
             MOVE 'SIGNATURE NOT VALID' TO TPS0054A::MENU-LINE
             MOVE 3                  TO TPS0054A::ACTIVE-FIELD
             GO TO 0100-DISPLAY.

      ********** CHECK PA NEW SIGNATURE ***********
          MOVE TPS0054A::NEW-SIGNATURE   TO LOGREC-KEY.
          PERFORM 0600-START-LOGON THRU 0600-EXIT.
          MOVE F-PRIME         TO FILE-KEY.
          MOVE F-READ-NEXT     TO FILE-ACTION.
          CALL TPSIO001 USING FILE-REQUEST TPSLOGON.
          IF NOT A-SUCCESSFUL-OPERATION
             MOVE 'LOGON   '     TO FILE-NAME
             MOVE 'TPS0054-READ' TO FILE-TEXT
             PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
             GO TO EXIT-THE-MODULE.
          IF TPS0054A-NEW-SIGNATURE(1:8) NOT = LOGREC-SIGN-ON-SHORT
             MOVE 'SIGNATURE NOT VALID' TO TPS0054A::MENU-LINE
             MOVE 3                  TO TPS0054A::ACTIVE-FIELD
             GO TO 0100-DISPLAY.

          PERFORM 0650-GET-SIGNATURE-INFO THRU 0650-EXIT.

          MOVE ZEROS                 TO SIGNATURE-KEY.

          PERFORM 0610-START-SIGNATURE THRU 0610-EXIT.

      *********** DISPLAY PROCESSING SCREEN *************
      *04/11/17

           IF PROCESSFORM-DISPLAY-FLAG = 0
               SET PROCESSFORM::X-POINT TO WS-X-PARM
               SET PROCESSFORM::Y-POINT TO WS-Y-PARM
               INVOKE PROCESSFORM::Show
               MOVE 1 TO PROCESSFORM-DISPLAY-FLAG
           END-IF.





       0100-CONTINUE.

          MOVE F-PRIME         TO FILE-KEY.                                     
          MOVE F-READ-NEXT     TO FILE-ACTION.
          CALL TPSIO032 USING FILE-REQUEST SIGNATURE.
          IF END-OF-FILE-WAS-REACHED
             GO TO 0100-EXIT.
          IF NOT A-SUCCESSFUL-OPERATION
             MOVE 'SIGNATUR'   TO FILE-NAME
             MOVE 'TPS0054-SBR' TO FILE-TEXT
             PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
             GO TO EXIT-THE-MODULE.
      ******* TEMPORARY OR PERMANT CHANGE ********
          IF SIGNATURE-LOGON-ID = TPS0054A-CUR-SIGNATURE AND
             TPS0054A-FROM-DATE > ZEROS AND
             TPS0054A-TO-DATE > ZEROS
             MOVE TPS0054A-NEW-SIGNATURE
             TO SIGNATURE-NEW-LOGON-ID
             MOVE TPS0054A-FROM-DATE  TO SIGNATURE-FROM-DATE
             MOVE TPS0054A-TO-DATE    TO SIGNATURE-TO-DATE
             MOVE LS-ACCESS-LEVEL-NAME     TO SIGNATURE-NEW-NAME
             MOVE LS-ACCESS-LEVEL-TITLE    TO SIGNATURE-NEW-TITLE
             MOVE LS-ACCESS-LEVEL-INITIALS TO SIGNATURE-NEW-INITIALS
          ELSE
          IF SIGNATURE-LOGON-ID = TPS0054A-CUR-SIGNATURE AND
             TPS0054A-FROM-DATE = ZEROS AND
             TPS0054A-TO-DATE = ZEROS
             MOVE TPS0054A-NEW-SIGNATURE        TO SIGNATURE-LOGON-ID
             MOVE LS-ACCESS-LEVEL-NAME     TO SIGNATURE-NAME
             MOVE LS-ACCESS-LEVEL-TITLE    TO SIGNATURE-TITLE
             MOVE LS-ACCESS-LEVEL-INITIALS TO SIGNATURE-INITIALS
          ELSE
             GO TO 0100-CONTINUE.

          PERFORM 0500-REWRITE THRU 0500-EXIT.
          GO TO 0100-CONTINUE.



       0100-EXIT.   EXIT.


       0200-CHANGE-CLIENTS.

          MOVE ZEROS                 TO TPS0054B-FROM-DATE
                                        TPS0054B-TO-DATE.
          MOVE 'ENTER KEY TO PROCESS END KEY TO GO BACK'
                                     TO TPS0054B::MENU-LINE
                                        TPS0054B::MENU-LINE.

          MOVE 1 TO TPS0054B::ACTIVE-FIELD.


       0200-DISPLAY.


           MOVE TPS0054B-CUR-SIGNATURE TO TPS0054B::CUR-SIGNATURE.
           MOVE TPS0054B-NEW-SIGNATURE TO TPS0054B::NEW-SIGNATURE.
           MOVE TPS0054B-FROM-DATE TO TPS0054B::FROM-DATE.
           MOVE TPS0054B-TO-DATE TO TPS0054B::TO-DATE.

           SET TPS0054B::X-POINT TO WS-X-PARM.
           SET TPS0054B::Y-POINT TO WS-Y-PARM.
           INVOKE TPS0054B::ShowDialog.
           MOVE TPS0054B::Location::X TO WS-X-PARM
                                         WS-CURRENT-X.
           MOVE TPS0054B::Location::Y TO WS-Y-PARM
                                         WS-CURRENT-Y.
           MOVE TPS0054B::SCREEN-NAME TO SCREEN-NAME.

           MOVE TPS0054B::CUR-SIGNATURE TO TPS0054B-CUR-SIGNATURE.
           MOVE TPS0054B::NEW-SIGNATURE TO TPS0054B-NEW-SIGNATURE.
           MOVE TPS0054B::FROM-DATE TO TPS0054B-FROM-DATE.
           MOVE TPS0054B::TO-DATE TO TPS0054B-TO-DATE.

          
          IF NOT TPS0054B::KEY-PRESSED = "Enter Key"
             GO TO 0001-DISPLAY.

          IF TPS0054B::CLIENT-NO = ZEROS
             MOVE 'ENTER CLIENT'     TO TPS0054B::MENU-LINE
             MOVE 1                  TO TPS0054B::ACTIVE-FIELD
             GO TO 0200-DISPLAY.

          IF TPS0054B-NEW-SIGNATURE = SPACES
             MOVE 'ENTER SIGNATURE'  TO TPS0054B::MENU-LINE
                                        TPS0054B::MENU-LINE
             MOVE 3                  TO TPS0054B::ACTIVE-FIELD
             GO TO 0200-DISPLAY.

          IF TPS0054B-CUR-SIGNATURE = SPACES
             MOVE 'ENTER SIGNATURE'  TO TPS0054B::MENU-LINE
                                        TPS0054B::MENU-LINE
             MOVE 4                  TO TPS0054B::ACTIVE-FIELD
             GO TO 0200-DISPLAY.

      ********** CHECK CURRENT PA SIGNATURE ***********
          MOVE TPS0054B-CUR-SIGNATURE   TO LOGREC-KEY.
          PERFORM 0600-START-LOGON THRU 0600-EXIT.
          MOVE F-PRIME         TO FILE-KEY.
          MOVE F-READ-NEXT     TO FILE-ACTION.
          CALL TPSIO001 USING FILE-REQUEST TPSLOGON.
          IF NOT A-SUCCESSFUL-OPERATION
             MOVE 'LOGON   '     TO FILE-NAME
             MOVE 'TPS0054-READ' TO FILE-TEXT
             PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
             GO TO EXIT-THE-MODULE.
          IF TPS0054B-CUR-SIGNATURE(1:8) NOT = LOGREC-SIGN-ON-SHORT
             MOVE 'SIGNATURE NOT VALID' TO TPS0054B::MENU-LINE
             MOVE 3                  TO TPS0054B::ACTIVE-FIELD
             GO TO 0200-DISPLAY.

      ********** CHECK NEW PA SIGNATURE ***********
          MOVE TPS0054B-NEW-SIGNATURE   TO LOGREC-KEY.
          PERFORM 0600-START-LOGON THRU 0600-EXIT.
          MOVE F-PRIME         TO FILE-KEY.
          MOVE F-READ-NEXT     TO FILE-ACTION.
          CALL TPSIO001 USING FILE-REQUEST TPSLOGON.
          IF NOT A-SUCCESSFUL-OPERATION
             MOVE 'LOGON   '     TO FILE-NAME
             MOVE 'TPS0054-READ' TO FILE-TEXT
             PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
             GO TO EXIT-THE-MODULE.
          IF TPS0054B-NEW-SIGNATURE(1:8) NOT = LOGREC-SIGN-ON-SHORT
             MOVE 'SIGNATURE NOT VALID' TO TPS0054B::MENU-LINE
                                           TPS0054B::MENU-LINE
             MOVE 3                  TO TPS0054B::ACTIVE-FIELD
             GO TO 0200-DISPLAY.

      *********** DISPLAY PROCESSING SCREEN *************
      *04/11/

           IF PROCESSFORM-DISPLAY-FLAG = 0
               SET PROCESSFORM::X-POINT TO WS-X-PARM
               SET PROCESSFORM::Y-POINT TO WS-Y-PARM
               INVOKE PROCESSFORM::Show
               MOVE 1 TO PROCESSFORM-DISPLAY-FLAG
           END-IF.



          PERFORM 0650-GET-SIGNATURE-INFO THRU 0650-EXIT.

          MOVE TPS0054B::CLIENT-NO   TO SIGNATURE-ACCT-NO.
          MOVE ZEROS                 TO SIGNATURE-SUB-ACCT.
          PERFORM 0610-START-SIGNATURE THRU 0610-EXIT.

          MOVE F-PRIME         TO FILE-KEY.
          MOVE F-READ          TO FILE-ACTION.
          CALL TPSIO032 USING FILE-REQUEST SIGNATURE.
          IF NOT A-SUCCESSFUL-OPERATION
             MOVE 'SIGNATUR'     TO FILE-NAME
             MOVE 'TPS0054-READ' TO FILE-TEXT
             PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
             GO TO EXIT-THE-MODULE.

      ******* TEMPORARY CHANGE FOR 1 CLIENT ********
          IF SIGNATURE-LOGON-ID = TPS0054B-CUR-SIGNATURE AND
             TPS0054B::ENDING-CLIENT-NO = ZEROS AND
             TPS0054B-FROM-DATE > ZEROS AND
             TPS0054B-TO-DATE > ZEROS
             MOVE TPS0054B-NEW-SIGNATURE
             TO SIGNATURE-NEW-LOGON-ID
             MOVE TPS0054B-FROM-DATE  TO SIGNATURE-FROM-DATE
             MOVE TPS0054B-TO-DATE    TO SIGNATURE-TO-DATE
             MOVE LS-ACCESS-LEVEL-NAME     TO SIGNATURE-NEW-NAME
             MOVE LS-ACCESS-LEVEL-TITLE    TO SIGNATURE-NEW-TITLE
             MOVE LS-ACCESS-LEVEL-INITIALS TO SIGNATURE-NEW-INITIALS
             PERFORM 0500-REWRITE THRU 0500-EXIT
             GO TO 0200-EXIT.
      ******* PERMANENT CHANGE FOR 1 CLIENT ********
          IF SIGNATURE-LOGON-ID = TPS0054B-CUR-SIGNATURE AND
             TPS0054B::ENDING-CLIENT-NO = ZEROS AND
             TPS0054B-FROM-DATE = ZEROS AND
             TPS0054B-TO-DATE = ZEROS
             MOVE TPS0054B-NEW-SIGNATURE        TO SIGNATURE-LOGON-ID
             MOVE TPS0054B-FROM-DATE  TO SIGNATURE-FROM-DATE
             MOVE TPS0054B-TO-DATE    TO SIGNATURE-TO-DATE
             MOVE LS-ACCESS-LEVEL-NAME     TO SIGNATURE-NAME
             MOVE LS-ACCESS-LEVEL-TITLE    TO SIGNATURE-TITLE
             MOVE LS-ACCESS-LEVEL-INITIALS TO SIGNATURE-INITIALS
             PERFORM 0500-REWRITE THRU 0500-EXIT
             GO TO 0200-EXIT.
      ******* CHANGE FOR RANGE OF CLIENTS ********
          IF TPS0054B-NEW-SIGNATURE > SPACES AND
             TPS0054B::ENDING-CLIENT-NO > ZEROS
             PERFORM 0700-MULTI-CLIENTS THRU 0700-EXIT.


       0200-EXIT.

       0300-ADD-CLIENTS.

          MOVE ZEROS                 TO TPS0054B-FROM-DATE
                                        TPS0054B-TO-DATE.
          MOVE 'ENTER KEY TO PROCESS END KEY TO GO BACK'
                                     TO TPS0054B::MENU-LINE
                                        TPS0054B::MENU-LINE.
          MOVE 1 TO TPS0054B::ACTIVE-FIELD.                           


       0300-DISPLAY.


           MOVE TPS0054B-CUR-SIGNATURE TO TPS0054B::CUR-SIGNATURE.
           MOVE TPS0054B-NEW-SIGNATURE TO TPS0054B::NEW-SIGNATURE.
           MOVE TPS0054B-FROM-DATE TO TPS0054B::FROM-DATE.
           MOVE TPS0054B-TO-DATE TO TPS0054B::TO-DATE.

           SET TPS0054B::X-POINT TO WS-X-PARM.
           SET TPS0054B::Y-POINT TO WS-Y-PARM.
           INVOKE TPS0054B::ShowDialog.
           MOVE TPS0054B::Location::X TO WS-X-PARM
             WS-CURRENT-X.
           MOVE TPS0054B::Location::Y TO WS-Y-PARM
             WS-CURRENT-Y.
           MOVE TPS0054B::SCREEN-NAME TO SCREEN-NAME.

           MOVE TPS0054B::CUR-SIGNATURE TO TPS0054B-CUR-SIGNATURE.
           MOVE TPS0054B::NEW-SIGNATURE TO TPS0054B-NEW-SIGNATURE.
           MOVE TPS0054B::FROM-DATE TO TPS0054B-FROM-DATE.
           MOVE TPS0054B::TO-DATE TO TPS0054B-TO-DATE.
 

          IF NOT TPS0054B::KEY-PRESSED = "Enter Key"
             GO TO 0001-DISPLAY.

          IF TPS0054B::CLIENT-NO = ZEROS
             MOVE 'ENTER CLIENT NO'  TO TPS0054B::MENU-LINE
             MOVE 1                  TO TPS0054B::ACTIVE-FIELD
             GO TO 0300-DISPLAY.

          IF TPS0054B-NEW-SIGNATURE = SPACES
             MOVE 'ENTER SIGNATURE'  TO TPS0054B::MENU-LINE
             MOVE 3                  TO TPS0054B::ACTIVE-FIELD
             GO TO 0300-DISPLAY.

      ********** CHECK PA SIGNATURE ***********
          MOVE TPS0054B-NEW-SIGNATURE   TO LOGREC-KEY.
          PERFORM 0600-START-LOGON THRU 0600-EXIT.
          MOVE F-PRIME         TO FILE-KEY.
          MOVE F-READ-NEXT     TO FILE-ACTION.
          CALL TPSIO001 USING FILE-REQUEST TPSLOGON.
          IF NOT A-SUCCESSFUL-OPERATION
             MOVE 'LOGON   '     TO FILE-NAME
             MOVE 'TPS0054-READ' TO FILE-TEXT
             PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
             GO TO EXIT-THE-MODULE.
          IF TPS0054B-NEW-SIGNATURE(1:8) NOT = LOGREC-SIGN-ON-SHORT
             MOVE 'SIGNATURE NOT VALID' TO TPS0054B::MENU-LINE
             MOVE 3                  TO TPS0054B::ACTIVE-FIELD
             GO TO 0300-DISPLAY.

          PERFORM 0650-GET-SIGNATURE-INFO THRU 0650-EXIT.

      *********** DISPLAY PROCESSING SCREEN *************
      *04/11/17

           IF PROCESSFORM-DISPLAY-FLAG = 0
               SET PROCESSFORM::X-POINT TO WS-X-PARM
               SET PROCESSFORM::Y-POINT TO WS-Y-PARM
               INVOKE PROCESSFORM::Show
               MOVE 1 TO PROCESSFORM-DISPLAY-FLAG
           END-IF.


      ******* CHECK FOR VALID CLIENT # *********
          MOVE TPS0054B::CLIENT-NO  TO CLNT-PROFILE-ACCT-NO.
          MOVE ZEROS                TO CLNT-PROFILE-SUB-ACCT.
          PERFORM 0620-OPEN-PROFILE THRU 0620-EXIT.
          MOVE F-PRIME         TO FILE-KEY.
          MOVE F-READ          TO FILE-ACTION.
          CALL TPSIO004 USING FILE-REQUEST TPSPROFL.
          IF NO-RECORD-WAS-FOUND
             MOVE 'INVALID CLIENT'   TO TPS0054B::MENU-LINE
             MOVE 1                  TO TPS0054B::ACTIVE-FIELD
             GO TO 0300-DISPLAY
          ELSE
          IF NOT A-SUCCESSFUL-OPERATION
             MOVE 'PROFILE '     TO FILE-NAME
             MOVE 'TPS0054-READ' TO FILE-TEXT
             PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
             GO TO EXIT-THE-MODULE.
      ******** IS CLIENT ACTIVE ***********
          IF CLNT-PROFILE-ADD-DATE(1:1) = 8 OR 9
             MOVE 'DELETED CLIENT'   TO TPS0054B::MENU-LINE
             MOVE 1                  TO TPS0054B::ACTIVE-FIELD
             GO TO 0300-DISPLAY.

          MOVE TPS0054B::CLIENT-NO      TO SIGNATURE-ACCT-NO.
          MOVE ZEROS                    TO SIGNATURE-SUB-ACCT.
          MOVE TPS0054B-NEW-SIGNATURE        TO SIGNATURE-LOGON-ID
          MOVE LS-ACCESS-LEVEL-NAME     TO SIGNATURE-NAME
          MOVE LS-ACCESS-LEVEL-TITLE    TO SIGNATURE-TITLE
          MOVE LS-ACCESS-LEVEL-INITIALS TO SIGNATURE-INITIALS
          PERFORM 0550-WRITE-REC THRU 0550-EXIT.

       0300-EXIT.  EXIT.

       0350-NEW-CLIENT.


       0350-DISPLAY.
      *04/13/15 ADDED MESSAGE TO PA SIGNATURE BOX                JA
          MOVE 'HIT ENTER KEY WHEN PA SIGNATURE IS COMPLETE      '
                                         TO TPS0054D-MENU-LINE
                                            TPS0054D-MENU-LINE.


           INITIALIZE  TPS0054D-CL-WINDOW-FLAG
                       TPS0054D-END-FLAG                  
                       TPS0054D-CR-FLAG. 

           MOVE TPS0054D-DATA-BLOCK-VERSION-NO 
                                 TO DS-DATA-BLOCK-VERSION-NO
           MOVE TPS0054D-VERSION-NO TO DS-VERSION-NO
           MOVE WS-CURRENT-X TO TPS0054D-DSMOVSZ-X.
           MOVE WS-CURRENT-Y TO TPS0054D-DSMOVSZ-Y.
           MOVE DS-PUSH-SET TO DS-CONTROL
           MOVE "TPS0054D"  TO DS-SET-NAME
           CALL "DSGRUN" USING DS-CONTROL-BLOCK
                               TPS0054D-DATA-BLOCK.

          MOVE TPS0054D-DSMOVSZ-X TO WS-CURRENT-X.
          MOVE TPS0054D-DSMOVSZ-Y TO WS-CURRENT-Y.
          MOVE WS-CURRENT-X TO WS-X-PARM.
          MOVE WS-CURRENT-Y TO WS-Y-PARM.

      *********** CLOSE POPUP TPS0054D *************************

           MOVE TPS0054D-DATA-BLOCK-VERSION-NO 
                                 TO DS-DATA-BLOCK-VERSION-NO
           MOVE TPS0054D-VERSION-NO TO DS-VERSION-NO
           MOVE WS-CURRENT-X TO TPS0054D-DSMOVSZ-X.
           MOVE WS-CURRENT-Y TO TPS0054D-DSMOVSZ-Y.
           MOVE DS-QUIT-SET TO DS-CONTROL
           MOVE "TPS0054D"  TO DS-SET-NAME
           CALL "DSGRUN" USING DS-CONTROL-BLOCK
                               TPS0054D-DATA-BLOCK.

          MOVE TPS0054D-DSMOVSZ-X TO WS-CURRENT-X.
          MOVE TPS0054D-DSMOVSZ-Y TO WS-CURRENT-Y.
          MOVE WS-CURRENT-X TO WS-X-PARM.
          MOVE WS-CURRENT-Y TO WS-Y-PARM.
      *********************************************************


          IF NOT TPS0054D-CR-FLAG-TRUE
             MOVE 'HIT ENTER KEY  '  TO TPS0054D-MENU-LINE
             MOVE 1                  TO TPS0054D-ACTIVE-FIELD
             GO TO 0350-DISPLAY.

          IF TPS0054D-NEW-SIGNATURE = SPACES
      *04/13/15 ADJUSTED ERROR MESSAGE TO PA SIGNATURE BOX          JA
             MOVE 'ENTER PA SIGNATURE! HIT ENTER KEY WHEN COMPLETE  '
                                    TO TPS0054D-MENU-LINE
             MOVE 1                  TO TPS0054D-ACTIVE-FIELD
             GO TO 0350-DISPLAY.

      ********** CHECK PA SIGNATURE ***********
          MOVE TPS0054D-NEW-SIGNATURE   TO LOGREC-KEY.
          PERFORM 0600-START-LOGON THRU 0600-EXIT.
          MOVE F-PRIME         TO FILE-KEY.
          MOVE F-READ-NEXT     TO FILE-ACTION.
          CALL TPSIO001 USING FILE-REQUEST TPSLOGON.
          IF NOT A-SUCCESSFUL-OPERATION
             MOVE 'LOGON   '     TO FILE-NAME
             MOVE 'TPS0054-READ' TO FILE-TEXT
             PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
             GO TO EXIT-THE-MODULE.

          PERFORM 0650-GET-SIGNATURE-INFO THRU 0650-EXIT.

          MOVE NEW-CLIENT-NO            TO SIGNATURE-ACCT-NO.
          MOVE ZEROS                    TO SIGNATURE-SUB-ACCT.
          MOVE TPS0054D-NEW-SIGNATURE   TO SIGNATURE-LOGON-ID
          MOVE LS-ACCESS-LEVEL-NAME     TO SIGNATURE-NAME
          MOVE LS-ACCESS-LEVEL-TITLE    TO SIGNATURE-TITLE
          MOVE LS-ACCESS-LEVEL-INITIALS TO SIGNATURE-INITIALS
          PERFORM 0550-WRITE-REC THRU 0550-EXIT.

       0350-EXIT.  EXIT.

       0400-DELETE-CLIENT.

          MOVE 'ENTER KEY TO PROCESS END KEY TO GO BACK'
                                     TO TPS0054C::MENU-LINE.


       0400-DISPLAY.

           SET TPS0054C::X-POINT TO WS-X-PARM.
           SET TPS0054C::Y-POINT TO WS-Y-PARM.
           INVOKE TPS0054C::ShowDialog.
           MOVE TPS0054C::Location::X TO WS-X-PARM
                                         WS-CURRENT-X.
           MOVE TPS0054C::Location::Y TO WS-Y-PARM
                                         WS-CURRENT-Y.
           MOVE TPS0054C::SCREEN-NAME TO SCREEN-NAME.


          IF NOT TPS0054C::KEY-PRESSED = "Enter Key"
             GO TO 0001-DISPLAY.

          IF TPS0054C::SIGNATURE-CLIENT = ZEROS
             MOVE 'ENTER CLIENT NO'  TO TPS0054C::MENU-LINE
             MOVE 1                  TO TPS0054C::ACTIVE-FIELD
             GO TO 0400-DISPLAY.

      ********** CHECK FOR CLIENT PA SIGNATURE RECORD ***********
          MOVE TPS0054C::SIGNATURE-CLIENT    TO SIGNATURE-ACCT-NO.
          MOVE ZEROS               TO SIGNATURE-SUB-ACCT.
          MOVE F-PRIME         TO FILE-KEY.
          MOVE F-READ          TO FILE-ACTION.
          CALL TPSIO032 USING FILE-REQUEST SIGNATURE.
          IF NO-RECORD-WAS-FOUND
             MOVE 'CLIENT RECORD DOES NOT EXITS' TO 
                   TPS0054C::MENU-LINE
             MOVE 1              TO TPS0054C::ACTIVE-FIELD
             GO TO 0400-DISPLAY
          ELSE
          IF NOT A-SUCCESSFUL-OPERATION
             MOVE 'SIGNATUR'     TO FILE-NAME
             MOVE 'TPS0054-READ' TO FILE-TEXT
             PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
             GO TO EXIT-THE-MODULE.

      *********** DISPLAY PROCESSING SCREEN *************
      *04/11/17

           
           IF PROCESSFORM-DISPLAY-FLAG = 0
               SET PROCESSFORM::X-POINT TO WS-X-PARM
               SET PROCESSFORM::Y-POINT TO WS-Y-PARM
               INVOKE PROCESSFORM::Show
               MOVE 1 TO PROCESSFORM-DISPLAY-FLAG
           END-IF.




      ******** DELETE RECORD ************
          MOVE F-PRIME         TO FILE-KEY.
          MOVE F-DELET         TO FILE-ACTION.
          CALL TPSIO032 USING FILE-REQUEST SIGNATURE.
          IF NOT A-SUCCESSFUL-OPERATION
             MOVE 'SIGNATUR'       TO FILE-NAME
             MOVE 'TPS0054-DELETE' TO FILE-TEXT
             PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
             GO TO EXIT-THE-MODULE.

       0400-EXIT.    EXIT.

       0450-PRINT-CLIENTS.

      *********** DISPLAY PRINTING SCREEN *************
      *04/11/17

           IF PROCESSFORM-DISPLAY-FLAG = 0
               SET PROCESSFORM::X-POINT TO WS-X-PARM
               SET PROCESSFORM::Y-POINT TO WS-Y-PARM
               INVOKE PROCESSFORM::Show
               MOVE 1 TO PROCESSFORM-DISPLAY-FLAG
           END-IF.




          MOVE ZEROS                 TO SIGNATURE-KEY.
          OPEN OUTPUT PRT-FILE.
          PERFORM 0605-LOAD-SECURE-CLIENTS THRU 0605-EXIT.
          PERFORM 0610-START-SIGNATURE THRU 0610-EXIT.
          PERFORM 0620-OPEN-PROFILE THRU 0620-EXIT.
          PERFORM 0460-HEADER THRU 0460-EXIT.

       0450-CONTINUE.

          MOVE F-PRIME         TO FILE-KEY.
          MOVE F-READ-NEXT     TO FILE-ACTION.
          CALL TPSIO032 USING FILE-REQUEST SIGNATURE.
          IF END-OF-FILE-WAS-REACHED
             GO TO 0450-EXIT.
          IF NOT A-SUCCESSFUL-OPERATION
             MOVE 'SIGNATUR'   TO FILE-NAME
             MOVE 'TPS0054-REN' TO FILE-TEXT
             PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
             GO TO EXIT-THE-MODULE.

          MOVE SIGNATURE-ACCT-NO       TO CLNT-PROFILE-ACCT-NO.
          MOVE ZEROS                   TO CLNT-PROFILE-SUB-ACCT.
          MOVE F-PRIME         TO FILE-KEY.
          MOVE F-READ          TO FILE-ACTION.
          CALL TPSIO004 USING FILE-REQUEST TPSPROFL.
          IF NOT A-SUCCESSFUL-OPERATION
             MOVE 'PROFILE '      TO FILE-NAME
             MOVE 'TPS0054-READ ' TO FILE-TEXT
             PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
             GO TO EXIT-THE-MODULE.

      ********** SET UP PRINT LINE *************
          IF CLNT-PROFILE-ADD-DATE(1:1) > '7'
             GO TO 0450-CONTINUE.

      ********** SET UP PRINT LINE *************
          MOVE SIGNATURE-ACCT-NO           TO PRT-ACCT-NO.
          PERFORM 0660-GET-PROFILE-NAME THRU 0660-EXIT.
          MOVE SIGNATURE-LOGON-ID          TO PRT-SIG-ID.
          MOVE SIGNATURE-NAME              TO PRT-SIG-NAME.
          IF SIGNATURE-TO-DATE >= TODAYS-DATE-CYMD OR
             SIGNATURE-FROM-DATE > TODAYS-DATE-CYMD
             MOVE SIGNATURE-NEW-LOGON-ID   TO PRT-TEMP-ID
             MOVE SIGNATURE-FROM-DATE(3:2) TO PRT-FROM-YY
             MOVE SIGNATURE-FROM-DATE(5:2) TO PRT-FROM-MM
             MOVE SIGNATURE-FROM-DATE(7:2) TO PRT-FROM-DD
             MOVE SIGNATURE-TO-DATE(3:2)   TO PRT-TO-YY
             MOVE SIGNATURE-TO-DATE(5:2)   TO PRT-TO-MM
             MOVE SIGNATURE-TO-DATE(7:2)   TO PRT-TO-DD
             MOVE TEMP-INFO                TO PRT-TEMP-INFO
          ELSE
             MOVE SPACES                   TO PRT-TEMP-INFO.
      *01/10/17 PRINT 'SECURE EMAIL CLIENT' ON REPORT
          PERFORM WITH TEST BEFORE                                                         00148500
                  VARYING WS-IDX FROM 1 BY 1 UNTIL                                         00148500
                  WS-IDX > TBL-IDX OR                                                      00148600
                  SECURE-ACCT-NO(WS-IDX) > SIGNATURE-ACCT-NO                               00148700
             IF SECURE-ACCT-NO(WS-IDX) = SIGNATURE-ACCT-NO                                 00148700
                MOVE 'SECURED EMAIL CLIENT' TO PRT-SIG-NAME(25:20)                         00148500
          END-PERFORM.                                                                     00148900
                                                                                           00148900
          WRITE PRT-RECORD FROM PRINT-REC AFTER ADVANCING 1.
          MOVE SPACES      TO PRINT-REC
          ADD 1                            TO LINES-PRINTED.
          IF LINES-PRINTED > LINES-PER-PAGE
             PERFORM 0460-HEADER THRU 0460-EXIT.

          GO TO 0450-CONTINUE.

       0450-EXIT.
          WRITE PRT-RECORD FROM END-OF-PRINT AFTER 2.
          WRITE PRT-RECORD FROM PCL-RESET AFTER 0.
          CLOSE PRT-FILE.
            EXIT.

       0460-HEADER.

          IF PAGES-PRINTED > 0
          WRITE PRT-RECORD FROM NEW-PAGE   AFTER ADVANCING 0 LINES
          END-IF.
          ADD 1 TO PAGES-PRINTED.
          MOVE PAGES-PRINTED TO PAGES-PRINTED-MASK.
          MOVE PAGES-PRINTED-MASK TO PAGE-NO.
          WRITE PRT-RECORD FROM PCL5-LANDSCAPE AFTER 0 LINES.
          WRITE PRT-RECORD FROM COURIER-56 AFTER ADVANCING 0 LINES.
          WRITE PRT-RECORD FROM HEADING-1   AFTER ADVANCING 1 LINE.
      *   WRITE PRT-RECORD FROM HEADING-2   AFTER ADVANCING 1 LINE.
      *   WRITE PRT-RECORD FROM HEADING-3   AFTER ADVANCING 1 LINE.
          WRITE PRT-RECORD FROM HEADING-4  AFTER ADVANCING 2 LINES.
          WRITE PRT-RECORD FROM COURIER-36 AFTER ADVANCING 0 LINES

          MOVE 4 TO LINES-PRINTED.

           MOVE 0 TO PROCESSFORM-DISPLAY-FLAG.
           INVOKE PROCESSFORM::Hide.

       0460-EXIT.    EXIT.

       0500-REWRITE.

          MOVE F-PRIME         TO FILE-KEY.
          MOVE F-REWRITE       TO FILE-ACTION.
          CALL TPSIO032 USING FILE-REQUEST SIGNATURE.
          IF NOT A-SUCCESSFUL-OPERATION
             MOVE 'SIGNATURE'    TO FILE-NAME
             MOVE 'TPS0054-REWR' TO FILE-TEXT
             PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
             GO TO EXIT-THE-MODULE.

       0500-EXIT.

       0550-WRITE-REC.

          MOVE F-PRIME         TO FILE-KEY.
          MOVE F-WRITE         TO FILE-ACTION.
          CALL TPSIO032 USING FILE-REQUEST SIGNATURE.
          IF NOT A-SUCCESSFUL-OPERATION
             MOVE 'SIGNATURE'    TO FILE-NAME
             MOVE 'TPS0054-RITE' TO FILE-TEXT
             PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
             GO TO EXIT-THE-MODULE.

       0550-EXIT.

       0600-START-LOGON.

          MOVE F-PRIME         TO FILE-KEY.
          MOVE F-START         TO FILE-ACTION.
          CALL TPSIO001 USING FILE-REQUEST TPSLOGON.
          IF NOT A-SUCCESSFUL-OPERATION
             MOVE 'LOGON   '     TO FILE-NAME
             MOVE 'TPS0054-STAR' TO FILE-TEXT
             PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
             GO TO EXIT-THE-MODULE.

       0600-EXIT.

      *01/10/17 LOAD SECURE EMAIL CLIENTS TABLE
       0605-LOAD-SECURE-CLIENTS.

          INITIALIZE TPS-EMAIL-REC.
          MOVE ZERO  TO TBL-IDX.

          SET FR-OPEN-INPUT TO TRUE.
          CALL TPSIO033 USING FILE-REQUEST TPS-EMAIL-REC.
          IF FILE-STATUS NOT = '00' AND '05'
             MOVE 'EMAIL' TO FILE-NAME
             MOVE 'TPS0054-OPEN' TO FILE-TEXT
             PERFORM FILE-ERROR THRU
                     FILE-ERROR-EXIT
             GO TO EXIT-THE-MODULE
           END-IF.

      *080118 DO START BEFORE READ NEXT
          MOVE F-PRIME         TO FILE-KEY.
          MOVE F-START         TO FILE-ACTION.
          CALL TPSIO033 USING FILE-REQUEST TPS-EMAIL-REC.
          IF NOT A-SUCCESSFUL-OPERATION
             MOVE 'EMAIL   '     TO FILE-NAME
             MOVE 'TPS0054-STAR' TO FILE-TEXT
             PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
             GO TO EXIT-THE-MODULE.

       0605-CONTINUE.

          SET FR-READ-NEXT TO TRUE
          CALL TPSIO033 USING FILE-REQUEST TPS-EMAIL-REC.
          IF END-OF-FILE-WAS-REACHED
             GO TO 0605-EXIT.
          IF NOT A-SUCCESSFUL-OPERATION
             MOVE 'EMAIL' TO FILE-NAME
             MOVE 'TPS0054-READ' TO FILE-TEXT
             PERFORM FILE-ERROR THRU
                     FILE-ERROR-EXIT
             GO TO EXIT-THE-MODULE
           END-IF.

         IF EMAIL-SECURED = 'Y'
            ADD 1              TO TBL-IDX
            MOVE EMAIL-ACCT-NO TO SECURE-ACCT-NO(TBL-IDX)
            GO TO 0605-CONTINUE
         ELSE
            GO TO 0605-CONTINUE.

       0605-EXIT.   EXIT.


       0610-START-SIGNATURE.

          MOVE F-PRIME         TO FILE-KEY.
          MOVE F-START         TO FILE-ACTION.
          CALL TPSIO032 USING FILE-REQUEST SIGNATURE.
          IF NOT A-SUCCESSFUL-OPERATION
             MOVE 'SIGNATUR'   TO FILE-NAME
             MOVE 'TPS0054-STR' TO FILE-TEXT
             PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
             GO TO EXIT-THE-MODULE.

       0610-EXIT.

       0620-OPEN-PROFILE.

          MOVE 'Y'             TO PROFL-OPEN.
          MOVE F-PRIME         TO FILE-KEY.
          MOVE F-OPEN-INPUT    TO FILE-ACTION.
          CALL TPSIO004 USING FILE-REQUEST TPSPROFL.
          IF NOT A-SUCCESSFUL-OPERATION
             MOVE 'PROFILE '     TO FILE-NAME
             MOVE 'TPS0054-OPEN' TO FILE-TEXT
             PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
             GO TO EXIT-THE-MODULE.

       0620-EXIT.

       0630-READ-PROFILE.

          MOVE F-PRIME         TO FILE-KEY.
          MOVE F-START         TO FILE-ACTION.
          CALL TPSIO004 USING FILE-REQUEST TPSPROFL.
          IF NOT A-SUCCESSFUL-OPERATION
             MOVE 'PROFILE '      TO FILE-NAME
             MOVE 'TPS0054-START' TO FILE-TEXT
             PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
             GO TO EXIT-THE-MODULE.

       0630-EXIT.

       0650-GET-SIGNATURE-INFO.

            MOVE SPACES             TO BG-FLOAT-PARMS.
            MOVE LOGREC-ADMIN-FIRST-NAME
                                    TO BG-FLOAT-1.
            IF LOGREC-ADMIN-MID-INIT = SPACES
               MOVE '2'             TO BG-FLOAT-COUNT
               MOVE LOGREC-ADMIN-LAST-NAME
                                    TO BG-FLOAT-2
               MOVE LOGREC-ADMIN-FIRST-NAME(1:1)
                                    TO LS-ACCESS-LEVEL-INITIALS(1:1)
               MOVE LOGREC-ADMIN-LAST-NAME(1:1)
                                    TO LS-ACCESS-LEVEL-INITIALS(2:1)
               MOVE '/hs '          TO LS-ACCESS-LEVEL-INITIALS(3:4)
            ELSE
               MOVE '3'             TO BG-FLOAT-COUNT
               MOVE LOGREC-ADMIN-MID-INIT
                                    TO BG-FLOAT-2
               MOVE '.'             TO BG-FLOAT-2(2:1)
               MOVE LOGREC-ADMIN-LAST-NAME
                                    TO BG-FLOAT-3
               MOVE LOGREC-ADMIN-FIRST-NAME(1:1)
                                    TO LS-ACCESS-LEVEL-INITIALS(1:1)
               MOVE LOGREC-ADMIN-MID-INIT
                                    TO LS-ACCESS-LEVEL-INITIALS(2:1)
               MOVE LOGREC-ADMIN-LAST-NAME(1:1)
                                    TO LS-ACCESS-LEVEL-INITIALS(3:1)
               MOVE '/hs'           TO LS-ACCESS-LEVEL-INITIALS(4:3)
            END-IF.
              CALL FLOATBIG USING BG-FLOAT-DATA.
            MOVE BG-FLOAT-1 (1:36)  TO LS-ACCESS-LEVEL-NAME.


       0650-EXIT.

       0660-GET-PROFILE-NAME.

            MOVE SPACES             TO BG-FLOAT-PARMS.
            MOVE CLNT-PROFILE-FIRST-NAME
                                    TO BG-FLOAT-1.
            IF CLNT-PROFILE-MDDL-INIT = SPACES
               MOVE '2'             TO BG-FLOAT-COUNT
               MOVE CLNT-PROFILE-LAST-NAME
                                    TO BG-FLOAT-2
            ELSE
               MOVE '3'             TO BG-FLOAT-COUNT
               MOVE CLNT-PROFILE-MDDL-INIT
                                    TO BG-FLOAT-2
               MOVE '.'             TO BG-FLOAT-2(2:1)
               MOVE CLNT-PROFILE-LAST-NAME
                                    TO BG-FLOAT-3
            END-IF.
              CALL FLOATBIG USING BG-FLOAT-DATA.
            MOVE BG-FLOAT-1 (1:36)  TO PRT-ACCT-NAME.


       0660-EXIT.

       0700-MULTI-CLIENTS.

      ***  CHANGED SIGNATURE-KEY TO SIGNATURE-ACCT-NO
          IF SIGNATURE-ACCT-NO < TPS0054B::CLIENT-NO OR
             SIGNATURE-ACCT-NO > TPS0054B::ENDING-CLIENT-NO
             GO TO 0700-EXIT.

      ******* TEMPORARY & PERMANT CHANGE FOR RANGE OF CLIENTS ********
          IF SIGNATURE-LOGON-ID = TPS0054B-CUR-SIGNATURE AND
             TPS0054B::ENDING-CLIENT-NO > ZEROS AND
             TPS0054B-FROM-DATE > ZEROS AND
             TPS0054B-TO-DATE > ZEROS
             MOVE TPS0054B-NEW-SIGNATURE
             TO SIGNATURE-NEW-LOGON-ID
             MOVE TPS0054B-FROM-DATE  TO SIGNATURE-FROM-DATE
             MOVE TPS0054B-TO-DATE    TO SIGNATURE-TO-DATE
             MOVE LS-ACCESS-LEVEL-NAME     TO SIGNATURE-NEW-NAME
             MOVE LS-ACCESS-LEVEL-TITLE    TO SIGNATURE-NEW-TITLE
             MOVE LS-ACCESS-LEVEL-INITIALS TO SIGNATURE-NEW-INITIALS
             PERFORM 0500-REWRITE THRU 0500-EXIT
          ELSE
          IF SIGNATURE-LOGON-ID = TPS0054B-CUR-SIGNATURE AND
             TPS0054B::ENDING-CLIENT-NO > ZEROS AND
             TPS0054B-FROM-DATE = ZEROS AND
             TPS0054B-TO-DATE = ZEROS
             MOVE TPS0054B-NEW-SIGNATURE        TO SIGNATURE-LOGON-ID
             MOVE LS-ACCESS-LEVEL-NAME     TO SIGNATURE-NAME
             MOVE LS-ACCESS-LEVEL-TITLE    TO SIGNATURE-TITLE
             MOVE LS-ACCESS-LEVEL-INITIALS TO SIGNATURE-INITIALS
             PERFORM 0500-REWRITE THRU 0500-EXIT.

          MOVE F-PRIME         TO FILE-KEY.
          MOVE F-READ-NEXT     TO FILE-ACTION.
          CALL TPSIO032 USING FILE-REQUEST SIGNATURE.
          IF END-OF-FILE-WAS-REACHED
             GO TO 0700-EXIT
          ELSE
          IF NOT A-SUCCESSFUL-OPERATION
             MOVE 'SIGNATUR'     TO FILE-NAME
             MOVE 'TPS0054-READ' TO FILE-TEXT
             PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
             GO TO EXIT-THE-MODULE.

          GO TO 0700-MULTI-CLIENTS.

       0700-EXIT.

       EXIT-THE-MODULE.

      ******* RETURN TO ORIGINAL LOGON **********
          MOVE SAVE-LOGREC-KEY     TO LOGREC-KEY.
          PERFORM 0600-START-LOGON THRU 0600-EXIT.
          MOVE F-PRIME         TO FILE-KEY.
          MOVE F-READ-NEXT     TO FILE-ACTION.
          CALL TPSIO001 USING FILE-REQUEST TPSLOGON.
          IF NOT A-SUCCESSFUL-OPERATION
             MOVE 'LOGON   '     TO FILE-NAME
             MOVE 'TPS0054-READ' TO FILE-TEXT
             PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
             GO TO EXIT-THE-MODULE.

          IF PROFL-OPEN = 'Y'
             MOVE F-PRIME         TO FILE-KEY
             MOVE F-CLOSE         TO FILE-ACTION
             CALL TPSIO004 USING FILE-REQUEST TPSPROFL
             IF NOT A-SUCCESSFUL-OPERATION
                MOVE 'PROFILE '     TO FILE-NAME
                MOVE 'TPS0054-CLOS' TO FILE-TEXT
                PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
                GO TO EXIT-THE-MODULE.

          MOVE F-PRIME         TO FILE-KEY
          MOVE F-CLOSE         TO FILE-ACTION
          CALL TPSIO032 USING FILE-REQUEST SIGNATURE.
          IF NOT A-SUCCESSFUL-OPERATION
             MOVE 'SIGNATUR'   TO FILE-NAME
             MOVE 'TPS0054-CLS' TO FILE-TEXT
             PERFORM FILE-ERROR THRU FILE-ERROR-EXIT.

          CANCEL TPSIO032.

           SET TPS0054::KEY-PRESSED TO "End Key".
           SET TPS0054A::KEY-PRESSED TO "End Key".
           SET TPS0054B::KEY-PRESSED TO "End Key".
           SET TPS0054C::KEY-PRESSED TO "End Key".

           INVOKE TPS0054::Close.
           INVOKE TPS0054A::Close.
           INVOKE TPS0054B::Close.
           INVOKE TPS0054C::Close.


           INITIALIZE CURRENT-XY-PARAMETERS.
           MOVE WS-CURRENT-X TO CURRENT-XY-PARAMETERS(1:4).
           MOVE WS-CURRENT-Y TO CURRENT-XY-PARAMETERS(5:4).



          GOBACK GIVING CURRENT-XY-PARAMETERS.

       FILE-ERROR.
            CALL TPSIOERR USING FILE-REQUEST
                                WS-CURRENT-XY-PARM.  
            CANCEL TPSIOERR.

            MOVE WS-CURRENT-XY-PARM(1:4) TO WS-CURRENT-X.
            MOVE WS-CURRENT-XY-PARM(5:4) TO WS-CURRENT-Y.


           INITIALIZE CURRENT-XY-PARAMETERS.
           MOVE WS-CURRENT-X TO CURRENT-XY-PARAMETERS(1:4).
           MOVE WS-CURRENT-Y TO CURRENT-XY-PARAMETERS(5:4).

       FILE-ERROR-EXIT. EXIT.

