       IDENTIFICATION DIVISION.
       PROGRAM-ID. TPSIOME1.

      ******************************************************************
      *     THIS PROGRAM PERFORMS I/O TO THE MEMO1 FILE WHICH          *
      *     CONTAINS MEMO RECORDS EARLIER THAN 2017. THIS PROGRAM      *
      *     IS CALLED BY TPSIOMEM.CBL WHICH READS MEMO RECORDS         *
      *     LATER THAN 01/01/2017.                                     *
      ******************************************************************
      ******************************************************************
      *07/12/18 Restored this program because the changes that were
      *         made to it did not work. This program is for
      *         tpsiome1.dll dated 10/03/2017                        AC*
      ******************************************************************

       ENVIRONMENT DIVISION.
       CONFIGURATION SECTION.
       SOURCE-COMPUTER. IBM-PC.
       OBJECT-COMPUTER. IBM-PC.
       SPECIAL-NAMES.
       INPUT-OUTPUT SECTION.
       FILE-CONTROL.
           SELECT TPSMEMO-FILE ASSIGN TO DYNAMIC  FILESPEC
               ORGANIZATION IS INDEXED
                   LOCK MODE IS AUTOMATIC
               ACCESS MODE IS DYNAMIC
               RECORD KEY IS TPS-MEMO-KEY OF FS
               FILE STATUS IS FILE-STATUS-LOCAL.
       DATA DIVISION.
       FILE SECTION.
       FD  TPSMEMO-FILE
               LABEL RECORDS STANDARD.
       01  FS.
           COPY "TPSMEMO.CPY".
       WORKING-STORAGE SECTION.
       01  FILESPEC                    PIC X(25) VALUE 
           '\tps\prod\files\memo1.dat'.
       01  FILE-STATUS-LOCAL           PIC XX VALUE ZERO.
      *
      *                         :---------------------------------------
      * ------------------------: Save next available key so we can
      *                         : automatically assign prime keys.
      *                         :---------------------------------------
       01  NEXT-KEY-RECORD.
           05  FILLER                  PIC X(52) VALUE HIGH-VALUE.
           05  NEXT-KEY-NUMBER         PIC S9(9) COMP-4 VALUE 1.
           05  FILLER                  PIC X(167) VALUE LOW-VALUE.
       01  END-KEY.
           05 END-ACCT-NO              PIC 9(10).
           05 END-SUB-ACCT             PIC 9(02).
       01  OPENED-FLAG                 PIC X.
       01  GENERIC-FLAG                PIC X.
       01  GENERIC-KEY-LENGTH-LV       PIC S9(4) COMP-5.
       01  GENERIC-KEY-LENGTH          PIC S9(4) COMP-5.
       01  GENERIC-KEY.
           05  GENERIC-KEY-BYTE OCCURS 50 INDEXED BY GKDEX
                                       PIC X.
       01  GENERIC-TEST.
           05  GENERIC-TEST-BYTE OCCURS 50 INDEXED BY GTDEX
                                       PIC X.
      *
      *                         :---------------------------------------
      * ------------------------: Table to pass back clear text
      *                         : message following file operations.
      *                         :---------------------------------------
      *
      *%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
       LINKAGE SECTION.
      *
               COPY TPSFILES.CPY.
       01 LS.
               COPY "TPSMEMO.CPY".
      *%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
       PROCEDURE DIVISION USING FILE-REQUEST LS.
      *%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
      *
       0001-STARTUP.
      *                         :---------------------------------------
      * ------------------------: Load the keys, initialize variables.
      *                         :---------------------------------------
      *

           IF FILESPEC = SPACES
            DISPLAY "TPSMEMO1FILE" UPON ENVIRONMENT-NAME
            ACCEPT FILESPEC FROM ENVIRONMENT-VALUE.
           MOVE '00' TO FILE-STATUS-LOCAL FILE-STATUS.
      *
      *                         :---------------------------------------
      * ------------------------: Perform the requested operation.
      *                         :---------------------------------------
      *
           GO TO
               0003-FR-OPEN-INPUT
               0004-FR-OPEN-I-O
               0005-FR-CLOSE
               0006-FR-WRITE
               0007-FR-REWRITE
               0008-FR-DELETE
               0009-FR-START
               0009-FR-START
               0010-FR-START-HIGH
               0010-FR-START-HIGH
               0011-FR-READ
               0012-FR-READ-NEXT
               0013-FR-READ-PREVIOUS
               DEPENDING
               ON FILE-ACTION.
      * -====-
       0002-FR-CREATE.
      *                         :---------------------------------------
      * ------------------------: Create the file & then open it I/O.
      *                         : If not a CREATE request,
      *                         :   return 'Invalid function' status.
      *                         :---------------------------------------
      *
           IF FR-CREATE
             OPEN OUTPUT TPSMEMO-FILE
             IF FILE-STATUS-LOCAL = '00'
      *
      *                         :---------------------------------------
      * ------------------------: Note:  Status 41 indicates a request
      *                         : to open an already opened file.
      *                         :
      *                         : This (OR '41') status code test
      *                         : circumvents a Micro Focus bug, to wit:
      *                         :
      *                         : The very first attempt to open this
      *                         : file failed (as expected) because the
      *                         : file didn't exist.  We therefore must
      *                         : open the file OUTPUT to create it.  We
      *                         : receive status 41 on this attempt,
      *                         : which is incorrect because the file
      *                         : wasn't OPENed in the first attempt.
      *                         :---------------------------------------
                   OR '41'
               WRITE FS FROM
                   NEXT-KEY-RECORD
                   INVALID KEY
                 CONTINUE
               END-WRITE
               IF FILE-STATUS-LOCAL = '00'
                 CLOSE TPSMEMO-FILE
                 IF FILE-STATUS-LOCAL = '00'
                   OPEN I-O TPSMEMO-FILE
                   IF FILE-STATUS-LOCAL = '00'
                     MOVE 'Y' TO OPENED-FLAG
                   END-IF
                 END-IF
               END-IF
             END-IF
           ELSE
             MOVE 'ZZ' TO FILE-STATUS-LOCAL.
      *
           GO TO 0017-RETURN.
      * -====-
       0003-FR-OPEN-INPUT.
      *                         :---------------------------------------
      * ------------------------: Open the file INPUT.
      *                         :---------------------------------------
      *
           IF OPENED-FLAG NOT = 'Y'
             OPEN INPUT TPSMEMO-FILE
             MOVE 'Y' TO OPENED-FLAG.
      *
           GO TO 0017-RETURN.
      * -====-
       0004-FR-OPEN-I-O.
      *                         :---------------------------------------
      * ------------------------: Open the file I/O and get highest key.
      *                         :---------------------------------------
      *
           IF OPENED-FLAG NOT = 'Y'
             OPEN I-O TPSMEMO-FILE.
      *
           GO TO 0017-RETURN.
      * -====-
       0005-FR-CLOSE.
      *                         :---------------------------------------
      * ------------------------: Close the file.
      *                         :---------------------------------------
      *
           IF OPENED-FLAG = 'Y'
             CLOSE TPSMEMO-FILE
             MOVE 'N' TO OPENED-FLAG.
      *
           GO TO 0017-RETURN.
      * -====-
       0006-FR-WRITE.
      *                         :---------------------------------------
      * ------------------------: Write a new record.
      *                         :---------------------------------------
      *
           WRITE FS FROM LS.
      *
      *
           GO TO 0017-RETURN.
      * -====-
       0007-FR-REWRITE.
      *                         :---------------------------------------
      * ------------------------: Rewrite the record.
      *                         :---------------------------------------
      *
           REWRITE FS FROM LS.
      *
           GO TO 0017-RETURN.
      * -====-
       0008-FR-DELETE.
      *                         :---------------------------------------
      * ------------------------: Delete the record.
      *                         :---------------------------------------
      *
           DELETE TPSMEMO-FILE RECORD.
      *
           GO TO 0017-RETURN.
      * -====-
       0009-FR-START.
      *                         :---------------------------------------
      * ------------------------: Set sequential for browsing.
      *                         :
      *                         : If a generic start,
      *                         :   save the portion of the key that
      *                         :   was provided for later testing.
      *                         :
      *                         :---------------------------------------
      *
           IF FR-PRIME
             MOVE TPS-MEMO-KEY OF LS TO TPS-MEMO-KEY OF FS
             MOVE TPS-MEMO-KEY OF FS TO GENERIC-KEY
             START TPSMEMO-FILE KEY NOT LESS THAN TPS-MEMO-KEY OF FS
                 INVALID KEY
               CONTINUE.
      *
           GO TO 0017-RETURN.
      * -====-
       0010-FR-START-HIGH.
      *                         :---------------------------------------
      * ------------------------: Set sequential to the end of file.
      *                         :
      *                         : If a generic start,
      *                         :   save the portion of the key that
      *                         :   was provided for later testing.
      *                         :
      *                         :---------------------------------------
      *
           IF FR-PRIME
             MOVE TPS-MEMO-KEY OF FS TO GENERIC-KEY
             MOVE HIGH-VALUE TO TPS-MEMO-KEY OF FS
             START TPSMEMO-FILE KEY EQUAL TPS-MEMO-KEY OF FS
                 INVALID KEY
               CONTINUE.
      *
      * -====-
       0011-FR-READ.
      *                         :---------------------------------------
      * ------------------------: Read the record directly on prime key.
      *                         : We do business this way to eliminate
      *                         : problems that can occur when you try
      *                         : to read using an alternate key that
      *                         : duplicates allowed.  The prime key
      *                         : NEVER allows duplicates.
      *                         :---------------------------------------
      *
           MOVE TPS-MEMO-KEY OF LS TO TPS-MEMO-KEY OF FS.
           READ TPSMEMO-FILE INTO LS
               KEY IS TPS-MEMO-KEY OF FS
               INVALID KEY
             MOVE LOW-VALUES TO LS.
      *
           GO TO 0017-RETURN.
      * -====-
       0012-FR-READ-NEXT.
      *                         :---------------------------------------
      * ------------------------: Browse (read sequential) the file.
      *                         :---------------------------------------
      *
      *  ** SET UP RECORD TO JUMP FROM OLD3 FILE TO NEW FILE **
      *    IF FILE-NAME = 'END3'
              MOVE TPS-MEMO-ACCT-NO OF LS   TO END-ACCT-NO.
              MOVE TPS-MEMO-SUB-ACCT OF LS  TO END-SUB-ACCT.
              
           READ TPSMEMO-FILE
           NEXT RECORD INTO LS
          IGNORE LOCK
           AT END
             MOVE 'N' TO GENERIC-FLAG.
      *
      * SET UP RECORD TO JUMP FROM OLD2 FILE TO NEW FILE 
       
           IF FILE-NAME = 'END3'
             IF TPS-MEMO-ACCT-NO OF LS NOT = END-ACCT-NO OR
                TPS-MEMO-SUB-ACCT OF LS NOT = END-SUB-ACCT
                  MOVE 'NEW4'           TO FILE-NAME
                  MOVE END-ACCT-NO      TO TPS-MEMO-ACCT-NO OF LS
                  MOVE END-SUB-ACCT     TO TPS-MEMO-SUB-ACCT OF LS
                  MOVE '20170101'       TO TPS-MEMO-RECEIVE-DATE OF LS
                  MOVE ZEROS            TO TPS-MEMO-RECEIVE-NO OF LS
             END-IF
           END-IF.
           
      * IF SEARCH IS FOR CLIENT NOT STARTED IN 3RD FILE
      * BUT STARTED IN 4TH FILE. EX:SUMMARY STARTS 6 MONTHS
      * BACK OF START DATE
        
           IF TPS-MEMO-ACCT-NO OF LS NOT = END-ACCT-NO OR
              TPS-MEMO-SUB-ACCT OF LS NOT = END-SUB-ACCT
                  MOVE 'NEW4'           TO FILE-NAME
                  MOVE END-ACCT-NO      TO TPS-MEMO-ACCT-NO OF LS
                  MOVE END-SUB-ACCT     TO TPS-MEMO-SUB-ACCT OF LS
                  MOVE '20170101'       TO TPS-MEMO-RECEIVE-DATE OF LS
                  MOVE ZEROS            TO TPS-MEMO-RECEIVE-NO OF LS
           END-IF.
           
      *
           GO TO 0017-RETURN.
      * -====-
       0013-FR-READ-PREVIOUS.
      *                         :---------------------------------------
      * ------------------------: Browse a file backwards.
      *                         :---------------------------------------
      *
           READ TPSMEMO-FILE
               PREVIOUS RECORD INTO LS
           AT END
             MOVE 'N' TO GENERIC-FLAG.
      *
           GO TO 0017-RETURN.
      * -====-
       0017-RETURN.
           MOVE FILE-STATUS-LOCAL TO FILE-STATUS.
           GOBACK.
