000400 IDENTIFICATION DIVISION.
000500 PROGRAM-ID. TPSIO023.
000600*****************************************************************
000700*  THIS PROGRAM PERFORMS I/O TO THE SPLIT MAIL DATA BASE        *
000800*****************************************************************
000700*                     maintenance log                           *
000700* 06/27/08- changes to accept the new key of split file      ts *
000700*                                                               *
000700*                                                               *
000800*****************************************************************
000900 ENVIRONMENT DIVISION.
001000
001100 CONFIGURATION SECTION.
001200 SOURCE-COMPUTER. IBM-PC.
001300 OBJECT-COMPUTER. IBM-PC.
001400 SPECIAL-NAMES.
001500     ENVIRONMENT-VALUE IS ENV-VALUE
001600     ENVIRONMENT-NAME IS ENV-NAME.
001700
001800 INPUT-OUTPUT SECTION.
001900 FILE-CONTROL.
002000
002100    SELECT SPLIT-FILE ASSIGN TO DYNAMIC FILESPEC
002200        ORGANIZATION IS INDEXED
002300        LOCK MODE IS AUTOMATIC
002400        ACCESS MODE IS DYNAMIC
002500        RECORD KEY IS SPLIT-KEY
002600        FILE STATUS IS FILE-STATUS-LOCAL.
002700
002800 DATA DIVISION.
002900
003000 FILE SECTION.
003100
003200 FD  SPLIT-FILE
003300        RECORD CONTAINS 256 CHARACTERS
003400        LABEL RECORDS STANDARD.
003500 01  SPLIT-REC.
003600      05  SPLIT-KEY                PIC  X(27).
003700      05  FILLER                   PIC  X(229).
003800
003900 WORKING-STORAGE SECTION.
004400*
004500 01  FILESPEC                    PIC X(28) VALUE 
           '\tps\prod\files\tpssplit.dat'.
004600*
004700 01  FILE-STATUS-LOCAL           PIC XX VALUE ZERO.
004800*
004900 01  NEXT-KEY-RECORD.
005000    05  FILLER                   PIC X(52) VALUE HIGH-VALUE.
005100    05  NEXT-KEY-NUMBER          PIC S9(9) COMP-4 VALUE 1.
005200    05  FILLER                   PIC X(167) VALUE LOW-VALUE.
005300*
005400 01  OPENED-FLAG                 PIC X.
005500*
005600 01  GENERIC-FLAG                PIC X.
005700*
005800 01  GENERIC-KEY-LENGTH-LV       PIC S9(4) COMP-5.
005900*
006000 01  GENERIC-KEY-LENGTH          PIC S9(4) COMP-5.
006100*
006200 01  GENERIC-KEY.
006300    05  GENERIC-KEY-BYTE OCCURS 50 INDEXED BY GKDEX
006400                                 PIC X.
006500 01  GENERIC-TEST.
006600    05  GENERIC-TEST-BYTE OCCURS 50 INDEXED BY GTDEX
006700                                 PIC X.
006800*
006900                              77   LINK-SIGN-ON      PIC  X(10).
007000                              77   LINK-PASSWORD     PIC  X(10).
007100 LINKAGE SECTION.
007200      COPY TPSFILES.CPY.
007300*
007400 01  CS.
007500      COPY TPSSPLIT.CPY.
007600*
007700 PROCEDURE DIVISION USING FILE-REQUEST CS.
007800*
007900 0001-STARTUP.
008000     IF FILESPEC = SPACES
008100      DISPLAY 'TPSSPLITFILE' UPON ENVIRONMENT-NAME
008200      ACCEPT FILESPEC FROM ENVIRONMENT-VALUE.
008300*
008400    MOVE SPLIT-REC-KEY         TO SPLIT-KEY.
008500    MOVE '00'                  TO FILE-STATUS-LOCAL FILE-STATUS.
008600*
008700    GO TO
008800******  0000-FR-CREATE
008900        0001-FR-OPEN-INPUT
009000        0002-FR-OPEN-I-O
009100        0003-FR-CLOSE
009200        0004-FR-WRITE
009300        0005-FR-REWRITE
009400        0006-FR-DELETE
009500        0007-FR-START
009600        0008-FR-GENERIC-START
009700        0009-FR-START-HIGH
009800        0010-FR-GENERIC-START-HIGH
009900        0011-FR-READ
010000        0012-FR-READ-NEXT
010100        0013-FR-READ-PREVIOUS
010200        0014-FR-READ-WITH-LOCK
010300        0015-FR-OPEN-WITH-LOCK
010400        0016-FR-UNLOCK
010500        0017-FR-START-LOW
010600        DEPENDING
010700        ON FILE-ACTION.
010800*
010900 0000-FR-CREATE.
011000    GO TO 0020-RETURN.
011100*
011200 0001-FR-OPEN-INPUT.
011300      IF OPENED-FLAG = 'Y'
011400          GO TO 0020-RETURN.
011500      OPEN INPUT SPLIT-FILE
011600        IF FILE-STATUS-LOCAL = '00' or '05'
011700           MOVE 'Y' TO OPENED-FLAG.
011800        GO TO 0020-RETURN.
011900*
012000 0002-FR-OPEN-I-O.
012100      IF OPENED-FLAG = 'Y'
012200          GO TO 0020-RETURN.
012300      OPEN I-O SPLIT-FILE
012400        IF FILE-STATUS-LOCAL = '00' or '05'
012500           MOVE 'Y' TO OPENED-FLAG.
012600        GO TO 0020-RETURN.
012700*
012800 0003-FR-CLOSE.
012900    IF OPENED-FLAG = 'Y'
013000      CLOSE SPLIT-FILE
013100      MOVE 'N' TO OPENED-FLAG.
013200    GO TO 0020-RETURN.
013300*
013400 0004-FR-WRITE.
013500    WRITE SPLIT-REC FROM CS.
013600    GO TO 0020-RETURN.
013700*
013800 0005-FR-REWRITE.
013900    REWRITE SPLIT-REC FROM CS.
014000    GO TO 0020-RETURN.
014100*
014200 0006-FR-DELETE.
014300    DELETE SPLIT-FILE RECORD.
014400    GO TO 0020-RETURN.
014500*
014600 0007-FR-START.
014700      START SPLIT-FILE KEY NOT LESS THAN SPLIT-KEY.
014800    GO TO 0020-RETURN.
014900*
015000 0008-FR-GENERIC-START.
015100    GO TO 0020-RETURN.
015200*
015300 0009-FR-START-HIGH.
015400    GO TO 0020-RETURN.
015500*
015600 0010-FR-GENERIC-START-HIGH.
015700    GO TO 0020-RETURN.
015800*
015900 0011-FR-READ.
016000    READ SPLIT-FILE INTO CS.
016100    GO TO 0020-RETURN.
016200*
016300 0012-FR-READ-NEXT.
016400      READ SPLIT-FILE
016500      NEXT RECORD INTO CS
016600    IGNORE LOCK
016700      AT END MOVE 'N' TO GENERIC-FLAG.
016800
016900    GO TO 0020-RETURN.
017000*
017100 0013-FR-READ-PREVIOUS.
017200
017300    READ SPLIT-FILE
017400    PREVIOUS RECORD INTO CS
017500    AT END MOVE 'N' TO GENERIC-FLAG.
017600
017700*   PERFORM 0019-EOF-TEST.
017800    GO TO 0020-RETURN.
017900*
018000 0014-FR-READ-WITH-LOCK.
018100    GO TO 0020-RETURN.
018200*
018300 0015-FR-OPEN-WITH-LOCK.
018400    GO TO 0020-RETURN.
018500*
018600 0016-FR-UNLOCK.
018700    GO TO 0020-RETURN.
018800*
018900 0017-FR-START-LOW.
019000    START SPLIT-FILE KEY NOT LESS THAN SPLIT-KEY.
019100    GO TO 0020-RETURN.
019200*
019300 0019-EOF-TEST.
019400    IF SPLIT-KEY = HIGH-VALUES
019500      MOVE '10' TO FILE-STATUS-LOCAL.
019600    IF FILE-STATUS-LOCAL = '10' OR '23'
019700      MOVE 'N' TO GENERIC-FLAG.
019800
019900    MOVE SPLIT-KEY TO GENERIC-TEST
020000
020100      PERFORM WITH TEST AFTER
020200      VARYING GKDEX FROM GENERIC-KEY-LENGTH BY -1
020300      UNTIL GKDEX = 1 OR GENERIC-FLAG = 'N'
020400        SET GTDEX TO GKDEX
020500        IF GENERIC-KEY-BYTE (GKDEX)
020600        NOT = GENERIC-TEST-BYTE (GTDEX)
020700    MOVE '10' TO FILE-STATUS-LOCAL
020800    MOVE 'N' TO GENERIC-FLAG
020900        END-PERFORM.
021000
021100*
021200*
021300* -====-
021400*
021500 0020-RETURN.
021600    MOVE FILE-STATUS-LOCAL TO FILE-STATUS.
021700    GOBACK.
021800*
