*******970514  1837  CHECKIN TPSIO006.CBL JJM 
*******951030  1731  CHECKIN TPSIO006.CBL JPC 
*******951025  1150  CHECKOUT TPSIO006.CBL JPC
*******950829  1738  CHECKIN TPSIO006.CBL JPC
*******950824  1321  CHECKIN TPSIO006.CBL JPC
001000******************************************************************
001010* 10/25/95 "Ignore Lock" when doing a READ NEXT.              JC *
001000******************************************************************
000100 IDENTIFICATION DIVISION.
000200 PROGRAM-ID. TPSIO006.
000210*
000220*             I/O MODULE FOR RESIDENCE DATA BASE.
000230*
000300 ENVIRONMENT DIVISION.
000400 CONFIGURATION SECTION.
000500 SOURCE-COMPUTER. IBM-PC.
000600 OBJECT-COMPUTER. IBM-PC.
000700 SPECIAL-NAMES.
000800 INPUT-OUTPUT SECTION.
000900 FILE-CONTROL.
001000     SELECT RESIDE-FILE ASSIGN TO DYNAMIC FILESPEC
001100         ORGANIZATION IS INDEXED
                   LOCK MODE IS AUTOMATIC
001200         ACCESS MODE IS DYNAMIC
001300         RECORD KEY IS RESI-CLIENT-KEY OF FS
001400*********ALTERNATE RECORD KEY IS RESI-CLIENT-KEY OF FS WITH DUPLICATES
001500*********ALTERNATE RECORD KEY IS RESI-CLIENT-KEY OF FS WITH DUPLICATES
001600*********ALTERNATE RECORD KEY IS RESI-CLIENT-KEY OF FS WITH DUPLICATES
001700         FILE STATUS IS FILE-STATUS-LOCAL.
001800 DATA DIVISION.
001900 FILE SECTION.
002000 FD  RESIDE-FILE
002100         LABEL RECORDS STANDARD.
002200 01  FS.
002300     COPY "TPSRESID.CPY".
002400 WORKING-STORAGE SECTION.
002500 01 FILESPEC PIC X(28) VALUE '\tps\prod\files\tpsresid.dat'.

002700 01  FILE-STATUS-LOCAL           PIC XX VALUE ZERO.
002800*
002900*                         :---------------------------------------
003000* ------------------------: Save next available key so we can
003100*                         : automatically assign prime keys.
003200*                         :---------------------------------------
003300 01  NEXT-KEY-RECORD.
003400     05  FILLER                  PIC X(52) VALUE HIGH-VALUE.
003500     05  NEXT-KEY-NUMBER         PIC S9(9) COMP-4 VALUE 1.
003600     05  FILLER                  PIC X(167) VALUE LOW-VALUE.
003700 01  OPENED-FLAG                 PIC X.
003800 01  GENERIC-FLAG                PIC X.
003900 01  GENERIC-KEY-LENGTH-LV       PIC S9(4) COMP-5.
004000 01  GENERIC-KEY-LENGTH          PIC S9(4) COMP-5.
004100 01  GENERIC-KEY.
004200     05  GENERIC-KEY-BYTE OCCURS 50 INDEXED BY GKDEX
004300                                 PIC X.
004400 01  GENERIC-TEST.
004500     05  GENERIC-TEST-BYTE OCCURS 50 INDEXED BY GTDEX
004600                                 PIC X.
004700*
005400 LINKAGE SECTION.
005600         COPY TPSFILES.CPY.
005700 01 LS.
005800         COPY "TPSRESID.CPY".
005900*
006000 PROCEDURE DIVISION USING FILE-REQUEST LS.
006100*
006300 0001-STARTUP.
006400*                         :---------------------------------------
006500* ------------------------: Load the keys, initialize variables.
006600*                         :---------------------------------------
006700*
006800*****MOVE RESI-CLIENT-KEY TO RESI-CLIENT-KEY OF FS-NUMERIC.
006900*****MOVE RESI-CLIENT-KEY1 TO RESI-CLIENT-KEY OF FS1.
007000*****MOVE RESI-CLIENT-KEY2 TO RESI-CLIENT-KEY OF FS2.
007100*****MOVE RESI-CLIENT-KEY3 TO RESI-CLIENT-KEY OF FS3.
007200******READ THE VALUE OF ENVIRONMENT NAME "TPSRESIDENCEFILE"
007300     IF FILESPEC = SPACES
007400      DISPLAY "TPSRESIDENCEFILE" UPON ENVIRONMENT-NAME
007500      ACCEPT FILESPEC FROM ENVIRONMENT-VALUE.
007600     MOVE '00' TO FILE-STATUS-LOCAL FILE-STATUS.
007700*
008200     GO TO
008300         0003-FR-OPEN-INPUT
008400         0004-FR-OPEN-I-O
008500         0005-FR-CLOSE
008600         0006-FR-WRITE
008700         0007-FR-REWRITE
008800         0008-FR-DELETE
008900         0009-FR-START
009000         0009-FR-START
009100         0010-FR-START-HIGH
009200         0010-FR-START-HIGH
009300         0011-FR-READ
009400         0012-FR-READ-NEXT
009500         0013-FR-READ-PREVIOUS
009600         DEPENDING
009700         ON FILE-ACTION.
009800*
009900 0002-FR-CREATE.
010600     IF FR-CREATE
010700*******PERFORM 0016-BUILD-FILESPEC
010800       OPEN OUTPUT RESIDE-FILE
010900       IF FILE-STATUS-LOCAL = '00'
012600             OR '41'
012700         WRITE FS FROM
012800             NEXT-KEY-RECORD
012900             INVALID KEY
013000           CONTINUE
013100         END-WRITE
013200         IF FILE-STATUS-LOCAL = '00'
013300           CLOSE RESIDE-FILE
013400           IF FILE-STATUS-LOCAL = '00'
013500             OPEN I-O RESIDE-FILE
013600             IF FILE-STATUS-LOCAL = '00'
013700               MOVE 'Y' TO OPENED-FLAG
013800             END-IF
013900           END-IF
014000         END-IF
014100       END-IF
014200     ELSE
014300       MOVE 'ZZ' TO FILE-STATUS-LOCAL.
014400*
014500     GO TO 0017-RETURN.
014600*
014700 0003-FR-OPEN-INPUT.
015200     IF OPENED-FLAG NOT = 'Y'
015400       OPEN INPUT RESIDE-FILE
015500       MOVE 'Y' TO OPENED-FLAG.
015700     GO TO 0017-RETURN.
015800*
015900 0004-FR-OPEN-I-O.
016400     IF OPENED-FLAG NOT = 'Y'
016600        OPEN I-O RESIDE-FILE.
017700     GO TO 0017-RETURN.
017800*
017900 0005-FR-CLOSE.
018400     IF OPENED-FLAG = 'Y'
018500       CLOSE RESIDE-FILE
018600       MOVE 'N' TO OPENED-FLAG.
018800     GO TO 0017-RETURN.
018900*
019000 0006-FR-WRITE.
019600     WRITE FS FROM LS.
020200     GO TO 0017-RETURN.
020300*
020400 0007-FR-REWRITE.
020900     REWRITE FS FROM LS.
021100     GO TO 0017-RETURN.
021200*
021300 0008-FR-DELETE.
021800     DELETE RESIDE-FILE RECORD.
022000     GO TO 0017-RETURN.
022100*
022200 0009-FR-START.
023200     IF FR-PRIME
023300       MOVE RESI-CLIENT-KEY OF LS TO RESI-CLIENT-KEY OF FS
023400       MOVE RESI-CLIENT-KEY OF FS TO GENERIC-KEY
023500       START RESIDE-FILE KEY NOT LESS THAN RESI-CLIENT-KEY OF FS
023600           INVALID KEY
023700         CONTINUE.
023800*
023900*****IF FR-AIX1
024000*****  MOVE RESI-CLIENT-KEY OF FS1 TO GENERIC-KEY
024100*****  START RESIDE-FILE KEY NOT LESS THAN RESI-CLIENT-KEY OF FS1
024200*****      INVALID KEY
024300         CONTINUE.
024400*
024500*****IF FR-AIX2
024600*****  MOVE RESI-CLIENT-KEY OF FS2 TO GENERIC-KEY
024700*****  START RESIDE-FILE KEY NOT LESS THAN RESI-CLIENT-KEY OF FS2
024800*****      INVALID KEY
024900*****    CONTINUE.
025000*
025100*****IF FR-AIX3
025200*****  MOVE RESI-CLIENT-KEY OF FS3 TO GENERIC-KEY
025300*****  START RESIDE-FILE KEY NOT LESS THAN RESI-CLIENT-KEY OF FS3
025400*****      INVALID KEY
025500*****    CONTINUE.
025600*
025700     IF FR-GENERIC-START
025800       PERFORM 0014-SAVE-GENERIC-KEY.
025900*
026000     GO TO 0017-RETURN.
026100* -====-
026200 0010-FR-START-HIGH.
027200     IF FR-PRIME
027300       MOVE RESI-CLIENT-KEY OF FS TO GENERIC-KEY
027400**JM   MOVE HIGH-VALUE TO RESI-CLIENT-KEY OF FS
027500       START RESIDE-FILE KEY EQUAL RESI-CLIENT-KEY OF FS
027600           INVALID KEY
027700         CONTINUE.
027800*
027900*****IF FR-AIX1
028000*****  MOVE RESI-CLIENT-KEY OF FS1 TO GENERIC-KEY
028100*****  MOVE HIGH-VALUE TO RESI-CLIENT-KEY OF FS1
028200*****  START RESIDE-FILE KEY EQUAL RESI-CLIENT-KEY OF FS1
028300*****      INVALID KEY
028400*****    CONTINUE.
028500*
028600*****IF FR-AIX2
028700*****  MOVE RESI-CLIENT-KEY OF FS2 TO GENERIC-KEY
028800*****  MOVE HIGH-VALUE TO RESI-CLIENT-KEY OF FS2
028900*****  START RESIDE-FILE KEY EQUAL RESI-CLIENT-KEY OF FS2
029000*****      INVALID KEY
029100*****    CONTINUE.
029200*
029300*****IF FR-AIX3
029400*****  MOVE RESI-CLIENT-KEY OF FS3 TO GENERIC-KEY
029500*****  MOVE HIGH-VALUE TO RESI-CLIENT-KEY OF FS3
029600*****  START RESIDE-FILE KEY EQUAL RESI-CLIENT-KEY OF FS3
029700*****      INVALID KEY
029800         CONTINUE.
029900*
030000     IF FR-GENERIC-START
030100       PERFORM 0014-SAVE-GENERIC-KEY.
030200* -====-
030300 0011-FR-READ.
031300     MOVE RESI-CLIENT-KEY OF LS TO RESI-CLIENT-KEY OF FS.
031400     READ RESIDE-FILE INTO LS
031500         KEY IS RESI-CLIENT-KEY OF FS
031600         INVALID KEY
031700       MOVE LOW-VALUES TO LS.
031900     GO TO 0017-RETURN.
032000*
032100 0012-FR-READ-NEXT.
033100     READ RESIDE-FILE
033200     NEXT RECORD INTO LS
          IGNORE LOCK
033300     AT END
033400       MOVE 'N' TO GENERIC-FLAG.
033500*
033600     PERFORM 0015-EOF-TEST.
033700*
033800     GO TO 0017-RETURN.
033900*
034000 0013-FR-READ-PREVIOUS.
034500     READ RESIDE-FILE
034600         PREVIOUS RECORD INTO LS
034700     AT END
034800       MOVE 'N' TO GENERIC-FLAG.
034900*
035000     PERFORM 0015-EOF-TEST.
035200     GO TO 0017-RETURN.
035300*
035400 0014-SAVE-GENERIC-KEY.
036500     MOVE 0 TO GENERIC-KEY-LENGTH GENERIC-KEY-LENGTH-LV.
036600*
036700     INSPECT GENERIC-KEY
036800         TALLYING GENERIC-KEY-LENGTH-LV
036900         FOR CHARACTERS BEFORE INITIAL LOW-VALUE.
037000*
037100     INSPECT GENERIC-KEY
037200         TALLYING GENERIC-KEY-LENGTH
037300         FOR CHARACTERS BEFORE INITIAL SPACE.
037400*
037500     IF GENERIC-KEY-LENGTH > GENERIC-KEY-LENGTH-LV
037600       MOVE GENERIC-KEY-LENGTH-LV TO GENERIC-KEY-LENGTH.
037700*
037800     IF GENERIC-KEY-LENGTH > 0
037900       MOVE 'Y' TO GENERIC-FLAG
038000     ELSE
038100       MOVE 'N' TO GENERIC-FLAG.
038200* -====-
038300 0015-EOF-TEST.
039600     IF RESI-CLIENT-KEY OF FS = HIGH-VALUES
039700       MOVE '10' TO FILE-STATUS-LOCAL.
039800*
039900     IF FILE-STATUS-LOCAL = '10' OR '23'
040000       MOVE 'N' TO GENERIC-FLAG.
040100*
040200     IF GENERIC-FLAG = 'Y'
040300       IF FR-PRIME
040400         MOVE RESI-CLIENT-KEY OF FS TO GENERIC-TEST
040500*******ELSE
040600*********IF FR-AIX1
040700*********  MOVE RESI-CLIENT-KEY OF FS1 TO GENERIC-TEST
040800*********ELSE
040900*********  IF FR-AIX2
041000*********    MOVE RESI-CLIENT-KEY OF FS2 TO GENERIC-TEST
041100*********  ELSE
041200*********    IF FR-AIX3
041300*********      MOVE RESI-CLIENT-KEY OF FS3 TO GENERIC-TEST
041400*********    END-IF
041500*********  END-IF
041600*********END-IF
041700       END-IF
041800       PERFORM WITH TEST AFTER
041900             VARYING GKDEX FROM GENERIC-KEY-LENGTH BY -1
042000             UNTIL GKDEX = 1 OR GENERIC-FLAG = 'N'
042100         SET GTDEX TO GKDEX
042200         IF GENERIC-KEY-BYTE (GKDEX)
042300               NOT = GENERIC-TEST-BYTE (GTDEX)
042400           MOVE '10' TO FILE-STATUS-LOCAL
042500           MOVE 'N' TO GENERIC-FLAG
042600         END-PERFORM.
042700* -====-
042800 0017-RETURN.
042900     MOVE FILE-STATUS-LOCAL TO FILE-STATUS.
043000     GOBACK.
