       IDENTIFICATION DIVISION.
       PROGRAM-ID. TPSEVENT.
       AUTHOR. JOHN CURRAN.
      *****************************************************************
      * READ CALENDAR RECORDS AND SET UP FOR PRINTING                 *
      *****************************************************************
      * 10/29/07  MOVE AROUND FILEDS FOR BETTER PRINTING FORMAT.   JM *
      * 09/14/95  MOVE CAL-APPT-ATTEND-OPTION TO TPS-EVENT-NAME(99:1) *
      *    JM     TO DECIDE TO PRINT ON-HOLD LIST.                    *
      * 10/06/97  REARRANGE FIELDS TO PRINT ON LESS LINES        JM   *
      *****************************************************************
       ENVIRONMENT DIVISION.
       CONFIGURATION SECTION.
       SOURCE-COMPUTER. IBM-PS2.
       OBJECT-COMPUTER. IBM-PS2.
       FILE-CONTROL.
       DATA DIVISION.
       FILE SECTION.
       WORKING-STORAGE SECTION.
             COPY TPSFILES.
       01    CALENDAR-REC.
             COPY TPSCALEN.CPY.
       01    EDIT-COST               PIC 9(6)V99.
       01    EDIT-COST-X REDEFINES EDIT-COST PIC X(8).
       01    EVENT-W                 PIC X(10) VALUE 'Event:'.
       01    DATE-W                  PIC X(10) VALUE 'Date:'.
       01    TIME-W                  PIC X(10) VALUE 'Time:'.
       01    SURPRISE-W              PIC X(11) VALUE 'Surprise?: '.
       01    SURPRISE-W2             PIC X(11) VALUE 'Surprise:  '.
       01    GIVEN-BY-W              PIC X(10) VALUE 'Given by:'.
       01    HONORING-W              PIC X(10) VALUE 'Honoring:'.
       01    RSVP-W                  PIC X(10) VALUE 'RSVP:'.
       01    CONTACT-W               PIC X(10) VALUE 'Contact:'.
       01    COST-W                  PIC X(10) VALUE 'Cost:'.
       01    DRESS-W                 PIC X(07) VALUE 'Dress: '.
       01    LOCATION-W              PIC X(10) VALUE 'Location:'.
       01  PROGRAM-NAMES.
        10 TPSIO018    PIC X(08) VALUE 'TPSIO018'.
        10 FILLER      PIC X(08) VALUE HIGH-VALUES.
       LINKAGE SECTION.
       01 TPS-PROFILE.
           COPY "TPSPROFL.CPY".
       01  MAIL-RECEIVE-CALENDAR-XREF  PIC 9(12).
       01 LS-EVENT-TABLE.
           COPY "TPSEVENT.CPY".

       PROCEDURE DIVISION USING TPS-PROFILE
                                MAIL-RECEIVE-CALENDAR-XREF
                                LS-EVENT-TABLE.
       READ-THE-CALENDAR.
          MOVE LOW-VALUES TO CALENDAR-REC.
          MOVE CLNT-PROFILE-ACCT-NO
            TO CAL-KEY-ACCT-NO.
          MOVE CLNT-PROFILE-SUB-ACCT
            TO CAL-KEY-SUB-ACCT.
**********MOVE MAIL-CALENDAR-XREF OF LS-MAIL-REC
**********  TO MAIL-RECEIVE-CALENDAR-XREF.
          MOVE MAIL-RECEIVE-CALENDAR-XREF(1:8)
            TO CAL-KEY-DATE.
          MOVE MAIL-RECEIVE-CALENDAR-XREF(9:4)
            TO CAL-KEY-RECORD-NUMBER.
          MOVE F-PRIME TO FILE-KEY.
          MOVE F-START TO FILE-ACTION.
          CALL TPSIO018 USING FILE-REQUEST CALENDAR-REC.
          IF NOT A-SUCCESSFUL-OPERATION GO TO READ-THE-CALENDAR-EXIT
          END-IF.
          MOVE F-READ-NEXT TO FILE-ACTION.
       CALENDAR-LOOP.
          CALL TPSIO018 USING FILE-REQUEST CALENDAR-REC.
          IF NOT A-SUCCESSFUL-OPERATION
             OR
             CLNT-PROFILE-ACCT-NO IS NOT EQUAL TO CAL-KEY-ACCT-NO
             OR
             CLNT-PROFILE-SUB-ACCT IS NOT EQUAL TO CAL-KEY-SUB-ACCT
             OR
             MAIL-RECEIVE-CALENDAR-XREF(1:8) IS NOT EQUAL TO
               CAL-KEY-DATE (1:8)
             OR
             MAIL-RECEIVE-CALENDAR-XREF(9:4) IS NOT EQUAL TO
               CAL-KEY-RECORD-NUMBER (1:4)
               GO TO READ-THE-CALENDAR-EXIT
          END-IF.
      ***** DO NOT PROCESS DELETED RECORDS **************
          IF CAL-APPT-ADD-DATE(1:1) = 8 OR 9
             GO TO CALENDAR-LOOP.
      ***** DO NOT PROCESS WHEN RESPONSE TO ATTEND WAS ANSWERED *****
          IF CAL-APPT-APPOINT-DATA(1:7)   = 'Event: '
             MOVE CAL-APPT-APPOINT-DATA TO TPS-EVENT-NAME
             MOVE CAL-APPT-ATTEND-OPTION TO TPS-EVENT-NAME(99:1)
          ELSE
          IF CAL-APPT-APPOINT-DATA(1:6)   = 'Date: '
             MOVE CAL-APPT-APPOINT-DATA TO EVENT-DATE-W
             MOVE CAL-APPT-APPOINT-DATA(07:08) TO EVENT-DATE-START
             IF CAL-APPT-APPOINT-DATA(18:02) > '00'
                MOVE ' - ' TO EVENT-DATE-DASH
                MOVE CAL-APPT-APPOINT-DATA(18:08) TO EVENT-DATE-END
             END-IF
             IF   CAL-APPT-APPOINT-DATA(33:02) > '00'
              MOVE CAL-APPT-APPOINT-DATA(27:06) TO EVENT-TIME-W
              MOVE CAL-APPT-APPOINT-DATA(33:02) TO EVENT-TIME-START-H
              MOVE ':'                    TO EVENT-TIME-START-COLON
              MOVE CAL-APPT-APPOINT-DATA(35:02) TO EVENT-TIME-START-M
              MOVE CAL-APPT-APPOINT-DATA(38:02) TO EVENT-TIME-START-AM
             END-IF
             IF CAL-APPT-APPOINT-DATA(43:02) > '00'
                MOVE '-' TO EVENT-TIME-START-DASH
                MOVE CAL-APPT-APPOINT-DATA(43:02) TO EVENT-TIME-END-H
                MOVE ':'                  TO EVENT-TIME-END-COLON
                MOVE CAL-APPT-APPOINT-DATA(45:02) TO EVENT-TIME-END-M
                MOVE CAL-APPT-APPOINT-DATA(48:02) TO EVENT-TIME-END-AM
             END-IF
          ELSE
          IF CAL-APPT-APPOINT-DATA(1:10)  = 'Given by: '
             MOVE CAL-APPT-APPOINT-DATA TO TPS-EVENT-GIVEN-BY
          ELSE
          IF CAL-APPT-APPOINT-DATA(1:10)  = 'Honoring: '
             MOVE CAL-APPT-APPOINT-DATA TO TPS-EVENT-HONORING
          ELSE
          IF CAL-APPT-APPOINT-DATA(1:06)  = 'RSVP: '
             OR
             CAL-APPT-APPOINT-DATA(16:09) = 'Contact: '
             PERFORM EDIT-RSVP-LINE THRU EDIT-RSVP-LINE-EXIT
          ELSE
          IF CAL-APPT-APPOINT-DATA(1:06)  = 'Cost: '
             OR
             CAL-APPT-APPOINT-DATA(17:10) = 'Surprise: '
             OR
             CAL-APPT-APPOINT-DATA(30:07) = 'Dress: '
             PERFORM EDIT-COST-LINE THRU EDIT-COST-LINE-EXIT
          ELSE
          IF CAL-APPT-APPOINT-DATA(01:10) = 'Location: '
             MOVE CAL-APPT-APPOINT-DATA TO TPS-EVENT-LOCATION
          ELSE
          IF TPS-EVENT-MEMO-LINE-1 IS NOT GREATER THAN SPACES
             MOVE CAL-APPT-APPOINT-DATA TO TPS-EVENT-MEMO-LINE-1
          ELSE
          IF TPS-EVENT-MEMO-LINE-2 IS NOT GREATER THAN SPACES
             MOVE CAL-APPT-APPOINT-DATA TO TPS-EVENT-MEMO-LINE-2
          ELSE
          IF TPS-EVENT-MEMO-LINE-3 IS NOT GREATER THAN SPACES
             MOVE CAL-APPT-APPOINT-DATA TO TPS-EVENT-MEMO-LINE-3.
          GO TO CALENDAR-LOOP.
       READ-THE-CALENDAR-EXIT.
      *10/29/07 *** MOVE FIELDS FOR BETTER PRINT FORMAT
          IF TPS-EVENT-GIVEN-BY = LOW-VALUES AND
                        TPS-EVENT-HONORING > LOW-VALUES
             MOVE TPS-EVENT-HONORING    TO TPS-EVENT-GIVEN-BY
             MOVE LOW-VALUES            TO TPS-EVENT-HONORING
             IF TPS-EVENT-DRESS > LOW-VALUES
                MOVE EVENT-DRESS-W(1:35) TO TPS-EVENT-HONORING
                MOVE LOW-VALUES          TO TPS-EVENT-DRESS.
          IF EVENT-RSVP = LOW-VALUES
             MOVE EVENT-CONTACT-W(1:35)  TO EVENT-RSVP-W(1:35)
             MOVE LOW-VALUES             TO EVENT-CONTACT(5:21).

        GOBACK.

       EDIT-COST-LINE.
              IF CAL-APPT-APPOINT-DATA(1:06)  = 'Cost: '
                 AND
                 CAL-APPT-APPOINT-DATA(8:08)  > '00000000'
                 MOVE CAL-APPT-APPOINT-DATA(1:06)  TO EVENT-COST-W
                 MOVE CAL-APPT-APPOINT-DATA(8:08)  TO EDIT-COST-X
                 MOVE EDIT-COST                    TO EVENT-COST
              END-IF.
              IF CAL-APPT-APPOINT-DATA(17:10) = 'Surprise: '
                 AND
                 CAL-APPT-APPOINT-DATA(28:01) > SPACE
                 MOVE CAL-APPT-APPOINT-DATA(17:10)   TO EVENT-SURPRISE-W
                 MOVE CAL-APPT-APPOINT-DATA(28:01)   TO EVENT-SURPRISE
              END-IF.
              IF CAL-APPT-APPOINT-DATA(30:07) = 'Dress: '
                 AND
                 CAL-APPT-APPOINT-DATA(37:10) > SPACES
                 MOVE CAL-APPT-APPOINT-DATA(30:07) TO EVENT-DRESS-W
                 MOVE CAL-APPT-APPOINT-DATA(37:10) TO EVENT-DRESS
              END-IF.
       EDIT-COST-LINE-EXIT. EXIT.

       EDIT-RSVP-LINE.
          IF CAL-APPT-APPOINT-DATA(1:06)  = 'RSVP: '
             AND
             CAL-APPT-APPOINT-DATA(07:02) > '00'
             MOVE CAL-APPT-APPOINT-DATA TO EVENT-RSVP-W
             MOVE CAL-APPT-APPOINT-DATA(07:08) TO EVENT-RSVP
          END-IF.
          IF CAL-APPT-APPOINT-DATA(16:09) = 'Contact: '
             AND
             CAL-APPT-APPOINT-DATA(25:26) > SPACES
             MOVE CAL-APPT-APPOINT-DATA(16:09) TO EVENT-CONTACT-W
             MOVE CAL-APPT-APPOINT-DATA(25:26) TO EVENT-CONTACT
          END-IF.
       EDIT-RSVP-LINE-EXIT. EXIT.
