000100 IDENTIFICATION DIVISION.
000200 PROGRAM-ID. TPSDATES.
000400************************************************************** 
000300*                  MAINTENANCE LOG                           *
000300* 02/07/08  -certain routines in prog were checking the yy   * 
000300*    TS      field for < 14 to insert a value of 20 when ex- *
000300*            panding the format to include century. all      *
000300*            checks now looking for < 94 to insert '20'...   *
000300* 05/26/00  -FIXED IF STATEMENT ADDED IN JAN/00 CHECKING FOR * 
000300*    TS      ZERO DATE, PROGRAM WILL ENSURE 8 BYTES OF ZEROS.*
000300* 07/16/98  -ADDED OPTION 26 & 27 TO CALCULATE NEXT & PREV   *
000300*    TS      BUSINESS DAY + DAY OF WEEK..........            *
000300* 02/18/98  -ADDED OPTION 25, CALCULATE(AGE) # DAYS BETWEEN  *
000300*    TS      TO DATES. DATE1 CAN BE HIGHER/LOWER THAN DATE2, *
000300*            RESULT WILL BE INCLUSIVE....                    *
000400**************************************************************
000500*                                                            *
000600*      THIS MODULE WILL ;                                    *
000700*                                                            *
000800* 1 - REFORMAT DATES BY PARAMETER..                          *
000900*     DATA PASSED WILL BE 9(02) PARM REQUEST AND             *
001000*     X(20) INPUT DATE FIELD. RETURN PARM WILL REPLACE       *
001100*     REQUEST PARM AND REFORMAT WILL REPLACE ORIGINAL DATE.  *
001200*                                                            *
001300*   PARM    INPUT FORMAT      OUTPUT FORMAT                  *
001400*   ----    ------------      -------------                  *
001500*    01       YYMMDD            CCYYMMDD                     *
001600*    02       YYMMDD            MMDDCCYY                     *
001700*    03       YYMMDD            MM/DD/YY                     *
001800*    04       YYMMDD            MM/DD/CCYY                   *
001900*    05       YYMMDD            MMDDYY                       *
002000*    06       YYMMDD            MONTH DD, 19XX               *
002100*    07       YYMMDD            MON ZZ, 19XX                 *
002200*    08       YYMMDD            MONTH, 19XX                  *
002300*    09       YYMMDD            MONTH DD                     *
002400*                                                            *
002500*    11       MMDDYY            CCYYMMDD                     *
002600*    12       MMDDYY            YYMMDD                       *
002700*    13       MMDDYY            MM/DD/YY                     *
002800*    14       MMDDYY            MM/DD/CCYY                   *
002900*                                                            *
003000*    21       CCYYMMDDXXX       CCYYMMDD   ADD XXX TO DATE   *
003100*    22       CCYYMMDDXXX       CCYYMMDD   SUB XXX FROM DATE *
003200*    23       CCYYMMDD          CCYYMMDDX  X = DAY OF WEEK   *
003300*                                          0=SUN,1=MON,etc.  *
003400*    24       CCYYMMXX          CCYYMMDD   DD= LAST DAY OF MO*
003400*    25       CCYYMMDDCCYYMMDD  DDDD       DDDD = # DAYS BET-*
003500*                                          WEEN DATE1 & DATE2*
004100*             OPT '25' DDDD WILL BE INCLUSIVE (DIFFERENCE    *
004100*             BETWEEN DATE-1 & DATE-2 WILL BE '+1'...        *
003100*    26       CCYYMMDD          CCYYMMDDX  NEXT BUSINESS DATE*
004100*                                          X = DAY OF WEEK   *
003100*    27       CCYYMMDD          CCYYMMDDX  PREV BUSINESS DATE*
004100*                                          X = DAY OF WEEK   *
003100*    28       CCYYMMDD          CCYYMMDDX  NEXT BUSINESS DATE*
004100*                                          X = DAY OF WEEK   *
004100*                                          SKIP WED & FRI    *
003100*    29       CCYYMMDD          CCYYMMDDX  PREV BUSINESS DATE*
004100*                                          X = DAY OF WEEK   *
004100*                                          SKIP WED & FRI    *
004100*                                                            *
003600* 2 - TIME CALCULATIONS..                                    *
003700*     DATA PASSED WILL BE 9(02) TIME REQUEST AND             *
003800*     X(20) INPUT DATE FIELD. RESULT WILL BE PLACED IN THE   *
003900*     PARM1 FIELD OF THE INITIAL PARAMETER. THE 'PARM1'      *
004000*     FIELD WILL BE ADJUSTED BY THE PARM2 FIELD VALUE.       *
004100*                                                            *
004200*   PARM     INPUT FORMAT        OUTPUT FORMAT    REQUEST    *
004300*           PARM1     PARM2     PARM1     PARM2              *
004400*   ----  -----------------    -----------------  --------   *
004500*    91     HHMMSS   HHMMSS      HHMMSS           SUBTRACT   *
004600*    92     HHMMSS   HHMMSS      HHMMSS           ADD        *
004700*    93   HHHHMMSS HHHHMMSS    HHHHMMSS           SUBTRACT   *
004800*    94   HHHHMMSS HHHHMMSS    HHHHMMSS           ADD        *
004900*                                                            *
005000*    98   HHHHMMSS             SSSSSSSS           CONVERT    *
005100*    99   SSSSSSSS             HHHHMMSS           CONVERT    *
005200*                                                            *
005300*    RETURN TO CALLING PROGRAM, PARM WILL = 00 IF FUNCTION   *
005400*    COMPLETED, PARM WILL = 99 IN REQUEST INVALID.....       *
005500**************************************************************
005600*
005700 ENVIRONMENT DIVISION.
005800*
005900 CONFIGURATION SECTION.
006000 SOURCE-COMPUTER. IBM-PC.
006100 OBJECT-COMPUTER. IBM-PC.
006200*
006300 DATA DIVISION.
006400*
006500 WORKING-STORAGE SECTION.
283391 01  TPSIO018                      PIC  X(08) VALUE 'TPSIO018'.
283391 01  TPSIOERR                      PIC  X(08) VALUE 'TPSIOERR'.
002330                                                                                     
002360                                                                                     
002370 01 TPS-PROFILE.                                                                     
002380     COPY "TPSPROFL.CPY".                                                            
013590                                                                                     
013600     COPY "TPSFILES.CPY".                                                            
013680                                                                                     
014000                                                                                     
014010 01  TPS-FILE-STATUS                       PIC XX.                                   
014020     88  TPS-CARRIER-FILE-OK VALUE '00', '02'.                                       
006400
283391 01  TPS-CALEN-REC.
283391     COPY TPSCALEN.CPY.
006400
006400
011800 01 HOLIDAY-TABLE                  PIC  X(800) VALUE HIGH-VALUES.
011900 01 HOLIDAY-REDEF REDEFINES HOLIDAY-TABLE.
012000    05 HOLIDAY-REDEF OCCURS 100 TIMES.
012100       10 HOLIDAY-DATE             PIC  X(08).
012200
012200 01 HOL-IDX                        PIC  9(04) COMP.
012200
006600 01  MONTH-NAME-TABLE.                                            
006700     10 FILLER PIC X(10) VALUE 'January  7'.                      
006800     10 FILLER PIC X(10) VALUE 'February 8'.                      
006900     10 FILLER PIC X(10) VALUE 'March    5'.                      
007000     10 FILLER PIC X(10) VALUE 'April    5'.                      
007100     10 FILLER PIC X(10) VALUE 'May      3'.                      
007200     10 FILLER PIC X(10) VALUE 'June     4'.                      
007300     10 FILLER PIC X(10) VALUE 'July     4'.                      
007400     10 FILLER PIC X(10) VALUE 'August   7'.                      
007500     10 FILLER PIC X(10) VALUE 'September9'.                      
007600     10 FILLER PIC X(10) VALUE 'October  7'.                      
007700     10 FILLER PIC X(10) VALUE 'November 8'.                      
007800     10 FILLER PIC X(10) VALUE 'December 8'.                      
007900 01 MONTH-NAME-TABLE-R REDEFINES                                  
008000    MONTH-NAME-TABLE.                                             
008100     10 MONTH-ROW               OCCURS 12 TIMES.                  
008200     20 NAME-OF-MONTH PIC X(09).                                  
008300     20 NAME-LENGTH   PIC 9(01).                                  
008400 01  WS-DATE.                                                     
008500     10 WS-YEAR              PIC 99.                              
008600     10 WS-MONTH             PIC 99.                              
008700     10 WS-DAY               PIC 99.                              
008800     10 FILLER               PIC X(14).
008900*
009100 01  TODAYS-DATE-CYMD              PIC  9(08) VALUE ZEROS.
009100 01  FILLER REDEFINES TODAYS-DATE-CYMD.
009100     05  FILLER                    PIC  9(02).
009100     05  TODAYS-DATE-YMD           PIC  9(06).
009000*
009100 01  WS-OPT01-DATE.
009200     05  WS-OPT01-CC               PIC  9(02).
009300     05  WS-OPT01-YY               PIC  9(02).
009400     05  WS-OPT01-MM               PIC  9(02).
009500     05  WS-OPT01-DD               PIC  9(02).
009600     05  FILLER                    PIC  X(12) VALUE SPACES.
009700*
009800*
009900  01  WS-OPT02-DATE.
010000      05  WS-OPT02-MM               PIC  9(02).
010100      05  WS-OPT02-DD               PIC  9(02).
010200      05  WS-OPT02-CC               PIC  9(02).
010300      05  WS-OPT02-YY               PIC  9(02).
010400      05  FILLER                    PIC  X(12) VALUE SPACES.
010500*
010600*
010700  01  WS-OPT03-DATE.
010800      05  WS-OPT03-MM               PIC  9(02).
010900      05  FILLER                    PIC  X(01) VALUE '/'.
011000      05  WS-OPT03-DD               PIC  9(02).
011100      05  FILLER                    PIC  X(01) VALUE '/'.
011200      05  WS-OPT03-YY               PIC  9(02).
011300      05  FILLER                    PIC  X(12) VALUE SPACES.
011400*
011500*
011600  01  WS-OPT04-DATE.
011700      05  WS-OPT04-MM               PIC  9(02).
011800      05  FILLER                    PIC  X(01) VALUE '/'.
011900      05  WS-OPT04-DD               PIC  9(02).
012000      05  FILLER                    PIC  X(01) VALUE '/'.
012100      05  WS-OPT04-CC               PIC  9(02).
012200      05  WS-OPT04-YY               PIC  9(02).
012300      05  FILLER                    PIC  X(10) VALUE SPACES.
012400*
012500*
012600  01  WS-OPT05-DATE.
012700      05  WS-OPT05-MM               PIC  9(02).
012800      05  WS-OPT05-DD               PIC  9(02).
012900      05  WS-OPT05-YY               PIC  9(02).
013000      05  FILLER                    PIC  X(14) VALUE SPACES.
013100*
013200*
013300  01  WS-OPT11-DATE.
013400      05  WS-OPT11-CC               PIC  9(02).
013500      05  WS-OPT11-YY               PIC  9(02).
013600      05  WS-OPT11-MM               PIC  9(02).
013700      05  WS-OPT11-DD               PIC  9(02).
013800      05  FILLER                    PIC  X(12) VALUE SPACES.
013900*
014000*
014100  01  WS-OPT12-DATE.
014200      05  WS-OPT12-YY               PIC  9(02).
014300      05  WS-OPT12-MM               PIC  9(02).
014400      05  WS-OPT12-DD               PIC  9(02).
014500      05  FILLER                    PIC  X(14) VALUE SPACES.
014600*
014700*
014800  01  WS-OPT13-DATE.
014900      05  WS-OPT13-MM               PIC  9(02).
015000      05  FILLER                    PIC  X(01) VALUE '/'.
015100      05  WS-OPT13-DD               PIC  9(02).
015200      05  FILLER                    PIC  X(01) VALUE '/'.
015300      05  WS-OPT13-YY               PIC  9(02).
015400      05  FILLER                    PIC  X(12) VALUE SPACES.
015500*
015600*
015700  01  WS-OPT14-DATE.
015800      05  WS-OPT14-MM               PIC  9(02).
015900      05  FILLER                    PIC  X(01) VALUE '/'.
016000      05  WS-OPT14-DD               PIC  9(02).
016100      05  FILLER                    PIC  X(01) VALUE '/'.
016200      05  WS-OPT14-CC               PIC  9(02).
016300      05  WS-OPT14-YY               PIC  9(02).
016400      05  FILLER                    PIC  X(10) VALUE SPACES.
016500*
016600*
016700  01  WS-OPT21-DATE.
016800      05  WS-OPT21-CCYYMMDD         PIC  9(08).
016900      05  FILLER REDEFINES WS-OPT21-CCYYMMDD.
017000          10  WS-OPT21-CC           PIC  9(02).
017100          10  WS-OPT21-YY           PIC  9(02).
017200          10  WS-OPT21-MM           PIC  9(02).
017300          10  WS-OPT21-DD           PIC  9(02).
017400      05  WS-OPT21-ADD-FACTOR       PIC  9(03).
017500      05  FILLER                    PIC  X(09) VALUE SPACES.
017600*
017700  01  WS-OPT22-DATE.
017800      05  WS-OPT22-CCYYMMDD         PIC  9(08).
017900      05  FILLER REDEFINES WS-OPT22-CCYYMMDD.
018000          10  WS-OPT22-CC           PIC  9(02).
018100          10  WS-OPT22-YY           PIC  9(02).
018200          10  WS-OPT22-MM           PIC  9(02).
018300          10  WS-OPT22-DD           PIC  9(02).
018400      05  WS-OPT22-SUB-FACTOR       PIC  9(03).
018500      05  FILLER                    PIC  X(09) VALUE SPACES.
018600*
018700  01  WS-OPT23-DATE.
018800      05  WS-OPT23-CCYYMMDD         PIC  9(08).
018900      05  FILLER REDEFINES WS-OPT23-CCYYMMDD.
019000          10  WS-OPT23-CC           PIC  9(02).
019100          10  WS-OPT23-YY           PIC  9(02).
019200          10  WS-OPT23-MM           PIC  9(02).
019300          10  WS-OPT23-DD           PIC  9(02).
019400      05  WS-OPT23-DAY-OF-WEEK      PIC  9(01).
019500      05  FILLER                    PIC  X(11) VALUE SPACES.
019600*
019700  01  WS-OPT24-DATE.
019800      05  WS-OPT24-CCYYMMDD         PIC  9(08).
019900      05  FILLER REDEFINES WS-OPT24-CCYYMMDD.
020000          10  WS-OPT24-CC           PIC  9(02).
020100          10  WS-OPT24-YY           PIC  9(02).
020200          10  WS-OPT24-MM           PIC  9(02).
020300          10  WS-OPT24-DD           PIC  9(02).
020400      05  FILLER                    PIC  X(12) VALUE SPACES.
019600*
019700  01  WS-OPT25-DATE.
019800      05  WS-OPT25-DATE1-CCYYMMDD   PIC  9(08).
019800      05  WS-OPT25-DATE2-CCYYMMDD   PIC  9(08).
019800      05  WS-OPT25-DDDD             PIC  9(04).
018600*
018600*DICK
018700  01  WS-OPT26-DATE.
018800      05  WS-OPT26-CCYYMMDD         PIC  9(08).
018900      05  FILLER REDEFINES WS-OPT26-CCYYMMDD.
019000          10  WS-OPT26-CC           PIC  9(02).
019100          10  WS-OPT26-YY           PIC  9(02).
019200          10  WS-OPT26-MM           PIC  9(02).
019300          10  WS-OPT26-DD           PIC  9(02).
018900      05  FILLER REDEFINES WS-OPT26-CCYYMMDD.
021000          10 FILLER              PIC  9(04).
021100          10 WS-OPT26-MO-DAY     PIC  9999.
021200             88 ITS-A-HOLIDAY    VALUES 0101 0704 1225.
021300             88 ITS-NEW-YEARS-DAY
021400                                 VALUES 0102 0103.
021500             88 ITS-MARTIN-LUTHER-KING-DAY
021600                                 VALUES 0115 THRU 0121.
021700             88 ITS-PRESIDENTS-DAY
021710                                 VALUES 0215 THRU 0221.
021720             88 ITS-MEMORIAL-DAY
021730                                 VALUES 0525 THRU 0531.
021740             88 ITS-INDEPENDENCE-DAY
021750                                 VALUES 0705 THRU 0706.
021760             88 ITS-LABOR-DAY    VALUES 0901 THRU 0907.
021770             88 ITS-THANKSGIVING
021780                                 VALUES 1122 THRU 1128.
021790             88 ITS-CHRISTMAS VALUES 1226 THRU 1227.
019400      05  WS-OPT26-DAY-OF-WEEK      PIC  9(01).
021794          88 ITS-THE-WEEKEND VALUES 0 6.
021795          88 ITS-A-WEEKDAY   VALUES 1 2 3 4 5.
021796          88 ITS-SUNDAY      VALUE 0.
021797          88 ITS-MONDAY      VALUE 1.
021798          88 ITS-TUESDAY     VALUE 2.
021799          88 ITS-WEDNESDAY   VALUE 3.
021800          88 ITS-THURSDAY    VALUE 4.
021801          88 ITS-FRIDAY      VALUE 5.
021802          88 ITS-SATURDAY    VALUE 6.
019500      05  FILLER                    PIC  X(11) VALUE SPACES.
018600*
018700* 01  WS-OPT27-DATE.
018800*     05  WS-OPT27-CCYYMMDD         PIC  9(08).
018900*     05  FILLER REDEFINES WS-OPT27-CCYYMMDD.
019000*         10  WS-OPT27-CC           PIC  9(02).
019100*         10  WS-OPT27-YY           PIC  9(02).
019200*         10  WS-OPT27-MM           PIC  9(02).
019300*         10  WS-OPT27-DD           PIC  9(02).
019400*     05  WS-OPT27-DAY-OF-WEEK      PIC  9(01).
019500*     05  FILLER                    PIC  X(11) VALUE SPACES.
020500*
020500  01  WS-MISC-TIMES.
020600      05  WS-TIME-WK                PIC  9(03).
020700      05  FILLER REDEFINES WS-TIME-WK.
020800          10  WS-TIME-WK1           PIC  9(01).
020900          10  WS-TIME-WK2           PIC  9(02).
021000*
021100      05  WS-TIME-CVRT1             PIC  9(08).
021200      05  WS-TIME-CVRT2             PIC  9(08).
021300      05  WS-TIME-CVRT3             PIC  9(08).
021400      05  WS-TIME-CVRT4             PIC  9(08).
021500*
021600      05  WS-BY60                   PIC  9(04) VALUE 0060.
021700      05  WS-BY3600                 PIC  9(04) VALUE 3600.
021800      05  JULIAN                    PIC  9(07) VALUE 0.
021900      05  TODAY-NO                  PIC  9(08) VALUE 0.
022000      05  DOW                       PIC  9(01).
021900      05  JULIAN-FROM-DATE          PIC  9(07) VALUE 0.
021900      05  JULIAN-TO-DATE            PIC  9(07) VALUE 0.
022100
022200  01  WS-DAYS-IN-MONTH.
022300          10  DAYS-JAN    PIC  X(04) VALUE '0131'.
022400          10  DAYS-FEB    PIC  X(04) VALUE '0228'.
022500          10  DAYS-MAR    PIC  X(04) VALUE '0331'.
022600          10  DAYS-APR    PIC  X(04) VALUE '0430'.
022700          10  DAYS-MAY    PIC  X(04) VALUE '0531'.
022800          10  DAYS-JUN    PIC  X(04) VALUE '0630'.
022900          10  DAYS-JUL    PIC  X(04) VALUE '0731'.
023000          10  DAYS-AUG    PIC  X(04) VALUE '0831'.
023100          10  DAYS-SEP    PIC  X(04) VALUE '0930'.
023200          10  DAYS-OCT    PIC  X(04) VALUE '1031'.
023300          10  DAYS-NOV    PIC  X(04) VALUE '1130'.
023400          10  DAYS-DEC    PIC  X(04) VALUE '1231'.
023500
023600  01  IN-MONTH REDEFINES WS-DAYS-IN-MONTH.
023700      05  IN-MONTH OCCURS 12 TIMES
023800                                 INDEXED BY MON-INDEX.
023900          10  THE-MONTH         PIC  9(02).
024000          10  THE-DAYS          PIC  9(02).
024100
024200  01  WS-YEAR-WORK               PIC  9(02).
024300  01  WS-YEAR-WORK1              PIC  9(02).
024400  01  WS-YEAR-WORK2              PIC  9(02).
024500
024600  01  WS-FOUR                    PIC  9(01) VALUE 4.
024700
024800  01  WS-LIMIT-OF-MONTH          PIC  9(02) VALUE 0.
024900  01  WS-DAY-OF-MONTH            PIC  9(02) VALUE 0.
025000
025100
025200*
025300 LINKAGE SECTION.
025400*
025500 01  LS-LINK-DATA.
025600*
025700     05  LS-DATE-REQUEST               PIC  9(02).
025800*
025900     05  LS-INPUT-FORMAT               PIC  X(20).
026000     05  LS-DATE REDEFINES LS-INPUT-FORMAT.
026100         10 LS-YEAR              PIC 99.
026200         10 LS-MONTH             PIC 99.
026300         10 LS-DAY               PIC 99.
026400         10 FILLER               PIC X(14).
026500     05  DATE-IN-ENGLISH-W REDEFINES LS-DATE.
026600         10 MONTH-NAME           PIC X(09).
026700         10 FILLER               PIC X(11).
026800     05  LS-YYMMDD-FORMAT REDEFINES LS-INPUT-FORMAT.
026900         10  LS-YYMMDD-FORMAT.
027000             20  LS-YYMMDD-YY          PIC  9(02).
027100             20  LS-YYMMDD-MM          PIC  9(02).
027200             20  LS-YYMMDD-DD          PIC  9(02).
027300             20  FILLER                PIC  X(14).
026000     05  AGED-DATE REDEFINES LS-INPUT-FORMAT.
026100         10 LS-AGED-DATE-1-CYMD            PIC  9(08).
026100         10 LS-AGED-DATE-2-CYMD            PIC  9(08).
026400         10 LS-AGED-DATE-DIFFERENCE        PIC  9(04).
027500     05  LS-MMDDYY-FORMAT REDEFINES LS-INPUT-FORMAT.
027600         10  LS-MMDDYY-FORMAT.
027700             20  LS-MMDDYY-MM          PIC  9(02).
027800             20  LS-MMDDYY-DD          PIC  9(02).
027900             20  LS-MMDDYY-YY          PIC  9(02).
028000             20  FILLER                PIC  X(14).
028200     05  LS-HHMMSS-FORMAT REDEFINES LS-INPUT-FORMAT.
028300         10  LS-HHMMSS-FORMAT         PIC   X(20).
028400         10  FILLER REDEFINES LS-HHMMSS-FORMAT.
028500             15  LS-HHMMSS-PARM1       PIC  9(06).
028600             15  FILLER REDEFINES LS-HHMMSS-PARM1.
028700                 20  LS-HHMMSS-PARM1-HH    PIC  9(02).
028800                 20  LS-HHMMSS-PARM1-MM    PIC  9(02).
028900                 20  LS-HHMMSS-PARM1-SS    PIC  9(02).
029000             15  LS-HHMMSS-PARM2       PIC  9(06).
029100             15  FILLER REDEFINES LS-HHMMSS-PARM2.
029200                 20  LS-HHMMSS-PARM2-HH    PIC  9(02).
029300                 20  LS-HHMMSS-PARM2-MM    PIC  9(02).
029400                 20  LS-HHMMSS-PARM2-SS    PIC  9(02).
029500             15  FILLER                    PIC  X(08).
029700     05  LS-HHHHMMSS-FORMAT REDEFINES LS-INPUT-FORMAT.
029800         10  LS-HHHHMMSS-FORMAT            PIC  X(20).
029900         10  FILLER REDEFINES LS-HHHHMMSS-FORMAT.
030000             15  LS-HHHHMMSS-PARM1         PIC  9(08).
030100             15  FILLER REDEFINES LS-HHHHMMSS-PARM1.
030200                 20  LS-HHHHMMSS-PARM1-HH  PIC  9(04).
030300                 20  LS-HHHHMMSS-PARM1-MM  PIC  9(02).
030400                 20  LS-HHHHMMSS-PARM1-SS  PIC  9(02).
030500             15  LS-HHHHMMSS-PARM2         PIC  9(08).
030600             15  FILLER REDEFINES LS-HHHHMMSS-PARM2.
030700                 20  LS-HHHHMMSS-PARM2-HH  PIC  9(04).
030800                 20  LS-HHHHMMSS-PARM2-MM  PIC  9(02).
030900                 20  LS-HHHHMMSS-PARM2-SS  PIC  9(02).
031000             15  FILLER                    PIC  X(04).
031200     05  LS-SSSSSSSS-FORMAT REDEFINES LS-INPUT-FORMAT.
031300         10  LS-SSSSSSSS-FORMAT            PIC  X(20).
031400         10  FILLER REDEFINES LS-SSSSSSSS-FORMAT.
031500             15  LS-SSSSSSSS-PARM1         PIC  9(08).
031600             15  FILLER REDEFINES LS-SSSSSSSS-PARM1.
031700                 20  LS-SSSSSSSS-PARM1-HH  PIC  9(04).
031800                 20  LS-SSSSSSSS-PARM1-MM  PIC  9(02).
031900                 20  LS-SSSSSSSS-PARM1-SS  PIC  9(02).
032000             15  LS-SSSSSSSS-PARM2         PIC  9(08).
032100             15  FILLER REDEFINES LS-SSSSSSSS-PARM2.
032200                 20  LS-SSSSSSSS-PARM2-HH  PIC  9(04).
032300                 20  LS-SSSSSSSS-PARM2-MM  PIC  9(02).
032400                 20  LS-SSSSSSSS-PARM2-SS  PIC  9(02).
032500             15  FILLER                    PIC  X(04).
032600
032700 PROCEDURE DIVISION USING LS-LINK-DATA.
032700*PROCEDURE DIVISION.
032800*
032900 0001-BEGIN.
033000*
033100*     MOVE '25'                 TO LS-DATE-REQUEST.
026100*     MOVE '19980101'           TO LS-AGED-DATE-1-CYMD.
026100*     MOVE '19980218'           TO LS-AGED-DATE-2-CYMD.
033000*
026100*     MOVE '19980218'           TO LS-AGED-DATE-1-CYMD.
026100*     MOVE '19980101'           TO LS-AGED-DATE-2-CYMD.
026400*     MOVE ZEROS                TO LS-AGED-DATE-DIFFERENCE.
033000*     
            
038200      IF LS-YEAR    = ZEROS AND
038300         LS-MONTH   = ZEROS AND
038300         LS-DAY     = ZEROS
025900         MOVE '00000000'     TO LS-INPUT-FORMAT(1:8)                                                              
038400         GO TO 9999-DATE-EXIT                                                                                     
038400       END-IF.                                                                                                    
038500                                                                                                                    
025900      if ls-input-format(1:6) = '068310'                                                                            
038400         go to 9999-date-exit                                                                                     
038400       end-if.                                                                                                    
038500                                                                                                                    
033600      IF LS-DATE-REQUEST = 01
033700           GO TO 0001-FORMAT-OPTION01.
033800      IF LS-DATE-REQUEST = 02
033900           GO TO 0002-FORMAT-OPTION02.
034000      IF LS-DATE-REQUEST = 03
034100           GO TO 0003-FORMAT-OPTION03.
034200      IF LS-DATE-REQUEST = 04
034300           GO TO 0004-FORMAT-OPTION04.
034400      IF LS-DATE-REQUEST = 05
034500           GO TO 0005-FORMAT-OPTION05.
034600      IF LS-DATE-REQUEST = 06
034700           GO TO CONVERT-TO-ENGLISH.
034800      IF LS-DATE-REQUEST = 07
034900           GO TO CONVERT-TO-ENGLISH.
035000      IF LS-DATE-REQUEST = 08
035100           GO TO CONVERT-TO-ENGLISH.
035200      IF LS-DATE-REQUEST = 09
035300           GO TO CONVERT-TO-ENGLISH.
035400      IF LS-DATE-REQUEST = 11
035500           GO TO 0011-FORMAT-OPTION11.
035600      IF LS-DATE-REQUEST = 12
035700           GO TO 0012-FORMAT-OPTION12.
035800      IF LS-DATE-REQUEST = 13
035900           GO TO 0013-FORMAT-OPTION13.
036000      IF LS-DATE-REQUEST = 14
036100           GO TO 0014-FORMAT-OPTION14.
036200*
036300      IF LS-DATE-REQUEST = 21
036400           GO TO 0021-FORMAT-OPTION21.
036500      IF LS-DATE-REQUEST = 22
036600           GO TO 0022-FORMAT-OPTION22.
036700      IF LS-DATE-REQUEST = 23
036800           GO TO 0023-FORMAT-OPTION23.
036810      IF LS-DATE-REQUEST = 24
036820           GO TO 0024-FORMAT-OPTION24.
036810      IF LS-DATE-REQUEST = 25
036820           GO TO 0025-FORMAT-OPTION25.
036810      IF LS-DATE-REQUEST = 26
036820           GO TO 0026-FORMAT-OPTION26.
036810      IF LS-DATE-REQUEST = 27
036820           GO TO 0027-FORMAT-OPTION27.
036810      IF LS-DATE-REQUEST = 28
036820           GO TO 0028-FORMAT-OPTION28.
036810      IF LS-DATE-REQUEST = 29
036820           GO TO 0029-FORMAT-OPTION29.
036900*
037000      IF LS-DATE-REQUEST = 91
037100           GO TO 0091-FORMAT-OPTION91.
037200      IF LS-DATE-REQUEST = 92
037300           GO TO 0092-FORMAT-OPTION92.
037400      IF LS-DATE-REQUEST = 93
037500           GO TO 0093-FORMAT-OPTION93.
037600      IF LS-DATE-REQUEST = 94
037700           GO TO 0094-FORMAT-OPTION94.
037800      IF LS-DATE-REQUEST = 98
037900           GO TO 0098-FORMAT-OPTION98.
038000      IF LS-DATE-REQUEST = 99
038100           GO TO 0099-FORMAT-OPTION99.
038200*
038300      MOVE 99 TO LS-DATE-REQUEST
038400           GO TO 9999-DATE-EXIT.
038500*
038600*
038700 0001-FORMAT-OPTION01.
038900      MOVE LS-YYMMDD-YY         TO WS-OPT01-YY.
039000      MOVE LS-YYMMDD-MM         TO WS-OPT01-MM.
039100      MOVE LS-YYMMDD-DD         TO WS-OPT01-DD.
039200*
039300      IF LS-YYMMDD-YY < 94
039400           MOVE 20              TO WS-OPT01-CC
039500      ELSE
039600           MOVE 19              TO WS-OPT01-CC.
039700*
039800      MOVE 00 TO LS-DATE-REQUEST
039900      MOVE WS-OPT01-DATE        TO LS-INPUT-FORMAT.
040000           GO TO 9999-DATE-EXIT.
040100*
040200*
040300 0002-FORMAT-OPTION02.
040500      MOVE LS-YYMMDD-MM         TO WS-OPT02-MM.
040600      MOVE LS-YYMMDD-DD         TO WS-OPT02-DD.
040700      MOVE LS-YYMMDD-YY         TO WS-OPT02-YY.
040800*
040900*02/07/09 IF LS-YYMMDD-YY < 14                                                                                      
040900      if ls-yymmdd-yy < 94                                                                                          
041000           MOVE 20              TO WS-OPT02-CC
041100      ELSE
041200           MOVE 19              TO WS-OPT02-CC.
041300*
041400      MOVE 00 TO LS-DATE-REQUEST
041500      MOVE WS-OPT02-DATE        TO LS-INPUT-FORMAT.
041600           GO TO 9999-DATE-EXIT.
041700*
041800*
041900 0003-FORMAT-OPTION03.
042100      MOVE LS-YYMMDD-MM         TO WS-OPT03-MM.
042200      MOVE LS-YYMMDD-DD         TO WS-OPT03-DD.
042300      MOVE LS-YYMMDD-YY         TO WS-OPT03-YY.
042400*
042500      MOVE 00 TO LS-DATE-REQUEST
042600      MOVE WS-OPT03-DATE        TO LS-INPUT-FORMAT.
042700           GO TO 9999-DATE-EXIT.
042800*
042900*
043000 0004-FORMAT-OPTION04.
043200      MOVE LS-YYMMDD-MM         TO WS-OPT04-MM.
043300      MOVE LS-YYMMDD-DD         TO WS-OPT04-DD.
043400      MOVE LS-YYMMDD-YY         TO WS-OPT04-YY.
043500*
043600*02/07/08 IF LS-YYMMDD-YY < 14                                                                                      
043600      if ls-yymmdd-yy < 94                                                                                          
043700           MOVE 20              TO WS-OPT04-CC
043800      ELSE
043900           MOVE 19              TO WS-OPT04-CC.
044000*
044100      MOVE 00 TO LS-DATE-REQUEST
044200      MOVE WS-OPT04-DATE        TO LS-INPUT-FORMAT.
044300           GO TO 9999-DATE-EXIT.
044400*
044500*
044600 0005-FORMAT-OPTION05.
044800      MOVE LS-YYMMDD-MM         TO WS-OPT05-MM.
044900      MOVE LS-YYMMDD-DD         TO WS-OPT05-DD.
045000      MOVE LS-YYMMDD-YY         TO WS-OPT05-YY.
045100*
045200      MOVE 00 TO LS-DATE-REQUEST
045300      MOVE WS-OPT05-DATE        TO LS-INPUT-FORMAT.
045400           GO TO 9999-DATE-EXIT.
045500*
045600*
045700 0011-FORMAT-OPTION11.
045900      MOVE LS-MMDDYY-YY         TO WS-OPT11-YY.
046000      MOVE LS-MMDDYY-MM         TO WS-OPT11-MM.
046100      MOVE LS-MMDDYY-DD         TO WS-OPT11-DD.
046200*
046300*02/07/08 IF LS-MMDDYY-YY < 14                                                                                      
046300      if ls-mmddyy-yy < 94                                                                                          
046400           MOVE 20              TO WS-OPT11-CC
046500      ELSE
046600           MOVE 19              TO WS-OPT11-CC.
046700*
046800      MOVE 00 TO LS-DATE-REQUEST
046900      MOVE WS-OPT11-DATE        TO LS-INPUT-FORMAT.
047000           GO TO 9999-DATE-EXIT.
047100*
047200*
047300 0012-FORMAT-OPTION12.
047500      MOVE LS-MMDDYY-YY         TO WS-OPT12-YY.
047600      MOVE LS-MMDDYY-MM         TO WS-OPT12-MM.
047700      MOVE LS-MMDDYY-DD         TO WS-OPT12-DD.
047800*
047900      MOVE 00 TO LS-DATE-REQUEST
048000      MOVE WS-OPT12-DATE        TO LS-INPUT-FORMAT.
048100           GO TO 9999-DATE-EXIT.
048200*
048300*
048400 0013-FORMAT-OPTION13.
048600      MOVE LS-MMDDYY-MM         TO WS-OPT13-MM.
048700      MOVE LS-MMDDYY-DD         TO WS-OPT13-DD.
048800      MOVE LS-MMDDYY-YY         TO WS-OPT13-YY.
048900*
049000      MOVE 00 TO LS-DATE-REQUEST
049100      MOVE WS-OPT13-DATE        TO LS-INPUT-FORMAT.
049200           GO TO 9999-DATE-EXIT.
049300*
049400*
049500 0014-FORMAT-OPTION14.
049700      MOVE LS-MMDDYY-MM         TO WS-OPT14-MM.
049800      MOVE LS-MMDDYY-DD         TO WS-OPT14-DD.
049900      MOVE LS-MMDDYY-YY         TO WS-OPT14-YY.
050000*
050100*02/07/08 IF LS-MMDDYY-YY < 14                                                                                      
050100      if ls-mmddyy-yy < 94                                                                                          
050200           MOVE 20              TO WS-OPT14-CC
050300      ELSE
050400           MOVE 19              TO WS-OPT14-CC.
050500*
050600      MOVE 00 TO LS-DATE-REQUEST
050700      MOVE WS-OPT14-DATE        TO LS-INPUT-FORMAT.
050800           GO TO 9999-DATE-EXIT.
050900*
051000 0021-FORMAT-OPTION21.
051100     MOVE LS-INPUT-FORMAT(1:8)    TO WS-OPT21-CCYYMMDD.
051200     MOVE LS-INPUT-FORMAT(9:3)    TO WS-OPT21-ADD-FACTOR.
051300      COMPUTE TODAY-NO =
051400              FUNCTION INTEGER-OF-DATE (WS-OPT21-CCYYMMDD)
051500
051600* FOLLOWING INSTRUCTION IS FOR REFERENCE ONLY, IT CONVERTS
051700* TODAY-NO WHICH IS A INTEGER DATE TO JULIAN FORMAT (YYYYDDD).
051800      COMPUTE JULIAN =
051900              FUNCTION DAY-OF-INTEGER (TODAY-NO)
052000
052100      ADD WS-OPT21-ADD-FACTOR      TO TODAY-NO.
052200      MOVE ZEROS                TO WS-OPT21-CCYYMMDD.
052300      COMPUTE WS-OPT21-CCYYMMDD =
052400              FUNCTION DATE-OF-INTEGER (TODAY-NO)
052500      MOVE 00 TO LS-DATE-REQUEST
052600      MOVE WS-OPT21-DATE        TO LS-INPUT-FORMAT.
052700           GO TO 9999-DATE-EXIT.
052800*
052900 0022-FORMAT-OPTION22.
053000     MOVE LS-INPUT-FORMAT(1:8)    TO WS-OPT22-CCYYMMDD.
053100     MOVE LS-INPUT-FORMAT(9:3)    TO WS-OPT22-SUB-FACTOR.
053200      COMPUTE TODAY-NO =
053300              FUNCTION INTEGER-OF-DATE (WS-OPT22-CCYYMMDD)
053400      SUBTRACT WS-OPT22-SUB-FACTOR   FROM TODAY-NO.
053500      MOVE ZEROS                TO WS-OPT22-CCYYMMDD.
053600      COMPUTE WS-OPT22-CCYYMMDD =
053700              FUNCTION DATE-OF-INTEGER (TODAY-NO)
053800      MOVE 00 TO LS-DATE-REQUEST
053900      MOVE WS-OPT22-DATE        TO LS-INPUT-FORMAT.
054000           GO TO 9999-DATE-EXIT.
054100*
054200 0023-FORMAT-OPTION23.
054300      MOVE LS-INPUT-FORMAT(1:8)    TO WS-OPT23-CCYYMMDD.
054400      COMPUTE DOW = FUNCTION REM (FUNCTION INTEGER-OF-DATE
054500      (WS-OPT23-CCYYMMDD) , 7).
054600      MOVE 00 TO LS-DATE-REQUEST
054700      MOVE WS-OPT23-DATE        TO LS-INPUT-FORMAT.
054800      MOVE DOW                  TO LS-INPUT-FORMAT(9:1).
054900           GO TO 9999-DATE-EXIT.
055000*
055100 0024-FORMAT-OPTION24.
055200      MOVE LS-INPUT-FORMAT(1:8)    TO WS-OPT24-CCYYMMDD.
055300      PERFORM VARYING MON-INDEX FROM 1 BY 1
055400              UNTIL MON-INDEX > 12
055500              IF THE-MONTH(MON-INDEX) =
055600                               WS-OPT24-MM
055700              MOVE THE-DAYS(MON-INDEX) TO
055800                                WS-OPT24-DD
055900              GO TO CHECK-FOR-LEAP-YEAR
056000          END-PERFORM.
056100
056200 CHECK-FOR-LEAP-YEAR.
056300      IF WS-OPT24-MM NOT = '02'
056400         GO TO FINISH-OPT24.
056500      MOVE WS-OPT24-YY            TO WS-YEAR-WORK.
056600      MOVE  ZEROS                 TO WS-YEAR-WORK1
056700                                     WS-YEAR-WORK2.
056800      DIVIDE WS-YEAR-WORK  BY WS-FOUR   GIVING
056900                        WS-YEAR-WORK1  REMAINDER WS-YEAR-WORK2.
057000      IF WS-YEAR-WORK2 = 0
057100         ADD 1                        TO WS-OPT24-DD.
057200
057300 FINISH-OPT24.
057400      MOVE WS-OPT24-DATE        TO LS-INPUT-FORMAT.
057500           GO TO 9999-DATE-EXIT.
054100*
054200 0025-FORMAT-OPTION25.
026100      IF LS-AGED-DATE-1-CYMD = LS-AGED-DATE-2-CYMD
026400         MOVE ZEROS            TO LS-AGED-DATE-DIFFERENCE
038300         MOVE 99               TO LS-DATE-REQUEST
038400         GO TO 9999-DATE-EXIT
038400       END-IF.
026100      MOVE LS-AGED-DATE-1-CYMD     TO WS-OPT25-DATE1-CCYYMMDD.
026100      MOVE LS-AGED-DATE-2-CYMD     TO WS-OPT25-DATE2-CCYYMMDD.
051300      COMPUTE JULIAN-FROM-DATE =
051400              FUNCTION INTEGER-OF-DATE (WS-OPT25-DATE1-CCYYMMDD).
051300      COMPUTE JULIAN-TO-DATE =
051400              FUNCTION INTEGER-OF-DATE (WS-OPT25-DATE2-CCYYMMDD).
026100      IF JULIAN-FROM-DATE < JULIAN-TO-DATE
019800         SUBTRACT JULIAN-FROM-DATE FROM JULIAN-TO-DATE
026400         MOVE JULIAN-TO-DATE(4:4)   TO LS-AGED-DATE-DIFFERENCE
054600        ELSE
019800         SUBTRACT JULIAN-TO-DATE FROM JULIAN-FROM-DATE
026400         MOVE JULIAN-FROM-DATE(4:4) TO LS-AGED-DATE-DIFFERENCE
054600       END-IF.
026400      ADD 1                      TO LS-AGED-DATE-DIFFERENCE.
054600      MOVE 00 TO LS-DATE-REQUEST
054900      GO TO 9999-DATE-EXIT.
057600*
036820 0026-FORMAT-OPTION26.
051100     MOVE LS-INPUT-FORMAT(1:8)    TO WS-OPT26-CCYYMMDD.
051300      COMPUTE TODAY-NO =
051400              FUNCTION INTEGER-OF-DATE (WS-OPT26-CCYYMMDD)
051800      COMPUTE JULIAN =
051900              FUNCTION DAY-OF-INTEGER (TODAY-NO)
052100      ADD 1                     TO TODAY-NO.
052200      MOVE ZEROS                TO WS-OPT26-CCYYMMDD.
052300      COMPUTE WS-OPT26-CCYYMMDD =
052400              FUNCTION DATE-OF-INTEGER (TODAY-NO)
052600      MOVE WS-OPT26-DATE        TO LS-INPUT-FORMAT.
            PERFORM SEE-IF-HOLIDAY THRU
                    SEE-IF-HOLIDAY-EXIT.
019400      MOVE DOW                  TO LS-INPUT-FORMAT(9:1).
052500      MOVE 00                   TO LS-DATE-REQUEST.
052700      GO TO 9999-DATE-EXIT.
      *                                                                                                                   
057600*
036820 0027-FORMAT-OPTION27.
051100     MOVE LS-INPUT-FORMAT(1:8)    TO WS-OPT26-CCYYMMDD.
051300      COMPUTE TODAY-NO =
051400              FUNCTION INTEGER-OF-DATE (WS-OPT26-CCYYMMDD)
051800      COMPUTE JULIAN =
051900              FUNCTION DAY-OF-INTEGER (TODAY-NO)
052100      SUBTRACT 1              FROM TODAY-NO.
052200      MOVE ZEROS                TO WS-OPT26-CCYYMMDD.
052300      COMPUTE WS-OPT26-CCYYMMDD =
052400              FUNCTION DATE-OF-INTEGER (TODAY-NO)
052600      MOVE WS-OPT26-DATE        TO LS-INPUT-FORMAT.
            PERFORM SEE-IF-HOLIDAY THRU
                    SEE-IF-HOLIDAY-EXIT.
019400      MOVE DOW                  TO LS-INPUT-FORMAT(9:1).
052500      MOVE 00                   TO LS-DATE-REQUEST.
052700      GO TO 9999-DATE-EXIT.
057600*
036820 0028-FORMAT-OPTION28.
051100     MOVE LS-INPUT-FORMAT(1:8)    TO WS-OPT26-CCYYMMDD.
051300      COMPUTE TODAY-NO =
051400              FUNCTION INTEGER-OF-DATE (WS-OPT26-CCYYMMDD)
051800      COMPUTE JULIAN =
051900              FUNCTION DAY-OF-INTEGER (TODAY-NO)
052100      ADD 1                     TO TODAY-NO.
052200      MOVE ZEROS                TO WS-OPT26-CCYYMMDD.
052300      COMPUTE WS-OPT26-CCYYMMDD =
052400              FUNCTION DATE-OF-INTEGER (TODAY-NO)
052600      MOVE WS-OPT26-DATE        TO LS-INPUT-FORMAT.
            PERFORM SEE-HOLIDAY-AND-WED-FRI THRU
                    SEE-HOLIDAY-AND-WED-FRI-EXIT.
019400      MOVE DOW                  TO LS-INPUT-FORMAT(9:1).
052500      MOVE 00                   TO LS-DATE-REQUEST.
052700      GO TO 9999-DATE-EXIT.
      *                                                                                                                   
057600*
036820 0029-FORMAT-OPTION29.
051100     MOVE LS-INPUT-FORMAT(1:8)    TO WS-OPT26-CCYYMMDD.
051300      COMPUTE TODAY-NO =
051400              FUNCTION INTEGER-OF-DATE (WS-OPT26-CCYYMMDD)
051800      COMPUTE JULIAN =
051900              FUNCTION DAY-OF-INTEGER (TODAY-NO)
052100      SUBTRACT 1              FROM TODAY-NO.
052200      MOVE ZEROS                TO WS-OPT26-CCYYMMDD.
052300      COMPUTE WS-OPT26-CCYYMMDD =
052400              FUNCTION DATE-OF-INTEGER (TODAY-NO)
052600      MOVE WS-OPT26-DATE        TO LS-INPUT-FORMAT.
            PERFORM SEE-HOLIDAY-AND-WED-FRI THRU
                    SEE-HOLIDAY-AND-WED-FRI-EXIT.
019400      MOVE DOW                  TO LS-INPUT-FORMAT(9:1).
052500      MOVE 00                   TO LS-DATE-REQUEST.
052700      GO TO 9999-DATE-EXIT.
057600*
057600*
057600*
       SEE-IF-HOLIDAY.
283330      SET HOL-IDX TO 1.
283330      IF HOLIDAY-DATE(HOL-IDX) = HIGH-VALUES
               PERFORM LOAD-HOLIDAYS THRU
                       LOAD-HOLIDAYS-EXIT
             END-IF.
054300      MOVE LS-INPUT-FORMAT(1:8) TO WS-OPT26-CCYYMMDD.
054400      COMPUTE DOW = FUNCTION REM (FUNCTION INTEGER-OF-DATE
054500      (WS-OPT26-CCYYMMDD) , 7).
019400      MOVE DOW                  TO WS-OPT26-DAY-OF-WEEK.
279329      IF ITS-THE-WEEKEND OR ITS-A-HOLIDAY
051100         MOVE LS-INPUT-FORMAT(1:8)
051100                                TO WS-OPT26-CCYYMMDD
051300         COMPUTE TODAY-NO =
051400              FUNCTION INTEGER-OF-DATE (WS-OPT26-CCYYMMDD)
051800         COMPUTE JULIAN =
051900              FUNCTION DAY-OF-INTEGER (TODAY-NO)
052500         IF LS-DATE-REQUEST = '26'
052100            ADD 1               TO TODAY-NO
                 ELSE
052100            SUBTRACT 1        FROM TODAY-NO
                END-IF
052200         MOVE ZEROS             TO WS-OPT26-CCYYMMDD
052300         COMPUTE WS-OPT26-CCYYMMDD =
052400              FUNCTION DATE-OF-INTEGER (TODAY-NO)
052200         MOVE WS-OPT26-CCYYMMDD    TO LS-INPUT-FORMAT(1:8)
               GO TO SEE-IF-HOLIDAY
             END-IF.
281200
281220****** CHECK FOR BANK HOLIDAY ********
281250    PERFORM VARYING HOL-IDX FROM 1 BY 1
281260              UNTIL HOLIDAY-DATE(HOL-IDX) = HIGH-VALUES
052200      IF WS-OPT26-CCYYMMDD = HOLIDAY-DATE(HOL-IDX)
052200         MOVE WS-OPT26-CCYYMMDD    TO LS-INPUT-FORMAT(1:8)
               GO TO SEE-IF-HOLIDAY
283200       END-PERFORM.
283300
052600      MOVE WS-OPT26-CCYYMMDD       TO LS-INPUT-FORMAT(1:8).
283300
054300      MOVE LS-INPUT-FORMAT(1:8) TO WS-OPT26-CCYYMMDD.
054400      COMPUTE DOW = FUNCTION REM (FUNCTION INTEGER-OF-DATE
054500      (WS-OPT26-CCYYMMDD) , 7).
019400      MOVE DOW                  TO WS-OPT26-DAY-OF-WEEK.
       SEE-IF-HOLIDAY-EXIT. EXIT.
057600*

       SEE-HOLIDAY-AND-WED-FRI.
283330      SET HOL-IDX TO 1.
283330      IF HOLIDAY-DATE(HOL-IDX) = HIGH-VALUES
               PERFORM LOAD-HOLIDAYS THRU
                       LOAD-HOLIDAYS-EXIT
             END-IF.
054300      MOVE LS-INPUT-FORMAT(1:8) TO WS-OPT26-CCYYMMDD.
054400      COMPUTE DOW = FUNCTION REM (FUNCTION INTEGER-OF-DATE
054500      (WS-OPT26-CCYYMMDD) , 7).
019400      MOVE DOW                  TO WS-OPT26-DAY-OF-WEEK.
279329      IF ITS-THE-WEEKEND OR ITS-A-HOLIDAY
021799                         OR ITS-WEDNESDAY
021801                         OR ITS-FRIDAY
051100         MOVE LS-INPUT-FORMAT(1:8)
051100                                TO WS-OPT26-CCYYMMDD
051300         COMPUTE TODAY-NO =
051400              FUNCTION INTEGER-OF-DATE (WS-OPT26-CCYYMMDD)
051800         COMPUTE JULIAN =
051900              FUNCTION DAY-OF-INTEGER (TODAY-NO)
052500         IF LS-DATE-REQUEST = '28'
052100            ADD 1               TO TODAY-NO
                 ELSE
052100            SUBTRACT 1        FROM TODAY-NO
                END-IF
052200         MOVE ZEROS             TO WS-OPT26-CCYYMMDD
052300         COMPUTE WS-OPT26-CCYYMMDD =
052400              FUNCTION DATE-OF-INTEGER (TODAY-NO)
052200         MOVE WS-OPT26-CCYYMMDD    TO LS-INPUT-FORMAT(1:8)
               GO TO SEE-HOLIDAY-AND-WED-FRI
             END-IF.
281200
281220****** CHECK FOR BANK HOLIDAY ********
281250    PERFORM VARYING HOL-IDX FROM 1 BY 1
281260              UNTIL HOLIDAY-DATE(HOL-IDX) = HIGH-VALUES
052200      IF WS-OPT26-CCYYMMDD = HOLIDAY-DATE(HOL-IDX)
052200         MOVE WS-OPT26-CCYYMMDD    TO LS-INPUT-FORMAT(1:8)
               GO TO SEE-HOLIDAY-AND-WED-FRI
283200       END-PERFORM.
283300
052600      MOVE WS-OPT26-CCYYMMDD       TO LS-INPUT-FORMAT(1:8).
283300
054300      MOVE LS-INPUT-FORMAT(1:8) TO WS-OPT26-CCYYMMDD.
054400      COMPUTE DOW = FUNCTION REM (FUNCTION INTEGER-OF-DATE
054500      (WS-OPT26-CCYYMMDD) , 7).
019400      MOVE DOW                  TO WS-OPT26-DAY-OF-WEEK.
       SEE-HOLIDAY-AND-WED-FRI-EXIT. EXIT.
283310
283310
       LOAD-HOLIDAYS.
283321    PERFORM VARYING HOL-IDX FROM 1 BY 1
283322              UNTIL HOL-IDX > 100
283330       MOVE HIGH-VALUES         TO HOLIDAY-DATE(HOL-IDX)
283331     END-PERFORM.

283391    ACCEPT TODAYS-DATE-YMD FROM DATE.
283391    IF TODAYS-DATE-YMD(1:2) < '94'
283391       MOVE '20'      TO TODAYS-DATE-CYMD(1:2)
            ELSE
283391       MOVE '19'      TO TODAYS-DATE-CYMD(1:2)
           END-IF.

283391    INITIALIZE TPS-CALEN-REC.
283380    MOVE F-PRIME      TO FILE-KEY.
283390    MOVE F-OPEN-INPUT TO FILE-ACTION.
283391    CALL TPSIO018 USING FILE-REQUEST TPS-CALEN-REC.
283395    IF NOT A-SUCCESSFUL-OPERATION
283396       MOVE 'TPSDATES'       TO FILE-NAME
283418       MOVE 'TPSDATES OP'    TO FILE-TEXT
283398       CALL TPSIOERR USING FILE-REQUEST
             GO TO LOAD-HOLIDAYS-EXIT
283401     END-IF.
283340    MOVE '9999999999'           TO CAL-KEY-ACCT-NO
283350    MOVE '00'                   TO CAL-KEY-SUB-ACCT
283360    MOVE ZERO                   TO HOL-IDX.
283380    MOVE F-PRIME TO FILE-KEY.
283390    MOVE F-START TO FILE-ACTION.
283391    CALL TPSIO018 USING FILE-REQUEST TPS-CALEN-REC.
283392    IF END-OF-FILE-WAS-REACHED
283392       OR NO-RECORD-WAS-FOUND
                GO TO LOAD-HOLIDAYS-EXIT
283394     END-IF.
283395    IF NOT A-SUCCESSFUL-OPERATION
283396       MOVE 'CALENDAR' TO FILE-NAME
283418       MOVE 'TPSDATES ST'    TO FILE-TEXT
283398       CALL TPSIOERR USING FILE-REQUEST
             GO TO LOAD-HOLIDAYS-EXIT
283401     END-IF.
283402
       CONTINUE-LOAD-HOLIDAYS.
283404    IF HOL-IDX > 100
             GO TO LOAD-HOLIDAYS-EXIT
283406     END-IF.
283408    MOVE F-PRIME TO FILE-KEY.
283409    MOVE F-READ-NEXT TO FILE-ACTION.
283410    CALL TPSIO018 USING FILE-REQUEST TPS-CALEN-REC.
283411    IF END-OF-FILE-WAS-REACHED
             GO TO LOAD-HOLIDAYS-EXIT
283415     END-IF.
283416    IF NOT A-SUCCESSFUL-OPERATION
283417       MOVE 'CALENDAR   '    TO FILE-NAME
283418       MOVE 'TPSDATES RN'    TO FILE-TEXT
283419       CALL TPSIOERR USING FILE-REQUEST
             GO TO LOAD-HOLIDAYS-EXIT
283421     END-IF.
283422    IF CAL-KEY-DATE < TODAYS-DATE-CYMD
             GO TO CONTINUE-LOAD-HOLIDAYS
283424     END-IF.
283426    IF CAL-APPT-APPOINT-DATA(37:1) = 'B'
283427       ADD 1                        TO HOL-IDX
283428       MOVE CAL-KEY-DATE            TO HOLIDAY-DATE(HOL-IDX)
             GO TO CONTINUE-LOAD-HOLIDAYS
283430      ELSE
             GO TO CONTINUE-LOAD-HOLIDAYS
283432     END-IF.

       LOAD-HOLIDAYS-EXIT.
283380    MOVE F-PRIME      TO FILE-KEY.
283390    MOVE F-CLOSE      TO FILE-ACTION.
283391    CALL TPSIO018 USING FILE-REQUEST TPS-CALEN-REC.
283395    IF NOT A-SUCCESSFUL-OPERATION
283396       MOVE 'TPSDATES'       TO FILE-NAME
283418       MOVE 'TPSDATES CL'    TO FILE-TEXT
283398       CALL TPSIOERR USING FILE-REQUEST
283401     END-IF.
283433    EXIT.
283434
057600*
057700 0091-FORMAT-OPTION91.
057800      IF LS-HHMMSS-PARM1 < LS-HHMMSS-PARM2
057900           MOVE 99              TO LS-DATE-REQUEST
058000           GO TO 9999-DATE-EXIT.
058100
058200      IF LS-HHMMSS-PARM1-SS < LS-HHMMSS-PARM2-SS AND
058300           LS-HHMMSS-PARM1-MM     = 00
058400               MOVE ZEROS             TO WS-TIME-WK
058500               MOVE LS-HHMMSS-PARM1-SS  TO WS-TIME-WK2
058600               ADD 60                 TO WS-TIME-WK
058700               SUBTRACT LS-HHMMSS-PARM2-SS FROM WS-TIME-WK
058800               MOVE WS-TIME-WK2       TO LS-HHMMSS-PARM1-SS
058900               ADD  59                TO LS-HHMMSS-PARM1-MM
059000               SUBTRACT 1           FROM LS-HHMMSS-PARM1-HH
059100      ELSE
059200      IF LS-HHMMSS-PARM1-SS < LS-HHMMSS-PARM2-SS AND
059300           LS-HHMMSS-PARM1-MM NOT = 00
059400               MOVE ZEROS             TO WS-TIME-WK
059500               MOVE LS-HHMMSS-PARM1-SS  TO WS-TIME-WK2
059600               ADD 60                 TO WS-TIME-WK
059700               SUBTRACT LS-HHMMSS-PARM2-SS FROM WS-TIME-WK
059800               MOVE WS-TIME-WK2       TO LS-HHMMSS-PARM1-SS
059900               SUBTRACT 1           FROM LS-HHMMSS-PARM1-MM
060000      ELSE
060100           SUBTRACT LS-HHMMSS-PARM2-SS FROM LS-HHMMSS-PARM1-SS
060200        END-IF.
060300
060400      IF LS-HHMMSS-PARM1-MM < LS-HHMMSS-PARM2-MM AND
060500           LS-HHMMSS-PARM1-HH NOT = 00
060600               MOVE ZEROS             TO WS-TIME-WK
060700               MOVE LS-HHMMSS-PARM1-MM  TO WS-TIME-WK2
060800               ADD 60                 TO WS-TIME-WK
060900               SUBTRACT LS-HHMMSS-PARM2-MM FROM WS-TIME-WK
061000               MOVE WS-TIME-WK2       TO LS-HHMMSS-PARM1-MM
061100               SUBTRACT 1           FROM LS-HHMMSS-PARM1-HH
061200      ELSE
061300           SUBTRACT LS-HHMMSS-PARM2-MM FROM LS-HHMMSS-PARM1-MM
061400      END-IF.
061500
061600      SUBTRACT LS-HHMMSS-PARM2-HH FROM LS-HHMMSS-PARM1-HH.
061700
061800      MOVE ZEROS                TO LS-HHMMSS-PARM2.
061900      MOVE 00                   TO LS-DATE-REQUEST.
062000      GO TO 9999-DATE-EXIT.
062100
062200
062300*
062400 0092-FORMAT-OPTION92.
062600      MOVE  ZEROS                   TO WS-TIME-WK.
062700      MOVE  LS-HHMMSS-PARM1-SS    TO WS-TIME-WK2.
062800      ADD LS-HHMMSS-PARM2-SS    TO WS-TIME-WK
062900      IF WS-TIME-WK  > 59
063000               ADD 1 TO LS-HHMMSS-PARM1-MM
063100               SUBTRACT 60 FROM WS-TIME-WK.
063200      MOVE WS-TIME-WK2       TO LS-HHMMSS-PARM1-SS.
063300
063400      MOVE  ZEROS                   TO WS-TIME-WK.
063500      MOVE  LS-HHMMSS-PARM1-MM    TO WS-TIME-WK2.
063600      ADD LS-HHMMSS-PARM2-MM    TO WS-TIME-WK
063700      IF WS-TIME-WK  > 59
063800               ADD 1 TO LS-HHMMSS-PARM1-HH
063900               SUBTRACT 60 FROM WS-TIME-WK.
064000      MOVE WS-TIME-WK2       TO LS-HHMMSS-PARM1-MM.
064100
064200      ADD LS-HHMMSS-PARM2-HH    TO LS-HHMMSS-PARM1-HH
064300
064400      MOVE ZEROS                TO LS-HHMMSS-PARM2.
064500      MOVE 00                   TO LS-DATE-REQUEST.
064600      GO TO 9999-DATE-EXIT.
064700
064800 0093-FORMAT-OPTION93.
065000      IF LS-HHHHMMSS-PARM1 < LS-HHHHMMSS-PARM2
065100           MOVE 99              TO LS-DATE-REQUEST
065200           GO TO 9999-DATE-EXIT.
065300
065400      IF LS-HHHHMMSS-PARM1-SS < LS-HHHHMMSS-PARM2-SS AND
065500           LS-HHHHMMSS-PARM1-MM     = 00
065600               MOVE ZEROS             TO WS-TIME-WK
065700               MOVE LS-HHHHMMSS-PARM1-SS  TO WS-TIME-WK2
065800               ADD 60                 TO WS-TIME-WK
065900               SUBTRACT LS-HHHHMMSS-PARM2-SS FROM WS-TIME-WK
066000               MOVE WS-TIME-WK2       TO LS-HHHHMMSS-PARM1-SS
066100               ADD  59                TO LS-HHHHMMSS-PARM1-MM
066200               SUBTRACT 1           FROM LS-HHHHMMSS-PARM1-HH
066300      ELSE
066400      IF LS-HHHHMMSS-PARM1-SS < LS-HHHHMMSS-PARM2-SS AND
066500           LS-HHHHMMSS-PARM1-MM NOT = 00
066600               MOVE ZEROS             TO WS-TIME-WK
066700               MOVE LS-HHHHMMSS-PARM1-SS  TO WS-TIME-WK2
066800               ADD 60                 TO WS-TIME-WK
066900               SUBTRACT LS-HHHHMMSS-PARM2-SS FROM WS-TIME-WK
067000               MOVE WS-TIME-WK2       TO LS-HHHHMMSS-PARM1-SS
067100               SUBTRACT 1           FROM LS-HHHHMMSS-PARM1-MM
067200      ELSE
067300           SUBTRACT LS-HHHHMMSS-PARM2-SS FROM LS-HHHHMMSS-PARM1-SS
067400        END-IF.
067500
067700      MOVE  ZEROS                   TO WS-TIME-WK.
067800      MOVE  LS-HHHHMMSS-PARM1-MM    TO WS-TIME-WK2.
067900      IF LS-HHHHMMSS-PARM1-MM < LS-HHHHMMSS-PARM2-MM
068000           ADD 60 TO WS-TIME-WK
068100           SUBTRACT  1 FROM LS-HHHHMMSS-PARM1-HH.
068200
068300         SUBTRACT LS-HHHHMMSS-PARM2-MM FROM WS-TIME-WK
068400         MOVE WS-TIME-WK2         TO LS-HHHHMMSS-PARM1-MM.
068500
068600      SUBTRACT LS-HHHHMMSS-PARM2-HH FROM LS-HHHHMMSS-PARM1-HH.
068700
068800      MOVE ZEROS                TO LS-HHHHMMSS-PARM2.
068900      MOVE 00                   TO LS-DATE-REQUEST.
069000      GO TO 9999-DATE-EXIT.
069100
069200*
069300 0094-FORMAT-OPTION94.
069500      MOVE  ZEROS                   TO WS-TIME-WK.
069600      MOVE  LS-HHHHMMSS-PARM1-SS    TO WS-TIME-WK2.
069700      ADD LS-HHHHMMSS-PARM2-SS    TO WS-TIME-WK
069800      IF WS-TIME-WK  > 59
069900               ADD 1 TO LS-HHHHMMSS-PARM1-MM
070000               SUBTRACT 60 FROM WS-TIME-WK.
070100      MOVE WS-TIME-WK2       TO LS-HHHHMMSS-PARM1-SS.
070200
070300      MOVE  ZEROS                   TO WS-TIME-WK.
070400      MOVE  LS-HHHHMMSS-PARM1-MM    TO WS-TIME-WK2.
070500      ADD LS-HHHHMMSS-PARM2-MM    TO WS-TIME-WK
070600      IF WS-TIME-WK  > 59
070700               ADD 1 TO LS-HHHHMMSS-PARM1-HH
070800               SUBTRACT 60 FROM WS-TIME-WK.
070900      MOVE WS-TIME-WK2       TO LS-HHHHMMSS-PARM1-MM.
071000
071100      ADD LS-HHHHMMSS-PARM2-HH    TO LS-HHHHMMSS-PARM1-HH
071200
071300      MOVE ZEROS                TO LS-HHHHMMSS-PARM2.
071400      MOVE 00                   TO LS-DATE-REQUEST.
071500      GO TO 9999-DATE-EXIT.
071600
071700
071800 0098-FORMAT-OPTION98.
072000      MOVE  ZEROS                   TO WS-TIME-CVRT1.
072100      ADD   LS-HHHHMMSS-PARM1-SS    TO WS-TIME-CVRT1.
072200
072300      MOVE  ZEROS                   TO WS-TIME-CVRT2.
072400      MOVE  LS-HHHHMMSS-PARM1-MM    TO WS-TIME-CVRT2 (7:2).
072500      MULTIPLY WS-BY60              BY WS-TIME-CVRT2
072600      ADD   WS-TIME-CVRT2           TO WS-TIME-CVRT1.
072700
072800      MOVE  ZEROS                   TO WS-TIME-CVRT2.
072900      MOVE  LS-HHHHMMSS-PARM1-HH    TO WS-TIME-CVRT2 (5:4).
073000      MULTIPLY WS-BY3600            BY WS-TIME-CVRT2
073100      ADD   WS-TIME-CVRT2           TO WS-TIME-CVRT1.
073200
073300      MOVE  WS-TIME-CVRT1           TO LS-HHHHMMSS-PARM1.
073400      MOVE ZEROS                TO LS-HHHHMMSS-PARM2.
073500      MOVE 00                   TO LS-DATE-REQUEST.
073600      GO TO 9999-DATE-EXIT.
073700
073800 0099-FORMAT-OPTION99.
074000      MOVE  ZEROS                   TO WS-TIME-CVRT1.
074100      MOVE  LS-SSSSSSSS-PARM1       TO WS-TIME-CVRT2.
074200      DIVIDE WS-TIME-CVRT2 BY WS-BY3600 GIVING
074300                        WS-TIME-CVRT3  REMAINDER WS-TIME-CVRT4.
074400      MOVE  ZEROS                   TO LS-HHHHMMSS-PARM1.
074500      MOVE  WS-TIME-CVRT3 (5:4)     TO LS-HHHHMMSS-PARM1-HH.
074600      MOVE  WS-TIME-CVRT4           TO WS-TIME-CVRT2.
074700
074800      DIVIDE WS-TIME-CVRT2 BY WS-BY60 GIVING
074900                        WS-TIME-CVRT3  REMAINDER WS-TIME-CVRT4.
075000      MOVE  WS-TIME-CVRT3 (7:2)     TO LS-HHHHMMSS-PARM1-MM.
075100      MOVE  WS-TIME-CVRT4 (7:2)     TO LS-HHHHMMSS-PARM1-SS.
075200
075300      MOVE ZEROS                TO LS-SSSSSSSS-PARM2.
075400      MOVE 00                   TO LS-DATE-REQUEST.
075500      GO TO 9999-DATE-EXIT.
075600
075700
075800 CONVERT-TO-ENGLISH.
075900      MOVE LS-DATE TO WS-DATE.
076000      MOVE NAME-OF-MONTH (WS-MONTH) TO MONTH-NAME.
076100      MOVE NAME-LENGTH(WS-MONTH) TO WS-MONTH.                     
076200      IF LS-DATE-REQUEST = 7
076300         MOVE 3 TO WS-MONTH
076400         MOVE SPACE TO MONTH-NAME(4:1).
076500      IF NOT LS-DATE-REQUEST = 8
076600         ADD  2           TO WS-MONTH
076700         MOVE WS-DAY   TO DATE-IN-ENGLISH-W (WS-MONTH:2)
076800         ADD  2           TO WS-MONTH
076900      ELSE
077000         ADD  1           TO WS-MONTH.
077100      IF LS-DATE-REQUEST = 9
077200         MOVE '.'   TO DATE-IN-ENGLISH-W (WS-MONTH:1)
077300         GO TO 9999-DATE-EXIT.
077400      MOVE ', 19'   TO DATE-IN-ENGLISH-W (WS-MONTH:4).
077500      IF WS-YEAR IS LESS THAN 94
077600      MOVE ', 20'   TO DATE-IN-ENGLISH-W (WS-MONTH:4).
077700      ADD  4           TO WS-MONTH.
077800      MOVE WS-YEAR  TO DATE-IN-ENGLISH-W (WS-MONTH:2).
077900      GO TO 9999-DATE-EXIT.
078000 CONVERT-TO-ENGLISH-EXIT.
078100*
078200 9999-DATE-EXIT.
078300         GOBACK.
