       IDENTIFICATION DIVISION.
       PROGRAM-ID. TPS620.
       AUTHOR. J. MONAGHAN.
      ***************************************************************
      *        PRINT CHANGE OF ADDRESS LETTER BACK TO CLIENT        *
      *-------------------------------------------------------------*
      ***************************************************************
      * 05/09/17 CHANGED GUI                                     AC *
      * 11/27/00 ADDED TEMPORARY CODE TO PRINT BILLS ONLY        JM *
      * 06/09/06 don't print zip+4 info                          JM *
      ***************************************************************
       ENVIRONMENT DIVISION.
       CONFIGURATION SECTION.
       SOURCE-COMPUTER. IBM-PS2.
       OBJECT-COMPUTER. IBM-PS2.
       FILE-CONTROL.
           SELECT PRT-FILE  ASSIGN TO DYNAMIC FILESPEC                                                                  
               ORGANIZATION IS LINE SEQUENTIAL.                                                                         
           SELECT  TPS-SIGNATURE-FILE
                   ASSIGN TO DYNAMIC SIGNATURE-FILE-NAME
                   ORGANIZATION IS LINE SEQUENTIAL
                   FILE STATUS IS TPS-FILE-STATUS.
       DATA DIVISION.
       FILE SECTION.
       FD  PRT-FILE                                                                                                     
           LABEL RECORDS ARE OMITTED                                                                                    
           RECORD CONTAINS 2000 CHARACTERS.                                                                             
       01  PRT-RECORD PIC X(2000).

       FD  TPS-SIGNATURE-FILE
           DATA RECORD  IS TPS-SIGNATURE-INPUT
           LABEL RECORDS STANDARD.
       01  TPS-SIGNATURE-INPUT              PIC X(80).

       WORKING-STORAGE SECTION.

      *********** WINFORMS SCREEN DEFINITION **********

       01 CHGADDR  type TPS000.CHGADDRForm.

       01 PROCESS-2 type TPS000.PROCESS_2Form.

       01 PROCESS-2-DISPLAY-FLAG PIC 9(01) VALUE 0.

       01 CLOSE-ALL-FORMS-FLAG PIC 9(01) VALUE 0.
       01 SCREEN-NAME PIC x(10).


       01 WS-CURRENT-X PIC 9(04).
       01 WS-CURRENT-Y PIC 9(04).
       01 WS-CURRENT-XY-PARM.
         05 WS-X-PARM PIC 9(04).
         05 WS-Y-PARM PIC 9(04).
      ***************************************************


       01  TPSRESID-FLAG           PIC 9(01) VALUE 0.
           88 TPSRESID-OPEN              VALUE 1.

       01  PRT-COMMAND-1.
           10 FILLER      PIC X(05) VALUE 'COPY '.
           10 FILESPEC    PIC X(50) VALUE SPACES.
           10 FILLER      PIC X(20) VALUE ' PRN > NUL'.
       01 DIGITAL-SIGNATURE.
          10 FILLER PIC X(01) VALUE X'1B'.
          10 FILLER PIC X(11) VALUE '*p+075y300X'.
          10 FILLER PIC X(01) VALUE X'1B'.
          10 FILLER PIC X(04) VALUE ')31X'.
          10 PCL-SI PIC X(01) VALUE X'0E'.
          10 FILLER PIC X(01) VALUE  'A'.
          10 PCL-SI PIC X(01) VALUE X'0F'.
       01 RESULT           PIC 99 COMP-X.
       01 FUNCTION-35      PIC 99 COMP-X VALUE 35.
       01 NULL-PARAMETER.
          05 FILLER        PIC 99 COMP-X VALUE 0.
          05 FILLER        PIC X.
       01  ASSIGN-THE-FONT-NUMBER.
           10 FILLER PIC X(01) VALUE X'1B'.
           10 FILLER PIC X(05) VALUE '*c31D'.
       01  DESIGNATE-SECONDARY-FONT.
           10 FILLER PIC X(01) VALUE X'1B'.
           10 FILLER PIC X(04) VALUE ')31X'.
       01  DOWNLOAD-THE-FONT.
           10 FILLER     PIC X(10) VALUE 'COPY /B '.
           10 FONT-NAME  PIC X(27) VALUE SPACES.
           10 FILLER     PIC X(01) VALUE SPACE.
           10 FILLER     PIC X(20) VALUE 'PRN > NUL'.
       01  SIGNATURE-FILE-EXTENSION PIC X(04) VALUE '.SIG'.
       01  SIGNATURE-FILE-NAME.
           10 SIGNATURE-LIBRARY PIC X(13) VALUE '\TPS\FONTS\'.
           10 SIGNATURE-NAME    PIC X(10).
           10 SIGNATURE-EXT     PIC X(04) VALUE SPACES.
       01  FILL-INDEX                            PIC S9(4) COMP.
       01  LINE-SPACING.
           05 PLUS-000-Y PIC X(03) VALUE '000'.
           05 PLUS-050-Y PIC X(03) VALUE '050'.
       01  ACCOUNT-NUMBER PIC X(15) VALUE 'Account Number '.

       01 TPS-RESID-REC.
           COPY "TPSRESID.CPY".

       01 COA-WORK.
           05 CITY   PIC X(22) VALUE 'CITY  '.
           05 FILLER PIC X(02) VALUE ','.
           05 STATE  PIC X(02) VALUE 'ST'.
           05 FILLER PIC X(02) VALUE ' '.
           05 ZIP    PIC X(05) VALUE '12345'.
           05 ZIP-4-DASH PIC X(01) VALUE '-'.
           05 ZIP-4  PIC X(05) VALUE '6789'.
       01  CHANGE-OF-ADDRESS-NOTICE.
        02 RETURN-ADDRESS.
           05 FILLER PIC X(01) VALUE X'1B'.
           05 FILLER PIC X(11) VALUE '*p0150y100X'.

           05 NAME-1 PIC X(36) VALUE 'RE:ADDRESSEE LINE 1'.

           05 FILLER PIC X(01) VALUE X'1B'.
           05 FILLER PIC X(11) VALUE '*p+050y100X'.
           05 LINE-02 PIC X(36)
              VALUE 'c/o TPS Administrative Group, LLC.'.

           05 FILLER PIC X(01) VALUE X'1B'.
           05 FILLER PIC X(11) VALUE '*p+050y100X'.
           05 PO-BOX PIC X(36) VALUE 'PO-BOX'.
****************************
           05 FILLER PIC X(01) VALUE X'1B'.
           05 FILLER PIC X(11) VALUE '*p+050y100X'.
         03 CITY-STATE-AND-ZIP.
           05 CITY   PIC X(22) VALUE 'CITY  '.
           05 FILLER PIC X(01) VALUE ' '.
           05 STATE  PIC X(02) VALUE 'ST'.
           05 FILLER PIC X(02) VALUE ' '.
           05 ZIP    PIC X(05) VALUE '12345'.
           05 ZIP-4-DASH PIC X(01) VALUE '-'.
           05 ZIP-4  PIC X(05) VALUE '6789'.
****************************
        02 RECEIVE-DATE.
           05 FILLER PIC X(01) VALUE X'1B'.
           05 FILLER PIC X(12) VALUE '*p0450y0300X'.
***********05 FILLER PIC X(12) VALUE '*p0300y1310X'.
           05 THE-DATE PIC X(20) VALUE 'THE DATE ...........'.
      ****************   X(20) VALUE '12345678901234567890'.
        02 ACCOUNT-NUMBER.
           05 FILLER PIC X(01) VALUE X'1B'.
           05 FILLER PIC X(12) VALUE '*p0450y1000X'.
           05 ACCTNO PIC X(17) VALUE 'Re : Account # - '.
           05 THE-ACCT-NO PIC X(20) VALUE 'THE ACCOUNT.........'.
****************************
****************************
        02 ADDRESSOR.
           05 FILLER PIC X(01) VALUE X'1B'.
           05 PCL-L1 PIC X(11) VALUE '*p+150y300X'.
           05 LINE-1 PIC X(36) VALUE 'ADDRESSOR LINE 1'.
****************************
           05 FILLER PIC X(01) VALUE X'1B'.
           05 PCL-L2 PIC X(11) VALUE '*p+050y300X'.
           05 LINE-2 PIC X(36) VALUE 'ADDRESSOR LINE 2'.
****************************
           05 FILLER PIC X(01) VALUE X'1B'.
           05 PCL-L3 PIC X(11) VALUE '*p+050y300X'.
           05 LINE-3 PIC X(36) VALUE 'ADDRESSOR LINE 3'.
****************************
           05 FILLER PIC X(01) VALUE X'1B'.
           05 FILLER PIC X(11) VALUE '*p+050y300X'.
           05 CITY   PIC X(20) VALUE 'STATE '.
           05 FILLER PIC X(02) VALUE ','.
           05 STATE  PIC X(02) VALUE 'ST'.
           05 FILLER PIC X(01) VALUE ' '.
           05 ZIP    PIC X(05) VALUE '12345'.
           05 ZIP-4-DASH PIC X(01) VALUE '-'.
           05 ZIP-4  PIC X(05) VALUE '6789'.
****************************
           05 FILLER PIC X(01) VALUE X'1B'.
           05 FILLER PIC X(11) VALUE '*p+250y300X'.
           05 FILLER PIC X(80) VALUE 'To Whom It May Concern:'.
****************************
           05 FILLER PIC X(01) VALUE X'1B'.
           05 FILLER PIC X(11) VALUE '*p+100y300X'.
           05 FILLER PIC X(40) VALUE
              'Kindly note my change of address. Please'.
           05 FILLER PIC X(40) VALUE
              ' forward all future bills and correspond'.
           05 FILLER PIC X(40) VALUE
              'ence to me                              '.
****************************
           05 FILLER PIC X(01) VALUE X'1B'.
           05 FILLER PIC X(11) VALUE '*p+050y300X'.
           05 FILLER PIC X(40) VALUE
              'at this address:                        '.
****************************
        02 NEW-ADDRESS.
           05 FILLER PIC X(01) VALUE X'1B'.
           05 PCL-L1 PIC X(12) VALUE '*p+100y0900X'.
           05 NAME-1 PIC X(36).
****************************
           05 FILLER PIC X(01) VALUE X'1B'.
           05 PCL-L2 PIC X(12) VALUE '*p+050y0900X'.
           05 LINE-02 PIC X(36).
****************************
           05 FILLER PIC X(01) VALUE X'1B'.
           05 FILLER PIC X(11) VALUE '*p+050y900X'.
           05 LINE-03 PIC X(36).
****************************
           05 FILLER PIC X(01) VALUE X'1B'.
           05 FILLER PIC X(11) VALUE '*p+050y900X'.
           05 LINE-04 PIC X(36).
****************************
         03 FILLER.
           05 FILLER PIC X(01) VALUE X'1B'.
           05 FILLER PIC X(11) VALUE '*p+200y300X'.
           05 FILLER PIC X(40) VALUE
              'If you have any questions, please contac'.
           05 FILLER PIC X(40) VALUE
              't TPS Administrative Group at telephone '.
           05 FILLER PIC X(01) VALUE X'1B'.
           05 FILLER PIC X(11) VALUE '*p+050y300X'.
           05 FILLER                   PIC X(01) VALUE '('.
           05 PRT-OFFICE-TEL1          PIC X(03).
           05 FILLER                   PIC X(01) VALUE ')'.
           05 PRT-OFFICE-TEL2          PIC X(03).
           05 FILLER                   PIC X(01) VALUE '-'.
           05 PRT-OFFICE-TEL3          PIC X(04).
           05 FILLER                   PIC X(08) VALUE ' or fax '.
           05 FILLER                   PIC X(01) VALUE '('.
           05 PRT-OFFICE-FAX1          PIC X(03).
           05 FILLER                   PIC X(01) VALUE ')'.
           05 PRT-OFFICE-FAX2          PIC X(03).
           05 FILLER                   PIC X(01) VALUE '-'.
           05 PRT-OFFICE-FAX3          PIC X(04).
****************************
           05 FILLER PIC X(01) VALUE X'1B'.
           05 FILLER PIC X(11) VALUE '*p+100y300X'.
           05 FILLER PIC X(40) VALUE
              'Thank you for your courtesy.            '.
           05 FILLER PIC X(01) VALUE X'1B'.
           05 FILLER PIC X(11) VALUE '*p+200y300X'.
           05 FILLER PIC X(40) VALUE
              'Very truly yours,                       '.
           05 FILLER PIC X(01) VALUE X'1B'.
           05 FILLER PIC X(11) VALUE '*p+100y300X'.
           05 ROOM-FOR-SIGNATURE.
              10 FILLER PIC X(01) VALUE SPACES.
              10 FILLER PIC X(11) VALUE SPACES.
              10 FILLER PIC X(01) VALUE SPACES.
              10 FILLER PIC X(07) VALUE SPACES.
              10 PCL-SI PIC X(01) VALUE SPACES.
              10 FILLER PIC X(01) VALUE SPACES.
              10 PCL-SI PIC X(01) VALUE SPACES.
****************************
        02 ADDRESSEE.
           05 FILLER PIC X(01) VALUE X'1B'.
           05 PCL-L1 PIC X(12) VALUE '*p+150y0300X'.
           05 LINE-1 PIC X(36) VALUE 'RE:ADDRESSEE LINE 1'.
****************************
           05 FILLER PIC X(01) VALUE X'1B'.
           05 PCL-L2 PIC X(12) VALUE '*p+050y0300X'.
           05 LINE-2 PIC X(36) VALUE 'ADDRESSEE LINE 2'.
****************************
           05 FILLER PIC X(01) VALUE X'1B'.
           05 PCL-L3 PIC X(12) VALUE '*p+050y0300X'.
           05 LINE-3 PIC X(36) VALUE 'ADDRESSEE LINE 3'.
****************************
           05 FILLER PIC X(01) VALUE X'1B'.
           05 FILLER PIC X(12) VALUE '*p+050y0300X'.
           05 CITY   PIC X(20) VALUE 'CITY '.
           05 FILLER PIC X(02) VALUE ','.
           05 STATE  PIC X(02) VALUE 'ST'.
           05 FILLER PIC X(01) VALUE ' '.
           05 ZIP    PIC X(05) VALUE '12345'.
           05 ZIP-4-DASH PIC X(01) VALUE '-'.
           05 ZIP-4  PIC X(05) VALUE '6789'.
        02 BACK-OF-THE-PAGE.
           05 FILLER PIC X(01) VALUE X'0C'.
****************************
           05 FILLER PIC X(01) VALUE X'1B'.
           05 FILLER PIC X(13) VALUE '*p1000y900X'.
           05 FILLER PIC X(10) VALUE '- - - - - '.
           05 FILLER PIC X(01) VALUE X'0C'.
****************************
       01  PCL-SETUP.
           05 FILLER PIC X(01) VALUE X'1B'.
           05 FILLER PIC X(04) VALUE  '&l0O'.
           05 FILLER PIC X(01) VALUE X'1B'.
           05 FILLER PIC X(04) VALUE  '&l6D'.
           05 FILLER PIC X(01) VALUE X'1B'.
           05 FILLER PIC X(16) VALUE  '(s1p12v1s0b4101T'.
           05 FILLER PIC X(01) VALUE X'1B'.
           05 FILLER PIC X(05) VALUE  '&a25L'.
 **********ENBABLE DUPLEX PRINTING - JPC
         02 DISABLE-DUPLEX-PRINTING.
           05 FILLER PIC X(01) VALUE X'1B'.
           05 FILLER PIC X(04) VALUE  '&l1S'.
       01  NEW-PAGE PIC X VALUE X'0C'.

           COPY "TPSFILES.CPY".
           COPY "KEYVALUE.CPY".
           COPY "PCLVALUE.CPY".

       01  TPS-RECUR-REC.
           COPY "TPSRECUR.CPY".

           COPY "TPSKEYS.CPY".

       01 CALL-TPSDATES.
          05 FILLER                            PIC X(02) VALUE '07'.
         03 DATE-IN-ENGLISH.
          05 NUMBER-DATE PIC 999999.
          05 NUMBER-DATE-R REDEFINES NUMBER-DATE.
           10 NUMBER-Y                           PIC 99.
           10 NUMBER-MD                          PIC 9999.
          05  FILLER                             PIC X(12).

       01  PROGRAM-NAMES.
        10 GUISCREEN   PIC X(08) VALUE 'GS    '.
        10 SCREENIO    PIC X(08) VALUE 'SCRNIO'.
        10 TPSIO006    PIC X(08) VALUE 'TPSIO006'.
        10 TPSIO004    PIC X(08) VALUE 'TPSIO004'.
        10 TPSIORCR    PIC X(08) VALUE 'TPSIORCR'.
        10 TPSIOERR    PIC X(08) VALUE 'TPSIOERR'.
        10 TPSDATES    PIC X(08) VALUE 'TPSDATES'.
        10 FLOATBIG    PIC X(08) VALUE 'FLOATBIG'.
        10 FILLER      PIC X(08) VALUE HIGH-VALUES.
       01  PROGRAM-NAMES-R REDEFINES PROGRAM-NAMES.
        10 PROGRAM-NAME PIC X(08) OCCURS 20 TIMES.


       01  DATE-REQUEST-PARAMETER.
        10 FILLER                                PIC 99 VALUE 06.
        10 DATE-REQUEST-DATE                     PIC X(20) VALUE SPACES.
       01  TODAYS-DATE PIC 999999.
       01  TODAYS-DATE-R REDEFINES TODAYS-DATE.
           10 TODAYS-YEAR                        PIC 99.
           10 TODAYS-MONTH                       PIC 99.
           10 TODAYS-DAY                         PIC 99.
       01  THE-INDEX                      PIC S9(4) COMP VALUE ZERO.
       01  OFFSET-INDEX                          PIC S9(4) COMP.
       01  TPS-FILE-STATUS                       PIC XX.
           88  TPS-CARRIER-FILE-OK VALUE '00', '02'.

       LINKAGE SECTION.

       01 TPS-LOGON.
           COPY "TPSLOGON.CPY".
       01 TPS-PROFILE.
           COPY "TPSPROFL.CPY".
       01 TPS-RESIDENCE-REC.
           COPY "TPSRESID.CPY".

       01 CURRENT-XY-PARAMETERS PIC 9(08).

       PROCEDURE DIVISION USING TPS-LOGON
                                TPS-PROFILE
                                TPS-RESIDENCE-REC
                                CURRENT-XY-PARAMETERS.
       TPS620-BEGIN.

      *********** INITIALIZE WINFORMS SCREENS **************
       
       set CHGADDR to new TPS000.CHGADDRForm().
       set PROCESS-2 to new TPS000.PROCESS_2Form().

      ******************************************************



           

           MOVE CURRENT-XY-PARAMETERS(1:4) TO WS-CURRENT-X
             WS-X-PARM.
           MOVE CURRENT-XY-PARAMETERS(5:4) TO WS-CURRENT-Y
             WS-Y-PARM.


          ACCEPT DATE-REQUEST-DATE(1:6) FROM DATE.
          CALL TPSDATES   USING DATE-REQUEST-PARAMETER.
          MOVE DATE-REQUEST-DATE TO THE-DATE.
          MOVE 'PRESS ENTER TO CONTINUE... OR END TO GO BACK.'                             00146100
                           TO CHGADDR::MENU-LINE.                                          00146200

           SET CHGADDR::X-POINT TO WS-X-PARM.
           SET CHGADDR::Y-POINT TO WS-Y-PARM.
           INVOKE CHGADDR::ShowDialog.
           MOVE CHGADDR::SCREEN-NAME TO SCREEN-NAME.
           MOVE CHGADDR::Location::X TO WS-X-PARM
             WS-CURRENT-X.
           MOVE CHGADDR::Location::Y TO WS-Y-PARM
             WS-CURRENT-Y.


           IF CHGADDR::KEY-PRESSED = "End Key"
               IF PROCESS-2-DISPLAY-FLAG = 1
                   invoke PROCESS-2::Hide
                   MOVE 0 TO PROCESS-2-DISPLAY-FLAG
               END-IF
               INITIALIZE CURRENT-XY-PARAMETERS
               MOVE WS-CURRENT-X TO CURRENT-XY-PARAMETERS(1:4)
               MOVE WS-CURRENT-Y TO CURRENT-XY-PARAMETERS(5:4)
               IF CLOSE-ALL-FORMS-FLAG = 0
                   SET CHGADDR::KEY-PRESSED TO "End Key"
                   INVOKE CHGADDR::Close
                   MOVE 1 TO CLOSE-ALL-FORMS-FLAG
               END-IF
               GOBACK
           END-IF.


           IF PROCESS-2-DISPLAY-FLAG = 0
               SET PROCESS-2 TO NEW TPS000.PROCESS_2Form()
               SET PROCESS-2::X-POINT TO WS-X-PARM
               SET PROCESS-2::Y-POINT TO WS-Y-PARM
               INVOKE PROCESS-2::Show
               MOVE 1 TO PROCESS-2-DISPLAY-FLAG
           END-IF.



          PERFORM GET-NEW-ADDRESS THRU GET-NEW-ADDRESS-EXIT.
          PERFORM GET-OLD-ADDRESS THRU GET-OLD-ADDRESS-EXIT.

          PERFORM 0100-READ-RECUR-FILE
                                  THRU 0100-READ-RECUR-FILE-EXIT.

       TPS620-END.

          MOVE F-PRIME      TO FILE-KEY.
          MOVE F-CLOSE      TO FILE-ACTION.
          CALL TPSIORCR USING FILE-REQUEST TPS-RECUR-REC.
          IF NOT A-SUCCESSFUL-OPERATION
             MOVE ' RECUR  '   TO FILE-NAME
             MOVE 'TPS620-CLO' TO FILE-TEXT
             CALL TPSIOERR USING FILE-REQUEST
                                   WS-CURRENT-XY-PARM
             GO TO TPS620-END.

           IF PROCESS-2-DISPLAY-FLAG = 1
               invoke PROCESS-2::Hide
               MOVE 0 TO PROCESS-2-DISPLAY-FLAG
           END-IF.
           INITIALIZE CURRENT-XY-PARAMETERS.
           MOVE WS-CURRENT-X TO CURRENT-XY-PARAMETERS(1:4).
           MOVE WS-CURRENT-Y TO CURRENT-XY-PARAMETERS(5:4).

           IF CLOSE-ALL-FORMS-FLAG = 0
               SET CHGADDR::KEY-PRESSED TO "End Key"
               INVOKE CHGADDR::Close
               MOVE 1 TO CLOSE-ALL-FORMS-FLAG
           END-IF.

          GOBACK.

       0100-READ-RECUR-FILE.
      *   DISPLAY "TPSCOALETTER" UPON ENVIRONMENT-NAME
      *   ACCEPT FILESPEC FROM ENVIRONMENT-VALUE
           MOVE '\tps\prod\files\tps1010c.pcl' to FILESPEC.
          OPEN OUTPUT PRT-FILE.
          WRITE PRT-RECORD FROM PCL-RESET.
          WRITE PRT-RECORD FROM PCL-SETUP.

          MOVE F-PRIME      TO FILE-KEY.
          MOVE F-OPEN-INPUT TO FILE-ACTION.
          CALL TPSIORCR USING FILE-REQUEST TPS-RECUR-REC.
          IF NOT A-SUCCESSFUL-OPERATION
             MOVE ' RECUR  '   TO FILE-NAME
             MOVE 'TPS620-OPN' TO FILE-TEXT
             CALL TPSIOERR USING FILE-REQUEST
                                   WS-CURRENT-XY-PARM
             GO TO TPS620-END.

          MOVE F-PRIME TO FILE-KEY.
          MOVE F-START TO FILE-ACTION.
          MOVE SPACES        TO RECUR-KEY.
          MOVE CLNT-PROFILE-ACCT-NO TO RECUR-ACCT-NO
          MOVE CLNT-PROFILE-SUB-ACCT TO RECUR-SUB-ACCT.
          CALL TPSIORCR USING FILE-REQUEST TPS-RECUR-REC.
          IF NO-RECORD-WAS-FOUND
             GO TO 0100-READ-RECUR-FILE-EXIT.
          IF NOT A-SUCCESSFUL-OPERATION
             MOVE ' RECUR  ' TO FILE-NAME
             MOVE 'TPS620-SBR' TO FILE-TEXT
             CALL TPSIOERR USING FILE-REQUEST
                                   WS-CURRENT-XY-PARM
             GO TO TPS620-END.

       READ-RECUR-CONT.
          MOVE F-PRIME TO FILE-KEY.
          MOVE F-READ-NEXT TO FILE-ACTION.
          CALL TPSIORCR USING FILE-REQUEST TPS-RECUR-REC.
          IF END-OF-FILE-WAS-REACHED
             GO TO 0100-READ-RECUR-FILE-EXIT.
          IF NOT A-SUCCESSFUL-OPERATION
             MOVE ' RECUR  ' TO FILE-NAME
             MOVE 'TPS620-BRN' TO FILE-TEXT
             CALL TPSIOERR USING FILE-REQUEST
                                   WS-CURRENT-XY-PARM
             GO TO TPS620-END.

          IF RECUR-ACCT-NO > CLNT-PROFILE-ACCT-NO
             GO TO 0100-READ-RECUR-FILE-EXIT.

      *JM11/00  ******** PROCESS BILLS ONLY ***********
      *   IF RECUR-CHART-ACCT-01(1:2) NOT = '02' AND '11' AND
      *                                     '31' AND '33'
      *      GO TO READ-RECUR-CONT.

      ******* USE NAME FROM RECUR-ADDRESEE-NAME *********
          MOVE RECUR-ADDRESEE-NAME      TO NAME-1 OF NEW-ADDRESS
                                           LINE-1 OF ADDRESSEE
                                           NAME-1 OF RETURN-ADDRESS.

          IF RECUR-ADDRESOR-ADDRL1 = SPACES AND
             RECUR-ADDRESOR-ADDRL2 = SPACES
             GO TO READ-RECUR-CONT.

          MOVE RECUR-ADDRESOR-NAME  TO LINE-1 OF ADDRESSOR.

          MOVE RECUR-ADDRESOR-ADDRL1 TO LINE-2 OF ADDRESSOR.
          MOVE PLUS-000-Y TO PCL-L2 OF ADDRESSOR(4:3)
          IF   RECUR-ADDRESOR-ADDRL1 > SPACES
               MOVE PLUS-050-Y TO PCL-L2 OF ADDRESSOR(4:3)
          END-IF.

          MOVE RECUR-ADDRESOR-ADDRL2 TO LINE-3 OF ADDRESSOR.
          MOVE PLUS-000-Y TO PCL-L3 OF ADDRESSOR(4:3)
          IF   RECUR-ADDRESOR-ADDRL2 > SPACES
               MOVE PLUS-050-Y TO PCL-L3 OF ADDRESSOR(4:3)
          END-IF.

          PERFORM VARYING FILL-INDEX FROM 24 BY -1 UNTIL
             RECUR-ADDRESOR-CITY (FILL-INDEX:1) > SPACE
             OR FILL-INDEX < 1
                MOVE LOW-VALUE TO RECUR-ADDRESOR-CITY
                (FILL-INDEX:1)
          END-PERFORM.
          MOVE RECUR-ADDRESOR-CITY  TO CITY OF ADDRESSOR.
          MOVE RECUR-ADDRESOR-STATE TO STATE OF ADDRESSOR.
          MOVE SPACES TO ZIP   OF ADDRESSOR
                         ZIP-4-DASH OF ADDRESSOR
                         ZIP-4 OF ADDRESSOR.
          IF   RECUR-ADDRESOR-ZIPCODE(1:5) > '00000'
               MOVE RECUR-ADDRESOR-ZIPCODE(1:5) TO ZIP OF ADDRESSOR
          END-IF.
          IF   RECUR-ADDRESOR-ZIPCODE(6:4) > '0000'
               MOVE '-'             TO ZIP-4-DASH OF ADDRESSOR
               MOVE RECUR-ADDRESOR-ZIPCODE(6:4)
                                    TO ZIP-4 OF ADDRESSOR
          END-IF.

          IF RECUR-PAYEE-ACCOUNT-NUMBER = SPACES
             MOVE SPACES       TO ACCTNO
                                  THE-ACCT-NO
          ELSE
             MOVE 'Re: Account # - '         TO ACCTNO
             MOVE RECUR-PAYEE-ACCOUNT-NUMBER TO THE-ACCT-NO.

          WRITE PRT-RECORD FROM CHANGE-OF-ADDRESS-NOTICE.

          GO TO READ-RECUR-CONT.

       0100-READ-RECUR-FILE-EXIT.
          WRITE PRT-RECORD FROM DISABLE-DUPLEX-PRINTING.
          WRITE PRT-RECORD FROM PCL-RESET.
          CLOSE PRT-FILE.
          DISPLAY PRT-COMMAND-1 UPON COMMAND-LINE.
          CALL X'91' USING RESULT FUNCTION-35 NULL-PARAMETER.
          EXIT.

       FILE-ERROR.
           CALL   TPSIOERR USING FILE-REQUEST.
           CANCEL TPSIOERR.
       FILE-ERROR-EXIT. EXIT.


       GET-NEW-ADDRESS.

            MOVE CLNT-PROFILE-ACCT-NO OF TPS-PROFILE
                                   TO RESI-ACCT-NO OF TPS-RESID-REC
            MOVE CLNT-PROFILE-SUB-ACCT OF TPS-PROFILE
                                  TO RESI-SUB-ACCT OF TPS-RESID-REC
            MOVE 01        TO RESI-RESIDENC-NUMBER OF TPS-RESID-REC
      ***** FILE SHOULD BE OPEN, IF NOT OPEN IT *****
            SET FR-PRIME       TO TRUE
            SET FR-OPEN-INPUT  TO TRUE
            CALL TPSIO006 USING FILE-REQUEST TPS-RESID-REC
            IF FILE-STATUS NOT = '00' AND '05'
               MOVE 'RESID' TO FILE-NAME
               MOVE 'TPS620-OPEN' TO FILE-TEXT
               PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
               GO TO GET-NEW-ADDRESS-EXIT.
            SET FR-PRIME TO TRUE
            SET FR-START TO TRUE
            CALL TPSIO006 USING FILE-REQUEST TPS-RESID-REC.
            IF NOT A-SUCCESSFUL-OPERATION
               MOVE 'RESID' TO FILE-NAME
               MOVE 'TPS620-START' TO FILE-TEXT
               PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
               GO TO GET-NEW-ADDRESS-EXIT.

       NEW-ADDRESS-CONT.

            SET FR-READ-NEXT TO TRUE
            CALL TPSIO006 USING FILE-REQUEST TPS-RESID-REC.
            IF NOT A-SUCCESSFUL-OPERATION
               MOVE 'RESID' TO FILE-NAME
               MOVE 'TPS620-READN' TO FILE-TEXT
               PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
               GO TO GET-NEW-ADDRESS-EXIT.

          IF RESI-RESIDENC-TYPE OF TPS-RESID-REC(1:7) NOT = 'Primary'
               ADD 1      TO RESI-RESIDENC-NUMBER OF TPS-RESID-REC
               GO TO NEW-ADDRESS-CONT.


          PERFORM VARYING FILL-INDEX FROM 24 BY -1 UNTIL
             RESI-ADDRESS-CITY OF TPS-RESID-REC(FILL-INDEX:1) > SPACE
             OR FILL-INDEX < 1
                MOVE LOW-VALUE TO RESI-ADDRESS-CITY OF TPS-RESID-REC
                (FILL-INDEX:1)
          END-PERFORM.

       MOVE-THE-NEW-ADDRESS.

          MOVE RESI-ADDRESS-LINE-01 OF TPS-RESID-REC
                                     TO LINE-02 OF NEW-ADDRESS.
          MOVE RESI-ADDRESS-LINE-02 OF TPS-RESID-REC
                                     TO LINE-03 OF NEW-ADDRESS.
          MOVE RESI-ADDRESS-CITY  OF TPS-RESID-REC
                                     TO CITY OF COA-WORK.
          MOVE RESI-ADDRESS-STATE OF TPS-RESID-REC
                                     TO STATE OF COA-WORK.
          MOVE RESI-ADDRESS-ZIPCODE OF TPS-RESID-REC(1:5)
                                     TO ZIP   OF COA-WORK.
      *06/09/06 ******* don't print zip+4 *******
          MOVE SPACES                TO ZIP-4-DASH OF COA-WORK.
          MOVE SPACES                TO ZIP-4 OF COA-WORK.
      *   MOVE RESI-ADDRESS-ZIPCODE OF TPS-RESID-REC(6:4)
      *                              TO ZIP-4 OF COA-WORK.
          IF RESI-ADDRESS-LINE-02 OF TPS-RESID-REC > SPACES
             MOVE COA-WORK           TO LINE-04 OF NEW-ADDRESS
          ELSE
             MOVE COA-WORK           TO LINE-03 OF NEW-ADDRESS.

      ***********  ADDRESSEE ADDRESS ************

          MOVE RESI-ADDRESS-LINE-01 OF TPS-RESID-REC
            TO LINE-2 OF ADDRESSEE.
          MOVE PLUS-000-Y TO PCL-L2 OF ADDRESSEE(4:3)
          IF   RESI-ADDRESS-LINE-01 OF TPS-RESID-REC > SPACES
               MOVE PLUS-050-Y TO PCL-L2 OF ADDRESSEE(4:3)
          END-IF.

          MOVE RESI-ADDRESS-LINE-02 OF TPS-RESID-REC
            TO LINE-3 OF ADDRESSEE.
          MOVE PLUS-000-Y TO PCL-L3 OF ADDRESSEE(4:3)
          IF   RESI-ADDRESS-LINE-02 OF TPS-RESID-REC > SPACES
               MOVE PLUS-050-Y TO PCL-L3 OF ADDRESSEE(4:3)
          END-IF.

          PERFORM VARYING FILL-INDEX FROM 24 BY -1
             UNTIL RESI-ADDRESS-CITY OF TPS-RESID-REC(FILL-INDEX:1)
                        IS GREATER THAN SPACE
                OR FILL-INDEX < 1
             MOVE LOW-VALUE
                TO RESI-ADDRESS-CITY OF TPS-RESID-REC(FILL-INDEX:1)
          END-PERFORM.
          MOVE RESI-ADDRESS-CITY OF TPS-RESID-REC
            TO CITY OF ADDRESSEE.

          MOVE RESI-ADDRESS-STATE OF TPS-RESID-REC
            TO STATE OF ADDRESSEE.
          MOVE SPACES TO ZIP   OF ADDRESSEE
                         ZIP-4-DASH OF ADDRESSEE
                         ZIP-4 OF ADDRESSEE.
          IF RESI-ADDRESS-ZIPCODE OF TPS-RESID-REC (1:5) > '00000'
               MOVE RESI-ADDRESS-ZIPCODE OF TPS-RESID-REC (1:5)
                 TO ZIP OF ADDRESSEE
          END-IF.
      *06/09/06 ****** don't print zip+4 *******
      *   IF RESI-ADDRESS-ZIPCODE OF TPS-RESID-REC(6:4) > '0000'
      *        MOVE '-'           TO ZIP-4-DASH OF ADDRESSEE
      *        MOVE RESI-ADDRESS-ZIPCODE OF TPS-RESID-REC(6:4)
      *          TO ZIP-4 OF ADDRESSEE
      *   END-IF.

       GET-NEW-ADDRESS-EXIT. EXIT.

       GET-OLD-ADDRESS.

          MOVE 95        TO RESI-RESIDENC-NUMBER OF TPS-RESID-REC
          SET FR-READ TO TRUE
          CALL TPSIO006 USING FILE-REQUEST TPS-RESID-REC.
          IF NOT A-SUCCESSFUL-OPERATION
             MOVE 'RESID' TO FILE-NAME
             MOVE 'TPS620-READ2' TO FILE-TEXT
             PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
             GO TO GET-NEW-ADDRESS-EXIT.

          MOVE RESI-ADDRESS-LINE-01 OF TPS-RESID-REC
                                     TO LINE-02 OF RETURN-ADDRESS.
          MOVE RESI-ADDRESS-LINE-02 OF TPS-RESID-REC
                                     TO PO-BOX OF RETURN-ADDRESS.

          PERFORM VARYING FILL-INDEX FROM 24 BY -1 UNTIL
             RESI-ADDRESS-CITY OF TPS-RESID-REC(FILL-INDEX:1) > SPACE
             OR FILL-INDEX < 1
                MOVE LOW-VALUE TO RESI-ADDRESS-CITY OF TPS-RESID-REC
                (FILL-INDEX:1)
          END-PERFORM.
          MOVE RESI-ADDRESS-CITY  OF TPS-RESID-REC
                                     TO CITY OF COA-WORK.
          MOVE RESI-ADDRESS-STATE OF TPS-RESID-REC
                                     TO STATE OF COA-WORK.
          MOVE RESI-ADDRESS-ZIPCODE OF TPS-RESID-REC(1:5)
                                     TO ZIP   OF COA-WORK.
          MOVE '-'                   TO ZIP-4-DASH OF COA-WORK.
          MOVE RESI-ADDRESS-ZIPCODE OF TPS-RESID-REC(6:4)
                                     TO ZIP-4 OF COA-WORK.

          MOVE COA-WORK      TO CITY-STATE-AND-ZIP OF RETURN-ADDRESS.

      ***** MOVE OFFICE TEL AND FAX TO LETTER *****
          MOVE RESI-PRIME-PHONE-NUMBER OF TPS-RESID-REC(1:3)
                                       TO PRT-OFFICE-TEL1.
          MOVE RESI-PRIME-PHONE-NUMBER OF TPS-RESID-REC(4:3)
                                       TO PRT-OFFICE-TEL2
          MOVE RESI-PRIME-PHONE-NUMBER OF TPS-RESID-REC(7:4)
                                       TO PRT-OFFICE-TEL3.
          MOVE RESI-FAX-PHONE-NUMBER OF TPS-RESID-REC(1:3)
                                     TO PRT-OFFICE-FAX1.
          MOVE RESI-FAX-PHONE-NUMBER OF TPS-RESID-REC(4:3)
                                     TO PRT-OFFICE-FAX2.
          MOVE RESI-FAX-PHONE-NUMBER OF TPS-RESID-REC(7:4)
                                     TO PRT-OFFICE-FAX3.

       GET-OLD-ADDRESS-EXIT. EXIT.


