*******970611  1530  CHECKIN TPS600.CBL JJM
*******970611  1242  CHECKOUT TPS600.CBL JJM
*******970609  1919  CHECKIN TPS600.CBL JJM
       IDENTIFICATION DIVISION.
       PROGRAM-ID. TPS600.
       AUTHOR. JIM MONAGHAN.
      *****************************************************************
      *  SHOW START & END DATES FOR WEEKLY DIARIES THAT HAVE BEEN RUN *
      *  IN THE PAST. SELECT THE DATES AND PASS THEM TO TPS1010A,     *
      *  TO RERUN DIARY REPORTS.                                      *
      *****************************************************************
      * 06/11/97 CLEAR WS-IND FIELD ALONG WITH TABLES              JM *
      *****************************************************************
       ENVIRONMENT DIVISION.
       CONFIGURATION SECTION.
       SOURCE-COMPUTER. IBM-PS2.
       OBJECT-COMPUTER. IBM-PS2.

       DATA DIVISION.

       WORKING-STORAGE SECTION.

      *******WINFORMS SCREEN DEFINITION *****

       01 TPS1010R  type TPS000.TPS1010RForm.
       01 TPS1010M  type TPS000.TPS1010MForm.

       01 CLOSE-ALL-FORMS-FLAG PIC 9(01) VALUE 0.
       01 SCREEN-NAME PIC x(10).

       01 WS-CURRENT-X                            PIC 9(04).
       01 WS-CURRENT-Y                            PIC 9(04).
       01 WS-CURRENT-XY-PARM.
          05 WS-X-PARM                            PIC 9(04).
          05 WS-Y-PARM                            PIC 9(04).

       COPY "ds-cntrl.v1".

       01 TPS1010R-IDX                            PIC 9(02).
       01 THE-IDX PIC 9(02).

**********************************************************

       01 PROGRAM-NAMES.
          10 TPSIOERR    PIC X(08) VALUE 'TPSIOERR'.
          10 TPSIO024    PIC X(08) VALUE 'TPSIO024'.
          10 TPSDATES    PIC X(08) VALUE 'TPSDATES'.
      ************** SCREENIO COPYBOOK ***************


       01  DR.
           COPY "TPSDIARY.CPY".

           COPY "TPSFILES.CPY".
           COPY "KEYVALUE.CPY".
           COPY "PCL5VALU.CPY".
           COPY "CALLDATE.CPY".

       01 OPEN-FLAGS.
          05 TPSDIARY-FLAG            PIC 9(01) VALUE 0.
             88 TPSDIARY-OPEN            VALUE 1.

       01 CALL-TPSDATES-NEXT-DAY.
          05 FILLER                            PIC X(02) VALUE '21'.
          05 NEXT-DAY                          PIC 9(08).
          05 1-DAY                             PIC 999 VALUE 1.
          05 FILLER                            PIC X(07).

       01 WS-DATE-YYMMDD.
          10 WS-DATE-YY            PIC 9(02).
          10 WS-DATE-MM            PIC 9(02).
          10 WS-DATE-DD            PIC 9(02).

       01 WS-DATE-CCYYMMDD.
          10 WS-DATE-CC            PIC 9(02).
          10 WS-DATE-YY            PIC 9(02).
          10 WS-DATE-MM            PIC 9(02).
          10 WS-DATE-DD            PIC 9(02).

       01 FIRST-RECORD             PIC X(01) VALUE 'Y'.
       01 WS-IND                   PIC 9(02) VALUE ZERO.

       01 WS-TABLE-DATES              PIC X(240).
       01 TABLE-DATES REDEFINES WS-TABLE-DATES OCCURS 12 TIMES.
          10 FR-DATE-MM               PIC X(02).
          10 FILL1                    PIC X(01).
          10 FR-DATE-DD               PIC X(02).
          10 FILL2                    PIC X(01).
          10 FR-DATE-YY               PIC X(02).
          10 FILL3                    PIC X(03).
          10 TO-DATE-MM               PIC X(02).
          10 FILL4                    PIC X(01).
          10 TO-DATE-DD               PIC X(02).
          10 FILL5                    PIC X(01).
          10 TO-DATE-YY               PIC X(02).
          10 FILLER                   PIC X(01).

       01 WS-TABLE-KEY                PIC X(240).
       01 TABLE-KEY REDEFINES WS-TABLE-KEY OCCURS 12 TIMES.
          10 TABLE-ACCT-NO            PIC X(10).
          10 TABLE-SUB-ACCT           PIC X(02).
          10 TABLE-DATE-OF-REPORT     PIC X(08).


       LINKAGE SECTION.

       01 TPS-PROFILE.
             COPY TPSPROFL.CPY.

       01 RERUN-DATES.
        03 TPS-MAIL-START-KEY.
          05 START-ACCT-NO             PIC 9(10).
          05 START-SUB-ACCT            PIC 9(02).
          05 START-MAIL-DATE           PIC 9(08).
          05 START-MAIL-REC            PIC S9(05) COMP-3.
        03 TPS-MAIL-END-KEY.
          05 END-ACCT-NO               PIC 9(10).
          05 END-SUB-ACCT              PIC 9(02).
          05 END-MAIL-DATE             PIC 9(08).
          05 END-MAIL-REC              PIC S9(05) COMP-3.

       01 RERUN-IND                   PIC X(01).

       01 CURRENT-XY-PARAMETERS       PIC 9(08).

       PROCEDURE DIVISION USING TPS-PROFILE
                                RERUN-DATES
                                RERUN-IND
                                CURRENT-XY-PARAMETERS.

       0001-BEGIN.

            
      ****** INITIALIZE WINFORMS SCREENS ******

       set TPS1010R to new TPS000.TPS1010RForm().
       set TPS1010M to new TPS000.TPS1010MForm().

      ********************************************* 

           INITIALIZE DS-CONTROL-BLOCK.
           INITIALIZE DS-INPUT-FIELDS.
           MOVE CURRENT-XY-PARAMETERS(1:4) TO WS-CURRENT-X
                                              WS-X-PARM.
           MOVE CURRENT-XY-PARAMETERS(5:4) TO WS-CURRENT-Y
                                              WS-Y-PARM.

          ACCEPT WS-DATE-YYMMDD       FROM DATE.
          INITIALIZE WS-DATE-REQUEST.
          MOVE 01                     TO WS-DATE-PARAM.
          MOVE WS-DATE-YYMMDD         TO WS-DATE-REFORM.
          CALL TPSDATES USING WS-DATE-REQUEST.
          MOVE WS-DATE-REFORM-LEN08   TO WS-DATE-CCYYMMDD.

      ******** READ TPSDIARY AND FILL SCREEN **********
          MOVE CLNT-PROFILE-ACCT-NO   TO DIARY-RPT-ACCT-NO.
          MOVE CLNT-PROFILE-SUB-ACCT  TO DIARY-RPT-SUB-ACCT.
          MOVE WS-DATE-CCYYMMDD       TO DIARY-RPT-DATE-OF-REPORT.

          IF NOT TPSDIARY-OPEN
             MOVE 1             TO TPSDIARY-FLAG
             MOVE F-PRIME       TO FILE-KEY
             MOVE F-OPEN-INPUT  TO FILE-ACTION
             CALL TPSIO024 USING FILE-REQUEST DR
             IF FILE-STATUS NOT = '00' AND '05'
                MOVE 'DIARY ' TO FILE-NAME
                MOVE 'TPS600-OPN' TO FILE-TEXT
                PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
                GO TO EXIT-THE-MODULE.

          MOVE F-PRIME     TO FILE-KEY.
          MOVE F-START-LOW TO FILE-ACTION.
          CALL TPSIO024 USING FILE-REQUEST DR.
          IF NOT A-SUCCESSFUL-OPERATION
             MOVE ' DIARY  ' TO FILE-NAME
             MOVE 'TPS600-SBR' TO FILE-TEXT
             PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
             GO TO EXIT-THE-MODULE.

          INITIALIZE WS-IND, WS-TABLE-DATES, WS-TABLE-KEY.

       0010-READ-RECS.

      **** SHOW LATEST DATE FIRST ON SCREEN ****
          MOVE F-PRIME         TO FILE-KEY.
          MOVE F-READ-PREVIOUS TO FILE-ACTION.
          CALL TPSIO024 USING FILE-REQUEST DR.
          IF END-OF-FILE-WAS-REACHED
             GO TO 0010-EXIT.
          IF NOT A-SUCCESSFUL-OPERATION
             MOVE ' DIARY  '   TO FILE-NAME
             MOVE 'TPS600-BRN' TO FILE-TEXT
             PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
             GO TO EXIT-THE-MODULE.

          IF FIRST-RECORD = 'Y'
             MOVE 'N'          TO FIRST-RECORD
             IF DIARY-RPT-ACCT-NO  NOT = CLNT-PROFILE-ACCT-NO OR
                DIARY-RPT-SUB-ACCT NOT = CLNT-PROFILE-SUB-ACCT
                MOVE 'NO REC FOUND'       TO FILE-NAME
                MOVE CLNT-PROFILE-ACCT-NO TO FILE-TEXT
                PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
                GO TO EXIT-THE-MODULE.

          IF DIARY-RPT-ACCT-NO      = CLNT-PROFILE-ACCT-NO AND
             DIARY-RPT-SUB-ACCT     = CLNT-PROFILE-SUB-ACCT
             NEXT SENTENCE
          ELSE
             GO TO 0010-EXIT.

          IF DIARY-RPT-SCHEDULE = 99 OR
             DIARY-RPT-END-DATE = ZERO
             GO TO 0010-READ-RECS.

          ADD 1                     TO WS-IND.
      ***** BUILD DISPLAY TABLE *******
          MOVE DIARY-RPT-START-MM   TO FR-DATE-MM(WS-IND).
          MOVE DIARY-RPT-START-DD   TO FR-DATE-DD(WS-IND).
          MOVE DIARY-RPT-START-YY   TO FR-DATE-YY(WS-IND).
          MOVE DIARY-RPT-END-MM     TO TO-DATE-MM(WS-IND).
          MOVE DIARY-RPT-END-DD     TO TO-DATE-DD(WS-IND).
          MOVE DIARY-RPT-END-YY     TO TO-DATE-YY(WS-IND).
          MOVE '/'                  TO FILL1(WS-IND), FILL2(WS-IND),
                                       FILL4(WS-IND), FILL5(WS-IND).
      ***** BUILD LOOKUP TABLE TO READ SELECTED RECORD *******
          MOVE DIARY-RPT-ACCT-NO    TO TABLE-ACCT-NO(WS-IND).
          MOVE DIARY-RPT-SUB-ACCT   TO TABLE-SUB-ACCT(WS-IND).
          MOVE DIARY-RPT-DATE-OF-REPORT
                                    TO TABLE-DATE-OF-REPORT(WS-IND).

          IF WS-IND = 12
             GO TO 0010-EXIT
          ELSE
             GO TO 0010-READ-RECS.

       0010-EXIT.   EXIT.

       0020-DISPLAY-TABLE.

          IF WS-IND = ZERO
             GO TO EXIT-THE-MODULE.


           MOVE 0 TO TPS1010R-IDX.
           PERFORM VARYING THE-IDX FROM 1 BY 1
             UNTIL THE-IDX > 12
               MOVE TABLE-DATES(THE-IDX) TO
                 TPS1010R::RERUN-DATES(TPS1010R-IDX)
                 COMPUTE TPS1010R-IDX = TPS1010R-IDX + 1
           END-PERFORM.
          MOVE 'PUT CURSOR ON DATES AND HIT ENTER KEY'
                                     TO TPS1010R::MENU-LINE.

           MOVE 1 TO TPS1010M::SPLASH-FLAG.
           SET TPS1010M::X-POINT TO WS-X-PARM.
           SET TPS1010M::Y-POINT TO WS-Y-PARM.
           INVOKE TPS1010M::Show.
           MOVE TPS1010M::Location::X TO WS-X-PARM
                                         WS-CURRENT-X.
           MOVE TPS1010M::Location::Y TO WS-Y-PARM
                                         WS-CURRENT-Y.
           SET TPS1010R::X-POINT TO WS-X-PARM.
           SET TPS1010R::Y-POINT TO WS-Y-PARM.
           INVOKE TPS1010R::ShowDialog.
           MOVE TPS1010R::SCREEN-NAME TO SCREEN-NAME.
           MOVE 0 TO TPS1010M::SPLASH-FLAG.
           INVOKE TPS1010M::Hide.


          IF TPS1010R::KEY-PRESSED = "End Key"
             GO TO EXIT-THE-MODULE.

          IF TPS1010R::KEY-PRESSED = "Page Down Key"
             PERFORM 0030-PAGE-DOWN THRU 0030-EXIT
             GO TO 0020-DISPLAY-TABLE.

          IF TPS1010R::KEY-PRESSED = "Page Up Key"
             PERFORM 0040-PAGE-UP THRU 0040-EXIT
             GO TO 0020-DISPLAY-TABLE.

          MOVE TPS1010R::ACTIVE-FIELD    TO WS-IND.
          MOVE TABLE-ACCT-NO(WS-IND)    TO DIARY-RPT-ACCT-NO.
          MOVE TABLE-SUB-ACCT(WS-IND)   TO DIARY-RPT-SUB-ACCT.
          MOVE TABLE-DATE-OF-REPORT(WS-IND)
                                        TO DIARY-RPT-DATE-OF-REPORT.
          GO TO 0050-READ-DIARY-RECORD.

       0020-EXIT. EXIT.

       0030-PAGE-DOWN.

      **** WHEN FIRST SCREEN IS NOT FULL GO TO EXIT ****
          IF TABLE-KEY(12) = SPACES
             GO TO 0030-EXIT.
      **** FILL SCREEN WITH LATEST DATE FIRST ****
          MOVE TABLE-KEY(12)   TO DIARY-RPT-KEY
          INITIALIZE WS-TABLE-DATES, WS-TABLE-KEY.

       0030-READ-RECS.

          MOVE F-PRIME         TO FILE-KEY.
          MOVE F-READ-PREVIOUS TO FILE-ACTION.
          CALL TPSIO024 USING FILE-REQUEST DR.
          IF END-OF-FILE-WAS-REACHED
             GO TO 0030-EXIT.
          IF NOT A-SUCCESSFUL-OPERATION
             MOVE ' DIARY  '    TO FILE-NAME
             MOVE 'TPS600-REPR' TO FILE-TEXT
             PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
             GO TO EXIT-THE-MODULE.

          IF DIARY-RPT-ACCT-NO      = CLNT-PROFILE-ACCT-NO AND
             DIARY-RPT-SUB-ACCT     = CLNT-PROFILE-SUB-ACCT
             NEXT SENTENCE
          ELSE
             GO TO 0030-EXIT.

          IF DIARY-RPT-SCHEDULE = 99
             GO TO 0030-READ-RECS.

          ADD 1                     TO WS-IND.
      ***** BUILD DISPLAY TABLE *******
          MOVE DIARY-RPT-START-MM   TO FR-DATE-MM(WS-IND).
          MOVE DIARY-RPT-START-DD   TO FR-DATE-DD(WS-IND).
          MOVE DIARY-RPT-START-YY   TO FR-DATE-YY(WS-IND).
          MOVE DIARY-RPT-END-MM     TO TO-DATE-MM(WS-IND).
          MOVE DIARY-RPT-END-DD     TO TO-DATE-DD(WS-IND).
          MOVE DIARY-RPT-END-YY     TO TO-DATE-YY(WS-IND).
          MOVE '/'                  TO FILL1(WS-IND), FILL2(WS-IND),
                                       FILL4(WS-IND), FILL5(WS-IND).
      ***** BUILD LOOKUP TABLE TO READ SELECTED RECORD *******
          MOVE DIARY-RPT-ACCT-NO    TO TABLE-ACCT-NO(WS-IND).
          MOVE DIARY-RPT-SUB-ACCT   TO TABLE-SUB-ACCT(WS-IND).
          MOVE DIARY-RPT-DATE-OF-REPORT
                                    TO TABLE-DATE-OF-REPORT(WS-IND).

          IF WS-IND = 12
             GO TO 0030-EXIT
          ELSE
             GO TO 0030-READ-RECS.

       0030-EXIT.   EXIT.

       0040-PAGE-UP.

      **** FILL SCREEN WITH LATEST DATE FIRST ****
          MOVE TABLE-KEY(1)    TO DIARY-RPT-KEY.
          INITIALIZE WS-TABLE-DATES, WS-TABLE-KEY.

       0040-READ-RECS.

          MOVE F-PRIME     TO FILE-KEY.
          MOVE F-READ-NEXT TO FILE-ACTION.
          CALL TPSIO024 USING FILE-REQUEST DR.
          IF END-OF-FILE-WAS-REACHED
             GO TO 0040-EXIT.
          IF NOT A-SUCCESSFUL-OPERATION
             MOVE ' DIARY  '    TO FILE-NAME
             MOVE 'TPS600-RENX' TO FILE-TEXT
             PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
             GO TO EXIT-THE-MODULE.

          IF DIARY-RPT-ACCT-NO      = CLNT-PROFILE-ACCT-NO AND
             DIARY-RPT-SUB-ACCT     = CLNT-PROFILE-SUB-ACCT
             NEXT SENTENCE
          ELSE
             GO TO 0040-EXIT.

          IF DIARY-RPT-END-DATE = ZEROS
             GO TO 0040-READ-RECS.

          ADD 1                     TO WS-IND.
      ***** BUILD DISPLAY TABLE *******
          MOVE DIARY-RPT-START-MM   TO FR-DATE-MM(WS-IND).
          MOVE DIARY-RPT-START-DD   TO FR-DATE-DD(WS-IND).
          MOVE DIARY-RPT-START-YY   TO FR-DATE-YY(WS-IND).
          MOVE DIARY-RPT-END-MM     TO TO-DATE-MM(WS-IND).
          MOVE DIARY-RPT-END-DD     TO TO-DATE-DD(WS-IND).
          MOVE DIARY-RPT-END-YY     TO TO-DATE-YY(WS-IND).
          MOVE '/'                  TO FILL1(WS-IND), FILL2(WS-IND),
                                       FILL4(WS-IND), FILL5(WS-IND).
      ***** BUILD LOOKUP TABLE TO READ SELECTED RECORD *******
          MOVE DIARY-RPT-ACCT-NO    TO TABLE-ACCT-NO(WS-IND).
          MOVE DIARY-RPT-SUB-ACCT   TO TABLE-SUB-ACCT(WS-IND).
          MOVE DIARY-RPT-DATE-OF-REPORT
                                    TO TABLE-DATE-OF-REPORT(WS-IND).

          IF WS-IND = 12
             GO TO 0040-EXIT
          ELSE
             GO TO 0040-READ-RECS.

       0040-EXIT.   EXIT.

       0050-READ-DIARY-RECORD.

          MOVE F-PRIME     TO FILE-KEY.
          MOVE F-READ      TO FILE-ACTION.
          CALL TPSIO024 USING FILE-REQUEST DR.
          IF NOT A-SUCCESSFUL-OPERATION
             MOVE ' DIARY  '    TO FILE-NAME
             MOVE 'TPS600-READ' TO FILE-TEXT
             PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
             GO TO EXIT-THE-MODULE.

          MOVE DIARY-RPT-ACCT-NO         TO START-ACCT-NO.
          MOVE DIARY-RPT-SUB-ACCT        TO START-SUB-ACCT.
          MOVE DIARY-RPT-START-DATE      TO NEXT-DAY
          CALL TPSDATES USING CALL-TPSDATES-NEXT-DAY
          MOVE NEXT-DAY                  TO START-MAIL-DATE
          MOVE 1                         TO START-MAIL-REC.
          MOVE DIARY-RPT-ACCT-NO         TO END-ACCT-NO.
          MOVE DIARY-RPT-SUB-ACCT        TO END-SUB-ACCT.
          MOVE DIARY-RPT-END-DATE        TO END-MAIL-DATE.
          MOVE 99                        TO END-MAIL-REC.

          MOVE 'Y'         TO RERUN-IND.

       0050-EXIT. EXIT.

       EXIT-THE-MODULE.

          IF TPSDIARY-OPEN
             MOVE 0             TO TPSDIARY-FLAG
             MOVE F-PRIME       TO FILE-KEY
             MOVE F-CLOSE       TO FILE-ACTION
             CALL TPSIO024 USING FILE-REQUEST DR
             IF NOT A-SUCCESSFUL-OPERATION
                MOVE 'DIARY ' TO FILE-NAME
                MOVE 'TPS600-CLS' TO FILE-TEXT
                PERFORM FILE-ERROR THRU FILE-ERROR-EXIT.

          CANCEL TPSIO024.
          CANCEL TPSDATES.
          CANCEL TPSIOERR.

           INITIALIZE CURRENT-XY-PARAMETERS.
           MOVE WS-CURRENT-X TO CURRENT-XY-PARAMETERS(1:4).
           MOVE WS-CURRENT-Y TO CURRENT-XY-PARAMETERS(5:4).

           IF CLOSE-ALL-FORMS-FLAG = 0
               SET TPS1010R::KEY-PRESSED TO "End Key"
               SET TPS1010M::KEY-PRESSED TO "End Key"
               INVOKE TPS1010R::Close
               INVOKE TPS1010M::Close
               MOVE 1 TO CLOSE-ALL-FORMS-FLAG
           END-IF.

          GOBACK GIVING CURRENT-XY-PARAMETERS.

       FILE-ERROR.
            CALL TPSIOERR USING FILE-REQUEST
                                WS-CURRENT-XY-PARM.
            CANCEL TPSIOERR.

            MOVE WS-CURRENT-XY-PARM(1:4) TO WS-CURRENT-X.
            MOVE WS-CURRENT-XY-PARM(5:4) TO WS-CURRENT-Y.

           INITIALIZE CURRENT-XY-PARAMETERS.
           MOVE WS-CURRENT-X TO CURRENT-XY-PARAMETERS(1:4).
           MOVE WS-CURRENT-Y TO CURRENT-XY-PARAMETERS(5:4).

       FILE-ERROR-EXIT. EXIT.

