000100 IDENTIFICATION DIVISION.
000200 PROGRAM-ID. TPS571.
000300 AUTHOR. JIM MONAGHAN.
000400***************************************************************
000500*    CREATE CLIENT AND VENDOR FILES TO IMPORT INTO KOFAX      *
000600***************************************************************
000500* 08/16/11 ADD BANK AND BROKERAGE FILES TO SELECTION       JM *
000500* 04/29/11 REMOVE CLIENT FILE,, IT IS CREATED AS A mdb FILE   *
000500*    JM    IN TPS545.                                         *
000500* 05/04/11 take the filters and pass all the bills.        JM *
000500* 05/10/11 put client table back in to pick active clients JM *
000600***************************************************************
000700 ENVIRONMENT DIVISION.
000800 CONFIGURATION SECTION.
000900 SOURCE-COMPUTER. IBM-PS2.
001000 OBJECT-COMPUTER. IBM-PS2.
001100 FILE-CONTROL.
001300
001200**   SELECT PRT-FILE  ASSIGN TO 'LPT1'
001300     SELECT CLIENT-FILE  ASSIGN TO "C:\TPS\APP\CLIENT.TXT"
001400         ORGANIZATION IS LINE SEQUENTIAL
001500         FILE STATUS IS TPS-FILE-STATUS.
001300
001300     SELECT VENDOR-FILE
001300         ASSIGN TO "M:\KTM PROJECT FILES\VENDOR_LOOKUP.TXT"
001400         ORGANIZATION IS LINE SEQUENTIAL
001500         FILE STATUS IS TPS-FILE-STATUS.
001300
001300     SELECT BANK-FILE
001300         ASSIGN TO "M:\KTM PROJECT FILES\BANK_LOOKUP.TXT"
001400         ORGANIZATION IS LINE SEQUENTIAL
001500         FILE STATUS IS TPS-FILE-STATUS.
001600 DATA DIVISION.
001700 FILE SECTION.
001300
001800 FD  CLIENT-FILE
001900     LABEL RECORDS ARE OMITTED
002000     RECORD CONTAINS 100 CHARACTERS.
002100 01  CLIENT-RECORD.
              05  CLIENT-LINE-NO              PIC 9(03).
              05  FILLER                      PIC x(01) VALUE ','.
              05  CLIENT-SHORT-NAME           PIC x(03).
              05  FILLER                      PIC x(01) VALUE ','.
              05  CLIENT-NAME                 PIC x(36).
002148        05  FILLER                      PIC X(02) value ','.
002145        05  CLIENT-ACCT-NO              PIC 9(10).
001300
001800 FD  VENDOR-FILE
001900     LABEL RECORDS ARE OMITTED
002000     RECORD CONTAINS 100 CHARACTERS.
002100 01  VENDOR-RECORD            pic x(300).
003800                                                                          
                                              
001300*08/16/11 add bank-file to selection
001800 FD  BANK-FILE
001900     LABEL RECORDS ARE OMITTED
002000     RECORD CONTAINS 100 CHARACTERS.
002100 01  BANK-RECORD             pic x(300).
003800
003900 WORKING-STORAGE SECTION.

****************DIALOG SCREEN DEFINITION****************************

       01 WS-CURRENT-X                            PIC 9(04).
       01 WS-CURRENT-Y                            PIC 9(04).
       01 WS-CURRENT-XY-PARM.
          05 WS-X-PARM                            PIC 9(04).
          05 WS-Y-PARM                            PIC 9(04).

       COPY "ds-cntrl.v1".
********************************************************************

004000     COPY "TPSFILES.CPY".
004100     COPY "KEYVALUE.CPY".
004110     COPY "PCL5VALU.CPY".
004120
004120****************************************************************          
                                              
004120
002100 01  hdr-record-1.                                                        
                                              
002200     10 filler                         pic x(10) value
002200        'VendorNum|'.
002200     10 filler                         pic x(11) value
002200        'ClientName|'.
002200     10 filler                         pic x(10) value
002200        'VendorName'.
002200*    10 filler                         pic x(09) value
002200*       'Address1|'.
002200*    10 filler                         pic x(09) value
002200*       'Address2|'.
002200*    10 filler                         pic x(05) value
002200*       'City|'.
002200*    10 filler                         pic x(03) value
002200*       'ST|'.
002200*    10 filler                         pic x(07) value
002200*       'ZipCode'.
003800                                                                          
                                              
004120****************************************************************          
                                              
004120
004120
002100 01 data-record.
002200     10 prt-payee-acct-no              pic x(20).
002200     10 filler                         pic x value ','.
002600     10 prt-client-name                pic x(36).
002200     10 filler                         pic x value ','.
002600     10 prt-payee-name                 pic x(36).
002200     10 filler                         pic x value ','.
002200     10 prt-payee-addrl1               pic x(36).
002200     10 filler                         pic x value ','.
002200     10 prt-payee-addrl2               pic x(36).
002200     10 filler                         pic x value ','.
002200     10 prt-city                       pic x(24).
002200     10 filler                         pic x value ','.
002200     10 prt-state                      pic x(02).
002200     10 filler                         pic x value ','.
002200     10 prt-zip                        pic x(05).
002200     10 filler                         pic x value '-'.
002200     10 prt-zipcode                    pic x(09).


002100*01  prt-record-3.
002200*    10 filler                         pic x(04).
002200*    10 filler                         pic x.
002300*    10 filler                         pic x.
002200*    10 prt3-the-schedule              pic x(11).
002300*    10 filler                         pic x.
002200*    10 prt3-chart-desc                pic x(62).
003100*    10 filler                         pic x(20).
003800                                                                          
                                              
002100*01  prt-record-4                      pic x(100) value spaces.
003800*03/22/11
002100 01 WS-DATA-RECORD            PIC X(200) VALUE SPACES.
002100 01 WS-IND                    PIC 9(02) VALUE ZERO.
002200 01 DATA-IND                  PIC 9(03) VALUE ZERO.
002200 01 WS-FIELD-20               PIC X(20).
002300 01 WS-FIELD-20-BYTE REDEFINES WS-FIELD-20 OCCURS 20 TIMES
002200                              PIC X(01).
002300 01 WS-FIELD-36               PIC X(36) USAGE DISPLAY.
002200 01 WS-FIELD-36-BYTE REDEFINES WS-FIELD-36 OCCURS 36 TIMES
003100                              PIC X(01).
025600 01  WS-EDIT-NAME        PIC X(36) VALUE SPACES.
025700 01  EDIT-NAME           PIC X VALUE 'E'.
025800 01  LENGTH-36           PIC 999 VALUE 36.
025600 01  WS-EDIT-NAME-20     PIC X(20) VALUE SPACES.
025800 01  LENGTH-20           PIC 999 VALUE 20.
025600
025900 01  TPSVEDIT            PIC X(08) VALUE 'TPSVEDIT'.
025900 01  MAKECAPS            PIC X(08) VALUE 'MAKECAPS'.
009000*
003800
003800                                                                          
                                              
035000
004130 01  PS.
004140     COPY "TPSPROFL.CPY".
004150
004200 01  TPS-MAIL-REC.
004300     COPY "TPSMAIL.CPY".
004400*01  TPS-RECUR-REC.
004500*    COPY "TPSRECUR.CPY".
004600 01  TPSIORCR                      PIC X(08) VALUE 'TPSIORCR'.
004600 01  TPSIO004                      PIC X(08) VALUE 'TPSIO004'.
004610 01  FLOATBIG                      PIC X(08) VALUE 'FLOATBIG'.
004700 01  PROGRAM-NAMES.
004800  10 TPSIOERR    PIC X(08) VALUE 'TPSIOERR'.
004810  10 TPSCHART    PIC X(08) VALUE 'TPSCHART'.
004900  10 FILLER      PIC X(08) VALUE HIGH-VALUES.
005000 01  TPS-FILE-STATUS                       PIC XX.
005100     88  TPS-CARRIER-FILE-OK VALUE '00', '02'.
005120
005172
005173*
005174  01  BG-FLOAT-DATA.
005175      05  BG-FLOAT-PARMS              PIC  X(161).
005176      05  FILLER REDEFINES BG-FLOAT-PARMS.
005177          10  BG-FLOAT-COUNT          PIC  X(01).
005180          10  BG-FLOAT-1              PIC  X(40).
005190          10  BG-FLOAT-2              PIC  X(40).
005191          10  BG-FLOAT-2-R REDEFINES BG-FLOAT-2.
005192              15  BG-FLOAT-2-I        PIC  X(01) OCCURS 40 TIMES.
005193          10  BG-FLOAT-3              PIC  X(40).
005194          10  FILLER REDEFINES BG-FLOAT-3.
005195              15  BG-FLOAT-3-A        PIC  X(37).
005196              15  BG-FLOAT-3-B        PIC  X(03).
005197          10  BG-FLOAT-3-R REDEFINES BG-FLOAT-3.
005198              15  BG-FLOAT-3-I        PIC  X(01) OCCURS 40 TIMES.
005199          10  BG-FLOAT-4              PIC  X(40).
005200
002319
002264 01 WS-LINE-NO                PIC 9(03) VALUE ZERO.
005201
       01 CLIENT-TABLE OCCURS 1 TO 1000 TIMES DEPENDING ON CLIENT-IND
                       INDEXED BY CLIENT-IDX.
            05  TBL-CLIENT-NO                 PIC  9(10).
            05  TBL-CLIENT-NAME               PIC  X(36).
005241 01  CLIENT-IND                         PIC 9(04) VALUE ZEROS.
005203 01  CURRENT-CLIENT                     PIC 9(10) VALUE ZEROS.
005240
005241 01  MISC-WORKING-STORAGE.
005242      05  LINE-COUNT                  PIC  9(02) VALUE 14.
005243      05  FIRST-PAGE-FLAG             PIC  9(01) VALUE 0.
005244          88  FIRST-PAGE                         VALUE 0.
005245          88  NOT-FIRST-PAGE                     VALUE 1.
005242      05  LINE-number                 PIC  9(04) VALUE 0.                 
                                              
005246
005247
005247
005241*01  select-client-flag               pic  9(01) value 0.                 
                                              
005241 01  select-client-flag               pic  9(01) value 2.
005241     88 select-one-client                        value 1.                 
                                              
005241     88 create-flat-file                         value 2.
005247
005247
005247
005250 LINKAGE SECTION.
005300 01 TPS-PARAMETER.
005400    05 TPS-PARAMETER-VALUE PIC XX.
005500
005600 PROCEDURE DIVISION USING
005700                          TPS-PARAMETER.
005800 TPS571-BEGIN.

           INITIALIZE DS-CONTROL-BLOCK.
           INITIALIZE DS-INPUT-FIELDS.

005900    PERFORM OPEN-THE-FILES
006000       THRU OPEN-THE-FILES-EXIT.
006100    PERFORM READ-CLIENT-FILE
006200       THRU READ-CLIENT-FILE-EXIT.
006100    PERFORM READ-THE-RECUR
006200       THRU READ-THE-RECUR-EXIT.
006300 TPS571-COMMON-EXIT.
006400    PERFORM CLOSE-THE-FILES
006500       THRU CLOSE-THE-FILES-EXIT.
006600    GOBACK.
230900                                                                          
231000 READ-CLIENT-FILE.                                                        
229600    MOVE ZEROS      TO CLNT-PROFILE-KEY.                                  
229700    MOVE F-PRIME TO FILE-KEY.                                             
229800    MOVE F-START TO FILE-ACTION.                                          
229900    CALL TPSIO004 USING FILE-REQUEST PS.                                  
230300    IF NOT A-SUCCESSFUL-OPERATION                                         
230400       MOVE ' PROFILE' TO FILE-NAME                                       
230500       MOVE 'TPS000-START' TO FILE-TEXT                                   
230600       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                            
230800     END-IF.                                                              
30900
231000 READ-CLIENTS.                                                            
230900                                                                          
231100    MOVE F-PRIME TO FILE-KEY.                                             
231200    MOVE F-READ-NEXT TO FILE-ACTION.                                      
231300    CALL TPSIO004 USING FILE-REQUEST PS.                                  
231400    IF END-OF-FILE-WAS-REACHED                                            
231500       GO TO READ-CLIENT-FILE-EXIT                                        
231600     END-IF.                                                              
231700                                                                          
231800    IF NOT A-SUCCESSFUL-OPERATION                                         
231900       MOVE 'PROFILE ' TO FILE-NAME                                       
232000       MOVE 'TPS000-BRN' TO FILE-TEXT                                     
232100       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                            
232300     END-IF.                                                              
232400                                                                          
232500    IF CLNT-PROFILE-SUB-ACCT > 00                                         
232600       GO TO READ-CLIENTS.                                                
232700                                                                          
232800    IF CLNT-PROFILE-ADD-DATE(1:1) > 6                                     
232900       GO TO READ-CLIENTS.                                                
233000                                                                          
233100    IF CLNT-PROFILE-MOD-DATE(1:1) > 6                                     
233200       GO TO READ-CLIENTS.                                                
233300                                                                          
009226********* BUILD CLIENT FILE *********
086700    add 1                         to ws-line-no.
086700    move ws-line-no               to client-line-no.
086700    move clnt-profile-last-name(1:3) to client-short-name.
009244    move clnt-profile-name        to client-name.
009244    move clnt-profile-acct-no     to client-acct-no.
017200    WRITE CLIENT-RECORD.
009243
009226********* ADD CLIENT TO LOOKUP TABLE ************
233400    ADD 1                      TO CLIENT-IND.
233400    MOVE CLNT-PROFILE-ACCT-NO  TO TBL-CLIENT-NO(CLIENT-IND).
233400    MOVE CLNT-PROFILE-NAME     TO TBL-CLIENT-NAME(CLIENT-IND).
233500
233400    ADD 1                        TO CLNT-PROFILE-KEY.
231000    GO TO READ-CLIENTS.
230900
231000 READ-CLIENT-FILE-EXIT.   EXIT.
230900
006700
006800 READ-THE-RECUR.
006900    MOVE LOW-VALUES         TO RECUR-KEY.
007000*   MOVE '0101000024'       TO RECUR-ACCT-NO.
007100
015940    write vendor-record from hdr-record-1.
015940    write bank-record from hdr-record-1.
007300
007400    MOVE F-PRIME TO FILE-KEY.
007500    MOVE F-START TO FILE-ACTION.
007610    CALL TPSIORCR USING FILE-REQUEST RECUR-ROOT-SECTION.
007700    IF NO-RECORD-WAS-FOUND GO TO READ-THE-RECUR-EXIT.
007800    IF NOT A-SUCCESSFUL-OPERATION
007900       MOVE ' RECURE' TO FILE-NAME
008000       MOVE 'TPS571-SBR' TO FILE-TEXT
008100       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
008200       GO TO TPS571-COMMON-EXIT.
008210
008300 READ-ALL-RECUR-RECORDS.
008400    MOVE F-PRIME TO FILE-KEY.
008500    MOVE F-READ-NEXT TO FILE-ACTION.
008610    CALL TPSIORCR USING FILE-REQUEST RECUR-ROOT-SECTION.
008700    IF END-OF-FILE-WAS-REACHED GO TO READ-THE-RECUR-EXIT.
008800    IF NOT A-SUCCESSFUL-OPERATION
008900       MOVE ' RECURE' TO FILE-NAME
009000       MOVE 'TPS571-BRN' TO FILE-TEXT
009100       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
009200       GO TO TPS571-COMMON-EXIT.
009300
010300
010400****SELECTION CRITERIA.
010410
011309
011309*08/16/11 add bank & brokerage statements to selection
011309    if recur-chart-acct-01(1:2) = '02' or '11' or '31' or '33'
011309                   or '03' or '12'
011309       continue                                                           
                                              
011309      else                                                                
                                              
011306       go to read-all-recur-records
011309     end-if.                                                              
                                              
011309
011309*05/04/11 ***** take out filters and pass all bills
011309*   if recur-payee-account-number = zeros or spaces
011306*      go to read-all-recur-records
011309*    end-if.
011309
011309*   if recur-payee-addrl1 = spaces
011306*      go to read-all-recur-records
011309*    end-if.
011309
011309*   if recur-payee-name(1:3) = 'TPS'
011306*      go to read-all-recur-records
011309*    end-if.
011309
011309******* CHECK FOR ACTIVE CLIENT ***********
011309    IF RECUR-ACCT-NO = CURRENT-CLIENT
011309       CONTINUE
011309    ELSE
575100       SET CLIENT-IDX TO 1
575200       SEARCH CLIENT-TABLE
575300         WHEN RECUR-ACCT-NO = TBL-CLIENT-NO(CLIENT-IDX)
575500         MOVE TBL-CLIENT-NO(CLIENT-IDX) TO CURRENT-CLIENT
575700       END-SEARCH.
011309
011309    IF RECUR-ACCT-NO NOT = CURRENT-CLIENT
575300       GO TO READ-ALL-RECUR-RECORDS
011309    END-IF.
011309
011309    if create-flat-file
011306       perform flat-file thru flat-file-exit
011306       go to read-all-recur-records
011309     end-if.
011309
015901
011347       move spaces to prt-payee-acct-no
002600            prt-client-name
002600            prt-payee-name
002200            prt-payee-addrl1
002200            prt-payee-addrl2
002600            prt-city
002600            prt-state
002600            prt-zip
002600            prt-zipcode.
015901
012140       move recur-payee-account-number
002200         to prt-payee-acct-no.
012701       INSPECT prt-payee-acct-no
012702               REPLACING ALL X'00' BY X'20'.
012130       move recur-payee-account-number
002600         to ws-edit-name.
             CALL MAKECAPS  USING  ws-edit-name.
             CANCEL MAKECAPS.
             MOVE ws-edit-name             TO prt-client-name.
379200
379200       MOVE RECUR-PAYEE-NAME  TO WS-EDIT-NAME.
002200****** remove comma from payee name *************
379200       CALL TPSVEDIT USING EDIT-NAME
379300                     LENGTH-36
379400                     WS-EDIT-NAME.
             CALL MAKECAPS  USING  ws-edit-name.
             CANCEL MAKECAPS.
             MOVE ws-edit-name             TO prt-payee-name.
379400       MOVE WS-EDIT-NAME   TO prt-payee-name.
012140
012140       move recur-payee-addrl1       to ws-edit-name.
             CALL MAKECAPS  USING  ws-edit-name.
             CANCEL MAKECAPS.
             MOVE WS-edit-name             TO prt-payee-addrl1.
012140
012140       move recur-payee-addrl2       TO ws-edit-name.
             CALL MAKECAPS  USING  ws-edit-name.
             CANCEL MAKECAPS.
             MOVE WS-edit-name             TO prt-payee-addrl2.
012140
012130       move recur-payee-city         TO ws-edit-name.
             CALL MAKECAPS  USING  ws-edit-name.
             CANCEL MAKECAPS.
             MOVE WS-edit-name             TO prt-city.
012140
012200       move recur-payee-state        TO ws-edit-name
             CALL MAKECAPS  USING  ws-edit-name.
             CANCEL MAKECAPS.
             MOVE ws-edit-name             TO prt-state.
012140
012200       move recur-payee-zipcode(1:5)
002600         to prt-zip.
012200       move recur-payee-zipcode(6:4)
002600         to prt-zipcode.
012453
011309    if recur-chart-acct-01(1:2) = '02' or '11' or '31' or '33'
015940       write vendor-record from data-record.
011309*08/16/11 add bank statements to selection
011309    if recur-chart-acct-01(1:2) = '03' or '12'
015940       write bank-record from data-record.
012453
016000       GO TO READ-ALL-RECUR-RECORDS.
004120
003800                                                                          
                                              
016100 READ-THE-RECUR-EXIT. EXIT.
016200
016100 flat-file.
016308
002200****** move payee account number **********
012140       move recur-payee-account-number
002200         to ws-edit-name-20.
             CALL MAKECAPS  USING  ws-edit-name-20.
             CANCEL MAKECAPS.
             MOVE ws-edit-name-20          TO ws-field-20.
012701       INSPECT ws-field-20
012702               REPLACING ALL X'00' BY X'20'.
457400       PERFORM VARYING WS-IND FROM 20 BY -1
457500          UNTIL WS-IND = 1  OR
457600          WS-FIELD-20-BYTE(WS-IND) > SPACES
457900       END-PERFORM.
012140       move ws-field-20(1:ws-ind)
002200         to ws-data-record.
012140       move ws-ind     to data-ind.
002200       add 1          to data-ind.
012140       move '|'       to ws-data-record(data-ind:1).
002200       add 1          to data-ind.
012140
002200****** move addresee name *************
379200       MOVE RECUR-ADDRESEE-NAME  TO WS-EDIT-NAME.
002200****** remove comma from name *************
379200       CALL TPSVEDIT USING EDIT-NAME
379300                     LENGTH-36
379400                     WS-EDIT-NAME.
             CALL MAKECAPS  USING  ws-edit-name.
             CANCEL MAKECAPS.
             MOVE ws-edit-name             TO ws-field-36.
457400       PERFORM VARYING WS-IND FROM 36 BY -1
457500          UNTIL WS-IND = 1  OR
457600          WS-FIELD-36-BYTE(WS-IND) > SPACES
457900       END-PERFORM.
012140       move ws-field-36(1:ws-ind)
002200         to ws-data-record(data-ind:ws-ind).
012140       add ws-ind     to data-ind.
012140       move '|'       to ws-data-record(data-ind:1).
002200       add 1          to data-ind.
012140
012140
002200****** move payee name *************
011309*08/16/11 add bank statements to selection
011309    if recur-chart-acct-01(1:2) = '03' or '12'
011309       move recur-addresor-name to ws-edit-name
011309    else
379200       MOVE RECUR-PAYEE-NAME  TO WS-EDIT-NAME.
002200****** remove comma from payee name *************
379200       CALL TPSVEDIT USING EDIT-NAME
379300                     LENGTH-36
379400                     WS-EDIT-NAME.
             CALL MAKECAPS  USING  ws-edit-name.
             CANCEL MAKECAPS.
             MOVE ws-edit-name             TO ws-field-36.
457400       PERFORM VARYING WS-IND FROM 36 BY -1
457500          UNTIL WS-IND = 1  OR
457600          WS-FIELD-36-BYTE(WS-IND) > SPACES
457900       END-PERFORM.
012140       move ws-field-36(1:ws-ind)
002200         to ws-data-record(data-ind:ws-ind).
012140*      add ws-ind     to data-ind.
012140*      move '|'       to ws-data-record(data-ind:1).
002200*      add 1          to data-ind.
012140
012140     GO TO SKIP-ZIP.
012140
002200****** move payee address *************
012140     if recur-payee-addrl1 > spaces
012140       move recur-payee-addrl1
002200         to ws-edit-name
379200       CALL TPSVEDIT USING EDIT-NAME
379300                     LENGTH-36
379400                     WS-EDIT-NAME
             CALL MAKECAPS  USING  ws-edit-name
             CANCEL MAKECAPS
             MOVE ws-edit-name             TO ws-field-36
457400       PERFORM VARYING WS-IND FROM 36 BY -1
457500          UNTIL WS-IND = 1  OR
457600          WS-FIELD-36-BYTE(WS-IND) > SPACES
457900       END-PERFORM
012140       move ws-field-36(1:ws-ind)
002200         to ws-data-record(data-ind:ws-ind)
012140       add ws-ind     to data-ind
012140       move '|'       to ws-data-record(data-ind:1)
002200       add 1          to data-ind
012140     else
012140       move '|'       to ws-data-record(data-ind:1)
002200       add 1          to data-ind.
012140
002200****** move payee address line 2 *************
012140       if recur-payee-addrl2 > spaces
012140          move recur-payee-addrl2  to ws-edit-name
379200          CALL TPSVEDIT USING EDIT-NAME
379300                        LENGTH-36
379400                        WS-EDIT-NAME
                CALL MAKECAPS  USING  ws-edit-name
                CANCEL MAKECAPS
                MOVE ws-edit-name             TO ws-field-36
457400          PERFORM VARYING WS-IND FROM 36 BY -1
457500             UNTIL WS-IND = 1  OR
457600             WS-FIELD-36-BYTE(WS-IND) > SPACES
457900          END-PERFORM
012140          move ws-field-36(1:ws-ind)
002200             to ws-data-record(data-ind:ws-ind)
012140          add ws-ind     to data-ind
012140          move '|'       to ws-data-record(data-ind:1)
002200          add 1          to data-ind
012140        else
012140          move '|'       to ws-data-record(data-ind:1)
002200          add 1          to data-ind.
012140
012140
002200****** move payee city *************
012140     if recur-payee-city > spaces
012140       move recur-payee-city
002200          to ws-edit-name
379200          CALL TPSVEDIT USING EDIT-NAME
379300                        LENGTH-36
379400                        WS-EDIT-NAME
                CALL MAKECAPS  USING  ws-edit-name
                CANCEL MAKECAPS
                MOVE ws-edit-name   TO ws-field-36
457400       PERFORM VARYING WS-IND FROM 36 BY -1
457500          UNTIL WS-IND = 1  OR
457600          WS-FIELD-36-BYTE(WS-IND) > SPACES
457900       END-PERFORM
012140       move ws-field-36(1:ws-ind)
002200          to ws-data-record(data-ind:ws-ind)
012140       add ws-ind     to data-ind
012140       move '|'       to ws-data-record(data-ind:1)
002200       add 1          to data-ind
012140     else
012140       move '|'       to ws-data-record(data-ind:1)
002200       add 1          to data-ind.
012140
002200****** move payee city *************
012140       if recur-payee-state > spaces
012130          move recur-payee-state
002200            to ws-data-record(data-ind:2)
012140          add 2          to data-ind
012140          move '|'       to ws-data-record(data-ind:1)
002200          add 1          to data-ind
012140       else
012140          move '|'       to ws-data-record(data-ind:1)
002200          add 1          to data-ind.
012140
002200****** move payee zip code *********
012140       if recur-payee-zipcode > zeros
012130          move recur-payee-zipcode(1:5)
002200            to ws-data-record(data-ind:5)
012130          add 5 to data-ind
012130          move '-'    to ws-data-record(data-ind:1)
012130          add 1 to data-ind
012130          move recur-payee-zipcode(6:4)
002200            to ws-data-record(data-ind:4).
012140
012140 SKIP-ZIP.
002200
011309    if recur-chart-acct-01(1:2) = '02' or '11' or '31' or '33'
015940       write vendor-record from ws-data-record.
011309*08/16/11 add bank statements to selection
011309    if recur-chart-acct-01(1:2) = '03' or '12'
015940       write bank-record from ws-data-record.
002600*   write vendor-record from ws-data-record.
002600    move spaces        to ws-data-record.
012111
016100 flat-file-exit.      EXIT.
016309
016310
016400
016500 FILE-ERROR.
016600     CALL TPSIOERR USING FILE-REQUEST
                               WS-CURRENT-XY-PARM.
016700     CANCEL TPSIOERR.

            MOVE WS-CURRENT-XY-PARM(1:4) TO WS-CURRENT-X.
            MOVE WS-CURRENT-XY-PARM(5:4) TO WS-CURRENT-Y.

016800 FILE-ERROR-EXIT. EXIT.
016900
017000
017100 OPEN-THE-FILES.
017200
017200*   OPEN OUTPUT CLIENT-FILE.
017200    OPEN OUTPUT VENDOR-FILE.
017200*08/16/11 ******* add bank file
017200    OPEN OUTPUT BANK-FILE.
017200
017210******    WRITE PRT-RECORD FROM PCL5-LANDSCAPE.                           
                                              
017300    MOVE F-PRIME    TO FILE-KEY.
017400    MOVE F-OPEN-INPUT TO FILE-ACTION.
017500*** CALL TPSIORCR USING FILE-REQUEST TPS-RECUR-REC.
017510    CALL TPSIORCR USING FILE-REQUEST RECUR-ROOT-SECTION.
017600    IF FILE-STATUS NOT = '00' AND '05'
017700       MOVE 'RECURE ' TO FILE-NAME
017800       MOVE 'TPS571-OIN' TO FILE-TEXT
017900       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
018000       GO TO TPS571-COMMON-EXIT.
017000
017300    MOVE F-PRIME    TO FILE-KEY.
017400    MOVE F-OPEN-INPUT TO FILE-ACTION.
017500    CALL TPSIO004 USING FILE-REQUEST PS.
017600    IF FILE-STATUS NOT = '00' AND '05'
017700       MOVE 'profl  ' TO FILE-NAME
017800       MOVE 'TPS571-OIN' TO FILE-TEXT
017900       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
018000       GO TO TPS571-COMMON-EXIT.
018100 OPEN-THE-FILES-EXIT. EXIT.
017000
018200 CLOSE-THE-FILES.
017200
017200*     CLOSE CLIENT-FILE.
017200      CLOSE VENDOR-FILE.
017200*08/16/11  ******* add bank file
017200      CLOSE BANK-FILE.
018300
018400      MOVE F-PRIME TO FILE-KEY.
018500      MOVE F-CLOSE TO FILE-ACTION.
018600
018700***   CALL TPSIORCR USING FILE-REQUEST TPS-RECUR-REC.
018710      CALL TPSIORCR USING FILE-REQUEST RECUR-ROOT-SECTION.
018800      IF NOT A-SUCCESSFUL-OPERATION
018900         MOVE 'RECURE ' TO FILE-NAME
019000         MOVE 'TPS571-CLO' TO FILE-TEXT
019100         PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
019200      END-IF.
019300
017500    CALL TPSIO004 USING FILE-REQUEST PS.
017600    IF NOT A-SUCCESSFUL-OPERATION
017700       MOVE 'profl  ' TO FILE-NAME
017800       MOVE 'TPS571-CLO' TO FILE-TEXT
017900       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
018000    END-IF.
018000
019400 CLOSE-THE-FILES-EXIT. EXIT.
019500*----------------------------------------------------
019600*----------------------------------------------------
019700*----------------------------------------------------
019800*----------------------------------------------------
019900
028300
015901
016900
083900
091900
092000
