000100 $SET SQL
000100 IDENTIFICATION DIVISION.
000200 PROGRAM-ID. TPS540.
000300 AUTHOR. JIM MONAGHAN.
000400***************************************************************
000400***************************************************************
000500*    DELETE & EXPORT RECURRING RECORDS INTO ACCESS DB         *
000600***************************************************************
000600* 03/04/05 ADD RECUR CATEGORY TO DATABASE                   JM*
000600* 05/22/06 ADD '1' RECORD TO THE DATABASE                   JM*
000600* 06/05/06 CLEAN UP VENDOR ACCOUNT # FOR MATCH TO SCANCODE  JM*
000600***************************************************************
000700 ENVIRONMENT DIVISION.
000800 CONFIGURATION SECTION.
000900 SOURCE-COMPUTER. IBM-PS2.
001000 OBJECT-COMPUTER. IBM-PS2.
       SPECIAL-NAMES.
           ENVIRONMENT-VALUE IS ENV-VALUE
           ENVIRONMENT-NAME IS ENV-NAME.

       INPUT-OUTPUT SECTION.
001100 FILE-CONTROL.

           SELECT  TPS-MAIL-CATEGORY-FILE                                                  00020800
                   ASSIGN TO DYNAMIC FILESPEC1                                             00021000
                   ORGANIZATION IS LINE SEQUENTIAL                                         00021100
                   FILE STATUS IS TPS-FILE-STATUS.                                         00021200
                                                                                           00000490
003800 DATA DIVISION.                                                                      00000690
003900 FILE SECTION.                                                                       00000700

       FD  TPS-MAIL-CATEGORY-FILE                                                          00025200
           DATA RECORD  IS TPS-MAIL-CATEGORY-INPUT                                         00025300
           LABEL RECORDS STANDARD.                                                         00025400
       01  TPS-MAIL-CATEGORY-INPUT.                                                        00025500
           10 TPS-MAIL-CATEGORY-CODE       PIC X(02).                                      00251100
           10 FILLER                       PIC X(01).                                      00251200
           10 TPS-MAIL-CATEGORY-NAME       PIC X(41).                                      00251300
           10 FILLER                       PIC X(976).                                     00251200
                                                                                           00000870
002200
003900 WORKING-STORAGE SECTION.
004000     COPY "TPSFILES.CPY".
004100     COPY "KEYVALUE.CPY".
004110     COPY "PCLVALUE.CPY".
004110     COPY "PCL5VALU.CPY".
004200*01  TPS-MAIL-REC.
004300*    COPY "TPSMAIL.CPY".
004300 01  TPS-RECUR-REC.
004500     COPY "TPSRECUR.CPY".
004300                                                                                                                    
       01 SCREENIO    PIC X(08) VALUE 'GS    '.                                            00018400
        COPY METER.COB.                                                                    00049900
004300
       01  TPSDEDIT            PIC X(08) VALUE 'TPSDEDIT'.                                 00018600
004600 01  TPSIORCR            PIC X(08) VALUE 'TPSIORCR'.
004600 01  tpsiochk            PIC x(08) value 'tpsiochk'.
004610 01  FLOATBIG            PIC X(08) VALUE 'FLOATBIG'.
004800 01  TPSIOERR            PIC X(08) VALUE 'TPSIOERR'.
004900
005000 01  TPS-FILE-STATUS                       PIC XX.
005100     88  TPS-CARRIER-FILE-OK VALUE '00', '02'.
004400 01  EDIT-DATE            PIC 9(06).

      *>      SQL SECTION

           EXEC SQL INCLUDE SQLCA END-EXEC


      *>AFTER AN SQL ERROR THIS HAS THE FULL MESSAGE TEXT
        01  MFSQLMESSAGETEXT      PIC X(250).
        01  IDX                   PIC X(04) COMP-5.
      *>         SQL VARIBLES
           EXEC SQL BEGIN DECLARE SECTION END-EXEC
           EXEC SQL INCLUDE VendorList END-EXEC
           EXEC SQL END DECLARE SECTION END-EXEC

      ****** OUTPUT LINK FOR SQL **********
        01 WS-VENDORLIST.
          03 LNKA-AddressorName            PIC X(36).
          03 LNKA-VendorAccount            PIC X(20).
          03 LNKA-AddresseeName            PIC X(36).
          03 LNKA-ClientNumber             PIC S9(09)  COMP-5.
          03 LNKA-Category                 PIC X(41).


       01 MAIL-CATEGORY-DATA OCCURS 050 TIMES.                                             00250900
          10 MAIL-CATEGORY-ROW.                                                            00251000
             20 MAIL-CATEGORY-CODE       PIC X(02).                                        00251100
             20 FILLER                   PIC X(01).                                        00251200
             20 MAIL-CATEGORY-NAME       PIC X(41).                                        00251300
       01 THE-INDEX                      PIC 9(02) VALUE ZEROS.
       01 WS-MAIL-CATEGORY               PIC X(41) VALUE SPACES.
005130*
005140  01  BG-FLOAT-DATA.
005150      05  BG-FLOAT-PARMS              PIC  X(161).
005160      05  FILLER REDEFINES BG-FLOAT-PARMS.
005170          10  BG-FLOAT-COUNT          PIC  X(01).
005180          10  BG-FLOAT-1              PIC  X(40).
005190          10  BG-FLOAT-2              PIC  X(40).
005191          10  BG-FLOAT-2-R REDEFINES BG-FLOAT-2.
005192              15  BG-FLOAT-2-I        PIC  X(01) OCCURS 40 TIMES.
005193          10  BG-FLOAT-3              PIC  X(40).
005194          10  FILLER REDEFINES BG-FLOAT-3.
005195              15  BG-FLOAT-3-A        PIC  X(37).
005196              15  BG-FLOAT-3-B        PIC  X(03).
005197          10  BG-FLOAT-3-R REDEFINES BG-FLOAT-3.
005198              15  BG-FLOAT-3-I        PIC  X(01) OCCURS 40 TIMES.
005199          10  BG-FLOAT-4              PIC  X(40).
005200
       01 CUR                              PIC 9(03) VALUE 0.                              00009200
       01 SAVE-CUR                         PIC 9(03) VALUE 0.                              00009200
       01 IND                              PIC 9(03) VALUE 0.                              00009300
       01 HOLD-ACCT-NO                     PIC 9(10) VALUE 0.                              00009300
       01 FIELD-20                         PIC X(20).                                      00009300
       01 WS-FIELD-20 REDEFINES FIELD-20                                                   00037300
                      OCCURS 20 TIMES PIC X(01).                                           00037400
       01 FIELD-36                         PIC X(36).                                      00009300
       01 WS-FIELD-36 REDEFINES FIELD-36                                                   00037300
                      OCCURS 36 TIMES PIC X(01).                                           00037400


       LINKAGE SECTION.
       01 WS-FAX                 PIC X(01).
       01 WS-PARAMETER.
          05 WS-CLIENT-ACCT-NO   PIC 9(10).
          05 WS-CLIENT-SUB-ACCT  PIC 9(02).
          05 WS-PROFILE-NAME     PIC X(36).                                                00043600

       PROCEDURE DIVISION USING WS-PARAMETER.

       SEERECUR-BEGIN.
          PERFORM OPEN-THE-FILES
             THRU OPEN-THE-FILES-EXIT.
                                                                                           00055000
       TPS-MAIL-CATEGORY-TABLE.                                                            00313400
                                                                                           00313300
            READ TPS-MAIL-CATEGORY-FILE                                                    00312600
                 AT END GO TO TPS-MAIL-CATEGORY-FILE-EXIT                                  00312700
            END-READ                                                                       00312800
            ADD 1              TO THE-INDEX.                                               00312900
            MOVE TPS-MAIL-CATEGORY-CODE                                                    00313000
              TO MAIL-CATEGORY-CODE(THE-INDEX).                                            00313100
            MOVE TPS-MAIL-CATEGORY-NAME                                                    00313000
              TO MAIL-CATEGORY-NAME(THE-INDEX).                                            00313100
            IF THE-INDEX = 50                                                              00312700
               GO TO TPS-MAIL-CATEGORY-FILE-EXIT.                                          00312700
            GO TO TPS-MAIL-CATEGORY-TABLE.                                                 00312700
                                                                                           00313300
       TPS-MAIL-CATEGORY-FILE-EXIT.                                                        00313400

          PERFORM OPEN-DELETE-DB
             THRU OPEN-DELETE-DB-EXIT.

          PERFORM READ-THE-RECUR
             THRU READ-THE-RECUR-EXIT.

       SEERECUR-COMMON-EXIT.

          PERFORM  ADD-LAST-RECORD
             THRU  ADD-LAST-RECORD-EXIT.

          PERFORM CLOSE-THE-FILES
             THRU CLOSE-THE-FILES-EXIT.

           EXEC SQL
               DISCONNECT CURRENT
           END-EXEC.

          GOBACK.
          STOP RUN.


       OPEN-DELETE-DB.

           EXEC SQL
               WHENEVER SQLERROR perform OpenESQL-Error
           END-EXEC

           EXEC SQL
               CONNECT TO 'TPSrecords' USER 'admin'
           END-EXEC

            EXEC SQL
             DELETE FROM VendorList
      *       WHERE ( AddressorName = 'AAA PLUS' )
            END-EXEC.

       OPEN-DELETE-DB-EXIT.  EXIT.

006800 READ-THE-RECUR.
006900    INITIALIZE RECUR-KEY.
007000    MOVE WS-CLIENT-ACCT-NO  TO RECUR-ACCT-NO
007000                               HOLD-ACCT-NO.
007300
007400    MOVE F-PRIME TO FILE-KEY.
007500    MOVE F-START TO FILE-ACTION.
007600    CALL TPSIORCR USING FILE-REQUEST TPS-RECUR-REC.
007700    IF NO-RECORD-WAS-FOUND
007700       GO TO READ-THE-RECUR-EXIT.
007800    IF NOT A-SUCCESSFUL-OPERATION
007900       MOVE ' RECURE' TO FILE-NAME
008000       MOVE 'TPS540-START' TO FILE-TEXT
008100       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
008200       GO TO SEERECUR-COMMON-EXIT.
008300 READ-ALL-RECUR-RECORDS.
008400    MOVE F-PRIME TO FILE-KEY.
008500    MOVE F-READ-NEXT TO FILE-ACTION.
008600    CALL TPSIORCR USING FILE-REQUEST TPS-RECUR-REC.
008700    IF END-OF-FILE-WAS-REACHED
008700       GO TO READ-THE-RECUR-EXIT
008700     end-if.
011329                                                                                                                    
008800    IF NOT A-SUCCESSFUL-OPERATION
008900       MOVE ' RECURE' TO FILE-NAME
009000       MOVE 'TPS540-READN' TO FILE-TEXT
009100       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
009200       GO TO SEERECUR-COMMON-EXIT.
009300
010300
010400****SELECTION CRITERIA.
012111
010500    IF RECUR-ACCT-NO NOT = HOLD-ACCT-NO
008700       GO TO READ-THE-RECUR-EXIT
011200    END-IF.
012111
010500*   IF RECUR-CHART-ACCT-01(1:2) NOT = '02' and
010500*                                     '11' and
010500*                                     '31' and
010500*                                     '33'
010600*      GO TO READ-ALL-RECUR-RECORDS
011200*   END-IF.
011200                                                                                                                  
                                                                                           00453200
      ***** USE METER TO SHOW JOB PROGRESS ********
          ADD 1               TO PROGRESS-BAR.
          IF PROGRESS-BAR = 100
             MOVE 1           TO PROGRESS-BAR.
          SET METER-DO-DISPLAY-AND-RETURN TO TRUE.
          CALL SCREENIO USING METER-1
                              METER-2
                              METER-3
                              METER-4.

      ******* FIND THE CATEGORY NAME TO DISPLAY ******                                     00068600
          PERFORM VARYING THE-INDEX FROM 1 BY 1                                            00314400
                  UNTIL   THE-INDEX = 50 OR                                                00314500
                  MAIL-CATEGORY-CODE(THE-INDEX) = RECUR-CATEGORY-CODE                      00314600
          END-PERFORM.                                                                     00314700
          MOVE MAIL-CATEGORY-NAME(THE-INDEX) TO WS-MAIL-CATEGORY.
          IF THE-INDEX = 50                                                                00068900
             MOVE SPACES           TO WS-MAIL-CATEGORY.                                    00068900

      *06/05/06 ******** CLEAN VENDOR ACCT # FOR MATCH ********
          CALL TPSDEDIT USING RECUR-PAYEE-ACCOUNT-NUMBER.                                  00303400

          MOVE RECUR-ADDRESOR-NAME TO VendorList-AddressorName.
          MOVE RECUR-PAYEE-ACCOUNT-NUMBER TO VendorList-VendorAccount.
          MOVE RECUR-ADDRESEE-NAME TO VendorList-AddresseeName.
          MOVE RECUR-ACCT-NO       TO VendorList-ClientNumber.
          MOVE WS-MAIL-CATEGORY    TO VendorList-VendorCategory.

            EXEC SQL
             INSERT INTO VendorList
             (AddressorName
             ,VendorAccount
             ,AddresseeName
             ,ClientNumber
             ,VendorCategory
             ) VALUES
             (:VendorList-AddressorName:VendorList-AddressorName-NULL
             ,:VendorList-VendorAccount:VendorList-VendorAccount-NULL
             ,:VendorList-AddresseeName:VendorList-AddresseeName-NULL
             ,:VendorList-ClientNumber:VendorList-ClientNumber-NULL
           ,:VendorList-VendorCategory:VendorList-VendorCategory-NULL
             )
            END-EXEC

            EXEC SQL COMMIT END-EXEC

      *   MOVE RECUR-ACCT-NO             TO EXT-LINE(CUR:).
      *   WRITE EXT-LINE.

          GO TO READ-ALL-RECUR-RECORDS.

       READ-THE-RECUR-EXIT. EXIT.

       ADD-LAST-RECORD.

          MOVE '1'              TO VendorList-AddressorName.
          MOVE WS-PROFILE-NAME  TO VendorList-AddresseeName.
      *   MOVE RECUR-PAYEE-ACCOUNT-NUMBER TO VendorList-VendorAccount.
      *   MOVE RECUR-ACCT-NO       TO VendorList-ClientNumber.

            EXEC SQL
             INSERT INTO VendorList
             (AddressorName
             ,VendorAccount
             ,AddresseeName
             ,ClientNumber
             ) VALUES
             (:VendorList-AddressorName:VendorList-AddressorName-NULL
             ,:VendorList-VendorAccount:VendorList-VendorAccount-NULL
             ,:VendorList-AddresseeName:VendorList-AddresseeName-NULL
             ,:VendorList-ClientNumber:VendorList-ClientNumber-NULL
             )
            END-EXEC.

            EXEC SQL COMMIT END-EXEC.

       ADD-LAST-RECORD-EXIT.  EXIT.

      *DATABASE-DISPLAY.

       OpenESQL-Error Section.

           display "SQL Error=" sqlstate" "sqlcode
           display MFSQLMESSAGETEXT
           GO TO SEERECUR-COMMON-EXIT.


016400
016500 FILE-ERROR.
016600     CALL TPSIOERR USING FILE-REQUEST.
016700     CANCEL TPSIOERR.
016800 FILE-ERROR-EXIT. EXIT.
016900
017000
017100 OPEN-THE-FILES.
                                                                                           00051900
         DISPLAY 'TPSMAILCATEGORY' UPON ENVIRONMENT-NAME.
         MOVE "\tps\prod\files\mailcatg.men" TO FILESPEC1.                                
                                                                                           00311000
         OPEN  INPUT  TPS-MAIL-CATEGORY-FILE.                                              00312300
017210
017300    MOVE F-PRIME      TO FILE-KEY.
017400    MOVE F-OPEN-INPUT TO FILE-ACTION.
017500    CALL TPSIORCR USING FILE-REQUEST TPS-RECUR-REC.
017600    IF FILE-IS-ALREADY-OPEN
017700       GO TO OPEN-THE-FILES-EXIT.
017600    IF FILE-STATUS NOT = '00' AND '05'
017700       MOVE 'RECUR  ' TO FILE-NAME
017800       MOVE 'TPS540-I/O' TO FILE-TEXT
017900       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
018000       GO TO SEERECUR-COMMON-EXIT.
018000
018100 OPEN-THE-FILES-EXIT. EXIT.
017000
018200 CLOSE-THE-FILES.
018300
            CLOSE TPS-MAIL-CATEGORY-FILE.                                                  00313400
018400      MOVE F-PRIME TO FILE-KEY.
018500      MOVE F-CLOSE TO FILE-ACTION.
018600
018700      CALL TPSIORCR USING FILE-REQUEST TPS-RECUR-REC.
018800      IF NOT A-SUCCESSFUL-OPERATION
018900         MOVE 'RECUR  ' TO FILE-NAME
019000         MOVE 'TPS540-CLOSE' TO FILE-TEXT
019100         PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
019200      END-IF.
019300
019400 CLOSE-THE-FILES-EXIT. EXIT.
019500*----------------------------------------------------
019600*----------------------------------------------------
019700*----------------------------------------------------
019800*----------------------------------------------------
