002500 IDENTIFICATION DIVISION.
002600 PROGRAM-ID. TPS4010.
002700*               ACCEPTS APPOINTMENTS FROM RECEIVING PROGRAM
002800*               AND ADDS THEM TO CALENDAR DATA BASE........
002900*               ALSO ACCEPTS APPOINTMENTS FROM PANEL TPS4010.COB
003000*               AND ADDS THEM TO CALENDAR DATA BASE........
003100
003200*****************************************************************
003300*                MAINTENANCE LOG                                *
001001* 10/19/17 MODIFIED GUI SCREEN                               AC *
003400* 11/05/07 MAKE HONORING INPUT FIELD 32 IN SCREENIO TO FIT      *
003400*    JM    PROGRAM PROCESS AND NOT TRUNCATE FIELD.              *
003400* 06/15/98 FIX DELETE FUNCTION IN RECEIVING                  JM *
003400* 03/06/98 PROGRAM WAS NOT DISPLAYING MEMO LINES AT READ-CAL-REC*
003400*    TS                                                         *
003400* 10/22/97 UNDO CHANGING LSP-OPTION IN HOT FIELD.               *
003400* 09/29/97 IN MAIL RECEIVE DO NOT ALLOW SELECTIONS FROM MENU    *
003400*    JM    SCREEN. IF OLD RECORD IS SELECTED AND DATE IS        *
003400*          CHANGED WRITE NEW RECORD.                            *
003400* 04/01/97 FIX RECEIVE DATE & CALENDAR XREF IN MAINT        JM  *
003400* 01/21/97 CORRECTED PROBLEM WHEN TABBING THRU EVENT 2ND TIME,  *
003401*    TS    PROGRAM WOULD EXIT TO PREV MENU.....                 *
003410* 01/02/97 CORRECTED PROBLEM WHEN ENTERING 'TO' DATE.  TS       *
003500* 12/17/96 COMPLETED CHANGES FROM OCT. '96, PANEL TPS4010 MOD   *
003600*    TS    TO ACCECPT DATE 1ST, THEN TOGGLE TO PANEL TPS4001    *
003700*          TO DISPLAY APPOINTMENTS ALREADY ENTERED. ALSO CORRECT*
003800*          DRESS CODE DISPLAY AND ADDED ADD/UPDATE AND ADMIN NAM*
003900* 10/09/96 WHEN CHANGING RECORD REWRITE THE ATTEND & PRINT      *
004000*    JM    OPTIONS. ALSO DON'T UPDATE OTHER RECORDS.            *
004100* 12/27/95 FIXED START & END TIME IN PANEL TPS4010.         JM  *
004200* 12/19/95 CHECKED OUT TO COMPILE FOR REVISED PANEL TPS4010.COB *
004300*    TS                                                         *
004400* 11/17/95 MOVE 'Y' TO MAIL-OPEN FLAG WHEN OPENING RECEIVE FILE *
004500*    JM    SO IT CAN BE CLOSED WHEN DOING MAINTENANCE.          *
004600* 11/16/95 WHEN DELETING AN EVENT ATTACHED TO A MAIL RECORD     *
004700*    JM    MOVE ZEROS TO MAIL-CALENDAR-XREF.                    *
004900* 11/07/95 WHEN A RECORD IS UPDATED, USING CALENDAR MAINTENANCE *
005000*    JM    CHANGE THE RECORD NUMBER IN THE MAIL-CALENDAR-XREF   *
005100*          FIELD OF THE MAIL RECORD WHEN APPLICABLE.            *
005200* 08/16/95 ADD POP UP WINDOW FOR ATTENDING EVENTS          JM   *
005300* 08/16/95 ADD MAINTENANCE FOR CALENDAR RECORDS.           JM   *
005400* 08/04/95 PUT MENU MSG IN PROGRAM FOR PANEL TPS4010            *
005500* 08/01/95 ADDED CODE FOR 'ADD, MODIFY AND DELETE' TRANSACTIONS *
005600*    TS    FROM VARIOUS DATA BASE MODULES....                   *
005700*                                                               *
005800* 07/18/95 MAINTENANCE TO RECORDS ADDED BY RECEIVE PROGRAM.     *
005900*    JC                                                         *
006000*---------------------------------------------------------------*
006100*****************************************************************
006200*               ERROR RETURN CODES (IN LSP-PROG-ID)             *
006300*                                                               *
006400*  '99999999' UNKNOWN CALLING PROGRAM.                          *
006500*  '99998888' INVALID LSP-MAINT-FIELD-CODE FROM D. B. MAINT.    *
006600*  '99997777' INVALID CODE IN 'CALENDAR.MEN'                    *
006700*  '99996666' INVALID LSP-ACTION CODE FROM D.B. MAINTENANCE     *
006800*  '99995555' NO MATCH ON DELETE REQUEST FROM D. B. MAINT.      *
006900*  '99994444' NO MATCH ON MODIFY REQUEST FROM D. B. MAINT.      *
007000*                                                               *
007100*****************************************************************
007200 ENVIRONMENT DIVISION.
007300
007400 CONFIGURATION SECTION.
007500 SOURCE-COMPUTER. IBM-PC.
007600 OBJECT-COMPUTER. IBM-PC.
007700
007800 DATA DIVISION.
007900
008000 WORKING-STORAGE SECTION.

       01 WS-TEMP-MSG-FLAG         PIC 9(01) VALUE 1.
008100
008200* ------------------------: Dynamically called programs:
008300*        SCRNIO  is SCREENIO
008400*        TPSIO018 IS 'CALEN' (ISAM) FILE HANDLER.
008500*
        01  GUISCREEN               pic x(08) value 'GS      '.
008600  01  SCREENIO                PIC X(8) VALUE 'SCRNIO'.
008700  01  TPSDATES                PIC X(8) VALUE 'TPSDATES'.
008800  01  TPSIOERR                PIC X(8) VALUE 'TPSIOERR'.
008900  01  TPSIO018                PIC X(8) VALUE 'TPSIO018'.
009000  01  TPSIOREC                PIC X(8) VALUE 'TPSIOREC'.
009100  01  FLOATBIG                PIC X(8) VALUE 'FLOATBIG'.
009200
009300
009400  COPY KEYVALUE.CPY.
009500
009600  COPY TPSBROWS.CPY.
009700
009800 01  TPS-CALENDAR-REC.
009900  COPY TPSCALEN.CPY.
010000
010100
010200*01  WS.
010300* COPY TPSLOGON.CPY.
010400
010500*01  PS.
010600* COPY TPSPROFL.CPY.
010700
010800  COPY TPSFILES.CPY.

      *********** WINFORMS SCREEN DEFINITION **********

       01 TPS4010 type TPS000.TPS4010Form.
       01 TPS4001 type TPS000.TPS4001Form.
       01 TPS4010B type TPS000.TPS4010BForm.
       01 TPS4010A type TPS000.TPS4010AForm.
       01 TPS4000A type TPS000.TPS4000AForm.

       01 TPS4010-DATE-START pic 9(06).
       01 TPS4010-DATE-END pic 9(06).
       01 TPS4010-RSVP-DATE pic 9(06).
       01 TPS4010-EVENT-COST pic S9(10)V9(02).
       01 TPS4010-SURPRISE-INDIC pic x(03) .
       01 TPS4010-ACTIVE-FIELD PIC 9(03).
       01 TPS4010-DISPLAY-FLAG PIC 9(01) VALUE 0.

       01 TPS4001-LINE-NO PIC 9(02) OCCURS 15 TIMES.
       01 TPS4001-DATE PIC 9(06) OCCURS 15 TIMES.
       01 TPS4001-ATTEND-Y-N PIC X(01) OCCURS 15 TIMES.
       01 TPS4001-EVENT PIC X(50) OCCURS 15 TIMES.
       01 TPS4001-RECEIVE-DATE PIC 9(06) OCCURS 15 TIMES.
       01 TPS4001-IDX PIC 9(02).

       01 TPS4000A-DISPLAY-DATE PIC 9(06).

       01 THE-IDX-2 PIC 9(02).
       01 CLOSE-ALL-FORMS-FLAG PIC 9(01) VALUE 0.
       01 SCREEN-NAME PIC x(10).

       01 WS-CURRENT-X                            PIC 9(04).
       01 WS-CURRENT-Y                            PIC 9(04).
       01 WS-CURRENT-XY-PARM.
          05 WS-X-PARM                            PIC 9(04).
          05 WS-Y-PARM                            PIC 9(04).

       COPY "ds-cntrl.v1".
       
       COPY "TPS4010C.CPB".

      *************************************************



011400*RENAMED TO TPS4010C COPY TPS4000B.COB.

011700
011800 01 HOLD-MAIL-KEY.
011900    05 HOLD-MAIL-ACCT-NO              PIC 9(10).
012000    05 HOLD-MAIL-SUB-ACCT             PIC 9(02).
012100    05 HOLD-MAIL-RECEIVE-DATE         PIC X(08).
012200    05 HOLD-MAIL-RECEIVE-NUMBER       PIC S9(05) COMP-3.
012300
012400 01 UPD-MAIL.
012500      COPY TPSMAIL.CPY.
012600
012700 01  DB-EVENT-MENU.
012800      COPY CALENDAR.CPY.
012900 01  DB-EVENT-TABLE REDEFINES DB-EVENT-MENU.
013000      05  DB-EVENT-TABLE OCCURS 13 TIMES INDEXED BY DB-IDX.
013100         10 DB-EVENT-CODE       PIC  9(04).
013200         10 DB-NUMBER-LINES     PIC  9(01).
013300         10 DB-FLOAT-FACTOR     PIC  X(01).
013400               88 DB-FLOAT-NO              VALUE 'N'.
013500               88 DB-FLOAT-YES             VALUE 'F'.
013600         10 DB-EVENT-DESCRIPT   PIC  X(30).
013700
013800 01  WS-ENTRY-DATE              PIC  X(06).
013800 01  WS-DB-EVENT-CODE           PIC  9(04).
013900 01  WS-APPT-PRINT-OPTION       PIC  X(01).
014000 01  WS-APPT-ATTEND-OPTION      PIC  X(01).
014100
014200 01  TPSMAIL-FLAG               PIC 9(01) VALUE 0.
014300     88 TPSMAIL-OPEN                      VALUE 1.
014400
014500 01  VIEW-FOR-NEW-FLAG          PIC 9(01) VALUE 0.
014600     88 VIEW-FOR-NEW-EVENT                VALUE 1.
014700 01  STARTED-AS-NEW-FLAG        PIC 9(01) VALUE 0.
014800     88  STARTED-AS-NEW                   VALUE 1.
014810 01  ENTERED-EVENT-DATE-FLAG    PIC 9(01) VALUE 0.
014811     88  ENTERED-EVENT-DATE               VALUE 1.
014900
015000 01  WS-DONE-BY-WHO.
015100      05  WHAT-DID-THEY-DO   PIC  X(07).
015200      05  FILLER             PIC  X(04) VALUE ' BY '.
015300      05  WHO-DID-IT         PIC  X(07).
015400      05  FILLER             PIC  X(04) VALUE ' ON '.
015500      05  WHEN-MM            PIC  X(02).
015600      05  FILLER             PIC  X(01) VALUE '/'.
015700      05  WHEN-DD            PIC  X(02).
015800      05  FILLER             PIC  X(01) VALUE '/'.
015900      05  WHEN-YY            PIC  X(02).
016000
016100
016200 01  WS-RECV-MEMO.
016300      02  WS-MEMO-ACCT-NO               PIC  9(10).
016400      02  WS-MEMO-SUB-ACCT              PIC  9(02).
016500      02  WS-MEMO-RECEIVE-DATE          PIC  9(08).
016600      02  WS-MEMO-RECEIVE-NUMBER        PIC S9(05) COMP-3.
016700      02  WS-MEMO-LINE      PIC  X(50) OCCURS 10 TIMES.
016800      02  WS-MEMO-AREA REDEFINES WS-MEMO-LINE.
016900      05  WS-MEMO-LINE-1.
017000          10  WS-MEMO-EVENT-W           PIC X(07).
017100          10  WS-MEMO-EVENT             PIC X(43).
017200      05  WS-MEMO-LINE-2.
017300          10  WS-MEMO-DATE-W            PIC X(06).
017400          10  WS-MEMO-DATE-START        PIC 99/99/99.
017500          10  WS-MEMO-DATE-DASH         PIC X(03).
017600          10  WS-MEMO-DATE-END          PIC 99/99/99.
017700          10  FILLER                    PIC X(01).
017800          10  WS-MEMO-TIME-W            PIC X(06).
017900          10  WS-MEMO-TIME-START        PIC X(04).
018000          10  FILLER                    PIC X(01).
018100          10  WS-MEMO-START-AM-PM       PIC X(02).
018200          10  FILLER                    PIC X(01).
018300          10  WS-MEMO-TIME-DASH-W       PIC X(01).
018400          10  FILLER                    PIC X(01).
018500          10  WS-MEMO-TIME-END          PIC X(04).
018600          10  FILLER                    PIC X(01).
018700          10  WS-MEMO-END-AM-PM         PIC X(02).
018800          10  FILLER                    PIC X(01).
018900      05  WS-MEMO-LINE-3.
019000          10  WS-MEMO-GIVEN-BY-W        PIC X(10).
019100          10  WS-MEMO-GIVEN-BY          PIC X(40).
019200      05  WS-MEMO-LINE-3A.
019300          10  WS-MEMO-HONORING-W        PIC X(10).
019400          10  WS-MEMO-HONORING          PIC X(40).
019500      05  WS-MEMO-LINE-4.
019600          10  WS-MEMO-RSVP-W            PIC X(06).
019700          10  WS-MEMO-RSVP              PIC 99/99/99.
019800          10  FILLER                    PIC X(01).
019900          10  WS-MEMO-CONTACT-W         PIC X(09).
020000          10  WS-MEMO-CONTACT           PIC X(26).
020100      05  WS-MEMO-LINE-5.
020200          10  WS-MEMO-COST-W            PIC X(07).
020300          10  WS-MEMO-COST              PIC 999999V99.
020400          10  FILLER                    PIC X(01).
020500          10  WS-MEMO-SURPRISE-W        PIC X(11).
020600          10  WS-MEMO-SURPRISE          PIC X(01).
020700          10  FILLER                    PIC X(01).
020800          10  WS-MEMO-DRESS-W           PIC X(07).
020900          10  WS-MEMO-DRESS             PIC X(10).
021000          10  FILLER                    PIC X(04).
021100      05  WS-MEMO-LINE-6.
021200          10  WS-MEMO-LOCATION-W        PIC X(10).
021300          10  WS-MEMO-LOCATION          PIC X(40).
021400      05  WS-MEMO-LINE-7.
021500          10  WS-MEMO-COMMENT-1         PIC X(40).
021600          10  WS-MEMO-COMMENTS-W        PIC X(10).
021700      05  WS-MEMO-LINE-8.
021800          10  WS-MEMO-COMMENT-2         PIC X(40).
021900          10  FILLER                    PIC X(10).
022000      05  WS-MEMO-LINE-9.
022100          10  WS-MEMO-COMMENT-3         PIC X(40).
022200          10  FILLER                    PIC X(10).
022300********10  TPS-MEMO-LINE-10           PIC X(50).
022400
022500 01  WS-WORK-AREA.
022600      05  WS-TODAYS-DATE-YMD         PIC  9(06).
022700      05  FILLER REDEFINES WS-TODAYS-DATE-YMD.
022800          10  WS-TODAYS-DATE-YMD-YY  PIC  9(02).
022900          10  WS-TODAYS-DATE-YMD-MM  PIC  9(02).
023000          10  WS-TODAYS-DATE-YMD-DD  PIC  9(02).
023100
023200      05  WS-MEMO-DATE-CYMD          PIC  9(08).
023300      05  FILLER REDEFINES WS-MEMO-DATE-CYMD.
023400          10  WS-MEMO-DATE-CYMD-CC   PIC  9(02).
023500          10  WS-MEMO-DATE-CYMD-YY   PIC  9(02).
023600          10  WS-MEMO-DATE-CYMD-MM   PIC  9(02).
023700          10  WS-MEMO-DATE-CYMD-DD   PIC  9(02).
023800
023900      05  WS-TODAYS-DATE-CYMD        PIC  9(08).
024000      05  FILLER REDEFINES WS-TODAYS-DATE-CYMD.
024100          10  WS-TODAYS-DATE-CYMD-CC PIC  9(02).
024200          10  WS-TODAYS-DATE-CYMD-YY PIC  9(02).
024300          10  WS-TODAYS-DATE-CYMD-MM PIC  9(02).
024400          10  WS-TODAYS-DATE-CYMD-DD PIC  9(02).
024500          10  WS-TODAYS-DATE-CYMD-DD PIC  9(02).
024600
024700      05  WS-FROM-DATE-MDY           PIC  9(06).
024800      05  WS-FROM-DATE-CYMD          PIC  9(08).
024900      05  WS-TO-DATE-CYMD            PIC  9(08).
025000      05  WS-FROM-TIME-HHMM          PIC  9(04).
025100      05  WS-TO-TIME-HHMM            PIC  9(04).
025200
025300  01 WS-SUB                           PIC  9(02) VALUE 0.
025400  01 WS-SUB1                          PIC  9(02) VALUE 0.
025500  01 WS-SUB2                          PIC  9(02) VALUE 0.
025600  01 WS-TAB                           PIC  9(02) VALUE 0.
025700  01 CAL-MAINT                        PIC  X(01) VALUE 'N'.
025800  01 DB-MAINT                         PIC  X(01) VALUE 'N'.
025900  01 CHANGE-RECORD                    PIC  X(01) VALUE 'N'.
026000  01 WS-DISPLAY-OPTION                PIC  9(02) VALUE 0.
026100  01 WS-FIRST-RECORD                  PIC  9(02) VALUE 0.
026200  01 CAL-TABLE                        PIC  X(975).
026300  01 FILLER REDEFINES CAL-TABLE OCCURS 15 TIMES.
026400      05 TABLE-NO                     PIC  9(02).
026500      05 TABLE-DATE                   PIC  9(06).
026600      05 TABLE-ATTEND                 PIC  X(01).
026700      05 TABLE-EVENT                  PIC  X(50).
026800      05 TABLE-RECEIVED               PIC  9(06).
026900
027000  01 CAL-TABLE1                       PIC  X(90).
027100  01 FILLER REDEFINES CAL-TABLE1 OCCURS 15 TIMES.
027200      05 TABLE1-REC-NO                PIC  9(04).
027300      05 TABLE1-SUB-REC-NO            PIC  9(02).
027400
027500  01 PRE-TABLE                        PIC  X(1065).
027600  01 FILLER REDEFINES PRE-TABLE OCCURS 15 TIMES.
027700      05 PRE-TABLE-NO                 PIC  9(02).
027800      05 PRE-TABLE-DATE               PIC  9(06).
027900      05 PRE-TABLE-ATTEND             PIC  X(01).
028000      05 PRE-TABLE-EVENT              PIC  X(50).
028100      05 PRE-TABLE-RECEIVED           PIC  9(06).
028200      05 PRE-TABLE-REC-NO             PIC  9(04).
028300      05 PRE-TABLE-SUB-REC-NO         PIC  9(02).
028400
028500  01  BG-FLOAT-DATA.
028600      05  BG-FLOAT-PARMS              PIC  X(161).
028700      05  FILLER REDEFINES BG-FLOAT-PARMS.
028800          10  BG-FLOAT-COUNT          PIC  X(01).
028900          10  BG-FLOAT-1              PIC  X(40).
029000          10  BG-FLOAT-2              PIC  X(40).
029100          10  BG-FLOAT-2-R REDEFINES BG-FLOAT-2.
029200              15  BG-FLOAT-2-I        PIC  X(01) OCCURS 40 TIMES.
029300          10  BG-FLOAT-3              PIC  X(40).
029400          10  FILLER REDEFINES BG-FLOAT-3.
029500              15  BG-FLOAT-3-A        PIC  X(37).
029600              15  BG-FLOAT-3-B        PIC  X(03).
029700          10  BG-FLOAT-3-R REDEFINES BG-FLOAT-3.
029800              15  BG-FLOAT-3-I        PIC  X(01) OCCURS 40 TIMES.
029900          10  BG-FLOAT-4              PIC  X(40).
030000
030100
030200 01  FLOAT-DATA.
030300      05  FLOAT-PARMS                 PIC  X(161).
030400      05  FILLER REDEFINES FLOAT-PARMS.
030500          10  FLOAT-COUNT             PIC  9(01).
030600          10  FLOAT-1                 PIC  X(40).
030700          10  FLOAT-2                 PIC  X(40).
030800          10  FLOAT-3                 PIC  X(40).
030900          10  FILLER REDEFINES FLOAT-3.
031000              15  FLOAT-3-A           PIC  X(37).
031100              15  FLOAT-3-B           PIC  X(03).
031200          10  FLOAT-4                 PIC  X(40).
031300
031400
031500  01  WS-DATE-REQUEST.
031600      05  WS-DATE-PARAM          PIC  9(02).
031700
031800      05  WS-DATE-TENBYTES       PIC  X(20) VALUE SPACES.
031900      05  FILLER REDEFINES WS-DATE-TENBYTES.
032000          10  WS-DATE-REFORM         PIC  X(06).
032100          10  WS-DATE-EXTEND         PIC  X(04).
032200          10  FILLER                 PIC  X(10).
032300      05  FILLER REDEFINES WS-DATE-TENBYTES.
032400          10  WS-DATE-REFORM-LEN06   PIC  X(06).
032500          10  FILLER                 PIC  X(14).
032600      05  FILLER REDEFINES WS-DATE-TENBYTES.
032700          10  WS-DATE-REFORM-LEN08   PIC  X(08).
032800          10  FILLER                 PIC  X(12).
032900      05  FILLER REDEFINES WS-DATE-TENBYTES.
033000          10  WS-DATE-REFORM-LEN10   PIC  X(10).
033100          10  FILLER                 PIC  X(10).
033200      05  FILLER REDEFINES WS-DATE-TENBYTES.
033300          10  WS-TIME-PARM1          PIC  X(06).
033400          10  WS-TIME-PARM2          PIC  X(06).
033500          10  WS-TIME-EXTEND         PIC  X(08).
033600      05  FILLER REDEFINES WS-DATE-TENBYTES.
033700          10  WS-TIME-PARM1BY8       PIC  X(08).
033800          10  WS-TIME-PARM2BY8       PIC  X(08).
033900          10  WS-TIME-EXTNDBY8       PIC  X(04).
034000
034100      05  WS-FIX-DATE-YMD            PIC  9(06).
034200      05  FILLER REDEFINES WS-FIX-DATE-YMD.
034300          10  WS-FIX-DATE-YY-YMD     PIC  9(02).
034400          10  WS-FIX-DATE-MM-YMD     PIC  9(02).
034500          10  WS-FIX-DATE-DD-YMD     PIC  9(02).
034600
034700      05  WS-FIX-DATE-MDY            PIC  9(06).
034800      05  FILLER REDEFINES WS-FIX-DATE-MDY.
034900          10  WS-FIX-DATE-MM-MDY     PIC  9(02).
035000          10  WS-FIX-DATE-DD-MDY     PIC  9(02).
035100          10  WS-FIX-DATE-YY-MDY     PIC  9(02).
035200
035300      05  WS-TIME-OF-DAY        PIC  9(08) VALUE ZERO.
035400      05  FILLER REDEFINES WS-TIME-OF-DAY.
035500          10  WS-TIME-HH        PIC  9(02).
035600          10  WS-TIME-MM        PIC  9(02).
035700          10  WS-TIME-SS        PIC  9(04).
035800          10  FILLER REDEFINES WS-TIME-SS.
035900              15  WS-TIME-SS1   PIC  9(02).
036000              15  WS-TIME-SS2   PIC  9(02).
036100
036200      05  INPUT-FLAG                PIC  9(01) VALUE 0.
036300               88  INPUT-BY-PANEL         VALUE 1.
036400               88  INPUT-BY-RECEIVE       VALUE 2.
036500
036600      05  WS-ADMIN-ONLY-ONCE        PIC  9(01) VALUE 0.
036700               88  ADMIN-MISSED-ONCE      VALUE 1.
036800
036900      05  WS-SERVICE-NUMBER           PIC  9(03).
037000      05  WS-FUNCTION-NUMBER          PIC  9(03).
037100
037200      05  WS-CLIENT-ACCOUNT-NUMBER      PIC  9(10).
037300      05  FILLER REDEFINES  WS-CLIENT-ACCOUNT-NUMBER.
037400           10  WS-BRANCH-NUMBER-NEW     PIC  9(02).
037500           10  WS-ADMIN-NUMBER-NEW      PIC  9(02).
037600           10  WS-CLIENT-NUMBER-NEW     PIC  9(05).
037700           10  WS-CHECK-DIGIT-NEW       PIC  9(01).
037800
037900      05  WS-NEXT-AVAIL-REC-NUM         PIC  9(04).
038000
038100      05  WS-RECORD-TYPE                PIC  9(02).
038200
038300      05  WS-MONTH-WORK         PIC  X(09).
038400      05  FILLER REDEFINES WS-MONTH-WORK.
038500          10  WS-MONTH-WORK2    PIC  X(01) OCCURS 9 TIMES.
038600      05  MONTH-INDEX           PIC S9(04) COMP.
038700      05  THE-INDEX             PIC S9(04) COMP.
038800      05  SPACE-HIT             PIC  9(01) VALUE 0.
038900
039000      05 BYTE-FIELD-ONE         PIC  X(36).
039100      05 FILLER REDEFINES BYTE-FIELD-ONE.
039200         10  B-F-1             PIC  X(01) OCCURS 45 TIMES.
039300
039400      05  B-F-IDX               PIC S9(04) COMP.
039500
039600      05 BYTE-FIELD-TWO         PIC  X(36).
039700      05 FILLER REDEFINES BYTE-FIELD-TWO.
039800         10  B-F-2             PIC  X(01) OCCURS 36 TIMES.
039900
040000      05 SAVE-LSP-NEW          PIC  X(36).
040100
040200  01  DISPLAY-FILE-ACTION        PIC 99.
040300  01  FUNCTION-15                PIC S9(4) COMP-5 VALUE 15.
040400
040500  01  FUNCTION-FLAG             PIC S9(4) COMP-5 VALUE 12.
040600  01  WS-CALENDAR-XREF          PIC  9(12).
040700  01  FILLER REDEFINES WS-CALENDAR-XREF.
040800      05  WS-KEY-DATE           PIC  9(08).
040900      05  WS-KEY-RECORD-NUMBER  PIC  9(04).
041000
041100 LINKAGE SECTION.
041200 01  LS-PARMS.
041300     05  LSP-PROG-ID                   PIC  X(08).
041400     05  LSP-PROG-TYPE                 PIC  9(01).
041500         88  LSP-PROG-RECEIVE                     VALUE 1.
041600         88  LSP-PROG-DB-MAINTAIN                 VALUE 2.
041700         88  LSP-PROG-CAL-MAINTAIN                VALUE 3.
041800     05  LSP-ACTION                    PIC  9(01) VALUE 0.
041900         88  LSP-ADD                              VALUE 1.
042000         88  LSP-MODIFY                           VALUE 2.
042100         88  LSP-DELETE                           VALUE 3.
042200     05  LSP-MAINT-FIELD-CODE          PIC  9(04).
042300     05  LSP-MAINT-EVENT-DATE          PIC  9(08).
042400     05  LSP-MAINT-EVENT-TIME          PIC  X(06).
042500     05  FILLER REDEFINES LSP-MAINT-EVENT-TIME.
042600         10  LSP-MAINT-EVENT-TIME-HH   PIC  9(02).
042700         10  LSP-MAINT-EVENT-TIME-MM   PIC  9(02).
042800         10  LSP-MAINT-EVENT-TIME-AMPM PIC  X(02).
042900     05  LSP-MAINT-DATA-DESCRIP-NEW    PIC  X(36).
043000*  FOLLOWING FIELD FOR 'MODIFY' OF D.B. MAINTENANCE
043100     05  LSP-MAINT-DATA-DESCRIP-OLD    PIC  X(36).
043200
043300 01  LS-LOGON.
043400      COPY TPSLOGON.CPY.
043500 01  LS-PROFL.
043600  COPY TPSPROFL.CPY.
043700 01  LS-RECVE.
043800      COPY TPSMAIL.CPY.
043900
044000 01 CURRENT-XY-PARAMETERS PIC 9(08).

044100 PROCEDURE DIVISION USING LS-PARMS
044200                          LS-LOGON
044300                          LS-PROFL
044400                          LS-RECVE
                                CURRENT-XY-PARAMETERS.
044500
044600 0001-BEGIN.


      *********** INITIALIZE WINFORMS SCREENS **********

       set TPS4010 to new TPS000.TPS4010Form().
       set TPS4001 to new TPS000.TPS4001Form().
       set TPS4010B to new TPS000.TPS4010BForm().
       set TPS4010A to new TPS000.TPS4010AForm().
       set TPS4000A to new TPS000.TPS4000AForm().

      **************************************************
           MOVE CURRENT-XY-PARAMETERS(1:4) TO WS-CURRENT-X
                                              WS-X-PARM.
           MOVE CURRENT-XY-PARAMETERS(5:4) TO WS-CURRENT-Y
                                              WS-Y-PARM.

044800      ACCEPT WS-TODAYS-DATE-YMD FROM DATE.
044900      MOVE 01                   TO WS-DATE-PARAM.
045000      MOVE WS-TODAYS-DATE-YMD   TO WS-DATE-REFORM.
045100      MOVE SPACES               TO WS-DATE-EXTEND.
045200         CALL TPSDATES USING WS-DATE-REQUEST.
045300      MOVE WS-DATE-REFORM-LEN08 TO WS-TODAYS-DATE-CYMD.
045400
045500    PERFORM OPEN-THE-FILES
045600       THRU OPEN-THE-FILES-EXIT.
045700
045800      IF  LSP-PROG-RECEIVE AND LSP-PROG-ID = 'TPS1010 '
045900          GO TO INPUT-FROM-RECEIVE.
046000      IF  LSP-PROG-DB-MAINTAIN
046100          GO TO INPUT-FROM-DB-MAINT.
046200      IF  LSP-PROG-CAL-MAINTAIN AND LSP-PROG-ID = 'TPS4000 '
046300          AND LSP-ACTION = 0
046400          GO TO INPUT-FROM-RECEIVE.
046500      IF  LSP-PROG-CAL-MAINTAIN AND LSP-PROG-ID = 'TPS4000 '
046600          GO TO INPUT-FROM-CAL-MAINT.
046700
046800      MOVE '99999999'           TO LSP-PROG-ID.
046900      GO TO EXIT-THE-MODULE.
047000
047100 INPUT-FROM-DB-MAINT.
047200      IF LSP-MODIFY             GO TO DB-MODIFY.
047300      IF LSP-DELETE             GO TO DB-DELETE.
047400      IF NOT LSP-ADD
047500         MOVE '99996666'           TO LSP-PROG-ID
047600         GO TO EXIT-THE-MODULE.
047700
047800      MOVE 'Event: '             TO  WS-MEMO-EVENT-W.
047900      MOVE 'Date: '              TO  WS-MEMO-DATE-W.
048000      MOVE 'Time: '              TO  WS-MEMO-TIME-W.
048100      MOVE 'Given by: '          TO  WS-MEMO-GIVEN-BY-W.
048200      MOVE 'Honoring: '          TO  WS-MEMO-HONORING-W.
048300      MOVE 'RSVP: '              TO  WS-MEMO-RSVP-W.
048400      MOVE 'Contact: '           TO  WS-MEMO-CONTACT-W.
048500      MOVE 'Cost: '              TO  WS-MEMO-COST-W.
048600      MOVE 'Surprise: '          TO  WS-MEMO-SURPRISE-W.
048700      MOVE 'Dress: '             TO  WS-MEMO-DRESS-W.
048800      MOVE 'Location: '          TO  WS-MEMO-LOCATION-W.
048900
049000      MOVE SPACES         TO WS-MEMO-EVENT
049100                             WS-MEMO-START-AM-PM
049200                             WS-MEMO-END-AM-PM
049300                             WS-MEMO-GIVEN-BY
049400                             WS-MEMO-HONORING
049500                             WS-MEMO-CONTACT
049600                             WS-MEMO-SURPRISE
049700                             WS-MEMO-DRESS
049800                             WS-MEMO-LOCATION
049900                             WS-MEMO-COMMENT-1
050000                             WS-MEMO-COMMENT-2
050100                             WS-MEMO-COMMENT-3.
050200
050300      MOVE ZEROS          TO WS-MEMO-DATE-START
050400                             WS-MEMO-DATE-END
050500                             WS-MEMO-TIME-START
050600                             WS-MEMO-TIME-END
050700                             WS-MEMO-COST
050800                             WS-MEMO-RSVP.
050900
051000      MOVE CLNT-PROFILE-ACCT-NO OF LS-PROFL TO
051100                            WS-MEMO-ACCT-NO.
051200      MOVE CLNT-PROFILE-SUB-ACCT OF LS-PROFL TO
051300                            WS-MEMO-SUB-ACCT.
051400      MOVE LSP-MAINT-EVENT-DATE   TO WS-MEMO-DATE-CYMD.
051500
051600      MOVE 05                       TO WS-DATE-PARAM.
051700      MOVE LSP-MAINT-EVENT-DATE(3:6) TO WS-DATE-REFORM.
051800      MOVE SPACES                   TO WS-DATE-EXTEND.
051900        CALL TPSDATES USING WS-DATE-REQUEST.
052000      MOVE WS-DATE-REFORM-LEN06   TO WS-MEMO-DATE-START.
052100
052200 LOOKUP-EVENT-DESCRIPT.
052300         PERFORM VARYING DB-IDX FROM 1 BY 1
052400                   UNTIL DB-EVENT-CODE(DB-IDX) = '9999'
052500
052600         IF DB-EVENT-CODE(DB-IDX) = LSP-MAINT-FIELD-CODE
052700              GO TO SETUP-EVENT-DESCRIPT
052800         END-PERFORM.
052900
053000      MOVE '99998888'           TO LSP-PROG-ID.
053100      GO TO EXIT-THE-MODULE.
053200
053300 SETUP-EVENT-DESCRIPT.
053400      MOVE  DB-EVENT-CODE(DB-IDX) TO WS-DB-EVENT-CODE
053500      IF DB-FLOAT-YES(DB-IDX) AND DB-NUMBER-LINES(DB-IDX) = 1
053600         GO TO SETUP-EVENT-ONELINE-FLOAT.
053700      IF DB-FLOAT-NO(DB-IDX)  AND DB-NUMBER-LINES(DB-IDX) = 1
053800         GO TO SETUP-EVENT-ONELINE-NOFLOAT.
053900
054000
054100*  FOLLOWING CODE HAS NOT BEEN TESTED A/O 8/1/95....
054200****  IF DB-FLOAT-NO(DB-IDX)  AND DB-NUMBER-LINES(DB-IDX) = 2
054300****     GO TO SETUP-EVENT-TWOLINE-NOFLOAT.
054400
054500      MOVE '99997777'           TO LSP-PROG-ID.
054600      GO TO EXIT-THE-MODULE.
054700
054800 SETUP-EVENT-ONELINE-FLOAT.
054900       MOVE SPACES              TO BG-FLOAT-PARMS.
055000       MOVE '2'                 TO BG-FLOAT-COUNT.
055100       MOVE LSP-MAINT-DATA-DESCRIP-NEW
055200                                TO BG-FLOAT-1.
055300       MOVE DB-EVENT-DESCRIPT(DB-IDX)
055400                                TO BG-FLOAT-2.
055500       CALL FLOATBIG USING BG-FLOAT-DATA.
055600       CANCEL FLOATBIG.
055700       MOVE BG-FLOAT-1 (1:43)     TO WS-MEMO-EVENT(1:43).
055800       IF LSP-MODIFY
055900          GO TO FINISH-DB-MODIFY.
056000       GO TO FROM-THE-PANEL.
056100
056200 SETUP-EVENT-ONELINE-NOFLOAT.
056300       MOVE DB-EVENT-DESCRIPT(DB-IDX)(1:30)
056400                           TO WS-MEMO-EVENT(1:30).
056500       IF LSP-MODIFY
056600          GO TO FINISH-DB-MODIFY.
056700       GO TO FROM-THE-PANEL.
056800
056900
057000****   THIS CODE NEEDS TO BE TESTED...........
057100 SETUP-EVENT-TWOLINE-NOFLOAT.
057200       MOVE DB-EVENT-DESCRIPT(DB-IDX)(1:30)
057300                           TO WS-MEMO-EVENT(1:30).
057400       MOVE LSP-MAINT-DATA-DESCRIP-NEW
057500                           TO WS-MEMO-COMMENT-1.
057600       GO TO FROM-THE-PANEL.
057700
057800
057900 DB-MODIFY.
058000      MOVE CLNT-PROFILE-ACCT-NO   TO CAL-KEY-ACCT-NO.
058100      MOVE CLNT-PROFILE-SUB-ACCT  TO CAL-KEY-SUB-ACCT.
058200      MOVE LSP-MAINT-EVENT-DATE   TO CAL-KEY-DATE.
058300      MOVE '0001'                 TO CAL-KEY-RECORD-NUMBER.
058400      MOVE '01'                   TO CAL-KEY-SUB-RECORD-NUMBER.
058500
058600 DB-MODIFY-READ.
058700       PERFORM READ-THE-CALENDAR THRU
058800               READ-THE-CALENDAR-EXIT.
058900
059000      IF CLNT-PROFILE-ACCT-NO NOT =  CAL-KEY-ACCT-NO
059100        OR CLNT-PROFILE-SUB-ACCT NOT = CAL-KEY-SUB-ACCT
059200           MOVE '99994444'          TO LSP-PROG-ID
059300           GO TO EXIT-THE-MODULE.
059400
059500      IF LSP-MAINT-FIELD-CODE NOT =  CAL-DB-MAINT-FIELD-CODE
059600         ADD 1                    TO CAL-KEY-RECORD-NUMBER
059700         GO TO DB-MODIFY-READ.
059800
059900       MOVE LSP-MAINT-DATA-DESCRIP-NEW  TO SAVE-LSP-NEW.
060000       MOVE LSP-MAINT-DATA-DESCRIP-OLD TO
060100                           LSP-MAINT-DATA-DESCRIP-NEW.
060200
060300       PERFORM BYTE-BY-BYTE-COMPARE THRU
060400               BYTE-BY-BYTE-COMPARE-EXIT.
060500
060600       MOVE SAVE-LSP-NEW      TO LSP-MAINT-DATA-DESCRIP-NEW.
060700       GO TO LOOKUP-EVENT-DESCRIPT.
060800
060900 FINISH-DB-MODIFY.
061000      MOVE 'Event: '        TO  WS-MEMO-EVENT-W.
061100      MOVE WS-MEMO-LINE-1   TO CAL-APPT-APPOINT-DATA.
061200      MOVE SPACES           TO CAL-APPT-CHANGE-PASSWORD.
061300      MOVE LSP-MAINT-FIELD-CODE(1:4) TO
061400                               CAL-APPT-CHANGE-PASSWORD(1:4).
061500      MOVE WS-TODAYS-DATE-CYMD TO
061600                               CAL-APPT-CHANGE-DATE.
061700      PERFORM REWRITE-THE-CALENDAR THRU
061800              REWRITE-THE-CALENDAR-EXIT.
061900
062000      GO TO EXIT-THE-MODULE.
062100
062200
062300
062400 DB-DELETE.
062500      MOVE CLNT-PROFILE-ACCT-NO   TO CAL-KEY-ACCT-NO.
062600      MOVE CLNT-PROFILE-SUB-ACCT  TO CAL-KEY-SUB-ACCT.
062700      IF CAL-MAINT = 'Y'
062800         MOVE WS-KEY-DATE            TO CAL-KEY-DATE
062900         MOVE TABLE1-REC-NO(WS-TAB)  TO CAL-KEY-RECORD-NUMBER
063000      ELSE
063100      IF LSP-PROG-RECEIVE AND LSP-PROG-ID = 'TPS1010'
241500         MOVE MAIL-CALENDAR-XREF OF LS-RECVE TO WS-CALENDAR-XREF
062800         MOVE WS-KEY-DATE            TO CAL-KEY-DATE
062900         MOVE WS-KEY-RECORD-NUMBER   TO CAL-KEY-RECORD-NUMBER
063000      ELSE
063100         MOVE LSP-MAINT-EVENT-DATE   TO CAL-KEY-DATE
063200         MOVE '0001'                 TO CAL-KEY-RECORD-NUMBER.
063300      MOVE '01'                   TO CAL-KEY-SUB-RECORD-NUMBER.
063400
063500 DB-DELETE-READ.
063600       PERFORM READ-THE-CALENDAR THRU
063700               READ-THE-CALENDAR-EXIT.
063800
063900      IF CLNT-PROFILE-ACCT-NO NOT =  CAL-KEY-ACCT-NO
064000        OR CLNT-PROFILE-SUB-ACCT NOT = CAL-KEY-SUB-ACCT
064100           MOVE '99995555'          TO LSP-PROG-ID
064200           GO TO EXIT-THE-MODULE.
064300******* IF CAL-MAINT SET UP KEY TO READ THE MAIL RECORD *******
064300******* FROM MAINTENANCE OR RECEIVING                   *******
064400      IF CAL-MAINT = 'Y' OR
063100        (LSP-PROG-RECEIVE AND LSP-PROG-ID = 'TPS1010')
064500         MOVE CAL-KEY-ACCT-NO         TO HOLD-MAIL-ACCT-NO
064600         MOVE CAL-KEY-SUB-ACCT        TO HOLD-MAIL-SUB-ACCT
064700         MOVE CAL-APPT-RECEIVE-DATE   TO HOLD-MAIL-RECEIVE-DATE
064800         MOVE CAL-APPT-RECEIVE-NUMBER TO HOLD-MAIL-RECEIVE-NUMBER
064900      ELSE
065000      IF LSP-MAINT-FIELD-CODE NOT =  CAL-DB-MAINT-FIELD-CODE
065100         ADD 1                    TO CAL-KEY-RECORD-NUMBER
065200         GO TO DB-DELETE-READ.
065300
065400      IF CAL-APPT-RECEIVE-DATE NUMERIC AND
065500           CAL-APPT-RECEIVE-DATE > ZERO
065600         PERFORM DELETE-MAIL-XREF THRU DELETE-MAIL-XREF-EXIT.
065700
065800*JM6/98PERFORM BYTE-BY-BYTE-COMPARE THRU
065900*              BYTE-BY-BYTE-COMPARE-EXIT.
066000
066100      PERFORM VARYING B-F-IDX FROM 1 BY 1
066200              UNTIL B-F-IDX > 12
066300      IF CAL-APPT-ADD-DATE(1:1) = '1'
066400         MOVE '8'       TO CAL-APPT-ADD-DATE(1:1)
066500      ELSE
066600         MOVE '9'       TO CAL-APPT-ADD-DATE(1:1)
066700      END-IF
066800
066900      PERFORM REWRITE-THE-CALENDAR THRU
067000              REWRITE-THE-CALENDAR-EXIT
067100
067200       ADD 1                  TO CAL-KEY-SUB-RECORD-NUMBER
067300
067400       PERFORM READ-THE-CALENDAR THRU
067500               READ-THE-CALENDAR-EXIT
067600
067700      IF (CLNT-PROFILE-ACCT-NO NOT =  CAL-KEY-ACCT-NO
067800        OR CLNT-PROFILE-SUB-ACCT NOT = CAL-KEY-SUB-ACCT)
067900        AND CAL-MAINT = 'Y'
068000           MOVE 13           TO B-F-IDX
068100       END-IF
068200
068300      IF (CLNT-PROFILE-ACCT-NO NOT =  CAL-KEY-ACCT-NO
068400        OR CLNT-PROFILE-SUB-ACCT NOT = CAL-KEY-SUB-ACCT)
068500        AND CAL-MAINT = 'N'
068600           GO TO EXIT-THE-MODULE
068700       END-IF
068800      END-PERFORM.
068900
069000 DB-DELETE-EXIT.   EXIT.
069100
069200 BYTE-BY-BYTE-COMPARE.
069300      MOVE SPACES                      TO BYTE-FIELD-ONE
069400                                          BYTE-FIELD-TWO.
069500      MOVE LSP-MAINT-DATA-DESCRIP-NEW(1:36)
069600                                       TO BYTE-FIELD-ONE(1:36).
069700      MOVE CAL-APPT-APPOINT-DATA(8:36) TO BYTE-FIELD-TWO(1:36).
069800
069900      PERFORM VARYING B-F-IDX FROM 1 BY 1
070000              UNTIL B-F-IDX > 36
070100
070200      IF B-F-1(B-F-IDX)(1:6) = SPACES
070300         GO TO BYTE-BY-BYTE-COMPARE-EXIT
070400       END-IF
070500
070600      IF B-F-1(B-F-IDX) NOT = B-F-2(B-F-IDX)
070700         ADD 1                    TO CAL-KEY-RECORD-NUMBER
070800         IF LSP-MODIFY
070900            GO TO DB-MODIFY-READ
071000         ELSE
071100            GO TO DB-DELETE-READ
071200        END-IF
071300       END-IF
071400      END-PERFORM.
071500
071600 BYTE-BY-BYTE-COMPARE-EXIT.
071700
071800
071900
072000
072100
072200 INPUT-FROM-CAL-MAINT.
103100
103100      IF THEY-HIT-END
103500         GO TO EXIT-THE-MODULE.
103500
072300      IF VIEW-FOR-NEW-EVENT
072400         MOVE TPS4010-DATE-START
072500                                  TO TPS4000A-DISPLAY-DATE
072600         GO TO SKIP-TPS4000A-DISPLAY
072700       END-IF.
072710
072711*JM9/97
103100*     IF THEY-HIT-END
103500*        GO TO EXIT-THE-MODULE
103700*     ELSE
072712      PERFORM SET-UP-THE-PANEL THRU
072713              SET-UP-THE-PANEL-EXIT.
                    

073000      MOVE 'ENTER TO PROCESS OR END TO GO BACK'
073100                       TO TPS4000A::MENU-LINE.

           MOVE TPS4000A-DISPLAY-DATE TO TPS4000A::DISPLAY-DATE.

           MOVE 1 TO TPS4010::SPLASH-SCREEN-FLAG.
           IF TPS4010-DISPLAY-FLAG = 0
               SET TPS4010::X-POINT TO WS-X-PARM
               SET TPS4010::Y-POINT TO WS-Y-PARM
               SET TPS4010::Width TO 1
               SET TPS4010::Height TO 1
               INVOKE TPS4010::Show
               SET TPS4010::Width TO 1271
               SET TPS4010::Height TO 793
               INVOKE TPS4010::Show
               MOVE 1 TO TPS4010-DISPLAY-FLAG
           END-IF.
           MOVE 0 TO TPS4010::SPLASH-SCREEN-FLAG.

           SET TPS4000A::X-POINT TO WS-X-PARM.
           SET TPS4000A::Y-POINT TO WS-Y-PARM.
           INVOKE TPS4000A::ShowDialog.
           MOVE TPS4000A::SCREEN-NAME TO SCREEN-NAME.
           MOVE TPS4000A::Location::X TO WS-X-PARM
             WS-CURRENT-X.
           MOVE TPS4000A::Location::Y TO WS-Y-PARM
             WS-CURRENT-Y.

           MOVE TPS4000A::DISPLAY-DATE TO TPS4000A-DISPLAY-DATE.

           INVOKE TPS4010::Hide.
           MOVE 0 TO TPS4010-DISPLAY-FLAG.

074100      IF TPS4000A::KEY-PRESSED = "End Key"
074200         IF VIEW-FOR-NEW-EVENT
074300            GO TO HOT-FIELD-1005-RETURN
074400           ELSE
074500            GO TO EXIT-THE-MODULE
074600          END-IF
074700       END-IF.
074800*JM09/99
074900      IF NOT TPS4000A::KEY-PRESSED = "Enter Key"
075100         MOVE 'HIT ENTER TO PROCESS DATA' TO
075200                                   TPS4010::MENU-LINE
075300         GO TO INPUT-FROM-CAL-MAINT
075400       END-IF.
075500
075600 SKIP-TPS4000A-DISPLAY.
075700    IF TPS4000A-DISPLAY-DATE > ZEROS
075800       MOVE TPS4000A-DISPLAY-DATE  TO
075900                                 WS-DATE-REFORM
076000       MOVE 11                   TO WS-DATE-PARAM
076100       MOVE SPACES               TO WS-DATE-EXTEND
076200       CALL TPSDATES USING WS-DATE-REQUEST
076300       MOVE WS-DATE-REFORM-LEN08 TO CAL-KEY-DATE
076400      ELSE
076500       MOVE ZEROS                TO CAL-KEY-DATE
076600     END-IF.
076700
076800    MOVE CLNT-PROFILE-ACCT-NO   TO CAL-KEY-ACCT-NO.
076900    MOVE CLNT-PROFILE-SUB-ACCT  TO CAL-KEY-SUB-ACCT.
077000    MOVE 0001                   TO CAL-KEY-RECORD-NUMBER.
077100    MOVE 01                     TO CAL-KEY-SUB-RECORD-NUMBER.
077200
077300    MOVE F-PRIME TO FILE-KEY.
077400    MOVE F-START TO FILE-ACTION.
077500    CALL TPSIO018 USING FILE-REQUEST TPS-CALENDAR-REC.
077600    IF NO-RECORD-WAS-FOUND
077700      IF VIEW-FOR-NEW-EVENT
077800         GO TO HOT-FIELD-1005-RETURN
077900        ELSE
078100         MOVE 'NO RECORDS FOUND DO YOU WANT TO ADD A RECORD'
078200                                TO TPS4010::MENU-LINE
078300         GO TO DISPLAY-PANEL-TPS4010
078400       END-IF
078500     END-IF.
078600
078700    IF NOT A-SUCCESSFUL-OPERATION
078800       MOVE 'CALENDAR' TO FILE-NAME
078900       MOVE 'START'    TO FILE-TEXT
079000       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT.
079100
079200*** INITIALIZE CAL-TABLE, CAL-TABLE1.
079300       PERFORM VARYING THE-INDEX FROM 1 BY 1
079400                 UNTIL THE-INDEX > 15
079500         MOVE SPACES        TO TABLE-EVENT(THE-INDEX)
079600                               TABLE-ATTEND(THE-INDEX)
079700         MOVE ZEROS         TO TABLE-NO(THE-INDEX)
079800                               TABLE-DATE(THE-INDEX)
079900                               TABLE-RECEIVED(THE-INDEX)
080000                               TABLE1-REC-NO(THE-INDEX)
080100                               TABLE1-SUB-REC-NO(THE-INDEX)
080200        END-PERFORM.
080300    MOVE ZERO                 TO WS-SUB.
080400    PERFORM READ-NEXT-CAL-REC THRU
080500            READ-NEXT-CAL-EXIT.
080600    GO TO MOVE-TABLE.
080700
080800 READ-NEXT-CAL-REC.
080900
081000    IF WS-SUB = 15
081100       GO TO READ-NEXT-CAL-EXIT.
081200
081300    MOVE F-PRIME TO FILE-KEY.
081400    MOVE F-READ-NEXT TO FILE-ACTION.
081500    CALL TPSIO018 USING FILE-REQUEST TPS-CALENDAR-REC.
081600    IF WS-FIRST-RECORD = 0
081700       IF END-OF-FILE-WAS-REACHED
081800          IF VIEW-FOR-NEW-EVENT
081900             GO TO HOT-FIELD-1005-RETURN
082000            ELSE
082200             MOVE 'NO RECORDS FOUND DO YOU WANT TO ADD A RECORD'
082300                                    TO TPS4010::MENU-LINE
082400             GO TO DISPLAY-PANEL-TPS4010
082500           END-IF
082600       ELSE
082700          MOVE 1                    TO WS-FIRST-RECORD
082800       END-IF
082900    END-IF.
083000
083100    IF END-OF-FILE-WAS-REACHED OR
083200       (CAL-KEY-ACCT-NO NOT = CLNT-PROFILE-ACCT-NO OR
083300        CAL-KEY-SUB-ACCT NOT = CLNT-PROFILE-SUB-ACCT)
083400       GO TO READ-NEXT-CAL-EXIT.
083500
083600    IF NOT A-SUCCESSFUL-OPERATION
083700       MOVE 'CALENDAR' TO FILE-NAME
083800       MOVE 'READN'    TO FILE-TEXT
083900       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
084000       GO TO EXIT-THE-MODULE.
084100*HERE
084200    IF CAL-KEY-SUB-RECORD-NUMBER NOT = 1
084300       GO TO READ-NEXT-CAL-REC.
084400
084500    IF CAL-APPT-ADD-DATE(1:1) = 8 OR 9
084600       GO TO READ-NEXT-CAL-REC.
084700
084800    ADD 1                     TO WS-SUB.
084900    MOVE CAL-KEY-DATE(3:6) TO
085000                                WS-DATE-REFORM.
085100    MOVE 5                    TO WS-DATE-PARAM.
085200    MOVE SPACES               TO WS-DATE-EXTEND.
085300    CALL TPSDATES USING WS-DATE-REQUEST.
085400    MOVE WS-DATE-REFORM-LEN06           TO TABLE-DATE(WS-SUB).
085500    MOVE WS-SUB                         TO TABLE-NO(WS-SUB).
085600    MOVE CAL-APPT-APPOINT-DATA(8:42)    TO TABLE-EVENT(WS-SUB).
085700
085800    IF CAL-APPT-ATTEND-OPTION = '0'
085900       MOVE 'Y'                      TO TABLE-ATTEND(WS-SUB)
086000     ELSE
086100    IF CAL-APPT-ATTEND-OPTION = '1'
086200       MOVE 'N'                      TO TABLE-ATTEND(WS-SUB)
086300     ELSE
086400       MOVE ' '                      TO TABLE-ATTEND(WS-SUB)
086500      END-IF
086600     END-IF.
086700
086800    IF CAL-APPT-RECEIVE-DATE NUMERIC
086900       IF CAL-APPT-RECEIVE-DATE > ZERO
087000          MOVE CAL-APPT-RECEIVE-DATE(3:6)
087100                                    TO WS-DATE-REFORM
087200          MOVE 5                    TO WS-DATE-PARAM
087300          MOVE SPACES               TO WS-DATE-EXTEND
087400          CALL TPSDATES USING WS-DATE-REQUEST
087500          MOVE WS-DATE-REFORM-LEN06 TO TABLE-RECEIVED(WS-SUB)
087600         END-IF
087700      END-IF.
087800** MOVE RECORD NUMBER TO SEPERATE TABLE TO USE FOR REC LOOKUP **
087900    MOVE CAL-KEY-RECORD-NUMBER      TO TABLE1-REC-NO(WS-SUB).
088000    MOVE CAL-KEY-SUB-RECORD-NUMBER  TO TABLE1-SUB-REC-NO(WS-SUB).
088100    GO TO READ-NEXT-CAL-REC.
088200
088300 READ-NEXT-CAL-EXIT.  EXIT.
088400
088500 READ-PREV-CAL-REC.
088600    IF WS-SUB = 15
088700       GO TO READ-PREV-CAL-EXIT.
088800    MOVE F-PRIME TO FILE-KEY.
088900    MOVE F-READ-PREVIOUS TO FILE-ACTION.
089000    CALL TPSIO018 USING FILE-REQUEST TPS-CALENDAR-REC.
089100    IF WS-FIRST-RECORD = 0
089200       IF END-OF-FILE-WAS-REACHED
089300          IF VIEW-FOR-NEW-EVENT
089400             GO TO HOT-FIELD-1005-RETURN
089500            ELSE
089700             MOVE 'NO RECORDS FOUND DO YOU WANT TO ADD A RECORD'
089800                                    TO TPS4010::MENU-LINE
089900             GO TO DISPLAY-PANEL-TPS4010
090000           END-IF
090100       ELSE
090200          MOVE 1                    TO WS-FIRST-RECORD
090300       END-IF
090400    END-IF.
090500
090600    IF END-OF-FILE-WAS-REACHED OR
090700       (CAL-KEY-ACCT-NO NOT = CLNT-PROFILE-ACCT-NO OR
090800        CAL-KEY-SUB-ACCT NOT = CLNT-PROFILE-SUB-ACCT)
090900       GO TO READ-PREV-CAL-EXIT.
091000
091100    IF NOT A-SUCCESSFUL-OPERATION
091200       MOVE 'CALENDAR' TO FILE-NAME
091300       MOVE 'READP'    TO FILE-TEXT
091400       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
091500       GO TO EXIT-THE-MODULE.
091600
091700    IF CAL-KEY-SUB-RECORD-NUMBER NOT = 1
091800       GO TO READ-PREV-CAL-REC.
091900
092000    IF CAL-APPT-ADD-DATE(1:1) = 8 OR 9
092100       GO TO READ-PREV-CAL-REC.
092200
092300    ADD 1                     TO WS-SUB.
092400    MOVE CAL-KEY-DATE(3:6) TO
092500                                WS-DATE-REFORM.
092600    MOVE 5                    TO WS-DATE-PARAM.
092700    MOVE SPACES               TO WS-DATE-EXTEND.
092800    CALL TPSDATES USING WS-DATE-REQUEST.
092900    MOVE WS-DATE-REFORM-LEN06        TO PRE-TABLE-DATE(WS-SUB).
093000    MOVE WS-SUB                      TO PRE-TABLE-NO(WS-SUB).
093100    MOVE CAL-APPT-APPOINT-DATA(8:42) TO PRE-TABLE-EVENT(WS-SUB).
093200    MOVE CAL-KEY-RECORD-NUMBER     TO PRE-TABLE-REC-NO(WS-SUB).
093300
093400    IF CAL-APPT-ATTEND-OPTION = '0'
093500       MOVE 'Y'                      TO PRE-TABLE-ATTEND(WS-SUB)
093600     ELSE
093700    IF CAL-APPT-ATTEND-OPTION = '1'
093800       MOVE 'N'                      TO PRE-TABLE-ATTEND(WS-SUB)
093900     ELSE
094000       MOVE ' '                      TO PRE-TABLE-ATTEND(WS-SUB)
094100      END-IF
094200     END-IF.
094300
094400    IF CAL-APPT-RECEIVE-DATE NUMERIC
094500       IF CAL-APPT-RECEIVE-DATE > ZERO
094600          MOVE CAL-APPT-RECEIVE-DATE(3:6)
094700                                    TO WS-DATE-REFORM
094800          MOVE 5                    TO WS-DATE-PARAM
094900          MOVE SPACES               TO WS-DATE-EXTEND
095000          CALL TPSDATES USING WS-DATE-REQUEST
095100          MOVE WS-DATE-REFORM-LEN06 TO PRE-TABLE-RECEIVED(WS-SUB)
095200         END-IF
095300      END-IF.
095400
095500    MOVE CAL-KEY-SUB-RECORD-NUMBER
095600                                TO PRE-TABLE-SUB-REC-NO(WS-SUB).
095700    GO TO READ-PREV-CAL-REC.
095800
095900 READ-PREV-CAL-EXIT.  EXIT.
096000
096100 START-CAL-READ.
096200
096300    MOVE F-PRIME TO FILE-KEY.
096400    MOVE F-START TO FILE-ACTION.
096500    CALL TPSIO018 USING FILE-REQUEST TPS-CALENDAR-REC.
096600
096700    IF NOT A-SUCCESSFUL-OPERATION
096800       MOVE 'CALENDAR' TO FILE-NAME
096900       MOVE 'STARTB4READ'    TO FILE-TEXT
097000       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT.
097100
097200 START-CAL-READ-EXIT.    EXIT.
097300
097400 REVERSE-TABLE.
097500
097600    MOVE PRE-TABLE-DATE(WS-SUB1)        TO TABLE-DATE(WS-SUB2).
097700    MOVE WS-SUB2                        TO TABLE-NO(WS-SUB2).
097800    MOVE PRE-TABLE-EVENT(WS-SUB1)       TO TABLE-EVENT(WS-SUB2).
097900    MOVE PRE-TABLE-ATTEND(WS-SUB1)      TO TABLE-ATTEND(WS-SUB2).
098000    MOVE PRE-TABLE-RECEIVED(WS-SUB1)  TO TABLE-RECEIVED(WS-SUB2).
098100** MOVE RECORD NUMBER TO SEPERATE TABLE TO USE FOR REC LOOKUP **
098200    MOVE PRE-TABLE-REC-NO(WS-SUB1) TO TABLE1-REC-NO(WS-SUB2).
098300    MOVE PRE-TABLE-SUB-REC-NO(WS-SUB1)
098400                               TO TABLE1-SUB-REC-NO(WS-SUB2).
098500    SUBTRACT 1       FROM WS-SUB1.
098600 REVERSE-TABLE-EXIT.  EXIT.
098700
098800
098900 MOVE-TABLE.
099000    IF NOT VIEW-FOR-NEW-EVENT
099100       MOVE SPACES            TO TPS4010::EVENT-NAME
099200                                 TPS4010::TIME-START-AM-PM
099300                                 TPS4010::TIME-END-AM-PM
099400                                 TPS4010::TIME-ZONE
099500                                 TPS4010::LOCATION
099600                                 TPS4010::GIVEN-BY
099700                                 TPS4010::RSVP-CONTACT
099800                                 TPS4010::HONORING-NAME
099900                                 TPS4010::DRESS-MEMO
100000                                 TPS4010-SURPRISE-INDIC
100100                                 TPS4010A::MEMO-LINE-01
100200                                 TPS4010A::MEMO-LINE-02
100300                                 TPS4010A::MEMO-LINE-03
100400                                 TPS4010::BY-WHO
100500       MOVE ZEROS             TO TPS4010-DATE-START
100600                                 TPS4010-DATE-END
100700                                 TPS4010::TIME-START-HH
100800                                 TPS4010::TIME-START-MM
100900                                 TPS4010::TIME-END-HH
101000                                 TPS4010::TIME-END-MM
101100                                 TPS4010-RSVP-DATE
101200                                 TPS4010-EVENT-COST
101300       END-IF.

           PERFORM VARYING TPS4001-IDX FROM 1 BY 1
                   UNTIL TPS4001-IDX > 15
                   MOVE TABLE-NO(TPS4001-IDX) TO
                        TPS4001-LINE-NO(TPS4001-IDX)
                   MOVE TABLE-DATE(TPS4001-IDX) TO
                        TPS4001-DATE(TPS4001-IDX)
                   MOVE TABLE-ATTEND(TPS4001-IDX) TO
                        TPS4001-ATTEND-Y-N(TPS4001-IDX)
                   MOVE TABLE-EVENT(TPS4001-IDX) TO
                        TPS4001-EVENT(TPS4001-IDX)
                   MOVE TABLE-RECEIVED(TPS4001-IDX) TO 
                        TPS4001-RECEIVE-DATE(TPS4001-IDX)
          END-PERFORM.

            
101500      MOVE ZERO             TO TPS4001::DISPLAY-LINE-NO.
101700      MOVE
101800      'PAGE UP/PAGE DOWN/ENTER TO PROCESS/END TO GO BACK'
101900                                TO TPS4001::MENU-LINE.
102100
134500      IF VIEW-FOR-NEW-EVENT AND LSP-PROG-RECEIVE
101700      MOVE
101800      'THIS IS A BROWSE FUNCTION ONLY...ANY KEY TO GO BACK'
101900                                TO TPS4001::MENU-LINE.
074800
102200 DISPLAY-DATE-INFO.

           MOVE 0 TO TPS4001-IDX.
           PERFORM VARYING THE-IDX-2 FROM 1 BY 1
             UNTIL THE-IDX-2 > 15
               MOVE TPS4001-LINE-NO(THE-IDX-2) TO
                 TPS4001::LINE-NO(TPS4001-IDX)
               MOVE TPS4001-DATE(THE-IDX-2) TO
                 TPS4001::DATE-1(TPS4001-IDX)
               MOVE TPS4001-ATTEND-Y-N(THE-IDX-2) TO
                 TPS4001::ATTEND-Y-N(TPS4001-IDX)
               MOVE TPS4001-EVENT(THE-IDX-2) TO
                 TPS4001::EVENT-1(TPS4001-IDX)
               MOVE TPS4001-RECEIVE-DATE(THE-IDX-2) TO
                 TPS4001::RECEIVE-DATE(TPS4001-IDX)
               COMPUTE TPS4001-IDX = TPS4001-IDX + 1
           END-PERFORM.


 
           SET TPS4001::X-POINT TO WS-X-PARM.
           SET TPS4001::Y-POINT TO WS-Y-PARM.
           INVOKE TPS4001::ShowDialog.
           MOVE TPS4001::Location::X TO WS-X-PARM
             WS-CURRENT-X.
           MOVE TPS4001::Location::Y TO WS-Y-PARM
             WS-CURRENT-Y.
           MOVE TPS4001::SCREEN-NAME TO SCREEN-NAME.


103000
103100    IF TPS4001::KEY-PRESSED = "End Key"
103200         IF VIEW-FOR-NEW-EVENT
103300            GO TO HOT-FIELD-1005-RETURN
103400           ELSE
103500            GO TO EXIT-THE-MODULE
103600          END-IF
103700    END-IF.
103800
134500      IF VIEW-FOR-NEW-EVENT AND LSP-PROG-RECEIVE
114800         GO TO DISPLAY-PANEL-TPS4010.
114800
103900*JM09/99     IF THEY-HIT-ENTER
104000*        MOVE 1                    TO TPS4001-DISPLAY-OPTION
104100*        MOVE 'HIT ENTER TO PROCESS DATA' TO
104200*                                     TPS4001-MENU-MSG
104300*        GO TO DISPLAY-DATE-INFO.
104400
104500      IF TPS4001::KEY-PRESSED = "Page Down Key"
104600         MOVE CLNT-PROFILE-ACCT-NO   TO CAL-KEY-ACCT-NO
104700         MOVE CLNT-PROFILE-SUB-ACCT  TO CAL-KEY-SUB-ACCT
104800         MOVE TABLE-DATE(WS-SUB) TO WS-DATE-REFORM
104900         MOVE 11                TO WS-DATE-PARAM
105000         MOVE SPACES            TO WS-DATE-EXTEND
105100         CALL TPSDATES USING WS-DATE-REQUEST
105200         MOVE WS-DATE-REFORM-LEN08  TO CAL-KEY-DATE
105300         MOVE TABLE1-REC-NO(WS-SUB) TO CAL-KEY-RECORD-NUMBER
105400         MOVE TABLE1-SUB-REC-NO(WS-SUB)
105500                                    TO CAL-KEY-SUB-RECORD-NUMBER
105600***      INITIALIZE CAL-TABLE, CAL-TABLE1
105700         PERFORM VARYING THE-INDEX FROM 1 BY 1
105800                    UNTIL THE-INDEX > 15
105900            MOVE SPACES        TO TABLE-EVENT(THE-INDEX)
106000                                  TABLE-ATTEND(THE-INDEX)
106100            MOVE ZEROS         TO TABLE-NO(THE-INDEX)
106200                                  TABLE-DATE(THE-INDEX)
106300                                  TABLE-RECEIVED(THE-INDEX)
106400                                  TABLE1-REC-NO(THE-INDEX)
106500                                  TABLE1-SUB-REC-NO(THE-INDEX)
106600           END-PERFORM
106700         MOVE ZERO              TO WS-SUB
106800         PERFORM START-CAL-READ THRU
106900                 START-CAL-READ-EXIT
107000         PERFORM READ-NEXT-CAL-REC THRU
107100                 READ-NEXT-CAL-EXIT
107200         GO TO MOVE-TABLE.
107300
107400      IF TPS4001::KEY-PRESSED = "Page Up Key"
107500         MOVE CLNT-PROFILE-ACCT-NO   TO CAL-KEY-ACCT-NO
107600         MOVE CLNT-PROFILE-SUB-ACCT  TO CAL-KEY-SUB-ACCT
107700         MOVE TABLE-DATE(01)    TO WS-DATE-REFORM
107800         MOVE 11                TO WS-DATE-PARAM
107900         MOVE SPACES            TO WS-DATE-EXTEND
108000         CALL TPSDATES USING WS-DATE-REQUEST
108100         MOVE WS-DATE-REFORM-LEN08  TO CAL-KEY-DATE
108200         MOVE TABLE1-REC-NO(01) TO CAL-KEY-RECORD-NUMBER
108300         MOVE TABLE1-SUB-REC-NO(01) TO CAL-KEY-SUB-RECORD-NUMBER
108400*******  INITIALIZE PRE-TABLE
108500         PERFORM VARYING THE-INDEX FROM 1 BY 1
108600                    UNTIL THE-INDEX > 15
108700            MOVE SPACES        TO PRE-TABLE-EVENT(THE-INDEX)
108800                                  PRE-TABLE-ATTEND(THE-INDEX)
108900            MOVE ZEROS         TO PRE-TABLE-NO(THE-INDEX)
109000                                  PRE-TABLE-DATE(THE-INDEX)
109100                                  PRE-TABLE-RECEIVED(THE-INDEX)
109200                                  PRE-TABLE-REC-NO(THE-INDEX)
109300                                  PRE-TABLE-SUB-REC-NO(THE-INDEX)
109400           END-PERFORM
109500         MOVE ZERO              TO WS-SUB
109600         PERFORM START-CAL-READ THRU
109700                 START-CAL-READ-EXIT
109800         PERFORM READ-PREV-CAL-REC THRU
109900                 READ-PREV-CAL-EXIT
110000         MOVE WS-SUB            TO WS-SUB1
110100***      INITIALIZE CAL-TABLE, CAL-TABLE1
110200         PERFORM VARYING THE-INDEX FROM 1 BY 1
110300                    UNTIL THE-INDEX > 15
110400            MOVE SPACES        TO TABLE-EVENT(THE-INDEX)
110500                                  TABLE-ATTEND(THE-INDEX)
110600            MOVE ZEROS         TO TABLE-NO(THE-INDEX)
110700                                  TABLE-DATE(THE-INDEX)
110800                                  TABLE-RECEIVED(THE-INDEX)
110900                                  TABLE1-REC-NO(THE-INDEX)
111000                                  TABLE1-SUB-REC-NO(THE-INDEX)
111100           END-PERFORM
111200         PERFORM REVERSE-TABLE VARYING WS-SUB2 FROM 1 BY 1
111300         UNTIL WS-SUB2 > WS-SUB
111400         GO TO MOVE-TABLE.
111500
111600      IF NOT TPS4001::KEY-PRESSED = "Enter Key"
111700          GO TO EXIT-THE-MODULE.
111800
111900      IF TPS4001::KEY-PRESSED = "Enter Key" AND
               TPS4001::DISPLAY-LINE-NO = ZERO
112100         MOVE 'ENTER SELECTION AND HIT ENTER TO PROCESS DATA'
112200                                TO TPS4001::MENU-LINE
112300         GO TO DISPLAY-DATE-INFO.
112400
112500**** READ SELECTED RECORD ******
112600    MOVE TPS4001::DISPLAY-LINE-NO            TO WS-TAB.
112700    MOVE TABLE-DATE(WS-TAB)   TO WS-DATE-REFORM.
112800    MOVE 11                   TO WS-DATE-PARAM.
112900    MOVE SPACES               TO WS-DATE-EXTEND.
113000    CALL TPSDATES USING WS-DATE-REQUEST.
113100    MOVE WS-DATE-REFORM-LEN08           TO CAL-KEY-DATE
113200                                           WS-KEY-DATE.
113300    MOVE CLNT-PROFILE-ACCT-NO           TO CAL-KEY-ACCT-NO.
113400    MOVE CLNT-PROFILE-SUB-ACCT          TO CAL-KEY-SUB-ACCT.
113500    MOVE TABLE1-REC-NO(WS-TAB)          TO CAL-KEY-RECORD-NUMBER.
113600    MOVE TABLE1-SUB-REC-NO(WS-TAB)  TO CAL-KEY-SUB-RECORD-NUMBER.
113700
113800    MOVE 'N'                TO DB-MAINT.
113900    PERFORM FILL-PANEL-TPS4010 THRU
114000            FILL-PANEL-TPS4010-EXIT.
114100    IF DB-MAINT = 'Y'
114200       PERFORM DB-MAINT-RETURN THRU
114300               DB-MAINT-RETURN-EXIT.
114400
114500*12/06 MOVE '0'               TO VIEW-FOR-NEW-FLAG.
114600    MOVE 5                 TO TPS4010-ACTIVE-FIELD .
114800    GO TO DISPLAY-PANEL-TPS4010.
114900
115000 INPUT-FROM-CAL-MAINT-EXIT.   EXIT.
115100
115200 DB-MAINT-RETURN.

115400    MOVE 'ENTER KEY TO PROCESS OR END KEY TO GO BACK'
115500                                TO TPS4010C-MENU-LINE.

           INITIALIZE  TPS4010C-CL-WINDOW-FLAG
                       TPS4010C-END-FLAG                  
                       TPS4010C-CR-FLAG.                 

           MOVE TPS4010C-DATA-BLOCK-VERSION-NO 
                                 TO DS-DATA-BLOCK-VERSION-NO.
           MOVE TPS4010C-VERSION-NO TO DS-VERSION-NO.
           MOVE WS-CURRENT-X TO TPS4010C-DSMOVSZ-X.
           MOVE WS-CURRENT-Y TO TPS4010C-DSMOVSZ-Y.
           MOVE DS-PUSH-SET TO DS-CONTROL.
           MOVE "TPS4010C"  TO DS-SET-NAME.
           CALL "DSGRUN" USING DS-CONTROL-BLOCK
                               TPS4010C-DATA-BLOCK.

          MOVE TPS4010C-DSMOVSZ-X TO WS-CURRENT-X.
          MOVE TPS4010C-DSMOVSZ-Y TO WS-CURRENT-Y.
          MOVE WS-CURRENT-X TO WS-X-PARM.
          MOVE WS-CURRENT-Y TO WS-Y-PARM.

      *********** CLOSE POPUP TPS4010C ***********************

           MOVE TPS4010C-DATA-BLOCK-VERSION-NO 
                                 TO DS-DATA-BLOCK-VERSION-NO.
           MOVE TPS4010C-VERSION-NO TO DS-VERSION-NO.
           MOVE WS-CURRENT-X TO TPS4010C-DSMOVSZ-X.
           MOVE WS-CURRENT-Y TO TPS4010C-DSMOVSZ-Y.
           MOVE DS-QUIT-SET TO DS-CONTROL.
           MOVE "TPS4010C"  TO DS-SET-NAME.
           CALL "DSGRUN" USING DS-CONTROL-BLOCK
                               TPS4010C-DATA-BLOCK.
      ********************************************************

116400
116500    IF TPS4010C-END-FLAG-TRUE OR TPS4010C-CL-WINDOW-FLAG-TRUE
116600       IF VIEW-FOR-NEW-EVENT
116700          GO TO HOT-FIELD-1005-RETURN
116800         ELSE
116900          GO TO EXIT-THE-MODULE
117000       END-IF
117100     END-IF.
117200
117300    IF NOT TPS4010C-CR-FLAG-TRUE
117500       MOVE 'HIT ENTER TO PROCESS DATA' TO
117600                                   TPS4010C-MENU-LINE
117700       GO TO DB-MAINT-RETURN.
117800
117900    IF TPS4010C-DB-RETURN = 'Y'
118000       GO TO EXIT-THE-MODULE.
118100
118200    IF TPS4010C-DB-RETURN = 'N'
118300       MOVE ZERO             TO TPS4001::DISPLAY-LINE-NO
118500       MOVE
118600       'PAGE UP/PAGE DOWN/ENTER TO PROCESS/END TO GO BACK'
118700                             TO TPS4001::MENU-LINE
118900       GO TO DISPLAY-DATE-INFO.
119000
119100 DB-MAINT-RETURN-EXIT.
119200
119300
119400 FILL-PANEL-TPS4010.
119500    MOVE 'Y'              TO CAL-MAINT.
100100    MOVE SPACES           TO TPS4010A::MEMO-LINE-01
100200                             TPS4010A::MEMO-LINE-02
100300                             TPS4010A::MEMO-LINE-03.
119600    MOVE CLNT-PROFILE-ACCT-NO OF LS-PROFL TO
119700                          TPS4010::CLNT-ACCOUNT.
119800    MOVE CLNT-PROFILE-LAST-NAME OF LS-PROFL TO
119900                          TPS4010::CLNT-LAST-NAME.
120000    MOVE CLNT-PROFILE-FIRST-NAME OF LS-PROFL TO
120100                          TPS4010::CLNT-FIRST-NAME.
120200    MOVE CLNT-PROFILE-MDDL-INIT  OF LS-PROFL TO
120300                          TPS4010::CLNT-MIDDLE-INIT.
120400
120500 READ-CAL-REC.
120600    MOVE F-PRIME TO FILE-KEY.
120700    MOVE F-READ  TO FILE-ACTION.
120800    CALL TPSIO018 USING FILE-REQUEST TPS-CALENDAR-REC.
120900    IF NO-RECORD-WAS-FOUND
121000       GO TO FILL-PANEL-TPS4010-EXIT.
121100
121200    IF NOT A-SUCCESSFUL-OPERATION
121300       MOVE 'CALENDAR' TO FILE-NAME
121400       MOVE 'READ '    TO FILE-TEXT
121500       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
121600       GO TO EXIT-THE-MODULE.
121700
121800    IF CAL-APPT-APPOINT-DATA(1:6) = 'Event:'
121900       MOVE CAL-APPT-APPOINT-DATA(8:43) TO 
             TPS4010::EVENT-NAME
122000       MOVE CAL-APPT-PRINT-OPTION  TO WS-APPT-PRINT-OPTION
122100       MOVE CAL-APPT-ATTEND-OPTION TO WS-APPT-ATTEND-OPTION
122200       IF CAL-APPT-RECEIVE-DATE(1:4) NUMERIC AND
122300          CAL-APPT-RECEIVE-DATE(5:4) = SPACES
122400          MOVE 'Y'                TO DB-MAINT
122200       ELSE
064500          MOVE CAL-KEY-ACCT-NO       TO HOLD-MAIL-ACCT-NO
064600          MOVE CAL-KEY-SUB-ACCT      TO HOLD-MAIL-SUB-ACCT
122200          MOVE CAL-APPT-RECEIVE-DATE TO HOLD-MAIL-RECEIVE-DATE
064800          MOVE CAL-APPT-RECEIVE-NUMBER
064800                                     TO HOLD-MAIL-RECEIVE-NUMBER.
122500*JM3/31
122600*
122700    MOVE SPACES                    TO TPS4010::BY-WHO.
122800    IF CAL-APPT-ADD-DATE = CAL-APPT-CHANGE-DATE
122900       MOVE '  ADDED'              TO WHAT-DID-THEY-DO
123000       MOVE CAL-APPT-ADD-PASSWORD  TO WHO-DID-IT
123100       MOVE CAL-APPT-ADD-DATE(5:2) TO WHEN-MM
123200       MOVE CAL-APPT-ADD-DATE(7:2) TO WHEN-DD
123300       MOVE CAL-APPT-ADD-DATE(3:2) TO WHEN-YY
123400     ELSE
123500       MOVE 'UPDATED'                 TO WHAT-DID-THEY-DO
123600       MOVE CAL-APPT-CHANGE-PASSWORD  TO WHO-DID-IT
123700       MOVE CAL-APPT-CHANGE-DATE(5:2) TO WHEN-MM
123800       MOVE CAL-APPT-CHANGE-DATE(7:2) TO WHEN-DD
123900       MOVE CAL-APPT-CHANGE-DATE(3:2) TO WHEN-YY
124000     END-IF.
124100    MOVE WS-DONE-BY-WHO            TO TPS4010::BY-WHO.
124200
124300    IF CAL-APPT-APPOINT-DATA(1:6) = 'Date: '
124400       MOVE CAL-APPT-APPOINT-DATA(7:2)
124500                                TO TPS4010-DATE-START(1:2)
124500                                   WS-ENTRY-DATE(1:2)
124600       MOVE CAL-APPT-APPOINT-DATA(10:2)
124700                                TO TPS4010-DATE-START(3:2)
124500                                   WS-ENTRY-DATE(3:2)
124800       MOVE CAL-APPT-APPOINT-DATA(13:2)
124900                                TO TPS4010-DATE-START(5:2)
124500                                   WS-ENTRY-DATE(5:2)
125000       MOVE CAL-APPT-APPOINT-DATA(18:2)
125100                                TO TPS4010-DATE-END(1:2)
125200       MOVE CAL-APPT-APPOINT-DATA(21:2)
125300                                TO TPS4010-DATE-END(3:2)
125400       MOVE CAL-APPT-APPOINT-DATA(24:2)
125500                                TO TPS4010-DATE-END(5:2)
125600       INSPECT CAL-APPT-APPOINT-DATA(33:4)
125700               REPLACING ALL X'20' BY X'30'
125800       MOVE CAL-APPT-APPOINT-DATA(33:2)
125900                                TO TPS4010::TIME-START-HH
126000       MOVE CAL-APPT-APPOINT-DATA(35:2)
126100                                TO TPS4010::TIME-START-MM
126200       MOVE CAL-APPT-APPOINT-DATA(38:2)
126300                                TO TPS4010::TIME-START-AM-PM
126400       INSPECT CAL-APPT-APPOINT-DATA(43:4)
126500               REPLACING ALL X'20' BY X'30'
126600       MOVE CAL-APPT-APPOINT-DATA(43:2)
126700                                TO TPS4010::TIME-END-HH
126800       MOVE CAL-APPT-APPOINT-DATA(45:2)
126900                                TO TPS4010::TIME-END-MM
127000       MOVE CAL-APPT-APPOINT-DATA(48:2)
127100                                TO TPS4010::TIME-END-AM-PM
127100      ELSE
127200    IF CAL-APPT-APPOINT-DATA(1:10) = 'Given by: '
127300       MOVE CAL-APPT-APPOINT-DATA(11:40) TO TPS4010::GIVEN-BY
127100      ELSE
127400    IF CAL-APPT-APPOINT-DATA(1:6) = 'RSVP: '
127500       MOVE CAL-APPT-APPOINT-DATA(7:2)
127600                                TO TPS4010-RSVP-DATE(1:2)
127700       MOVE CAL-APPT-APPOINT-DATA(10:2)
127800                                TO TPS4010-RSVP-DATE(3:2)
127900       MOVE CAL-APPT-APPOINT-DATA(13:2)
128000                                TO TPS4010-RSVP-DATE(5:2)
128100       MOVE CAL-APPT-APPOINT-DATA(25:26)
128200                                TO TPS4010::RSVP-CONTACT
127100      ELSE
128300    IF CAL-APPT-APPOINT-DATA(1:10) = 'Honoring: '
128400       MOVE CAL-APPT-APPOINT-DATA(11:40)
128500                                TO TPS4010::HONORING-NAME
127100      ELSE
128600    IF CAL-APPT-APPOINT-DATA(1:6) = 'Cost: '
128700       MOVE CAL-APPT-APPOINT-DATA(8:8)
128800                                TO TPS4010-EVENT-COST
128900       DIVIDE TPS4010-EVENT-COST BY 100 GIVING
129000                                   TPS4010-EVENT-COST
127100      ELSE
129100    IF CAL-APPT-APPOINT-DATA(17:10) = 'Surprise: '
129200       MOVE CAL-APPT-APPOINT-DATA(28:1)
129300                                TO TPS4010-SURPRISE-INDIC
127100      ELSE
129400    IF CAL-APPT-APPOINT-DATA(30:07) = 'Dress: '
129500       MOVE CAL-APPT-APPOINT-DATA(37:14)
129600                                TO TPS4010::DRESS-MEMO
127100      ELSE
129700    IF CAL-APPT-APPOINT-DATA(1:10) = 'Location: '
129800       MOVE CAL-APPT-APPOINT-DATA(11:40)
129900                                TO TPS4010::LOCATION
127100      ELSE
127100*03/06/98
121800    IF CAL-APPT-APPOINT-DATA(1:6) NOT = 'Event:'
100100       IF TPS4010A::MEMO-LINE-01 = SPACES
129800          MOVE CAL-APPT-APPOINT-DATA(01:40)
100200                          TO TPS4010A::MEMO-LINE-01
127100         ELSE
100100       IF TPS4010A::MEMO-LINE-02 = SPACES
129800          MOVE CAL-APPT-APPOINT-DATA(01:40)
100200                          TO TPS4010A::MEMO-LINE-02
127100         ELSE
100100       IF TPS4010A::MEMO-LINE-03 = SPACES
129800          MOVE CAL-APPT-APPOINT-DATA(01:40)
100200                          TO TPS4010A::MEMO-LINE-03
127100        END-IF
127100     END-IF.
130000    ADD 1               TO CAL-KEY-SUB-RECORD-NUMBER.
130100    GO TO READ-CAL-REC.

130200 FILL-PANEL-TPS4010-EXIT.   EXIT.
130300
130400 INPUT-FROM-RECEIVE.
130500      MOVE 1                   TO INPUT-FLAG.
130600      MOVE CLNT-PROFILE-ACCT-NO OF LS-PROFL TO
130700                            WS-MEMO-ACCT-NO.
130800      MOVE CLNT-PROFILE-SUB-ACCT OF LS-PROFL TO
130900                            WS-MEMO-SUB-ACCT.
131000
131001      PERFORM SET-UP-THE-PANEL THRU
131002              SET-UP-THE-PANEL-EXIT.
131010
134110      MOVE 0                 TO ENTERED-EVENT-DATE-FLAG.
134200      MOVE 5                 TO TPS4010-ACTIVE-FIELD .
134400
134500      IF     LSP-PROG-RECEIVE AND LSP-PROG-ID = 'TPS1010 '
134600         AND MAIL-CALENDAR-XREF OF LS-RECVE IS NUMERIC
134700         AND MAIL-CALENDAR-XREF OF LS-RECVE IS GREATER THAN 0
134800         PERFORM MAINTENANCE-FUNCTION
134900            THRU MAINTENANCE-FUNCTION-EXIT
135000      END-IF.
135100
135200     GO TO DISPLAY-PANEL-TPS4010.
135201
135202 SET-UP-THE-PANEL.
135203      MOVE CLNT-PROFILE-ACCT-NO OF LS-PROFL TO
135204                            TPS4010::CLNT-ACCOUNT.
135205      MOVE CLNT-PROFILE-LAST-NAME OF LS-PROFL TO
135206                            TPS4010::CLNT-LAST-NAME.
135207      MOVE CLNT-PROFILE-FIRST-NAME OF LS-PROFL TO
135208                            TPS4010::CLNT-FIRST-NAME.
135209      MOVE CLNT-PROFILE-MDDL-INIT  OF LS-PROFL TO
135210                            TPS4010::CLNT-MIDDLE-INIT.
135211      MOVE SPACES            TO TPS4010::EVENT-NAME
135212                                TPS4010::TIME-START-AM-PM
135213                                TPS4010::TIME-END-AM-PM
135214                                TPS4010::TIME-ZONE
135215                                TPS4010::LOCATION
135216                                TPS4010::GIVEN-BY
135217                                TPS4010::RSVP-CONTACT
135218                                TPS4010::HONORING-NAME
135219                                TPS4010::DRESS-MEMO
135220                                TPS4010-SURPRISE-INDIC
135221                                TPS4010A::MEMO-LINE-01
135222                                TPS4010A::MEMO-LINE-02
135223                                TPS4010A::MEMO-LINE-03
135224                                TPS4010::BY-WHO.
135225      MOVE ZEROS             TO TPS4010-DATE-START
135226                                TPS4010-DATE-END
135227                                TPS4010::TIME-START-HH
135228                                TPS4010::TIME-START-MM
135229                                TPS4010::TIME-END-HH
135230                                TPS4010::TIME-END-MM
135231                                TPS4010-RSVP-DATE
135232                                TPS4010-EVENT-COST.


        
        MOVE 5 TO TPS4010-ACTIVE-FIELD .
        
135233 SET-UP-THE-PANEL-EXIT. EXIT.
135234
135235
135236
135237
135240 DISPLAY-PANEL-TPS4010.
135300*TS IF THEY-HIT-ALT-ENTER AND WS-DISPLAY-OPTION = 0 OR
135400*TS    LSP-ACTION = 0
       
          IF TPS4010-ACTIVE-FIELD = 0 
             MOVE 5 TO TPS4010-ACTIVE-FIELD 
          END-IF.
             
135500    IF TPS4010::KEY-PRESSED = "Enter Key" AND
             WS-DISPLAY-OPTION = 0 AND
135400       LSP-ACTION = 2
135700      MOVE
135800     'F1-MEMO LINES/F2-DELETE EVENT/F3-RESPONSE/ENTER OR END KEY'
135900                                TO TPS4010::MENU-LINE
136100    ELSE
142600    IF TPS4010::KEY-PRESSED = "F2 Key" AND
             WS-DISPLAY-OPTION = 1
135600        NEXT SENTENCE
136100    ELSE
135500    IF TPS4010::KEY-PRESSED = "Enter Key" AND
             WS-DISPLAY-OPTION = 0 OR
135400       LSP-ACTION = 0
            IF WS-TEMP-MSG-FLAG = '0'
              CONTINUE
            ELSE
135700        MOVE
135800        'F1-MEMO LINES/F2-DELETE EVENT/ENTER OR END KEY'
135900                                TO TPS4010::MENU-LINE
            END-IF
136100    END-IF.


           MOVE TPS4010-DATE-START TO TPS4010::DATE-START.
           MOVE TPS4010-DATE-END TO TPS4010::DATE-END.
           MOVE TPS4010-RSVP-DATE TO TPS4010::RSVP-DATE.
           MOVE TPS4010-EVENT-COST TO TPS4010::EVENT-COST.
           MOVE TPS4010-SURPRISE-INDIC TO TPS4010::SURPRISE-INDIC.
           MOVE TPS4010-ACTIVE-FIELD TO TPS4010::ACTIVE-FIELD.

           SET TPS4010::X-POINT TO WS-X-PARM.
           SET TPS4010::Y-POINT TO WS-Y-PARM.
           INVOKE TPS4010::ShowDialog.
           MOVE TPS4010::Location::X TO WS-X-PARM
             WS-CURRENT-X.
           MOVE TPS4010::Location::Y TO WS-Y-PARM
             WS-CURRENT-Y.
           MOVE TPS4010::SCREEN-NAME TO SCREEN-NAME.

           MOVE TPS4010::DATE-START TO TPS4010-DATE-START.
           MOVE TPS4010::DATE-END TO TPS4010-DATE-END.
           MOVE TPS4010::RSVP-DATE TO TPS4010-RSVP-DATE.
           MOVE TPS4010::EVENT-COST TO TPS4010-EVENT-COST.
           MOVE TPS4010::SURPRISE-INDIC TO TPS4010-SURPRISE-INDIC.
           MOVE TPS4010::ACTIVE-FIELD TO TPS4010-ACTIVE-FIELD.


      *   IF TPS4010::KEY-PRESSED = "Enter Key" OR
      *      TPS4010::KEY-PRESSED = "F1 Key" OR
      *      TPS4010::KEY-PRESSED = "F2 Key" OR
      *      TPS4010::KEY-PRESSED = "F3 Key"
      *      INITIALIZE TPS4010::HOT-FIELD
      *   END-IF.

137000    MOVE '1' TO WS-TEMP-MSG-FLAG.


137100      IF THEY-HIT-ALT-TAB
137200         IF TPS4010-ACTIVE-FIELD > 5
137300            SUBTRACT 1        FROM TPS4010-ACTIVE-FIELD
137400           END-IF
137500         GO TO DISPLAY-PANEL-TPS4010
137600       END-IF.
138000
138100      IF TPS4010::KEY-PRESSED = "End Key"
138200          GO TO EXIT-THE-MODULE.
138300
138400*JM09/99     IF THEY-HIT-ENTER
138500*     MOVE 1                    TO TPS4010-DISPLAY-OPTION
138600*     MOVE 'HIT ENTER TO PROCESS DATA' TO
138700*                                  TPS4010-MENU-MSG
136000*                                  TPS4010::MENU-LINE
138800*     GO TO DISPLAY-PANEL-TPS4010.
138900
139000      EVALUATE TPS4010::HOT-FIELD
139100           WHEN 1005 GO TO HOT-FIELD-1005
139200           WHEN 1006 GO TO HOT-FIELD-1006
139300           WHEN 1007 GO TO HOT-FIELD-1007
139400           WHEN 1008 GO TO HOT-FIELD-1008
139500           WHEN 1009 GO TO HOT-FIELD-1009
139600           WHEN 1010 GO TO HOT-FIELD-1010
139700           WHEN 1011 GO TO HOT-FIELD-1011
139800           WHEN 1012 GO TO HOT-FIELD-1012
139900           WHEN 1013 GO TO HOT-FIELD-1013
139900           WHEN 1014 GO TO HOT-FIELD-1014
139900           WHEN 1015 GO TO HOT-FIELD-1015
139900           WHEN 1016 GO TO HOT-FIELD-1016
140000           WHEN 1017 GO TO HOT-FIELD-1017
140000           WHEN 1018 GO TO HOT-FIELD-1018
140000           WHEN 1019 GO TO HOT-FIELD-1019
140000           WHEN 1020 GO TO HOT-FIELD-1020
140000           WHEN 1021 GO TO HOT-FIELD-1021
140100           WHEN 1022 GO TO HOT-FIELD-1022
140200      END-EVALUATE.
140300
140400      MOVE 'N'            TO CHANGE-RECORD
140500
140600      IF TPS4010::KEY-PRESSED = "Enter Key" AND
               LSP-ACTION = 0
140700         GO TO PROCESS-PANEL-TPS4010.
140800
140900      IF TPS4010::KEY-PRESSED = "Enter Key" AND
               WS-DISPLAY-OPTION = 0
141000         MOVE 1              TO WS-DISPLAY-OPTION
141200         MOVE
141300         'HIT ENTER KEY TO CONFIRM CHANGES OR END KEY TO GO BACK'
141400                                TO TPS4010::MENU-LINE
141500         GO TO DISPLAY-PANEL-TPS4010.
141600
141700      IF TPS4010::KEY-PRESSED = "Enter Key" AND
               WS-DISPLAY-OPTION = 1
141800         MOVE 0              TO WS-DISPLAY-OPTION
141900         MOVE 'Y'            TO CHANGE-RECORD
142000         GO TO PROCESS-PANEL-TPS4010.
142100*JM      PERFORM DB-DELETE THRU DB-DELETE-EXIT
142200*        GO TO PROCESS-PANEL-TPS4010.
142300
142400      IF TPS4010::KEY-PRESSED = "F1 Key"
               GO TO SETUP-PANEL-TPS4010A
            END-IF.
142500
142600      IF TPS4010::KEY-PRESSED = "F2 Key" AND
              WS-DISPLAY-OPTION = 0
               MOVE 1                TO WS-DISPLAY-OPTION
142800         MOVE
142900         'HIT F2 KEY TO CONFIRM DELETE OR END KEY TO GO BACK'
143000                                TO TPS4010::MENU-LINE
               MOVE '0'               TO WS-TEMP-MSG-FLAG
143100         GO TO DISPLAY-PANEL-TPS4010.
143200
143300      IF TPS4010::KEY-PRESSED = "F2 Key" AND
              WS-DISPLAY-OPTION = 1
143400         MOVE 0              TO WS-DISPLAY-OPTION
143500         PERFORM DB-DELETE THRU
143600                 DB-DELETE-EXIT
143700         GO TO INPUT-FROM-CAL-MAINT.
143800
143900      IF TPS4010::KEY-PRESSED = "F3 Key"
144000         MOVE SPACES         TO TPS4010B::ATTEND
144100                                TPS4010B::PRINT-1
144300         MOVE 'ENTER TO PROCESS DATA OR END KEY TO GO BACK'
144400                             TO TPS4010B::MENU-LINE

144600         PERFORM DISPLAY-PANEL-TPS4010B THRU
144700                 DISPLAY-PANEL-TPS4010B-EXIT
144800         GO TO INPUT-FROM-CAL-MAINT.
144900
145000      GO TO DISPLAY-PANEL-TPS4010.
145100
145200 HOT-FIELD-1005.
145300      IF TPS4010-DATE-START = ZEROS
145400         MOVE 5                TO TPS4010-ACTIVE-FIELD 
145700         MOVE 1                TO WS-DISPLAY-OPTION
               MOVE 0                TO WS-TEMP-MSG-FLAG
145800         MOVE 'A "FROM" DATE REQUIRED' TO
145900                                   TPS4010::MENU-LINE
146000         GO TO DISPLAY-PANEL-TPS4010.
134400*JM9/97 ****** IF RECORD ALREADY EXITS GO TO MAINTENANCE ******
134500      IF     LSP-PROG-RECEIVE AND LSP-PROG-ID = 'TPS1010 '
134600         AND MAIL-CALENDAR-XREF OF LS-RECVE > ZERO
134900         GO TO DISPLAY-PANEL-TPS4010.
146100
146200      IF LSP-ACTION NOT = ZEROS OR
146300             CAL-MAINT = 'Y'
146400         MOVE 6                 TO TPS4010-ACTIVE-FIELD 
146600         MOVE 1                 TO WS-DISPLAY-OPTION
146800         MOVE ' ENTER EVENT END DATE OR TAB THRU FIELD'
146900                                TO TPS4010::MENU-LINE
               MOVE 0                TO WS-TEMP-MSG-FLAG
147000         GO TO DISPLAY-PANEL-TPS4010.
147100

147101      IF ENTERED-EVENT-DATE
147102         MOVE 6                 TO TPS4010-ACTIVE-FIELD 
147104         MOVE 1                 TO WS-DISPLAY-OPTION
147106         MOVE ' ENTER EVENT END DATE OR TAB THRU FIELD'
147107                                TO TPS4010::MENU-LINE
               MOVE 0                TO WS-TEMP-MSG-FLAG
147108         GO TO DISPLAY-PANEL-TPS4010.
147109
147110      MOVE '1'                  TO ENTERED-EVENT-DATE-FLAG.
147120
147200      MOVE '1'                  TO VIEW-FOR-NEW-FLAG.
147300      MOVE '1'                  TO STARTED-AS-NEW-FLAG.
147400*JM10/97   MOVE '2'                  TO LSP-ACTION.
147500      MOVE TPS4010-DATE-START TO WS-FROM-DATE-MDY.
147600      GO TO INPUT-FROM-CAL-MAINT.
147700
147800 HOT-FIELD-1005-RETURN.
147900      MOVE '0'               TO VIEW-FOR-NEW-FLAG.
148000      MOVE '0'               TO STARTED-AS-NEW-FLAG.
148100      MOVE '0'               TO LSP-ACTION.
148200      MOVE 'N'               TO CAL-MAINT.
148300      MOVE SPACES            TO TPS4010::EVENT-NAME
148400                                TPS4010::TIME-START-AM-PM
148500                                TPS4010::TIME-END-AM-PM
148600                                TPS4010::TIME-ZONE
148700                                TPS4010::LOCATION
148800                                TPS4010::GIVEN-BY
148900                                TPS4010::RSVP-CONTACT
149000                                TPS4010::HONORING-NAME
149100                                TPS4010::DRESS-MEMO
149200                                TPS4010-SURPRISE-INDIC
149300                                TPS4010A::MEMO-LINE-01
149400                                TPS4010A::MEMO-LINE-02
149500                                TPS4010A::MEMO-LINE-03
149600                                TPS4010::BY-WHO.
149700      MOVE ZEROS             TO TPS4010-DATE-START
149800                                TPS4010-DATE-END
149900                                TPS4010::TIME-START-HH
150000                                TPS4010::TIME-START-MM
150100                                TPS4010::TIME-END-HH
150200                                TPS4010::TIME-END-MM
150300                                TPS4010-RSVP-DATE
150400                                TPS4010-EVENT-COST.
150500      MOVE WS-FROM-DATE-MDY     TO TPS4010-DATE-START.
150600      MOVE 6                    TO TPS4010-ACTIVE-FIELD .
            MOVE '0'                   TO WS-TEMP-MSG-FLAG.
150800      MOVE 1                    TO WS-DISPLAY-OPTION.
151000      MOVE ' ENTER EVENT END DATE OR TAB THRU FIELD'
151100                                TO TPS4010::MENU-LINE.
151200      GO TO DISPLAY-PANEL-TPS4010.
151300
151400 HOT-FIELD-1006.

151500      IF TPS4010-DATE-END = ZEROS
151600         MOVE 7                TO TPS4010-ACTIVE-FIELD 
151900         MOVE 'ENTER EVENT NAME       ' TO
152000                                   TPS4010::MENU-LINE
152100         MOVE 1                TO WS-DISPLAY-OPTION
               MOVE '0'              TO WS-TEMP-MSG-FLAG
152200         GO TO DISPLAY-PANEL-TPS4010.
152300
152400      MOVE 11                   TO WS-DATE-PARAM.
152500      MOVE TPS4010-DATE-START TO WS-DATE-REFORM.
152600      MOVE SPACES               TO WS-DATE-EXTEND.
152700         CALL TPSDATES USING WS-DATE-REQUEST.
152800      MOVE WS-DATE-REFORM-LEN08 TO WS-FROM-DATE-CYMD.
152900
153000      MOVE 11                   TO WS-DATE-PARAM.
153100      MOVE TPS4010-DATE-END TO WS-DATE-REFORM.
153200      MOVE SPACES               TO WS-DATE-EXTEND.
153300         CALL TPSDATES USING WS-DATE-REQUEST.
153400      MOVE WS-DATE-REFORM-LEN08 TO WS-TO-DATE-CYMD.
153500
153600      IF WS-TO-DATE-CYMD < WS-FROM-DATE-CYMD
153700         MOVE 5                TO TPS4010-ACTIVE-FIELD 
154000         MOVE '   INVALID DATE RANGE     ' TO
154100                                   TPS4010::MENU-LINE
154200         MOVE 1                TO WS-DISPLAY-OPTION
154300         GO TO DISPLAY-PANEL-TPS4010.
154400
154500*12/27IF LSP-ACTION NOT = ZEROS
154600*  "     MOVE 7                 TO TPS4010-CURSOR-FIELD
154700*  "     MOVE 0                 TO TPS4010-CURSOR-OFFSET
154800*  "     MOVE 0                 TO TPS4010-DISPLAY-OPTION
154900*  "     GO TO DISPLAY-PANEL-TPS4010.
155000*  "
155100*  "  MOVE '1'                  TO VIEW-FOR-NEW-FLAG.
155200*12/27GO TO INPUT-FROM-CAL-MAINT.
155300
155400      MOVE 7                 TO TPS4010-ACTIVE-FIELD .
155700      MOVE '   ENTER EVENT NAME       '
155800                             TO TPS4010::MENU-LINE.
155900      MOVE 1                 TO WS-DISPLAY-OPTION.
156000      GO TO DISPLAY-PANEL-TPS4010.
156100
156200
156300
156400 HOT-FIELD-1007.

156500      IF TPS4010::EVENT-NAME = SPACES
156600         MOVE 7                TO TPS4010-ACTIVE-FIELD 
156900         MOVE 'EVENT NAME IS REQUIRED A ENTRY' TO
157000                                   TPS4010::MENU-LINE
157100         MOVE 1                TO WS-DISPLAY-OPTION
               MOVE '0'              TO WS-TEMP-MSG-FLAG
157200         GO TO DISPLAY-PANEL-TPS4010.
157300
           IF TPS4010-ACTIVE-FIELD = '0007'
157200         GO TO DISPLAY-PANEL-TPS4010.

157400      MOVE 8                    TO TPS4010-ACTIVE-FIELD .
157700      MOVE ' ENTER EVENT START TIME OR TAB THRU FIELD'
157800                                TO TPS4010::MENU-LINE.
157900      MOVE 1                    TO WS-DISPLAY-OPTION.
            MOVE '0'                  TO WS-TEMP-MSG-FLAG.
158000      GO TO DISPLAY-PANEL-TPS4010.
158100
158200
158300 HOT-FIELD-1008.

158400      IF TPS4010::TIME-START-HH = ZEROS
158500         MOVE SPACES           TO TPS4010::TIME-START-AM-PM
158600         MOVE ZEROS            TO TPS4010::TIME-END-HH
158700                                  TPS4010::TIME-END-MM
158800         MOVE SPACES           TO TPS4010::TIME-END-AM-PM
158900         MOVE SPACES           TO TPS4010::TIME-ZONE
159000*10/28   MOVE 13               TO TPS4010-CURSOR-FIELD
159100         MOVE 15               TO TPS4010-ACTIVE-FIELD 
159400         MOVE ' ENTER EVENT LOCATION OR TAB THRU FIELD'
159500                                TO TPS4010::MENU-LINE
159600         MOVE 1                 TO WS-DISPLAY-OPTION
               MOVE '0'               TO WS-TEMP-MSG-FLAG
159700         GO TO DISPLAY-PANEL-TPS4010.

159800
159900      MOVE 'Eastern '           TO TPS4010::TIME-ZONE.
160000      MOVE 9                    TO TPS4010-ACTIVE-FIELD .
160300      MOVE ' ENTER EVENT START TIME                  '
160400                                TO TPS4010::MENU-LINE.
160500      MOVE 1                    TO WS-DISPLAY-OPTION.
            MOVE '0'                  TO WS-TEMP-MSG-FLAG.
160600      GO TO DISPLAY-PANEL-TPS4010.
160700
160800 HOT-FIELD-1009.
160900*     IF TPS4010-ENTRY-TIME-END-HH = ZEROS
161000*        MOVE 14               TO TPS4010-CURSOR-FIELD
161100*        MOVE 0                TO TPS4010-CURSOR-OFFSET
161200*        MOVE 0                TO TPS4010-DISPLAY-OPTION
161300*        GO TO DISPLAY-PANEL-TPS4010.
161400

161500      MOVE 10                   TO TPS4010-ACTIVE-FIELD .
161800      MOVE ' ENTER EVENT START TIME AM OR PM       '
161900                                TO TPS4010::MENU-LINE.
162000      MOVE 1                    TO WS-DISPLAY-OPTION.
            MOVE '0'                  TO WS-TEMP-MSG-FLAG.
162100      GO TO DISPLAY-PANEL-TPS4010.
162200
162300 HOT-FIELD-1010.

162400      IF TPS4010::TIME-START-HH NOT = ZEROS
162500       IF TPS4010::TIME-START-AM-PM NOT = 'AM' AND 'PM'
162600         MOVE 10                TO TPS4010-ACTIVE-FIELD 
162900         MOVE ' AM OR PM REQUIRED                  '
163000                                TO TPS4010::MENU-LINE
163100         MOVE 1                 TO WS-DISPLAY-OPTION
               MOVE '0'               TO WS-TEMP-MSG-FLAG
163200         GO TO DISPLAY-PANEL-TPS4010
163300        END-IF
163400       END-IF.

163500      MOVE 11                   TO TPS4010-ACTIVE-FIELD .
163800      MOVE ' ENTER EVENT END TIME                '
163900                                TO TPS4010::MENU-LINE.
164000      MOVE 1                    TO WS-DISPLAY-OPTION.
            MOVE '0'                  TO WS-TEMP-MSG-FLAG.
164100      GO TO DISPLAY-PANEL-TPS4010.
164200
164300 HOT-FIELD-1011.
164400      IF TPS4010::TIME-END-HH = ZEROS
164500         MOVE 14               TO TPS4010-ACTIVE-FIELD 
164800         MOVE ' ENTER TIME ZONE                    '
164900                                TO TPS4010::MENU-LINE
165000         MOVE 1                 TO WS-DISPLAY-OPTION
165100         GO TO DISPLAY-PANEL-TPS4010.
165200

165300      MOVE 12                   TO TPS4010-ACTIVE-FIELD .
165600      MOVE ' ENTER EVENT END TIME                '
165700                                TO TPS4010::MENU-LINE.
165800      MOVE 1                    TO WS-DISPLAY-OPTION.
            MOVE '0'                  TO WS-TEMP-MSG-FLAG.
165900      GO TO DISPLAY-PANEL-TPS4010.
166000
166100 HOT-FIELD-1012.

166200      MOVE 13                   TO TPS4010-ACTIVE-FIELD .
166500      MOVE ' ENTER EVENT END TIME AM OR PM       '
166600                                TO TPS4010::MENU-LINE.
166700      MOVE 1                    TO WS-DISPLAY-OPTION.
            MOVE '0'                  TO WS-TEMP-MSG-FLAG.
166800      GO TO DISPLAY-PANEL-TPS4010.
166900
167000 HOT-FIELD-1013.
167100      IF TPS4010::TIME-END-AM-PM  = SPACES
167200         MOVE 13               TO TPS4010-ACTIVE-FIELD 
167500         MOVE 'AM OR PM ENTRY REQUIRED' TO
167600                                   TPS4010::MENU-LINE
               MOVE '0' TO WS-TEMP-MSG-FLAG
167700         GO TO DISPLAY-PANEL-TPS4010.
167800
167900      IF TPS4010::TIME-END-AM-PM  NOT = 'AM' AND 'PM'
168000         MOVE 13                   TO TPS4010-ACTIVE-FIELD 
168300         MOVE 'ONLY AM OR PM ENTRY ALLOWED' TO
168400                                   TPS4010::MENU-LINE
               MOVE '0'  TO WS-TEMP-MSG-FLAG
168500         GO TO DISPLAY-PANEL-TPS4010.
168600
168700
168800      MOVE TPS4010::TIME-START-HH
168900                                TO WS-FROM-TIME-HHMM(1:2).
169000      MOVE TPS4010::TIME-START-MM
169100                                TO WS-FROM-TIME-HHMM(3:2).
169200      IF TPS4010::TIME-START-AM-PM = 'PM'
169300         ADD 1200               TO WS-FROM-TIME-HHMM
169400       END-IF.
169500      MOVE TPS4010::TIME-END-HH
169600                                TO WS-TO-TIME-HHMM(1:2).
169700      MOVE TPS4010::TIME-END-MM
169800                                TO WS-TO-TIME-HHMM(3:2).
169900      IF TPS4010::TIME-END-AM-PM = 'PM'
170000         ADD 1200               TO WS-TO-TIME-HHMM
170100       END-IF.
170200
170300      IF WS-TO-TIME-HHMM < WS-FROM-TIME-HHMM
170400         MOVE 08               TO TPS4010-ACTIVE-FIELD 
170700         MOVE '   INVALID TIME RANGE     ' TO
170800                                   TPS4010::MENU-LINE
               MOVE '0' TO WS-TEMP-MSG-FLAG
170900         GO TO DISPLAY-PANEL-TPS4010.
171000

171100      MOVE 14                   TO TPS4010-ACTIVE-FIELD .
171400      MOVE ' ENTER TIME ZONE                     '
171500                                TO TPS4010::MENU-LINE.
171600      MOVE 1                    TO WS-DISPLAY-OPTION.
            MOVE '0'                  TO WS-TEMP-MSG-FLAG.
171700      GO TO DISPLAY-PANEL-TPS4010.
171800
167000 HOT-FIELD-1014.

           MOVE 15 TO TPS4010-ACTIVE-FIELD.
171400      MOVE ' ENTER LOCATION' TO TPS4010::MENU-LINE.
            MOVE '0'                  TO WS-TEMP-MSG-FLAG.
171700      GO TO DISPLAY-PANEL-TPS4010.

167000 HOT-FIELD-1015.

           MOVE 16 TO TPS4010-ACTIVE-FIELD.
171400      MOVE 'ENTER A NAME   ' TO TPS4010::MENU-LINE.
            MOVE '0'                  TO WS-TEMP-MSG-FLAG.
171700      GO TO DISPLAY-PANEL-TPS4010.

167000 HOT-FIELD-1016.

           MOVE 17 TO TPS4010-ACTIVE-FIELD.
171400      MOVE 'ENTER RESERVE DATE   ' TO TPS4010::MENU-LINE.
            MOVE '0'                  TO WS-TEMP-MSG-FLAG.
171700      GO TO DISPLAY-PANEL-TPS4010.

171900 HOT-FIELD-1017.
172000      IF TPS4010-RSVP-DATE = ZEROS
172100         MOVE 18               TO TPS4010-ACTIVE-FIELD 
172400         MOVE ' ENTER CONTACT NAME              '
172500                               TO TPS4010::MENU-LINE
172600         MOVE 1                TO WS-DISPLAY-OPTION
               MOVE '0'              TO WS-TEMP-MSG-FLAG
172700         GO TO DISPLAY-PANEL-TPS4010.
172800
172900      MOVE 11                   TO WS-DATE-PARAM.
173000      MOVE TPS4010-DATE-START TO WS-DATE-REFORM.
173100      MOVE SPACES               TO WS-DATE-EXTEND.
173200         CALL TPSDATES USING WS-DATE-REQUEST.
173300      MOVE WS-DATE-REFORM-LEN08 TO WS-FROM-DATE-CYMD.
173400
173500      MOVE 11                   TO WS-DATE-PARAM.
173600      MOVE TPS4010-RSVP-DATE TO WS-DATE-REFORM.
173700      MOVE SPACES               TO WS-DATE-EXTEND.
173800         CALL TPSDATES USING WS-DATE-REQUEST.
173900      MOVE WS-DATE-REFORM-LEN08 TO WS-TO-DATE-CYMD.
174000
174100      IF WS-TO-DATE-CYMD NOT < WS-FROM-DATE-CYMD
174200         MOVE 17               TO TPS4010-ACTIVE-FIELD 
174500         MOVE '   INVALID RSVP DATE RANGE     ' TO
174600                                   TPS4010::MENU-LINE
174700         GO TO DISPLAY-PANEL-TPS4010.
174800

174900      MOVE 18                  TO TPS4010-ACTIVE-FIELD .
175200      MOVE ' ENTER RSVP CONTACT                  '
175300                               TO TPS4010::MENU-LINE.
175400      MOVE 1                   TO WS-DISPLAY-OPTION.
            MOVE '0'                 TO WS-TEMP-MSG-FLAG.
175500      GO TO DISPLAY-PANEL-TPS4010.
175600
167000 HOT-FIELD-1018.

           MOVE 19 TO TPS4010-ACTIVE-FIELD.
171400      MOVE 'ENTER NAME ' TO TPS4010::MENU-LINE.
            MOVE '0'                  TO WS-TEMP-MSG-FLAG.
171700      GO TO DISPLAY-PANEL-TPS4010.
175700
167000 HOT-FIELD-1019.

           MOVE 20 TO TPS4010-ACTIVE-FIELD.
171400      MOVE 'ENTER COST ' TO TPS4010::MENU-LINE.
            MOVE '0'                  TO WS-TEMP-MSG-FLAG.
171700      GO TO DISPLAY-PANEL-TPS4010.

167000 HOT-FIELD-1020.

           MOVE 21 TO TPS4010-ACTIVE-FIELD.
171400      MOVE 'ENTER DRESS ' TO TPS4010::MENU-LINE.
            MOVE '0'                  TO WS-TEMP-MSG-FLAG.
171700      GO TO DISPLAY-PANEL-TPS4010.

167000 HOT-FIELD-1021.

           MOVE 22 TO TPS4010-ACTIVE-FIELD.
171400      MOVE 'ENTER Y/N '   TO TPS4010::MENU-LINE.
            MOVE '0'                  TO WS-TEMP-MSG-FLAG.
171700      GO TO DISPLAY-PANEL-TPS4010.

175800 HOT-FIELD-1022.


175900      MOVE '0028'              TO EXIT-KEY-NAMES.
176000      IF TPS4010-SURPRISE-INDIC = SPACES
176100         MOVE 23                TO TPS4010-ACTIVE-FIELD 
176400         MOVE 0                TO WS-DISPLAY-OPTION
176500         GO TO DISPLAY-PANEL-TPS4010.
176600
176700      IF TPS4010-SURPRISE-INDIC = 'Y  '
176800         MOVE 'Yes'            TO TPS4010-SURPRISE-INDIC
176900         MOVE 23                TO TPS4010-ACTIVE-FIELD 
177200         MOVE 0                TO WS-DISPLAY-OPTION
177300         GO TO DISPLAY-PANEL-TPS4010.
177400
177500      IF TPS4010-SURPRISE-INDIC = 'N  '
177600         MOVE 'No '            TO TPS4010-SURPRISE-INDIC
177700         MOVE 23                TO TPS4010-ACTIVE-FIELD 
178000         MOVE 0                TO WS-DISPLAY-OPTION
178100         GO TO DISPLAY-PANEL-TPS4010.
178200
178400      MOVE 'SPACE, Y OR N ARE VALID ENTRIES' TO
178500                                   TPS4010::MENU-LINE.
178600      MOVE 22                   TO TPS4010-ACTIVE-FIELD .
178900      MOVE '0000'               TO EXIT-KEY-NAMES.
179000      GO TO DISPLAY-PANEL-TPS4010.

179100
179200 PROCESS-PANEL-TPS4010.
179300         PERFORM VARYING THE-INDEX FROM 1 BY 1
179400              UNTIL THE-INDEX > 10
179500      MOVE SPACES           TO  WS-MEMO-LINE(THE-INDEX)
179600         END-PERFORM.
179700
179800      MOVE 'Event: '             TO  WS-MEMO-EVENT-W.
179900      MOVE 'Date: '              TO  WS-MEMO-DATE-W.
180000****  MOVE ' - '                 TO  WS-MEMO-DATE-DASH.
180100      MOVE 'Time: '              TO  WS-MEMO-TIME-W.
180200      MOVE 'Given by: '          TO  WS-MEMO-GIVEN-BY-W.
180300      MOVE 'Honoring: '          TO  WS-MEMO-HONORING-W.
180400      MOVE 'RSVP: '              TO  WS-MEMO-RSVP-W.
180500      MOVE 'Contact: '           TO  WS-MEMO-CONTACT-W.
180600      MOVE 'Cost: '              TO  WS-MEMO-COST-W.
180700      MOVE 'Surprise: '          TO  WS-MEMO-SURPRISE-W.
180800      MOVE 'Dress: '             TO  WS-MEMO-DRESS-W.
180900      MOVE 'Location: '          TO  WS-MEMO-LOCATION-W.
181000
181100      MOVE TPS4010::EVENT-NAME TO
181200                             WS-MEMO-EVENT.
181300      MOVE TPS4010-DATE-START TO
181400                             WS-MEMO-DATE-START.
181500***** MOVE ' - '          TO WS-MEMO-DATE-DASH.
181600      MOVE TPS4010-DATE-END TO
181700                             WS-MEMO-DATE-END.
181800      MOVE TPS4010::TIME-START-HH TO
181900                            WS-MEMO-TIME-START(1:2).
182000      MOVE TPS4010::TIME-START-MM TO
182100                            WS-MEMO-TIME-START(3:2).
182200      MOVE TPS4010::TIME-START-AM-PM TO
182300                            WS-MEMO-START-AM-PM.
182400*10/28IF CALEN-ENTRY-TIME-END NOT = SPACES
182500      IF TPS4010::TIME-END-HH NOT = ZEROS
182600*****    MOVE '-'               TO WS-MEMO-TIME-DASH-W
182700         MOVE TPS4010::TIME-END-HH TO
182800                             WS-MEMO-TIME-END(1:2)
182900         MOVE TPS4010::TIME-END-MM TO
183000                             WS-MEMO-TIME-END(3:2)
183100         MOVE TPS4010::TIME-END-AM-PM TO
183200                             WS-MEMO-END-AM-PM.
183300
183400******  10 TPS4010::TIME-ZONE          PIC X(08).
183500
183600      MOVE TPS4010::GIVEN-BY TO
183700                             WS-MEMO-GIVEN-BY.
183800      MOVE TPS4010::HONORING-NAME TO
183900                             WS-MEMO-HONORING.
184000      MOVE TPS4010-RSVP-DATE TO
184100                              WS-MEMO-RSVP.
184200      MOVE TPS4010::RSVP-CONTACT TO
184300                             WS-MEMO-CONTACT.
184400      MOVE TPS4010-EVENT-COST TO
184500                             WS-MEMO-COST.
184600      MOVE TPS4010-SURPRISE-INDIC(1:1) TO
184700                             WS-MEMO-SURPRISE.
184800      MOVE TPS4010::DRESS-MEMO TO
184900                             WS-MEMO-DRESS.
185000      MOVE TPS4010::LOCATION TO
185100                             WS-MEMO-LOCATION.
185200      MOVE TPS4010A::MEMO-LINE-01 TO
185300                             WS-MEMO-COMMENT-1.
185400      MOVE TPS4010A::MEMO-LINE-02 TO
185500                             WS-MEMO-COMMENT-2.
185600      MOVE TPS4010A::MEMO-LINE-03 TO
185700                             WS-MEMO-COMMENT-3.
185800
185900      MOVE WS-MEMO-DATE-START(1:2)  TO WS-DATE-REFORM(1:2).
186000      MOVE WS-MEMO-DATE-START(4:2)  TO WS-DATE-REFORM(3:2).
186100      MOVE WS-MEMO-DATE-START(7:2)  TO WS-DATE-REFORM(5:2).
186200      MOVE 11                       TO WS-DATE-PARAM.
186300      MOVE SPACES                   TO WS-DATE-EXTEND.
186400        CALL TPSDATES USING WS-DATE-REQUEST.
186500      MOVE WS-DATE-REFORM-LEN08   TO WS-MEMO-DATE-CYMD.
186600
186700      IF CHANGE-RECORD = 'Y'
186800         GO TO START-UPDATING
186900      ELSE
187000         GO TO FROM-THE-PANEL.
187100
187200 DISPLAY-PANEL-TPS4010B.
187300
187400**** READ AND DISPLAY FIELDS FOR SELECTED RECORD ******
187500    MOVE TPS4001::DISPLAY-LINE-NO            TO WS-TAB.
187600    MOVE TABLE-DATE(WS-TAB)   TO WS-DATE-REFORM.
187700    MOVE 11                   TO WS-DATE-PARAM.
187800    MOVE SPACES               TO WS-DATE-EXTEND.
187900    CALL TPSDATES USING WS-DATE-REQUEST.
188000    MOVE WS-DATE-REFORM-LEN08           TO CAL-KEY-DATE
188100                                           WS-KEY-DATE.
188200    MOVE CLNT-PROFILE-ACCT-NO           TO CAL-KEY-ACCT-NO.
188300    MOVE CLNT-PROFILE-SUB-ACCT          TO CAL-KEY-SUB-ACCT.
188400    MOVE TABLE1-REC-NO(WS-TAB)          TO CAL-KEY-RECORD-NUMBER.
188500    MOVE TABLE1-SUB-REC-NO(WS-TAB)  TO CAL-KEY-SUB-RECORD-NUMBER.
188600
188700    PERFORM READ-THE-CALENDAR THRU
188800            READ-THE-CALENDAR-EXIT.
188900
189000    IF CAL-APPT-ATTEND-OPTION = '0'
189100       MOVE 'Y'                      TO TPS4010B::ATTEND.
189200    IF CAL-APPT-ATTEND-OPTION = '1'
189300       MOVE 'N'                      TO TPS4010B::ATTEND.
189400    IF CAL-APPT-PRINT-OPTION = '0'
189500       MOVE 'Y'                      TO TPS4010B::PRINT-1.
189600    IF CAL-APPT-PRINT-OPTION = '1'
189700       MOVE 'N'                      TO TPS4010B::PRINT-1.
189800
189900 REDISPLAY-PANEL-TPS4010B.

           MOVE 1 TO TPS4010::SPLASH-SCREEN-FLAG.
           IF TPS4010-DISPLAY-FLAG = 0
               SET TPS4010::X-POINT TO WS-X-PARM
               SET TPS4010::Y-POINT TO WS-Y-PARM
               SET TPS4010::Width TO 1
               SET TPS4010::Height TO 1
               INVOKE TPS4010::Show
               SET TPS4010::Width TO 1205
               SET TPS4010::Height TO 793
               INVOKE TPS4010::Show
               MOVE 1 TO TPS4010-DISPLAY-FLAG
           END-IF.
           MOVE 0 TO TPS4010::SPLASH-SCREEN-FLAG.

           SET TPS4010B::X-POINT TO WS-X-PARM.
           SET TPS4010B::Y-POINT TO WS-Y-PARM.
           INVOKE TPS4010B::ShowDialog.
           MOVE TPS4010B::SCREEN-NAME TO SCREEN-NAME.
           MOVE TPS4010B::Location::X TO WS-X-PARM
             WS-CURRENT-X.
           MOVE TPS4010B::Location::Y TO WS-Y-PARM
             WS-CURRENT-Y.


           INVOKE TPS4010::Hide.
           MOVE 0 TO TPS4010-DISPLAY-FLAG.
191200
191300      IF TPS4010B::KEY-PRESSED = "End Key"
191400         GO TO DISPLAY-PANEL-TPS4010B-EXIT.
191500
191600      IF NOT TPS4010B::KEY-PRESSED = "Enter Key"
191700         GO TO DISPLAY-PANEL-TPS4010B-EXIT.
191800
191900      MOVE SPACES            TO CAL-APPT-ATTEND-OPTION.
192000      MOVE SPACES            TO CAL-APPT-PRINT-OPTION.
192100      IF TPS4010B::ATTEND = 'Y'
192200         MOVE '0'            TO CAL-APPT-ATTEND-OPTION.
192300      IF TPS4010B::ATTEND = 'N'
192400         MOVE '1'            TO CAL-APPT-ATTEND-OPTION.
192500      IF TPS4010B::PRINT-1 = 'Y'
192600         MOVE '0'            TO CAL-APPT-PRINT-OPTION.
192700      IF TPS4010B::PRINT-1 = 'N'
192800         MOVE '1'            TO CAL-APPT-PRINT-OPTION.
192900
193000    PERFORM REWRITE-THE-CALENDAR THRU
193100            REWRITE-THE-CALENDAR-EXIT.
193200
193300    GO TO DISPLAY-PANEL-TPS4010B-EXIT.
193400
193500 PRINT-QUESTION.
193600     IF TPS4010B::ATTEND = 'Y'
193700         MOVE 'Y' TO TPS4010B::PRINT-1
193800         MOVE 1 TO TPS4010B::ACTIVE-FIELD
194000*        MOVE 'P'                  TO TPS4010B-FIELD-OPTION(2)
194200         MOVE
194300        'WHEN ATTENDING THE EVENT, IT WILL APPEAR ON THE CALENDAR'
194400           TO TPS4010B::MENU-LINE
194500     ELSE
194600         MOVE 2 TO TPS4010B::ACTIVE-FIELD

           END-IF.
194900
195000      GO TO REDISPLAY-PANEL-TPS4010B.
195100
195200 DISPLAY-PANEL-TPS4010B-EXIT.   EXIT.
195300
195400 SETUP-PANEL-TPS4010A.
195500******* IF CALENDAR MAINTENANCE GO TO DISPLAY ***************
195600      IF CAL-MAINT = 'Y'
195700         GO TO DISPLAY-PANEL-TPS4010A.
195800
195900      MOVE SPACES            TO TPS4010A::MEMO-LINE-01
196000                                TPS4010A::MEMO-LINE-02
196100                                TPS4010A::MEMO-LINE-03.
196200      IF     LSP-PROG-RECEIVE AND LSP-PROG-ID = 'TPS1010 '
196300         AND MAIL-CALENDAR-XREF OF LS-RECVE IS NUMERIC
196400         AND MAIL-CALENDAR-XREF OF LS-RECVE IS GREATER THAN 0
196500         MOVE WS-MEMO-COMMENT-1
196600           TO TPS4010A::MEMO-LINE-01
196700         MOVE WS-MEMO-COMMENT-2
196800           TO TPS4010A::MEMO-LINE-02
196900         MOVE WS-MEMO-COMMENT-3
197000           TO TPS4010A::MEMO-LINE-03
197100      END-IF.
197200    MOVE 1               TO TPS4010A::ACTIVE-FIELD.


         
197500 DISPLAY-PANEL-TPS4010A.
       
           MOVE 1 TO TPS4010::SPLASH-SCREEN-FLAG.
           IF TPS4010-DISPLAY-FLAG = 0
               SET TPS4010::X-POINT TO WS-X-PARM
               SET TPS4010::Y-POINT TO WS-Y-PARM
               SET TPS4010::Width TO 1
               SET TPS4010::Height TO 1
               INVOKE TPS4010::Show
               SET TPS4010::Width TO 1205
               SET TPS4010::Height TO 793
               INVOKE TPS4010::Show
               MOVE 1 TO TPS4010-DISPLAY-FLAG
           END-IF.
           MOVE 0 TO TPS4010::SPLASH-SCREEN-FLAG.

           SET TPS4010A::X-POINT TO WS-X-PARM.
           SET TPS4010A::Y-POINT TO WS-Y-PARM.
           INVOKE TPS4010A::ShowDialog.
           MOVE TPS4010A::SCREEN-NAME TO SCREEN-NAME.
           MOVE TPS4010A::Location::X TO WS-X-PARM
             WS-CURRENT-X.
           MOVE TPS4010A::Location::Y TO WS-Y-PARM
             WS-CURRENT-Y.

198400     INVOKE TPS4010::Hide.
           MOVE 0 TO TPS4010-DISPLAY-FLAG.

198500      IF TPS4010A::KEY-PRESSED = "End Key"
198600         GO TO DISPLAY-PANEL-TPS4010
198700      END-IF.
198800*JM09/99

198900      IF NOT TPS4010A::KEY-PRESSED = "Enter Key"
199100      MOVE 'HIT ENTER TO PROCESS DATA' TO
199200                                   TPS4010A::MENU-LINE
199300      GO TO DISPLAY-PANEL-TPS4010A.
199400
199600
199700      MOVE 5                    TO TPS4010-ACTIVE-FIELD 
200000      GO TO DISPLAY-PANEL-TPS4010.
200100
200200 FROM-THE-PANEL.
200300      MOVE CLNT-PROFILE-ACCT-NO OF LS-PROFL TO
200400                            CAL-KEY-ACCT-NO.
200500      MOVE CLNT-PROFILE-SUB-ACCT OF LS-PROFL TO
200600                            CAL-KEY-SUB-ACCT.
200700      MOVE ZEROS                  TO CAL-KEY-DATE.
200800
200900      MOVE WS-MEMO-DATE-CYMD-CC   TO CAL-KEY-DATE-CC.
201000      MOVE WS-MEMO-DATE-CYMD-YY   TO CAL-KEY-DATE-YY.
201100      MOVE ZEROS                  TO CAL-KEY-RECORD-NUMBER.
201200      MOVE ZEROS                  TO CAL-KEY-SUB-RECORD-NUMBER.
201300
201400      IF     LSP-PROG-RECEIVE AND LSP-PROG-ID = 'TPS1010 '
201500         AND MAIL-CALENDAR-XREF OF LS-RECVE IS NUMERIC
201600         AND MAIL-CALENDAR-XREF OF LS-RECVE IS GREATER THAN 0
201700         AND WS-KEY-DATE      = WS-DATE-REFORM-LEN08
201800         MOVE WS-KEY-DATE          TO CAL-KEY-DATE
201900         MOVE WS-KEY-RECORD-NUMBER TO CAL-KEY-RECORD-NUMBER
202000         MOVE '00' TO FILE-STATUS
202100         PERFORM UNTIL FILE-STATUS IS NOT EQUAL TO '00'
202200                 ADD 1 TO CAL-KEY-SUB-RECORD-NUMBER
202400                 PERFORM DELETE-THE-CALENDAR
202500                    THRU DELETE-THE-CALENDAR-EXIT
202600         END-PERFORM
202700         MOVE ZEROS TO CAL-KEY-SUB-RECORD-NUMBER
202800         GO TO START-UPDATING
202900      END-IF.
203000
203100      PERFORM READ-THE-CALENDAR THRU
203200              READ-THE-CALENDAR-EXIT.
203300
203400      IF CAL-MAINT = 'Y'
203500         MOVE CAL-KEY-ACCT-NO    TO WS-MEMO-ACCT-NO.
203600
203700      IF WS-MEMO-ACCT-NO = CAL-KEY-ACCT-NO
203800         GO TO HAVE-YEAR-CHECK-MONTH.
203900
204000*****  BUILD OF YEARLY CONTROL RECORD
204100
204200      MOVE CLNT-PROFILE-ACCT-NO   TO CAL-KEY-ACCT-NO.
204300      MOVE CLNT-PROFILE-SUB-ACCT  TO CAL-KEY-SUB-ACCT.
204400      MOVE ZEROS                  TO CAL-KEY-DATE.
204500      MOVE WS-MEMO-DATE-CYMD-CC   TO CAL-KEY-DATE-CC.
204600      MOVE WS-MEMO-DATE-CYMD-YY   TO CAL-KEY-DATE-YY.
204700      MOVE ZEROS                  TO CAL-KEY-RECORD-NUMBER.
204800      MOVE ZEROS                  TO CAL-KEY-SUB-RECORD-NUMBER.
204900
205000      MOVE ZEROS                  TO CAL-RECORD-TYPE.
205100      MOVE SPACES                 TO CAL-VARIABLE.
205200
205300      PERFORM VARYING THE-INDEX FROM 1 BY 1
205400                      UNTIL THE-INDEX > 12
205500         MOVE 0 TO CAL-YR-MONTH-OF-YEAR-APPT(THE-INDEX)
205600         MOVE 0 TO CAL-YR-MONTH-OF-YEAR-EVENT(THE-INDEX)
205700         MOVE 0 TO CAL-YR-MONTH-OF-YEAR-DELET(THE-INDEX)
205800      END-PERFORM.
205900
206000      PERFORM UPDATE-MONTH-OF-YEAR THRU
206100              UPDATE-MONTH-OF-YEAR-EXIT.
206200      PERFORM WRITE-THE-CALENDAR THRU
206300              WRITE-THE-CALENDAR-EXIT.
206400      GO TO READ-THE-MONTH-RECORD.
206500
206600 UPDATE-MONTH-OF-YEAR.
206700      MOVE WS-MEMO-DATE-CYMD-MM  TO THE-INDEX.
206800      IF WS-MEMO-TIME-START = SPACES
206900         ADD 1       TO CAL-YR-MONTH-OF-YEAR-EVENT(THE-INDEX)
207000      ELSE
207100         ADD 1       TO CAL-YR-MONTH-OF-YEAR-APPT(THE-INDEX).
207200 UPDATE-MONTH-OF-YEAR-EXIT. EXIT.
207300
207400 HAVE-YEAR-CHECK-MONTH.
207500      PERFORM UPDATE-MONTH-OF-YEAR THRU
207600              UPDATE-MONTH-OF-YEAR-EXIT.
207700      PERFORM REWRITE-THE-CALENDAR THRU
207800              REWRITE-THE-CALENDAR-EXIT.
207900
208000 READ-THE-MONTH-RECORD.
208100      MOVE WS-MEMO-DATE-CYMD-MM   TO CAL-KEY-DATE-MM.
208200
208300      PERFORM READ-THE-CALENDAR THRU
208400              READ-THE-CALENDAR-EXIT.
208500
208600      IF WS-MEMO-ACCT-NO = CAL-KEY-ACCT-NO
208700         GO TO HAVE-MONTH-CHECK-DAY.
208800
208900*****  BUILD OF MONTHLY CONTROL RECORD
209000
209100      MOVE CLNT-PROFILE-ACCT-NO   TO CAL-KEY-ACCT-NO.
209200      MOVE CLNT-PROFILE-SUB-ACCT  TO CAL-KEY-SUB-ACCT.
209300      MOVE ZEROS                  TO CAL-KEY-DATE.
209400      MOVE WS-MEMO-DATE-CYMD-CC   TO CAL-KEY-DATE-CC.
209500      MOVE WS-MEMO-DATE-CYMD-YY   TO CAL-KEY-DATE-YY.
209600      MOVE WS-MEMO-DATE-CYMD-MM   TO CAL-KEY-DATE-MM.
209700      MOVE ZEROS                  TO CAL-KEY-RECORD-NUMBER.
209800      MOVE ZEROS                  TO CAL-KEY-SUB-RECORD-NUMBER.
209900
210000      MOVE ZEROS                  TO CAL-RECORD-TYPE.
210100      MOVE SPACES                 TO CAL-VARIABLE.
210200
210300      PERFORM VARYING THE-INDEX FROM 1 BY 1
210400                      UNTIL THE-INDEX > 31
210500         MOVE 0 TO CAL-MO-DAY-OF-MONTH-APPT(THE-INDEX)
210600         MOVE 0 TO CAL-MO-DAY-OF-MONTH-EVENT(THE-INDEX)
210700         MOVE 0 TO CAL-MO-DAY-OF-MONTH-DELET(THE-INDEX)
210800      END-PERFORM.
210900
211000      PERFORM UPDATE-DAY-OF-MONTH THRU
211100              UPDATE-DAY-OF-MONTH-EXIT.
211200      PERFORM WRITE-THE-CALENDAR THRU
211300              WRITE-THE-CALENDAR-EXIT.
211400      GO TO READ-THE-DAY-RECORD.
211500
211600 UPDATE-DAY-OF-MONTH.
211700      MOVE WS-MEMO-DATE-CYMD-DD  TO THE-INDEX.
211800      IF WS-MEMO-TIME-START = SPACES
211900         ADD 1       TO CAL-MO-DAY-OF-MONTH-EVENT(THE-INDEX)
212000      ELSE
212100         ADD 1       TO CAL-MO-DAY-OF-MONTH-APPT(THE-INDEX).
212200 UPDATE-DAY-OF-MONTH-EXIT. EXIT.
212300
212400 HAVE-MONTH-CHECK-DAY.
212500      PERFORM UPDATE-DAY-OF-MONTH THRU
212600              UPDATE-DAY-OF-MONTH-EXIT.
212700      PERFORM REWRITE-THE-CALENDAR THRU
212800              REWRITE-THE-CALENDAR-EXIT.
212900
213000 READ-THE-DAY-RECORD.
213100      MOVE WS-MEMO-DATE-CYMD-DD   TO CAL-KEY-DATE-DD.
213200
213300      PERFORM READ-THE-CALENDAR THRU
213400              READ-THE-CALENDAR-EXIT.
213500
213600      IF WS-MEMO-ACCT-NO = CAL-KEY-ACCT-NO
213700         GO TO HAVE-DAY-GET-CONTROL-NUMBER.
213800
213900*****  BUILD OF DAILY CONTROL RECORD
214000
214100      MOVE CLNT-PROFILE-ACCT-NO   TO CAL-KEY-ACCT-NO.
214200      MOVE CLNT-PROFILE-SUB-ACCT  TO CAL-KEY-SUB-ACCT.
214300      MOVE WS-MEMO-DATE-CYMD      TO CAL-KEY-DATE.
214400      MOVE ZEROS                  TO CAL-KEY-RECORD-NUMBER.
214500      MOVE ZEROS                  TO CAL-KEY-SUB-RECORD-NUMBER.
214600
214700      MOVE ZEROS                  TO CAL-RECORD-TYPE.
214800      MOVE SPACES                 TO CAL-VARIABLE.
214900      MOVE '0001'                 TO CAL-DAY-NEXT-AVAIL-REC-NUM.
215000      MOVE ZEROS                  TO CAL-DAY-OF-MONTH-APPT
215100                                     CAL-DAY-OF-MONTH-EVENT
215200                                     CAL-DAY-OF-MONTH-DELET.
215300      PERFORM WRITE-THE-CALENDAR THRU
215400              WRITE-THE-CALENDAR-EXIT.
215500
215600 HAVE-DAY-GET-CONTROL-NUMBER.
215700      MOVE CAL-DAY-NEXT-AVAIL-REC-NUM TO WS-NEXT-AVAIL-REC-NUM.
215800      ADD  1                     TO CAL-DAY-NEXT-AVAIL-REC-NUM.
215900      IF WS-MEMO-TIME-START = SPACES
216000         ADD 1       TO CAL-DAY-OF-MONTH-EVENT
216100      ELSE
216200         ADD 1       TO CAL-DAY-OF-MONTH-APPT.
216300
216400      PERFORM REWRITE-THE-CALENDAR THRU
216500              REWRITE-THE-CALENDAR-EXIT.
216600
216700      MOVE WS-NEXT-AVAIL-REC-NUM  TO CAL-KEY-RECORD-NUMBER.
216800 START-UPDATING.
146200
146200      IF CAL-MAINT = 'Y' AND
146200         TPS4010-DATE-START NOT = WS-ENTRY-DATE
146300         MOVE ZERO           TO CAL-APPT-RECEIVE-DATE
146300         MOVE ZERO           TO CAL-APPT-RECEIVE-NUMBER.
146200
216900      MOVE ZEROS                   TO CAL-KEY-SUB-RECORD-NUMBER.
217000
217100      MOVE '01'                   TO WS-RECORD-TYPE.
217200      MOVE WS-MEMO-TIME-START  TO CAL-APPT-START-TIME.
217300      MOVE WS-MEMO-START-AM-PM TO CAL-APPT-START-TIME-AM-PM.
217400      MOVE WS-MEMO-TIME-END    TO CAL-APPT-STOP-TIME.
217500      MOVE WS-MEMO-END-AM-PM   TO CAL-APPT-STOP-TIME-AM-PM.
217600
217700      IF CAL-APPT-START-TIME = SPACES OR ZEROS
217800         MOVE '02'                TO WS-RECORD-TYPE.
217900
218000      IF CHANGE-RECORD = 'Y'
218100         MOVE WS-APPT-PRINT-OPTION  TO CAL-APPT-PRINT-OPTION
218200         MOVE WS-APPT-ATTEND-OPTION TO CAL-APPT-ATTEND-OPTION.
218300
218400      MOVE WS-RECORD-TYPE         TO CAL-RECORD-TYPE.
218500
218600**  PERFORM VARYING THE-INDEX FROM 1 BY 1
218700**          UNTIL   THE-INDEX > 10
218800
218900      MOVE 0                    TO THE-INDEX.
219000      MOVE LOGREC-SIGN-ON OF LS-LOGON
219100                          TO CAL-APPT-ADD-PASSWORD.
219200      MOVE WS-TODAYS-DATE-CYMD  TO CAL-APPT-ADD-DATE.
219300      MOVE LOGREC-SIGN-ON OF LS-LOGON
219400                          TO CAL-APPT-CHANGE-PASSWORD.
219500      MOVE WS-TODAYS-DATE-CYMD  TO CAL-APPT-CHANGE-DATE.
219600      IF LSP-PROG-RECEIVE
219700         MOVE MAIL-RECEIVE-DATE OF LS-RECVE
219800                                  TO CAL-APPT-RECEIVE-DATE
219900         MOVE MAIL-RECEIVE-NUMBER OF LS-RECVE
220000                                  TO CAL-APPT-RECEIVE-NUMBER
220100         MOVE WS-MEMO-DATE-CYMD   TO WS-DATE-REFORM-LEN08
220200         MOVE CAL-KEY-RECORD-NUMBER TO WS-DATE-REFORM-LEN08(9:4)
220300         MOVE WS-DATE-REFORM-LEN08(1:12) TO
220400                                 MAIL-CALENDAR-XREF OF LS-RECVE
220500      ELSE
220600      IF LSP-PROG-DB-MAINTAIN
220700         MOVE SPACES            TO CAL-APPT-RECEIVE-DATE
220800         MOVE ZEROS             TO CAL-APPT-RECEIVE-NUMBER
220900         MOVE LSP-MAINT-FIELD-CODE TO
221000                                   CAL-DB-MAINT-FIELD-CODE
221100      ELSE
221200      IF CAL-MAINT = 'Y' AND
221300         HOLD-MAIL-RECEIVE-DATE  NUMERIC
221400         PERFORM UPDATE-MAIL-RECORD THRU UPDATE-MAIL-RECORD-EXIT
221500*jm3/31  MOVE HOLD-MAIL-RECEIVE-DATE   TO CAL-APPT-RECEIVE-DATE
221600*        MOVE HOLD-MAIL-RECEIVE-NUMBER TO CAL-APPT-RECEIVE-NUMBER
221700         MOVE SPACES                   TO HOLD-MAIL-RECEIVE-DATE
221800      ELSE
221900         MOVE SPACES            TO CAL-APPT-RECEIVE-DATE
222000         MOVE ZEROS             TO CAL-APPT-RECEIVE-NUMBER.
222100
222200 MEMO-LINE-WRITE-LOOP.
222300      ADD 1                     TO THE-INDEX.
222400      IF THE-INDEX > 10     GO TO SEE-IF-FROM-RECEIVE.
222500      IF WS-MEMO-LINE(THE-INDEX)(1:7) = 'Event: ' AND
222600            WS-MEMO-LINE(THE-INDEX)(8:40) NOT = SPACES
222700               GO TO WRITE-MEMO-LINE.
222800      IF WS-MEMO-LINE(THE-INDEX)(1:6) = 'Date: ' AND
222900*****       WS-MEMO-LINE(THE-INDEX)(7:08) NOT = '00/00/00'
223000            WS-MEMO-LINE(THE-INDEX)(7:08) NOT = SPACES
223100               GO TO WRITE-MEMO-LINE.
223200      IF WS-MEMO-LINE(THE-INDEX)(1:10) = 'Given by: ' AND
223300            WS-MEMO-LINE(THE-INDEX)(11:40) NOT = SPACES
223400               GO TO WRITE-MEMO-LINE.
223500      IF WS-MEMO-LINE(THE-INDEX)(1:10) = 'Honoring: ' AND
223600            WS-MEMO-LINE(THE-INDEX)(11:40) NOT = SPACES
223700               GO TO WRITE-MEMO-LINE.
223800      IF WS-MEMO-LINE(THE-INDEX)(1:06) = 'RSVP: ' AND
223900            WS-MEMO-LINE(THE-INDEX)(7:08) NOT = '00/00/00'
224000               GO TO WRITE-MEMO-LINE.
224100      IF WS-MEMO-LINE(THE-INDEX)(16:09) = 'Contact: ' AND
224200            WS-MEMO-LINE(THE-INDEX)(25:26) NOT = SPACES
224300               GO TO WRITE-MEMO-LINE.
224400      IF WS-MEMO-LINE(THE-INDEX)(1:06) = 'Cost: ' AND
224500            WS-MEMO-LINE(THE-INDEX)(8:08) NOT = ZEROS
224600               GO TO WRITE-MEMO-LINE.
224700      IF WS-MEMO-LINE(THE-INDEX)(17:10) = 'Surprise: ' AND
224800            WS-MEMO-LINE(THE-INDEX)(28:01) NOT = SPACES
224900               GO TO WRITE-MEMO-LINE.
225000      IF WS-MEMO-LINE(THE-INDEX)(30:07) = 'Dress: ' AND
225100            WS-MEMO-LINE(THE-INDEX)(37:14) NOT = SPACES
225200               GO TO WRITE-MEMO-LINE.
225300      IF WS-MEMO-LINE(THE-INDEX)(01:10) = 'Location: ' AND
225400            WS-MEMO-LINE(THE-INDEX)(11:40) NOT = SPACES
225500               GO TO WRITE-MEMO-LINE.
225600      IF THE-INDEX < 8      GO TO MEMO-LINE-WRITE-LOOP.
225700      IF   WS-MEMO-LINE(THE-INDEX)(1:40) NOT = SPACES
225800               GO TO WRITE-MEMO-LINE.
225900      GO TO MEMO-LINE-WRITE-LOOP.
226000
226100 WRITE-MEMO-LINE.
226200      ADD 1                   TO CAL-KEY-SUB-RECORD-NUMBER.
226300      MOVE WS-MEMO-LINE(THE-INDEX) TO CAL-APPT-APPOINT-DATA.
226400*JM9/97 ***** IF OLD RECORD IS SELECTED FROM MENU AND ******
226400*JM9/97 ***** NEW DATE WRITE NEW RECORD               ******
226400      IF CHANGE-RECORD = 'Y' AND
226400         WS-MEMO-DATE-CYMD NOT = CAL-KEY-DATE
226400         MOVE WS-MEMO-DATE-CYMD    TO CAL-KEY-DATE
226500         MOVE 'N'                  TO CHANGE-RECORD.
226400
226400      IF CHANGE-RECORD = 'Y'
226500         PERFORM REWRITE-THE-CALENDAR THRU
226600                 REWRITE-THE-CALENDAR-EXIT
226700      ELSE
226800         PERFORM WRITE-THE-CALENDAR THRU
226900                 WRITE-THE-CALENDAR-EXIT.
227000      GO TO MEMO-LINE-WRITE-LOOP.
227100
227200 SEE-IF-FROM-RECEIVE.
227300      IF  LSP-PROG-CAL-MAINTAIN AND LSP-ACTION = 0
227400          GO TO EXIT-THE-MODULE.
227500      IF  LSP-PROG-CAL-MAINTAIN
227600          IF STARTED-AS-NEW
227700             MOVE '0'          TO VIEW-FOR-NEW-FLAG
227800             MOVE '0'          TO STARTED-AS-NEW-FLAG
227900             MOVE '0'          TO LSP-ACTION
228000             MOVE 'N'          TO CAL-MAINT
228100             GO TO INPUT-FROM-RECEIVE
228200            END-IF
228300          GO TO INPUT-FROM-CAL-MAINT
228400        END-IF.
228500      IF  LSP-PROG-DB-MAINTAIN
228600          GO TO EXIT-THE-MODULE.
228700
228800
228900 EXIT-THE-MODULE.
229000      PERFORM CLOSE-THE-FILES THRU
229100              CLOSE-THE-FILES-EXIT.
229200      CANCEL TPSIOERR
229300      CANCEL TPSIO018
229400      CANCEL TPSDATES
229500      CANCEL SCREENIO

           INITIALIZE CURRENT-XY-PARAMETERS.
           MOVE WS-CURRENT-X TO CURRENT-XY-PARAMETERS(1:4).
           MOVE WS-CURRENT-Y TO CURRENT-XY-PARAMETERS(5:4).

           IF CLOSE-ALL-FORMS-FLAG = 0
               SET TPS4010::KEY-PRESSED TO "End Key"
               SET TPS4001::KEY-PRESSED TO "End Key"
               SET TPS4010B::KEY-PRESSED TO "End Key"
               SET TPS4010A::KEY-PRESSED TO "End Key"
               SET TPS4000A::KEY-PRESSED TO "End Key"
               INVOKE TPS4010::Close
               INVOKE TPS4001::Close
               INVOKE TPS4010B::Close
               INVOKE TPS4010A::Close
               INVOKE TPS4000A::Close
               MOVE 1 TO CLOSE-ALL-FORMS-FLAG
           END-IF.

229600     GOBACK GIVING CURRENT-XY-PARAMETERS.
229700
229800 OPEN-THE-FILES.
229900    MOVE F-PRIME      TO FILE-KEY.
230000    MOVE F-OPEN-I-O TO FILE-ACTION.
230100    CALL TPSIO018 USING FILE-REQUEST TPS-CALENDAR-REC.
230200    IF FILE-STATUS NOT = '00' AND '05'
230300       MOVE 'CALENDAR' TO FILE-NAME
230400       MOVE 'OPEN-I-O' TO FILE-TEXT
230500       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
230600       GO TO EXIT-THE-MODULE
230700    END-IF.
230800 OPEN-THE-FILES-EXIT. EXIT.
230900
231000 CLOSE-THE-FILES.
231100    MOVE F-PRIME TO FILE-KEY.
231200    MOVE F-CLOSE TO FILE-ACTION.
231300    CALL TPSIO018 USING FILE-REQUEST TPS-CALENDAR-REC.
231400    IF NOT A-SUCCESSFUL-OPERATION
231500       MOVE 'CALENDAR' TO FILE-NAME
231600       MOVE 'CLOSE'    TO FILE-TEXT
231700       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
231800    END-IF.
231900
232000    IF TPSMAIL-OPEN
232100       CALL TPSIOREC USING FILE-REQUEST UPD-MAIL
232200       IF NOT A-SUCCESSFUL-OPERATION
232300          MOVE 'RECEIVE ' TO FILE-NAME
232400          MOVE 'CLOSE'    TO FILE-TEXT
232500          PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
232600    END-IF.
232700 CLOSE-THE-FILES-EXIT. EXIT.
232800
232900 READ-THE-CALENDAR.
233000    MOVE F-PRIME TO FILE-KEY.
233100    MOVE F-READ TO FILE-ACTION.
233200    CALL TPSIO018 USING FILE-REQUEST TPS-CALENDAR-REC.
233300    IF NOT A-SUCCESSFUL-OPERATION
233400       MOVE ZEROS      TO CAL-KEY-ACCT-NO.
233500**     MOVE 'CALENDAR' TO FILE-NAME
233600**     MOVE 'READ'     TO FILE-TEXT
233700**     PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
233800**     GO TO TPS4010-COMMON-EXIT.
233900 READ-THE-CALENDAR-EXIT. EXIT.
234000
234100 READ-MAIL.
234200    MOVE F-PRIME TO FILE-KEY.
234300    MOVE F-READ TO FILE-ACTION.
234400    CALL TPSIOREC USING FILE-REQUEST UPD-MAIL.
234500    IF NO-RECORD-WAS-FOUND
234600       NEXT SENTENCE
234700    ELSE
234800    IF NOT A-SUCCESSFUL-OPERATION
234900       MOVE 'MAIL    ' TO FILE-NAME
235000       MOVE 'READ'     TO FILE-TEXT
235100       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
235200       GO TO EXIT-THE-MODULE.
235300 READ-MAIL-EXIT.    EXIT.
235400
235500 REWRITE-MAIL.
235600    MOVE F-PRIME TO FILE-KEY.
235700    MOVE F-REWRITE TO FILE-ACTION.
235800    CALL TPSIOREC USING FILE-REQUEST UPD-MAIL.
235900    IF NOT A-SUCCESSFUL-OPERATION
236000       MOVE 'MAIL    ' TO FILE-NAME
236100       MOVE 'REWRITE'  TO FILE-TEXT
236200       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
236300       GO TO EXIT-THE-MODULE.
236400 REWRITE-MAIL-EXIT.    EXIT.
236500
236600 WRITE-THE-CALENDAR.
236700    MOVE F-PRIME TO FILE-KEY.
236800    MOVE F-WRITE TO FILE-ACTION.
236900    CALL TPSIO018 USING FILE-REQUEST TPS-CALENDAR-REC.
237000    IF NOT A-SUCCESSFUL-OPERATION
237100       MOVE 'CALENDAR' TO FILE-NAME
237200       MOVE 'WRITE'    TO FILE-TEXT
237300       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
237400       GO TO EXIT-THE-MODULE.
237500 WRITE-THE-CALENDAR-EXIT. EXIT.
237600
237700 REWRITE-THE-CALENDAR.
237800    MOVE F-PRIME TO FILE-KEY.
237900    MOVE F-REWRITE TO FILE-ACTION.
238000    CALL TPSIO018 USING FILE-REQUEST TPS-CALENDAR-REC.
238100    IF CHANGE-RECORD = 'Y' AND  NO-RECORD-WAS-FOUND
238200       PERFORM WRITE-THE-CALENDAR THRU
238300               WRITE-THE-CALENDAR-EXIT
238400    ELSE
238500    IF NOT A-SUCCESSFUL-OPERATION
238600       MOVE 'CALENDAR' TO FILE-NAME
238700       MOVE 'REWRITE'  TO FILE-TEXT
238800       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
238900       GO TO EXIT-THE-MODULE.
239000 REWRITE-THE-CALENDAR-EXIT. EXIT.
239100
239200 DELETE-THE-CALENDAR.
239300    MOVE F-PRIME TO FILE-KEY.
239400    MOVE F-DELET TO FILE-ACTION.
239500    CALL TPSIO018 USING FILE-REQUEST TPS-CALENDAR-REC.
239600    IF     LSP-PROG-RECEIVE AND LSP-PROG-ID = 'TPS1010 '
239700       GO TO DELETE-THE-CALENDAR-EXIT
239800    END-IF.
239900    IF NOT A-SUCCESSFUL-OPERATION
240000       MOVE 'CALENDAR' TO FILE-NAME
240100       MOVE 'TPS4010-DEL'  TO FILE-TEXT
240200       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
240300    END-IF.
240400 DELETE-THE-CALENDAR-EXIT. EXIT.
240500
240600 FILE-ERROR.
240700      CALL TPSIOERR USING FILE-REQUEST
                                WS-CURRENT-XY-PARM.
240800      CANCEL TPSIOERR.

            MOVE WS-CURRENT-XY-PARM(1:4) TO WS-CURRENT-X.
            MOVE WS-CURRENT-XY-PARM(5:4) TO WS-CURRENT-Y.

           INITIALIZE CURRENT-XY-PARAMETERS.
           MOVE WS-CURRENT-X TO CURRENT-XY-PARAMETERS(1:4).
           MOVE WS-CURRENT-Y TO CURRENT-XY-PARAMETERS(5:4).

240900 FILE-ERROR-EXIT. EXIT.
241000
241100
241200 MAINTENANCE-FUNCTION.
241300      MOVE CLNT-PROFILE-ACCT-NO   TO CAL-KEY-ACCT-NO.
241400      MOVE CLNT-PROFILE-SUB-ACCT  TO CAL-KEY-SUB-ACCT.
241500      MOVE MAIL-CALENDAR-XREF OF LS-RECVE TO WS-CALENDAR-XREF.
241600      MOVE WS-KEY-DATE            TO CAL-KEY-DATE.
241700      MOVE WS-KEY-RECORD-NUMBER   TO CAL-KEY-RECORD-NUMBER.
241800      MOVE ZEROS                  TO CAL-KEY-SUB-RECORD-NUMBER.
241900      MOVE F-PRIME TO FILE-KEY.
242000      MOVE F-START TO FILE-ACTION.
242100      CALL TPSIO018 USING FILE-REQUEST TPS-CALENDAR-REC.
242200      IF NOT A-SUCCESSFUL-OPERATION
242300         MOVE 'CALENDAR'    TO FILE-NAME
242400         MOVE 'TPS4010-SBC' TO FILE-TEXT
242500         PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
242600         GO TO MAINTENANCE-FUNCTION-EXIT
242700      END-IF.
242800      MOVE F-PRIME TO FILE-KEY.
242900      MOVE F-READ-NEXT TO FILE-ACTION.
243000      INITIALIZE WS-MEMO-AREA.
243100 MAINTENANCE-BROWSE-LOOP.
243200      CALL TPSIO018 USING FILE-REQUEST TPS-CALENDAR-REC.
243300      IF    END-OF-FILE-WAS-REACHED
243400         OR CLNT-PROFILE-ACCT-NO  NOT = CAL-KEY-ACCT-NO
243500         OR CLNT-PROFILE-SUB-ACCT NOT = CAL-KEY-SUB-ACCT
243600         OR WS-KEY-DATE           NOT = CAL-KEY-DATE
243700         OR WS-KEY-RECORD-NUMBER  NOT = CAL-KEY-RECORD-NUMBER
243800         GO TO MAINTENANCE-BROWSE-EXIT
243900      END-IF.
244000      IF NOT A-SUCCESSFUL-OPERATION
244100         MOVE 'CALENDAR'    TO FILE-NAME
244200         MOVE 'TPS4010-CRN' TO FILE-TEXT
244300         PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
244400         GO TO MAINTENANCE-FUNCTION-EXIT
244500      END-IF.
244600      SET THE-INDEX TO 8.
244700      IF      CAL-APPT-APPOINT-DATA(1:7) = 'Event: '
244800         SET THE-INDEX TO 1
244900         MOVE SPACES                    TO TPS4010::BY-WHO
245000         IF CAL-APPT-ADD-DATE = CAL-APPT-CHANGE-DATE
245100            MOVE '  ADDED'              TO WHAT-DID-THEY-DO
245200            MOVE CAL-APPT-ADD-PASSWORD  TO WHO-DID-IT
245300            MOVE CAL-APPT-ADD-DATE(5:2) TO WHEN-MM
245400            MOVE CAL-APPT-ADD-DATE(7:2) TO WHEN-DD
245500            MOVE CAL-APPT-ADD-DATE(3:2) TO WHEN-YY
245600          ELSE
245700            MOVE 'UPDATED'                 TO WHAT-DID-THEY-DO
245800            MOVE CAL-APPT-CHANGE-PASSWORD  TO WHO-DID-IT
245900            MOVE CAL-APPT-CHANGE-DATE(5:2) TO WHEN-MM
246000            MOVE CAL-APPT-CHANGE-DATE(7:2) TO WHEN-DD
246100            MOVE CAL-APPT-CHANGE-DATE(3:2) TO WHEN-YY
246200          END-IF
246300         MOVE WS-DONE-BY-WHO               TO TPS4010::BY-WHO
246400      END-IF.
246500      IF      CAL-APPT-APPOINT-DATA(1:6) = 'Date: '
246600         SET THE-INDEX TO 2
246700      END-IF.
246800      IF     CAL-APPT-APPOINT-DATA(1:10) = 'Given by: '
246900         SET THE-INDEX TO 3
247000      END-IF.
247100      IF     CAL-APPT-APPOINT-DATA(1:10) = 'Honoring: '
247200         SET THE-INDEX TO 4
247300      END-IF.
247400      IF     CAL-APPT-APPOINT-DATA(1:06) = 'RSVP: '
247500         SET THE-INDEX TO 5
247600      END-IF.
247700      IF     CAL-APPT-APPOINT-DATA(16:09) = 'Contact: '
247800         SET THE-INDEX TO 5
247900      END-IF.
248000      IF     CAL-APPT-APPOINT-DATA(1:06) = 'Cost: '
248100         SET THE-INDEX TO 6
248200      END-IF.
248300      IF     CAL-APPT-APPOINT-DATA(14:10) = 'Surprise: '
248400         SET THE-INDEX TO 6
248500      END-IF.
248600      IF     CAL-APPT-APPOINT-DATA(27:07) = 'Dress: '
248700         SET THE-INDEX TO 6
248800      END-IF.
248900      IF     CAL-APPT-APPOINT-DATA(01:10) = 'Location: '
249000         SET THE-INDEX TO 7
249100      END-IF.
249200      IF THE-INDEX IS LESS THAN 8
249300         CONTINUE
249400      ELSE
249500******MUST BE A MEMO LINE. FIND A BLANK LINE TO STORE IT.
249600         IF WS-MEMO-LINE-7 IS EQUAL TO SPACES
249700            SET THE-INDEX TO 8
249800         ELSE
249900         IF WS-MEMO-LINE-8 IS EQUAL TO SPACES
250000            SET THE-INDEX TO 9
250100         ELSE
250200            SET THE-INDEX TO 10
250300      END-IF.
250400      MOVE CAL-APPT-APPOINT-DATA TO WS-MEMO-LINE(THE-INDEX)
250500      GO TO MAINTENANCE-BROWSE-LOOP.
250600 MAINTENANCE-BROWSE-EXIT.
250700      MOVE WS-MEMO-EVENT
250800        TO TPS4010::EVENT-NAME.
250900      MOVE WS-MEMO-DATE-START
251000        TO TPS4010-DATE-START.
251100      MOVE WS-MEMO-DATE-END
251200        TO TPS4010-DATE-END.
251300      INSPECT WS-MEMO-TIME-START(1:4)
251400              REPLACING ALL X'20' BY X'30'
251500      MOVE WS-MEMO-TIME-START(1:2)
251600        TO TPS4010::TIME-START-HH.
251700      MOVE WS-MEMO-TIME-START(3:2)
251800        TO TPS4010::TIME-START-MM.
251900      MOVE WS-MEMO-START-AM-PM
252000        TO TPS4010::TIME-START-AM-PM.
252100      INSPECT WS-MEMO-TIME-END(1:4)
252200              REPLACING ALL X'20' BY X'30'
252300      MOVE WS-MEMO-TIME-END(1:2)
252400        TO TPS4010::TIME-END-HH.
252500      MOVE WS-MEMO-TIME-END(3:2)
252600        TO TPS4010::TIME-END-MM.
252700      MOVE WS-MEMO-END-AM-PM
252800        TO TPS4010::TIME-END-AM-PM.
252900      MOVE WS-MEMO-GIVEN-BY
253000        TO TPS4010::GIVEN-BY.
253100      MOVE WS-MEMO-HONORING
253200        TO TPS4010::HONORING-NAME.
253300      MOVE WS-MEMO-RSVP
253400        TO TPS4010-RSVP-DATE.
253500      MOVE WS-MEMO-CONTACT
253600        TO TPS4010::RSVP-CONTACT.
253700      MOVE WS-MEMO-COST
253800        TO TPS4010-EVENT-COST.
253900      MOVE WS-MEMO-SURPRISE
254000        TO TPS4010-SURPRISE-INDIC.
254100      MOVE WS-MEMO-DRESS
254200        TO TPS4010::DRESS-MEMO.
254300      MOVE WS-MEMO-LOCATION
254400        TO TPS4010::LOCATION.
254500      MOVE WS-MEMO-COMMENT-1
254600        TO TPS4010A::MEMO-LINE-01.
254700      MOVE WS-MEMO-COMMENT-2
254800        TO TPS4010A::MEMO-LINE-02.
254900      MOVE WS-MEMO-COMMENT-3
255000        TO TPS4010A::MEMO-LINE-03.
255100
255200 MAINTENANCE-FUNCTION-EXIT. EXIT.
255300
255400 UPDATE-MAIL-RECORD.
255500
255600    MOVE HOLD-MAIL-KEY   TO MAIL-KEY OF UPD-MAIL.
255700    IF NOT TPSMAIL-OPEN
255800       MOVE 1          TO TPSMAIL-FLAG
255900       MOVE F-OPEN-I-O TO FILE-ACTION
256000       CALL TPSIOREC USING FILE-REQUEST UPD-MAIL
256100       IF FILE-STATUS NOT = '00' AND '05'
256200          MOVE 'RECEIVE ' TO FILE-NAME
256300          MOVE 'OPEN-I-O' TO FILE-TEXT
256400          PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
256500          GO TO EXIT-THE-MODULE
256600    END-IF.
256700
256800    PERFORM READ-MAIL THRU READ-MAIL-EXIT.
256900    IF NO-RECORD-WAS-FOUND
257000      MOVE ZEROS               TO FILE-STATUS
257100      GO TO UPDATE-MAIL-RECORD-EXIT.
257200
257300    MOVE CAL-KEY-DATE          TO WS-KEY-DATE.
257400    MOVE CAL-KEY-RECORD-NUMBER TO WS-KEY-RECORD-NUMBER.
257500    MOVE WS-CALENDAR-XREF      TO MAIL-CALENDAR-XREF OF UPD-MAIL.
257600    PERFORM REWRITE-MAIL THRU REWRITE-MAIL-EXIT.
257700
257800 UPDATE-MAIL-RECORD-EXIT.   EXIT.
257900
258000 DELETE-MAIL-XREF.
258100
258200    MOVE HOLD-MAIL-KEY   TO MAIL-KEY OF UPD-MAIL.
258300    IF NOT TPSMAIL-OPEN
258400       MOVE 1          TO TPSMAIL-FLAG
258500       MOVE F-OPEN-I-O TO FILE-ACTION
258600       CALL TPSIOREC USING FILE-REQUEST UPD-MAIL
258700       IF FILE-STATUS NOT = '00' AND '05'
258800          MOVE 'RECEIVE ' TO FILE-NAME
258900          MOVE 'OPEN-I-O' TO FILE-TEXT
259000          PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
259100          GO TO EXIT-THE-MODULE
259200    END-IF.
259300
259400    PERFORM READ-MAIL THRU READ-MAIL-EXIT.
259500    IF NO-RECORD-WAS-FOUND
259600      MOVE ZEROS               TO FILE-STATUS
259700      GO TO DELETE-MAIL-XREF-EXIT.
259800
259900    MOVE ZEROS                 TO WS-CALENDAR-XREF.
260000    MOVE WS-CALENDAR-XREF      TO MAIL-CALENDAR-XREF OF UPD-MAIL.
260100    PERFORM REWRITE-MAIL THRU REWRITE-MAIL-EXIT.
260200
260300 DELETE-MAIL-XREF-EXIT.   EXIT.




