000100 IDENTIFICATION DIVISION.                                                            00000400
000200 PROGRAM-ID. TPS3059.                                                                00000500
000300 AUTHOR. T S.                                                                        00000600
000400****************************************************************                     00000700
001000*                                                     12/31/98 *                     00000800
000500*             MONTHLY SEARCH OF RECURRING D.B.                 *                     00000900
000500*             FOR AUTOMATIC PAYMENT EXPIRATION                 *                     00001000
001000*                                                              *                     00001100
001000*  PROGRAM IS CALLED BY TPS000 ONCE PER MONTH AFTER MONTHLY    *                     00001200
001000*  REPORTS ARE GENERATED. CALL IS TRIGGERED WHEN SYSTEM DATE   *                     00001300
001000*  IS < CAL-ADM-MNTH-ACTIVITY-DATE (THE DATE USED TO TRIGGER   *                     00001400
001000*  RUNNING THE MONTHLY MANAGEMENT REPORTS - TPS3058)......     *                     00001500
001000*                                                              *                     00001600
000800****************************************************************                     00001700
000900*                    MAINTENANCE LOG                           *
      * 06/15/17 CHANGED GUI                                       AC*  
      * 01/21/02 modified program to set on hold expire date to the  *                                                  
      *    TS    current date +180 days, consist with other programs *                                                  
061100*          in system (field is 'mail-on-hold-expire-date')     *                                                  
      * 01/24/01 VARIOUS CHANGES TO PROCESS NEW RECURRING CODES FOR  *                                                  
      *    TS    WEEKLY AND BI-WEEKLY PAYMENT CYCLE (06 & 07)......  *                                                  
001000* 11/06/00 REPLACE TPSSIGN WITH PASIGN                    JM   *                     00001900                     
001000* 11/05/99 ADDED CODE TO CHECK FOR 02, 11, 31, 33 BEFORE       *                     00001900                     
001000*    TS    CHECKING FOR AUTOMATIC PAYMENT.                     *                     00001910                     
001000*          ADDED ADMIN MEMO EXPLAINING WHY MEMOS RE: EXPIRE    *                     00001920                     
001000*          MEMOS ARE BEING REPORTED...........                 *                     00001930                     
001500****************************************************************                     00002400
001600 ENVIRONMENT DIVISION.                                                               00002500
001700 CONFIGURATION SECTION.                                                              00002600
001800 SOURCE-COMPUTER. IBM-PS2.                                                           00002700
001900 OBJECT-COMPUTER. IBM-PS2.                                                           00002800
002000 FILE-CONTROL.                                                                       00002900
002100***  SELECT PRT-FILE  ASSIGN TO EXTERNAL LISTFILE                                    00003000
002200     SELECT PRT-FILE  ASSIGN TO REPORT-ASSIGNMENT                                    00003100
002300         ORGANIZATION IS LINE SEQUENTIAL.                                            00003200
002400                                                                                     00003300
002500 DATA DIVISION.                                                                      00003400
002600 FILE SECTION.                                                                       00003500
002700 FD  PRT-FILE                                                                        00003600
002800     LABEL RECORDS ARE OMITTED                                                       00003700
002900     RECORD CONTAINS 200 CHARACTERS.                                                 00003800
003000 01  PRT-RECORD                    PIC  X(200).                                      00003900
003100                                                                                     00004000
003200 WORKING-STORAGE SECTION.                                                            00004100

***************** WINFORMS SCREEN DEFINITION **********

       01 PROCESS-RPTS type TPS000.PROCESS_RPTSForm.

       01 PROCESS-RPTS-DISPLAY-FLAG PIC 9(01) VALUE 0.


       01 WS-CURRENT-X                            PIC 9(04).
       01 WS-CURRENT-Y                            PIC 9(04).
       01 WS-CURRENT-XY-PARM.
          05 WS-X-PARM                            PIC 9(04).
          05 WS-Y-PARM                            PIC 9(04).

********************************************************

003300     COPY "TPSFILES.CPY".                                                            00004200
003400     COPY "KEYVALUE.CPY".                                                            00004300
003500     COPY "PCL5VALU.CPY".                                                            00004400
003600                                                                                     00004500

003600                                                                                     00004700
004000 01 TPS-MAIL-REC.                                                                    00004800
004100     COPY "TPSMAIL.CPY".                                                             00004900
003900                                                                                     00005000
004000 01 SAV-MAIL-REC                   PIC  X(1190).                                     00005001
003900                                                                                     00005010
004000 01 TPS-PROFL-REC.                                                                   00005100
004100     COPY "TPSPROFL.CPY".                                                            00005200
005100 
       01  GUISCREEN               PIC x(08) VALUE 'GS      '.                             00005300
005200 01  PROGRAM-NAMES.                                                                  00005400
005300     10 TPSIOERR    PIC X(08) VALUE 'TPSIOERR'.                                      00005500
005400     10 TPSIOREC    PIC X(08) VALUE 'TPSIOREC'.                                      00005600
005800     10 TPSIORCR    PIC X(08) VALUE 'TPSIORCR'.                                      00005700
005800     10 TPSIO004    PIC X(08) VALUE 'TPSIO004'.                                      00005800
005900     10 FLOATBIG    PIC X(08) VALUE 'FLOATBIG'.                                      00005900
006000     10 TPSDATES    PIC X(08) VALUE 'TPSDATES'.                                      00006000
006000*JM11/00    10 TPSSIGN     PIC X(08) VALUE 'TPSSIGN '.                               00006100
006000     10 PASIGN      PIC X(08) VALUE 'PASIGN'.                                        00006100
006000     10 TPS1010G    PIC X(08) VALUE 'TPS1010G'.                                      00006200
006200*    10 SCREENIO    PIC X(08) VALUE 'SCRNIO'.                                        00006300
006300     10 FILLER      PIC X(08) VALUE HIGH-VALUES.                                     00006400
006400                                                                                     00006500
013100                                                                                     00006600
013000 01  THE-INDEX                          PIC S9(04) COMP.                             00006700
013100                                                                                     00006800
013200 01  TPS-FILE-STATUS                       PIC XX.                                   00006900
013300     88  TPS-CARRIER-FILE-OK VALUE '00', '02'.                                       00007000
013400                                                                                     00007100
013500 01  MISC-WORKING-STORAGE.                                                           00007200
019700      05  WS-TODAYS-DATE-YMD          PIC  X(06).                                    00007300
019700      05  WS-TODAYS-DATE-CYMD         PIC  9(08).                                    00007400
061100*01/21/02                                                                                                         
061100      05  TODAYS-DATE-PLUS-180        pic  9(08).                                                                 
019800                                                                                     00007500
034900      05  EXPIRE-MONTH-DATE-FROM      PIC  9(08).                                    00007600
034900      05  EXPIRE-MONTH-DATE-TO        PIC  9(08).                                    00007700
023400                                                                                     00007800
046400      05  WORK-PAYMENT-DATE           PIC  9(08).                                    00007900
046400      05  LAST-PAYMENT-DATE           PIC  9(08).                                    00008000
            05  LAST-PAYMENT-FACTOR         PIC  9(08).                                    00008100
            05  WORK-PAYMENT-FACTOR         PIC  9(08).                                    00008200
027000                                                                                     00008300
027100  01  WS-DATE-REQUEST.                                                               00008400
027200      05  WS-DATE-PARAM          PIC  9(02).                                         00008500
027300      05  WS-DATE-TENBYTES       PIC  X(20) VALUE SPACES.                            00008600
027400      05  FILLER REDEFINES WS-DATE-TENBYTES.                                         00008700
027500          10  WS-DATE-REFORM         PIC  X(06).                                     00008800
027600          10  WS-DATE-EXTEND         PIC  X(04).                                     00008900
027700          10  FILLER                 PIC  X(10).                                     00009000
027800      05  FILLER REDEFINES WS-DATE-TENBYTES.                                         00009100
027900          10  WS-DATE-REFORM-LEN06   PIC  X(06).                                     00009200
028000          10  FILLER                 PIC  X(14).                                     00009300
028100      05  FILLER REDEFINES WS-DATE-TENBYTES.                                         00009400
028200          10  WS-DATE-REFORM-LEN08   PIC  X(08).                                     00009500
028300          10  FILLER                 PIC  X(12).                                     00009600
028400      05  FILLER REDEFINES WS-DATE-TENBYTES.                                         00009700
028500          10  WS-DATE-REFORM-LEN10   PIC  X(10).                                     00009800
028600          10  FILLER                 PIC  X(10).                                     00009900
028700      05  FILLER REDEFINES WS-DATE-TENBYTES.                                         00010000
028800          10  WS-TIME-PARM1          PIC  X(06).                                     00010100
028900          10  WS-TIME-PARM2          PIC  X(06).                                     00010200
029000          10  WS-TIME-EXTEND         PIC  X(08).                                     00010300
029100      05  FILLER REDEFINES WS-DATE-TENBYTES.                                         00010400
029200          10  WS-TIME-PARM1BY8       PIC  X(08).                                     00010500
029300          10  WS-TIME-PARM2BY8       PIC  X(08).                                     00010600
029400          10  WS-TIME-EXTNDBY8       PIC  X(04).                                     00010700
029500                                                                                     00010800
029600                                                                                     00010900
029700  01  BG-FLOAT-DATA.                                                                 00011000
029800      05  BG-FLOAT-PARMS              PIC  X(161).                                   00011100
029900      05  FILLER REDEFINES BG-FLOAT-PARMS.                                           00011200
030000          10  BG-FLOAT-COUNT          PIC  X(01).                                    00011300
030100          10  BG-FLOAT-1              PIC  X(40).                                    00011400
030200          10  BG-FLOAT-2              PIC  X(40).                                    00011500
030300          10  BG-FLOAT-2-R REDEFINES BG-FLOAT-2.                                     00011600
030400              15  BG-FLOAT-2-I        PIC  X(01) OCCURS 40 TIMES.                    00011700
030500          10  BG-FLOAT-3              PIC  X(40).                                    00011800
030600          10  FILLER REDEFINES BG-FLOAT-3.                                           00011900
030700              15  BG-FLOAT-3-A        PIC  X(37).                                    00012000
030800              15  BG-FLOAT-3-B        PIC  X(03).                                    00012100
030900          10  BG-FLOAT-3-R REDEFINES BG-FLOAT-3.                                     00012200
031000              15  BG-FLOAT-3-I        PIC  X(01) OCCURS 40 TIMES.                    00012300
031100          10  BG-FLOAT-4              PIC  X(40).                                    00012400
031200                                                                                     00012500
028000                                                                                     00012600
       01  MEMO-RECORD.                                                                    00012700
           05  MEMO-KEY  PIC X(23).                                                        00012800
           05  MEMO-LINE-01.                                                               00012900
               10 FILLER PIC X(50) VALUE                                                   00013000
                 '                                                  '.                     00013100
           05  MEMO-LINE-02.                                                               00013200
               10 FILLER PIC X(50) VALUE                                                   00013300
                 '                                                  '.                     00013400
           05  MEMO-LINE-03.                                                               00013500
               10 FILLER PIC X(50) VALUE                                                   00013600
                 '                                                  '.                     00013700
           05  MEMO-LINE-04.                                                               00013800
               10 FILLER PIC X(50) VALUE                                                   00013900
                 '                                                  '.                     00014000
           05  MEMO-LINE-05.                                                               00014100
               10 FILLER PIC X(50) VALUE                                                   00014200
                 '                                                  '.                     00014300
           05  MEMO-LINE-06.                                                               00014400
               10 FILLER PIC X(50) VALUE                                                   00014500
                 'TPS will NOT issue any payments once the          '.                     00014600
           05  MEMO-LINE-07.                                                               00014700
               10 FILLER PIC X(50) VALUE                                                   00014800
                 'expiration date has passed. If you would like     '.                     00014900
           05  MEMO-LINE-08.                                                               00015000
               10 FILLER PIC X(50) VALUE                                                   00015100
                 'TPS to continue making this payment on your       '.                     00015200
           05  MEMO-LINE-09.                                                               00015300
               10 FILLER PIC X(50) VALUE                                                   00015400
                 'behalf, please provide me with a new expiration   '.                     00015500
           05  MEMO-LINE-10.                                                               00015600
               10 FILLER PIC X(50) VALUE                                                   00015700
                 'date and amount, if applicable.                   '.                     00015800
      *---------------------------------------------------------------                     00015900
031200*11/05/99                                                                            00016000
       01  PROCEDURE-FLAG                 PIC  9(01) VALUE 0.                              00016010
           88  PROCEDURE-IN-PROGRESS                 VALUE 1.                              00016020
017400 01  PROCEDURE-ACCT-NO              PIC  9(10) VALUE ZEROS.                          00016030
028000                                                                                     00016100
268500 01  SAVE-MAIL-KEY                  PIC  X(23).                                      00016101
028000                                                                                     00016110
028000*11/05/99                                                                            00016120
       01  PROC-RECORD.                                                                    00016200
           05  PROC-KEY  PIC X(23).                                                        00016300
           05  PROC-LINE-01.                                                               00016400
               10 FILLER PIC X(50) VALUE                                                   00016500
                 "The following Administrator Memo(s) are part of   ".                     00016600
           05  PROC-LINE-02.                                                               00016700
               10 FILLER PIC X(50) VALUE                                                   00016800
                 "TPS' quality assurance procedures to ensure that  ".                     00016900
           05  PROC-LINE-03.                                                               00017000
               10 FILLER PIC X(50) VALUE                                                   00017100
                 "'automatic payments' being made on your behalf are".                     00017200
           05  PROC-LINE-04.                                                               00017300
               10 FILLER PIC X(50) VALUE                                                   00017400
                 "accurate and that they are still in effect.       ".                     00017500
           05  PROC-LINE-05.                                                               00017600
               10 FILLER PIC X(50) VALUE                                                   00017700
                 "                                                  ".                     00017800
           05  PROC-LINE-06.                                                               00017900
               10 FILLER PIC X(50) VALUE                                                   00018000
                 "                                                  ".                     00018100
           05  PROC-LINE-07.                                                               00018200
               10 FILLER PIC X(50) VALUE                                                   00018300
                 "                                                  ".                     00018400
           05  PROC-LINE-08.                                                               00018500
               10 FILLER PIC X(50) VALUE                                                   00018600
                 "                                                  ".                     00018601
           05  PROC-LINE-09.                                                               00018800
               10 FILLER PIC X(50) VALUE                                                   00018900
                 "                                                  ".                     00018901
           05  PROC-LINE-10.                                                               00019100
               10 FILLER PIC X(50) VALUE                                                   00019200
                 "                                                  ".                     00019201
      *---------------------------------------------------------------                     00019400
033200                                                                                     00019500
048400 01  LS-LOGON-PARMS.                                                                 00019600
048500     05  LS-ACCESS-LEVEL          PIC  X(02).                                        00019700
048600     05  LS-ACCESS-LEVEL-NAME     PIC  X(36).                                        00019800
048700     05  LS-ACCESS-LEVEL-TITLE    PIC  X(36).                                        00019900
048800     05  LS-ACCESS-LEVEL-INITIALS PIC  X(07).                                        00020000
048900                                                                                     00020100
033200                                                                                     00020200
033700*01 DOLLAR-MASK            PIC $,$$$,$$9.99.                                         00020300
033700 01 DOLLAR-MASK            PIC $$,$$$,$$9.99.                                        00020400
033300                                                                                     00020500
033400                                                                                     00020600
033500 LINKAGE SECTION.                                                                    00020700
033700 01 TPS-LOGON-REC.                                                                   00020900
033800     COPY "TPSLOGON.CPY".                                                            00021000
033700 01 TPS-CALEN-REC.                                                                   00021200
033800     COPY "TPSCALEN.CPY".                                                            00021300
033900                                                                                     00021400
034000 01 CURRENT-XY-PARAMETERS PIC 9(08).
000215
034100*PROCEDURE DIVISION.                                                                 00021800
034100 PROCEDURE DIVISION USING TPS-LOGON-REC                                              00021810
034100                          TPS-CALEN-REC
                                CURRENT-XY-PARAMETERS.
034200                                                                                     00021900
034300 TPS3059-BEGIN.                                                                      00022000


           MOVE CURRENT-XY-PARAMETERS(1:4) TO WS-CURRENT-X
                                              WS-X-PARM.
           MOVE CURRENT-XY-PARAMETERS(5:4) TO WS-CURRENT-Y
                                              WS-Y-PARM.

           IF PROCESS-RPTS-DISPLAY-FLAG = 0
               SET PROCESS-RPTS TO NEW TPS000.PROCESS_RPTSForm
               MOVE 1 TO PROCESS-RPTS::AUTO-PAY-EXPIRE
               SET PROCESS-RPTS::X-POINT TO WS-X-PARM
               SET PROCESS-RPTS::Y-POINT TO WS-Y-PARM
               INVOKE PROCESS-RPTS::Show
               MOVE 0 TO PROCESS-RPTS::AUTO-PAY-EXPIRE
               MOVE 1 TO PROCESS-RPTS-DISPLAY-FLAG
           END-IF.


004000      INITIALIZE TPS-MAIL-REC.                                                       00022800
004000      INITIALIZE TPS-PROFL-REC.                                                      00022900
034200                                                                                     00023000
034800      ACCEPT WS-TODAYS-DATE-YMD FROM DATE.                                           00023100
035000      MOVE 01                   TO WS-DATE-PARAM.                                    00023200
035100      MOVE SPACES               TO WS-DATE-TENBYTES.                                 00023300
034900      MOVE WS-TODAYS-DATE-YMD   TO WS-DATE-REFORM-LEN06.                             00023400
035300      CALL TPSDATES USING WS-DATE-REQUEST.                                          000023500
035400      MOVE WS-DATE-REFORM-LEN08 TO WS-TODAYS-DATE-CYMD.                              00023600
034900*01/21/02                                                                                                         
061200                                                                                     00083400
060700      MOVE 21                   TO WS-DATE-PARAM.                                    00083500
015100      MOVE SPACES               TO WS-DATE-TENBYTES.                                 00083600
061100      MOVE WS-TODAYS-DATE-CYMD  TO WS-DATE-REFORM-LEN08.                             00083700
061100      MOVE '180'                TO WS-DATE-REFORM-LEN08(9:3).                        00083800
061000       CALL TPSDATES USING WS-DATE-REQUEST.                                          00083900
061100      MOVE WS-DATE-REFORM-LEN08 TO TODAYS-DATE-PLUS-180.                          00000084000
061200                                                                                     00084100
034900                                                                                                                  
034900                                                                                                                  
034900                                                                                                                  
034900                                                                                                                  
034900                                                                                                                  
034900                                                                                                                  
034900                                                                                                                  
034900                                                                                                                  
034900                                                                                                                  
034900                                                                                                                  
034900                                                                                                                  
034900                                                                                                                  
034900*TEMP CODE TO COMBINED JAN & FEB '99 IN FIRST RUNNING                                00023800
034900*TEMP CODE    OF EXPIRE SEARCH, AFTER 1ST EXECUTION                                  00023900
034900*TEMP CODE    CHECK WILL BE 1 MONTH EACH MONTH.......                                00024000
034900      IF CAL-ADM-MNTH-ACTIVITY-DATE = 19990101                                       00024100
034900         MOVE CAL-ADM-MNTH-ACTIVITY-DATE                                             00024200
034900                                TO EXPIRE-MONTH-DATE-FROM                            00024300
034900         MOVE '19990228'        TO EXPIRE-MONTH-DATE-TO                              00024400
034900         GO TO FIX-DATES-ONLY-ONCE                                                   00024500
             END-IF.                                                                       00024600
034900                                                                                     00024700
034900                                                                                     00024800
034900      MOVE CAL-ADM-MNTH-ACTIVITY-DATE                                                00024900
034900                                TO EXPIRE-MONTH-DATE-FROM.                           00025000
034900      ADD  100                  TO EXPIRE-MONTH-DATE-FROM.                           00025100
034900      IF EXPIRE-MONTH-DATE-FROM(5:2) > 12                                            00025200
034900         ADD  10000             TO EXPIRE-MONTH-DATE-FROM                            00025300
034900         SUBTRACT 1200        FROM EXPIRE-MONTH-DATE-FROM                            00025400
034900         MOVE 01                TO EXPIRE-MONTH-DATE-FROM(7:2)                       00025500
             END-IF.                                                                       00025600
034900      MOVE EXPIRE-MONTH-DATE-FROM                                                    00025700
034900                                TO EXPIRE-MONTH-DATE-TO.                             00025800
035000      MOVE 24                   TO WS-DATE-PARAM.                                    00025900
035100      MOVE SPACES               TO WS-DATE-TENBYTES.                                 00026000
034900      MOVE EXPIRE-MONTH-DATE-TO TO WS-DATE-REFORM-LEN08.                             00026100
035300      CALL TPSDATES USING WS-DATE-REQUEST.                                          000026200
035400      MOVE WS-DATE-REFORM-LEN08 TO EXPIRE-MONTH-DATE-TO.                             00026300
034900                                                                                     00026400
034900 FIX-DATES-ONLY-ONCE.                                                                00026500
057500      PERFORM OPEN-THE-FILES THRU                                                    00026600
057500              OPEN-THE-FILES-EXIT.                                                   00026700
                                                                                           00026800
010100      PERFORM READ-THE-RECUR THRU                                                    00026900
010600              READ-THE-RECUR-EXIT.                                                   00027000
034900                                                                                     00027100
057700      GO TO TPS3059-COMMON-EXIT.                                                     00027200
                                                                                           00027300
                                                                                           00027400
010100 READ-THE-RECUR.                                                                     00027500
010200    MOVE LOW-VALUES TO RECUR-KEY.                                                    00027600
010300    MOVE F-PRIME TO FILE-KEY.                                                        00027700
010400    MOVE F-START TO FILE-ACTION.                                                     00027800
020200    CALL TPSIORCR USING FILE-REQUEST RECUR-ROOT-SECTION.                             00027900
010600    IF NO-RECORD-WAS-FOUND                                                           00028000
010600       GO TO READ-THE-RECUR-EXIT                                                     00028100
           END-IF.                                                                         00028200
010700    IF NOT A-SUCCESSFUL-OPERATION                                                    00028300
010800       MOVE ' RECUR' TO FILE-NAME                                                    00028400
010900       MOVE 'SEELOGON-SBR' TO FILE-TEXT                                              00028500
011000       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                       00028600
057700       GO TO TPS3059-COMMON-EXIT                                                     00028700
           END-IF.                                                                         00028800
011200                                                                                     00028900
011200                                                                                     00029000
011300 READ-ALL-RECUR-RECORDS.                                                             00029100
011400    MOVE F-PRIME TO FILE-KEY.                                                        00029200
011500    MOVE F-READ-NEXT TO FILE-ACTION.                                                 00029300
020200    CALL TPSIORCR USING FILE-REQUEST RECUR-ROOT-SECTION.                             00029400
011700    IF END-OF-FILE-WAS-REACHED                                                       00029500
010600       GO TO READ-THE-RECUR-EXIT                                                     00029600
           END-IF.                                                                         00029700
011800    IF NOT A-SUCCESSFUL-OPERATION                                                    00029800
011900       MOVE ' RECUR' TO FILE-NAME                                                    00029900
012000       MOVE 'FIXRECUR-BRN' TO FILE-TEXT                                              00030000
012100       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                       00030100
057700       GO TO TPS3059-COMMON-EXIT                                                     00030200
           END-IF.                                                                         00030300
012300                                                                                     00030400
012300                                                                                     00030500
035400    IF WS-TODAYS-DATE-CYMD = '19991105'                                              00030510
017400       IF RECUR-ACCT-NO < '0150000057'                                               00030600
011300          GO TO READ-ALL-RECUR-RECORDS                                               00030610
               ELSE                                                                        00030620
017400       IF RECUR-ACCT-NO = '0150000057'                                               00030630
012300          CONTINUE                                                                   00030700
               ELSE                                                                        00030710
010600          GO TO READ-THE-RECUR-EXIT                                                  00030720
              END-IF                                                                       00030730
           END-IF.                                                                         00030800
012300                                                                                     00030900
012300*11/05/99                                                                            00031000
007600    IF RECUR-CHART-ACCT-01(1:2) NOT = '02' AND                                       00031100
007600                                      '11' AND                                       00031200
007600                                      '31' AND                                       00031300
007600                                      '33'                                           00031400
011300       GO TO READ-ALL-RECUR-RECORDS                                                  00031500
           END-IF.                                                                         00031600
012300                                                                                     00031700
012342*------------- AUTOMATIC PAYMENT ?????? ------------------                           00031800
007600    IF RECUR-CYCLE-EVENT(1:1) NOT = '2'                                              00031900
011300       GO TO READ-ALL-RECUR-RECORDS                                                  00032000
           END-IF.                                                                         00032100
012342                                                                                     00032200
007600    IF RECUR-EXPIRE-DATE < EXPIRE-MONTH-DATE-FROM                                    00032300
011300       GO TO READ-ALL-RECUR-RECORDS                                                  00032400
           END-IF.                                                                         00032500
012342                                                                                     00032600
007600    IF RECUR-EXPIRE-DATE > EXPIRE-MONTH-DATE-TO                                      00032700
011300       GO TO READ-ALL-RECUR-RECORDS                                                  00032800
           END-IF.                                                                         00032900
012342                                                                                     00033000
          PERFORM WRITE-ADMIN-MEMO-ONHOLD THRU                                             00033100
                  WRITE-ADMIN-MEMO-ONHOLD-EXIT.                                            00033200
012342                                                                                     00033300
012359    GO TO READ-ALL-RECUR-RECORDS.                                                    00033400
012360                                                                                     00033500
015800 READ-THE-RECUR-EXIT. EXIT.                                                          00033600
015900                                                                                     00033700
016000                                                                                     00033800
                                                                                           00033900
                                                                                           00034000
       WRITE-ADMIN-MEMO-ONHOLD.                                                            00034100
028000*11/05/99                                                                            00034120
017400     IF RECUR-ACCT-NO NOT = PROCEDURE-ACCT-NO                                        00034200
017400        MOVE RECUR-ACCT-NO  TO PROCEDURE-ACCT-NO                                     00034210
              PERFORM PROCEDURE-MEMO THRU                                                  00034300
                      PROCEDURE-MEMO-EXIT                                                  00034400
            END-IF.                                                                        00034500
                                                                                           00034600
268500     MOVE MAIL-KEY            TO MEMO-KEY.                                           00034700
                                                                                           00034800
043000     MOVE SPACES              TO BG-FLOAT-PARMS.                                     00034900
043500     MOVE 'RE:'               TO BG-FLOAT-1.                                         00035000
041200     MOVE RECUR-PAYEE-NAME    TO BG-FLOAT-2.                                         00035100
043300     MOVE '2'                 TO BG-FLOAT-COUNT.                                     00035200
046200     CALL FLOATBIG USING BG-FLOAT-PARMS.                                             00035300
046200     CANCEL FLOATBIG.                                                                00035400
046400     MOVE BG-FLOAT-1(1:50)    TO MEMO-LINE-01.                                       00035500
                                                                                           00035600
                                                                                           00035700
                                                                                           00035800
      *--------------------------------------------------------------                      00035900
      *--------------------------------------------------------------                      00036000
      *--------------------------------------------------------------                      00036100
          MOVE SPACES                     TO BG-FLOAT-DATA.                                00036200
      *** MOVE '    Automatic'            TO BG-FLOAT-1.                                   00036300
          MOVE 'Automatic'                TO BG-FLOAT-1.                                   00036400
          IF RECUR-CYCLE-EVENT(2:1) = '0'                                                  00036500
             MOVE 'Monthly'               TO BG-FLOAT-2                                    00036600
            ELSE                                                                           00036700
          IF RECUR-CYCLE-EVENT(2:1) = '1'                                                  00036800
             MOVE 'Bi-Monthly'            TO BG-FLOAT-2                                    00036900
            ELSE                                                                           00037000
          IF RECUR-CYCLE-EVENT(2:1) = '2'                                                  00037100
             MOVE 'Quarterly'             TO BG-FLOAT-2                                    00037200
            ELSE                                                                           00037300
          IF RECUR-CYCLE-EVENT(2:1) = '3'                                                  00037400
             MOVE 'Semi-Annual'           TO BG-FLOAT-2                                    00037500
            ELSE                                                                           00037600
          IF RECUR-CYCLE-EVENT(2:1) = '4'                                                  00037700
             MOVE 'Annual'                TO BG-FLOAT-2                                    00037800
            ELSE                                                                           00037900
          IF RECUR-CYCLE-EVENT(2:1) = '5'                                                  00038000
             MOVE 'Bi-Annual'             TO BG-FLOAT-2                                    00038100
            ELSE                                                                           00038200
      *01/24/01                                                                                                         
          IF RECUR-CYCLE-EVENT(2:1) = '6'                                                  00038000
             MOVE 'Weekly   '             TO BG-FLOAT-2                                    00038100
            ELSE                                                                           00038200
          IF RECUR-CYCLE-EVENT(2:1) = '7'                                                  00038000
             MOVE 'Bi-Weekly'             TO BG-FLOAT-2                                    00038100
            ELSE                                                                           00038200
             MOVE '***'                   TO BG-FLOAT-2                                    00038300
           END-IF.                                                                         00038900
          MOVE 'Payments'                 TO BG-FLOAT-3.                                   00039000
          MOVE 3                          TO BG-FLOAT-COUNT.                               00039100
          CALL FLOATBIG USING BG-FLOAT-DATA.                                               00039200
          CANCEL FLOATBIG.                                                                 00039300
046400    MOVE BG-FLOAT-1(1:50)           TO MEMO-LINE-02.                                 00039400
                                                                                           00039500
      *--------------------------------------------------------------                      00039600
          MOVE SPACES                     TO BG-FLOAT-DATA.                                00039700
      *** MOVE '    In the Amount of'     TO BG-FLOAT-1.                                   00039800
          MOVE 'In the Amount of'         TO BG-FLOAT-1.                                   00039900
          MOVE RECUR-CYCLE-AMOUNT         TO DOLLAR-MASK.                                  00040000
033700    IF DOLLAR-MASK(1:1) NOT = SPACES                                                 00040100
             MOVE DOLLAR-MASK(1:13)       TO BG-FLOAT-2                                    00040200
            ELSE                                                                           00040300
033700    IF DOLLAR-MASK(2:1) NOT = SPACES                                                 00040400
             MOVE DOLLAR-MASK(2:12)       TO BG-FLOAT-2                                    00040500
            ELSE                                                                           00040600
033700    IF DOLLAR-MASK(3:1) NOT = SPACES                                                 00040700
             MOVE DOLLAR-MASK(3:11)       TO BG-FLOAT-2                                    00040800
            ELSE                                                                           00040900
033700    IF DOLLAR-MASK(4:1) NOT = SPACES                                                 00041000
             MOVE DOLLAR-MASK(4:10)       TO BG-FLOAT-2                                    00041100
            ELSE                                                                           00041200
033700    IF DOLLAR-MASK(5:1) NOT = SPACES                                                 00041300
             MOVE DOLLAR-MASK(5:09)       TO BG-FLOAT-2                                    00041400
            ELSE                                                                           00041500
033700    IF DOLLAR-MASK(6:1) NOT = SPACES                                                 00041600
             MOVE DOLLAR-MASK(6:08)       TO BG-FLOAT-2                                    00041700
            ELSE                                                                           00041800
033700    IF DOLLAR-MASK(7:1) NOT = SPACES                                                 00041900
             MOVE DOLLAR-MASK(7:07)       TO BG-FLOAT-2                                    00042000
            ELSE                                                                           00042100
033700    IF DOLLAR-MASK(8:1) NOT = SPACES                                                 00042200
             MOVE DOLLAR-MASK(8:06)       TO BG-FLOAT-2                                    00042300
            ELSE                                                                           00042400
033700    IF DOLLAR-MASK(9:1) NOT = SPACES                                                 00042500
             MOVE DOLLAR-MASK(9:05)       TO BG-FLOAT-2                                    00042600
            ELSE                                                                           00042700
             MOVE DOLLAR-MASK(10:04)      TO BG-FLOAT-2                                    00042800
                   END-IF                                                                  00042900
                  END-IF                                                                   00043000
                 END-IF                                                                    00043100
                END-IF                                                                     00043200
               END-IF                                                                      00043300
              END-IF                                                                       00043400
             END-IF                                                                        00043500
            END-IF                                                                         00043600
           END-IF.                                                                         00043700
                                                                                           00043800
          MOVE 2                          TO BG-FLOAT-COUNT.                               00043900
          CALL FLOATBIG USING BG-FLOAT-DATA.                                               00044000
          CANCEL FLOATBIG.                                                                 00044100
046400    MOVE BG-FLOAT-1(1:50)           TO MEMO-LINE-03.                                 00044200
      *--------------------------------------------------------------                      00044300
          MOVE SPACES                     TO BG-FLOAT-DATA.                                00044400
          MOVE 3                          TO BG-FLOAT-COUNT.                               00044500
      **  MOVE '    To Expire on'         TO BG-FLOAT-1.                                   00044600
          MOVE 'To Expire on'             TO BG-FLOAT-1.                                   00044700
035000    MOVE 06                         TO WS-DATE-PARAM.                                00044800
035100    MOVE SPACES                     TO WS-DATE-TENBYTES.                             00044900
007600    MOVE RECUR-EXPIRE-DATE(3:6)     TO WS-DATE-REFORM-LEN06.                         00045000
035300    CALL TPSDATES USING WS-DATE-REQUEST.                                          0  00045100
027300    MOVE WS-DATE-TENBYTES           TO BG-FLOAT-2.                                   00045200
027300    MOVE '.'                        TO BG-FLOAT-3.                                   00045300
          CALL FLOATBIG USING BG-FLOAT-DATA.                                               00045400
          CANCEL FLOATBIG.                                                                 00045500
046400    MOVE BG-FLOAT-1(1:50)           TO MEMO-LINE-04.                                 00045600
      *--------------------------------------------------------------                      00045700
      **********   123456789012345678901234567890123456                                    00045800
046400    PERFORM FIGURE-LAST-PAYMENT THRU                                                 00045900
046400            FIGURE-LAST-PAYMENT-EXIT.                                                00046000
          MOVE SPACES                     TO BG-FLOAT-DATA.                                00046100
          MOVE 3                          TO BG-FLOAT-COUNT.                               00046200
046400    IF LAST-PAYMENT-DATE < WS-TODAYS-DATE-CYMD                                       00046300
      ***    MOVE '    Last Payment Was '    TO BG-FLOAT-1                                 00046400
             MOVE 'Last Payment Was '        TO BG-FLOAT-1                                 00046500
            ELSE                                                                           00046600
      ****** MOVE '    Last Payment Is '     TO BG-FLOAT-1                                 00046700
      ***    MOVE '    Last Payment Will Be' TO BG-FLOAT-1                                 00046800
             MOVE 'Last Payment Will Be'     TO BG-FLOAT-1                                 00046900
           END-IF.                                                                         00047000
035000    MOVE 06                         TO WS-DATE-PARAM.                                00047100
035100    MOVE SPACES                     TO WS-DATE-TENBYTES.                             00047200
007600    MOVE LAST-PAYMENT-DATE(3:6)     TO WS-DATE-REFORM-LEN06.                         00047300
035300    CALL TPSDATES USING WS-DATE-REQUEST.                                          0  00047400
027300    MOVE WS-DATE-TENBYTES           TO BG-FLOAT-2.                                   00047500
027300    MOVE '.'                        TO BG-FLOAT-3.                                   00047600
          CALL FLOATBIG USING BG-FLOAT-DATA.                                               00047700
          CANCEL FLOATBIG.                                                                 00047800
046400    MOVE BG-FLOAT-1(1:50)           TO MEMO-LINE-05.                                 00047900
                                                                                           00048000
                                                                                           00048100
      *--------------------------------------------------------------                      00048200
       ENTER-FROM-PROCEDURE.                                                               00048210
017400    IF RECUR-ACCT-NO NOT = CLNT-PROFILE-ACCT-NO                                      00048300
017500       MOVE RECUR-ACCT-NO     TO CLNT-PROFILE-ACCT-NO                                00048400
017600       MOVE ZEROS             TO CLNT-PROFILE-SUB-ACCT                               00048500
011400       MOVE F-PRIME TO FILE-KEY                                                      00048600
011500       MOVE F-READ  TO FILE-ACTION                                                   00048700
020200       CALL TPSIO004 USING FILE-REQUEST TPS-PROFL-REC                                00048800
011800       IF NOT A-SUCCESSFUL-OPERATION                                                 00048900
011900          MOVE ' RECUR'       TO FILE-NAME                                           00049000
012000          MOVE 'TPS3059-READ' TO FILE-TEXT                                           00049100
012100          PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                    00049200
057700          GO TO TPS3059-COMMON-EXIT                                                  00049300
              END-IF                                                                       00049400
           END-IF.                                                                         00049500
012300                                                                                     00049600
      *--------------------------------------------------------------                      00049700
                                                                                           00049800
023870      MOVE '04'                  TO LS-ACCESS-LEVEL.                                 00049900
023871      MOVE SPACES                TO LS-ACCESS-LEVEL-NAME                             00050000
023872                                    LS-ACCESS-LEVEL-TITLE                            00050100
023873                                    LS-ACCESS-LEVEL-INITIALS.                        00050200
006100                                                                                     00050300
023874      CALL PASIGN USING TPS-PROFL-REC
                              LS-LOGON-PARMS
                              WS-CURRENT-XY-PARM. 
023875      CANCEL PASIGN.                                                                 00050500

            MOVE WS-CURRENT-XY-PARM(1:4) TO WS-CURRENT-X.
            MOVE WS-CURRENT-XY-PARM(5:4) TO WS-CURRENT-Y.

023874*JM11/00    CALL TPSSIGN USING TPS-LOGON-REC LS-LOGON-PARMS.                         00050400
023875*******     CANCEL TPSSIGN.                                                          00050500
023887                                                                                     00050600
038600      MOVE SPACES      TO MAIL-PASS-WORD                                             00050700
038700                          MAIL-TYPE-ACCT                                             00050800
038800                          MAIL-CARRIER-CODE                                          00050900
038900                          MAIL-ADDRESOR-NAME                                         00051000
039000                          MAIL-ADDRESOR-ADDRL1                                       00051100
039100                          MAIL-ADDRESOR-ADDRL2                                       00051200
039200                          MAIL-ADDRESOR-CITYSTAT                                     00051300
039300                          MAIL-ADDRESEE-NAME                                         00051400
039400                          MAIL-ADDRESEE-ADDRL1                                       00051500
039500                          MAIL-ADDRESEE-ADDRL2                                       00051600
039600                          MAIL-ADDRESEE-CITYSTAT                                     00051700
039700                          MAIL-ADMIN-XXXXXX                                          00051800
039800******** REDEFINE 4 DUP   MAIL-MEMO-ATTACHED                                         00051900
039900******** SET TO ON HOLD   MAIL-DISPOSITION                                           00052000
040000                          MAIL-CATEGORY-CODE                                         00052100
040100                          MAIL-ROOM-TO-EXPAND                                        00052200
040200                          RECUR-ADDRESOR-NAME                                        00052300
040300                          RECUR-PASS-WORD                                            00052400
040400                          RECUR-TYPE-ACCT                                            00052500
040500                          RECUR-ADDRESOR-ADDRL1                                      00052600
040600                          RECUR-ADDRESOR-ADDRL2                                      00052700
040700                          RECUR-ADDRESOR-CITYSTAT                                    00052800
040800                          RECUR-ADDRESEE-NAME                                        00052900
040900                          RECUR-ADDRESEE-ADDRL1                                      00053000
041000                          RECUR-ADDRESEE-ADDRL2                                      00053100
041100                          RECUR-ADDRESEE-CITYSTAT                                    00053200
041200                          RECUR-PAYEE-NAME                                           00053300
041300                          RECUR-PAYEE-ADDRL1                                         00053400
041400                          RECUR-PAYEE-ADDRL2                                         00053500
041500                          RECUR-PAYEE-CITYSTAT                                       00053600
041600                          RECUR-PAYEE-ACCOUNT-NUMBER                                 00053700
041700                          RECUR-PAYEE-MEMO-FIELD                                     00053800
041800                          RECUR-INVOICE-CATEGORY                                     00053900
041900                          RECUR-CARRIER-CODE                                         00054000
042000                          RECUR-POSTAGE-CLASS                                        00054100
042100                          RECUR-CONTAINR-SIZE                                        00054200
042200******* SET TO ON HOLD    RECUR-DISPOSITION                                          00054300
042300                          RECUR-CATEGORY-CODE                                        00054400
042400                          RECUR-SEND-BILL-STUB.                                      00054500
042500      MOVE ZEROS       TO MAIL-RECEIVE-DATE                                          00054600
042600                          MAIL-RECEIVE-NUMBER                                        00054700
042700                          MAIL-ADDRESOR-ZIPCODE                                      00054800
042800                          MAIL-ADDRESEE-ZIPCODE                                      00054900
042900                          MAIL-POSTMARK-DATE                                         00055000
043000                          MAIL-POSTAGE-CLASS                                         00055100
043100                          MAIL-POSTAGE-AMOUNT                                        00055200
043200                          MAIL-CONTAINR-SIZE                                         00055300
043300                          MAIL-ADMIN-PROCESS-DATE                                    00055400
043400                          MAIL-NUMBER-ENCLOSED                                       00055500
043500                          MAIL-ENCLOSED-DESCRIPT                                     00055600
043600                          MAIL-DOCUMENT-DISPOS-ITION                                 00055700
043700                          MAIL-NUMBER-ENCLOSURES                                     00055800
043800                          MAIL-IMAGE-NUMBER                                          00055900
043900                          MAIL-TOTAL-BALANCE                                         00056000
044000                          MAIL-DUE-DATE                                              00056100
044100                          MAIL-AMOUNT-BILLED                                         00056200
044200                          MAIL-CLOSING-DATE                                          00056300
044300                          MAIL-CHECK-TRANSACTION-NO                                  00056400
044400                          MAIL-XREF-DATE                                             00056500
044500                          MAIL-XREF-N                                                00056600
044600                          MAIL-DEPOSIT-AMOUNT                                        00056700
044700                          MAIL-OPENING-BALANCE-SHARES                                00056800
044800                          MAIL-CLOSING-BALANCE-SHARES                                00056900
044900                          MAIL-CALENDAR-XREF                                         00057000
045000                          RECUR-ACCT-NO                                              00057100
045100                          RECUR-SUB-ACCT                                             00057200
045200                          RECUR-ADDRESOR-ZIPCODE                                     00057300
045300                          RECUR-ADDRESEE-ZIPCODE                                     00057400
045400                          RECUR-PAYEE-ZIPCODE                                        00057500
045500                          RECUR-PAYEE-RESIDENT-CODE                                  00057600
045600                          RECUR-PAYEE-DISPOSITION                                    00057700
045700                          RECUR-INVOICE-CLASSIFY                                     00057800
045900                          RECUR-PRE-APPROVE-LOLIMIT                                  00057900
045900                          RECUR-PRE-APPROVE-HILIMIT                                  00058000
046000                          RECUR-CYCLE-AMOUNT                                         00058100
046100                          RECUR-CYCLE-DATE                                           00058200
046200                          RECUR-CYCLE-EVENT                                          00058300
046300                          RECUR-POSTAGE-AMOUNT                                       00058400
046400                          RECUR-NUMBER-ENCLOSURES                                    00058500
046500                          RECUR-CHART-ACCT-01                                        00058600
046600                          RECUR-CHART-ACCT-02                                        00058700
046700                          RECUR-CHART-ACCT-03                                        00058800
046800                          RECUR-CHART-ACCT-04                                        00058900
046900                          RECUR-CHART-ACCT-05                                        00059000
047000                          RECUR-CHART-ACCT-06                                        00059100
047100                          RECUR-CHART-ACCT-07                                        00059200
047200                          RECUR-CHART-ACCT-08.                                       00059300
047300                                                                                     00059400
032900      MOVE CLNT-PROFILE-ACCT-NO  TO MAIL-ACCT-NO                                     00059500
047500                                    RECUR-ACCT-NO.                                   00059600
047600      MOVE CLNT-PROFILE-SUB-ACCT TO MAIL-SUB-ACCT                                    00059700
047700                                    RECUR-SUB-ACCT.                                  00059800
047900                                                                                     00059900
050900***** MOVE 'n'                   TO MAIL-ALLOW-DUPLICATES.                           00060000
050900      MOVE 'y'                   TO MAIL-ALLOW-DUPLICATES.                           00060100
      *11/05/99                                                                            00060101
            IF PROCEDURE-IN-PROGRESS                                                       00060110
047900         MOVE '99'               TO MAIL-DISPOSITION                                 00060200
047900                                    RECUR-DISPOSITION                                00060300
047800         MOVE 'TPS3059   '       TO MAIL-ADMIN-XXXXXX                                00060301
              ELSE                                                                         00060303
047900         MOVE '08'               TO MAIL-DISPOSITION                                 00060310
047900                                    RECUR-DISPOSITION                                00060320
047800         MOVE 'XX'               TO MAIL-ON-HOLD-ID-VALUE                            00060400
007600*01/21/02MOVE RECUR-EXPIRE-DATE  TO MAIL-ON-HOLD-EXPIRE-DATE                                                      
061100         move todays-date-plus-180 to mail-on-hold-expire-date                                                    
             END-IF.                                                                       00060501
048100      MOVE '19'                  TO MAIL-CATEGORY-CODE                               00060600
048200                                    RECUR-CATEGORY-CODE                              00060700
048300                                    RECUR-CHART-ACCT-01(1:2).                        00060800
048400      MOVE '99'                  TO MAIL-CONTAINR-SIZE                               00060900
048500                                    MAIL-POSTAGE-CLASS                               00061000
048600                                    MAIL-CARRIER-CODE.                               00061100
048710      MOVE LS-ACCESS-LEVEL-NAME  TO MAIL-ADDRESOR-NAME                               00061200
048800                                    RECUR-ADDRESOR-NAME.                             00061300
048802      MOVE LS-ACCESS-LEVEL-TITLE TO MAIL-ADDRESOR-ADDRL1                             00061400
048810                                    RECUR-ADDRESOR-ADDRL1.                           00061500
048900                                                                                     00061600
049200      MOVE SPACES                    TO BG-FLOAT-PARMS.                              00061700
049300      MOVE CLNT-PROFILE-FIRST-NAME   TO BG-FLOAT-1.                                  00061800
049400      IF CLNT-PROFILE-MDDL-INIT  = SPACES                                            00061900
049500         MOVE '2'                    TO BG-FLOAT-COUNT                               00062000
049600         MOVE CLNT-PROFILE-LAST-NAME TO BG-FLOAT-2                                   00062100
049700        ELSE                                                                         00062200
049800         MOVE '3'                    TO BG-FLOAT-COUNT                               00062300
049900         MOVE CLNT-PROFILE-MDDL-INIT TO BG-FLOAT-2(1:1)                              00062400
050000         MOVE '.'                    TO BG-FLOAT-2 (2:1)                             00062500
050100         MOVE CLNT-PROFILE-LAST-NAME TO BG-FLOAT-3                                   00062600
050200       END-IF.                                                                       00062700
050300      CALL FLOATBIG USING BG-FLOAT-PARMS.                                            00062800
050300      CANCEL FLOATBIG.                                                               00062900
050600                                                                                     00063000
050700      MOVE BG-FLOAT-1(1:36)      TO MAIL-ADDRESEE-NAME                               00063100
050800                                    RECUR-ADDRESEE-NAME.                             00063200
052100                                                                                     00063300
068200      MOVE ZEROS                 TO MAIL-RECEIVE-DATE                                00063400
068300                                    MAIL-RECEIVE-NUMBER.                             00063500
052100*11/05/99                                                                            00063600
            IF PROCEDURE-IN-PROGRESS                                                       00063610
               GO TO PROCEDURE-MEMO-RETURN                                                 00063620
             END-IF.                                                                       00063630
                                                                                           00063640
052200      CALL TPS1010G USING TPS-LOGON-REC                                              00063700
052300                          TPS-PROFL-REC                                              00063800
033100                          TPS-MAIL-REC                                               00063900
052510                          MEMO-RECORD
                                WS-CURRENT-XY-PARM.
052600      CANCEL TPS1010G.                                                               00064100

            MOVE WS-CURRENT-XY-PARM(1:4) TO WS-CURRENT-X.
            MOVE WS-CURRENT-XY-PARM(5:4) TO WS-CURRENT-Y.

       WRITE-ADMIN-MEMO-ONHOLD-EXIT. EXIT.                                                 00064300
052700                                                                                     00064400
                                                                                           00064500
031200*11/05/99                                                                            00064510
       PROCEDURE-MEMO.                                                                     00064600
268500      MOVE MAIL-KEY            TO PROC-KEY.                                          00064700
268500      MOVE MAIL-KEY            TO SAVE-MAIL-KEY.                                     00064710
004000      MOVE TPS-MAIL-REC        TO SAV-MAIL-REC.                                      00064720
            MOVE '1'                 TO PROCEDURE-FLAG.                                    00064800
            GO TO ENTER-FROM-PROCEDURE.                                                    00064810
                                                                                           00064811
                                                                                           00064816
                                                                                           00064817
       PROCEDURE-MEMO-RETURN.                                                              00064820
            MOVE '0'                 TO PROCEDURE-FLAG.                                    00064821
052200      CALL TPS1010G USING TPS-LOGON-REC                                              00064830
052300                          TPS-PROFL-REC                                              00064840
033100                          TPS-MAIL-REC                                               00064850
052510                          PROC-RECORD
                                WS-CURRENT-XY-PARM.
052600      CANCEL TPS1010G.                                                               00064870

            MOVE WS-CURRENT-XY-PARM(1:4) TO WS-CURRENT-X.
            MOVE WS-CURRENT-XY-PARM(5:4) TO WS-CURRENT-Y.
004000      MOVE SAV-MAIL-REC        TO TPS-MAIL-REC.                                      00064871
268500      MOVE SAVE-MAIL-KEY       TO MAIL-KEY.                                          00064880
                                                                                           00064900
       PROCEDURE-MEMO-EXIT. EXIT.                                                          00064910
                                                                                           00065000
                                                                                           00065010
      *--------------------------------------------------------------                      00065100
046400 FIGURE-LAST-PAYMENT.                                                                00065200
          IF RECUR-CYCLE-EVENT(2:1) = '0'                                                  00065300
             MOVE 00000100                TO LAST-PAYMENT-FACTOR                           00065400
            ELSE                                                                           00065500
          IF RECUR-CYCLE-EVENT(2:1) = '1'                                                  00065600
             MOVE 00000200                TO LAST-PAYMENT-FACTOR                           00065700
            ELSE                                                                           00065800
          IF RECUR-CYCLE-EVENT(2:1) = '2'                                                  00065900
             MOVE 00000300                TO LAST-PAYMENT-FACTOR                           00066000
            ELSE                                                                           00066100
          IF RECUR-CYCLE-EVENT(2:1) = '3'                                                  00066200
             MOVE 00000600                TO LAST-PAYMENT-FACTOR                           00066300
            ELSE                                                                           00066400
          IF RECUR-CYCLE-EVENT(2:1) = '4'                                                  00066500
             MOVE 00001200                TO LAST-PAYMENT-FACTOR                           00066600
            ELSE                                                                           00066700
          IF RECUR-CYCLE-EVENT(2:1) = '5'                                                  00066800
             MOVE 00002400                TO LAST-PAYMENT-FACTOR                           00066900
            ELSE                                                                           00067000
      *01/24/01                                                                            00067000
          IF RECUR-CYCLE-EVENT(2:1) = '6'                                                  00066800
             MOVE 00000007                TO LAST-PAYMENT-FACTOR                           00066900
            ELSE                                                                           00067000
          IF RECUR-CYCLE-EVENT(2:1) = '7'                                                  00066800
             MOVE 00000014                TO LAST-PAYMENT-FACTOR                           00066900
            ELSE                                                                           00067000
046400       GO TO FIGURE-LAST-PAYMENT-EXIT                                                00067100
           END-IF.                                                                         00067700
                                                                                           00067800
                                                                                           00067900
          MOVE RECUR-CYCLE-DATE       TO LAST-PAYMENT-DATE.                                00068000
          IF LAST-PAYMENT-DATE(3:2) < 94                                                   00068100
             MOVE '20'                TO LAST-PAYMENT-DATE(1:2)                            00068200
            ELSE                                                                           00068300
             MOVE '19'                TO LAST-PAYMENT-DATE(1:2)                            00068400
           END-IF.                                                                         00068500
          MOVE LAST-PAYMENT-DATE      TO WORK-PAYMENT-DATE.                                00068600
                                                                                           00068700
      *                                                                                    00068800
046400 FIGURE-LAST-PAYMENT-LOOP.                                                           00068900
          IF LAST-PAYMENT-FACTOR < 1300                                                    00069000
             ADD LAST-PAYMENT-FACTOR  TO WORK-PAYMENT-DATE                                 00069100
             IF WORK-PAYMENT-DATE(5:2) > 12                                                00069200
                ADD 10000             TO WORK-PAYMENT-DATE                                 00069300
                SUBTRACT 1200       FROM WORK-PAYMENT-DATE                                 00069400
              END-IF                                                                       00069500
             IF WORK-PAYMENT-DATE > RECUR-EXPIRE-DATE                                      00069600
046400          GO TO FIGURE-LAST-PAYMENT-EXIT                                             00069700
              END-IF                                                                       00069800
             MOVE WORK-PAYMENT-DATE   TO LAST-PAYMENT-DATE                                 00069900
046400       GO TO FIGURE-LAST-PAYMENT-LOOP                                                00070000
           END-IF.                                                                         00070100
                                                                                           00070200
          IF LAST-PAYMENT-FACTOR < 2500                                                    00070300
             MOVE LAST-PAYMENT-FACTOR TO WORK-PAYMENT-FACTOR                               00070400
             ADD 1200                 TO WORK-PAYMENT-DATE                                 00070500
             SUBTRACT 1200          FROM WORK-PAYMENT-FACTOR                               00070600
             IF WORK-PAYMENT-DATE(5:2) > 12                                                00070700
                ADD 10000             TO WORK-PAYMENT-DATE                                 00070800
                SUBTRACT 1200       FROM WORK-PAYMENT-DATE                                 00070900
              END-IF                                                                       00071000
             ADD WORK-PAYMENT-FACTOR  TO WORK-PAYMENT-DATE                                 00071100
             IF WORK-PAYMENT-DATE(5:2) > 12                                                00071200
                ADD 10000             TO WORK-PAYMENT-DATE                                 00071300
                SUBTRACT 1200       FROM WORK-PAYMENT-DATE                                 00071400
              END-IF                                                                       00071500
             IF WORK-PAYMENT-DATE > RECUR-EXPIRE-DATE                                      00071600
046400          GO TO FIGURE-LAST-PAYMENT-EXIT                                             00071700
              END-IF                                                                       00071800
             MOVE WORK-PAYMENT-DATE   TO LAST-PAYMENT-DATE                                 00071900
046400       GO TO FIGURE-LAST-PAYMENT-LOOP                                                00072000
           END-IF.                                                                         00072100
                                                                                           00072200
046400 FIGURE-LAST-PAYMENT-EXIT. EXIT.                                                     00072300
      *--------------------------------------------------------------                      00072400
                                                                                           00072500
016000                                                                                     00072600
057500                                                                                     00072700
057500                                                                                     00072800
057500                                                                                     00072900
057500                                                                                     00073000
057600                                                                                     00073100
057700 TPS3059-COMMON-EXIT.                                                                00073200
057800    PERFORM CLOSE-THE-FILES THRU                                                     00073300
057900            CLOSE-THE-FILES-EXIT.


           IF PROCESS-RPTS-DISPLAY-FLAG = 1
               invoke PROCESS-RPTS::Hide
               MOVE 0 TO PROCESS-RPTS-DISPLAY-FLAG
           END-IF.
                                                                                          

           INITIALIZE CURRENT-XY-PARAMETERS.
           MOVE WS-CURRENT-X TO CURRENT-XY-PARAMETERS(1:4).
           MOVE WS-CURRENT-Y TO CURRENT-XY-PARAMETERS(5:4).

058000       GOBACK GIVING CURRENT-XY-PARAMETERS.                                                                       
058100                                                                                     00073600
058200                                                                                     00073700
058300                                                                                     00073800
228600                                                                                     00073900
228700                                                                                     00074000
228800                                                                                     00074100
228900 FILE-ERROR.                                                                         00074200
229000     CALL TPSIOERR USING FILE-REQUEST
                               WS-CURRENT-XY-PARM.
229100     CANCEL TPSIOERR.
           
            MOVE WS-CURRENT-XY-PARM(1:4) TO WS-CURRENT-X.
            MOVE WS-CURRENT-XY-PARM(5:4) TO WS-CURRENT-Y.

            INITIALIZE CURRENT-XY-PARAMETERS.
            MOVE WS-CURRENT-X TO CURRENT-XY-PARAMETERS(1:4).
            MOVE WS-CURRENT-Y TO CURRENT-XY-PARAMETERS(5:4).

229200 FILE-ERROR-EXIT. EXIT.                                                              00074500
229300                                                                                     00074600
229400                                                                                     00074700
229500 OPEN-THE-FILES.                                                                     00074800
016900    MOVE F-PRIME    TO FILE-KEY.                                                     00074900
017000    MOVE F-OPEN-I-O   TO FILE-ACTION.                                                00075000
020200    CALL TPSIOREC USING FILE-REQUEST TPS-MAIL-REC.                                   00075100
233800    IF NOT A-SUCCESSFUL-OPERATION                                                    00075200
017300       MOVE 'RECV  ' TO FILE-NAME                                                    00075300
017400       MOVE 'TPS3059-OPN ' TO FILE-TEXT                                              00075400
017500       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                       00075500
057700       GO TO TPS3059-COMMON-EXIT                                                     00075600
           END-IF.                                                                         00075700
016900    MOVE F-PRIME    TO FILE-KEY.                                                     00075800
017000    MOVE F-OPEN-I-O   TO FILE-ACTION.                                                00075900
020200    CALL TPSIORCR USING FILE-REQUEST RECUR-ROOT-SECTION.                             00076000
233800    IF NOT A-SUCCESSFUL-OPERATION                                                    00076100
017300       MOVE 'RECUR ' TO FILE-NAME                                                    00076200
017400       MOVE 'TPS3059-OPN ' TO FILE-TEXT                                              00076300
017500       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                       00076400
057700       GO TO TPS3059-COMMON-EXIT                                                     00076500
           END-IF.                                                                         00076600
016900    MOVE F-PRIME    TO FILE-KEY.                                                     00076700
017000    MOVE F-OPEN-I-O   TO FILE-ACTION.                                                00076800
020200    CALL TPSIO004 USING FILE-REQUEST TPS-PROFL-REC.                                  00076900
233800    IF NOT A-SUCCESSFUL-OPERATION                                                    00077000
017300       MOVE 'PROFL ' TO FILE-NAME                                                    00077100
017400       MOVE 'TPS3059-OPN ' TO FILE-TEXT                                              00077200
017500       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                       00077300
057700       GO TO TPS3059-COMMON-EXIT                                                     00077400
           END-IF.                                                                         00077500
019400 OPEN-THE-FILES-EXIT. EXIT.                                                          00077600
019500                                                                                     00077700
233100                                                                                     00077800
233200                                                                                     00077900
233300 CLOSE-THE-FILES.                                                                    00078000
020000    MOVE F-PRIME TO FILE-KEY.                                                        00078100
020100    MOVE F-CLOSE TO FILE-ACTION.                                                     00078200
020200    CALL TPSIOREC USING FILE-REQUEST TPS-MAIL-REC.                             0002  00078300
020300    IF NOT A-SUCCESSFUL-OPERATION                                                    00078400
020400       MOVE 'RECV  ' TO FILE-NAME                                                    00078500
020500       MOVE 'TPS3059-CLO ' TO FILE-TEXT                                              00078600
020600       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                       00078700
020700     END-IF.                                                                         00078800
020000    MOVE F-PRIME TO FILE-KEY.                                                        00078900
020100    MOVE F-CLOSE TO FILE-ACTION.                                                     00079000
020200    CALL TPSIORCR USING FILE-REQUEST RECUR-ROOT-SECTION.                       0002  00079100
020300    IF NOT A-SUCCESSFUL-OPERATION                                                    00079200
020400       MOVE 'RECUR ' TO FILE-NAME                                                    00079300
020500       MOVE 'TPS3059-CLO ' TO FILE-TEXT                                              00079400
020600       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                       00079500
020700     END-IF.                                                                         00079600
020200    CANCEL TPSIOREC.                                                                 00079700
020200    CANCEL TPSIORCR.                                                                 00079800
020900 CLOSE-THE-FILES-EXIT. EXIT.                                                         00079900
021000                                                                                     00080000
