       IDENTIFICATION DIVISION.
       PROGRAM-ID. TPS2012.
       AUTHOR. Alex Castro.
      *****************************************************************
      *                 DISPLAY DEPOSIT INFORMATION                   * 
      *****************************************************************
      *                     MAINTENANCE LOG                           *
      ***************************************************************** 

       ENVIRONMENT DIVISION.                                                               
       CONFIGURATION SECTION.                                                              
       SOURCE-COMPUTER. IBM-PS2.                                                           
       OBJECT-COMPUTER. IBM-PS2. 
       
       FILE-CONTROL.
       
           SELECT XCL-FILE ASSIGN TO XCL-FILE-ASSIGNMENT
                  ORGANIZATION IS LINE SEQUENTIAL
                  FILE STATUS IS TPS-FILE-STATUS.       
       
       DATA DIVISION.
       FILE SECTION.
       
       FD  XCL-FILE
           LABEL RECORDS ARE OMITTED
           RECORD CONTAINS 283 CHARACTERS.       
       01  XCL-RECORD.
       
           10 XCL-POST-DATE-M        PIC 9(02).
           10 XCL-BACK-SLASH-1       PIC X(01).
           10 XCL-POST-DATE-D        PIC 9(02).
           10 XCL-BACK-SLASH-2       PIC X(01). 
           10 XCL-POST-DATE-Y        PIC 9(02).
           10 XCL-COMMA-1            PIC X(01).       
           10 XCL-AMOUNT             PIC 9(12).99.
           10 XCL-COMMA-2            PIC X(01). 
           10 XCL-PAYEE-MEMO         PIC X(36).
           10 XCL-COMMA-3            PIC X(01). 
           10 XCL-LOGON              PIC X(07).
           10 XCL-COMMA-4            PIC X(01). 
           10 XCL-PROCESSED-DATE-M   PIC 9(02).
           10 XCL-BACK-SLASH-3       PIC X(01).
           10 XCL-PROCESSED-DATE-D   PIC 9(02).
           10 XCL-BACK-SLASH-4       PIC X(01). 
           10 XCL-PROCESSED-DATE-Y   PIC 9(02).
           10 XCL-COMMA-5            PIC X(01).  
           
       WORKING-STORAGE SECTION.

***************** WINFORMS SCREEN DEFINITION **********

       01 TPS2012 type TPS000.TPS2012Form.
       01 TPS3000 type TPS000.TPS3000Form.
       01 TPS2012A type TPS000.TPS2012AForm.
       01 TPS2012B type TPS000.TPS2012BForm.

       01 TPS2012-FROM-DATE PIC 9(06).
       01 TPS2012-TO-DATE PIC 9(06).

       01 TPS2012A-LINE-NO PIC 9(02) OCCURS 10 TIMES.
       01 TPS2012A-BANK-DATE PIC 9(06) OCCURS 10 TIMES.
       01 TPS2012A-AMOUNT PIC S9(10)V9(02) OCCURS 10 TIMES.
       01 TPS2012A-PAYEE PIC X(36) OCCURS 10 TIMES.
       01 TPS2012A-LOGON PIC X(07) OCCURS 10 TIMES.
       01 TPS2012A-PROCESS-DATE PIC 9(06) OCCURS 10 TIMES.
       01 TPS2012A-SELECT-LINE PIC 9(02).
       01 TPS2012A-IDX PIC 9(02).
       01 TPS2012A-DISPLAY-FLAG PIC 9(01) VALUE 0.

       01 TPS3000-DISPLAY-FLAG PIC 9(01) VALUE 0.

       01 THE-IDX-2 PIC 9(02).
       01 CLOSE-ALL-FORMS-FLAG PIC 9(01) VALUE 0.
       01 SCREEN-NAME PIC x(10).

       01 WS-CURRENT-X                            PIC 9(04).
       01 WS-CURRENT-Y                            PIC 9(04).
       01 WS-CURRENT-XY-PARM.
          05 WS-X-PARM                            PIC 9(04).
          05 WS-Y-PARM                            PIC 9(04).


**********************************************************

       01 XCL-FILE-ASSIGNMENT.
          05 XCL-DRIVE-LETTER                  PIC  X(01) VALUE
            'C'.
          05 FILLER                            PIC  X(12) VALUE
            ':\TPS\EXCEL\'.
          05 XCL-FILE-NAME                     PIC  X(10).
          05 FILLER                            PIC  X(07) VALUE
            'DEPOSIT'.
          05 FILLER                            PIC  X(04) VALUE
            '.CSV'.
       
       01 PRT-EXCEL-HEADER.
          05 FILLER                            PIC X(14) VALUE 
             'BANK POST DATE'.
          05 PRT-EXCEL-COMMA-1                 PIC X(01).
          05 FILLER                            PIC X(06) VALUE
             'AMOUNT'.
          05 PRT-EXCEL-COMMA-2                 PIC X(01).
          05 FILLER                            PIC X(10) VALUE
             'PAYEE/MEMO'.
          05 PRT-EXCEL-COMMA-3                 PIC X(01).
          05 FILLER                            PIC X(12) VALUE
             'PROCESSED BY'.
          05 PRT-EXCEL-COMMA-4                 PIC X(01).
          05 FILLER                            PIC X(14) VALUE
             'PROCESSED DATE'.
             
       01 PRT-EXCEL-HEADER-SPACE.     
          05 FILLER                            PIC X(80) VALUE SPACE.
          
       01 PRT-EXCEL-TOT-HEADER.
          05 FILLER                            PIC X(12) VALUE
             'TOTAL AMOUNT'.
          05 PRT-EXCEL-TOT-COMMA               PIC X(01).
          05 PRT-EXCEL-TOT-AMOUNT              PIC 9(12).99.
       
       01 WHAT-DRIVE-ASSIGNMENT       PIC  X(01) VALUE SPACES.                                                          
       01 WHAT-DRIVE-STATUS           PIC  X(02).  
             
       01 WS-XCL-TOT-AMOUNT                  PIC 9(12)V99.
       01 WS-TODAYS-DATE-YMD                 PIC 9(06).
       01 WS-TODAYS-DATE-CYMD                PIC 9(08).
       01 TODAYS-DATE-PLUS-180               PIC 9(08).
       01 WS-TODAYS-DATE-MDY                 PIC 9(06). 
       01 WS-TODAYS-DATE-ENGLISH             PIC X(20).
       01 WS-CHECKING-AC-NO                  PIC  X(02).
       
       01 CHECK-FROM-DATE-CYMD               PIC  9(08).                                                             
       01 CHECK-TO-DATE-CYMD                 PIC  9(08).                                                             
       
       01 PANEL-TPS2012-DONE-FLAG            PIC  9(01) VALUE 0.                                                   
           88  PANEL-TPS2012-DONE                       VALUE 1. 
           
       01 THE-INDEX                          PIC 9(05).
       01 END-INDEX                          PIC 9(05).
       01 TBL-INDEX                          PIC 9(05) VALUE 1.
       01 ALT-TBL-INDEX                      PIC 9(05) VALUE 1.
       01 TMP-TBL-INDEX                      PIC 9(05) VALUE 1.
       01 WS-LINE-NUMBER                     PIC 9(02).
       01  EDIT-MASK-12                          PIC $ZZ,ZZZ,ZZZ.99.
       
       01  WS-CHECK-RECORDS.                                                               
           05  WS-HOLD-CHECKS             PIC  X(350) OCCURS 12 TIMES.              
       
       01  LAST-CHECK-FLAG           PIC  9(01) VALUE 0.                                   
                     88  LAST-CHECK-IN          VALUE 1.                                   
                                                                                           
       01  PAGE-UP-FLAG              PIC  9(01) VALUE 0.                                   
                     88  PAGE-UP-ACTIVE         VALUE 1.                                   
       01  PAGE-UP-DOWN-TABLE         PIC  X(28800).                                       
       01  FILLER REDEFINES PAGE-UP-DOWN-TABLE OCCURS 600 TIMES.                           
                10  TBL-KEY                 PIC  X(48).                                                                         
       
       
        01  WS-DATE-REQUEST.                                                               
            05  WS-DATE-PARAM          PIC  9(02).                                         
            05  WS-DATE-TENBYTES       PIC  X(20) VALUE SPACES.                            
            05  FILLER REDEFINES WS-DATE-TENBYTES.                                         
                10  WS-DATE-REFORM         PIC  X(06).                                     
                10  WS-DATE-EXTEND         PIC  X(04).                                     
                10  FILLER                 PIC  X(10).                                     
            05  FILLER REDEFINES WS-DATE-TENBYTES.                                         
                10  WS-DATE-REFORM-LEN06   PIC  X(06).                                     
                10  FILLER                 PIC  X(14).                                     
            05  FILLER REDEFINES WS-DATE-TENBYTES.                                         
                10  WS-DATE-REFORM-LEN08   PIC  X(08).                                     
                10  FILLER                 PIC  X(12).                                     
            05  FILLER REDEFINES WS-DATE-TENBYTES.                                         
                10  WS-DATE-REFORM-LEN10   PIC  X(10).                                     
                10  FILLER                 PIC  X(10).                                     
            05  FILLER REDEFINES WS-DATE-TENBYTES.                                         
                10  WS-TIME-PARM1          PIC  X(06).                                     
                10  WS-TIME-PARM2          PIC  X(06).                                     
                10  WS-TIME-EXTEND         PIC  X(08).                                     
            05  FILLER REDEFINES WS-DATE-TENBYTES.                                         
                10  WS-TIME-PARM1BY8       PIC  X(08).                                     
                10  WS-TIME-PARM2BY8       PIC  X(08).                                     
                10  WS-TIME-EXTNDBY8       PIC  X(04).  
                
       01  PROGRAM-NAMES.
           10 TPSDATES    PIC X(08) VALUE 'TPSDATES'.
           10 TPSIOERR    PIC X(08) VALUE 'TPSIOERR'.   
           
       01  GUISCREEN               PIC x(08) VALUE 'GS      '.                             
           
          COPY "TPSFILES.CPY".       
          COPY "KEYVALUE.CPY".
          COPY "PCL5VALU.CPY".
                                                                                                                                             
        
       01  TPS-CKING-REC.
           COPY TPSCKING.CPY.
           
       01  TPS-MAIL-REC.
           COPY "TPSMAIL.CPY".
           
       01  TPS-CHECK-REC.
           COPY "TPSCHECK.CPY".
           
           
       01  TPSIOCHK                      PIC X(08) VALUE 'TPSIOCHK'.
           
       01  TPS-FILE-STATUS                       PIC XX.                                   
           88  TPS-CARRIER-FILE-OK VALUE '00', '02'.    
           
       LINKAGE SECTION.
       
       01 TPS-LOGON.
          COPY "TPSLOGON.CPY".
          
       01 TPS-PROFILE.
          COPY "TPSPROFL.CPY".
          

       01 CURRENT-XY-PARAMETERS PIC 9(08).
           
       
       PROCEDURE DIVISION USING TPS-LOGON
                                TPS-PROFILE
                                CURRENT-XY-PARAMETERS.
       
       TPS2012-BEGIN.

      ************ INITIALIZE WINFORMS SCREENS **********
       
       set TPS2012 to new TPS000.TPS2012Form().
       set TPS3000 to new TPS000.TPS3000Form().
       set TPS2012A to new TPS000.TPS2012AForm().
       set TPS2012B to new TPS000.TPS2012BForm().

      ***************************************************
           MOVE CURRENT-XY-PARAMETERS(1:4) TO WS-CURRENT-X
                                              WS-X-PARM.
           MOVE CURRENT-XY-PARAMETERS(5:4) TO WS-CURRENT-Y
                                              WS-Y-PARM.

          CALL "pc_read_drive" USING WHAT-DRIVE-ASSIGNMENT
                           RETURNING WHAT-DRIVE-STATUS.
          MOVE WHAT-DRIVE-ASSIGNMENT  to XCL-DRIVE-LETTER.
       
           
            MOVE CLNT-PROFILE-ACCT-NO  TO XCL-FILE-NAME.
            MOVE XCL-FILE-ASSIGNMENT TO TPS2012::FILE-PATH.
            ACCEPT WS-TODAYS-DATE-YMD FROM DATE.                                           
                                                                                           
            MOVE 01                   TO WS-DATE-PARAM.                                    
            MOVE WS-TODAYS-DATE-YMD   TO WS-DATE-REFORM.                                   
            MOVE SPACES               TO WS-DATE-EXTEND(1:14).                             
             CALL TPSDATES USING WS-DATE-REQUEST.                                          
            MOVE WS-DATE-REFORM-LEN08 TO WS-TODAYS-DATE-CYMD.                              
                                                                                           
            MOVE 21                   TO WS-DATE-PARAM.                                    
            MOVE SPACES               TO WS-DATE-TENBYTES.                                 
            MOVE WS-TODAYS-DATE-CYMD  TO WS-DATE-REFORM-LEN08.                             
            MOVE '180'                TO WS-DATE-REFORM-LEN08(9:3).                        
             CALL TPSDATES USING WS-DATE-REQUEST.                                          
            MOVE WS-DATE-REFORM-LEN08 TO TODAYS-DATE-PLUS-180.                           
                                                                                           
            MOVE 05                   TO WS-DATE-PARAM.                                    
            MOVE WS-TODAYS-DATE-YMD   TO WS-DATE-REFORM.                                   
            MOVE SPACES               TO WS-DATE-EXTEND(1:14).                             
             CALL TPSDATES USING WS-DATE-REQUEST.                                          
            MOVE WS-DATE-REFORM-LEN06 TO WS-TODAYS-DATE-MDY.                               
                                                                                           
            MOVE 06                   TO WS-DATE-PARAM.                                    
            MOVE WS-TODAYS-DATE-YMD   TO WS-DATE-REFORM.                                   
            MOVE SPACES               TO WS-DATE-EXTEND(1:14).                             
             CALL TPSDATES USING WS-DATE-REQUEST.                                          
            MOVE WS-DATE-TENBYTES     TO WS-TODAYS-DATE-ENGLISH.                           
                                                                                           
            MOVE CLNT-PROFILE-ACCT-NO        TO CHECKING-ACCT-NO.                          
            MOVE CLNT-PROFILE-SUB-ACCT       TO CHECKING-SUB-ACCT.                           
                                                                        
            IF RECUR-CHART-ACCT-01(7:2) NOT NUMERIC                                                                       
               MOVE '01'      TO RECUR-CHART-ACCT-01(7:2)                                                                 
              ELSE                                                                                                        
            IF RECUR-CHART-ACCT-01(7:2) < '01'                                                                            
               MOVE '01'      TO RECUR-CHART-ACCT-01(7:2)
              END-IF                                                                                                      
             END-IF.                                                                                                      
                                                                                                                          
            MOVE RECUR-CHART-ACCT-01(7:2)    TO CHECKING-RECORD-NUMBER.                                                   
                                                                                                                          
            MOVE RECUR-CHART-ACCT-01(7:2)    TO WS-CHECKING-AC-NO.  
                                                                        
            
       
           PERFORM OPEN-THE-FILES THRU                                                        
                   OPEN-THE-FILES-EXIT.  
            
           PERFORM REQUEST-DATE-RANGE THRU
                    REQUEST-DATE-RANGE-EXIT.
                    
           PERFORM CREATE-EXCEL-REPORT THRU
                   CREATE-EXCEL-REPORT-EXIT.
           
           PERFORM LOAD-DEPOSIT-DETAIL-PANEL THRU
                   LOAD-DEPOSIT-DETAIL-PANEL-EXIT.
                    
       TPS2012-COMMON-EXIT.
       
           PERFORM CLOSE-THE-FILES THRU
                   CLOSE-THE-FILES-EXIT.

           INITIALIZE CURRENT-XY-PARAMETERS.
           MOVE WS-CURRENT-X TO CURRENT-XY-PARAMETERS(1:4).
           MOVE WS-CURRENT-Y TO CURRENT-XY-PARAMETERS(5:4).

           IF CLOSE-ALL-FORMS-FLAG = 0
               SET TPS2012::KEY-PRESSED TO "End Key"
               SET TPS3000::KEY-PRESSED TO "End Key"
               SET TPS2012A::KEY-PRESSED TO "End Key"
               SET TPS2012B::KEY-PRESSED TO "End Key"
               INVOKE TPS2012::Close
               INVOKE TPS3000::Close
               INVOKE TPS2012A::Close
               INVOKE TPS2012B::Close
               MOVE 1 TO CLOSE-ALL-FORMS-FLAG
           END-IF.

           GOBACK GIVING CURRENT-XY-PARAMETERS.     
        
       
       TPS2012-COMMON-EXIT-EXIT.                    
                                                                                           

       
       REQUEST-DATE-RANGE.
       
            MOVE '0'                  TO PANEL-TPS2012-DONE-FLAG.                                                     
            MOVE ZEROES   TO TPS2012-FROM-DATE.
            MOVE WS-TODAYS-DATE-MDY   TO TPS2012-TO-DATE.
            MOVE 'ENTER "FROM" DATE AND TAB | END TO GO BACK  '
                                      TO TPS2012::MENU-LINE.                                 
        
       DISPLAY-TPS2012.

           MOVE TPS2012-FROM-DATE TO TPS2012::FROM-DATE.
           MOVE TPS2012-TO-DATE TO TPS2012::TO-DATE.

           MOVE 1 TO TPS3000::SPLASH-SCREEN-FLAG.
           IF TPS3000-DISPLAY-FLAG = 0
               SET TPS3000::X-POINT TO WS-X-PARM
               SET TPS3000::Y-POINT TO WS-Y-PARM
               SET TPS3000::Width TO 1
               SET TPS3000::Height TO 1
               INVOKE TPS3000::Show
               SET TPS3000::Width TO 1205
               SET TPS3000::Height TO 793
               INVOKE TPS3000::Show
               MOVE 1 TO TPS3000-DISPLAY-FLAG
           END-IF.
           MOVE 0 TO TPS3000::SPLASH-SCREEN-FLAG.

           SET TPS2012::X-POINT TO WS-X-PARM.
           SET TPS2012::Y-POINT TO WS-Y-PARM.
           INVOKE TPS2012::ShowDialog.
           MOVE TPS2012::SCREEN-NAME TO SCREEN-NAME.
           MOVE TPS2012::Location::X TO WS-X-PARM
             WS-CURRENT-X.
           MOVE TPS2012::Location::Y TO WS-Y-PARM
             WS-CURRENT-Y.

           MOVE TPS2012::FROM-DATE TO TPS2012-FROM-DATE.
           MOVE TPS2012::TO-DATE TO TPS2012-TO-DATE.

            IF TPS2012::KEY-PRESSED = "End Key"
               INVOKE TPS3000::Hide
               MOVE 0 TO TPS3000-DISPLAY-FLAG
                GO TO TPS2012-COMMON-EXIT                                                                                
              END-IF.          

            IF PANEL-TPS2012-DONE
               INVOKE TPS3000::Hide
               MOVE 0 TO TPS3000-DISPLAY-FLAG
               GO TO REQUEST-DATE-RANGE-EXIT
             END-IF.     
                                                                                                                 
                                                                                                                          
            EVALUATE TPS2012::HOT-FIELD                                                                                     
                WHEN 1001
                    GO TO MENU1-HOT-FIELD-1001
                WHEN 1002
                    GO TO MENU1-HOT-FIELD-1002
              END-EVALUATE.                                                                                               
                                                                                                                          
            IF NOT TPS2012::KEY-PRESSED = "Enter Key"                                                          
               MOVE '     ENTER TO CONTINUE, END TO EXIT   '                                                              
                                         TO TPS2012::MENU-LINE
               GO TO DISPLAY-TPS2012                                                                             
             END-IF.
       
       
       DISPLAY-TPS2012-EXIT.
       
       MENU1-HOT-FIELD-1001.
       
       
          IF TPS2012-FROM-DATE = ZEROS OR SPACES
               MOVE 'ENTER "FROM" DATE AND TAB | END TO GO BACK '
                                      TO TPS2012::MENU-LINE
               MOVE 1                 TO TPS2012::ACTIVE-FIELD
               GO TO DISPLAY-TPS2012                                                                              
          END-IF.

            MOVE 11                   TO WS-DATE-PARAM.                                                                   
            MOVE SPACES               TO WS-DATE-TENBYTES.                                                                
            MOVE TPS2012-FROM-DATE    TO WS-DATE-REFORM-LEN06.                                             
            CALL TPSDATES USING WS-DATE-REQUEST.                                                                          
            MOVE WS-DATE-REFORM-LEN08 TO CHECK-FROM-DATE-CYMD.                                                        
            MOVE WS-TODAYS-DATE-MDY   TO TPS2012-TO-DATE.

            MOVE 'ENTER "TO" DATE AND TAB | END TO GO BACK '
                                      TO TPS2012::MENU-LINE.
            MOVE 2                    TO TPS2012::ACTIVE-FIELD.
            GO TO DISPLAY-TPS2012.
       
       
       MENU1-HOT-FIELD-1001-EXIT.
       
       MENU1-HOT-FIELD-1002.
       
            IF TPS2012-TO-DATE = ZEROS OR SPACES
               MOVE 'ENTER "TO" DATE AND TAB | END TO GO BACK'
                                      TO TPS2012::MENU-LINE
               MOVE 2                 TO TPS2012::ACTIVE-FIELD
               GO TO DISPLAY-TPS2012                                                                             
            END-IF.

            MOVE 11                   TO WS-DATE-PARAM.                                                                   
            MOVE SPACES               TO WS-DATE-TENBYTES.                                                                
            MOVE TPS2012-TO-DATE                                                                     
                                      TO WS-DATE-REFORM-LEN06.                                                            
            CALL TPSDATES USING WS-DATE-REQUEST.                                                                          
            MOVE '1'                  TO PANEL-TPS2012-DONE-FLAG.                                                      
            MOVE WS-DATE-REFORM-LEN08 TO CHECK-TO-DATE-CYMD.                                                          
                
            IF CHECK-FROM-DATE-CYMD >                                                                                 
                         CHECK-TO-DATE-CYMD                                                                           
               MOVE ZEROS             TO TPS2012-FROM-DATE                                           
                                         TPS2012-TO-DATE                                             
                                         CHECK-FROM-DATE-CYMD                                                         
                                         CHECK-TO-DATE-CYMD                                                           
               MOVE 'INVALID DATE RANGE, TRY AGAIN | END TO GO BACK '
                                      TO TPS2012::MENU-LINE
               MOVE 1                 TO TPS2012::ACTIVE-FIELD
               MOVE '0' TO PANEL-TPS2012-DONE-FLAG
               GO TO DISPLAY-TPS2012
           END-IF.

            MOVE 'ENTER TO CONTINUE | END TO GO BACK'
                                      TO TPS2012::MENU-LINE
            MOVE 001                  TO TPS2012::ACTIVE-FIELD.
            GO TO DISPLAY-TPS2012.                                                                 
       
       
       MENU1-HOT-FIELD-1002-EXIT.       
       
       
       REQUEST-DATE-RANGE-EXIT.
       
       CREATE-EXCEL-REPORT.
       
         OPEN OUTPUT XCL-FILE.
       
         
         MOVE ','         TO PRT-EXCEL-COMMA-1 
                             PRT-EXCEL-COMMA-2
                             PRT-EXCEL-COMMA-3
                             PRT-EXCEL-COMMA-4.
                             
         WRITE XCL-RECORD FROM PRT-EXCEL-HEADER.
         WRITE XCL-RECORD FROM PRT-EXCEL-HEADER-SPACE.
                                       
        INITIALIZE CHECK-KEY.
        
           PERFORM START-CHECK-BROWSE THRU                                                  
                   START-CHECK-BROWSE-EXIT.  
                   
           PERFORM READ-CHECK-FOR-EXCEL THRU
                   READ-CHECK-FOR-EXCEL-EXIT.
                   
       CREATE-EXCEL-REPORT-EXIT.              
                   
       READ-CHECK-FOR-EXCEL.
       
            PERFORM READ-NEXT-CHECK-EXCEL THRU
                    READ-NEXT-CHECK-EXCEL-EXIT.
                    
          IF END-OF-FILE-WAS-REACHED   
             PERFORM EXCEL-TOTALS THRU
                     EXCEL-TOTALS-EXIT                                                     
            GO TO READ-CHECK-FOR-EXCEL-EXIT                             
           END-IF.                                                                         
                                                                                           
          IF NOT A-SUCCESSFUL-OPERATION                                                    
             GO TO TPS2012-COMMON-EXIT                                                    
            END-IF.                                                                        
                                                                                           
          IF  CLNT-PROFILE-ACCT-NO  NOT = CHECK-ACCT-NO                                    
           OR CLNT-PROFILE-SUB-ACCT NOT = CHECK-SUB-ACCT
             PERFORM EXCEL-TOTALS THRU
                     EXCEL-TOTALS-EXIT                                                                                 
              GO TO READ-CHECK-FOR-EXCEL-EXIT                           
            END-IF.   
            
          IF CHECK-DATE < CHECK-FROM-DATE-CYMD
                GO TO READ-CHECK-FOR-EXCEL
           END-IF.
           
          IF CHECK-DATE > CHECK-TO-DATE-CYMD
                GO TO READ-CHECK-FOR-EXCEL
          END-IF.
             
          
          IF CHECK-AMOUNT = ZEROS                                                       
             GO TO READ-CHECK-FOR-EXCEL                                         
          END-IF.  
          
          PERFORM WRITE-EXCEL-REPORT THRU
                  WRITE-EXCEL-REPORT-EXIT.
        
          GO TO READ-CHECK-FOR-EXCEL.
          
       READ-CHECK-FOR-EXCEL-EXIT.
       
       READ-NEXT-CHECK-EXCEL.
       
            MOVE F-PRIME TO FILE-KEY.                                                        
            MOVE F-READ-NEXT TO FILE-ACTION.                                               
            CALL TPSIOCHK USING FILE-REQUEST TPS-CHECK-REC.                                
            IF END-OF-FILE-WAS-REACHED                                                     
               GO TO READ-NEXT-CHECK-EXIT                                                  
           END-IF.      
       
       
       READ-NEXT-CHECK-EXCEL-EXIT.
       
       
       WRITE-EXCEL-REPORT.
       
            IF CHECK-TRANSACTION-CODE = 'P' OR 'D' 
             CONTINUE
          ELSE
             GO TO WRITE-EXCEL-REPORT-EXIT
          END-IF.     
          
                                   
          MOVE CHECK-DATE        TO WS-DATE-REFORM.  
          MOVE CHECK-DATE(5:2)   TO XCL-POST-DATE-M. 
          MOVE CHECK-DATE(7:2)   TO XCL-POST-DATE-D.
          MOVE CHECK-DATE(3:2)   TO XCL-POST-DATE-Y.  
          
          MOVE CHECK-ADD-DATE(5:2) TO XCL-PROCESSED-DATE-M.
          MOVE CHECK-ADD-DATE(7:2) TO XCL-PROCESSED-DATE-D.
          MOVE CHECK-ADD-DATE(3:2) TO XCL-PROCESSED-DATE-Y.                   
                                                      
          
          MOVE '/'               TO XCL-BACK-SLASH-1
                                    XCL-BACK-SLASH-2
                                    XCL-BACK-SLASH-3
                                    XCL-BACK-SLASH-4.
                                    
          MOVE ','               TO XCL-COMMA-1
                                    XCL-COMMA-2
                                    XCL-COMMA-3
                                    XCL-COMMA-4
                                    XCL-COMMA-5.  

          
          MOVE CHECK-AMOUNT     TO XCL-AMOUNT. 
          
          COMPUTE WS-XCL-TOT-AMOUNT = WS-XCL-TOT-AMOUNT + CHECK-AMOUNT.

          
          MOVE CHECK-MANUAL-PAYEE-NAME TO XCL-PAYEE-MEMO.
          MOVE CHECK-ADD-PASSWORD      TO XCL-LOGON.
          
          
          WRITE XCL-RECORD.
       
       WRITE-EXCEL-REPORT-EXIT.
       
       EXCEL-TOTALS.
       
         MOVE WS-XCL-TOT-AMOUNT  TO PRT-EXCEL-TOT-AMOUNT.
         MOVE ','                TO PRT-EXCEL-TOT-COMMA.
         
         WRITE XCL-RECORD FROM PRT-EXCEL-HEADER-SPACE.
         WRITE XCL-RECORD FROM PRT-EXCEL-TOT-HEADER.
       
         CLOSE XCL-FILE.
         
       EXCEL-TOTALS-EXIT.
       
       
       
       
       LOAD-DEPOSIT-DETAIL-PANEL.
       
             INITIALIZE CHECK-KEY.  
                                                                                           
            PERFORM  CLEARUP-SCREEN THRU                                                   
                     CLEARUP-SCREEN-EXIT                                                   
                     VARYING THE-INDEX FROM 1 BY 1                                         
                     UNTIL THE-INDEX > 10.  
                     
          SET THE-INDEX          TO 1.                                                     
          PERFORM START-CHECK-BROWSE THRU                                                  
                  START-CHECK-BROWSE-EXIT. 
                                                                                           
          PERFORM READ-CHECK THRU                                                          
                  READ-CHECK-EXIT.                     
       
       
       LOAD-DEPOSIT-DETAIL-PANEL-EXIT.
       
       
       CLEARUP-SCREEN.
       
              MOVE SPACES           TO                                  
                           TPS2012A-PAYEE(THE-INDEX)                  
                           TPS2012A-LOGON (THE-INDEX).                 
             MOVE ZEROS            TO                                   
                           TPS2012A-LINE-NO (THE-INDEX)
                           TPS2012A-BANK-DATE(THE-INDEX)               
                           TPS2012A-AMOUNT (THE-INDEX)                 
                           TPS2012A-PROCESS-DATE (THE-INDEX).      
       
       CLEARUP-SCREEN-EXIT.
       
       START-CHECK-BROWSE.
       
          MOVE CLNT-PROFILE-ACCT-NO  TO CHECK-ACCT-NO.                                     
          MOVE CLNT-PROFILE-SUB-ACCT TO CHECK-SUB-ACCT.                                    
          MOVE F-PRIME TO FILE-KEY.                                                        
          MOVE F-START TO FILE-ACTION.                                                     
          CALL TPSIOCHK USING FILE-REQUEST TPS-CHECK-REC.                                  
          IF NO-RECORD-WAS-FOUND                                                           
             GO TO START-CHECK-BROWSE-EXIT                                                 
           END-IF.                                                                         
          IF NOT A-SUCCESSFUL-OPERATION                                                    
             MOVE 'CHK FILE' TO FILE-NAME                                                  
             MOVE 'TPS2012-STR' TO FILE-TEXT                                              
             PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                       
             GO TO TPS2012-COMMON-EXIT                                                     
           END-IF.       
       
       
       START-CHECK-BROWSE-EXIT.
        
       READ-CHECK.   
                                                                                           
          PERFORM READ-NEXT-CHECK THRU                                               
                  READ-NEXT-CHECK-EXIT. 
                                                                                           
          IF END-OF-FILE-WAS-REACHED                                                       
            MOVE 1                      TO LAST-CHECK-FLAG  
            MOVE 10           TO END-INDEX                                      
            COMPUTE TBL-INDEX = TBL-INDEX - THE-INDEX
            COMPUTE TBL-INDEX = TBL-INDEX + 11                                                                                           
            GO TO TPS2012A-SEE-LAST-PANEL                                             
           END-IF.                                                                         
                                                                                           
          IF NOT A-SUCCESSFUL-OPERATION                                                    
             GO TO TPS2012-COMMON-EXIT                                                    
            END-IF.                                                                        
                                                                                           
          IF  CLNT-PROFILE-ACCT-NO  NOT = CHECK-ACCT-NO                                    
           OR CLNT-PROFILE-SUB-ACCT NOT = CHECK-SUB-ACCT                                   
              MOVE 1                   TO LAST-CHECK-FLAG                                  
              MOVE 10           TO END-INDEX                                      
              COMPUTE TBL-INDEX = TBL-INDEX - THE-INDEX
              COMPUTE TBL-INDEX = TBL-INDEX + 11
              GO TO TPS2012A-SEE-LAST-PANEL                                           
            END-IF.                                                                        
                                                                                                        
          MOVE 0                       TO LAST-CHECK-FLAG.                                                      
                                                                                           
                                                                                                                          
              
          IF CHECK-DATE < CHECK-FROM-DATE-CYMD
                GO TO READ-CHECK
           END-IF.
           
          IF CHECK-DATE > CHECK-TO-DATE-CYMD
                GO TO READ-CHECK
          END-IF.
             
          
          IF CHECK-AMOUNT = ZEROS                                                       
             GO TO READ-CHECK                                                             
          END-IF. 
          
          GO TO KEEP-THE-DEPOSIT-TRANSACTION.
           
                                                               

       READ-CHECK-EXIT.
       
       READ-NEXT-CHECK.
       
          MOVE F-PRIME TO FILE-KEY.                                                        
          MOVE F-READ-NEXT TO FILE-ACTION.                                                 
          CALL TPSIOCHK USING FILE-REQUEST TPS-CHECK-REC.                                  
          IF END-OF-FILE-WAS-REACHED                                                       
             GO TO READ-NEXT-CHECK-EXIT                                                    
           END-IF.         
       
       
       READ-NEXT-CHECK-EXIT.
       
       KEEP-THE-DEPOSIT-TRANSACTION.
       
           IF CHECK-TRANSACTION-CODE = 'P' OR 'D' 
             CONTINUE
          ELSE
             GO TO READ-CHECK
          END-IF.
                                                                                                                     
          PERFORM SETUP-SCREEN THRU                                                 
                  SETUP-SCREEN-EXIT.                                                
          SET THE-INDEX UP BY 1.                                                           
          SET TBL-INDEX UP BY 1.                                                           
                                                                                           
           IF THE-INDEX < 11                                                               
              GO TO READ-CHECK                                                             
            END-IF.                                                                        
                                                                                           
           MOVE THE-INDEX           TO END-INDEX.                                          
           SUBTRACT 1             FROM END-INDEX.  
           
            GO TO DISPLAY-PANEL-TPS2012A.        
       
       
       KEEP-THE-DEPOSIT-TRANSACTION-EXIT.
       
       SETUP-SCREEN. 
       
                                                                                          
          MOVE CHECK-KEY    TO TBL-KEY(TBL-INDEX)                                      
          MOVE TPS-CHECK-REC  TO WS-HOLD-CHECKS (THE-INDEX). 
          COMPUTE WS-LINE-NUMBER = WS-LINE-NUMBER + 1.                                  
          MOVE WS-LINE-NUMBER      TO TPS2012A-LINE-NO(THE-INDEX). 
                                                                                           
       REFRESH-SCREEN. 
                                                                                           
                                                                                                    
          MOVE CHECK-AMOUNT        TO EDIT-MASK-12.                                       
          MOVE EDIT-MASK-12        TO TPS2012A-AMOUNT (THE-INDEX).                     
          MOVE 05                  TO WS-DATE-PARAM.                                       
          MOVE CHECK-DATE(3:6)     TO WS-DATE-REFORM.                                      
          MOVE SPACES              TO WS-DATE-EXTEND.                                      
          CALL TPSDATES USING WS-DATE-REQUEST.                                             
          MOVE WS-DATE-REFORM-LEN06                                                       
                                   TO TPS2012A-BANK-DATE(THE-INDEX).  
          MOVE CHECK-ADD-DATE(3:6) TO WS-DATE-REFORM. 
          MOVE SPACES              TO WS-DATE-EXTEND.  
          MOVE 05                  TO WS-DATE-PARAM.
          CALL TPSDATES USING WS-DATE-REQUEST. 
          MOVE WS-DATE-REFORM TO TPS2012A-PROCESS-DATE(THE-INDEX).
                        
                                                                                           
         
         MOVE CHECK-AMOUNT TO TPS2012A-AMOUNT(THE-INDEX).
         MOVE CHECK-MANUAL-PAYEE-NAME TO TPS2012A-PAYEE(THE-INDEX).
         MOVE CHECK-ADD-PASSWORD TO TPS2012A-LOGON(THE-INDEX).
                                                                                    
                                                                       
                                                                                
                                                                                           
       SETUP-SCREEN-EXIT. EXIT.  
       
 
       
       DISPLAY-PANEL-TPS2012A. 
                                                                                           
            MOVE CLNT-PROFILE-ACCT-NO    TO                                                
                                      TPS2012A::CLNT-ACCT-NO.                             
            MOVE CLNT-PROFILE-LAST-NAME  TO                                                
                                      TPS2012A::CLNT-LAST-NAME.                           
            MOVE CLNT-PROFILE-FIRST-NAME TO                                                
                                     TPS2012A::CLNT-FIRST-NAME.                           
            MOVE CLNT-PROFILE-MDDL-INIT  TO                                                
                                   TPS2012A::CLNT-MDDL-INIT.                              
            MOVE 'ENTER LINE NUMBER AND ENTER | END TO GO BACK' TO
                                   TPS2012A::MENU-LINE.

       REDISPLAY-PANEL-TPS2012A. 
                                                                                           
                                                                                           
           MOVE 0 TO TPS2012A-IDX.
           PERFORM VARYING THE-IDX-2 FROM 1 BY 1
             UNTIL THE-IDX-2 > 10
               MOVE TPS2012A-LINE-NO(THE-IDX-2) TO
                 TPS2012A::LINE-NO(TPS2012A-IDX)
               MOVE TPS2012A-BANK-DATE(THE-IDX-2) TO
                 TPS2012A::BANK-DATE(TPS2012A-IDX)
               MOVE TPS2012A-AMOUNT(THE-IDX-2) TO
                 TPS2012A::AMOUNT(TPS2012A-IDX)
               MOVE TPS2012A-PAYEE(THE-IDX-2) TO
                 TPS2012A::PAYEE(TPS2012A-IDX)
               MOVE TPS2012A-LOGON(THE-IDX-2) TO
                 TPS2012A::LOGON(TPS2012A-IDX)
               MOVE TPS2012A-PROCESS-DATE(THE-IDX-2) TO
                 TPS2012A::PROCESS-DATE(TPS2012A-IDX)
               COMPUTE TPS2012A-IDX = TPS2012A-IDX + 1
           END-PERFORM.

           SET TPS2012A::X-POINT TO WS-X-PARM.
           SET TPS2012A::Y-POINT TO WS-Y-PARM.
           INVOKE TPS2012A::ShowDialog.
           MOVE TPS2012A::Location::X TO WS-X-PARM
             WS-CURRENT-X.
           MOVE TPS2012A::Location::Y TO WS-Y-PARM
             WS-CURRENT-Y.
           MOVE TPS2012A::SCREEN-NAME TO SCREEN-NAME.

           MOVE TPS2012A::SELECT-LINE TO TPS2012A-SELECT-LINE.

              
           IF TPS2012A::KEY-PRESSED = "End Key"
              GO TO TPS2012-COMMON-EXIT.
           
           IF TPS2012A::KEY-PRESSED = "Page Down Key"
              GO TO NEXT-PANEL.
              
           IF TPS2012A::KEY-PRESSED = "Page Up Key"
              GO TO CHECK-TABLE-IDX.
              
           MOVE 0               TO PAGE-UP-FLAG.   
           
           IF TPS2012A-SELECT-LINE NOT = 0                                             
               GO TO SETUP-ACKNOWLEDGE-THE-CHECK                                           
             END-IF. 
             
           GO TO REDISPLAY-PANEL-TPS2012A.                                                                                                                            
       
       NEXT-PANEL.
       
           IF LAST-CHECK-IN
              MOVE 'Cannot page down | no more information to display'
                    TO TPS2012A::MENU-LINE           
              GO TO REDISPLAY-PANEL-TPS2012A.

            PERFORM  CLEARUP-SCREEN THRU                                
                     CLEARUP-SCREEN-EXIT                                
                     VARYING THE-INDEX FROM 1 BY 1                      
                     UNTIL THE-INDEX > 10.                              
            PERFORM  CLEAR-CHECK-RECS THRU                              
                     CLEAR-CHECK-RECS-EXIT                              
                     VARYING THE-INDEX FROM 1 BY 1                      
                     UNTIL THE-INDEX > 10.                              
            SET THE-INDEX          TO 1.     
            MOVE 0                 TO WS-LINE-NUMBER.                   
          GO TO READ-CHECK.                                             
       
       
       NEXT-PANEL-EXIT.
       
       CLEAR-CHECK-RECS.
       
            MOVE SPACES         TO WS-HOLD-CHECKS (THE-INDEX).    
            
       CLEAR-CHECK-RECS-EXIT.      
       
       
       CHECK-TABLE-IDX.
       
           IF PAGE-UP-ACTIVE
              MOVE  TBL-INDEX      TO ALT-TBL-INDEX                     
              SUBTRACT  10       FROM ALT-TBL-INDEX           
              GO TO SEE-ALT-TBL-INDEX.
              
       CHECK-TABLE-IDX-EXIT. 
       
       CANT-PAGE-UP.  
       
           IF TBL-INDEX <= 11 
              MOVE 'Cannot page up | no more information to display'
                    TO TPS2012A::MENU-LINE
              GO TO REDISPLAY-PANEL-TPS2012A.
                                                                        
            MOVE  0              TO LAST-CHECK-FLAG.
            MOVE  1              TO PAGE-UP-FLAG.                       
            MOVE  TBL-INDEX      TO ALT-TBL-INDEX.                      
            SUBTRACT  10       FROM ALT-TBL-INDEX.                      
                                                                        
            IF NOT LAST-CHECK-IN                                        
                 GO TO SEEIF-PREV-PANEL.                                
            IF  ALT-TBL-INDEX NOT < END-INDEX                           
                    SUBTRACT END-INDEX FROM ALT-TBL-INDEX               
                    MOVE  ALT-TBL-INDEX   TO TMP-TBL-INDEX              
                    GO TO PREPAGE-UP-LOOP.                              
                 GO TO SETUP-PAGEUP-ERROR.                              
       
       CANT-PAGE-UP-EXIT.      
       
       SEE-ALT-TBL-INDEX.
       
          IF ALT-TBL-INDEX < 11
             GO TO CANT-PAGE-UP.
             
          MOVE  0              TO LAST-CHECK-FLAG
          SUBTRACT 10 FROM ALT-TBL-INDEX.
          MOVE ALT-TBL-INDEX TO TMP-TBL-INDEX.
          GO TO PREPAGE-UP-LOOP.
          
       SEE-ALT-TBL-INDEX-EXIT.  
       
       PREPAGE-UP-LOOP.
       
          MOVE 0 TO WS-LINE-NUMBER.
          MOVE 1 TO THE-INDEX.
          
       PREPAGE-UP-LOOP-EXIT.
       
       PAGE-UP-LOOP.
       
          MOVE  TBL-KEY (TMP-TBL-INDEX)  TO CHECK-KEY.
          PERFORM READ-CHECK-FILE THRU
                  READ-CHECK-FILE-EXIT.
                
          PERFORM SETUP-SCREEN THRU
                  SETUP-SCREEN-EXIT.
                  SET THE-INDEX UP BY 1.
                  SET TMP-TBL-INDEX UP BY 1.
                  COMPUTE TBL-INDEX = TBL-INDEX - 1.
          IF THE-INDEX < 11
             GO TO PAGE-UP-LOOP.
          MOVE THE-INDEX           TO END-INDEX.
          SUBTRACT 1             FROM END-INDEX.
          GO TO DISPLAY-PANEL-TPS2012A.
          
       PAGE-UP-LOOP-EXIT.       
       
       SEEIF-PREV-PANEL.                                                
            IF  ALT-TBL-INDEX NOT < 10                                  
                 SUBTRACT 10         FROM ALT-TBL-INDEX                 
                 MOVE  ALT-TBL-INDEX   TO TMP-TBL-INDEX                 
               GO TO PREPAGE-UP-LOOP.  
                                                                        
       SEEIF-PREV-PANEL-EXIT.     
       
       SETUP-PAGEUP-ERROR.

               MOVE 'YOU CANNOT PAGE UP.' TO                                        
                                         TPS2012A::MENU-LINE                            
               GO TO REDISPLAY-PANEL-TPS2012A.    
                                                                                           
       SETUP-PAGEUP-ERROR-EXIT.  
       
       READ-CHECK-FILE.
       
         MOVE F-PRIME TO FILE-KEY.
         MOVE F-READ  TO FILE-ACTION.
         CALL TPSIOCHK USING FILE-REQUEST TPS-CHECK-REC.
         IF NO-RECORD-WAS-FOUND
            GO TO READ-CHECK-FILE-EXIT
            
         IF NOT A-SUCCESSFUL-OPERATION
             MOVE ' CHECK  ' TO FILE-NAME                               
             MOVE 'TPS3020-CCK' TO FILE-TEXT                            
             PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                    
          END-IF.
            
       
       READ-CHECK-FILE-EXIT. 
       
       TPS2012A-SEE-LAST-PANEL.
       
         IF THE-INDEX < 2 
            MOVE 'ALL CHECKS HAVE BEEN DISPLAYED.' TO
                                       TPS2012A::MENU-LINE
             GO TO REDISPLAY-PANEL-TPS2012A.
             
         IF THE-INDEX > 10
            MOVE 005             TO TPS2012A::ACTIVE-FIELD
             GO TO DISPLAY-PANEL-TPS2012A.
             
       TPS2012A-SEE-LAST-PANEL-EXIT.
       
       PARTIAL-SCREEN-CLEAR.
       
          PERFORM CLEARUP-SCREEN THRU
                  CLEARUP-SCREEN-EXIT.
                  SET THE-INDEX UP BY 1.
                
          IF THE-INDEX < 11
             GO TO PARTIAL-SCREEN-CLEAR.
             
          MOVE 005                  TO TPS2012A::ACTIVE-FIELD.
          GO TO DISPLAY-PANEL-TPS2012A.
          
       PARTIAL-SCREEN-CLEAR-EXIT.      
       
       SETUP-ACKNOWLEDGE-THE-CHECK.  
       
            MOVE CLNT-PROFILE-ACCT-NO    TO                                                
                                      TPS2012B::CLNT-ACCOUNT.                        
            MOVE CLNT-PROFILE-LAST-NAME  TO                                                
                                      TPS2012B::CLNT-LAST-NAME.                           
            MOVE CLNT-PROFILE-FIRST-NAME TO                                                
                                     TPS2012B::CLNT-FIRST-NAME.                           
            MOVE CLNT-PROFILE-MDDL-INIT  TO                                                
                                   TPS2012B::CLNT-MIDDLE-INIT.                            
            MOVE 'END TO GO BACK' TO TPS2012B::MENU-LINE.
                                                                                                                            
            IF TPS2012A-SELECT-LINE > END-INDEX
               MOVE 'INVALID LINE NUMBER SELECTED'                                         
                                         TO TPS2012A::MENU-LINE
               GO TO REDISPLAY-PANEL-TPS2012A                                              
             END-IF.                                                                       
                                                                                           
            MOVE TPS2012A-SELECT-LINE  TO THE-INDEX.                                       
            MOVE WS-HOLD-CHECKS (THE-INDEX) TO TPS-CHECK-REC.  
            
       SETUP-ACKNOWLEDGE-THE-CHECK-EXIT.
       
       ACKNOWLEDGE-THE-CHECK.
       
          MOVE CHECK-AMOUNT           TO TPS2012B::CHECK-AMOUNT.
          MOVE CHECK-OPENING-BALANCE  TO TPS2012B::OPENING-BALANCE.
          MOVE CHECK-TRANSACTION-NO   TO TPS2012B::TRANS-NO.
          MOVE CHECK-TRANSACTION-CODE TO TPS2012B::TRANS-CODE.
          
          IF CHECK-DATE = ZEROS
             MOVE ZEROS             TO TPS2012B::BANK-POST-DATE
          ELSE
             MOVE 05                TO WS-DATE-PARAM
             MOVE CHECK-DATE(3:6)   TO WS-DATE-REFORM
             MOVE SPACES            TO WS-DATE-EXTEND(1:14)
             CALL TPSDATES USING WS-DATE-REQUEST
             MOVE WS-DATE-REFORM-LEN06 TO
                                    TPS2012B::BANK-POST-DATE
          END-IF.
          
          IF CHECK-ADD-DATE = ZEROS
             MOVE ZEROS             TO TPS2012B::PROCESS-DATE
          ELSE
             MOVE 05                TO WS-DATE-PARAM
             MOVE CHECK-ADD-DATE(3:6)   TO WS-DATE-REFORM
             MOVE SPACES            TO WS-DATE-EXTEND(1:14)
             CALL TPSDATES USING WS-DATE-REQUEST
             MOVE WS-DATE-REFORM-LEN06 TO
                                    TPS2012B::PROCESS-DATE
          END-IF.      
          
         MOVE CHECK-MANUAL-PAYEE-NAME TO TPS2012B::PAYEE-MEMO.
         MOVE CHECK-ADD-PASSWORD      TO TPS2012B::LOGON.
         
         GO TO DISPLAY-TPS2012B.
       
       ACKNOWLEDGE-THE-CHECK-EXIT.
       
       DISPLAY-TPS2012B.

           SET TPS2012B::X-POINT TO WS-X-PARM.
           SET TPS2012B::Y-POINT TO WS-Y-PARM.
           INVOKE TPS2012B::ShowDialog.
           MOVE TPS2012B::Location::X TO WS-X-PARM
             WS-CURRENT-X.
           MOVE TPS2012B::Location::Y TO WS-Y-PARM
             WS-CURRENT-Y.
           MOVE TPS2012B::SCREEN-NAME TO SCREEN-NAME.


             
          IF TPS2012B::KEY-PRESSED = "End Key"
             GO TO REDISPLAY-PANEL-TPS2012A.

          IF TPS2012B::KEY-PRESSED = "Enter Key" 
              GO TO REDISPLAY-PANEL-TPS2012A
          END-IF.

       
       DISPLAY-TPS2012B-EXIT.
       
             
        
       OPEN-THE-FILES.
       
          
       
          MOVE F-PRIME    TO FILE-KEY.
          MOVE F-OPEN-I-O  TO FILE-ACTION.                                                                               
          CALL TPSIOCHK USING FILE-REQUEST TPS-CHECK-REC.
          IF FILE-STATUS NOT = '00' AND '05'
             MOVE 'CHECK ' TO FILE-NAME
             MOVE 'TPS2012' TO FILE-TEXT
             PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
             GO TO TPS2012-COMMON-EXIT.
       
       
       OPEN-THE-FILES-EXIT.
       
       CLOSE-THE-FILES.
       
            
       
            MOVE F-PRIME TO FILE-KEY.
            MOVE F-CLOSE TO FILE-ACTION.
            CALL TPSIOCHK USING FILE-REQUEST TPS-CHECK-REC.
            IF NOT A-SUCCESSFUL-OPERATION
               MOVE 'CHECK ' TO FILE-NAME
               MOVE 'TPS2012' TO FILE-TEXT
               PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
            END-IF.
       
       
       CLOSE-THE-FILES-EXIT.
       
       FILE-ERROR.
       
           CALL TPSIOERR USING FILE-REQUEST
                               WS-CURRENT-XY-PARM.
           CANCEL TPSIOERR.

            MOVE WS-CURRENT-XY-PARM(1:4) TO WS-CURRENT-X.
            MOVE WS-CURRENT-XY-PARM(5:4) TO WS-CURRENT-Y.

            INITIALIZE CURRENT-XY-PARAMETERS.
            MOVE WS-CURRENT-X TO CURRENT-XY-PARAMETERS(1:4).
            MOVE WS-CURRENT-Y TO CURRENT-XY-PARAMETERS(5:4).

       FILE-ERROR-EXIT. EXIT.
       
