       IDENTIFICATION DIVISION.
       PROGRAM-ID. TPS2003N.
       AUTHOR. JOHN CURRAN.
      ***************************************************************
      ***************************************************************
      *    SEE IF AN AUTOMATIC PAYMENT IS DUE.                      *
      ***************************************************************
      *                   MAINTENANCE LOG                           * 
      * 05/25/17 CHANGED GUI                                    AC  *   
      * 01/24/01 VARIOUS CHANGES TO PROCESS NEW RECURRING CODES FOR *                                                   
      *    TS    WEEKLY AND BI-WEEKLY PAYMENT CYCLE (06 & 07)...... *                                                   
      * 11/02/94 NEW PROGRAM                                        *
      *    JC                                                       *
      ***************************************************************
       ENVIRONMENT DIVISION.
       CONFIGURATION SECTION.
       SOURCE-COMPUTER. IBM-PS2.
       OBJECT-COMPUTER. IBM-PS2.
       DATA DIVISION.
       FILE SECTION.
       WORKING-STORAGE SECTION.
        01  TPSDATES                   PIC  X(08) VALUE 'TPSDATES'.                                                     
037700                                                                                                                  
037800  01  WS-DATE-REQUEST.                                                                                            
037900      05  WS-DATE-PARAM          PIC  9(02).                                                                      
038000                                                                                                                  
038100      05  WS-DATE-TENBYTES       PIC  X(20) VALUE SPACES.                                                         
038200      05  FILLER REDEFINES WS-DATE-TENBYTES.                                                                      
038300          10  WS-DATE-REFORM         PIC  X(06).                                                                  
038400          10  WS-DATE-EXTEND         PIC  X(04).                                                                  
038500          10  FILLER                 PIC  X(10).                                                                  
038600      05  FILLER REDEFINES WS-DATE-TENBYTES.                                                                      
038700          10  WS-DATE-REFORM-LEN06   PIC  X(06).                                                                  
038800          10  FILLER                 PIC  X(14).                                                                  
038900      05  FILLER REDEFINES WS-DATE-TENBYTES.                                                                      
039000          10  WS-DATE-REFORM-LEN08   PIC  X(08).                                                                  
039100          10  FILLER                 PIC  X(12).                                                                  
039200      05  FILLER REDEFINES WS-DATE-TENBYTES.                                                                      
039300          10  WS-DATE-REFORM-LEN10   PIC  X(10).                                                                  
039400          10  FILLER                 PIC  X(10).                                                                  
039500      05  FILLER REDEFINES WS-DATE-TENBYTES.                                                                      
039600          10  WS-TIME-PARM1          PIC  X(06).                                                                  
039700          10  WS-TIME-PARM2          PIC  X(06).                                                                  
039800          10  WS-TIME-EXTEND         PIC  X(08).                                                                  
039900      05  FILLER REDEFINES WS-DATE-TENBYTES.                                                                      
040000          10  WS-TIME-PARM1BY8       PIC  X(08).                                                                  
040100          10  WS-TIME-PARM2BY8       PIC  X(08).                                                                  
040200          10  WS-TIME-EXTNDBY8       PIC  X(04).                                                                  
040300                                                                                                                  
                             
       01  TPS-CHECK-REC.
           COPY "TPSCHECK.CPY".
       01  TPS-MAIL-REC.
           COPY "TPSMAIL.CPY".
           COPY "TPS1010A.COB".
       01 TPS1010A-POPUP REDEFINES
             TPS1010A-4.
             10 TPS1010A-POPUP-LINE  PIC X(20) OCCURS 11 TIMES.
           COPY "TPSKEYS.CPY".
           COPY "TPSFILES.CPY".
       01  TPSIOREC                      PIC X(08) VALUE 'TPSIOREC'.
       01  PROGRAM-NAMES.
        10 SCRNIO      PIC X(08) VALUE 'SCRNIO'.
        10 TPSIOERR    PIC X(08) VALUE 'TPSIOERR'.
        10 TPSIOCHK    PIC X(08) VALUE 'TPSIOCHK'.
        10 FILLER      PIC X(08) VALUE HIGH-VALUES.
       01  PROGRAM-NAMES-R REDEFINES PROGRAM-NAMES.
        10 PROGRAM-NAME PIC X(08) OCCURS 7 TIMES.
*******************************************************
       01  THE-SYSTEM-DATE      PIC 9(08).
       01  THE-SYSTEM-DATE-R REDEFINES THE-SYSTEM-DATE.
           10  CENTURY          PIC 9(02).
           10  THE-CURRENT-DATE PIC 9(06).
*******************************************************
       01  FEBRUARY-1-1994      PIC 9(06) VALUE 940201.
*******************************************************
       01  DATE-ADJUSTMENT      PIC 9(08).
*******************************************************
       01  NEXT-DUE-DATE        PIC 9(08).
       01  MAXIMUM-ROWS         PIC S9(4) COMP VALUE 100.
       01  MAXIMUM-POPUP-ROWS   PIC S9(4) COMP VALUE 11.
       LINKAGE SECTION.
       01 TPS-LOGON.
           COPY "TPSLOGON.CPY".
       01 TPS-PROFILE.
           COPY "TPSPROFL.CPY".
       01 TPS-CLIENT-REC.
           COPY "TPSRESID.CPY".
       01 LS-MAIL-REC.
           COPY "TPSMAIL.CPY".
       01 TPS-PARAMETER.
          05  DATE-WORK            PIC 9(08).
          05  DATE-WORK-R REDEFINES DATE-WORK.
              10 DATE-WORK-C       PIC 99.
              10 DATE-WORK-Y       PIC 99.
              10 DATE-WORK-M       PIC 99.
              10 DATE-WORK-D       PIC 99.

       PROCEDURE DIVISION USING TPS-LOGON TPS-PROFILE TPS-CLIENT-REC
                                LS-MAIL-REC TPS-PARAMETER.
       TPS2003N-BEGIN.
**********ESTABLISH TODAYS DATE AND ALLOW FOR THE YEAR 2000.
          ACCEPT THE-CURRENT-DATE FROM DATE.
          MOVE 19                  TO CENTURY.                                                                          
          IF THE-CURRENT-DATE < FEBRUARY-1-1994                                                                         
             MOVE 20               TO CENTURY                                                                           
           END-IF.                                                                                                      

**********TEST IF PAYMENT DUE DATE IS STILL IN THE FUTURE.
          MOVE RECUR-CYCLE-DATE OF LS-MAIL-REC TO DATE-WORK.
          MOVE 19 TO DATE-WORK-C
          IF DATE-WORK-Y < 94                                                                                           
             MOVE 20               TO DATE-WORK-C                                                                       
           END-IF.                                                                                                      
          IF THE-SYSTEM-DATE  < DATE-WORK
             GO TO TPS2003N-COMMON-EXIT                                                                                 
           END-IF.                                                                                                      

**********PUT THE DUE DATE IN A WORK AREA AND SET UP A FIELD TO HOLD
**********THE NUMBER OF MONTHS IN THE CYCLE.
          EVALUATE RECUR-CYCLE-EVENT OF LS-MAIL-REC
           WHEN 20 MOVE  100 TO DATE-ADJUSTMENT
           WHEN 21 MOVE  200 TO DATE-ADJUSTMENT
           WHEN 22 MOVE  300 TO DATE-ADJUSTMENT
           WHEN 23 MOVE  600 TO DATE-ADJUSTMENT
           WHEN 24 MOVE 1200 TO DATE-ADJUSTMENT
           WHEN 25 MOVE 2400 TO DATE-ADJUSTMENT
      *01/24/01                                                                                                         
           WHEN 26 MOVE 0007 TO DATE-ADJUSTMENT
           WHEN 27 MOVE 0014 TO DATE-ADJUSTMENT
          END-EVALUATE.

                                                                                                                        
*******FIGURE OUT THE NEXT DUE DATE FOR THIS ITEM.
       DETERMINE-NEXT-DUE-DATE.
          IF DATE-ADJUSTMENT > 14                                                                                       
             MOVE DATE-WORK      TO NEXT-DUE-DATE                                                                       
             ADD DATE-ADJUSTMENT TO DATE-WORK                                                                           
             IF DATE-WORK-M > 12                                                                                        
                ADD 8800         TO DATE-WORK                                                                           
              END-IF                                                                                                    
             IF DATE-WORK NOT > THE-SYSTEM-DATE                                                                         
                GO TO DETERMINE-NEXT-DUE-DATE                                                                           
              END-IF                                                                                                    
            ELSE                                                                                                        
      *01/24/01                                                                                                         
             MOVE 21                    TO WS-DATE-PARAM                                                                
             MOVE DATE-WORK             TO WS-DATE-REFORM-LEN08                                                         
             IF RECUR-CYCLE-EVENT OF LS-MAIL-REC = '26'                                                                 
                MOVE '007'              TO WS-DATE-REFORM-LEN08(9:3)                                                    
               ELSE                                                                                                     
                MOVE '014'              TO WS-DATE-REFORM-LEN08(9:3)                                                    
              END-IF                                                                                                    
             CALL TPSDATES USING WS-DATE-REQUEST                                                                        
             MOVE WS-DATE-REFORM-LEN08  TO DATE-WORK                                                                    
             IF DATE-WORK NOT > THE-SYSTEM-DATE                                                                         
                GO TO DETERMINE-NEXT-DUE-DATE                                                                           
              END-IF                                                                                                    
           END-IF.                                                                                                      
      *01/24/01                                                                                                         
**********THE DUE DATE IS NOW IN "NEXT-DUE-DATE".


       TPS2003N-COMMON-EXIT.
          EXIT PROGRAM.
          GOBACK.
          STOP RUN.


