       IDENTIFICATION DIVISION.
       PROGRAM-ID. TPS2003D.
       AUTHOR. JOHN CURRAN.
      ***************************************************************
      *    SEE IF AN AUTOMATIC PAYMENT IS DUE.                      *
      ***************************************************************
      *                 MAINTENANCE LOG                             * 
      * 05/25/17 CHANGED GUI                                     AC *   
      * 10/09/08-at automatic payment routine added holiday checks  *                                                   
      *    ts    (copied from tps1010) to back off 1 day when nec.  *                                                   
      * 08/05/02-ADD NEW CATEGORY "60-HISTORICAL DOCUMENTS" BUT     *
      *    JM    DO NOT PRINT ON REPORTS.                           *
      * 09/17/01-ADD 0800-ADJUST-LAST-DUE-DATE TO SKIP WED & FRI    *
      *    JM    FOR OLD AUTO PAYMENTS. THIS IS TEMPORARY.........  *
      * 02/01/01-AT BACKUP-1-DAY ADDED CODE FOR WEEKLY & BIWEEKLY   *                                                   
      *    TS    AUTO PAYMENTS FOR FRIDAY & WEDNESDAY CHECK.......  *                                                   
      * 01/25/01-FOR AUTOMATIC PAYMENTS, AT READ-NEXT OF RECEIVE FIL*                                                   
      *    TS    IF 'VOID' SKIP RECORD...........                   *                                                   
      * 01/24/01-VARIOUS CHANGES TO PROCESS NEW RECURRING CODES FOR *                                                   
      *    TS    WEEKLY AND BI-WEEKLY PAYMENT CYCLE (06 & 07)...... *                                                   
      *         -ELIMINATED WEDNESDAY/FRIDAY TEST ........          *                                                   
      * 03/01/99 MOVED CHANGES FROM 1/28/99 TO ROUTINE ADJUST-DATE  *
      *    TS                                                       *
      * 01/28/99 BEFORE PERFORM ADJUST-DATE, ADDED CODE TO ENSURE   *
      *    TS    THAT DAY OF MONTH DOES NOT EXCEED MAX OF MONTH IN  *
      *          AREA CALLED DATE-WORK.........                     *
      * 08/17/98 GET SYSTEM-DATE FROM CALLING PROGRAM           JM  *
      * 11/02/96 TAKE OUT CHECK WORK-DATE < SYSTEM-DATE IN          *
      *    JM    DETERMINE-LAST-DUE-DATE IT SEEMS TO BE REPETITIVE. *
      * 09/26/96 IF DUE DATE IS WED OR FRI MAKE 1 DAY LESS.      JM *
      * 08/04/95 Adjustment to "DETERMINE-LAST-DUE-DATE".        JC *
      ***************************************************************
       ENVIRONMENT DIVISION.
       CONFIGURATION SECTION.
       SOURCE-COMPUTER. IBM-PS2.
       OBJECT-COMPUTER. IBM-PS2.
       DATA DIVISION.
       FILE SECTION.
       WORKING-STORAGE SECTION.

****************DIALOG SCREEN DEFINITION****************************

       01 WS-CURRENT-X                            PIC 9(04).
       01 WS-CURRENT-Y                            PIC 9(04).
       01 WS-CURRENT-XY-PARM.
          05 WS-X-PARM                            PIC 9(04).
          05 WS-Y-PARM                            PIC 9(04).

       COPY "ds-cntrl.v1".
********************************************************************

       01  TPSDATES-INTERFACE.
           COPY "TPSDATES.CPY".
037700                                                                                                                  
      *01/24/01                                                                                                         
037800  01  WS-DATE-REQUEST.                                                                                            
037900      05  WS-DATE-PARAM          PIC  9(02).                                                                      
038100      05  WS-DATE-TENBYTES       PIC  X(20) VALUE SPACES.                                                         
038200      05  FILLER REDEFINES WS-DATE-TENBYTES.                                                                      
038300          10  WS-DATE-REFORM         PIC  X(06).                                                                  
038400          10  WS-DATE-EXTEND         PIC  X(04).                                                                  
038500          10  FILLER                 PIC  X(10).                                                                  
038600      05  FILLER REDEFINES WS-DATE-TENBYTES.                                                                      
038700          10  WS-DATE-REFORM-LEN06   PIC  X(06).                                                                  
038800          10  FILLER                 PIC  X(14).                                                                  
038900      05  FILLER REDEFINES WS-DATE-TENBYTES.                                                                      
039000          10  WS-DATE-REFORM-LEN08   PIC  X(08).                                                                  
039100          10  FILLER                 PIC  X(12).                                                                  
039200      05  FILLER REDEFINES WS-DATE-TENBYTES.                                                                      
039300          10  WS-DATE-REFORM-LEN10   PIC  X(10).                                                                  
039400          10  FILLER                 PIC  X(10).                                                                  
039500      05  FILLER REDEFINES WS-DATE-TENBYTES.                                                                      
039600          10  WS-TIME-PARM1          PIC  X(06).                                                                  
039700          10  WS-TIME-PARM2          PIC  X(06).                                                                  
039800          10  WS-TIME-EXTEND         PIC  X(08).                                                                  
039900      05  FILLER REDEFINES WS-DATE-TENBYTES.                                                                      
040000          10  WS-TIME-PARM1BY8       PIC  X(08).                                                                  
040100          10  WS-TIME-PARM2BY8       PIC  X(08).                                                                  
040200          10  WS-TIME-EXTNDBY8       PIC  X(04).                                                                  
      *01/24/01                                                                                                         
                                                                                                                        
       01  TPS-CHECK-REC.
           COPY "TPSCHECK.CPY".
       01  TPS-MAIL-REC.
           COPY "TPSMAIL.CPY".
           COPY "TPS1010A.COB".
       01 TPS1010A-POPUP REDEFINES
             TPS1010A-4.
             10 TPS1010A-POPUP-LINE  PIC X(20) OCCURS 11 TIMES.
           COPY "TPSKEYS.CPY".
           COPY "TPSFILES.CPY".
       01  TPSIOREC                      PIC X(08) VALUE 'TPSIOREC'.
       01  PROGRAM-NAMES.
        10 TPSIOERR    PIC X(08) VALUE 'TPSIOERR'.
        10 TPSDATES    PIC X(08) VALUE 'TPSDATES'.
        10 FILLER      PIC X(08) VALUE HIGH-VALUES.
       01  PROGRAM-NAMES-R REDEFINES PROGRAM-NAMES.
        10 PROGRAM-NAME PIC X(08) OCCURS 7 TIMES.
*******************************************************
       01  THE-SYSTEM-DATE      PIC 9(08).
       01  THE-SYSTEM-DATE-R REDEFINES THE-SYSTEM-DATE.
           10  CENTURY          PIC 9(02).
           10  THE-CURRENT-DATE PIC 9(06).
*******************************************************
       01  FEBRUARY-1-1994      PIC 9(06) VALUE 940201.
*******************************************************
       01  DATE-ADJUSTMENT      PIC 9(08).
       01  DATE-WORK            PIC 9(08).
       01  DATE-WORK-R REDEFINES DATE-WORK.
           10 DATE-WORK-C       PIC 99.
           10 DATE-WORK-Y       PIC 99.
           10 DATE-WORK-M       PIC 99.
           10 DATE-WORK-D       PIC 99.
       01  SAVE-DATE            PIC 9(08).
       01  FILLER REDEFINES SAVE-DATE.
           10 SAVE-DATE-C       PIC 99.
           10 SAVE-DATE-Y       PIC 99.
           10 SAVE-DATE-M       PIC 99.
           10 SAVE-DATE-D       PIC 99.
*******************************************************
       01  LAST-DUE-DATE        PIC 9(08).
       01  MAXIMUM-ROWS         PIC S9(4) COMP VALUE 100.
       01  MAXIMUM-POPUP-ROWS   PIC S9(4) COMP VALUE 11.
       LINKAGE SECTION.
       01 TPS-LOGON.
           COPY "TPSLOGON.CPY".
       01 TPS-PROFILE.
           COPY "TPSPROFL.CPY".
       01 TPS-CLIENT-REC.
           COPY "TPSRESID.CPY".
       01 LS-MAIL-REC.
           COPY "TPSMAIL.CPY".
       01 TPS-PARAMETER.
          05 TPS-PARAMETER-VALUE PIC X.
       01 TPS-CURRENT-DATE       PIC X(08).


       01 CURRENT-XY-PARAMETERS PIC 9(08).

       PROCEDURE DIVISION USING TPS-LOGON
                                TPS-PROFILE
                                TPS-CLIENT-REC
                                LS-MAIL-REC
                                TPS-PARAMETER
                                TPS-CURRENT-DATE
                                CURRENT-XY-PARAMETERS.
       TPS2003D-BEGIN.

           INITIALIZE DS-CONTROL-BLOCK.
           INITIALIZE DS-INPUT-FIELDS.
           MOVE CURRENT-XY-PARAMETERS(1:4) TO WS-CURRENT-X
                                              WS-X-PARM.
           MOVE CURRENT-XY-PARAMETERS(5:4) TO WS-CURRENT-Y
                                              WS-Y-PARM.

**********DEFAULT TO "NOT DUE".
          MOVE 'N' TO TPS-PARAMETER-VALUE.

      *JM ***** ESTABLISH TODAYS DATE FROM CALLING PROGRAM *****
          MOVE TPS-CURRENT-DATE   TO THE-SYSTEM-DATE.
      *
**********ESTABLISH TODAYS DATE AND ALLOW FOR THE YEAR 2000.
      *   ACCEPT THE-CURRENT-DATE FROM DATE.
      *   MOVE 19 TO CENTURY
      *   IF THE-CURRENT-DATE < FEBRUARY-1-1994 MOVE 20 TO CENTURY.

**********TEST IF PAYMENT DUE DATE IS STILL IN THE FUTURE.
          MOVE RECUR-CYCLE-DATE OF LS-MAIL-REC TO DATE-WORK
                                                  SAVE-DATE.
          MOVE 19               TO DATE-WORK-C.                                                                         
          IF DATE-WORK-Y < 94                                                                                           
             MOVE 20            TO DATE-WORK-C                                                                          
           END-IF.                                                                                                      
          PERFORM ADJUST-DATE THRU                                                                                      
                  ADJUST-DATE-EXIT.                                                                                     
          IF THE-SYSTEM-DATE  < DATE-WORK
             GO TO TPS2003D-COMMON-EXIT                                                                                 
           END-IF.                                                                                                      

**********PUT THE DUE DATE IN A WORK AREA AND SET UP A FIELD TO HOLD
**********THE NUMBER OF MONTHS IN THE CYCLE.
          EVALUATE RECUR-CYCLE-EVENT OF LS-MAIL-REC
           WHEN 20 MOVE  100 TO DATE-ADJUSTMENT
           WHEN 21 MOVE  200 TO DATE-ADJUSTMENT
           WHEN 22 MOVE  300 TO DATE-ADJUSTMENT
           WHEN 23 MOVE  600 TO DATE-ADJUSTMENT
           WHEN 24 MOVE 1200 TO DATE-ADJUSTMENT
           WHEN 25 MOVE 2400 TO DATE-ADJUSTMENT
      *01/24/01                                                                                                         
           WHEN 26 MOVE 0007 TO DATE-ADJUSTMENT
           WHEN 27 MOVE 0014 TO DATE-ADJUSTMENT
          END-EVALUATE.
                                                                                                                        
*******FIGURE OUT THE MOST RECENT DUE DATE FOR THIS ITEM.
       DETERMINE-LAST-DUE-DATE.
          IF DATE-ADJUSTMENT > 14                                                                                       
             MOVE DATE-WORK TO LAST-DUE-DATE                                                                            
             ADD DATE-ADJUSTMENT TO DATE-WORK                                                                           
             IF DATE-WORK-M > 12                                                                                        
                ADD 8800 TO DATE-WORK                                                                                   
              END-IF                                                                                                    
             MOVE SAVE-DATE-D TO DATE-WORK-D
             IF DATE-WORK IS LESS THAN THE-SYSTEM-DATE                                                                  
                GO TO DETERMINE-LAST-DUE-DATE                                                                           
              END-IF                                                                                                    
            ELSE                                                                                                        
      *01/24/01                                                                                                         
             MOVE 21                    TO WS-DATE-PARAM                                                                
             MOVE DATE-WORK             TO WS-DATE-REFORM-LEN08                                                         
                                           LAST-DUE-DATE                                                                
             IF RECUR-CYCLE-EVENT OF LS-MAIL-REC = '26'                                                                 
                MOVE '007'              TO WS-DATE-REFORM-LEN08(9:3)                                                    
               ELSE                                                                                                     
                MOVE '014'              TO WS-DATE-REFORM-LEN08(9:3)                                                    
              END-IF                                                                                                    
             CALL TPSDATES USING WS-DATE-REQUEST                                                                        
             MOVE WS-DATE-REFORM-LEN08  TO DATE-WORK                                                                    
             IF DATE-WORK IS LESS THAN THE-SYSTEM-DATE                                                                  
                GO TO DETERMINE-LAST-DUE-DATE                                                                           
              END-IF                                                                                                    
           END-IF.                                                                                                      
      *01/24/01                                                                                                         

          PERFORM ADJUST-DATE THRU                                                                                      
                  ADJUST-DATE-EXIT.                                                                                     
**********IF DATE-WORK NOT > THE-SYSTEM-DATE
          IF DATE-WORK IS LESS THAN THE-SYSTEM-DATE
            AND                                                                                                         
             DATE-WORK-M IS EQUAL TO SAVE-DATE-M
             GO TO ACCEPT-THIS-DATE
          END-IF.
      *JM IF DATE-WORK IS LESS THAN THE-SYSTEM-DATE
      *      GO TO DETERMINE-LAST-DUE-DATE.
          IF DATE-WORK IS EQUAL TO  THE-SYSTEM-DATE
             MOVE DATE-WORK TO LAST-DUE-DATE
           END-IF.                                                                                                      

       ACCEPT-THIS-DATE.
          MOVE LAST-DUE-DATE TO DATE-WORK.
          PERFORM 0800-ADJUST-LAST-DUE-DATE THRU
                  0800-EXIT.
          MOVE DATE-WORK TO LAST-DUE-DATE.
**********THE-MOST RECENT DUE DATE IS NOW IN "LAST-DUE-DATE".
**********BROWSE THE RECEIVE FILE AND SEE IF THERE WERE ANY PAYMENTS
**********WHICH MATCH THE INFORMATION IN THE RECURRING RECORD.
**********IF THE PAYEE, ACCOUNT, AMOUNT, CYCLE DATE, AND CYCLE AMOUNT
**********MATCH, THE ITEM IS CONSIDERED "NOT DUE".
**********IF NONE OF THESE ITEMS CAN BE MATCHED WITH A RECORD ON THE
**********RECEIVE FILE, THE ITEM IS "DUE".
          MOVE LS-MAIL-REC           TO TPS-MAIL-REC.                                                                   
          MOVE CLNT-PROFILE-ACCT-NO  TO MAIL-ACCT-NO  OF TPS-MAIL-REC.
          MOVE CLNT-PROFILE-SUB-ACCT TO MAIL-SUB-ACCT OF TPS-MAIL-REC.
          MOVE LAST-DUE-DATE    TO MAIL-RECEIVE-DATE   OF TPS-MAIL-REC.                                                 
          MOVE ZEROES           TO MAIL-RECEIVE-NUMBER OF TPS-MAIL-REC.                                                 
          MOVE F-PRIME TO FILE-KEY.
          MOVE F-START TO FILE-ACTION.
          CALL TPSIOREC USING FILE-REQUEST TPS-MAIL-REC.
          IF NO-RECORD-WAS-FOUND
             MOVE 'Y' TO TPS-PARAMETER-VALUE
             GO TO TPS2003D-COMMON-EXIT
           END-IF.                                                                                                      
          IF NOT A-SUCCESSFUL-OPERATION
             MOVE ' RECEIVE' TO FILE-NAME
             MOVE 'TPS2003D-SBR' TO FILE-TEXT
             PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
             GO TO TPS2003D-COMMON-EXIT
           END-IF.                                                                                                      
                                                                                                                        
       READ-ALL-RECEIVE-NUMBERS.
          MOVE F-PRIME TO FILE-KEY.
          MOVE F-READ-NEXT TO FILE-ACTION.
          CALL TPSIOREC USING FILE-REQUEST TPS-MAIL-REC.
          IF END-OF-FILE-WAS-REACHED
             MOVE 'Y' TO TPS-PARAMETER-VALUE
             GO TO TPS2003D-COMMON-EXIT
           END-IF.                                                                                                      
          IF NOT A-SUCCESSFUL-OPERATION
             MOVE ' RECEIVE' TO FILE-NAME
             MOVE 'TPS2003D-BRN' TO FILE-TEXT
             PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
             GO TO TPS2003D-COMMON-EXIT
           END-IF.                                                                                                      
          IF CLNT-PROFILE-ACCT-NO NOT = MAIL-ACCT-NO  OF TPS-MAIL-REC
             OR
             CLNT-PROFILE-SUB-ACCT NOT = MAIL-SUB-ACCT OF TPS-MAIL-REC
             MOVE 'Y' TO TPS-PARAMETER-VALUE
             GO TO TPS2003D-COMMON-EXIT
           END-IF.                                                                                                      
      *01/25/01                                                                                                         
          IF MAIL-DISPOSITION OF TPS-MAIL-REC = '88'                                                                    
             GO TO READ-ALL-RECEIVE-NUMBERS                                                                             
           END-IF.                                                                                                      
      *JM08/02 ******* SKIP HISTROICAL DOCUMENTS ********                                  00321200
          IF MAIL-CATEGORY-CODE OF TPS-MAIL-REC = '60'                                     00321300
             GO TO READ-ALL-RECEIVE-NUMBERS                                                00321400
          END-IF.                                                                          00321500
                                                                                                                        
          IF RECUR-PAYEE-NAME           OF TPS-MAIL-REC =
             RECUR-PAYEE-NAME           OF  LS-MAIL-REC
            AND                                                                                                         
             RECUR-PAYEE-ACCOUNT-NUMBER OF TPS-MAIL-REC =
             RECUR-PAYEE-ACCOUNT-NUMBER OF  LS-MAIL-REC
            AND                                                                                                         
             RECUR-CYCLE-AMOUNT         OF TPS-MAIL-REC =
             RECUR-CYCLE-AMOUNT         OF  LS-MAIL-REC
            AND                                                                                                         
             RECUR-CYCLE-EVENT          OF TPS-MAIL-REC =
             RECUR-CYCLE-EVENT          OF  LS-MAIL-REC
            AND                                                                                                         
             MAIL-CHECK-TRANSACTION-NO OF TPS-MAIL-REC IS NUMERIC
            AND                                                                                                         
             MAIL-CHECK-TRANSACTION-NO OF TPS-MAIL-REC > 0
             GO TO TPS2003D-COMMON-EXIT
           END-IF.                                                                                                      
          GO TO READ-ALL-RECEIVE-NUMBERS.

       TPS2003D-COMMON-EXIT.

           INITIALIZE CURRENT-XY-PARAMETERS.
           MOVE WS-CURRENT-X TO CURRENT-XY-PARAMETERS(1:4).
           MOVE WS-CURRENT-Y TO CURRENT-XY-PARAMETERS(5:4).

          EXIT PROGRAM GIVING CURRENT-XY-PARAMETERS.
          GOBACK GIVING CURRENT-XY-PARAMETERS.

       FILE-ERROR.
           CALL TPSIOERR USING FILE-REQUEST
                               WS-CURRENT-XY-PARM.
           CANCEL TPSIOERR.

            MOVE WS-CURRENT-XY-PARM(1:4) TO WS-CURRENT-X.
            MOVE WS-CURRENT-XY-PARM(5:4) TO WS-CURRENT-Y.

            INITIALIZE CURRENT-XY-PARAMETERS.
            MOVE WS-CURRENT-X TO CURRENT-XY-PARAMETERS(1:4).
            MOVE WS-CURRENT-Y TO CURRENT-XY-PARAMETERS(5:4).

       FILE-ERROR-EXIT. EXIT.

      *01/28/99
       ADJUST-DATE.
          IF DATE-WORK(5:2) = '04' OR '06' OR '09' OR '11'
             IF DATE-WORK(7:2) = '31'
                MOVE '30'             TO DATE-WORK(7:2)
              END-IF
            ELSE
          IF DATE-WORK(5:2) = '02'
             IF DATE-WORK(7:2) > '28'
                MOVE '28'             TO DATE-WORK(7:2)
              END-IF
            END-IF
           END-IF.
      *01/28/99
          MOVE DATE-WORK TO TPSDATES-CYMD.

      *BACKUP-1-DAY.
      *   MOVE 23 TO TPSDATES-OPTION.
      *   CALL TPSDATES USING TPSDATES-INTERFACE.
      *01/24/01 IF ITS-THE-WEEKEND OR ITS-A-HOLIDAY OR                                                                  
      *01/24/01    ITS-WEDNESDAY   OR ITS-FRIDAY                                                                        
      *******************01/25/01    IF ITS-THE-WEEKEND OR ITS-A-HOLIDAY                                                
      *   IF ITS-THE-WEEKEND OR ITS-A-HOLIDAY OR                                                                        
      *      ITS-WEDNESDAY   OR ITS-FRIDAY                                                                              
      *      MOVE 22 TO TPSDATES-OPTION
      *      MOVE 1  TO TPSDATES-DAYS-TO-ADJUST
      *      CALL TPSDATES USING TPSDATES-INTERFACE
      *      GO TO BACKUP-1-DAY
      *   END-IF.
      *   MOVE TPSDATES-CYMD TO DATE-WORK.
      *ADJUST-DATE-EXIT. EXIT.

      *02/01/01
       BACKUP-1-DAY.
          MOVE 23 TO TPSDATES-OPTION.
          CALL TPSDATES USING TPSDATES-INTERFACE.
                 
      *   IF recur-cycle-event of ls-mail-rec = '26' or '27'
             IF ITS-THE-WEEKEND OR ITS-A-HOLIDAY                                                                        
335900*10/09/08                                                                                                           
336000          OR (ITS-MONDAY   AND ITS-MARTIN-LUTHER-KING-DAY)                              00477700                    
336100          OR (ITS-MONDAY   AND ITS-PRESIDENTS-DAY        )                              00477800                    
336200          OR (ITS-MONDAY   AND ITS-MEMORIAL-DAY          )                              00477900                    
336300          OR (ITS-MONDAY   AND ITS-INDEPENDENCE-DAY      )                              00478000                    
336400          OR (ITS-MONDAY   AND ITS-LABOR-DAY             )                              00478100                    
336500          OR (ITS-THURSDAY AND ITS-THANKSGIVING          )                                                          
335900*10/09/08                                                                                                           
                MOVE 22 TO TPSDATES-OPTION                                                                              
                MOVE 1  TO TPSDATES-DAYS-TO-ADJUST                                                                      
                CALL TPSDATES USING TPSDATES-INTERFACE                                                                  
                GO TO BACKUP-1-DAY                                                                                      
             END-IF.
      *     else
      *      IF ITS-THE-WEEKEND OR ITS-A-HOLIDAY OR
      *         ITS-WEDNESDAY   OR ITS-FRIDAY
      *         MOVE 22 TO TPSDATES-OPTION
      *         MOVE 1  TO TPSDATES-DAYS-TO-ADJUST
      *         CALL TPSDATES USING TPSDATES-INTERFACE
      *         GO TO BACKUP-1-DAY
      *      END-IF
      *    END-IF.
          MOVE TPSDATES-CYMD TO DATE-WORK.
       ADJUST-DATE-EXIT. EXIT.

      *JM09/01 ***** ADJUST LAST DUE DATE SKIPPIN WED & FRI *****
       0800-ADJUST-LAST-DUE-DATE.
          IF DATE-WORK(5:2) = '04' OR '06' OR '09' OR '11'
             IF DATE-WORK(7:2) = '31'
                MOVE '30'             TO DATE-WORK(7:2)
              END-IF
            ELSE
          IF DATE-WORK(5:2) = '02'
             IF DATE-WORK(7:2) > '28'
                MOVE '28'             TO DATE-WORK(7:2)
              END-IF
            END-IF
           END-IF.

          MOVE DATE-WORK TO TPSDATES-CYMD.

       BACKUP-LAST-DAY.
          MOVE 23 TO TPSDATES-OPTION.
          CALL TPSDATES USING TPSDATES-INTERFACE.

          IF ITS-THE-WEEKEND OR ITS-A-HOLIDAY OR
             ITS-WEDNESDAY   OR ITS-FRIDAY
             MOVE 22 TO TPSDATES-OPTION
             MOVE 1  TO TPSDATES-DAYS-TO-ADJUST
             CALL TPSDATES USING TPSDATES-INTERFACE
             GO TO BACKUP-LAST-DAY
          END-IF.
          MOVE TPSDATES-CYMD TO DATE-WORK.
       0800-EXIT.  EXIT.


