000100 IDENTIFICATION DIVISION.
000200 PROGRAM-ID. TPS122.
000300*************************************************************
000400*     CLIENT CLIPBOARD MAINTENANCE                          *
000500*     THIS PROGRAM IS ENTERED VIA TPS000, WHICH PASSES      *
000600*     THE CLIENT TPSPROFL RECORD TO LOOK UP RECORDS ON      *
000700*     THE CLIPBORD.DAT FILE AND DISPLAY THEM ON PANEL       *
000800*     TPS0037.                                              *
001600*************************************************************
001600*    MAINTENANCE                                            *
      * 05/16/17 CHANGED GUI                                   AC *     
001600* 08/29/00 FIX DATES IN PRE-TABLE WHEN PAGE-UP.             *
001600* 03/05/06 DISPLAY OLDEST RECORDS FIRST. REDO PROGRAM BY    *
001600*    JM    ADDING A TABLE AND LOOKUP TABLE TO DISPLAY RECORD*
001600*************************************************************
001700 ENVIRONMENT DIVISION.
001800*
001900 CONFIGURATION SECTION.
002000 SOURCE-COMPUTER. IBM-PC.
002100 OBJECT-COMPUTER. IBM-PC.
002200*
002300 DATA DIVISION.
002400*
002500 WORKING-STORAGE SECTION.

***************** WINFORMS SCREEN DEFINITION ***********

       01 TPS0037 type TPS000.TPS0037Form.

       01 CLOSE-ALL-FORMS-FLAG PIC 9(01) VALUE 0.
       01 SCREEN-NAME PIC x(10).

       01 TPS0037-NO PIC X(02) OCCURS 14 TIMES.
       01 TPS0037-DATE PIC X(08) OCCURS 14 TIMES.
       01 TPS0037-DESCRIPTION PIC X(60) OCCURS 14 TIMES.
       01 TPS0037-SELECTION PIC 9(02).
       01 TPS0037-IDX PIC 9(02).

       01 THE-IDX-2 PIC 9(02).
       01 WS-CURRENT-X                            PIC 9(04).
       01 WS-CURRENT-Y                            PIC 9(04).
       01 WS-CURRENT-XY-PARM.
          05 WS-X-PARM                            PIC 9(04).
          05 WS-Y-PARM                            PIC 9(04).

       

***********************************************************

002600*
002700* ------------------------: Dynamically called programs:
003400*
        01  GUISCREEN               PIC x(08) VALUE 'GS      '.
003500* 01  SCREENIO                PIC X(8) VALUE 'SCRNIO'.
003600  01  TPSDATES                PIC X(8) VALUE 'TPSDATES'.
003800  01  TPSIOERR                PIC X(8) VALUE 'TPSIOERR'.
004100  01  TPSIO019                PIC X(8) VALUE 'TPSIO019'.
004400* 01  TPSIO004                PIC X(8) VALUE 'TPSIO004'.
004500*
004600  COPY KEYVALUE.CPY.
004800  COPY TPSFILES.CPY.
004900
005300 01  CB.
005400  COPY CLIPBORD.CPY.
005800

009100*
009200* ------------------------: Miscellaneous working fields.
009300*
009400  01  WS-TODAYS-DATE-YMD         PIC  9(06).
009600  01  WS-TODAYS-DATE-CYMD        PIC  9(08).
009400  01  WS-CLIP-KEY.
009400      05 WS-CLIP-ACCT-NO         PIC  9(10).
009400      05 WS-CLIP-DATE            PIC  9(08).
009400      05 WS-CLIP-RECORD-NO       PIC  9(04).
009400      05 WS-CLIP-LINE-NO         PIC  9(02).
009700*
006700  01  WS-DATE-REQUEST.
006800      05  WS-DATE-PARAM          PIC  9(02).
006900
007000      05  WS-DATE-TENBYTES       PIC  X(20) VALUE SPACES.
007100      05  FILLER REDEFINES WS-DATE-TENBYTES.
007200          10  WS-DATE-REFORM         PIC  X(06).
007300          10  WS-DATE-EXTEND         PIC  X(04).
007400          10  FILLER                 PIC  X(10).
007500      05  FILLER REDEFINES WS-DATE-TENBYTES.
007600          10  WS-DATE-REFORM-LEN06   PIC  X(06).
007700          10  FILLER                 PIC  X(14).
007800      05  FILLER REDEFINES WS-DATE-TENBYTES.
007900          10  WS-DATE-REFORM-LEN08   PIC  X(08).
008000          10  FILLER                 PIC  X(12).
008100      05  FILLER REDEFINES WS-DATE-TENBYTES.
008200          10  WS-DATE-REFORM-LEN10   PIC  X(10).
008300          10  FILLER                 PIC  X(10).
008400      05  FILLER REDEFINES WS-DATE-TENBYTES.
008500          10  WS-TIME-PARM1          PIC  X(06).
008600          10  WS-TIME-PARM2          PIC  X(06).
008700          10  WS-TIME-EXTEND         PIC  X(08).
008800      05  FILLER REDEFINES WS-DATE-TENBYTES.
008900          10  WS-TIME-PARM1BY8       PIC  X(08).
009000          10  WS-TIME-PARM2BY8       PIC  X(08).
009100          10  WS-TIME-EXTNDBY8       PIC  X(04).
012900*
016900  01 WS-TAB                           PIC  9(02) VALUE 0.
016900  01 WS-SUB                           PIC  9(02) VALUE 0.
016900  01 WS-SUB1                          PIC  9(02) VALUE 0.
016900  01 WS-SUB2                          PIC  9(02) VALUE 0.
016900  01 WORK-DATE.
016900     05 WORK-DATE-MM                  PIC  9(02).
016900     05 FILLER                        PIC  X(01) VALUE '/'.
016900     05 WORK-DATE-DD                  PIC  9(02).
016900     05 FILLER                        PIC  X(01) VALUE '/'.
016900     05 WORK-DATE-YY                  PIC  9(02).
016900  01 WS-DATE.
016900     05 WS-DATE-MM                    PIC  9(02).
016900     05 WS-DATE-DD                    PIC  9(02).
016900     05 WS-DATE-YY                    PIC  9(02).
016900
017000  01 MASTER-TABLE OCCURS 1 TO 5000 TIMES
016900       DEPENDING ON MAS-SUB.
002600     10  MAST-DATE                   PIC  9(08).
002600     10  MAST-RECORD-NO              PIC  9(04).
002600     10  MAST-LINE-NO                PIC  9(02).
002700     10  MAST-DESCRIPTION            PIC  X(65).
017300  01 MAS-SUB                         PIC  9(04) VALUE ZERO.
017300  01 MS-SUB                          PIC  9(04) VALUE ZERO.
016800
016900  01 CLIP-TABLE                       PIC  X(980).
017000  01 FILLER REDEFINES CLIP-TABLE OCCURS 14 TIMES.
017100      05 TABLE-NO                     PIC  X(02).
017200      05 TABLE-DATE                   PIC  X(08).
017300      05 TABLE-DESCRIPTION            PIC  X(60).
016800
016900  01 CLIP-TABLE1                       PIC X(84).
017000  01 FILLER REDEFINES CLIP-TABLE1 OCCURS 14 TIMES.
017100      05 TABLE1-REC-NO                PIC  9(04).
017200      05 TABLE1-LINE-NO               PIC  9(02).
016800
016900  01 PRE-TABLE                        PIC  X(1064).
017000  01 FILLER REDEFINES PRE-TABLE OCCURS 14 TIMES.
017100      05 PRE-TABLE-NO                 PIC  X(02).
017200      05 PRE-TABLE-DATE               PIC  X(08).
017100      05 PRE-TABLE-REC-NO             PIC  9(04).
017200      05 PRE-TABLE-LINE-NO            PIC  9(02).
017300      05 PRE-TABLE-DESCRIPTION        PIC  X(60).
013600*
017100*
016900  01 OPEN-FLAGS.
017700      05  TPSPROFL-FLAG             PIC  9(01) VALUE 0.
017800               88  TPSPROFL-OPEN          VALUE 1.
018300      05  CLIPBORD-FLAG             PIC  9(01) VALUE 0.
018400               88  CLIPBORD-OPEN          VALUE 1.
018500*
018900 LINKAGE SECTION.
019500
019600 01  PS.
019700  COPY TPSPROFL.CPY.
019500
019600 01  LS.
019700  COPY TPSLOGON.CPY.
019800
021600 01 CURRENT-XY-PARAMETERS PIC 9(08).

021700 PROCEDURE DIVISION USING PS
                                LS
                                CURRENT-XY-PARAMETERS.
021800*
021900 0001-BEGIN.

      *********** INITIALIZE WINFORMS SCREENS ********** 

       set TPS0037 to new TPS000.TPS0037Form().

      **************************************************
           MOVE CURRENT-XY-PARAMETERS(1:4) TO WS-CURRENT-X
                                              WS-X-PARM.
           MOVE CURRENT-XY-PARAMETERS(5:4) TO WS-CURRENT-Y
                                              WS-Y-PARM.

022000
022000    ACCEPT WS-TODAYS-DATE-YMD FROM DATE.
022100    MOVE 01                   TO WS-DATE-PARAM.
022200    MOVE WS-TODAYS-DATE-YMD   TO WS-DATE-REFORM.
022300    MOVE SPACES               TO WS-DATE-EXTEND.
022500    CALL TPSDATES USING WS-DATE-REQUEST.
022700    MOVE WS-DATE-REFORM-LEN08 TO WS-TODAYS-DATE-CYMD.
022800
111631     MOVE CLNT-PROFILE-LAST-NAME TO TPS0037::CLNT-LAST-NAME
111631     MOVE CLNT-PROFILE-FIRST-NAME TO TPS0037::CLNT-FIRST-NAME.
111631    MOVE CLNT-PROFILE-MDDL-INIT    TO TPS0037::CLNT-MIDDLE-INIT
111631    MOVE CLNT-PROFILE-ACCT-NO      TO CLIP-ACCT-NO
111631                                      TPS0037::CLNT-ACCOUNT.
111631    MOVE ZEROS                     TO CLIP-DATE.
111631    MOVE ZEROS                     TO CLIP-RECORD-NO.
111631    MOVE ZEROS                     TO CLIP-LINE-NO.
111631
111631    IF NOT CLIPBORD-OPEN
111632       MOVE 1                    TO CLIPBORD-FLAG
111633       SET FR-OPEN-I-O TO TRUE
111634       CALL TPSIO019 USING FILE-REQUEST CB
111636       IF FILE-STATUS NOT = '00' AND '05'
111637          MOVE 'CLIPBRD' TO FILE-NAME
111638          MOVE 'TPS122-OPEN' TO FILE-TEXT
111639          PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
111733          GO TO EXIT-THE-MODULE.
111641
056630    MOVE F-PRIME TO FILE-KEY.
056640    MOVE F-START TO FILE-ACTION.
056650    CALL TPSIO019 USING FILE-REQUEST CB.
056660    IF NO-RECORD-WAS-FOUND OR END-OF-FILE-WAS-REACHED
062800      INITIALIZE  CLIP-TABLE
062900      MOVE '**** NO RECORDS FOUND ****' TO TABLE-DESCRIPTION(1)
063100      GO TO 0020-MOVE-TABLE.
063100
056660    IF NOT A-SUCCESSFUL-OPERATION
056680       MOVE 'CLIPBORD' TO FILE-NAME
056690       MOVE 'START'    TO FILE-TEXT
056691       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT.
056692
056692    INITIALIZE CLIP-TABLE, CLIP-TABLE1.
056692    MOVE ZERO                 TO WS-SUB
056620                                 WS-TAB.
056692    MOVE 1                    TO MAS-SUB.
056620
021900 0005-BUILD-TABLE.
022000
056630    MOVE F-PRIME TO FILE-KEY.
056640    MOVE F-READ-NEXT TO FILE-ACTION.
056650    CALL TPSIO019 USING FILE-REQUEST CB.
056660
056660    IF END-OF-FILE-WAS-REACHED OR
056660       (CLIP-ACCT-NO NOT = CLNT-PROFILE-ACCT-NO)
056660       GO TO 0005-EXIT
056660    ELSE
056700       MOVE CLIP-KEY    TO WS-CLIP-KEY.
056660
056660    IF NOT A-SUCCESSFUL-OPERATION
056680       MOVE 'CLIPBORD' TO FILE-NAME
056690       MOVE 'READN'    TO FILE-TEXT
056691       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
056692       GO TO EXIT-THE-MODULE.
056660
056660    IF CLIP-ADD-DATE(1:1) = 8 OR 9
056680       GO TO 0005-BUILD-TABLE.
056693
045650    MOVE CLIP-DATE          TO MAST-DATE(MAS-SUB).
056693    MOVE CLIP-RECORD-NO     TO MAST-RECORD-NO(MAS-SUB).
056693    MOVE CLIP-LINE-NO       TO MAST-LINE-NO(MAS-SUB).
056693    MOVE CLIP-DESCRIPTION   TO MAST-DESCRIPTION(MAS-SUB).

056693    ADD 1                           TO MAS-SUB.
056693    GO TO 0005-BUILD-TABLE.
056693
056693 0005-EXIT.    EXIT.
056693
056693 0007-SORT.
056620
056693    SORT MASTER-TABLE DESCENDING MAST-DATE
056693                      ASCENDING  MAST-RECORD-NO
056693                                 MAST-LINE-NO.
056693
021900 0007-EXIT.  EXIT.
056620
021900 0010-READ-NEXT-CLIPBORD.
022000
056700    IF WS-SUB = 14
056700       GO TO 0010-EXIT.
056693
056693    ADD 1                           TO WS-SUB
056693                                       MS-SUB.
045650    IF MAST-LINE-NO(MS-SUB) = 1
045650       MOVE MAST-DATE(MS-SUB)(3:2)  TO WORK-DATE-YY
045650       MOVE MAST-DATE(MS-SUB)(5:2)  TO WORK-DATE-MM
045650       MOVE MAST-DATE(MS-SUB)(7:2)  TO WORK-DATE-DD
045730       MOVE WORK-DATE               TO TABLE-DATE(WS-SUB)
056693       ADD 1                        TO WS-TAB
056693       MOVE WS-TAB                  TO TABLE-NO(WS-SUB).
056693    MOVE MAST-DESCRIPTION(MS-SUB)   TO TABLE-DESCRIPTION(WS-SUB).
056693** MOVE RECORD NUMBER TO SEPERATE TABLE TO USE FOR REC LOOKUP **
056693    MOVE MAST-RECORD-NO(MS-SUB)     TO TABLE1-REC-NO(WS-SUB).
056693    MOVE MAST-LINE-NO(MS-SUB)       TO TABLE1-LINE-NO(WS-SUB).
056693
056693    GO TO 0010-READ-NEXT-CLIPBORD.
056693
056693 0010-EXIT.    EXIT.
056693
056693 0020-MOVE-TABLE.


           MOVE 0 TO TPS0037-IDX.
           PERFORM VARYING THE-IDX-2 FROM 1 BY 1
             UNTIL THE-IDX-2 > 14
               MOVE TABLE-NO(THE-IDX-2) TO
                 TPS0037-NO(THE-IDX-2)
                 TPS0037::NO-1(TPS0037-IDX)
               MOVE TABLE-DATE(THE-IDX-2) TO
                 TPS0037-DATE(THE-IDX-2)
                 TPS0037::DATE-1(TPS0037-IDX)
               MOVE TABLE-DESCRIPTION(THE-IDX-2) TO
                 TPS0037-DESCRIPTION(THE-IDX-2)
                 TPS0037::DESCRIPTION(TPS0037-IDX)
               COMPUTE TPS0037-IDX = TPS0037-IDX + 1
           END-PERFORM.


045730      MOVE ZERO                 TO TPS0037-SELECTION.
061600
061601      MOVE 47                   TO TPS0037::ACTIVE-FIELD.

062900      MOVE 'F1-ADD, F2-DELETE, ANY KEY TO GO BACK'
061604                                TO TPS0037::MENU-LINE.
           MOVE 1 TO TPS0037::CHOOSE-OPTION-FLAG.
           SET TPS0037::X-POINT TO WS-X-PARM.
           SET TPS0037::Y-POINT TO WS-Y-PARM.
           INVOKE TPS0037::ShowDialog.
           MOVE TPS0037::Location::X TO WS-X-PARM
             WS-CURRENT-X.
           MOVE TPS0037::Location::Y TO WS-Y-PARM
             WS-CURRENT-Y.
           MOVE TPS0037::SCREEN-NAME TO SCREEN-NAME.
           MOVE TPS0037::SELECTION TO TPS0037-SELECTION.
           MOVE 0 TO TPS0037::CHOOSE-OPTION-FLAG.

           MOVE 0 TO TPS0037-IDX.
           PERFORM VARYING THE-IDX-2 FROM 1 BY 1
             UNTIL THE-IDX-2 > 14
               MOVE TPS0037::DESCRIPTION(TPS0037-IDX) TO
                 TPS0037-DESCRIPTION(THE-IDX-2)
               COMPUTE TPS0037-IDX = TPS0037-IDX + 1
           END-PERFORM.

111771     IF TPS0037::KEY-PRESSED = "End Key"
               GO TO EXIT-THE-MODULE
           END-IF.

111771     IF TPS0037::KEY-PRESSED = "Enter Key"
               GO TO EXIT-THE-MODULE
           END-IF.

111772      IF TPS0037::KEY-PRESSED = "F1 Key"
111775         GO TO 0050-ADD-RECORD.
111776
111772*     IF TPS0037-EXIT-KEY = F2
111775*        GO TO 0050-CHANGE-RECORD.
111776
111772      IF TPS0037::KEY-PRESSED = "F2 Key"
111775         GO TO 0060-DELETE-RECORD.
111776
111772      IF TPS0037::KEY-PRESSED = "Page Down Key"
056693         IF MS-SUB > MAS-SUB
056693            GO TO 0020-MOVE-TABLE
056693         END-IF
056692         INITIALIZE CLIP-TABLE, CLIP-TABLE1
056692         MOVE ZERO                 TO WS-SUB
056692         MOVE ZERO                 TO WS-TAB
056692*        MOVE WS-CLIP-KEY          TO CLIP-KEY
056692*        MOVE ZERO                 TO CLIP-LINE-NO
111775         GO TO 0010-READ-NEXT-CLIPBORD.
111776
111772      IF TPS0037::KEY-PRESSED = "Page Up Key"
056693         IF MS-SUB = 14
056693            GO TO 0020-MOVE-TABLE
056693         END-IF
056692         INITIALIZE CLIP-TABLE, CLIP-TABLE1
056692         MOVE ZERO                 TO WS-SUB
056692         MOVE ZERO                 TO WS-TAB
056692         SUBTRACT 28               FROM MS-SUB
111775         GO TO 0010-READ-NEXT-CLIPBORD.
111776
111775      GO TO EXIT-THE-MODULE.
111776
056693 0020-EXIT.    EXIT.
056693
056700 0030-READ-PREV-CLIPBORD.
056620
056700    IF WS-SUB = 14
056692*      MOVE WS-SUB            TO WS-SUB1
056692*      INITIALIZE CLIP-TABLE, CLIP-TABLE1
056692*      PERFORM 0035-REVERSE-TABLE VARYING WS-SUB2
063100*             FROM 1 BY 1 UNTIL WS-SUB2 > WS-SUB
063100       GO TO 0020-MOVE-TABLE.
056693
056693    ADD 1                       TO WS-SUB
056693                                   MS-SUB.
056693
045650    IF MAST-LINE-NO(MS-SUB) = 1
045650       MOVE MAST-DATE(MS-SUB)(3:2)  TO WORK-DATE-YY
045650       MOVE MAST-DATE(MS-SUB)(5:2)  TO WORK-DATE-MM
045650       MOVE MAST-DATE(MS-SUB)(7:2)  TO WORK-DATE-DD
045730       MOVE WORK-DATE               TO TABLE-DATE(WS-SUB)
056693       ADD 1                        TO WS-TAB
056693       MOVE WS-TAB                  TO TABLE-NO(WS-SUB).
056693    MOVE MAST-DESCRIPTION(MS-SUB)   TO TABLE-DESCRIPTION(WS-SUB).
056693** MOVE RECORD NUMBER TO SEPERATE TABLE TO USE FOR REC LOOKUP **
056693    MOVE MAST-RECORD-NO(MS-SUB)     TO TABLE1-REC-NO(WS-SUB).
056693    MOVE MAST-LINE-NO(MS-SUB)       TO TABLE1-LINE-NO(WS-SUB).
056693
056693    GO TO 0030-READ-PREV-CLIPBORD.
056693
056693 0030-EXIT.           EXIT.
056610
056693 0035-REVERSE-TABLE.
056693
045730    MOVE PRE-TABLE-DATE(WS-SUB1)        TO TABLE-DATE(WS-SUB2).
056693    MOVE WS-SUB2                        TO TABLE-NO(WS-SUB2).
056693    MOVE PRE-TABLE-DESCRIPTION(WS-SUB1)
056693                                    TO TABLE-DESCRIPTION(WS-SUB2).
056693** MOVE RECORD NUMBER TO SEPERATE TABLE TO USE FOR REC LOOKUP **
056693    MOVE PRE-TABLE-REC-NO(WS-SUB1)  TO TABLE1-REC-NO(WS-SUB2).
056693    MOVE PRE-TABLE-LINE-NO(WS-SUB1) TO TABLE1-LINE-NO(WS-SUB2).
056693
056693    SUBTRACT 1       FROM WS-SUB1.
056693
056693 0035-EXIT.     EXIT.
056693
231200*
111828 0040-READ-CLIPBOARD.
111829
056630    MOVE F-PRIME TO FILE-KEY.
056640    MOVE F-READ  TO FILE-ACTION.
056650    CALL TPSIO019 USING FILE-REQUEST CB.
056660
056660    IF NOT A-SUCCESSFUL-OPERATION
056680       MOVE 'CLIPBORD' TO FILE-NAME
056690       MOVE 'READN'    TO FILE-TEXT
056691       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
056692       GO TO EXIT-THE-MODULE.
111837
111828 0040-EXIT.   EXIT.
231200
111828 0050-ADD-RECORD.

111829
111830     IF LOGREC-ACCESS-LEVEL < 3
111834         MOVE 'NOT AUTHORIZED TO ADD RECORDS, HIT END KEY'
111835           TO TPS0037::MENU-LINE

               MOVE 1 TO TPS0037::PROTECT-FLAG

               SET TPS0037::X-POINT TO WS-X-PARM
               SET TPS0037::Y-POINT TO WS-Y-PARM
               INVOKE TPS0037::ShowDialog
               MOVE TPS0037::Location::X TO WS-X-PARM
                 WS-CURRENT-X
               MOVE TPS0037::Location::Y TO WS-Y-PARM
                 WS-CURRENT-Y
               MOVE TPS0037::SCREEN-NAME TO SCREEN-NAME

               MOVE 0 TO TPS0037::PROTECT-FLAG

111733         GO TO EXIT-THE-MODULE.

056692     INITIALIZE CLIP-TABLE, CLIP-TABLE1.
           MOVE 0 TO TPS0037-IDX.
           PERFORM VARYING THE-IDX-2 FROM 1 BY 1
             UNTIL THE-IDX-2 > 14
               MOVE TABLE-NO(THE-IDX-2) TO
                 TPS0037-NO(THE-IDX-2)
                 TPS0037::NO-1(TPS0037-IDX)
               MOVE TABLE-DATE(THE-IDX-2) TO
                 TPS0037-DATE(THE-IDX-2)
                 TPS0037::DATE-1(TPS0037-IDX)
               MOVE TABLE-DESCRIPTION(THE-IDX-2) TO
                 TPS0037-DESCRIPTION(THE-IDX-2)
                 TPS0037::DESCRIPTION(TPS0037-IDX)
               COMPUTE TPS0037-IDX = TPS0037-IDX + 1
           END-PERFORM.


045650     MOVE WS-TODAYS-DATE-YMD(1:2)    TO WORK-DATE-YY.
045650     MOVE WS-TODAYS-DATE-YMD(3:2)    TO WORK-DATE-MM.
045650     MOVE WS-TODAYS-DATE-YMD(5:2)    TO WORK-DATE-DD.
045730     MOVE WORK-DATE            TO TPS0037-DATE(1)
                                        TPS0037::DATE-1(0).
045730     MOVE 'END OF NOTE'        TO TPS0037-DESCRIPTION(5)
                                         TPS0037::DESCRIPTION(4).
045730     MOVE ZERO                 TO TPS0037-SELECTION.
111833     MOVE 7                    TO TPS0037::ACTIVE-FIELD.

111834     MOVE 'ENTER TO CONFIRM ADD OR END KEY TO GO BACK'
111835                               TO TPS0037::MENU-LINE.

           MOVE 1 TO TPS0037::F1-ADD-FLAG.
           MOVE TPS0037-DATE(1) TO TPS0037::DATE-1(0).
           SET TPS0037::X-POINT TO WS-X-PARM.
           SET TPS0037::Y-POINT TO WS-Y-PARM.
           INVOKE TPS0037::ShowDialog.
           MOVE TPS0037::Location::X TO WS-X-PARM
             WS-CURRENT-X.
           MOVE TPS0037::Location::Y TO WS-Y-PARM
             WS-CURRENT-Y.
           MOVE TPS0037::SCREEN-NAME TO SCREEN-NAME.
           MOVE 0 TO TPS0037::F1-ADD-FLAG.

111774     IF TPS0037::KEY-PRESSED = "End Key"
111775        GO TO EXIT-THE-MODULE.
111776
111777     IF NOT TPS0037::KEY-PRESSED = "Enter Key"
111775        GO TO EXIT-THE-MODULE.

           MOVE 0 TO TPS0037-IDX.
           PERFORM VARYING THE-IDX-2 FROM 1 BY 1
             UNTIL THE-IDX-2 > 5
               MOVE TPS0037::DESCRIPTION(TPS0037-IDX) TO
                 TPS0037-DESCRIPTION(THE-IDX-2)
               COMPUTE TPS0037-IDX = TPS0037-IDX + 1
           END-PERFORM.
111776
045730**** READ FILE TO POSITION TO ADD NEW RECORD ******
056693    MOVE CLNT-PROFILE-ACCT-NO           TO CLIP-ACCT-NO.
045730    MOVE WS-TODAYS-DATE-CYMD            TO CLIP-DATE.
056693    MOVE 1                              TO CLIP-RECORD-NO.
056693    MOVE 1                              TO CLIP-LINE-NO.
025000
111848 ADD-CONTINUE.
111849     SET FR-READ TO TRUE
111850     CALL TPSIO019 USING FILE-REQUEST CB.
111851
056660    IF NO-RECORD-WAS-FOUND OR END-OF-FILE-WAS-REACHED
056660       GO TO 0055-WRITE-RECORD.
111851
111852     IF NOT A-SUCCESSFUL-OPERATION
111853        MOVE 'CLIPBORD' TO FILE-NAME
111854        MOVE 'TPS122-READ ' TO FILE-TEXT
111855        PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
111733        GO TO EXIT-THE-MODULE.
135400
111838     ADD 1                  TO CLIP-RECORD-NO.
111839     GO TO ADD-CONTINUE.
111848
231600 0050-EXIT.    EXIT.
111848
231600 0055-WRITE-RECORD.
111848
111848     MOVE CLNT-PROFILE-ACCT-NO    TO CLIP-ACCT-NO.
111848     MOVE WS-TODAYS-DATE-CYMD     TO CLIP-DATE
111848                                     CLIP-ADD-DATE.
111848
111849     IF TPS0037-DESCRIPTION(1) > SPACES
111850        MOVE 1                    TO CLIP-LINE-NO
111850        MOVE TPS0037-DESCRIPTION(1)    TO CLIP-DESCRIPTION
111850        PERFORM 0056-WRITE-CLIP-RECORD THRU 0056-EXIT.
111848
111849     IF TPS0037-DESCRIPTION(2) > SPACES
111850        MOVE 2                    TO CLIP-LINE-NO
111850        MOVE TPS0037-DESCRIPTION(2)    TO CLIP-DESCRIPTION
111850        PERFORM 0056-WRITE-CLIP-RECORD THRU 0056-EXIT.
111848
111849     IF TPS0037-DESCRIPTION(3) > SPACES
111850        MOVE 3                    TO CLIP-LINE-NO
111850        MOVE TPS0037-DESCRIPTION(3)    TO CLIP-DESCRIPTION
111850        PERFORM 0056-WRITE-CLIP-RECORD THRU 0056-EXIT.
111848
111849     IF TPS0037-DESCRIPTION(4) > SPACES
111850        MOVE 4                    TO CLIP-LINE-NO
111850        MOVE TPS0037-DESCRIPTION(4)    TO CLIP-DESCRIPTION
111850        PERFORM 0056-WRITE-CLIP-RECORD THRU 0056-EXIT.
111850
111850     GO TO 0001-BEGIN.
111817
111828 0055-EXIT.    EXIT.
111817
111828 0056-WRITE-CLIP-RECORD.
111848
111849     SET FR-WRITE TO TRUE
111850     CALL TPSIO019 USING FILE-REQUEST CB.
111851
111852     IF NOT A-SUCCESSFUL-OPERATION
111853        MOVE 'CLIPBORD' TO FILE-NAME
111854        MOVE 'TPS122-DELETE ' TO FILE-TEXT
111855        PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
111733        GO TO EXIT-THE-MODULE.
111817
111828 0056-EXIT.    EXIT.
231200
111828 0060-DELETE-RECORD.

           MOVE 0 TO TPS0037-IDX.
           PERFORM VARYING THE-IDX-2 FROM 1 BY 1
             UNTIL THE-IDX-2 > 14
               MOVE TABLE-NO(THE-IDX-2) TO
                 TPS0037-NO(THE-IDX-2)
                 TPS0037::NO-1(TPS0037-IDX)
               MOVE TABLE-DATE(THE-IDX-2) TO
                 TPS0037-DATE(THE-IDX-2)
                 TPS0037::DATE-1(TPS0037-IDX)
               MOVE TABLE-DESCRIPTION(THE-IDX-2) TO
                 TPS0037-DESCRIPTION(THE-IDX-2)
                 TPS0037::DESCRIPTION(TPS0037-IDX)
               COMPUTE TPS0037-IDX = TPS0037-IDX + 1
           END-PERFORM.
111829
111830     IF LOGREC-ACCESS-LEVEL < 3
111834         MOVE 'NOT AUTHORIZED TO DELETE RECORDS, HIT END KEY'
111835           TO TPS0037::MENU-LINE
               MOVE 1 TO TPS0037::PROTECT-FLAG

               SET TPS0037::X-POINT TO WS-X-PARM
               SET TPS0037::Y-POINT TO WS-Y-PARM
               INVOKE TPS0037::ShowDialog
               MOVE TPS0037::Location::X TO WS-X-PARM
                 WS-CURRENT-X
               MOVE TPS0037::Location::Y TO WS-Y-PARM
                 WS-CURRENT-Y
               MOVE TPS0037::SCREEN-NAME TO SCREEN-NAME

               MOVE 0 TO TPS0037::PROTECT-FLAG

111733         GO TO EXIT-THE-MODULE.
111837

111834     MOVE 'ENTER TO CONFIRM DELETE OR END KEY TO GO BACK'
111835                               TO TPS0037::MENU-LINE.

           MOVE 48 TO TPS0037::ACTIVE-FIELD.

           MOVE 1 TO TPS0037::PROTECT-FLAG.
           MOVE 1 TO TPS0037::F2-DELTE-FLAG.
           SET TPS0037::X-POINT TO WS-X-PARM.
           SET TPS0037::Y-POINT TO WS-Y-PARM.
           INVOKE TPS0037::ShowDialog.
           MOVE TPS0037::Location::X TO WS-X-PARM
             WS-CURRENT-X.
           MOVE TPS0037::Location::Y TO WS-Y-PARM
             WS-CURRENT-Y.
           MOVE TPS0037::SCREEN-NAME TO SCREEN-NAME.
           MOVE 0 TO TPS0037::F2-DELTE-FLAG.
           MOVE 0 TO TPS0037::PROTECT-FLAG.

111773
111774     IF TPS0037::KEY-PRESSED = "End Key"
111775        GO TO EXIT-THE-MODULE.
111776
111777     IF NOT TPS0037::KEY-PRESSED = "Enter Key"
111775        GO TO EXIT-THE-MODULE.
111776
111777     IF TPS0037-SELECTION < 1 OR > 14
111775        GO TO EXIT-THE-MODULE.
111778
045730**** READ TABLE TO GET SELECTED RECORD ****
045730    MOVE ZERO               TO WS-TAB.
045730    PERFORM 0065-ADD-TAB THRU 0065-EXIT.
045725    MOVE TABLE-DATE(WS-TAB)             TO WORK-DATE.
045725    MOVE WORK-DATE-MM                   TO WS-DATE-MM.
045725    MOVE WORK-DATE-DD                   TO WS-DATE-DD.
045725    MOVE WORK-DATE-YY                   TO WS-DATE-YY.
045725    MOVE WS-DATE                        TO WS-DATE-REFORM.
045725    MOVE 11                             TO WS-DATE-PARAM.
045726    MOVE SPACES                         TO WS-DATE-EXTEND.
045728    CALL TPSDATES USING WS-DATE-REQUEST.
045730    MOVE WS-DATE-REFORM-LEN08           TO CLIP-DATE.
056693    MOVE CLNT-PROFILE-ACCT-NO           TO CLIP-ACCT-NO.
056693    MOVE TABLE1-REC-NO(WS-TAB)          TO CLIP-RECORD-NO.
056693    MOVE TABLE1-LINE-NO(WS-TAB)         TO CLIP-LINE-NO.
025000
231600 DELETE-CONTINUE.
111849     SET FR-READ TO TRUE
111850     CALL TPSIO019 USING FILE-REQUEST CB.
111851
111852     IF NO-RECORD-WAS-FOUND
111853        GO TO 0001-BEGIN.
111851
111852     IF NOT A-SUCCESSFUL-OPERATION
111853        MOVE 'CLIPBORD' TO FILE-NAME
111854        MOVE 'TPS122-READ ' TO FILE-TEXT
111855        PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
111733        GO TO EXIT-THE-MODULE.
135400
111838     IF CLIP-ADD-DATE(1:1) = 1
111839        MOVE 8              TO CLIP-ADD-DATE(1:1)
111839     ELSE
111839        MOVE 9              TO CLIP-ADD-DATE(1:1).
111848
111849     SET FR-REWRITE TO TRUE
111850     CALL TPSIO019 USING FILE-REQUEST CB.
111851
111852     IF NOT A-SUCCESSFUL-OPERATION
111853        MOVE 'CLIPBORD' TO FILE-NAME
111854        MOVE 'TPS122-DELETE ' TO FILE-TEXT
111855        PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
111733        GO TO EXIT-THE-MODULE.
135400
231500     ADD 1              TO CLIP-LINE-NO.
231600     GO TO DELETE-CONTINUE.
111817
111828 0060-EXIT.    EXIT.
231500
111828 0065-ADD-TAB.
135400
231500     ADD 1              TO WS-TAB.
231500     IF TABLE-NO(WS-TAB) = TPS0037-SELECTION
231500        GO TO 0065-EXIT
231500     ELSE
231500        GO TO 0065-ADD-TAB.
111817
111828 0065-EXIT.    EXIT.
231500
231400 EXIT-THE-MODULE.

           IF CLOSE-ALL-FORMS-FLAG = 0
               SET TPS0037::KEY-PRESSED TO "End Key"
               INVOKE TPS0037::Close
               MOVE 1 TO CLOSE-ALL-FORMS-FLAG
           END-IF.
231500
231500      IF NOT CLIPBORD-OPEN
231600           GO TO END-OF-THE-LINE.
231700
231800      SET FR-CLOSE         TO TRUE
231900      CALL TPSIO019 USING FILE-REQUEST CB
232000      IF NOT A-SUCCESSFUL-OPERATION
232100           MOVE 'CLIPBORD' TO FILE-NAME
232200           MOVE 'TPS122-CLOSE' TO FILE-TEXT
232300           PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
232400           GOBACK GIVING CURRENT-XY-PARAMETERS.
232500
236200 END-OF-THE-LINE.
236300*     CANCEL SCREENIO
236400      CANCEL TPSDATES
236600      CANCEL TPSIOERR
236800      CANCEL TPSIO019.

           INITIALIZE CURRENT-XY-PARAMETERS.
           MOVE WS-CURRENT-X TO CURRENT-XY-PARAMETERS(1:4).
           MOVE WS-CURRENT-Y TO CURRENT-XY-PARAMETERS(5:4).

           IF CLOSE-ALL-FORMS-FLAG = 0
               SET TPS0037::KEY-PRESSED TO "End Key"
               INVOKE TPS0037::Close
               MOVE 1 TO CLOSE-ALL-FORMS-FLAG
           END-IF.


237300         GOBACK GIVING CURRENT-XY-PARAMETERS.
237400
237500 FILE-ERROR.
237600      CALL TPSIOERR USING FILE-REQUEST
                                WS-CURRENT-XY-PARM.
237700      CANCEL TPSIOERR.

            MOVE WS-CURRENT-XY-PARM(1:4) TO WS-CURRENT-X.
            MOVE WS-CURRENT-XY-PARM(5:4) TO WS-CURRENT-Y.

            INITIALIZE CURRENT-XY-PARAMETERS.
            MOVE WS-CURRENT-X TO CURRENT-XY-PARAMETERS(1:4).
            MOVE WS-CURRENT-Y TO CURRENT-XY-PARAMETERS(5:4).

237800 FILE-ERROR-EXIT. EXIT.
237900
