000100 IDENTIFICATION DIVISION.
000200 PROGRAM-ID. TPS118.
000300*************************************************************
000400*     VEHICLE ONLINE PROGRAM                                *
000500*     THIS PROGRAM IS ENTERED VIA TPS000, WHICH PASSES      *
000600*     THE TPSLOGON AND TPSADMIN RECORDS OF THE ADMINIS-     *
000700*     TRATOR THAT HAS LOGGED ON.                            *
000800*     THIS MODULE WILL CREATE TPSVEHIC RECORD(S) IF THE     *
000900*     CLIENT PROFILE REQUIRIES THEM.                        *
001100*************************************************************
001000*                    MAINTENANCE LOG                        * 
      * 05/12/17 CHANGED GUI                                   AC *
      * 05/03/17 GUI CONVERSION                                TAM*     
001000* 08/08/00-COMMENTED OUT CODE TO BYPASS DELETED VEHICLES,   *                                 
001000*    TS    WAS CAUSING PROBLEM WHEN ADDING NEW VEHICLE.     *                                 
001000*         -ADDED NEW COLUMN ON PANEL TPS0350 TO FLAG DELETED*                                 
001000*          VEHICLES...........                              *                                 
001000* 06/02/00 CHANGED FOOTNOTE OF PANELS TPS0350 & TPS0351,    *                                 
001000*    TS    ALSO ALLOW INPUT OF LINE 14 WHEN 14TH IS NEW VEH.*                                 
001000* 05/18/00 FIXED PROBLEM WHEN VEHICLES EXCEED 13........ TS *                                 
001000* 12/08/95 CHANGE PANEL MESSAGE FOR POP-UP WINDOW.       JM *
001000* 11/15/95 FIX SELECTION FOR VEHICLE TYPE.               JM *
001000* 10/04/95 TURN OFF TPSREPORTFILE(TPSREPRT.CPY)          JM *
001000* 09/25/95 IF DATE = ZEROS DON'T DO CALENDAR MAINTENANCE JM *
001000* 08/10/95 ACTIVATE AND TEST CALENDAR MAINTENANCE ROUTINE   *
001000* 02/15/95 ADD CALENDAR EVEMNT ROUTINE WHEN DATES CHANGE    *
001000*              CALL TPS4010 AND PROCESS DATA            JM  *
001100*************************************************************
001200 ENVIRONMENT DIVISION.
001300*
001400 CONFIGURATION SECTION.
001500 SOURCE-COMPUTER. IBM-PC.
001600 OBJECT-COMPUTER. IBM-PC.
001700*
001800 DATA DIVISION.
001900*
002000 WORKING-STORAGE SECTION.


***************** WINFORMS SCREEN DEFINITION ************

       01 TPS0040A type TPS000.TPS0040AForm.
       01 TPS0045 type TPS000.TPS0045Form.
       01 TPS0350 type TPS000.TPS0350Form.
       01 TPS0351 type TPS000.TPS0351Form.

       01 TPS0045-DISPLAY-FLAG PIC 9(01) VALUE 0.

       01 TPS0350-LINE-NUMBER PIC 9(02) OCCURS 13 TIMES.
       01 TPS0350-DELETE-FLAG PIC X(01) OCCURS 13 TIMES.
       01 TPS0350-YEAR PIC 9(04) OCCURS 13 TIMES.
       01 TPS0350-MAKE PIC X(20) OCCURS 13 TIMES.
       01 TPS0350-MODEL PIC X(20) OCCURS 13 TIMES.
       01 TPS0350-COLOR PIC X(08) OCCURS 13 TIMES.
       01 TPS0350-PLATE-NUMBER PIC X(08) OCCURS 13 TIMES.
       01 TPS0350-PLATE-STATE PIC X(02) OCCURS 13 TIMES.
       01 TPS0350-IDX PIC 9(02).

       01 TPS0351-YEAR PIC 9(04).
       01 TPS0351-REGISTER-EXPIRE PIC 9(06).
       01 TPS0351-INSPECT-EXPIRE PIC 9(06).
       01 TPS0351-WARRANTY-EXPIRE PIC 9(06).
       01 TPS0351-SALES-PERSON-PHONE PIC 9(10).
       01 TPS0351-SERVICE-PERSON-PHONE PIC 9(10).

       01 CLOSE-ALL-FORMS-FLAG PIC 9(01) VALUE 0.
       01 SCREEN-NAME PIC x(10).

       01 WS-CURRENT-X                            PIC 9(04).
       01 WS-CURRENT-Y                            PIC 9(04).
       01 WS-CURRENT-XY-PARM.
          05 WS-X-PARM                            PIC 9(04).
          05 WS-Y-PARM                            PIC 9(04).

       COPY "ds-cntrl.v1".

       

**********************************************************
       01 THE-IDX                PIC S9(04).
002100*
002200* ------------------------: Dynamically called programs:
002300*        SCRNIO  is SCREENIO
002400*        TPSIO014 IS 'VEHIC' (ISAM) FILE HANDLER.
002500*        TPSIO100 IS 'REPRT' (ISAM) FILE HANDLER.
002600*
002700  01  GUISCREEN               PIC X(8) VALUE 'GS      '.
002700* 01  SCREENIO                PIC X(8) VALUE 'SCRNIO'.
002800  01  TPSDATES                PIC X(8) VALUE 'TPSDATES'.
002900  01  TPSIOERR                PIC X(8) VALUE 'TPSIOERR'.
003000  01  TPSSTATE                PIC X(8) VALUE 'TPSSTATE'.
003100
003200  01  TPSIO014                PIC X(8) VALUE 'TPSIO014'.
003300  01  TPSIO100                PIC X(8) VALUE 'TPSIO100'.
003300  01  TPS4010                 PIC X(8) VALUE 'TPS4010'.
003400*
003500  COPY KEYVALUE.CPY.
003600  COPY TPSBROWS.CPY.
003700  COPY TPSFILES.CPY.
003800
003900 01  VS.
004000  COPY TPSVEHIC.CPY.
004100
004200 01  RS2.
004300  COPY TPSREPRT.CPY.
004100
004300  COPY CALEVENT.CPY.
004200 01  LS-RECVE.
004300  COPY TPSMAIL.CPY.
004400



004600*
004700* ------------------------: Miscellaneous working fields.
004800*
004900  01  WS-TODAYS-DATE-YMD         PIC  9(06).
005000*
005100  01  WS-TODAYS-DATE-CYMD        PIC  9(08).
005200*
005300  01  REGIS-CHANGE               PIC X(01)  VALUE 'N'.
005300  01  INSP-CHANGE                PIC X(01)  VALUE 'N'.
005300  01  WRRN-CHANGE                PIC X(01)  VALUE 'N'.
005100  01  OLD-REGIS-DATE             PIC 9(08).
005100  01  NEW-REGIS-DATE             PIC 9(08).
005100  01  OLD-INSP-DATE              PIC 9(08).
005100  01  NEW-INSP-DATE              PIC 9(08).
005100  01  OLD-WRRN-DATE              PIC 9(08).
005100  01  NEW-WRRN-DATE              PIC 9(08).
005300  01  MOVE-BYTES                 PIC 9(03)  VALUE 0.
005300  01  TABLE-SUB                  PIC 9(02)  VALUE 0.
005300  01  WS-LINE-NO                 PIC 9(02)  VALUE 0.
005300  01  WS-NEW-ACCT                PIC 9(01)  VALUE 0.
005300  01  SCREEN-DISPLAY-OPTION      PIC 9  VALUE 0.
005300  01  DISPLAY-FILE-ACTION        PIC 99.
005400  01  FUNCTION-15                PIC S9(4) COMP-5 VALUE 15.
005200*
005400*08/08VHCL-TABLE                 PIC X(832).
005400  01  VHCL-TABLE                 PIC X(845).
024651  01  VHCL-TABLE-ENTRIES REDEFINES VHCL-TABLE.
024653      05 TABLE-DATA OCCURS 13 TIMES.
024653         10 TABLE-LINE           PIC 9(02).
024653         10 TABLE-DELETE         PIC X(01).
024653         10 TABLE-YEAR           PIC X(04).
024653         10 TABLE-MAKE           PIC X(20).
024655         10 TABLE-MODEL          PIC X(20).
024657         10 TABLE-COLOR          PIC X(08).
024661         10 TABLE-PLATE-NUMBER   PIC X(08).
024663         10 TABLE-PLATE-STATE    PIC X(02).
024653  01 TABLE-DATA-1 OCCURS 13 TIMES.
024653     05 TABLE-VHCL-NO            PIC 9(02).
005500*
005600  01  WS-DATE-REQUEST.
005700      05  WS-DATE-PARAM          PIC  9(02).
005800*
005900      05  WS-DATE-TENBYTES       PIC  X(10) VALUE SPACES.
006000*
006100      05  FILLER REDEFINES WS-DATE-TENBYTES.
006200          10  WS-DATE-REFORM         PIC  X(06).
006300          10  WS-DATE-EXTEND         PIC  X(04).
006400*
006500      05  FILLER REDEFINES WS-DATE-TENBYTES.
006600          10  WS-DATE-REFORM-LEN06   PIC  X(06).
006700          10  FILLER                 PIC  X(04).
006800*
006900      05  FILLER REDEFINES WS-DATE-TENBYTES.
007000          10  WS-DATE-REFORM-LEN08   PIC  X(08).
007100          10  FILLER                 PIC  X(02).
007200*
007300      05  FILLER REDEFINES WS-DATE-TENBYTES.
007400          10  WS-DATE-REFORM-LEN10   PIC  X(10).
007500*
007600      05  WS-ADMIN-ACCOUNT-NUMBER   PIC  9(10).
007700*
007800      05  WS-NEW-CLIENT-ACCOUNT-NUMBER  PIC  9(10).
007900      05  FILLER REDEFINES  WS-NEW-CLIENT-ACCOUNT-NUMBER.
008000           10  WS-BRANCH-NUMBER-NEW     PIC  9(02).
008100           10  WS-ADMIN-NUMBER-NEW      PIC  9(02).
008200           10  WS-CLIENT-NUMBER-NEW     PIC  9(05).
008300           10  WS-CHECK-DIGIT-NEW       PIC  9(01).
008400*
008800      05  WS-ADMIN-LOGON            PIC  X(10).
008900      05  WS-ADMIN-BRANCH           PIC  X(02).
009000      05  DOC-INDEX                 PIC S9(04) COMP.
009100
009200      05  WS-VHCL-SUB-ACCT          PIC  9(02) VALUE 0.
009300      05  WS-VHCL-NUMBER            PIC  9(02) VALUE 0.
009400
009500      05 WS-ZIP-CODE            PIC  X(09).
009600      05 FILLER REDEFINES WS-ZIP-CODE.
009700         10 WS-ZIP-FIRST-FIVE   PIC  X(05).
009800         10 WS-ZIP-SECOND-FOUR  PIC  X(04).
009900      05 FILLER REDEFINES WS-ZIP-CODE.
010000         10 WS-ZIP-FIRST-FOUR   PIC  X(04).
010100         10 WS-ZIP-SECOND-FIVE  PIC  X(05).
010200      05 FILLER REDEFINES WS-ZIP-CODE.
010300         10 WS-ZIP-FIRST-THREE  PIC  X(03).
010400         10 WS-ZIP-THE-REST     PIC  X(06).
010500
010600      05 WS-FIX-ZIP             PIC  X(09).
010700      05 FILLER REDEFINES WS-FIX-ZIP.
010800         10 WS-FIX-ZIP-FIRST-FIVE  PIC  X(05).
010900         10 WS-FIX-ZIP-SECOND-FOUR PIC  X(04).
011000
011100      05 LS-ZIP-THREE           PIC  X(03).
011200      05 FILLER REDEFINES LS-ZIP-THREE.
011300         10 LS-ZIP-FLAG         PIC  X(01).
011400         10 LS-ZIP-STATE        PIC  X(02).
011500*
011600      05 WHEN-IS-ZIP            PIC  9(01) VALUE 0.
011700           88 NOT-SO-HOT               VALUE 1.
011800*
011900      05  TPSVEHIC-FLAG             PIC  9(01) VALUE 0.
012000               88  TPSVEHIC-OPEN          VALUE 1.
012100      05  TPSREPRT-FLAG             PIC  9(01) VALUE 0.
012200               88  TPSREPRT-OPEN          VALUE 1.
012200*05/18/00                                                                                     
015410      05  PAGE-OVERFLO-FLAG         PIC  9(01) VALUE 0.                                       
015410               88 PAGE-OVERFLO                 VALUE 1.                                       
012200                                                                                              
012300*
012400      05  HOT-FIELD-KEY-CHECK       PIC  9(01) VALUE 0.
012500               88  PFKEY-NG               VALUE 1.
012600*
012700 LINKAGE SECTION.
012800 01  LS.
012900  COPY TPSLOGON.CPY.
013000
013100 01  AD.
013200  COPY TPSADMIN.CPY.
013300
013400 01  PS.
013500  COPY TPSPROFL.CPY.
013600*
013630 01  LINK-PARMS.
013640      05  PARMS                       PIC  X(250).
013650      05  FILLER REDEFINES PARMS.
013660          10  PARM01                  PIC  9(12).
013660          10  FILLER REDEFINES PARM01.
013670              15 PARM01-ACCOUNT-NUMBER  PIC  9(10).
013670              15 PARM01-SUB-ACCT        PIC  9(02).
013670          10  PARM02                  PIC  9(01).
013680              88  PARM02-NEW-ACCT                VALUE 1.
013690          10  PARM03                  PIC  9(01).
013691              88  PARM03-MAINT-ACCT              VALUE 1.
013692          10  PARM04                  PIC  9(01).
013692              88  PARM04-DELETE-ACCT             VALUE 1.
013693          10  PARM05                  PIC  9(01).
013692              88  PARM05-UNDELETE-ACCT           VALUE 1.
013694          10  PARM06                  PIC  9(01).
013695          10  PARM07                  PIC  9(01).
013696          10  PARM08                  PIC  9(01).
013697          10  PARM09                  PIC  9(01).
013698          10  PARM10                  PIC  9(01).
013699          10  FILLER                  PIC  X(231).
013700
       01 CURRENT-XY-PARAMETERS PIC 9(08).

013800 PROCEDURE DIVISION USING LS
                                AD
                                PS
                                LINK-PARMS
                                CURRENT-XY-PARAMETERS.
013900*                 
014000 0001-BEGIN.

      *********** INITIALIZE WINFORMS SCREENS **********

       set TPS0040A to new TPS000.TPS0040AForm().
       set TPS0045 to new TPS000.TPS0045Form().
       set TPS0350 to new TPS000.TPS0350Form().
       set TPS0351 to new TPS000.TPS0351Form().

      **************************************************     
           MOVE CURRENT-XY-PARAMETERS(1:4) TO WS-CURRENT-X
                                              WS-X-PARM.
           MOVE CURRENT-XY-PARAMETERS(5:4) TO WS-CURRENT-Y
                                              WS-Y-PARM.

014200      ACCEPT WS-TODAYS-DATE-YMD FROM DATE.
014300*
014400      MOVE 01                   TO WS-DATE-PARAM.
014500      MOVE WS-TODAYS-DATE-YMD   TO WS-DATE-REFORM.
014600      MOVE SPACES               TO WS-DATE-EXTEND.
014700*
014800      CALL TPSDATES USING WS-DATE-REQUEST.
014900*
015000      MOVE WS-DATE-REFORM-LEN08 TO WS-TODAYS-DATE-CYMD.
015100*
015200      MOVE CLNT-PROFILE-ACCT-NO OF PS TO
015300                                WS-ADMIN-ACCOUNT-NUMBER.
015400
020100******** DISPLAY POPUP WINDOW TO CHOOSE VEHICLE ********

015410      IF PARM02-NEW-ACCT
021400         MOVE 'ENTER TO PROCESS DATA OR END TO BYPASS'
021500                                TO TPS0040A::MENU-LINE
021400      ELSE
021400         MOVE 'HIT ENTER TO PROCESS DATA OR END KEY TO GO BACK'
021500                                TO TPS0040A::MENU-LINE.
015410      PERFORM 0050-DISPLAY-POPUP THRU 0050-EXIT.
015400
015410      IF PARM02-NEW-ACCT

021400         MOVE 'ENTER TO PROCESS DATA OR END TO BYPASS'
021500                             TO TPS0351::MENU-LINE
035300         MOVE 1              TO WS-NEW-ACCT
035300         GO TO CLEAR-PANEL-TPS0351
035300      ELSE
021400         MOVE 'ENTER TO PROCESS DATA OR END KEY TO GO BACK'
021500                             TO TPS0351::MENU-LINE.
015400
015410      IF PARM03-MAINT-ACCT OR PARM04-DELETE-ACCT OR
015410           PARM05-UNDELETE-ACCT
               PERFORM VARYING TPS0350-IDX FROM 1 BY 1 
                       UNTIL TPS0350-IDX > 13
                       MOVE ZEROES TO TPS0350-LINE-NUMBER(TPS0350-IDX)
                                      TABLE-LINE(TPS0350-IDX)
                                      TPS0350-YEAR(TPS0350-IDX)
                                      TABLE-YEAR(TPS0350-IDX)
                       MOVE SPACES TO TPS0350-DELETE-FLAG(TPS0350-IDX)
                                      TABLE-DELETE(TPS0350-IDX)
                                      TPS0350-MAKE(TPS0350-IDX)
                                      TABLE-MAKE(TPS0350-IDX)
                                      TPS0350-MODEL(TPS0350-IDX)
                                      TABLE-MODEL(TPS0350-IDX)
                                      TPS0350-COLOR(TPS0350-IDX)
                                      TABLE-COLOR(TPS0350-IDX)
                                      TPS0350-PLATE-NUMBER(TPS0350-IDX)
                                      TABLE-PLATE-NUMBER(TPS0350-IDX)
                                      TPS0350-PLATE-STATE(TPS0350-IDX)
                                      TABLE-PLATE-STATE(TPS0350-IDX)
               END-PERFORM
               MOVE ZEROES TO TPS0350::LINE-SELECT.
                                      
024633         MOVE PARM01-ACCOUNT-NUMBER   TO VHCL-ACCT-NO
024634         MOVE PARM01-SUB-ACCT         TO VHCL-SUB-ACCT
015410         MOVE TPS0040A::VEHIC-TYPE   TO VHCL-TYPE
015410         MOVE 1                       TO VHCL-NUMBER
015410                                         TABLE-SUB
015410         MOVE 0                       TO PAGE-OVERFLO-FLAG
015410         PERFORM 2100-FILL-VHCL-TABLE THRU 2100-EXIT
015410         PERFORM 2200-MOVE-VHCL-TABLE THRU 2200-EXIT
024633         MOVE PARM01-ACCOUNT-NUMBER   TO VHCL-ACCT-NO
024634         MOVE PARM01-SUB-ACCT         TO VHCL-SUB-ACCT
015410         MOVE TPS0040A::VEHIC-TYPE   TO VHCL-TYPE
015420         MOVE TABLE-VHCL-NO(TABLE-SUB) TO VHCL-NUMBER
015410         MOVE 0           TO TPS0350::LINE-SELECT
021300         MOVE 1           TO SCREEN-DISPLAY-OPTION
021400         MOVE 'HIT ENTER TO PROCESS SELECTION OR END KEY'
021500                          TO TPS0350::MENU-LINE.
021300
021300 0010-DISPLAY-TPS0350.

           MOVE 0 TO TPS0350-IDX.
           PERFORM VARYING THE-IDX FROM 1 BY 1
             UNTIL THE-IDX > 13
               MOVE TPS0350-LINE-NUMBER(THE-IDX) TO
                 TPS0350::LINE-NUMBER(TPS0350-IDX)
               MOVE TPS0350-DELETE-FLAG(THE-IDX) TO
                 TPS0350::DELETE-FLAG(TPS0350-IDX)
               MOVE TPS0350-YEAR(THE-IDX) TO
                 TPS0350::YEAR(TPS0350-IDX)
               MOVE TPS0350-MAKE(THE-IDX) TO
                 TPS0350::MAKE(TPS0350-IDX)
               MOVE TPS0350-MODEL(THE-IDX) TO
                 TPS0350::MODEL(TPS0350-IDX)
               MOVE TPS0350-COLOR(THE-IDX) TO
                 TPS0350::COLOR(TPS0350-IDX)
               MOVE TPS0350-PLATE-NUMBER(THE-IDX) TO
                 TPS0350::PLATE-NUMBER(TPS0350-IDX)
               MOVE TPS0350-PLATE-STATE(THE-IDX) TO
                 TPS0350::PLATE-STATE(TPS0350-IDX)
               COMPUTE TPS0350-IDX = TPS0350-IDX + 1
           END-PERFORM.

           SET TPS0350::X-POINT TO WS-X-PARM.
           SET TPS0350::Y-POINT TO WS-Y-PARM.
           INVOKE TPS0350::ShowDialog.
           MOVE TPS0350::Location::X TO WS-X-PARM
                                        WS-CURRENT-X.
           MOVE TPS0350::Location::Y TO WS-Y-PARM
                                        WS-CURRENT-Y.
           MOVE TPS0350::SCREEN-NAME TO SCREEN-NAME.

035100
021800      IF TPS0350::KEY-PRESSED = "End Key"
021900          GO TO EXIT-FROM-MODULE.
035100
035100*05/18/00                                                                                     
021800      IF TPS0350::KEY-PRESSED = "Page Down Key"                   
015410         IF PAGE-OVERFLO                                                                      
015410            MOVE 1                       TO TABLE-SUB                                         
                  PERFORM VARYING TPS0350-IDX FROM 1 BY 1
                          UNTIL TPS0350-IDX > 13
                       MOVE ZEROES TO TPS0350-LINE-NUMBER(TPS0350-IDX)
                                      TABLE-LINE(TPS0350-IDX)
                                      TPS0350-YEAR(TPS0350-IDX)
                                      TABLE-YEAR(TPS0350-IDX)
                       MOVE SPACES TO TPS0350-DELETE-FLAG(TPS0350-IDX)
                                      TABLE-DELETE(TPS0350-IDX)
                                      TPS0350-MAKE(TPS0350-IDX)
                                      TABLE-MAKE(TPS0350-IDX)
                                      TPS0350-MODEL(TPS0350-IDX)
                                      TABLE-MODEL(TPS0350-IDX)
                                      TPS0350-COLOR(TPS0350-IDX)
                                      TABLE-COLOR(TPS0350-IDX)
                                      TPS0350-PLATE-NUMBER(TPS0350-IDX)
                                      TABLE-PLATE-NUMBER(TPS0350-IDX)
                                      TPS0350-PLATE-STATE(TPS0350-IDX)
                                      TABLE-PLATE-STATE(TPS0350-IDX)

                   END-PERFORM
015410            ADD 1                        TO VHCL-NUMBER                                       
015410            PERFORM 2100-FILL-VHCL-TABLE THRU 2100-EXIT                                       
015410            PERFORM 2200-MOVE-VHCL-TABLE THRU 2200-EXIT                                       
024633            MOVE PARM01-ACCOUNT-NUMBER   TO VHCL-ACCT-NO                                      
024634            MOVE PARM01-SUB-ACCT         TO VHCL-SUB-ACCT                                     
015410            MOVE TPS0040A::VEHIC-TYPE   TO VHCL-TYPE                                        
015420            MOVE TABLE-VHCL-NO(TABLE-SUB) TO VHCL-NUMBER                                      
015410            MOVE 0           TO TPS0350::LINE-SELECT                                       
021300            MOVE 1           TO SCREEN-DISPLAY-OPTION                                         
021400            MOVE 'HIT ENTER TO PROCESS SELECTION OR END KEY'                                  
021500                             TO TPS0350::MENU-LINE
021300            GO TO 0010-DISPLAY-TPS0350                                                        
                END-IF                                                                              
             END-IF.                                                                                
035100
035100
035100
035100
021800*06/02IF TPS0350::LINE-SELECT < 1 OR > 13
021800      IF TPS0350::LINE-SELECT < 1           
015410         MOVE 0           TO TPS0350::LINE-SELECT
021400         MOVE 'INVALID SELECTION..... TRY AGAIN'
021500                          TO TPS0350::MENU-LINE
021900         GO TO 0010-DISPLAY-TPS0350.
015400
015410      IF PARM04-DELETE-ACCT AND NOT LOGREC-ACCESS-LEVEL04
035300         MOVE 1                TO SCREEN-DISPLAY-OPTION
035300         MOVE 'NOT AUTHORIZED TO DELETE RECORD, HIT END KEY'
035400                               TO TPS0351::MENU-LINE
               MOVE TPS0351-YEAR TO TPS0351::YEAR
               MOVE TPS0351-REGISTER-EXPIRE TO
                    TPS0351::REGISTER-EXPIRE
               MOVE TPS0351-INSPECT-EXPIRE TO
                    TPS0351::INSPECT-EXPIRE
               MOVE TPS0351-WARRANTY-EXPIRE TO 
                    TPS0351::WARRANTY-EXPIRE
               MOVE TPS0351-SALES-PERSON-PHONE TO 
                    TPS0351::SALES-PERSON-PHONE
               MOVE TPS0351-SERVICE-PERSON-PHONE TO
                    TPS0351::SERVICE-PERSON-PHONE
               SET TPS0351::X-POINT TO WS-X-PARM
               SET TPS0351::Y-POINT TO WS-Y-PARM
               INVOKE TPS0351::ShowDialog
               MOVE TPS0351::Location::X TO WS-X-PARM
                                            WS-CURRENT-X
               MOVE TPS0351::Location::Y TO WS-Y-PARM
                                           WS-CURRENT-Y
              MOVE TPS0351::SCREEN-NAME TO SCREEN-NAME
               MOVE TPS0351::YEAR TO TPS0351-YEAR
               MOVE TPS0351::REGISTER-EXPIRE TO
                 TPS0351-REGISTER-EXPIRE
               MOVE TPS0351::INSPECT-EXPIRE TO
                 TPS0351-INSPECT-EXPIRE
               MOVE TPS0351::WARRANTY-EXPIRE TO
                 TPS0351-WARRANTY-EXPIRE
               MOVE TPS0351::SALES-PERSON-PHONE TO
                 TPS0351-SALES-PERSON-PHONE
               MOVE TPS0351::SERVICE-PERSON-PHONE TO
                 TPS0351-SERVICE-PERSON-PHONE

015430         GO TO EXIT-FROM-MODULE
           END-IF.
015400
015410      IF PARM04-DELETE-ACCT
015420         MOVE TABLE-VHCL-NO(TPS0350::LINE-SELECT) TO VHCL-NUMBER
015420         PERFORM 2000-READ-RECORD THRU 2000-EXIT
035300         MOVE 1          TO SCREEN-DISPLAY-OPTION
035300         MOVE 'ENTER TO CONFIRM DELETE OR END KEY TO GO BACK'
035400                         TO TPS0351::MENU-LINE
                                  TPS0351::MENU-LINE
015430         GO TO 1000-DISPLAY-PANEL-TPS0351.
015400
015410      IF TPS0350::LINE-SELECT > TABLE-SUB
015420         MOVE 2          TO WS-NEW-ACCT
035300         MOVE ZERO       TO PARM03
035300         MOVE 1          TO PARM02
035300         GO TO CLEAR-PANEL-TPS0351.
015400
015410      IF PARM03-MAINT-ACCT
015420         MOVE TABLE-VHCL-NO(TPS0350::LINE-SELECT) TO VHCL-NUMBER
015420         PERFORM 2000-READ-RECORD THRU 2000-EXIT
015430         MOVE 1          TO SCREEN-DISPLAY-OPTION
               GO TO 1000-DISPLAY-PANEL-TPS0351.
015400
015410      IF PARM05-UNDELETE-ACCT AND NOT LOGREC-ACCESS-LEVEL04
035300         MOVE 1                TO SCREEN-DISPLAY-OPTION
035300         MOVE 'NOT AUTHORIZED TO RESTORE RECORD, HIT END KEY'
035400                               TO TPS0351::MENU-LINE
                                        TPS0351::MENU-LINE
               MOVE TPS0351-YEAR TO TPS0351::YEAR
               MOVE TPS0351-REGISTER-EXPIRE TO
                 TPS0351::REGISTER-EXPIRE
               MOVE TPS0351-INSPECT-EXPIRE TO
                 TPS0351::INSPECT-EXPIRE
               MOVE TPS0351-WARRANTY-EXPIRE TO
                 TPS0351::WARRANTY-EXPIRE
               MOVE TPS0351-SALES-PERSON-PHONE TO
                 TPS0351::SALES-PERSON-PHONE
               MOVE TPS0351-SERVICE-PERSON-PHONE TO
                 TPS0351::SERVICE-PERSON-PHONE
               SET TPS0351::X-POINT TO WS-X-PARM
               SET TPS0351::Y-POINT TO WS-Y-PARM
               INVOKE TPS0351::ShowDialog
               MOVE TPS0351::YEAR TO TPS0351-YEAR
               MOVE TPS0351::Location::X TO WS-X-PARM
                 WS-CURRENT-X
               MOVE TPS0351::Location::Y TO WS-Y-PARM
                 WS-CURRENT-Y
               MOVE TPS0351::SCREEN-NAME TO SCREEN-NAME
               MOVE TPS0351::REGISTER-EXPIRE TO
                 TPS0351-REGISTER-EXPIRE
               MOVE TPS0351::INSPECT-EXPIRE TO
                 TPS0351-INSPECT-EXPIRE
               MOVE TPS0351::WARRANTY-EXPIRE TO
                 TPS0351-WARRANTY-EXPIRE
               MOVE TPS0351::SALES-PERSON-PHONE TO
                 TPS0351-SALES-PERSON-PHONE
               MOVE TPS0351::SERVICE-PERSON-PHONE TO
                 TPS0351-SERVICE-PERSON-PHONE

015430         GO TO EXIT-FROM-MODULE
           END-IF.
015400
015410      IF PARM05-UNDELETE-ACCT
015420         MOVE TABLE-VHCL-NO(TPS0350::LINE-SELECT) TO VHCL-NUMBER
015420         PERFORM 2000-READ-RECORD THRU 2000-EXIT
035300         MOVE 1          TO SCREEN-DISPLAY-OPTION
035300         MOVE 'ENTER TO CONFIRM RESTORE OR END KEY TO GO BACK'
035400                         TO TPS0351::MENU-LINE
                                  TPS0351::MENU-LINE
015430         GO TO 1000-DISPLAY-PANEL-TPS0351.
015400
015510 0050-DISPLAY-POPUP.

           MOVE 1 TO TPS0045::SPLASH-SCREEN-FLAG.
           IF TPS0045-DISPLAY-FLAG = 0
               SET TPS0045::X-POINT TO WS-X-PARM
               SET TPS0045::Y-POINT TO WS-Y-PARM
               SET TPS0045::Width TO 1
               SET TPS0045::Height TO 1
               INVOKE TPS0045::Show
               SET TPS0045::Width TO 1212
               SET TPS0045::Height TO 799
               INVOKE TPS0045::Show
               MOVE 1 TO TPS0045-DISPLAY-FLAG
           END-IF.
           MOVE 0 TO TPS0045::SPLASH-SCREEN-FLAG.

           SET TPS0040A::X-POINT TO WS-X-PARM.
           SET TPS0040A::Y-POINT TO WS-Y-PARM.
           INVOKE TPS0040A::ShowDialog.
           MOVE TPS0040A::SCREEN-NAME TO SCREEN-NAME.
           MOVE TPS0040A::Location::X TO WS-X-PARM
             WS-CURRENT-X.
           MOVE TPS0040A::Location::Y TO WS-Y-PARM
             WS-CURRENT-Y.


035100
021800      IF TPS0040A::KEY-PRESSED = "End Key"
               INVOKE TPS0045::Hide
               MOVE 0 TO TPS0045-DISPLAY-FLAG
021900          GO TO EXIT-FROM-MODULE.
021700
015410      IF TPS0040A::VEHIC-TYPE < 1 OR > 10
021400      MOVE 'INVALID SELECTION..... TRY AGAIN'
021500                             TO TPS0040A::MENU-LINE
021600      GO TO 0050-DISPLAY-POPUP.

           INVOKE TPS0045::Hide.
           MOVE 0 TO TPS0045-DISPLAY-FLAG.

035100
015510 0050-EXIT.    EXIT.
015600
015400
015510 CLEAR-PANEL-TPS0351.
015600
015700           MOVE SPACES TO
015800                TPS0351::MAKE
015900                TPS0351::MODEL
                      TPS0351::COLOR
016100                TPS0351::VIN
016200                TPS0351::PLATE-NUMBER
016300                TPS0351::PLATE-STATE
016400                TPS0351::STEREO-CODE
016500                TPS0351::KEYLESS-DOOR-CODE
016600                TPS0351::ALARM-CODE1
016700                TPS0351::ALARM-CODE2
016800                TPS0351::KEY-CODE-IGNITION
016900                TPS0351::KEY-CODE-DOORS
017000                TPS0351::LUG-LOCK-NUMBER
017100                TPS0351::DEALER-SHIP
017200                TPS0351::SALES-PERSON
017300                TPS0351::SERVICE-PERSON
017400                TPS0351::TITLE-ATTPS
017500                TPS0351::LEASE-ATTPS
017600                TPS0351::LIEN-ATTPS
017700                TPS0351::MAINTEN-ATTPS.
017800                              
017900           MOVE ZERO TO
018000                TPS0351-YEAR
018100                TPS0351-REGISTER-EXPIRE
018200                TPS0351-INSPECT-EXPIRE
018300                TPS0351-WARRANTY-EXPIRE
018400                TPS0351-SALES-PERSON-PHONE
018500                TPS0351-SERVICE-PERSON-PHONE.
018600
018700**    IF WS-NEW-ACCT = 2
015410      IF PARM02-NEW-ACCT
018700         MOVE 5                 TO TPS0351::ACTIVE-FIELD
021400       MOVE 'HIT ENTER TO PROCESS DATA OR END KEY TO GO BACK'
021500                                   TO TPS0351::MENU-LINE
                                            TPS0351::MENU-LINE
018700      ELSE
018700         MOVE 5                TO TPS0351::ACTIVE-FIELD
        
            END-IF.
          
 
019000 1000-DISPLAY-PANEL-TPS0351.
       
     
019100
019200      MOVE CLNT-PROFILE-ACCT-NO    TO
019300                                TPS0351::CLNT-ACCT-NUM.
019400      MOVE CLNT-PROFILE-LAST-NAME  TO
019500                                TPS0351::CLNT-LAST-NAME.
019600      MOVE CLNT-PROFILE-FIRST-NAME TO
019700                                TPS0351::CLNT-FIRST-NAME.
019800      MOVE CLNT-PROFILE-MDDL-INIT  TO
019900                                TPS0351::CLNT-MIDDLE-INIT.

           MOVE TPS0351-YEAR TO TPS0351::YEAR.
           MOVE TPS0351-REGISTER-EXPIRE TO
             TPS0351::REGISTER-EXPIRE.
           MOVE TPS0351-INSPECT-EXPIRE TO
             TPS0351::INSPECT-EXPIRE.
           MOVE TPS0351-WARRANTY-EXPIRE TO
             TPS0351::WARRANTY-EXPIRE.
           MOVE TPS0351-SALES-PERSON-PHONE TO
             TPS0351::SALES-PERSON-PHONE.
           MOVE TPS0351-SERVICE-PERSON-PHONE TO
             TPS0351::SERVICE-PERSON-PHONE.
           SET TPS0351::X-POINT TO WS-X-PARM.
           SET TPS0351::Y-POINT TO WS-Y-PARM.
           INVOKE TPS0351::ShowDialog.
           MOVE TPS0351::YEAR TO TPS0351-YEAR.
           MOVE TPS0351::Location::X TO WS-X-PARM
             WS-CURRENT-X.
           MOVE TPS0351::Location::Y TO WS-Y-PARM
             WS-CURRENT-Y.
           MOVE TPS0351::SCREEN-NAME TO SCREEN-NAME
           MOVE TPS0351::REGISTER-EXPIRE TO
             TPS0351-REGISTER-EXPIRE.
           MOVE TPS0351::INSPECT-EXPIRE TO
             TPS0351-INSPECT-EXPIRE.
           MOVE TPS0351::WARRANTY-EXPIRE TO
             TPS0351-WARRANTY-EXPIRE.
           MOVE TPS0351::SALES-PERSON-PHONE TO
             TPS0351-SALES-PERSON-PHONE.
           MOVE TPS0351::SERVICE-PERSON-PHONE TO
             TPS0351-SERVICE-PERSON-PHONE.



                                 
021800      IF TPS0351::KEY-PRESSED = "End Key"
021900          GO TO EXIT-FROM-MODULE.                                 
020700
020800      IF TPS0351::HOT-FIELD = 1010
020900          GO TO VALIDATE-TPS0351-STATE.
021000
015410      IF PARM04-DELETE-ACCT
015420         PERFORM 4000-DELETE-RECORD THRU 4000-EXIT.
021700
015410      IF PARM05-UNDELETE-ACCT
015420         PERFORM 5000-UNDELETE-RECORD THRU 5000-EXIT.
015400
022000      IF TPS0351::KEY-PRESSED = "Enter Key" AND
                PARM02 = 1
022100          GO TO 3000-ACCEPT-TPS0351-DATA.
022100
022110      IF TPS0351::KEY-PRESSED = "Enter Key"  AND
               PARM03 = 1 AND
021300         SCREEN-DISPLAY-OPTION  = 1
021300          MOVE 2             TO SCREEN-DISPLAY-OPTION
021400          MOVE 'HIT ENTER TO CONFIRM CHANGES' TO
021500                                   TPS0351::MENU-LINE
021600          GO TO 1000-DISPLAY-PANEL-TPS0351.
021600
022000      IF TPS0351::KEY-PRESSED = "Enter Key"  AND
               PARM03 = 1 AND
021300         SCREEN-DISPLAY-OPTION  = 2
022100          GO TO 3000-ACCEPT-TPS0351-DATA.
022200
022200      GO TO 1000-DISPLAY-PANEL-TPS0351.
022300
022400 VALIDATE-TPS0351-STATE.
022500
022600      MOVE 'A'                     TO WS-ZIP-FIRST-THREE(1:1).
022700      MOVE TPS0351::PLATE-STATE     TO WS-ZIP-FIRST-THREE(2:2).
022800
022900      PERFORM 8900-STATE-CODE-CONVERT THRU
023000              8900-STATE-CODE-CONVERT-EXIT.
023100
023200      IF LS-ZIP-FLAG = '0'
023300          MOVE 012              TO TPS0351::ACTIVE-FIELD
023500      GO TO 1000-DISPLAY-PANEL-TPS0351.
023600
023200      IF LS-ZIP-FLAG = '1' AND  TPS0351::PLATE-STATE = SPACES
023300         MOVE 012              TO TPS0351::ACTIVE-FIELD
023500         GO TO 1000-DISPLAY-PANEL-TPS0351
023500      ELSE
023800         MOVE SPACES            TO TPS0351::PLATE-STATE
023900         MOVE 009            TO TPS0351::ACTIVE-FIELD
024200         MOVE 'INVALID STATE CODE ENTERED' TO
024300                                   TPS0351::MENU-LINE
024400         GO TO 1000-DISPLAY-PANEL-TPS0351.
024500
024600 2000-READ-RECORD.
024610
024622      IF NOT TPSVEHIC-OPEN
024623         MOVE 1                    TO TPSVEHIC-FLAG
024624         SET FR-OPEN-I-O TO TRUE
024625         CALL TPSIO014 USING FILE-REQUEST VS
024627         IF FILE-STATUS NOT = '00' AND '05'
024628            MOVE 'VEHIC' TO FILE-NAME
024629            MOVE 'TPS118-OPEN' TO FILE-TEXT
024630            PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
024631            GO TO EXIT-FROM-MODULE.
024632
024637      SET FR-READ  TO TRUE
024638      CALL TPSIO014 USING FILE-REQUEST VS.
024639
024640      IF NO-RECORD-WAS-FOUND
015420           MOVE 2                  TO SCREEN-DISPLAY-OPTION
024642           MOVE 'RECORD NOT FOUND, HIT END KEY'
024642                                   TO TPS0351::MENU-LINE
024400           GO TO 1000-DISPLAY-PANEL-TPS0351
024643      ELSE
024640      IF NOT A-SUCCESSFUL-OPERATION
024641           MOVE 'VEHIC' TO FILE-NAME
024642           MOVE 'TPS118-READ ' TO FILE-TEXT
024643           PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
024644           GO TO EXIT-FROM-MODULE.
024645
024646      MOVE VHCL-ACCT-NO  TO TPS0351::CLNT-ACCT-NUM.
024651      MOVE VHCL-YEAR             TO TPS0351-YEAR.
024653      MOVE VHCL-MAKE             TO TPS0351::MAKE.
024655      MOVE VHCL-MODEL            TO TPS0351::MODEL.
024657      MOVE VHCL-COLOR            TO TPS0351::COLOR.
024659      MOVE VHCL-VIN              TO TPS0351::VIN.
024661      MOVE VHCL-PLATE-NUMBER     TO TPS0351::PLATE-NUMBER.
024663      MOVE VHCL-PLATE-STATE      TO TPS0351::PLATE-STATE.
024665      MOVE VHCL-SEC-STEREO-CODE  TO TPS0351::STEREO-CODE.
024667      MOVE VHCL-SEC-KEYLESS-ENTRY  TO
024669                                      TPS0351::KEYLESS-DOOR-CODE.
024670      MOVE VHCL-SEC-ALARM-CODE1  TO TPS0351::ALARM-CODE1.
024672      MOVE VHCL-SEC-ALARM-CODE2  TO TPS0351::ALARM-CODE2.
024674      MOVE VHCL-SEC-KEYCODE-IGNIT  TO
024676                                     TPS0351::KEY-CODE-IGNITION.
024677      MOVE VHCL-SEC-KEYCODE-DOORS  TO TPS0351::KEY-CODE-DOORS.
024679      MOVE VHCL-SEC-LUG-LOCK-NUMB  TO TPS0351::LUG-LOCK-NUMBER.
024682      MOVE VHCL-REGISTER-EXPIRE(3:6) TO
024682                                   WS-DATE-REFORM.
024682      MOVE 5                       TO WS-DATE-PARAM.
024682      MOVE SPACES                  TO WS-DATE-EXTEND.
024682      CALL TPSDATES USING WS-DATE-REQUEST.
024682      MOVE WS-DATE-REFORM-LEN06    TO TPS0351-REGISTER-EXPIRE.
024682      MOVE VHCL-INSPECT-EXPIRE(3:6) TO
024682                                   WS-DATE-REFORM.
024682      MOVE 5                       TO WS-DATE-PARAM.
024682      MOVE SPACES                  TO WS-DATE-EXTEND.
024682      CALL TPSDATES USING WS-DATE-REQUEST.
024682      MOVE WS-DATE-REFORM-LEN06    TO TPS0351-INSPECT-EXPIRE.
024682      MOVE VHCL-WRRNTY-EXPIRE(3:6) TO
024682                                   WS-DATE-REFORM.
024682      MOVE 5                       TO WS-DATE-PARAM.
024682      MOVE SPACES                  TO WS-DATE-EXTEND.
024682      CALL TPSDATES USING WS-DATE-REQUEST.
024682      MOVE WS-DATE-REFORM-LEN06    TO TPS0351-WARRANTY-EXPIRE.
024702      MOVE VHCL-DEALER-SHIP        TO TPS0351::DEALER-SHIP.
024704      MOVE VHCL-SALES-NAME         TO TPS0351::SALES-PERSON.
024706      MOVE VHCL-SALES-PHONE-NUM TO TPS0351-SALES-PERSON-PHONE.
024708      MOVE VHCL-SERV-NAME          TO TPS0351::SERVICE-PERSON.
024711      MOVE VHCL-SERV-PHONE-NUM     TO
024712                                TPS0351-SERVICE-PERSON-PHONE.
024713      MOVE VHCL-TITLE              TO TPS0351::TITLE-ATTPS.
024715      MOVE VHCL-LEASE              TO TPS0351::LEASE-ATTPS.
024716      MOVE TPS0351::LEASE-ATTPS       TO VHCL-LEASE.
024718      MOVE VHCL-MAINTAIN           TO TPS0351::MAINTEN-ATTPS.
024720
021400      MOVE 'ENTER TO PROCESS CHANGES OR END KEY TO GO BACK'
021500                                TO TPS0351::MENU-LINE.

024721
024722 2000-EXIT.   EXIT.
024500
024600 2100-FILL-VHCL-TABLE.
024622      IF NOT TPSVEHIC-OPEN
024623         MOVE 1                    TO TPSVEHIC-FLAG
024624         SET FR-OPEN-I-O TO TRUE
024625         CALL TPSIO014 USING FILE-REQUEST VS
024627         IF FILE-STATUS NOT = '00' AND '05'
024628            MOVE 'VEHIC' TO FILE-NAME
024629            MOVE 'TPS118-OPEN' TO FILE-TEXT
024630            PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
024631            GO TO EXIT-FROM-MODULE.
024639
024600 2100-READ.
024637      SET FR-READ       TO TRUE
024638      CALL TPSIO014 USING FILE-REQUEST VS.
024639
024639********** NO RECORDS FOR VEHICLE TYPE **************
024640      IF NO-RECORD-WAS-FOUND AND VHCL-NUMBER = 1
015420         MOVE 1          TO WS-NEW-ACCT
035300         MOVE ZERO       TO VHCL-NUMBER
015410                            TPS0350::LINE-SELECT
035300                            PARM03
035300         MOVE 1          TO PARM02
035300         MOVE 'NO RECORDS FOUND DO U WANT TO ADD RECORD' TO
035400                                   TPS0351::MENU-LINE
035500         GO TO CLEAR-PANEL-TPS0351.
024639
024639*05/18/00
024640      IF NO-RECORD-WAS-FOUND
015410         IF PAGE-OVERFLO                                                                      
015410            IF TABLE-SUB = 1                                                                  
021400               MOVE '  NO ADDITIONAL VEHICLES TO DISPLAY      '                               
021500                           TO TPS0350::MENU-LINE
021300               GO TO 0010-DISPLAY-TPS0350                                                     
                   END-IF                                                                           
                END-IF                                                                              
             END-IF.                                                                                
024639
024640      IF NO-RECORD-WAS-FOUND
024400         SUBTRACT 1         FROM TABLE-SUB
024400         IF TABLE-SUB = 0
024640            MOVE TPS0040A::VEHIC-TYPE TO VHCL-TYPE
015420            MOVE 1          TO WS-NEW-ACCT
035300            MOVE ZERO       TO VHCL-NUMBER
015410                               TPS0350::LINE-SELECT
035300                               PARM03
035300            MOVE 1          TO PARM02
035300            MOVE 'NO RECORDS FOUND DO U WANT TO ADD RECORD' TO
035400                                   TPS0351::MENU-LINE
                                         TPS0351::MENU-LINE
035500            GO TO CLEAR-PANEL-TPS0351
035500         ELSE
024400            GO TO 2100-EXIT.
024639
024640*08/08IF PARM05-UNDELETE-ACCT AND LOGREC-ACCESS-LEVEL04
024640*        NEXT SENTENCE
024640*     ELSE
024640*     IF VHCL-SYSADMIN-SETUP-DATE(1:1) = 8 OR 9
015410*        ADD 1                     TO VHCL-NUMBER
024640*        GO TO 2100-READ.
024643
024640      IF NOT A-SUCCESSFUL-OPERATION
024641           MOVE 'VEHIC' TO FILE-NAME
024642           MOVE 'TPS118-READ ' TO FILE-TEXT
024643           PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
024644           GO TO EXIT-FROM-MODULE.
024645
024622      MOVE TABLE-SUB             TO TABLE-LINE(TABLE-SUB).
024640      IF VHCL-SYSADMIN-SETUP-DATE(1:1) = 8 OR 9
024653         MOVE '*'                TO TABLE-DELETE(TABLE-SUB)                                                       
              ELSE
024653         MOVE ' '                TO TABLE-DELETE(TABLE-SUB)                                                       
             END-IF.
024651      MOVE VHCL-YEAR             TO TABLE-YEAR(TABLE-SUB).
024653      MOVE VHCL-MAKE             TO TABLE-MAKE(TABLE-SUB).
024655      MOVE VHCL-MODEL            TO TABLE-MODEL(TABLE-SUB).
024657      MOVE VHCL-COLOR            TO TABLE-COLOR(TABLE-SUB).
024661      MOVE VHCL-PLATE-NUMBER     TO TABLE-PLATE-NUMBER(TABLE-SUB).
024663      MOVE VHCL-PLATE-STATE      TO TABLE-PLATE-STATE(TABLE-SUB).
024663      MOVE VHCL-NUMBER           TO TABLE-VHCL-NO(TABLE-SUB).
024723
024723*05/18/00
024622      IF TABLE-SUB = 13
015410         MOVE 1                    TO PAGE-OVERFLO-FLAG                                       
021400         MOVE 'MORE VEHICLES ON NEXT SCREEN'
021500                                   TO TPS0350::MENU-LINE
024622         GO TO 2100-EXIT.
024723
024723
024622      ADD 1                        TO TABLE-SUB.
024622      IF TABLE-SUB > 13
021400         MOVE 'MORE VEHICLES ON NEXT SCREEN'
021500                                   TO TPS0350::MENU-LINE
024622         GO TO 2100-EXIT.
024610
015410      ADD 1                     TO VHCL-NUMBER.
024663      GO TO 2100-READ.
024723
024722 2100-EXIT.   EXIT.
024500
024600 2200-MOVE-VHCL-TABLE.
024610
019200      MOVE CLNT-PROFILE-ACCT-NO    TO
019300                                TPS0350::CLNT-ACCT-NUMB.
019400      MOVE CLNT-PROFILE-LAST-NAME  TO
019500                                TPS0350::CLNT-LAST-NAME.
019600      MOVE CLNT-PROFILE-FIRST-NAME TO
019700                                TPS0350::CLNT-FIRST-NAME.
019800      MOVE CLNT-PROFILE-MDDL-INIT  TO
019900                                TPS0350::CLNT-MIDDLE-INIT.
024622      COMPUTE MOVE-BYTES = TABLE-SUB * 64.
.
            PERFORM VARYING TPS0350-IDX FROM 1 BY 1
                    UNTIL TPS0350-IDX > 13
                    MOVE TABLE-LINE(TPS0350-IDX) TO
                         TPS0350-LINE-NUMBER(TPS0350-IDX)
                    MOVE TABLE-DELETE(TPS0350-IDX) TO
                         TPS0350-DELETE-FLAG(TPS0350-IDX)
                    MOVE TABLE-YEAR(TPS0350-IDX) TO
                         TPS0350-YEAR(TPS0350-IDX)
                    MOVE TABLE-MAKE(TPS0350-IDX) TO
                         TPS0350-MAKE(TPS0350-IDX)
                    MOVE TABLE-MODEL(TPS0350-IDX) TO
                         TPS0350-MODEL(TPS0350-IDX)
                    MOVE TABLE-COLOR(TPS0350-IDX) TO
                         TPS0350-COLOR(TPS0350-IDX)
                    MOVE TABLE-PLATE-NUMBER(TPS0350-IDX) TO
                         TPS0350-PLATE-NUMBER(TPS0350-IDX)
                    MOVE TABLE-PLATE-STATE(TPS0350-IDX) TO
                         TPS0350-PLATE-STATE(TPS0350-IDX)
           END-PERFORM.

024723
024722 2200-EXIT.   EXIT.
024500
024724 3000-ACCEPT-TPS0351-DATA.
024730
024800           MOVE PARM01-ACCOUNT-NUMBER    TO VHCL-ACCT-NO.
025000           MOVE PARM01-SUB-ACCT          TO VHCL-SUB-ACCT.
025100           IF VHCL-TYPE NOT NUMERIC
025100              MOVE 1                     TO VHCL-TYPE.
025100           IF TPS0040A::VEHIC-TYPE NOT = VHCL-TYPE
025100              MOVE TPS0040A::VEHIC-TYPE TO VHCL-TYPE
025100              MOVE 1                     TO WS-VHCL-NUMBER.
024800           IF WS-NEW-ACCT = 1
025100              ADD   1                    TO WS-VHCL-NUMBER
025200              MOVE WS-VHCL-NUMBER        TO VHCL-NUMBER.
024800           IF WS-NEW-ACCT = 2
024800              ADD 1                      TO VHCL-NUMBER.
025200
025200     IF PARM02-NEW-ACCT
025200        MOVE WS-TODAYS-DATE-CYMD  TO VHCL-SYSADMIN-SETUP-DATE
025200        MOVE LOGREC-SIGN-ON OF LS TO VHCL-SYSADMIN-SETUP-PASSWORD.
025200     MOVE WS-TODAYS-DATE-CYMD   TO VHCL-SYSADMIN-CHANGE-DATE.
025200     MOVE LOGREC-SIGN-ON OF LS  TO VHCL-SYSADMIN-CHANGE-PASSWORD.
025200
025200           MOVE ZEROS                 TO VHCL-REGISTER-EXPIRE
025200                                         VHCL-INSPECT-EXPIRE
025200                                         VHCL-WRRNTY-EXPIRE.
025300           MOVE TPS0351-YEAR            TO VHCL-YEAR.
025400           MOVE TPS0351::MAKE            TO VHCL-MAKE.
025500           MOVE TPS0351::MODEL           TO VHCL-MODEL.
025600           MOVE TPS0351::COLOR           TO VHCL-COLOR.
025700           MOVE TPS0351::VIN             TO VHCL-VIN.
025800           MOVE TPS0351::PLATE-NUMBER    TO VHCL-PLATE-NUMBER.
025900           MOVE TPS0351::PLATE-STATE     TO VHCL-PLATE-STATE.
026000           MOVE TPS0351::STEREO-CODE     TO VHCL-SEC-STEREO-CODE.
026100           MOVE TPS0351::KEYLESS-DOOR-CODE TO
026200                                      VHCL-SEC-KEYLESS-ENTRY.
026300           MOVE TPS0351::ALARM-CODE1     TO VHCL-SEC-ALARM-CODE1.
026400           MOVE TPS0351::ALARM-CODE2     TO VHCL-SEC-ALARM-CODE2.
026500           MOVE TPS0351::KEY-CODE-IGNITION TO
026600                                      VHCL-SEC-KEYCODE-IGNIT.
026700           MOVE TPS0351::KEY-CODE-DOORS  TO 
                 VHCL-SEC-KEYCODE-DOORS.
026800           MOVE TPS0351::LUG-LOCK-NUMBER TO 
                 VHCL-SEC-LUG-LOCK-NUMB.
026900
027000           MOVE TPS0351-REGISTER-EXPIRE TO WS-DATE-REFORM.
027100           MOVE 11                   TO WS-DATE-PARAM.
027200           MOVE SPACES               TO WS-DATE-EXTEND.
027300           CALL TPSDATES USING WS-DATE-REQUEST.
027400           IF WS-DATE-REFORM-LEN08(3:6) = ZEROS
027400              NEXT SENTENCE
027400           ELSE
027400           IF WS-DATE-REFORM-LEN08 NOT = VHCL-REGISTER-EXPIRE
027400              IF PARM02 > 0
027400                 MOVE 'A'                  TO REGIS-CHANGE
027400              ELSE
027400                 MOVE 'M'                  TO REGIS-CHANGE
027400              END-IF
027400              MOVE WS-DATE-REFORM-LEN08 TO NEW-REGIS-DATE
027400              MOVE VHCL-REGISTER-EXPIRE TO OLD-REGIS-DATE.
027400           MOVE WS-DATE-REFORM-LEN08 TO VHCL-REGISTER-EXPIRE.
027500
027600           MOVE TPS0351-INSPECT-EXPIRE  TO WS-DATE-REFORM.
027700           MOVE 11                   TO WS-DATE-PARAM.
027800           MOVE SPACES               TO WS-DATE-EXTEND.
027900           CALL TPSDATES USING WS-DATE-REQUEST.
027400           IF WS-DATE-REFORM-LEN08(3:6) = ZEROS
027400              NEXT SENTENCE
027400           ELSE
027400           IF WS-DATE-REFORM-LEN08 NOT = VHCL-INSPECT-EXPIRE
027400              IF PARM02 > 0
027400                 MOVE 'A'                  TO INSP-CHANGE
027400              ELSE
027400                 MOVE 'M'                  TO INSP-CHANGE
027400              END-IF
027400              MOVE WS-DATE-REFORM-LEN08 TO NEW-INSP-DATE
027400              MOVE VHCL-INSPECT-EXPIRE  TO OLD-INSP-DATE.
028000           MOVE WS-DATE-REFORM-LEN08 TO VHCL-INSPECT-EXPIRE.
028100
028200           MOVE TPS0351-WARRANTY-EXPIRE TO WS-DATE-REFORM.
028300           MOVE 11                   TO WS-DATE-PARAM.
028400           MOVE SPACES               TO WS-DATE-EXTEND.
028500           CALL TPSDATES USING WS-DATE-REQUEST.
027400           IF WS-DATE-REFORM-LEN08(3:6) = ZEROS
027400              NEXT SENTENCE
027400           ELSE
027400           IF WS-DATE-REFORM-LEN08 NOT = VHCL-WRRNTY-EXPIRE
027400              IF PARM02 > 0
027400                 MOVE 'A'                  TO WRRN-CHANGE
027400              ELSE
027400                 MOVE 'M'                  TO WRRN-CHANGE
027400              END-IF
027400              MOVE WS-DATE-REFORM-LEN08 TO NEW-WRRN-DATE
027400              MOVE VHCL-WRRNTY-EXPIRE   TO OLD-WRRN-DATE.
028600           MOVE WS-DATE-REFORM-LEN08 TO VHCL-WRRNTY-EXPIRE.
028700
028800           MOVE TPS0351::DEALER-SHIP     TO VHCL-DEALER-SHIP.
028900           MOVE TPS0351::SALES-PERSON    TO VHCL-SALES-NAME.
029000           MOVE TPS0351-SALES-PERSON-PHONE TO
                                               VHCL-SALES-PHONE-NUM.
029100           MOVE TPS0351::SERVICE-PERSON  TO VHCL-SERV-NAME.
029200           MOVE TPS0351-SERVICE-PERSON-PHONE TO
029300                                      VHCL-SERV-PHONE-NUM.
029400           MOVE TPS0351::TITLE-ATTPS     TO VHCL-TITLE.
029500           MOVE TPS0351::LEASE-ATTPS     TO VHCL-LEASE.
029600           MOVE TPS0351::LIEN-ATTPS      TO VHCL-LIEN-HOLDER.
029700           MOVE TPS0351::MAINTEN-ATTPS   TO VHCL-MAINTAIN.
029800
029900***        'TPSVEHIC' RECORD COMPLETE.........
031100
031200      IF PARM03-MAINT-ACCT
031200         SET FR-REWRITE TO TRUE
031300         CALL TPSIO014 USING FILE-REQUEST VS
031500         IF NOT A-SUCCESSFUL-OPERATION
031600            MOVE 'VEHIC' TO FILE-NAME
031700            MOVE 'TPS118-REWRITE' TO FILE-TEXT
031800            PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
031900            GO TO EXIT-FROM-MODULE
031900         ELSE
031900            GO TO 3001-CONTINUE.
030000
030100      IF NOT TPSVEHIC-OPEN
030200           MOVE 1                    TO TPSVEHIC-FLAG
030300           SET FR-OPEN-I-O TO TRUE
030400           CALL TPSIO014 USING FILE-REQUEST VS
030600         IF FILE-STATUS NOT = '00' AND '05'
030700            MOVE 'VEHIC' TO FILE-NAME
030800            MOVE 'TPS118-OPEN' TO FILE-TEXT
030900            PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
031000            GO TO EXIT-FROM-MODULE.
031100
031200      SET FR-WRITE TO TRUE
031300      CALL TPSIO014 USING FILE-REQUEST VS.
031400
031500      IF NOT A-SUCCESSFUL-OPERATION
031600           MOVE 'VEHIC' TO FILE-NAME
031700           MOVE 'TPS118-WRITE' TO FILE-TEXT
031800           PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
031900           GO TO EXIT-FROM-MODULE.
035600
035700 3001-CONTINUE.
032000
032100      IF REGIS-CHANGE = 'N' OR INSP-CHANGE = 'N' OR
032100          WRRN-CHANGE = 'N'
032200         NEXT SENTENCE
032200      ELSE
032200         PERFORM 9000-WRITE-CAL-REC THRU 9000-EXIT
032100         MOVE 'N'                   TO REGIS-CHANGE
032100                                       INSP-CHANGE
032100                                       WRRN-CHANGE.
032000
032100*     MOVE CLNT-PROFILE-ACCT-NO  TO REPRT-CLIENT-ACCOUNT-NUMBER.
032200*     MOVE CLNT-PROFILE-SUB-ACCT TO REPRT-CLIENT-SUB-ACCOUNT.
032300*     MOVE WS-TODAYS-DATE-CYMD   TO REPRT-CREATE-DATE.
032400*     ACCEPT REPRT-CREATE-TIME   FROM TIME.
032500*     MOVE 014                   TO REPRT-DATA-BASE-NUMBER.
032600*     MOVE 'A'                   TO REPRT-TYPE-ACTION.
032700*     MOVE '0'                   TO REPRT-REPORT-STATUS.
032800*     MOVE WS-TODAYS-DATE-CYMD   TO REPRT-STATUS-DATE.
032900*     MOVE SPACES                TO REPRT-VARIABLE-DATA-KEY.
033000*     MOVE VHCL-KEY              TO REPRT-IO014-KEY-TPSVEHIC.
033100*
033200*     IF NOT TPSREPRT-OPEN
033300*          MOVE 1                    TO TPSREPRT-FLAG
033400*          SET FR-OPEN-I-O TO TRUE
033500*          CALL TPSIO100 USING FILE-REQUEST RS2.
033600*
033700*     IF FILE-STATUS NOT = '00' AND '05'
033800*          MOVE 'REPRT' TO FILE-NAME
033900*          MOVE 'TPS118-OPEN' TO FILE-TEXT
034000*          PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
034100*          GO TO EXIT-FROM-MODULE.
034200*
034300*     SET FR-WRITE TO TRUE
034400*     CALL TPSIO100 USING FILE-REQUEST RS2.
034500*
034600*     IF NOT A-SUCCESSFUL-OPERATION
034700*          MOVE 'REPRT' TO FILE-NAME
034800*          MOVE 'TPS118-WRITE' TO FILE-TEXT
034900*          PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
035000*          GO TO EXIT-FROM-MODULE.
035100
024800**JM  IF WS-NEW-ACCT = 1
035200*     MOVE 1                    TO TPS0351-DISPLAY-OPTION
035300*     MOVE 'ENTER NEXT VEHICLE OR END KEY TO BYPASS' TO
035400*                               TPS0351-MENU-MSG
035500*     GO TO CLEAR-PANEL-TPS0351.
035100
035300      IF WS-NEW-ACCT = 1 OR 2
035200         MOVE 1                    TO PARM03
035300         MOVE 0                    TO PARM02
035300                                      WS-NEW-ACCT.
024721
022100      GO TO 0001-BEGIN.
024721
024724 4000-DELETE-RECORD.
045604
025200     MOVE WS-TODAYS-DATE-CYMD   TO VHCL-SYSADMIN-CHANGE-DATE.
025200     MOVE LOGREC-SIGN-ON OF LS  TO VHCL-SYSADMIN-CHANGE-PASSWORD.
025200
045598      IF WS-TODAYS-DATE-CYMD(1:1) = 1
045598         MOVE 8   TO VHCL-SYSADMIN-SETUP-DATE(1:1)
045598      ELSE
045598         MOVE 9   TO VHCL-SYSADMIN-SETUP-DATE(1:1).
031100
031200      SET FR-REWRITE TO TRUE
031300      CALL TPSIO014 USING FILE-REQUEST VS
031500      IF NOT A-SUCCESSFUL-OPERATION
031600         MOVE 'VEHIC' TO FILE-NAME
031700         MOVE 'TPS118-DELETE ' TO FILE-TEXT
031800         PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
031900         GO TO EXIT-FROM-MODULE.
032000
031100******** SET UP CALENDAR RECORD **********
031200      MOVE 'D'                 TO REGIS-CHANGE
031200                                  INSP-CHANGE
031200                                  WRRN-CHANGE.
028600      MOVE VHCL-REGISTER-EXPIRE      TO OLD-REGIS-DATE.
028600      MOVE VHCL-INSPECT-EXPIRE       TO OLD-INSP-DATE.
028600      MOVE VHCL-WRRNTY-EXPIRE        TO OLD-WRRN-DATE.
032200      PERFORM 9000-WRITE-CAL-REC THRU 9000-EXIT.
032100      MOVE 'N'                   TO REGIS-CHANGE
032100                                    INSP-CHANGE
032100                                    WRRN-CHANGE.
031500
022100       GO TO 0001-BEGIN.
035600
024722 4000-EXIT.   EXIT.
024721
024724 5000-UNDELETE-RECORD.
025200
025200     MOVE WS-TODAYS-DATE-CYMD   TO VHCL-SYSADMIN-CHANGE-DATE.
025200     MOVE LOGREC-SIGN-ON OF LS  TO VHCL-SYSADMIN-CHANGE-PASSWORD.
045604
045598      IF WS-TODAYS-DATE-CYMD(1:1) = 8
045598         MOVE 1   TO VHCL-SYSADMIN-SETUP-DATE(1:1)
045598      ELSE
045598         MOVE 2   TO VHCL-SYSADMIN-SETUP-DATE(1:1).
031100
031200      SET FR-REWRITE TO TRUE
031300      CALL TPSIO014 USING FILE-REQUEST VS
031500      IF NOT A-SUCCESSFUL-OPERATION
031600         MOVE 'VEHIC' TO FILE-NAME
031700         MOVE 'TPS118-UNDELETE ' TO FILE-TEXT
031800         PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
031900         GO TO EXIT-FROM-MODULE.
031100******** SET UP CALENDAR RECORD **********
028600      IF VHCL-REGISTER-EXPIRE(3:6) > ZEROS
031200         MOVE 'A'                       TO REGIS-CHANGE
028600         MOVE VHCL-REGISTER-EXPIRE      TO NEW-REGIS-DATE.
028600      IF VHCL-INSPECT-EXPIRE(3:6) > ZERO
031200         MOVE 'A'                       TO INSP-CHANGE
028600         MOVE VHCL-INSPECT-EXPIRE       TO NEW-INSP-DATE.
028600      IF VHCL-WRRNTY-EXPIRE(3:6) > ZERO
031200         MOVE 'A'                       TO WRRN-CHANGE
028600         MOVE VHCL-WRRNTY-EXPIRE        TO NEW-WRRN-DATE.
032200      PERFORM 9000-WRITE-CAL-REC THRU 9000-EXIT.
032100      MOVE 'N'                   TO REGIS-CHANGE
032100                                    INSP-CHANGE
032100                                    WRRN-CHANGE.
031500
022100      GO TO 0001-BEGIN.
035600
024722 5000-EXIT.   EXIT.
024723
035700 8900-STATE-CODE-CONVERT.
035800
035900      IF WS-ZIP-CODE            = ZEROS
036000           MOVE 1               TO LS-ZIP-FLAG
036100           MOVE SPACES          TO LS-ZIP-STATE
036200           GO TO 8900-STATE-CODE-CONVERT-EXIT.
036300
036400      IF WS-ZIP-FIRST-FOUR = ZEROS
036500           GO TO 8902-SHIFT-THE-ZIP-CODE.
036600
036700      MOVE WS-ZIP-FIRST-THREE   TO LS-ZIP-THREE.
036800
036900 8901-CALL-STATE-CONVERT.
037000
037100      CALL TPSSTATE USING LS-ZIP-THREE.
037200           GO TO 8900-STATE-CODE-CONVERT-EXIT.
037300
037400 8902-SHIFT-THE-ZIP-CODE.
037500
037600      MOVE WS-ZIP-SECOND-FIVE   TO WS-FIX-ZIP-FIRST-FIVE.
037700      MOVE ZEROS                TO WS-FIX-ZIP-SECOND-FOUR.
037800      MOVE WS-FIX-ZIP           TO WS-ZIP-CODE.
037900      MOVE WS-ZIP-FIRST-THREE   TO LS-ZIP-THREE.
038000      GO TO 8901-CALL-STATE-CONVERT.
038100
038200 8900-STATE-CODE-CONVERT-EXIT. EXIT.
038300*
231400 9000-WRITE-CAL-REC.
231500
231500      INITIALIZE      LS-RECVE.
231500      INITIALIZE      LS-PARMS.
231500      MOVE 'TPS118'         TO LSP-PROG-ID.
231500      MOVE 2                TO LSP-PROG-TYPE.
231600      MOVE VHCL-YEAR-YY     TO LSP-MAINT-DATA-DESCRIP-NEW(1:2).
231600      MOVE VHCL-MODEL       TO LSP-MAINT-DATA-DESCRIP-NEW(4:20).
231500***** ADD RECORDS FIRST TIME THRU & EXIT ***********
231500      IF REGIS-CHANGE = 'A' OR
231500              WS-TODAYS-DATE-YMD = 19950808
231500         MOVE 0901             TO LSP-MAINT-FIELD-CODE
231600         MOVE NEW-REGIS-DATE   TO LSP-MAINT-EVENT-DATE
231600         MOVE 1                TO LSP-ACTION
231500         CALL TPS4010 USING LS-PARMS
                                  LS
                                  PS
                                  LS-RECVE
                                  WS-CURRENT-XY-PARM.
231500      IF INSP-CHANGE = 'A' OR
231500              WS-TODAYS-DATE-YMD = 19950808
231500         MOVE 0902             TO LSP-MAINT-FIELD-CODE
231600         MOVE NEW-INSP-DATE    TO LSP-MAINT-EVENT-DATE
231600         MOVE 1                TO LSP-ACTION
231500         CALL TPS4010 USING LS-PARMS
                                  LS
                                  PS
                                  LS-RECVE
                                  WS-CURRENT-XY-PARM.
231500      IF WRRN-CHANGE = 'A' OR
231500              WS-TODAYS-DATE-YMD = 19950808
231500         MOVE 0903             TO LSP-MAINT-FIELD-CODE
231600         MOVE NEW-WRRN-DATE    TO LSP-MAINT-EVENT-DATE
231600         MOVE 1                TO LSP-ACTION
231500         CALL TPS4010 USING LS-PARMS
                                  LS
                                  PS
                                  LS-RECVE
                                  WS-CURRENT-XY-PARM.
231500
231500      IF REGIS-CHANGE = 'M'
231500         MOVE 0901             TO LSP-MAINT-FIELD-CODE
231600         MOVE OLD-REGIS-DATE   TO LSP-MAINT-EVENT-DATE
231600         MOVE 3                TO LSP-ACTION
231500         CALL TPS4010 USING LS-PARMS
                                  LS
                                  PS
                                  LS-RECVE
                                  WS-CURRENT-XY-PARM.
231600         MOVE NEW-REGIS-DATE   TO LSP-MAINT-EVENT-DATE
231600         MOVE 1                TO LSP-ACTION
231500         CALL TPS4010 USING LS-PARMS
                                  LS
                                  PS
                                  LS-RECVE
                                  WS-CURRENT-XY-PARM.
231500      IF INSP-CHANGE = 'M'
231500         MOVE 0902             TO LSP-MAINT-FIELD-CODE
231600         MOVE OLD-INSP-DATE    TO LSP-MAINT-EVENT-DATE
231600         MOVE 3                TO LSP-ACTION
231500         CALL TPS4010 USING LS-PARMS
                                  LS
                                  PS
                                  LS-RECVE
                                  WS-CURRENT-XY-PARM.
231600         MOVE NEW-INSP-DATE    TO LSP-MAINT-EVENT-DATE
231600         MOVE 1                TO LSP-ACTION
231500         CALL TPS4010 USING LS-PARMS
                                  LS
                                  PS
                                  LS-RECVE
                                  WS-CURRENT-XY-PARM.
231500      IF WRRN-CHANGE = 'M'
231500         MOVE 0903             TO LSP-MAINT-FIELD-CODE
231600         MOVE OLD-WRRN-DATE    TO LSP-MAINT-EVENT-DATE
231600         MOVE 3                TO LSP-ACTION
231500         CALL TPS4010 USING LS-PARMS
                                  LS
                                  PS
                                  LS-RECVE
                                  WS-CURRENT-XY-PARM.
231600         MOVE NEW-WRRN-DATE    TO LSP-MAINT-EVENT-DATE
231600         MOVE 1                TO LSP-ACTION
231500         CALL TPS4010 USING LS-PARMS
                                  LS
                                  PS
                                  LS-RECVE
                                  WS-CURRENT-XY-PARM.
231500
231500      IF REGIS-CHANGE = 'D'
231500        MOVE 0901             TO LSP-MAINT-FIELD-CODE
231600        MOVE OLD-REGIS-DATE   TO LSP-MAINT-EVENT-DATE
231600        MOVE 3                TO LSP-ACTION
231500        CALL TPS4010 USING LS-PARMS
                                 LS
                                 PS
                                 LS-RECVE
                                 WS-CURRENT-XY-PARM.
231500      IF INSP-CHANGE = 'D'
231500        MOVE 0902             TO LSP-MAINT-FIELD-CODE
231600        MOVE OLD-INSP-DATE    TO LSP-MAINT-EVENT-DATE
231600        MOVE 3                TO LSP-ACTION
231500        CALL TPS4010 USING LS-PARMS
                                 LS
                                 PS
                                 LS-RECVE
                                 WS-CURRENT-XY-PARM.
231500      IF WRRN-CHANGE = 'D'
231500        MOVE 0903             TO LSP-MAINT-FIELD-CODE
231600        MOVE OLD-WRRN-DATE    TO LSP-MAINT-EVENT-DATE
231600        MOVE 3                TO LSP-ACTION
231500        CALL TPS4010 USING LS-PARMS
                                 LS
                                 PS
                                 LS-RECVE
                                 WS-CURRENT-XY-PARM.


            MOVE WS-CURRENT-XY-PARM(1:4) TO WS-CURRENT-X.
            MOVE WS-CURRENT-XY-PARM(5:4) TO WS-CURRENT-Y.

231400 9000-EXIT.   EXIT.
061800*
038400*
038500 EXIT-FROM-MODULE.
038600      IF NOT TPSVEHIC-OPEN
038700           GO TO SEEIF-REPRT-OPEN.
038800
038900      SET FR-CLOSE         TO TRUE
039000      CALL TPSIO014 USING FILE-REQUEST VS
039100      IF NOT A-SUCCESSFUL-OPERATION
039200           MOVE 'VEHIC' TO FILE-NAME
039300           MOVE 'TPS118-CLOSE' TO FILE-TEXT
039400           PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
039500           GO TO SEEIF-REPRT-OPEN.
039600
039700 SEEIF-REPRT-OPEN.
039800      IF NOT TPSREPRT-OPEN
039900           GO TO END-OF-THE-LINE.
040000
040100      SET FR-CLOSE         TO TRUE
040200      CALL TPSIO100 USING FILE-REQUEST RS2
040300      IF NOT A-SUCCESSFUL-OPERATION
040400           MOVE 'REPRT' TO FILE-NAME
040500           MOVE 'TPS118-CLOSE' TO FILE-TEXT
040600           PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
040700           GO TO END-OF-THE-LINE.
040800
040900 END-OF-THE-LINE.
041000
041100*     CANCEL SCREENIO
041200      CANCEL TPSDATES
041300      CANCEL TPSIOERR
041400      CANCEL TPSSTATE
041500      CANCEL TPSIO014.
041600      CANCEL TPSIO100.
041600      CANCEL TPS4010.

           INITIALIZE CURRENT-XY-PARAMETERS.
           MOVE WS-CURRENT-X TO CURRENT-XY-PARAMETERS(1:4).
           MOVE WS-CURRENT-Y TO CURRENT-XY-PARAMETERS(5:4).

           IF CLOSE-ALL-FORMS-FLAG = 0
               SET TPS0040A::KEY-PRESSED TO "End Key"
               SET TPS0045::KEY-PRESSED TO "End Key"
               SET TPS0350::KEY-PRESSED TO "End Key"
               SET TPS0351::KEY-PRESSED TO "End Key"
               INVOKE TPS0040A::Close
               INVOKE TPS0045::Close
               INVOKE TPS0350::Close
               INVOKE TPS0351::Close
               MOVE 1 TO CLOSE-ALL-FORMS-FLAG
           END-IF.

           GOBACK GIVING CURRENT-XY-PARAMETERS. 


041900
042000 FILE-ERROR.
042100      CALL TPSIOERR USING FILE-REQUEST
                                WS-CURRENT-XY-PARM.
042200      CANCEL TPSIOERR.


            MOVE WS-CURRENT-XY-PARM(1:4) TO WS-CURRENT-X.
            MOVE WS-CURRENT-XY-PARM(5:4) TO WS-CURRENT-Y.

           INITIALIZE CURRENT-XY-PARAMETERS.
           MOVE WS-CURRENT-X TO CURRENT-XY-PARAMETERS(1:4).
           MOVE WS-CURRENT-Y TO CURRENT-XY-PARAMETERS(5:4).

042300 FILE-ERROR-EXIT. EXIT.
042400
