       IDENTIFICATION DIVISION.
       PROGRAM-ID. TPS1010B.
       AUTHOR. JOHN CURRAN.
      ***************************************************************
      *    CREATE PAYMENT AUTHORIZATION REPORT                      *
      * 04/08/94 NEW PROGRAM                                        *
      *    JC                                                       *
      ***************************************************************
       ENVIRONMENT DIVISION.
       CONFIGURATION SECTION.
       SOURCE-COMPUTER. IBM-PS2.
       OBJECT-COMPUTER. IBM-PS2.
       FILE-CONTROL.
           SELECT  TPS-MAIL-CATEGORY-FILE
                   ASSIGN TO "\tps\prod\files\mailcatg.men"
                   ORGANIZATION IS LINE SEQUENTIAL
                   FILE STATUS IS TPS-FILE-STATUS.
           SELECT  TPS-DISPOSITION-FILE
                   ASSIGN TO "\tps\prod\files\disposit.men"
                   ORGANIZATION IS LINE SEQUENTIAL
                   FILE STATUS IS TPS-FILE-STATUS.
       DATA DIVISION.
       FILE SECTION.
       FD  TPS-MAIL-CATEGORY-FILE
           DATA RECORD  IS TPS-MAIL-CATEGORY-INPUT
           LABEL RECORDS STANDARD.
       01  TPS-MAIL-CATEGORY-INPUT          PIC X(80).
       FD  TPS-DISPOSITION-FILE
           DATA RECORD  IS TPS-DISPOSITION-INPUT
           LABEL RECORDS STANDARD.
       01  TPS-DISPOSITION-INPUT            PIC X(80).
       WORKING-STORAGE SECTION.
           COPY "TPSFILES.CPY".
           COPY "KEYVALUE.CPY".
       01  TPS-MAIL-REC.
           COPY "TPSMAIL.CPY".
       01  TPS-MAIL-HOLD.
           COPY "TPSMAIL.CPY".
           COPY "TPSMEMO.COB".
       01 TPSMEMO-USER-FIELDS-R REDEFINES TPSMEMO-4.
             10  MEMO-ACCT-NO               PIC  9(10).
             10  MEMO-SUB-ACCT              PIC  9(02).                 00002500
             10  MEMO-RECEIVE-DATE          PIC  9(08).                 00002510
             10  MEMO-RECEIVE-NUMBER        PIC S9(05) COMP-3.          00002520
             10 TPS-MEMO-LINE PIC X(50) OCCURS 10 TIMES INDEXED BY JPC.
             10 TPS-MEMO-LINE-R REDEFINES TPS-MEMO-LINE.
                20 MEMO-TEXT PIC X(500).
                   88 NO-MEMO-WAS-ENTERED    VALUE SPACES.
           COPY "TPSKEYS.CPY".
       01  HEADING-1.
             20 FILLER                   PIC X(40)
           VALUE '               Taking Care of Your Perso'.
             20 FILLER                   PIC X(40)
           VALUE 'nal Business...Privately                '.
       01  HEADING-2       PIC X(80).
       01  HEADING-2-X.
           05 CLIENT-DIARY PIC X(22) VALUE 'Client Mail Diary For '.
           05 CLIENT-NAME  PIC X(48) USAGE DISPLAY.
           05 CLIENT-FIRST-NAME REDEFINES CLIENT-NAME OCCURS 48 TIMES
              PIC X(01).
       01  HEADING-3.
             20 FILLER PIC X(20) VALUE '                    '.
             20 FILLER PIC X(20) VALUE '                    '.
             20 FILLER PIC X(20) VALUE '                    '.
             20 FILLER PIC X(20) VALUE '                    '.
       01  HEADING-4.
             20 FILLER PIC X(20) VALUE '   Addressor   Enclo'.
             20 FILLER PIC X(20) VALUE 'sures            Res'.
             20 FILLER PIC X(20) VALUE 'idence              '.
             20 FILLER PIC X(20) VALUE '   Disposition      '.
       01  BOLD-LINE.
        10 FILLER PIC X(20) VALUE '===================='.
        10 FILLER PIC X(20) VALUE '===================='.
        10 FILLER PIC X(20) VALUE '===================='.
        10 FILLER PIC X(20) VALUE '===================='.
       01  A-LINE-OF-DASHES.
        10 FILLER PIC X(20) VALUE '____________________'.
        10 FILLER PIC X(20) VALUE '____________________'.
        10 FILLER PIC X(20) VALUE '____________________'.
        10 FILLER PIC X(20) VALUE '____________________'.
       01  HALF-A-LINE-OF-DASHES.
        10 FILLER PIC X(20) VALUE '____________________'.
        10 FILLER PIC X(20) VALUE '______              '.
        10 FILLER PIC X(20) VALUE '                    '.
        10 FILLER PIC X(20) VALUE '                    '.
       01 PIECE-COUNTS.
        10 PIECES-RECEIVED   PIC 99.
        10 FOR-PAYMENT       PIC 99.
        10 TO-APPROVE        PIC 99.
        10 DISCARDED         PIC 99.
        10 PENDING           PIC 99.
        10 PIECES-PER-ADDRESS.
           20 PIECES-R0      PIC 99.
           20 PIECES-R1      PIC 99.
           20 PIECES-R2      PIC 99.
           20 PIECES-R3      PIC 99.
           20 PIECES-R4      PIC 99.
           20 PIECES-R5      PIC 99.
           20 PIECES-R6      PIC 99.
           20 PIECES-R7      PIC 99.
           20 PIECES-R8      PIC 99.
           20 PIECES-R9      PIC 99.
        10 PIECE-COUNT REDEFINES PIECES-PER-ADDRESS
           OCCURS 10 TIMES PIC 99.
       01 PIECES-PER-DISP OCCURS 99 TIMES PIC 99.
       01 FOOTING-1.
        10 FILLER PIC X(17) VALUE
                             'TPS has received '.
        10 TOTAL-PIECES-RECEIVED PIC Z9.
        10 TOTAL-PIECE-WORD PIC X(07) VALUE ' pieces'.
        10 FILLER PIC X(29) VALUE
                             ' of mail addressed to you on '.
        10 DATE-RECEIVED PIC X(20) VALUE '____________________'.
        10 DATE-RECEIVED-R REDEFINES DATE-RECEIVED
           OCCURS 20 TIMES PIC X.

       01 FOOTING-2.
        10 FILLER PIC X(10) VALUE
                             'Of these, '.
        10 TOTAL-PIECES-R1       PIC Z9.
        10 TOTAL-PIECE-WORD-R1 PIC X(05) VALUE ' were'.
        10 FILLER PIC X(19) VALUE
                             ' addressed to your '.
        10 R1-RESIDENCE        PIC X(20).
        10 FILLER PIC X(16) VALUE
                             ' address. There '.
        10 ITEMS-FOR-PAYMENT-WORD PIC X(04) VALUE
                             'are '.
        10 ITEMS-FOR-PAYMENT PIC Z9.
        10 FILLER            PIC XX VALUE SPACES.

       01 FOOTING-3.
        10 ITEMS-FOR-PAYMENT-WORD-2 PIC X(06) VALUE 'items '.
        10 FILLER PIC X(51) VALUE
           ' for payment and will require your approval. There '.
        10 ITEMS-TO-FORWARD-WORD   PIC X(04) VALUE 'are '.
        10 ITEMS-TO-FORWARD        PIC Z9.
        10 ITEMS-TO-FORWARD-WORD-2 PIC X(06) VALUE ' items'.
        10 FILLER PIC X(11) VALUE
                             ' being for-'.
       01 FOOTING-4.
        10 FILLER PIC X(19) VALUE
                             'warded to you and '.
        10 ITEMS-DISCARDED         PIC Z9.
        10 ITEMS-DISCARDED-WORD    PIC X(11) VALUE ' items were'.
        10 FILLER PIC X(21) VALUE
           ' discarded. You have '.
        10 ITEMS-PENDING           PIC Z9.
        10 ITEMS-PENDING-WORD      PIC X(06) VALUE ' items'.
        10 FILLER PIC X(19) VALUE
           ' pending approval. '.
       01 FOOTING-5.
        10 FILLER PIC X(40) VALUE
                             'It is listed at the beginning of this re'.
        10 FILLER PIC X(40) VALUE
                             'port.                                   '.
       01 FOOTING-6.
        10 FILLER PIC X(40) VALUE
                             '                                        '.
        10 FILLER PIC X(40) VALUE
                             'Thank You,                              '.
       01 FOOTING-7.
        10 FILLER PIC X(40) VALUE
                             '                                        '.
        10 NAME-OF-ADMINISTRATOR PIC X(40) VALUE SPACES.
        10 NAME-OF-ADMINISTRATOR-R REDEFINES NAME-OF-ADMINISTRATOR
           OCCURS 40 TIMES PIC X.
       01 FOOTING-8.
        10 FILLER PIC X(40) VALUE
                             '                                        '.
        10 FILLER PIC X(40) VALUE
                             'Account Administrator                   '.
       01 TOTAL-AMOUNT-DUE   PIC 9(6)V99.
       01 TOTAL-MINIMUM-PAY  PIC 9(6)V99.
       01  PROGRAM-NAMES.
        10 SCRNIO      PIC X(08) VALUE 'SCRNIO'.
        10 TPSIOREC    PIC X(08) VALUE 'TPSIOREC'.
        10 TPSIOMEM    PIC X(08) VALUE 'TPSIOMEM'.
        10 TPSIOERR    PIC X(08) VALUE 'TPSIOERR'.
        10 TPSIO005    PIC X(08) VALUE 'TPSIO005'.
        10 JPCDATES    PIC X(08) VALUE 'JPCDATES'.
        10 INQUIRY     PIC X(08) VALUE 'INQUIRY'.
        10 FILLER      PIC X(08) VALUE HIGH-VALUES.
       01  PROGRAM-NAMES-R REDEFINES PROGRAM-NAMES.
        10 PROGRAM-NAME PIC X(08) OCCURS 7 TIMES.
       01  NEXT-RECEIVE-NUMBER PIC S9(5) COMP-3 VALUE 0.
       01  DATE-REQUEST-PARAMETER                PIC 99 VALUE 15.
       01  TODAYS-DATE PIC 999999.
       01  TODAYS-DATE-R REDEFINES TODAYS-DATE.
           10 TODAYS-YEAR                        PIC 99.
           10 TODAYS-MONTH                       PIC 99.
           10 TODAYS-DAY                         PIC 99.
       01  THE-INDEX                             PIC S9(4) COMP.
       01  DIARY-INDEX                           PIC S9(4) COMP.
       01  MONTH-INDEX                           PIC S9(4) COMP.
       01  POPUP-INDEX                           PIC S9(4) COMP.
       01  MAXIMUM-ROWS       PIC S9(4) COMP VALUE 100.
       01  MAXIMUM-POPUP-ROWS PIC S9(4) COMP VALUE 11.
       01  CATEGORY-HOLD                         PIC XX VALUE SPACES.
       01  YES                                   PIC X VALUE 'Y'.
       01  NOPE                                  PIC X VALUE 'N'.
       01  EDIT-MASK-10                          PIC ZZZ,ZZZ.99.
       01  MEMO-WAS-FOUND                        PIC X.
           88  ITS-A-NEW-MEMO                    VALUE 'N'.
           88  ITS-AN-OLD-MEMO                   VALUE 'Y'.
       01  EXIT-KEY-NAME-TABLE                   PIC S9(4) COMP-5.
           88  ITS-THE-RECEIVE-NUMBER            VALUE +1006.
           88  ITS-THE-ADDRESSOR-HOT-FIELD       VALUE +1007.
           88  ITS-THE-CARRIER-CODE              VALUE +1009.
           88  ITS-THE-POSTMARK-DATE             VALUE +1012.
           88  ITS-THE-POSTAGE-CLASS             VALUE +1015.
           88  ITS-THE-ACCOUNT-NUMBER            VALUE +1015.
           88  ITS-THE-CONTAINER-SIZE            VALUE +1017.
           88  ITS-THE-DISPOSITION               VALUE +1020.
           88  ITS-THE-CATEGORY                  VALUE +1023.
       01  CURSOR-FIELD                          PIC S9(4) COMP-5.
           88  WERE-DOING-RECEIVE-DATES          VALUE 05.
           88  WERE-DOING-RECEIVE-NUMBERS        VALUE 06.
           88  WERE-DOING-THE-ADDRESSOR          VALUE 07.
           88  WERE-DOING-CARRIER-CODES          VALUE 09.
           88  WERE-DOING-POSTMARK-DATES         VALUE 12.
           88  WERE-DOING-POSTAGE-CLASSES        VALUE 15.
           88  WERE-DOING-THE-ACCOUNT-NUMBER     VALUE 15.
           88  WERE-DOING-CONTAINER-SIZES        VALUE 17.
           88  WERE-DOING-DISPOSITIONS           VALUE 20.
           88  WERE-DOING-MAIL-CATEGORIES        VALUE 23.
       01  MONTH-DAY-TABLE.
           10 FILLER                             PIC 99 VALUE 31.
           10 FILLER                             PIC 99 VALUE 28.
           10 FILLER                             PIC 99 VALUE 31.
           10 FILLER                             PIC 99 VALUE 30.
           10 FILLER                             PIC 99 VALUE 31.
           10 FILLER                             PIC 99 VALUE 30.
           10 FILLER                             PIC 99 VALUE 31.
           10 FILLER                             PIC 99 VALUE 31.
           10 FILLER                             PIC 99 VALUE 30.
           10 FILLER                             PIC 99 VALUE 31.
           10 FILLER                             PIC 99 VALUE 30.
           10 FILLER                             PIC 99 VALUE 31.
       01 MONTH-DAY-TABLE-R REDEFINES
          MONTH-DAY-TABLE.
           10 DAYS-IN-MONTH PIC 99 OCCURS 12 TIMES.
       01  TPS-FILE-STATUS                       PIC XX.
           88  TPS-CARRIER-FILE-OK VALUE '00', '02'.
       01 MAIL-CATEGORY-DATA OCCURS 100 TIMES.
          10 MAIL-CATEGORY-ROW.
             20 MAIL-CATEGORY-CODE       PIC X(02).
             20 FILLER                   PIC X(01).
             20 MAIL-CATEGORY-NAME       PIC X(77).

       01 CATEGORY-TABLE     OCCURS 100 TIMES INDEXED BY CATEGORY-INDEX.
          10 SEARCH-CATEGORY.
             20 SEARCH-CATEGORY-CODE     PIC X(02).
             20 FILLER                   PIC X(01).
             20 SEARCH-CATEGORY-NAME     PIC X(77).

       01 DISPOSITION-DATA OCCURS 100 TIMES.
          10 DISPOSITION-ROW.
             20 DISPOSITION-CODE         PIC 9(02).
             20 FILLER                   PIC X(01).
             20 DISPOSITION-DESCRIPTION  PIC X(17).
             20 FILLER                   PIC X(60).

       01 DISPOSITION-TABLE  OCCURS 100 TIMES
                             INDEXED BY DISPOSITION-INDEX.
          10 SEARCH-DISPOSITION.
             20 SEARCH-DISPOSITION-CODE  PIC X(02).
             20 FILLER                   PIC X(01).
             20 SEARCH-DISPOSITION-NAME  PIC X(17).
             20 FILLER                   PIC X(60).

       01 MAIL-RECEIVE-DATA OCCURS 100 TIMES.
          10 MAIL-RECEIVE-ROW.
             20 MAIL-RECEIVE-CODE        PIC 9(02).
             20 MAIL-RECEIVE-CODE-X REDEFINES MAIL-RECEIVE-CODE PIC XX.
             20 FILLER                   PIC X(01).
             20 MAIL-RECEIVE-NAME        PIC X(36).
             20 FILLER                   PIC X(01).
             20 MAIL-RESIDENT-CODE       PIC X(02).
             20 FILLER                   PIC X(01).
             20 MAIL-MEMO                PIC X(50).
             20 FILLER                   PIC X(01).
             20 MAIL-DISP                PIC X(02).
             20 MAIL-DISP-R REDEFINES MAIL-DISP PIC 9(02).
             20 MAIL-RECEIVE-CATEGORY      PIC X(02).
             20 MAIL-RECEIVE-TOTAL-BALANCE PIC 9(6)V99.
             20 MAIL-RECEIVE-DUE-DATE      PIC 9(6).
             20 MAIL-RECEIVE-CLOSING-DATE  PIC 9(6).
             20 MAIL-RECEIVE-AMOUNT-BILLED PIC 9(6)V99.
             20 MAIL-RECEIVE-ACCOUNT       PIC X(20).

       01 MAIL-DIARY-DATA OCCURS 1000 TIMES.
          10 MAIL-DIARY-ROW.
*************20 MAIL-DIARY-CODE          PIC X(02).
             20 MAIL-DIARY-CODE          PIC ZZ.
             20 FILLER                   PIC X(01).
             20 MAIL-DIARY-NAME          PIC X(36).
             20 FILLER                   PIC X(01).
             20 MAIL-DIARY-RESIDE        PIC 9(02).
             20 MAIL-DIARY-BALANCE       PIC ZZZ,ZZZ.ZZ.
             20 FILLER                   PIC X(01).
             20 MAIL-DIARY-DUE-DATE      PIC X(08).
             20 FILLER                   PIC X(02).
             20 MAIL-DIARY-DISP          PIC X(17).
          10 MAIL-DIARY-ROW-R REDEFINES  MAIL-DIARY-ROW.
             20 MAIL-DIARY-CATEGORY      PIC X(80).
          10 MAIL-DIARY-ROW-R2 REDEFINES MAIL-DIARY-ROW.
             20 FILLER                   PIC X(15).
             20 MAIL-DIARY-MEMO          PIC X(50).
             20 FILLER                   PIC X(15).
       01 ALPHA-TEST                     PIC X(36) VALUE SPACES.
       01 NUMERIC-TEST                   PIC X(09) VALUE SPACES.
       01 PROCESS-SWITCH                 PIC X(01) VALUE 'R'.
           88  ITS-RECEIVING       VALUE 'R'.
           88  ITS-ADMINISTRATION  VALUE 'A'.
       01  HEADING-2-PAY.
           05 CLIENT-PAY   PIC X(31)
              VALUE 'Payment Authorization Report - '.
           05 CLIENT-NAME-PAY  PIC X(48) USAGE DISPLAY.
       01  HEADING-3-PAY.
             20 FILLER PIC X(20) VALUE '   Addressor/       '.
             20 FILLER PIC X(20) VALUE '             Account'.
             20 FILLER PIC X(20) VALUE ' Number         Pay '.
             20 FILLER PIC X(20) VALUE '     Pay        Pay '.
       01  HEADING-4-PAY.
             20 FILLER PIC X(20) VALUE '    Addressee       '.
             20 FILLER PIC X(20) VALUE '             Closing'.
             20 FILLER PIC X(20) VALUE '-Due Dates      Amt '.
             20 FILLER PIC X(20) VALUE 'Due  Min. Due   Only'.
       01 PAY-FOOTING-1.
        10 FILLER PIC X(06) VALUE
                             'There '.
        10 ITEMS-FOR-PAYMENT-WORD PIC X(04) VALUE
                             'are '.
        10 ITEMS-FOR-PAYMENT PIC Z9.
        10 FILLER PIC X(01) VALUE SPACE.
        10 ITEMS-FOR-PAYMENT-WORD-2 PIC X(06) VALUE 'items '.
        10 FILLER PIC X(61) VALUE
           ' pending approval.'.
       01 PAY-FOOTING-2.
        10 PAYMENT-TOTAL-AMOUNT-DUE   PIC ZZZ,ZZZ.99.
        10 FILLER PIC X(70) VALUE
           ' is the amount due, payment in full.'.
       01 PAY-FOOTING-3.
        10 PAYMENT-TOTAL-MINIMUM-PAY  PIC ZZZ,ZZZ.99.
        10 FILLER PIC X(70) VALUE
           ' is the amount due, minimum payment.'.
       01 PAY-FOOTING-4.
        10 FILLER PIC X(20) VALUE 'Please indicate your'.
        10 FILLER PIC X(20) VALUE ' preferences above a'.
        10 FILLER PIC X(20) VALUE 'nd fax this report t'.
        10 FILLER PIC X(20) VALUE 'o TPS 516-739-7202. '.
       01  DATE-REQUEST-PARAMETER                PIC 99 VALUE 15.
       01  TODAYS-DATE PIC 999999.
       01  TODAYS-DATE-R REDEFINES TODAYS-DATE.
           10 TODAYS-YEAR                        PIC 99.
           10 TODAYS-MONTH                       PIC 99.
           10 TODAYS-DAY                         PIC 99.
       01  PAYMENT-INDEX                         PIC S9(4) COMP.
       01 PAYMENT-AUTHORIZATION-DATA OCCURS 1000 TIMES.
          10 PAYMENT-AUTHORIZATION-ROW.
*************20 PAYMENT-AUTHORIZATION-CODE     PIC X(02).
             20 PAYMENT-AUTHORIZATION-CODE     PIC ZZ.
             20 FILLER                         PIC X(01).
             20 PAYMENT-AUTHORIZATION-NAME     PIC X(29).
             20 FILLER                         PIC X(01).
             20 PAYMENT-AUTHORIZATION-ACCOUNT  PIC X(20).
             20 PAYMENT-AUTHORIZATION-BALANCE  PIC ZZZ,ZZZ.ZZ.
             20 PAYMENT-AUTHORIZATION-MINIMUM  PIC ZZZ,ZZZ.99.
             20 FILLER                         PIC X(01).
             20 PAYMENT-AUTHORIZATION-ONLY     PIC X(06).
          10 PAYMENT-AUTHORIZATION-ROW-R REDEFINES
             PAYMENT-AUTHORIZATION-ROW.
             20 FILLER                         PIC X(02).
             20 FILLER                         PIC X(01).
             20 PAYMENT-AUTHORIZATION-RESIDE   PIC X(02).
             20 FILLER                         PIC X(28).
             20 PAYMENT-AUTHORIZATION-CLOSING  PIC X(08).
             20 FILLER                         PIC X(01).
             20 PAYMENT-AUTHORIZATION-DUEDATE  PIC X(08).
             20 FILLER                         PIC X(30).
       LINKAGE SECTION.
       01 TPS-LOGON.
           COPY "TPSLOGON.CPY".
       01 TPS-PROFILE.
           COPY "TPSPROFL.CPY".
       01 TPS-CLIENT-REC.
           COPY "TPSRESID.CPY".
       01 LS-MAIL-REC.
           COPY "TPSMAIL.CPY".

       PROCEDURE DIVISION USING TPS-LOGON TPS-PROFILE TPS-CLIENT-REC
                                LS-MAIL-REC.
       TPS1010-BEGIN.
          MOVE LS-MAIL-REC TO TPS-MAIL-REC.
          PERFORM SET-UP-TABLES
             THRU SET-UP-TABLES-EXIT.
          PERFORM MAIL-DIARY THRU MAIL-DIARY-EXIT.
          GOBACK.

       SET-UP-TABLES.
          PERFORM CLEAR-MAIL-RECEIVED THRU CLEAR-MAIL-RECEIVED-EXIT.
          OPEN  INPUT  TPS-MAIL-CATEGORY-FILE.
          PERFORM VARYING THE-INDEX FROM 1 BY 1
                  UNTIL   THE-INDEX > MAXIMUM-ROWS
            READ TPS-MAIL-CATEGORY-FILE
                 AT END GO TO TPS-MAIL-CATEGORY-FILE-EXIT
            END-READ
            SET CATEGORY-INDEX TO THE-INDEX
            MOVE TPS-MAIL-CATEGORY-INPUT
              TO MAIL-CATEGORY-ROW(THE-INDEX)
                 SEARCH-CATEGORY (CATEGORY-INDEX)
          END-PERFORM.
       TPS-MAIL-CATEGORY-FILE-EXIT.
          CLOSE TPS-MAIL-CATEGORY-FILE.
          OPEN  INPUT  TPS-DISPOSITION-FILE.
          PERFORM VARYING THE-INDEX FROM 1 BY 1
                  UNTIL   THE-INDEX > MAXIMUM-ROWS
            READ TPS-DISPOSITION-FILE
                 AT END GO TO TPS-DISPOSITION-FILE-EXIT
            END-READ
            SET DISPOSITION-INDEX TO THE-INDEX
            MOVE TPS-DISPOSITION-INPUT
              TO DISPOSITION-ROW(THE-INDEX)
                 SEARCH-DISPOSITION(DISPOSITION-INDEX)
          END-PERFORM.
       TPS-DISPOSITION-FILE-EXIT.
          CLOSE TPS-DISPOSITION-FILE.
       SET-UP-TABLES-EXIT. EXIT.

       READ-RECEIVE-NUMBERS.
          PERFORM CLEAR-MAIL-RECEIVED THRU CLEAR-MAIL-RECEIVED-EXIT.
          MOVE F-PRIME TO FILE-KEY.
          MOVE F-START TO FILE-ACTION.
          MOVE 1 TO MAIL-RECEIVE-NUMBER OF TPS-MAIL-REC.
          PERFORM SET-THE-ACCOUNT-NUMBER
             THRU SET-THE-ACCOUNT-NUMBER-EXIT.
          MOVE MAIL-KEY OF TPS-MAIL-REC TO MAIL-KEY OF TPS-MAIL-HOLD.
          CALL TPSIOREC USING FILE-REQUEST TPS-MAIL-REC.
          IF NO-RECORD-WAS-FOUND GO TO READ-RECEIVE-NUMBERS-EXIT.
          IF NOT A-SUCCESSFUL-OPERATION
             MOVE ' RECEIVE' TO FILE-NAME
             MOVE 'TPS1010-SBR' TO FILE-TEXT
             PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
             EXIT PROGRAM
             GOBACK.
          MOVE F-PRIME TO FILE-KEY.
          MOVE F-READ-NEXT TO FILE-ACTION.
          SET THE-INDEX TO 1.
       READ-ALL-RECEIVE-NUMBERS.
          CALL TPSIOREC USING FILE-REQUEST TPS-MAIL-REC.
          IF END-OF-FILE-WAS-REACHED GO TO READ-RECEIVE-NUMBERS-EXIT.
          IF NOT A-SUCCESSFUL-OPERATION
             MOVE ' RECEIVE' TO FILE-NAME
             MOVE 'TPS1010-BRN' TO FILE-TEXT
             PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
             EXIT PROGRAM
             GOBACK.
          IF MAIL-KEY-GENERIC OF TPS-MAIL-REC
           > MAIL-KEY-GENERIC OF TPS-MAIL-HOLD
             GO TO READ-RECEIVE-NUMBERS-EXIT.
          IF RECUR-PAYEE-RESIDENT-CODE  OF TPS-MAIL-REC IS NOT NUMERIC
             MOVE 0 TO RECUR-PAYEE-RESIDENT-CODE OF TPS-MAIL-REC.
          IF THE-INDEX = 1
             MOVE TPS-MAIL-REC TO TPS-MAIL-HOLD.
          IF MAIL-ACCT-NO      OF TPS-MAIL-REC =
             MAIL-ACCT-NO      OF TPS-MAIL-HOLD
           AND
             MAIL-SUB-ACCT     OF TPS-MAIL-REC =
             MAIL-SUB-ACCT     OF TPS-MAIL-HOLD
           AND
             MAIL-RECEIVE-DATE OF TPS-MAIL-REC =
             MAIL-RECEIVE-DATE OF TPS-MAIL-HOLD
           PERFORM CREATE-RECEIVE-TABLE THRU CREATE-RECEIVE-TABLE-EXIT
           GO TO READ-ALL-RECEIVE-NUMBERS.
       READ-RECEIVE-NUMBERS-EXIT. EXIT.

       CREATE-RECEIVE-TABLE.
           MOVE MAIL-RECEIVE-NUMBER OF TPS-MAIL-REC
             TO NEXT-RECEIVE-NUMBER
                MAIL-RECEIVE-CODE  (THE-INDEX)
           MOVE MAIL-ADDRESOR-NAME OF TPS-MAIL-REC
             TO MAIL-RECEIVE-NAME  (THE-INDEX)
           IF   RECUR-PAYEE-RESIDENT-CODE  OF TPS-MAIL-REC
                IS NOT NUMERIC
           MOVE 0 TO RECUR-PAYEE-RESIDENT-CODE  OF TPS-MAIL-REC.
           MOVE RECUR-PAYEE-RESIDENT-CODE  OF TPS-MAIL-REC
             TO MAIL-RESIDENT-CODE(THE-INDEX)
           MOVE RECUR-DISPOSITION  OF TPS-MAIL-REC
             TO MAIL-DISP          (THE-INDEX)
           MOVE MAIL-CATEGORY-CODE OF TPS-MAIL-REC
             TO MAIL-RECEIVE-CATEGORY  (THE-INDEX).
           MOVE 0 TO MAIL-RECEIVE-TOTAL-BALANCE (THE-INDEX)
                     MAIL-RECEIVE-DUE-DATE (THE-INDEX)
                     MAIL-RECEIVE-CLOSING-DATE (THE-INDEX)
                     MAIL-RECEIVE-AMOUNT-BILLED (THE-INDEX).
          IF   MAIL-TOTAL-BALANCE OF TPS-MAIL-REC IS NUMERIC
          MOVE MAIL-TOTAL-BALANCE OF TPS-MAIL-REC
            TO MAIL-RECEIVE-TOTAL-BALANCE (THE-INDEX)
          IF   MAIL-DUE-DATE      OF TPS-MAIL-REC IS NUMERIC
          MOVE MAIL-DUE-DATE      OF TPS-MAIL-REC
            TO MAIL-RECEIVE-DUE-DATE (THE-INDEX).
          IF   MAIL-CLOSING-DATE  OF TPS-MAIL-REC IS NUMERIC
          MOVE MAIL-CLOSING-DATE  OF TPS-MAIL-REC
            TO MAIL-RECEIVE-CLOSING-DATE (THE-INDEX).
          IF   MAIL-AMOUNT-BILLED OF TPS-MAIL-REC IS NUMERIC
          MOVE MAIL-AMOUNT-BILLED OF TPS-MAIL-REC
            TO MAIL-RECEIVE-AMOUNT-BILLED (THE-INDEX).
          MOVE RECUR-PAYEE-ACCOUNT-NUMBER OF TPS-MAIL-REC
            TO MAIL-RECEIVE-ACCOUNT (THE-INDEX).
          INSPECT MAIL-RECEIVE-ACCOUNT (THE-INDEX)
                  REPLACING ALL X'00' BY X'20'.
          SET THE-INDEX UP BY 1.
       CREATE-RECEIVE-TABLE-EXIT.

       CLEAR-MAIL-RECEIVED.
          PERFORM VARYING THE-INDEX FROM 1 BY 1
                  UNTIL   THE-INDEX > MAXIMUM-ROWS
          MOVE HIGH-VALUES TO MAIL-RECEIVE-ROW (THE-INDEX)
          END-PERFORM.
       CLEAR-MAIL-RECEIVED-EXIT.


       FILE-ERROR.
           CALL TPSIOERR USING FILE-REQUEST.
           CANCEL TPSIOERR.
       FILE-ERROR-EXIT. EXIT.



       SET-THE-ACCOUNT-NUMBER.
            MOVE CLNT-PROFILE-ACCT-NO  TO MAIL-ACCT-NO  OF TPS-MAIL-REC.
            MOVE CLNT-PROFILE-SUB-ACCT TO MAIL-SUB-ACCT OF TPS-MAIL-REC.
       SET-THE-ACCOUNT-NUMBER-EXIT. EXIT.

       READ-MEMO.
          MOVE NOPE TO MEMO-WAS-FOUND.
          MOVE F-PRIME TO FILE-KEY.
          MOVE F-READ  TO FILE-ACTION.
          CALL TPSIOMEM USING FILE-REQUEST TPSMEMO-4
          IF A-SUCCESSFUL-OPERATION MOVE YES TO MEMO-WAS-FOUND.
          IF NO-RECORD-WAS-FOUND CONTINUE
          ELSE
             IF NOT A-SUCCESSFUL-OPERATION
             MOVE 'TPSMEMO ' TO FILE-NAME
             MOVE 'TPS1010-RMM' TO FILE-TEXT
             PERFORM FILE-ERROR THRU FILE-ERROR-EXIT.
       READ-MEMO-EXIT. EXIT.

       SET-DIARY-INDEX-UP-BY-1.
            SET DIARY-INDEX UP BY 1.
            MOVE SPACES TO MAIL-DIARY-ROW(DIARY-INDEX).
       SET-DIARY-INDEX-UP-BY-1-EXIT. EXIT.
       MAIL-DIARY.
            MOVE TPS-MAIL-REC TO TPS-MAIL-HOLD.
            PERFORM READ-RECEIVE-NUMBERS
               THRU READ-RECEIVE-NUMBERS-EXIT.
            MOVE TPS-MAIL-HOLD TO TPS-MAIL-REC.
            SORT MAIL-RECEIVE-DATA ON ASCENDING KEY
                                      MAIL-RECEIVE-CATEGORY
                                      MAIL-RECEIVE-NAME.
            PERFORM VARYING THE-INDEX FROM 1 BY 1
                    UNTIL   THE-INDEX > 1000
            MOVE HIGH-VALUES TO MAIL-DIARY-ROW (THE-INDEX)
                                PAYMENT-AUTHORIZATION-ROW (THE-INDEX)
            END-PERFORM.
            PERFORM VARYING THE-INDEX FROM 1 BY 1
                    UNTIL   THE-INDEX > 10
            MOVE 0 TO PIECE-COUNT (THE-INDEX)
            END-PERFORM.
            PERFORM VARYING THE-INDEX FROM 1 BY 1
                    UNTIL   THE-INDEX > 100
            MOVE 0 TO PIECES-PER-DISP(THE-INDEX)
            END-PERFORM.
            MOVE 0 TO PIECES-RECEIVED
                      FOR-PAYMENT
                      TOTAL-AMOUNT-DUE
                      TOTAL-MINIMUM-PAY
                      PENDING.
            MOVE ' pieces'     TO TOTAL-PIECE-WORD.
            MOVE ' were'       TO TOTAL-PIECE-WORD-R1.
            MOVE 'are     '  TO ITEMS-FOR-PAYMENT-WORD OF FOOTING-2
                                ITEMS-FOR-PAYMENT-WORD OF PAY-FOOTING-1.
            MOVE 'items '  TO ITEMS-FOR-PAYMENT-WORD-2 OF FOOTING-3
                              ITEMS-FOR-PAYMENT-WORD-2 OF PAY-FOOTING-1.
            MOVE 'are '        TO ITEMS-TO-FORWARD-WORD.
            MOVE ' items'      TO ITEMS-TO-FORWARD-WORD-2.
            MOVE ' items were' TO ITEMS-DISCARDED-WORD.
            MOVE ' items'      TO ITEMS-PENDING-WORD.
            MOVE SPACES TO NAME-OF-ADMINISTRATOR.
            SET THE-INDEX TO 1.
            SET DIARY-INDEX TO 1.
            SET PAYMENT-INDEX TO 1.
            MOVE SPACES TO CATEGORY-HOLD.
       MAIL-DIARY-LOOP.
            SET CATEGORY-INDEX TO 1.
            SET DISPOSITION-INDEX TO 1.
            IF MAIL-RECEIVE-ROW (THE-INDEX) = HIGH-VALUES
               GO TO MAIL-DIARY-EXIT.
            IF   MAIL-DIARY-ROW (DIARY-INDEX) < HIGH-VALUES
                 SET DIARY-INDEX UP BY 1
                 GO TO MAIL-DIARY-LOOP.

            IF MAIL-RECEIVE-CATEGORY (THE-INDEX) NOT EQUAL CATEGORY-HOLD
               IF CATEGORY-HOLD = SPACES
                  MOVE MAIL-RECEIVE-YYMMDD OF TPS-MAIL-REC
                    TO MAIL-DIARY-ROW(DIARY-INDEX)
                  MOVE MAIL-DIARY-ROW (DIARY-INDEX) TO DATE-RECEIVED
                  PERFORM SET-DIARY-INDEX-UP-BY-1
               END-IF
               SEARCH CATEGORY-TABLE
                      WHEN MAIL-RECEIVE-CATEGORY (THE-INDEX) =
                           SEARCH-CATEGORY-CODE (CATEGORY-INDEX)
                      MOVE SEARCH-CATEGORY-NAME (CATEGORY-INDEX)
                        TO MAIL-DIARY-CATEGORY(DIARY-INDEX)
                      PERFORM SET-DIARY-INDEX-UP-BY-1
                      MOVE HALF-A-LINE-OF-DASHES
                        TO MAIL-DIARY-CATEGORY(DIARY-INDEX)
                      PERFORM SET-DIARY-INDEX-UP-BY-1
               END-SEARCH
            END-IF.

            MOVE SPACES TO MAIL-DIARY-ROW(DIARY-INDEX).
            PERFORM SET-DIARY-INDEX-UP-BY-1.
            MOVE MAIL-RECEIVE-CATEGORY (THE-INDEX) TO CATEGORY-HOLD.
            MOVE MAIL-RECEIVE-ROW (THE-INDEX)
              TO MAIL-DIARY-ROW (DIARY-INDEX).
            ADD 1 TO PIECES-RECEIVED.
            IF MAIL-DIARY-RESIDE(DIARY-INDEX) IS NUMERIC
               MOVE MAIL-DIARY-RESIDE(DIARY-INDEX) TO MONTH-INDEX
               ADD 1 TO MONTH-INDEX
               ADD 1 TO PIECE-COUNT(MONTH-INDEX)
            END-IF.
            MOVE MAIL-DISP(THE-INDEX) TO MONTH-INDEX
            ADD 1 TO PIECES-PER-DISP(MONTH-INDEX).
************MOVE SPACES TO MAIL-DIARY-CODE(DIARY-INDEX).
            MOVE PIECES-RECEIVED TO MAIL-DIARY-CODE(DIARY-INDEX).
            SEARCH DISPOSITION-TABLE
                   WHEN MAIL-DISP (THE-INDEX) =
                        SEARCH-DISPOSITION-CODE (DISPOSITION-INDEX)
                   MOVE SEARCH-DISPOSITION-NAME (DISPOSITION-INDEX)
                     TO MAIL-DIARY-DISP (DIARY-INDEX)
                   PERFORM SET-DIARY-INDEX-UP-BY-1
            END-SEARCH.
************PERFORM SET-THE-RECEIVE-DATE
************   THRU SET-THE-RECEIVE-DATE-EXIT.
            IF MAIL-DISP (THE-INDEX) = '04'
               PERFORM ADD-TO-PAYMENT-REPORT
                  THRU ADD-TO-PAYMENT-REPORT-EXIT.
            MOVE MAIL-KEY OF TPS-MAIL-REC TO TPS-MEMO-KEY.
            MOVE MAIL-RECEIVE-CODE(THE-INDEX) TO MEMO-RECEIVE-NUMBER.
            PERFORM READ-MEMO THRU READ-MEMO-EXIT.
            IF NOT A-SUCCESSFUL-OPERATION GO TO INCREASE-THE-INDEX.
            PERFORM VARYING JPC FROM 1 BY 1 UNTIL JPC > 10
               IF TPS-MEMO-LINE (JPC) > SPACES
                  MOVE TPS-MEMO-LINE(JPC)
                    TO MAIL-DIARY-MEMO(DIARY-INDEX)
                  PERFORM SET-DIARY-INDEX-UP-BY-1
            END-PERFORM.
       INCREASE-THE-INDEX.
            SET THE-INDEX UP BY 1.
            PERFORM SET-DIARY-INDEX-UP-BY-1.
************MOVE A-LINE-OF-DASHES TO MAIL-DIARY-ROW (DIARY-INDEX).
************PERFORM SET-DIARY-INDEX-UP-BY-1.
            GO TO MAIL-DIARY-LOOP.
       MAIL-DIARY-EXIT.
            SORT MAIL-RECEIVE-DATA ON ASCENDING KEY
                                      MAIL-RECEIVE-CODE-X.
            MOVE SPACES TO CLIENT-NAME.
            MOVE CLNT-PROFILE-FIRST-NAME TO CLIENT-NAME.
            PERFORM VARYING THE-INDEX FROM 15 BY -1 UNTIL
                 CLIENT-FIRST-NAME (THE-INDEX) > SPACES
                 CONTINUE
            END-PERFORM.
            SET THE-INDEX UP BY 2.
            IF CLNT-PROFILE-MDDL-INIT IS GREATER THAN SPACES
               MOVE CLNT-PROFILE-MDDL-INIT TO CLIENT-NAME (THE-INDEX:1)
               SET THE-INDEX UP BY 1
               MOVE '.' TO CLIENT-NAME (THE-INDEX:1)
               SET THE-INDEX UP BY 2.
            MOVE CLNT-PROFILE-LAST-NAME TO CLIENT-NAME (THE-INDEX:20).
            PERFORM VARYING THE-INDEX FROM 48 BY -1 UNTIL
                 CLIENT-FIRST-NAME (THE-INDEX) > SPACES
                 CONTINUE
            END-PERFORM.
            SET THE-INDEX UP BY 2.
************MOVE RECV-CLNT-RECEIVE-DATE(1:2) TO CLIENT-NAME(THE-INDEX:2).
            SET THE-INDEX UP BY 2.
            MOVE '/'                    TO CLIENT-NAME (THE-INDEX:1).
            SET THE-INDEX UP BY 1.
************MOVE RECV-CLNT-RECEIVE-DATE(3:2) TO CLIENT-NAME(THE-INDEX:2).
            SET THE-INDEX UP BY 2.
            MOVE '/'                    TO CLIENT-NAME (THE-INDEX:1).
            SET THE-INDEX UP BY 1.
************MOVE RECV-CLNT-RECEIVE-DATE(5:2) TO CLIENT-NAME(THE-INDEX:2).
            MOVE CLIENT-NAME TO CLIENT-NAME-PAY.
            PERFORM VARYING THE-INDEX FROM 20 BY -1 UNTIL
                 DATE-RECEIVED-R   (THE-INDEX) > SPACES
                 CONTINUE
            END-PERFORM.
            SET THE-INDEX UP BY 1.
            MOVE '.' TO DATE-RECEIVED-R (THE-INDEX)
************CENTER THE HEADING.
            MOVE SPACES TO HEADING-2.
            PERFORM VARYING THE-INDEX FROM 48 BY -1 UNTIL
                 CLIENT-FIRST-NAME (THE-INDEX) > SPACES
                 CONTINUE
            END-PERFORM.
            COMPUTE THE-INDEX = (80 - THE-INDEX - 22) / 2.
            MOVE HEADING-2-X TO HEADING-2(THE-INDEX:).
            MOVE PIECES-RECEIVED    TO TOTAL-PIECES-RECEIVED.
            IF   PIECES-RECEIVED = 1
            MOVE ' piece '     TO TOTAL-PIECE-WORD.
            MOVE PIECES-R1          TO TOTAL-PIECES-R1.
            IF   PIECES-R1 = 1
                 MOVE ' was '       TO TOTAL-PIECE-WORD-R1.
            MOVE PIECES-PER-DISP(4) TO ITEMS-FOR-PAYMENT OF FOOTING-2
                                   ITEMS-FOR-PAYMENT OF PAY-FOOTING-1.
            IF   PIECES-PER-DISP(4) = 1
                 MOVE 'is      ' TO ITEMS-FOR-PAYMENT-WORD OF FOOTING-2
                                ITEMS-FOR-PAYMENT-WORD OF PAY-FOOTING-1
                 MOVE 'item  ' TO ITEMS-FOR-PAYMENT-WORD-2 OF FOOTING-3
                              ITEMS-FOR-PAYMENT-WORD-2 OF PAY-FOOTING-1.
            MOVE PIECES-PER-DISP(3) TO ITEMS-TO-FORWARD.
            IF   PIECES-PER-DISP(3) = 1
                 MOVE 'is  '        TO ITEMS-TO-FORWARD-WORD
                 MOVE ' item '      TO ITEMS-TO-FORWARD-WORD-2.
            MOVE PIECES-PER-DISP(2) TO ITEMS-DISCARDED.
            IF   PIECES-PER-DISP(2) = 1
                 MOVE ' item  was ' TO ITEMS-DISCARDED-WORD.
            MOVE PENDING            TO ITEMS-PENDING.
            IF   PENDING            = 1
                 MOVE ' item '      TO ITEMS-PENDING-WORD.
            MOVE SPACES TO NAME-OF-ADMINISTRATOR.
            MOVE LOGREC-ADMIN-FIRST-NAME TO NAME-OF-ADMINISTRATOR.
            PERFORM VARYING THE-INDEX FROM 15 BY -1 UNTIL
                 NAME-OF-ADMINISTRATOR-R (THE-INDEX) > SPACES
                 CONTINUE
            END-PERFORM.
            SET THE-INDEX UP BY 2.
            IF LOGREC-ADMIN-MID-INIT IS GREATER THAN SPACES
               MOVE LOGREC-ADMIN-MID-INIT
                 TO NAME-OF-ADMINISTRATOR (THE-INDEX:1)
               SET THE-INDEX UP BY 1
               MOVE '.'
                 TO NAME-OF-ADMINISTRATOR (THE-INDEX:1)
               SET THE-INDEX UP BY 2.
            MOVE LOGREC-ADMIN-LAST-NAME
              TO NAME-OF-ADMINISTRATOR (THE-INDEX:20).
            MOVE FOOTING-1 TO MAIL-DIARY-ROW(DIARY-INDEX).
            PERFORM SET-DIARY-INDEX-UP-BY-1.
            MOVE PAY-FOOTING-1
              TO PAYMENT-AUTHORIZATION-ROW (PAYMENT-INDEX).
            PERFORM SET-PAYMENT-INDEX-UP-BY-1
               THRU SET-PAYMENT-INDEX-UP-BY-1-EXIT.
            MOVE FOOTING-2 TO MAIL-DIARY-ROW(DIARY-INDEX).
            PERFORM SET-DIARY-INDEX-UP-BY-1.
            MOVE TOTAL-AMOUNT-DUE  TO PAYMENT-TOTAL-AMOUNT-DUE.
            MOVE TOTAL-MINIMUM-PAY TO PAYMENT-TOTAL-MINIMUM-PAY.
            MOVE PAY-FOOTING-2
              TO PAYMENT-AUTHORIZATION-ROW (PAYMENT-INDEX).
            PERFORM SET-PAYMENT-INDEX-UP-BY-1
               THRU SET-PAYMENT-INDEX-UP-BY-1-EXIT.
            MOVE FOOTING-3 TO MAIL-DIARY-ROW(DIARY-INDEX).
            PERFORM SET-DIARY-INDEX-UP-BY-1.
            MOVE PAY-FOOTING-3
              TO PAYMENT-AUTHORIZATION-ROW (PAYMENT-INDEX).
            PERFORM SET-PAYMENT-INDEX-UP-BY-1
               THRU SET-PAYMENT-INDEX-UP-BY-1-EXIT.
            MOVE FOOTING-4 TO MAIL-DIARY-ROW(DIARY-INDEX).
            PERFORM SET-DIARY-INDEX-UP-BY-1.
            MOVE PAY-FOOTING-4
              TO PAYMENT-AUTHORIZATION-ROW (PAYMENT-INDEX).
            PERFORM SET-PAYMENT-INDEX-UP-BY-1
               THRU SET-PAYMENT-INDEX-UP-BY-1-EXIT.
            IF   PENDING            > 0
                 MOVE FOOTING-5 TO MAIL-DIARY-ROW(DIARY-INDEX)
                 PERFORM SET-DIARY-INDEX-UP-BY-1.
            MOVE FOOTING-6 TO MAIL-DIARY-ROW(DIARY-INDEX)
                              PAYMENT-AUTHORIZATION-ROW(PAYMENT-INDEX).
            PERFORM SET-DIARY-INDEX-UP-BY-1.
            PERFORM SET-PAYMENT-INDEX-UP-BY-1
               THRU SET-PAYMENT-INDEX-UP-BY-1-EXIT.
            MOVE FOOTING-7 TO MAIL-DIARY-ROW(DIARY-INDEX)
                              PAYMENT-AUTHORIZATION-ROW(PAYMENT-INDEX).
            PERFORM SET-DIARY-INDEX-UP-BY-1.
            PERFORM SET-PAYMENT-INDEX-UP-BY-1
               THRU SET-PAYMENT-INDEX-UP-BY-1-EXIT.
            MOVE FOOTING-8 TO MAIL-DIARY-ROW(DIARY-INDEX)
                              PAYMENT-AUTHORIZATION-ROW(PAYMENT-INDEX).
            PERFORM SET-PAYMENT-INDEX-UP-BY-1
               THRU SET-PAYMENT-INDEX-UP-BY-1-EXIT.
************CALL INQUIRY   USING HEADING-2
************                     HEADING-3
************                     HEADING-3
************                     HEADING-3
************                     HEADING-4
************                     MAIL-DIARY-DATA(1).
            MOVE SPACES TO HEADING-2.
            PERFORM VARYING THE-INDEX FROM 48 BY -1 UNTIL
                 CLIENT-FIRST-NAME (THE-INDEX) > SPACES
                 CONTINUE
            END-PERFORM.
            COMPUTE THE-INDEX = (80 - THE-INDEX - 31) / 2.
            MOVE HEADING-2-PAY TO HEADING-2(THE-INDEX:).
            CALL INQUIRY   USING HEADING-2
                                 HEADING-3
                                 HEADING-3
                                 HEADING-3-PAY
                                 HEADING-4-PAY
                                 PAYMENT-AUTHORIZATION-DATA(1).
            CANCEL INQUIRY.
            EXIT.
       ADD-TO-PAYMENT-REPORT.
            MOVE SPACES TO PAYMENT-AUTHORIZATION-ROW(PAYMENT-INDEX).
            ADD 1 TO FOR-PAYMENT.
            MOVE FOR-PAYMENT
              TO PAYMENT-AUTHORIZATION-CODE(PAYMENT-INDEX).
            MOVE MAIL-RECEIVE-NAME (THE-INDEX)
              TO PAYMENT-AUTHORIZATION-NAME (PAYMENT-INDEX).
            MOVE MAIL-RECEIVE-ACCOUNT (THE-INDEX)
              TO PAYMENT-AUTHORIZATION-ACCOUNT (PAYMENT-INDEX).
            MOVE MAIL-RECEIVE-TOTAL-BALANCE(THE-INDEX)
              TO PAYMENT-AUTHORIZATION-BALANCE(PAYMENT-INDEX).
            ADD  MAIL-RECEIVE-TOTAL-BALANCE(THE-INDEX)
              TO TOTAL-AMOUNT-DUE.
            MOVE MAIL-RECEIVE-AMOUNT-BILLED(THE-INDEX)
              TO PAYMENT-AUTHORIZATION-MINIMUM (PAYMENT-INDEX).
            ADD  MAIL-RECEIVE-AMOUNT-BILLED(THE-INDEX)
              TO TOTAL-MINIMUM-PAY.
            MOVE '$_____'
              TO PAYMENT-AUTHORIZATION-ONLY (PAYMENT-INDEX).
            PERFORM SET-PAYMENT-INDEX-UP-BY-1
               THRU SET-PAYMENT-INDEX-UP-BY-1-EXIT.
            MOVE MAIL-RESIDENT-CODE (THE-INDEX)
              TO PAYMENT-AUTHORIZATION-RESIDE (PAYMENT-INDEX).
            MOVE MAIL-RECEIVE-DUE-DATE (THE-INDEX) (1:2)
              TO PAYMENT-AUTHORIZATION-DUEDATE(PAYMENT-INDEX)  (1:2).
            MOVE '/'
              TO PAYMENT-AUTHORIZATION-DUEDATE(PAYMENT-INDEX)  (3:1)
                 PAYMENT-AUTHORIZATION-DUEDATE(PAYMENT-INDEX)  (6:1).
            MOVE MAIL-RECEIVE-DUE-DATE (THE-INDEX) (3:2)
              TO PAYMENT-AUTHORIZATION-DUEDATE(PAYMENT-INDEX)  (4:2).
            MOVE MAIL-RECEIVE-DUE-DATE (THE-INDEX) (5:2)
              TO PAYMENT-AUTHORIZATION-DUEDATE(PAYMENT-INDEX)  (7:2).
            IF PAYMENT-AUTHORIZATION-DUEDATE(PAYMENT-INDEX) ='00/00/00'
             MOVE SPACES
               TO PAYMENT-AUTHORIZATION-DUEDATE (PAYMENT-INDEX).
            MOVE MAIL-RECEIVE-CLOSING-DATE (THE-INDEX) (1:2)
              TO PAYMENT-AUTHORIZATION-CLOSING(PAYMENT-INDEX)  (1:2).
            MOVE '/'
              TO PAYMENT-AUTHORIZATION-CLOSING(PAYMENT-INDEX)  (3:1)
                 PAYMENT-AUTHORIZATION-CLOSING(PAYMENT-INDEX)  (6:1).
            MOVE MAIL-RECEIVE-CLOSING-DATE (THE-INDEX) (3:2)
              TO PAYMENT-AUTHORIZATION-CLOSING(PAYMENT-INDEX)  (4:2).
            MOVE MAIL-RECEIVE-CLOSING-DATE (THE-INDEX) (5:2)
              TO PAYMENT-AUTHORIZATION-CLOSING(PAYMENT-INDEX)  (7:2).
            IF PAYMENT-AUTHORIZATION-CLOSING(PAYMENT-INDEX) ='00/00/00'
             MOVE SPACES
               TO PAYMENT-AUTHORIZATION-CLOSING (PAYMENT-INDEX).
            PERFORM SET-PAYMENT-INDEX-UP-BY-1
               THRU SET-PAYMENT-INDEX-UP-BY-1-EXIT.
            MOVE SPACES
               TO PAYMENT-AUTHORIZATION-ROW (PAYMENT-INDEX).
            PERFORM SET-PAYMENT-INDEX-UP-BY-1
               THRU SET-PAYMENT-INDEX-UP-BY-1-EXIT.
********    MOVE A-LINE-OF-DASHES
********       TO PAYMENT-AUTHORIZATION-ROW (PAYMENT-INDEX).
********    PERFORM SET-PAYMENT-INDEX-UP-BY-1
********       THRU SET-PAYMENT-INDEX-UP-BY-1-EXIT.
       ADD-TO-PAYMENT-REPORT-EXIT. EXIT.
       SET-PAYMENT-INDEX-UP-BY-1.
            SET PAYMENT-INDEX UP BY 1.
            MOVE SPACES TO PAYMENT-AUTHORIZATION-ROW(PAYMENT-INDEX).
       SET-PAYMENT-INDEX-UP-BY-1-EXIT. EXIT.
