000100 IDENTIFICATION DIVISION.
000200 PROGRAM-ID. TPS1000.
000300 AUTHOR. JOHN CURRAN.
000400***************************************************************
000500*    CALL TPS1010 (MAIL RECEIVING OR NEXT DAY MAIL RECEIVING) *
000600* 01/26/94 NEW PROGRAM                                        *
000700*    JC                                                       *
000800***************************************************************
000700*                    MAINTENANCE LOG                          *
      * 08/10/17 - CHANGE SCREENIO TO GUISCREENS.                AC *
000700* 06/25/01 ADDED NEXT DAY PROCESSING, CHECK VERIFY.DAT TO SEE *
000700*    JM    IF CHECKS WERE RUN. ADD MAIN-MENU-FUNCTION & DATE  *
000700*          TO TPS1010 CALL STATEMENT.                         *
000700* 11/01/98 ADDED CODE TO BYPASS PANEL, CALL TPS1010 DIRECT  TS*
000800***************************************************************
000900 ENVIRONMENT DIVISION.
001000 CONFIGURATION SECTION.
001100 SOURCE-COMPUTER. IBM-PS2.
001200 OBJECT-COMPUTER. IBM-PS2.
001300 INPUT-OUTPUT SECTION.
001400 FILE-CONTROL.
017400
017800     SELECT VERIFYCK  ASSIGN TO '\TPS\PROD\FILES\VERIFYCK.DAT'
017400                      ORGANIZATION IS LINE SEQUENTIAL
017400                      FILE STATUS IS FILE-STATUS.
017400
002000 DATA DIVISION.
002100 FILE SECTION.
017400
017800 FD  VERIFYCK
017800     DATA RECORDS IS VRFYREC
017800     RECORD CONTAINS 700 CHARACTERS.
017800 01 VRFYREC.
017800    05 VRFY-ID                     PIC  X(14).
017800    05 FILLER                      PIC  X(01).
017800    05 VRFY-DATE                   PIC  X(08).
017800    05 FILLER                      PIC  X(01).
017800    05 VRFY-STATUS                 PIC  X(01).
017800       88 VRFY-DOWNLOAD-COMPLETE        VALUE '0'.
017800       88 VRFY-DOWNLOAD-INCOMPLETE      VALUE '1'.
017800    05 FILLER                      PIC  X(675).
017800
002600 WORKING-STORAGE SECTION.


***************** WINFORMS SCREEN DEFINITION **********

       01 NEXTDAY type TPS000.NEXTDAYForm.
       01 TPS0035 type TPS000.TPS0035Form.

       01 TPS0035-DISPLAY-FLAG PIC 9(01) VALUE 0.

       01 CLOSE-ALL-FORMS-FLAG PIC 9(01) VALUE 0.
       01 SCREEN-NAME PIC x(10).

       01 WS-CURRENT-X                            PIC 9(04).
       01 WS-CURRENT-Y                            PIC 9(04).
       01 WS-CURRENT-XY-PARM.
          05 WS-X-PARM                            PIC 9(04).
          05 WS-Y-PARM                            PIC 9(04).

       COPY "ds-cntrl.v1".

**********************************************************
005100 01  TPS-CLIENT-REC.
005200     COPY "TPSCLINT.CPY".
       01  CAL-REC.
           COPY "TPSCALEN.CPY".
003300

003400    COPY "KEYVALUE.CPY".
003500    COPY "TPSFILES.CPY".

       01  GUISCREEN               PIC x(08) VALUE 'GS      '.
003600 01 FILESPEC                   PIC X(80) VALUE SPACES.
004100 01 SCRNIO                     PIC X(06) VALUE 'SCRNIO'.
004200 01 TPSIO005                   PIC X(08) VALUE 'TPSIO005'.
       01 TPSIO018                   PIC X(08) VALUE 'TPSIO018'.
004300 01 TPSIOERR                   PIC X(08) VALUE 'TPSIOERR'.
006200 01 TPSDATES                   PIC X(08) VALUE 'TPSDATES'.
006200 01 TPS1010                    PIC X(08) VALUE 'TPS1010 '.

012600 01  WS-DATE-REQUEST.
012700     05  WS-DATE-PARAM          PIC  9(02).
012900     05  WS-DATE-TENBYTES       PIC  X(20) VALUE SPACES.
013100     05  FILLER REDEFINES WS-DATE-TENBYTES.
013200         10  WS-DATE-REFORM         PIC  X(06).
013300         10  WS-DATE-EXTEND         PIC  X(04).
013400         10  FILLER                 PIC  X(10).
013600     05  FILLER REDEFINES WS-DATE-TENBYTES.
013700         10  WS-DATE-REFORM-LEN06   PIC  X(06).
013800         10  FILLER                 PIC  X(14).
014000     05  FILLER REDEFINES WS-DATE-TENBYTES.
014100         10  WS-DATE-REFORM-LEN08   PIC  X(08).
014200         10  FILLER                 PIC  X(12).
014400     05  FILLER REDEFINES WS-DATE-TENBYTES.
014500         10  WS-DATE-REFORM-LEN10   PIC  X(10).
014600         10  FILLER                 PIC  X(10).
014700
       01  WS-SUB                         PIC  9(02)  VALUE  0.
       01  HOL-SUB                        PIC  9(02)  VALUE 25.
018400 01  WS-TODAYS-DATE-YMD             PIC  9(06).
018400 01  WS-TODAYS-DATE-CYMD            PIC  9(08).
018400 01  HOLD-TODAYS-DATE-CYMD          PIC  9(08).
014900
000100 01 HOLIDAY-TABLE               PIC X(108).
005600 01 HOLIDAY-REDEF REDEFINES HOLIDAY-TABLE.
005700    05 HOLIDAY-REDEF OCCURS 27 TIMES.
005800       10 HOLIDAY-DATE          PIC  9(04).
006000

005300 LINKAGE SECTION.
005400 01 TPS-LOGON.
005500     COPY "TPSLOGON.CPY".
005600 01 TPS-PROFILE.
005700     COPY "TPSPROFL.CPY".
005800 01 TPS-TOMS-PARAMETERS PIC X(01).
005900 01 MAIN-MENU-FUNCTION  PIC 9(02).
091400    88 NEXT-DAY-PROCESSING   VALUE 06.
014900
       01 CURRENT-XY-PARAMETERS PIC 9(08).



006200 PROCEDURE DIVISION USING TPS-LOGON
                                TPS-PROFILE
006300                          TPS-TOMS-PARAMETERS
                                MAIN-MENU-FUNCTION
                                CURRENT-XY-PARAMETERS.


006400 TPS1000-BEGIN.

      *********** INITIALIZE WINFORMS SCREENS **********

       set NEXTDAY to new TPS000.NEXTDAYForm().
       set TPS0035 to new TPS000.TPS0035Form().

      **************************************************

            MOVE CURRENT-XY-PARAMETERS(1:4) TO WS-CURRENT-X.
            MOVE CURRENT-XY-PARAMETERS(5:4) TO WS-CURRENT-Y.

           MOVE CURRENT-XY-PARAMETERS(1:4) TO WS-CURRENT-X
                                              WS-X-PARM.
           MOVE CURRENT-XY-PARAMETERS(5:4) TO WS-CURRENT-Y
                                              WS-Y-PARM.
018900
018100      ACCEPT WS-TODAYS-DATE-YMD FROM DATE.
018300      MOVE 01                   TO WS-DATE-PARAM.
018400      MOVE WS-TODAYS-DATE-YMD   TO WS-DATE-REFORM.
018500      MOVE SPACES               TO WS-DATE-EXTEND.
018700      CALL TPSDATES USING WS-DATE-REQUEST.
018900      MOVE WS-DATE-REFORM-LEN08 TO WS-TODAYS-DATE-CYMD.
018900      MOVE WS-TODAYS-DATE-CYMD  TO HOLD-TODAYS-DATE-CYMD.
018900
      *JM06/01 ADD MAIN-MENU-FUNCTION & DATE TO CALL TPS1010
      ******** WHEN DOING NEXT DAY RECEIVING.
            IF NEXT-DAY-PROCESSING
               PERFORM 0100-VERIFY-CHECK-RUN THRU 0100-EXIT
               PERFORM 350-LOAD-HOLIDAYS THRU 350-EXIT.
               PERFORM 0200-FIND-NEXT-DAY THRU 0200-EXIT.
018900
009100     CALL TPS1010 USING TPS-LOGON
009200                        TPS-PROFILE
009200                        TPS-CLIENT-REC
009200                        MAIN-MENU-FUNCTION
009200                        WS-TODAYS-DATE-CYMD
                              CURRENT-XY-PARAMETERS.

009300      CANCEL TPS1010.
            MOVE CURRENT-XY-PARAMETERS(1:4) TO WS-CURRENT-X.
            MOVE CURRENT-XY-PARAMETERS(5:4) TO WS-CURRENT-Y.

       TPS1000-END-PROGRAM.

           INITIALIZE CURRENT-XY-PARAMETERS.
           MOVE WS-CURRENT-X TO CURRENT-XY-PARAMETERS(1:4).
           MOVE WS-CURRENT-Y TO CURRENT-XY-PARAMETERS(5:4).

           IF CLOSE-ALL-FORMS-FLAG = 0
               SET NEXTDAY::KEY-PRESSED TO "End Key"
               SET TPS0035::KEY-PRESSED TO "End Key"
               INVOKE NEXTDAY::Close
               INVOKE TPS0035::Close
               MOVE 1 TO CLOSE-ALL-FORMS-FLAG
           END-IF.

            EXIT PROGRAM GIVING CURRENT-XY-PARAMETERS.


       0100-VERIFY-CHECK-RUN.

            OPEN INPUT VERIFYCK.
            IF NOT A-SUCCESSFUL-OPERATION
               MOVE 'VERIFY'   TO FILE-NAME
               MOVE 'TPS1000-OPEN' TO FILE-TEXT
               PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
               GO TO TPS1000-END-PROGRAM.

            READ VERIFYCK INTO VRFYREC
               AT END GO TO 0100-EXIT.
            IF NOT A-SUCCESSFUL-OPERATION
               MOVE 'VERIFY'   TO FILE-NAME
               MOVE 'TPS1000-READ' TO FILE-TEXT
               PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
               CLOSE VERIFYCK
               GO TO 0100-EXIT.

           IF VRFY-DOWNLOAD-COMPLETE AND
             VRFY-DATE = HOLD-TODAYS-DATE-CYMD
               CONTINUE
           ELSE
               MOVE 1 TO TPS0035::SPLASH-SCREEN-FLAG
               IF TPS0035-DISPLAY-FLAG = 0
                   SET TPS0035::X-POINT TO WS-X-PARM
                   SET TPS0035::Y-POINT TO WS-Y-PARM
                   SET TPS0035::Width TO 1
                   SET TPS0035::Height TO 1
                   INVOKE TPS0035::Show
                   SET TPS0035::Width TO 1205
                   SET TPS0035::Height TO 793
                   INVOKE TPS0035::Show
                   MOVE 1 TO TPS0035-DISPLAY-FLAG
               END-IF
               MOVE 0 TO TPS0035::SPLASH-SCREEN-FLAG

               SET NEXTDAY::X-POINT TO WS-X-PARM
               SET NEXTDAY::Y-POINT TO WS-Y-PARM
               INVOKE NEXTDAY::ShowDialog
               MOVE NEXTDAY::SCREEN-NAME TO SCREEN-NAME
               MOVE NEXTDAY::Location::X TO WS-X-PARM
                 WS-CURRENT-X
               MOVE NEXTDAY::Location::Y TO WS-Y-PARM
                 WS-CURRENT-Y
               INVOKE TPS0035::Hide
               MOVE 0 TO TPS0035-DISPLAY-FLAG

               CLOSE VERIFYCK
               GO TO TPS1000-END-PROGRAM
           END-IF.

           CLOSE VERIFYCK.

       0100-EXIT.
            EXIT.

       0200-FIND-NEXT-DAY.

            MOVE 21                   TO WS-DATE-PARAM.
            MOVE WS-TODAYS-DATE-CYMD  TO WS-DATE-REFORM-LEN08.
            MOVE '001'                TO WS-DATE-REFORM-LEN08(9:3).
            CALL TPSDATES USING WS-DATE-REQUEST.
            MOVE WS-DATE-REFORM-LEN08 TO WS-TODAYS-DATE-CYMD.
      ********* CHECK NEXT DAY FOR HOLIDAY **********
            PERFORM 0300-CHECK-HOLIDAY THRU 0300-EXIT.

      ********* CHECK FOR WEEKEND **********
            MOVE 23                   TO WS-DATE-PARAM
            MOVE WS-TODAYS-DATE-CYMD  TO WS-DATE-REFORM-LEN08
            CALL TPSDATES USING WS-DATE-REQUEST
      ********* CHECK FOR SUNDAY AND HOLIDAY ON MONDAY **********
            IF WS-DATE-REFORM-LEN08(9:1) = 0
               MOVE 21                TO WS-DATE-PARAM
               MOVE '001'             TO WS-DATE-REFORM-LEN08(9:3)
               CALL TPSDATES USING WS-DATE-REQUEST
               MOVE WS-DATE-REFORM-LEN08 TO WS-TODAYS-DATE-CYMD
               PERFORM 0300-CHECK-HOLIDAY THRU 0300-EXIT.
      ********* CHECK FOR SATURDAY AND HOLIDAY ON MONDAY **********
            IF WS-DATE-REFORM-LEN08(9:1) = 6
               MOVE 21                TO WS-DATE-PARAM
               MOVE '002'             TO WS-DATE-REFORM-LEN08(9:3)
               CALL TPSDATES USING WS-DATE-REQUEST
               MOVE WS-DATE-REFORM-LEN08 TO WS-TODAYS-DATE-CYMD
               PERFORM 0300-CHECK-HOLIDAY THRU 0300-EXIT.


       0200-EXIT.
            EXIT.

       0300-CHECK-HOLIDAY.

      ****** CHECK FOR BANK HOLIDAY ********
          MOVE 1                        TO WS-SUB.

       0300-CONTINUE.
          IF WS-SUB > HOL-SUB
             GO TO 0300-EXIT.

          IF WS-TODAYS-DATE-CYMD(5:4)
                                = HOLIDAY-DATE(WS-SUB)
             MOVE 26                    TO WS-SUB
             MOVE 21                    TO WS-DATE-PARAM
             MOVE WS-TODAYS-DATE-CYMD   TO WS-DATE-REFORM-LEN08
             MOVE '001'                 TO WS-DATE-REFORM-LEN08(9:3)
             CALL TPSDATES USING WS-DATE-REQUEST
             MOVE WS-DATE-REFORM-LEN08  TO WS-TODAYS-DATE-CYMD
            ELSE
             ADD 1                      TO WS-SUB
             GO TO 0300-CONTINUE
           END-IF.

       0300-EXIT.
            EXIT.

       350-LOAD-HOLIDAYS.
          MOVE '9999999999'             TO CAL-KEY-ACCT-NO.
          MOVE '00'                     TO CAL-KEY-SUB-ACCT.
          MOVE ZEROS                    TO CAL-KEY-DATE.
          MOVE WS-TODAYS-DATE-CYMD(1:4) TO CAL-KEY-DATE(1:4).
          MOVE ZERO                     TO WS-SUB.

          MOVE F-PRIME      TO FILE-KEY.
          MOVE F-OPEN-INPUT TO FILE-ACTION.
          CALL TPSIO018 USING FILE-REQUEST CAL-REC.
          IF NOT A-SUCCESSFUL-OPERATION
             MOVE 'CALENDAR' TO FILE-NAME
             MOVE 'OPEN    '    TO FILE-TEXT
             CALL TPSIOERR USING FILE-REQUEST
                                 WS-CURRENT-XY-PARM
             GO TO 350-EXIT
           END-IF.

          MOVE F-PRIME TO FILE-KEY.
          MOVE F-START TO FILE-ACTION.
          CALL TPSIO018 USING FILE-REQUEST CAL-REC.
          IF END-OF-FILE-WAS-REACHED OR NO-RECORD-WAS-FOUND
             GO TO 350-EXIT
           END-IF.
          IF NOT A-SUCCESSFUL-OPERATION
             MOVE 'CALENDAR' TO FILE-NAME
             MOVE 'START  '     TO FILE-TEXT
             CALL TPSIOERR USING FILE-REQUEST
                                 WS-CURRENT-XY-PARM
             GO TO 350-EXIT
           END-IF.

       350-CONTINUE.
          IF WS-SUB > 25
             GO TO 350-EXIT
           END-IF.

          IF CAL-KEY-DATE(1:4) NOT = WS-TODAYS-DATE-CYMD(1:4)
             GO TO 350-EXIT
           END-IF.

          MOVE F-PRIME TO FILE-KEY.
          MOVE F-READ-NEXT TO FILE-ACTION.
          CALL TPSIO018 USING FILE-REQUEST CAL-REC.
          IF END-OF-FILE-WAS-REACHED
             GO TO 350-EXIT
           END-IF.
          IF NOT A-SUCCESSFUL-OPERATION
             MOVE 'CALENDAR' TO FILE-NAME
             MOVE 'READNEXT'    TO FILE-TEXT
             CALL TPSIOERR USING FILE-REQUEST
                                 WS-CURRENT-XY-PARM
             GO TO 350-EXIT
           END-IF.

          IF CAL-APPT-APPOINT-DATA(37:1) = 'B'
             ADD 1                        TO WS-SUB
             MOVE CAL-KEY-DATE-MM(1:4)    TO HOLIDAY-DATE(WS-SUB)
             GO TO 350-CONTINUE
            ELSE
             GO TO 350-CONTINUE
           END-IF.

       350-EXIT.

           INITIALIZE CURRENT-XY-PARAMETERS.
           MOVE WS-CURRENT-X TO CURRENT-XY-PARAMETERS(1:4).
           MOVE WS-CURRENT-Y TO CURRENT-XY-PARAMETERS(5:4).

           EXIT.


011100
011200 FILE-ERROR.
011300     CALL TPSIOERR USING FILE-REQUEST
                               WS-CURRENT-XY-PARM.
011400     CANCEL TPSIOERR.

            MOVE WS-CURRENT-XY-PARM(1:4) TO WS-CURRENT-X.
            MOVE WS-CURRENT-XY-PARM(5:4) TO WS-CURRENT-Y.

           INITIALIZE CURRENT-XY-PARAMETERS.
           MOVE WS-CURRENT-X TO CURRENT-XY-PARAMETERS(1:4).
           MOVE WS-CURRENT-Y TO CURRENT-XY-PARAMETERS(5:4).

011500 FILE-ERROR-EXIT. EXIT.
