001000 IDENTIFICATION DIVISION.
001100 PROGRAM-ID. TPS052.
001200 AUTHOR. T.S.
002600***************************************************************
002700*           P.A. SYSTEM MONITOR MAIL ON HOLD DISPLAY          *
002800***************************************************************
001300***************************************************************
001600*                  MAINTENANCE LOG                            *
001001* 07/13/17 CHANGED GUI                                   AC *
001600* 03/13/03 - expanded linkage parm area for call to tpsview   *
001600*    ts      from 31 to 100 bytes.......                      *
001600* 07/23/98 - ADDED CODE TO CLEAR RED FIELDS PANEL TPS0052A    *
001600*    TS      WHEN PAGING UP                                   *
001600*                                                             *
001700***************************************************************
002900 ENVIRONMENT DIVISION.
003000 CONFIGURATION SECTION.
003100 SOURCE-COMPUTER. IBM-PS2.
003200 OBJECT-COMPUTER. IBM-PS2.
003300 FILE-CONTROL.
017100     SELECT  TPS-DISPOSITION-FILE
017200             ASSIGN TO "\tps\prod\files\disposit.men"
017300             ORGANIZATION IS LINE SEQUENTIAL
017400             FILE STATUS IS TPS-FILE-STATUS.
003400***  SELECT PRT-FILE  ASSIGN TO EXTERNAL LISTFILE
003500     SELECT PRT-FILE  ASSIGN TO "C:\TPS\APP\PROFL.TXT"
003600         ORGANIZATION IS LINE SEQUENTIAL
003700         FILE STATUS IS TPS-FILE-STATUS.
003800 DATA DIVISION.
003900 FILE SECTION.
021300 FD  TPS-DISPOSITION-FILE
021400     DATA RECORD  IS TPS-DISPOSITION-INPUT
021500     LABEL RECORDS STANDARD.
021600 01  TPS-DISPOSITION-INPUT            PIC X(80).
004000 FD  PRT-FILE
004100     LABEL RECORDS ARE OMITTED
004200     RECORD CONTAINS 200 CHARACTERS.
004300 01  PRT-RECORD.
004400********05  PRT-WHO                           PIC  X(36).
004500        05  PRT-WHO                           PIC  X(20).
004600        05  FILLER                            PIC  X(01).
004700        05  PRT-WHEN                          PIC  X(08).
004800        05  FILLER                            PIC  X(01).
004900        05  PRT-WHAT                          PIC  X(40).
005000        05  FILLER                            PIC  X(01).
005100        05  PRT-ACCT-NO                       PIC  9(10).
005200        05  FILLER                            PIC  X(01).
005300
005400
005500
005600
005700
005800 WORKING-STORAGE SECTION.
005900     COPY "TPSFILES.CPY".
006000     COPY "KEYVALUE.CPY".
006400
558600 01  DUMMY-2BYTE-REC              PIC  X(02).
006400
006800 01  TPS-PROFL-REC.
006900     COPY "TPSPROFL.CPY".
007000
007100 01  TPS-LOGON-REC.
007200     COPY "TPSLOGON.CPY".
008800
008900 01 TPS-RESIDE-REC.
009000     COPY "TPSRESID.CPY".
009100
009500 01 TPS-MAIL-REC.
009600    COPY "TPSMAIL.CPY".
009100
009500 01 TPS-CATMO-REC.
009600    COPY "TPSCATMO.CPY".
009700
009800 01 TPS-PAMON-REC.
009900    COPY "TPSPAMON.CPY".
010000
010100 01 SAV-PAMON-REC              PIC  X(600).
010900
011000 01 LAST-RECON-KEY             PIC  X(28).                                      00052200
011100
011300 01 TPS052-PARAMETERS.
011400     05 SELECTED-ON-HOLD-ACCT  PIC  X(10).
011700
012100
012110*   LEAVE THIS ENTRY SEPERATE............................
012111 01 TPSIO027        PIC X(08) VALUE 'TPSIO027'.
012112*   LEAVE THIS ENTRY SEPERATE............................
012120
012200 01  GUISCREEN      PIC X(08) VAlUE 'GS      '.
012130
012200 01  PROGRAM-NAMES.
012300     10 SCREENIO    PIC X(08) VALUE 'SCRNIO  '.
012500     10 TPSIOREC    PIC X(08) VALUE 'TPSIOREC'.
012500     10 TPSIOMEM    PIC X(08) VALUE 'TPSIOMEM'.
012900     10 TPSIO001    PIC X(08) VALUE 'TPSIO001'.
013000     10 TPSIO004    PIC X(08) VALUE 'TPSIO004'.
013100     10 TPSIO006    PIC X(08) VALUE 'TPSIO006'.
013200     10 TPSIO008    PIC X(08) VALUE 'TPSIO008'.
013300     10 TPSIO009    PIC X(08) VALUE 'TPSIO009'.
013400     10 TPSIO012    PIC X(08) VALUE 'TPSIO012'.
013500     10 TPSIO013    PIC X(08) VALUE 'TPSIO013'.
013600     10 TPSIO014    PIC X(08) VALUE 'TPSIO014'.
013700     10 TPSIO015    PIC X(08) VALUE 'TPSIO015'.
013700     10 TPSIO016    PIC X(08) VALUE 'TPSIO016'.
013800     10 TPSIO022    PIC X(08) VALUE 'TPSIO022'.
013900     10 TPSIO025    PIC X(08) VALUE 'TPSIO025'.
014100     10 TPSIOERR    PIC X(08) VALUE 'TPSIOERR'.
014200     10 TPSCHART    PIC X(08) VALUE 'TPSCHART'.
014300     10 TPSDATES    PIC X(08) VALUE 'TPSDATES'.
014400     10 FLOATBIG    PIC X(08) VALUE 'FLOATBIG'.
014600     10 TPSVIEW     PIC X(08) VALUE 'TPSVIEW '.
014700     10 FILLER      PIC X(08) VALUE HIGH-VALUES.
014800 01  PROGRAM-NAMES-R REDEFINES PROGRAM-NAMES.
014900     10  PROGRAM-NAME  PIC  X(08) OCCURS 30 TIMES.

      *******WINFORMS SCREEN DEFINITION ***** 

       01 TPS0052A type TPS000.TPS0052AForm.

       01 TPS0052A-TABLE.
         05 TPS0052A-ADDRESSOR-NAME-TBL PIC X(36) OCCURS 16 TIMES.
         05 TPS0052A-CATEGORY-TBL PIC X(26) OCCURS 16 TIMES.
         05 TPS0052A-RECEIVE-DATE-TBL PIC 9(06) OCCURS 16 TIMES.
         05 TPS0052A-RECEIVE-NUMBER-TBL PIC 9(05) OCCURS 16 TIMES.

       01 TPS0052A-IDX PIC 9(02).
       01 TMP-DATE PIC 9(06).
       01 TMP-TIME PIC X(07).
       01 SCREEN-NAME PIC x(10).
       01 WS-CURRENT-X                            PIC 9(04).
       01 WS-CURRENT-Y                            PIC 9(04).
       01 WS-CURRENT-XY-PARM.
          05 WS-X-PARM                            PIC 9(04).
          05 WS-Y-PARM                            PIC 9(04).

       COPY "ds-cntrl.v1".


       
*******************************************
015500    COPY TPSLOCKD.COB.
015500    COPY TPS0050J.COB.

016900
015500    COPY TPS0052B.COB.
048000                                                                                     45500
015500    COPY TPS0052C.COB.
015600 01 FILLER REDEFINES TPS0052C-4.
016000           10 PA-NEW-DISPOSIT-STUFF       PIC  X(496).
016100           10 FILLER REDEFINES PA-NEW-DISPOSIT-STUFF
016100                                      OCCURS 16 TIMES.
FLD005              15 PA-ONHOLD-NEW-DISPOSIT   PIC  X(31).
048000                                                                                     45500
048100    COPY TPSR0100.COB.                                                              45600
048200 01 TPSR0100-POPUP REDEFINES                                                         45700
048300       TPSR0100-4.                                                                   45800
048400       10 FILLER               PIC X(60).                                            45900
048500       10 TPSR0100-POPUP-LINE  PIC X(60) OCCURS 18 TIMES.                            46
048600                                                                                     46100
047000    COPY "TPSMEMO.COB".
047100 01 TPSMEMO-USER-FIELDS-R REDEFINES TPSMEMO-4.
047200       10  MEMO-ACCT-NO               PIC  X(10).
047300       10  MEMO-SUB-ACCT              PIC  X(02).
047400       10  MEMO-RECEIVE-DATE          PIC  X(08).
047500       10  MEMO-RECEIVE-NUMBER        PIC  X(03).
047600       10 TPS-MEMO-LINE PIC X(50) OCCURS 10 TIMES INDEXED BY IDX.
047700       10 TPS-MEMO-LINE-R REDEFINES TPS-MEMO-LINE.
047800          20 MEMO-TEXT PIC X(500).
047900             88 NO-MEMO-WAS-ENTERED    VALUE SPACES.
020100
020100
080100 01 DISPOSITION-DATA OCCURS 050 TIMES.
080200    10 DISPOSITION-ROW.
080300       20 DISPOSITION-CODE         PIC X(02).
080400       20 FILLER                   PIC X(01).
080500       20 DISPOSITION-DESCRIPTION  PIC X(28).
080600       20 FILLER                   PIC X(49).
083400
020100
020100
020100
020100
020200 01 TABLE-IDX                    PIC S9(04) COMP.
020300 01 SAVE-TABLE-IDX               PIC S9(04) COMP.
020400*         120 BYTES PER ENTRY X 200 SPOTS = 24000 BYTES.
020500 01 TABLE-ONHOLD.
020600        05 TABLE-ONHOLD-STUFF               PIC  X(24000).
020700        05 TABLE-ONHOLD-STUFF-R REDEFINES
020700                        TABLE-ONHOLD-STUFF OCCURS 200 TIMES
FLD007             DESCENDING TABLE-ONHOLD-RECEIVE-DATE-LONG
FLD008             ASCENDING TABLE-ONHOLD-RECEIVE-NUMBER.
FLD005           10 TABLE-ONHOLD-ADDRESSOR-NAME    PIC  X(36).
FLD006           10 TABLE-ONHOLD-CATEGORY          PIC  X(26).
FLD007           10 TABLE-ONHOLD-RECEIVE-DATE      PIC  9(06).
FLD008           10 TABLE-ONHOLD-RECEIVE-NUMBER    PIC  9(05).
021500           10 TABLE-ONHOLD-RECEIVE-DATE-LONG PIC  9(08).
021800
021900                                                                                     00017400
022000 01 TPS-PARM-VIEW.                                                                                                
022000    05 filler      PIC X(31) VALUE '\BAT\TPSVIEW.BAT'.                                                            
022000*03/13/03                                                                                                         
022000    05 filler      PIC X(69) VALUE spaces.                                                                        
021900                                                                                     00017400
022100 01 TPS-PARM-PRINT.                                                                                               
022100    05 filler      PIC X(31) VALUE '\BAT\TPSPRINT.BAT'.                                                           
022000*03/13/03                                                                                                         
022000    05 filler      PIC X(69) VALUE spaces.                                                                        
022200
022300 01  TPS-FILE-STATUS                       PIC XX.
022400     88  TPS-CARRIER-FILE-OK VALUE '00', '02'.
022500
022600 01 SAVE-PAM-CONTROL-DATE       PIC  9(08).
022700 01 TODAYS-DATE-YMD             PIC  9(06).
022800 01 TODAYS-DATE-MDY             PIC  9(06).
022900 01 MONTH-DAY                   PIC  X(05) VALUE 'XX/XX'.
023000 01 TODAYS-TIME                 PIC  9(08).
023100 01 FILLER REDEFINES TODAYS-TIME.
023200    05 TODAYS-TIME-HH           PIC  9(02).
023300    05 TODAYS-TIME-MM           PIC  9(02).
023400    05 TODAYS-TIME-SS           PIC  9(04).
023500 01 PA-STUFF-STATUS-TIME         PIC  9(08).
023600 01 FILLER REDEFINES PA-STUFF-STATUS-TIME.
023700    05 PA-STUFF-STATUS-TIME-HHMM PIC  9(04).
023800    05 FILLER                    PIC  9(04).
023900 01 WORK-TIME-HH                PIC  9(02).
024000 01 WORK-DATE-YY                PIC  9(02).
024700 01 TODAYS-DATE-CYMD            PIC  9(08).
024700 01 TODAYS-DATE-CYMD-LESS30     PIC  9(08).
025000
338300 01 DISPOSITION-CHANGED.
025900    05 FILLER PIC X(18) VALUE '******* ITEM NO LO'.
025900    05 FILLER PIC X(18) VALUE 'NGER ON HOLD *****'.
025500
025700 01 F1-F2-F3-F4-MSG.
025800    05 FILLER PIC X(17) VALUE 'F1-CHANGE STATUS,'.
025900    05 FILLER PIC X(20) VALUE 'F2-VIEW IMG,F3-PRINT'.
026000    05 FILLER PIC X(20) VALUE ' IMG,F4-RECODE CHART'.
026100    05 FILLER PIC X(20) VALUE ',END-PREVIOUS       '.
026200
025500
025700 01 PF-KEY-LEGEND-MSG.
025800    05 FILLER PIC X(20) VALUE '  SELECT PF KEY FUNC'.
025900    05 FILLER PIC X(20) VALUE 'TION FROM LEGEND OR '.
026000    05 FILLER PIC X(20) VALUE 'END KEY FOR PREVIOUS'.
026000    05 FILLER PIC X(20) VALUE ' PANEL.             '.
026872
026880
026900 01  WS-DATE-REQUEST.
027000     05  WS-DATE-PARAM          PIC  9(02).
027100     05  WS-DATE-TENBYTES       PIC  X(20) VALUE SPACES.
027200     05  FILLER REDEFINES WS-DATE-TENBYTES.
027300         10  WS-DATE-REFORM         PIC  X(06).
027400         10  WS-DATE-EXTEND         PIC  X(04).
027500         10  FILLER                 PIC  X(10).
027600     05  FILLER REDEFINES WS-DATE-TENBYTES.
027700         10  WS-DATE-REFORM-LEN06   PIC  X(06).
027800         10  FILLER                 PIC  X(14).
027900     05  FILLER REDEFINES WS-DATE-TENBYTES.
028000         10  WS-DATE-REFORM-LEN08   PIC  9(08).
028001         10  FILLER REDEFINES WS-DATE-REFORM-LEN08.
028002             20 FILLER              PIC  9(04).
028007             20 WS-MONTH-AND-DAY    PIC  9999.
028009                88 ITS-A-HOLIDAY VALUES 0101 0704 1225.
028010                88 ITS-NEW-YEARS-DAY
028011                                 VALUES 0102 0103.
028012                88 ITS-MARTIN-LUTHER-KING-DAY
028013                                 VALUES 0115 THRU 0121.
028014                88 ITS-PRESIDENTS-DAY
028015                                 VALUES 0215 THRU 0221.
028016                88 ITS-MEMORIAL-DAY
028017                                 VALUES 0525 THRU 0531.
028018                88 ITS-INDEPENDENCE-DAY
028019                                 VALUES 0705 THRU 0706.
028020                88 ITS-LABOR-DAY VALUES 0901 THRU 0907.
028022                88 ITS-THANKSGIVING
028023                                 VALUES 1122 THRU 1128.
028025                88 ITS-CHRISTMAS VALUES 1226 THRU 1227.
028030         10  WS-DAYS-TO-ADJUST      PIC 999.
028031         10  FILLER REDEFINES WS-DAYS-TO-ADJUST.
028032             20 WS-DAY-OF-THE-WEEK  PIC 9.
028040                88 ITS-THE-WEEKEND VALUES 0 6.
028050                88 ITS-A-WEEKDAY   VALUES 1 2 3 4 5.
028060                88 ITS-SUNDAY      VALUE 0.
028070                88 ITS-MONDAY      VALUE 1.
028080                88 ITS-TUESDAY     VALUE 2.
028090                88 ITS-WEDNESDAY   VALUE 3.
028091                88 ITS-THURSDAY    VALUE 4.
028092                88 ITS-FRIDAY      VALUE 5.
028093                88 ITS-SATURDAY    VALUE 6.
028094             20 FILLER              PIC 99.
028100         10  FILLER                 PIC  X(09).
028200     05  FILLER REDEFINES WS-DATE-TENBYTES.
028300         10  WS-DATE-REFORM-LEN10   PIC  X(10).
028400         10  FILLER                 PIC  X(10).
028500     05  FILLER REDEFINES WS-DATE-TENBYTES.
028600         10  WS-TIME-PARM1          PIC  X(06).
028700         10  WS-TIME-PARM2          PIC  X(06).
028800         10  WS-TIME-EXTEND         PIC  X(08).
028900     05  FILLER REDEFINES WS-DATE-TENBYTES.
029000         10  WS-TIME-PARM1BY8       PIC  X(08).
029100         10  WS-TIME-PARM2BY8       PIC  X(08).
029200         10  WS-TIME-EXTNDBY8       PIC  X(04).
029300
029400*
030500*
030600 01  BG-FLOAT-DATA.
030700     05  BG-FLOAT-PARMS              PIC  X(161).
030800     05  FILLER REDEFINES BG-FLOAT-PARMS.
030900         10  BG-FLOAT-COUNT          PIC  X(01).
031000         10  BG-FLOAT-1              PIC  X(40).
031100         10  BG-FLOAT-2              PIC  X(40).
031200         10  BG-FLOAT-2-R REDEFINES BG-FLOAT-2.
031300             15  BG-FLOAT-2-I        PIC  X(01) OCCURS 40 TIMES.
031400         10  BG-FLOAT-3              PIC  X(40).
031500         10  FILLER REDEFINES BG-FLOAT-3.
031600             15  BG-FLOAT-3-A        PIC  X(37).
031700             15  BG-FLOAT-3-B        PIC  X(03).
031800         10  BG-FLOAT-3-R REDEFINES BG-FLOAT-3.
031900             15  BG-FLOAT-3-I        PIC  X(01) OCCURS 40 TIMES.
032000         10  BG-FLOAT-4              PIC  X(40).
032100
032300
033300
033400 01  CURSOR-IDX                   PIC S9(04) COMP.
033500 01  THE-INDEX                    PIC S9(04) COMP.
033600 01  SAV-CURSOR-IDX-1             PIC S9(04) COMP.
033700 01  SAV-CLIENT-IDX-1             PIC S9(04) COMP.
033800 01  WK-IDX                       PIC S9(04) COMP.
033800 01  SAV-WK-IDX                   PIC S9(04) COMP.
033800 01  IDX                          PIC S9(04) COMP.
035000 01  HOLD-IDX                     PIC S9(04) COMP.
035100 01  SAVE-HOLD-IDX                PIC S9(04) COMP.
035200
035200 01  FACTOR-4                     PIC  9(01) VALUE 4.
035200 01  WS-QUOT-1                    PIC  9(03) VALUE 0.
035200 01  WS-QUOT-2                    PIC  9(02) VALUE 0.
035200
035200
040200                                                                                     00048200
040300 01  WS-PARMS.                                                                       00048300
040400     05  WS-ACTION-PARM               PIC  9(01) VALUE 3.                            00048400
040500         88  WS-ACTION-NEW                       VALUE 1.                            00048500
040600         88  WS-ACTION-EXISTING                  VALUE 2.                            00048600
040700         88  WS-ACTION-ENGLISH                   VALUE 3.                            00048700
040800     05  WS-ENGLISH-CHART-01          PIC  X(60).                                    00048800
040900     05  WS-ENGLISH-CHART-02          PIC  X(60).                                    00048900
041000     05  WS-ENGLISH-CHART-03          PIC  X(60).                                    00049000
041100     05  WS-ENGLISH-CHART-04          PIC  X(60).                                    00049100
041200     05  WS-ENGLISH-CHART-05          PIC  X(60).                                    00049200
041300     05  WS-ENGLISH-CHART-06          PIC  X(60).                                    00049300
041400     05  WS-ENGLISH-CHART-07          PIC  X(60).                                    00049400
041500     05  WS-ENGLISH-CHART-08          PIC  X(60).                                    00049500
041600     05  WS-TYPEIN-TEXT OCCURS 018 TIMES.                                            00049600
041700         10  WS-LINE-OF-TYPEIN        PIC  X(60).                                    00049700
041800
041900 01  SAV-CHART-OF-ACCTS.
042000      05  SAV-CHART-OF-ACCTS-01           PIC  9(10).
042100      05  SAV-CHART-OF-ACCTS-02           PIC  9(10).
042200      05  SAV-CHART-OF-ACCTS-03           PIC  9(10).
042300      05  SAV-CHART-OF-ACCTS-04           PIC  9(10).
042400      05  SAV-CHART-OF-ACCTS-05           PIC  9(10).
042500      05  SAV-CHART-OF-ACCTS-06           PIC  9(10).
042600      05  SAV-CHART-OF-ACCTS-07           PIC  9(10).
042700      05  SAV-CHART-OF-ACCTS-08           PIC  9(10).
042800
042900
043000 LINKAGE SECTION.
043100 01  LINK-LOGON-REC.
043200     COPY "TPSLOGON.CPY".
043400 01  VARIOUS-STUFF.
043400     05 THE-ACCOUNT-NUMBER        PIC  X(10).
043400     05 THE-STATUS-DATE           PIC  X(06).
043400     05 THE-STATUS-TIME           PIC  X(05).
043700
043800 01 CURRENT-XY-PARAMETERS PIC 9(08).

043900 PROCEDURE DIVISION USING LINK-LOGON-REC
043400                          VARIOUS-STUFF
                                CURRENT-XY-PARAMETERS.
044200
044300 TPS052-BEGIN.

      ********INITIALIZE WINFORMS SCREENS **************
       
       set TPS0052A to new TPS000.TPS0052AForm().
            
      **************************************************

           INITIALIZE DS-CONTROL-BLOCK.
           INITIALIZE DS-INPUT-FIELDS.
           MOVE CURRENT-XY-PARAMETERS(1:4) TO WS-CURRENT-X
                                              WS-X-PARM.
           MOVE CURRENT-XY-PARAMETERS(5:4) TO WS-CURRENT-Y
                                              WS-Y-PARM.
044400    ACCEPT TODAYS-DATE-YMD FROM DATE.
044500    MOVE 05                   TO WS-DATE-PARAM.
044600    MOVE SPACES               TO WS-DATE-TENBYTES.
044700    MOVE TODAYS-DATE-YMD      TO WS-DATE-REFORM.
044800    CALL TPSDATES USING WS-DATE-REQUEST.
044900    MOVE WS-DATE-REFORM-LEN06 TO TODAYS-DATE-MDY.
045000
045100    MOVE TODAYS-DATE-MDY(1:2) TO MONTH-DAY(1:2).
045200    MOVE '/'                  TO MONTH-DAY(3:2).
045300    MOVE TODAYS-DATE-MDY(3:2) TO MONTH-DAY(4:2).
045400
045500    ACCEPT TODAYS-TIME     FROM TIME.
045600
045700    MOVE 01                   TO WS-DATE-PARAM.
045800    MOVE SPACES               TO WS-DATE-TENBYTES.
045900    MOVE TODAYS-DATE-YMD      TO WS-DATE-REFORM.
046000    CALL TPSDATES USING WS-DATE-REQUEST.
046100    MOVE WS-DATE-REFORM-LEN08 TO TODAYS-DATE-CYMD.
048300
045700    MOVE 22                   TO WS-DATE-PARAM.
045800    MOVE SPACES               TO WS-DATE-TENBYTES.
045900    MOVE TODAYS-DATE-CYMD     TO WS-DATE-REFORM-LEN08.
045900    MOVE '030'                TO WS-DATE-REFORM-LEN08(9:3).
046000    CALL TPSDATES USING WS-DATE-REQUEST.
046100    MOVE WS-DATE-REFORM-LEN08 TO TODAYS-DATE-CYMD-LESS30.
048300
048400    MOVE LINK-LOGON-REC           TO TPS-LOGON-REC.
048500
049700     MOVE THE-ACCOUNT-NUMBER      TO PAM-ACCT-NO.
049800     MOVE ZEROS                   TO PAM-SUB-ACCT-NO.
050100
050300     MOVE F-PRIME    TO FILE-KEY.
050400     MOVE F-OPEN-I-O TO FILE-ACTION.
050500     CALL TPSIO027 USING FILE-REQUEST TPS-PAMON-REC.
050501*06/04
050502    IF THE-FILE-IS-LOCKED
050503       MOVE 'TPSPAMON ' TO DATA-FILE-LOCKED-MESSAGE
050504       SET TPSLOCKD-DO-DISPLAY TO TRUE
050505       CALL GUISCREEN USING TPSLOCKD-1
050506                            TPSLOCKD-2
050507                            TPSLOCKD-3
050508                            TPSLOCKD-4
050509       GO TO TPS052-COMMON-EXIT
050510      END-IF.
050520*06/04
050600     IF FILE-STATUS NOT = '00' AND '05'
050700        MOVE 'PAMON ' TO FILE-NAME
050800        MOVE 'TPS052-OPN' TO FILE-TEXT
050900        PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
051000        GO TO TPS052-COMMON-EXIT
051100      END-IF.
051300
061500    PERFORM OPEN-THE-FILES THRU
061600            OPEN-THE-FILES-EXIT.
061700
061800    PERFORM READ-THE-PROFL THRU
061900            READ-THE-PROFL-EXIT.
062000
080600    PERFORM READ-ALL-ONHOLD THRU
080600            READ-ALL-ONHOLD-EXIT.
062000
062400    PERFORM SORT-THE-TABLES THRU
062500            SORT-THE-TABLES-EXIT.
062600*06/09
063300
063400    PERFORM START-THE-DISPLAYS THRU
063500            END-THE-DISPLAYS.
063600
063700 TPS052-COMMON-EXIT.
063710*   IF FUNCTION-AUTO-REFRESH
063800*      PERFORM CLOSE-THE-FILES THRU
063900*              CLOSE-THE-FILES-EXIT
063910*    END-IF.
064000
064040
064100*   PERFORM VARYING THE-INDEX FROM 1 BY 1
064200*             UNTIL PROGRAM-NAME(THE-INDEX) = HIGH-VALUES
064300*             CANCEL PROGRAM-NAME(THE-INDEX)
064400*   END-PERFORM.

064500     INITIALIZE CURRENT-XY-PARAMETERS
           MOVE WS-CURRENT-X TO CURRENT-XY-PARAMETERS(1:4)
           MOVE WS-CURRENT-Y TO CURRENT-XY-PARAMETERS(5:4)

           set TPS0052A::KEY-PRESSED to "End Key".
           invoke TPS0052A::Close.
064600    GOBACK GIVING CURRENT-XY-PARAMETERS.
064700    STOP RUN.
064800
080200*-----------------------------------------------------------
080300*-----------------------------------------------------------
080400
080500
080600 READ-THE-PROFL.
Fld001    MOVE THE-ACCOUNT-NUMBER     TO PA-HOLD-DETAIL-ACCOUNT-NUMBER.
043400    MOVE THE-STATUS-DATE        TO TPS0052A::STATUS-DATE
Fld002                                   PA-HOLD-DETAIL-STATUS-DATE.
043400    MOVE THE-STATUS-TIME        TO TPS0052A::STATUS-TIME
Fld003                                   PA-HOLD-DETAIL-STATUS-TIME.
086400    MOVE THE-ACCOUNT-NUMBER     TO CLNT-PROFILE-ACCT-NO
086400                                   TPS0052A::CLIENT-ACCT-NUMBER.
086400    MOVE ZEROS                  TO CLNT-PROFILE-SUB-ACCT.
084100    MOVE F-PRIME TO FILE-KEY.
084200    MOVE F-READ  TO FILE-ACTION.
084300    CALL TPSIO004 USING FILE-REQUEST TPS-PROFL-REC.
084400
084900    IF NOT A-SUCCESSFUL-OPERATION
085000       MOVE ' PROFL' TO FILE-NAME
085100       MOVE 'TPS052-READ ' TO FILE-TEXT
085200       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
085300       GO TO TPS052-COMMON-EXIT
085400     END-IF.
086500
086600    MOVE SPACES                   TO BG-FLOAT-PARMS.
086700    MOVE  CLNT-PROFILE-LAST-NAME  TO BG-FLOAT-1.
086800    IF CLNT-PROFILE-MDDL-INIT = SPACES
086900       MOVE '2'                   TO BG-FLOAT-COUNT
087000       MOVE CLNT-PROFILE-FIRST-NAME  TO BG-FLOAT-2
087100      ELSE
087200       MOVE '3'                   TO BG-FLOAT-COUNT
087300       MOVE CLNT-PROFILE-FIRST-NAME  TO BG-FLOAT-2
087400       MOVE CLNT-PROFILE-MDDL-INIT   TO BG-FLOAT-3
087500       MOVE '.'                      TO BG-FLOAT-3(2:1)
087600     END-IF.
087700    CALL FLOATBIG USING BG-FLOAT-DATA.
087800    MOVE BG-FLOAT-1(1:36)     TO TPS0052A::CLIENT-NAME
Fld004                                 PA-HOLD-DETAIL-CLIENT-NAME.
089400 READ-THE-PROFL-EXIT. EXIT.
089500
080400
080500
080600 READ-ALL-ONHOLD.
080700     SET THE-INDEX TO 1.
080800     PERFORM 200 TIMES
FLD005        MOVE HIGH-VALUE TO TABLE-ONHOLD-ADDRESSOR-NAME(THE-INDEX)
FLD006        MOVE SPACES     TO TABLE-ONHOLD-CATEGORY(THE-INDEX)
FLD007        MOVE ZEROS   TO TABLE-ONHOLD-RECEIVE-DATE(THE-INDEX)
FLD008                        TABLE-ONHOLD-RECEIVE-NUMBER(THE-INDEX)
021500*06/18  MOVE '999999999'
021500        MOVE ZEROS   TO TABLE-ONHOLD-RECEIVE-DATE-LONG(THE-INDEX)
082100        SET THE-INDEX UP BY 1
082200      END-PERFORM.
082300
082400    MOVE 1                        TO THE-INDEX.
082500
082600    MOVE ZEROS                 TO PAM-CLIENT-KEY.
082600    MOVE THE-ACCOUNT-NUMBER    TO PAM-ACCT-NO.
082700    MOVE F-PRIME TO FILE-KEY.
082800    MOVE F-START TO FILE-ACTION.
178000    CALL TPSIO027 USING FILE-REQUEST TPS-PAMON-REC.
083000    IF NO-RECORD-WAS-FOUND
080600       GO TO READ-ALL-ONHOLD-EXIT
083200     END-IF.
083300    IF NOT A-SUCCESSFUL-OPERATION
083400       MOVE ' PAMON' TO FILE-NAME
083500       MOVE 'TPS052-START' TO FILE-TEXT
083600       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
083700       GO TO TPS052-COMMON-EXIT
083800     END-IF.
083900
080600 READ-ALL-ONHOLD-RECORDS.
084100    MOVE F-PRIME TO FILE-KEY.
084200    MOVE F-READ-NEXT TO FILE-ACTION.
178000    CALL TPSIO027 USING FILE-REQUEST TPS-PAMON-REC.
084400
084500    IF END-OF-FILE-WAS-REACHED
080600       GO TO READ-ALL-ONHOLD-EXIT
084700     END-IF.
084800
084900    IF NOT A-SUCCESSFUL-OPERATION
085000       MOVE ' PAMON' TO FILE-NAME
085100       MOVE 'TPS052-RNEXT' TO FILE-TEXT
085200       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
085300       GO TO TPS052-COMMON-EXIT
085400     END-IF.
085500
082600    IF PAM-ACCT-NO NOT = THE-ACCOUNT-NUMBER
080600       GO TO READ-ALL-ONHOLD-EXIT
084700     END-IF.
085500
066900    IF NOT PAM-MAIL-ON-HOLD
080600       GO TO READ-ALL-ONHOLD-RECORDS
085400     END-IF.

044700    MOVE PAM-ADDRESSOR-NAME
FLD005           TO TABLE-ONHOLD-ADDRESSOR-NAME(THE-INDEX).

144200    MOVE PAM-ACCT-NO                 TO MAIL-ACCT-NO.
144400    MOVE ZEROS                       TO MAIL-SUB-ACCT.
144600    MOVE PAM-RECEIVE-DATE            TO MAIL-RECEIVE-DATE.
144800    MOVE PAM-RECEIVE-NO              TO MAIL-RECEIVE-NUMBER.
212000    MOVE PAM-NON-CHART-ACCOUNTS-01   TO RECUR-CHART-ACCT-01.
212000    MOVE PAM-NON-CHART-ACCOUNTS-02   TO RECUR-CHART-ACCT-02.
212000    MOVE PAM-NON-CHART-ACCOUNTS-03   TO RECUR-CHART-ACCT-03.
212000    MOVE PAM-NON-CHART-ACCOUNTS-04   TO RECUR-CHART-ACCT-04.
212000    MOVE PAM-NON-CHART-ACCOUNTS-05   TO RECUR-CHART-ACCT-05.
212000    MOVE PAM-NON-CHART-ACCOUNTS-06   TO RECUR-CHART-ACCT-06.
212000    MOVE PAM-NON-CHART-ACCOUNTS-07   TO RECUR-CHART-ACCT-07.
212000    MOVE PAM-NON-CHART-ACCOUNTS-08   TO RECUR-CHART-ACCT-08.
313400    MOVE 3                           TO WS-ACTION-PARM.
313500    CALL TPSCHART USING WS-PARMS
                              TPS-PROFL-REC
                              TPS-MAIL-REC
                              WS-CURRENT-XY-PARM.

            MOVE WS-CURRENT-XY-PARM(1:4) TO WS-CURRENT-X.
            MOVE WS-CURRENT-XY-PARM(5:4) TO WS-CURRENT-Y.

313700    MOVE WS-ENGLISH-CHART-01(1:26) TO
FLD006              TABLE-ONHOLD-CATEGORY(THE-INDEX).
044500    MOVE 05                   TO WS-DATE-PARAM.
044600    MOVE SPACES               TO WS-DATE-TENBYTES.
044700    MOVE PAM-RECEIVE-DATE(3:6) TO WS-DATE-REFORM.
044800    CALL TPSDATES USING WS-DATE-REQUEST.
044900    MOVE WS-DATE-REFORM-LEN06
FLD007           TO TABLE-ONHOLD-RECEIVE-DATE(THE-INDEX)
044700    MOVE PAM-RECEIVE-NO
FLD008           TO TABLE-ONHOLD-RECEIVE-NUMBER(THE-INDEX).
044700    MOVE PAM-RECEIVE-DATE
021500           TO TABLE-ONHOLD-RECEIVE-DATE-LONG(THE-INDEX).
087900    SET THE-INDEX UP BY 1.
088000    GO TO READ-ALL-ONHOLD-RECORDS.
080600 READ-ALL-ONHOLD-EXIT. EXIT.
088200
088300
089500
089600
090800
090900
112900
113000
113100
113200 SORT-THE-TABLES.
020700      SORT TABLE-ONHOLD-STUFF-R.
020700*     SORT TABLE-ONHOLD-STUFF-R ON ASCENDING KEY
021500*                          TABLE-ONHOLD-RECEIVE-DATE-LONG
FLD008*                          TABLE-ONHOLD-RECEIVE-NUMBER
FLD005*                          TABLE-ONHOLD-ADDRESSOR-NAME.
113900 SORT-THE-TABLES-EXIT. EXIT.
114200
114300
157300
157400
157500 FILE-ERROR.
157600     CALL TPSIOERR USING FILE-REQUEST
                               WS-CURRENT-XY-PARM.
157700     CANCEL TPSIOERR.

            MOVE WS-CURRENT-XY-PARM(1:4) TO WS-CURRENT-X.
            MOVE WS-CURRENT-XY-PARM(5:4) TO WS-CURRENT-Y.

           INITIALIZE CURRENT-XY-PARAMETERS.
           MOVE WS-CURRENT-X TO CURRENT-XY-PARAMETERS(1:4).
           MOVE WS-CURRENT-Y TO CURRENT-XY-PARAMETERS(5:4).

157800 FILE-ERROR-EXIT. EXIT.
157900
158000
158100 OPEN-THE-FILES.
158200    OPEN OUTPUT PRT-FILE.

          PERFORM VARYING THE-INDEX FROM 1 BY 1
                    UNTIL THE-INDEX > 50
268600       MOVE HIGH-VALUES    TO DISPOSITION-ROW(THE-INDEX)
           END-PERFORM.

267800    OPEN  INPUT  TPS-DISPOSITION-FILE.
267900    PERFORM VARYING THE-INDEX FROM 1 BY 1
268000            UNTIL   THE-INDEX > 49
268100      READ TPS-DISPOSITION-FILE
268200           AT END GO TO TPS-DISPOSITION-FILE-EXIT
268300       END-READ
268500      MOVE TPS-DISPOSITION-INPUT
268600               TO DISPOSITION-ROW(THE-INDEX)
080300      IF DISPOSITION-CODE(THE-INDEX) = '04' OR '11' OR
080300                                       '12' OR '17' OR
080300                                       '18' OR '20' OR
080300                                       '23' OR '24' OR
080300                                       '26' OR '32' OR
080300                                       '33' OR '34' OR
080300                                       '38' OR '88'
268600         MOVE HIGH-VALUES   TO DISPOSITION-ROW(THE-INDEX)
080300         SET THE-INDEX DOWN BY 1
             END-IF
269200     END-PERFORM.
168400
269300 TPS-DISPOSITION-FILE-EXIT.
269400    CLOSE TPS-DISPOSITION-FILE.
080500    SORT  DISPOSITION-DATA ON ASCENDING KEY
080500          DISPOSITION-DESCRIPTION.
168400
159200    MOVE F-PRIME      TO FILE-KEY.
159300    MOVE F-OPEN-INPUT TO FILE-ACTION.
159400    CALL TPSIO004 USING FILE-REQUEST TPS-PROFL-REC.
159500    IF FILE-STATUS NOT = '00' AND '05'
159600       MOVE 'PROFL ' TO FILE-NAME
159700       MOVE 'TPS052-OPN' TO FILE-TEXT
159800       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
159900       GO TO TPS052-COMMON-EXIT
160000      END-IF.
166500    MOVE F-PRIME    TO FILE-KEY.
166600    MOVE F-OPEN-I-O TO FILE-ACTION.
166700    CALL TPSIOREC USING FILE-REQUEST TPS-MAIL-REC.
166800    IF FILE-STATUS NOT = '00' AND '05'
166900       MOVE ' MAIL ' TO FILE-NAME
167000       MOVE 'TPS052-OPN' TO FILE-TEXT
167100       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
167200       GO TO TPS052-COMMON-EXIT
167300      END-IF.
456900    MOVE F-PRIME      TO FILE-KEY.
166600    MOVE F-OPEN-INPUT TO FILE-ACTION.
457100    CALL TPSIOMEM USING FILE-REQUEST TPSMEMO-4
458100    IF NOT A-SUCCESSFUL-OPERATION
458200       MOVE 'TPSMEMO ' TO FILE-NAME
458300       MOVE 'TPS052-OPN' TO FILE-TEXT
458400       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
458600       GO TO TPS052-COMMON-EXIT
458000     END-IF.
168300 OPEN-THE-FILES-EXIT. EXIT.
168400
168400
168500 CLOSE-THE-FILES.
168600    CLOSE PRT-FILE.
169600    MOVE F-PRIME TO FILE-KEY.
169700    MOVE F-CLOSE TO FILE-ACTION.
169800    CALL TPSIO004 USING FILE-REQUEST TPS-PROFL-REC.
169900    IF NOT A-SUCCESSFUL-OPERATION
170000       MOVE 'PROFL ' TO FILE-NAME
170100       MOVE 'TPS052-CLO' TO FILE-TEXT
170200       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
170300       GO TO TPS052-COMMON-EXIT
170400      END-IF.
175900
176000 CLOSE-THE-FILES-EXIT. EXIT.
176100
176200
176300*----------------------------------------------------------------
176400*----------------------------------------------------------------
176500*----------------------------------------------------------------
176600*----------------------------------------------------------------
176700*----------------------------------------------------------------
176800*
176900 START-THE-DISPLAYS.
227300      PERFORM CLEAR-FIELDS-TPS0052A THRU
227400              CLEAR-FIELDS-TPS0052A-EXIT.
227510
227600      PERFORM RESET-COLORS-TPS0052A THRU
227700              RESET-COLORS-TPS0052A-EXIT.
227800
227900      MOVE ZEROS                  TO WK-IDX.
228000      MOVE ZEROS                  TO HOLD-IDX.
228100      MOVE HOLD-IDX               TO SAVE-HOLD-IDX.
228200
228400 LOAD-PANEL-TPS0052A.
228500      PERFORM VARYING THE-INDEX FROM 1 BY 1
228600                UNTIL THE-INDEX > 16
228700        SET HOLD-IDX UP BY 1
FLD005        IF TABLE-ONHOLD-ADDRESSOR-NAME(HOLD-IDX) = HIGH-VALUES
228900           GO TO SHOW-ONHOLD-ITEMS
229000         END-IF
229100        SET WK-IDX UP BY 1
FLD005        MOVE TABLE-ONHOLD-ADDRESSOR-NAME(HOLD-IDX)
FLD005                 TO TPS0052A-ADDRESSOR-NAME-TBL(WK-IDX)
FLD006        MOVE TABLE-ONHOLD-CATEGORY(HOLD-IDX)
FLD006                 TO TPS0052A-CATEGORY-TBL(WK-IDX)
FLD007        MOVE TABLE-ONHOLD-RECEIVE-DATE(HOLD-IDX)
FLD007                 TO TPS0052A-RECEIVE-DATE-TBL(WK-IDX)
FLD008        MOVE TABLE-ONHOLD-RECEIVE-NUMBER(HOLD-IDX)
FLD008                 TO TPS0052A-RECEIVE-NUMBER-TBL(WK-IDX)
048300
021500        IF TABLE-ONHOLD-RECEIVE-DATE-LONG(HOLD-IDX)
024700                       < TODAYS-DATE-CYMD-LESS30
419000           PERFORM MAKE-RECEIVE-RED-TPS0052A THRU
419000                   MAKE-RECEIVE-RED-TPS0052A-EXIT
230900         END-IF
230900       END-PERFORM.
231000
228900 SHOW-ONHOLD-ITEMS.
       
231400      MOVE 'SELECT ON HOLD-ENTER TO PROCESS OR END KEY-PREVIOUS'
231500                                TO TPS0052A::MENU-LINE.
233230
233300 DISPLAY-PANEL-TPS0052A.

           MOVE 0 TO TPS0052A-IDX.
           PERFORM VARYING THE-INDEX FROM 1 BY 1
             UNTIL THE-INDEX > 16
               MOVE TPS0052A-ADDRESSOR-NAME-TBL(THE-INDEX) TO
                    TPS0052A::ADDRESSOR-NAME(TPS0052A-IDX)
               MOVE TPS0052A-CATEGORY-TBL(THE-INDEX) TO
                 TPS0052A::CATEGORY(TPS0052A-IDX)
               MOVE TPS0052A-RECEIVE-DATE-TBL(THE-INDEX) TO
                 TPS0052A::RECEIVE-DATE(TPS0052A-IDX)
               MOVE TPS0052A-RECEIVE-NUMBER-TBL(THE-INDEX) TO
                 TPS0052A::RECEIVE-NUMBER(TPS0052A-IDX)
               COMPUTE TPS0052A-IDX = TPS0052A-IDX + 1
           END-PERFORM.
       
233400      MOVE 1           TO TPS0052A::ACTIVE-FIELD.

           SET TPS0052A::X-POINT TO WS-X-PARM.
           SET TPS0052A::Y-POINT TO WS-Y-PARM.
           INVOKE TPS0052A::ShowDialog.
           MOVE TPS0052A::Location::X TO WS-X-PARM
                                         WS-CURRENT-X.
           MOVE TPS0052A::Location::Y TO WS-Y-PARM
                                         WS-CURRENT-Y.
           MOVE TPS0052A::SCREEN-NAME TO SCREEN-NAME.

234300
234400      IF TPS0052A::KEY-PRESSED = "End Key"
234500          GO TO END-THE-DISPLAYS
234600       END-IF.
234700
234800      IF TPS0052A::KEY-PRESSED = "Page Down Key"
FLD005         IF TABLE-ONHOLD-ADDRESSOR-NAME(HOLD-IDX) = HIGH-VALUES
235100            MOVE 'U CANNOT PAGE DOWN, PAGE UP OR SELECT CLIENT'
235200                             TO TPS0052A::MENU-LINE
235300            GO TO DISPLAY-PANEL-TPS0052A
235400          END-IF
235500         MOVE SAVE-HOLD-IDX          TO HOLD-IDX
235600         SET HOLD-IDX UP BY 16
235700         MOVE HOLD-IDX               TO SAVE-HOLD-IDX
235800         MOVE ZEROS                  TO WK-IDX
235900         PERFORM CLEAR-FIELDS-TPS0052A THRU
236000                 CLEAR-FIELDS-TPS0052A-EXIT
236100         PERFORM RESET-COLORS-TPS0052A THRU
236200                 RESET-COLORS-TPS0052A-EXIT
236300         GO TO LOAD-PANEL-TPS0052A
236400       END-IF.
236500
236600      IF TPS0052A::KEY-PRESSED = "Page Up Key"
236700         IF SAVE-HOLD-IDX = 0
236900            MOVE 'U CANNOT PAGE UP, PAGE DOWN OR SELECT CLIENT'
237000                             TO TPS0052A::MENU-LINE
237100            GO TO DISPLAY-PANEL-TPS0052A
237200          END-IF
      *07/23/98
235900         PERFORM CLEAR-FIELDS-TPS0052A THRU
236000                 CLEAR-FIELDS-TPS0052A-EXIT
236100         PERFORM RESET-COLORS-TPS0052A THRU
236200                 RESET-COLORS-TPS0052A-EXIT
237300         MOVE ZEROS                  TO WK-IDX
237400         IF HOLD-IDX < 16
237500            MOVE ZEROS               TO HOLD-IDX
237600                                        SAVE-HOLD-IDX
237700                                        WK-IDX
237800            GO TO LOAD-PANEL-TPS0052A
237900          END-IF
238000         MOVE SAVE-HOLD-IDX          TO HOLD-IDX
238100         SET HOLD-IDX DOWN BY 16
238200         MOVE HOLD-IDX               TO SAVE-HOLD-IDX
238300         MOVE ZEROS                  TO WK-IDX
238400         GO TO LOAD-PANEL-TPS0052A
238500       END-IF.
238600
238800      IF NOT TPS0052A::KEY-PRESSED = "Enter Key"
239000         MOVE 'VALID KEYS - ENTER, END,PAGE UP OR PAGE DOWN'
239100                          TO TPS0052A::MENU-LINE
239200         GO TO DISPLAY-PANEL-TPS0052A
239300       END-IF.
239400************************************* 6/16/98  ******************
239400************************************* 6/16/98  ******************
239400************************************* 6/16/98  ******************
239400************************************* 6/16/98  ******************
239500      MOVE TPS0052A::ACTIVE-FIELD  TO CURSOR-IDX.

239500      IF CURSOR-IDX < 6
240400         MOVE 1           TO TPS0052A::ACTIVE-FIELD
240700         MOVE 'NO LINE SELECTED, PLEASE SELECT AGAIN'
240800                          TO TPS0052A::MENU-LINE
240900         GO TO DISPLAY-PANEL-TPS0052A
241000       END-IF.

239500      SET CURSOR-IDX DOWN BY 5
239600      DIVIDE CURSOR-IDX    BY FACTOR-4
239700             GIVING WS-QUOT-1  REMAINDER WS-QUOT-2.
239800      MOVE WS-QUOT-1       TO CURSOR-IDX.
239900***** IF TPS0052A-CURSOR-FIELD > 1
240000*****    SET CURSOR-IDX UP BY 1
240100*****  END-IF.
240000      SET CURSOR-IDX UP BY 1.
240200
FLD005      IF TPS0052A::ADDRESSOR-NAME(CURSOR-IDX) = SPACES
240400         MOVE 1           TO TPS0052A::ACTIVE-FIELD
240700         MOVE 'INVALID LINE SELECTED, PLEASE SELECT AGAIN'
240800                          TO TPS0052A::MENU-LINE
240900         GO TO DISPLAY-PANEL-TPS0052A
241000       END-IF.
241100
241200      MOVE SAVE-HOLD-IDX          TO HOLD-IDX.
241300      ADD CURSOR-IDX              TO HOLD-IDX.
241400
241500      MOVE HOLD-IDX               TO SAV-CURSOR-IDX-1.
241700*06/15/98
241700*DICK
247000
336200 RELOAD-PANEL-TPS0052B.
296300***** PERFORM CLEAR-FIELDS-TPS0052B THRU
296400*****         CLEAR-FIELDS-TPS0052B-EXIT.
296500
296600    MOVE THE-ACCOUNT-NUMBER             TO MAIL-ACCT-NO.
296800    MOVE ZEROS                          TO MAIL-SUB-ACCT.
297000*
297100    MOVE TPS0052A::ACTIVE-FIELD     TO THE-INDEX.
297200    SET THE-INDEX DOWN BY 2.
297300    IF THE-INDEX > 1
297400       DIVIDE THE-INDEX    BY FACTOR-4
297500              GIVING WS-QUOT-1  REMAINDER WS-QUOT-2
297600       MOVE WS-QUOT-1                 TO THE-INDEX
297700     END-IF.
297800
297900    ADD SAVE-HOLD-IDX                 TO THE-INDEX.
298000
021500    MOVE TABLE-ONHOLD-RECEIVE-DATE-LONG(THE-INDEX)
298200                              TO MAIL-RECEIVE-DATE.
298400    MOVE 05                   TO WS-DATE-PARAM.
298500    MOVE SPACES               TO WS-DATE-TENBYTES.
021500    MOVE TABLE-ONHOLD-RECEIVE-DATE-LONG(THE-INDEX)(3:6)
298700                              TO WS-DATE-REFORM.
298800    CALL TPSDATES USING WS-DATE-REQUEST.
Fld006    MOVE WS-DATE-REFORM-LEN06 TO PA-HOLD-DETAIL-RECEIVE-DATE.
299000
299100*05/29/98
FLD008    MOVE TABLE-ONHOLD-RECEIVE-NUMBER(THE-INDEX)
299300                              TO MAIL-RECEIVE-NUMBER
Fld008                                 PA-HOLD-DETAIL-RECEIVE-NUMBER.
299500
299500* BUILD PAMON KEY NOW INCASE THEY CHANGE DISPOSITION........
299900*06/18
299900*06/16
296600    MOVE THE-ACCOUNT-NUMBER             TO PAM-ACCT-NO.
044700    MOVE ZEROS                          TO PAM-SUB-ACCT-NO
044700                                           PAM-PAYMENT-PAY-DATE
044700                                           PAM-PAYMENT-DUE-DATE
044700                                           PAM-PAYEE-ZIP-CODE.
021500    MOVE TABLE-ONHOLD-RECEIVE-DATE-LONG(THE-INDEX)
044700                                        TO PAM-RECEIVE-DATE.
FLD008    MOVE TABLE-ONHOLD-RECEIVE-NUMBER(THE-INDEX)
044700                                        TO PAM-RECEIVE-NO.
044700    MOVE '81'                           TO PAM-RECORD-TYPE.
299500* BUILD PAMON KEY NOW INCASE THEY CHANGE DISPOSITION........
299500
299700    PERFORM READ-RECEIVE-FILE THRU
299800            READ-RECEIVE-FILE-EXIT.
299900*06/16
454700    MOVE MAIL-KEY       TO TPS-MEMO-KEY.
451500    PERFORM READ-MAIL-MEMO THRU
451500            READ-MAIL-MEMO-EXIT.
457200    IF A-SUCCESSFUL-OPERATION
FLD013       MOVE 'Yes'       TO PA-HOLD-DETAIL-MAIL-MEMO
FLD013       MOVE '0079'      TO PA-HOLD-DETAIL-MAIL-MEMO-C
            ELSE
FLD013       MOVE 'No '       TO PA-HOLD-DETAIL-MAIL-MEMO
FLD013       MOVE ZEROS       TO PA-HOLD-DETAIL-MAIL-MEMO-C
           END-IF.
299900*06/16
          IF RECUR-CHART-ACCT-01(1:2) = '99'
           OR RECUR-CHART-ACCT-02(5:2) = '99'
            OR RECUR-CHART-ACCT-03(5:2) = '99'
             OR RECUR-CHART-ACCT-04(5:2) = '99'
              OR RECUR-CHART-ACCT-05(5:2) = '99'
               OR RECUR-CHART-ACCT-06(5:2) = '99'
                OR RECUR-CHART-ACCT-07(5:2) = '99'
                 OR RECUR-CHART-ACCT-08(5:2) = '99'
528600              PERFORM READ-CHART-MEMO THRU
528600                      READ-CHART-MEMO-EXIT
534100              SET WK-IDX TO 1
534200              IF TPSR0100-POPUP-LINE(WK-IDX) NOT = SPACES
FLD013                 MOVE 'Yes'       TO PA-HOLD-DETAIL-CHART-MEMO
FLD013                 MOVE '0079'      TO PA-HOLD-DETAIL-CHART-MEMO-C
                      ELSE
FLD013                 MOVE 'No '       TO PA-HOLD-DETAIL-CHART-MEMO
FLD013                 MOVE ZEROS       TO PA-HOLD-DETAIL-CHART-MEMO-C
                     END-IF
            ELSE
FLD013       MOVE 'No '                 TO PA-HOLD-DETAIL-CHART-MEMO
FLD013       MOVE ZEROS                 TO PA-HOLD-DETAIL-CHART-MEMO-C
           END-IF.

          IF MAIL-IMAGE-NUMBER IS NOT NUMERIC
FLD005       MOVE ZEROS               TO PA-HOLD-DETAIL-IMAGE-NUMBER
            ELSE
FLD005       MOVE MAIL-IMAGE-NUMBER   TO PA-HOLD-DETAIL-IMAGE-NUMBER
           END-IF.

267900    PERFORM VARYING THE-INDEX FROM 1 BY 1
268000            UNTIL DISPOSITION-CODE(THE-INDEX) = HIGH-VALUES
080300       IF MAIL-DISPOSITION = DISPOSITION-CODE(THE-INDEX)
080500          MOVE DISPOSITION-DESCRIPTION(THE-INDEX)(1:15)
268500               TO PA-HOLD-DETAIL-DISPOSITION
268500          NEXT SENTENCE
268500        END-IF
269200     END-PERFORM.
      *DICK
080300    IF MAIL-DISPOSITION = '08' OR '31'
268500       MOVE ZEROS              TO PA-HOLD-DETAIL-DISPOSITION-C
268500      ELSE
268500       MOVE '0224'             TO PA-HOLD-DETAIL-DISPOSITION-C
268500     END-IF.

Fld005    MOVE RECUR-ADDRESOR-NAME
Fld005                 TO PA-HOLD-DETAIL-RESSOR-NAME.
Fld007    MOVE RECUR-ADDRESOR-ADDRL1
Fld007                 TO PA-HOLD-DETAIL-RESSOR-ADDR-01.
Fld009    MOVE RECUR-ADDRESOR-ADDRL2
Fld009                 TO PA-HOLD-DETAIL-RESSOR-ADDR-02.
Fld010    MOVE RECUR-ADDRESOR-CITY
Fld010                 TO PA-HOLD-DETAIL-RESSOR-CITY.
Fld011    MOVE RECUR-ADDRESOR-STATE
Fld011                 TO PA-HOLD-DETAIL-RESSOR-STATE.
Fld012    MOVE RECUR-ADDRESOR-ZIPCODE
Fld012                 TO PA-HOLD-DETAIL-RESSOR-ZIP-CODE.
306500    MOVE RECUR-ADDRESEE-NAME
Fld014                 TO PA-HOLD-DETAIL-RESSEE-NAME.
306600    MOVE RECUR-ADDRESEE-ADDRL1
Fld015                 TO PA-HOLD-DETAIL-RESSEE-ADDR-01.
306700    MOVE RECUR-ADDRESEE-ADDRL2
Fld016                 TO PA-HOLD-DETAIL-RESSEE-ADDR-02.
306800    MOVE RECUR-ADDRESEE-CITY
Fld017                 TO PA-HOLD-DETAIL-RESSEE-CITY.
306900    MOVE RECUR-ADDRESEE-STATE
Fld018                 TO PA-HOLD-DETAIL-RESSEE-STATE.
307000    MOVE RECUR-ADDRESEE-ZIPCODE
Fld019                 TO PA-HOLD-DETAIL-RESSEE-ZIP-CODE.
307100
313400    MOVE 3                    TO WS-ACTION-PARM.                                   00197500
313500    CALL TPSCHART USING WS-PARMS
                              TPS-PROFL-REC
                              TPS-MAIL-REC
                              WS-CURRENT-XY-PARM.

            MOVE WS-CURRENT-XY-PARM(1:4) TO WS-CURRENT-X.
            MOVE WS-CURRENT-XY-PARM(5:4) TO WS-CURRENT-Y.

313700    MOVE WS-ENGLISH-CHART-01(1:40) TO                                               00198000
Fld020                  PA-HOLD-DETAIL-CHART-ACCT-01.
313900    MOVE WS-ENGLISH-CHART-02(1:40) TO                                               00198200
Fld020                  PA-HOLD-DETAIL-CHART-ACCT-02.
314100    MOVE WS-ENGLISH-CHART-03(1:40) TO                                               00198400
Fld020                  PA-HOLD-DETAIL-CHART-ACCT-03.
314300    MOVE WS-ENGLISH-CHART-04(1:40) TO                                               00198600
Fld020                  PA-HOLD-DETAIL-CHART-ACCT-04.
314500    MOVE WS-ENGLISH-CHART-05(1:40) TO                                               00198800
Fld020                  PA-HOLD-DETAIL-CHART-ACCT-05.
314700    MOVE WS-ENGLISH-CHART-06(1:40) TO                                               00199000
Fld020                  PA-HOLD-DETAIL-CHART-ACCT-06.
332900
333000 DISPLAY-PANEL-TPS0052B.
            SET TPS0052B-MESSAGE-BAR-PERSIST TO TRUE.
333400      MOVE PF-KEY-LEGEND-MSG  TO TPS0052B-MESSAGE-TEXT.
333600
333700 DISPLAY-PANEL-TPS0052B-IMAGE.
       
333800      SET TPS0052B-MESSAGE-BAR-PERSIST TO TRUE.
333900      MOVE 26          TO TPS0052B-ACTIVE-FIELD-ID.
334100      SET TPS0052B-DO-DISPLAY TO TRUE.
334200      CALL GUISCREEN USING TPS0052B-1
334300                           TPS0052B-2
334400                           TPS0052B-3
334500                           TPS0052B-4.
334600
334700      MOVE TPS0052B-EVENT-ID TO EXIT-KEY-NAMES.
334800
335700      IF THEY-HIT-F1
335800         PERFORM CHANGE-DISPOSITION THRU
335900                 CHANGE-DISPOSITION-EXIT
336200         GO TO RELOAD-PANEL-TPS0052B
336300       END-IF.
336400
336500      IF THEY-HIT-F2
336600         GO TO DISPLAY-IMAGE
336700       END-IF.
336800
336900      IF THEY-HIT-F3
337000         GO TO PRINT-IMAGE
337100       END-IF.
337200
337300      IF THEY-HIT-F4
337400         GO TO RECODE-CHART-OF-ACCOUNTS
337500       END-IF.
337200
337300      IF THEY-HIT-F5
FLD013         IF PA-HOLD-DETAIL-MAIL-MEMO = 'No '
333000            GO TO DISPLAY-PANEL-TPS0052B
337500          END-IF
337400         PERFORM DISPLAY-MAIL-MEMO THRU
337400                 DISPLAY-MAIL-MEMO-EXIT
333000         GO TO DISPLAY-PANEL-TPS0052B
337500       END-IF.
337200
337300      IF THEY-HIT-F6
FLD013         IF PA-HOLD-DETAIL-CHART-MEMO = 'No '
333000            GO TO DISPLAY-PANEL-TPS0052B
337500          END-IF
337400         PERFORM DISPLAY-CHART-MEMO THRU
337400                 DISPLAY-CHART-MEMO-EXIT
333000         GO TO DISPLAY-PANEL-TPS0052B
337500       END-IF.
337600
337700      IF THEY-HIT-END
228900         GO TO SHOW-ONHOLD-ITEMS
337900       END-IF.
338000
333000      GO TO DISPLAY-PANEL-TPS0052B.
338200
299900*06/16
528600 READ-CHART-MEMO.
529200     PERFORM VARYING THE-INDEX FROM 1 BY 1
529300            UNTIL   THE-INDEX > 18
529600        MOVE SPACES TO TPSR0100-POPUP-LINE(THE-INDEX)
529700      END-PERFORM.
529800
492800     INITIALIZE TPS-CATMO-REC.
492600     MOVE F-PRIME      TO FILE-KEY.
159300     MOVE F-OPEN-INPUT TO FILE-ACTION.
492800     CALL TPSIO016 USING FILE-REQUEST TPS-CATMO-REC.
493300     IF NOT A-SUCCESSFUL-OPERATION
493400        MOVE ' MEMO   ' TO FILE-NAME
493500        MOVE 'TPS052-OPN' TO FILE-TEXT
493600        PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
493700        GO TO TPS052-COMMON-EXIT
493800      END-IF.
529800
530500      MOVE MAIL-ACCT-NO         TO CMEMO-ACCT-NO.
530600      MOVE MAIL-SUB-ACCT        TO CMEMO-SUB-ACCT.
530700      MOVE MAIL-RECEIVE-DATE    TO CMEMO-RECEIVE-DATE.
530800      MOVE MAIL-RECEIVE-NUMBER  TO CMEMO-RECEIVE-NUMBER.
530900      MOVE 99                   TO CMEMO-CHART-CATEGORY-NO.
531000      MOVE SPACES               TO CMEMO-ROOM-TO-EXPAND.
531100      MOVE 0                    TO CMEMO-RECORD-NUMBER.
531200      MOVE 0                    TO WK-IDX.
531500
531600 READ-CHART-RECORDS.
531700      ADD 1                     TO CMEMO-RECORD-NUMBER.
531800      PERFORM READ-TPSIO016-DATA THRU
531900              READ-TPSIO016-DATA-EXIT.
532000
532100      IF CLNT-PROFILE-ACCT-NO         NOT = CMEMO-ACCT-NO OR
532200         CLNT-PROFILE-SUB-ACCT        NOT = CMEMO-SUB-ACCT
492600         MOVE F-PRIME      TO FILE-KEY
159300         MOVE F-OPEN-INPUT TO FILE-ACTION
492800         CALL TPSIO016 USING FILE-REQUEST TPS-CATMO-REC
493300         IF NOT A-SUCCESSFUL-OPERATION
493400            MOVE ' MEMO   ' TO FILE-NAME
493500            MOVE 'TPS052-CLO' TO FILE-TEXT
493600            PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
493700            GO TO TPS052-COMMON-EXIT
493800          END-IF
528600         GO TO READ-CHART-MEMO-EXIT
534600       END-IF.
532400
534100      SET WK-IDX UP BY 1.
534200      MOVE CMEMO-LINE-OF-MEMO TO TPSR0100-POPUP-LINE(WK-IDX).
535000      GO TO READ-CHART-RECORDS.
528600 READ-CHART-MEMO-EXIT. EXIT.
535100
535100
528600 DISPLAY-CHART-MEMO.
FLD001      MOVE 'P'                    TO CHART-ACCT-PFKEYS-O
FLD002                                     CHART-ACCT-TYPEIN-01-O
FLD002                                     CHART-ACCT-TYPEIN-02-O
FLD002                                     CHART-ACCT-TYPEIN-03-O
FLD002                                     CHART-ACCT-TYPEIN-04-O
FLD002                                     CHART-ACCT-TYPEIN-05-O
FLD002                                     CHART-ACCT-TYPEIN-06-O
FLD002                                     CHART-ACCT-TYPEIN-07-O
FLD002                                     CHART-ACCT-TYPEIN-08-O
FLD002                                     CHART-ACCT-TYPEIN-09-O
FLD002                                     CHART-ACCT-TYPEIN-10-O
FLD002                                     CHART-ACCT-TYPEIN-11-O
FLD002                                     CHART-ACCT-TYPEIN-12-O
FLD002                                     CHART-ACCT-TYPEIN-13-O
FLD002                                     CHART-ACCT-TYPEIN-14-O
FLD002                                     CHART-ACCT-TYPEIN-15-O
FLD002                                     CHART-ACCT-TYPEIN-16-O
FLD002                                     CHART-ACCT-TYPEIN-17-O.
          SET TPSR0100-MESSAGE-BAR-PERSIST TO TRUE
239000    MOVE '        END KEY FOR PREVIOUS PANEL            '
239100                     TO TPSR0100-MESSAGE-TEXT
453100    CALL GUISCREEN USING TPSR0100-1
453200                         TPSR0100-2
453300                         TPSR0100-3
453400                         TPSR0100-4.
234100
234200    MOVE TPSR0100-EVENT-ID        TO EXIT-KEY-NAMES.
234300
234400    IF NOT THEY-HIT-END OR TPSR0100-EVENT-CLOSE-AND-STOP
452900       GO TO DISPLAY-CHART-MEMO
234600     END-IF.
528600 DISPLAY-CHART-MEMO-EXIT. EXIT.
535200
299900*06/16
456600
456700 READ-MAIL-MEMO.
456900    MOVE F-PRIME TO FILE-KEY.
457000    MOVE F-READ  TO FILE-ACTION.
457100    CALL TPSIOMEM USING FILE-REQUEST TPSMEMO-4
457300    IF NO-RECORD-WAS-FOUND
457300       MOVE SPACES     TO TPS-MEMO-LINE-01(1:500)
458700       GO TO READ-MAIL-MEMO-EXIT
458000     END-IF.
458100    IF NOT A-SUCCESSFUL-OPERATION
458200       MOVE 'TPSMEMO ' TO FILE-NAME
458300       MOVE 'TPS052-RMM' TO FILE-TEXT
458400       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
458600       GO TO TPS052-COMMON-EXIT
458000     END-IF.
047200    MOVE SPACES                TO MEMO-ACCT-NO
047300                                  MEMO-SUB-ACCT
047400                                  MEMO-RECEIVE-DATE
047500                                  MEMO-RECEIVE-NUMBER.
458700 READ-MAIL-MEMO-EXIT. EXIT.
458700
299900*06/16
452900 DISPLAY-MAIL-MEMO.
          MOVE 'P'                      TO TPS-MEMO-LINE-01-O
                                           TPS-MEMO-LINE-02-01-O
                                           TPS-MEMO-LINE-02-O
                                           TPS-MEMO-LINE-03-01-O
                                           TPS-MEMO-LINE-03-O
                                           TPS-MEMO-LINE-04-01-O
                                           TPS-MEMO-LINE-04-O
                                           TPS-MEMO-LINE-05-01-O
                                           TPS-MEMO-LINE-05-O
                                           TPS-MEMO-LINE-06-01-O
                                           TPS-MEMO-LINE-06-O
                                           TPS-MEMO-LINE-07-01-O
                                           TPS-MEMO-LINE-07-O
                                           TPS-MEMO-LINE-08-01-O
                                           TPS-MEMO-LINE-08-O
                                           TPS-MEMO-LINE-09-01-O
                                           TPS-MEMO-LINE-09-O
                                           TPS-MEMO-LINE-10-01-O
                                           TPS-MEMO-LINE-10-O.
238900*   MOVE 1           TO TPSMEMO-DISPLAY-OPTION
239000    MOVE '        END KEY FOR PREVIOUS PANEL            '
239100                     TO TPSMEMO-MESSAGE-TEXT
453100    CALL GUISCREEN USING TPSMEMO-1
453200                         TPSMEMO-2
453300                         TPSMEMO-3
453400                         TPSMEMO-4.
234100
234200    MOVE TPSMEMO-EVENT-ID        TO EXIT-KEY-NAMES.
234300
234400    IF NOT THEY-HIT-END
452900       GO TO DISPLAY-MAIL-MEMO
234600     END-IF.
452900 DISPLAY-MAIL-MEMO-EXIT. EXIT.
456600
299900
338300
338300
335800 CHANGE-DISPOSITION.
FLD005    PERFORM VARYING THE-INDEX FROM 1 BY 1
FLD005              UNTIL THE-INDEX > 16
FLD005        MOVE SPACES          TO PA-ONHOLD-NEW-DISPOSIT(THE-INDEX)
048000     END-PERFORM.
048000    MOVE ZEROS               TO WK-IDX
033800                                SAV-WK-IDX.
048000
335800 LOAD-DISPOSITION.
FLD005    PERFORM VARYING THE-INDEX FROM 1 BY 1
FLD005              UNTIL THE-INDEX > 16
FLD005        MOVE SPACES          TO PA-ONHOLD-NEW-DISPOSIT(THE-INDEX)
048000     END-PERFORM.
FLD005    PERFORM VARYING THE-INDEX FROM 1 BY 1
FLD005              UNTIL THE-INDEX > 16
080500       SET WK-IDX UP BY 1
080500       IF DISPOSITION-DESCRIPTION(WK-IDX) = HIGH-VALUES
228900          GO TO SHOW-NEW-DISPOSITIONS
048000        END-IF
080300       MOVE DISPOSITION-CODE(WK-IDX)
FLD005              TO PA-ONHOLD-NEW-DISPOSIT(THE-INDEX)(1:2)
080500       MOVE DISPOSITION-DESCRIPTION(WK-IDX)
FLD005              TO PA-ONHOLD-NEW-DISPOSIT(THE-INDEX)(4:28)
048000     END-PERFORM.
048000
231000
228900 SHOW-NEW-DISPOSITIONS.
       
231300      SET TPS0052C-MESSAGE-BAR-PERSIST TO TRUE.
231400      MOVE 'SELECT DISPOSITION-NTR TO PROCESS OR END KEY-PREV'
231500                                TO TPS0052C-MESSAGE-TEXT.
233230
233300 DISPLAY-PANEL-TPS0052C.
233400      MOVE 1           TO TPS0052C-ACTIVE-FIELD-ID.
233600      SET TPS0052C-DO-DISPLAY TO TRUE.
233700      CALL GUISCREEN USING TPS0052C-1
233800                           TPS0052C-2
233900                           TPS0052C-3
234000                           TPS0052C-4.
234100
234200      MOVE TPS0052C-EVENT-ID TO EXIT-KEY-NAMES.
234300
234400      IF THEY-HIT-END OR TPS0052C-EVENT-CLOSE-AND-STOP
335900          GO TO CHANGE-DISPOSITION-EXIT
234600       END-IF.
234700
234800      IF THEY-HIT-PAGE-DOWN
080500         SET WK-IDX UP BY 1
080500         IF DISPOSITION-DESCRIPTION(WK-IDX) = HIGH-VALUES
080500            SET WK-IDX DOWN BY 1
235000            SET TPS0052C-MESSAGE-BAR-PERSIST TO TRUE
235100            MOVE 'U CANNOT PAGE DOWN, PAGE UP OR SELECT DISPOSIT'
235200                             TO TPS0052C-MESSAGE-TEXT
235300            GO TO DISPLAY-PANEL-TPS0052C
235400          END-IF
235500         MOVE SAV-WK-IDX             TO WK-IDX
235600         SET WK-IDX UP BY 16
235700         MOVE WK-IDX                 TO SAV-WK-IDX
335800         GO TO LOAD-DISPOSITION
236400       END-IF.
236500
236600      IF THEY-HIT-PAGE-UP
236700         IF SAV-WK-IDX = 0
236800            SET TPS0052C-MESSAGE-BAR-PERSIST TO TRUE
236900            MOVE 'U CANNOT PAGE UP, PAGE DOWN OR SELECT DISPOSIT'
237000                             TO TPS0052C-MESSAGE-TEXT
235600            MOVE ZEROS       TO WK-IDX
235700                                SAV-WK-IDX
335800            GO TO LOAD-DISPOSITION
237200          END-IF
237400         IF WK-IDX < 16
237600            MOVE ZEROS               TO SAV-WK-IDX
237700                                        WK-IDX
335800            GO TO LOAD-DISPOSITION
237900          END-IF
238000         MOVE SAV-WK-IDX             TO WK-IDX
238100         SET WK-IDX DOWN BY 16
238200         MOVE WK-IDX                 TO SAV-WK-IDX
335800         GO TO LOAD-DISPOSITION
238500       END-IF.
238600
238800      IF NOT THEY-HIT-ALT-ENTER
238900         SET TPS0052C-MESSAGE-BAR-PERSIST TO TRUE
239000         MOVE ' VALID KEYS - ENTER, END,PAGE UP OR PAGE DOWN '
239100                          TO TPS0052C-MESSAGE-TEXT
239200         GO TO DISPLAY-PANEL-TPS0052C
239300       END-IF.
239400
239500      MOVE TPS0052C-ACTIVE-FIELD-ID  TO CURSOR-IDX.
FLD005      IF PA-ONHOLD-NEW-DISPOSIT(CURSOR-IDX) = SPACES
238900         SET TPS0052C-MESSAGE-BAR-PERSIST TO TRUE
239000         MOVE 'INVALID LINE SELECTED, TRY AGAIN'
239100                          TO TPS0052C-MESSAGE-TEXT
239200         GO TO DISPLAY-PANEL-TPS0052C
239300       END-IF.

FLD005      MOVE PA-ONHOLD-NEW-DISPOSIT(CURSOR-IDX)(1:2)
048000                     TO MAIL-DISPOSITION.
338300
358300     PERFORM REWRITE-RECEIVE-FILE THRU
358400             REWRITE-RECEIVE-FILE-EXIT.
338300*06/17 DICK
358300     PERFORM READ-PAMON-FILE THRU
358300             READ-PAMON-FILE-EXIT.
338300
338300     MOVE DISPOSITION-CHANGED     TO PAM-ADDRESSOR-NAME.
338300
494200     PERFORM REWRITE-PAMON-FILE THRU
494200             REWRITE-PAMON-FILE-EXIT.
338300
335900 CHANGE-DISPOSITION-EXIT. EXIT.
366700
366800
366900 END-THE-DISPLAYS.
368000      EXIT.
368100
391200
391300
391301
391332
391333
391334
391340
391400
391500 CLEAR-FIELDS-TPS0052A.
391600      PERFORM VARYING THE-INDEX FROM 1 BY 1
391700                UNTIL THE-INDEX > 16
FLD005         MOVE SPACES TO TPS0052A-ADDRESSOR-NAME-TBL(THE-INDEX)
FLD006                             TPS0052A-CATEGORY-TBL(THE-INDEX)
FLD007         MOVE ZEROS  TO TPS0052A-RECEIVE-DATE-TBL(THE-INDEX)
FLD008                        TPS0052A-RECEIVE-NUMBER-TBL(THE-INDEX)
392500       END-PERFORM.
392600 CLEAR-FIELDS-TPS0052A-EXIT. EXIT.
397300
397400
397500 RESET-COLORS-TPS0052A.
397600*     MOVE ZEROS          TO TPS0052A-RECEIVE-DATE-01-C
397600*                            TPS0052A-RECEIVE-DATE-02-C
397600*                            TPS0052A-RECEIVE-DATE-03-C
397600*                            TPS0052A-RECEIVE-DATE-04-C
397600*                            TPS0052A-RECEIVE-DATE-05-C
397600*                            TPS0052A-RECEIVE-DATE-06-C
397600*                            TPS0052A-RECEIVE-DATE-07-C
397600*                            TPS0052A-RECEIVE-DATE-08-C
397600*                            TPS0052A-RECEIVE-DATE-09-C
397600*                            TPS0052A-RECEIVE-DATE-10-C
397600*                            TPS0052A-RECEIVE-DATE-11-C
397600*                            TPS0052A-RECEIVE-DATE-12-C
397600*                            TPS0052A-RECEIVE-DATE-13-C
397600*                            TPS0052A-RECEIVE-DATE-14-C
397600*                            TPS0052A-RECEIVE-DATE-15-C
397600*                            TPS0052A-RECEIVE-DATE-16-C
FLD006*                            TPS0052A-ADDRESSOR-NAME-01-C
FLD006*                            TPS0052A-ADDRESSOR-NAME-02-C
FLD006*                            TPS0052A-ADDRESSOR-NAME-03-C
FLD006*                            TPS0052A-ADDRESSOR-NAME-04-C
FLD006*                            TPS0052A-ADDRESSOR-NAME-05-C
FLD006*                            TPS0052A-ADDRESSOR-NAME-06-C
FLD006*                            TPS0052A-ADDRESSOR-NAME-07-C
FLD006*                            TPS0052A-ADDRESSOR-NAME-08-C
FLD006*                            TPS0052A-ADDRESSOR-NAME-09-C
FLD006*                            TPS0052A-ADDRESSOR-NAME-10-C
FLD006*                            TPS0052A-ADDRESSOR-NAME-11-C
FLD006*                            TPS0052A-ADDRESSOR-NAME-12-C
FLD006*                            TPS0052A-ADDRESSOR-NAME-13-C
FLD006*                            TPS0052A-ADDRESSOR-NAME-14-C
FLD006*                            TPS0052A-ADDRESSOR-NAME-15-C
FLD006*                            TPS0052A-ADDRESSOR-NAME-16-C
FLD007*                            TPS0052A-CATEGORY-01-C
FLD007*                            TPS0052A-CATEGORY-02-C
FLD007*                            TPS0052A-CATEGORY-03-C
FLD007*                            TPS0052A-CATEGORY-04-C
FLD007*                            TPS0052A-CATEGORY-05-C
FLD007*                            TPS0052A-CATEGORY-06-C
FLD007*                            TPS0052A-CATEGORY-07-C
FLD007*                            TPS0052A-CATEGORY-08-C
FLD007*                            TPS0052A-CATEGORY-09-C
FLD007*                            TPS0052A-CATEGORY-10-C
FLD007*                            TPS0052A-CATEGORY-11-C
FLD007*                            TPS0052A-CATEGORY-12-C
FLD007*                            TPS0052A-CATEGORY-13-C
FLD007*                            TPS0052A-CATEGORY-14-C
FLD007*                            TPS0052A-CATEGORY-15-C
FLD007*                            TPS0052A-CATEGORY-16-C
FLD008*                            TPS0052A-RECEIVE-DATE-01-C
FLD008*                            TPS0052A-RECEIVE-DATE-02-C
FLD008*                            TPS0052A-RECEIVE-DATE-03-C
FLD008*                            TPS0052A-RECEIVE-DATE-04-C
FLD008*                            TPS0052A-RECEIVE-DATE-05-C
FLD008*                            TPS0052A-RECEIVE-DATE-06-C
FLD008*                            TPS0052A-RECEIVE-DATE-07-C
FLD008*                            TPS0052A-RECEIVE-DATE-08-C
FLD008*                            TPS0052A-RECEIVE-DATE-09-C
FLD008*                            TPS0052A-RECEIVE-DATE-10-C
FLD008*                            TPS0052A-RECEIVE-DATE-11-C
FLD008*                            TPS0052A-RECEIVE-DATE-12-C
FLD008*                            TPS0052A-RECEIVE-DATE-13-C
FLD008*                            TPS0052A-RECEIVE-DATE-14-C
FLD008*                            TPS0052A-RECEIVE-DATE-15-C
FLD008*                            TPS0052A-RECEIVE-DATE-16-C
FLD009*                            TPS0052A-RECEIVE-NUMBER-01-C
FLD009*                            TPS0052A-RECEIVE-NUMBER-02-C
FLD009*                            TPS0052A-RECEIVE-NUMBER-03-C
FLD009*                            TPS0052A-RECEIVE-NUMBER-04-C
FLD009*                            TPS0052A-RECEIVE-NUMBER-05-C
FLD009*                            TPS0052A-RECEIVE-NUMBER-06-C
FLD009*                            TPS0052A-RECEIVE-NUMBER-07-C
FLD009*                            TPS0052A-RECEIVE-NUMBER-08-C
FLD009*                            TPS0052A-RECEIVE-NUMBER-09-C
FLD009*                            TPS0052A-RECEIVE-NUMBER-10-C
FLD009*                            TPS0052A-RECEIVE-NUMBER-11-C
FLD009*                            TPS0052A-RECEIVE-NUMBER-12-C
FLD009*                            TPS0052A-RECEIVE-NUMBER-13-C
FLD009*                            TPS0052A-RECEIVE-NUMBER-14-C
FLD009*                            TPS0052A-RECEIVE-NUMBER-15-C
FLD009*                            TPS0052A-RECEIVE-NUMBER-16-C.
408400 RESET-COLORS-TPS0052A-EXIT. EXIT.
408500
418800
418900
419000 MAKE-RECEIVE-RED-TPS0052A.
419100       IF WK-IDX = 1
397600*         MOVE '0111'           TO TPS0052A-RECEIVE-DATE-01-C
FLD006*                                  TPS0052A-ADDRESSOR-NAME-01-C
FLD007*                                  TPS0052A-CATEGORY-01-C
FLD008*                                  TPS0052A-RECEIVE-DATE-01-C
FLD009*                                  TPS0052A-RECEIVE-NUMBER-01-C
419400         ELSE
419500       IF WK-IDX = 2
397600*         MOVE '0111'           TO TPS0052A-RECEIVE-DATE-02-C
FLD006*                                  TPS0052A-ADDRESSOR-NAME-02-C
FLD007*                                  TPS0052A-CATEGORY-02-C
FLD008*                                  TPS0052A-RECEIVE-DATE-02-C
FLD009*                                  TPS0052A-RECEIVE-NUMBER-02-C
419800         ELSE
419900       IF WK-IDX = 3
397600*         MOVE '0111'           TO TPS0052A-RECEIVE-DATE-03-C
FLD006*                                  TPS0052A-ADDRESSOR-NAME-03-C
FLD007*                                  TPS0052A-CATEGORY-03-C
FLD008*                                  TPS0052A-RECEIVE-DATE-03-C
FLD009*                                  TPS0052A-RECEIVE-NUMBER-03-C
420200         ELSE
420300       IF WK-IDX = 4
397600*         MOVE '0111'           TO TPS0052A-RECEIVE-DATE-04-C
FLD006*                                  TPS0052A-ADDRESSOR-NAME-04-C
FLD007*                                  TPS0052A-CATEGORY-04-C
FLD008*                                  TPS0052A-RECEIVE-DATE-04-C
FLD009*                                  TPS0052A-RECEIVE-NUMBER-04-C
420600         ELSE
420700       IF WK-IDX = 5
397600*         MOVE '0111'           TO TPS0052A-RECEIVE-DATE-05-C
FLD006*                                  TPS0052A-ADDRESSOR-NAME-05-C
FLD007*                                  TPS0052A-CATEGORY-05-C
FLD008*                                  TPS0052A-RECEIVE-DATE-05-C
FLD009*                                  TPS0052A-RECEIVE-NUMBER-05-C
421000         ELSE
421100       IF WK-IDX = 6
397600*         MOVE '0111'           TO TPS0052A-RECEIVE-DATE-06-C
FLD006*                                  TPS0052A-ADDRESSOR-NAME-06-C
FLD007*                                  TPS0052A-CATEGORY-06-C
FLD008*                                  TPS0052A-RECEIVE-DATE-06-C
FLD009*                                  TPS0052A-RECEIVE-NUMBER-06-C
421400         ELSE
421500       IF WK-IDX = 7
397600*         MOVE '0111'           TO TPS0052A-RECEIVE-DATE-07-C
FLD006*                                  TPS0052A-ADDRESSOR-NAME-07-C
FLD007*                                  TPS0052A-CATEGORY-07-C
FLD008*                                  TPS0052A-RECEIVE-DATE-07-C
FLD009*                                  TPS0052A-RECEIVE-NUMBER-07-C
421800         ELSE
421900       IF WK-IDX = 8
397600*         MOVE '0111'           TO TPS0052A-RECEIVE-DATE-08-C
FLD006*                                  TPS0052A-ADDRESSOR-NAME-08-C
FLD007*                                  TPS0052A-CATEGORY-08-C
FLD008*                                  TPS0052A-RECEIVE-DATE-08-C
FLD009*                                  TPS0052A-RECEIVE-NUMBER-08-C
422200         ELSE
422300       IF WK-IDX = 9
397600*         MOVE '0111'           TO TPS0052A-RECEIVE-DATE-09-C
FLD006*                                  TPS0052A-ADDRESSOR-NAME-09-C
FLD007*                                  TPS0052A-CATEGORY-09-C
FLD008*                                  TPS0052A-RECEIVE-DATE-09-C
FLD009*                                  TPS0052A-RECEIVE-NUMBER-09-C
422600         ELSE
422700       IF WK-IDX = 10
397600*         MOVE '0111'           TO TPS0052A-RECEIVE-DATE-10-C
FLD006*                                  TPS0052A-ADDRESSOR-NAME-10-C
FLD007*                                  TPS0052A-CATEGORY-10-C
FLD008*                                  TPS0052A-RECEIVE-DATE-10-C
FLD009*                                  TPS0052A-RECEIVE-NUMBER-10-C
423000         ELSE
423100       IF WK-IDX = 11
397600*         MOVE '0111'           TO TPS0052A-RECEIVE-DATE-11-C
FLD006*                                  TPS0052A-ADDRESSOR-NAME-11-C
FLD007*                                  TPS0052A-CATEGORY-11-C
FLD008*                                  TPS0052A-RECEIVE-DATE-11-C
FLD009*                                  TPS0052A-RECEIVE-NUMBER-11-C
423400         ELSE
423500       IF WK-IDX = 12
397600*         MOVE '0111'           TO TPS0052A-RECEIVE-DATE-12-C
FLD006*                                  TPS0052A-ADDRESSOR-NAME-12-C
FLD007*                                  TPS0052A-CATEGORY-12-C
FLD008*                                  TPS0052A-RECEIVE-DATE-12-C
FLD009*                                  TPS0052A-RECEIVE-NUMBER-12-C
423800         ELSE
423900       IF WK-IDX = 13
397600*         MOVE '0111'           TO TPS0052A-RECEIVE-DATE-13-C
FLD006*                                  TPS0052A-ADDRESSOR-NAME-13-C
FLD007*                                  TPS0052A-CATEGORY-13-C
FLD008*                                  TPS0052A-RECEIVE-DATE-13-C
FLD009*                                  TPS0052A-RECEIVE-NUMBER-13-C
424200         ELSE
424300       IF WK-IDX = 14
397600*         MOVE '0111'           TO TPS0052A-RECEIVE-DATE-14-C
FLD006*                                  TPS0052A-ADDRESSOR-NAME-14-C
FLD007*                                  TPS0052A-CATEGORY-14-C
FLD008*                                  TPS0052A-RECEIVE-DATE-14-C
FLD009*                                  TPS0052A-RECEIVE-NUMBER-14-C
424600         ELSE
424700       IF WK-IDX = 15
397600*         MOVE '0111'           TO TPS0052A-RECEIVE-DATE-15-C
FLD006*                                  TPS0052A-ADDRESSOR-NAME-15-C
FLD007*                                  TPS0052A-CATEGORY-15-C
FLD008*                                  TPS0052A-RECEIVE-DATE-15-C
FLD009*                                  TPS0052A-RECEIVE-NUMBER-15-C
424600         ELSE
425100       IF WK-IDX = 16
397600*         MOVE '0111'           TO TPS0052A-RECEIVE-DATE-16-C
FLD006*                                  TPS0052A-ADDRESSOR-NAME-16-C
FLD007*                                  TPS0052A-CATEGORY-16-C
FLD008*                                  TPS0052A-RECEIVE-DATE-16-C
FLD009*                                  TPS0052A-RECEIVE-NUMBER-16-C
426200        END-IF.
419000 MAKE-RECEIVE-RED-TPS0052A-EXIT. EXIT.
426400
489800
083900
080600 READ-PAMON-FILE.
084100    MOVE F-PRIME TO FILE-KEY.
084200    MOVE F-READ  TO FILE-ACTION.
178000    CALL TPSIO027 USING FILE-REQUEST TPS-PAMON-REC.
084900    IF NOT A-SUCCESSFUL-OPERATION
085000       MOVE ' PAMON' TO FILE-NAME
085100       MOVE 'TPS052-READ ' TO FILE-TEXT
085200       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
085300       GO TO TPS052-COMMON-EXIT
085400     END-IF.
085500
080600 READ-PAMON-FILE-EXIT. EXIT.
088200
494100
494200 REWRITE-PAMON-FILE.
494300    MOVE F-PRIME TO FILE-KEY.
494400    MOVE F-REWRITE   TO FILE-ACTION.
178000    CALL TPSIO027 USING FILE-REQUEST TPS-PAMON-REC.
494600    IF NOT A-SUCCESSFUL-OPERATION
494700       MOVE ' PAMON  ' TO FILE-NAME
494800       MOVE 'TPS052-REW' TO FILE-TEXT
494900       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
495000       GO TO TPS052-COMMON-EXIT
495100     END-IF.
495200 REWRITE-PAMON-FILE-EXIT. EXIT.
492300
492400
492500 READ-RECEIVE-FILE.
492600    MOVE F-PRIME TO FILE-KEY.
492700    MOVE F-READ      TO FILE-ACTION.
492800    CALL TPSIOREC USING FILE-REQUEST TPS-MAIL-REC.
492900    IF NO-RECORD-WAS-FOUND
493000       MOVE ZEROS    TO MAIL-ACCT-NO
493100       GO TO READ-RECEIVE-FILE-EXIT
493200     END-IF.
493300    IF NOT A-SUCCESSFUL-OPERATION
493400       MOVE ' RECEIVE' TO FILE-NAME
493500       MOVE 'TPS052-RD ' TO FILE-TEXT
493600       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
493700       GO TO TPS052-COMMON-EXIT
493800     END-IF.
493900 READ-RECEIVE-FILE-EXIT. EXIT.
494000
494100
494200 REWRITE-RECEIVE-FILE.
494300    MOVE F-PRIME TO FILE-KEY.
494400    MOVE F-REWRITE   TO FILE-ACTION.
494500    CALL TPSIOREC USING FILE-REQUEST TPS-MAIL-REC.
494600    IF NOT A-SUCCESSFUL-OPERATION
494700       MOVE ' RECEIVE' TO FILE-NAME
494800       MOVE 'TPS052-REW' TO FILE-TEXT
494900       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
495000       GO TO TPS052-COMMON-EXIT
495100     END-IF.
495200 REWRITE-RECEIVE-FILE-EXIT. EXIT.
495300
495400
492400
531800 READ-TPSIO016-DATA.
492600    MOVE F-PRIME     TO FILE-KEY.
492700    MOVE F-READ      TO FILE-ACTION.
492800    CALL TPSIO016 USING FILE-REQUEST TPS-CATMO-REC.
492900    IF NO-RECORD-WAS-FOUND
530500       MOVE ZEROS    TO CMEMO-ACCT-NO
531900       GO TO READ-TPSIO016-DATA-EXIT
493200     END-IF.
493300    IF NOT A-SUCCESSFUL-OPERATION
493400       MOVE ' MEMO   ' TO FILE-NAME
493500       MOVE 'TPS052-RD ' TO FILE-TEXT
493600       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
493700       GO TO TPS052-COMMON-EXIT
493800     END-IF.
531900 READ-TPSIO016-DATA-EXIT. EXIT.
497000
555300
555400*----------------------------------------------------------
555500
555600 DISPLAY-IMAGE.
555700      IF MAIL-IMAGE-NUMBER OF TPS-MAIL-REC = ZEROS
               SET TPS0052B-MESSAGE-BAR-PERSIST TO TRUE
555800         MOVE 'DOCUMENT WAS NOT IMAGED'
555900                             TO TPS0052B-MESSAGE-TEXT
556000         GO TO DISPLAY-PANEL-TPS0052B-IMAGE
556100       END-IF.
556200       CALL TPSVIEW USING TPS-LOGON-REC
556300                          TPS-PROFL-REC
556400                          DUMMY-2BYTE-REC
556500                          TPS-MAIL-REC
556600                          TPS-PARM-VIEW.
556700
556800 REFRESH-THE-SCREEN.
       

557500      GO TO DISPLAY-PANEL-TPS0052B.
557600
557700 PRINT-IMAGE.
557800      IF MAIL-IMAGE-NUMBER OF TPS-MAIL-REC = ZEROS
               SET TPS0052B-MESSAGE-BAR-PERSIST TO TRUE
557900         MOVE 'DOCUMENT WAS NOT IMAGED'
558000                             TO TPS0052B-MESSAGE-TEXT
558100         GO TO DISPLAY-PANEL-TPS0052B-IMAGE
558200       END-IF.
558300
558400       CALL TPSVIEW USING TPS-LOGON-REC
558500                          TPS-PROFL-REC
558600                          DUMMY-2BYTE-REC
558700                          TPS-MAIL-REC
558800                          TPS-PARM-PRINT.
556800       GO TO REFRESH-THE-SCREEN.
559000
559100*----------------------------------------------------------
559200
559300
559400*05/11/98
559500 RECODE-CHART-OF-ACCOUNTS.
559600      MOVE RECUR-CHART-ACCT-01   TO SAV-CHART-OF-ACCTS-01.
559700      MOVE RECUR-CHART-ACCT-02   TO SAV-CHART-OF-ACCTS-02.
559800      MOVE RECUR-CHART-ACCT-03   TO SAV-CHART-OF-ACCTS-03.
559900      MOVE RECUR-CHART-ACCT-04   TO SAV-CHART-OF-ACCTS-04.
560000      MOVE RECUR-CHART-ACCT-05   TO SAV-CHART-OF-ACCTS-05.
560100      MOVE RECUR-CHART-ACCT-06   TO SAV-CHART-OF-ACCTS-06.
560200      MOVE RECUR-CHART-ACCT-07   TO SAV-CHART-OF-ACCTS-07.
560300      MOVE RECUR-CHART-ACCT-08   TO SAV-CHART-OF-ACCTS-08.
560400
560500      MOVE 2                    TO WS-ACTION-PARM.
560600      CALL TPSCHART USING WS-PARMS
                                TPS-PROFL-REC
                                TPS-MAIL-REC
                                WS-CURRENT-XY-PARM.
560700      CANCEL TPSCHART.

            MOVE WS-CURRENT-XY-PARM(1:4) TO WS-CURRENT-X.
            MOVE WS-CURRENT-XY-PARM(5:4) TO WS-CURRENT-Y.

560900*05/11/98
561000      IF RECUR-CHART-ACCT-01 NOT = SAV-CHART-OF-ACCTS-01
561100         GO TO RECODE-CHART-ERROR
561200       END-IF.
561300
561400      IF RECUR-CHART-ACCT-01 NOT = SAV-CHART-OF-ACCTS-01
561500       OR RECUR-CHART-ACCT-02 NOT = SAV-CHART-OF-ACCTS-02
561600        OR RECUR-CHART-ACCT-03 NOT = SAV-CHART-OF-ACCTS-03
561700         OR RECUR-CHART-ACCT-04 NOT = SAV-CHART-OF-ACCTS-04
561800          OR RECUR-CHART-ACCT-05 NOT = SAV-CHART-OF-ACCTS-05
561900           OR RECUR-CHART-ACCT-06 NOT = SAV-CHART-OF-ACCTS-06
562000            OR RECUR-CHART-ACCT-07 NOT = SAV-CHART-OF-ACCTS-07
562100             OR RECUR-CHART-ACCT-08 NOT = SAV-CHART-OF-ACCTS-08
562200                MOVE RECUR-CHART-ACCT-01
562300                                      TO SAV-CHART-OF-ACCTS-01
562400                MOVE RECUR-CHART-ACCT-02
562500                                      TO SAV-CHART-OF-ACCTS-02
562600                MOVE RECUR-CHART-ACCT-03
562700                                      TO SAV-CHART-OF-ACCTS-03
562800                MOVE RECUR-CHART-ACCT-04
562900                                      TO SAV-CHART-OF-ACCTS-04
563000                MOVE RECUR-CHART-ACCT-05
563100                                      TO SAV-CHART-OF-ACCTS-05
563200                MOVE RECUR-CHART-ACCT-06
563300                                      TO SAV-CHART-OF-ACCTS-06
563400                MOVE RECUR-CHART-ACCT-07
563500                                      TO SAV-CHART-OF-ACCTS-07
563600                MOVE RECUR-CHART-ACCT-08
563700                                      TO SAV-CHART-OF-ACCTS-08
563800                MOVE F-PRIME          TO FILE-KEY
563900                MOVE F-READ           TO FILE-ACTION
564000*************** MOVE F-READ-WITH-LOCK TO FILE-ACTION
564100                CALL TPSIOREC USING FILE-REQUEST TPS-MAIL-REC
564200                IF NOT A-SUCCESSFUL-OPERATION
564300                   MOVE ' RECEIVE' TO FILE-NAME
564400                   MOVE 'TPS052-RLK' TO FILE-TEXT
564500                   PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
564600                   GO TO TPS052-COMMON-EXIT
564700                 END-IF
564800                MOVE SAV-CHART-OF-ACCTS-01
564900                                        TO RECUR-CHART-ACCT-01
565000                MOVE SAV-CHART-OF-ACCTS-02
565100                                        TO RECUR-CHART-ACCT-02
565200                MOVE SAV-CHART-OF-ACCTS-03
565300                                        TO RECUR-CHART-ACCT-03
565400                MOVE SAV-CHART-OF-ACCTS-04
565500                                        TO RECUR-CHART-ACCT-04
565600                MOVE SAV-CHART-OF-ACCTS-05
565700                                        TO RECUR-CHART-ACCT-05
565800                MOVE SAV-CHART-OF-ACCTS-06
565900                                        TO RECUR-CHART-ACCT-06
566000                MOVE SAV-CHART-OF-ACCTS-07
566100                                        TO RECUR-CHART-ACCT-07
566200                MOVE SAV-CHART-OF-ACCTS-08
566300                                        TO RECUR-CHART-ACCT-08
566400                MOVE F-PRIME TO FILE-KEY
566500                MOVE F-REWRITE   TO FILE-ACTION
566600                CALL TPSIOREC USING FILE-REQUEST TPS-MAIL-REC
566700                IF NOT A-SUCCESSFUL-OPERATION
566800                   MOVE ' RECEIVE' TO FILE-NAME
566900                   MOVE 'TPS052-REW' TO FILE-TEXT
567000                   PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
567100                   GO TO TPS052-COMMON-EXIT
567200                 END-IF
358300                PERFORM READ-PAMON-FILE THRU
358300                        READ-PAMON-FILE-EXIT
564800                MOVE SAV-CHART-OF-ACCTS-01
564900                               TO PAM-NON-CHART-ACCOUNTS-01
564800                MOVE SAV-CHART-OF-ACCTS-02
564900                               TO PAM-NON-CHART-ACCOUNTS-02
564800                MOVE SAV-CHART-OF-ACCTS-03
564900                               TO PAM-NON-CHART-ACCOUNTS-03
564800                MOVE SAV-CHART-OF-ACCTS-04
564900                               TO PAM-NON-CHART-ACCOUNTS-04
564800                MOVE SAV-CHART-OF-ACCTS-05
564900                               TO PAM-NON-CHART-ACCOUNTS-05
564800                MOVE SAV-CHART-OF-ACCTS-06
564900                               TO PAM-NON-CHART-ACCOUNTS-06
564800                MOVE SAV-CHART-OF-ACCTS-07
564900                               TO PAM-NON-CHART-ACCOUNTS-07
564800                MOVE SAV-CHART-OF-ACCTS-08
564900                               TO PAM-NON-CHART-ACCOUNTS-08
494200                PERFORM REWRITE-PAMON-FILE THRU
494200                        REWRITE-PAMON-FILE-EXIT
568500                GO TO DISPLAY-PANEL-TPS0052B
568300       END-IF.
568400
568500      GO TO DISPLAY-PANEL-TPS0052B.
568600
568700
568800
568900 RECODE-CHART-ERROR.
569000*     MOVE 'O'         TO TPS0052B-REPAINT-SCREEN.
569100*     MOVE '6'         TO TPS0052B-INDICATORS.
569200*     CALL SCREENIO USING TPS0052B-PANEL
569300*                         TPS0052B-PASS-TO-EXIT
569400*                         TPS0052B-WORK-S
569500*                         TPS0052B-WORK-D.
569600      SET TPS0050J-DO-DISPLAY TO TRUE.
569700      CALL GUISCREEN USING TPS0050J-1
569800                           TPS0050J-2
569900                           TPS0050J-3
570000                           TPS0050J-4.
570100
570200      MOVE TPS0050J-EVENT-ID TO EXIT-KEY-NAMES.
570300
570400      IF THEY-HIT-ALT-ENTER
570500         MOVE SAV-CHART-OF-ACCTS-01  TO RECUR-CHART-ACCT-01
570600         MOVE SAV-CHART-OF-ACCTS-02  TO RECUR-CHART-ACCT-02
570700         MOVE SAV-CHART-OF-ACCTS-03  TO RECUR-CHART-ACCT-03
570800         MOVE SAV-CHART-OF-ACCTS-04  TO RECUR-CHART-ACCT-04
570900         MOVE SAV-CHART-OF-ACCTS-05  TO RECUR-CHART-ACCT-05
571000         MOVE SAV-CHART-OF-ACCTS-06  TO RECUR-CHART-ACCT-06
571100         MOVE SAV-CHART-OF-ACCTS-07  TO RECUR-CHART-ACCT-07
571200         MOVE SAV-CHART-OF-ACCTS-08  TO RECUR-CHART-ACCT-08
571300         GO TO RECODE-CHART-OF-ACCOUNTS
571400       END-IF.
571500
571600      IF THEY-HIT-END
333000         GO TO DISPLAY-PANEL-TPS0052B
571800       END-IF.
571900
572000      GO TO RECODE-CHART-ERROR.
572100
572200*----------------------------------------------------------
572300
078100
