        IDENTIFICATION DIVISION.
        PROGRAM-ID. TPS021C.
        AUTHOR. ALEX CASTRO.
      ****************************************************************
      **  REPORT OF COMMUNICATIONS RECIVED YEAR TO DATE BY CLIENT  *
      ****************************************************************

      *  PROGRAM IS CALLED BY TPS0006 AUTOMATICALLY EVERY MONDAY     *
      *  REPORT WILL SHOW RECEIVED MAIL ACTIVITY BY CLIENT YTD       *
      ***************************************************************

      *                 MAINTENANCE LOG                             *
      *12/05/18 FIXED OUT OF SCRIPT ERROR BY CHANGING (6:1) TO
      *        (5:2)                                              AC*

      ***************************************************************

       ENVIRONMENT DIVISION.
       CONFIGURATION SECTION.
       SOURCE-COMPUTER. IBM-PS2.
       OBJECT-COMPUTER. IBM-PS2.
       FILE-CONTROL.

           SELECT PRT-FILE1 ASSIGN TO REPORT-ASSIGNMENT1
               ORGANIZATION IS LINE SEQUENTIAL
               FILE STATUS IS TPS-FILE-STATUS.

           SELECT PRT-FILE2 ASSIGN TO REPORT-ASSIGNMENT2
               ORGANIZATION IS LINE SEQUENTIAL
               FILE STATUS IS TPS-FILE-STATUS.

      
       FD  PRT-FILE1
           LABEL RECORDS ARE OMITTED
           RECORD CONTAINS 180 CHARACTERS.


       01 PRT-RECORD                  PIC X(180).

       FD  PRT-FILE2
           LABEL RECORDS ARE OMITTED
           RECORD CONTAINS 500 CHARACTERS.


       01 PRT-RECORD2                 PIC X(500).



       WORKING-STORAGE SECTION.

***************** WINFORMS SCREEN DEFINITION **********

       01 PROCESS-RPTS type TPS000.PROCESS_RPTSForm.

       01 PROCESS-RPTS-DISPLAY-FLAG PIC 9(01) VALUE 0.


       01 WS-CURRENT-X                            PIC 9(04).
       01 WS-CURRENT-Y                            PIC 9(04).
       01 WS-CURRENT-XY-PARM.
          05 WS-X-PARM                            PIC 9(04).
          05 WS-Y-PARM                            PIC 9(04).

********************************************************

       01 REPORT-ASSIGNMENT1           PIC X(53) VALUE
             'L:\TPS\PROD\FILES\TPSREPRT\CommunicationsReceived.PCL'.

       01 REPORT-ASSIGNMENT2           PIC X(53) VALUE
             'L:\TPS\PROD\FILES\TPSREPRT\CommunicationsReceived.BAT'.
       
       01 REPORT-ASSIGNMENT2-LINE1.
          05 RPT-ASSIGN2-LINE1.
             10 FILLER                   PIC X(01) VALUE '@'.
             10 RPT-ASSIGN2-DRIVE        PIC X(01).
             10 FILLER                   PIC X(01) VALUE ':'.
       
       01 REPORT-ASSIGNMENT2-LINE2.
             10 FILLER                   PIC X(10) VALUE
                '@cd\jetpcl'.
       01 REPORT-ASSIGNMENT2-LINE3.
             10 FILLER                  PIC X(12) VALUE
                '@jetpcl.exe '.
             10 RPT-LINE3-DRIVE         PIC X(01).
             10 RPT-LINE3-PATH1         PIC X(53) VALUE
               ':\tps\PROD\FILES\TPSREPRT\CommunicationsReceived.PCL '.
             10 RPT-LINE3-DRIVE2        PIC X(01).
             10 RPT-LINE3-PATH2         PIC X(53) VALUE
              ':\tps\PROD\FILES\TPSREPRT\CommunicationsReceived.pdf '.
             10 RPT-LINE3-PDF           PIC X(28) VALUE
                '-d300 -Opdf:Binary;RotateImg'.
       01 REPORT-ASSIGNMENT2-LINE4.
             10 FILLER                  PIC X(05) VALUE
                '@exit'.
       01 DOS-COMMAND                          pic  x(80).
       01 WHAT-DRIVE-ASSIGNMENT            PIC  X(01) VALUE SPACES.

       01  PROGRAM-NAMES.
        10  TPSIOERR                      PIC X(08) VALUE 'TPSIOERR'.
        10  GUISCREEN                     PIC X(08) VALUE 'GS      '.       
        10  TPSIOREC                      PIC X(08) VALUE 'TPSIOREC'.
        10  TPSIO001                      PIC X(08) VALUE 'TPSIO001'.
        10  TPSIO004                      PIC X(08) VALUE 'TPSIO004'.
        10  FLOATBIG                      PIC X(08) VALUE 'FLOATBIG'.
        10  TPSDATES                      PIC X(08) VALUE 'TPSDATES'.
        10 FILLER      PIC X(08) VALUE HIGH-VALUES.

       01  TPS-FILE-STATUS                       PIC XX.
           88  TPS-CARRIER-FILE-OK VALUE '00', '02'.


       01  RESULT                     PIC 99 COMP-X VALUE 0.
       01  FUNCTION-35                PIC 99 COMP-X VALUE 35.
       01  NULL-PARAMETER.
            05  FILLER                PIC 99 COMP-X VALUE 0.
            05  FILLER                PIC X.

           COPY "TPSFILES.CPY".
           COPY "KEYVALUE.CPY".
           COPY "PCL5VALU.CPY".

        COPY PROCESS.COB.

       01  TPS-MAIL-REC.
           COPY "TPSMAIL.CPY".

       01  TPS-LOGON-REC.
           COPY "TPSLOGON.CPY".

       01  TPS-PROFL-REC.
           COPY "TPSPROFL.CPY".

       01 WS-CURRENT-ACCT                  PIC 9(10) VALUE ZEROS.

086500  01  WS-DATE-REQUEST.
086600      05  WS-DATE-PARAM          PIC  9(02).
086700      05  WS-DATE-TENBYTES       PIC  X(20) VALUE SPACES.
086800      05  FILLER REDEFINES WS-DATE-TENBYTES.
086900          10  WS-DATE-REFORM         PIC  X(06).
087000          10  WS-DATE-EXTEND         PIC  X(04).
087100          10  FILLER                 PIC  X(10).
087200      05  FILLER REDEFINES WS-DATE-TENBYTES.
087300          10  WS-DATE-REFORM-LEN06   PIC  X(06).
087400          10  FILLER                 PIC  X(14).
087500      05  FILLER REDEFINES WS-DATE-TENBYTES.
087600          10  WS-DATE-REFORM-LEN08   PIC  X(08).
087700          10  FILLER                 PIC  X(12).
087800      05  FILLER REDEFINES WS-DATE-TENBYTES.
087900          10  WS-DATE-REFORM-LEN10   PIC  X(10).
088000          10  FILLER                 PIC  X(10).

088200 01 WS-MONDAYS-DATE-CYMD           PIC X(08).

       01 WS-START-YEAR.
          05 WS-CC               PIC 99.
          05 WS-YY               PIC 99.
          05 WS-MM               PIC 99 VALUE 01.
          05 WS-DD               PIC 99 VALUE 01.

012100 01 THIS-YR-LO-DATE        PIC 9(08) VALUE ZERO.
012200 01 THIS-YR-HI-DATE        PIC 9(08) VALUE ZERO.
012300 01 THIS-WK-LO-DATE        PIC 9(08) VALUE ZERO.
012400 01 THIS-WK-HI-DATE        PIC 9(08) VALUE ZERO.


       01 TODAYS-DATE-CYMD.
          05 TODAYS-DATE-CC      PIC 99.
          05 TODAYS-DATE-YMD.
             10 TODAYS-DATE-YY   PIC 99.
             10 TODAYS-DATE-MM   PIC 99.
             10 TODAYS-DATE-DD   PIC 99.

088200 01 WS-TODAYS-DATE-CYMD            PIC X(08).
       01 WS-TMP-CYMD                    PIC X(08).

011702 01  PRT2-HDR1.
011703        05 FILLER                 PIC X(45) VALUE SPACES.
011704        05 FILLER                 PIC X(40) VALUE
011705          'Weekly Report of Communication Activity'.
011706        05 FILLER                 PIC X(10) VALUE SPACES.
011707        05 PRT2-HDR1-DATE         PIC X(20).
011709        05 FILLER                 PIC X(15) VALUE SPACES.
011710        05 FILLER                 PIC X(05) VALUE 'Page '.
011711        05 PRT2-HDR1-PAGE-NUM     PIC ZZ9.

011713*01  PAGE-COUNT                   PIC  9(03) VALUE ZEROS.
011714
011715 01  PRT2-HDR2.
011716****    15 FILLER                 PIC X(50) VALUE SPACES.
011717        05 FILLER                 PIC X(45) VALUE SPACES.
011718        05 FILLER                 PIC X(18) VALUE
011719          'For the Period of '.
011720        05 FOR-WEEK-FROM          PIC X(06) VALUE SPACES.
011722        05 FILLER                 PIC X(09) VALUE ' through '.
011723        05 FOR-WEEK-TO            PIC X(12) VALUE SPACES.

       
       01 PRT3-HDR3.
      *   05 FILLER                 PIC X(05) VALUE SPACES.
          05 FILLER                 PIC X(07) VALUE
            'Account'.
          05 FILLER                 PIC X(10) VALUE SPACES.
          05 FILLER                 PIC X(04) VALUE
            'Name'.
          05 FILLER                 PIC X(23) VALUE SPACES.
          05 FILLER                 PIC X(03) VALUE 'JAN'.
          05 FILLER                 PIC X(05) VALUE SPACES.
          05 FILLER                 PIC X(03) VALUE 'FEB'.
          05 FILLER                 PIC X(05) VALUE SPACES.
          05 FILLER                 PIC X(03) VALUE 'MAR'.
          05 FILLER                 PIC X(05) VALUE SPACES.
          05 FILLER                 PIC X(03) VALUE 'APR'.
          05 FILLER                 PIC X(05) VALUE SPACES.
          05 FILLER                 PIC X(03) VALUE 'MAY'.
          05 FILLER                 PIC X(05) VALUE SPACES.
          05 FILLER                 PIC X(03) VALUE 'JUN'.
          05 FILLER                 PIC X(05) VALUE SPACES.
          05 FILLER                 PIC X(03) VALUE 'JUL'.
          05 FILLER                 PIC X(05) VALUE SPACES.
          05 FILLER                 PIC X(03) VALUE 'AUG'.
          05 FILLER                 PIC X(05) VALUE SPACES.
          05 FILLER                 PIC X(03) VALUE 'SEP'.
          05 FILLER                 PIC X(05) VALUE SPACES.
          05 FILLER                 PIC X(03) VALUE 'OCT'.
          05 FILLER                 PIC X(05) VALUE SPACES.
          05 FILLER                 PIC X(03) VALUE 'NOV'.
          05 FILLER                 PIC X(05) VALUE SPACES.
          05 FILLER                 PIC X(03) VALUE 'DEC'.
          05 FILLER                 PIC X(05) VALUE SPACES.
          05 FILLER                 PIC X(05) VALUE 'TOTAL'.
       
       01 PRT4-HDR4.
      *   05 FILLER                PIC X(05) VALUE SPACES.
          05 PRT4-ACCT-NO          PIC 9(10).
          05 FILLER                PIC X(05) VALUE SPACES.
          05 PRT4-ACCT-NAME        PIC X(20).
          05 FILLER                PIC X(07) VALUE SPACES.
          05 PRT4-JAN              PIC ZZZZZ.
          05 FILLER                PIC X(03) VALUE SPACES.
          05 PRT4-FEB              PIC ZZZZZ.
          05 FILLER                PIC X(03) VALUE SPACES.
          05 PRT4-MAR              PIC ZZZZZ.
          05 FILLER                PIC X(03) VALUE SPACES.
          05 PRT4-APR              PIC ZZZZZ.
          05 FILLER                PIC X(03) VALUE SPACES.
          05 PRT4-MAY              PIC ZZZZZ.
          05 FILLER                PIC X(03) VALUE SPACES.
          05 PRT4-JUN              PIC ZZZZZ.
          05 FILLER                PIC X(03) VALUE SPACES.
          05 PRT4-JUL              PIC ZZZZZ.
          05 FILLER                PIC X(03) VALUE SPACES.
          05 PRT4-AUG              PIC ZZZZZ.
          05 FILLER                PIC X(03) VALUE SPACES.
          05 PRT4-SEP              PIC ZZZZZ.
          05 FILLER                PIC X(03) VALUE SPACES.
          05 PRT4-OCT              PIC ZZZZZ.
          05 FILLER                PIC X(03) VALUE SPACES.
          05 PRT4-NOV              PIC ZZZZZ.
          05 FILLER                PIC X(03) VALUE SPACES.
          05 PRT4-DEC              PIC ZZZZZ.
          05 FILLER                PIC X(03) VALUE SPACES.
          05 PRT4-TOT              PIC ZZZZZZ.

       01 PRT3-SPACE.
          05 FILLER                           PIC X(80) VALUE SPACE.

       01 WS-MAIL-TABLE OCCURS 10000 TIMES.
          05 WS-ACCT                     PIC 9(10).
          05 WS-NAME                     PIC X(36).
          05 WS-ADDRESOR-NAME            PIC X(36).
          05 WS-ADMIN-LOGON              PIC X(10).
          05 WS-RECEIVE-DATE             PIC 9(08).
       
       01 WS-MONTH-TOT-TABLE OCCURS 12 TIMES.
          05 WS-MONTH-TOT                 PIC 9(05).

       01 WS-TBL-IDX                     PIC 9(05) VALUE 00001.
       01 WS-MONTH-RUNNING-TOT           PIC 9(12).
       01 WS-MAIL-TOTAL                  PIC 9(12).
       01 WS-MONTH-TBL-IDX               PIC 9(02).
       01 WS-PRT-TBL-IDX                 PIC 9(02).
       01 WS-PRT-TBL-IDX-2               PIC 9(02).
       01 WS-LINE-CNT                    PIC 9(02).
       01 WS-PAGE-CNT                    PIC 9(05).

       LINKAGE SECTION.

       01 CURRENT-XY-PARAMETERS PIC 9(08).

       PROCEDURE DIVISION USING CURRENT-XY-PARAMETERS.
          
       TPSS02CB-BEGIN.


           MOVE CURRENT-XY-PARAMETERS(1:4) TO WS-CURRENT-X
                                              WS-X-PARM.
           MOVE CURRENT-XY-PARAMETERS(5:4) TO WS-CURRENT-Y
                                              WS-Y-PARM.

           IF PROCESS-RPTS-DISPLAY-FLAG = 0
               SET PROCESS-RPTS TO NEW TPS000.PROCESS_RPTSForm
               MOVE 1 TO PROCESS-RPTS:: ANN-RECEIVED-FLAG
               SET PROCESS-RPTS::X-POINT TO WS-X-PARM
               SET PROCESS-RPTS::Y-POINT TO WS-Y-PARM
               INVOKE PROCESS-RPTS::Show
               MOVE 0 TO PROCESS-RPTS:: ANN-RECEIVED-FLAG
               MOVE 1 TO PROCESS-RPTS-DISPLAY-FLAG
           END-IF.


           CALL "PC_READ_DRIVE" USING WHAT-DRIVE-ASSIGNMENT.
           MOVE WHAT-DRIVE-ASSIGNMENT TO REPORT-ASSIGNMENT2(1:1)
                                         REPORT-ASSIGNMENT1(1:1)
                                         RPT-ASSIGN2-DRIVE
                                         RPT-LINE3-DRIVE
                                         RPT-LINE3-DRIVE2.
                                         



           ACCEPT TODAYS-DATE-YMD FROM DATE.
           MOVE TODAYS-DATE-YMD TO WS-TODAYS-DATE-CYMD(3:6).

          IF TODAYS-DATE-YY > 94
              MOVE 19                TO TODAYS-DATE-CC
          ELSE
             MOVE 20                TO TODAYS-DATE-CC
          END-IF.

           MOVE TODAYS-DATE-CYMD TO WS-TODAYS-DATE-CYMD.

           MOVE TODAYS-DATE-CYMD(1:2) TO WS-CC.
           MOVE TODAYS-DATE-CYMD(3:2) TO WS-YY.


           MOVE WS-TODAYS-DATE-CYMD  TO WS-MONDAYS-DATE-CYMD
                                        WS-TMP-CYMD.
           MOVE '01'                 TO WS-TMP-CYMD(5:2)
                                        WS-TMP-CYMD(7:2).


       SEARCH-FOR-MONDAY.
090300      MOVE 23                   TO WS-DATE-PARAM.
090500      MOVE WS-MONDAYS-DATE-CYMD TO WS-DATE-REFORM(1:8).
090600      CALL TPSDATES USING WS-DATE-REQUEST.
090700      MOVE WS-DATE-REFORM-LEN08 TO WS-MONDAYS-DATE-CYMD.
090700***** IF NOT MONDAY GOT LAST MONDAY ********
090700      IF WS-DATE-REFORM-LEN08(9:1) NOT = 1
090300         MOVE 22                   TO WS-DATE-PARAM
090500         MOVE WS-MONDAYS-DATE-CYMD TO WS-DATE-REFORM(1:8)
090400         MOVE '001'                TO WS-DATE-REFORM-LEN08(9:3)
090600         CALL TPSDATES USING WS-DATE-REQUEST
090700         MOVE WS-DATE-REFORM-LEN08 TO WS-MONDAYS-DATE-CYMD
090300         GO TO SEARCH-FOR-MONDAY
             END-IF.
090210
090300      MOVE 22                   TO WS-DATE-PARAM.
090400      MOVE '001'                TO WS-DATE-REFORM-LEN08(9:3).
090500      MOVE WS-MONDAYS-DATE-CYMD TO WS-DATE-REFORM(1:8).
090600      CALL TPSDATES USING WS-DATE-REQUEST.
090700      MOVE WS-DATE-REFORM-LEN08 TO THIS-WK-HI-DATE.
090710
090720      MOVE 22                   TO WS-DATE-PARAM.
090730      MOVE '007'                TO WS-DATE-REFORM-LEN08(9:3).
090740      MOVE WS-MONDAYS-DATE-CYMD  TO WS-DATE-REFORM(1:8).
090750      CALL TPSDATES USING WS-DATE-REQUEST.
090760      MOVE WS-DATE-REFORM-LEN08 TO THIS-WK-LO-DATE.
101100
101200      MOVE THIS-WK-LO-DATE      TO THIS-YR-LO-DATE.
101201      MOVE '0101'               TO THIS-YR-LO-DATE(5:4).
101202      MOVE THIS-WK-HI-DATE      TO THIS-YR-HI-DATE.
101300
101500*--------------------------------------------------------------

101700 START-THE-PROCESS.

101707*---------------------------------------------------------------
101708      MOVE 07                   TO WS-DATE-PARAM.
101709      MOVE SPACES               TO WS-DATE-EXTEND.
101710      MOVE WS-TODAYS-DATE-CYMD(3:6)   TO WS-DATE-REFORM.
101711      CALL TPSDATES USING WS-DATE-REQUEST.
101712      MOVE WS-DATE-TENBYTES     TO PRT2-HDR1-DATE
                                         FOR-WEEK-TO.
101713*---------------------------------------------------------------
101714      MOVE 07                   TO WS-DATE-PARAM.
101715      MOVE SPACES               TO WS-DATE-EXTEND.
101716      MOVE WS-TMP-CYMD(3:6) TO WS-DATE-REFORM.
101717      CALL TPSDATES USING WS-DATE-REQUEST.
101718      MOVE WS-DATE-TENBYTES(1:6) TO FOR-WEEK-FROM.
101719*---------------------------------------------------------------
101720*     MOVE 07                   TO WS-DATE-PARAM.
101721*     MOVE SPACES               TO WS-DATE-EXTEND.
101722*     MOVE THIS-WK-HI-DATE(3:6) TO WS-DATE-REFORM.
101723*     CALL TPSDATES USING WS-DATE-REQUEST.
101724*     MOVE WS-DATE-TENBYTES(1:12) TO FOR-WEEK-TO.
101730*---------------------------------------------------------------

101800    PERFORM OPEN-THE-FILES
101900       THRU OPEN-THE-FILES-EXIT.



       START-PROFILE.

110900    MOVE F-PRIME TO FILE-KEY.
111000    MOVE F-START TO FILE-ACTION.
111100    MOVE LOW-VALUES TO TPS-PROFL-REC.
111200    MOVE ZEROES TO CLNT-PROFILE-KEY.
111300    CALL TPSIO004 USING FILE-REQUEST TPS-PROFL-REC.
111400    IF NO-RECORD-WAS-FOUND
111500       GO TO START-PROFILE-EXIT
111600     END-IF.
111700    IF NOT A-SUCCESSFUL-OPERATION
111800       MOVE ' PROFILE' TO FILE-NAME
111900       MOVE 'TPS021-STRT ' TO FILE-TEXT
112100       GO TO START-PROFILE-EXIT
112200     END-IF.

       START-PROFILE-EXIT.


       READ-NEXT-PROFILE.

112600    MOVE F-PRIME TO FILE-KEY.
112700    MOVE F-READ-NEXT TO FILE-ACTION.
112800    CALL TPSIO004 USING FILE-REQUEST TPS-PROFL-REC.
112900    IF END-OF-FILE-WAS-REACHED
113000       GO TO TPS021C-COMMON-EXIT
113100     END-IF.
113200    IF NOT A-SUCCESSFUL-OPERATION
113300       MOVE ' PROFILE' TO FILE-NAME
113400       MOVE 'TPS021-RNXT' TO FILE-TEXT
113500*      PERFORM FILE-ERROR THRU
      *              FILE-ERROR-EXIT
113600       GO TO TPS021C-COMMON-EXIT
113700     END-IF.
113800
113900    IF CLNT-PROFILE-SUB-ACCT NOT = '00'
114000       GO TO READ-NEXT-PROFILE
114100     END-IF.
114200
114300    IF CLNT-PROFILE-ADD-DATE(1:1) = 8 OR 9 
114300       GO TO READ-NEXT-PROFILE
114500     END-IF.

           MOVE CLNT-PROFILE-ACCT-NO  TO WS-CURRENT-ACCT.


       READ-NEXT-PROFILE-EXIT.

       START-RECEIVE-FILE.

115600    MOVE LOW-VALUES TO MAIL-KEY OF TPS-MAIL-REC.

115900    MOVE WS-CURRENT-ACCT TO MAIL-ACCT-NO.
116000    MOVE ZEROS        TO MAIL-SUB-ACCT
116100                         MAIL-RECEIVE-NUMBER.
116200
116300    MOVE WS-START-YEAR TO MAIL-RECEIVE-DATE.
          MOVE F-PRIME TO FILE-KEY.
116400    MOVE F-START TO FILE-ACTION.
116500    CALL TPSIOREC USING FILE-REQUEST TPS-MAIL-REC.
116600    IF NO-RECORD-WAS-FOUND
116700       GO TO READ-NEXT-PROFILE
116800     END-IF.
116900    IF NOT A-SUCCESSFUL-OPERATION
117000       MOVE ' RECEIVE' TO FILE-NAME
117100       MOVE 'TPS021C-SBR' TO FILE-TEXT
117200*      PERFORM FILE-ERROR THRU
      *        FILE-ERROR-EXIT
117300       GO TO TPS021C-COMMON-EXIT.

       START-RECEIVE-FILE-EXIT.

       READ-NEXT-RECEIVE-REC.

117600    MOVE F-PRIME TO FILE-KEY.
117700    MOVE F-READ-NEXT TO FILE-ACTION.
117800    CALL TPSIOREC USING FILE-REQUEST TPS-MAIL-REC.
117900    IF END-OF-FILE-WAS-REACHED
118000       GO TO READ-NEXT-PROFILE
118100     END-IF.

118200    IF NOT A-SUCCESSFUL-OPERATION
118300       MOVE ' RECEIVE' TO FILE-NAME
118400       MOVE 'TPS021-BRN' TO FILE-TEXT
118500*      PERFORM FILE-ERROR THRU
      *              FILE-ERROR-EXIT
118600       GO TO TPS021C-COMMON-EXIT.


          IF MAIL-ACCT-NO NOT = WS-CURRENT-ACCT
             GO TO PRINT-REPORT
          END-IF.

           IF MAIL-RECEIVE-DATE < WS-START-YEAR
             GO TO READ-NEXT-RECEIVE-REC
          END-IF.

          IF MAIL-ADMIN-XXXXXX(1:8) = 'TPS1010A' OR 'START' OR
                                      'CHKADM' OR 'CKADM' OR
                                      'TPS051' OR 'TPS093' OR
                                      'NY6JAMON'
             GO TO READ-NEXT-RECEIVE-REC
          END-IF.


       READ-NEXT-RECEIVE-REC-EXIT.

       CALCULATE-MAIL.

      *12/05/18  
          MOVE MAIL-RECEIVE-DATE(5:2) TO WS-MONTH-TBL-IDX.
      **********
          COMPUTE WS-MONTH-TOT (WS-MONTH-TBL-IDX)
            = WS-MONTH-TOT(WS-MONTH-TBL-IDX) + 1.
          COMPUTE WS-MAIL-TOTAL = WS-MAIL-TOTAL + 1.
                  

          MOVE MAIL-ACCT-NO TO WS-ACCT(WS-TBL-IDX).
          MOVE MAIL-ADDRESEE-NAME TO WS-NAME(WS-TBL-IDX).
          MOVE MAIL-ADDRESOR-NAME TO WS-ADDRESOR-NAME(WS-TBL-IDX).
          MOVE MAIL-ADMIN-XXXXXX  TO WS-ADMIN-LOGON(WS-TBL-IDX).
          MOVE MAIL-RECEIVE-DATE  TO WS-RECEIVE-DATE(WS-TBL-IDX).

          COMPUTE WS-TBL-IDX = WS-TBL-IDX + 1.

          GO TO READ-NEXT-RECEIVE-REC.

       CALCULATE-MAIL-EXIT.

       PRINT-REPORT.

          MOVE '01' TO WS-PRT-TBL-IDX.

          MOVE WS-ACCT(WS-PRT-TBL-IDX) TO PRT4-ACCT-NO.
          MOVE WS-NAME(WS-PRT-TBL-IDX) TO PRT4-ACCT-NAME.

          MOVE WS-MONTH-TOT(WS-PRT-TBL-IDX) TO PRT4-JAN.
          COMPUTE WS-PRT-TBL-IDX = WS-PRT-TBL-IDX + 1.
          MOVE WS-MONTH-TOT(WS-PRT-TBL-IDX) TO PRT4-FEB.
          COMPUTE WS-PRT-TBL-IDX = WS-PRT-TBL-IDX + 1.
          MOVE WS-MONTH-TOT(WS-PRT-TBL-IDX) TO PRT4-MAR.
          COMPUTE WS-PRT-TBL-IDX = WS-PRT-TBL-IDX + 1.
          MOVE WS-MONTH-TOT(WS-PRT-TBL-IDX) TO PRT4-APR.
          COMPUTE WS-PRT-TBL-IDX = WS-PRT-TBL-IDX + 1.
          MOVE WS-MONTH-TOT(WS-PRT-TBL-IDX) TO PRT4-MAY.
          COMPUTE WS-PRT-TBL-IDX = WS-PRT-TBL-IDX + 1.
          MOVE WS-MONTH-TOT(WS-PRT-TBL-IDX) TO PRT4-JUN.
          COMPUTE WS-PRT-TBL-IDX = WS-PRT-TBL-IDX + 1.
          MOVE WS-MONTH-TOT(WS-PRT-TBL-IDX) TO PRT4-JUL.
          COMPUTE WS-PRT-TBL-IDX = WS-PRT-TBL-IDX + 1.
          MOVE WS-MONTH-TOT(WS-PRT-TBL-IDX) TO PRT4-AUG.
          COMPUTE WS-PRT-TBL-IDX = WS-PRT-TBL-IDX + 1.
          MOVE WS-MONTH-TOT(WS-PRT-TBL-IDX) TO PRT4-SEP.
          COMPUTE WS-PRT-TBL-IDX = WS-PRT-TBL-IDX + 1.
          MOVE WS-MONTH-TOT(WS-PRT-TBL-IDX) TO PRT4-OCT.
          COMPUTE WS-PRT-TBL-IDX = WS-PRT-TBL-IDX + 1.
          MOVE WS-MONTH-TOT(WS-PRT-TBL-IDX) TO PRT4-NOV.
          COMPUTE WS-PRT-TBL-IDX = WS-PRT-TBL-IDX + 1.
          MOVE WS-MONTH-TOT(WS-PRT-TBL-IDX) TO PRT4-DEC.
          MOVE WS-MAIL-TOTAL TO PRT4-TOT.



          COMPUTE WS-LINE-CNT = WS-LINE-CNT + 1
          IF WS-LINE-CNT = '27'
             MOVE '01' TO WS-LINE-CNT
             WRITE PRT-RECORD FROM PRT3-SPACE
             WRITE PRT-RECORD FROM PRT3-SPACE
             WRITE PRT-RECORD FROM PRT3-SPACE
          END-IF.

          IF WS-LINE-CNT = '01'
             COMPUTE WS-PAGE-CNT = WS-PAGE-CNT + 1
             MOVE WS-PAGE-CNT TO PRT2-HDR1-PAGE-NUM 
             WRITE PRT-RECORD FROM PRT2-HDR1
             WRITE PRT-RECORD FROM PRT2-HDR2
             WRITE PRT-RECORD FROM PRT3-SPACE
             WRITE PRT-RECORD FROM PRT3-HDR3
             WRITE PRT-RECORD FROM PRT3-SPACE
          END-IF.



          
          WRITE PRT-RECORD FROM PRT3-SPACE.
          WRITE PRT-RECORD FROM PRT4-HDR4.

          PERFORM VARYING WS-PRT-TBL-IDX FROM 1 BY 1
                  UNTIL WS-PRT-TBL-IDX > 12
                  MOVE ZEROES TO WS-MONTH-TOT(WS-PRT-TBL-IDX)
          END-PERFORM.
          MOVE ZEROES TO WS-MAIL-TOTAL.
          
          PERFORM VARYING WS-TBL-IDX FROM 1 BY 1
                  UNTIL WS-TBL-IDX > 10000
                  MOVE ZEROES TO WS-ACCT(WS-TBL-IDX)
                  MOVE SPACES TO WS-NAME(WS-TBL-IDX)
                  MOVE SPACES TO WS-ADDRESOR-NAME(WS-TBL-IDX)
                  MOVE SPACES TO WS-ADMIN-LOGON(WS-TBL-IDX)
                  MOVE ZEROES TO WS-RECEIVE-DATE(WS-TBL-IDX)
                  
          END-PERFORM.
          MOVE '00001' TO WS-TBL-IDX.

          GO TO READ-NEXT-PROFILE.

       PRINT-REPORT-EXIT.

143400 OPEN-THE-FILES.
143500
           OPEN OUTPUT  PRT-FILE1.

           OPEN OUTPUT  PRT-FILE2.
           WRITE PRT-RECORD2 FROM REPORT-ASSIGNMENT2-LINE1.
           WRITE PRT-RECORD2 FROM REPORT-ASSIGNMENT2-LINE2.
           WRITE PRT-RECORD2 FROM REPORT-ASSIGNMENT2-LINE3.
           WRITE PRT-RECORD2 FROM REPORT-ASSIGNMENT2-LINE4.
           CLOSE PRT-FILE2.

143800    WRITE PRT-RECORD FROM PCL5-LANDSCAPE
143900                    AFTER ADVANCING 0 LINES.                                         
144000    WRITE PRT-RECORD FROM PCL5-DUPLEX-ON
144100                    AFTER ADVANCING 0 LINES.                                         
144200    WRITE PRT-RECORD FROM PCL5-PRM-SPACE-FIXED
144300                    AFTER ADVANCING 0 LINES.                                       
144400    WRITE PRT-RECORD FROM PCL5-LINE-SPACE-08LPI
144500                    AFTER ADVANCING 0 LINES.                                       
144600    MOVE 0014          TO PCL5-CPI-VALUE.
144700    WRITE PRT-RECORD FROM PCL5-PRIMARY-PITCH-CPI
144800                    AFTER ADVANCING 0 LINES.                                       
144910    MOVE 08            TO PCL5-POINTS-VALUE.                                        
145000    WRITE PRT-RECORD FROM PCL5-PRIMARY-HEIGHT
145100                    AFTER ADVANCING 0 LINES.                                       
145200    WRITE PRT-RECORD FROM PCL5-STYLE-UPRIGHT
145300                    AFTER ADVANCING 0 LINES.                                       
145400**** WRITE PRT-RECORD FROM PCL5-WT-MEDIUM                                            
145500    WRITE PRT-RECORD FROM PCL5-WT-BOLD
145600                    AFTER ADVANCING 0 LINES. 

                                     

145800
146200    MOVE F-PRIME    TO FILE-KEY.
146300    MOVE F-OPEN-INPUT TO FILE-ACTION.
146400    CALL TPSIOREC USING FILE-REQUEST TPS-MAIL-REC.
146500    IF FILE-STATUS NOT = '00' AND '05'
146600       MOVE 'RECEIVE ' TO FILE-NAME
146700       MOVE 'TPS021C-ORC' TO FILE-TEXT
146800*      PERFORM FILE-ERROR THRU
      *              FILE-ERROR-EXIT
146900       GO TO TPS021C-COMMON-EXIT.
147000    MOVE F-PRIME    TO FILE-KEY.
147100    MOVE F-OPEN-I-O TO FILE-ACTION.
147200    CALL TPSIO001 USING FILE-REQUEST TPS-LOGON-REC.
147300    IF FILE-STATUS NOT = '00' AND '05'
147400       MOVE 'LOGON   ' TO FILE-NAME
147500       MOVE 'TPS021C-ORC' TO FILE-TEXT
147600*      PERFORM FILE-ERROR THRU
      *             FILE-ERROR-EXIT
147700       GO TO TPS021C-COMMON-EXIT.
147800
147900    MOVE F-PRIME    TO FILE-KEY.
148000    MOVE F-OPEN-I-O TO FILE-ACTION.
148100    CALL TPSIO004 USING FILE-REQUEST TPS-PROFL-REC.
148200    IF FILE-STATUS NOT = '00' AND '05'
148300       MOVE 'PROFILE   ' TO FILE-NAME
148400       MOVE 'TPS021C-ORC' TO FILE-TEXT
148500*      PERFORM FILE-ERROR THRU
      *              FILE-ERROR-EXIT
148600       GO TO TPS021C-COMMON-EXIT.
148700
148800 OPEN-THE-FILES-EXIT. EXIT.


110200 TPS021C-COMMON-EXIT.
110300    PERFORM CLOSE-THE-FILES
110400       THRU CLOSE-THE-FILES-EXIT.


          MOVE REPORT-ASSIGNMENT2 TO DOS-COMMAND
          DISPLAY DOS-COMMAND UPON COMMAND-LINE.
          CALL X'91' USING RESULT FUNCTION-35 NULL-PARAMETER.

           IF PROCESS-RPTS-DISPLAY-FLAG = 1
               invoke PROCESS-RPTS::Hide
               MOVE 0 TO PROCESS-RPTS-DISPLAY-FLAG
           END-IF.

           INITIALIZE CURRENT-XY-PARAMETERS.
           MOVE WS-CURRENT-X TO CURRENT-XY-PARAMETERS(1:4).
           MOVE WS-CURRENT-Y TO CURRENT-XY-PARAMETERS(5:4).

10500    EXIT PROGRAM GIVING CURRENT-XY-PARAMETERS.
110501    GOBACK GIVING CURRENT-XY-PARAMETERS.

149100 CLOSE-THE-FILES.
149200      CLOSE PRT-FILE1.
149400      MOVE F-PRIME TO FILE-KEY.
149500      MOVE F-CLOSE TO FILE-ACTION.
149600
149700      CALL TPSIOREC USING FILE-REQUEST TPS-MAIL-REC.
149800      IF NOT A-SUCCESSFUL-OPERATION
149900         MOVE 'RECEIVE ' TO FILE-NAME
150000         MOVE 'TPS021-CCK' TO FILE-TEXT
150100*        PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
150200       END-IF.
151600*      END-IF.
151700
151800 CLOSE-THE-FILES-EXIT. EXIT.

142800 FILE-ERROR.
142900     CALL TPSIOERR USING FILE-REQUEST
                               WS-CURRENT-XY-PARM.
143000     CANCEL TPSIOERR.


           MOVE CURRENT-XY-PARAMETERS(1:4) TO WS-CURRENT-X
                                              WS-X-PARM.
           MOVE CURRENT-XY-PARAMETERS(5:4) TO WS-CURRENT-Y
                                              WS-Y-PARM.

143100 FILE-ERROR-EXIT. EXIT.
