000100 IDENTIFICATION DIVISION.
000200 PROGRAM-ID. SEEMAIL.
000300 AUTHOR. JOHN CURRAN.
000400***************************************************************
000500*   PRINT CUSTOMIZED MAIL REPORTS                             *
000600***************************************************************
000700 ENVIRONMENT DIVISION.
000800 CONFIGURATION SECTION.
000900 SOURCE-COMPUTER. IBM-PS2.
001000 OBJECT-COMPUTER. IBM-PS2.
001100 FILE-CONTROL.
001200**** SELECT PRT-FILE  ASSIGN TO EXTERNAL LISTFILE                 00001000
001300     SELECT PRT-FILE  ASSIGN TO "C:\TPS\APP\SEEMAIL.TXT"          00001000
001400**** SELECT PRT-FILE  ASSIGN TO "LPT1"                            00001000
001500         ORGANIZATION IS LINE SEQUENTIAL                          00001100
001600         FILE STATUS IS TPS-FILE-STATUS.
001600                                                                                                                  
001300     SELECT xcl-FILE  ASSIGN TO "C:\TPS\APP\impexcel.TXT"                                                         
001500         ORGANIZATION IS LINE SEQUENTIAL                          00001100
001600         FILE STATUS IS TPS-FILE-STATUS.
001600                                                                                                                  
001700 DATA DIVISION.
001800 FILE SECTION.
001900 FD  PRT-FILE                                                     00001600
002000     LABEL RECORDS ARE OMITTED                                    00001700
002100     RECORD CONTAINS 200 CHARACTERS.                              00001800
002200 01  PRT-RECORD.
002210     10 PRT-ACCT-NO        PIC X(10).
002220     10 FILLER             PIC X(02).
           10 PRT-ACCT-NAME-2     PIC X(15).
002220     10 FILLER             PIC X(02).
002300     10 PRT-RECV-DATE      PIC X(08).
002220     10 FILLER             PIC X(02).
           10 PRT-RECUR-NAME     PIC X(30).
           10 FILLER             PIC X(02).
           10 PRT-RECUR-ACCT     PIC X(10).
002210     10 PRT-RECV-NO        PIC X(05).
002220     10 FILLER             PIC X(03).
002300*    10 PRT-OPEN-SHARES    PIC X(10).
002220*    10 FILLER             PIC X(01).
002300*    10 PRT-CLOSE-SHARES   PIC X(10).
002220*    10 FILLER             PIC X(01).
002300*    10 PRT-CAL-XREF       PIC X(10).
002220*    10 FILLER             PIC X(01).
002300*    10 PRT-PAC-NUM        PIC X(06).
002220*    10 FILLER             PIC X(01).
002300*    10 PRT-SORT-NUM       PIC X(06).
002220*    10 FILLER             PIC X(02).
002300*    10 PRT-OFAC-FLAG      PIC X(01).
002220*    10 FILLER             PIC X(01).
002300*    10 PRT-OFAC-CHG       PIC X(01).
002220*    10 FILLER             PIC X(01).
002220     10 PRT-AMOUNT         PIC ZZZZ,ZZZ.ZZ.
002220*    10 FILLER             PIC X(02).
012000*    10 PRT-PAYEE-ACCT     pic x(20).
002220*    10 filler             pic x(70).
012000*    10 prt-chart-01       pic x(06).                                                                               
002220*    10 filler             pic x(01).
012000*    10 prt-chart-02       pic x(06).                                                                               
002220*    10 filler             pic x(01).
012000*    10 prt-chart-03       pic x(06).                                                                               
002220*    10 FILLER             PIC X(02).
002210*    10 PRT-sub-ACCT-NO    PIC X(02).
002220*    10 FILLER             PIC X(01).
002300*    10 PRT-IMAGE-NUMBER   PIC ZZZZZZZ9.
002220*    10 FILLER             PIC X(02).
002300*    10 PRT-split-flag     PIC X(01).
002220*    10 FILLER             PIC X(02).
002300*    10 PRT-ADDSEE-NAME    PIC X(20).
002220*    10 FILLER             PIC X(01).
002300*    10 PRT-CHECK-NUMBER   PIC X(10).
002220*    10 FILLER             PIC X(02).
002300*    10 PRT-CHECK-AMOUNT   PIC ZZ,ZZZ,ZZZ.99.
002220*    10 FILLER             PIC X(20).
012000*    10 prt-chart-01       pic x(10).
002220*    10 filler             pic x(01).
012000*    10 prt-chart-02       pic x(10).
002220*    10 filler             pic x(01).
012000*    10 prt-chart-03       pic x(10).
002220*    10 FILLER             PIC X(02).
001800                                                                                                                  
001900 FD  xcl-FILE                                                                                                     
002000     LABEL RECORDS ARE OMITTED                                                                                    
002100     RECORD CONTAINS 289 CHARACTERS.                                                                              
002200 01  xcl-RECORD.
016406     10 xcl-payee-name     pic x(36).                                                                             
002220     10 xcl-coma-0         PIC X(01).
016406     10 xcl-paid-amt       pic 9(07)v9(02).                                                                       
002220     10 xcl-coma-1         PIC X(01).
002210*    10 xcl-level-1        PIC X(60).
002220*    10 xcl-coma-2         PIC X(01).
002300     10 xcl-level-2        PIC X(60).
002220     10 xcl-coma-3         PIC X(01).
002300     10 xcl-level-3        PIC X(60).
002220     10 xcl-coma-4         PIC X(01).
002300     10 xcl-level-4        PIC X(60).
002220*    10 xcl-coma-5         PIC X(01).
002300*    10 xcl-level-5        PIC X(60).
005900
006000
009300
009400
009500 WORKING-STORAGE SECTION.

       01  FIRST-RECV-FILE  PIC X VALUE '1'.
       01  WS-TMP-RECEIVE-DATE   PIC 9(08) VALUE ZEROES.
       01  WS-TMP-RECEIVE-DATE-2 PIC 9(08).

002200 01  strt-RECORD.
002300     10 strt-split-flag     PIC X(01).                                                                              
002300                                                                                                                    
002220                                                                                                                    
027200     COPY "PCLVALUE.CPY".
009600     COPY "TPSFILES.CPY".
009700     COPY "KEYVALUE.CPY".
       01  TPS-RECUR-REC.
           COPY "TPSRECUR.CPY".
010000 01  TPS-MAIL-REC.
010100     COPY "TPSMAIL.CPY".
010000 01  TPS-MEMO-REC.
010100     COPY "TPSMEMO.CPY".
010120 01  TPS-INVOICE-REC.
010130     COPY "TPSINVC.CPY".
010110 01  TPS-PROFL-REC.
010111     COPY "TPSPROFL.CPY".
010120 01  TPS-LOGON-REC.
010130     COPY "TPSLOGON.CPY".
010120 01  tps-check-rec.
010130     copy "tpscheck.cpy".
       01  TPSIORCR                      PIC X(08) VALUE 'TPSIORCR'.
010200 01  tpsiochk                      pic x(08) value 'tpsiochk'.
010200 01  TPSIOREC                      PIC X(08) VALUE 'TPSIOREC'.
010200 01  TPSIOMEM                      PIC X(08) VALUE 'TPSIOMEM'.
010200 01  TPSIO022                      PIC X(08) VALUE 'TPSIO022'.
010200 01  TPSIO004                      PIC X(08) VALUE 'TPSIO004'.

010200 01  TPSIORCV                      PIC X(08) VALUE 'TPSIORCV'.
010200 01  TPSIORC2                      PIC X(08) VALUE 'TPSIORC2'.
010200 01  TPSIORC3                      PIC X(08) VALUE 'TPSIORC3'.

010300 01  PROGRAM-NAMES.
010400  10 TPSIOERR    PIC X(08) VALUE 'TPSIOERR'.
010500  10 TPSCHART    PIC X(08) VALUE 'TPSCHART'.
010600  10 FLOATBIG    PIC X(08) VALUE 'FLOATBIG'.
010610  10 TPSDATES    PIC X(08) VALUE 'TPSDATES'.
010620  10 TPS124      PIC X(08) VALUE 'TPS124  '.
010620  10 tps1010g    PIC X(08) VALUE 'tps1010g'.
010700  10 FILLER      PIC X(08) VALUE HIGH-VALUES.
010800 01  REC-COUNT   PIC 9(05) VALUE ZEROS.
010810 01  ALL-MAIL    PIC 9(09) VALUE ZEROS.
010900 01  TPS-FILE-STATUS                       PIC XX.
011000     88  TPS-CARRIER-FILE-OK VALUE '00', '02'.
011100
044100                                                                                     00062900
044200 01  WS-TODAYS-DATE-YMD         PIC  9(06).                                          00063000
044300 01  FILLER REDEFINES WS-TODAYS-DATE-YMD.                                            00063100
044400     10  WS-TODAYS-DATE-YMD-YY  PIC  9(02).                                          00063200
044500     10  WS-TODAYS-DATE-YMD-MM  PIC  9(02).                                          00063300
044600     10  WS-TODAYS-DATE-YMD-DD  PIC  9(02).                                          00063400
011100
002200 01 WS-PAGE          PIC 9(02) VALUE ZERO.
002200 01 LINE-COUNT       PIC 9(02) VALUE ZERO.
026964
       01 RECUR-HEADER.
          05 H-RECUR-ACCT       PIC  X(10).
          05 FILLER             PIC  X(02).
          05 H-ACCT-NAME        PIC  X(15).
          05 FILLER             PIC  X(02).
          05 H-RECUR-PAYEE      PIC  X(10).
          05 FILLER             PIC  X(02).
          05 H-RECUR-PAYEE-ACCT PIC  X(22).
          05 FILLER             PIC  X(02).
          05 H-RECEIVE-DATE     PIC  X(10).
002200 01 HEADER-1.
002220     10 FILLER             PIC X(60) VALUE SPACES.
002220     10 FILLER             PIC X(48) VALUE
002220        'Total Pesonal Services Administrative Group, LLC'.
002220     10 FILLER             PIC X(32) VALUE SPACES.
002220     10 PRT-DATE           PIC X(30).
026964
002200 01 HEADER-2.
002220     10 FILLER             PIC X(08) VALUE 'Seemail '.
002220     10 FILLER             PIC X(47) VALUE SPACES.
002220     10 FILLER             PIC X(51) VALUE
002300        '"Taking Care Of Your Persoanl Business...Privately"'.
002220     10 FILLER             PIC X(30) VALUE SPACES.
002220     10 FILLER             PIC X(05) VALUE 'Page '.
002220     10 PRT-PAGE           PIC ZZ.
002220     10 FILLER             PIC X(04) VALUE ' of '.
002220     10 PRT-TOT-PAGE       PIC ZZ.
026964
002200 01 HEADER-3.
002220     10 FILLER             PIC X(45) VALUE SPACES.
002220     10 FILLER             PIC X(43) VALUE
002300        'Mail Received and Imaged for the Account of'.
002220     10 FILLER             PIC X(01) VALUE SPACES.
002220     10 PRT-CLIENT-NAME    PIC x(36).
026964
002200 01 HEADER-4.
002220     10 FILLER             PIC X(40) VALUE SPACES.
002220     10 FILLER             PIC X(17) VALUE 'Print Report for '.
002300     10 PRT-ACCT-NAME      PIC X(25).
002220     10 FILLER             PIC X(01) VALUE SPACES.
002220     10 FILLER             PIC X(11) VALUE 'Start Date '.
002300     10 PRT-START-DATE     PIC X(10).
002220     10 FILLER             PIC X(11) VALUE '  End Date '.
002220     10 PRT-END-DATE       PIC x(10).
026964
002200 01  HDR-RECORD.
002220*    10 FILLER             PIC X(10) VALUE ' ACCT #   '.
002220     10 FILLER             PIC X(10) VALUE ' IMAGE #  '.
002300     10 FILLER             PIC X(01) VALUE SPACES.
002220     10 FILLER             PIC X(14) VALUE ' RECV DATE & #'.
002300     10 FILLER             PIC X(09) VALUE SPACES.
002300     10 FILLER             PIC X(04) VALUE 'NAME'.
002220     10 FILLER             PIC X(25) VALUE SPACES.
002300     10 FILLER             PIC X(10) VALUE 'CATEGORY'.
002300     10 FILLER             PIC X(17) VALUE SPACES.
002300     10 FILLER             PIC X(06) VALUE 'AMOUNT'.
002220     10 FILLER             PIC X(04) VALUE SPACES.
002300     10 FILLER             PIC X(10) VALUE 'PAYEE ACCT'.
011101
011102 01 PRT-TOTAL-LINE.                                                                  00067400
011103    05 FILLER                  PIC X(05) VALUE 'TOTAL'.                              00067500
011103    05 PRT-TOTAL               PIC  ZZZZZ.                                           00067500
011100
011101                                                                                                                  
011102  01  WS-DATE-REQUEST.                                                               00067400
011103      05  WS-DATE-PARAM          PIC  9(02).                                         00067500
011104      05  WS-DATE-TENBYTES       PIC  X(20) VALUE SPACES.                            00067600
011105      05  FILLER REDEFINES WS-DATE-TENBYTES.                                         00067700
011106          10  WS-DATE-REFORM         PIC  X(06).                                     00067800
011107          10  WS-DATE-EXTEND         PIC  X(04).                                     00067900
011108          10  FILLER                 PIC  X(10).                                     00068000
011109      05  FILLER REDEFINES WS-DATE-TENBYTES.                                         00068100
011110          10  WS-DATE-REFORM-LEN06   PIC  X(06).                                     00068200
011111          10  FILLER                 PIC  X(14).                                     00068300
011112      05  FILLER REDEFINES WS-DATE-TENBYTES.                                         00068400
011113          10  WS-DATE-REFORM-LEN08   PIC  X(08).                                     00068500
011114          10  FILLER                 PIC  X(12).                                     00068600
011115      05  FILLER REDEFINES WS-DATE-TENBYTES.                                         00068700
011116          10  WS-DATE-REFORM-LEN10   PIC  X(10).                                     00068800
011117          10  FILLER                 PIC  X(10).                                     00068900
011118      05  FILLER REDEFINES WS-DATE-TENBYTES.                                         00069000
011119          10  WS-TIME-PARM1          PIC  X(06).                                     00069100
011120          10  WS-TIME-PARM2          PIC  X(06).                                     00069200
011121          10  WS-TIME-EXTEND         PIC  X(08).                                     00069300
011122      05  FILLER REDEFINES WS-DATE-TENBYTES.                                         00069400
011123          10  WS-TIME-PARM1BY8       PIC  X(08).                                     00069500
011124          10  WS-TIME-PARM2BY8       PIC  X(08).                                     00069600
011125          10  WS-TIME-EXTNDBY8       PIC  X(04).                                     00069700
011126                                                                                     00069800
011200 01 WS-SAVE-ACCT-NO         PIC  9(10) VALUE ZEROS.
011130
011200 01  CURRENT-ACCT-NO        PIC  9(10) VALUE ZEROS.
011300 01  CURRENT-TOTAL          PIC S9(07)V9(02) VALUE ZEROS.
011400
011500 01  WS-PARMS.
011600     05  WS-ACTION-PARM               PIC  9(01) VALUE 3.
011700         88  WS-ACTION-NEW                       VALUE 1.
011800         88  WS-ACTION-EXISTING                  VALUE 2.
011900         88  WS-ACTION-ENGLISH                   VALUE 3.
012000     05  WS-ENGLISH-CHART-01          PIC  X(60).
012100     05  WS-ENGLISH-CHART-02          PIC  X(60).
012200     05  WS-ENGLISH-CHART-03          PIC  X(60).
012300     05  WS-ENGLISH-CHART-04          PIC  X(60).
012400     05  WS-ENGLISH-CHART-05          PIC  X(60).
012500     05  WS-ENGLISH-CHART-06          PIC  X(60).
012600     05  WS-ENGLISH-CHART-07          PIC  X(60).
012700     05  WS-ENGLISH-CHART-08          PIC  X(60).
012800     05  WS-TYPEIN-TEXT OCCURS 018 TIMES.
012900         10  WS-LINE-OF-TYPEIN        PIC  X(60).
014800  01  BG-FLOAT-DATA.
014900      05  BG-FLOAT-PARMS              PIC  X(161).
015000      05  FILLER REDEFINES BG-FLOAT-PARMS.
015100          10  BG-FLOAT-COUNT          PIC  X(01).
015200          10  BG-FLOAT-1              PIC  X(40).
015300          10  BG-FLOAT-2              PIC  X(40).
015400          10  BG-FLOAT-2-R REDEFINES BG-FLOAT-2.
015500              15  BG-FLOAT-2-I        PIC  X(01) OCCURS 40 TIMES.
015600          10  BG-FLOAT-3              PIC  X(40).
015700          10  FILLER REDEFINES BG-FLOAT-3.
015800              15  BG-FLOAT-3-A        PIC  X(37).
015900              15  BG-FLOAT-3-B        PIC  X(03).
016000          10  BG-FLOAT-3-R REDEFINES BG-FLOAT-3.
016100              15  BG-FLOAT-3-I        PIC  X(01) OCCURS 40 TIMES.
016200          10  BG-FLOAT-4              PIC  X(40).
016300
016310 01 CHECKS-ISSUED-VALUE          PIC  9(02).                                     00028100
016320        88 CHECKS-ISSUED-CODE         VALUE 02, 31, 33.                              00028200
016400
016401 01 JUNK-MAIL-COUNT              PIC  9(07) VALUE ZEROS.                         00028100
016402 01 todays-date-ymd              pic  x(06).                                         00010990
016403 01 TPS124-PARM                   PIC  X(01) VALUE ' '.                              00011000
016404                                                                                     00011010
016405 01 CHECKS-PAID-NUM          PIC  9(05) VALUE ZEROS.
016406 01 CHECKS-PAID-AMT          PIC S9(07)V9(02) VALUE ZEROS.
016404                                                                                                                  
016404                                                                                                                  
016404                                                                                                                  
016404                                                                                                                  
002200 01  xrt-record.
002210     10 xrt-acct-no        pic x(10).
002220     10 filler             pic x(01).
002300     10 xrt-recv-date      pic x(08).
002220     10 filler             pic x(01).
002300     10 xrt-recv-no        pic x(05).
002220     10 filler             pic x(02).
002300     10 xrt-check-number   pic 99999.
002220     10 filler             pic x(02).
002300     10 xrt-check-amount   pic $$,$$$,$$9.99.
002220     10 filler             pic x(01).
002300     10 xrt-check-date     pic x(10).                
002220     10 filler             pic x(01).
002300     10 xrt-payee-name     pic x(36).                                                                             
016461                                      
026876
026964
005900 01 check-count-total      pic  9(05) value 0.                                                                    
005900 01 check-amount-total     pic s9(07)v9(02) value 0.
026964
005900 01 mail-count-total       pic  9(07) value 0.                                                                      
016461                                      
  
  
023610 01 bad-date-deletes   pic  9(03) value zeros.                                                                      
000000 01 loseit-stuff.                                                                                                   
          05 filler          pic x(10) value '0101000024'.
          05 filler          pic x(10) value '0101000297'.
          05 filler          pic x(10) value '0101000321'.
          05 filler          pic x(10) value '0101000420'.
          05 filler          pic x(10) value '0101000446'.
          05 filler          pic x(10) value '0101000461'.
          05 filler          pic x(10) value '0101000503'.
          05 filler          pic x(10) value '0101000594'.
          05 filler          pic x(10) value '0101000651'.
          05 filler          pic x(10) value '0101000750'.
          05 filler          pic x(10) value '0101000800'.
          05 filler          pic x(10) value '0101000834'.
          05 filler          pic x(10) value '0101000917'.
          05 filler          pic x(10) value '0101000933'.
          05 filler          pic x(10) value '0101000941'.
          05 filler          pic x(10) value '0101000958'.
          05 filler          pic x(10) value '0101000982'.
          05 filler          pic x(10) value '0101001071'.
          05 filler          pic x(10) value '0101001246'.
          05 filler          pic x(10) value '0101001329'.
          05 filler          pic x(10) value '0101001394'.
          05 filler          pic x(10) value '0101001402'.
          05 filler          pic x(10) value '0101001428'.
          05 filler          pic x(10) value '0101001477'.
          05 filler          pic x(10) value '0101001485'.
          05 filler          pic x(10) value '0101001493'.
          05 filler          pic x(10) value '0101001501'.
          05 filler          pic x(10) value '0101001584'.
          05 filler          pic x(10) value '0101001600'.
          05 filler          pic x(10) value '0101001618'.
          05 filler          pic x(10) value '0101001675'.
          05 filler          pic x(10) value '0101001683'.
          05 filler          pic x(10) value '0101001691'.
          05 filler          pic x(10) value '0103000030'.
          05 filler          pic x(10) value '0105000020'.
          05 filler          pic x(10) value '0106000045'.
          05 filler          pic x(10) value '0106000078'.
          05 filler          pic x(10) value '0106000086'.
          05 filler          pic x(10) value '0120000120'.
          05 filler          pic x(10) value '0120000153'.
          05 filler          pic x(10) value '0120000161'.
          05 filler          pic x(10) value '0150000057'.
          05 filler          pic x(10) value '9999999999'.
000000 01 loseit-ac redefines loseit-stuff.                                                                               
010700    05 loseit-ac occurs 43 times                                                                                    
010700                      indexed by loseit-idx.                                                                        
010700       10 loseit-acct-num   pic  x(10).                                                                             
  
016461                                      
016461                                      
016461 01 what-r-we-doing          pic  9(02) value 00.
016461    88 we-r-exporting-excel             value 01.                                                                   
016461    88 we-b-fixing-maher                value 02.                                                                   
016461    88 we-b-printing-splits             value 03.                                                                   
016461    88 we-r-reporting-check-info        value 04.                                                                   
016561    88 we-b-repairing-bill              value 05.                                                                   
016561    88 we-b-counting-mail               value 06.                                                                   
016561    88 we-b-fixing-invoices             value 07.                                                                   
016561    88 we-b-fixing-payment              value 08.                                                                   
016561    88 we-b-searching-horses            value 09.                                                                   
016561    88 we-b-looking-4-starter           value 10.                                                                   
016561    88 we-b-fixing-vernice              value 11.                                                                   
016561    88 we-b-fixing-total-balance        value 12.                                                                   
016561    88 we-b-looking-4-napoli-bills      value 13.                                                                   
016561    88 we-b-looking-4-tps3054-problem   value 14.                                                                   
016561    88 we-b-making-FAX-records          value 15.                                                                   
016561    88 we-b-checking-po-box             value 16.                                                                   
016561    88 we-b-fixing-payee-name           value 17.                                                                   
016561    88 we-b-adding-an-image             value 18.                                                                   
016561    88 we-b-undoing-import              value 19.                                                                   
          88 we-be-looking-4-refund           value 20.                                                                   
          88 we-be-converting-to-elec-debit   value 21.                                                                   
          88 we-be-unsplitting-record         value 22.                                                                   
          88 we-be-unsplitting-record-2       value 23.                                                                   
          88 we-be-reset-split-records        value 24.                                                                   
000200    88 we-be-recoding-bill-recs         value 25.
000200    88 we-be-fixing-chart-of-acct       value 26.
016461                                      
016461                                      
016470
016500 LINKAGE SECTION.
016600*01 TPS-PARAMETER.
016700*   05 TPS-PARAMETER-VALUE PIC XX.
016800
016900 PROCEDURE DIVISION.
017000
017100 SEEMAIL-BEGIN.
017200    PERFORM OPEN-THE-FILES
017300       THRU OPEN-THE-FILES-EXIT.
084600                                                                                     00108200
084700      ACCEPT WS-TODAYS-DATE-YMD FROM DATE.                                           00111100
084800      MOVE 06                   TO WS-DATE-PARAM.                                    00111200
084900      MOVE WS-TODAYS-DATE-YMD   TO WS-DATE-REFORM.                                   00111300
085000      MOVE SPACES               TO WS-DATE-EXTEND.                                   00111400
085100      CALL TPSDATES USING WS-DATE-REQUEST.                                           00111500
085200      MOVE WS-DATE-TENBYTES TO PRT-DATE.                                             00111600
                            
000200      if we-be-fixing-chart-of-acct                                                                                           
         
               perform repair-chart-of-acct thru                                                                                    
         
                       repair-chart-of-acct-exit                                                                                    
         
017600****     go to seemail-common-exit                                                                                  
000200       end-if.                                                                                                      
                            
000200      if we-be-recoding-bill-recs                                                                                             
         
000200         perform recode-bill-recs thru                                                                                        
         
000200                 recode-bill-recs-exit                                                                                        
         
017600****     go to seemail-common-exit                                                                                  
000200       end-if.                                                                                                      
                            
            if we-be-looking-4-refund
               perform search-for-refund-amount thru                                                                      
                       search-for-refund-amount-exit                                                                      
017600         go to seemail-common-exit                                                                                  
000200       end-if.                                                                                                      
                            
            if we-be-converting-to-elec-debit                                                                             
052000         perform build-receive-for-split thru                                                                       
052000                 build-receive-for-split-exit                                                                       
017600         go to seemail-common-exit                                                                                  
000200       end-if.                                                                                                      
                            
016561    if we-b-undoing-import                                                                                          
             perform lose-bad-import-date thru                                                                            
                     lose-bad-import-date-exit                                                                            
017600       go to seemail-common-exit                                                                                    
000200     end-if.                                                                                                        
                            
                            
016561    if we-b-adding-an-image                                                                                         
             perform add-the-image-number thru                                                                            
                     add-the-image-number-exit                                                                            
017600       go to seemail-common-exit                                                                                    
000200     end-if.                                                                                                        
                            
016561    if we-b-fixing-payee-name                                                                                       
             perform repair-the-payee-name thru                                                                           
                     repair-the-payee-name-exit                                                                           
017600       go to seemail-common-exit                                                                                    
000200     end-if.                                                                                                        
                            
016561    if we-b-checking-po-box                                                                                         
             perform search-the-zip-codes thru                                                                            
                     search-the-zip-codes-exit                                                                            
017600       go to seemail-common-exit                                                                                    
000200     end-if.                                                                                                        
                            
016561    if we-b-making-FAX-records                                                                                      
             perform build-starter-records thru                                                                           
                     build-starter-records-exit                                                                           
017600       go to seemail-common-exit                                                                                    
000200     end-if.                                                                                                        
                            
016561    if we-b-fixing-total-balance                                                                                    
             perform replace-opening-balance thru                                                                         
                     replace-opening-balance-exit                                                                         
017600       go to seemail-common-exit                                                                                    
000200     end-if.                                                                                                        
                            
000200                      
016561    if we-b-looking-4-starter                                                                                       
000200       perform search-4-starters thru                                                                               
000200               search-4-starters-exit                                                                               
017600       go to seemail-common-exit                                                                                    
000200     end-if.                                                                                                        
000200                      
000200                      
          if we-be-unsplitting-record                                                                                     
000200       perform undo-split-flags thru                                                                                
000200               undo-split-flags-exit                                                                                
017600       go to seemail-common-exit                                                                                    
000200     end-if.                                                                                                        
000200                      
          if we-be-unsplitting-record-2                                                                                   
000200*      perform undo-split-flags thru                                                                                
000200*              undo-split-flags-exit                                                                                
000200       perform undo-split-flags-2 thru                                                                              
000200               undo-split-flags-2-exit                                                                              
017600       go to seemail-common-exit                                                                                    
000200     end-if.                                                                                                        
000200                      
          if we-be-reset-split-records                                                                                    
000200       perform undo-split-flags thru                                                                                
000200               undo-split-flags-exit                                                                                
000200       perform undo-split-flags-2 thru                                                                              
000200               undo-split-flags-2-exit                                                                              
000200                      
000200       perform reset-split-flags thru                                                                               
000200               reset-split-flags-exit                                                                               
017600       go to seemail-common-exit                                                                                    
000200     end-if.                                                                                                        
000200                      
017400    PERFORM READ-THE-MAIL
017500       THRU READ-THE-MAIL-EXIT.
016413*   PERFORM REPORT-THE-TOTALS THRU
016413*           REPORT-THE-TOTALS-EXIT.
                            
017600 SEEMAIL-COMMON-EXIT.
017400*   MOVE REC-COUNT      TO PRT-TOTAL.
017500*   MOVE PRT-TOTAL-LINE TO PRT-RECORD.
002200*   WRITE PRT-RECORD AFTER 3.
017700    PERFORM CLOSE-THE-FILES
017800       THRU CLOSE-THE-FILES-EXIT.
017900    GOBACK.                                                                                                       
018000
018000
018000
018000
018000
026924* don't start tpsiorec before 01/01/2000, io mod can't handle it                                                  
026924* don't start tpsiorec before 01/01/2000, io mod can't handle it                                                  
026924* don't start tpsiorec before 01/01/2000, io mod can't handle it                                                  
026924* don't start tpsiorec before 01/01/2000, io mod can't handle it                                                  
026924* don't start tpsiorec before 01/01/2000, io mod can't handle it                                                  
026924* don't start tpsiorec before 01/01/2000, io mod can't handle it                                                  
018000
018000
018000*** 026800      if sf-acct-no = '0101001253' or '0101001261'                                                                  
         
                     
018000
018100 READ-THE-MAIL.
018000
018200    MOVE LOW-VALUES TO MAIL-KEY OF TPS-MAIL-REC.
018200    MOVE 0101000016 TO MAIL-ACCT-NO OF TPS-MAIL-REC.
018200    MOVE 00         TO MAIL-SUB-ACCT OF TPS-MAIL-REC.
021300    MOVE F-PRIME TO FILE-KEY.
021400    MOVE F-START TO FILE-ACTION.
021500*03/19/12 ***** read all 3 receive files *****
021500*07/12/16 *** ADD 4th RECEIVE FILE ***
021500    IF FIRST-RECV-FILE = '1'
021500       CALL TPSIORCV USING FILE-REQUEST TPS-MAIL-REC
021500    ELSE
021500    IF FIRST-RECV-FILE = '2'
021500       MOVE 20070101 TO MAIL-RECEIVE-DATE OF TPS-MAIL-REC
021500       CALL TPSIORC2 USING FILE-REQUEST TPS-MAIL-REC
021500    ELSE
021500    IF FIRST-RECV-FILE = '3'
021500       MOVE 20110101 TO MAIL-RECEIVE-DATE OF TPS-MAIL-REC
021500       CALL TPSIORC3 USING FILE-REQUEST TPS-MAIL-REC
021500    ELSE
021500    IF FIRST-RECV-FILE = '4'
021500       MOVE 20160101 TO MAIL-RECEIVE-DATE OF TPS-MAIL-REC
021500       CALL TPSIOREC USING FILE-REQUEST TPS-MAIL-REC
021500    END-IF.
021600    IF NO-RECORD-WAS-FOUND
             GO TO READ-THE-MAIL-EXIT.
021700    IF NOT A-SUCCESSFUL-OPERATION
021800       MOVE ' RECEIVE' TO FILE-NAME
021900       MOVE 'SEEMAIL-SBR' TO FILE-TEXT
022000       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
022100       GO TO SEEMAIL-COMMON-EXIT.

       READ-THE-MAIL-EXIT.

022200 READ-ALL-RECEIVE-NUMBERS.

022300    MOVE F-PRIME TO FILE-KEY.
022400    MOVE F-READ-NEXT TO FILE-ACTION.
021500    IF FIRST-RECV-FILE = '1'
021500       CALL TPSIORCV USING FILE-REQUEST TPS-MAIL-REC
021500    ELSE
021500    IF FIRST-RECV-FILE = '2'
021500       CALL TPSIORC2 USING FILE-REQUEST TPS-MAIL-REC
021500    ELSE
021500    IF FIRST-RECV-FILE = '3'
021500       MOVE 'TPS3054'      TO FILE-PROGRAM
021500       CALL TPSIORC3 USING FILE-REQUEST TPS-MAIL-REC
021500    ELSE
021500    IF FIRST-RECV-FILE = '4'
021500       CALL TPSIOREC USING FILE-REQUEST TPS-MAIL-REC.
022900*07/12/16 *** ADD 4th RECEIVE FILE ***
022600    IF END-OF-FILE-WAS-REACHED AND FIRST-RECV-FILE = '1'
022700       MOVE '2'    TO FIRST-RECV-FILE
022700       GO TO READ-THE-MAIL
022800     END-IF.
022900
022600    IF END-OF-FILE-WAS-REACHED AND FIRST-RECV-FILE = '2'
022700       MOVE '3'    TO FIRST-RECV-FILE
022700       GO TO READ-THE-MAIL
022800     END-IF.
022900
022600    IF END-OF-FILE-WAS-REACHED AND FIRST-RECV-FILE = '3'
022700       MOVE '4'    TO FIRST-RECV-FILE
022700       GO TO READ-THE-MAIL
022800     END-IF.
022900
022600    IF END-OF-FILE-WAS-REACHED AND FIRST-RECV-FILE = '4'
022700       GO TO READ-THE-MAIL-EXIT
022800     END-IF.
022900
023000    IF NOT A-SUCCESSFUL-OPERATION
023100       MOVE ' RECEIVE' TO FILE-NAME
023200       MOVE 'SEEMAIL-BRN' TO FILE-TEXT
023300       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
023400       GO TO SEEMAIL-COMMON-EXIT
023500     END-IF.
023610

026878*-           GET RID OF VOIDS
026879    IF MAIL-DISPOSITION = '88'
026880       GO TO READ-ALL-RECEIVE-NUMBERS
026886     END-IF.
277700    IF MAIL-CATEGORY-CODE = '60'                                                     00321300
277800       GO TO READ-ALL-RECEIVE-NUMBERS                                                00321400
277900    END-IF.                                                                          00321500


         IF WS-TMP-RECEIVE-DATE NOT = ZEROES
            IF WS-TMP-RECEIVE-DATE(1:4) NOT = MAIL-RECEIVE-DATE(1:4)
               DISPLAY MAIL-RECEIVE-DATE.

         MOVE MAIL-RECEIVE-DATE TO WS-TMP-RECEIVE-DATE.

         GO TO READ-ALL-RECEIVE-NUMBERS.

       YEARLY-TOTALS.

      * ADD 1 TO JUST-MAIL
      *          JUST-MAIL-ALL.

       YEARLY-TOTALS-EXIT.

002200 report-the-record.
002200*   INITIALIZE PRT-RECORD.
012000*   move recur-payee-name
012000*        to prt-payee-name.
026951*   move recur-chart-acct-01
012000*        to prt-chart-01.
026951*   move recur-chart-acct-02
012000*        to prt-chart-02.
026951*   move recur-chart-acct-03
012000*        to prt-chart-03.
      *   MOVE RECUR-ADDRESEE-NAME OF TPS-RECUR-REC
      *                               TO H-ACCT-NAME.
      *   MOVE RECUR-ACCT-NO OF TPS-RECUR-REC
      *                               TO H-RECUR-ACCT.
      *   MOVE RECUR-ADDRESOR-NAME OF TPS-RECUR-REC
      *                               TO H-RECUR-PAYEE.
      *   MOVE RECUR-PAYEE-ACCOUNT-NUMBER OF TPS-RECUR-REC
      *                                TO H-RECUR-PAYEE-ACCT.
026886*   MOVE RECUR-ACCT-NO OF TPS-RECUR-REC   TO H-RECUR-ACCT.
      *   MOVE RECUR-ADDRESEE-NAME OF TPS-RECUR-REC TO H-ACCT-NAME.
      *   MOVE RECUR-ADDRESOR-NAME OF TPS-RECUR-REC TO H-RECUR-PAYEE.
      *   MOVE RECUR-PAYEE-ACCOUNT-NUMBER OF TPS-RECUR-REC
      *                              TO H-RECUR-PAYEE-ACCT.
      *   MOVE MAIL-RECEIVE-DATE     TO H-RECEIVE-DATE.
      *   MOVE RECUR-ADDRESOR-NAME  TO PRT-RECUR-NAME.
      *   MOVE RECUR-ACCT-NO        TO PRT-RECUR-ACCT.
002210*   move mail-sub-acct         to PRT-sub-ACCT-NO.
026880*   MOVE MAIL-RECEIVE-DATE     TO PRT-RECV-DATE.
026886*   MOVE MAIL-RECEIVE-NUMBER   TO PRT-RECV-NO.
026880*   IF MAIL-IMAGE-NUMBER > ZERO
026880*      MOVE MAIL-IMAGE-NUMBER  TO PRT-IMAGE-NUMBER
026880*   ELSE
026880*      MOVE ZEROS              TO PRT-IMAGE-NUMBER.
026880*   MOVE MAIL-OPENING-BALANCE-SHARES      TO PRT-OPEN-SHARES.
012000*   MOVE MAIL-CLOSING-BALANCE-SHARES      TO PRT-CLOSE-SHARES.
002210*   MOVE MAIL-CALENDAR-XREF               TO PRT-CAL-XREF.
026880*   MOVE MAIL-AMOUNT-TO-PAY    TO PRT-AMOUNT.
012000*   MOVE MAIL-PAC-NUMBER           TO PRT-PAC-NUM.
012000*   MOVE MAIL-SORT-NUMBER          TO PRT-SORT-NUM.
012000*   MOVE mail-ofac-flag            TO PRT-OFAC-FLAG.
012000*   MOVE mail-ofac-same-day-change TO PRT-OFAC-CHG.

          MOVE MAIL-ACCT-NO TO PRT-ACCT-NO.
          MOVE MAIL-ADDRESEE-NAME TO PRT-ACCT-NAME-2
026880    MOVE MAIL-RECEIVE-DATE     TO PRT-RECV-DATE.
          MOVE RECUR-ADDRESOR-NAME OF TPS-MAIL-REC
                                   TO PRT-RECUR-NAME.
026886    MOVE MAIL-RECEIVE-NUMBER   TO PRT-RECV-NO.
          MOVE MAIL-AMOUNT-TO-PAY TO PRT-AMOUNT.
002200    WRITE PRT-RECORD AFTER 1.
022200    GO TO READ-ALL-RECEIVE-NUMBERS.
      *   PERFORM 015-CHECK THRU 015-EXIT.
                                                                                                                        
002200    WRITE PRT-RECORD AFTER 1.
002200    ADD 1            TO LINE-COUNT.
002200    IF LINE-COUNT > 35
002200       MOVE 6        TO LINE-COUNT
002200       ADD 1         TO WS-PAGE
002200       MOVE WS-PAGE  TO PRT-PAGE
002200       WRITE PRT-RECORD FROM RECUR-HEADER
002200       WRITE PRT-RECORD FROM RECUR-HEADER
002200*      WRITE PRT-RECORD FROM HEADER-1
017500*      WRITE PRT-RECORD FROM HEADER-2
002200*      WRITE PRT-RECORD FROM HEADER-3 AFTER 1 LINE
017500*      WRITE PRT-RECORD FROM HEADER-4 AFTER 1 LINE
017500*   WRITE PRT-RECORD FROM HEADER-5 AFTER 1 LINE.
002200*      WRITE PRT-RECORD FROM COURIER-36 AFTER 1 LINE
002200*      WRITE PRT-RECORD FROM HDR-RECORD AFTER 1 LINE.
026880
026964
026963*   GO TO READ-RECUR-FILE.
026928                                                                                                                  
026949*   WRITE PRT-RECORD FROM RECUR-HEADER
026963*   GO TO READ-RECUR-FILE.
026972
026928
026949    WRITE PRT-RECORD FROM RECUR-HEADER.
028360
048600*READ-THE-MAIL-EXIT. EXIT.
048700
048900
049000 FILE-ERROR.
049100     CALL TPSIOERR USING FILE-REQUEST.
049200     CANCEL TPSIOERR.
049300 FILE-ERROR-EXIT. EXIT.
049400
049500
049600 OPEN-THE-FILES.
049700    OPEN OUTPUT PRT-FILE.
049700    OPEN OUTPUT xcl-FILE.
049800    MOVE F-PRIME    TO FILE-KEY.
049900*** MOVE F-OPEN-INPUT TO FILE-ACTION.
049900    MOVE F-OPEN-I-o   TO FILE-ACTION.
050000    CALL TPSIOREC USING FILE-REQUEST TPS-MAIL-REC.
050100    IF FILE-STATUS NOT = '00' AND '05'
050200       MOVE 'RECEIVE ' TO FILE-NAME
050300       MOVE 'SEEMAIL-ORC' TO FILE-TEXT
050400       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
050500       GO TO SEEMAIL-COMMON-EXIT.
050000*   CALL TPSIOMEM USING FILE-REQUEST TPS-MEMO-REC.
050100*   IF FILE-STATUS NOT = '00' AND '05'
050200*      MOVE 'MEMO    ' TO FILE-NAME
050300*      MOVE 'SEEMAIL-OME' TO FILE-TEXT
050400*      PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
050500*      GO TO SEEMAIL-COMMON-EXIT.
459200*   CALL TPSIO022 USING FILE-REQUEST TPS-INVOICE-REC.
050100*   IF FILE-STATUS NOT = '00' AND '05'
050200*      MOVE 'MEMO    ' TO FILE-NAME
050300*      MOVE 'SEEMAIL-OIV' TO FILE-TEXT
050400*      PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
050500*      GO TO SEEMAIL-COMMON-EXIT.
016561*    if we-b-looking-4-starter                                                                                      
459200       CALL TPSIO004 USING FILE-REQUEST TPS-profl-REC                                                               
050100       IF FILE-STATUS NOT = '00' AND '05'                                                                           
050200          MOVE 'profl   ' TO FILE-NAME                                                                              
050300          MOVE 'SEEMAIL-OIV' TO FILE-TEXT                                                                           
050400          PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                                                   
050500          GO TO SEEMAIL-COMMON-EXIT                                                                                 
050600        end-if                                                                                                      
050600*    end-if.                                                                                                        
050600 
049800    MOVE F-PRIME    TO FILE-KEY.
049900    MOVE F-OPEN-INPUT TO FILE-ACTION.
049900*   MOVE F-OPEN-I-o   TO FILE-ACTION.
050000    CALL TPSIOchk USING FILE-REQUEST TPS-check-REC.
050100    IF FILE-STATUS NOT = '00' AND '05'
050200       MOVE 'check   ' TO FILE-NAME
050300       MOVE 'SEEMAIL-Opn' TO FILE-TEXT
050400       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
050500       GO TO SEEMAIL-COMMON-EXIT.


049800    MOVE F-PRIME    TO FILE-KEY.
049900*   MOVE F-OPEN-I-O TO FILE-ACTION.
049900    MOVE F-OPEN-INPUT  TO FILE-ACTION.
050000    CALL TPSIORCR USING FILE-REQUEST TPS-RECUR-REC.
050100    IF FILE-STATUS NOT = '00' AND '05'
050200       MOVE 'RECUR   ' TO FILE-NAME
050300       MOVE 'SEEMAIL-RECUR' TO FILE-TEXT
050400       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
050500       GO TO SEEMAIL-COMMON-EXIT.

050600 OPEN-THE-FILES-EXIT. EXIT.
050600                                                                                                                  
050700 CLOSE-THE-FILES.
050800    CLOSE PRT-FILE.
050800    CLOSE xcl-FILE.
050900      MOVE F-PRIME TO FILE-KEY.
051000      MOVE F-CLOSE TO FILE-ACTION.
051100
051200      CALL TPSIOREC USING FILE-REQUEST TPS-MAIL-REC.
051300      IF NOT A-SUCCESSFUL-OPERATION
051400         MOVE 'RECEIVE ' TO FILE-NAME
051500         MOVE 'SEEMAIL-CCK' TO FILE-TEXT
051600         PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
051700      END-IF.
050000*   CALL TPSIOMEM USING FILE-REQUEST TPS-MEMO-REC.
050100*   IF NOT A-SUCCESSFUL-OPERATION
050200*      MOVE 'MEMO    ' TO FILE-NAME
050300*      MOVE 'SEEMAIL-CME' TO FILE-TEXT
050400*      PERFORM FILE-ERROR THRU FILE-ERROR-EXIT.
459200*   CALL TPSIO022 USING FILE-REQUEST TPS-INVOICE-REC.                                00658600
050100*   IF NOT A-SUCCESSFUL-OPERATION
050200*      MOVE 'MEMO    ' TO FILE-NAME
050300*      MOVE 'SEEMAIL-CIV' TO FILE-TEXT
050400*      PERFORM FILE-ERROR THRU FILE-ERROR-EXIT.
050600*
016461*   if not we-r-reporting-check-info
050600*      go to close-the-files-exit
050600*    end-if.
050600*
050000    CALL TPSIOchk USING FILE-REQUEST TPS-check-REC.
050100    IF FILE-STATUS NOT = '00' AND '05'
050200       MOVE 'check   ' TO FILE-NAME
050300       MOVE 'SEEMAIL-clo' TO FILE-TEXT
050400       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT.


050900      MOVE F-PRIME TO FILE-KEY.
051000      MOVE F-CLOSE TO FILE-ACTION.
050000    CALL TPSIORCR USING FILE-REQUEST TPS-RECUR-REC.
050100    IF FILE-STATUS NOT = '00' AND '05'
050200       MOVE 'RECUR   ' TO FILE-NAME
050300       MOVE 'SEEMAIL-RECUR' TO FILE-TEXT
050400       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT.

051800
051900 CLOSE-THE-FILES-EXIT. EXIT.
023610                                                                                                                  
023610                                                                                                                  
023610                                                                                                                  
023610                                                                                                                  
023610                                                                                                                  
023610*** commented stuff worked, they added 2 more bad records                                                         
023610*** so got 2 go after #'s 204 & 205 on 2nd fix.............                                                       
023610*** do twice, rename records then delete records.............
023610                                                                                                                  
       add-the-missing-record.                                                                                          
026886    move '0101000420'                 to mail-acct-no.
026880    move '00'                         to mail-sub-acct.
026880    move '20021028'                   to mail-receive-date.
026886    move '00203'                      to mail-receive-number.
023610                                                                                                                  
022300    move f-prime to file-key.
022400    move f-start  to file-action.
022500    call tpsiorec using file-request tps-mail-rec.
023000    if not a-successful-operation
023100       move ' receive' to file-name
023200       move 'seemail-rd ' to file-text
023300       perform file-error thru file-error-exit
023400       go to seemail-common-exit
023500     end-if.
023610                                                                                                                  
       fix-missing-record.
023610
022300    move f-prime to file-key.
022400    move f-read-next  to file-action.
022500    call tpsiorec using file-request tps-mail-rec.
023000    if not a-successful-operation
023100       move ' receive' to file-name
023200       move 'seemail-rd ' to file-text
023300       perform file-error thru file-error-exit
023400       go to seemail-common-exit
023500     end-if.
023610
026886*   move '00002'                      to mail-receive-number.                                                     
023610
026886*   subtract 201 from mail-receive-number.
023610                                                                                                                  
022300    move f-prime to file-key.
022400*   move f-write to file-action.
022400    move f-delet to file-action.
022500    call tpsiorec using file-request tps-mail-rec.
023000    if not a-successful-operation
023100       move ' receive' to file-name
023200       move 'seemail-wr ' to file-text
023300       perform file-error thru file-error-exit
023400       go to seemail-common-exit
023500     end-if.
023610
017600*   if mail-receive-number = 9
017600    if mail-receive-number = 218
017600       go to seemail-common-exit.
023610
026886    go to fix-missing-record.
023610********** delete 203 ******************************************************                                      
026886*   move '0101000321'                 to mail-acct-no.                                                            
026880*   move '00'                         to mail-sub-acct.                                                           
026880*   move '20021024'                   to mail-receive-date.                                                       
026886*   move '00203'                      to mail-receive-number.                                                     
023610                                                                                                                  
022300*   move f-prime to file-key.
022400*   move f-read  to file-action.
022500*   call tpsiorec using file-request tps-mail-rec.
023000*   if not a-successful-operation
023100*      move ' receive' to file-name
023200*      move 'seemail-rd ' to file-text
023300*      perform file-error thru file-error-exit
023400*      go to seemail-common-exit
023500*    end-if.
023610                                                                                                                  
022300*   move f-prime to file-key.
022400*   move f-delet to file-action.
022500*   call tpsiorec using file-request tps-mail-rec.
023000*   if not a-successful-operation
023100*      move ' receive' to file-name
023200*      move 'seemail-wr ' to file-text
023300*      perform file-error thru file-error-exit
023400*      go to seemail-common-exit
023500*    end-if.
023610********** delete 204 ******************************************************                                      
026886    move '0101000321'                 to mail-acct-no.                                                            
026880    move '00'                         to mail-sub-acct.                                                           
026880    move '20021024'                   to mail-receive-date.                                                       
026886    move '00204'                      to mail-receive-number.                                                     
023610                                                                                                                  
022300    move f-prime to file-key.
022400    move f-read  to file-action.
022500    call tpsiorec using file-request tps-mail-rec.
023000    if not a-successful-operation
023100       move ' receive' to file-name
023200       move 'seemail-rd ' to file-text
023300       perform file-error thru file-error-exit
023400       go to seemail-common-exit
023500     end-if.
023610                                                                                                                  
022300    move f-prime to file-key.
022400    move f-delet to file-action.
022500    call tpsiorec using file-request tps-mail-rec.
023000    if not a-successful-operation
023100       move ' receive' to file-name
023200       move 'seemail-wr ' to file-text
023300       perform file-error thru file-error-exit
023400       go to seemail-common-exit
023500     end-if.
023610********** delete 205 ******************************************************                                      
026886    move '0101000321'                 to mail-acct-no.                                                            
026880    move '00'                         to mail-sub-acct.                                                           
026880    move '20021024'                   to mail-receive-date.                                                       
026886    move '00205'                      to mail-receive-number.                                                     
023610                                                                                                                  
022300    move f-prime to file-key.
022400    move f-read  to file-action.
022500    call tpsiorec using file-request tps-mail-rec.
023000    if not a-successful-operation
023100       move ' receive' to file-name
023200       move 'seemail-rd ' to file-text
023300       perform file-error thru file-error-exit
023400       go to seemail-common-exit
023500     end-if.
023610                                                                                                                  
022300    move f-prime to file-key.
022400    move f-delet to file-action.
022500    call tpsiorec using file-request tps-mail-rec.
023000    if not a-successful-operation
023100       move ' receive' to file-name
023200       move 'seemail-wr ' to file-text
023300       perform file-error thru file-error-exit
023400       go to seemail-common-exit
023500     end-if.
023610*****************************************************************                                                 
023610                                                                                                                  
017600    go to seemail-common-exit.                                                                                    
023610                                                                                                                  
023610                                                                                                                  
023620                                                                                                                  
023630                                                                                                                  
023640                                                                                                                  
023650                                                                                                                  
023660                                                                                                                  
023670                                                                                                                  
023680                                                                                                                  
023690************ whiteside record was changed from bill to general after                                                
023700************ check was issued. bug fixed, now fix bad record........                                                
034310                                                                                                                  
034410                                                                                                                  
024010                                                                                                                  
       GET-CHART-INFO.
026876
011600    move '3'                      to ws-action-parm.
018200    call tpschart using ws-parms
018200                        tps-profl-rec
018200                        tps-mail-rec.
018200    cancel tpschart.
026876
011400
002200    initialize xcl-RECORD.
012000    inspect WS-ENGLISH-CHART-01
                  replacing all ',' by ' '.
012000*   move WS-ENGLISH-CHART-01
002210*        to PRT-CHART-INFO.
012000*   inspect WS-ENGLISH-CHART-02
      *           replacing all ',' by ' '.
012000*   move WS-ENGLISH-CHART-02
002210*        to PRT-CHART-INFO(26:10).
002210    ADD 1   TO REC-COUNT.
024110                                                                                                                  
       GET-CHART-INFO-EXIT.    EXIT.
024210                                                                                                                  
024310                                                                                                                  
024410                                                                                                                  
026876
011400
026876
026876
026876
026928
026928
026928                                                                                                                  
026949 015-CHECK.
026876
026924    move mail-acct-no             to check-acct-no.
026924    move '00'                     to check-sub-acct.
003600    move mail-check-transaction-no to check-transaction-no.
026876
022300    move f-prime to file-key.
022400    move f-read  to file-action.
022500    call tpsiochk using file-request tps-check-rec.
023000    if not a-successful-operation
023100       move ' check  ' to file-name
023200       move 'seemail-rd ' to file-text
023300       perform file-error thru file-error-exit
023400       go to seemail-common-exit
023500     end-if.
023610
026876
003600    if mail-check-transaction-no not numeric
026880       go to 015-EXIT
026886     end-if.
026876
003600    if mail-check-transaction-no = 0
026880       go to 015-EXIT
026886     end-if.
026876
026924    move mail-acct-no             to check-acct-no.
026924    move '00'                     to check-sub-acct.
003600    move mail-check-transaction-no to check-transaction-no.
026876    move spaces                       to xrt-record.
026876
005800*   move check-number          to Prt-check-number.
005900*   move check-amount          to Prt-check-amount.
052000
052000 015-EXIT.   EXIT.
052000
052000
052000
052000
052000
000000                                                                                                                    
023610 count-mail-2002.                                                                                                   
026906*** if mail-receive-date(1:4) not = '2002'                                                                          
026906    if mail-receive-date(1:4) not = '2001'                                                                          
026963       go to read-all-receive-numbers
026886     end-if.
      ***********   voids
026879    if mail-disposition = '88'
026880       go to read-all-receive-numbers
026886     end-if.
      ***********   historic
277700    if mail-category-code = '60'                                                                                    
277800       go to read-all-receive-numbers                                                                               
277900    end-if.                                                                                                         
026690                                                                                                                    
052000                                                                                                                    
005900    add 1                   to mail-count-total.                                                                    
277800    go to read-all-receive-numbers.                                                                                 
052000
052000
052000
052000
052000
052000****************************************************************                                                    
025210                                                                                                                  
052000
034010*****************************************************************                                                 
025210                                                                                                                  
052000
052000
034010*****************************************************************                                                 
052000
052000
052000
025210                                                                                                                  
052000
052000
052000
052000
052000
000200 find-speigel-horse-stuff.                                                                                          
023810    move '0101000990'                 to mail-acct-no.
023910    move '00'                         to mail-sub-acct.
024010    move '20040101'                   to mail-receive-date.
024110    move '00000'                      to mail-receive-number.
021300                                                                                                                    
021300    MOVE F-PRIME TO FILE-KEY.
021400    MOVE F-START TO FILE-ACTION.
021500    CALL TPSIOREC USING FILE-REQUEST TPS-MAIL-REC.
021700    IF NOT A-SUCCESSFUL-OPERATION
021800       MOVE ' RECEIVE' TO FILE-NAME
021900       MOVE 'SEEMAIL-SBR' TO FILE-TEXT
022000       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
022100       GO TO SEEMAIL-COMMON-EXIT.
026880
026876
026876
009100
023610                                                                                                                    
026928                                                                                                                  
000200 find-speigel-horse-stuff-exit. exit.                                                                               
052000
052000
052000
000200 search-4-starters.                                                                                                 
018200    MOVE LOW-VALUES TO MAIL-KEY OF TPS-MAIL-REC.
026924    move '0101000016002004010100001' to mail-key.
021300    move f-prime to file-key.
021400    move f-start to file-action.
021500    call tpsiorec using file-request tps-mail-rec.
021700    if not a-successful-operation
021800       move ' receive' to file-name
021900       move 'seemail-sbr' to file-text
022000       perform file-error thru file-error-exit
022100       go to seemail-common-exit.
026880
026880
026880
022200 read-4-starters.                                                                                                   
022300    move f-prime to file-key.
022400    move f-read-next to file-action.
022500    call tpsiorec using file-request tps-mail-rec.
022600    if end-of-file-was-reached
022700       go to read-the-mail-exit
022800     end-if.
022900
023000    if not a-successful-operation
023100       move ' receive' to file-name
023200       move 'seemail-brn' to file-text
023300       perform file-error thru file-error-exit
023400       go to seemail-common-exit
023500     end-if.
023610                                                                                                                  
023610                                                                                                                  
026880    if mail-receive-date < '20040101'                                                                               
022200       go to read-4-starters                                                                                        
026886     end-if.
023610                                                                                                                  
026880    if mail-receive-date > '20050216'                                                                               
022200       go to read-4-starters                                                                                        
026886     end-if.
023610                                                                                                                  
000100    if recur-admin-logon of tps-mail-rec not = 'STARTER'                                                            
022200       go to read-4-starters                                                                                        
026886     end-if.
026880
026880    if mail-acct-no not = ws-save-acct-no                                                                           
026880       move mail-acct-no               to ws-save-acct-no                                                           
026880       move mail-acct-no               to clnt-profile-acct-no                                                      
026880       move '00'                       to clnt-profile-sub-acct                                                     
022300       move f-prime to file-key
022400       move f-read  to file-action
022500       call tpsio004 using file-request tps-profl-rec
023000       if not a-successful-operation                                                                                
023100          move ' profile' to file-name                                                                              
023200          move 'seemail-rd ' to file-text                                                                           
023300          perform file-error thru file-error-exit                                                                   
023400          go to seemail-common-exit                                                                                 
              end-if                                                                                                      
           end-if.                                                                                                        
023610                                                                                                                  
023610                                                                                                                  
000200 search-4-starters-exit. exit.                                                                                      
052000
052000
052000
052000
052000
052000
052000
052000
052000
       replace-opening-balance.                                                                                           
023810    move '0103000014'                 to mail-acct-no.
023910    move '00'                         to mail-sub-acct.
024010    move '20050217'                   to mail-receive-date.
024110    move '00009'                      to mail-receive-number.
024210                                                                                                                  
024310    move f-prime to file-key.
024410    move f-read   to file-action.
024510    call tpsiorec using file-request tps-mail-rec.
024610    if not a-successful-operation
024710       move ' receive' to file-name
024810       move 'seemail-rd ' to file-text
024910       perform file-error thru file-error-exit
025010       go to seemail-common-exit
025110     end-if.
029810                                                                                                                    
029810    move 940.35                to mail-total-balance                                                                
029810                                  mail-opening-balance.                                                             
029810                                                                                                                    
024310    move f-prime to file-key.
033610    move f-rewrite  to file-action.                                                                                 
024510    call tpsiorec using file-request tps-mail-rec.
024610    if not a-successful-operation
024710       move ' receive' to file-name
024810       move 'seemail-rew' to file-text
024910       perform file-error thru file-error-exit
025010       go to seemail-common-exit
025110     end-if.
025210                                                                                                                  
       replace-opening-balance-exit. exit.                                                                                
052000
052000
052000
052000
052000
052000
052000
017600 seeif-record-altered.                                                                                              
026924    if mail-acct-no(1:4) = '0150'                                                                                   
022700       go to read-the-mail-exit
277900    end-if.                                      
052000
026880    if mail-receive-date(1:4) not = '2004'                                                                          
277800       go to read-all-receive-numbers                                                                               
277900     end-if.                                                                                                        
052000
026879    if mail-disposition = '88'
026880       continue                                                                                                     
026886      else           
277700    if mail-category-code = '60'                                                                                    
026880       continue                                                                                                     
026886      else           
277800       go to read-all-receive-numbers                                                                               
277900     end-if                                                                                                         
277900    end-if.                                      
052000
052000    if mail-admin-process-date < '20050502'                                                                         
277800       go to read-all-receive-numbers                                                                               
277900     end-if.                                                                                                        
052000
052000    if mail-admin-process-date > '20050601'                                                                         
277800       go to read-all-receive-numbers                                                                               
277900     end-if.                                                                                                        
052000
052000
002200    go to report-the-record.                                                                                        
052000
052000
052000
       build-starter-records.                                                                                             
023810    move '0150000057'                 to mail-acct-no.
023910    move '00'                         to mail-sub-acct.
024010    move '20051110'                   to mail-receive-date.
024110    move '00012'                      to mail-receive-number.
024210                                                                                                                  
024310    move f-prime to file-key.
024410    move f-read   to file-action.
024510    call tpsiorec using file-request tps-mail-rec.
024610    if not a-successful-operation
024710       move ' receive' to file-name
024810       move 'seemail-rd ' to file-text
024910       perform file-error thru file-error-exit
025010       go to seemail-common-exit
025110     end-if.
025210                                                                                                                  
025210                                                                                                                  
033410                                                                                                                    
701400    call tps1010g using tps-logon-rec                                                                               
701500                        tps-profl-rec                                                                               
701600                        tps-mail-rec.                                                                               
701700    cancel tps1010g.                                                                                                
701800**********************************************************                                                          
026880    move '00002221'        to mail-image-number.                                                                    
701400    call tps1010g using tps-logon-rec                                                                               
701500                        tps-profl-rec                                                                               
701600                        tps-mail-rec.                                                                               
701700    cancel tps1010g.                                                                                                
701800**********************************************************                                                          
026880    move '00002222'        to mail-image-number.                                                                    
701400    call tps1010g using tps-logon-rec                                                                               
701500                        tps-profl-rec                                                                               
701600                        tps-mail-rec.                                                                               
701700    cancel tps1010g.                                                                                                
701800**********************************************************                                                          
026880    move '00002223'        to mail-image-number.                                                                    
701400    call tps1010g using tps-logon-rec                                                                               
701500                        tps-profl-rec                                                                               
701600                        tps-mail-rec.                                                                               
701700    cancel tps1010g.                                                                                                
701800**********************************************************                                                          
026880    move '00002224'        to mail-image-number.                                                                    
701400    call tps1010g using tps-logon-rec                                                                               
701500                        tps-profl-rec                                                                               
701600                        tps-mail-rec.                                                                               
701700    cancel tps1010g.                                                                                                
701800**********************************************************                                                          
026880    move '00002225'        to mail-image-number.                                                                    
701400    call tps1010g using tps-logon-rec                                                                               
701500                        tps-profl-rec                                                                               
701600                        tps-mail-rec.                                                                               
701700    cancel tps1010g.                                                                                                
701800**********************************************************                                                          
026880    move '00002226'        to mail-image-number.                                                                    
701400    call tps1010g using tps-logon-rec                                                                               
701500                        tps-profl-rec                                                                               
701600                        tps-mail-rec.                                                                               
701700    cancel tps1010g.                                                                                                
701800**********************************************************                                                          
026880    move '00002227'        to mail-image-number.                                                                    
701400    call tps1010g using tps-logon-rec                                                                               
701500                        tps-profl-rec                                                                               
701600                        tps-mail-rec.                                                                               
701700    cancel tps1010g.                                                                                                
701800**********************************************************                                                          
026880    move '00002228'        to mail-image-number.                                                                    
701400    call tps1010g using tps-logon-rec                                                                               
701500                        tps-profl-rec                                                                               
701600                        tps-mail-rec.                                                                               
701700    cancel tps1010g.                                                                                                
701800**********************************************************                                                          
026880    move '00002229'        to mail-image-number.                                                                    
701400    call tps1010g using tps-logon-rec                                                                               
701500                        tps-profl-rec                                                                               
701600                        tps-mail-rec.                                                                               
701700    cancel tps1010g.                                                                                                
701800**********************************************************                                                          
026880    move '00002230'        to mail-image-number.                                                                    
701400    call tps1010g using tps-logon-rec                                                                               
701500                        tps-profl-rec                                                                               
701600                        tps-mail-rec.                                                                               
701700    cancel tps1010g.                                                                                                
701800**********************************************************                                                          
026880    move '00002231'        to mail-image-number.                                                                    
701400    call tps1010g using tps-logon-rec                                                                               
701500                        tps-profl-rec                                                                               
701600                        tps-mail-rec.                                                                               
701700    cancel tps1010g.                                                                                                
052000
       build-starter-records-exit. exit.                                                                                  
052000
052000
052000
       search-the-zip-codes.                                                                                              
026924    move '0101000016002005010100001' to mail-key.
026880    MOVE MAIL-ACCT-NO     TO WS-SAVE-ACCT-NO.
026880                                                                                                                    
018100 START-THE-zip-search.
021300    MOVE F-PRIME TO FILE-KEY.
021400    MOVE F-START TO FILE-ACTION.
021500    CALL TPSIOREC USING FILE-REQUEST TPS-MAIL-REC.
021600    IF NO-RECORD-WAS-FOUND GO TO READ-THE-MAIL-EXIT.
021700    IF NOT A-SUCCESSFUL-OPERATION
021800       MOVE ' RECEIVE' TO FILE-NAME
021900       MOVE 'SEEMAIL-SBR' TO FILE-TEXT
022000       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
022100       GO TO SEEMAIL-COMMON-EXIT.
026880
002200    MOVE SPACES        TO PRT-RECORD.
026880 
022200 READ-ALL-zip-records.     
022300    MOVE F-PRIME TO FILE-KEY.
022400    MOVE F-READ-NEXT TO FILE-ACTION.
022500    CALL TPSIOREC USING FILE-REQUEST TPS-MAIL-REC.
022600    IF END-OF-FILE-WAS-REACHED
             go to search-the-zip-codes-exit                                                                              
022800     END-IF.
022900
023000    IF NOT A-SUCCESSFUL-OPERATION
023100       MOVE ' RECEIVE' TO FILE-NAME
023200       MOVE 'SEEMAIL-BRN' TO FILE-TEXT
023300       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
023400       GO TO SEEMAIL-COMMON-EXIT
023500     END-IF.
023610                                                                                                                  
026880    if MAIL-ACCT-NO not =  WS-SAVE-ACCT-NO                                                                          
026880       MOVE MAIL-ACCT-NO     TO WS-SAVE-ACCT-NO                                                                     
026924       move '0101000000002005010100001' to mail-key                                                                 
026880       MOVE WS-SAVE-ACCT-NO  to mail-acct-no                                                                        
026880       MOVE MAIL-ACCT-NO     TO clnt-profile-acct-no                                                                
026880       MOVE '00'             TO clnt-profile-sub-acct                                                               
022300       MOVE F-PRIME TO FILE-KEY                                                                                     
022400       MOVE F-READ  TO FILE-ACTION                                                                                  
022500       CALL TPSIO004 USING FILE-REQUEST TPS-profl-REC                                                               
023000       IF NOT A-SUCCESSFUL-OPERATION                                                                                
023100          MOVE ' profile' TO FILE-NAME                                                                              
023200          MOVE 'SEEMAIL-rd ' TO FILE-TEXT                                                                           
023300          PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                                                   
023400          GO TO SEEMAIL-COMMON-EXIT                                                                                 
              END-IF                                                                                                      
018100       go to START-THE-zip-search                                                                                   
023500     end-if.
                            
          if mail-addresee-zipcode not numeric                                                                            
022200       go to read-all-zip-records                                                                                   
023500     end-if.
                            
          if mail-addresee-zipcode = zeros                                                                                
022200       go to read-all-zip-records                                                                                   
023500     end-if.
                            
          if mail-addresee-zipcode = '115308020'                                                                          
022200       go to read-all-zip-records                                                                                   
023500     end-if.
                            
          if mail-addresee-zipcode = '115300000'                                                                          
022200       go to read-all-zip-records                                                                                   
023500     end-if.
                            
          if mail-addresee-zipcode(1:5) not = '11530'                                                                     
022200       go to read-all-zip-records                                                                                   
023500     end-if.
                            
                            
002210**  move mail-acct-no          to PRT-ACCT-NO.                                                                      
002300*   move clnt-profile-first-name(1:1)  to PRT-first-init.
002300*   move clnt-profile-last-name(1:20)  to PRT-last-name.
002300*   move mail-receive-date     to PRT-RECV-DATE.
002300*   move mail-receive-number   to PRT-RECV-NO.
002300*   move mail-addresor-name    to PRT-ADDSOR-NAME.
002300*   move mail-addresee-zipcode(1:5) to PRT-ADDee-zip(1:5).
002300*   move mail-addresee-zipcode(6:4) to PRT-ADDee-zip(7:4).
002220                                                                                                                    
002200    WRITE PRT-RECORD AFTER 1.
002200    MOVE SPACES        TO PRT-RECORD.
026964
022200    go to read-all-zip-records.                                                                                     
                            
052000
       search-the-zip-codes-exit. exit.                                                                                   
052000
052000
052000
034010*****************************************************************                                                 
       repair-the-payee-name.                                                                                             
023810    move '0101001543'                 to mail-acct-no.
023910    move '00'                         to mail-sub-acct.
024010    move '20060411'                   to mail-receive-date.
024110    move '00005'                      to mail-receive-number.
024210                                                                                                                  
024310    move f-prime to file-key.
024410    move f-read   to file-action.
024510    call tpsiorec using file-request tps-mail-rec.
024610    if not a-successful-operation
024710       move ' receive' to file-name
024810       move 'seemail-rd ' to file-text
024910       perform file-error thru file-error-exit
025010       go to seemail-common-exit
025110     end-if.
025210                                                                                                                  
024210                                                                                                                  
024310    move f-prime to file-key.
033610    move f-rewrite  to file-action.                                                                                 
024510    call tpsiorec using file-request tps-mail-rec.
024610    if not a-successful-operation
024710       move ' receive' to file-name
024810       move 'seemail-rew' to file-text
024910       perform file-error thru file-error-exit
025010       go to seemail-common-exit
025110     end-if.
052000
       repair-the-payee-name-exit. exit.                                                                                  
052000
052000
       add-the-image-number.                                                                                              
023810    move '0150000057'                 to mail-acct-no.
023910    move '00'                         to mail-sub-acct.
024010    move '20060719'                   to mail-receive-date.
024110    move '00006'                      to mail-receive-number.
024210                                                                                                                  
024310    move f-prime to file-key.
024410    move f-read   to file-action.
024510    call tpsiorec using file-request tps-mail-rec.
024610    if not a-successful-operation
024710       move ' receive' to file-name
024810       move 'seemail-rd ' to file-text
024910       perform file-error thru file-error-exit
025010       go to seemail-common-exit
025110     end-if.
025210                                                                                                                  
052000
026880    move '30001449'        to mail-image-number.                                                                    
024210                                                                                                                  
024310    move f-prime to file-key.
033610    move f-rewrite  to file-action.                                                                                 
024510    call tpsiorec using file-request tps-mail-rec.
024610    if not a-successful-operation
024710       move ' receive' to file-name
024810       move 'seemail-rew' to file-text
024910       perform file-error thru file-error-exit
025010       go to seemail-common-exit
025110     end-if.
052000                                                                                                                    
       add-the-image-number-exit. exit.                                                                                   
052000
052000
052000
       lose-bad-import-date.                                                                                              
010700     perform varying loseit-idx from 1 by 1                                                                         
010700           until loseit-acct-num(loseit-idx) = '9999999999'                                                         
052000           perform delete-bad-date thru                                                                             
052000                   delete-bad-date-exit                                                                             
052000       end-perform.
           go to lose-bad-import-date-exit.                                                                               
052000
052000
052000 delete-bad-date.                                                                                                   
021500    initialize tps-mail-rec.                                                                                        
010700    move loseit-acct-num(loseit-idx) to mail-acct-no.                                                               
010700    move '00'                        to mail-sub-acct.                                                              
010700    move '20061105'                  to mail-receive-date.                                                          
010700    move zeros                       to mail-receive-number.                                                        
052000
021300    move f-prime to file-key.
021400    move f-start to file-action.
021500    call tpsiorec using file-request tps-mail-rec.
021600    if no-record-was-found go to read-the-mail-exit.
021700    if not a-successful-operation
021800       move ' receive' to file-name
021900       move 'seemail-sbr' to file-text
022000       perform file-error thru file-error-exit
022100       go to seemail-common-exit.
026880
052000 read-for-delete-bad-date.                                                                                          
022300    move f-prime to file-key.
022400    move f-read-next to file-action.
022500    call tpsiorec using file-request tps-mail-rec.
022600    if end-of-file-was-reached
052000       go to delete-bad-date-exit                                                                                   
022800     end-if.
023000    if not a-successful-operation
023100       move ' receive' to file-name
023200       move 'seemail-brn' to file-text
023300       perform file-error thru file-error-exit
023400       go to seemail-common-exit
023500     end-if.
023610                                                                                                                  
023610                                                                                                                  
010700    if mail-acct-no not = loseit-acct-num(loseit-idx)                                                               
052000       go to delete-bad-date-exit                                                                                   
026886    end-if.
023610                                                                                                                  
010700    if mail-receive-date not = '20061105'                                                                           
052000       go to delete-bad-date-exit                                                                                   
026886    end-if.
023610                                                                                                                  
022300    move f-prime to file-key.
022400    move f-delet to file-action.                                                                                    
022500    call tpsiorec using file-request tps-mail-rec.
023000    if not a-successful-operation
023100       move ' receive' to file-name
023200       move 'seemail-del' to file-text
023300       perform file-error thru file-error-exit
023400       go to seemail-common-exit
023500     end-if.
023610    add 1                 to bad-date-deletes.                                                                    
052000    go to read-for-delete-bad-date.                                                                                 
023610
052000 delete-bad-date-exit. exit.                                                                                        
023610
023610
       lose-bad-import-date-exit. exit.                                                                                   
052000
052000
052000
       search-for-refund-amount.                                                                                          
026924    move '0101000016002006010100001' to mail-key.
026880    MOVE MAIL-ACCT-NO     TO WS-SAVE-ACCT-NO.
026880                                                                                                                    
018100 START-THE-refund-search.                                                                                           
021300    MOVE F-PRIME TO FILE-KEY.
021400    MOVE F-START TO FILE-ACTION.
021500    CALL TPSIOREC USING FILE-REQUEST TPS-MAIL-REC.
021600    IF NO-RECORD-WAS-FOUND GO TO READ-THE-MAIL-EXIT.
021700    IF NOT A-SUCCESSFUL-OPERATION
021800       MOVE ' RECEIVE' TO FILE-NAME
021900       MOVE 'SEEMAIL-SBR' TO FILE-TEXT
022000       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
022100       GO TO SEEMAIL-COMMON-EXIT.
026880
002200    MOVE SPACES        TO PRT-RECORD.
026880 
022200 READ-ALL-refund-records.                                                                                           
022300    MOVE F-PRIME TO FILE-KEY.
022400    MOVE F-READ-NEXT TO FILE-ACTION.
022500    CALL TPSIOREC USING FILE-REQUEST TPS-MAIL-REC.
022600    IF END-OF-FILE-WAS-REACHED
             go to search-for-refund-amount-exit                                                                          
022800     END-IF.
022900
023000    IF NOT A-SUCCESSFUL-OPERATION
023100       MOVE ' RECEIVE' TO FILE-NAME
023200       MOVE 'SEEMAIL-BRN' TO FILE-TEXT
023300       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
023400       GO TO SEEMAIL-COMMON-EXIT
023500     END-IF.
023610                                                                                                                  
026880    if MAIL-ACCT-NO not =  WS-SAVE-ACCT-NO                                                                          
026880       MOVE MAIL-ACCT-NO     TO WS-SAVE-ACCT-NO                                                                     
026924       move '0101000000002006010100001' to mail-key                                                                 
026880       MOVE WS-SAVE-ACCT-NO  to mail-acct-no                                                                        
026880       MOVE MAIL-ACCT-NO     TO clnt-profile-acct-no                                                                
026880       MOVE '00'             TO clnt-profile-sub-acct                                                               
022300       MOVE F-PRIME TO FILE-KEY                                                                                     
022400       MOVE F-READ  TO FILE-ACTION                                                                                  
022500       CALL TPSIO004 USING FILE-REQUEST TPS-profl-REC                                                               
023000       IF NOT A-SUCCESSFUL-OPERATION                                                                                
023100          MOVE ' profile' TO FILE-NAME                                                                              
023200          MOVE 'SEEMAIL-rd ' TO FILE-TEXT                                                                           
023300          PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                                                   
023400          GO TO SEEMAIL-COMMON-EXIT                                                                                 
              END-IF                                                                                                      
018100       go to START-THE-refund-search                                                                                
023500     end-if.
                            
026876
                            
002210    move mail-acct-no          to PRT-ACCT-NO.                                                                      
002300*   move clnt-profile-first-name(1:1)  to PRT-first-init.
002300*   move clnt-profile-last-name(1:20)  to PRT-last-name.
002300    move mail-receive-date     to PRT-RECV-DATE.                                                                    
002300    move mail-receive-number   to PRT-RECV-NO.                                                                      
002300*   move mail-addresor-name    to PRT-ADDSOR-NAME.
002300*   move mail-addresee-zipcode(1:5) to PRT-ADDee-zip(1:5).
002300*   move mail-addresee-zipcode(6:4) to PRT-ADDee-zip(7:4).
026880*   IF MAIL-IMAGE-NUMBER > ZERO
026880*      MOVE MAIL-IMAGE-NUMBER  TO PRT-IMAGE-NUMBER
026880*   ELSE
026880*      MOVE ZEROS              TO PRT-IMAGE-NUMBER.
002220                                                                                                                    
002200    WRITE PRT-RECORD AFTER 1.
002200    MOVE SPACES        TO PRT-RECORD.
026964
022200    go to read-all-refund-records.                                                                                  
052000
       search-for-refund-amount-exit. exit.                                                                               
052000
052000
052000
052000 build-receive-for-split.
000000    move spaces    to mail-pass-word         of tps-mail-rec                         00476800
464800                      mail-type-acct         of tps-mail-rec                         00476900
464900                      mail-addresor-name     of tps-mail-rec                         00477000
465000                      mail-addresor-addrl1   of tps-mail-rec                         00477100
465100                      mail-addresor-addrl2   of tps-mail-rec                         00477200
465200                      mail-addresor-citystat of tps-mail-rec                         00477300
465300                      mail-addresee-name     of tps-mail-rec                         00477400
465400                      mail-addresee-addrl1   of tps-mail-rec                         00477500
465500                      mail-addresee-addrl2   of tps-mail-rec                         00477600
465600                      mail-addresee-citystat of tps-mail-rec                         00477700
465700                      mail-admin-xxxxxx      of tps-mail-rec                         00477800
465800                      mail-memo-attached     of tps-mail-rec                         00477900
465900                      mail-disposition       of tps-mail-rec                         00478000
466000                      mail-room-to-expand    of tps-mail-rec                         00478100
466100                      recur-addresor-name    of tps-mail-rec                         00478200
466200                      recur-pass-word        of tps-mail-rec                         00478300
466300                      recur-type-acct        of tps-mail-rec                         00478400
466400                      recur-addresor-addrl1  of tps-mail-rec                         00478500
466500                      recur-addresor-addrl2  of tps-mail-rec                         00478600
466600                      recur-addresor-citystat  of tps-mail-rec                       00478700
466700                      recur-addresee-name    of tps-mail-rec                         00478800
466800                      recur-addresee-addrl1  of tps-mail-rec                         00478900
466900                      recur-addresee-addrl2  of tps-mail-rec                         00479000
467000                      recur-addresee-citystat  of tps-mail-rec                       00479100
467100                      recur-payee-name       of tps-mail-rec                         00479200
467200                      recur-payee-addrl1     of tps-mail-rec                         00479300
467300                      recur-payee-addrl2     of tps-mail-rec                         00479400
467400                      recur-payee-citystat   of tps-mail-rec                         00479500
467500                      recur-payee-account-number of tps-mail-rec                     00479600
467600                      recur-payee-memo-field of tps-mail-rec                         00479700
467700                      recur-invoice-category of tps-mail-rec                         00479800
467800                      recur-carrier-code     of tps-mail-rec                         00479900
467900                      recur-postage-class    of tps-mail-rec                         00480000
468000                      recur-containr-size    of tps-mail-rec                         00480100
468100                      recur-category-code    of tps-mail-rec                         00480200
468200                      recur-send-bill-stub   of tps-mail-rec.                        00480300
468300                                                                                     00480400
468400      move zeros     to mail-receive-date      of tps-mail-rec                       00480500
468500                       mail-receive-number    of tps-mail-rec                        00480600
468600                       mail-addresor-zipcode  of tps-mail-rec                        00480700
468700                       mail-addresee-zipcode  of tps-mail-rec                        00480800
468800                       mail-postmark-date     of tps-mail-rec                        00480900
468900                       mail-postage-amount    of tps-mail-rec                        00481000
469000                       mail-containr-size     of tps-mail-rec                        00481100
469100                       mail-admin-process-date of tps-mail-rec                       00481200
469200                       mail-number-enclosed   of tps-mail-rec                        00481300
469300                       mail-enclosed-descript of tps-mail-rec                        00481400
469400                      mail-document-dispos-ition of tps-mail-rec                     00481500
469500                       mail-number-enclosures of tps-mail-rec                        00481600
469600                       mail-image-number      of tps-mail-rec                        00481700
469700                       mail-total-balance     of tps-mail-rec                        00481800
469800                       mail-due-date          of tps-mail-rec                        00481900
469900                       mail-amount-billed     of tps-mail-rec                        00482000
470000                       mail-closing-date      of tps-mail-rec                        00482100
470100                       mail-check-transaction-no of tps-mail-rec                     00482200
470200                       mail-xref-date         of tps-mail-rec                        00482300
470300                       mail-xref-n            of tps-mail-rec                        00482400
470400                       mail-deposit-amount    of tps-mail-rec                        00482500
470500                     mail-opening-balance-shares of tps-mail-rec                     00482600
470600                     mail-closing-balance-shares of tps-mail-rec                     00482700
470700                       mail-calendar-xref     of tps-mail-rec                        00482800
470800                       recur-acct-no          of tps-mail-rec                        00482900
470900                       recur-sub-acct         of tps-mail-rec                        00483000
471000                       recur-addresor-zipcode of tps-mail-rec                        00483100
471100                       recur-addresee-zipcode of tps-mail-rec                        00483200
471200                       recur-payee-zipcode    of tps-mail-rec                        00483300
471300                       recur-payee-resident-code of tps-mail-rec                     00483400
471400                       recur-payee-disposition of tps-mail-rec                       00483500
471500                       recur-invoice-classify of tps-mail-rec                        00483600
471600                       recur-pre-approve-lolimit of tps-mail-rec                     00483700
471700                       recur-pre-approve-hilimit of tps-mail-rec                     00483800
471800                       recur-cycle-amount     of tps-mail-rec                        00483900
471900                       recur-cycle-date       of tps-mail-rec                        00484000
472000                       recur-cycle-event      of tps-mail-rec                        00484100
472100                       recur-postage-amount   of tps-mail-rec                        00484200
472200                       recur-number-enclosures of tps-mail-rec                       00484300
472300                       recur-chart-acct-01    of tps-mail-rec                        00484400
472400                       recur-chart-acct-02    of tps-mail-rec                        00484500
472500                       recur-chart-acct-03    of tps-mail-rec                        00484600
472600                       recur-chart-acct-04    of tps-mail-rec                        00484700
472700                       recur-chart-acct-05    of tps-mail-rec                        00484800
472800                       recur-chart-acct-06    of tps-mail-rec                        00484900
472900                       recur-chart-acct-07    of tps-mail-rec                        00485000
473000                       recur-chart-acct-08    of tps-mail-rec.                       00485100
473100                                                                                     00485200
008100      initialize tps-memo-rec.                                                                                      
473100                                                                                     00485200
473200      move '0101001253'      to mail-acct-no of tps-mail-rec                                                        
473300                                recur-acct-no of tps-mail-rec                                                       
                                      tps-memo-acct-no.                                                                   
473400      move '00'                  to mail-sub-acct                                    00485500
473500                                    of tps-mail-rec                                  00485600
473600                                   recur-sub-acct                                    00485700
473700                                    of tps-mail-rec                                 00485800                        
                                         tps-memo-sub-acct.                                                               
468400      move '20070801'       to mail-receive-date of tps-mail-rec.                                                   
468500      move 00003          to mail-receive-number of tps-mail-rec.                                                   
000000      move spaces             to mail-admin-xxxxxx                                                                  
473900                                    of tps-mail-rec                                                                 
                                       recur-admin-logon                                                                  
473900                                    of tps-mail-rec.                                                                
      *08/27/04 move logrec-sign-on-short to mail-admin-xxxxxx                                                            
            move 'NYTHSCA '           to mail-admin-xxxxxx                                                                
473900                                    of tps-mail-rec(1:8)                                                            
                                       recur-admin-logon                                                                  
473900                                    of tps-mail-rec(1:8).    
474000      move '99'               to mail-disposition                                    00486100
474100                                    of tps-mail-rec                                  00486200
474200                                 recur-disposition                                   00486300
474300                                    of tps-mail-rec.                                 00486400
474400      move '99'               to mail-carrier-code                                   00486500
474500                                    of tps-mail-rec                                  00486600
474600                                 mail-postage-class                                  00486700
474700                                    of tps-mail-rec.                                 00486800
474800      move '19'               to mail-category-code                                  00486900
474900                                    of tps-mail-rec                                  00487000
475000                                 recur-category-code                                 00487100
475100                                    of tps-mail-rec                                  00487200
475200                                 recur-chart-acct-01                                 00487300
475300                                    of tps-mail-rec(1:2).                            00487400
477300                      
475400      move 'CITI CARDS'       to mail-addresor-name                                  00487500                       
475500                                    of tps-mail-rec                                  00487600
475600                                 recur-addresor-name                                 00487700
475700                                    of tps-mail-rec.                                 00487800
132500                                                                                                                    
475800      move 'Louise W. Lamphere' to mail-addresee-name                                  00487900                     
475900                                    of tps-mail-rec                                  00488000
476000                                 recur-addresee-name                                 00488100
476100                                    of tps-mail-rec.                                 00488200
       
476200      move 'y'                to mail-allow-duplicates                               00488300
476300                                    of tps-mail-rec.                                 00488400
023610                                                                                                                  
052000
023610
052000 build-receive-for-split-exit. exit.
052000
052000
000200 undo-split-flags.                                                                                                  
023810**************            #  1      ***************** 
023810    move '0101001261'                 to mail-acct-no.
023910    move '00'                         to mail-sub-acct.
024010    move '20080104'                   to mail-receive-date.
024110    move '00006'                      to mail-receive-number.
024210                                                                                                                  
024310    move f-prime to file-key.
024410    move f-read   to file-action.
024510    call tpsiorec using file-request tps-mail-rec.
024610    if not a-successful-operation
024710       move ' receive' to file-name
024810       move 'seemail-rd ' to file-text
024910       perform file-error thru file-error-exit
025010       go to seemail-common-exit
025110     end-if.
052000
027710    move 'N'                   to mail-split-record-flag.                                                           
024210                                                                                                                  
024310    move f-prime to file-key.
033610    move f-rewrite  to file-action.                                                                                 
024510    call tpsiorec using file-request tps-mail-rec.
024610    if not a-successful-operation
024710       move ' receive' to file-name
024810       move 'seemail-rew' to file-text
024910       perform file-error thru file-error-exit
025010       go to seemail-common-exit
025110     end-if.
052000
023810**************            #  2      ***************** 
023810    move '0101001261'                 to mail-acct-no.
023910    move '00'                         to mail-sub-acct.
024010    move '20080201'                   to mail-receive-date.
024110    move '00008'                      to mail-receive-number.
024210                                                                                                                  
024310    move f-prime to file-key.
024410    move f-read   to file-action.
024510    call tpsiorec using file-request tps-mail-rec.
024610    if not a-successful-operation
024710       move ' receive' to file-name
024810       move 'seemail-rd ' to file-text
024910       perform file-error thru file-error-exit
025010       go to seemail-common-exit
025110     end-if.
052000
027710    move 'N'                   to mail-split-record-flag.                                                           
024210                                                                                                                  
024310    move f-prime to file-key.
033610    move f-rewrite  to file-action.                                                                                 
024510    call tpsiorec using file-request tps-mail-rec.
024610    if not a-successful-operation
024710       move ' receive' to file-name
024810       move 'seemail-rew' to file-text
024910       perform file-error thru file-error-exit
025010       go to seemail-common-exit
025110     end-if.
052000
023810**************            #  3      ***************** 
023810    move '0101001261'                 to mail-acct-no.
023910    move '00'                         to mail-sub-acct.
024010    move '20080327'                   to mail-receive-date.
024110    move '00002'                      to mail-receive-number.
024210                                                                                                                  
024310    move f-prime to file-key.
024410    move f-read   to file-action.
024510    call tpsiorec using file-request tps-mail-rec.
024610    if not a-successful-operation
024710       move ' receive' to file-name
024810       move 'seemail-rd ' to file-text
024910       perform file-error thru file-error-exit
025010       go to seemail-common-exit
025110     end-if.
052000
027710    move 'N'                   to mail-split-record-flag.                                                           
024210                                                                                                                  
024310    move f-prime to file-key.
033610    move f-rewrite  to file-action.                                                                                 
024510    call tpsiorec using file-request tps-mail-rec.
024610    if not a-successful-operation
024710       move ' receive' to file-name
024810       move 'seemail-rew' to file-text
024910       perform file-error thru file-error-exit
025010       go to seemail-common-exit
025110     end-if.
052000
023810**************            #  4     *****************                                                                
023810    move '0101001261'                 to mail-acct-no.
023910    move '00'                         to mail-sub-acct.
024010    move '20080327'                   to mail-receive-date.
024110    move '00003'                      to mail-receive-number.
024210                                                                                                                  
024310    move f-prime to file-key.
024410    move f-read   to file-action.
024510    call tpsiorec using file-request tps-mail-rec.
024610    if not a-successful-operation
024710       move ' receive' to file-name
024810       move 'seemail-rd ' to file-text
024910       perform file-error thru file-error-exit
025010       go to seemail-common-exit
025110     end-if.
052000
027710    move 'N'                   to mail-split-record-flag.                                                           
024210                                                                                                                  
024310    move f-prime to file-key.
033610    move f-rewrite  to file-action.                                                                                 
024510    call tpsiorec using file-request tps-mail-rec.
024610    if not a-successful-operation
024710       move ' receive' to file-name
024810       move 'seemail-rew' to file-text
024910       perform file-error thru file-error-exit
025010       go to seemail-common-exit
025110     end-if.
023810**************            #  5      ***************** 
023810    move '0101001261'                 to mail-acct-no.
023910    move '00'                         to mail-sub-acct.
024010    move '20080407'                   to mail-receive-date.
024110    move '00010'                      to mail-receive-number.
024210                                                                                                                  
024310    move f-prime to file-key.
024410    move f-read   to file-action.
024510    call tpsiorec using file-request tps-mail-rec.
024610    if not a-successful-operation
024710       move ' receive' to file-name
024810       move 'seemail-rd ' to file-text
024910       perform file-error thru file-error-exit
025010       go to seemail-common-exit
025110     end-if.
052000
027710    move 'N'                   to mail-split-record-flag.                                                           
024210                                                                                                                  
024310    move f-prime to file-key.
033610    move f-rewrite  to file-action.                                                                                 
024510    call tpsiorec using file-request tps-mail-rec.
024610    if not a-successful-operation
024710       move ' receive' to file-name
024810       move 'seemail-rew' to file-text
024910       perform file-error thru file-error-exit
025010       go to seemail-common-exit
025110     end-if.
052000
023810**************            #  6      ***************** 
023810    move '0101001261'                 to mail-acct-no.
023910    move '00'                         to mail-sub-acct.
024010    move '20080407'                   to mail-receive-date.
024110    move '00011'                      to mail-receive-number.
024210                                                                                                                  
024310    move f-prime to file-key.
024410    move f-read   to file-action.
024510    call tpsiorec using file-request tps-mail-rec.
024610    if not a-successful-operation
024710       move ' receive' to file-name
024810       move 'seemail-rd ' to file-text
024910       perform file-error thru file-error-exit
025010       go to seemail-common-exit
025110     end-if.
052000
027710    move 'N'                   to mail-split-record-flag.                                                           
024210                                                                                                                  
024310    move f-prime to file-key.
033610    move f-rewrite  to file-action.                                                                                 
024510    call tpsiorec using file-request tps-mail-rec.
024610    if not a-successful-operation
024710       move ' receive' to file-name
024810       move 'seemail-rew' to file-text
024910       perform file-error thru file-error-exit
025010       go to seemail-common-exit
025110     end-if.
052000
023810**************            #  7      ***************** 
023810    move '0101001261'                 to mail-acct-no.
023910    move '00'                         to mail-sub-acct.
024010    move '20080502'                   to mail-receive-date.
024110    move '00007'                      to mail-receive-number.
024210                                                                                                                  
024310    move f-prime to file-key.
024410    move f-read   to file-action.
024510    call tpsiorec using file-request tps-mail-rec.
024610    if not a-successful-operation
024710       move ' receive' to file-name
024810       move 'seemail-rd ' to file-text
024910       perform file-error thru file-error-exit
025010       go to seemail-common-exit
025110     end-if.
052000
027710    move 'N'                   to mail-split-record-flag.                                                           
024210                                                                                                                  
024310    move f-prime to file-key.
033610    move f-rewrite  to file-action.                                                                                 
024510    call tpsiorec using file-request tps-mail-rec.
024610    if not a-successful-operation
024710       move ' receive' to file-name
024810       move 'seemail-rew' to file-text
024910       perform file-error thru file-error-exit
025010       go to seemail-common-exit
025110     end-if.
052000
023810**************            #  8     *****************                                                                
023810    move '0101001261'                 to mail-acct-no.
023910    move '00'                         to mail-sub-acct.
024010    move '20080605'                   to mail-receive-date.
024110    move '00002'                      to mail-receive-number.
024210                                                                                                                  
024310    move f-prime to file-key.
024410    move f-read   to file-action.
024510    call tpsiorec using file-request tps-mail-rec.
024610    if not a-successful-operation
024710       move ' receive' to file-name
024810       move 'seemail-rd ' to file-text
024910       perform file-error thru file-error-exit
025010       go to seemail-common-exit
025110     end-if.
052000
027710    move 'N'                   to mail-split-record-flag.                                                           
024210                                                                                                                  
024310    move f-prime to file-key.
033610    move f-rewrite  to file-action.                                                                                 
024510    call tpsiorec using file-request tps-mail-rec.
024610    if not a-successful-operation
024710       move ' receive' to file-name
024810       move 'seemail-rew' to file-text
024910       perform file-error thru file-error-exit
025010       go to seemail-common-exit
025110     end-if.
023810**************            #  9      ***************** 
023810    move '0101001261'                 to mail-acct-no.
023910    move '00'                         to mail-sub-acct.
024010    move '20080609'                   to mail-receive-date.
024110    move '00004'                      to mail-receive-number.
024210                                                                                                                  
024310    move f-prime to file-key.
024410    move f-read   to file-action.
024510    call tpsiorec using file-request tps-mail-rec.
024610    if not a-successful-operation
024710       move ' receive' to file-name
024810       move 'seemail-rd ' to file-text
024910       perform file-error thru file-error-exit
025010       go to seemail-common-exit
025110     end-if.
052000
027710    move 'N'                   to mail-split-record-flag.                                                           
024210                                                                                                                  
024310    move f-prime to file-key.
033610    move f-rewrite  to file-action.                                                                                 
024510    call tpsiorec using file-request tps-mail-rec.
024610    if not a-successful-operation
024710       move ' receive' to file-name
024810       move 'seemail-rew' to file-text
024910       perform file-error thru file-error-exit
025010       go to seemail-common-exit
025110     end-if.
052000
023810**************            # 10      ***************** 
023810    move '0101001261'                 to mail-acct-no.
023910    move '00'                         to mail-sub-acct.
024010    move '20080724'                   to mail-receive-date.
024110    move '00001'                      to mail-receive-number.
024210                                                                                                                  
024310    move f-prime to file-key.
024410    move f-read   to file-action.
024510    call tpsiorec using file-request tps-mail-rec.
024610    if not a-successful-operation
024710       move ' receive' to file-name
024810       move 'seemail-rd ' to file-text
024910       perform file-error thru file-error-exit
025010       go to seemail-common-exit
025110     end-if.
052000
027710    move 'N'                   to mail-split-record-flag.                                                           
024210                                                                                                                  
024310    move f-prime to file-key.
033610    move f-rewrite  to file-action.                                                                                 
024510    call tpsiorec using file-request tps-mail-rec.
024610    if not a-successful-operation
024710       move ' receive' to file-name
024810       move 'seemail-rew' to file-text
024910       perform file-error thru file-error-exit
025010       go to seemail-common-exit
025110     end-if.
052000
023810**************            # 11      ***************** 
023810    move '0101001261'                 to mail-acct-no.
023910    move '00'                         to mail-sub-acct.
024010    move '20080725'                   to mail-receive-date.
024110    move '00007'                      to mail-receive-number.
024210                                                                                                                  
024310    move f-prime to file-key.
024410    move f-read   to file-action.
024510    call tpsiorec using file-request tps-mail-rec.
024610    if not a-successful-operation
024710       move ' receive' to file-name
024810       move 'seemail-rd ' to file-text
024910       perform file-error thru file-error-exit
025010       go to seemail-common-exit
025110     end-if.
052000
027710    move 'N'                   to mail-split-record-flag.                                                           
024210                                                                                                                  
024310    move f-prime to file-key.
033610    move f-rewrite  to file-action.                                                                                 
024510    call tpsiorec using file-request tps-mail-rec.
024610    if not a-successful-operation
024710       move ' receive' to file-name
024810       move 'seemail-rew' to file-text
024910       perform file-error thru file-error-exit
025010       go to seemail-common-exit
025110     end-if.
052000
023810**************            # 12     *****************                                                                
023810    move '0101001261'                 to mail-acct-no.
023910    move '00'                         to mail-sub-acct.
024010    move '20080801'                   to mail-receive-date.
024110    move '00001'                      to mail-receive-number.
024210                                                                                                                  
024310    move f-prime to file-key.
024410    move f-read   to file-action.
024510    call tpsiorec using file-request tps-mail-rec.
024610    if not a-successful-operation
024710       move ' receive' to file-name
024810       move 'seemail-rd ' to file-text
024910       perform file-error thru file-error-exit
025010       go to seemail-common-exit
025110     end-if.
052000
027710    move 'N'                   to mail-split-record-flag.                                                           
024210                                                                                                                  
024310    move f-prime to file-key.
033610    move f-rewrite  to file-action.                                                                                 
024510    call tpsiorec using file-request tps-mail-rec.
024610    if not a-successful-operation
024710       move ' receive' to file-name
024810       move 'seemail-rew' to file-text
024910       perform file-error thru file-error-exit
025010       go to seemail-common-exit
025110     end-if.
000200 undo-split-flags-exit. exit.                                                                                       
052000
052000
000200 undo-split-flags-2.                                                                                                
023810**************            #  1      ***************** 
023810    move '0101001261'                 to mail-acct-no.
023910    move '00'                         to mail-sub-acct.
024010    move '20080201'                   to mail-receive-date.
024110    move '00002'                      to mail-receive-number.
024210                                                                                                                  
024310    move f-prime to file-key.
024410    move f-read   to file-action.
024510    call tpsiorec using file-request tps-mail-rec.
024610    if not a-successful-operation
024710       move ' receive' to file-name
024810       move 'seemail-rd ' to file-text
024910       perform file-error thru file-error-exit
025010       go to seemail-common-exit
025110     end-if.
052000
023810**************            #  2      ***************** 
023810    move '0101001261'                 to mail-acct-no.
023910    move '00'                         to mail-sub-acct.
024010    move '20080407'                   to mail-receive-date.
024110    move '00010'                      to mail-receive-number.
024210                                                                                                                  
024310    move f-prime to file-key.
024410    move f-read   to file-action.
024510    call tpsiorec using file-request tps-mail-rec.
024610    if not a-successful-operation
024710       move ' receive' to file-name
024810       move 'seemail-rd ' to file-text
024910       perform file-error thru file-error-exit
025010       go to seemail-common-exit
025110     end-if.
052000
024210                                                                                                                  
024310    move f-prime to file-key.
033610    move f-rewrite  to file-action.                                                                                 
024510    call tpsiorec using file-request tps-mail-rec.
024610    if not a-successful-operation
024710       move ' receive' to file-name
024810       move 'seemail-rew' to file-text
024910       perform file-error thru file-error-exit
025010       go to seemail-common-exit
025110     end-if.
052000
023810**************            #  3      ***************** 
023810    move '0101001261'                 to mail-acct-no.
023910    move '00'                         to mail-sub-acct.
024010    move '20080521'                   to mail-receive-date.
024110    move '00046'                      to mail-receive-number.
024210                                                                                                                  
024310    move f-prime to file-key.
024410    move f-read   to file-action.
024510    call tpsiorec using file-request tps-mail-rec.
024610    if not a-successful-operation
024710       move ' receive' to file-name
024810       move 'seemail-rd ' to file-text
024910       perform file-error thru file-error-exit
025010       go to seemail-common-exit
025110     end-if.
052000
024210                                                                                                                  
024310    move f-prime to file-key.
033610    move f-rewrite  to file-action.                                                                                 
024510    call tpsiorec using file-request tps-mail-rec.
024610    if not a-successful-operation
024710       move ' receive' to file-name
024810       move 'seemail-rew' to file-text
024910       perform file-error thru file-error-exit
025010       go to seemail-common-exit
025110     end-if.
052000
023810**************            #  4     *****************                                                                
023810    move '0101001261'                 to mail-acct-no.
023910    move '00'                         to mail-sub-acct.
024010    move '20080521'                   to mail-receive-date.
024110    move '00047'                      to mail-receive-number.
024210                                                                                                                  
024310    move f-prime to file-key.
024410    move f-read   to file-action.
024510    call tpsiorec using file-request tps-mail-rec.
024610    if not a-successful-operation
024710       move ' receive' to file-name
024810       move 'seemail-rd ' to file-text
024910       perform file-error thru file-error-exit
025010       go to seemail-common-exit
025110     end-if.
052000
024210                                                                                                                  
024310    move f-prime to file-key.
033610    move f-rewrite  to file-action.                                                                                 
024510    call tpsiorec using file-request tps-mail-rec.
024610    if not a-successful-operation
024710       move ' receive' to file-name
024810       move 'seemail-rew' to file-text
024910       perform file-error thru file-error-exit
025010       go to seemail-common-exit
025110     end-if.
023810**************            #  5      ***************** 
023810    move '0101001261'                 to mail-acct-no.
023910    move '00'                         to mail-sub-acct.
024010    move '20080521'                   to mail-receive-date.
024110    move '00048'                      to mail-receive-number.
024210                                                                                                                  
024310    move f-prime to file-key.
024410    move f-read   to file-action.
024510    call tpsiorec using file-request tps-mail-rec.
024610    if not a-successful-operation
024710       move ' receive' to file-name
024810       move 'seemail-rd ' to file-text
024910       perform file-error thru file-error-exit
025010       go to seemail-common-exit
025110     end-if.
052000
024210                                                                                                                  
024310    move f-prime to file-key.
033610    move f-rewrite  to file-action.                                                                                 
024510    call tpsiorec using file-request tps-mail-rec.
024610    if not a-successful-operation
024710       move ' receive' to file-name
024810       move 'seemail-rew' to file-text
024910       perform file-error thru file-error-exit
025010       go to seemail-common-exit
025110     end-if.
052000
000200 undo-split-flags-2-exit. exit.                                                                                     
052000
052000
000200 reset-split-flags.                                                                                                 
023810**************            #  1      ***************** 
023810    move '0101001261'                 to mail-acct-no.
023910    move '00'                         to mail-sub-acct.
024010    move '20080407'                   to mail-receive-date.
024110    move '00011'                      to mail-receive-number.
024210                                                                                                                  
024310    move f-prime to file-key.
024410    move f-read   to file-action.
024510    call tpsiorec using file-request tps-mail-rec.
024610    if not a-successful-operation
024710       move ' receive' to file-name
024810       move 'seemail-rd ' to file-text
024910       perform file-error thru file-error-exit
025010       go to seemail-common-exit
025110     end-if.
052000
024210                                                                                                                  
024310    move f-prime to file-key.
033610    move f-rewrite  to file-action.                                                                                 
024510    call tpsiorec using file-request tps-mail-rec.
024610    if not a-successful-operation
024710       move ' receive' to file-name
024810       move 'seemail-rew' to file-text
024910       perform file-error thru file-error-exit
025010       go to seemail-common-exit
025110     end-if.
052000
023810**************            #  2      ***************** 
023810    move '0101001261'                 to mail-acct-no.
023910    move '00'                         to mail-sub-acct.
024010    move '20080605'                   to mail-receive-date.
024110    move '00002'                      to mail-receive-number.
024210                                                                                                                  
024310    move f-prime to file-key.
024410    move f-read   to file-action.
024510    call tpsiorec using file-request tps-mail-rec.
024610    if not a-successful-operation
024710       move ' receive' to file-name
024810       move 'seemail-rd ' to file-text
024910       perform file-error thru file-error-exit
025010       go to seemail-common-exit
025110     end-if.
052000
024210                                                                                                                  
024310    move f-prime to file-key.
033610    move f-rewrite  to file-action.                                                                                 
024510    call tpsiorec using file-request tps-mail-rec.
024610    if not a-successful-operation
024710       move ' receive' to file-name
024810       move 'seemail-rew' to file-text
024910       perform file-error thru file-error-exit
025010       go to seemail-common-exit
025110     end-if.
052000
000200 reset-split-flags-exit. exit.                                                                                      
052000
052000
052000
000200 recode-bill-recs.                                                                                                  
018200    MOVE LOW-VALUES TO MAIL-KEY OF TPS-MAIL-REC.
026924    move '0107000044002011070100001' to mail-key.
021300    MOVE F-PRIME TO FILE-KEY.
021400    MOVE F-START TO FILE-ACTION.
021500    CALL TPSIOREC USING FILE-REQUEST TPS-MAIL-REC.
021600    IF NO-RECORD-WAS-FOUND GO TO READ-THE-MAIL-EXIT.
021700    IF NOT A-SUCCESSFUL-OPERATION
021800       MOVE ' RECEIVE' TO FILE-NAME
021900       MOVE 'SEEMAIL-SBR' TO FILE-TEXT
022000       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
022100       GO TO SEEMAIL-COMMON-EXIT.
                                                                                                                                    
         
000200 recode-all-bill-recs.                                                                                                        
         
022300    MOVE F-PRIME TO FILE-KEY.
022400    MOVE F-READ-NEXT TO FILE-ACTION.
022500    CALL TPSIOREC USING FILE-REQUEST TPS-MAIL-REC.
022600    IF END-OF-FILE-WAS-REACHED
022700       GO TO READ-THE-MAIL-EXIT
022800     END-IF.
022900
023000    IF NOT A-SUCCESSFUL-OPERATION
023100       MOVE ' RECEIVE' TO FILE-NAME
023200       MOVE 'SEEMAIL-BRN' TO FILE-TEXT
023300       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
023400       GO TO SEEMAIL-COMMON-EXIT
023500     END-IF.
023610                                                                                                                  
026924    if mail-acct-no not = '0107000044'
000200       go to recode-bill-recs-exit                                                                                            
         
026886     end-if.                                                                                                                  
         
         
024210                                                                                                                  
024310    move f-prime to file-key.
033610    move f-rewrite  to file-action.                                                                                 
024510    call tpsiorec using file-request tps-mail-rec.
024610    if not a-successful-operation
024710       move ' receive' to file-name
024810       move 'seemail-rew' to file-text
024910       perform file-error thru file-error-exit
025010       go to seemail-common-exit
025110     end-if.
000200    go to recode-all-bill-recs.                                                                                               
         
                     
000200 recode-bill-recs-exit. exit.                                                                                                 
         
                     
052000
052000
       repair-chart-of-acct.                                                                                                        
         
018200    MOVE LOW-VALUES TO MAIL-KEY OF TPS-MAIL-REC.
026886    move '0107000044'                 to mail-acct-no.                                                            
026880    move '00'                         to mail-sub-acct.                                                           
026880    move '20110817'                   to mail-receive-date.                                                       
026886    move '00005'                      to mail-receive-number.                                                     
022300    MOVE F-PRIME TO FILE-KEY.
022400    MOVE F-READ  TO FILE-ACTION.                                                                                              
         
                     
022500    CALL TPSIOREC USING FILE-REQUEST TPS-MAIL-REC.
023000    IF NOT A-SUCCESSFUL-OPERATION
023100       MOVE ' RECEIVE' TO FILE-NAME
023200       MOVE 'SEEMAIL-BRN' TO FILE-TEXT
023300       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
023400       GO TO SEEMAIL-COMMON-EXIT
023500     END-IF.
023610                                                                                                                  
         
024210                                                                                                                  
024310    move f-prime to file-key.
033610    move f-rewrite  to file-action.
024510    call tpsiorec using file-request tps-mail-rec.
024610    if not a-successful-operation
024710       move ' receive' to file-name
024810       move 'seemail-rew' to file-text
024910       perform file-error thru file-error-exit
025010       go to seemail-common-exit
025110     end-if.
052000
       repair-chart-of-acct-exit. exit.                                                                                             
         
                     
052000
052000
