000100 IDENTIFICATION DIVISION.
000200 PROGRAM-ID. SEERECUR.
000300 AUTHOR. JOHN CURRAN.
000400***************************************************************
000500*    LIST OF RECURRING FILE.                                  *
000600***************************************************************
000700 ENVIRONMENT DIVISION.
000800 CONFIGURATION SECTION.
000900 SOURCE-COMPUTER. IBM-PS2.
001000 OBJECT-COMPUTER. IBM-PS2.
001100 FILE-CONTROL.
003700                                                                                     00000440
003200     SELECT  TPS-CONTRACT-FILE                                                       00000450
001300             ASSIGN TO "C:\TPS\APP\SEERECUR.MEN"
003500             ORGANIZATION IS LINE SEQUENTIAL                                         00000470
003600             FILE STATUS IS TPS-FILE-STATUS.                                         00000480
003700                                                                                     00000440
001200**** SELECT PRT-FILE  ASSIGN TO EXTERNAL LISTFILE                 00001000
001300     SELECT PRT-FILE  ASSIGN TO "C:\TPS\APP\SEERECUR.TXT"
001400         ORGANIZATION IS LINE SEQUENTIAL                          00001100
001500         FILE STATUS IS TPS-FILE-STATUS.
003700                                                                                     00000490
003800 DATA DIVISION.                                                                      00000690
003900 FILE SECTION.                                                                       00000700
007800 FD  TPS-CONTRACT-FILE                                                               00000710
007900     DATA RECORD  IS TPS-CONTRACT-INPUT                                              00000720
008000     LABEL RECORDS STANDARD.                                                         00000730
008100 01  TPS-CONTRACT-INPUT.                                                             00000740
008200     05  TPS-payee-name                 PIC  X(36).                                  00000750
003500     05  FILLER                         PIC  X.                                                                   
003400     05  TPS-CYCLE                      PIC  X(15).                                                               
003500     05  FILLER                         PIC  X.                                                                   
008200     05  TPS-account-no                 PIC  X(10).                                  00000770
003500     05  FILLER                         PIC  X.                                                                   
008200     05  TPS-payee-account-no           PIC  X(20).                                  00000770
008900     05  FILLER                         PIC  X(34).                                  00000860                     
                                                                                           00000870
001800 FD  PRT-FILE                                                     00001600
001900     LABEL RECORDS ARE OMITTED                                    00001700
002000     RECORD CONTAINS 090 CHARACTERS.                              00001800
002100 01  PRT-RECORD.
002200     10 PRT-ACCT-NO        PIC X(10).                                                                               
002700     10 FILLER             PIC X(02).
002800     10 PRT-ACCOUNT-NUMBER PIC X(20).
002900     10 FILLER             PIC X.
002600     10 PRT-PAYEE-NAME     PIC X(36).                                                                               
002600***  10 PRT-PAYEE-NAME     PIC X(20).
002700     10 FILLER             PIC X(02).
           10 prt-ADDRESOR-CITY  pic x(24).                                                                                                           
002700     10 FILLER             PIC X(02).
002600     10 PRT-ADDRESEE-NAME  PIC X(36).
002700     10 filler             pic x.
005900     10 prt-cycle-event    pic 9(02).                                                                               
002700     10 FILLER             PIC X(02).
000000     10 prt-CYCLE-DATE     PIC 9(08).                                                                               
002700     10 FILLER             PIC X(01).
002900     10 prt-payee-memo-FIELD    pic  x(36).                                                                         
002900     10 FILLER             PIC X.
002600     10 prt-PAYEE-ADDRL1   pic x(36).
002700     10 filler             pic x.
002600     10 prt-PAYEE-ADDRL2   pic x(36).
002700     10 filler             pic x.
002600     10 prt-PAYEE-CITYSTATE pic x(36).
003500     10 FILLER             PIC X.
002200     10 PRT-PAYEE-ZIPCODE  PIC X(09).
002700     10 FILLER             PIC X(01).
003500*    10 FILLER             PIC X.
003200*    10 PRT-AMOUNT         PIC ZZZ,ZZZ.99.
003400*    10 PRT-CYCLE          PIC X(25).
003500*    10 FILLER             PIC X.
002200*    10 PRT-ACCT-NO        PIC X(10).
002200*    10 filler redefines PRT-ACCT-NO.
003200*       15 PRT-consol-amt  PIC zzz,zz9.
002700*       15 FILLER          PIC X(03).
002300*    10 FILLER             PIC X.
002600*    10 PRT-send-stub      PIC X(03).
002700     10 FILLER             PIC X(03).
002400*    10 PRT-SUB-ACCT       PIC X(02).
002500     10 FILLER             PIC X.
003000*    10 PRT-LO-LIMIT       PIC $,$$$,$$9.99.
003100*    10 FILLER             PIC X.
003200*    10 PRT-HI-LIMIT       PIC $,$$$,$$9.99.
003300*    10 FILLER             PIC X.
003600*****10 PRT-IMAGE-NUMBER   PIC X(08).
003700*****10 FILLER             PIC X(06).
003800*****10 FILLER             PIC X(100).
003900 WORKING-STORAGE SECTION.
004000     COPY "TPSFILES.CPY".
004100     COPY "KEYVALUE.CPY".
004110     COPY "PCLVALUE.CPY".
004110     COPY "PCL5VALU.CPY".
004200*01  TPS-MAIL-REC.
004300*    COPY "TPSMAIL.CPY".
004300                                                                                                                    
004400 01  sav-RECUR-REC                 pic  x(679).
004400 01  TPS-RECUR-REC.
004500     COPY "TPSRECUR.CPY".
004300                                                                                                                    
004400 01  tps-check-REC.
004500     COPY "TPScheck.CPY".
004300                                                                                                                    
004300                                                                                                                    
004300                                                                                                                    
004600 01  TPS2003d                      PIC X(08) VALUE 'TPS2003d'.
004600 01  TPSIORCR                      PIC X(08) VALUE 'TPSIORCR'.
004600 01  tpsiochk                      pic x(08) value 'tpsiochk'.
004610 01  FLOATBIG                      PIC X(08) VALUE 'FLOATBIG'.
004700 01  PROGRAM-NAMES.
004800  10 TPSIOERR    PIC X(08) VALUE 'TPSIOERR'.
004900  10 FILLER      PIC X(08) VALUE HIGH-VALUES.
005000 01  TPS-FILE-STATUS                       PIC XX.
005100     88  TPS-CARRIER-FILE-OK VALUE '00', '02'.
004400 01  EDIT-DATE            PIC 9(06).
005120
005130*
005140  01  BG-FLOAT-DATA.
005150      05  BG-FLOAT-PARMS              PIC  X(161).
005160      05  FILLER REDEFINES BG-FLOAT-PARMS.
005170          10  BG-FLOAT-COUNT          PIC  X(01).
005180          10  BG-FLOAT-1              PIC  X(40).
005190          10  BG-FLOAT-2              PIC  X(40).
005191          10  BG-FLOAT-2-R REDEFINES BG-FLOAT-2.
005192              15  BG-FLOAT-2-I        PIC  X(01) OCCURS 40 TIMES.
005193          10  BG-FLOAT-3              PIC  X(40).
005194          10  FILLER REDEFINES BG-FLOAT-3.
005195              15  BG-FLOAT-3-A        PIC  X(37).
005196              15  BG-FLOAT-3-B        PIC  X(03).
005197          10  BG-FLOAT-3-R REDEFINES BG-FLOAT-3.
005198              15  BG-FLOAT-3-I        PIC  X(01) OCCURS 40 TIMES.
005199          10  BG-FLOAT-4              PIC  X(40).
005200
005201
005202
005203
005204**   10 FILLER PIC X(XX) VALUE
005205**                      '123456789012345678901234567890123456'.
005206
005207 01  HEAD-01.
005208*    10 PRT-ACCT-NO        PIC X(10).
005209*    10 FILLER             PIC X.
005210*    10 PRT-SUB-ACCT       PIC X(02).
005211     10 FILLER PIC X(01) VALUE SPACES.
005212     10 FILLER PIC X(36) VALUE
005213                        '       PAYEE NAME                   '.
005215     10 FILLER PIC X(01) VALUE SPACES.
005217     10 FILLER PIC X(20) VALUE
005219                        ' PAYEE A/C NUMBER   '.
005220     10 FILLER PIC X(01) VALUE SPACES.
005221     10 FILLER PIC X(12) VALUE
005223                        '    LO-LIMIT'.
005224     10 FILLER PIC X(01) VALUE SPACES.
005225     10 FILLER PIC X(12) VALUE
005227                        '    HI-LIMIT'.
005228     10 FILLER PIC X(01) VALUE SPACES.
005229     10 FILLER PIC X(36) VALUE
005230                        '  PAYMENT CYCLE                     '.
005232     10 FILLER PIC X(01) VALUE SPACES.
005233*****10 PRT-IMAGE-NUMBER   PIC X(08).
005234*****10 FILLER             PIC X(06).
005235*****10 FILLER             PIC X(100).
005236
005237 01  MISC-WORKING-STORAGE.
005238      05  LINE-COUNT                  PIC  9(02) VALUE 41.
005239      05  FIRST-PAGE-FLAG             PIC  9(01) VALUE 0.
005240          88  FIRST-PAGE                         VALUE 0.
005241          88  NOT-FIRST-PAGE                     VALUE 1.
005242
011329 01  REC-COUNT                        PIC  9(06) VALUE 0.                                                         
011329 01  REC-MASK-LINE.                                                                                               
005229     10 FILLER PIC X(36) VALUE
005230                        '                 RECORDS PROCESSED -'.
011329     10 REC-MASK                      PIC  Z,ZZZ,ZZ9.                                                             
005243
011329 01  first-flat-rec-flag              pic  9(01) value 0.                                                         
011329     88 first-flat-rec                           value 0.                                                         
008200 01  active-stuff.                                                                                                
008200     05  active-payee-name            PIC  X(36) value spaces.                                                    
008200     05  active-cycle                 PIC  X(36) value spaces.                                                    
005243
008200 01  current-stuff.                                                                                               
008200     05  current-payee-name            PIC  X(36) value spaces.                                                   
008200     05  current-cycle                 PIC  X(36) value spaces.                                                   
005243
005243                                                                                                                  
011329*01  flat-file-flag                   PIC  9(01) VALUE 0.                                                         
011329*01  flat-file-flag                   PIC  9(01) VALUE 1.                                                         
011329*01  flat-file-flag                   PIC  9(01) VALUE 2.                                                         
011329*01  flat-file-flag                   PIC  9(01) VALUE 3.                                                         
011329*01  flat-file-flag                   PIC  9(01) VALUE 4.                                                         
011329 01  flat-file-flag                   PIC  9(01) VALUE 0.
011329     88  flat-file-consolidate                   value 1.                                                         
011329     88  split-bill-search                       value 2.                                                         
011329     88  add-stub-flag                           value 3.                                                         
011329     88  just-call-tps2003d                      value 4.                                                         
011329     88  pass-for-corrupt-record                 value 5.                                                         
005243                                                                                                                  
005243
005243
005250 LINKAGE SECTION.
005300 01 TPS-PARAMETER.
005400    05 TPS-PARAMETER-VALUE PIC XX.
005500
005600 PROCEDURE DIVISION USING
005700                          TPS-PARAMETER.
005800 SEERECUR-BEGIN.
005900    PERFORM OPEN-THE-FILES
006000       THRU OPEN-THE-FILES-EXIT.
005500
011329    if pass-for-corrupt-record                                                                                                                  
011329       perform read-for-corrupt-record thru                                                                                                     
011329               read-for-corrupt-record-exit                                                                                                     
006300       go to seerecur-common-exit                                                                                                               
011329     end-if.
005500
011329*   if flat-file-consolidate
011329*      go to file-consolidate
011329*    end-if.
005500
006100    PERFORM READ-THE-RECUR
006200       THRU READ-THE-RECUR-EXIT.
005500
011329    MOVE REC-COUNT               TO REC-MASK.                                                                     
015910    WRITE PRT-RECORD FROM REC-MASK-LINE.                                                                          
005230                                                                                                                  
006300 SEERECUR-COMMON-EXIT.
006400    PERFORM CLOSE-THE-FILES
006500       THRU CLOSE-THE-FILES-EXIT.
006600    GOBACK.                                                                                                       
006600    STOP RUN.
006700
006800 READ-THE-RECUR.
006900
          MOVE LOW-VALUES         TO RECUR-KEY.
007000*   MOVE '0101000024'       TO RECUR-ACCT-NO.
007000**  MOVE '0120000062'       TO RECUR-ACCT-NO.
007000**  MOVE '0101001873'       TO RECUR-ACCT-NO.
007100
007200****MOVE '19960101' TO MAIL-RECEIVE-DATE.
007300
007400    MOVE F-PRIME TO FILE-KEY.
007500    MOVE F-START TO FILE-ACTION.
007600    CALL TPSIORCR USING FILE-REQUEST TPS-RECUR-REC.
007700    IF NO-RECORD-WAS-FOUND GO TO READ-THE-RECUR-EXIT.
007800    IF NOT A-SUCCESSFUL-OPERATION
007900       MOVE ' RECURE' TO FILE-NAME
008000       MOVE 'SEERECUR-SBR' TO FILE-TEXT
008100       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
008200       GO TO SEERECUR-COMMON-EXIT.
008300 READ-ALL-RECUR-RECORDS.
008400    MOVE F-PRIME TO FILE-KEY.
008500    MOVE F-READ-NEXT TO FILE-ACTION.
008600    CALL TPSIORCR USING FILE-REQUEST TPS-RECUR-REC.
008700    IF END-OF-FILE-WAS-REACHED
011329*      if add-stub-flag
011329*         move '0'               to flat-file-flag
006800*         go to read-the-recur
008700*       end-if
008700       go to read-the-recur-exit
008700     end-if.
011329                                                                                                                    
008800    IF NOT A-SUCCESSFUL-OPERATION
008900       MOVE ' RECURE' TO FILE-NAME
009000       MOVE 'SEERECUR-BRN' TO FILE-TEXT
009100       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
009200       GO TO SEERECUR-COMMON-EXIT.
009300
011329    if just-call-tps2003d                                                                                           
000000       CALL TPS2003D                                                                 00228300                       
115600            USING TPS-check-rec                                                      00228400                       
115700                  TPS-check-rec                                                      00228500
115800                  TPS-check-rec                                                      00228600
115900                  tps-recur-rec                                                                                     
115900                  tps-recur-rec                                                                                     
116000                  recur-cycle-date
009200       GO TO SEERECUR-COMMON-EXIT                                                                                   
008700     end-if.
009300
009300
009300
009300
009300
009300
009400*   IF MAIL-RECEIVE-DATE IS NOT NUMERIC
009500*      MOVE ZEROS        TO MAIL-RECEIVE-DATE.
009600
009700*   IF MAIL-ACCT-NO IS NOT NUMERIC
009800*      MOVE ZEROS               TO mail-ACCT-NO
009900*                                  mail-SUB-ACCT
010000*                                  mail-RECEIVE-DATE
010100*                                  mail-RECEIVE-NUMBER
010200*                                  mail-AMOUNT-TO-PAY.
010300
010400****SELECTION CRITERIA.
010410
010420*   IF RECUR-ACCT-NO NOT = 0101000024
008700*      GO TO READ-THE-RECUR-EXIT.
010421*      GO TO READ-ALL-RECUR-RECORDS.
013150*   IF RECUR-CYCLE-EVENT(1:1) NOT = '2'
010600*      GO TO READ-ALL-RECUR-RECORDS.
012107*   IF RECUR-EXPIRE-DATE < 20030214
016000*      GO TO READ-ALL-RECUR-RECORDS.
010420*   IF RECUR-ADDRESOR-NAME(1:18) = 'NORTH FORK COUNTRY'
008700*      GO TO PRINT-RECORD
010421*   ELSE
010421*      GO TO READ-ALL-RECUR-RECORDS.
012111
012111*   if recur-postage-class = '04'                                                                                   
008700*      go to print-record
010421*     else                                                                                                          
010421*      go to read-all-recur-records                                                                                 
010421*    end-if.                                                                                                        
012111
012111
010500*   IF RECUR-CHART-ACCT-01(1:2) NOT = '02' and
010500*                                     '11' and
010500*                                     '31' and
010500*                                     '33'
010600*      GO TO READ-ALL-RECUR-RECORDS
011200*    END-IF.
010500*   IF RECUR-CHART-ACCT-02(1:6) NOT = '000019'
010600*      GO TO READ-ALL-RECUR-RECORDS
011200*     else                                                                                                          
012123*      go to PRINT-RECORD                                                                                           
011200*    END-IF.
011200                                                                                                                    
011200                                                                                                                    
011200*   if recur-bill-splitting not = 'Y' and                                                                           
011200*                                 'D' and                                                                           
011200*                                 'S'                                                                               
010600*      go to read-all-recur-records
011200*     else                                                                                                          
011200*      move 'N'     to recur-bill-splitting
007400*      move f-prime to file-key                                                                                     
007500*      move f-rewrite to file-action                                                                                
007600*      call tpsiorcr using file-request tps-recur-rec                                                               
007800*      if not a-successful-operation                                                                                
007900*         move ' recure' to file-name                                                                               
008000*         move 'seerecur-wr ' to file-text                                                                          
008100*         perform file-error thru file-error-exit                                                                   
008200*         go to seerecur-common-exit                                                                                
011200*       end-if                                                                                                      
007400*      move f-prime to file-key                                                                                     
007500*      move f-start to file-action                                                                                  
007600*      call tpsiorcr using file-request tps-recur-rec                                                               
007800*      if not a-successful-operation                                                                                
007900*         move ' recure' to file-name                                                                               
008000*         move 'seerecur-sbr' to file-text                                                                          
008100*         perform file-error thru file-error-exit                                                                   
008200*         go to seerecur-common-exit                                                                                
011200*       end-if                                                                                                      
008400*      move f-prime to file-key                                                                                     
008500*      move f-read-next to file-action                                                                              
008600*      call tpsiorcr using file-request tps-recur-rec                                                               
008700*      if end-of-file-was-reached                                                                                   
008700*         go to read-the-recur-exit                                                                                 
011200*       end-if                                                                                                      
008800*      if not a-successful-operation                                                                                
008900*         move ' recure' to file-name                                                                               
009000*         move 'seerecur-brn' to file-text                                                                          
009100*         perform file-error thru file-error-exit                                                                   
009200*         go to seerecur-common-exit                                                                                
011200*       end-if                                                                                                      
008700*      go to print-record
011200*    end-if.                                                                                                        
011200                                                                                                                    
011200                                                                                                                    
012200    if recur-payee-name(1:7) = 'Verizon' or 'VERIZON'
012123       go to PRINT-RECORD
011200      else
010600       GO TO READ-ALL-RECUR-RECORDS
011200     END-IF.
011200                                                                                                                  
      *   if RECUR-ADDRESOR-CITY(1:2) = 'BR' or 'Br'
012123*      go to PRINT-RECORD
011200*     else
010600*      GO TO READ-ALL-RECUR-RECORDS
011200*    END-IF.
011200                                                                                                                    
011200                                                                                                                    
012200*   if recur-payee-name(1:6) = 'Mystic' or 'MYSTIC'                                                                 
012200*                           or 'Mistic' or 'MISTIC'                                                                 
012200*                           or 'Mastic' or 'MASTIC'                                                                 
011200                                                                                                                    
012200*   if recur-payee-name(1:7) = 'Verizon' or                                                                         
012200*                              'VERIZON'                                                                            
012123*      go to PRINT-RECORD                                                                                           
011200*     else
012200*   if recur-payee-name(1:8) = 'New York'                                                                           
012123*      go to PRINT-RECORD                                                                                           
011200*     else
010600*      GO TO READ-ALL-RECUR-RECORDS
011200*     END-IF                                                                                                        
011200*    END-IF.
011200                                                                                                                  
011310
011310***********  utility  ?????????????
010500*   if recur-chart-acct-02(1:6) = '000011'                                                                          
010500*      if recur-chart-acct-03(1:6) = '110003'                                                                       
010500*         if recur-chart-acct-04(1:6) = '110210'                                                                    
010500*            if recur-chart-acct-05(1:4) = '1103'                                                                   
010600*               go to needs-a-stub                                                                                  
011200*             end-if                                                                                                
011200*          end-if                                                                                                   
011200*       end-if                                                                                                      
011200*    end-if.
011310
011310***********  utility  ?????????????
010500*   if recur-chart-acct-02(1:6) = '000011'                                                                          
010500*      if recur-chart-acct-03(1:6) = '110012'                                                                       
010500*         if recur-chart-acct-04(1:4) = '1103'                                                                      
010600*            go to needs-a-stub                                                                                     
011200*          end-if                                                                                                   
011200*       end-if                                                                                                      
011200*    end-if.
011310
011310***********  insurance ????????????
010500*   if recur-chart-acct-02(1:6) = '000007'                                                                          
010600*      go to needs-a-stub                                                                                           
011200*    end-if.
011310
011310***********  credit card  ?????????????                                                                             
010500*   if recur-chart-acct-02(1:6) = '000019'                                                                          
010500*      if recur-chart-acct-03(1:6) = '190002'                                                                       
010600*         go to needs-a-stub                                                                                        
011200*       end-if                                                                                                      
011200*    end-if.
011310
011310***********  credit card  ?????????????                                                                             
010500*   if recur-chart-acct-02(1:6) = '000019'                                                                          
010500*      if recur-chart-acct-03(1:6) = '190005'                                                                       
010600*         go to needs-a-stub                                                                                        
011200*       end-if                                                                                                      
011200*    end-if.
011310
013110    IF RECUR-CYCLE-EVENT(1:1) = '2'                                                                                 
007700       if RECUR-EXPIRE-DATE not < '20080930'                                                                        
012123          go to PRINT-RECORD                                                                                        
011200        end-if                                                                                                      
011200     end-if.                                                                                                        
011310
010600    GO TO READ-ALL-RECUR-RECORDS.
011310
011310
012123 PRINT-RECORD.

011500       MOVE RECUR-ACCT-NO        TO PRT-ACCT-NO.                                                                    
000000       move RECUR-CYCLE-DATE                                                                                        
000000                  to prt-CYCLE-DATE.                                                                                
005900       move recur-cycle-event                                                                                       
005900                  to prt-cycle-event.                                                                               
             move RECUR-ADDRESOR-CITY                                                                                                                 
                        to prt-ADDRESOR-CITY.                                                                                                         
012200       MOVE RECUR-ADDRESEE-NAME
012300                 TO PRT-ADDRESEE-NAME.
012200       MOVE RECUR-PAYEE-NAME
011310****   move RECUR-ADDRESOR-NAME                                                                                     
012300                 TO PRT-PAYEE-NAME.
012200       MOVE RECUR-PAYEE-ACCOUNT-NUMBER
012300                 TO PRT-ACCOUNT-NUMBER.
012452       move RECUR-PAYEE-ADDRL1
002900         to prt-payee-ADDRL1.
012452       move RECUR-PAYEE-ADDRL2
002900         to prt-payee-ADDRL2.
012452       move RECUR-PAYEE-CITYSTAT
002900         to prt-payee-CITYSTATE.
012452       move RECUR-PAYEE-ZIPCODE
002900         to prt-payee-ZIPCODE.
015910       WRITE PRT-RECORD.
011310
010600    GO TO READ-ALL-RECUR-RECORDS.
011310
011310
011310
010600 needs-a-stub.                                                                                                      
011329    if add-stub-flag                                                                                                
011310       go to code-ad-stub-needed
011200     end-if.
011310
011310
011310
013207**  IF RECUR-CYCLE-EVENT(2:1)  not = '4'    annual                                                                  
013110**  IF RECUR-CYCLE-EVENT(1:1) = '1'         scheduled                                                               
013110*   IF RECUR-CYCLE-EVENT(1:1) not = '1'                                                                             
008300*      GO TO READ-ALL-RECUR-RECORDS
011200*   END-IF.
011310
011329       ADD 1               TO REC-COUNT.
011311       MOVE SPACES TO PRT-RECORD.
011328
011329       IF LINE-COUNT > 20
011330          IF FIRST-PAGE
011331             MOVE '1'           TO FIRST-PAGE-FLAG
011333             WRITE PRT-RECORD FROM PCL-LANDSCAPE
011332           ELSE
011333             WRITE PRT-RECORD FROM PCL-EJECT-PAGE
011334           END-IF
011335          MOVE ZEROS             TO LINE-COUNT
011336*         WRITE PRT-RECORD FROM HEAD-01
011337*         MOVE SPACES TO PRT-RECORD
011338*         WRITE PRT-RECORD
011339       END-IF.
011340
011341       ADD 1                     TO LINE-COUNT.
011350
011700
010600 skip-page-numbering.                                                                                             
011500       MOVE RECUR-ACCT-NO        TO PRT-ACCT-NO.
011600***    MOVE RECUR-SUB-ACCT       TO PRT-SUB-ACCT.
011700*keep automatic only
013150*      IF RECUR-CYCLE-EVENT(1:1) not = '2'                                                                        
010600*         GO TO READ-ALL-RECUR-RECORDS                                                                            
011200*       END-IF.                                                                                                   
011700
011800*      MOVE RECUR-EXPIRE-DATE                                                                                     
002600*                     TO PRT-EXPIRE-DATE.                                                                         
011700
011700
011800       INSPECT RECUR-PAYEE-NAME REPLACING ALL X'00' BY X'20'.
012000       INSPECT RECUR-PAYEE-ACCOUNT-NUMBER
012100               REPLACING ALL X'00' BY X'20'.
012101
012102       IF RECUR-PRE-APPROVE-LOLIMIT NOT NUMERIC
012103          MOVE ZEROS     TO RECUR-PRE-APPROVE-LOLIMIT.
012107       IF RECUR-PRE-APPROVE-HILIMIT NOT NUMERIC
012108          MOVE ZEROS     TO RECUR-PRE-APPROVE-HILIMIT.
012111
012120*      IF RECUR-PAYEE-NAME(1:3) = 'TPS'
012121*         MOVE SPACES            TO PRT-PAYEE-NAME
012122*       END-IF.
012123
002600*      move '- -'                to PRT-send-stub.                                                                  
011310*      move RECUR-SEND-BILL-STUB to prt-send-stub(2:1).                                                             
012123
012130       MOVE RECUR-ACCT-NO        TO PRT-acct-NO.
012130****   MOVE RECUR-PAYEE-NAME                                                                                        
011310       move RECUR-ADDRESOR-NAME                                                                                     
012130            TO PRT-PAYEE-NAME.                                                                                      
012123
012130*      MOVE RECUR-CYCLE-EVENT    TO PRT-CYCLE.
012130*      MOVE RECUR-CYCLE-DATE     TO EDIT-DATE.
012130*      MOVE EDIT-DATE            TO PRT-CYCLE-DATE.
012130*      MOVE RECUR-CYCLE-AMOUNT   TO PRT-AMOUNT.
012123
012200       MOVE RECUR-PAYEE-ACCOUNT-NUMBER
012300                 TO PRT-ACCOUNT-NUMBER.
012452
012452       move RECUR-PAYEE-MEMO-FIELD                                                                                  
002900         to prt-payee-memo-FIELD.                                                                                   
002600                                                                                                                    
002600*      move recur-chart-acct-01(1:6)
002600*        to prt-chart-1.
002600*      move recur-chart-acct-02(1:6)
002600*        to prt-chart-2.
002600*      move recur-chart-acct-03(1:6)
002600*        to prt-chart-3.
012452
015910       WRITE PRT-RECORD.
012452
016000       GO TO READ-ALL-RECUR-RECORDS.
012452
012500*      MOVE RECUR-PRE-APPROVE-LOLIMIT  TO PRT-LO-LIMIT.
012600*      MOVE RECUR-PRE-APPROVE-HILIMIT  TO PRT-HI-LIMIT.
012700
012701       INSPECT RECUR-CYCLE-EVENT
012702               REPLACING ALL X'00' BY X'30'.
012703       INSPECT RECUR-CYCLE-EVENT
012704               REPLACING ALL X'20' BY X'30'.
015901
012800*      IF RECUR-CYCLE-EVENT(1:1) = '0'
016220*         MOVE '               '  TO PRT-CYCLE                                                                    
016230*       ELSE
016210*      IF RECUR-CYCLE-EVENT(2:1) = '0'                                                                            
016220*         MOVE 'Monthly        '  TO PRT-CYCLE                                                                    
016230*       ELSE
016210*      IF RECUR-CYCLE-EVENT(2:1) = '1'                                                                            
016220*         MOVE 'Bi-Monthly     '  TO PRT-CYCLE                                                                    
016230*       ELSE
016210*      IF RECUR-CYCLE-EVENT(2:1) = '2'                                                                            
016220*         MOVE 'Quarterly      '  TO PRT-CYCLE                                                                    
016230*       ELSE
016210*      IF RECUR-CYCLE-EVENT(2:1) = '3'                                                                            
016220*         MOVE 'Semi-Annual    '  TO PRT-CYCLE                                                                    
016230*       ELSE
016210*      IF RECUR-CYCLE-EVENT(2:1) = '4'                                                                            
016220*         MOVE 'Annual         '  TO PRT-CYCLE                                                                    
016230*       ELSE
016210*      IF RECUR-CYCLE-EVENT(2:1) = '5'                                                                            
016220*         MOVE 'Bi-Annual      '  TO PRT-CYCLE                                                                    
016230*       ELSE
016210*      IF RECUR-CYCLE-EVENT(2:1) = '6'                                                                            
016220*         MOVE 'Weekly         '  TO PRT-CYCLE                                                                    
016230*       ELSE
016210*      IF RECUR-CYCLE-EVENT(2:1) = '7'                                                                            
016220*         MOVE 'Bi-Weekly      '  TO PRT-CYCLE                                                                    
016230*       ELSE
016220*         MOVE '???????????????'  TO PRT-CYCLE                                                                    
016230*      end-if.
016210                                                                                                                  
015910*      WRITE PRT-RECORD.
016000*      GO TO READ-ALL-RECUR-RECORDS.
015901
015910***!!  END LOGIC
016000***!!  READ NEXT RECORD
012710
012800       IF RECUR-CYCLE-EVENT(1:1) = '0'
012900*****     MOVE '12345678901234567890'
013000          MOVE 'Occasional          '  TO BG-FLOAT-1
013100        ELSE
013110       IF RECUR-CYCLE-EVENT(1:1) = '1'
013130          MOVE 'Scheduled           '  TO BG-FLOAT-1
013140        ELSE
013150       IF RECUR-CYCLE-EVENT(1:1) = '2'
013160          MOVE 'Automatic           '  TO BG-FLOAT-1
013170        ELSE
013180          MOVE '??????              '  TO BG-FLOAT-1
013190         END-IF
013191        END-IF
013192       END-IF.
013193
013194       IF RECUR-CYCLE-EVENT(1:1) NOT = '0'
013195         IF RECUR-CYCLE-EVENT(2:1) = '0'
013196            MOVE 'Monthly             '  TO BG-FLOAT-3
013197          ELSE
013198         IF RECUR-CYCLE-EVENT(2:1) = '1'
013199            MOVE 'Bi-Monthly          '  TO BG-FLOAT-3
013200          ELSE
013201         IF RECUR-CYCLE-EVENT(2:1) = '2'
013202            MOVE 'Quarterly           '  TO BG-FLOAT-3
013203          ELSE
013204         IF RECUR-CYCLE-EVENT(2:1) = '3'
013205            MOVE 'Semi-Annual         '  TO BG-FLOAT-3
013206          ELSE
013207         IF RECUR-CYCLE-EVENT(2:1) = '4'
013208            MOVE 'Annual              '  TO BG-FLOAT-3
013209          ELSE
013210         IF RECUR-CYCLE-EVENT(2:1) = '5'
013211            MOVE 'Bi-Annual           '  TO BG-FLOAT-3
013212          ELSE
013213           MOVE '?????????           '  TO BG-FLOAT-3
013214             END-IF
013215            END-IF
013216           END-IF
013217          END-IF
013218         END-IF
013219        END-IF
013220       END-IF.
015831
015833       MOVE '/'                   TO BG-FLOAT-2.
015837       MOVE '3'                   TO BG-FLOAT-COUNT.
015841        CALL FLOATBIG USING BG-FLOAT-DATA.
015843*      MOVE BG-FLOAT-1 (1:36)     TO PRT-CYCLE.
015901
015910       WRITE PRT-RECORD.
016000       GO TO READ-ALL-RECUR-RECORDS.
016100 READ-THE-RECUR-EXIT. EXIT.
016200
016308
016309
016310
016400
016500 FILE-ERROR.
016600     CALL TPSIOERR USING FILE-REQUEST.
016700     CANCEL TPSIOERR.
016800 FILE-ERROR-EXIT. EXIT.
016900
017000
017100 OPEN-THE-FILES.
017200    OPEN OUTPUT PRT-FILE.
017210    WRITE PRT-RECORD FROM PCL5-LANDSCAPE.
017300    MOVE F-PRIME    TO FILE-KEY.
017400    MOVE F-OPEN-I-o TO FILE-ACTION.                                                                                 
017500    CALL TPSIORCR USING FILE-REQUEST TPS-RECUR-REC.
017600    IF FILE-STATUS NOT = '00' AND '05'
017700       MOVE 'RECURE ' TO FILE-NAME
017800       MOVE 'SEERECUR-ORC' TO FILE-TEXT
017900       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
018000       GO TO SEERECUR-COMMON-EXIT.
017300    MOVE F-PRIME    TO FILE-KEY.
017400    MOVE F-OPEN-I-o TO FILE-ACTION.                                                                                 
017500    CALL TPSIOchk USING FILE-REQUEST TPS-check-REC.
017600    IF FILE-STATUS NOT = '00' AND '05'
017700       MOVE 'RECURE ' TO FILE-NAME
017800       MOVE 'SEERECUR-ORC' TO FILE-TEXT
017900       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
018000       GO TO SEERECUR-COMMON-EXIT.
018100 OPEN-THE-FILES-EXIT. EXIT.
017000
018200 CLOSE-THE-FILES.
018300    CLOSE PRT-FILE.
018400      MOVE F-PRIME TO FILE-KEY.
018500      MOVE F-CLOSE TO FILE-ACTION.
018600
018700      CALL TPSIORCR USING FILE-REQUEST TPS-RECUR-REC.
018800      IF NOT A-SUCCESSFUL-OPERATION
018900         MOVE 'RECURE ' TO FILE-NAME
019000         MOVE 'SEERECUR-CCK' TO FILE-TEXT
019100         PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
019200      END-IF.
019300
019400 CLOSE-THE-FILES-EXIT. EXIT.
019500*----------------------------------------------------
019600*----------------------------------------------------
019700*----------------------------------------------------
019800*----------------------------------------------------
019900
011329 file-consolidate.                                                                                                
300500      OPEN  INPUT  TPS-CONTRACT-FILE.                                                  00010890                   
011311      MOVE SPACES             TO PRT-RECORD.                                                                      
300600 read-the-file.                                                                                     00010900      
300900      READ TPS-CONTRACT-FILE                                                         00010930
301000           AT END GO TO TPS-CONTRACT-EXIT1                                           00010940
301100      END-READ.                                                                       00010950                    
008200      if TPS-payee-name = spaces                                                                                  
               go to read-the-file                                                                                      
             end-if.                                                                                                    
                                                                                                                        
011329      if first-flat-rec                                                                                           
011329         move '1'             to first-flat-rec-flag                                                              
008200         move TPS-payee-name  to active-payee-name                                                                
003400         MOVE TPS-CYCLE       to active-cycle                                                                     
011329         move zeros           to REC-COUNT                                                                        
011329         add 1                to REC-COUNT                                                                        
               go to read-the-file                                                                                      
             end-if.                                                                                                    
                                                                                                                        
008200      move TPS-payee-name     to current-payee-name.                                                              
003400      MOVE TPS-CYCLE          to current-cycle.                                                                   
                                                                                                                        
008200      if current-stuff = active-stuff                                                                             
011329         add 1                to REC-COUNT                                                                        
               go to read-the-file                                                                                      
             end-if.                                                                                                    
                                                                                                                        
008200*     move active-payee-name  to prt-payee-name.
003400*     MOVE active-cycle       to prt-CYCLE.
003200*     move rec-count          to PRT-consol-amt.
015910*     WRITE PRT-RECORD.
011311*     MOVE SPACES             TO PRT-RECORD.
                                                                                                                        
008200*     move TPS-payee-name  to active-payee-name.
003400*     MOVE TPS-CYCLE       to active-cycle.
011329*     move zeros           to REC-COUNT.
011329*     add 1                to REC-COUNT.
      *     go to read-the-file.
002600                                                                                                                  
301600                                                                                     00011320
301700 TPS-CONTRACT-EXIT1.                                                                 00011330
301800*    CLOSE TPS-CONTRACT-FILE.                                                        00011340
008200*     move active-payee-name  to prt-payee-name.
003400*     MOVE active-cycle       to prt-CYCLE.
003200*     move rec-count          to PRT-consol-amt.
015910*     WRITE PRT-RECORD.
011311*     MOVE SPACES             TO PRT-RECORD.
006300*     go to SEERECUR-COMMON-EXIT.
                                                                                                                        
301900                                                                                     00011350
078100                                                                                     00118900
011310 code-ad-stub-needed.
011310    if RECUR-SEND-BILL-STUB = 'Y'                                                                                   
008300       go to READ-ALL-RECUR-RECORDS                                                                                 
078100     end-if.                                                                                00118900                
078100                                                                                     00118900
011310    move 'Y'               to RECUR-SEND-BILL-STUB.                                                                 
007400    move f-prime to file-key.
007500    move f-rewrite to file-action.                                                                                  
007600    call tpsiorcr using file-request tps-recur-rec.
007800    if not a-successful-operation
007900       move ' recure' to file-name
008000       move 'seerecur-wr ' to file-text
008100       perform file-error thru file-error-exit
008200       go to seerecur-common-exit.
078100                                                                                     00118900
007300
007400    move f-prime to file-key.
007500    move f-start to file-action.
007600    call tpsiorcr using file-request tps-recur-rec.
007800    if not a-successful-operation
007900       move ' recure' to file-name
008000       move 'seerecur-sbr' to file-text
008100       perform file-error thru file-error-exit
008200       go to seerecur-common-exit.
078100                                                                                     00118900
008400    move f-prime to file-key.
008500    move f-read-next to file-action.
008600    call tpsiorcr using file-request tps-recur-rec.
008700    if end-of-file-was-reached go to read-the-recur-exit.
008800    if not a-successful-operation
008900       move ' recure' to file-name
009000       move 'seerecur-brn' to file-text
009100       perform file-error thru file-error-exit
009200       go to seerecur-common-exit.
009300
008300    go to READ-ALL-RECUR-RECORDS.                                                                                   
009300
009300
009300
009300
004400*01  sav-RECUR-REC                 pic  x(679).
004400*01  TPS-RECUR-REC.
028300
011329 read-for-corrupt-record.                                                                                                                       
007600    initialize tps-recur-rec.                                                                                                                   
007400    move f-prime to file-key.
007500    move f-start to file-action.
007600    call tpsiorcr using file-request tps-recur-rec.
007700*   if no-record-was-found go to read-the-recur-exit.
007800    if not a-successful-operation
007900       move ' recure' to file-name
008000       move 'seerecur-sbr' to file-text
008100       perform file-error thru file-error-exit
008200       go to seerecur-common-exit.
008300 search-all-corrupt-record.                                                                                                                     
008400    move f-prime to file-key.
008500    move f-read-next to file-action.
008600    call tpsiorcr using file-request tps-recur-rec.
008700    if end-of-file-was-reached
011329       go to read-for-corrupt-record-exit                                                                                                       
008700     end-if.
008800    if not a-successful-operation
008900       move ' recure' to file-name
009000       move 'seerecur-brn' to file-text
009100       perform file-error thru file-error-exit
009200       go to seerecur-common-exit                                                                                                               
008700     end-if.
008300    go to search-all-corrupt-record.                                                                                                            
009300
011329 read-for-corrupt-record-exit. exit.                                                                                                            
049000
049100
