000384 IDENTIFICATION DIVISION.
000385 PROGRAM-ID. SEEPAMON.
000390 AUTHOR. T S.
000400***************************************************************
000500*    LIST OF PA MONITOR DATABASE                              *
000600***************************************************************
000700 ENVIRONMENT DIVISION.
000800 CONFIGURATION SECTION.
000900 SOURCE-COMPUTER. IBM-PS2.
001000 OBJECT-COMPUTER. IBM-PS2.
001100 FILE-CONTROL.
001200***  SELECT PRT-FILE  ASSIGN TO 'LPT1'
001300     SELECT PRT-FILE  ASSIGN TO "C:\TPS\APP\SEEPAMON.TXT"         00001000
001400         ORGANIZATION IS LINE SEQUENTIAL                          00001100
001500         FILE STATUS IS TPS-FILE-STATUS.
001600 DATA DIVISION.
001700 FILE SECTION.
001800 FD  PRT-FILE                                                     00001600
001900     LABEL RECORDS ARE OMITTED                                    00001700
002000     RECORD CONTAINS 200 CHARACTERS.                              00001800
002100 01  PRT-RECORD.
002118*       05  P-KEY                             PIC  X(50).
002119*       05  FILLER                            PIC  X(01).
002120*       05  P-KEY-OLDEST                      PIC  X(23).
002121*       05  FILLER                            PIC  X(01).
002122        05  P-ACCT-NO                         PIC  X(10).
002123        05  FILLER                            PIC  X(01).
002124        05  P-RECORD-TYPE                     PIC  X(02).
002125        05  FILLER                            PIC  X(01).
002126        05  P-RECUR-CHANGE-DATE               PIC  9(08).
002127        05  FILLER                            PIC  X(01).
002128        05  P-RECEIVE-DATE                    PIC  X(08).
002129        05  FILLER                            PIC  X(01).
002130        05  P-RECEIVE-NUMBER                  PIC  X(05).
002131        05  FILLER                            PIC  X(01).
002132        05  P-PAYEE-NAME                      PIC  X(36).
002133        05  FILLER                            PIC  X(01).
002134        05  P-PAYMENT-PAY-DATE                PIC  X(08).
002135        05  FILLER                            PIC  X(01).
002136        05  P-PAYMENT-DUE-DATE                PIC  X(08).
002137        05  FILLER                            PIC  X(01).
002138        05  P-PAYEE-ZIP-CODE                  PIC  X(09).
002139        05  FILLER                            PIC  X(01).
002140        05  P-PAYEE-AMOUNT                    PIC  $,$$$,$$$.99-.
002141        05  FILLER                            PIC  X(01).
002142        05  P-EXPIRE                          PIC  X(08).
002150*       05  FILLER                            PIC  X(01).
002200*       05  P-SUB-ACCT-NO                     PIC  X(01).
002300*       05  FILLER                            PIC  X(01).
002670        05  FILLER                            PIC  X(01).
004200
004210
004310
004400 WORKING-STORAGE SECTION.
004500     COPY "TPSFILES.CPY".
004600     COPY "KEYVALUE.CPY".
004700     COPY "PCLVALUE.CPY".
004800     COPY "PCL5VALU.CPY".
004900 01  TPS-PAMON-REC.
005000     COPY "TPSPAMON.CPY".
004900 01  sav-PAMON-REC                 pic x(650).
005100 01  TPSIO027                      PIC X(08) VALUE 'TPSIO027'.
005200 01  PROGRAM-NAMES.
005300  10 TPSIOERR    PIC X(08) VALUE 'TPSIOERR'.
005400  10 FILLER      PIC X(08) VALUE HIGH-VALUES.
005500 01  TPS-FILE-STATUS                       PIC XX.
005600     88  TPS-CARRIER-FILE-OK VALUE '00', '02'.
005700
005710*01  SKIP-IT                               PIC X(01) VALUE '1'.
005710 01  SKIP-IT                               PIC X(01) VALUE '0'.
005800
008000
005710 01  fix-pa-mon-flag                       PIC X(01) VALUE '0'.
005710*01  fix-pa-mon-flag                       PIC X(01) VALUE '1'.
005710*01  fix-pa-mon-flag                       PIC X(01) VALUE '2'.
005710     88  del-bad-cur-cntrl                           VALUE '1'.                                                   
005710     88  fix-bad-cntrl                               VALUE '2'.                                                   
008100
008200
008300
008400
008500 LINKAGE SECTION.
008600 01 TPS-PARAMETER.
008700    05 TPS-PARAMETER-VALUE PIC XX.
008800
008900 PROCEDURE DIVISION USING tps-parameter.
009000                                                                                                                  
009100 SEEPAMON-BEGIN.
009200    PERFORM OPEN-THE-FILES
009300       THRU OPEN-THE-FILES-EXIT.
009000                                                                                                                  
005710    if del-bad-cur-cntrl                                                                                          
009000       perform delete-bad-control thru                                                                            
009000               delete-bad-control-exit                                                                            
009000     end-if.                                                                                                      
009000                                                                                                                  
005710    if fix-bad-cntrl                                                                                                
009000       perform fix-bad-control thru                                                                                 
009000               fix-bad-control-exit                                                                                 
009600       go to seepamon-common-exit                                                                                   
009000     end-if.                                                                                                      
009000                                                                                                                  
009000                                                                                                                  
009400    PERFORM READ-THE-PAMON
009500       THRU READ-THE-PAMON-EXIT.
009000                                                                                                                  
009600 SEEPAMON-COMMON-EXIT.
009700    PERFORM CLOSE-THE-FILES
009800       THRU CLOSE-THE-FILES-EXIT.
009900    goback.                                                                                                       
010000
010100 READ-THE-PAMON.
010200    MOVE LOW-VALUES TO PAM-CLIENT-KEY.
010210    MOVE '0101000024'       TO PAM-ACCT-NO.
122841    MOVE 20130107           TO PAM-CNTRL-DATE.
010300    MOVE F-PRIME TO FILE-KEY.
010400    MOVE F-START TO FILE-ACTION.
010500    CALL TPSIO027 USING FILE-REQUEST TPS-PAMON-REC.
010600    IF NO-RECORD-WAS-FOUND GO TO READ-THE-PAMON-EXIT.
010700    IF NOT A-SUCCESSFUL-OPERATION
010800       MOVE ' PAMON' TO FILE-NAME
010900       MOVE 'SEEPAMON-SBR' TO FILE-TEXT
011000       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
011100       GO TO SEEPAMON-COMMON-EXIT.
011200
011300 READ-ALL-PAMON-RECORDS.
011400    MOVE F-PRIME TO FILE-KEY.
011500    MOVE F-READ-NEXT TO FILE-ACTION.
011600    CALL TPSIO027 USING FILE-REQUEST TPS-PAMON-REC.
011700    IF END-OF-FILE-WAS-REACHED GO TO READ-THE-PAMON-EXIT.
011800    IF NOT A-SUCCESSFUL-OPERATION
011900       MOVE ' PAMON' TO FILE-NAME
012000       MOVE 'SEEPAMON-BRN' TO FILE-TEXT
012100       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
012200       GO TO SEEPAMON-COMMON-EXIT.
012300
012301    IF PAM-ACCT-NO NOT = '0101000024'
012302       GO TO READ-THE-PAMON-EXIT
012303     END-IF.
012304
012305*   IF NOT PAM-RECORD-TYPE-BALANCE
012306*      GO TO READ-ALL-PAMON-RECORDS
012307*    END-IF.
012310
012311*   IF SKIP-IT = '1'
012312*      MOVE SPACES               TO PRT-RECORD
012313*
      *      MOVE PAM-CLIENT-KEY       TO P-KEY
012314*      MOVE PAM-OLDEST-BILL-KEY  TO P-KEY-OLDEST
012321*      WRITE PRT-RECORD
012322*      GO TO READ-ALL-PAMON-RECORDS
012323*    END-IF.
012324
012330
012400*     IF LOGREC-KEY = 'DAMFWIC   '
012500*        GO TO READ-ALL-PAMON-RECORDS
012600*       END-IF.
012610
012620*     IF NOT PAM-RECUR-ACTIVE
012630*        GO TO READ-ALL-PAMON-RECORDS
012640*       END-IF.
012700
012800      MOVE SPACES                TO PRT-RECORD.
012900
012917      MOVE PAM-ACCT-NO
012918        TO  P-ACCT-NO.
012919****  MOVE PAM-SUB-ACCT-NO
012921      MOVE PAM-RECORD-TYPE
012922        TO  P-RECORD-TYPE.
012923
012970
014200*     IF PAM-RECORD-CONTROL-RECORD-CUR
014300*     OR PAM-RECORD-CONTROL-RECORD-OLD
014400*     OR PAM-RECORD-TYPE-BALANCE
014500*     OR PAM-RECORD-TYPE-DEPOSIT
014600*     OR PAM-RECORD-TYPE-PAYMENT
014700*     OR PAM-NOFUND-MAIL-REC
014800*     OR PAM-NOFUND-CLNT-MAIL-REC
014900*     OR PAM-NOFUND-FAXS-REC
015000*     OR PAM-NOFUND-PHONE-CALLS
015100*     OR PAM-NOFUND-OVERNITE
015200*     OR PAM-NOFUND-PVT-CARRIER
015300*     OR PAM-NOFUND-COURIER
015400*     OR PAM-NOFUND-WALKIN
015410*     OR PAM-NOFUND-OTHER
015420*     OR PAM-NOFUND-DEPOSITS-CONFIRM
015430*     OR PAM-NOFUND-INVITES
015440*     OR PAM-NOFUND-CLNT-MEMO
015470*     OR PAM-NOFUND-CORRESPONDENCE
015480*     OR PAM-NOFUND-FAX-DIARY
015490*     OR PAM-NOFUND-PAYMENT-CAL
015491*     OR PAM-NOFUND-PERSONAL-CAL
015492*     OR PAM-NOFUND-CHECK-RECONCIL
015493*     OR PAM-NOFUND-CHECK-SUMMARY
015494*     OR PAM-NOFUND-ROLODEX-POCKET
015495*     OR PAM-NOFUND-ROLODEX-PERSONAL
015496*     OR PAM-NOFUND-ROLODEX-CARDS
015497*     OR PAM-NOFUND-ROLODEX-PRO-SVC
015498*     OR PAM-NOFUND-SUMMARY-ACCTS
015499*     OR PAM-NOFUND-ADMIN-MEMO
      *        MOVE PAM-CLIENT-KEY       TO P-KEY
015500*        GO TO PRINT-IT
      *       else
015700*        GO TO READ-ALL-PAMON-RECORDS
015600*      END-IF.
015647
015648      MOVE PAM-RECUR-CHANGE-DATE
015649        TO  P-RECUR-CHANGE-DATE.
015650
015663
015664      MOVE PAM-PAYMENT-PAY-DATE
015665        TO  P-PAYMENT-PAY-DATE.
015667      MOVE PAM-PAYMENT-DUE-DATE
015668        TO  P-PAYMENT-DUE-DATE.
015669      MOVE PAM-PAYEE-ZIP-CODE
015670        TO  P-PAYEE-ZIP-CODE.
015671      MOVE PAM-RECEIVE-DATE
015672        TO  P-RECEIVE-DATE.
015673      MOVE PAM-RECEIVE-NO
015674        TO  P-RECEIVE-NUMBER.
015675
015676      MOVE PAM-PAYEE-NAME
015677        TO  P-PAYEE-NAME.
015678
015679      IF PAM-EXPIRED-RECORD
015680         MOVE PAM-EXPIRE-DATE TO P-EXPIRE
015681        ELSE
015682         MOVE SPACES          TO P-EXPIRE
015683       END-IF.
015684
015685      MOVE PAM-PAYMENT-AMOUNT
015686        TO  P-PAYEE-AMOUNT.
015687
015688
015689 PRINT-IT.
015690       WRITE PRT-RECORD.
015700       GO TO READ-ALL-PAMON-RECORDS.
015800 READ-THE-PAMON-EXIT. EXIT.
015900
016000
016100 FILE-ERROR.
016200     CALL TPSIOERR USING FILE-REQUEST.
016300     CANCEL TPSIOERR.
016400 FILE-ERROR-EXIT. EXIT.
016500
016600
016700 OPEN-THE-FILES.
016800    OPEN OUTPUT PRT-FILE.
016900    MOVE F-PRIME    TO FILE-KEY.
017000    MOVE F-OPEN-I-O   TO FILE-ACTION.
017100    CALL TPSIO027 USING FILE-REQUEST TPS-PAMON-REC.
017200    IF FILE-STATUS NOT = '00' AND '05'
017300       MOVE 'PAMON ' TO FILE-NAME
017400       MOVE 'SEEPAMON-ORC' TO FILE-TEXT
017500       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
017600       GO TO SEEPAMON-COMMON-EXIT.
019400 OPEN-THE-FILES-EXIT. EXIT.
019500
019600 CLOSE-THE-FILES.
019900    CLOSE PRT-FILE.
020000      MOVE F-PRIME TO FILE-KEY.
020100      MOVE F-CLOSE TO FILE-ACTION.
020200      CALL TPSIO027 USING FILE-REQUEST TPS-PAMON-REC.
020300      IF NOT A-SUCCESSFUL-OPERATION
020400         MOVE 'PAMON ' TO FILE-NAME
020500         MOVE 'SEEPAMON-CCK' TO FILE-TEXT
020600         PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
020700      END-IF.
020800
020900 CLOSE-THE-FILES-EXIT. EXIT.
020800
020800
020800
020800
009000 delete-bad-control.                                                                                              
010200    MOVE LOW-VALUES TO PAM-CLIENT-KEY.
010300    MOVE F-PRIME TO FILE-KEY.
010400    MOVE F-START TO FILE-ACTION.
010500    CALL TPSIO027 USING FILE-REQUEST TPS-PAMON-REC.
010600    IF NO-RECORD-WAS-FOUND GO TO READ-THE-PAMON-EXIT.
010700    IF NOT A-SUCCESSFUL-OPERATION
010800       MOVE ' PAMON' TO FILE-NAME
010900       MOVE 'SEEPAMON-SBR' TO FILE-TEXT
011000       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
011100       GO TO SEEPAMON-COMMON-EXIT.
011200
011300 READ-for-delete.                 
011400    MOVE F-PRIME TO FILE-KEY.
011500    MOVE F-READ-NEXT TO FILE-ACTION.
011600    CALL TPSIO027 USING FILE-REQUEST TPS-PAMON-REC.
011700    IF END-OF-FILE-WAS-REACHED                                                                                    
009000       go to delete-bad-control-exit                                                                              
011200     end-if.                                                                                                      
011200                                                                                                                  
011800    IF NOT A-SUCCESSFUL-OPERATION
011900       MOVE ' PAMON' TO FILE-NAME
012000       MOVE 'SEEPAMON-BRN' TO FILE-TEXT
012100       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
012200       GO TO SEEPAMON-COMMON-EXIT.
012300
014200    IF not PAM-RECORD-CONTROL-RECORD-CUR                                                                          
011300       go to READ-for-delete                                                                                      
011200     end-if.                                                                                                      
011200                                                                                                                  
014200    if pam-cntrl-date = zeros                                                                                     
011200       continue                                                                                                   
            else                                                                                                        
014200    if pam-cntrl-date not numeric                                                                                 
011200       continue                                                                                                   
            else                                                                                                        
011300       go to read-for-delete                                                                                      
011200      end-if                                                                                                      
011200     end-if.                                                                                                      
011200                                                                                                                  
011400    MOVE F-PRIME TO FILE-KEY.
011500    MOVE F-delet TO FILE-ACTION.
011600    CALL TPSIO027 USING FILE-REQUEST TPS-PAMON-REC.
011800    IF NOT A-SUCCESSFUL-OPERATION
011900       MOVE ' PAMON' TO FILE-NAME
012000       MOVE 'SEEPAMON-del' TO FILE-TEXT
012100       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
012200       GO TO SEEPAMON-COMMON-EXIT.
020800
009000 delete-bad-control-exit. exit.                                                                                   
021000
021000
009000 fix-bad-control.                                                                                                   
010200    move low-values to pam-client-key.
010300    move f-prime to file-key.
010400    move f-start to file-action.
010500    call tpsio027 using file-request tps-pamon-rec.
010700    if not a-successful-operation
010800       move ' pamon' to file-name
010900       move 'seepamon-stx' to file-text
011000       perform file-error thru file-error-exit
011100       go to seepamon-common-exit.
012200                                                                                                                    
012200 read-next-for-fix.                                                                                                 
011400    move f-prime to file-key.
011500    move f-read-next to file-action.
011600    call tpsio027 using file-request tps-pamon-rec.
011800    if not a-successful-operation
011900       move ' pamon' to file-name
012000       move 'seepamon-rnx' to file-text
012100       perform file-error thru file-error-exit
012200       go to seepamon-common-exit.
012300
014200    if not pam-record-control-record-cur                                                                          
012200       go to read-next-for-fix     
011200     end-if.                                                                                                      
011200                                                                                                                  
014200    if pam-cntrl-date not numeric                                                                                 
011200       continue                                                                                                   
            else                                                                                                        
011900       move ' pamon' to file-name
012000       move 'seepamon-gdr' to file-text
012100       perform file-error thru file-error-exit
012200       go to seepamon-common-exit 
011200     end-if.                                                                                                      
011200                                                                                                                  
004900    move tps-pamon-rec            to sav-pamon-rec.                                                                 
011200                                                                                                                  
011400    move f-prime to file-key.
011500    move f-delet to file-action.
011600    call tpsio027 using file-request tps-pamon-rec.
011800    if not a-successful-operation
011900       move ' pamon' to file-name
012000       move 'seepamon-del' to file-text
012100       perform file-error thru file-error-exit
012200       go to seepamon-common-exit.
020800
004900    move sav-pamon-rec            to tps-pamon-rec.                                                                 
014200    move '20040826'               to pam-cntrl-date.                                                                
011400    move f-prime to file-key.
011500    move f-write  to file-action.                                                                                   
011600    call tpsio027 using file-request tps-pamon-rec.
011800    if not a-successful-operation
011900       move ' pamon' to file-name
012000       move 'seepamon-wrx' to file-text
012100       perform file-error thru file-error-exit
012200       go to seepamon-common-exit.
012300
009000 fix-bad-control-exit. exit.                                                                                        
021000
021000
